"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const cdk = require("aws-cdk-lib");
const index_1 = require("./index");
// eslint-disable-next-line import/order
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'MyStack');
const lambdaFunctionProps = {
    runtime: aws_lambda_1.Runtime.PYTHON_3_9,
    handler: 'index.handler',
    code: aws_lambda_1.Code.fromAsset(path_1.join(__dirname, 'lambda-handler')),
};
const apiGatewayToSqsToLambdaProps = {
    serviceName: 'sqs-pusher',
    domain: 'example.com',
    domainCertArn: 'arn:aws:acm:eu-central-1:1234567852354:certificate/123123sdf-dsf-sdfs-sdsad-sadsdasdasd',
    route53HostedZoneId: 'Z0633005JYFGNZXCT3BN',
    lambdaFunctionProps: lambdaFunctionProps,
    deployDeadLetterQueue: true,
};
new index_1.ApiGatewayToSqsToLambda(stack, 'ApiGateway-Sqs-Lambda', apiGatewayToSqsToLambdaProps);
//# sourceMappingURL=data:application/json;base64,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