"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayToSqsToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const aws_certificatemanager_1 = require("aws-cdk-lib/aws-certificatemanager");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_lambda_event_sources_1 = require("aws-cdk-lib/aws-lambda-event-sources");
const aws_route53_1 = require("aws-cdk-lib/aws-route53");
const aws_route53_targets_1 = require("aws-cdk-lib/aws-route53-targets");
const constructs_1 = require("constructs");
/**
 * @summary The ApiGatewayToSqsToLambda class. Class is very opinionated and does not allow for existing queues or lambdas.
 * Class assumes a pulic domain should be created and the corresponding alias in route53 shall be created
 */
class ApiGatewayToSqsToLambda extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the ApiGatewayToSqsToLambda class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {ApiGatewayToSqsToLambdaProps} props - user provided props for the construct.
     */
    constructor(scope, id, props) {
        super(scope, id);
        const { serviceName, domain, domainCertArn, route53HostedZoneId, deployDeadLetterQueue, lambdaFunctionProps, } = props;
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            deployDeadLetterQueue: deployDeadLetterQueue,
        });
        const lambdaTimeout = lambdaFunctionProps.timeout
            ? lambdaFunctionProps.timeout
            : aws_cdk_lib_1.Duration.seconds(30);
        // Setup the queue
        [this.sqsQueue] = defaults.buildQueue(this, `${serviceName}-queue`, {
            deadLetterQueue: this.deadLetterQueue,
            queueProps: {
                queueName: `${serviceName}-queue`,
                visibilityTimeout: lambdaTimeout > aws_cdk_lib_1.Duration.seconds(30)
                    ? lambdaTimeout
                    : aws_cdk_lib_1.Duration.seconds(30),
            },
        });
        const certificate = aws_certificatemanager_1.Certificate.fromCertificateArn(this, `*.${domain}`, domainCertArn);
        const apiGatewayProps = {
            domainName: {
                domainName: `${serviceName}.${domain}`,
                certificate: certificate,
            },
            restApiName: serviceName,
        };
        // Setup API Gateway
        this.apiGateway = new aws_apigateway_1.RestApi(this, `${serviceName}-api-gateway`, apiGatewayProps);
        this.apiGatewayRole = new aws_iam_1.Role(this, `${serviceName}-api-gateway-role`, {
            assumedBy: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
        });
        this.apiGatewayRole.addToPolicy(new aws_iam_1.PolicyStatement({
            resources: [this.sqsQueue.queueArn],
            actions: ['sqs:SendMessage'],
        }));
        core_1.addProxyMethodToApiResource({
            service: 'sqs',
            path: `${aws_cdk_lib_1.Aws.ACCOUNT_ID}/${this.sqsQueue.queueName}`,
            apiGatewayRole: this.apiGatewayRole,
            apiMethod: 'POST',
            apiResource: this.apiGateway.root,
            requestTemplate: 'Action=SendMessage&MessageBody=$util.urlEncode("$input.body")',
            contentType: "'application/x-www-form-urlencoded'",
            methodOptions: {
                authorizationType: aws_apigateway_1.AuthorizationType.NONE,
            },
        });
        // infering throws error, which is why we have to provide both
        const hostedZone = aws_route53_1.HostedZone.fromHostedZoneAttributes(this, `${domain}-zone`, {
            hostedZoneId: route53HostedZoneId,
            zoneName: domain,
        });
        new aws_route53_1.ARecord(this, `${serviceName}-alias-record`, {
            zone: hostedZone,
            recordName: serviceName,
            target: aws_route53_1.RecordTarget.fromAlias(new aws_route53_targets_1.ApiGateway(this.apiGateway)),
        });
        this.lambdaFunction = new aws_lambda_1.Function(this, `${serviceName}-lambda`, lambdaFunctionProps);
        this.lambdaFunction.addEventSource(new aws_lambda_event_sources_1.SqsEventSource(this.sqsQueue));
    }
}
exports.ApiGatewayToSqsToLambda = ApiGatewayToSqsToLambda;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayToSqsToLambda[_a] = { fqn: "apigateway-sqs-lambda.ApiGatewayToSqsToLambda", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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