import { RestApi } from 'aws-cdk-lib/aws-apigateway';
import { Role } from 'aws-cdk-lib/aws-iam';
import { Function as LamdaFunction, FunctionProps as LamdaFunctionProps } from 'aws-cdk-lib/aws-lambda';
import { Queue, DeadLetterQueue } from 'aws-cdk-lib/aws-sqs';
import { Construct } from 'constructs';
/**
 * @summary The properties for the ApiGatewayToSqsToLambdaProps class.
 */
export interface ApiGatewayToSqsToLambdaProps {
    readonly serviceName: string;
    readonly domain: string;
    readonly domainCertArn: string;
    readonly route53HostedZoneId: string;
    readonly lambdaFunctionProps: LamdaFunctionProps;
    readonly deployDeadLetterQueue?: boolean;
}
/**
 * @summary The ApiGatewayToSqsToLambda class. Class is very opinionated and does not allow for existing queues or lambdas.
 * Class assumes a pulic domain should be created and the corresponding alias in route53 shall be created
 */
export declare class ApiGatewayToSqsToLambda extends Construct {
    readonly apiGateway: RestApi;
    readonly apiGatewayRole: Role;
    readonly apiGatewayCloudWatchRole?: Role;
    readonly sqsQueue: Queue;
    readonly deadLetterQueue?: DeadLetterQueue;
    readonly lambdaFunction: LamdaFunction;
    /**
     * @summary Constructs a new instance of the ApiGatewayToSqsToLambda class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {ApiGatewayToSqsToLambdaProps} props - user provided props for the construct.
     */
    constructor(scope: Construct, id: string, props: ApiGatewayToSqsToLambdaProps);
}
