"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyEcsConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// ~~ Generated by projen. To modify, edit .projenrc.js and run "npx projen".
const path = require("path");
const ec2 = require("aws-cdk-lib/aws-ec2");
const ecs = require("aws-cdk-lib/aws-ecs");
const ecs_patterns = require("aws-cdk-lib/aws-ecs-patterns");
const constructs_1 = require("constructs");
class MyEcsConstruct extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const vpc = new ec2.Vpc(this, 'MyVpc', {
            maxAzs: props.maxAzs,
        });
        const cluster = new ecs.Cluster(this, 'MyCluster', {
            vpc: vpc,
        });
        new ecs_patterns.ApplicationLoadBalancedFargateService(this, 'MyFargateService', {
            cluster: cluster,
            desiredCount: props.desiredCount,
            cpu: props.cpu,
            memoryLimitMiB: props.memoryLimitMiB,
            taskImageOptions: {
                image: ecs.ContainerImage.fromAsset(path.resolve(__dirname, props.dockerDirAsset), {
                    file: props.dockerFileAsset,
                }),
            },
            publicLoadBalancer: true,
        });
    }
}
exports.MyEcsConstruct = MyEcsConstruct;
_a = JSII_RTTI_SYMBOL_1;
MyEcsConstruct[_a] = { fqn: "fastfargate.MyEcsConstruct", version: "0.0.23" };
//# sourceMappingURL=data:application/json;base64,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