/*!
 * numbro.js
 * version : 1.6.2
 * author : Företagsplatsen AB
 * license : MIT
 * http://www.foretagsplatsen.se
 */
/************************************
        Constructors
    ************************************/
// Numbro prototype object
function Numbro(a){this._value=a}function zeroes(a){var b,c="";for(b=0;a>b;b++)c+="0";return c}/**
     * Implementation of toFixed() for numbers with exponent > 21
     *
     *
     */
function toFixedLarge(a,b){var c,d,e,f,g;return g=a.toString(),c=g.split("e")[0],f=g.split("e")[1],d=c.split(".")[0],e=c.split(".")[1]||"",g=d+e+zeroes(f-e.length),b>0&&(g+="."+zeroes(b)),g}/**
     * Implementation of toFixed() that treats floats more like decimals
     *
     * Fixes binary rounding issues (eg. (0.615).toFixed(2) === '0.61') that present
     * problems for accounting- and finance-related software.
     */
function toFixed(a,b,c,d){var e,f,g=Math.pow(10,b);
// Above 1e21, toFixed returns scientific notation, which
// is useless and unexpected
return f=a.toFixed(0).search("e")>-1?toFixedLarge(a,b):(c(a*g)/g).toFixed(b),d&&(e=new RegExp("0{1,"+d+"}$"),f=f.replace(e,"")),f}/************************************
        Formatting
    ************************************/
// determine what type of formatting we need to do
function formatNumbro(a,b,c){var d;
// return string
// TODO: do something with `language`
// figure out what kind of format we are dealing with
// currency!!!!!
return d=b.indexOf("$")>-1?formatCurrency(a,b,c):b.indexOf("%")>-1?formatPercentage(a,b,c):b.indexOf(":")>-1?formatTime(a):formatNumber(a,b,c)}function formatCurrency(a,b,c){var d,e,f=b,g=f.indexOf("$"),h=f.indexOf("("),i=f.indexOf("+"),j=f.indexOf("-"),k="",l="";if(-1===f.indexOf("$")?
// Use defaults instead of the format provided
"infix"===cultures[currentCulture].currency.position?(l=cultures[currentCulture].currency.symbol,cultures[currentCulture].currency.spaceSeparated&&(l=" "+l+" ")):cultures[currentCulture].currency.spaceSeparated&&(k=" "):f.indexOf(" $")>-1?(k=" ",f=f.replace(" $","")):f.indexOf("$ ")>-1?(k=" ",f=f.replace("$ ","")):f=f.replace("$",""),e=formatNumber(a,f,c,l),-1===b.indexOf("$"))
// Use defaults instead of the format provided
switch(cultures[currentCulture].currency.position){case"postfix":e.indexOf(")")>-1?(e=e.split(""),e.splice(-1,0,k+cultures[currentCulture].currency.symbol),e=e.join("")):e=e+k+cultures[currentCulture].currency.symbol;break;case"infix":break;case"prefix":e.indexOf("(")>-1||e.indexOf("-")>-1?(e=e.split(""),d=Math.max(h,j)+1,e.splice(d,0,cultures[currentCulture].currency.symbol+k),e=e.join("")):e=cultures[currentCulture].currency.symbol+k+e;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else
// position the symbol
1>=g?e.indexOf("(")>-1||e.indexOf("+")>-1||e.indexOf("-")>-1?(e=e.split(""),d=1,(h>g||i>g||j>g)&&(d=0),e.splice(d,0,cultures[currentCulture].currency.symbol+k),e=e.join("")):e=cultures[currentCulture].currency.symbol+k+e:e.indexOf(")")>-1?(e=e.split(""),e.splice(-1,0,k+cultures[currentCulture].currency.symbol),e=e.join("")):e=e+k+cultures[currentCulture].currency.symbol;return e}function formatPercentage(a,b,c){var d,e="";
// check for space before %
return a=100*a,b.indexOf(" %")>-1?(e=" ",b=b.replace(" %","")):b=b.replace("%",""),d=formatNumber(a,b,c),d.indexOf(")")>-1?(d=d.split(""),d.splice(-1,0,e+"%"),d=d.join("")):d=d+e+"%",d}function formatTime(a){var b=Math.floor(a/60/60),c=Math.floor((a-60*b*60)/60),d=Math.round(a-60*b*60-60*c);return b+":"+(10>c?"0"+c:c)+":"+(10>d?"0"+d:d)}function formatNumber(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w=!1,x=!1,y=!1,z="",A=!1,// force abbreviation to thousands
B=!1,// force abbreviation to millions
C=!1,// force abbreviation to billions
D=!1,// force abbreviation to trillions
E=!1,// force abbreviation
F="",G="",H=Math.abs(a),I=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],J=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],K="",L=!1,M=!1,N="";
// check if number is zero and a custom zero format has been set
if(0===a&&null!==zeroFormat)return zeroFormat;if(!isFinite(a))return""+a;if(0===b.indexOf("{")){var O=b.indexOf("}");if(-1===O)throw Error('Format should also contain a "}"');p=b.slice(1,O),b=b.slice(O+1)}else p="";if(b.indexOf("}")===b.length-1){var P=b.indexOf("{");if(-1===P)throw Error('Format should also contain a "{"');q=b.slice(P+1,-1),b=b.slice(0,P+1)}else q="";
// check for min length
var Q;
// see if abbreviation is wanted
if(Q=-1===b.indexOf(".")?b.match(/([0-9]+).*/):b.match(/([0-9]+)\..*/),v=null===Q?-1:Q[1].length,-1!==b.indexOf("-")&&(L=!0),b.indexOf("(")>-1?(w=!0,b=b.slice(1,-1)):b.indexOf("+")>-1&&(x=!0,b=b.replace(/\+/g,"")),b.indexOf("a")>-1){if(n=b.split(".")[0].match(/[0-9]+/g)||["0"],n=parseInt(n[0],10),A=b.indexOf("aK")>=0,B=b.indexOf("aM")>=0,C=b.indexOf("aB")>=0,D=b.indexOf("aT")>=0,E=A||B||C||D,b.indexOf(" a")>-1?(z=" ",b=b.replace(" a","")):b=b.replace("a",""),i=Math.floor(Math.log(H)/Math.LN10)+1,k=i%3,k=0===k?3:k,n&&0!==H&&(j=Math.floor(Math.log(H)/Math.LN10)+1-n,l=3*~~((Math.min(n,i)-k)/3),H/=Math.pow(10,l),-1===b.indexOf(".")&&n>3))for(b+="[.]",t=0===j?0:3*~~(j/3)-j,t=0>t?t+3:t,e=0;t>e;e++)b+="0";Math.floor(Math.log(Math.abs(a))/Math.LN10)+1!==n&&(H>=Math.pow(10,12)&&!E||D?(z+=cultures[currentCulture].abbreviations.trillion,a/=Math.pow(10,12)):H<Math.pow(10,12)&&H>=Math.pow(10,9)&&!E||C?(z+=cultures[currentCulture].abbreviations.billion,a/=Math.pow(10,9)):H<Math.pow(10,9)&&H>=Math.pow(10,6)&&!E||B?(z+=cultures[currentCulture].abbreviations.million,a/=Math.pow(10,6)):(H<Math.pow(10,6)&&H>=Math.pow(10,3)&&!E||A)&&(z+=cultures[currentCulture].abbreviations.thousand,a/=Math.pow(10,3)))}
// see if we are formatting binary bytes
if(b.indexOf("b")>-1)for(
// check for space before
b.indexOf(" b")>-1?(F=" ",b=b.replace(" b","")):b=b.replace("b",""),h=0;h<=I.length;h++)if(f=Math.pow(1024,h),g=Math.pow(1024,h+1),a>=f&&g>a){F+=I[h],f>0&&(a/=f);break}
// see if we are formatting decimal bytes
if(b.indexOf("d")>-1)for(
// check for space before
b.indexOf(" d")>-1?(F=" ",b=b.replace(" d","")):b=b.replace("d",""),h=0;h<=J.length;h++)if(f=Math.pow(1e3,h),g=Math.pow(1e3,h+1),a>=f&&g>a){F+=J[h],f>0&&(a/=f);break}if(
// see if ordinal is wanted
b.indexOf("o")>-1&&(
// check for space before
b.indexOf(" o")>-1?(G=" ",b=b.replace(" o","")):b=b.replace("o",""),cultures[currentCulture].ordinal&&(G+=cultures[currentCulture].ordinal(a))),b.indexOf("[.]")>-1&&(y=!0,b=b.replace("[.]",".")),m=a.toString().split(".")[0],o=b.split(".")[1],r=b.indexOf(","),o){if(-1!==o.indexOf("*")?K=toFixed(a,a.toString().split(".")[1].length,c):o.indexOf("[")>-1?(o=o.replace("]",""),o=o.split("["),K=toFixed(a,o[0].length+o[1].length,c,o[1].length)):K=toFixed(a,o.length,c),m=K.split(".")[0],K.split(".")[1].length){var R=d?z+d:cultures[currentCulture].delimiters.decimal;K=R+K.split(".")[1]}else K="";y&&0===Number(K.slice(1))&&(K="")}else m=toFixed(a,null,c);
// format number
return m.indexOf("-")>-1&&(m=m.slice(1),M=!0),m.length<v&&(m=new Array(v-m.length+1).join("0")+m),r>-1&&(m=m.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+cultures[currentCulture].delimiters.thousands)),0===b.indexOf(".")&&(m=""),s=b.indexOf("("),u=b.indexOf("-"),N=u>s?(w&&M?"(":"")+(L&&M||!w&&M?"-":""):(L&&M||!w&&M?"-":"")+(w&&M?"(":""),p+N+(!M&&x&&0!==a?"+":"")+m+K+(G?G:"")+(z&&!d?z:"")+(F?F:"")+(w&&M?")":"")+q}/************************************
        Helpers
    ************************************/
function setCulture(a,b){cultures[a]=b}function chooseCulture(a){currentCulture=a;var b=cultures[a].defaults;b&&b.format&&numbro.defaultFormat(b.format),b&&b.currencyFormat&&numbro.defaultCurrencyFormat(b.currencyFormat)}function format(a,b,c,d){return _.isString(c)&&c!==numbro.culture()&&numbro.setCulture(c),formatNumbro(Number(a),_.isString(b)?b:defaultFormat,_.isUndefined(d)?Math.round:d)}var _=require("underscore"),numbro,VERSION="1.6.2",
// internal storage for culture config files
cultures={},
// Todo: Remove in 2.0.0
languages=cultures,currentCulture="en-US",zeroFormat=null,defaultFormat="0,0",defaultCurrencyFormat="0$",
// check for nodeJS
hasModule="undefined"!=typeof module&&module.exports,
// default culture
enUS={delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(a){var b=a%10;return 1===~~(a%100/10)?"th":1===b?"st":2===b?"nd":3===b?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}};numbro=function(a){return numbro.isNumbro(a)?a=a.value():0===a||"undefined"==typeof a?a=0:Number(a)||(a=numbro.fn.unformat(a)),new Numbro(Number(a))},numbro.version=VERSION,numbro.isNumbro=function(a){return a instanceof Numbro},numbro.setLanguage=function(a,b){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var c=a,d=a.split("-")[0],e=null;languages[c]||(Object.keys(languages).forEach(function(a){e||a.split("-")[0]!==d||(e=a)}),c=e||b||"en-US"),chooseCulture(c)},numbro.setCulture=function(a,b){var c=a,d=a.split("-")[1],e=null;cultures[c]||(d&&Object.keys(cultures).forEach(function(a){e||a.split("-")[1]!==d||(e=a)}),c=e||b||"en-US"),chooseCulture(c)},numbro.language=function(a,b){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!a)return currentCulture;if(a&&!b){if(!languages[a])throw new Error("Unknown language : "+a);chooseCulture(a)}return(b||!languages[a])&&setCulture(a,b),numbro},numbro.culture=function(a,b){if(!a)return currentCulture;if(a&&!b){if(!cultures[a])throw new Error("Unknown culture : "+a);chooseCulture(a)}return(b||!cultures[a])&&setCulture(a,b),numbro},numbro.languageData=function(a){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!a)return languages[currentCulture];if(!languages[a])throw new Error("Unknown language : "+a);return languages[a]},numbro.cultureData=function(a){if(!a)return cultures[currentCulture];if(!cultures[a])throw new Error("Unknown culture : "+a);return cultures[a]},numbro.culture("en-US",enUS),numbro.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),languages},numbro.cultures=function(){return cultures},numbro.zeroFormat=function(a){zeroFormat="string"==typeof a?a:null},numbro.defaultFormat=function(a){defaultFormat="string"==typeof a?a:"0.0"},numbro.defaultCurrencyFormat=function(a){defaultCurrencyFormat="string"==typeof a?a:"0$"},numbro.validate=function(a,b){var c,d,e,f,g,h,i,j;if("string"!=typeof a&&(a+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",a)),a=a.trim(),a.match(/^\d+$/))return!0;if(""===a)return!1;try{i=numbro.cultureData(b)}catch(k){i=numbro.cultureData(numbro.culture())}return e=i.currency.symbol,g=i.abbreviations,c=i.delimiters.decimal,d="."===i.delimiters.thousands?"\\.":i.delimiters.thousands,j=a.match(/^[^\d]+/),null!==j&&(a=a.substr(1),j[0]!==e)?!1:(j=a.match(/[^\d]+$/),null!==j&&(a=a.slice(0,-1),j[0]!==g.thousand&&j[0]!==g.million&&j[0]!==g.billion&&j[0]!==g.trillion)?!1:(h=new RegExp(d+"{2}"),a.match(/[^\d.,]/g)?!1:(f=a.split(c),f.length>2?!1:f.length<2?!!f[0].match(/^\d+.*\d$/)&&!f[0].match(h):1===f[0].length?!!f[0].match(/^\d+$/)&&!f[0].match(h)&&!!f[1].match(/^\d+$/):!!f[0].match(/^\d+.*\d$/)&&!f[0].match(h)&&!!f[1].match(/^\d+$/))))},module.exports={format:format};