/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  const bokeh = factory();
  if (root.Bokeh === undefined) {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
    if (aliases === undefined) aliases = {};
    if (externals === undefined) externals = {};

    var cache = {};

    var normalize = function(name) {
      if (typeof name === "number")
        return name;

      if (name === "bokehjs")
        return entry;

      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)

      var alias = aliases[name]
      if (alias != null)
        return alias;

      var trailing = name.length > 0 && name[name.lenght-1] === "/";
      var index = aliases[name + (trailing ? "" : "/") + "index"];
      if (index != null)
        return index;

      return name;
    }

    var require = function(name) {
      var mod = cache[name];
      if (!mod) {
        var id = normalize(name);

        mod = cache[id];
        if (!mod) {
          if (!modules[id]) {
            if (externals[id] === false || (externals[id] == true && parent_require)) {
              try {
                mod = {exports: externals[id] ? parent_require(id) : {}};
                cache[id] = cache[name] = mod;
                return mod.exports;
              } catch (e) {}
            }

            var err = new Error("Cannot find module '" + name + "'");
            err.code = 'MODULE_NOT_FOUND';
            throw err;
          }

          mod = {exports: {}};
          cache[id] = cache[name] = mod;
          modules[id].call(mod.exports, require, mod, mod.exports);
        } else
          cache[name] = mod;
      }

      return mod.exports;
    }

    var main = require(entry);
    main.require = require;

    if (typeof Proxy !== "undefined") {
      // allow Bokeh.loader["@bokehjs/module/name"] syntax
      main.loader = new Proxy({}, {
        get: function(_obj, module) {
          return require(module);
        }
      });
    }

    main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
      if (plugin_aliases === undefined) plugin_aliases = {};
      if (plugin_externals === undefined) plugin_externals = {};

      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      for (var name in plugin_externals) {
        externals[name] = plugin_externals[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0}),e(1).__exportStar(e(2),_)},
function _(t,e,n){
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0
    
    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.
    
    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
Object.defineProperty(n,"__esModule",{value:!0});var r=function(t,e){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])})(t,e)};function o(t){var e="function"==typeof Symbol&&Symbol.iterator,n=e&&t[e],r=0;if(n)return n.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&r>=t.length&&(t=void 0),{value:t&&t[r++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function a(t,e){var n="function"==typeof Symbol&&t[Symbol.iterator];if(!n)return t;var r,o,a=n.call(t),i=[];try{for(;(void 0===e||e-- >0)&&!(r=a.next()).done;)i.push(r.value)}catch(t){o={error:t}}finally{try{r&&!r.done&&(n=a.return)&&n.call(a)}finally{if(o)throw o.error}}return i}function i(t){return this instanceof i?(this.v=t,this):new i(t)}n.__extends=function(t,e){function n(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)},n.__assign=function(){return n.__assign=Object.assign||function(t){for(var e,n=1,r=arguments.length;n<r;n++)for(var o in e=arguments[n])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},n.__assign.apply(this,arguments)},n.__rest=function(t,e){var n={};for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.indexOf(r)<0&&(n[r]=t[r]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(r=Object.getOwnPropertySymbols(t);o<r.length;o++)e.indexOf(r[o])<0&&Object.prototype.propertyIsEnumerable.call(t,r[o])&&(n[r[o]]=t[r[o]])}return n},n.__decorate=function(t,e,n,r){var o,a=arguments.length,i=a<3?e:null===r?r=Object.getOwnPropertyDescriptor(e,n):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,n,r);else for(var u=t.length-1;u>=0;u--)(o=t[u])&&(i=(a<3?o(i):a>3?o(e,n,i):o(e,n))||i);return a>3&&i&&Object.defineProperty(e,n,i),i},n.__param=function(t,e){return function(n,r){e(n,r,t)}},n.__metadata=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},n.__awaiter=function(t,e,n,r){return new(n||(n=Promise))((function(o,a){function i(t){try{c(r.next(t))}catch(t){a(t)}}function u(t){try{c(r.throw(t))}catch(t){a(t)}}function c(t){var e;t.done?o(t.value):(e=t.value,e instanceof n?e:new n((function(t){t(e)}))).then(i,u)}c((r=r.apply(t,e||[])).next())}))},n.__generator=function(t,e){var n,r,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:u(0),throw:u(1),return:u(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function u(a){return function(u){return function(a){if(n)throw new TypeError("Generator is already executing.");for(;i;)try{if(n=1,r&&(o=2&a[0]?r.return:a[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,a[1])).done)return o;switch(r=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return i.label++,{value:a[1],done:!1};case 5:i.label++,r=a[1],a=[0];continue;case 7:a=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==a[0]&&2!==a[0])){i=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){i.label=a[1];break}if(6===a[0]&&i.label<o[1]){i.label=o[1],o=a;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(a);break}o[2]&&i.ops.pop(),i.trys.pop();continue}a=e.call(t,i)}catch(t){a=[6,t],r=0}finally{n=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,u])}}},n.__exportStar=function(t,e){for(var n in t)e.hasOwnProperty(n)||(e[n]=t[n])},n.__values=o,n.__read=a,n.__spread=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(a(arguments[e]));return t},n.__spreadArrays=function(){for(var t=0,e=0,n=arguments.length;e<n;e++)t+=arguments[e].length;var r=Array(t),o=0;for(e=0;e<n;e++)for(var a=arguments[e],i=0,u=a.length;i<u;i++,o++)r[o]=a[i];return r},n.__await=i,n.__asyncGenerator=function(t,e,n){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var r,o=n.apply(t,e||[]),a=[];return r={},u("next"),u("throw"),u("return"),r[Symbol.asyncIterator]=function(){return this},r;function u(t){o[t]&&(r[t]=function(e){return new Promise((function(n,r){a.push([t,e,n,r])>1||c(t,e)}))})}function c(t,e){try{(n=o[t](e)).value instanceof i?Promise.resolve(n.value.v).then(f,l):s(a[0][2],n)}catch(t){s(a[0][3],t)}var n}function f(t){c("next",t)}function l(t){c("throw",t)}function s(t,e){t(e),a.shift(),a.length&&c(a[0][0],a[0][1])}},n.__asyncDelegator=function(t){var e,n;return e={},r("next"),r("throw",(function(t){throw t})),r("return"),e[Symbol.iterator]=function(){return this},e;function r(r,o){e[r]=t[r]?function(e){return(n=!n)?{value:i(t[r](e)),done:"return"===r}:o?o(e):e}:o}},n.__asyncValues=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,n=t[Symbol.asyncIterator];return n?n.call(t):(t=o(t),e={},r("next"),r("throw"),r("return"),e[Symbol.asyncIterator]=function(){return this},e);function r(n){e[n]=t[n]&&function(e){return new Promise((function(r,o){(function(t,e,n,r){Promise.resolve(r).then((function(e){t({value:e,done:n})}),e)})(r,o,(e=t[n](e)).done,e.value)}))}}},n.__makeTemplateObject=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t},n.__importStar=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n in t)Object.hasOwnProperty.call(t,n)&&(e[n]=t[n]);return e.default=t,e},n.__importDefault=function(t){return t&&t.__esModule?t:{default:t}},n.__classPrivateFieldGet=function(t,e){if(!e.has(t))throw new TypeError("attempted to get private field on non-instance");return e.get(t)},n.__classPrivateFieldSet=function(t,e,n){if(!e.has(t))throw new TypeError("attempted to set private field on non-instance");return e.set(t,n),n}},
function _(e,r,t){var l=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var r={};if(null!=e)for(var t in e)Object.hasOwnProperty.call(e,t)&&(r[t]=e[t]);return r.default=e,r};Object.defineProperty(t,"__esModule",{value:!0});var o=e(3);t.version=o.version;var s=e(4);t.index=s.index,t.embed=l(e(4)),t.protocol=l(e(367)),t._testing=l(e(368));var n=e(72);t.logger=n.logger,t.set_log_level=n.set_log_level;var a=e(22);t.settings=a.settings;var i=e(7);t.Models=i.Models;var v=e(5);t.documents=v.documents;var _=e(369);t.safely=_.safely},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0}),o.version="2.1.0"},
function _(e,o,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(5),s=e(72),d=e(24),r=e(8),_=e(15),c=e(358),i=e(360),a=e(359);var u=e(358);n.add_document_standalone=u.add_document_standalone,n.index=u.index;var l=e(360);n.add_document_from_session=l.add_document_from_session;var m=e(365);n.embed_items_notebook=m.embed_items_notebook,n.kernels=m.kernels;var f=e(359);async function g(e,o,n,_){r.isString(e)&&(e=JSON.parse(d.unescape(e)));const u={};for(const o in e){const n=e[o];u[o]=t.Document.from_json(n)}const l=[];for(const e of o){const o=a._resolve_element(e),t=a._resolve_root_elements(e);if(null!=e.docid)l.push(await c.add_document_standalone(u[e.docid],o,t,e.use_for_title));else{if(null==e.token)throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");{const d=i._get_ws_url(n,_);s.logger.debug("embed: computed ws url: "+d);try{l.push(await i.add_document_from_session(d,e.token,o,t,e.use_for_title)),console.log("Bokeh items were rendered successfully")}catch(e){console.log("Error rendering Bokeh items:",e)}}}}return l}n.BOKEH_ROOT=f.BOKEH_ROOT,n.embed_item=async function(e,o){const n={},t=d.uuid4();n[t]=e.doc,null==o&&(o=e.target_id);const s=document.getElementById(o);null!=s&&s.classList.add(a.BOKEH_ROOT);const r={roots:{[e.root_id]:o},root_ids:[e.root_id],docid:t},[c]=await _.defer(()=>g(n,[r]));return c},n.embed_items=async function(e,o,n,t){return await _.defer(()=>g(e,o,n,t))}},
function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0});const o=e(1);o.__exportStar(e(6),_),o.__exportStar(e(105),_)},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const o=e(1),n=e(7),r=e(3),i=e(72),_=e(291),a=e(13),l=e(14),c=e(16),h=e(27),d=e(9),f=o.__importStar(e(104)),u=e(25),m=e(8),g=e(245),p=e(76),w=e(71),v=e(105);class b{constructor(e){this.document=e,this.session=null,this.subscribed_models=new Set}send_event(e){const t=new v.MessageSentEvent(this.document,"bokeh_event",e.to_json());this.document._trigger_on_change(t)}trigger(e){for(const t of this.subscribed_models)null!=e.origin&&e.origin!=t||t._process_event(e)}}s.EventManager=b,b.__name__="EventManager",s.documents=[],s.DEFAULT_TITLE="Bokeh Application";class y{constructor(){s.documents.push(this),this._init_timestamp=Date.now(),this._title=s.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._all_models_freeze_count=0,this._callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new b(this),this.idle=new l.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}get layoutables(){return this._roots.filter(e=>e instanceof g.LayoutDOM)}get is_idle(){for(const e of this.layoutables)if(!this._idle_roots.has(e))return!1;return!0}notify_idle(e){this._idle_roots.set(e,!0),this.is_idle&&(i.logger.info(`document idle at ${Date.now()-this._init_timestamp} ms`),this.idle.emit())}clear(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}}interactive_start(e){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new _.LODStart)),this._interactive_timestamp=Date.now()}interactive_stop(e){null!=this._interactive_plot&&this._interactive_plot.id===e.id&&this._interactive_plot.trigger_event(new _.LODEnd),this._interactive_plot=null,this._interactive_timestamp=null}interactive_duration(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp}destructively_move(e){if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();const t=d.copy(this._roots);this.clear();for(const e of t)if(null!=e.document)throw new Error("Somehow we didn't detach "+e);if(0!=this._all_models.size)throw new Error("this._all_models still had stuff in it: "+this._all_models);for(const s of t)e.add_root(s);e.set_title(this._title)}_push_all_models_freeze(){this._all_models_freeze_count+=1}_pop_all_models_freeze(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()}_invalidate_all_models(){i.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()}_recompute_all_models(){let e=new Set;for(const t of this._roots)e=f.union(e,t.references());const t=new Set(this._all_models.values()),s=f.difference(t,e),o=f.difference(e,t),n=new Map;for(const t of e)n.set(t.id,t);for(const e of s)e.detach_document();for(const e of o)e.attach_document(this);this._all_models=n}roots(){return this._roots}add_root(e,t){if(i.logger.debug("Adding root: "+e),!d.includes(this._roots,e)){this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new v.RootAddedEvent(this,e,t))}}remove_root(e,t){const s=this._roots.indexOf(e);if(!(s<0)){this._push_all_models_freeze();try{this._roots.splice(s,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new v.RootRemovedEvent(this,e,t))}}title(){return this._title}set_title(e,t){e!==this._title&&(this._title=e,this._trigger_on_change(new v.TitleChangedEvent(this,e,t)))}get_model_by_id(e){var t;return null!==(t=this._all_models.get(e))&&void 0!==t?t:null}get_model_by_name(e){const t=[];for(const s of this._all_models.values())s instanceof w.Model&&s.name==e&&t.push(s);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error(`Multiple models are named '${e}'`)}}on_message(e,t){const s=this._message_callbacks.get(e);null==s?this._message_callbacks.set(e,new Set([t])):s.add(t)}remove_on_message(e,t){var s;null===(s=this._message_callbacks.get(e))||void 0===s||s.delete(t)}_trigger_on_message(e,t){const s=this._message_callbacks.get(e);if(null!=s)for(const e of s)e(t)}on_change(e,t=!1){this._callbacks.has(e)||this._callbacks.set(e,t)}remove_on_change(e){this._callbacks.delete(e)}_trigger_on_change(e){for(const[t,s]of this._callbacks)if(!s&&e instanceof v.DocumentEventBatch)for(const s of e.events)t(s);else t(e)}_notify_change(e,t,s,o,n){this._trigger_on_change(new v.ModelChangedEvent(this,e,t,s,o,null==n?void 0:n.setter_id,null==n?void 0:n.hint))}static _references_json(e,t=!0){const s=[];for(const o of e){const e=o.struct();e.attributes=o.attributes_as_json(t),delete e.attributes.id,s.push(e)}return s}static _instantiate_object(e,t,s){const o=Object.assign(Object.assign({},s),{id:e,__deferred__:!0});return new(n.Models(t))(o)}static _instantiate_references_json(e,t){const s=new Map;for(const o of e){const e=o.id,n=o.type,r=o.attributes||{};let i=t.get(e);null==i&&(i=y._instantiate_object(e,n,r),null!=o.subtype&&i.set_subtype(o.subtype)),s.set(i.id,i)}return s}static _resolve_refs(e,t,s,o){function n(e){if(c.is_ref(e)){if(t.has(e.id))return t.get(e.id);if(s.has(e.id))return s.get(e.id);throw new Error(`reference ${JSON.stringify(e)} isn't known (not in Document?)`)}return h.is_NDArray_ref(e)?h.decode_NDArray(e,o):m.isArray(e)?function(e){const t=[];for(const s of e)t.push(n(s));return t}(e):m.isPlainObject(e)?function(e){const t={};for(const s in e){const o=e[s];t[s]=n(o)}return t}(e):e}return n(e)}static _initialize_references_json(e,t,s,o){const n=new Map;for(const{id:r,attributes:i}of e){const e=!t.has(r),_=e?s.get(r):t.get(r),a=y._resolve_refs(i,t,s,o);_.setv(a,{silent:!0}),n.set(r,{instance:_,is_new:e})}const r=[],i=new Set;function _(e){if(e instanceof a.HasProps){if(n.has(e.id)&&!i.has(e.id)){i.add(e.id);const{instance:t,is_new:s}=n.get(e.id),{attributes:o}=t;for(const e in o)_(o[e]);s&&(t.finalize(),r.push(t))}}else if(m.isArray(e))for(const t of e)_(t);else if(m.isPlainObject(e))for(const t in e)_(e[t])}for(const e of n.values())_(e.instance);for(const e of r)e.connect_signals()}static _event_for_attribute_change(e,t,s,o,n){if(o.get_model_by_id(e.id).property(t).syncable){const r={kind:"ModelChanged",model:{id:e.id},attr:t,new:s};return a.HasProps._json_record_references(o,s,n,{recursive:!0}),r}return null}static _events_to_sync_objects(e,t,s,o){const n=Object.keys(e.attributes),r=Object.keys(t.attributes),_=d.difference(n,r),a=d.difference(r,n),l=d.intersection(n,r),c=[];for(const e of _)i.logger.warn(`Server sent key ${e} but we don't seem to have it in our JSON`);for(const n of a){const r=t.attributes[n];c.push(y._event_for_attribute_change(e,n,r,s,o))}for(const n of l){const r=e.attributes[n],i=t.attributes[n];null==r&&null==i||(null==r||null==i?c.push(y._event_for_attribute_change(e,n,i,s,o)):u.isEqual(r,i)||c.push(y._event_for_attribute_change(e,n,i,s,o)))}return c.filter(e=>null!=e)}static _compute_patch_since_json(e,t){const s=t.to_json(!1);function o(e){const t=new Map;for(const s of e.roots.references)t.set(s.id,s);return t}const n=o(e),r=new Map,i=[];for(const t of e.roots.root_ids)r.set(t,n.get(t)),i.push(t);const _=o(s),a=new Map,l=[];for(const e of s.roots.root_ids)a.set(e,_.get(e)),l.push(e);if(i.sort(),l.sort(),d.difference(i,l).length>0||d.difference(l,i).length>0)throw new Error("Not implemented: computing add/remove of document roots");const c=new Set;let h=[];for(const e of t._all_models.keys())if(n.has(e)){const s=y._events_to_sync_objects(n.get(e),_.get(e),t,c);h=h.concat(s)}return{references:y._references_json(c,!1),events:h}}to_json_string(e=!0){return JSON.stringify(this.to_json(e))}to_json(e=!0){const t=this._roots.map(e=>e.id),s=this._all_models.values();return{version:r.version,title:this._title,roots:{root_ids:t,references:y._references_json(s,e)}}}static from_json_string(e){const t=JSON.parse(e);return y.from_json(t)}static from_json(e){i.logger.debug("Creating Document from JSON");const t=e.version,s=-1!==t.indexOf("+")||-1!==t.indexOf("-"),o=`Library versions: JS (${r.version}) / Python (${t})`;s||r.version.replace(/-(dev|rc)\./,"$1")==t?i.logger.debug(o):(i.logger.warn("JS/Python version mismatch"),i.logger.warn(o));const n=e.roots,_=n.root_ids,a=n.references,l=y._instantiate_references_json(a,new Map);y._initialize_references_json(a,new Map,l,new Map);const c=new y;for(const e of _){const t=l.get(e);null!=t&&c.add_root(t)}return c.set_title(e.title),c}replace_with_json(e){y.from_json(e).destructively_move(this)}create_json_patch_string(e){return JSON.stringify(this.create_json_patch(e))}create_json_patch(e){const t=new Set,s=[];for(const o of e){if(o.document!==this)throw i.logger.warn("Cannot create a patch using events from a different document, event had ",o.document," we are ",this),new Error("Cannot create a patch using events from a different document");s.push(o.json(t))}return{events:s,references:y._references_json(t)}}apply_json_patch(e,t=new Map,s){const o=e.references,n=e.events,r=y._instantiate_references_json(o,this._all_models);t instanceof Map||(t=new Map(t));for(const e of n)switch(e.kind){case"RootAdded":case"RootRemoved":case"ModelChanged":{const t=e.model.id,s=this._all_models.get(t);if(null!=s)r.set(t,s);else if(!r.has(t))throw i.logger.warn(`Got an event for unknown model ${e.model}"`),new Error("event model wasn't known");break}}const _=new Map,a=new Map;for(const[e,t]of r)this._all_models.has(e)?_.set(e,t):a.set(e,t);y._initialize_references_json(o,_,a,t);for(const e of n)switch(e.kind){case"MessageSent":{const{msg_type:s,msg_data:o}=e;let n;if(void 0===o){if(1!=t.size)throw new Error("expected exactly one buffer");{const[[,e]]=t;n=e}}else n=y._resolve_refs(o,_,a,t);this._trigger_on_message(s,n);break}case"ModelChanged":{const o=e.model.id,n=this._all_models.get(o);if(null==n)throw new Error(`Cannot apply patch to ${o} which is not in the document`);const r=e.attr,i=y._resolve_refs(e.new,_,a,t);n.setv({[r]:i},{setter_id:s});break}case"ColumnDataChanged":{const o=e.column_source.id,n=this._all_models.get(o);if(null==n)throw new Error(`Cannot stream to ${o} which is not in the document`);const r=y._resolve_refs(e.new,new Map,new Map,t);if(null!=e.cols)for(const e in n.data)e in r||(r[e]=n.data[e]);n.setv({data:r},{setter_id:s,check_eq:!1});break}case"ColumnsStreamed":{const t=e.column_source.id,o=this._all_models.get(t);if(null==o)throw new Error(`Cannot stream to ${t} which is not in the document`);if(!(o instanceof p.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");const n=e.data,r=e.rollover;o.stream(n,r,s);break}case"ColumnsPatched":{const t=e.column_source.id,o=this._all_models.get(t);if(null==o)throw new Error(`Cannot patch ${t} which is not in the document`);if(!(o instanceof p.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");const n=e.patches;o.patch(n,s);break}case"RootAdded":{const t=e.model.id,o=r.get(t);this.add_root(o,s);break}case"RootRemoved":{const t=e.model.id,o=r.get(t);this.remove_root(o,s);break}case"TitleChanged":this.set_title(e.title,s);break;default:throw new Error("Unknown patch event "+JSON.stringify(e))}}}s.Document=y,y.__name__="Document"},
function _(e,r,s){Object.defineProperty(s,"__esModule",{value:!0});const o=e(1),t=e(8),d=e(13);s.overrides={};const i=new Map;s.Models=e=>{const r=s.overrides[e]||i.get(e);if(null==r)throw new Error(`Model '${e}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`);return r},s.Models.register=(e,r)=>{s.overrides[e]=r},s.Models.unregister=e=>{delete s.overrides[e]},s.Models.register_models=(e,r=!1,s)=>{var o;if(null!=e)for(const l in e){const n=e[l];if(o=n,t.isObject(o)&&o.prototype instanceof d.HasProps){const e=n.__qualified__;r||!i.has(e)?i.set(e,n):null!=s?s(e):console.warn(`Model '${e}' was already registered`)}}},s.register_models=s.Models.register_models,s.Models.registered_names=()=>Array.from(i.keys());const l=o.__importStar(e(29));s.register_models(l)},
function _(n,r,t){Object.defineProperty(t,"__esModule",{value:!0});
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const e=n(9),o=Object.prototype.toString;function u(n){return"[object Number]"===o.call(n)}function c(n){const r=typeof n;return"function"===r||"object"===r&&!!n}t.isBoolean=function(n){return!0===n||!1===n||"[object Boolean]"===o.call(n)},t.isNumber=u,t.isInteger=function(n){return u(n)&&Number.isInteger(n)},t.isString=function(n){return"[object String]"===o.call(n)},t.isFunction=function(n){return"[object Function]"===o.call(n)},t.isArray=function(n){return Array.isArray(n)},t.isArrayOf=function(n,r){return e.every(n,r)},t.isArrayableOf=function(n,r){for(let t=0,e=n.length;t<e;t++)if(!r(n[t]))return!1;return!0},t.isTypedArray=function(n){return null!=n&&n.buffer instanceof ArrayBuffer},t.isObject=c,t.isPlainObject=function(n){return c(n)&&(null==n.constructor||n.constructor===Object)}},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const r=n(10),o=n(11),i=n(12);e.map=i.map,e.reduce=i.reduce,e.min=i.min,e.min_by=i.min_by,e.max=i.max,e.max_by=i.max_by,e.sum=i.sum,e.cumsum=i.cumsum,e.every=i.every,e.some=i.some,e.find=i.find,e.find_last=i.find_last,e.find_index=i.find_index,e.find_last_index=i.find_last_index,e.sorted_index=i.sorted_index,e.is_empty=i.is_empty;const u=Array.prototype.slice;function c(n){return u.call(n)}function f(n){return[].concat(...n)}function s(n,t){return-1!==n.indexOf(t)}function l(n,t,e=1){o.assert(e>0,"'step' must be a positive number"),null==t&&(t=n,n=0);const{max:r,ceil:i,abs:u}=Math,c=n<=t?e:-e,f=r(i(u(t-n)/e),0),s=Array(f);for(let t=0;t<f;t++,n+=c)s[t]=n;return s}function a(n){const t=[];for(const e of n)s(t,e)||t.push(e);return t}e.head=function(n){return n[0]},e.tail=function(n){return n[n.length-1]},e.last=function(n){return n[n.length-1]},e.copy=c,e.concat=f,e.includes=s,e.contains=s,e.nth=function(n,t){return n[t>=0?t:n.length+t]},e.zip=function(...n){if(0==n.length)return[];const t=i.min(n.map(n=>n.length)),e=n.length,r=new Array(t);for(let o=0;o<t;o++){r[o]=new Array(e);for(let t=0;t<e;t++)r[o][t]=n[t][o]}return r},e.unzip=function(n){const t=n.length,e=i.min(n.map(n=>n.length)),r=Array(e);for(let n=0;n<e;n++)r[n]=new Array(t);for(let o=0;o<t;o++)for(let t=0;t<e;t++)r[t][o]=n[o][t];return r},e.range=l,e.linspace=function(n,t,e=100){const r=(t-n)/(e-1),o=new Array(e);for(let t=0;t<e;t++)o[t]=n+r*t;return o},e.transpose=function(n){const t=n.length,e=n[0].length,r=[];for(let o=0;o<e;o++){r[o]=[];for(let e=0;e<t;e++)r[o][e]=n[e][o]}return r},e.argmin=function(n){return i.min_by(l(n.length),t=>n[t])},e.argmax=function(n){return i.max_by(l(n.length),t=>n[t])},e.sort_by=function(n,t){const e=n.map((n,e)=>({value:n,index:e,key:t(n)}));return e.sort((n,t)=>{const e=n.key,r=t.key;if(e!==r){if(e>r||void 0===e)return 1;if(e<r||void 0===r)return-1}return n.index-t.index}),e.map(n=>n.value)},e.uniq=a,e.uniq_by=function(n,t){const e=[],r=[];for(const o of n){const n=t(o);s(r,n)||(r.push(n),e.push(o))}return e},e.union=function(...n){return a(f(n))},e.intersection=function(n,...t){const e=[];n:for(const r of n)if(!s(e,r)){for(const n of t)if(!s(n,r))continue n;e.push(r)}return e},e.difference=function(n,...t){const e=f(t);return n.filter(n=>!s(e,n))},e.remove_at=function(n,t){const e=c(n);return e.splice(t,1),e},e.remove_by=function(n,t){for(let e=0;e<n.length;)t(n[e])?n.splice(e,1):e++},e.shuffle=function(n){const t=n.length,e=new Array(t);for(let o=0;o<t;o++){const t=r.randomIn(0,o);t!==o&&(e[o]=e[t]),e[t]=n[o]}return e},e.pairwise=function(n,t){const e=n.length,r=new Array(e-1);for(let o=0;o<e-1;o++)r[o]=t(n[o],n[o+1]);return r},e.reversed=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++)e[t-r-1]=n[r];return e},e.repeat=function(n,t){const e=new Array(t);for(let r=0;r<t;r++)e[r]=n;return e}},
function _(n,t,r){function e(n){if(0==n)return 0;for(;n<=0;)n+=2*Math.PI;for(;n>2*Math.PI;)n-=2*Math.PI;return n}function o(n,t){return e(n-t)}function a(){return Math.random()}Object.defineProperty(r,"__esModule",{value:!0}),r.angle_norm=e,r.angle_dist=o,r.angle_between=function(n,t,r,a){const u=o(t,r);if(0==u)return!1;if(u==2*Math.PI)return!0;const f=e(n),i=o(t,f)<=u&&o(f,r)<=u;return 0==a?i:!i},r.random=a,r.randomIn=function(n,t){return null==t&&(t=n,n=0),n+Math.floor(Math.random()*(t-n+1))},r.atan2=function(n,t){return Math.atan2(t[1]-n[1],t[0]-n[0])},r.rnorm=function(n,t){let r,e;for(;r=a(),e=a(),e=(2*e-1)*Math.sqrt(1/Math.E*2),!(-4*r*r*Math.log(r)>=e*e););let o=e/r;return o=n+t*o,o},r.clamp=function(n,t,r){return n>r?r:n<t?t:n}},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});class o extends Error{}n.AssertionError=o,o.__name__="AssertionError",n.assert=function(e,r){if(!(!0===e||!1!==e&&e()))throw new o(null!=r?r:"Assertion failed")},n.unreachable=function(){throw new Error("unreachable code")}},
function _(n,t,e){function r(n,t,e,...r){const o=n.length;t<0&&(t+=o),t<0?t=0:t>o&&(t=o),null==e||e>o-t?e=o-t:e<0&&(e=0);const u=o-e+r.length,i=new n.constructor(u);let f=0;for(;f<t;f++)i[f]=n[f];for(const n of r)i[f++]=n;for(let r=t+e;r<o;r++)i[f++]=n[r];return i}function o(n,t){return r(n,t,n.length-t)}function u(n,t,e){const r=n.length;if(void 0===e&&0==r)throw new Error("can't reduce an empty array without an initial value");let o,u;for(void 0===e?(o=n[0],u=1):(o=e,u=0);u<r;u++)o=t(o,n[u],u,n);return o}function i(n){return function(t,e){const r=t.length;let o=n>0?0:r-1;for(;o>=0&&o<r;o+=n)if(e(t[o]))return o;return-1}}Object.defineProperty(e,"__esModule",{value:!0}),e.is_empty=function(n){return 0==n.length},e.splice=r,e.head=o,e.insert=function(n,t,e){return r(n,e,0,t)},e.append=function(n,t){return r(n,n.length,0,t)},e.prepend=function(n,t){return r(n,0,0,t)},e.indexOf=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.map=function(n,t){const e=n.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=t(n[o],o,n);return r},e.filter=function(n,t){const e=n.length,r=new n.constructor(e);let u=0;for(let o=0;o<e;o++){const e=n[o];t(e,o,n)&&(r[u++]=e)}return o(r,u)},e.reduce=u,e.min=function(n){let t,e=1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],t<e&&(e=t);return e},e.min_by=function(n,t){if(0==n.length)throw new Error("min_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,u=n.length;o<u;o++){const u=n[o],i=t(u);i<r&&(e=u,r=i)}return e},e.max=function(n){let t,e=-1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],t>e&&(e=t);return e},e.max_by=function(n,t){if(0==n.length)throw new Error("max_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,u=n.length;o<u;o++){const u=n[o],i=t(u);i>r&&(e=u,r=i)}return e},e.sum=function(n){let t=0;for(let e=0,r=n.length;e<r;e++)t+=n[e];return t},e.cumsum=function(n){const t=new n.constructor(n.length);return u(n,(n,e,r)=>t[r]=n+e,0),t},e.every=function(n,t){for(let e=0,r=n.length;e<r;e++)if(!t(n[e]))return!1;return!0},e.some=function(n,t){for(let e=0,r=n.length;e<r;e++)if(t(n[e]))return!0;return!1},e.index_of=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.find_index=i(1),e.find_last_index=i(-1),e.find=function(n,t){const r=e.find_index(n,t);return-1==r?void 0:n[r]},e.find_last=function(n,t){const r=e.find_last_index(n,t);return-1==r?void 0:n[r]},e.sorted_index=function(n,t){let e=0,r=n.length;for(;e<r;){const o=Math.floor((e+r)/2);n[o]<t?e=o+1:r=o}return e}},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const r=e(1),n=e(14),i=e(16),o=r.__importStar(e(18)),c=r.__importStar(e(23)),a=e(24),_=e(9),u=e(17),h=e(8),f=e(25),l=e(5),p=e(26),d=e(27);class y extends(n.Signalable()){constructor(e={}){var t;super(),this._subtype=void 0,this.document=null,this.destroyed=new n.Signal0(this,"destroyed"),this.change=new n.Signal0(this,"change"),this.transformchange=new n.Signal0(this,"transformchange"),this.properties={},this._pending=!1,this._changing=!1;const s=e instanceof Map?e.get:t=>e[t];for(const[e,{type:t,default_value:r,options:n}]of u.entries(this._props)){if(null==t)throw new Error(`undefined property type for ${this.type}.${e}`);this.properties[e]=new t(this,e,r,s(e),n)}null!==(t=s("__deferred__"))&&void 0!==t&&t||(this.finalize(),this.connect_signals())}set type(e){console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"),this.constructor.__name__=e}get type(){return this.constructor.__qualified__}static get __qualified__(){const{__module__:e,__name__:t}=this;return null!=e?`${e}.${t}`:t}static init_HasProps(){this.prototype._props={},this.prototype._mixins=[],this.define({id:[o.String,()=>a.uniqueId()]})}static _fix_default(e,t){return void 0===e?void 0:h.isFunction(e)?e:h.isObject(e)?h.isArray(e)?()=>_.copy(e):()=>u.clone(e):()=>e}static define(e){for(const[t,s]of u.entries(e)){if(null!=this.prototype._props[t])throw new Error(`attempted to redefine property '${this.prototype.type}.${t}'`);if(null!=this.prototype[t])throw new Error(`attempted to redefine attribute '${this.prototype.type}.${t}'`);Object.defineProperty(this.prototype,t,{get(){return this.properties[t].get_value()},set(e){return this.setv({[t]:e}),this},configurable:!1,enumerable:!0});const[e,r,n]=s,i={type:e,default_value:this._fix_default(r,t),options:n},o=u.clone(this.prototype._props);o[t]=i,this.prototype._props=o}}static internal(e){const t={};for(const[s,r]of u.entries(e)){const[e,n,i={}]=r;t[s]=[e,n,Object.assign(Object.assign({},i),{internal:!0})]}this.define(t)}static mixins(e){function t(e){switch(e){case"line":return c.LineVector;case"fill":return c.FillVector;case"hatch":return c.HatchVector;case"text":return c.TextVector;default:throw new Error(`Unknown property mixin kind '${e}'`)}}function s(e,t){const s={};for(const[r,n]of u.entries(t))s[e+r]=n;return s}function r(e){const[t]=Object.keys(e),[s]=t.split("_",1);return s}h.isArray(e)||(e=[e]);const n={},i=[];for(const o of e)if(h.isString(o)){const[e,r=""]=o.split(":"),c=t(e);i.push(o),u.extend(n,s(r,c))}else if(h.isArray(o)){const[e,t]=o;i.push(`${r(t)}:${e}`),u.extend(n,s(e,t))}else{const e=o;i.push(r(e)),u.extend(n,e)}this.define(n),this.prototype._mixins=[...this.prototype._mixins,...i]}static override(e){for(const[t,s]of u.entries(e)){const e=this._fix_default(s,t),r=this.prototype._props[t];if(null==r)throw new Error(`attempted to override nonexistent '${this.prototype.type}.${t}'`);const n=u.clone(this.prototype._props);n[t]=Object.assign(Object.assign({},r),{default_value:e}),this.prototype._props=n}}toString(){return`${this.type}(${this.id})`}property(e){const t=this.properties[e];if(null!=t)return t;throw new Error(`unknown property ${this.type}.${e}`)}get attributes(){const e={};for(const t of this)e[t.attr]=t.get_value();return e}finalize(){for(const e of this)null!=e.spec.transform&&this.connect(e.spec.transform.change,()=>this.transformchange.emit());this.initialize()}initialize(){}connect_signals(){}disconnect_signals(){n.Signal.disconnectReceiver(this)}destroy(){this.disconnect_signals(),this.destroyed.emit()}clone(){return new this.constructor(this.attributes)}_setv(e,t){const s=t.check_eq,r=t.silent,n=[],i=this._changing;this._changing=!0;for(const[t,r]of e)!1!==s&&f.isEqual(t.get_value(),r)||(t.set_value(r),n.push(t));if(!r){n.length>0&&(this._pending=!0);for(const e of n)e.change.emit()}if(!i){if(!r&&!t.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}}setv(e,t={}){if(u.isEmpty(e))return;const s=new Map,r=new Map;for(const t in e){if(!e.hasOwnProperty(t))continue;const n=this.properties[t];if(null==n)throw new Error(`property ${this.type}.${t} wasn't declared`);const i=e[t];s.set(n,i),r.set(n,n.get_value())}this._setv(s,t);const{document:n}=this;if(null!=n){const e=[];for(const[t,s]of r)e.push([t,s,t.get_value()]);for(const[,t,s]of e)if(this._needs_invalidate(t,s)){n._invalidate_all_models();break}!0!==t.silent&&this._push_changes(e,t)}}getv(e){return this.property(e).get_value()}ref(){return{id:this.id}}struct(){const e={type:this.type,id:this.id,attributes:{}};return null!=this._subtype&&(e.subtype=this._subtype),e}set_subtype(e){this._subtype=e}*[Symbol.iterator](){for(const e in this.properties)yield this.properties[e]}*syncable_properties(){for(const e of this)e.syncable&&(yield e)}serializable_attributes(){const e={};for(const t of this.syncable_properties())e[t.attr]=t.get_value();return e}static _value_to_json(e){if(e instanceof y)return e.ref();if(p.is_NDArray(e))return d.encode_NDArray(e);if(h.isArray(e)){const t=[];for(let s=0;s<e.length;s++){const r=e[s];t.push(y._value_to_json(r))}return t}if(h.isPlainObject(e)){const t={};for(const s in e)e.hasOwnProperty(s)&&(t[s]=y._value_to_json(e[s]));return t}return e}attributes_as_json(e=!0,t=y._value_to_json){const s={};for(const r of this)r.syncable&&(e||r.dirty)&&(s[r.attr]=t(r.get_value()));return s}static _json_record_references(e,t,s,r){const{recursive:n}=r;if(i.is_ref(t)){const r=e.get_model_by_id(t.id);null==r||s.has(r)||y._value_record_references(r,s,{recursive:n})}else if(h.isArray(t))for(const r of t)y._json_record_references(e,r,s,{recursive:n});else if(h.isPlainObject(t))for(const r in t)if(t.hasOwnProperty(r)){const i=t[r];y._json_record_references(e,i,s,{recursive:n})}}static _value_record_references(e,t,s){const{recursive:r}=s;if(e instanceof y){if(!t.has(e)&&(t.add(e),r)){const s=e._immediate_references();for(const e of s)y._value_record_references(e,t,{recursive:!0})}}else if(h.isArray(e))for(const s of e)y._value_record_references(s,t,{recursive:r});else if(h.isPlainObject(e))for(const s in e)if(e.hasOwnProperty(s)){const n=e[s];y._value_record_references(n,t,{recursive:r})}}_immediate_references(){const e=new Set;for(const t of this.syncable_properties()){const s=t.get_value();y._value_record_references(s,e,{recursive:!1})}return[...e.values()]}references(){const e=new Set;return y._value_record_references(this,e,{recursive:!0}),e}_doc_attached(){}_doc_detached(){}attach_document(e){if(null!=this.document&&this.document!=e)throw new Error("models must be owned by only a single document");this.document=e,this._doc_attached()}detach_document(){this._doc_detached(),this.document=null}_needs_invalidate(e,t){const s=new Set;y._value_record_references(t,s,{recursive:!1});const r=new Set;y._value_record_references(e,r,{recursive:!1});for(const e of s)if(!r.has(e))return!0;for(const e of r)if(!s.has(e))return!0;return!1}_push_changes(e,t={}){const{document:s}=this;if(null==s)return;const{setter_id:r}=t,n=[];for(const[t,i,o]of e)t.syncable&&n.push(new l.ModelChangedEvent(s,this,t.attr,i,o,r));if(0!=n.length){let e;1==n.length?[e]=n:e=new l.DocumentEventBatch(s,n,r),s._trigger_on_change(e)}}materialize_dataspecs(e){const t={};for(const s of this){if(!(s instanceof o.VectorSpec))continue;if(s.optional&&null==s.spec.value&&!s.dirty)continue;const r=s.attr,n=s.array(e);t["_"+r]=n,s instanceof o.DistanceSpec&&(t["max_"+r]=_.max(n))}return t}on_change(e,t){for(const s of h.isArray(e)?e:[e])this.connect(s.change,t)}}s.HasProps=y,y.init_HasProps()},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});const s=n(15),l=n(9);class o{constructor(n,t){this.sender=n,this.name=t}connect(n,t=null){c.has(this.sender)||c.set(this.sender,[]);const e=c.get(this.sender);if(null!=u(e,this,n,t))return!1;const s=t||n;r.has(s)||r.set(s,[]);const l=r.get(s),o={signal:this,slot:n,context:t};return e.push(o),l.push(o),!0}disconnect(n,t=null){const e=c.get(this.sender);if(null==e||0===e.length)return!1;const s=u(e,this,n,t);if(null==s)return!1;const l=t||n,o=r.get(l);return s.signal=null,f(e),f(o),!0}emit(n){const t=c.get(this.sender)||[];for(const{signal:e,slot:s,context:l}of t)e===this&&s.call(l,n,this.sender)}}e.Signal=o,o.__name__="Signal";class i extends o{emit(){super.emit(void 0)}}e.Signal0=i,i.__name__="Signal0",function(n){n.disconnectBetween=function(n,t){const e=c.get(n);if(null==e||0===e.length)return;const s=r.get(t);if(null!=s&&0!==s.length){for(const t of s){if(null==t.signal)return;t.signal.sender===n&&(t.signal=null)}f(e),f(s)}},n.disconnectSender=function(n){const t=c.get(n);if(null!=t&&0!==t.length){for(const n of t){if(null==n.signal)return;const t=n.context||n.slot;n.signal=null,f(r.get(t))}f(t)}},n.disconnectReceiver=function(n){const t=r.get(n);if(null!=t&&0!==t.length){for(const n of t){if(null==n.signal)return;const t=n.signal.sender;n.signal=null,f(c.get(t))}f(t)}},n.disconnectAll=function(n){const t=c.get(n);if(null!=t&&0!==t.length){for(const n of t)n.signal=null;f(t)}const e=r.get(n);if(null!=e&&0!==e.length){for(const n of e)n.signal=null;f(e)}}}(o||(e.Signal=o={})),e.Signalable=function(){return class{connect(n,t){return n.connect(t,this)}disconnect(n,t){return n.disconnect(t,this)}}};const c=new WeakMap,r=new WeakMap;function u(n,t,e,s){return l.find(n,n=>n.signal===t&&n.slot===e&&n.context===s)}const g=new Set;function f(n){0===g.size&&s.defer(a),g.add(n)}function a(){for(const n of g)l.remove_by(n,n=>null==n.signal);g.clear()}},
function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.delay=
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
function(n,e){return setTimeout(n,e)};const u="function"==typeof requestAnimationFrame?requestAnimationFrame:setImmediate;t.defer=function(n){return new Promise(e=>{u(()=>e(n()))})},t.throttle=function(n,e,t={}){let u,o,i,r=null,l=0;const c=function(){l=!1===t.leading?0:Date.now(),r=null,i=n.apply(u,o),r||(u=o=null)};return function(){const a=Date.now();l||!1!==t.leading||(l=a);const f=e-(a-l);return u=this,o=arguments,f<=0||f>e?(r&&(clearTimeout(r),r=null),l=a,i=n.apply(u,o),r||(u=o=null)):r||!1===t.trailing||(r=setTimeout(c,f)),i}},t.once=function(n){let e,t=!1;return function(){return t||(t=!0,e=n()),e}}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const i=e(8),r=e(17);t.is_ref=function(e){if(i.isPlainObject(e)){const n=r.keys(e);return 1==n.length&&"id"==n[0]}return!1}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const c=e(9);function o(e){return Object.keys(e).length}n.keys=Object.keys,n.values=Object.values,n.entries=Object.entries,n.extend=Object.assign,n.clone=function(e){return Object.assign({},e)},n.merge=function(e,t){const n=Object.create(Object.prototype),o=c.concat([Object.keys(e),Object.keys(t)]);for(const s of o){const o=e.hasOwnProperty(s)?e[s]:[],r=t.hasOwnProperty(s)?t[s]:[];n[s]=c.union(o,r)}return n},n.size=o,n.isEmpty=function(e){return 0==o(e)},n.to_object=function(e){const t={};for(const[n,c]of e)t[n]=c;return t}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const i=e(1),a=e(14),s=i.__importStar(e(19)),r=e(9),l=e(12),o=e(20),_=e(8),c=e(22);function u(e){try{return JSON.stringify(e)}catch(t){return e.toString()}}function d(e){return _.isPlainObject(e)&&(void 0===e.value?0:1)+(void 0===e.field?0:1)+(void 0===e.expr?0:1)==1}n.isSpec=d;class p{constructor(e,t,n,i,s={}){var r,l;let o;if(this.obj=e,this.attr=t,this.default_value=n,this._dirty=!1,this.change=new a.Signal0(this.obj,"change"),this.internal=null!==(r=s.internal)&&void 0!==r&&r,this.optional=null!==(l=s.optional)&&void 0!==l&&l,void 0!==i)o=i,this._dirty=!0;else{const t=this._default_override();o=void 0!==t?t:void 0!==n?n(e):null}this._update(o)}get syncable(){return!this.internal}get_value(){return this.spec.value}set_value(e){this._update(e),this._dirty=!0}_default_override(){}get dirty(){return this._dirty}_update(e){null!=e&&this.validate(e),this.spec={value:e}}toString(){return`Prop(${this.obj}.${this.attr}, spec: ${u(this.spec)})`}normalize(e){return e}validate(e){if(!this.valid(e))throw new Error(`${this.obj.type}.${this.attr} given invalid value: ${u(e)}`)}valid(e){return!0}value(e=!0){if(void 0===this.spec.value)throw new Error("attempted to retrieve property value for property without value specification");let t=this.normalize([this.spec.value])[0];return null!=this.spec.transform&&e&&(t=this.spec.transform.compute(t)),t}}n.Property=p,p.__name__="Property";class S extends p{}n.Any=S,S.__name__="Any";class h extends p{valid(e){return _.isArray(e)||e instanceof Float64Array}}n.Array=h,h.__name__="Array";class m extends p{valid(e){return _.isBoolean(e)}}n.Boolean=m,m.__name__="Boolean";class v extends p{valid(e){return _.isString(e)&&o.is_color(e)}}n.Color=v,v.__name__="Color";class g extends p{}n.Instance=g,g.__name__="Instance";class x extends p{valid(e){return _.isNumber(e)}}n.Number=x,x.__name__="Number";class y extends x{valid(e){return _.isNumber(e)&&(0|e)==e}}n.Int=y,y.__name__="Int";class f extends x{}n.Angle=f,f.__name__="Angle";class P extends x{valid(e){return _.isNumber(e)&&0<=e&&e<=1}}n.Percent=P,P.__name__="Percent";class A extends p{valid(e){return _.isString(e)}}n.String=A,A.__name__="String";class L extends p{valid(e){return null===e||_.isString(e)}}n.NullString=L,L.__name__="NullString";class T extends A{}n.FontSize=T,T.__name__="FontSize";class b extends A{_default_override(){return c.settings.dev?"Bokeh":void 0}}n.Font=b,b.__name__="Font";class M extends p{valid(e){return _.isString(e)&&r.includes(this.enum_values,e)}}function B(e){return class extends M{get enum_values(){return e}}}n.EnumProperty=M,M.__name__="EnumProperty",n.Enum=B;class C extends M{get enum_values(){return s.Direction}normalize(e){const t=new Uint8Array(e.length);for(let n=0;n<e.length;n++)switch(e[n]){case"clock":t[n]=0;break;case"anticlock":t[n]=1}return t}}n.Direction=C,C.__name__="Direction",n.Anchor=B(s.Anchor),n.AngleUnits=B(s.AngleUnits),n.BoxOrigin=B(s.BoxOrigin),n.ButtonType=B(s.ButtonType),n.CalendarPosition=B(s.CalendarPosition),n.Dimension=B(s.Dimension),n.Dimensions=B(s.Dimensions),n.Distribution=B(s.Distribution),n.FontStyle=B(s.FontStyle),n.HatchPatternType=B(s.HatchPatternType),n.HTTPMethod=B(s.HTTPMethod),n.HexTileOrientation=B(s.HexTileOrientation),n.HoverMode=B(s.HoverMode),n.LatLon=B(s.LatLon),n.LegendClickPolicy=B(s.LegendClickPolicy),n.LegendLocation=B(s.LegendLocation),n.LineCap=B(s.LineCap),n.LineJoin=B(s.LineJoin),n.LinePolicy=B(s.LinePolicy),n.Location=B(s.Location),n.Logo=B(s.Logo),n.MarkerType=B(s.MarkerType),n.MutedPolicy=B(s.MutedPolicy),n.Orientation=B(s.Orientation),n.OutputBackend=B(s.OutputBackend),n.PaddingUnits=B(s.PaddingUnits),n.Place=B(s.Place),n.PointPolicy=B(s.PointPolicy),n.RadiusDimension=B(s.RadiusDimension),n.RenderLevel=B(s.RenderLevel),n.RenderMode=B(s.RenderMode),n.ResetPolicy=B(s.ResetPolicy),n.RoundingFunction=B(s.RoundingFunction),n.Side=B(s.Side),n.SizingMode=B(s.SizingMode),n.Sort=B(s.Sort),n.SpatialUnits=B(s.SpatialUnits),n.StartEnd=B(s.StartEnd),n.StepMode=B(s.StepMode),n.TapBehavior=B(s.TapBehavior),n.TextAlign=B(s.TextAlign),n.TextBaseline=B(s.TextBaseline),n.TextureRepetition=B(s.TextureRepetition),n.TickLabelOrientation=B(s.TickLabelOrientation),n.TooltipAttachment=B(s.TooltipAttachment),n.UpdateMode=B(s.UpdateMode),n.VerticalAlign=B(s.VerticalAlign);class N extends p{get_value(){return null===this.spec.value?null:this.spec}_update(e){d(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)}}n.ScalarSpec=N,N.__name__="ScalarSpec";class z extends N{}n.AnyScalar=z,z.__name__="AnyScalar";class D extends N{}n.ColorScalar=D,D.__name__="ColorScalar";class F extends N{}n.NumberScalar=F,F.__name__="NumberScalar";class k extends N{}n.StringScalar=k,k.__name__="StringScalar";class O extends N{}n.NullStringScalar=O,O.__name__="NullStringScalar";class U extends N{}n.ArrayScalar=U,U.__name__="ArrayScalar";class w extends N{}n.LineJoinScalar=w,w.__name__="LineJoinScalar";class R extends N{}n.LineCapScalar=R,R.__name__="LineCapScalar";class E extends N{}n.FontSizeScalar=E,E.__name__="FontSizeScalar";class $ extends N{}n.FontStyleScalar=$,$.__name__="FontStyleScalar";class H extends N{}n.TextAlignScalar=H,H.__name__="TextAlignScalar";class j extends N{}n.TextBaselineScalar=j,j.__name__="TextBaselineScalar";class I extends p{get_value(){return null===this.spec.value?null:this.spec}_update(e){d(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)}array(e){let t;if(null!=this.spec.field){if(t=this.normalize(e.get_column(this.spec.field)),null==t)throw new Error(`attempted to retrieve property array for nonexistent field '${this.spec.field}'`)}else if(null!=this.spec.expr)t=this.normalize(this.spec.expr.v_compute(e));else{let n=e.get_length();null==n&&(n=1);const i=this.value(!1);t=r.repeat(i,n)}return null!=this.spec.transform&&(t=this.spec.transform.v_compute(t)),t}}n.VectorSpec=I,I.__name__="VectorSpec";class J extends I{}n.DataSpec=J,J.__name__="DataSpec";class V extends I{_update(e){super._update(e),null==this.spec.units&&(this.spec.units=this.default_units);const t=this.spec.units;if(!r.includes(this.valid_units,t))throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${t}`)}get units(){return this.spec.units}set units(e){this.spec.units=e}}n.UnitsSpec=V,V.__name__="UnitsSpec";class q extends V{get default_units(){return"rad"}get valid_units(){return s.AngleUnits}normalize(e){return"deg"==this.spec.units&&(e=l.map(e,e=>e*Math.PI/180)),e=l.map(e,e=>-e),super.normalize(e)}}n.AngleSpec=q,q.__name__="AngleSpec";class G extends J{}n.BooleanSpec=G,G.__name__="BooleanSpec";class K extends J{}n.ColorSpec=K,K.__name__="ColorSpec";class Q extends J{}n.CoordinateSpec=Q,Q.__name__="CoordinateSpec";class W extends J{}n.CoordinateSeqSpec=W,W.__name__="CoordinateSeqSpec";class X extends V{get default_units(){return"data"}get valid_units(){return s.SpatialUnits}}n.DistanceSpec=X,X.__name__="DistanceSpec";class Y extends J{}n.FontSizeSpec=Y,Y.__name__="FontSizeSpec";class Z extends J{}n.MarkerSpec=Z,Z.__name__="MarkerSpec";class ee extends J{}n.NumberSpec=ee,ee.__name__="NumberSpec";class te extends J{}n.StringSpec=te,te.__name__="StringSpec";class ne extends J{}n.NullStringSpec=ne,ne.__name__="NullStringSpec"},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0}),o.Align=["start","center","end"],o.Anchor=["top_left","top_center","top_right","center_left","center","center_right","bottom_left","bottom_center","bottom_right"],o.AngleUnits=["deg","rad"],o.BoxOrigin=["corner","center"],o.ButtonType=["default","primary","success","warning","danger"],o.CalendarPosition=["auto","above","below"],o.Dimension=["width","height"],o.Dimensions=["width","height","both"],o.Direction=["clock","anticlock"],o.Distribution=["uniform","normal"],o.FontStyle=["normal","italic","bold","bold italic"],o.HatchPatternType=["blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"],o.HTTPMethod=["POST","GET"],o.HexTileOrientation=["pointytop","flattop"],o.HoverMode=["mouse","hline","vline"],o.LatLon=["lat","lon"],o.LegendClickPolicy=["none","hide","mute"],o.LegendLocation=o.Anchor,o.LineCap=["butt","round","square"],o.LineJoin=["miter","round","bevel"],o.LinePolicy=["prev","next","nearest","interp","none"],o.Location=["above","below","left","right"],o.Logo=["normal","grey"],o.MarkerType=["asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","triangle","triangle_dot","triangle_pin","x","y"],o.MutedPolicy=["show","ignore"],o.Orientation=["vertical","horizontal"],o.OutputBackend=["canvas","svg","webgl"],o.PaddingUnits=["percent","absolute"],o.Place=["above","below","left","right","center"],o.PointPolicy=["snap_to_data","follow_mouse","none"],o.RadiusDimension=["x","y","max","min"],o.RenderLevel=["image","underlay","glyph","guide","annotation","overlay"],o.RenderMode=["canvas","css"],o.ResetPolicy=["standard","event_only"],o.RoundingFunction=["round","nearest","floor","rounddown","ceil","roundup"],o.SelectionMode=["replace","append","intersect","subtract"],o.Side=["above","below","left","right"],o.SizingMode=["stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"],o.Sort=["ascending","descending"],o.SpatialUnits=["screen","data"],o.StartEnd=["start","end"],o.StepMode=["after","before","center"],o.TapBehavior=["select","inspect"],o.TextAlign=["left","right","center"],o.TextBaseline=["top","middle","bottom","alphabetic","hanging","ideographic"],o.TextureRepetition=["repeat","repeat_x","repeat_y","no_repeat"],o.TickLabelOrientation=["vertical","horizontal","parallel","normal"],o.TooltipAttachment=["horizontal","vertical","left","right","above","below"],o.UpdateMode=["replace","append"],o.VerticalAlign=["top","middle","bottom"]},
function _(r,e,t){Object.defineProperty(t,"__esModule",{value:!0});const n=r(21),l=r(9);function s(r){const e=Number(r).toString(16);return 1==e.length?"0"+e:e}function o(r){if(0==(r+="").indexOf("#"))return r;if(n.is_svg_color(r))return n.svg_colors[r];if(0==r.indexOf("rgb")){const e=r.replace(/^rgba?\(|\s+|\)$/g,"").split(",");let t=e.slice(0,3).map(s).join("");return 4==e.length&&(t+=s(Math.floor(255*parseFloat(e[3])))),"#"+t.slice(0,8)}return r}function a(r,e=1){if(!r)return[0,0,0,0];let t=o(r);t=t.replace(/ |#/g,""),t.length<=4&&(t=t.replace(/(.)/g,"$1$1"));const n=t.match(/../g).map(r=>parseInt(r,16)/255);for(;n.length<3;)n.push(0);return n.length<4&&n.push(e),n.slice(0,4)}function c(r){let e;switch(r.substring(0,4)){case"rgba":e={start:"rgba(",len:4,alpha:!0};break;case"rgb(":e={start:"rgb(",len:3,alpha:!1};break;default:return!1}if(new RegExp(".*?(\\.).*(,)").test(r))return!1;const t=r.replace(e.start,"").replace(")","").split(",").map(parseFloat);return t.length==e.len&&((!e.alpha||0<=t[3]&&t[3]<=1)&&!l.includes(t.slice(0,3).map(r=>0<=r&&r<=255),!1))}t.is_color=function(r){return n.is_svg_color(r.toLowerCase())||"#"==r.substring(0,1)||c(r)},t.rgb2hex=function(r,e,t){return`#${s(255&r)}${s(255&e)}${s(255&t)}`},t.color2hex=o,t.color2rgba=a,t.color2css=function(r,e=1){if(1==e)return r;{const[t,n,l,s]=a(r,e);return`rgba(${255*t},${255*n},${255*l},${s})`}},t.valid_rgb=c},
function _(e,F,r){Object.defineProperty(r,"__esModule",{value:!0}),r.svg_colors={indianred:"#CD5C5C",lightcoral:"#F08080",salmon:"#FA8072",darksalmon:"#E9967A",lightsalmon:"#FFA07A",crimson:"#DC143C",red:"#FF0000",firebrick:"#B22222",darkred:"#8B0000",pink:"#FFC0CB",lightpink:"#FFB6C1",hotpink:"#FF69B4",deeppink:"#FF1493",mediumvioletred:"#C71585",palevioletred:"#DB7093",coral:"#FF7F50",tomato:"#FF6347",orangered:"#FF4500",darkorange:"#FF8C00",orange:"#FFA500",gold:"#FFD700",yellow:"#FFFF00",lightyellow:"#FFFFE0",lemonchiffon:"#FFFACD",lightgoldenrodyellow:"#FAFAD2",papayawhip:"#FFEFD5",moccasin:"#FFE4B5",peachpuff:"#FFDAB9",palegoldenrod:"#EEE8AA",khaki:"#F0E68C",darkkhaki:"#BDB76B",lavender:"#E6E6FA",thistle:"#D8BFD8",plum:"#DDA0DD",violet:"#EE82EE",orchid:"#DA70D6",fuchsia:"#FF00FF",magenta:"#FF00FF",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",blueviolet:"#8A2BE2",darkviolet:"#9400D3",darkorchid:"#9932CC",darkmagenta:"#8B008B",purple:"#800080",indigo:"#4B0082",slateblue:"#6A5ACD",darkslateblue:"#483D8B",mediumslateblue:"#7B68EE",greenyellow:"#ADFF2F",chartreuse:"#7FFF00",lawngreen:"#7CFC00",lime:"#00FF00",limegreen:"#32CD32",palegreen:"#98FB98",lightgreen:"#90EE90",mediumspringgreen:"#00FA9A",springgreen:"#00FF7F",mediumseagreen:"#3CB371",seagreen:"#2E8B57",forestgreen:"#228B22",green:"#008000",darkgreen:"#006400",yellowgreen:"#9ACD32",olivedrab:"#6B8E23",olive:"#808000",darkolivegreen:"#556B2F",mediumaquamarine:"#66CDAA",darkseagreen:"#8FBC8F",lightseagreen:"#20B2AA",darkcyan:"#008B8B",teal:"#008080",aqua:"#00FFFF",cyan:"#00FFFF",lightcyan:"#E0FFFF",paleturquoise:"#AFEEEE",aquamarine:"#7FFFD4",turquoise:"#40E0D0",mediumturquoise:"#48D1CC",darkturquoise:"#00CED1",cadetblue:"#5F9EA0",steelblue:"#4682B4",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",lightblue:"#ADD8E6",skyblue:"#87CEEB",lightskyblue:"#87CEFA",deepskyblue:"#00BFFF",dodgerblue:"#1E90FF",cornflowerblue:"#6495ED",royalblue:"#4169E1",blue:"#0000FF",mediumblue:"#0000CD",darkblue:"#00008B",navy:"#000080",midnightblue:"#191970",cornsilk:"#FFF8DC",blanchedalmond:"#FFEBCD",bisque:"#FFE4C4",navajowhite:"#FFDEAD",wheat:"#F5DEB3",burlywood:"#DEB887",tan:"#D2B48C",rosybrown:"#BC8F8F",sandybrown:"#F4A460",goldenrod:"#DAA520",darkgoldenrod:"#B8860B",peru:"#CD853F",chocolate:"#D2691E",saddlebrown:"#8B4513",sienna:"#A0522D",brown:"#A52A2A",maroon:"#800000",white:"#FFFFFF",snow:"#FFFAFA",honeydew:"#F0FFF0",mintcream:"#F5FFFA",azure:"#F0FFFF",aliceblue:"#F0F8FF",ghostwhite:"#F8F8FF",whitesmoke:"#F5F5F5",seashell:"#FFF5EE",beige:"#F5F5DC",oldlace:"#FDF5E6",floralwhite:"#FFFAF0",ivory:"#FFFFF0",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lavenderblush:"#FFF0F5",mistyrose:"#FFE4E1",gainsboro:"#DCDCDC",lightgray:"#D3D3D3",lightgrey:"#D3D3D3",silver:"#C0C0C0",darkgray:"#A9A9A9",darkgrey:"#A9A9A9",gray:"#808080",grey:"#808080",dimgray:"#696969",dimgrey:"#696969",lightslategray:"#778899",lightslategrey:"#778899",slategray:"#708090",slategrey:"#708090",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",black:"#000000"},r.is_svg_color=function(e){return e in r.svg_colors}},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});class n{constructor(){this._dev=!1}set dev(e){this._dev=e}get dev(){return this._dev}}s.Settings=n,n.__name__="Settings",s.settings=new n},
function _(e,l,a){Object.defineProperty(a,"__esModule",{value:!0});const t=e(1).__importStar(e(18));a.Line={line_color:[t.Color,"black"],line_alpha:[t.Number,1],line_width:[t.Number,1],line_join:[t.LineJoin,"bevel"],line_cap:[t.LineCap,"butt"],line_dash:[t.Array,[]],line_dash_offset:[t.Number,0]},a.Fill={fill_color:[t.Color,"gray"],fill_alpha:[t.Number,1]},a.Hatch={hatch_color:[t.Color,"black"],hatch_alpha:[t.Number,1],hatch_scale:[t.Number,12],hatch_pattern:[t.NullString,null],hatch_weight:[t.Number,1],hatch_extra:[t.Any,{}]},a.Text={text_color:[t.Color,"#444444"],text_alpha:[t.Number,1],text_font:[t.Font,"helvetica"],text_font_size:[t.FontSize,"16px"],text_font_style:[t.FontStyle,"normal"],text_align:[t.TextAlign,"left"],text_baseline:[t.TextBaseline,"bottom"],text_line_height:[t.Number,1.2]},a.LineScalar={line_color:[t.ColorScalar,"black"],line_alpha:[t.NumberScalar,1],line_width:[t.NumberScalar,1],line_join:[t.LineJoinScalar,"bevel"],line_cap:[t.LineCapScalar,"butt"],line_dash:[t.ArrayScalar,[]],line_dash_offset:[t.NumberScalar,0]},a.FillScalar={fill_color:[t.ColorScalar,"gray"],fill_alpha:[t.NumberScalar,1]},a.HatchScalar={hatch_color:[t.ColorScalar,"black"],hatch_alpha:[t.NumberScalar,1],hatch_scale:[t.NumberScalar,12],hatch_pattern:[t.NullStringScalar,null],hatch_weight:[t.NumberScalar,1],hatch_extra:[t.AnyScalar,{}]},a.TextScalar={text_color:[t.ColorScalar,"#444444"],text_alpha:[t.NumberScalar,1],text_font:[t.Font,"helvetica"],text_font_size:[t.FontSizeScalar,"16px"],text_font_style:[t.FontStyleScalar,"normal"],text_align:[t.TextAlignScalar,"left"],text_baseline:[t.TextBaselineScalar,"bottom"],text_line_height:[t.NumberScalar,1.2]},a.LineVector={line_color:[t.ColorSpec,"black"],line_alpha:[t.NumberSpec,1],line_width:[t.NumberSpec,1],line_join:[t.LineJoinScalar,"bevel"],line_cap:[t.LineCapScalar,"butt"],line_dash:[t.ArrayScalar,[]],line_dash_offset:[t.NumberScalar,0]},a.FillVector={fill_color:[t.ColorSpec,"gray"],fill_alpha:[t.NumberSpec,1]},a.HatchVector={hatch_color:[t.ColorSpec,"black"],hatch_alpha:[t.NumberSpec,1],hatch_scale:[t.NumberSpec,12],hatch_pattern:[t.NullStringSpec,null],hatch_weight:[t.NumberSpec,1],hatch_extra:[t.AnyScalar,{}]},a.TextVector={text_color:[t.ColorSpec,"#444444"],text_alpha:[t.NumberSpec,1],text_font:[t.Font,"helvetica"],text_font_size:[t.FontSizeSpec,"16px"],text_font_style:[t.FontStyleScalar,"normal"],text_align:[t.TextAlignScalar,"left"],text_baseline:[t.TextBaselineScalar,"bottom"],text_line_height:[t.NumberScalar,1.2]}},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const n=t(22);function u(){const t=new Array(32);for(let e=0;e<32;e++)t[e]="0123456789ABCDEF".substr(Math.floor(16*Math.random()),1);return t[12]="4",t[16]="0123456789ABCDEF".substr(3&t[16].charCodeAt(0)|8,1),t.join("")}r.startsWith=function(t,e,r=0){return t.substr(r,e.length)==e},r.uuid4=u;let s=1e3;r.uniqueId=function(t){const e=n.settings.dev?"j"+s++:u();return null!=t?`${t}-${e}`:e},r.escape=function(t){return t.replace(/(?:[&<>"'`])/g,t=>{switch(t){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return t}})},r.unescape=function(t){return t.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,(t,e)=>{switch(e){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return e}})},r.use_strict=function(t){return"'use strict';\n"+t}},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const r=t(8),o=Object.prototype.toString;n.isEqual=function(t,e){return function t(e,n,c,u){if(e===n)return 0!==e||1/e==1/n;if(null==e||null==n)return e===n;const i=o.call(e);if(i!==o.call(n))return!1;switch(i){case"[object RegExp]":case"[object String]":return""+e==""+n;case"[object Number]":return+e!=+e?+n!=+n:0==+e?1/+e==1/n:+e==+n;case"[object Date]":case"[object Boolean]":return+e==+n}const s="[object Array]"===i;if(!s){if("object"!=typeof e||"object"!=typeof n)return!1;const t=e.constructor,o=n.constructor;if(t!==o&&!(r.isFunction(t)&&t instanceof t&&r.isFunction(o)&&o instanceof o)&&"constructor"in e&&"constructor"in n)return!1}u=u||[];let f=(c=c||[]).length;for(;f--;)if(c[f]===e)return u[f]===n;if(c.push(e),u.push(n),s){if(f=e.length,f!==n.length)return!1;for(;f--;)if(!t(e[f],n[f],c,u))return!1}else{const r=Object.keys(e);let o;if(f=r.length,Object.keys(n).length!==f)return!1;for(;f--;)if(o=r[f],!n.hasOwnProperty(o)||!t(e[o],n[o],c,u))return!1}return c.pop(),u.pop(),!0}(t,e)}},
function _(t,r,n){Object.defineProperty(n,"__esModule",{value:!0});const a=t(8),e=t(11),s=Symbol("__ndarray__");class i extends Uint8Array{constructor(t,r){super(t),this.__ndarray__=s,this.dtype="uint8",this.shape=null!=r?r:[this.length]}}n.Uint8NDArray=i,i.__name__="Uint8NDArray";class _ extends Int8Array{constructor(t,r){super(t),this.__ndarray__=s,this.dtype="int8",this.shape=null!=r?r:A(t)?t.shape:[this.length]}}n.Int8NDArray=_,_.__name__="Int8NDArray";class c extends Uint16Array{constructor(t,r){super(t),this.__ndarray__=s,this.dtype="uint16",this.shape=null!=r?r:A(t)?t.shape:[this.length]}}n.Uint16NDArray=c,c.__name__="Uint16NDArray";class h extends Int16Array{constructor(t,r){super(t),this.__ndarray__=s,this.dtype="int16",this.shape=null!=r?r:A(t)?t.shape:[this.length]}}n.Int16NDArray=h,h.__name__="Int16NDArray";class u extends Uint32Array{constructor(t,r){super(t),this.__ndarray__=s,this.dtype="uint32",this.shape=null!=r?r:A(t)?t.shape:[this.length]}}n.Uint32NDArray=u,u.__name__="Uint32NDArray";class y extends Int32Array{constructor(t,r){super(t),this.__ndarray__=s,this.dtype="int32",this.shape=null!=r?r:A(t)?t.shape:[this.length]}}n.Int32NDArray=y,y.__name__="Int32NDArray";class l extends Float32Array{constructor(t,r){super(t),this.__ndarray__=s,this.dtype="float32",this.shape=null!=r?r:A(t)?t.shape:[this.length]}}n.Float32NDArray=l,l.__name__="Float32NDArray";class o extends Float64Array{constructor(t,r){super(t),this.__ndarray__=s,this.dtype="float64",this.shape=null!=r?r:A(t)?t.shape:[this.length]}}function A(t){return a.isObject(t)&&t.__ndarray__==s}n.Float64NDArray=o,o.__name__="Float64NDArray",n.is_NDArray=A,n.ndarray=function(t,r={}){let{dtype:n}=r;null==n&&(n=t instanceof ArrayBuffer||a.isArray(t)?"float64":(()=>{switch(!0){case t instanceof Uint8Array:return"uint8";case t instanceof Int8Array:return"int8";case t instanceof Uint16Array:return"uint16";case t instanceof Int16Array:return"int16";case t instanceof Uint32Array:return"uint32";case t instanceof Int32Array:return"int32";case t instanceof Float32Array:return"float32";case t instanceof Float64Array:return"float64";default:e.unreachable()}})());const{shape:s}=r;switch(n){case"uint8":return new i(t,s);case"int8":return new _(t,s);case"uint16":return new c(t,s);case"int16":return new h(t,s);case"uint32":return new u(t,s);case"int32":return new y(t,s);case"float32":return new l(t,s);case"float64":return new o(t,s)}}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1),a=e(8),f=e(28),_=n.__importStar(e(26));function o(e){const r=new Uint8Array(e),t=Array.from(r).map(e=>String.fromCharCode(e));return btoa(t.join(""))}function s(e){const r=atob(e),t=r.length,n=new Uint8Array(t);for(let e=0,a=t;e<a;e++)n[e]=r.charCodeAt(e);return n.buffer}function i(e){const r=new Uint8Array(e.buffer,e.byteOffset,2*e.length);for(let e=0,t=r.length;e<t;e+=2){const t=r[e];r[e]=r[e+1],r[e+1]=t}}function u(e){const r=new Uint8Array(e.buffer,e.byteOffset,4*e.length);for(let e=0,t=r.length;e<t;e+=4){let t=r[e];r[e]=r[e+3],r[e+3]=t,t=r[e+1],r[e+1]=r[e+2],r[e+2]=t}}function c(e){const r=new Uint8Array(e.buffer,e.byteOffset,8*e.length);for(let e=0,t=r.length;e<t;e+=8){let t=r[e];r[e]=r[e+7],r[e+7]=t,t=r[e+1],r[e+1]=r[e+6],r[e+6]=t,t=r[e+2],r[e+2]=r[e+5],r[e+5]=t,t=r[e+3],r[e+3]=r[e+4],r[e+4]=t}}t.buffer_to_base64=o,t.base64_to_buffer=s,t.BYTE_ORDER=f.is_little_endian?"little":"big",t.swap16=i,t.swap32=u,t.swap64=c,t.is_NDArray_ref=function(e){return a.isPlainObject(e)&&("__buffer__"in e||"__ndarray__"in e)},t.decode_NDArray=function(e,r){const{shape:n,dtype:a,order:f}=e;let o;if("__buffer__"in e){const t=r.get(e.__buffer__);if(null==t)throw new Error(`buffer for ${e.__buffer__} not found`);o=t}else o=s(e.__ndarray__);const l=(()=>{switch(a){case"uint8":return new _.Uint8NDArray(o,n);case"int8":return new _.Int8NDArray(o,n);case"uint16":return new _.Uint16NDArray(o,n);case"int16":return new _.Int16NDArray(o,n);case"uint32":return new _.Uint32NDArray(o,n);case"int32":return new _.Int32NDArray(o,n);case"float32":return new _.Float32NDArray(o,n);case"float64":return new _.Float64NDArray(o,n)}})();if(f!==t.BYTE_ORDER)switch(l.BYTES_PER_ELEMENT){case 2:i(l);break;case 4:u(l);break;case 8:c(l)}return l},t.encode_NDArray=function(e,r){const n={order:t.BYTE_ORDER,dtype:e.dtype,shape:e.shape};if(null!=r){const t=""+r.size;return r.set(t,e.buffer),Object.assign({__buffer__:t},n)}{const r=o(e.buffer);return Object.assign({__ndarray__:r},n)}}},
function _(e,n,i){Object.defineProperty(i,"__esModule",{value:!0}),i.is_ie=(()=>{const e="undefined"!=typeof navigator?navigator.userAgent:"";return e.indexOf("MSIE")>=0||e.indexOf("Trident")>0||e.indexOf("Edge")>0})(),i.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),i.is_little_endian=(()=>{const e=new ArrayBuffer(4),n=new Uint8Array(e);new Uint32Array(e)[1]=168496141;let i=!0;return 10==n[4]&&11==n[5]&&12==n[6]&&13==n[7]&&(i=!1),i})()},
function _(t,_,r){Object.defineProperty(r,"__esModule",{value:!0});const e=t(1);e.__exportStar(t(30),r),e.__exportStar(t(149),r),e.__exportStar(t(176),r),e.__exportStar(t(180),r),e.__exportStar(t(194),r),e.__exportStar(t(198),r),e.__exportStar(t(204),r),e.__exportStar(t(208),r),e.__exportStar(t(238),r),e.__exportStar(t(241),r),e.__exportStar(t(243),r),e.__exportStar(t(260),r),e.__exportStar(t(123),r),e.__exportStar(t(266),r),e.__exportStar(t(270),r),e.__exportStar(t(297),r),e.__exportStar(t(298),r),e.__exportStar(t(299),r),e.__exportStar(t(300),r),e.__exportStar(t(301),r),e.__exportStar(t(306),r),e.__exportStar(t(308),r),e.__exportStar(t(319),r),e.__exportStar(t(323),r)},
function _(a,e,o){Object.defineProperty(o,"__esModule",{value:!0});var r=a(31);o.Annotation=r.Annotation;var n=a(74);o.Arrow=n.Arrow;var t=a(75);o.ArrowHead=t.ArrowHead;var v=a(75);o.OpenHead=v.OpenHead;var l=a(75);o.NormalHead=l.NormalHead;var d=a(75);o.TeeHead=d.TeeHead;var i=a(75);o.VeeHead=i.VeeHead;var A=a(106);o.Band=A.Band;var H=a(107);o.BoxAnnotation=H.BoxAnnotation;var T=a(108);o.ColorBar=T.ColorBar;var p=a(133);o.Label=p.Label;var L=a(135);o.LabelSet=L.LabelSet;var b=a(136);o.Legend=b.Legend;var B=a(137);o.LegendItem=B.LegendItem;var S=a(139);o.PolyAnnotation=S.PolyAnnotation;var P=a(140);o.Slope=P.Slope;var g=a(141);o.Span=g.Span;var m=a(134);o.TextAnnotation=m.TextAnnotation;var w=a(142);o.Title=w.Title;var x=a(143);o.ToolbarPanel=x.ToolbarPanel;var s=a(144);o.Tooltip=s.Tooltip;var u=a(148);o.Whisker=u.Whisker},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const n=t(1),i=n.__importStar(t(32)),o=t(17),_=t(65),a=n.__importDefault(t(73));class r extends _.RendererView{get panel(){return this.layout}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.visible,()=>this.plot_view.request_layout())}styles(){return[...super.styles(),a.default]}get_size(){if(this.model.visible){const{width:t,height:e}=this._get_size();return{width:Math.round(t),height:Math.round(e)}}return{width:0,height:0}}_get_size(){throw new Error("not implemented")}set_data(t){const e=this.model.materialize_dataspecs(t);if(o.extend(this,e),this.plot_model.use_map){const t=this;null!=t._x&&([t._x,t._y]=i.project_xy(t._x,t._y)),null!=t._xs&&([t._xs,t._ys]=i.project_xsys(t._xs,t._ys))}}get needs_clip(){return null==this.layout}serializable_state(){const t=super.serializable_state();return null==this.layout?t:Object.assign(Object.assign({},t),{bbox:this.layout.bbox.box})}}s.AnnotationView=r,r.__name__="AnnotationView";class l extends _.Renderer{constructor(t){super(t)}static init_Annotation(){this.override({level:"annotation"})}}s.Annotation=l,l.__name__="Annotation",l.init_Annotation()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});const r=t(1),o=r.__importDefault(t(33)),a=r.__importDefault(t(34)),c=new a.default("GOOGLE"),l=new a.default("WGS84");e.wgs84_mercator=o.default(l,c);const u={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},f={lon:[-180,180],lat:[-85.06,85.06]};function s(t,n){const r=Math.min(t.length,n.length),o=new Array(r),a=new Array(r);for(let c=0;c<r;c++){const[r,l]=e.wgs84_mercator.forward([t[c],n[c]]);o[c]=r,a[c]=l}return[o,a]}e.clip_mercator=function(t,n,e){const[r,o]=u[e];return[Math.max(t,r),Math.min(n,o)]},e.in_bounds=function(t,n){const[e,r]=f[n];return e<t&&t<r},e.project_xy=s,e.project_xsys=function(t,n){const e=Math.min(t.length,n.length),r=new Array(e),o=new Array(e);for(let a=0;a<e;a++){const[e,c]=s(t[a],n[a]);r[a]=e,o[a]=c}return[r,o]}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const r=e(1),o=r.__importDefault(e(34)),a=r.__importDefault(e(59));var i=o.default("WGS84");function c(e,n,t){var r,o,i;return Array.isArray(t)?(r=a.default(e,n,t)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof r.z?[r.x,r.y,r.z].concat(t.splice(3)):[r.x,r.y,t[2]].concat(t.splice(3)):[r.x,r.y].concat(t.splice(2)):[r.x,r.y]):(o=a.default(e,n,t),2===(i=Object.keys(t)).length||i.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;o[r]=t[r]})),o)}function u(e){return e instanceof o.default?e:e.oProj?e.oProj:o.default(e)}t.default=function(e,n,t){e=u(e);var r,o=!1;return void 0===n?(n=e,e=i,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=i,o=!0),n=u(n),t?c(e,n,t):(r={forward:function(t){return c(e,n,t)},inverse:function(t){return c(n,e,t)}},o&&(r.oProj=n),r)}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const s=e(1),i=s.__importDefault(e(35)),u=s.__importDefault(e(46)),l=s.__importDefault(e(47)),o=e(55),r=s.__importDefault(e(57)),f=s.__importDefault(e(58)),d=s.__importDefault(e(42));function p(e,t){if(!(this instanceof p))return new p(e);t=t||function(e){if(e)throw e};var a=i.default(e);if("object"==typeof a){var s=p.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var l=d.default(r.default,a.datumCode);l&&(a.datum_params=l.towgs84?l.towgs84.split(","):null,a.ellps=l.ellipse,a.datumName=l.datumName?l.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84";var m=o.sphere(a.a,a.b,a.rf,a.ellps,a.sphere),n=o.eccentricity(m.a,m.b,m.rf,a.R_A),h=a.datum||f.default(a.datumCode,a.datum_params,m.a,m.b,n.es,n.ep2);u.default(this,a),u.default(this,s),this.a=m.a,this.b=m.b,this.rf=m.rf,this.sphere=m.sphere,this.es=n.es,this.e=n.e,this.ep2=n.ep2,this.datum=h,this.init(),t(null,this)}else t(e)}else t(e)}p.projections=l.default,p.projections.start(),a.default=p},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const u=t(1),n=u.__importDefault(t(36)),f=u.__importDefault(t(43)),i=u.__importDefault(t(38)),a=u.__importDefault(t(42));var o=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var l=["3857","900913","3785","102113"];r.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in n.default}(t))return n.default[t];if(function(t){return o.some((function(e){return t.indexOf(e)>-1}))}(t)){var e=f.default(t);if(function(t){var e=a.default(t,"authority");if(e){var r=a.default(e,"epsg");return r&&l.indexOf(r)>-1}}(e))return n.default["EPSG:3857"];var r=function(t){var e=a.default(t,"extension");if(e)return a.default(e,"proj4")}(e);return r?i.default(r):e}return function(t){return"+"===t[0]}(t)?i.default(t):void 0}},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const i=t(1),n=i.__importDefault(t(37)),f=i.__importDefault(t(38)),a=i.__importDefault(t(43));function l(t){var e=this;if(2===arguments.length){var r=arguments[1];"string"==typeof r?"+"===r.charAt(0)?l[t]=f.default(arguments[1]):l[t]=a.default(arguments[1]):l[t]=r}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?l.apply(e,t):l(t)}));if("string"==typeof t){if(t in l)return l[t]}else"EPSG"in t?l["EPSG:"+t.EPSG]=t:"ESRI"in t?l["ESRI:"+t.ESRI]=t:"IAU2000"in t?l["IAU2000:"+t.IAU2000]=t:console.log(t);return}}n.default(l),r.default=l},
function _(e,t,l){Object.defineProperty(l,"__esModule",{value:!0}),l.default=function(e){e("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),e("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),e("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),e.WGS84=e["EPSG:4326"],e["EPSG:3785"]=e["EPSG:3857"],e.GOOGLE=e["EPSG:3857"],e["EPSG:900913"]=e["EPSG:3857"],e["EPSG:102113"]=e["EPSG:3857"]}},
function _(t,n,o){Object.defineProperty(o,"__esModule",{value:!0});const e=t(1),a=t(39),u=e.__importDefault(t(40)),r=e.__importDefault(t(41)),i=e.__importDefault(t(42));o.default=function(t){var n,o,e,f={},l=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){f.rf=parseFloat(t)},lat_0:function(t){f.lat0=t*a.D2R},lat_1:function(t){f.lat1=t*a.D2R},lat_2:function(t){f.lat2=t*a.D2R},lat_ts:function(t){f.lat_ts=t*a.D2R},lon_0:function(t){f.long0=t*a.D2R},lon_1:function(t){f.long1=t*a.D2R},lon_2:function(t){f.long2=t*a.D2R},alpha:function(t){f.alpha=parseFloat(t)*a.D2R},lonc:function(t){f.longc=t*a.D2R},x_0:function(t){f.x0=parseFloat(t)},y_0:function(t){f.y0=parseFloat(t)},k_0:function(t){f.k0=parseFloat(t)},k:function(t){f.k0=parseFloat(t)},a:function(t){f.a=parseFloat(t)},b:function(t){f.b=parseFloat(t)},r_a:function(){f.R_A=!0},zone:function(t){f.zone=parseInt(t,10)},south:function(){f.utmSouth=!0},towgs84:function(t){f.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){f.to_meter=parseFloat(t)},units:function(t){f.units=t;var n=i.default(r.default,t);n&&(f.to_meter=n.to_meter)},from_greenwich:function(t){f.from_greenwich=t*a.D2R},pm:function(t){var n=i.default(u.default,t);f.from_greenwich=(n||parseFloat(t))*a.D2R},nadgrids:function(t){"@null"===t?f.datumCode="none":f.nadgrids=t},axis:function(t){3===t.length&&-1!=="ewnsud".indexOf(t.substr(0,1))&&-1!=="ewnsud".indexOf(t.substr(1,1))&&-1!=="ewnsud".indexOf(t.substr(2,1))&&(f.axis=t)}};for(n in l)o=l[n],n in c?"function"==typeof(e=c[n])?e(o):f[e]=o:f[n]=o;return"string"==typeof f.datumCode&&"WGS84"!==f.datumCode&&(f.datumCode=f.datumCode.toLowerCase()),f}},
function _(P,_,e){Object.defineProperty(e,"__esModule",{value:!0}),e.PJD_3PARAM=1,e.PJD_7PARAM=2,e.PJD_WGS84=4,e.PJD_NODATUM=5,e.SEC_TO_RAD=484813681109536e-20,e.HALF_PI=Math.PI/2,e.SIXTH=.16666666666666666,e.RA4=.04722222222222222,e.RA6=.022156084656084655,e.EPSLN=1e-10,e.D2R=.017453292519943295,e.R2D=57.29577951308232,e.FORTPI=Math.PI/4,e.TWO_PI=2*Math.PI,e.SPI=3.14159265359},
function _(e,o,r){Object.defineProperty(r,"__esModule",{value:!0});var a={};r.default=a,a.greenwich=0,a.lisbon=-9.131906111111,a.paris=2.337229166667,a.bogota=-74.080916666667,a.madrid=-3.687938888889,a.rome=12.452333333333,a.bern=7.439583333333,a.jakarta=106.807719444444,a.ferro=-17.666666666667,a.brussels=4.367975,a.stockholm=18.058277777778,a.athens=23.7163375,a.oslo=10.722916666667},
function _(e,t,f){Object.defineProperty(f,"__esModule",{value:!0}),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const o=e(1);const d=o.__importDefault(e(44)),r=e(45);function n(e){return.017453292519943295*e}a.default=function(e){var t=d.default(e),a=t.shift(),o=t.shift();t.unshift(["name",o]),t.unshift(["type",a]);var l={};return r.sExpr(t,l),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var t="",a=0,o=e.AXIS.length;a<o;++a){var d=e.AXIS[a][0].toLowerCase();-1!==d.indexOf("north")?t+="n":-1!==d.indexOf("south")?t+="s":-1!==d.indexOf("east")?t+="e":-1!==d.indexOf("west")&&(t+="w")}2===t.length&&(t+="u"),3===t.length&&(e.axis=t)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function l(t){return t*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",n],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",n],["x0","false_easting",l],["y0","false_northing",l],["long0","central_meridian",n],["lat0","latitude_of_origin",n],["lat0","standard_parallel_1",n],["lat1","standard_parallel_1",n],["lat2","standard_parallel_2",n],["azimuth","Azimuth"],["alpha","azimuth",n],["srsCode","name"]].forEach((function(t){return a=e,d=(o=t)[0],r=o[1],void(!(d in a)&&r in a&&(a[d]=a[r],3===o.length&&(a[d]=o[2](a[d]))));var a,o,d,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=n(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(l),l}},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=function(t){return new a(t).output()};var i=/\s/,s=/[A-Za-z]/,h=/[A-Za-z84]/,o=/[,\]]/,n=/[\d\.E\-\+]/;function a(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}a.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;i.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},a.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(o.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},a.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},a.prototype.number=function(t){if(!n.test(t)){if(o.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},a.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},a.prototype.keyword=function(t){if(h.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=1)}if(!o.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},a.prototype.neutral=function(t){if(s.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(n.test(t))return this.word=t,void(this.state=3);if(!o.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},a.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,r,a){function s(e,r,a){Array.isArray(r)&&(a.unshift(r),r=null);var s=r?{}:e,n=a.reduce((function(e,r){return c(r,e),e}),s);r&&(e[r]=n)}function c(e,r){if(Array.isArray(e)){var a=e.shift();if("PARAMETER"===a&&(a=e.shift()),1===e.length)return Array.isArray(e[0])?(r[a]={},void c(e[0],r[a])):void(r[a]=e[0]);if(e.length)if("TOWGS84"!==a){if("AXIS"===a)return a in r||(r[a]=[]),void r[a].push(e);var n;switch(Array.isArray(a)||(r[a]={}),a){case"UNIT":case"PRIMEM":case"VERT_DATUM":return r[a]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&c(e[2],r[a]));case"SPHEROID":case"ELLIPSOID":return r[a]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&c(e[3],r[a]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void s(r,a,e);default:for(n=-1;++n<e.length;)if(!Array.isArray(e[n]))return c(e,r[a]);return s(r,a,e)}}else r[a]=e;else r[a]=!0}else r[e]=!0}Object.defineProperty(a,"__esModule",{value:!0}),a.sExpr=c},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=function(e,n){var r,t;if(e=e||{},!n)return e;for(t in n)void 0!==(r=n[t])&&(e[t]=r);return e}},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});const a=t(1),n=a.__importDefault(t(48)),r=a.__importDefault(t(54));var u=[n.default,r.default],f={},i=[];function d(t,e){var o=i.length;return t.names?(i[o]=t,t.names.forEach((function(t){f[t.toLowerCase()]=o})),this):(console.log(e),!0)}function c(t){if(!t)return!1;var e=t.toLowerCase();return void 0!==f[e]&&i[f[e]]?i[f[e]]:void 0}function l(){u.forEach(d)}o.add=d,o.get=c,o.start=l,o.default={start:l,add:d,get:c}},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});const h=t(1),a=h.__importDefault(t(49)),e=h.__importDefault(t(50)),r=h.__importDefault(t(52)),n=h.__importDefault(t(53)),l=t(39);function u(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=a.default(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function o(t){var i,s,h=t.x,a=t.y;if(a*l.R2D>90&&a*l.R2D<-90&&h*l.R2D>180&&h*l.R2D<-180)return null;if(Math.abs(Math.abs(a)-l.HALF_PI)<=l.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*e.default(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(l.FORTPI+.5*a));else{var n=Math.sin(a),u=r.default(this.e,a,n);i=this.x0+this.a*this.k0*e.default(h-this.long0),s=this.y0-this.a*this.k0*Math.log(u)}return t.x=i,t.y=s,t}function f(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=l.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var r=Math.exp(-a/(this.a*this.k0));if(-9999===(s=n.default(this.e,r)))return null}return i=e.default(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=u,s.forward=o,s.inverse=f,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:u,forward:o,inverse:f,names:s.names}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e,t,n){var r=e*t;return n/Math.sqrt(1-r*r)}},
function _(e,t,u){Object.defineProperty(u,"__esModule",{value:!0});const n=e(1),a=e(39),f=n.__importDefault(e(51));u.default=function(e){return Math.abs(e)<=a.SPI?e:e-f.default(e)*a.TWO_PI}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){return e<0?-1:1}},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const a=t(39);n.default=function(t,e,n){var o=t*n,u=.5*t;return o=Math.pow((1-o)/(1+o),u),Math.tan(.5*(a.HALF_PI-e))/o}},
function _(t,a,e){Object.defineProperty(e,"__esModule",{value:!0});const n=t(39);e.default=function(t,a){for(var e,r,o=.5*t,u=n.HALF_PI-2*Math.atan(a),f=0;f<=15;f++)if(e=t*Math.sin(u),u+=r=n.HALF_PI-2*Math.atan(a*Math.pow((1-e)/(1+e),o))-u,Math.abs(r)<=1e-10)return u;return-9999}},
function _(e,n,i){function t(){}function r(e){return e}Object.defineProperty(i,"__esModule",{value:!0}),i.init=t,i.forward=r,i.inverse=r,i.names=["longlat","identity"],i.default={init:t,forward:r,inverse:r,names:i.names}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const a=e(1),n=e(39),f=a.__importStar(e(56)),u=a.__importDefault(e(42));r.eccentricity=function(e,t,r,a){var f=e*e,u=t*t,i=(f-u)/f,c=0;return a?(f=(e*=1-i*(n.SIXTH+i*(n.RA4+i*n.RA6)))*e,i=0):c=Math.sqrt(i),{es:i,e:c,ep2:(f-u)/u}},r.sphere=function(e,t,r,a,i){if(!e){var c=u.default(f.default,a);c||(c=f.WGS84),e=c.a,t=c.b,r=c.rf}return r&&!t&&(t=(1-1/r)*e),(0===r||Math.abs(e-t)<n.EPSLN)&&(i=!0,t=e),{a:e,b:t,rf:r,sphere:i}}},
function _(e,a,l){Object.defineProperty(l,"__esModule",{value:!0});var s={};l.default=s,s.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},s.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},s.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},s.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},s.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},s.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},s.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},s.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},s.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},s.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},s.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},s.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},s.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},s.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},s.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},s.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},s.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},s.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},s.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},s.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},s.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},s.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},s.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},s.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},s.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},s.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},s.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},s.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},s.hough={a:6378270,rf:297,ellipseName:"Hough"},s.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},s.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},s.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},s.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},s.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},s.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},s.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},s.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},s.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},s.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},s.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},s.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=s.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},s.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s){Object.defineProperty(s,"__esModule",{value:!0});var t={};s.default=t,t.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},t.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},t.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},t.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},t.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},t.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},t.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},t.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},t.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},t.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},t.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},t.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},t.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},t.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},t.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},t.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},t.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_){Object.defineProperty(_,"__esModule",{value:!0});const t=a(39);_.default=function(a,m,_,u,d,p){var r={};return r.datum_type=void 0===a||"none"===a?t.PJD_NODATUM:t.PJD_WGS84,m&&(r.datum_params=m.map(parseFloat),0===r.datum_params[0]&&0===r.datum_params[1]&&0===r.datum_params[2]||(r.datum_type=t.PJD_3PARAM),r.datum_params.length>3&&(0===r.datum_params[3]&&0===r.datum_params[4]&&0===r.datum_params[5]&&0===r.datum_params[6]||(r.datum_type=t.PJD_7PARAM,r.datum_params[3]*=t.SEC_TO_RAD,r.datum_params[4]*=t.SEC_TO_RAD,r.datum_params[5]*=t.SEC_TO_RAD,r.datum_params[6]=r.datum_params[6]/1e6+1))),r.a=_,r.b=u,r.es=d,r.ep2=p,r}},
function _(t,e,a){Object.defineProperty(a,"__esModule",{value:!0});const r=t(1),u=t(39),m=r.__importDefault(t(60)),_=r.__importDefault(t(62)),o=r.__importDefault(t(34)),d=r.__importDefault(t(63)),f=r.__importDefault(t(64));a.default=function t(e,a,r){var n;return Array.isArray(r)&&(r=d.default(r)),f.default(r),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===u.PJD_3PARAM||t.datum.datum_type===u.PJD_7PARAM)&&"WGS84"!==e.datumCode||(e.datum.datum_type===u.PJD_3PARAM||e.datum.datum_type===u.PJD_7PARAM)&&"WGS84"!==t.datumCode}(e,a)&&(r=t(e,n=new o.default("WGS84"),r),e=n),"enu"!==e.axis&&(r=_.default(e,!1,r)),"longlat"===e.projName?r={x:r.x*u.D2R,y:r.y*u.D2R,z:r.z||0}:(e.to_meter&&(r={x:r.x*e.to_meter,y:r.y*e.to_meter,z:r.z||0}),r=e.inverse(r)),e.from_greenwich&&(r.x+=e.from_greenwich),r=m.default(e.datum,a.datum,r),a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0}),"longlat"===a.projName?r={x:r.x*u.R2D,y:r.y*u.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0})),"enu"!==a.axis?_.default(a,!0,r):r}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const u=e(39),o=e(61);function _(e){return e===u.PJD_3PARAM||e===u.PJD_7PARAM}a.default=function(e,t,a){return o.compareDatums(e,t)||e.datum_type===u.PJD_NODATUM||t.datum_type===u.PJD_NODATUM?a:e.es!==t.es||e.a!==t.a||_(e.datum_type)||_(t.datum_type)?(a=o.geodeticToGeocentric(a,e.es,e.a),_(e.datum_type)&&(a=o.geocentricToWgs84(a,e.datum_type,e.datum_params)),_(t.datum_type)&&(a=o.geocentricFromWgs84(a,t.datum_type,t.datum_params)),o.geocentricToGeodetic(a,t.es,t.a,t.b)):a}},
function _(a,t,r){Object.defineProperty(r,"__esModule",{value:!0});const e=a(39);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===e.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==e.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,u,s,_,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-e.HALF_PI&&d>-1.001*e.HALF_PI)d=-e.HALF_PI;else if(d>e.HALF_PI&&d<1.001*e.HALF_PI)d=e.HALF_PI;else{if(d<-e.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>e.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),u=Math.sin(d),_=Math.cos(d),s=u*u,{x:((m=r/Math.sqrt(1-t*s))+i)*_*Math.cos(n),y:(m+i)*_*Math.sin(n),z:(m*(1-t)+i)*u}},r.geocentricToGeodetic=function(a,t,r,m){var u,s,_,n,d,i,p,P,o,y,M,z,c,A,x,f=a.x,h=a.y,I=a.z?a.z:0;if(u=Math.sqrt(f*f+h*h),s=Math.sqrt(f*f+h*h+I*I),u/r<1e-12){if(A=0,s/r<1e-12)return e.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else A=Math.atan2(h,f);_=I/s,P=(n=u/s)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),o=_*d,c=0;do{c++,i=t*(p=r/Math.sqrt(1-t*o*o))/(p+(x=u*P+I*o-p*(1-t*o*o))),z=(M=_*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(y=n*(1-i)*d)*o,P=y,o=M}while(z*z>1e-24&&c<30);return{x:A,y:Math.atan(M/Math.abs(y)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===e.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===e.PJD_7PARAM){var m=r[0],u=r[1],s=r[2],_=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-_*a.z)+u,z:i*(-n*a.x+_*a.y+a.z)+s}}},r.geocentricFromWgs84=function(a,t,r){if(t===e.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===e.PJD_7PARAM){var m=r[0],u=r[1],s=r[2],_=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-u)/i,o=(a.z-s)/i;return{x:p+d*P-n*o,y:-d*p+P+_*o,z:n*p-_*P+o}}}},
function _(e,a,i){Object.defineProperty(i,"__esModule",{value:!0}),i.default=function(e,a,i){var s,n,r,c=i.x,d=i.y,u=i.z||0,f={};for(r=0;r<3;r++)if(!a||2!==r||void 0!==i.z)switch(0===r?(s=c,n=-1!=="ew".indexOf(e.axis[r])?"x":"y"):1===r?(s=d,n=-1!=="ns".indexOf(e.axis[r])?"y":"x"):(s=u,n="z"),e.axis[r]){case"e":case"w":case"n":case"s":f[n]=s;break;case"u":void 0!==i[n]&&(f.z=s);break;case"d":void 0!==i[n]&&(f.z=-s);break;default:return null}return f}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var n={x:e[0],y:e[1]};return e.length>2&&(n.z=e[2]),e.length>3&&(n.m=e[3]),n}},
function _(e,i,n){function t(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e){t(e.x),t(e.y)}},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const r=e(1),n=e(66),s=r.__importStar(e(70)),_=r.__importStar(e(18)),l=e(71);class o extends n.DOMView{initialize(){super.initialize(),this.visuals=new s.Visuals(this.model),this._has_finished=!0}get plot_view(){return this.parent}get plot_model(){return this.parent.model}get layer(){const{canvas_view:e}=this.plot_view;return"overlay"==this.model.level?e.overlays:e.primary}request_render(){this.plot_view.request_render()}map_to_screen(e,t){return this.plot_view.map_to_screen(e,t,this.model.x_range_name,this.model.y_range_name)}get needs_clip(){return!1}notify_finished(){this.plot_view.notify_finished()}get has_webgl(){return!1}}i.RendererView=o,o.__name__="RendererView";class a extends l.Model{constructor(e){super(e)}static init_Renderer(){this.define({level:[_.RenderLevel],visible:[_.Boolean,!0]})}}i.Renderer=a,a.__name__="Renderer",a.init_Renderer()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(67),h=e(68),n=i.__importStar(e(68)),l=i.__importDefault(e(69));class _ extends r.View{initialize(){super.initialize(),this._has_finished=!1,this.is_root&&(this._stylesheet=h.stylesheet),this._inject_styles(),this.el=this._createElement()}remove(){n.removeElement(this.el),super.remove()}css_classes(){return[]}styles(){return[l.default]}cursor(e,t){return null}render(){}renderTo(e){e.appendChild(this.el),this.render()}has_finished(){return this._has_finished}get is_idle(){return this.has_finished()}get stylesheet(){return this.is_root?this._stylesheet:this.root.stylesheet}_inject_styles(){const{stylesheet:e}=this;for(const t of this.styles())e.append(t)}_createElement(){return n.createElement(this.tagName,{class:this.css_classes()})}}s.DOMView=_,_.__name__="DOMView",_.prototype.tagName="div"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const r=t(14),n=t(8);class o{constructor(t){if(this.removed=new r.Signal0(this,"removed"),this._ready=Promise.resolve(void 0),null==t.model)throw new Error("model of a view wasn't configured");this.model=t.model,this._parent=t.parent}get ready(){return this._ready}connect(t,e){return t.connect((t,i)=>{const r=Promise.resolve(e.call(this,t,i));this._ready=this._ready.then(()=>r)},this)}disconnect(t,e){return t.disconnect(e,this)}initialize(){}async lazy_initialize(){}remove(){this._parent=void 0,this.disconnect_signals(),this.removed.emit()}toString(){return`${this.model.type}View(${this.model.id})`}serializable_state(){return{type:this.model.type}}get parent(){if(void 0!==this._parent)return this._parent;throw new Error("parent of a view wasn't configured")}get is_root(){return null===this.parent}get root(){return this.is_root?this:this.parent.root}assert_root(){if(!this.is_root)throw new Error(this.toString()+" is not a root layout")}connect_signals(){}disconnect_signals(){r.Signal.disconnectReceiver(this)}on_change(t,e){for(const i of n.isArray(t)?t:[t])this.connect(i.change,e)}}i.View=o,o.__name__="View"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const i=t(8),o=t=>(e={},...n)=>{const o=document.createElement(t);o.classList.add("bk");for(const t in e){let n=e[t];if(null!=n&&(!i.isBoolean(n)||n))if("class"===t&&(i.isString(n)&&(n=n.split(/\s+/)),i.isArray(n)))for(const t of n)null!=t&&o.classList.add(t);else if("style"===t&&i.isPlainObject(n))for(const t in n)o.style[t]=n[t];else if("data"===t&&i.isPlainObject(n))for(const t in n)o.dataset[t]=n[t];else o.setAttribute(t,n)}function s(t){if(t instanceof Element)o.appendChild(t);else if(i.isString(t))o.appendChild(document.createTextNode(t));else if(null!=t&&!1!==t)throw new Error("expected a DOM element, string, false or null, got "+JSON.stringify(t))}for(const t of n)if(i.isArray(t))for(const e of t)s(e);else s(t);return o};function s(t){const e=t.parentNode;null!=e&&e.removeChild(t)}function l(t,...e){const n=t.firstChild;for(const i of e)t.insertBefore(i,n)}function r(t,e){const n=Element.prototype;return(n.matches||n.webkitMatchesSelector||n.mozMatchesSelector||n.msMatchesSelector).call(t,e)}function a(t){return parseFloat(t)||0}function c(t){const e=getComputedStyle(t);return{border:{top:a(e.borderTopWidth),bottom:a(e.borderBottomWidth),left:a(e.borderLeftWidth),right:a(e.borderRightWidth)},margin:{top:a(e.marginTop),bottom:a(e.marginBottom),left:a(e.marginLeft),right:a(e.marginRight)},padding:{top:a(e.paddingTop),bottom:a(e.paddingBottom),left:a(e.paddingLeft),right:a(e.paddingRight)}}}function h(t){const e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}n.createElement=function(t,e,...n){return o(t)(e,...n)},n.div=o("div"),n.span=o("span"),n.canvas=o("canvas"),n.link=o("link"),n.style=o("style"),n.a=o("a"),n.p=o("p"),n.i=o("i"),n.pre=o("pre"),n.button=o("button"),n.label=o("label"),n.input=o("input"),n.select=o("select"),n.option=o("option"),n.optgroup=o("optgroup"),n.textarea=o("textarea"),n.nbsp=function(){return document.createTextNode(" ")},n.append=function(t,...e){for(const n of e)t.appendChild(n)},n.remove=s,n.removeElement=s,n.replaceWith=function(t,e){const n=t.parentNode;null!=n&&n.replaceChild(e,t)},n.prepend=l,n.empty=function(t,e=!1){let n;for(;n=t.firstChild;)t.removeChild(n);if(e)for(const e of t.attributes)t.removeAttributeNode(e)},n.display=function(t){t.style.display=""},n.undisplay=function(t){t.style.display="none"},n.show=function(t){t.style.visibility=""},n.hide=function(t){t.style.visibility="hidden"},n.offset=function(t){const e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},n.matches=r,n.parent=function(t,e){let n=t;for(;n=n.parentElement;)if(r(n,e))return n;return null},n.extents=c,n.size=h,n.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},n.outer_size=function(t){const{margin:{left:e,right:n,top:i,bottom:o}}=c(t),{width:s,height:l}=h(t);return{width:Math.ceil(s+e+n),height:Math.ceil(l+i+o)}},n.content_size=function(t){const{left:e,top:n}=t.getBoundingClientRect(),{padding:i}=c(t);let o=0,s=0;for(const l of t.children){const t=l.getBoundingClientRect();o=Math.max(o,Math.ceil(t.left-e-i.left+t.width)),s=Math.max(s,Math.ceil(t.top-n-i.top+t.height))}return{width:o,height:s}},n.position=function(t,e,n){const{style:i}=t;if(i.left=e.x+"px",i.top=e.y+"px",i.width=e.width+"px",i.height=e.height+"px",null==n)i.margin="";else{const{top:t,right:e,bottom:o,left:s}=n;i.margin=`${t}px ${e}px ${o}px ${s}px`}},n.children=function(t){return Array.from(t.children)};class d{constructor(t){this.el=t,this.classList=t.classList}get values(){const t=[];for(let e=0;e<this.classList.length;e++){const n=this.classList.item(e);null!=n&&t.push(n)}return t}has(t){return this.classList.contains(t)}add(...t){for(const e of t)this.classList.add(e);return this}remove(...t){for(const e of t)this.classList.remove(e);return this}clear(){for(const t of this.values)"bk"!=t&&this.classList.remove(t);return this}toggle(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this}}var u;function f(t,e,n){const{width:i,height:o,position:s,display:l}=t.style;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?e.width+"px":"auto",t.style.height=null!=e.height&&e.height!=1/0?e.height+"px":"auto";try{return n()}finally{t.style.position=s,t.style.display=l,t.style.width=i,t.style.height=o}}n.ClassList=d,d.__name__="ClassList",n.classes=function(t){return new d(t)},n.toggle_attribute=function(t,e,n){null==n&&(n=!t.hasAttribute(e)),n?t.setAttribute(e,"true"):t.removeAttribute(e)},(u=n.Keys||(n.Keys={}))[u.Backspace=8]="Backspace",u[u.Tab=9]="Tab",u[u.Enter=13]="Enter",u[u.Esc=27]="Esc",u[u.PageUp=33]="PageUp",u[u.PageDown=34]="PageDown",u[u.Left=37]="Left",u[u.Up=38]="Up",u[u.Right=39]="Right",u[u.Down=40]="Down",u[u.Delete=46]="Delete",n.undisplayed=function(t,e){const{display:n}=t.style;t.style.display="none";try{return e()}finally{t.style.display=n}},n.unsized=function(t,e){return f(t,{},e)},n.sized=f;class p{constructor(t){this.root=t,this.known=new Set,this.style=n.style({type:"text/css"}),l(t,this.style)}append(t){this.known.has(t)||(this.style.appendChild(document.createTextNode(t)),this.known.add(t))}}n.StyleSheet=p,p.__name__="StyleSheet",n.stylesheet=new p(document.head)},
function _(n,o,e){Object.defineProperty(e,"__esModule",{value:!0});e.default="\n.bk-root {\n  position: relative;\n  width: auto;\n  height: auto;\n  z-index: 0;\n  box-sizing: border-box;\n  font-family: Helvetica, Arial, sans-serif;\n  font-size: 13px;\n}\n.bk-root .bk,\n.bk-root .bk:before,\n.bk-root .bk:after {\n  box-sizing: inherit;\n  margin: 0;\n  border: 0;\n  padding: 0;\n  background-image: none;\n  font-family: inherit;\n  font-size: 100%;\n  line-height: 1.42857143;\n}\n.bk-root pre.bk {\n  font-family: Courier, monospace;\n}\n"},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const s=e(1),c=s.__importStar(e(23)),l=s.__importStar(e(18)),i=e(20),h=e(12);function o(e,t,a){e.moveTo(0,a+.5),e.lineTo(t,a+.5),e.stroke()}function r(e,t,a){e.moveTo(a+.5,0),e.lineTo(a+.5,t),e.stroke()}function n(e,t){e.moveTo(0,t),e.lineTo(t,0),e.stroke(),e.moveTo(0,0),e.lineTo(t,t),e.stroke()}function _(e,t,a,s){const c=a,l=c/2,i=l/2,h=function(e){const t=document.createElement("canvas");return t.width=e,t.height=e,t}(a),_=h.getContext("2d");switch(_.strokeStyle=t,_.lineCap="square",_.fillStyle=t,_.lineWidth=s,e){case" ":case"blank":break;case".":case"dot":_.arc(l,l,l/2,0,2*Math.PI,!0),_.fill();break;case"o":case"ring":_.arc(l,l,l/2,0,2*Math.PI,!0),_.stroke();break;case"-":case"horizontal_line":o(_,c,l);break;case"|":case"vertical_line":r(_,c,l);break;case"+":case"cross":o(_,c,l),r(_,c,l);break;case'"':case"horizontal_dash":o(_,l,l);break;case":":case"vertical_dash":r(_,l,l);break;case"@":case"spiral":const e=c/30;_.moveTo(l,l);for(let t=0;t<360;t++){const a=.1*t,s=l+e*a*Math.cos(a),c=l+e*a*Math.sin(a);_.lineTo(s,c)}_.stroke();break;case"/":case"right_diagonal_line":_.moveTo(.5-i,c),_.lineTo(i+.5,0),_.stroke(),_.moveTo(i+.5,c),_.lineTo(3*i+.5,0),_.stroke(),_.moveTo(3*i+.5,c),_.lineTo(5*i+.5,0),_.stroke(),_.stroke();break;case"\\":case"left_diagonal_line":_.moveTo(i+.5,c),_.lineTo(.5-i,0),_.stroke(),_.moveTo(3*i+.5,c),_.lineTo(i+.5,0),_.stroke(),_.moveTo(5*i+.5,c),_.lineTo(3*i+.5,0),_.stroke(),_.stroke();break;case"x":case"diagonal_cross":n(_,c);break;case",":case"right_diagonal_dash":_.moveTo(i+.5,3*i+.5),_.lineTo(3*i+.5,i+.5),_.stroke();break;case"`":case"left_diagonal_dash":_.moveTo(i+.5,i+.5),_.lineTo(3*i+.5,3*i+.5),_.stroke();break;case"v":case"horizontal_wave":_.moveTo(0,i),_.lineTo(l,3*i),_.lineTo(c,i),_.stroke();break;case">":case"vertical_wave":_.moveTo(i,0),_.lineTo(3*i,l),_.lineTo(i,c),_.stroke();break;case"*":case"criss_cross":n(_,c),o(_,c,l),r(_,c,l)}return h}class u{constructor(e,t=""){this.obj=e,this.prefix=t,this.cache={};for(const a of this.attrs)this[a]=e.properties[t+a]}warm_cache(e){for(const t of this.attrs){const a=this.obj.properties[this.prefix+t];if(void 0!==a.spec.value)this.cache[t]=a.spec.value;else{if(!(null!=e&&a instanceof l.VectorSpec))throw new Error("source is required with a vectorized visual property");this.cache[t+"_array"]=a.array(e)}}}cache_select(e,t){const a=this.obj.properties[this.prefix+e];let s;return void 0!==a.spec.value?this.cache[e]=s=a.spec.value:this.cache[e]=s=this.cache[e+"_array"][t],s}get_array(e){const t=this.cache[e+"_array"];return null!=this.all_indices?h.map(this.all_indices,e=>t[e]):t}set_vectorize(e,t){null!=this.all_indices?this._set_vectorize(e,this.all_indices[t]):this._set_vectorize(e,t)}}a.ContextProperties=u,u.__name__="ContextProperties";class p extends u{set_value(e){e.strokeStyle=this.line_color.value(),e.globalAlpha=this.line_alpha.value(),e.lineWidth=this.line_width.value(),e.lineJoin=this.line_join.value(),e.lineCap=this.line_cap.value(),e.setLineDash(this.line_dash.value()),e.setLineDashOffset(this.line_dash_offset.value())}get doit(){return!(null===this.line_color.spec.value||0==this.line_alpha.spec.value||0==this.line_width.spec.value)}_set_vectorize(e,t){this.cache_select("line_color",t),e.strokeStyle=this.cache.line_color,this.cache_select("line_alpha",t),e.globalAlpha=this.cache.line_alpha,this.cache_select("line_width",t),e.lineWidth=this.cache.line_width,this.cache_select("line_join",t),e.lineJoin=this.cache.line_join,this.cache_select("line_cap",t),e.lineCap=this.cache.line_cap,this.cache_select("line_dash",t),e.setLineDash(this.cache.line_dash),this.cache_select("line_dash_offset",t),e.setLineDashOffset(this.cache.line_dash_offset)}color_value(){return i.color2css(this.line_color.value(),this.line_alpha.value())}}a.Line=p,p.__name__="Line",p.prototype.attrs=Object.keys(c.LineVector);class v extends u{set_value(e){e.fillStyle=this.fill_color.value(),e.globalAlpha=this.fill_alpha.value()}get doit(){return!(null===this.fill_color.spec.value||0==this.fill_alpha.spec.value)}_set_vectorize(e,t){this.cache_select("fill_color",t),e.fillStyle=this.cache.fill_color,this.cache_select("fill_alpha",t),e.globalAlpha=this.cache.fill_alpha}color_value(){return i.color2css(this.fill_color.value(),this.fill_alpha.value())}}a.Fill=v,v.__name__="Fill",v.prototype.attrs=Object.keys(c.FillVector);class f extends u{cache_select(e,t){let a;if("pattern"==e){this.cache_select("hatch_color",t),this.cache_select("hatch_scale",t),this.cache_select("hatch_pattern",t),this.cache_select("hatch_weight",t);const{hatch_color:e,hatch_scale:a,hatch_pattern:s,hatch_weight:c,hatch_extra:l}=this.cache;if(null!=l&&l.hasOwnProperty(s)){const t=l[s];this.cache.pattern=t.get_pattern(e,a,c)}else this.cache.pattern=t=>{const l=_(s,e,a,c);return t.createPattern(l,"repeat")}}else a=super.cache_select(e,t);return a}_try_defer(e){const{hatch_pattern:t,hatch_extra:a}=this.cache;if(null!=a&&a.hasOwnProperty(t)){a[t].onload(e)}}get doit(){return!(null===this.hatch_color.spec.value||0==this.hatch_alpha.spec.value||" "==this.hatch_pattern.spec.value||"blank"==this.hatch_pattern.spec.value||null===this.hatch_pattern.spec.value)}doit2(e,t,a,s){if(!this.doit)return;this.cache_select("pattern",t),null==this.cache.pattern(e)?this._try_defer(s):(this.set_vectorize(e,t),a())}_set_vectorize(e,t){this.cache_select("pattern",t),e.fillStyle=this.cache.pattern(e),this.cache_select("hatch_alpha",t),e.globalAlpha=this.cache.hatch_alpha}color_value(){return i.color2css(this.hatch_color.value(),this.hatch_alpha.value())}}a.Hatch=f,f.__name__="Hatch",f.prototype.attrs=Object.keys(c.HatchVector);class d extends u{color_value(){return i.color2css(this.text_color.value(),this.text_alpha.value())}font_value(){const e=this.text_font.value(),t=this.text_font_size.value();return`${this.text_font_style.value()} ${t} ${e}`}v_font_value(e){super.cache_select("text_font_style",e),super.cache_select("text_font_size",e),super.cache_select("text_font",e);const{text_font_style:t,text_font_size:a,text_font:s}=this.cache;return`${t} ${a} ${s}`}cache_select(e,t){let a;return"font"==e?this.cache.font=a=this.v_font_value(t):a=super.cache_select(e,t),a}set_value(e){e.font=this.font_value(),e.fillStyle=this.text_color.value(),e.globalAlpha=this.text_alpha.value(),e.textAlign=this.text_align.value(),e.textBaseline=this.text_baseline.value()}get doit(){return!(null===this.text_color.spec.value||0==this.text_alpha.spec.value)}_set_vectorize(e,t){this.cache_select("font",t),e.font=this.cache.font,this.cache_select("text_color",t),e.fillStyle=this.cache.text_color,this.cache_select("text_alpha",t),e.globalAlpha=this.cache.text_alpha,this.cache_select("text_align",t),e.textAlign=this.cache.text_align,this.cache_select("text_baseline",t),e.textBaseline=this.cache.text_baseline}}a.Text=d,d.__name__="Text",d.prototype.attrs=Object.keys(c.TextVector);class k{constructor(e){for(const t of e._mixins){const[a,s=""]=t.split(":");let c;switch(a){case"line":c=p;break;case"fill":c=v;break;case"hatch":c=f;break;case"text":c=d;break;default:throw new Error("unknown visual: "+a)}this[s+a]=new c(e,s)}}warm_cache(e){for(const t in this)if(this.hasOwnProperty(t)){const a=this[t];a instanceof u&&a.warm_cache(e)}}set_all_indices(e){for(const t in this)if(this.hasOwnProperty(t)){const a=this[t];a instanceof u&&(a.all_indices=e)}}}a.Visuals=k,k.__name__="Visuals"},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(1),c=e(13),i=n.__importStar(e(18)),a=e(8),r=e(17),o=e(72);class l extends c.HasProps{constructor(e){super(e)}static init_Model(){this.define({tags:[i.Array,[]],name:[i.String],js_property_callbacks:[i.Any,{}],js_event_callbacks:[i.Any,{}],subscribed_events:[i.Array,[]]})}initialize(){super.initialize(),this._js_callbacks=new Map}connect_signals(){super.connect_signals(),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,()=>this._update_property_callbacks()),this.connect(this.properties.js_event_callbacks.change,()=>this._update_event_callbacks()),this.connect(this.properties.subscribed_events.change,()=>this._update_event_callbacks())}_process_event(e){for(const t of this.js_event_callbacks[e.event_name]||[])t.execute(e);null!=this.document&&this.subscribed_events.some(t=>t==e.event_name)&&this.document.event_manager.send_event(e)}trigger_event(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))}_update_event_callbacks(){null!=this.document?this.document.event_manager.subscribed_models.add(this):o.logger.warn("WARNING: Document not defined for updating event callbacks")}_update_property_callbacks(){const e=e=>{const[t,s=null]=e.split(":");return null!=s?this.properties[s][t]:this[t]};for(const[t,s]of this._js_callbacks){const n=e(t);for(const e of s)this.disconnect(n,e)}this._js_callbacks.clear();for(const[t,s]of r.entries(this.js_property_callbacks)){const n=s.map(e=>()=>e.execute(this));this._js_callbacks.set(t,n);const c=e(t);for(const e of n)this.connect(c,e)}}_doc_attached(){r.isEmpty(this.js_event_callbacks)&&0==this.subscribed_events.length||this._update_event_callbacks()}_doc_detached(){this.document.event_manager.subscribed_models.delete(this)}select(e){if(a.isString(e))return[...this.references()].filter(t=>t instanceof l&&t.name===e);if(e.prototype instanceof c.HasProps)return[...this.references()].filter(t=>t instanceof e);throw new Error("invalid selector")}select_one(e){const t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error("found more than one object matching given selector")}}}s.Model=l,l.__name__="Model",l.init_Model()},
function _(e,l,o){Object.defineProperty(o,"__esModule",{value:!0});const n=e(8),t={};class s{constructor(e,l){this.name=e,this.level=l}}o.LogLevel=s,s.__name__="LogLevel";class g{constructor(e,l=g.INFO){this._name=e,this.set_level(l)}static get levels(){return Object.keys(g.log_levels)}static get(e,l=g.INFO){if(e.length>0){let o=t[e];return null==o&&(t[e]=o=new g(e,l)),o}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")}get level(){return this.get_level()}get_level(){return this._log_level}set_level(e){if(e instanceof s)this._log_level=e;else{if(!n.isString(e)||null==g.log_levels[e])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=g.log_levels[e]}const l=`[${this._name}]`;for(const e in g.log_levels){g.log_levels[e].level<this._log_level.level||this._log_level.level===g.OFF.level?this[e]=function(){}:this[e]=r(e,l)}}trace(...e){}debug(...e){}info(...e){}warn(...e){}error(...e){}}function r(e,l){return null!=console[e]?console[e].bind(console,l):null!=console.log?console.log.bind(console,l):function(){}}function i(e){const l=o.logger.level;return n.isString(e)&&null==g.log_levels[e]?(console.log(`[bokeh] unrecognized logging level '${e}' passed to Bokeh.set_log_level(), ignoring`),console.log("[bokeh] valid log levels are: "+g.levels.join(", "))):(console.log(`[bokeh] setting log level to: '${n.isString(e)?e:e.level}'`),o.logger.set_level(e)),l}o.Logger=g,g.__name__="Logger",g.TRACE=new s("trace",0),g.DEBUG=new s("debug",1),g.INFO=new s("info",2),g.WARN=new s("warn",6),g.ERROR=new s("error",7),g.FATAL=new s("fatal",8),g.OFF=new s("off",9),g.log_levels={trace:g.TRACE,debug:g.DEBUG,info:g.INFO,warn:g.WARN,error:g.ERROR,fatal:g.FATAL,off:g.OFF},o.logger=g.get("bokeh"),o.set_log_level=i,o.with_log_level=function(e,l){const o=i(e);try{l()}finally{i(o)}}},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});o.default="\n.bk-root .bk-shading {\n  position: absolute;\n  display: block;\n  border: 1px dashed green;\n}\n"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),a=t(31),n=t(75),r=t(76),o=t(23),_=i.__importStar(t(18)),l=t(10);class h extends a.AnnotationView{initialize(){super.initialize(),null==this.model.source&&(this.model.source=new r.ColumnDataSource),this.set_data(this.model.source)}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.set_data(this.model.source)),this.connect(this.model.source.streaming,()=>this.set_data(this.model.source)),this.connect(this.model.source.patching,()=>this.set_data(this.model.source))}set_data(t){super.set_data(t),this.visuals.warm_cache(t),this.plot_view.request_render()}_map_data(){const{frame:t}=this.plot_view;let e,s,i,a;return"data"==this.model.start_units?(e=t.xscales[this.model.x_range_name].v_compute(this._x_start),s=t.yscales[this.model.y_range_name].v_compute(this._y_start)):(e=t.xview.v_compute(this._x_start),s=t.yview.v_compute(this._y_start)),"data"==this.model.end_units?(i=t.xscales[this.model.x_range_name].v_compute(this._x_end),a=t.yscales[this.model.y_range_name].v_compute(this._y_end)):(i=t.xview.v_compute(this._x_end),a=t.yview.v_compute(this._y_end)),[[e,s],[i,a]]}render(){if(!this.model.visible)return;const{ctx:t}=this.layer;t.save();const[e,s]=this._map_data();null!=this.model.end&&this._arrow_head(t,"render",this.model.end,e,s),null!=this.model.start&&this._arrow_head(t,"render",this.model.start,s,e),t.beginPath();const{x:i,y:a,width:n,height:r}=this.plot_view.frame.bbox;t.rect(i,a,n,r),null!=this.model.end&&this._arrow_head(t,"clip",this.model.end,e,s),null!=this.model.start&&this._arrow_head(t,"clip",this.model.start,s,e),t.closePath(),t.clip(),this._arrow_body(t,e,s),t.restore()}_arrow_head(t,e,s,i,a){for(let n=0,r=this._x_start.length;n<r;n++){const r=Math.PI/2+l.atan2([i[0][n],i[1][n]],[a[0][n],a[1][n]]);t.save(),t.translate(a[0][n],a[1][n]),t.rotate(r),"render"==e?s.render(t,n):"clip"==e&&s.clip(t,n),t.restore()}}_arrow_body(t,e,s){if(this.visuals.line.doit)for(let i=0,a=this._x_start.length;i<a;i++)this.visuals.line.set_vectorize(t,i),t.beginPath(),t.moveTo(e[0][i],e[1][i]),t.lineTo(s[0][i],s[1][i]),t.stroke()}}s.ArrowView=h,h.__name__="ArrowView";class d extends a.Annotation{constructor(t){super(t)}static init_Arrow(){this.prototype.default_view=h,this.mixins(o.LineVector),this.define({x_start:[_.NumberSpec],y_start:[_.NumberSpec],start_units:[_.SpatialUnits,"data"],start:[_.Instance,null],x_end:[_.NumberSpec],y_end:[_.NumberSpec],end_units:[_.SpatialUnits,"data"],end:[_.Instance,()=>new n.OpenHead({})],source:[_.Instance],x_range_name:[_.String,"default"],y_range_name:[_.String,"default"]})}}s.Arrow=d,d.__name__="Arrow",d.init_Arrow()},
function _(i,e,s){Object.defineProperty(s,"__esModule",{value:!0});const t=i(1),o=i(31),l=i(70),n=i(23),h=t.__importStar(i(18));class a extends o.Annotation{constructor(i){super(i)}static init_ArrowHead(){this.define({size:[h.Number,25]})}initialize(){super.initialize(),this.visuals=new l.Visuals(this)}}s.ArrowHead=a,a.__name__="ArrowHead",a.init_ArrowHead();class r extends a{constructor(i){super(i)}static init_OpenHead(){this.mixins(n.LineVector)}clip(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,0),i.lineTo(.5*this.size,this.size)}render(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.stroke())}}s.OpenHead=r,r.__name__="OpenHead",r.init_OpenHead();class z extends a{constructor(i){super(i)}static init_NormalHead(){this.mixins([n.LineVector,n.FillVector]),this.override({fill_color:"black"})}clip(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(.5*this.size,this.size)}render(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._normal(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._normal(i,e),i.stroke())}_normal(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.closePath()}}s.NormalHead=z,z.__name__="NormalHead",z.init_NormalHead();class _ extends a{constructor(i){super(i)}static init_VeeHead(){this.mixins([n.LineVector,n.FillVector]),this.override({fill_color:"black"})}clip(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.lineTo(.5*this.size,this.size)}render(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._vee(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._vee(i,e),i.stroke())}_vee(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.closePath()}}s.VeeHead=_,_.__name__="VeeHead",_.init_VeeHead();class c extends a{constructor(i){super(i)}static init_TeeHead(){this.mixins(n.LineVector)}render(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,0),i.lineTo(-.5*this.size,0),i.stroke())}clip(i,e){}}s.TeeHead=c,c.__name__="TeeHead",c.init_TeeHead()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});const s=t(1),o=t(77),r=s.__importStar(t(18)),i=t(8),l=t(17),a=s.__importStar(t(103)),c=t(104),u=t(105);function h(t,n,e){if(i.isArray(t)){const s=t.concat(n);return null!=e&&s.length>e?s.slice(-e):s}if(i.isTypedArray(t)){const s=t.length+n.length;if(null!=e&&s>e){const o=s-e,r=t.length;let i;t.length<e?(i=new t.constructor(e),i.set(t,0)):i=t;for(let t=o,n=r;t<n;t++)i[t-o]=i[t];for(let t=0,e=n.length;t<e;t++)i[t+(r-o)]=n[t];return i}{const e=new t.constructor(n);return a.concat(t,e)}}throw new Error("unsupported array types")}function d(t,n){let e,s,o;return i.isNumber(t)?(e=t,o=t+1,s=1):(e=null!=t.start?t.start:0,o=null!=t.stop?t.stop:n,s=null!=t.step?t.step:1),[e,o,s]}function m(t,n){const e=new Set;let s=!1;for(const[o,r]of n){let n,l,a,c;if(i.isArray(o)){const[s]=o;e.add(s),n=t[s].shape,l=t[s],c=r,2===o.length?(n=[1,n[0]],a=[o[0],0,o[1]]):a=o}else i.isNumber(o)?(c=[r],e.add(o)):(c=r,s=!0),a=[0,0,o],n=[1,t.length],l=t;let u=0;const[h,m,f]=d(a[1],n[0]),[_,p,g]=d(a[2],n[1]);for(let t=h;t<m;t+=f)for(let o=_;o<p;o+=g)s&&e.add(o),l[t*n[1]+o]=c[u],u++}return e}e.stream_to_column=h,e.slice=d,e.patch_to_column=m;class f extends o.ColumnarDataSource{constructor(t){super(t)}static init_ColumnDataSource(){this.define({data:[r.Any,{}]})}stream(t,n,e){const{data:s}=this;for(const e in t)s[e]=h(s[e],t[e],n);if(this.setv({data:s},{silent:!0}),this.streaming.emit(),null!=this.document){const s=new u.ColumnsStreamedEvent(this.document,this.ref(),t,n);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:s})}}patch(t,n){const{data:e}=this;let s=new Set;for(const[n,o]of l.entries(t))s=c.union(s,m(e[n],o));if(this.setv({data:e},{silent:!0}),this.patching.emit([...s]),null!=this.document){const e=new u.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:n,hint:e})}}}e.ColumnDataSource=f,f.__name__="ColumnDataSource",f.init_ColumnDataSource()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});const a=t(1),s=t(78),i=t(14),r=t(72),c=t(80),l=a.__importStar(t(18)),o=t(8),u=t(9),h=t(17),g=t(79),_=t(102);class d extends s.DataSource{constructor(t){super(t)}get_array(t){let n=this.data[t];return null==n?this.data[t]=n=[]:o.isArray(n)||(this.data[t]=n=Array.from(n)),n}static init_ColumnarDataSource(){this.define({selection_policy:[l.Instance,()=>new _.UnionRenderers]}),this.internal({selection_manager:[l.Instance,t=>new c.SelectionManager({source:t})],inspected:[l.Instance,()=>new g.Selection]})}initialize(){super.initialize(),this._select=new i.Signal0(this,"select"),this.inspect=new i.Signal(this,"inspect"),this.streaming=new i.Signal0(this,"streaming"),this.patching=new i.Signal(this,"patching")}get_column(t){const n=this.data[t];return null!=n?n:null}columns(){return h.keys(this.data)}get_length(t=!0){const n=u.uniq(h.values(this.data).map(t=>t.length));switch(n.length){case 0:return null;case 1:return n[0];default:{const e="data source has columns of inconsistent lengths";if(t)return r.logger.warn(e),n.sort()[0];throw new Error(e)}}}get_indices(){const t=this.get_length();return u.range(0,null!=t?t:1)}clear(){const t={};for(const n of this.columns())t[n]=new this.data[n].constructor(0);this.data=t}}e.ColumnarDataSource=d,d.__name__="ColumnarDataSource",d.init_ColumnarDataSource()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const c=e(1),n=e(71),o=e(79),i=c.__importStar(e(18));class r extends n.Model{constructor(e){super(e)}static init_DataSource(){this.define({selected:[i.Instance,()=>new o.Selection]})}}a.DataSource=r,r.__name__="DataSource",r.init_DataSource()},
function _(i,e,s){Object.defineProperty(s,"__esModule",{value:!0});const t=i(1),n=i(71),l=t.__importStar(i(18)),c=i(9),_=i(17);class h extends n.Model{constructor(i){super(i)}static init_Selection(){this.define({indices:[l.Array,[]],line_indices:[l.Array,[]],multiline_indices:[l.Any,{}]}),this.internal({selected_glyphs:[l.Array,[]],get_view:[l.Any],image_indices:[l.Array,[]]})}initialize(){super.initialize(),this.get_view=()=>null}static from_hits(i){const e=c.sort_by(i,([,i])=>i).map(([i])=>i);return new h({indices:e})}get selected_glyph(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null}add_to_selected_glyphs(i){this.selected_glyphs.push(i)}update(i,e=!0,s="replace"){switch(s){case"replace":this.indices=i.indices,this.line_indices=i.line_indices,this.selected_glyphs=i.selected_glyphs,this.get_view=i.get_view,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices;break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i)}}clear(){this.indices=[],this.line_indices=[],this.multiline_indices={},this.get_view=()=>null,this.selected_glyphs=[]}is_empty(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length}update_through_union(i){this.indices=c.union(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.get_view()||(this.get_view=i.get_view),this.multiline_indices=_.merge(i.multiline_indices,this.multiline_indices)}update_through_intersection(i){this.indices=c.intersection(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.get_view()||(this.get_view=i.get_view),this.multiline_indices=_.merge(i.multiline_indices,this.multiline_indices)}update_through_subtraction(i){this.indices=c.difference(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.get_view()||(this.get_view=i.get_view),this.multiline_indices=_.merge(i.multiline_indices,this.multiline_indices)}}s.Selection=h,h.__name__="Selection",h.init_Selection()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),n=e(13),o=e(79),c=e(81),r=e(100),l=i.__importStar(e(18));class p extends n.HasProps{constructor(e){super(e),this.inspectors=new Map}static init_SelectionManager(){this.internal({source:[l.Any]})}select(e,t,s,i="replace"){const n=[],o=[];for(const t of e)t instanceof c.GlyphRendererView?n.push(t):t instanceof r.GraphRendererView&&o.push(t);let l=!1;for(const e of o){const n=e.model.selection_policy.hit_test(t,e);l=l||e.model.selection_policy.do_selection(n,e.model,s,i)}if(n.length>0){const e=this.source.selection_policy.hit_test(t,n);l=l||this.source.selection_policy.do_selection(e,this.source,s,i)}return l}inspect(e,t){let s=!1;if(e instanceof c.GlyphRendererView){const i=e.hit_test(t);if(null!=i){s=!i.is_empty();const n=this.get_or_create_inspector(e.model);n.update(i,!0,"replace"),this.source.setv({inspected:n},{silent:!0}),this.source.inspect.emit([e,{geometry:t}])}}else if(e instanceof r.GraphRendererView){const i=e.model.inspection_policy.hit_test(t,e);s=s||e.model.inspection_policy.do_inspection(i,t,e,!1,"replace")}return s}clear(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()}get_or_create_inspector(e){let t=this.inspectors.get(e);return null==t&&(t=new o.Selection,this.inspectors.set(e,t)),t}}s.SelectionManager=p,p.__name__="SelectionManager",p.init_SelectionManager()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),l=e(82),n=e(83),h=e(94),o=e(95),a=e(97),_=e(98),c=e(72),r=s.__importStar(e(18)),d=e(12),g=e(9),p=e(17),y=e(99),u=e(90),m={fill:{},line:{}},v={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},f={fill:{fill_alpha:.2},line:{}};class w extends l.DataRendererView{async lazy_initialize(){await super.lazy_initialize();const e=this.model.glyph,t=g.includes(e._mixins,"fill"),i=g.includes(e._mixins,"line"),s=p.clone(e.attributes);function l(l){const n=p.clone(s);return t&&p.extend(n,l.fill),i&&p.extend(n,l.line),new e.constructor(n)}delete s.id,this.glyph=await this.build_glyph_view(e);let{selection_glyph:n}=this.model;null==n?n=l({fill:{},line:{}}):"auto"===n&&(n=l(m)),this.selection_glyph=await this.build_glyph_view(n);let{nonselection_glyph:h}=this.model;null==h?h=l({fill:{},line:{}}):"auto"===h&&(h=l(f)),this.nonselection_glyph=await this.build_glyph_view(h);const{hover_glyph:o}=this.model;null!=o&&(this.hover_glyph=await this.build_glyph_view(o));const{muted_glyph:a}=this.model;null!=a&&(this.muted_glyph=await this.build_glyph_view(a));const _=l(v);this.decimated_glyph=await this.build_glyph_view(_),this.xscale=this.plot_view.frame.xscales[this.model.x_range_name],this.yscale=this.plot_view.frame.yscales[this.model.y_range_name],this.set_data(!1)}async build_glyph_view(e){return y.build_view(e,{parent:this})}remove(){var e,t;this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),null===(e=this.hover_glyph)||void 0===e||e.remove(),null===(t=this.muted_glyph)||void 0===t||t.remove(),this.decimated_glyph.remove(),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render()),this.connect(this.model.glyph.change,()=>this.set_data()),this.connect(this.model.data_source.change,()=>this.set_data()),this.connect(this.model.data_source.streaming,()=>this.set_data()),this.connect(this.model.data_source.patching,e=>this.set_data(!0,e)),this.connect(this.model.data_source.selected.change,()=>this.request_render()),this.connect(this.model.data_source._select,()=>this.request_render()),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,()=>this.request_render()),this.connect(this.model.properties.view.change,()=>this.set_data()),this.connect(this.model.view.change,()=>this.set_data()),this.connect(this.model.properties.visible.change,()=>this.plot_view.update_dataranges());const{x_ranges:e,y_ranges:t}=this.plot_view.frame;for(const t in e){const i=e[t];i instanceof u.FactorRange&&this.connect(i.change,()=>this.set_data())}for(const e in t){const i=t[e];i instanceof u.FactorRange&&this.connect(i.change,()=>this.set_data())}this.connect(this.model.glyph.transformchange,()=>this.set_data())}have_selection_glyphs(){return null!=this.selection_glyph&&null!=this.nonselection_glyph}set_data(e=!0,t=null){const i=Date.now(),s=this.model.data_source;this.all_indices=this.model.view.indices,this.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.glyph.set_data(s,this.all_indices,t),this.glyph.set_visuals(s,this.all_indices),this.decimated_glyph.set_visuals(s,this.all_indices),this.have_selection_glyphs()&&(this.selection_glyph.set_visuals(s,this.all_indices),this.nonselection_glyph.set_visuals(s,this.all_indices)),null!=this.hover_glyph&&this.hover_glyph.set_visuals(s,this.all_indices),null!=this.muted_glyph&&this.muted_glyph.set_visuals(s,this.all_indices);const{lod_factor:l}=this.plot_model;this.decimated=[];for(let e=0,t=Math.floor(this.all_indices.length/l);e<t;e++)this.decimated.push(e*l);const n=Date.now()-i;c.logger.debug(`${this.glyph.model.type} ${this.model}): set_data finished in ${n}ms`),this.set_data_timestamp=Date.now(),e&&this.request_render()}get has_webgl(){return this.glyph.has_webgl}render(){if(!this.model.visible)return;const e=Date.now(),t=this.has_webgl;this.glyph.map_data();const i=Date.now()-e,s=Date.now();let l=this.glyph.mask_data(this.all_indices);l.length===this.all_indices.length&&(l=g.range(0,this.all_indices.length));const _=Date.now()-s,{ctx:r}=this.layer;r.save();const{selected:p}=this.model.data_source;let y;y=!p||p.is_empty()?[]:this.glyph instanceof n.LineView&&p.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(l):p.indices;const{inspected:u}=this.model.data_source,m=new Set((()=>!u||u.is_empty()?[]:u.selected_glyph?this.model.view.convert_indices_from_subset(l):u.indices.length>0?u.indices:Object.keys(u.multiline_indices).map(e=>parseInt(e)))()),v=d.filter(l,e=>m.has(this.all_indices[e])),{lod_threshold:f}=this.plot_model;let w,b,x;null!=this.model.document&&this.model.document.interactive_duration()>0&&!t&&null!=f&&this.all_indices.length>f?(l=this.decimated,w=this.decimated_glyph,b=this.decimated_glyph,x=this.selection_glyph):(w=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,b=this.nonselection_glyph,x=this.selection_glyph),null!=this.hover_glyph&&v.length&&(l=g.difference(l,v));let D,V=null;if(y.length&&this.have_selection_glyphs()){const e=Date.now(),t={};for(const e of y)t[e]=!0;const i=new Array,s=new Array;if(this.glyph instanceof n.LineView)for(const e of this.all_indices)null!=t[e]?i.push(e):s.push(e);else for(const e of l)null!=t[this.all_indices[e]]?i.push(e):s.push(e);V=Date.now()-e,D=Date.now(),b.render(r,s,this.glyph),x.render(r,i,this.glyph),null!=this.hover_glyph&&(this.glyph instanceof n.LineView?this.hover_glyph.render(r,this.model.view.convert_indices_from_subset(v),this.glyph):this.hover_glyph.render(r,v,this.glyph))}else if(D=Date.now(),this.glyph instanceof n.LineView)this.hover_glyph&&v.length?this.hover_glyph.render(r,this.model.view.convert_indices_from_subset(v),this.glyph):w.render(r,this.all_indices,this.glyph);else if(this.glyph instanceof h.PatchView||this.glyph instanceof o.HAreaView||this.glyph instanceof a.VAreaView)if(0==u.selected_glyphs.length||null==this.hover_glyph)w.render(r,this.all_indices,this.glyph);else for(const e of u.selected_glyphs)e==this.glyph.model&&this.hover_glyph.render(r,this.all_indices,this.glyph);else w.render(r,l,this.glyph),this.hover_glyph&&v.length&&this.hover_glyph.render(r,v,this.glyph);const R=Date.now()-D;this.last_dtrender=R;const $=Date.now()-e;c.logger.debug(`${this.glyph.model.type} ${this.model}: render finished in ${$}ms`),c.logger.trace(` - map_data finished in       : ${i}ms`),c.logger.trace(` - mask_data finished in      : ${_}ms`),null!=V&&c.logger.trace(` - selection mask finished in : ${V}ms`),c.logger.trace(` - glyph renders finished in  : ${R}ms`),r.restore()}draw_legend(e,t,i,s,l,n,h,o){null==o&&(o=this.model.get_reference_point(n,h)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:s,y1:l},o)}hit_test(e){if(!this.model.visible)return null;const t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)}}i.GlyphRendererView=w,w.__name__="GlyphRendererView";class b extends l.DataRenderer{constructor(e){super(e)}static init_GlyphRenderer(){this.prototype.default_view=w,this.define({data_source:[r.Instance],view:[r.Instance,()=>new _.CDSView],glyph:[r.Instance],hover_glyph:[r.Instance],nonselection_glyph:[r.Any,"auto"],selection_glyph:[r.Any,"auto"],muted_glyph:[r.Instance],muted:[r.Boolean,!1]})}initialize(){super.initialize(),null==this.view.source&&(this.view.source=this.data_source,this.view.compute_indices())}get_reference_point(e,t){let i=0;if(null!=e){const s=this.data_source.get_column(e);if(null!=s){const e=d.indexOf(s,t);-1!=e&&(i=e)}}return i}get_selection_manager(){return this.data_source.selection_manager}}i.GlyphRenderer=b,b.__name__="GlyphRenderer",b.init_GlyphRenderer()},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(1),a=e(65),_=t.__importStar(e(18));class i extends a.RendererView{}n.DataRendererView=i,i.__name__="DataRendererView";class d extends a.Renderer{constructor(e){super(e)}static init_DataRenderer(){this.define({x_range_name:[_.String,"default"],y_range_name:[_.String,"default"]}),this.override({level:"glyph"})}}n.DataRenderer=d,d.__name__="DataRenderer",d.init_DataRenderer()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),n=e(84),_=e(92),l=s.__importStar(e(23)),o=s.__importStar(e(93)),r=e(79);class h extends n.XYGlyphView{_render(e,t,{sx:i,sy:s}){let n=!1,_=null;this.visuals.line.set_value(e);for(const l of t){if(n){if(!isFinite(i[l]+s[l])){e.stroke(),e.beginPath(),n=!1,_=l;continue}null!=_&&l-_>1&&(e.stroke(),n=!1)}n?e.lineTo(i[l],s[l]):(e.beginPath(),e.moveTo(i[l],s[l]),n=!0),_=l}n&&e.stroke()}_hit_point(e){const t=new r.Selection,i={x:e.sx,y:e.sy};let s=9999;const n=Math.max(2,this.visuals.line.line_width.value()/2);for(let e=0,_=this.sx.length-1;e<_;e++){const _={x:this.sx[e],y:this.sy[e]},l={x:this.sx[e+1],y:this.sy[e+1]},r=o.dist_to_segment(i,_,l);r<n&&r<s&&(s=r,t.add_to_selected_glyphs(this.model),t.get_view=()=>this,t.line_indices=[e])}return t}_hit_span(e){const{sx:t,sy:i}=e,s=new r.Selection;let n,_;"v"==e.direction?(n=this.renderer.yscale.invert(i),_=this._y):(n=this.renderer.xscale.invert(t),_=this._x);for(let e=0,t=_.length-1;e<t;e++)(_[e]<=n&&n<=_[e+1]||_[e+1]<=n&&n<=_[e])&&(s.add_to_selected_glyphs(this.model),s.get_view=()=>this,s.line_indices.push(e));return s}get_interpolation_hit(e,t){const[i,s,n,l]=[this._x[e],this._y[e],this._x[e+1],this._y[e+1]];return _.line_interpolation(this.renderer,t,i,s,n,l)}draw_legend_for_index(e,t,i){_.generic_line_legend(this.visuals,e,t,i)}}i.LineView=h,h.__name__="LineView";class a extends n.XYGlyph{constructor(e){super(e)}static init_Line(){this.prototype.default_view=h,this.mixins(l.Line)}}i.Line=a,a.__name__="Line",a.init_Line()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(85),n=e(89);class _ extends n.GlyphView{_index_data(){const e=[];for(let t=0,s=this._x.length;t<s;t++){const s=this._x[t],i=this._y[t];!isNaN(s+i)&&isFinite(s+i)&&e.push({x0:s,y0:i,x1:s,y1:i,i:t})}return new i.SpatialIndex(e)}scenterx(e){return this.sx[e]}scentery(e){return this.sy[e]}}s.XYGlyphView=_,_.__name__="XYGlyphView";class h extends n.Glyph{constructor(e){super(e)}static init_XYGlyph(){this.coords([["x","y"]])}}s.XYGlyph=h,h.__name__="XYGlyph",h.init_XYGlyph()},
function _(n,t,i){Object.defineProperty(i,"__esModule",{value:!0});const e=n(1).__importDefault(n(86)),s=n(88);class r{constructor(n){if(this.points=n,this.index=null,n.length>0){this.index=new e.default(n.length);for(const t of n){const{x0:n,y0:i,x1:e,y1:s}=t;this.index.add(n,i,e,s)}this.index.finish()}}_normalize(n){let{x0:t,y0:i,x1:e,y1:s}=n;return t>e&&([t,e]=[e,t]),i>s&&([i,s]=[s,i]),{x0:t,y0:i,x1:e,y1:s}}get bbox(){if(null==this.index)return s.empty();{const{minX:n,minY:t,maxX:i,maxY:e}=this.index;return{x0:n,y0:t,x1:i,y1:e}}}search(n){if(null==this.index)return[];{const{x0:t,y0:i,x1:e,y1:s}=this._normalize(n);return this.index.search(t,i,e,s).map(n=>this.points[n])}}indices(n){return this.search(n).map(({i:n})=>n)}}i.SpatialIndex=r,r.__name__="SpatialIndex"},
function _(t,s,i){Object.defineProperty(i,"__esModule",{value:!0});const e=t(1).__importDefault(t(87)),h=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class n{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[s,i]=new Uint8Array(t,0,2);if(251!==s)throw new Error("Data does not appear to be in a Flatbush format.");if(i>>4!=3)throw new Error(`Got v${i>>4} data when expected v3.`);const[e]=new Uint16Array(t,2,1),[o]=new Uint32Array(t,4,1);return new n(o,e,h[15&i],t)}constructor(t,s=16,i=Float64Array,n){if(void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+s,2),65535);let o=t,r=o;this._levelBounds=[4*o];do{o=Math.ceil(o/this.nodeSize),r+=o,this._levelBounds.push(4*r)}while(1!==o);this.ArrayType=i||Float64Array,this.IndexArrayType=r<16384?Uint16Array:Uint32Array;const a=h.indexOf(this.ArrayType),_=4*r*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error(`Unexpected typed array class: ${i}.`);n&&n instanceof ArrayBuffer?(this.data=n,this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=4*r,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+_+r*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=s,new Uint32Array(this.data,4,1)[0]=t),this._queue=new e.default}add(t,s,i,e){const h=this._pos>>2;return this._indices[h]=h,this._boxes[this._pos++]=t,this._boxes[this._pos++]=s,this._boxes[this._pos++]=i,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),s<this.minY&&(this.minY=s),i>this.maxX&&(this.maxX=i),e>this.maxY&&(this.maxY=e),h}finish(){if(this._pos>>2!==this.numItems)throw new Error(`Added ${this._pos>>2} items when expected ${this.numItems}.`);if(this.numItems<=this.nodeSize)return this._boxes[this._pos++]=this.minX,this._boxes[this._pos++]=this.minY,this._boxes[this._pos++]=this.maxX,void(this._boxes[this._pos++]=this.maxY);const t=this.maxX-this.minX,s=this.maxY-this.minY,i=new Uint32Array(this.numItems);for(let e=0;e<this.numItems;e++){let h=4*e;const n=this._boxes[h++],o=this._boxes[h++],r=this._boxes[h++],a=this._boxes[h++],d=Math.floor(65535*((n+r)/2-this.minX)/t),x=Math.floor(65535*((o+a)/2-this.minY)/s);i[e]=_(d,x)}!function t(s,i,e,h,n,o){if(Math.floor(h/o)>=Math.floor(n/o))return;const r=s[h+n>>1];let _=h-1,d=n+1;for(;;){do{_++}while(s[_]<r);do{d--}while(s[d]>r);if(_>=d)break;a(s,i,e,_,d)}t(s,i,e,h,d,o),t(s,i,e,d+1,n,o)}(i,this._boxes,this._indices,0,this.numItems-1,this.nodeSize);for(let t=0,s=0;t<this._levelBounds.length-1;t++){const i=this._levelBounds[t];for(;s<i;){const t=s;let e=1/0,h=1/0,n=-1/0,o=-1/0;for(let t=0;t<this.nodeSize&&s<i;t++)e=Math.min(e,this._boxes[s++]),h=Math.min(h,this._boxes[s++]),n=Math.max(n,this._boxes[s++]),o=Math.max(o,this._boxes[s++]);this._indices[this._pos>>2]=t,this._boxes[this._pos++]=e,this._boxes[this._pos++]=h,this._boxes[this._pos++]=n,this._boxes[this._pos++]=o}}}search(t,s,i,e,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const o=[],a=[];for(;void 0!==n;){const _=Math.min(n+4*this.nodeSize,r(n,this._levelBounds));for(let r=n;r<_;r+=4){const _=0|this._indices[r>>2];i<this._boxes[r]||(e<this._boxes[r+1]||t>this._boxes[r+2]||s>this._boxes[r+3]||(n<4*this.numItems?(void 0===h||h(_))&&a.push(_):o.push(_)))}n=o.pop()}return a}neighbors(t,s,i=1/0,e=1/0,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const a=this._queue,_=[],d=e*e;for(;void 0!==n;){const e=Math.min(n+4*this.nodeSize,r(n,this._levelBounds));for(let i=n;i<e;i+=4){const e=0|this._indices[i>>2],r=o(t,this._boxes[i],this._boxes[i+2]),_=o(s,this._boxes[i+1],this._boxes[i+3]),d=r*r+_*_;n<4*this.numItems?(void 0===h||h(e))&&a.push(-e-1,d):a.push(e,d)}for(;a.length&&a.peek()<0;){if(a.peekValue()>d)return a.clear(),_;if(_.push(-a.pop()-1),_.length===i)return a.clear(),_}n=a.pop()}return a.clear(),_}}function o(t,s,i){return t<s?s-t:t<=i?0:t-i}function r(t,s){let i=0,e=s.length-1;for(;i<e;){const h=i+e>>1;s[h]>t?e=h:i=h+1}return s[i]}function a(t,s,i,e,h){const n=t[e];t[e]=t[h],t[h]=n;const o=4*e,r=4*h,a=s[o],_=s[o+1],d=s[o+2],x=s[o+3];s[o]=s[r],s[o+1]=s[r+1],s[o+2]=s[r+2],s[o+3]=s[r+3],s[r]=a,s[r+1]=_,s[r+2]=d,s[r+3]=x;const l=i[e];i[e]=i[h],i[h]=l}function _(t,s){let i=t^s,e=65535^i,h=65535^(t|s),n=t&(65535^s),o=i|e>>1,r=i>>1^i,a=h>>1^e&n>>1^h,_=i&h>>1^n>>1^n;i=o,e=r,h=a,n=_,o=i&i>>2^e&e>>2,r=i&e>>2^e&(i^e)>>2,a^=i&h>>2^e&n>>2,_^=e&h>>2^(i^e)&n>>2,i=o,e=r,h=a,n=_,o=i&i>>4^e&e>>4,r=i&e>>4^e&(i^e)>>4,a^=i&h>>4^e&n>>4,_^=e&h>>4^(i^e)&n>>4,i=o,e=r,h=a,n=_,a^=i&h>>8^e&n>>8,_^=e&h>>8^(i^e)&n>>8,i=a^a>>1,e=_^_>>1;let d=t^s,x=e|65535^(d|i);return d=16711935&(d|d<<8),d=252645135&(d|d<<4),d=858993459&(d|d<<2),d=1431655765&(d|d<<1),x=16711935&(x|x<<8),x=252645135&(x|x<<4),x=858993459&(x|x<<2),x=1431655765&(x|x<<1),(x<<1|d)>>>0}i.default=n},
function _(s,t,i){Object.defineProperty(i,"__esModule",{value:!0});i.default=class{constructor(){this.ids=[],this.values=[],this.length=0}clear(){this.length=0}push(s,t){let i=this.length++;for(this.ids[i]=s,this.values[i]=t;i>0;){const s=i-1>>1,h=this.values[s];if(t>=h)break;this.ids[i]=this.ids[s],this.values[i]=h,i=s}this.ids[i]=s,this.values[i]=t}pop(){if(0===this.length)return;const s=this.ids[0];if(this.length--,this.length>0){const s=this.ids[0]=this.ids[this.length],t=this.values[0]=this.values[this.length],i=this.length>>1;let h=0;for(;h<i;){let s=1+(h<<1);const i=s+1;let e=this.ids[s],l=this.values[s];const n=this.values[i];if(i<this.length&&n<l&&(s=i,e=this.ids[i],l=n),l>=t)break;this.ids[h]=e,this.values[h]=l,h=s}this.ids[h]=s,this.values[h]=t}return s}peek(){if(0!==this.length)return this.ids[0]}peekValue(){if(0!==this.length)return this.values[0]}}},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});const{min:h,max:r}=Math;e.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},e.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},e.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},e.union=function(t,i){return{x0:h(t.x0,i.x0),x1:r(t.x1,i.x1),y0:h(t.y0,i.y0),y1:r(t.y1,i.y1)}};class s{constructor(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){const{x0:i,y0:e,x1:h,y1:r}=t;if(!(i<=h&&e<=r))throw new Error(`invalid bbox {x0: ${i}, y0: ${e}, x1: ${h}, y1: ${r}}`);this.x0=i,this.y0=e,this.x1=h,this.y1=r}else if("x"in t){const{x:i,y:e,width:h,height:r}=t;if(!(h>=0&&r>=0))throw new Error(`invalid bbox {x: ${i}, y: ${e}, width: ${h}, height: ${r}}`);this.x0=i,this.y0=e,this.x1=i+h,this.y1=e+r}else{let i,e,h,r;if("width"in t)if("left"in t)i=t.left,e=i+t.width;else if("right"in t)e=t.right,i=e-t.width;else{const h=t.width/2;i=t.hcenter-h,e=t.hcenter+h}else i=t.left,e=t.right;if("height"in t)if("top"in t)h=t.top,r=h+t.height;else if("bottom"in t)r=t.bottom,h=r-t.height;else{const i=t.height/2;h=t.vcenter-i,r=t.vcenter+i}else h=t.top,r=t.bottom;if(!(i<=e&&h<=r))throw new Error(`invalid bbox {left: ${i}, top: ${h}, right: ${e}, bottom: ${r}}`);this.x0=i,this.y0=h,this.x1=e,this.y1=r}}toString(){return`BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`}get left(){return this.x0}get top(){return this.y0}get right(){return this.x1}get bottom(){return this.y1}get p0(){return[this.x0,this.y0]}get p1(){return[this.x1,this.y1]}get x(){return this.x0}get y(){return this.y0}get width(){return this.x1-this.x0}get height(){return this.y1-this.y0}get rect(){return{x0:this.x0,y0:this.y0,x1:this.x1,y1:this.y1}}get box(){return{x:this.x,y:this.y,width:this.width,height:this.height}}get h_range(){return{start:this.x0,end:this.x1}}get v_range(){return{start:this.y0,end:this.y1}}get ranges(){return[this.h_range,this.v_range]}get aspect(){return this.width/this.height}get hcenter(){return(this.left+this.right)/2}get vcenter(){return(this.top+this.bottom)/2}contains(t,i){return t>=this.x0&&t<=this.x1&&i>=this.y0&&i<=this.y1}clip(t,i){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),i<this.y0?i=this.y0:i>this.y1&&(i=this.y1),[t,i]}union(t){return new s({x0:h(this.x0,t.x0),y0:h(this.y0,t.y0),x1:r(this.x1,t.x1),y1:r(this.y1,t.y1)})}equals(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1}get xview(){return{compute:t=>this.left+t,v_compute:t=>{const i=new Float64Array(t.length),e=this.left;for(let h=0;h<t.length;h++)i[h]=e+t[h];return i}}}get yview(){return{compute:t=>this.bottom-t,v_compute:t=>{const i=new Float64Array(t.length),e=this.bottom;for(let h=0;h<t.length;h++)i[h]=e-t[h];return i}}}}e.BBox=s,s.__name__="BBox"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),n=i.__importStar(t(18)),r=i.__importStar(t(88)),a=i.__importStar(t(32)),_=i.__importStar(t(70)),l=t(67),o=t(71),h=t(72),c=t(12),d=t(17),p=t(8),y=t(83),u=t(90),g=t(79);class x extends l.View{constructor(){super(...arguments),this._nohit_warned=new Set}get renderer(){return this.parent}get has_webgl(){return null!=this.glglyph}initialize(){super.initialize(),this.visuals=new _.Visuals(this.model)}async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e){let s=null;try{s=await Promise.resolve().then(()=>i.__importStar(t(371)))}catch(t){if("MODULE_NOT_FOUND"!==t.code)throw t;h.logger.warn("WebGL was requested and is supported, but bokeh-gl(.min).js is not available, falling back to 2D rendering.")}if(null!=s){const t=s[this.model.type+"GLGlyph"];null!=t&&(this.glglyph=new t(e.gl,this))}}}set_visuals(t,e){this.visuals.set_all_indices(e),this.visuals.warm_cache(t),null!=this.glglyph&&this.glglyph.set_visuals_changed()}render(t,e,s){t.beginPath(),null!=this.glglyph&&this.glglyph.render(t,e,s)||this._render(t,e,s)}has_finished(){return!0}notify_finished(){this.renderer.notify_finished()}_bounds(t){return t}bounds(){return this._bounds(this.index.bbox)}log_bounds(){const t=r.empty(),e=this.index.search(r.positive_x());for(const s of e)s.x0<t.x0&&(t.x0=s.x0),s.x1>t.x1&&(t.x1=s.x1);const s=this.index.search(r.positive_y());for(const e of s)e.y0<t.y0&&(t.y0=e.y0),e.y1>t.y1&&(t.y1=e.y1);return this._bounds(t)}get_anchor_point(t,e,[s,i]){switch(t){case"center":return{x:this.scenterx(e,s,i),y:this.scentery(e,s,i)};default:return null}}sdist(t,e,s,i="edge",n=!1){let r,a;const _=e.length;if("center"==i){const t=c.map(s,t=>t/2);r=new Float64Array(_);for(let s=0;s<_;s++)r[s]=e[s]-t[s];a=new Float64Array(_);for(let s=0;s<_;s++)a[s]=e[s]+t[s]}else{r=e,a=new Float64Array(_);for(let t=0;t<_;t++)a[t]=r[t]+s[t]}const l=t.v_compute(r),o=t.v_compute(a);return n?c.map(l,(t,e)=>Math.ceil(Math.abs(o[e]-l[e]))):c.map(l,(t,e)=>Math.abs(o[e]-l[e]))}draw_legend_for_index(t,e,s){}hit_test(t){switch(t.type){case"point":if(null!=this._hit_point)return this._hit_point(t);break;case"span":if(null!=this._hit_span)return this._hit_span(t);break;case"rect":if(null!=this._hit_rect)return this._hit_rect(t);break;case"poly":if(null!=this._hit_poly)return this._hit_poly(t)}return this._nohit_warned.has(t.type)||(h.logger.debug(`'${t.type}' selection not available for ${this.model.type}`),this._nohit_warned.add(t.type)),null}_hit_rect_against_index(t){const{sx0:e,sx1:s,sy0:i,sy1:n}=t,[r,a]=this.renderer.xscale.r_invert(e,s),[_,l]=this.renderer.yscale.r_invert(i,n),o=this.index.indices({x0:r,x1:a,y0:_,y1:l});return new g.Selection({indices:o})}set_data(t,e,s){let i=this.model.materialize_dataspecs(t);if(e&&!(this instanceof y.LineView)){const t={};for(const s in i){const n=i[s];"_"===s.charAt(0)?t[s]=e.map(t=>n[t]):t[s]=n}i=t}const n=this;if(d.extend(n,i),this.renderer.plot_view.model.use_map&&(null!=n._x&&([n._x,n._y]=a.project_xy(n._x,n._y)),null!=n._xs&&([n._xs,n._ys]=a.project_xsys(n._xs,n._ys)),null!=n._x0&&([n._x0,n._y0]=a.project_xy(n._x0,n._y0)),null!=n._x1&&([n._x1,n._y1]=a.project_xy(n._x1,n._y1))),null!=this.renderer.plot_view.frame.x_ranges){const t=this.renderer.plot_view.frame.x_ranges[this.model.x_range_name],e=this.renderer.plot_view.frame.y_ranges[this.model.y_range_name];for(let[s,i]of this.model._coords)s="_"+s,i="_"+i,null!=n._xs?(t instanceof u.FactorRange&&(n[s]=c.map(n[s],e=>t.v_synthetic(e))),e instanceof u.FactorRange&&(n[i]=c.map(n[i],t=>e.v_synthetic(t)))):(t instanceof u.FactorRange&&(n[s]=t.v_synthetic(n[s])),e instanceof u.FactorRange&&(n[i]=e.v_synthetic(n[i])))}null!=this.glglyph&&this.glglyph.set_data_changed(n._x.length),this._set_data(s),this.index_data()}_set_data(t){}index_data(){this.index=this._index_data()}mask_data(t){return null!=this.glglyph||null==this._mask_data?t:this._mask_data()}map_data(){const t=this;for(let[e,s]of this.model._coords){const i="s"+e,n="s"+s;if(e="_"+e,s="_"+s,null!=t[e]&&(p.isArray(t[e][0])||p.isTypedArray(t[e][0]))){const r=t[e].length;t[i]=new Array(r),t[n]=new Array(r);for(let a=0;a<r;a++){const[r,_]=this.map_to_screen(t[e][a],t[s][a]);t[i][a]=r,t[n][a]=_}}else[t[i],t[n]]=this.map_to_screen(t[e],t[s])}this._map_data()}_map_data(){}map_to_screen(t,e){return this.renderer.plot_view.map_to_screen(t,e,this.model.x_range_name,this.model.y_range_name)}}s.GlyphView=x,x.__name__="GlyphView";class m extends o.Model{constructor(t){super(t)}static init_Glyph(){this.prototype._coords=[],this.internal({x_range_name:[n.String,"default"],y_range_name:[n.String,"default"]})}static coords(t){const e=this.prototype._coords.concat(t);this.prototype._coords=e;const s={};for(const[e,i]of t)s[e]=[n.CoordinateSpec],s[i]=[n.CoordinateSpec];this.define(s)}}s.Glyph=m,m.__name__="Glyph",m.init_Glyph()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const s=t(1),i=t(91),r=s.__importStar(t(18)),a=t(12),o=t(9),p=t(8),g=t(11);function c(t,e,n=0){const s=new Map;for(let i=0;i<t.length;i++){const r=t[i];if(s.has(r))throw new Error("duplicate factor or subfactor: "+r);s.set(r,{value:.5+i*(1+e)+n})}return[s,(t.length-1)*e]}function l(t,e,n,s=0){var i;const r=new Map,a=new Map;for(const[e,n]of t){const t=null!==(i=a.get(e))&&void 0!==i?i:[];a.set(e,[...t,n])}let p=s,g=0;for(const[t,s]of a){const i=s.length,[a,l]=c(s,n,p);g+=l;const u=o.sum(s.map(t=>a.get(t).value));r.set(t,{value:u/i,mapping:a}),p+=i+e+l}return[r,(a.size-1)*e+g]}function u(t,e,n,s,i=0){var r;const a=new Map,p=new Map;for(const[e,n,s]of t){const t=null!==(r=p.get(e))&&void 0!==r?r:[];p.set(e,[...t,[n,s]])}let g=i,c=0;for(const[t,i]of p){const r=i.length,[p,u]=l(i,n,s,g);c+=u;const h=o.sum(i.map(([t])=>p.get(t).value));a.set(t,{value:h/r,mapping:p}),g+=r+e+u}return[a,(p.size-1)*e+c]}n.map_one_level=c,n.map_two_levels=l,n.map_three_levels=u;class h extends i.Range{constructor(t){super(t)}static init_FactorRange(){this.define({factors:[r.Array,[]],factor_padding:[r.Number,0],subgroup_padding:[r.Number,.8],group_padding:[r.Number,1.4],range_padding:[r.Number,0],range_padding_units:[r.PaddingUnits,"percent"],start:[r.Number],end:[r.Number]}),this.internal({levels:[r.Number],mids:[r.Array,null],tops:[r.Array,null]})}get min(){return this.start}get max(){return this.end}initialize(){super.initialize(),this._init(!0)}connect_signals(){super.connect_signals(),this.connect(this.properties.factors.change,()=>this.reset()),this.connect(this.properties.factor_padding.change,()=>this.reset()),this.connect(this.properties.group_padding.change,()=>this.reset()),this.connect(this.properties.subgroup_padding.change,()=>this.reset()),this.connect(this.properties.range_padding.change,()=>this.reset()),this.connect(this.properties.range_padding_units.change,()=>this.reset())}reset(){this._init(!1),this.change.emit()}_lookup(t){switch(t.length){case 1:{const[e]=t,n=this._mapping.get(e);return null!=n?n.value:NaN}case 2:{const[e,n]=t,s=this._mapping.get(e);if(null!=s){const t=s.mapping.get(n);if(null!=t)return t.value}return NaN}case 3:{const[e,n,s]=t,i=this._mapping.get(e);if(null!=i){const t=i.mapping.get(n);if(null!=t){const e=t.mapping.get(s);if(null!=e)return e.value}}return NaN}default:g.unreachable()}}synthetic(t){if(p.isNumber(t))return t;if(p.isString(t))return this._lookup([t]);let e=0;const n=t[t.length-1];return p.isNumber(n)&&(e=n,t=t.slice(0,-1)),this._lookup(t)+e}v_synthetic(t){return a.map(t,t=>this.synthetic(t))}_init(t){const{levels:e,mapping:n,tops:s,mids:i,inside_padding:r}=(()=>{if(o.every(this.factors,p.isString)){const t=this.factors,[e,n]=c(t,this.factor_padding);return{levels:1,mapping:e,tops:null,mids:null,inside_padding:n}}if(o.every(this.factors,t=>p.isArray(t)&&2==t.length&&p.isString(t[0])&&p.isString(t[1]))){const t=this.factors,[e,n]=l(t,this.group_padding,this.factor_padding),s=[...e.keys()];return{levels:2,mapping:e,tops:s,mids:null,inside_padding:n}}if(o.every(this.factors,t=>p.isArray(t)&&3==t.length&&p.isString(t[0])&&p.isString(t[1])&&p.isString(t[2]))){const t=this.factors,[e,n]=u(t,this.group_padding,this.subgroup_padding,this.factor_padding),s=[...e.keys()],i=[];for(const[t,n]of e)for(const e of n.mapping.keys())i.push([t,e]);return{levels:3,mapping:e,tops:s,mids:i,inside_padding:n}}g.unreachable()})();this._mapping=n,this.tops=s,this.mids=i;let a=0,h=this.factors.length+r;if("percent"==this.range_padding_units){const t=(h-a)*this.range_padding/2;a-=t,h+=t}else a-=this.range_padding,h+=this.range_padding;this.setv({start:a,end:h,levels:e},{silent:t}),"auto"==this.bounds&&this.setv({bounds:[a,h]},{silent:!0})}}n.FactorRange=h,h.__name__="FactorRange",h.init_FactorRange()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const i=e(1),a=e(71),r=i.__importStar(e(18));class s extends a.Model{constructor(e){super(e),this.have_updated_interactively=!1}static init_Range(){this.define({bounds:[r.Any],min_interval:[r.Any],max_interval:[r.Any]}),this.internal({plots:[r.Array,[]]})}get is_reversed(){return this.start>this.end}}n.Range=s,s.__name__="Range",s.init_Range()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1).__importStar(e(93));i.generic_line_legend=function(e,t,{x0:i,x1:n,y0:c,y1:o},r){t.save(),t.beginPath(),t.moveTo(i,(c+o)/2),t.lineTo(n,(c+o)/2),e.line.doit&&(e.line.set_vectorize(t,r),t.stroke()),t.restore()},i.generic_area_legend=function(e,t,{x0:i,x1:n,y0:c,y1:o},r){const l=.1*Math.abs(n-i),a=.1*Math.abs(o-c),s=i+l,_=n-l,h=c+a,v=o-a;e.fill.doit&&(e.fill.set_vectorize(t,r),t.fillRect(s,h,_-s,v-h)),null!=e.hatch&&e.hatch.doit&&(e.hatch.set_vectorize(t,r),t.fillRect(s,h,_-s,v-h)),e.line&&e.line.doit&&(t.beginPath(),t.rect(s,h,_-s,v-h),e.line.set_vectorize(t,r),t.stroke())},i.line_interpolation=function(e,t,i,c,o,r){const{sx:l,sy:a}=t;let s,_,h,v;"point"==t.type?([h,v]=e.yscale.r_invert(a-1,a+1),[s,_]=e.xscale.r_invert(l-1,l+1)):"v"==t.direction?([h,v]=e.yscale.r_invert(a,a),[s,_]=[Math.min(i-1,o-1),Math.max(i+1,o+1)]):([s,_]=e.xscale.r_invert(l,l),[h,v]=[Math.min(c-1,r-1),Math.max(c+1,r+1)]);const{x,y}=n.check_2_segments_intersect(s,h,_,v,i,c,o,r);return[x,y]}},
function _(t,n,e){function i(t){return t*t}function o(t,n){return i(t.x-n.x)+i(t.y-n.y)}function r(t,n,e){const i=o(n,e);if(0==i)return o(t,n);const r=((t.x-n.x)*(e.x-n.x)+(t.y-n.y)*(e.y-n.y))/i;return o(t,r<0?n:r>1?e:{x:n.x+r*(e.x-n.x),y:n.y+r*(e.y-n.y)})}Object.defineProperty(e,"__esModule",{value:!0}),e.point_in_poly=function(t,n,e,i){let o=!1,r=e[e.length-1],s=i[i.length-1];for(let u=0;u<e.length;u++){const c=e[u],_=i[u];s<n!=_<n&&r+(n-s)/(_-s)*(c-r)<t&&(o=!o),r=c,s=_}return o},e.point_in_ellipse=function(t,n,e,i,o,r,s){return((Math.cos(e)/o)**2+(Math.sin(e)/i)**2)*(t-r)**2+2*Math.cos(e)*Math.sin(e)*((1/o)**2-(1/i)**2)*(t-r)*(n-s)+((Math.cos(e)/i)**2+(Math.sin(e)/o)**2)*(n-s)**2<=1},e.dist_2_pts=o,e.dist_to_segment_squared=r,e.dist_to_segment=function(t,n,e){return Math.sqrt(r(t,n,e))},e.check_2_segments_intersect=function(t,n,e,i,o,r,s,u){const c=(u-r)*(e-t)-(s-o)*(i-n);if(0==c)return{hit:!1,x:null,y:null};{let _=n-r,l=t-o;const y=(e-t)*_-(i-n)*l;return _=((s-o)*_-(u-r)*l)/c,l=y/c,{hit:_>0&&_<1&&l>0&&l<1,x:t+_*(e-t),y:n+_*(i-n)}}}},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const s=e(1),l=e(84),_=e(92),n=s.__importStar(e(93)),o=s.__importStar(e(23)),a=e(79);class h extends l.XYGlyphView{_inner_loop(e,i,t,s,l){for(const _ of i)0!=_?isNaN(t[_]+s[_])?(e.closePath(),l.apply(e),e.beginPath()):e.lineTo(t[_],s[_]):(e.beginPath(),e.moveTo(t[_],s[_]));e.closePath(),l.call(e)}_render(e,i,{sx:t,sy:s}){this.visuals.fill.doit&&(this.visuals.fill.set_value(e),this._inner_loop(e,i,t,s,e.fill)),this.visuals.hatch.doit2(e,0,()=>this._inner_loop(e,i,t,s,e.fill),()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_value(e),this._inner_loop(e,i,t,s,e.stroke))}draw_legend_for_index(e,i,t){_.generic_area_legend(this.visuals,e,i,t)}_hit_point(e){const i=new a.Selection;return n.point_in_poly(e.sx,e.sy,this.sx,this.sy)&&(i.add_to_selected_glyphs(this.model),i.get_view=()=>this),i}}t.PatchView=h,h.__name__="PatchView";class r extends l.XYGlyph{constructor(e){super(e)}static init_Patch(){this.prototype.default_view=h,this.mixins([o.Line,o.Fill,o.Hatch])}}t.Patch=r,r.__name__="Patch",r.init_Patch()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(96),n=e(85),a=i.__importStar(e(93)),_=i.__importStar(e(18)),h=e(79);class l extends r.AreaView{_index_data(){const e=[];for(let t=0,s=this._x1.length;t<s;t++){const s=this._x1[t],i=this._x2[t],r=this._y[t];!isNaN(s+i+r)&&isFinite(s+i+r)&&e.push({x0:Math.min(s,i),y0:r,x1:Math.max(s,i),y1:r,i:t})}return new n.SpatialIndex(e)}_inner(e,t,s,i,r){e.beginPath();for(let s=0,r=t.length;s<r;s++)e.lineTo(t[s],i[s]);for(let t=s.length-1;t>=0;t--)e.lineTo(s[t],i[t]);e.closePath(),r.call(e)}_render(e,t,{sx1:s,sx2:i,sy:r}){this.visuals.fill.doit&&(this.visuals.fill.set_value(e),this._inner(e,s,i,r,e.fill)),this.visuals.hatch.doit2(e,0,()=>this._inner(e,s,i,r,e.fill),()=>this.renderer.request_render())}_hit_point(e){const t=this.sy.length,s=new Float64Array(2*t),i=new Float64Array(2*t);for(let e=0,r=t;e<r;e++)s[e]=this.sx1[e],i[e]=this.sy[e],s[t+e]=this.sx2[t-e-1],i[t+e]=this.sy[t-e-1];const r=new h.Selection;return a.point_in_poly(e.sx,e.sy,s,i)&&(r.add_to_selected_glyphs(this.model),r.get_view=()=>this),r}scenterx(e){return(this.sx1[e]+this.sx2[e])/2}scentery(e){return this.sy[e]}_map_data(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)}}s.HAreaView=l,l.__name__="HAreaView";class o extends r.Area{constructor(e){super(e)}static init_HArea(){this.prototype.default_view=l,this.define({x1:[_.CoordinateSpec],x2:[_.CoordinateSpec],y:[_.CoordinateSpec]})}}s.HArea=o,o.__name__="HArea",o.init_HArea()},
function _(e,_,i){Object.defineProperty(i,"__esModule",{value:!0});const a=e(1),r=e(89),t=e(92),n=a.__importStar(e(23));class s extends r.GlyphView{draw_legend_for_index(e,_,i){t.generic_area_legend(this.visuals,e,_,i)}}i.AreaView=s,s.__name__="AreaView";class c extends r.Glyph{constructor(e){super(e)}static init_Area(){this.mixins([n.Fill,n.HatchVector])}}i.Area=c,c.__name__="Area",c.init_Area()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(96),n=e(85),a=i.__importStar(e(93)),_=i.__importStar(e(18)),h=e(79);class l extends r.AreaView{_index_data(){const e=[];for(let t=0,s=this._x.length;t<s;t++){const s=this._x[t],i=this._y1[t],r=this._y2[t];!isNaN(s+i+r)&&isFinite(s+i+r)&&e.push({x0:s,y0:Math.min(i,r),x1:s,y1:Math.max(i,r),i:t})}return new n.SpatialIndex(e)}_inner(e,t,s,i,r){e.beginPath();for(let i=0,r=s.length;i<r;i++)e.lineTo(t[i],s[i]);for(let s=i.length-1;s>=0;s--)e.lineTo(t[s],i[s]);e.closePath(),r.call(e)}_render(e,t,{sx:s,sy1:i,sy2:r}){this.visuals.fill.doit&&(this.visuals.fill.set_value(e),this._inner(e,s,i,r,e.fill)),this.visuals.hatch.doit2(e,0,()=>this._inner(e,s,i,r,e.fill),()=>this.renderer.request_render())}scenterx(e){return this.sx[e]}scentery(e){return(this.sy1[e]+this.sy2[e])/2}_hit_point(e){const t=this.sx.length,s=new Float64Array(2*t),i=new Float64Array(2*t);for(let e=0,r=t;e<r;e++)s[e]=this.sx[e],i[e]=this.sy1[e],s[t+e]=this.sx[t-e-1],i[t+e]=this.sy2[t-e-1];const r=new h.Selection;return a.point_in_poly(e.sx,e.sy,s,i)&&(r.add_to_selected_glyphs(this.model),r.get_view=()=>this),r}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)}}s.VAreaView=l,l.__name__="VAreaView";class o extends r.Area{constructor(e){super(e)}static init_VArea(){this.prototype.default_view=l,this.define({x:[_.CoordinateSpec],y1:[_.CoordinateSpec],y2:[_.CoordinateSpec]})}}s.VArea=o,o.__name__="VArea",o.init_VArea()},
function _(i,e,s){Object.defineProperty(s,"__esModule",{value:!0});const t=i(1),n=i(71),c=t.__importStar(i(18)),o=i(79),r=i(9),_=i(77);class h extends n.Model{constructor(i){super(i)}static init_CDSView(){this.define({filters:[c.Array,[]],source:[c.Instance]}),this.internal({indices:[c.Array,[]],indices_map:[c.Any,{}]})}initialize(){super.initialize(),this.compute_indices()}connect_signals(){super.connect_signals(),this.connect(this.properties.filters.change,()=>{this.compute_indices(),this.change.emit()});const i=()=>{const i=()=>this.compute_indices();null!=this.source&&(this.connect(this.source.change,i),this.source instanceof _.ColumnarDataSource&&(this.connect(this.source.streaming,i),this.connect(this.source.patching,i)))};let e=null!=this.source;e?i():this.connect(this.properties.source.change,()=>{e||(i(),e=!0)})}compute_indices(){const i=this.filters.map(i=>i.compute_indices(this.source)).filter(i=>null!=i);i.length>0?this.indices=r.intersection.apply(this,i):this.source instanceof _.ColumnarDataSource&&(this.indices=this.source.get_indices()),this.indices_map_to_subset()}indices_map_to_subset(){this.indices_map={};for(let i=0;i<this.indices.length;i++)this.indices_map[this.indices[i]]=i}convert_selection_from_subset(i){const e=new o.Selection;e.update_through_union(i);const s=i.indices.map(i=>this.indices[i]);return e.indices=s,e.image_indices=i.image_indices,e}convert_selection_to_subset(i){const e=new o.Selection;e.update_through_union(i);const s=i.indices.map(i=>this.indices_map[i]);return e.indices=s,e.image_indices=i.image_indices,e}convert_indices_from_subset(i){return i.map(i=>this.indices[i])}}s.CDSView=h,h.__name__="CDSView",h.init_CDSView()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(9);async function i(e,n,t){const o=new e(Object.assign(Object.assign({},t),{model:n}));return o.initialize(),await o.lazy_initialize(),o}t.build_view=async function(e,n={parent:null},t=(e=>e.default_view)){const o=await i(t(e),e,n);return o.connect_signals(),o},t.build_views=async function(e,n,t={parent:null},s=(e=>e.default_view)){const c=o.difference([...e.keys()],n);for(const n of c)e.get(n).remove(),e.delete(n);const a=[],f=n.filter(n=>!e.has(n));for(const n of f){const o=await i(s(n),n,t);e.set(n,o),a.push(o)}for(const e of a)e.connect_signals();return a},t.remove_views=function(e){for(const[n,t]of e)t.remove(),e.delete(n)}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const s=e(1),r=e(82),i=e(101),a=s.__importStar(e(18)),d=e(99);class _ extends r.DataRendererView{initialize(){super.initialize(),this.xscale=this.plot_view.frame.xscales.default,this.yscale=this.plot_view.frame.yscales.default,this._renderer_views=new Map}async lazy_initialize(){[this.node_view,this.edge_view]=await d.build_views(this._renderer_views,[this.model.node_renderer,this.model.edge_renderer],{parent:this.parent}),this.set_data()}remove(){d.remove_views(this._renderer_views),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.layout_provider.change,()=>this.set_data()),this.connect(this.model.node_renderer.data_source._select,()=>this.set_data()),this.connect(this.model.node_renderer.data_source.inspect,()=>this.set_data()),this.connect(this.model.node_renderer.data_source.change,()=>this.set_data()),this.connect(this.model.edge_renderer.data_source._select,()=>this.set_data()),this.connect(this.model.edge_renderer.data_source.inspect,()=>this.set_data()),this.connect(this.model.edge_renderer.data_source.change,()=>this.set_data());const{x_ranges:e,y_ranges:t}=this.plot_view.frame;for(const t in e){const n=e[t];this.connect(n.change,()=>this.set_data())}for(const e in t){const n=t[e];this.connect(n.change,()=>this.set_data())}}set_data(e=!0){this.node_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.edge_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0});const t=this.node_view.glyph;[t._x,t._y]=this.model.layout_provider.get_node_coordinates(this.model.node_renderer.data_source);const n=this.edge_view.glyph;[n._xs,n._ys]=this.model.layout_provider.get_edge_coordinates(this.model.edge_renderer.data_source),t.index_data(),n.index_data(),e&&this.request_render()}render(){this.edge_view.render(),this.node_view.render()}}n.GraphRendererView=_,_.__name__="GraphRendererView";class o extends r.DataRenderer{constructor(e){super(e)}static init_GraphRenderer(){this.prototype.default_view=_,this.define({layout_provider:[a.Instance],node_renderer:[a.Instance],edge_renderer:[a.Instance],selection_policy:[a.Instance,()=>new i.NodesOnly],inspection_policy:[a.Instance,()=>new i.NodesOnly]})}get_selection_manager(){return this.node_renderer.data_source.selection_manager}}n.GraphRenderer=o,o.__name__="GraphRenderer",o.init_GraphRenderer()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const d=e(71),s=e(12),o=e(9),_=e(79);class i extends d.Model{constructor(e){super(e)}_hit_test_nodes(e,t){if(!t.model.visible)return null;const n=t.node_view.glyph.hit_test(e);return null==n?null:t.node_view.model.view.convert_selection_from_subset(n)}_hit_test_edges(e,t){if(!t.model.visible)return null;const n=t.edge_view.glyph.hit_test(e);return null==n?null:t.edge_view.model.view.convert_selection_from_subset(n)}}n.GraphHitTestPolicy=i,i.__name__="GraphHitTestPolicy";class r extends i{constructor(e){super(e)}hit_test(e,t){return this._hit_test_nodes(e,t)}do_selection(e,t,n,d){if(null==e)return!1;const s=t.node_renderer.data_source.selected;return s.update(e,n,d),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.model.get_selection_manager().get_or_create_inspector(n.node_view.model);return o.update(e,d,s),n.node_view.model.data_source.setv({inspected:o},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:t}]),!o.is_empty()}}n.NodesOnly=r,r.__name__="NodesOnly";class c extends i{constructor(e){super(e)}hit_test(e,t){return this._hit_test_nodes(e,t)}get_linked_edges(e,t,n){let d=[];"selection"==n?d=e.selected.indices.map(t=>e.data.index[t]):"inspection"==n&&(d=e.inspected.indices.map(t=>e.data.index[t]));const s=[];for(let e=0;e<t.data.start.length;e++)(o.contains(d,t.data.start[e])||o.contains(d,t.data.end[e]))&&s.push(e);const i=new _.Selection;for(const e of s)i.multiline_indices[e]=[0];return i.indices=s,i}do_selection(e,t,n,d){if(null==e)return!1;const s=t.node_renderer.data_source.selected;s.update(e,n,d);const o=t.edge_renderer.data_source.selected,_=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(_,n,d),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);o.update(e,d,s),n.node_view.model.data_source.setv({inspected:o},{silent:!0});const _=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model),i=this.get_linked_edges(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return _.update(i,d,s),n.edge_view.model.data_source.setv({inspected:_},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:t}]),!o.is_empty()}}n.NodesAndLinkedEdges=c,c.__name__="NodesAndLinkedEdges";class a extends i{constructor(e){super(e)}hit_test(e,t){return this._hit_test_edges(e,t)}get_linked_nodes(e,t,n){let d=[];"selection"==n?d=t.selected.indices:"inspection"==n&&(d=t.inspected.indices);const i=[];for(const e of d)i.push(t.data.start[e]),i.push(t.data.end[e]);const r=o.uniq(i).map(t=>s.indexOf(e.data.index,t));return new _.Selection({indices:r})}do_selection(e,t,n,d){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;s.update(e,n,d);const o=t.node_renderer.data_source.selected,_=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(_,n,d),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model);o.update(e,d,s),n.edge_view.model.data_source.setv({inspected:o},{silent:!0});const _=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model),i=this.get_linked_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return _.update(i,d,s),n.node_view.model.data_source.setv({inspected:_},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view,{geometry:t}]),!o.is_empty()}}n.EdgesAndLinkedNodes=a,a.__name__="EdgesAndLinkedNodes"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const s=e(71);class o extends s.Model{do_selection(e,t,n,s){return null!==e&&(t.selected.update(e,n,s),t._select.emit(),!t.selected.is_empty())}}n.SelectionPolicy=o,o.__name__="SelectionPolicy";class r extends o{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!==t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_intersection(t);return e}return null}}n.IntersectRenderers=r,r.__name__="IntersectRenderers";class c extends o{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!==t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_union(t);return e}return null}}n.UnionRenderers=c,c.__name__="UnionRenderers"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0}),n.concat=function(t,...e){let n=t.length;for(const t of e)n+=t.length;const o=new t.constructor(n);o.set(t,0);let c=t.length;for(const t of e)o.set(t,c),c+=t.length;return o}},
function _(n,o,e){function t(...n){const o=new Set;for(const e of n)for(const n of e)o.add(n);return o}Object.defineProperty(e,"__esModule",{value:!0}),e.union=t,e.intersection=function(n,...o){const e=new Set;n:for(const t of n){for(const n of o)if(!n.has(t))continue n;e.add(t)}return e},e.difference=function(n,...o){const e=new Set(n);for(const n of t(...o))e.delete(n);return e}},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(13);class o{constructor(e){this.document=e}}s.DocumentEvent=o,o.__name__="DocumentEvent";class r extends o{constructor(e,t,s){super(e),this.events=t,this.setter_id=s}}s.DocumentEventBatch=r,r.__name__="DocumentEventBatch";class d extends o{}s.DocumentChangedEvent=d,d.__name__="DocumentChangedEvent";class _ extends d{constructor(e,t,s){super(e),this.msg_type=t,this.msg_data=s}json(e){const t=this.msg_data,s=n.HasProps._value_to_json(t),o=new Set;return n.HasProps._value_record_references(t,o,{recursive:!0}),{kind:"MessageSent",msg_type:this.msg_type,msg_data:s}}}s.MessageSentEvent=_,_.__name__="MessageSentEvent";class i extends d{constructor(e,t,s,n,o,r,d){super(e),this.model=t,this.attr=s,this.old=n,this.new_=o,this.setter_id=r,this.hint=d}json(e){if("id"===this.attr)throw new Error("'id' field should never change, whatever code just set it is wrong");if(null!=this.hint)return this.hint.json(e);const t=this.new_,s=n.HasProps._value_to_json(t),o=new Set;n.HasProps._value_record_references(t,o,{recursive:!0}),o.has(this.model)&&this.model!==t&&o.delete(this.model);for(const t of o)e.add(t);return{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:s}}}s.ModelChangedEvent=i,i.__name__="ModelChangedEvent";class a extends d{constructor(e,t,s){super(e),this.column_source=t,this.patches=s}json(e){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}}}s.ColumnsPatchedEvent=a,a.__name__="ColumnsPatchedEvent";class c extends d{constructor(e,t,s,n){super(e),this.column_source=t,this.data=s,this.rollover=n}json(e){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}}}s.ColumnsStreamedEvent=c,c.__name__="ColumnsStreamedEvent";class h extends d{constructor(e,t,s){super(e),this.title=t,this.setter_id=s}json(e){return{kind:"TitleChanged",title:this.title}}}s.TitleChangedEvent=h,h.__name__="TitleChangedEvent";class u extends d{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}json(e){return n.HasProps._value_record_references(this.model,e,{recursive:!0}),{kind:"RootAdded",model:this.model.ref()}}}s.RootAddedEvent=u,u.__name__="RootAddedEvent";class l extends d{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}json(e){return{kind:"RootRemoved",model:this.model.ref()}}}s.RootRemovedEvent=l,l.__name__="RootRemovedEvent"},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),_=e(31),o=e(76),l=i.__importStar(e(23)),a=i.__importStar(e(18));class n extends _.AnnotationView{initialize(){super.initialize(),this.set_data(this.model.source)}connect_signals(){super.connect_signals(),this.connect(this.model.source.streaming,()=>this.set_data(this.model.source)),this.connect(this.model.source.patching,()=>this.set_data(this.model.source)),this.connect(this.model.source.change,()=>this.set_data(this.model.source))}set_data(e){super.set_data(e),this.visuals.warm_cache(e),this.plot_view.request_render()}_map_data(){const{frame:e}=this.plot_view,t=this.model.dimension,s=e.xscales[this.model.x_range_name],i=e.yscales[this.model.y_range_name],_="height"==t?i:s,o="height"==t?s:i,l="height"==t?e.yview:e.xview,a="height"==t?e.xview:e.yview;let n,h,r;n="data"==this.model.properties.lower.units?_.v_compute(this._lower):l.v_compute(this._lower),h="data"==this.model.properties.upper.units?_.v_compute(this._upper):l.v_compute(this._upper),r="data"==this.model.properties.base.units?o.v_compute(this._base):a.v_compute(this._base);const[c,p]="height"==t?[1,0]:[0,1],u=[n,r],d=[h,r];this._lower_sx=u[c],this._lower_sy=u[p],this._upper_sx=d[c],this._upper_sy=d[p]}render(){if(!this.model.visible)return;this._map_data();const{ctx:e}=this.layer;e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let t=0,s=this._lower_sx.length;t<s;t++)e.lineTo(this._lower_sx[t],this._lower_sy[t]);for(let t=this._upper_sx.length-1;t>=0;t--)e.lineTo(this._upper_sx[t],this._upper_sy[t]);e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(e),e.fill()),e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let t=0,s=this._lower_sx.length;t<s;t++)e.lineTo(this._lower_sx[t],this._lower_sy[t]);this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke()),e.beginPath(),e.moveTo(this._upper_sx[0],this._upper_sy[0]);for(let t=0,s=this._upper_sx.length;t<s;t++)e.lineTo(this._upper_sx[t],this._upper_sy[t]);this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke())}}s.BandView=n,n.__name__="BandView";class h extends _.Annotation{constructor(e){super(e)}static init_Band(){this.prototype.default_view=n,this.mixins([l.Line,l.Fill]),this.define({lower:[a.DistanceSpec],upper:[a.DistanceSpec],base:[a.DistanceSpec],dimension:[a.Dimension,"height"],source:[a.Instance,()=>new o.ColumnDataSource],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}}s.Band=h,h.__name__="Band",h.init_Band()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});const s=t(1),n=t(31),o=t(14),l=s.__importStar(t(23)),a=s.__importStar(t(18)),r=t(88);e.EDGE_TOLERANCE=2.5;class h extends n.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_paint(this)),this.connect(this.model.data_update,()=>this.plot_view.request_paint(this))}render(){if(!this.model.visible)return;if(null==this.model.left&&null==this.model.right&&null==this.model.top&&null==this.model.bottom)return;const{frame:t}=this.plot_view,i=t.xscales[this.model.x_range_name],e=t.yscales[this.model.y_range_name],s=(t,i,e,s,n)=>{let o;return o=null!=t?this.model.screen?t:"data"==i?e.compute(t):s.compute(t):n,o};this.sleft=s(this.model.left,this.model.left_units,i,t.xview,t._left.value),this.sright=s(this.model.right,this.model.right_units,i,t.xview,t._right.value),this.stop=s(this.model.top,this.model.top_units,e,t.yview,t._top.value),this.sbottom=s(this.model.bottom,this.model.bottom_units,e,t.yview,t._bottom.value),this._paint_box(this.sleft,this.sright,this.sbottom,this.stop)}_paint_box(t,i,e,s){const{ctx:n}=this.layer;n.save(),n.beginPath(),n.rect(t,s,i-t,e-s),this.visuals.fill.doit&&(this.visuals.fill.set_value(n),n.fill()),this.visuals.line.doit&&(this.visuals.line.set_value(n),n.stroke()),n.restore()}interactive_bbox(){const t=this.model.properties.line_width.value()+e.EDGE_TOLERANCE;return new r.BBox({x0:this.sleft-t,y0:this.stop-t,x1:this.sright+t,y1:this.sbottom+t})}interactive_hit(t,i){if(null==this.model.in_cursor)return!1;return this.interactive_bbox().contains(t,i)}cursor(t,i){return Math.abs(t-this.sleft)<3||Math.abs(t-this.sright)<3?this.model.ew_cursor:Math.abs(i-this.sbottom)<3||Math.abs(i-this.stop)<3?this.model.ns_cursor:t>this.sleft&&t<this.sright&&i>this.stop&&i<this.sbottom?this.model.in_cursor:null}}e.BoxAnnotationView=h,h.__name__="BoxAnnotationView";class _ extends n.Annotation{constructor(t){super(t)}static init_BoxAnnotation(){this.prototype.default_view=h,this.mixins([l.Line,l.Fill]),this.define({render_mode:[a.RenderMode,"canvas"],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"],top:[a.Number,null],top_units:[a.SpatialUnits,"data"],bottom:[a.Number,null],bottom_units:[a.SpatialUnits,"data"],left:[a.Number,null],left_units:[a.SpatialUnits,"data"],right:[a.Number,null],right_units:[a.SpatialUnits,"data"]}),this.internal({screen:[a.Boolean,!1],ew_cursor:[a.String,null],ns_cursor:[a.String,null],in_cursor:[a.String,null]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}initialize(){super.initialize(),this.data_update=new o.Signal0(this,"data_update")}update({left:t,right:i,top:e,bottom:s}){this.setv({left:t,right:i,top:e,bottom:s,screen:!0},{silent:!0}),this.data_update.emit()}}e.BoxAnnotation=_,_.__name__="BoxAnnotation",_.init_BoxAnnotation()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const o=t(1),a=t(31),s=t(109),r=t(113),l=t(115),n=t(120),_=t(130),h=t(131),m=o.__importStar(t(23)),d=o.__importStar(t(18)),c=o.__importStar(t(132)),u=t(9),p=t(12),g=t(8),f=t(11);class b extends a.AnnotationView{initialize(){super.initialize(),this._set_canvas_image()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.visible.change,()=>this.plot_view.request_render()),this.connect(this.model.ticker.change,()=>this.plot_view.request_render()),this.connect(this.model.formatter.change,()=>this.plot_view.request_render()),null!=this.model.color_mapper&&this.connect(this.model.color_mapper.change,()=>{this._set_canvas_image(),this.plot_view.request_render()})}_get_size(){if(null==this.model.color_mapper)return{width:0,height:0};{const{width:t,height:e}=this.compute_legend_dimensions();return{width:t,height:e}}}_set_canvas_image(){if(null==this.model.color_mapper)return;let t,e,{palette:i}=this.model.color_mapper;switch("vertical"==this.model.orientation&&(i=u.reversed(i)),this.model.orientation){case"vertical":[t,e]=[1,i.length];break;case"horizontal":[t,e]=[i.length,1]}const o=document.createElement("canvas");o.width=t,o.height=e;const a=o.getContext("2d"),s=a.getImageData(0,0,t,e),r=new l.LinearColorMapper({palette:i}).rgba_mapper.v_compute(u.range(0,i.length));s.data.set(r),a.putImageData(s,0,0),this.image=o}compute_legend_dimensions(){const t=this._computed_image_dimensions(),[e,i]=[t.height,t.width],o=this._get_label_extent(),a=this._title_extent(),s=this._tick_extent(),{padding:r}=this.model;let l,n;switch(this.model.orientation){case"vertical":l=e+a+2*r,n=i+s+o+2*r;break;case"horizontal":l=e+a+s+o+2*r,n=i+2*r}return{width:n,height:l}}compute_legend_location(){const t=this.compute_legend_dimensions(),[e,i]=[t.height,t.width],o=this.model.margin,a=null!=this.panel?this.panel:this.plot_view.frame,[s,r]=a.bbox.ranges,{location:l}=this.model;let n,_;if(g.isString(l))switch(l){case"top_left":n=s.start+o,_=r.start+o;break;case"top_center":n=(s.end+s.start)/2-i/2,_=r.start+o;break;case"top_right":n=s.end-o-i,_=r.start+o;break;case"bottom_right":n=s.end-o-i,_=r.end-o-e;break;case"bottom_center":n=(s.end+s.start)/2-i/2,_=r.end-o-e;break;case"bottom_left":n=s.start+o,_=r.end-o-e;break;case"center_left":n=s.start+o,_=(r.end+r.start)/2-e/2;break;case"center":n=(s.end+s.start)/2-i/2,_=(r.end+r.start)/2-e/2;break;case"center_right":n=s.end-o-i,_=(r.end+r.start)/2-e/2}else if(g.isArray(l)&&2==l.length){const[t,i]=l;n=a.xview.compute(t),_=a.yview.compute(i)-e}else f.unreachable();return{sx:n,sy:_}}render(){if(!this.model.visible||null==this.model.color_mapper)return;const{ctx:t}=this.layer;t.save();const{sx:e,sy:i}=this.compute_legend_location();t.translate(e,i),this._draw_bbox(t);const o=this._get_image_offset();if(t.translate(o.x,o.y),this._draw_image(t),null!=this.model.color_mapper.low&&null!=this.model.color_mapper.high){const e=this.tick_info();this._draw_major_ticks(t,e),this._draw_minor_ticks(t,e),this._draw_major_labels(t,e)}this.model.title&&this._draw_title(t),t.restore()}_draw_bbox(t){const e=this.compute_legend_dimensions();t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(0,0,e.width,e.height)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()}_draw_image(t){const e=this._computed_image_dimensions();t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this.image,0,0,e.width,e.height),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()}_draw_major_ticks(t,e){if(!this.visuals.major_tick_line.doit)return;const[i,o]=this._normals(),a=this._computed_image_dimensions(),[s,r]=[a.width*i,a.height*o],[l,n]=e.coords.major,_=this.model.major_tick_in,h=this.model.major_tick_out;t.save(),t.translate(s,r),this.visuals.major_tick_line.set_value(t);for(let e=0,a=l.length;e<a;e++)t.beginPath(),t.moveTo(Math.round(l[e]+i*h),Math.round(n[e]+o*h)),t.lineTo(Math.round(l[e]-i*_),Math.round(n[e]-o*_)),t.stroke();t.restore()}_draw_minor_ticks(t,e){if(!this.visuals.minor_tick_line.doit)return;const[i,o]=this._normals(),a=this._computed_image_dimensions(),[s,r]=[a.width*i,a.height*o],[l,n]=e.coords.minor,_=this.model.minor_tick_in,h=this.model.minor_tick_out;t.save(),t.translate(s,r),this.visuals.minor_tick_line.set_value(t);for(let e=0,a=l.length;e<a;e++)t.beginPath(),t.moveTo(Math.round(l[e]+i*h),Math.round(n[e]+o*h)),t.lineTo(Math.round(l[e]-i*_),Math.round(n[e]-o*_)),t.stroke();t.restore()}_draw_major_labels(t,e){if(!this.visuals.major_label_text.doit)return;const[i,o]=this._normals(),a=this._computed_image_dimensions(),[s,r]=[a.width*i,a.height*o],l=this.model.label_standoff+this._tick_extent(),[n,_]=[l*i,l*o],[h,m]=e.coords.major,d=e.labels.major;this.visuals.major_label_text.set_value(t),t.save(),t.translate(s+n,r+_);for(let e=0,a=h.length;e<a;e++)t.fillText(d[e],Math.round(h[e]+i*this.model.label_standoff),Math.round(m[e]+o*this.model.label_standoff));t.restore()}_draw_title(t){this.visuals.title_text.doit&&(t.save(),this.visuals.title_text.set_value(t),t.fillText(this.model.title,0,-this.model.title_standoff),t.restore())}_get_label_extent(){const t=this.tick_info().labels.major;let e;if(null==this.model.color_mapper.low||null==this.model.color_mapper.high||u.is_empty(t))e=0;else{const{ctx:i}=this.layer;switch(i.save(),this.visuals.major_label_text.set_value(i),this.model.orientation){case"vertical":e=u.max(t.map(t=>i.measureText(t.toString()).width));break;case"horizontal":e=c.measure_font(this.visuals.major_label_text.font_value()).height}e+=this.model.label_standoff,i.restore()}return e}_get_image_offset(){return{x:this.model.padding,y:this.model.padding+this._title_extent()}}_normals(){return"vertical"==this.model.orientation?[1,0]:[0,1]}_title_extent(){const t=this.model.title_text_font+" "+this.model.title_text_font_size+" "+this.model.title_text_font_style;return this.model.title?c.measure_font(t).height+this.model.title_standoff:0}_tick_extent(){return null!=this.model.color_mapper.low&&null!=this.model.color_mapper.high?u.max([this.model.major_tick_out,this.model.minor_tick_out]):0}_computed_image_dimensions(){const t=this.plot_view.frame._height.value,e=this.plot_view.frame._width.value,i=this._title_extent();let o,a;switch(this.model.orientation){case"vertical":"auto"==this.model.height?null!=this.panel?o=t-2*this.model.padding-i:(o=u.max([25*this.model.color_mapper.palette.length,.3*t]),o=u.min([o,.8*t-2*this.model.padding-i])):o=this.model.height,a="auto"==this.model.width?25:this.model.width;break;case"horizontal":o="auto"==this.model.height?25:this.model.height,"auto"==this.model.width?null!=this.panel?a=e-2*this.model.padding:(a=u.max([25*this.model.color_mapper.palette.length,.3*e]),a=u.min([a,.8*e-2*this.model.padding])):a=this.model.width}return{width:a,height:o}}_tick_coordinate_scale(t){const e={source_range:new h.Range1d({start:this.model.color_mapper.low,end:this.model.color_mapper.high}),target_range:new h.Range1d({start:0,end:t})};switch(this.model.color_mapper.type){case"LinearColorMapper":return new n.LinearScale(e);case"LogColorMapper":return new _.LogScale(e);default:f.unreachable()}}_format_major_labels(t,e){const i=this.model.formatter.doFormat(t,null);for(let t=0,o=e.length;t<o;t++)e[t]in this.model.major_label_overrides&&(i[t]=this.model.major_label_overrides[e[t]]);return i}tick_info(){const t=this._computed_image_dimensions();let e;switch(this.model.orientation){case"vertical":e=t.height;break;case"horizontal":e=t.width}const i=this._tick_coordinate_scale(e),[o,a]=this._normals(),[s,r]=[this.model.color_mapper.low,this.model.color_mapper.high],l=this.model.ticker.get_ticks(s,r,null,null,this.model.ticker.desired_num_ticks),n=l.major,_=l.minor,h=[[],[]],m=[[],[]];for(let t=0,e=n.length;t<e;t++)n[t]<s||n[t]>r||(h[o].push(n[t]),h[a].push(0));for(let t=0,e=_.length;t<e;t++)_[t]<s||_[t]>r||(m[o].push(_[t]),m[a].push(0));const d={major:this._format_major_labels(h[o],n)},c={major:[[],[]],minor:[[],[]]};return c.major[o]=i.v_compute(h[o]),c.minor[o]=i.v_compute(m[o]),c.major[a]=h[a],c.minor[a]=m[a],"vertical"==this.model.orientation&&(c.major[o]=p.map(c.major[o],t=>e-t),c.minor[o]=p.map(c.minor[o],t=>e-t)),{coords:c,labels:d}}}i.ColorBarView=b,b.__name__="ColorBarView";class v extends a.Annotation{constructor(t){super(t)}static init_ColorBar(){this.prototype.default_view=b,this.mixins([["major_label_",m.Text],["title_",m.Text],["major_tick_",m.Line],["minor_tick_",m.Line],["border_",m.Line],["bar_",m.Line],["background_",m.Fill]]),this.define({location:[d.Any,"top_right"],orientation:[d.Orientation,"vertical"],title:[d.String],title_standoff:[d.Number,2],width:[d.Any,"auto"],height:[d.Any,"auto"],scale_alpha:[d.Number,1],ticker:[d.Instance,()=>new s.BasicTicker],formatter:[d.Instance,()=>new r.BasicTickFormatter],major_label_overrides:[d.Any,{}],color_mapper:[d.Instance],label_standoff:[d.Number,5],margin:[d.Number,30],padding:[d.Number,10],major_tick_in:[d.Number,5],major_tick_out:[d.Number,0],minor_tick_in:[d.Number,0],minor_tick_out:[d.Number,0]}),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_align:"center",major_label_text_baseline:"middle",major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})}}i.ColorBar=v,v.__name__="ColorBar",v.init_ColorBar()},
function _(e,c,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(110);class r extends i.AdaptiveTicker{constructor(e){super(e)}}s.BasicTicker=r,r.__name__="BasicTicker"},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});const a=t(1),s=t(111),n=t(9),r=a.__importStar(t(18));class _ extends s.ContinuousTicker{constructor(t){super(t)}static init_AdaptiveTicker(){this.define({base:[r.Number,10],mantissas:[r.Array,[1,2,5]],min_interval:[r.Number,0],max_interval:[r.Number]})}initialize(){super.initialize();const t=n.nth(this.mantissas,-1)/this.base,i=n.nth(this.mantissas,0)*this.base;this.extended_mantissas=[t,...this.mantissas,i],this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()}get_interval(t,i,e){const a=i-t,s=this.get_ideal_interval(t,i,e),r=Math.floor(function(t,i=Math.E){return Math.log(t)/Math.log(i)}(s/this.base_factor,this.base)),_=this.base**r*this.base_factor,h=this.extended_mantissas,m=h.map(t=>Math.abs(e-a/(t*_))),o=h[n.argmin(m)];return c=o*_,l=this.get_min_interval(),u=this.get_max_interval(),Math.max(l,Math.min(u,c));var c,l,u}}e.AdaptiveTicker=_,_.__name__="AdaptiveTicker",_.init_AdaptiveTicker()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});const n=t(1),r=t(112),s=n.__importStar(t(18)),o=t(9);class _ extends r.Ticker{constructor(t){super(t)}static init_ContinuousTicker(){this.define({num_minor_ticks:[s.Number,5],desired_num_ticks:[s.Number,6]})}get_ticks(t,i,e,n,r){return this.get_ticks_no_defaults(t,i,n,this.desired_num_ticks)}get_ticks_no_defaults(t,i,e,n){const r=this.get_interval(t,i,n),s=Math.floor(t/r),_=Math.ceil(i/r);let c;c=isNaN(s)||isNaN(_)?[]:o.range(s,_+1);const u=c.map(t=>t*r).filter(e=>t<=e&&e<=i),a=this.num_minor_ticks,l=[];if(a>0&&u.length>0){const e=r/a,n=o.range(0,a).map(t=>t*e);for(const e of n.slice(1)){const n=u[0]-e;t<=n&&n<=i&&l.push(n)}for(const e of u)for(const r of n){const n=e+r;t<=n&&n<=i&&l.push(n)}}return{major:u,minor:l}}get_min_interval(){return this.min_interval}get_max_interval(){return null!=this.max_interval?this.max_interval:1/0}get_ideal_interval(t,i,e){return(i-t)/e}}e.ContinuousTicker=_,_.__name__="ContinuousTicker",_.init_ContinuousTicker()},
function _(e,c,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(71);class r extends o.Model{constructor(e){super(e)}}n.Ticker=r,r.__name__="Ticker"},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});const r=i(1),s=i(114),n=r.__importStar(i(18));class o extends s.TickFormatter{constructor(i){super(i),this.last_precision=3}static init_BasicTickFormatter(){this.define({precision:[n.Any,"auto"],use_scientific:[n.Boolean,!0],power_limit_high:[n.Number,5],power_limit_low:[n.Number,-3]})}get scientific_limit_low(){return 10**this.power_limit_low}get scientific_limit_high(){return 10**this.power_limit_high}_need_sci(i){if(!this.use_scientific)return!1;const{scientific_limit_high:t}=this,{scientific_limit_low:e}=this,r=i.length<2?0:Math.abs(i[1]-i[0])/1e4;for(const s of i){const i=Math.abs(s);if(!(i<=r)&&(i>=t||i<=e))return!0}return!1}_format_with_precision(i,t,e){const r=new Array(i.length);if(t)for(let t=0,s=i.length;t<s;t++)r[t]=i[t].toExponential(e);else for(let t=0,s=i.length;t<s;t++)r[t]=i[t].toFixed(e).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");return r}_auto_precision(i,t){const e=new Array(i.length),r=this.last_precision<=15;i:for(let s=this.last_precision;r?s<=15:s>=1;r?s++:s--){if(t){e[0]=i[0].toExponential(s);for(let t=1;t<i.length;t++)if(e[t]==e[t-1])continue i;this.last_precision=s;break}e[0]=i[0].toFixed(s).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");for(let t=1;t<i.length;t++)if(e[t]=i[t].toFixed(s).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,""),e[t]==e[t-1])continue i;this.last_precision=s;break}return this.last_precision}doFormat(i,t){if(0==i.length)return[];const e=this._need_sci(i),r="auto"==this.precision?this._auto_precision(i,e):this.precision;return this._format_with_precision(i,e,r)}}e.BasicTickFormatter=o,o.__name__="BasicTickFormatter",o.init_BasicTickFormatter()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const r=e(71);class c extends r.Model{constructor(e){super(e)}}o.TickFormatter=c,c.__name__="TickFormatter"},
function _(o,n,l){Object.defineProperty(l,"__esModule",{value:!0});const e=o(116),t=o(12);class i extends e.ContinuousColorMapper{constructor(o){super(o)}_v_compute(o,n,l,e){const{nan_color:i,low_color:r,high_color:s}=e,c=null!=this.low?this.low:t.min(o),h=null!=this.high?this.high:t.max(o),u=l.length-1,a=1/(h-c),_=1/l.length;for(let e=0,t=o.length;e<t;e++){const t=o[e];if(isNaN(t)){n[e]=i;continue}if(t==h){n[e]=l[u];continue}const p=(t-c)*a,f=Math.floor(p/_);n[e]=f<0?null!=r?r:l[0]:f>u?null!=s?s:l[u]:l[f]}}}l.LinearColorMapper=i,i.__name__="LinearColorMapper"},
function _(o,r,l){Object.defineProperty(l,"__esModule",{value:!0});const i=o(1),t=o(117),e=i.__importStar(o(18));class s extends t.ColorMapper{constructor(o){super(o)}static init_ContinuousColorMapper(){this.define({high:[e.Number],low:[e.Number],high_color:[e.Color],low_color:[e.Color]})}_colors(o){return Object.assign(Object.assign({},super._colors(o)),{low_color:null!=this.low_color?o(this.low_color):void 0,high_color:null!=this.high_color?o(this.high_color):void 0})}}l.ContinuousColorMapper=s,s.__name__="ContinuousColorMapper",s.init_ContinuousColorMapper()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const n=t(1),o=t(118),_=n.__importStar(t(18)),i=t(8),l=t(20),c=t(28);function a(t){return i.isNumber(t)?t:("#"!=t[0]&&(t=l.color2hex(t)),9!=t.length&&(t+="ff"),parseInt(t.slice(1),16))}function s(t){const e=new Uint32Array(t.length);for(let r=0,n=t.length;r<n;r++)e[r]=a(t[r]);return e}function p(t){if(c.is_little_endian){const e=new DataView(t.buffer);for(let r=0,n=t.length;r<n;r++)e.setUint32(4*r,t[r])}return new Uint8Array(t.buffer)}r._convert_color=a,r._convert_palette=s,r._uint32_to_rgba=p;class u extends o.Mapper{constructor(t){super(t)}static init_ColorMapper(){this.define({palette:[_.Any],nan_color:[_.Color,"gray"]})}v_compute(t){const e=new Array(t.length);return this._v_compute(t,e,this.palette,this._colors(t=>t)),e}get rgba_mapper(){const t=this,e=s(this.palette),r=this._colors(a);return{v_compute(n){const o=new Uint32Array(n.length);return t._v_compute(n,o,e,r),p(o)}}}_colors(t){return{nan_color:t(this.nan_color)}}}r.ColorMapper=u,u.__name__="ColorMapper",u.init_ColorMapper()},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(119);class s extends o.Transform{constructor(e){super(e)}compute(e){throw new Error("mapping single values is not supported")}}n.Mapper=s,s.__name__="Mapper"},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});const r=e(71);class s extends r.Model{constructor(e){super(e)}}o.Transform=s,s.__name__="Transform"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e(121);class _ extends r.ContinuousScale{constructor(e){super(e)}compute(e){return this._linear_compute(e)}v_compute(e){return this._linear_v_compute(e)}invert(e){return this._linear_invert(e)}v_invert(e){return this._linear_v_invert(e)}}n.LinearScale=_,_.__name__="LinearScale"},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});const c=e(122);class s extends c.Scale{constructor(e){super(e)}}o.ContinuousScale=s,s.__name__="ContinuousScale"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const n=t(1),_=t(123),s=n.__importStar(t(18));class i extends _.Transform{constructor(t){super(t)}static init_Scale(){this.internal({source_range:[s.Any],target_range:[s.Any]})}r_compute(t,e){return this.target_range.is_reversed?[this.compute(e),this.compute(t)]:[this.compute(t),this.compute(e)]}r_invert(t,e){return this.target_range.is_reversed?[this.invert(e),this.invert(t)]:[this.invert(t),this.invert(e)]}_linear_compute(t){const[e,r]=this._linear_compute_state();return e*t+r}_linear_v_compute(t){const[e,r]=this._linear_compute_state(),n=new Float64Array(t.length);for(let _=0;_<t.length;_++)n[_]=e*t[_]+r;return n}_linear_invert(t){const[e,r]=this._linear_compute_state();return(t-r)/e}_linear_v_invert(t){const[e,r]=this._linear_compute_state(),n=new Float64Array(t.length);for(let _=0;_<t.length;_++)n[_]=(t[_]-r)/e;return n}_linear_compute_state(){const t=this.source_range.start,e=this.source_range.end,r=this.target_range.start,n=(this.target_range.end-r)/(e-t);return[n,-n*t+r]}}r.Scale=i,i.__name__="Scale",i.init_Scale()},
function _(r,o,t){Object.defineProperty(t,"__esModule",{value:!0});var e=r(124);t.CustomJSTransform=e.CustomJSTransform;var a=r(125);t.Dodge=a.Dodge;var n=r(126);t.Interpolator=n.Interpolator;var p=r(127);t.Jitter=p.Jitter;var l=r(128);t.LinearInterpolator=l.LinearInterpolator;var v=r(129);t.StepInterpolator=v.StepInterpolator;var s=r(119);t.Transform=s.Transform},
function _(t,r,s){Object.defineProperty(s,"__esModule",{value:!0});const n=t(1),e=t(119),a=n.__importStar(t(18)),o=t(17),u=t(24);class i extends e.Transform{constructor(t){super(t)}static init_CustomJSTransform(){this.define({args:[a.Any,{}],func:[a.String,""],v_func:[a.String,""]})}get names(){return o.keys(this.args)}get values(){return o.values(this.args)}_make_transform(t,r){return new Function(...this.names,t,u.use_strict(r))}get scalar_transform(){return this._make_transform("x",this.func)}get vector_transform(){return this._make_transform("xs",this.v_func)}compute(t){return this.scalar_transform(...this.values,t)}v_compute(t){return this.vector_transform(...this.values,t)}}s.CustomJSTransform=i,i.__name__="CustomJSTransform",i.init_CustomJSTransform()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const n=e(1),o=e(119),i=e(90),s=n.__importStar(e(18)),a=e(8);class c extends o.Transform{constructor(e){super(e)}static init_Dodge(){this.define({value:[s.Number,0],range:[s.Instance]})}v_compute(e){let t;if(this.range instanceof i.FactorRange)t=this.range.v_synthetic(e);else{if(!a.isArrayableOf(e,a.isNumber))throw new Error("unexpected");t=e}const r=new Float64Array(t.length);for(let e=0;e<t.length;e++){const n=t[e];r[e]=this._compute(n)}return r}compute(e){if(this.range instanceof i.FactorRange)return this._compute(this.range.synthetic(e));if(a.isNumber(e))return this._compute(e);throw new Error("unexpected")}_compute(e){return e+this.value}}r.Dodge=c,c.__name__="Dodge",c.init_Dodge()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const s=t(1),o=t(119),n=s.__importStar(t(18)),i=t(9),a=t(8);class h extends o.Transform{constructor(t){super(t),this._sorted_dirty=!0}static init_Interpolator(){this.define({x:[n.Any],y:[n.Any],data:[n.Any],clip:[n.Boolean,!0]})}connect_signals(){super.connect_signals(),this.connect(this.change,()=>this._sorted_dirty=!0)}v_compute(t){const e=new Float64Array(t.length);for(let r=0;r<t.length;r++){const s=t[r];e[r]=this.compute(s)}return e}sort(t=!1){if(!this._sorted_dirty)return;let e,r;if(a.isString(this.x)&&a.isString(this.y)&&null!=this.data){const t=this.data.columns();if(!i.includes(t,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!i.includes(t,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");e=this.data.get_column(this.x),r=this.data.get_column(this.y)}else{if(!a.isArray(this.x)||!a.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");e=this.x,r=this.y}if(e.length!==r.length)throw new Error("The length for x and y do not match");if(e.length<2)throw new Error("x and y must have at least two elements to support interpolation");const s=[];for(const t in e)s.push({x:e[t],y:r[t]});t?s.sort((t,e)=>t.x>e.x?-1:t.x==e.x?0:1):s.sort((t,e)=>t.x<e.x?-1:t.x==e.x?0:1),this._x_sorted=[],this._y_sorted=[];for(const{x:t,y:e}of s)this._x_sorted.push(t),this._y_sorted.push(e);this._sorted_dirty=!1}}r.Interpolator=h,h.__name__="Interpolator",h.init_Interpolator()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const i=t(1),n=t(119),s=t(90),o=t(8),u=i.__importStar(t(18)),a=i.__importStar(t(10));class h extends n.Transform{constructor(t){super(t)}static init_Jitter(){this.define({mean:[u.Number,0],width:[u.Number,1],distribution:[u.Distribution,"uniform"],range:[u.Instance]}),this.internal({previous_values:[u.Array]})}v_compute(t){if(null!=this.previous_values&&this.previous_values.length==t.length)return this.previous_values;let e;if(this.range instanceof s.FactorRange)e=this.range.v_synthetic(t);else{if(!o.isArrayableOf(t,o.isNumber))throw new Error("unexpected");e=t}const r=new Float64Array(e.length);for(let t=0;t<e.length;t++){const i=e[t];r[t]=this._compute(i)}return this.previous_values=r,r}compute(t){if(this.range instanceof s.FactorRange)return this._compute(this.range.synthetic(t));if(o.isNumber(t))return this._compute(t);throw new Error("unexpected")}_compute(t){switch(this.distribution){case"uniform":return t+this.mean+(a.random()-.5)*this.width;case"normal":return t+a.rnorm(this.mean,this.width)}}}r.Jitter=h,h.__name__="Jitter",h.init_Jitter()},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const _=t(9),r=t(126);class o extends r.Interpolator{constructor(t){super(t)}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];const s=_.find_last_index(this._x_sorted,s=>s<t),e=this._x_sorted[s],r=this._x_sorted[s+1],o=this._y_sorted[s],i=this._y_sorted[s+1];return o+(t-e)/(r-e)*(i-o)}}e.LinearInterpolator=o,o.__name__="LinearInterpolator"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const s=t(1),o=t(126),_=s.__importStar(t(18)),i=t(9);class n extends o.Interpolator{constructor(t){super(t)}static init_StepInterpolator(){this.define({mode:[_.StepMode,"after"]})}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}let e;switch(this.mode){case"after":e=i.find_last_index(this._x_sorted,e=>t>=e);break;case"before":e=i.find_index(this._x_sorted,e=>t<=e);break;case"center":{const r=this._x_sorted.map(e=>Math.abs(e-t)),s=i.min(r);e=i.find_index(r,t=>s===t);break}default:throw new Error("unknown mode: "+this.mode)}return-1!=e?this._y_sorted[e]:NaN}}r.StepInterpolator=n,n.__name__="StepInterpolator",n.init_StepInterpolator()},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});const a=t(121);class s extends a.ContinuousScale{constructor(t){super(t)}compute(t){const[e,o,a,s]=this._compute_state();let n;if(0==a)n=0;else{const r=(Math.log(t)-s)/a;n=isFinite(r)?r*e+o:NaN}return n}v_compute(t){const[e,o,a,s]=this._compute_state(),n=new Float64Array(t.length);if(0==a)for(let e=0;e<t.length;e++)n[e]=0;else for(let r=0;r<t.length;r++){const l=(Math.log(t[r])-s)/a;let c;c=isFinite(l)?l*e+o:NaN,n[r]=c}return n}invert(t){const[e,o,a,s]=this._compute_state(),n=(t-o)/e;return Math.exp(a*n+s)}v_invert(t){const[e,o,a,s]=this._compute_state(),n=new Float64Array(t.length);for(let r=0;r<t.length;r++){const l=(t[r]-o)/e;n[r]=Math.exp(a*l+s)}return n}_get_safe_factor(t,e){let o=t<0?0:t,a=e<0?0:e;if(o==a)if(0==o)[o,a]=[1,10];else{const t=Math.log(o)/Math.log(10);o=10**Math.floor(t),a=Math.ceil(t)!=Math.floor(t)?10**Math.ceil(t):10**(Math.ceil(t)+1)}return[o,a]}_compute_state(){const t=this.source_range.start,e=this.source_range.end,o=this.target_range.start,a=this.target_range.end-o,[s,n]=this._get_safe_factor(t,e);let r,l;return 0==s?(r=Math.log(n),l=0):(r=Math.log(n)-Math.log(s),l=Math.log(s)),[a,o,r,l]}}o.LogScale=s,s.__name__="LogScale"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),n=t(91),r=i.__importStar(t(18));class a extends n.Range{constructor(t){super(t)}static init_Range1d(){this.define({start:[r.Number,0],end:[r.Number,1],reset_start:[r.Number],reset_end:[r.Number]})}_set_auto_bounds(){if("auto"==this.bounds){const t=Math.min(this.reset_start,this.reset_end),e=Math.max(this.reset_start,this.reset_end);this.setv({bounds:[t,e]},{silent:!0})}}initialize(){super.initialize(),null==this.reset_start&&(this.reset_start=this.start),null==this.reset_end&&(this.reset_end=this.end),this._set_auto_bounds()}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}reset(){this._set_auto_bounds(),this.start!=this.reset_start||this.end!=this.reset_end?this.setv({start:this.reset_start,end:this.reset_end}):this.change.emit()}}s.Range1d=a,a.__name__="Range1d",a.init_Range1d()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const o=t(68),i=new Map;n.measure_font=function(t){const e=i.get(t);if(null!=e)return e;const n=o.span({style:{font:t}},"Hg"),l=o.div({style:{display:"inline-block",width:"1px",height:"0px"}}),s=o.div({},n,l);document.body.appendChild(s);try{l.style.verticalAlign="baseline";const e=o.offset(l).top-o.offset(n).top;l.style.verticalAlign="bottom";const d=o.offset(l).top-o.offset(n).top,c={height:d,ascent:e,descent:d-e};return i.set(t,c),c}finally{document.body.removeChild(s)}};const l=new Map;n.measure_text=function(t,e){let n=l.get(e);if(null!=n){const e=n.get(t);if(null!=e)return e}else n=new Map,l.set(e,n);const i=o.div({style:{display:"inline-block","white-space":"nowrap",font:e}},t);document.body.appendChild(i);try{const{width:e,height:o}=i.getBoundingClientRect();return n.set(t,{width:e,height:o}),{width:e,height:o}}finally{document.body.removeChild(i)}}},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),a=e(134),l=e(68),n=s.__importStar(e(23)),o=s.__importStar(e(18));class _ extends a.TextAnnotationView{initialize(){super.initialize(),this.visuals.warm_cache()}_get_size(){const{ctx:e}=this.layer;this.visuals.text.set_value(e);const{width:t,ascent:i}=e.measureText(this.model.text);return{width:t,height:i}}render(){if(this.model.visible||"css"!=this.model.render_mode||l.undisplay(this.el),!this.model.visible)return;let e;switch(this.model.angle_units){case"rad":e=-this.model.angle;break;case"deg":e=-this.model.angle*Math.PI/180}const t=null!=this.panel?this.panel:this.plot_view.frame,i=this.plot_view.frame.xscales[this.model.x_range_name],s=this.plot_view.frame.yscales[this.model.y_range_name];let a="data"==this.model.x_units?i.compute(this.model.x):t.xview.compute(this.model.x),n="data"==this.model.y_units?s.compute(this.model.y):t.yview.compute(this.model.y);a+=this.model.x_offset,n-=this.model.y_offset,("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,this.model.text,a,n,e)}}i.LabelView=_,_.__name__="LabelView";class r extends a.TextAnnotation{constructor(e){super(e)}static init_Label(){this.prototype.default_view=_,this.mixins([n.Text,["border_",n.Line],["background_",n.Fill]]),this.define({x:[o.Number],x_units:[o.SpatialUnits,"data"],y:[o.Number],y_units:[o.SpatialUnits,"data"],text:[o.String],angle:[o.Angle,0],angle_units:[o.AngleUnits,"rad"],x_offset:[o.Number,0],y_offset:[o.Number,0],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})}}i.Label=r,r.__name__="Label",r.init_Label()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),l=e(31),a=e(68),n=i.__importStar(e(18)),o=e(132),r=e(11);class _ extends l.AnnotationView{constructor(){super(...arguments),this.rotate=!0}initialize(){super.initialize(),"css"==this.model.render_mode&&this.plot_view.canvas_view.add_overlay(this.el)}connect_signals(){super.connect_signals(),"css"==this.model.render_mode?this.connect(this.model.change,()=>this.render()):this.connect(this.model.change,()=>this.plot_view.request_render())}_calculate_text_dimensions(e,t){const{width:s}=e.measureText(t),{height:i}=o.measure_font(this.visuals.text.font_value());return[s,i]}_calculate_bounding_box_dimensions(e,t){const[s,i]=this._calculate_text_dimensions(e,t);let l,a;switch(e.textAlign){case"left":l=0;break;case"center":l=-s/2;break;case"right":l=-s;break;default:r.unreachable()}switch(e.textBaseline){case"top":a=0;break;case"middle":a=-.5*i;break;case"bottom":a=-1*i;break;case"alphabetic":a=-.8*i;break;case"hanging":a=-.17*i;break;case"ideographic":a=-.83*i;break;default:r.unreachable()}return[l,a,s,i]}_canvas_text(e,t,s,i,l){this.visuals.text.set_value(e);const a=this._calculate_bounding_box_dimensions(e,t);e.save(),e.beginPath(),e.translate(s,i),l&&e.rotate(l),e.rect(a[0],a[1],a[2],a[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),e.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(e),e.stroke()),this.visuals.text.doit&&(this.visuals.text.set_value(e),e.fillText(t,0,0)),e.restore()}_css_text(e,t,s,i,l){a.undisplay(this.el),this.visuals.text.set_value(e);const n=this._calculate_bounding_box_dimensions(e,t),o=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_value(e),this.visuals.background_fill.set_value(e),this.el.style.position="absolute",this.el.style.left=s+n[0]+"px",this.el.style.top=i+n[1]+"px",this.el.style.color=""+this.visuals.text.text_color.value(),this.el.style.opacity=""+this.visuals.text.text_alpha.value(),this.el.style.font=""+this.visuals.text.font_value(),this.el.style.lineHeight="normal",l&&(this.el.style.transform=`rotate(${l}rad)`),this.visuals.background_fill.doit&&(this.el.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(this.el.style.borderStyle=""+o,this.el.style.borderWidth=this.visuals.border_line.line_width.value()+"px",this.el.style.borderColor=""+this.visuals.border_line.color_value()),this.el.textContent=t,a.display(this.el)}}s.TextAnnotationView=_,_.__name__="TextAnnotationView";class h extends l.Annotation{constructor(e){super(e)}static init_TextAnnotation(){this.define({render_mode:[n.RenderMode,"canvas"]})}}s.TextAnnotation=h,h.__name__="TextAnnotation",h.init_TextAnnotation()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),l=t(134),o=t(76),a=i.__importStar(t(23)),n=t(68),r=i.__importStar(t(18));class _ extends l.TextAnnotationView{initialize(){if(super.initialize(),this.set_data(this.model.source),"css"==this.model.render_mode)for(let t=0,e=this._text.length;t<e;t++){const t=n.div({style:{display:"none"}});this.el.appendChild(t)}}connect_signals(){super.connect_signals(),"css"==this.model.render_mode?(this.connect(this.model.change,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.streaming,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.patching,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.change,()=>{this.set_data(this.model.source),this.render()})):(this.connect(this.model.change,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.streaming,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.patching,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.change,()=>{this.set_data(this.model.source),this.plot_view.request_render()}))}set_data(t){super.set_data(t),this.visuals.warm_cache(t)}_map_data(){const t=this.plot_view.frame.xscales[this.model.x_range_name],e=this.plot_view.frame.yscales[this.model.y_range_name],s=null!=this.panel?this.panel:this.plot_view.frame;return["data"==this.model.x_units?t.v_compute(this._x):s.xview.v_compute(this._x),"data"==this.model.y_units?e.v_compute(this._y):s.yview.v_compute(this._y)]}render(){if(this.model.visible||"css"!=this.model.render_mode||n.undisplay(this.el),!this.model.visible)return;const t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),{ctx:e}=this.layer,[s,i]=this._map_data();for(let l=0,o=this._text.length;l<o;l++)t(e,l,this._text[l],s[l]+this._x_offset[l],i[l]-this._y_offset[l],this._angle[l])}_get_size(){const{ctx:t}=this.layer;this.visuals.text.set_value(t);const{width:e,ascent:s}=t.measureText(this._text[0]);return{width:e,height:s}}_v_canvas_text(t,e,s,i,l,o){this.visuals.text.set_vectorize(t,e);const a=this._calculate_bounding_box_dimensions(t,s);t.save(),t.beginPath(),t.translate(i,l),t.rotate(o),t.rect(a[0],a[1],a[2],a[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(s,0,0)),t.restore()}_v_css_text(t,e,s,i,l,o){const a=this.el.children[e];a.textContent=s,this.visuals.text.set_vectorize(t,e);const r=this._calculate_bounding_box_dimensions(t,s),_=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_vectorize(t,e),this.visuals.background_fill.set_vectorize(t,e),a.style.position="absolute",a.style.left=i+r[0]+"px",a.style.top=l+r[1]+"px",a.style.color=""+this.visuals.text.text_color.value(),a.style.opacity=""+this.visuals.text.text_alpha.value(),a.style.font=""+this.visuals.text.font_value(),a.style.lineHeight="normal",o&&(a.style.transform=`rotate(${o}rad)`),this.visuals.background_fill.doit&&(a.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(a.style.borderStyle=""+_,a.style.borderWidth=this.visuals.border_line.line_width.value()+"px",a.style.borderColor=""+this.visuals.border_line.color_value()),n.display(a)}}s.LabelSetView=_,_.__name__="LabelSetView";class h extends l.TextAnnotation{constructor(t){super(t)}static init_LabelSet(){this.prototype.default_view=_,this.mixins([a.TextVector,["border_",a.LineVector],["background_",a.FillVector]]),this.define({x:[r.NumberSpec],y:[r.NumberSpec],x_units:[r.SpatialUnits,"data"],y_units:[r.SpatialUnits,"data"],text:[r.StringSpec,{field:"text"}],angle:[r.AngleSpec,0],x_offset:[r.NumberSpec,{value:0}],y_offset:[r.NumberSpec,{value:0}],source:[r.Instance,()=>new o.ColumnDataSource],x_range_name:[r.String,"default"],y_range_name:[r.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})}}s.LabelSet=h,h.__name__="LabelSet",h.init_LabelSet()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),l=t(31),n=s.__importStar(t(23)),h=s.__importStar(t(18)),a=t(14),o=t(132),_=t(88),r=t(9),d=t(8),c=t(11);class g extends l.AnnotationView{cursor(t,e){return"none"==this.model.click_policy?null:"pointer"}get legend_padding(){return null!=this.visuals.border_line.line_color.value()?this.model.padding:0}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render()),this.connect(this.model.item_change,()=>this.plot_view.request_render())}compute_legend_bbox(){const t=this.model.get_legend_names(),{glyph_height:e,glyph_width:i}=this.model,{label_height:s,label_width:l}=this.model;this.max_label_height=r.max([o.measure_font(this.visuals.label_text.font_value()).height,s,e]);const{ctx:n}=this.layer;n.save(),this.visuals.label_text.set_value(n),this.text_widths=new Map;for(const e of t)this.text_widths.set(e,r.max([n.measureText(e).width,l]));this.visuals.title_text.set_value(n),this.title_height=this.model.title?o.measure_font(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?n.measureText(this.model.title).width:0,n.restore();const h=Math.max(r.max([...this.text_widths.values()]),0),a=this.model.margin,{legend_padding:g}=this,m=this.model.spacing,{label_standoff:b}=this.model;let u,f;if("vertical"==this.model.orientation)u=t.length*this.max_label_height+Math.max(t.length-1,0)*m+2*g+this.title_height,f=r.max([h+i+b+2*g,this.title_width+2*g]);else{let e=2*g+Math.max(t.length-1,0)*m;for(const[,t]of this.text_widths)e+=r.max([t,l])+i+b;f=r.max([this.title_width+2*g,e]),u=this.max_label_height+this.title_height+2*g}const x=null!=this.panel?this.panel:this.plot_view.frame,[p,v]=x.bbox.ranges,{location:w}=this.model;let y,k;if(d.isString(w))switch(w){case"top_left":y=p.start+a,k=v.start+a;break;case"top_center":y=(p.end+p.start)/2-f/2,k=v.start+a;break;case"top_right":y=p.end-a-f,k=v.start+a;break;case"bottom_right":y=p.end-a-f,k=v.end-a-u;break;case"bottom_center":y=(p.end+p.start)/2-f/2,k=v.end-a-u;break;case"bottom_left":y=p.start+a,k=v.end-a-u;break;case"center_left":y=p.start+a,k=(v.end+v.start)/2-u/2;break;case"center":y=(p.end+p.start)/2-f/2,k=(v.end+v.start)/2-u/2;break;case"center_right":y=p.end-a-f,k=(v.end+v.start)/2-u/2}else if(d.isArray(w)&&2==w.length){const[t,e]=w;y=x.xview.compute(t),k=x.yview.compute(e)-u}else c.unreachable();return new _.BBox({left:y,top:k,width:f,height:u})}interactive_bbox(){return this.compute_legend_bbox()}interactive_hit(t,e){return this.interactive_bbox().contains(t,e)}on_hit(t,e){let i;const{glyph_width:s}=this.model,{legend_padding:l}=this,n=this.model.spacing,{label_standoff:h}=this.model;let a=i=l;const o=this.compute_legend_bbox(),r="vertical"==this.model.orientation;for(const d of this.model.items){const c=d.get_labels_list_from_label_prop();for(const g of c){const c=o.x+a,m=o.y+i+this.title_height;let b,u;if([b,u]=r?[o.width-2*l,this.max_label_height]:[this.text_widths.get(g)+s+h,this.max_label_height],new _.BBox({left:c,top:m,width:b,height:u}).contains(t,e)){switch(this.model.click_policy){case"hide":for(const t of d.renderers)t.visible=!t.visible;break;case"mute":for(const t of d.renderers)t.muted=!t.muted}return!0}r?i+=this.max_label_height+n:a+=this.text_widths.get(g)+s+h+n}}return!1}render(){if(!this.model.visible)return;if(0==this.model.items.length)return;for(const t of this.model.items)t.legend=this.model;const{ctx:t}=this.layer,e=this.compute_legend_bbox();t.save(),this._draw_legend_box(t,e),this._draw_legend_items(t,e),this.model.title&&this._draw_title(t,e),t.restore()}_draw_legend_box(t,e){t.beginPath(),t.rect(e.x,e.y,e.width,e.height),this.visuals.background_fill.set_value(t),t.fill(),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke())}_draw_legend_items(t,e){const{glyph_width:i,glyph_height:s}=this.model,{legend_padding:l}=this,n=this.model.spacing,{label_standoff:h}=this.model;let a=l,o=l;const _="vertical"==this.model.orientation;for(const d of this.model.items){const c=d.get_labels_list_from_label_prop(),g=d.get_field_from_label_prop();if(0==c.length)continue;const m=(()=>{switch(this.model.click_policy){case"none":return!0;case"hide":return r.every(d.renderers,t=>t.visible);case"mute":return r.every(d.renderers,t=>!t.muted)}})();for(const r of c){const c=e.x+a,b=e.y+o+this.title_height,u=c+i,f=b+s;_?o+=this.max_label_height+n:a+=this.text_widths.get(r)+i+h+n,this.visuals.label_text.set_value(t),t.fillText(r,u+h,b+this.max_label_height/2);for(const e of d.renderers){this.plot_view.renderer_views.get(e).draw_legend(t,c,u,b,f,g,r,d.index)}if(!m){let s,n;[s,n]=_?[e.width-2*l,this.max_label_height]:[this.text_widths.get(r)+i+h,this.max_label_height],t.beginPath(),t.rect(c,b,s,n),this.visuals.inactive_fill.set_value(t),t.fill()}}}}_draw_title(t,e){this.visuals.title_text.doit&&(t.save(),t.translate(e.x0,e.y0+this.title_height),this.visuals.title_text.set_value(t),t.fillText(this.model.title,this.legend_padding,this.legend_padding-this.model.title_standoff),t.restore())}_get_size(){const{width:t,height:e}=this.compute_legend_bbox();return{width:t+2*this.model.margin,height:e+2*this.model.margin}}}i.LegendView=g,g.__name__="LegendView";class m extends l.Annotation{constructor(t){super(t)}initialize(){super.initialize(),this.item_change=new a.Signal0(this,"item_change")}static init_Legend(){this.prototype.default_view=g,this.mixins([["label_",n.Text],["title_",n.Text],["inactive_",n.Fill],["border_",n.Line],["background_",n.Fill]]),this.define({orientation:[h.Orientation,"vertical"],location:[h.Any,"top_right"],title:[h.String],title_standoff:[h.Number,5],label_standoff:[h.Number,5],glyph_height:[h.Number,20],glyph_width:[h.Number,20],label_height:[h.Number,20],label_width:[h.Number,20],margin:[h.Number,10],padding:[h.Number,10],spacing:[h.Number,3],items:[h.Array,[]],click_policy:[h.Any,"none"]}),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})}get_legend_names(){const t=[];for(const e of this.items){const i=e.get_labels_list_from_label_prop();t.push(...i)}return t}}i.Legend=m,m.__name__="Legend",m.init_Legend()},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(1),l=e(71),i=e(77),s=e(138),_=t.__importStar(e(18)),o=e(72),a=e(9);class u extends l.Model{constructor(e){super(e)}static init_LegendItem(){this.define({label:[_.StringSpec,null],renderers:[_.Array,[]],index:[_.Number,null]})}_check_data_sources_on_renderers(){if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;const e=this.renderers[0].data_source;if(null!=e)for(const r of this.renderers)if(r.data_source!=e)return!1}return!0}_check_field_label_on_data_source(){const e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;const r=this.renderers[0].data_source;if(null!=r&&!a.includes(r.columns(),e))return!1}return!0}initialize(){super.initialize(),this.legend=null,this.connect(this.change,()=>{null!=this.legend&&this.legend.item_change.emit()}),this._check_data_sources_on_renderers()||o.logger.error("Non matching data sources on legend item renderers"),this._check_field_label_on_data_source()||o.logger.error("Bad column name on label: "+this.label)}get_field_from_label_prop(){const{label:e}=this;return s.isField(e)?e.field:null}get_labels_list_from_label_prop(){if(s.isValue(this.label)){const{value:e}=this.label;return null!=e?[e]:[]}const e=this.get_field_from_label_prop();if(null!=e){let r;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if(r=this.renderers[0].data_source,r instanceof i.ColumnarDataSource){const n=r.get_column(e);return null!=n?a.uniq(Array.from(n)):["Invalid field"]}}return[]}}n.LegendItem=u,u.__name__="LegendItem",u.init_LegendItem()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(8);n.isValue=function(e){return t.isPlainObject(e)&&"value"in e},n.isField=function(e){return t.isPlainObject(e)&&"field"in e}},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const n=t(1),s=t(31),l=n.__importStar(t(23)),o=t(14),a=n.__importStar(t(18));class r extends s.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render()),this.connect(this.model.data_update,()=>this.plot_view.request_render())}render(){if(!this.model.visible)return;const{xs:t,ys:e}=this.model;if(t.length!=e.length)return;if(t.length<3||e.length<3)return;const{frame:i}=this.plot_view,{ctx:n}=this.layer;for(let s=0,l=t.length;s<l;s++){let l,o;if("screen"!=this.model.xs_units)throw new Error("not implemented");if(l=this.model.screen?t[s]:i.xview.compute(t[s]),"screen"!=this.model.ys_units)throw new Error("not implemented");o=this.model.screen?e[s]:i.yview.compute(e[s]),0==s?(n.beginPath(),n.moveTo(l,o)):n.lineTo(l,o)}n.closePath(),this.visuals.line.doit&&(this.visuals.line.set_value(n),n.stroke()),this.visuals.fill.doit&&(this.visuals.fill.set_value(n),n.fill())}}i.PolyAnnotationView=r,r.__name__="PolyAnnotationView";class _ extends s.Annotation{constructor(t){super(t)}static init_PolyAnnotation(){this.prototype.default_view=r,this.mixins([l.Line,l.Fill]),this.define({xs:[a.Array,[]],xs_units:[a.SpatialUnits,"data"],ys:[a.Array,[]],ys_units:[a.SpatialUnits,"data"],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]}),this.internal({screen:[a.Boolean,!1]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}initialize(){super.initialize(),this.data_update=new o.Signal0(this,"data_update")}update({xs:t,ys:e}){this.setv({xs:t,ys:e,screen:!0},{silent:!0}),this.data_update.emit()}}i.PolyAnnotation=_,_.__name__="PolyAnnotation",_.init_PolyAnnotation()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=e(31),l=n.__importStar(e(23)),o=n.__importStar(e(18));class r extends s.AnnotationView{initialize(){super.initialize()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render())}render(){this.model.visible&&this._draw_slope()}_draw_slope(){const e=this.model.gradient,t=this.model.y_intercept;if(null==e||null==t)return;const{frame:i}=this.plot_view,n=i.xscales[this.model.x_range_name],s=i.yscales[this.model.y_range_name],l=i._top.value,o=l+i._height.value,r=(s.invert(l)-t)/e,a=(s.invert(o)-t)/e,_=n.compute(r),c=n.compute(a),{ctx:u}=this.layer;u.save(),u.beginPath(),this.visuals.line.set_value(u),u.moveTo(_,l),u.lineTo(c,o),u.stroke(),u.restore()}}i.SlopeView=r,r.__name__="SlopeView";class a extends s.Annotation{constructor(e){super(e)}static init_Slope(){this.prototype.default_view=r,this.mixins(l.Line),this.define({gradient:[o.Number,null],y_intercept:[o.Number,null],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({line_color:"black"})}}i.Slope=a,a.__name__="Slope",a.init_Slope()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),o=e(31),s=n.__importStar(e(23)),a=n.__importStar(e(18));class l extends o.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_paint(this))}render(){if(!this.model.visible)return;const{location:e}=this.model;if(null==e)return;const{frame:t}=this.plot_view,i=t.xscales[this.model.x_range_name],n=t.yscales[this.model.y_range_name],o=(t,i)=>"data"==this.model.location_units?t.compute(e):this.model.for_hover?e:i.compute(e);let s,a,l,r;"width"==this.model.dimension?(l=o(n,t.yview),a=t._left.value,r=t._width.value,s=this.model.properties.line_width.value()):(l=t._top.value,a=o(i,t.xview),r=this.model.properties.line_width.value(),s=t._height.value);const{ctx:_}=this.layer;_.save(),_.beginPath(),this.visuals.line.set_value(_),_.moveTo(a,l),"width"==this.model.dimension?_.lineTo(a+r,l):_.lineTo(a,l+s),_.stroke(),_.restore()}}i.SpanView=l,l.__name__="SpanView";class r extends o.Annotation{constructor(e){super(e)}static init_Span(){this.prototype.default_view=l,this.mixins(s.Line),this.define({render_mode:[a.RenderMode,"canvas"],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"],location:[a.Number,null],location_units:[a.SpatialUnits,"data"],dimension:[a.Dimension,"width"]}),this.override({line_color:"black"}),this.internal({for_hover:[a.Boolean,!1]})}}i.Span=r,r.__name__="Span",r.init_Span()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const l=e(1),a=e(134),s=e(68),n=e(70),o=l.__importStar(e(23)),r=l.__importStar(e(18));class _ extends a.TextAnnotationView{initialize(){super.initialize(),this.visuals.text=new n.Text(this.model)}_get_location(){const e=this.panel,t=this.model.offset;let i,l;switch(e.side){case"above":case"below":switch(this.model.vertical_align){case"top":l=e._top.value+5;break;case"middle":l=e._vcenter.value;break;case"bottom":l=e._bottom.value-5}switch(this.model.align){case"left":i=e._left.value+t;break;case"center":i=e._hcenter.value;break;case"right":i=e._right.value-t}break;case"left":switch(this.model.vertical_align){case"top":i=e._left.value-5;break;case"middle":i=e._hcenter.value;break;case"bottom":i=e._right.value+5}switch(this.model.align){case"left":l=e._bottom.value-t;break;case"center":l=e._vcenter.value;break;case"right":l=e._top.value+t}break;case"right":switch(this.model.vertical_align){case"top":i=e._right.value-5;break;case"middle":i=e._hcenter.value;break;case"bottom":i=e._left.value+5}switch(this.model.align){case"left":l=e._top.value+t;break;case"center":l=e._vcenter.value;break;case"right":l=e._bottom.value-t}}return[i,l]}render(){if(!this.model.visible)return void("css"==this.model.render_mode&&s.undisplay(this.el));const{text:e}=this.model;if(null==e||0==e.length)return;this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;const[t,i]=this._get_location(),l=this.panel.get_label_angle_heuristic("parallel");("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,e,t,i,l)}_get_size(){const{text:e}=this.model;if(null==e||0==e.length)return{width:0,height:0};{this.visuals.text.set_value(this.layer.ctx);const{width:t,ascent:i}=this.layer.ctx.measureText(e);return{width:t,height:i*this.visuals.text.text_line_height.value()+10}}}}i.TitleView=_,_.__name__="TitleView";class c extends a.TextAnnotation{constructor(e){super(e)}static init_Title(){this.prototype.default_view=_,this.mixins([["border_",o.Line],["background_",o.Fill]]),this.define({text:[r.String],text_font:[r.Font,"helvetica"],text_font_size:[r.StringSpec,"13px"],text_font_style:[r.FontStyle,"bold"],text_color:[r.ColorSpec,"#444444"],text_alpha:[r.NumberSpec,1],text_line_height:[r.Number,1],vertical_align:[r.VerticalAlign,"bottom"],align:[r.TextAlign,"left"],offset:[r.Number,0]}),this.override({background_fill_color:null,border_line_color:null}),this.internal({text_align:[r.TextAlign,"left"],text_baseline:[r.TextBaseline,"bottom"]})}}i.Title=c,c.__name__="Title",c.init_Title()},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(1),l=e(31),s=e(99),a=e(68),n=o.__importStar(e(18));class r extends l.AnnotationView{constructor(){super(...arguments),this.rotate=!0}initialize(){super.initialize(),this.plot_view.canvas_view.add_event(this.el)}async lazy_initialize(){this._toolbar_view=await s.build_view(this.model.toolbar,{parent:this}),this.plot_view.visibility_callbacks.push(e=>this._toolbar_view.set_visibility(e))}remove(){this._toolbar_view.remove(),super.remove()}render(){super.render(),this.model.visible?(this.el.style.position="absolute",this.el.style.overflow="hidden",a.position(this.el,this.panel.bbox),this._toolbar_view.render(),a.empty(this.el),this.el.appendChild(this._toolbar_view.el),a.display(this.el)):a.undisplay(this.el)}_get_size(){const{tools:e,logo:i}=this.model.toolbar;return{width:30*e.length+(null!=i?25:0),height:30}}}t.ToolbarPanelView=r,r.__name__="ToolbarPanelView";class _ extends l.Annotation{constructor(e){super(e)}static init_ToolbarPanel(){this.prototype.default_view=r,this.define({toolbar:[n.Instance]})}}t.ToolbarPanel=_,_.__name__="ToolbarPanel",_.init_ToolbarPanel()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),l=t(31),o=t(68),a=i.__importStar(t(18)),h=t(145),n=t(146),r=i.__importDefault(t(147));function c(t,e,s,i,l){switch(t){case"horizontal":return e<i?"right":"left";case"vertical":return s<l?"below":"above";default:return t}}s.compute_side=c;class d extends l.AnnotationView{initialize(){super.initialize(),this.plot_view.canvas_view.add_overlay(this.el),o.undisplay(this.el)}connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,()=>this._draw_tips())}styles(){return[...super.styles(),r.default]}css_classes(){return super.css_classes().concat(h.bk_tooltip)}render(){this.model.visible&&this._draw_tips()}_draw_tips(){const{data:t}=this.model;if(o.empty(this.el),o.undisplay(this.el),this.model.custom?this.el.classList.add(h.bk_tooltip_custom):this.el.classList.remove(h.bk_tooltip_custom),0==t.length)return;const{frame:e}=this.plot_view;for(const[s,i,l]of t){if(this.model.inner_only&&!e.bbox.contains(s,i))continue;const t=o.div({},l);this.el.appendChild(t)}const[s,i]=t[t.length-1],l=c(this.model.attachment,s,i,e._hcenter.value,e._vcenter.value);this.el.classList.remove(n.bk_right),this.el.classList.remove(n.bk_left),this.el.classList.remove(n.bk_above),this.el.classList.remove(n.bk_below);let a;o.display(this.el);let r=0,d=0;switch(l){case"right":this.el.classList.add(n.bk_left),r=s+(this.el.offsetWidth-this.el.clientWidth)+10,a=i-this.el.offsetHeight/2;break;case"left":this.el.classList.add(n.bk_right),d=this.plot_view.layout.bbox.width-s+10,a=i-this.el.offsetHeight/2;break;case"below":this.el.classList.add(n.bk_above),a=i+(this.el.offsetHeight-this.el.clientHeight)+10,r=Math.round(s-this.el.offsetWidth/2);break;case"above":this.el.classList.add(n.bk_below),a=i-this.el.offsetHeight-10,r=Math.round(s-this.el.offsetWidth/2)}this.model.show_arrow&&this.el.classList.add(h.bk_tooltip_arrow),this.el.childNodes.length>0?(this.el.style.top=a+"px",this.el.style.left=r?r+"px":"auto",this.el.style.right=d?d+"px":"auto"):o.undisplay(this.el)}}s.TooltipView=d,d.__name__="TooltipView";class _ extends l.Annotation{constructor(t){super(t)}static init_Tooltip(){this.prototype.default_view=d,this.define({attachment:[a.TooltipAttachment,"horizontal"],inner_only:[a.Boolean,!0],show_arrow:[a.Boolean,!0]}),this.override({level:"overlay"}),this.internal({data:[a.Any,[]],custom:[a.Any]})}clear(){this.data=[]}add(t,e,s){this.data=this.data.concat([[t,e,s]])}}s.Tooltip=_,_.__name__="Tooltip",_.init_Tooltip()},
function _(o,t,l){Object.defineProperty(l,"__esModule",{value:!0}),l.bk_tooltip="bk-tooltip",l.bk_tooltip_arrow="bk-tooltip-arrow",l.bk_tooltip_custom="bk-tooltip-custom",l.bk_tooltip_row_label="bk-tooltip-row-label",l.bk_tooltip_row_value="bk-tooltip-row-value",l.bk_tooltip_color_block="bk-tooltip-color-block"},
function _(e,b,k){Object.defineProperty(k,"__esModule",{value:!0}),k.bk_active="bk-active",k.bk_inline="bk-inline",k.bk_left="bk-left",k.bk_right="bk-right",k.bk_above="bk-above",k.bk_below="bk-below",k.bk_up="bk-up",k.bk_down="bk-down",k.bk_side=function(e){switch(e){case"above":return k.bk_above;case"below":return k.bk_below;case"left":return k.bk_left;case"right":return k.bk_right}}},
function _(o,n,t){Object.defineProperty(t,"__esModule",{value:!0});t.default='\n.bk-root {\n  /* Same border color used everywhere */\n  /* Gray of icons */\n}\n.bk-root .bk-tooltip {\n  font-weight: 300;\n  font-size: 12px;\n  position: absolute;\n  padding: 5px;\n  border: 1px solid #e5e5e5;\n  color: #2f2f2f;\n  background-color: white;\n  pointer-events: none;\n  opacity: 0.95;\n  z-index: 100;\n}\n.bk-root .bk-tooltip > div:not(:first-child) {\n  /* gives space when multiple elements are being hovered over */\n  margin-top: 5px;\n  border-top: #e5e5e5 1px dashed;\n}\n.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-left::before {\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right::after {\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-above::before {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  top: -10px;\n  border-bottom-width: 10px;\n  border-bottom-color: #909599;\n}\n.bk-root .bk-tooltip.bk-below::after {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  bottom: -10px;\n  border-top-width: 10px;\n  border-top-color: #909599;\n}\n.bk-root .bk-tooltip-row-label {\n  text-align: right;\n  color: #26aae1;\n  /* blue from toolbar highlighting */\n}\n.bk-root .bk-tooltip-row-value {\n  color: default;\n  /* seems to be necessary for notebook */\n}\n.bk-root .bk-tooltip-color-block {\n  width: 12px;\n  height: 12px;\n  margin-left: 5px;\n  margin-right: 5px;\n  outline: #dddddd solid 1px;\n  display: inline-block;\n}\n'},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(31),o=e(76),a=e(75),n=e(23),h=i.__importStar(e(18));class _ extends r.AnnotationView{initialize(){super.initialize(),this.set_data(this.model.source)}connect_signals(){super.connect_signals(),this.connect(this.model.source.streaming,()=>this.set_data(this.model.source)),this.connect(this.model.source.patching,()=>this.set_data(this.model.source)),this.connect(this.model.source.change,()=>this.set_data(this.model.source))}set_data(e){super.set_data(e),this.visuals.warm_cache(e),this.plot_view.request_render()}_map_data(){const{frame:e}=this.plot_view,t=this.model.dimension,s=e.xscales[this.model.x_range_name],i=e.yscales[this.model.y_range_name],r="height"==t?i:s,o="height"==t?s:i,a="height"==t?e.yview:e.xview,n="height"==t?e.xview:e.yview;let h,_,l;h="data"==this.model.properties.lower.units?r.v_compute(this._lower):a.v_compute(this._lower),_="data"==this.model.properties.upper.units?r.v_compute(this._upper):a.v_compute(this._upper),l="data"==this.model.properties.base.units?o.v_compute(this._base):n.v_compute(this._base);const[d,p]="height"==t?[1,0]:[0,1],c=[h,l],u=[_,l];this._lower_sx=c[d],this._lower_sy=c[p],this._upper_sx=u[d],this._upper_sy=u[p]}render(){if(!this.model.visible)return;this._map_data();const{ctx:e}=this.layer;if(this.visuals.line.doit)for(let t=0,s=this._lower_sx.length;t<s;t++)this.visuals.line.set_vectorize(e,t),e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),e.stroke();const t="height"==this.model.dimension?0:Math.PI/2;if(null!=this.model.lower_head)for(let s=0,i=this._lower_sx.length;s<i;s++)e.save(),e.translate(this._lower_sx[s],this._lower_sy[s]),e.rotate(t+Math.PI),this.model.lower_head.render(e,s),e.restore();if(null!=this.model.upper_head)for(let s=0,i=this._upper_sx.length;s<i;s++)e.save(),e.translate(this._upper_sx[s],this._upper_sy[s]),e.rotate(t),this.model.upper_head.render(e,s),e.restore()}}s.WhiskerView=_,_.__name__="WhiskerView";class l extends r.Annotation{constructor(e){super(e)}static init_Whisker(){this.prototype.default_view=_,this.mixins(n.LineVector),this.define({lower:[h.DistanceSpec],lower_head:[h.Instance,()=>new a.TeeHead({level:"underlay",size:10})],upper:[h.DistanceSpec],upper_head:[h.Instance,()=>new a.TeeHead({level:"underlay",size:10})],base:[h.DistanceSpec],dimension:[h.Dimension,"height"],source:[h.Instance,()=>new o.ColumnDataSource],x_range_name:[h.String,"default"],y_range_name:[h.String,"default"]}),this.override({level:"underlay"})}}s.Whisker=l,l.__name__="Whisker",l.init_Whisker()},
function _(i,a,e){Object.defineProperty(e,"__esModule",{value:!0});var r=i(150);e.Axis=r.Axis;var s=i(152);e.CategoricalAxis=s.CategoricalAxis;var x=i(155);e.ContinuousAxis=x.ContinuousAxis;var A=i(156);e.DatetimeAxis=A.DatetimeAxis;var o=i(157);e.LinearAxis=o.LinearAxis;var t=i(170);e.LogAxis=t.LogAxis;var n=i(173);e.MercatorAxis=n.MercatorAxis},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),a=e(151),l=s.__importStar(e(23)),n=s.__importStar(e(18)),o=e(9),r=e(8),_=e(90),{abs:h,min:c,max:m}=Math;class d extends a.GuideRendererView{constructor(){super(...arguments),this.rotate=!0}get panel(){return this.layout}render(){if(!this.model.visible)return;const e={tick:this._tick_extent(),tick_label:this._tick_label_extents(),axis_label:this._axis_label_extent()},t=this.tick_coords,i=this.layer.ctx;i.save(),this._draw_rule(i,e),this._draw_major_ticks(i,e,t),this._draw_minor_ticks(i,e,t),this._draw_major_labels(i,e,t),this._draw_axis_label(i,e,t),null!=this._render&&this._render(i,e,t),i.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_paint());const e=this.model.properties;this.on_change(e.visible,()=>this.plot_view.request_layout())}get_size(){if(this.model.visible&&null==this.model.fixed_location){const e=this._get_size();return{width:0,height:Math.round(e)}}return{width:0,height:0}}_get_size(){return this._tick_extent()+this._tick_label_extent()+this._axis_label_extent()}get needs_clip(){return null!=this.model.fixed_location}_draw_rule(e,t){if(!this.visuals.axis_line.doit)return;const[i,s]=this.rule_coords,[a,l]=this.plot_view.map_to_screen(i,s,this.model.x_range_name,this.model.y_range_name),[n,o]=this.normals,[r,_]=this.offsets;this.visuals.axis_line.set_value(e),e.beginPath(),e.moveTo(Math.round(a[0]+n*r),Math.round(l[0]+o*_));for(let t=1;t<a.length;t++){const i=Math.round(a[t]+n*r),s=Math.round(l[t]+o*_);e.lineTo(i,s)}e.stroke()}_draw_major_ticks(e,t,i){const s=this.model.major_tick_in,a=this.model.major_tick_out,l=this.visuals.major_tick_line;this._draw_ticks(e,i.major,s,a,l)}_draw_minor_ticks(e,t,i){const s=this.model.minor_tick_in,a=this.model.minor_tick_out,l=this.visuals.minor_tick_line;this._draw_ticks(e,i.minor,s,a,l)}_draw_major_labels(e,t,i){const s=i.major,a=this.compute_labels(s[this.dimension]),l=this.model.major_label_orientation,n=t.tick+this.model.major_label_standoff,o=this.visuals.major_label_text;this._draw_oriented_labels(e,a,s,l,this.panel.side,n,o)}_draw_axis_label(e,t,i){if(null==this.model.axis_label||0==this.model.axis_label.length||null!=this.model.fixed_location)return;let s,a;switch(this.panel.side){case"above":s=this.panel._hcenter.value,a=this.panel._bottom.value;break;case"below":s=this.panel._hcenter.value,a=this.panel._top.value;break;case"left":s=this.panel._right.value,a=this.panel._vcenter.value;break;case"right":s=this.panel._left.value,a=this.panel._vcenter.value;break;default:throw new Error("unknown side: "+this.panel.side)}const l=[[s],[a]],n=t.tick+o.sum(t.tick_label)+this.model.axis_label_standoff,r=this.visuals.axis_label_text;this._draw_oriented_labels(e,[this.model.axis_label],l,"parallel",this.panel.side,n,r,"screen")}_draw_ticks(e,t,i,s,a){if(!a.doit)return;const[l,n]=t,[o,r]=this.plot_view.map_to_screen(l,n,this.model.x_range_name,this.model.y_range_name),[_,h]=this.normals,[c,m]=this.offsets,[d,u]=[_*(c-i),h*(m-i)],[b,x]=[_*(c+s),h*(m+s)];a.set_value(e);for(let t=0;t<o.length;t++){const i=Math.round(o[t]+b),s=Math.round(r[t]+x),a=Math.round(o[t]+d),l=Math.round(r[t]+u);e.beginPath(),e.moveTo(i,s),e.lineTo(a,l),e.stroke()}}_draw_oriented_labels(e,t,i,s,a,l,n,o="data"){if(!n.doit||0==t.length)return;let _,h,c,m;if("screen"==o)[_,h]=i,[c,m]=[0,0];else{const[e,t]=i;[_,h]=this.plot_view.map_to_screen(e,t,this.model.x_range_name,this.model.y_range_name),[c,m]=this.offsets}const[d,u]=this.normals,b=d*(c+l),x=u*(m+l);let f;n.set_value(e),this.panel.apply_label_text_heuristics(e,s),f=r.isString(s)?this.panel.get_label_angle_heuristic(s):-s;for(let i=0;i<_.length;i++){const s=Math.round(_[i]+b),a=Math.round(h[i]+x);e.translate(s,a),e.rotate(f),e.fillText(t[i],0,0),e.rotate(-f),e.translate(-s,-a)}}_axis_label_extent(){if(null==this.model.axis_label||""==this.model.axis_label)return 0;const e=this.model.axis_label_standoff,t=this.visuals.axis_label_text;return this._oriented_labels_extent([this.model.axis_label],"parallel",this.panel.side,e,t)}_tick_extent(){return this.model.major_tick_out}_tick_label_extent(){return o.sum(this._tick_label_extents())}_tick_label_extents(){const e=this.tick_coords.major,t=this.compute_labels(e[this.dimension]),i=this.model.major_label_orientation,s=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(t,i,this.panel.side,s,a)]}_oriented_labels_extent(e,t,i,s,a){if(0==e.length)return 0;const l=this.layer.ctx;let n,o;a.set_value(l),r.isString(t)?(n=1,o=this.panel.get_label_angle_heuristic(t)):(n=2,o=-t),o=Math.abs(o);const _=Math.cos(o),h=Math.sin(o);let c=0;for(let t=0;t<e.length;t++){const s=1.1*l.measureText(e[t]).width,a=.9*l.measureText(e[t]).ascent;let o;o="above"==i||"below"==i?s*h+a/n*_:s*_+a/n*h,o>c&&(c=o)}return c>0&&(c+=s),c}get normals(){return this.panel.normals}get dimension(){return this.panel.dimension}compute_labels(e){const t=this.model.formatter.doFormat(e,this);for(let i=0;i<e.length;i++)e[i]in this.model.major_label_overrides&&(t[i]=this.model.major_label_overrides[e[i]]);return t}get offsets(){if(null!=this.model.fixed_location)return[0,0];const{frame:e}=this.plot_view;let[t,i]=[0,0];switch(this.panel.side){case"below":i=h(this.panel._top.value-e._bottom.value);break;case"above":i=h(this.panel._bottom.value-e._top.value);break;case"right":t=h(this.panel._left.value-e._right.value);break;case"left":t=h(this.panel._right.value-e._left.value)}return[t,i]}get ranges(){const e=this.dimension,t=(e+1)%2,{frame:i}=this.plot_view,s=[i.x_ranges[this.model.x_range_name],i.y_ranges[this.model.y_range_name]];return[s[e],s[t]]}get computed_bounds(){const[e]=this.ranges,t=this.model.bounds,i=[e.min,e.max];if("auto"==t)return[e.min,e.max];if(r.isArray(t)){let e,s;const[a,l]=t,[n,o]=i;return h(a-l)>h(n-o)?(e=m(c(a,l),n),s=c(m(a,l),o)):(e=c(a,l),s=m(a,l)),[e,s]}throw new Error(`user bounds '${t}' not understood`)}get rule_coords(){const e=this.dimension,t=(e+1)%2,[i]=this.ranges,[s,a]=this.computed_bounds,l=[new Array(2),new Array(2)];return l[e][0]=Math.max(s,i.min),l[e][1]=Math.min(a,i.max),l[e][0]>l[e][1]&&(l[e][0]=l[e][1]=NaN),l[t][0]=this.loc,l[t][1]=this.loc,l}get tick_coords(){const e=this.dimension,t=(e+1)%2,[i]=this.ranges,[s,a]=this.computed_bounds,l=this.model.ticker.get_ticks(s,a,i,this.loc,{}),n=l.major,o=l.minor,r=[[],[]],_=[[],[]],[h,c]=[i.min,i.max];for(let i=0;i<n.length;i++)n[i]<h||n[i]>c||(r[e].push(n[i]),r[t].push(this.loc));for(let i=0;i<o.length;i++)o[i]<h||o[i]>c||(_[e].push(o[i]),_[t].push(this.loc));return{major:r,minor:_}}get loc(){const{fixed_location:e}=this.model;if(null!=e){if(r.isNumber(e))return e;const[,t]=this.ranges;if(t instanceof _.FactorRange)return t.synthetic(e);throw new Error("unexpected")}const[,t]=this.ranges;switch(this.panel.side){case"left":case"below":return t.start;case"right":case"above":return t.end}}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box})}}i.AxisView=d,d.__name__="AxisView";class u extends a.GuideRenderer{constructor(e){super(e)}static init_Axis(){this.prototype.default_view=d,this.mixins([["axis_",l.Line],["major_tick_",l.Line],["minor_tick_",l.Line],["major_label_",l.Text],["axis_label_",l.Text]]),this.define({bounds:[n.Any,"auto"],ticker:[n.Instance],formatter:[n.Instance],x_range_name:[n.String,"default"],y_range_name:[n.String,"default"],axis_label:[n.String,""],axis_label_standoff:[n.Int,5],major_label_standoff:[n.Int,5],major_label_orientation:[n.Any,"horizontal"],major_label_overrides:[n.Any,{}],major_tick_in:[n.Number,2],major_tick_out:[n.Number,6],minor_tick_in:[n.Number,0],minor_tick_out:[n.Number,4],fixed_location:[n.Any,null]}),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic"})}}i.Axis=u,u.__name__="Axis",u.init_Axis()},
function _(e,r,d){Object.defineProperty(d,"__esModule",{value:!0});const i=e(65);class n extends i.RendererView{}d.GuideRendererView=n,n.__name__="GuideRendererView";class t extends i.Renderer{constructor(e){super(e)}static init_GuideRenderer(){this.override({level:"guide"})}}d.GuideRenderer=t,t.__name__="GuideRenderer",t.init_GuideRenderer()},
function _(t,s,o){Object.defineProperty(o,"__esModule",{value:!0});const e=t(1),i=t(150),r=t(153),a=t(154),l=e.__importStar(t(23)),_=e.__importStar(t(18));class n extends i.AxisView{_render(t,s,o){this._draw_group_separators(t,s,o)}_draw_group_separators(t,s,o){const[e]=this.ranges,[i,r]=this.computed_bounds;if(!e.tops||e.tops.length<2||!this.visuals.separator_line.doit)return;const a=this.dimension,l=(a+1)%2,_=[[],[]];let n=0;for(let t=0;t<e.tops.length-1;t++){let s,o;for(let i=n;i<e.factors.length;i++)if(e.factors[i][0]==e.tops[t+1]){[s,o]=[e.factors[i-1],e.factors[i]],n=i;break}const h=(e.synthetic(s)+e.synthetic(o))/2;h>i&&h<r&&(_[a].push(h),_[l].push(this.loc))}const h=this._tick_label_extent();this._draw_ticks(t,_,-3,h-6,this.visuals.separator_line)}_draw_major_labels(t,s,o){const e=this._get_factor_info();let i=s.tick+this.model.major_label_standoff;for(let o=0;o<e.length;o++){const[r,a,l,_]=e[o];this._draw_oriented_labels(t,r,a,l,this.panel.side,i,_),i+=s.tick_label[o]}}_tick_label_extents(){const t=this._get_factor_info(),s=[];for(const[o,,e,i]of t){const t=this._oriented_labels_extent(o,e,this.panel.side,this.model.major_label_standoff,i);s.push(t)}return s}_get_factor_info(){const[t]=this.ranges,[s,o]=this.computed_bounds,e=this.loc,i=this.model.ticker.get_ticks(s,o,t,e,{}),r=this.tick_coords,a=[];if(1==t.levels){const t=i.major,s=this.model.formatter.doFormat(t,this);a.push([s,r.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){const t=i.major.map(t=>t[1]),s=this.model.formatter.doFormat(t,this);a.push([s,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([i.tops,r.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){const t=i.major.map(t=>t[2]),s=this.model.formatter.doFormat(t,this),o=i.mids.map(t=>t[1]);a.push([s,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([o,r.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),a.push([i.tops,r.tops,this.model.group_label_orientation,this.visuals.group_text])}return a}get tick_coords(){const t=this.dimension,s=(t+1)%2,[o]=this.ranges,[e,i]=this.computed_bounds,r=this.model.ticker.get_ticks(e,i,o,this.loc,{}),a={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return a.major[t]=r.major,a.major[s]=r.major.map(t=>this.loc),3==o.levels&&(a.mids[t]=r.mids,a.mids[s]=r.mids.map(t=>this.loc)),o.levels>1&&(a.tops[t]=r.tops,a.tops[s]=r.tops.map(t=>this.loc)),a}}o.CategoricalAxisView=n,n.__name__="CategoricalAxisView";class h extends i.Axis{constructor(t){super(t)}static init_CategoricalAxis(){this.prototype.default_view=n,this.mixins([["separator_",l.Line],["group_",l.Text],["subgroup_",l.Text]]),this.define({group_label_orientation:[_.Any,"parallel"],subgroup_label_orientation:[_.Any,"parallel"]}),this.override({ticker:()=>new r.CategoricalTicker,formatter:()=>new a.CategoricalTickFormatter,separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})}}o.CategoricalAxis=h,h.__name__="CategoricalAxis",h.init_CategoricalAxis()},
function _(t,c,e){Object.defineProperty(e,"__esModule",{value:!0});const o=t(112);class s extends o.Ticker{constructor(t){super(t)}get_ticks(t,c,e,o,s){return{major:this._collect(e.factors,e,t,c),minor:[],tops:this._collect(e.tops||[],e,t,c),mids:this._collect(e.mids||[],e,t,c)}}_collect(t,c,e,o){const s=[];for(const r of t){const t=c.synthetic(r);t>e&&t<o&&s.push(r)}return s}}e.CategoricalTicker=s,s.__name__="CategoricalTicker"},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const o=e(114),c=e(9);class a extends o.TickFormatter{constructor(e){super(e)}doFormat(e,t){return c.copy(e)}}r.CategoricalTickFormatter=a,a.__name__="CategoricalTickFormatter"},
function _(s,e,n){Object.defineProperty(n,"__esModule",{value:!0});const o=s(150);class t extends o.Axis{constructor(s){super(s)}}n.ContinuousAxis=t,t.__name__="ContinuousAxis"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(157),a=e(158),r=e(163);class n extends s.LinearAxisView{}i.DatetimeAxisView=n,n.__name__="DatetimeAxisView";class _ extends s.LinearAxis{constructor(e){super(e)}static init_DatetimeAxis(){this.prototype.default_view=n,this.override({ticker:()=>new r.DatetimeTicker,formatter:()=>new a.DatetimeTickFormatter})}}i.DatetimeAxis=_,_.__name__="DatetimeAxis",_.init_DatetimeAxis()},
function _(e,i,s){Object.defineProperty(s,"__esModule",{value:!0});const t=e(150),n=e(155),r=e(113),a=e(109);class _ extends t.AxisView{}s.LinearAxisView=_,_.__name__="LinearAxisView";class c extends n.ContinuousAxis{constructor(e){super(e)}static init_LinearAxis(){this.prototype.default_view=_,this.override({ticker:()=>new a.BasicTicker,formatter:()=>new r.BasicTickFormatter})}}s.LinearAxis=c,c.__name__="LinearAxis",c.init_LinearAxis()},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const r=t(1),i=r.__importDefault(t(159)),n=t(114),o=t(72),a=r.__importStar(t(18)),c=t(160),m=t(9),u=t(8);function h(t){return i.default(t,"%Y %m %d %H %M %S").split(/\s+/).map(t=>parseInt(t,10))}function d(t,s){if(u.isFunction(s))return s(t);{const e=c.sprintf("$1%06d",function(t){return Math.round(t/1e3%1*1e6)}(t));return-1==(s=s.replace(/((^|[^%])(%%)*)%f/,e)).indexOf("%")?s:i.default(t,s)}}const l=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"];class _ extends n.TickFormatter{constructor(t){super(t),this.strip_leading_zeros=!0}static init_DatetimeTickFormatter(){this.define({microseconds:[a.Array,["%fus"]],milliseconds:[a.Array,["%3Nms","%S.%3Ns"]],seconds:[a.Array,["%Ss"]],minsec:[a.Array,[":%M:%S"]],minutes:[a.Array,[":%M","%Mm"]],hourmin:[a.Array,["%H:%M"]],hours:[a.Array,["%Hh","%H:%M"]],days:[a.Array,["%m/%d","%a%d"]],months:[a.Array,["%m/%Y","%b %Y"]],years:[a.Array,["%Y"]]})}initialize(){super.initialize(),this._update_width_formats()}_update_width_formats(){const t=+i.default(new Date),s=function(s){const e=s.map(s=>d(t,s).length),r=m.sort_by(m.zip(e,s),([t])=>t);return m.unzip(r)};this._width_formats={microseconds:s(this.microseconds),milliseconds:s(this.milliseconds),seconds:s(this.seconds),minsec:s(this.minsec),minutes:s(this.minutes),hourmin:s(this.hourmin),hours:s(this.hours),days:s(this.days),months:s(this.months),years:s(this.years)}}_get_resolution_str(t,s){const e=1.1*t;switch(!1){case!(e<.001):return"microseconds";case!(e<1):return"milliseconds";case!(e<60):return s>=60?"minsec":"seconds";case!(e<3600):return s>=3600?"hourmin":"minutes";case!(e<86400):return"hours";case!(e<2678400):return"days";case!(e<31536e3):return"months";default:return"years"}}doFormat(t,s){if(0==t.length)return[];const e=Math.abs(t[t.length-1]-t[0])/1e3,r=e/(t.length-1),i=this._get_resolution_str(r,e),[,[n]]=this._width_formats[i],a=[],c=l.indexOf(i),m={};for(const t of l)m[t]=0;m.seconds=5,m.minsec=4,m.minutes=4,m.hourmin=3,m.hours=3;for(const s of t){let t,e;try{e=h(s),t=d(s,n)}catch(t){o.logger.warn("unable to format tick for timestamp value "+s),o.logger.warn(" - "+t),a.push("ERR");continue}let r=!1,u=c;for(;0==e[m[l[u]]];){let n;if(u+=1,u==l.length)break;if(("minsec"==i||"hourmin"==i)&&!r){if("minsec"==i&&0==e[4]&&0!=e[5]||"hourmin"==i&&0==e[3]&&0!=e[4]){n=this._width_formats[l[c-1]][1][0],t=d(s,n);break}r=!0}n=this._width_formats[l[u]][1][0],t=d(s,n)}if(this.strip_leading_zeros){let s=t.replace(/^0+/g,"");s!=t&&isNaN(parseInt(s))&&(s="0"+s),a.push(s)}else a.push(t)}return a}}e.DatetimeTickFormatter=_,_.__name__="DatetimeTickFormatter",_.init_DatetimeTickFormatter()},
function _(e,t,n){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(r,n,e){Object.defineProperty(e,"__esModule",{value:!0});const t=r(1),i=t.__importStar(r(161)),u=r(162),a=t.__importDefault(r(159)),f=r(24),o=r(8);function l(r,...n){return u.sprintf(r,...n)}function s(r,n,e){if(o.isNumber(r)){return l((()=>{switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}})(),r)}return""+r}function c(r,n,t){if(null==n)return s;if(null!=t&&r in t){const n=t[r];if(o.isString(n)){if(n in e.DEFAULT_FORMATTERS)return e.DEFAULT_FORMATTERS[n];throw new Error(`Unknown tooltip field formatter type '${n}'`)}return function(r,e,t){return n.format(r,e,t)}}return e.DEFAULT_FORMATTERS.numeral}function m(r,n,e,t){if("$"==r[0]){return function(r,n){if(r in n)return n[r];throw new Error(`Unknown special variable '$${r}'`)}(r.substring(1),t)}return function(r,n,e){const t=n.get_column(r);if(null==t)return null;if(o.isNumber(e))return t[e];const i=t[e.index];if(o.isTypedArray(i)||o.isArray(i)){if(o.isArray(i[0])){return i[e.dim2][e.dim1]}return i[e.flat_index]}return i}(r.substring(1).replace(/[{}]/g,""),n,e)}e.DEFAULT_FORMATTERS={numeral:(r,n,e)=>i.format(r,n),datetime:(r,n,e)=>a.default(r,n),printf:(r,n,e)=>l(n,r)},e.sprintf=l,e.basic_formatter=s,e.get_formatter=c,e.get_value=m,e.replace_placeholders=function(r,n,e,t,i={}){return r=(r=r.replace(/@\$name/g,r=>`@{${i.name}}`)).replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g,(r,u,a)=>{const o=m(u,n,e,i);if(null==o)return""+f.escape("???");if("safe"==a)return""+o;const l=c(u,a,t);return""+f.escape(l(o,a,i))})}},
function _(e,n,t){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var r,i={},a=i,o="en-US",l=null,u="0,0";void 0!==n&&n.exports;function c(e){this._value=e}function s(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function f(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+s(i-r.length),n>0&&(a+="."+s(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function d(e,n,t){return n.indexOf("$")>-1?function(e,n,t){var r,a,l=n,u=l.indexOf("$"),c=l.indexOf("("),s=l.indexOf("+"),f=l.indexOf("-"),d="",p="";-1===l.indexOf("$")?"infix"===i[o].currency.position?(p=i[o].currency.symbol,i[o].currency.spaceSeparated&&(p=" "+p+" ")):i[o].currency.spaceSeparated&&(d=" "):l.indexOf(" $")>-1?(d=" ",l=l.replace(" $","")):l.indexOf("$ ")>-1?(d=" ",l=l.replace("$ ","")):l=l.replace("$","");if(a=h(e,l,t,p),-1===n.indexOf("$"))switch(i[o].currency.position){case"postfix":a.indexOf(")")>-1?((a=a.split("")).splice(-1,0,d+i[o].currency.symbol),a=a.join("")):a=a+d+i[o].currency.symbol;break;case"infix":break;case"prefix":a.indexOf("(")>-1||a.indexOf("-")>-1?(a=a.split(""),r=Math.max(c,f)+1,a.splice(r,0,i[o].currency.symbol+d),a=a.join("")):a=i[o].currency.symbol+d+a;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else u<=1?a.indexOf("(")>-1||a.indexOf("+")>-1||a.indexOf("-")>-1?(a=a.split(""),r=1,(u<c||u<s||u<f)&&(r=0),a.splice(r,0,i[o].currency.symbol+d),a=a.join("")):a=i[o].currency.symbol+d+a:a.indexOf(")")>-1?((a=a.split("")).splice(-1,0,d+i[o].currency.symbol),a=a.join("")):a=a+d+i[o].currency.symbol;return a}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=h(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):h(e,n,t)}function h(e,n,t,r){var a,u,c,s,d,h,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==l)return l;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(d=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(h=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,d)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===h?0:3*~~(h/3)-h)<0?M+3:M,a=0;a<M;a++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=i[o].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=i[o].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=i[o].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=i[o].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(u=Math.pow(1024,s),c=Math.pow(1024,s+1),e>=u&&e<c){C+=K[s],u>0&&(e/=u);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(u=Math.pow(1e3,s),c=Math.pow(1e3,s+1),e>=u&&e<c){C+=G[s],u>0&&(e/=u);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),i[o].ordinal&&(L+=i[o].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?f(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?f(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):f(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:i[o].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=f(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+i[o].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function p(e,n){i[e]=n}function m(e){o=e;var n=i[e].defaults;n&&n.format&&r.defaultFormat(n.format),n&&n.currencyFormat&&r.defaultCurrencyFormat(n.currencyFormat)}(r=function(e){return r.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=r.fn.unformat(e)),new c(Number(e))}).version="1.6.2",r.isNumbro=function(e){return e instanceof c},r.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;a[t]||(Object.keys(a).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),m(t)},r.setCulture=function(e,n){var t=e,r=e.split("-")[1],a=null;i[t]||(r&&Object.keys(i).forEach((function(e){a||e.split("-")[1]!==r||(a=e)})),t=a||n||"en-US"),m(t)},r.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return o;if(e&&!n){if(!a[e])throw new Error("Unknown language : "+e);m(e)}return!n&&a[e]||p(e,n),r},r.culture=function(e,n){if(!e)return o;if(e&&!n){if(!i[e])throw new Error("Unknown culture : "+e);m(e)}return!n&&i[e]||p(e,n),r},r.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return a[o];if(!a[e])throw new Error("Unknown language : "+e);return a[e]},r.cultureData=function(e){if(!e)return i[o];if(!i[e])throw new Error("Unknown culture : "+e);return i[e]},r.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),r.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),a},r.cultures=function(){return i},r.zeroFormat=function(e){l="string"==typeof e?e:null},r.defaultFormat=function(e){u="string"==typeof e?e:"0.0"},r.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},r.validate=function(e,n){var t,i,a,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=r.cultureData(n)}catch(e){c=r.cultureData(r.culture())}return a=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,i="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===a))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(i+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,i){return null!=t&&t!==r.culture()&&r.setCulture(t),d(Number(e),null!=n?n:u,null==i?Math.round:i)}}},
function _(e,n,t){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(e){return i(a(e),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}function i(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}var s=Object.create(null);function a(n){if(s[n])return s[n];for(var t,r=n,i=[],a=0;r;){if(null!==(t=e.text.exec(r)))i.push(t[0]);else if(null!==(t=e.modulo.exec(r)))i.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");i.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return s[n]=i}void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(9),a=e(110),s=e(164),r=e(165),c=e(168),_=e(169),m=e(167);class k extends s.CompositeTicker{constructor(e){super(e)}static init_DatetimeTicker(){this.override({num_minor_ticks:0,tickers:()=>[new a.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*m.ONE_MILLI,num_minor_ticks:0}),new a.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:m.ONE_SECOND,max_interval:30*m.ONE_MINUTE,num_minor_ticks:0}),new a.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:m.ONE_HOUR,max_interval:12*m.ONE_HOUR,num_minor_ticks:0}),new r.DaysTicker({days:t.range(1,32)}),new r.DaysTicker({days:t.range(1,31,3)}),new r.DaysTicker({days:[1,8,15,22]}),new r.DaysTicker({days:[1,15]}),new c.MonthsTicker({months:t.range(0,12,1)}),new c.MonthsTicker({months:t.range(0,12,2)}),new c.MonthsTicker({months:t.range(0,12,4)}),new c.MonthsTicker({months:t.range(0,12,6)}),new _.YearsTicker({})]})}}n.DatetimeTicker=k,k.__name__="DatetimeTicker",k.init_DatetimeTicker()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const r=t(1),s=t(111),n=r.__importStar(t(18)),_=t(9);class a extends s.ContinuousTicker{constructor(t){super(t)}static init_CompositeTicker(){this.define({tickers:[n.Array,[]]})}get min_intervals(){return this.tickers.map(t=>t.get_min_interval())}get max_intervals(){return this.tickers.map(t=>t.get_max_interval())}get min_interval(){return this.min_intervals[0]}get max_interval(){return this.max_intervals[0]}get_best_ticker(t,e,i){const r=e-t,s=this.get_ideal_interval(t,e,i),n=[_.sorted_index(this.min_intervals,s)-1,_.sorted_index(this.max_intervals,s)],a=[this.min_intervals[n[0]],this.max_intervals[n[1]]].map(t=>Math.abs(i-r/t));let c;if(_.is_empty(a.filter(t=>!isNaN(t))))c=this.tickers[0];else{const t=n[_.argmin(a)];c=this.tickers[t]}return c}get_interval(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)}get_ticks_no_defaults(t,e,i,r){return this.get_best_ticker(t,e,r).get_ticks_no_defaults(t,e,i,r)}}i.CompositeTicker=a,a.__name__="CompositeTicker",a.init_CompositeTicker()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const i=t(1),s=t(166),a=t(167),o=i.__importStar(t(18)),r=t(9);class _ extends s.SingleIntervalTicker{constructor(t){super(t)}static init_DaysTicker(){this.define({days:[o.Array,[]]}),this.override({num_minor_ticks:0})}initialize(){super.initialize();const t=this.days;t.length>1?this.interval=(t[1]-t[0])*a.ONE_DAY:this.interval=31*a.ONE_DAY}get_ticks_no_defaults(t,e,n,i){const s=function(t,e){const n=a.last_month_no_later_than(new Date(t)),i=a.last_month_no_later_than(new Date(e));i.setUTCMonth(i.getUTCMonth()+1);const s=[],o=n;for(;s.push(a.copy_date(o)),o.setUTCMonth(o.getUTCMonth()+1),!(o>i););return s}(t,e),o=this.days,_=this.interval;return{major:r.concat(s.map(t=>((t,e)=>{const n=t.getUTCMonth(),i=[];for(const s of o){const o=a.copy_date(t);o.setUTCDate(s),new Date(o.getTime()+e/2).getUTCMonth()==n&&i.push(o)}return i})(t,_))).map(t=>t.getTime()).filter(n=>t<=n&&n<=e),minor:[]}}}n.DaysTicker=_,_.__name__="DaysTicker",_.init_DaysTicker()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),r=e(111),l=n.__importStar(e(18));class a extends r.ContinuousTicker{constructor(e){super(e)}static init_SingleIntervalTicker(){this.define({interval:[l.Number]})}get_interval(e,t,i){return this.interval}get min_interval(){return this.interval}get max_interval(){return this.interval}}i.SingleIntervalTicker=a,a.__name__="SingleIntervalTicker",a.init_SingleIntervalTicker()},
function _(t,e,n){function _(t){return new Date(t.getTime())}function O(t){const e=_(t);return e.setUTCDate(1),e.setUTCHours(0),e.setUTCMinutes(0),e.setUTCSeconds(0),e.setUTCMilliseconds(0),e}Object.defineProperty(n,"__esModule",{value:!0}),n.ONE_MILLI=1,n.ONE_SECOND=1e3,n.ONE_MINUTE=60*n.ONE_SECOND,n.ONE_HOUR=60*n.ONE_MINUTE,n.ONE_DAY=24*n.ONE_HOUR,n.ONE_MONTH=30*n.ONE_DAY,n.ONE_YEAR=365*n.ONE_DAY,n.copy_date=_,n.last_month_no_later_than=O,n.last_year_no_later_than=function(t){const e=O(t);return e.setUTCMonth(0),e}},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const r=t(1),i=t(166),s=t(167),a=r.__importStar(t(18)),o=t(9);class _ extends i.SingleIntervalTicker{constructor(t){super(t)}static init_MonthsTicker(){this.define({months:[a.Array,[]]})}initialize(){super.initialize();const t=this.months;t.length>1?this.interval=(t[1]-t[0])*s.ONE_MONTH:this.interval=12*s.ONE_MONTH}get_ticks_no_defaults(t,e,n,r){const i=function(t,e){const n=s.last_year_no_later_than(new Date(t)),r=s.last_year_no_later_than(new Date(e));r.setUTCFullYear(r.getUTCFullYear()+1);const i=[],a=n;for(;i.push(s.copy_date(a)),a.setUTCFullYear(a.getUTCFullYear()+1),!(a>r););return i}(t,e),a=this.months;return{major:o.concat(i.map(t=>a.map(e=>{const n=s.copy_date(t);return n.setUTCMonth(e),n}))).map(t=>t.getTime()).filter(n=>t<=n&&n<=e),minor:[]}}}n.MonthsTicker=_,_.__name__="MonthsTicker",_.init_MonthsTicker()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const i=e(109),r=e(166),n=e(167);class _ extends r.SingleIntervalTicker{constructor(e){super(e)}initialize(){super.initialize(),this.interval=n.ONE_YEAR,this.basic_ticker=new i.BasicTicker({num_minor_ticks:0})}get_ticks_no_defaults(e,t,a,i){const r=n.last_year_no_later_than(new Date(e)).getUTCFullYear(),_=n.last_year_no_later_than(new Date(t)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,_,a,i).major.map(e=>Date.UTC(e,0,1)).filter(a=>e<=a&&a<=t),minor:[]}}}a.YearsTicker=_,_.__name__="YearsTicker"},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const s=e(150),o=e(155),n=e(171),r=e(172);class _ extends s.AxisView{}t.LogAxisView=_,_.__name__="LogAxisView";class c extends o.ContinuousAxis{constructor(e){super(e)}static init_LogAxis(){this.prototype.default_view=_,this.override({ticker:()=>new r.LogTicker,formatter:()=>new n.LogTickFormatter})}}t.LogAxis=c,c.__name__="LogAxis",c.init_LogAxis()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const i=t(1),o=t(114),a=t(113),n=i.__importStar(t(18));class c extends o.TickFormatter{constructor(t){super(t)}static init_LogTickFormatter(){this.define({ticker:[n.Instance,null]})}initialize(){super.initialize(),this.basic_formatter=new a.BasicTickFormatter}doFormat(t,e){if(0==t.length)return[];const r=null!=this.ticker?this.ticker.base:10;let i=!1;const o=new Array(t.length);for(let e=0,a=t.length;e<a;e++)if(o[e]=`${r}^${Math.round(Math.log(t[e])/Math.log(r))}`,e>0&&o[e]==o[e-1]){i=!0;break}return i?this.basic_formatter.doFormat(t,e):o}}r.LogTickFormatter=c,c.__name__="LogTickFormatter",c.init_LogTickFormatter()},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(110),s=t(9);class n extends i.AdaptiveTicker{constructor(t){super(t)}static init_LogTicker(){this.override({mantissas:[1,5]})}get_ticks_no_defaults(t,o,e,i){const n=this.num_minor_ticks,r=[],c=this.base,a=Math.log(t)/Math.log(c),f=Math.log(o)/Math.log(c),l=f-a;let h;if(isFinite(l))if(l<2){const e=this.get_interval(t,o,i),c=Math.floor(t/e),a=Math.ceil(o/e);if(h=s.range(c,a+1).filter(t=>0!=t).map(t=>t*e).filter(e=>t<=e&&e<=o),n>0&&h.length>0){const t=e/n,o=s.range(0,n).map(o=>o*t);for(const t of o.slice(1))r.push(h[0]-t);for(const t of h)for(const e of o)r.push(t+e)}}else{const t=Math.ceil(.999999*a),o=Math.floor(1.000001*f),e=Math.ceil((o-t)/9);if(h=s.range(t-1,o+1,e).map(t=>c**t),n>0&&h.length>0){const t=c**e/n,o=s.range(1,n+1).map(o=>o*t);for(const t of o)r.push(h[0]/t);r.push(h[0]);for(const t of h)for(const e of o)r.push(t*e)}}else h=[];return{major:h.filter(e=>t<=e&&e<=o),minor:r.filter(e=>t<=e&&e<=o)}}}e.LogTicker=n,n.__name__="LogTicker",n.init_LogTicker()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const i=e(150),s=e(157),o=e(174),a=e(175);class c extends i.AxisView{}r.MercatorAxisView=c,c.__name__="MercatorAxisView";class n extends s.LinearAxis{constructor(e){super(e)}static init_MercatorAxis(){this.prototype.default_view=c,this.override({ticker:()=>new a.MercatorTicker({dimension:"lat"}),formatter:()=>new o.MercatorTickFormatter({dimension:"lat"})})}}r.MercatorAxis=n,n.__name__="MercatorAxis",n.init_MercatorAxis()},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});const o=r(1),n=r(113),i=o.__importStar(r(18)),c=r(32);class s extends n.BasicTickFormatter{constructor(r){super(r)}static init_MercatorTickFormatter(){this.define({dimension:[i.LatLon]})}doFormat(r,t){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==r.length)return[];const e=r.length,o=new Array(e);if("lon"==this.dimension)for(let n=0;n<e;n++){const[e]=c.wgs84_mercator.inverse([r[n],t.loc]);o[n]=e}else for(let n=0;n<e;n++){const[,e]=c.wgs84_mercator.inverse([t.loc,r[n]]);o[n]=e}return super.doFormat(o,t)}}e.MercatorTickFormatter=s,s.__name__="MercatorTickFormatter",s.init_MercatorTickFormatter()},
function _(r,o,e){Object.defineProperty(e,"__esModule",{value:!0});const n=r(1),s=r(109),i=n.__importStar(r(18)),t=r(32);class c extends s.BasicTicker{constructor(r){super(r)}static init_MercatorTicker(){this.define({dimension:[i.LatLon]})}get_ticks_no_defaults(r,o,e,n){if(null==this.dimension)throw new Error("MercatorTicker.dimension not configured");let s,i,c;[r,o]=t.clip_mercator(r,o,this.dimension),"lon"===this.dimension?([s,c]=t.wgs84_mercator.inverse([r,e]),[i,c]=t.wgs84_mercator.inverse([o,e])):([c,s]=t.wgs84_mercator.inverse([e,r]),[c,i]=t.wgs84_mercator.inverse([e,o]));const a=super.get_ticks_no_defaults(s,i,e,n),_=[],f=[];if("lon"===this.dimension){for(const r of a.major)if(t.in_bounds(r,"lon")){const[o]=t.wgs84_mercator.forward([r,c]);_.push(o)}for(const r of a.minor)if(t.in_bounds(r,"lon")){const[o]=t.wgs84_mercator.forward([r,c]);f.push(o)}}else{for(const r of a.major)if(t.in_bounds(r,"lat")){const[,o]=t.wgs84_mercator.forward([c,r]);_.push(o)}for(const r of a.minor)if(t.in_bounds(r,"lat")){const[,o]=t.wgs84_mercator.forward([c,r]);f.push(o)}}return{major:_,minor:f}}}e.MercatorTicker=c,c.__name__="MercatorTicker",c.init_MercatorTicker()},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});var t=e(177);o.CustomJS=t.CustomJS;var u=e(179);o.OpenURL=u.OpenURL},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const n=t(1),u=t(178),c=n.__importStar(t(18)),r=t(17),a=t(24);class i extends u.Callback{constructor(t){super(t)}static init_CustomJS(){this.define({args:[c.Any,{}],code:[c.String,""]})}get names(){return r.keys(this.args)}get values(){return r.values(this.args)}get func(){const t=a.use_strict(this.code);return new Function(...this.names,"cb_obj","cb_data",t)}execute(t,e={}){return this.func.apply(t,this.values.concat(t,e))}}s.CustomJS=i,i.__name__="CustomJS",i.init_CustomJS()},
function _(e,c,l){Object.defineProperty(l,"__esModule",{value:!0});const a=e(71);class n extends a.Model{constructor(e){super(e)}}l.Callback=n,n.__name__="Callback"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(1),s=e(178),i=e(160),c=o.__importStar(e(18));class r extends s.Callback{constructor(e){super(e)}static init_OpenURL(){this.define({url:[c.String,"http://"],same_tab:[c.Boolean,!1]})}execute(e,{source:t}){const n=e=>{const n=i.replace_placeholders(this.url,t,e);this.same_tab?window.location.href=n:window.open(n)},{selected:o}=t;for(const e of o.indices)n(e);for(const e of o.line_indices)n(e)}}n.OpenURL=r,r.__name__="OpenURL",r.init_OpenURL()},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=a(181);r.Canvas=n.Canvas;var s=a(184);r.CartesianFrame=s.CartesianFrame},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),a=e(13),n=e(66),l=e(72),o=s.__importStar(e(18)),r=e(68),h=e(17),c=e(88),d=e(182),_=e(183),v=(()=>{const e=document.createElement("canvas"),t=e.getContext("webgl",{premultipliedAlpha:!0});return null!=t?{canvas:e,gl:t}:void l.logger.trace("WebGL is not supported")})(),p={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"};class g{constructor(e,t){switch(this.backend=e,this.hidpi=t,this.pixel_ratio=1,this.bbox=new c.BBox,e){case"webgl":case"canvas":{this._el=this._canvas=r.canvas({style:p});const e=this.canvas.getContext("2d");if(null==e)throw new Error("unable to obtain 2D rendering context");this._ctx=e,t&&(this.pixel_ratio=devicePixelRatio);break}case"svg":{const e=new _.SVGRenderingContext2D;this._ctx=e,this._canvas=e.getSvg(),this._el=r.div({style:p},this._canvas);break}}d.fixup_ctx(this._ctx)}get canvas(){return this._canvas}get ctx(){return this._ctx}get el(){return this._el}resize(e,t){this.bbox=new c.BBox({left:0,top:0,width:e,height:t});const i=this._ctx instanceof _.SVGRenderingContext2D?this._ctx:this.canvas;i.width=e*this.pixel_ratio,i.height=t*this.pixel_ratio}prepare(){const{ctx:e,hidpi:t,pixel_ratio:i}=this;e.save(),t&&(e.scale(i,i),e.translate(.5,.5)),this.clear()}clear(){const{x:e,y:t,width:i,height:s}=this.bbox;this.ctx.clearRect(e,t,i,s)}finish(){this.ctx.restore()}save(e){const{_canvas:t}=this;if(t instanceof HTMLCanvasElement)if(null!=t.msToBlob){const i=t.msToBlob();window.navigator.msSaveBlob(i,e)}else{const i=document.createElement("a");i.href=t.toDataURL("image/png"),i.download=e+".png",i.target="_blank",i.dispatchEvent(new MouseEvent("click"))}else{const t=this._ctx.getSerializedSvg(!0),i=new Blob([t],{type:"text/plain"}),s=document.createElement("a");s.download=e+".svg",s.innerHTML="Download svg",s.href=window.URL.createObjectURL(i),s.onclick=e=>document.body.removeChild(e.target),s.style.display="none",document.body.appendChild(s),s.click()}}}i.CanvasLayer=g,g.__name__="CanvasLayer";class b extends n.DOMView{initialize(){super.initialize();const{output_backend:e,hidpi:t}=this.model;"webgl"==e&&(this.webgl=v),this.underlays_el=r.div({style:p}),this.primary=new g(e,t),this.overlays=new g(e,t),this.overlays_el=r.div({style:p}),this.events_el=r.div({class:"bk-canvas-events",style:p});const i=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];h.extend(this.el.style,p),r.append(this.el,...i),l.logger.debug("CanvasView initialized")}add_underlay(e){this.underlays_el.appendChild(e)}add_overlay(e){this.overlays_el.appendChild(e)}add_event(e){this.events_el.appendChild(e)}get pixel_ratio(){return this.primary.pixel_ratio}resize(e,t){this.bbox=new c.BBox({left:0,top:0,width:e,height:t}),this.primary.resize(e,t),this.overlays.resize(e,t)}prepare_webgl(e){const{webgl:t}=this;if(null!=t){const{width:i,height:s}=this.bbox;t.canvas.width=this.pixel_ratio*i,t.canvas.height=this.pixel_ratio*s;const{gl:a}=t;a.enable(a.SCISSOR_TEST);const[n,l,o,r]=e,{xview:h,yview:c}=this.bbox,d=h.compute(n),_=c.compute(l+r),v=this.pixel_ratio;a.scissor(v*d,v*_,v*o,v*r),a.enable(a.BLEND),a.blendFuncSeparate(a.SRC_ALPHA,a.ONE_MINUS_SRC_ALPHA,a.ONE_MINUS_DST_ALPHA,a.ONE)}}clear_webgl(){const{webgl:e}=this;if(null!=e){const{gl:t,canvas:i}=e;t.viewport(0,0,i.width,i.height),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT||t.DEPTH_BUFFER_BIT)}}blit_webgl(e){const{webgl:t}=this;if(null!=t&&(l.logger.debug("drawing with WebGL"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi)){const t=this.pixel_ratio;e.scale(t,t),e.translate(.5,.5)}}save(e){const{output_backend:t}=this.model,{width:i,height:s}=this.bbox,a=new g(t,!1);a.resize(i,s),a.ctx.drawImage(this.primary.canvas,0,0),a.ctx.drawImage(this.overlays.canvas,0,0),a.save(e)}}i.CanvasView=b,b.__name__="CanvasView";class w extends a.HasProps{constructor(e){super(e)}static init_Canvas(){this.prototype.default_view=b,this.internal({hidpi:[o.Boolean,!0],output_backend:[o.OutputBackend,"canvas"]})}}i.Canvas=w,w.__name__="Canvas",w.init_Canvas()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.fixup_ctx=function(e){!function(e){e.setLineDash||(e.setLineDash=t=>{e.mozDash=t,e.webkitLineDash=t}),e.getLineDash||(e.getLineDash=()=>e.mozDash)}(e),function(e){e.setLineDashOffset=t=>{e.lineDashOffset=t,e.mozDashOffset=t,e.webkitLineDashOffset=t},e.getLineDashOffset=()=>e.mozDashOffset}(e),function(e){e.setImageSmoothingEnabled=t=>{e.imageSmoothingEnabled=t,e.mozImageSmoothingEnabled=t,e.oImageSmoothingEnabled=t,e.webkitImageSmoothingEnabled=t,e.msImageSmoothingEnabled=t},e.getImageSmoothingEnabled=()=>{const t=e.imageSmoothingEnabled;return null==t||t}}(e),function(e){e.measureText&&null==e.html5MeasureText&&(e.html5MeasureText=e.measureText,e.measureText=t=>{const n=e.html5MeasureText(t);return n.ascent=1.6*e.html5MeasureText("m").width,n})}(e),function(e){e.ellipse||(e.ellipse=function(t,n,a,o,s,i,m,h=!1){const l=.551784;e.translate(t,n),e.rotate(s);let u=a,r=o;h&&(u=-a,r=-o),e.moveTo(-u,0),e.bezierCurveTo(-u,r*l,-u*l,r,0,r),e.bezierCurveTo(u*l,r,u,r*l,u,0),e.bezierCurveTo(u,-r*l,u*l,-r,0,-r),e.bezierCurveTo(-u*l,-r,-u,-r*l,-u,0),e.rotate(-s),e.translate(-t,-n)})}(e)}},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(8);function r(t){return[...t.childNodes]}function n(t){if(!t)throw new Error("cannot create a random attribute name for an undefined object");const e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";let s="";do{s="";for(let t=0;t<12;t++)s+=e[Math.floor(Math.random()*e.length)]}while(t[s]);return s}function a(t){const e={left:"start",right:"end",center:"middle",start:"start",end:"end"};return e[t]||e.start}function o(t){const e={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return e[t]||e.alphabetic}const l=function(t,e){const s=new Map,i=t.split(",");e=e||10;for(let t=0;t<i.length;t+=2){const r="&"+i[t+1]+";",n=parseInt(i[t],e);s.set(r,"&#"+n+";")}return s.set("\\xa0","&#160;"),s}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),h={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};class c{constructor(t,e){this.__root=t,this.__ctx=e}addColorStop(t,e){const s=this.__ctx.__createElement("stop");if(s.setAttribute("offset",""+t),-1!==e.indexOf("rgba")){const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),[,i,r,n,a]=t;s.setAttribute("stop-color",`rgb(${i},${r},${n})`),s.setAttribute("stop-opacity",a)}else s.setAttribute("stop-color",e);this.__root.appendChild(s)}}c.__name__="CanvasGradient";class _{constructor(t,e){this.__root=t,this.__ctx=e}}_.__name__="CanvasPattern";class u{constructor(t){var e,s,i,r;this.__currentPosition=null,this.__currentElementsToStyle=null,this.enableMirroring=null!==(e=null==t?void 0:t.enableMirroring)&&void 0!==e&&e,this.__document=null!==(s=null==t?void 0:t.document)&&void 0!==s?s:document,(null==t?void 0:t.ctx)?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[this.__getStyleState()],this.__groupStack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.width=null!==(i=null==t?void 0:t.width)&&void 0!==i?i:500,this.height=null!==(r=null==t?void 0:t.height)&&void 0!==r?r:500,this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs),this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g"),this.__root.appendChild(this.__currentElement)}get canvas(){return this}get width(){return this._width}set width(t){this._width=t,this.__root.setAttribute("width",""+t)}get height(){return this._height}set height(t){this._height=t,this.__root.setAttribute("height",""+t)}__createElement(t,e={},s=!1){const i=this.__document.createElementNS("http://www.w3.org/2000/svg",t);s&&(i.setAttribute("fill","none"),i.setAttribute("stroke","none"));const r=Object.keys(e);for(const t of r)i.setAttribute(t,""+e[t]);return i}__setDefaultStyles(){const t=Object.keys(h),e=this;for(let s=0;s<t.length;s++){const i=t[s];e[i]=h[i].canvas}}__applyStyleState(t){const e=Object.keys(t),s=this;for(let i=0;i<e.length;i++){const r=e[i];s[r]=t[r]}}__getStyleState(){const t=Object.keys(h),e={};for(let s=0;s<t.length;s++){const i=t[s];e[i]=this[i]}return e}__applyStyleToCurrentElement(t){let e=this.__currentElement;const s=this.__currentElementsToStyle;if(null!=s){e.setAttribute(t,""),e=s.element;for(const e of s.children)e.setAttribute(t,"")}const n=Object.keys(h);for(let s=0;s<n.length;s++){const a=h[n[s]],o=this[n[s]];if(a.apply)if(o instanceof _){if(o.__ctx)for(;o.__ctx.__defs.childNodes.length;){const t=r(o.__ctx.__defs)[0].getAttribute("id");this.__ids[t]=t,this.__defs.appendChild(o.__ctx.__defs.childNodes[0])}const t=o.__root.getAttribute("id");e.setAttribute(a.apply,`url(#${t})`)}else if(o instanceof c){const t=o.__root.getAttribute("id");e.setAttribute(a.apply,`url(#${t})`)}else if(-1!==a.apply.indexOf(t)&&a.svg!==o)if("stroke"!==a.svgAttr&&"fill"!==a.svgAttr||!i.isString(o)||-1===o.indexOf("rgba")){let i=a.svgAttr;if("globalAlpha"===n[s]&&(i=t+"-"+a.svgAttr,e.getAttribute(i)))continue;e.setAttribute(i,""+o)}else{const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(o),[,s,i,r,n]=t;e.setAttribute(a.svgAttr,`rgb(${s},${i},${r})`);let l=parseFloat(n);const h=this.globalAlpha;null!=h&&(l*=h),e.setAttribute(a.svgAttr+"-opacity",""+l)}}}__closestGroupOrSvg(t=this.__currentElement){return"g"===t.nodeName||"svg"===t.nodeName?t:this.__closestGroupOrSvg(t.parentNode)}getSerializedSvg(t=!1){let e=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(e)&&(e=e.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)for(const[t,s]of l){const i=new RegExp(t,"gi");i.test(e)&&(e=e.replace(i,s))}return e}getSvg(){return this.__root}save(){const t=this.__createElement("g"),e=this.__closestGroupOrSvg();this.__groupStack.push(e),e.appendChild(t),this.__currentElement=t,this.__stack.push(this.__getStyleState())}restore(){this.__currentElement=this.__groupStack.pop(),this.__currentElementsToStyle=null,this.__currentElement||(this.__currentElement=r(this.__root)[1]);const t=this.__stack.pop();this.__applyStyleState(t)}__addTransform(t){const e=this.__closestGroupOrSvg();if(e.childNodes.length>0){"path"===this.__currentElement.nodeName&&(this.__currentElementsToStyle||(this.__currentElementsToStyle={element:e,children:[]}),this.__currentElementsToStyle.children.push(this.__currentElement),this.__applyCurrentDefaultPath());const t=this.__createElement("g");e.appendChild(t),this.__currentElement=t}let s=this.__currentElement.getAttribute("transform");if(s){if(s.includes(t))return;s+=" "}else s="";s+=t,this.__currentElement.setAttribute("transform",s)}scale(t,e){this.__addTransform(`scale(${t},${null!=e?e:t})`)}rotate(t){const e=180*t/Math.PI,[s,i]=[0,0];this.__addTransform(`rotate(${e},${s},${i})`)}translate(t,e){this.__addTransform(`translate(${t},${e})`)}transform(t,e,s,i,r,n){this.__addTransform(`matrix(${t},${e},${s},${i},${r},${n})`)}beginPath(){this.__currentDefaultPath="",this.__currentPosition=null;const t=this.__createElement("path",{},!0);this.__closestGroupOrSvg().appendChild(t),this.__currentElement=t}__applyCurrentDefaultPath(){const t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)}__addPathCommand(t){this.__currentDefaultPath+=" ",this.__currentDefaultPath+=t}moveTo(t,e){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.__currentPosition={x:t,y:e},this.__addPathCommand(`M ${t} ${e}`)}closePath(){this.__currentDefaultPath&&this.__addPathCommand("Z")}lineTo(t,e){this.__currentPosition={x:t,y:e},this.__currentDefaultPath.indexOf("M")>-1?this.__addPathCommand(`L ${t} ${e}`):this.__addPathCommand(`M ${t} ${e}`)}bezierCurveTo(t,e,s,i,r,n){this.__currentPosition={x:r,y:n},this.__addPathCommand(`C ${t} ${e} ${s} ${i} ${r} ${n}`)}quadraticCurveTo(t,e,s,i){this.__currentPosition={x:s,y:i},this.__addPathCommand(`Q ${t} ${e} ${s} ${i}`)}arcTo(t,e,s,i,r){if(null==this.__currentPosition)return;const n=this.__currentPosition.x,a=this.__currentPosition.y;if(r<0)throw new Error("IndexSizeError: The radius provided ("+r+") is negative.");if(n===t&&a===e||t===s&&e===i||0===r)return void this.lineTo(t,e);function o([t,e]){const s=Math.sqrt(t**2+e**2);return[t/s,e/s]}const l=o([n-t,a-e]),h=o([s-t,i-e]);if(l[0]*h[1]==l[1]*h[0])return void this.lineTo(t,e);const c=l[0]*h[0]+l[1]*h[1],_=Math.acos(Math.abs(c)),u=o([l[0]+h[0],l[1]+h[1]]),d=r/Math.sin(_/2),p=t+d*u[0],m=e+d*u[1],g=[-l[1],l[0]],f=[h[1],-h[0]];function v(t){const e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}const w=v(g),b=v(f);this.lineTo(p+g[0]*r,m+g[1]*r),this.arc(p,m,r,w,b)}stroke(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill stroke markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke")}fill(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke fill markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill")}rect(t,e,s,i){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+s,e),this.lineTo(t+s,e+i),this.lineTo(t,e+i),this.lineTo(t,e),this.closePath()}fillRect(t,e,s,i){const r=this.__createElement("rect",{x:t,y:e,width:s,height:i},!0);this.__closestGroupOrSvg().appendChild(r),this.__currentElement=r,this.__applyStyleToCurrentElement("fill")}strokeRect(t,e,s,i){const r=this.__createElement("rect",{x:t,y:e,width:s,height:i},!0);this.__closestGroupOrSvg().appendChild(r),this.__currentElement=r,this.__applyStyleToCurrentElement("stroke")}__clearCanvas(){const t=this.__closestGroupOrSvg().getAttribute("transform"),e=r(this.__root)[1],s=e.childNodes;for(let t=s.length-1;t>=0;t--)s[t]&&e.removeChild(s[t]);this.__currentElement=e,this.__groupStack=[],t&&this.__addTransform(t)}clearRect(t,e,s,i){if(0===t&&0===e&&s===this.width&&i===this.height)return void this.__clearCanvas();const r=this.__createElement("rect",{x:t,y:e,width:s,height:i,fill:"#FFFFFF"},!0);this.__closestGroupOrSvg().appendChild(r)}createLinearGradient(t,e,s,i){const r=this.__createElement("linearGradient",{id:n(this.__ids),x1:t+"px",x2:s+"px",y1:e+"px",y2:i+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(r),new c(r,this)}createRadialGradient(t,e,s,i,r,a){const o=this.__createElement("radialGradient",{id:n(this.__ids),cx:i+"px",cy:r+"px",r:a+"px",fx:t+"px",fy:e+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(o),new c(o,this)}__parseFont(){const t=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),e={style:t[1]||"normal",size:t[4]||"10px",family:t[6]||"sans-serif",weight:t[3]||"normal",decoration:t[2]||"normal"};return"underline"===this.__fontUnderline&&(e.decoration="underline"),null!=this.__fontHref&&(e.href=this.__fontHref),e}__wrapTextLink(t,e){if(t.href){const s=this.__createElement("a");return s.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),s.appendChild(e),s}return e}__applyText(t,e,s,i){const r=this.__parseFont(),n=this.__closestGroupOrSvg(),l=this.__createElement("text",{"font-family":r.family,"font-size":r.size,"font-style":r.style,"font-weight":r.weight,"text-decoration":r.decoration,x:e,y:s,"text-anchor":a(this.textAlign),"dominant-baseline":o(this.textBaseline)},!0);l.appendChild(this.__document.createTextNode(t)),this.__currentElement=l,this.__applyStyleToCurrentElement(i),n.appendChild(this.__wrapTextLink(r,l))}fillText(t,e,s){this.__applyText(t,e,s,"fill")}strokeText(t,e,s){this.__applyText(t,e,s,"stroke")}measureText(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)}arc(t,e,s,i,r,n=!1){if(i===r)return;(i%=2*Math.PI)===(r%=2*Math.PI)&&(r=(r+2*Math.PI-.001*(n?-1:1))%(2*Math.PI));const a=t+s*Math.cos(r),o=e+s*Math.sin(r),l=t+s*Math.cos(i),h=e+s*Math.sin(i),c=n?0:1;let _=0,u=r-i;u<0&&(u+=2*Math.PI),_=n?u>Math.PI?0:1:u>Math.PI?1:0,this.moveTo(l,h);const d=s,p=s;this.__addPathCommand(`A ${d} ${p} 0 ${_} ${c} ${a} ${o}`),this.__currentPosition={x:a,y:o}}clip(){const t=this.__closestGroupOrSvg(),e=this.__createElement("clipPath"),s=n(this.__ids),i=this.__createElement("g");this.__applyCurrentDefaultPath(),t.removeChild(this.__currentElement),e.setAttribute("id",s),e.appendChild(this.__currentElement),this.__defs.appendChild(e),t.setAttribute("clip-path",`url(#${s})`),t.appendChild(i),this.__currentElement=i}drawImage(t,...e){let s,i,n,a,o,l,h,c;if(2==e.length)[s,i]=e,o=0,l=0,h=t.width,c=t.height,n=h,a=c;else if(4==e.length)[s,i,n,a]=e,o=0,l=0,h=t.width,c=t.height;else{if(8!==e.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);[o,l,h,c,s,i,n,a]=e}const _=this.__closestGroupOrSvg(),d="translate("+s+", "+i+")";if(t instanceof u){const e=t.getSvg().cloneNode(!0);if(e.childNodes&&e.childNodes.length>1){const t=r(e)[0];for(;t.childNodes.length;){const e=r(t)[0].getAttribute("id");this.__ids[e]=e,this.__defs.appendChild(r(t)[0])}const s=r(e)[1];if(s){const t=s.getAttribute("transform");let e;e=t?t+" "+d:d,s.setAttribute("transform",e),_.appendChild(s)}}}else if(t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__createElement("image");if(e.setAttribute("width",""+n),e.setAttribute("height",""+a),e.setAttribute("preserveAspectRatio","none"),o||l||h!==t.width||c!==t.height){const e=this.__document.createElement("canvas");e.width=n,e.height=a,e.getContext("2d").drawImage(t,o,l,h,c,0,0,n,a),t=e}e.setAttribute("transform",d);const s=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",s),_.appendChild(e)}else if(t instanceof HTMLCanvasElement){const e=this.__createElement("image");e.setAttribute("width",""+n),e.setAttribute("height",""+a),e.setAttribute("preserveAspectRatio","none");const s=this.__document.createElement("canvas");s.width=n,s.height=a;const i=s.getContext("2d");i.imageSmoothingEnabled=!1,i.drawImage(t,o,l,h,c,0,0,n,a),t=s,e.setAttribute("transform",d),e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.toDataURL()),_.appendChild(e)}}createPattern(t,e){const s=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),i=n(this.__ids);let r;if(s.setAttribute("id",i),s.setAttribute("width",""+t.width),s.setAttribute("height",""+t.height),t instanceof HTMLCanvasElement||t instanceof HTMLImageElement||t instanceof SVGImageElement){r=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),r.setAttribute("width",""+t.width),r.setAttribute("height",""+t.height);const e=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");r.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",e),s.appendChild(r),this.__defs.appendChild(s)}else t instanceof u&&(s.appendChild(t.__root.childNodes[1]),this.__defs.appendChild(s));return new _(s,this)}setLineDash(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null}}s.SVGRenderingContext2D=u,u.__name__="SVGRenderingContext2D"},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const a=e(185),_=e(121),n=e(130),r=e(131),i=e(186),g=e(90),c=e(188);class h extends c.LayoutItem{constructor(e,t,s,a,_={},n={}){super(),this.x_scale=e,this.y_scale=t,this.x_range=s,this.y_range=a,this.extra_x_ranges=_,this.extra_y_ranges=n,this._configure_scales()}map_to_screen(e,t,s="default",a="default"){return[this.xscales[s].v_compute(e),this.yscales[a].v_compute(t)]}_get_ranges(e,t){return Object.assign(Object.assign({},t),{default:e})}_get_scales(e,t,s){const c={};for(const h in t){const o=t[h];if((o instanceof i.DataRange1d||o instanceof r.Range1d)&&!(e instanceof _.ContinuousScale))throw new Error(`Range ${o.type} is incompatible is Scale ${e.type}`);if(o instanceof g.FactorRange&&!(e instanceof a.CategoricalScale))throw new Error(`Range ${o.type} is incompatible is Scale ${e.type}`);e instanceof n.LogScale&&o instanceof i.DataRange1d&&(o.scale_hint="log");const l=e.clone();l.setv({source_range:o,target_range:s}),c[h]=l}return c}_configure_frame_ranges(){this._h_target=new r.Range1d({start:this._left.value,end:this._right.value}),this._v_target=new r.Range1d({start:this._bottom.value,end:this._top.value})}_configure_scales(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._xscales=this._get_scales(this.x_scale,this._x_ranges,this._h_target),this._yscales=this._get_scales(this.y_scale,this._y_ranges,this._v_target)}_update_scales(){this._configure_frame_ranges();for(const e in this._xscales){this._xscales[e].target_range=this._h_target}for(const e in this._yscales){this._yscales[e].target_range=this._v_target}}_set_geometry(e,t){super._set_geometry(e,t),this._update_scales()}get x_ranges(){return this._x_ranges}get y_ranges(){return this._y_ranges}get xscales(){return this._xscales}get yscales(){return this._yscales}}s.CartesianFrame=h,h.__name__="CartesianFrame"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(122);class _ extends n.Scale{constructor(e){super(e)}compute(e){return super._linear_compute(this.source_range.synthetic(e))}v_compute(e){return super._linear_v_compute(this.source_range.v_synthetic(e))}invert(e){return this._linear_invert(e)}v_invert(e){return this._linear_v_invert(e)}}t.CategoricalScale=_,_.__name__="CategoricalScale"},
function _(t,i,n){Object.defineProperty(n,"__esModule",{value:!0});const e=t(1),a=t(187),s=t(81),l=t(72),_=e.__importStar(t(18)),o=e.__importStar(t(88)),r=t(9);class h extends a.DataRange{constructor(t){super(t),this.have_updated_interactively=!1}static init_DataRange1d(){this.define({start:[_.Number],end:[_.Number],range_padding:[_.Number,.1],range_padding_units:[_.PaddingUnits,"percent"],flipped:[_.Boolean,!1],follow:[_.StartEnd],follow_interval:[_.Number],default_span:[_.Number,2],only_visible:[_.Boolean,!1]}),this.internal({scale_hint:[_.String,"auto"]})}initialize(){super.initialize(),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}computed_renderers(){const t=this.names;let i=this.renderers;if(0==i.length)for(const t of this.plots){const n=t.renderers.filter(t=>t instanceof s.GlyphRenderer);i=i.concat(n)}t.length>0&&(i=i.filter(i=>r.includes(t,i.name))),l.logger.debug(`computed ${i.length} renderers for ${this}`);for(const t of i)l.logger.trace(" - "+t);return i}_compute_plot_bounds(t,i){let n=o.empty();for(const e of t){const t=i.get(e);null==t||!e.visible&&this.only_visible||(n=o.union(n,t))}return n}adjust_bounds_for_aspect(t,i){const n=o.empty();let e=t.x1-t.x0;e<=0&&(e=1);let a=t.y1-t.y0;a<=0&&(a=1);const s=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return e<i*a?e=i*a:a=e/i,n.x1=s+.5*e,n.x0=s-.5*e,n.y1=l+.5*a,n.y0=l-.5*a,n}_compute_min_max(t,i){let n,e,a=o.empty();for(const i of t)a=o.union(a,i);return[n,e]=0==i?[a.x0,a.x1]:[a.y0,a.y1],[n,e]}_compute_range(t,i){const n=this.range_padding;let e,a;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){let s,_;if((isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,l.logger.warn("could not determine minimum data value for log axis, DataRange1d using value "+t)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,l.logger.warn("could not determine maximum data value for log axis, DataRange1d using value "+i)),i==t)_=this.default_span+.001,s=Math.log(t)/Math.log(10);else{let e,a;"percent"==this.range_padding_units?(e=Math.log(t)/Math.log(10),a=Math.log(i)/Math.log(10),_=(a-e)*(1+n)):(e=Math.log(t-n)/Math.log(10),a=Math.log(i+n)/Math.log(10),_=a-e),s=(e+a)/2}e=10**(s-_/2),a=10**(s+_/2)}else{let s;s=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+n):i-t+2*n;const l=(i+t)/2;e=l-s/2,a=l+s/2}let s=1;this.flipped&&([e,a]=[a,e],s=-1);const _=this.follow_interval;return null!=_&&Math.abs(e-a)>_&&("start"==this.follow?a=e+s*_:"end"==this.follow&&(e=a-s*_)),[e,a]}update(t,i,n,e){if(this.have_updated_interactively)return;const a=this.computed_renderers();let s=this._compute_plot_bounds(a,t);null!=e&&(s=this.adjust_bounds_for_aspect(s,e)),this._plot_bounds.set(n,s);const[l,_]=this._compute_min_max(this._plot_bounds.values(),i);let[o,r]=this._compute_range(l,_);null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(o=this._initial_start):o=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(r=this._initial_end):r=this._initial_end);const[h,d]=[this.start,this.end];if(o!=h||r!=d){const t={};o!=h&&(t.start=o),r!=d&&(t.end=r),this.setv(t)}"auto"==this.bounds&&this.setv({bounds:[o,r]},{silent:!0}),this.change.emit()}reset(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()}}n.DataRange1d=h,h.__name__="DataRange1d",h.init_DataRange1d()},
function _(e,a,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1),r=e(91),s=n.__importStar(e(18));class _ extends r.Range{constructor(e){super(e)}static init_DataRange(){this.define({names:[s.Array,[]],renderers:[s.Array,[]]})}}t.DataRange=_,_.__name__="DataRange",_.init_DataRange()},
function _(a,o,t){Object.defineProperty(t,"__esModule",{value:!0});var e=a(189);t.Sizeable=e.Sizeable;var r=a(190);t.Layoutable=r.Layoutable,t.LayoutItem=r.LayoutItem;var n=a(191);t.HStack=n.HStack,t.VStack=n.VStack,t.AnchorLayout=n.AnchorLayout;var u=a(192);t.Grid=u.Grid,t.Row=u.Row,t.Column=u.Column;var c=a(193);t.ContentBox=c.ContentBox,t.VariadicBox=c.VariadicBox},
function _(h,t,i){Object.defineProperty(i,"__esModule",{value:!0});const{min:e,max:w}=Math;class d{constructor(h={}){this.width=null!=h.width?h.width:0,this.height=null!=h.height?h.height:0}bounded_to({width:h,height:t}){return new d({width:this.width==1/0&&null!=h?h:this.width,height:this.height==1/0&&null!=t?t:this.height})}expanded_to({width:h,height:t}){return new d({width:h!=1/0?w(this.width,h):this.width,height:t!=1/0?w(this.height,t):this.height})}expand_to({width:h,height:t}){this.width=w(this.width,h),this.height=w(this.height,t)}narrowed_to({width:h,height:t}){return new d({width:e(this.width,h),height:e(this.height,t)})}narrow_to({width:h,height:t}){this.width=e(this.width,h),this.height=e(this.height,t)}grow_by({left:h,right:t,top:i,bottom:e}){const w=this.width+h+t,s=this.height+i+e;return new d({width:w,height:s})}shrink_by({left:h,right:t,top:i,bottom:e}){const s=w(this.width-h-t,0),n=w(this.height-i-e,0);return new d({width:s,height:n})}map(h,t){return new d({width:h(this.width),height:(null!=t?t:h)(this.height)})}}i.Sizeable=d,d.__name__="Sizeable"},
function _(i,t,h){Object.defineProperty(h,"__esModule",{value:!0});const e=i(189),s=i(88),{min:n,max:g,round:a}=Math;class r{constructor(){this._bbox=new s.BBox,this._inner_bbox=new s.BBox;const i=this;this._top={get value(){return i.bbox.top}},this._left={get value(){return i.bbox.left}},this._width={get value(){return i.bbox.width}},this._height={get value(){return i.bbox.height}},this._right={get value(){return i.bbox.right}},this._bottom={get value(){return i.bbox.bottom}},this._hcenter={get value(){return i.bbox.hcenter}},this._vcenter={get value(){return i.bbox.vcenter}}}get bbox(){return this._bbox}get inner_bbox(){return this._inner_bbox}get sizing(){return this._sizing}set_sizing(i){const t=i.width_policy||"fit",h=i.width,e=null!=i.min_width?i.min_width:0,s=null!=i.max_width?i.max_width:1/0,n=i.height_policy||"fit",g=i.height,a=null!=i.min_height?i.min_height:0,r=null!=i.max_height?i.max_height:1/0,l=i.aspect,_=i.margin||{top:0,right:0,bottom:0,left:0},d=!1!==i.visible,o=i.halign||"start",u=i.valign||"start";this._sizing={width_policy:t,min_width:e,width:h,max_width:s,height_policy:n,min_height:a,height:g,max_height:r,aspect:l,margin:_,visible:d,halign:o,valign:u,size:{width:h,height:g},min_size:{width:e,height:a},max_size:{width:s,height:r}},this._init()}_init(){}_set_geometry(i,t){this._bbox=i,this._inner_bbox=t}set_geometry(i,t){this._set_geometry(i,t||i)}is_width_expanding(){return"max"==this.sizing.width_policy}is_height_expanding(){return"max"==this.sizing.height_policy}apply_aspect(i,{width:t,height:h}){const{aspect:e}=this.sizing;if(null!=e){const{width_policy:s,height_policy:n}=this.sizing,g=(i,t)=>{const h={max:4,fit:3,min:2,fixed:1};return h[i]>h[t]};if("fixed"!=s&&"fixed"!=n)if(s==n){const s=t,n=a(t/e),g=a(h*e),r=h;Math.abs(i.width-s)+Math.abs(i.height-n)<=Math.abs(i.width-g)+Math.abs(i.height-r)?(t=s,h=n):(t=g,h=r)}else g(s,n)?h=a(t/e):t=a(h*e);else"fixed"==s?h=a(t/e):"fixed"==n&&(t=a(h*e))}return{width:t,height:h}}measure(i){if(!this.sizing.visible)return{width:0,height:0};const t=i=>"fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:i,h=i=>"fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:i,s=new e.Sizeable(i).shrink_by(this.sizing.margin).map(t,h),n=this._measure(s),g=this.clip_size(n),a=t(g.width),r=h(g.height),l=this.apply_aspect(s,{width:a,height:r});return Object.assign(Object.assign({},n),l)}compute(i={}){const t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),{width:h,height:e}=t,n=new s.BBox({left:0,top:0,width:h,height:e});let g=void 0;if(null!=t.inner){const{left:i,top:n,right:a,bottom:r}=t.inner;g=new s.BBox({left:i,top:n,right:h-a,bottom:e-r})}this.set_geometry(n,g)}get xview(){return this.bbox.xview}get yview(){return this.bbox.yview}clip_width(i){return g(this.sizing.min_width,n(i,this.sizing.max_width))}clip_height(i){return g(this.sizing.min_height,n(i,this.sizing.max_height))}clip_size({width:i,height:t}){return{width:this.clip_width(i),height:this.clip_height(t)}}}h.Layoutable=r,r.__name__="Layoutable";class l extends r{_measure(i){const{width_policy:t,height_policy:h}=this.sizing;let e,s;if(i.width==1/0)e=null!=this.sizing.width?this.sizing.width:0;else switch(t){case"fixed":e=null!=this.sizing.width?this.sizing.width:0;break;case"min":e=null!=this.sizing.width?n(i.width,this.sizing.width):0;break;case"fit":e=null!=this.sizing.width?n(i.width,this.sizing.width):i.width;break;case"max":e=null!=this.sizing.width?g(i.width,this.sizing.width):i.width}if(i.height==1/0)s=null!=this.sizing.height?this.sizing.height:0;else switch(h){case"fixed":s=null!=this.sizing.height?this.sizing.height:0;break;case"min":s=null!=this.sizing.height?n(i.height,this.sizing.height):0;break;case"fit":s=null!=this.sizing.height?n(i.height,this.sizing.height):i.height;break;case"max":s=null!=this.sizing.height?g(i.height,this.sizing.height):i.height}return{width:e,height:s}}}h.LayoutItem=l,l.__name__="LayoutItem";class _ extends r{_measure(i){const t=this._content_size(),h=i.bounded_to(this.sizing.size).bounded_to(t);return{width:(()=>{switch(this.sizing.width_policy){case"fixed":return null!=this.sizing.width?this.sizing.width:t.width;case"min":return t.width;case"fit":return h.width;case"max":return Math.max(t.width,h.width)}})(),height:(()=>{switch(this.sizing.height_policy){case"fixed":return null!=this.sizing.height?this.sizing.height:t.height;case"min":return t.height;case"fit":return h.height;case"max":return Math.max(t.height,h.height)}})()}}}h.ContentLayoutable=_,_.__name__="ContentLayoutable"},
function _(t,e,h){Object.defineProperty(h,"__esModule",{value:!0});const o=t(190),r=t(88);class i extends o.Layoutable{constructor(){super(...arguments),this.children=[]}}h.Stack=i,i.__name__="Stack";class s extends i{_measure(t){let e=0,h=0;for(const t of this.children){const o=t.measure({width:0,height:0});e+=o.width,h=Math.max(h,o.height)}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const{top:h,bottom:o}=t;let{left:i}=t;for(const t of this.children){const{width:e}=t.measure({width:0,height:0});t.set_geometry(new r.BBox({left:i,width:e,top:h,bottom:o})),i+=e}}}h.HStack=s,s.__name__="HStack";class n extends i{_measure(t){let e=0,h=0;for(const t of this.children){const o=t.measure({width:0,height:0});e=Math.max(e,o.width),h+=o.height}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const{left:h,right:o}=t;let{top:i}=t;for(const t of this.children){const{height:e}=t.measure({width:0,height:0});t.set_geometry(new r.BBox({top:i,height:e,left:h,right:o})),i+=e}}}h.VStack=n,n.__name__="VStack";class c extends o.Layoutable{constructor(){super(...arguments),this.children=[]}_measure(t){let e=0,h=0;for(const{layout:o}of this.children){const r=o.measure(t);e=Math.max(e,r.width),h=Math.max(h,r.height)}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);for(const{layout:e,anchor:h,margin:o}of this.children){const{left:i,right:s,top:n,bottom:c,hcenter:a,vcenter:_}=t,{width:g,height:d}=e.measure(t);let m;switch(h){case"top_left":m=new r.BBox({left:i+o,top:n+o,width:g,height:d});break;case"top_center":m=new r.BBox({hcenter:a,top:n+o,width:g,height:d});break;case"top_right":m=new r.BBox({right:s-o,top:n+o,width:g,height:d});break;case"bottom_right":m=new r.BBox({right:s-o,bottom:c-o,width:g,height:d});break;case"bottom_center":m=new r.BBox({hcenter:a,bottom:c-o,width:g,height:d});break;case"bottom_left":m=new r.BBox({left:i+o,bottom:c-o,width:g,height:d});break;case"center_left":m=new r.BBox({left:i+o,vcenter:_,width:g,height:d});break;case"center":m=new r.BBox({hcenter:a,vcenter:_,width:g,height:d});break;case"center_right":m=new r.BBox({right:s-o,vcenter:_,width:g,height:d})}e.set_geometry(m)}}}h.AnchorLayout=c,c.__name__="AnchorLayout"},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});const e=t(189),o=t(190),n=t(8),r=t(88),h=t(9),{max:l,round:c}=Math;class a{constructor(t){this.def=t,this._map=new Map}get(t){let i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i}apply(t,i){const s=this.get(t);this._map.set(t,i(s))}}a.__name__="DefaultMap";class g{constructor(){this._items=[],this._nrows=0,this._ncols=0}get nrows(){return this._nrows}get ncols(){return this._ncols}add(t,i){const{r1:s,c1:e}=t;this._nrows=l(this._nrows,s+1),this._ncols=l(this._ncols,e+1),this._items.push({span:t,data:i})}at(t,i){return this._items.filter(({span:s})=>s.r0<=t&&t<=s.r1&&s.c0<=i&&i<=s.c1).map(({data:t})=>t)}row(t){return this._items.filter(({span:i})=>i.r0<=t&&t<=i.r1).map(({data:t})=>t)}col(t){return this._items.filter(({span:i})=>i.c0<=t&&t<=i.c1).map(({data:t})=>t)}foreach(t){for(const{span:i,data:s}of this._items)t(i,s)}map(t){const i=new g;for(const{span:s,data:e}of this._items)i.add(s,t(s,e));return i}}g.__name__="Container";class p extends o.Layoutable{constructor(t=[]){super(),this.items=t,this.rows="auto",this.cols="auto",this.spacing=0,this.absolute=!1}is_width_expanding(){if(super.is_width_expanding())return!0;if("fixed"==this.sizing.width_policy)return!1;const{cols:t}=this._state;return h.some(t,t=>"max"==t.policy)}is_height_expanding(){if(super.is_height_expanding())return!0;if("fixed"==this.sizing.height_policy)return!1;const{rows:t}=this._state;return h.some(t,t=>"max"==t.policy)}_init(){super._init();const t=new g;for(const{layout:i,row:s,col:e,row_span:o,col_span:n}of this.items)if(i.sizing.visible){const r=s,h=e,l=s+(null!=o?o:1)-1,c=e+(null!=n?n:1)-1;t.add({r0:r,c0:h,r1:l,c1:c},i)}const{nrows:i,ncols:s}=t,e=new Array(i);for(let s=0;s<i;s++){const i=(()=>{const t=n.isPlainObject(this.rows)?this.rows[s]||this.rows["*"]:this.rows;return null==t?{policy:"auto"}:n.isNumber(t)?{policy:"fixed",height:t}:n.isString(t)?{policy:t}:t})(),o=i.align||"auto";if("fixed"==i.policy)e[s]={policy:"fixed",height:i.height,align:o};else if("min"==i.policy)e[s]={policy:"min",align:o};else if("fit"==i.policy||"max"==i.policy)e[s]={policy:i.policy,flex:i.flex||1,align:o};else{if("auto"!=i.policy)throw new Error("unrechable");h.some(t.row(s),t=>t.is_height_expanding())?e[s]={policy:"max",flex:1,align:o}:e[s]={policy:"min",align:o}}}const o=new Array(s);for(let i=0;i<s;i++){const s=(()=>{const t=n.isPlainObject(this.cols)?this.cols[i]||this.cols["*"]:this.cols;return null==t?{policy:"auto"}:n.isNumber(t)?{policy:"fixed",width:t}:n.isString(t)?{policy:t}:t})(),e=s.align||"auto";if("fixed"==s.policy)o[i]={policy:"fixed",width:s.width,align:e};else if("min"==s.policy)o[i]={policy:"min",align:e};else if("fit"==s.policy||"max"==s.policy)o[i]={policy:s.policy,flex:s.flex||1,align:e};else{if("auto"!=s.policy)throw new Error("unrechable");h.some(t.col(i),t=>t.is_width_expanding())?o[i]={policy:"max",flex:1,align:e}:o[i]={policy:"min",align:e}}}const[r,l]=n.isNumber(this.spacing)?[this.spacing,this.spacing]:this.spacing;this._state={items:t,nrows:i,ncols:s,rows:e,cols:o,rspacing:r,cspacing:l}}_measure_totals(t,i){const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state;return{height:h.sum(t)+(s-1)*o,width:h.sum(i)+(e-1)*n}}_measure_cells(t){const{items:i,nrows:s,ncols:o,rows:n,cols:r,rspacing:h,cspacing:a}=this._state,p=new Array(s);for(let t=0;t<s;t++){const i=n[t];p[t]="fixed"==i.policy?i.height:0}const _=new Array(o);for(let t=0;t<o;t++){const i=r[t];_[t]="fixed"==i.policy?i.width:0}const f=new g;return i.foreach((i,s)=>{const{r0:o,c0:g,r1:d,c1:w}=i,u=(d-o)*h,m=(w-g)*a;let y=0;for(let i=o;i<=d;i++)y+=t(i,g).height;y+=u;let x=0;for(let i=g;i<=w;i++)x+=t(o,i).width;x+=m;const b=s.measure({width:x,height:y});f.add(i,{layout:s,size_hint:b});const z=new e.Sizeable(b).grow_by(s.sizing.margin);z.height-=u,z.width-=m;const j=[];for(let t=o;t<=d;t++){const i=n[t];"fixed"==i.policy?z.height-=i.height:j.push(t)}if(z.height>0){const t=c(z.height/j.length);for(const i of j)p[i]=l(p[i],t)}const O=[];for(let t=g;t<=w;t++){const i=r[t];"fixed"==i.policy?z.width-=i.width:O.push(t)}if(z.width>0){const t=c(z.width/O.length);for(const i of O)_[i]=l(_[i],t)}}),{size:this._measure_totals(p,_),row_heights:p,col_widths:_,size_hints:f}}_measure_grid(t){const{nrows:i,ncols:s,rows:e,cols:o,rspacing:n,cspacing:r}=this._state,h=this._measure_cells((t,i)=>{const s=e[t],n=o[i];return{width:"fixed"==n.policy?n.width:1/0,height:"fixed"==s.policy?s.height:1/0}});let a;a="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:h.size.height;let g,p=0;for(let t=0;t<i;t++){const i=e[t];"fit"==i.policy||"max"==i.policy?p+=i.flex:a-=h.row_heights[t]}if(a-=(i-1)*n,0!=p&&a>0)for(let t=0;t<i;t++){const i=e[t];if("fit"==i.policy||"max"==i.policy){const s=c(a*(i.flex/p));a-=s,h.row_heights[t]=s,p-=i.flex}}else if(a<0){let t=0;for(let s=0;s<i;s++){"fixed"!=e[s].policy&&t++}let s=-a;for(let o=0;o<i;o++){if("fixed"!=e[o].policy){const i=h.row_heights[o],e=c(s/t);h.row_heights[o]=l(i-e,0),s-=e>i?i:e,t--}}}g="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:h.size.width;let _=0;for(let t=0;t<s;t++){const i=o[t];"fit"==i.policy||"max"==i.policy?_+=i.flex:g-=h.col_widths[t]}if(g-=(s-1)*r,0!=_&&g>0)for(let t=0;t<s;t++){const i=o[t];if("fit"==i.policy||"max"==i.policy){const s=c(g*(i.flex/_));g-=s,h.col_widths[t]=s,_-=i.flex}}else if(g<0){let t=0;for(let i=0;i<s;i++){"fixed"!=o[i].policy&&t++}let i=-g;for(let e=0;e<s;e++){if("fixed"!=o[e].policy){const s=h.col_widths[e],o=c(i/t);h.col_widths[e]=l(s-o,0),i-=o>s?s:o,t--}}}const{row_heights:f,col_widths:d,size_hints:w}=this._measure_cells((t,i)=>({width:h.col_widths[i],height:h.row_heights[t]}));return{size:this._measure_totals(f,d),row_heights:f,col_widths:d,size_hints:w}}_measure(t){const{size:i}=this._measure_grid(t);return i}_set_geometry(t,i){super._set_geometry(t,i);const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state,{row_heights:h,col_widths:g,size_hints:p}=this._measure_grid(t),_=this._state.rows.map((t,i)=>Object.assign(Object.assign({},t),{top:0,height:h[i],get bottom(){return this.top+this.height}})),f=this._state.cols.map((t,i)=>Object.assign(Object.assign({},t),{left:0,width:g[i],get right(){return this.left+this.width}})),d=p.map((t,i)=>Object.assign(Object.assign({},i),{outer:new r.BBox,inner:new r.BBox}));for(let i=0,e=this.absolute?t.top:0;i<s;i++){const t=_[i];t.top=e,e+=t.height+o}for(let i=0,s=this.absolute?t.left:0;i<e;i++){const t=f[i];t.left=s,s+=t.width+n}d.foreach(({r0:t,c0:i,r1:s,c1:e},h)=>{const{layout:l,size_hint:a}=h,{sizing:g}=l,{width:p,height:d}=a,w=function(t,i){let s=(i-t)*n;for(let e=t;e<=i;e++)s+=f[e].width;return s}(i,e),u=function(t,i){let s=(i-t)*o;for(let e=t;e<=i;e++)s+=_[e].height;return s}(t,s),m=i==e&&"auto"!=f[i].align?f[i].align:g.halign,y=t==s&&"auto"!=_[t].align?_[t].align:g.valign;let x=f[i].left;"start"==m?x+=g.margin.left:"center"==m?x+=c((w-p)/2):"end"==m&&(x+=w-g.margin.right-p);let b=_[t].top;"start"==y?b+=g.margin.top:"center"==y?b+=c((u-d)/2):"end"==y&&(b+=u-g.margin.bottom-d),h.outer=new r.BBox({left:x,top:b,width:p,height:d})});const w=_.map(()=>({start:new a(()=>0),end:new a(()=>0)})),u=f.map(()=>({start:new a(()=>0),end:new a(()=>0)}));d.foreach(({r0:t,c0:i,r1:s,c1:e},{size_hint:o,outer:n})=>{const{inner:r}=o;null!=r&&(w[t].start.apply(n.top,t=>l(t,r.top)),w[s].end.apply(_[s].bottom-n.bottom,t=>l(t,r.bottom)),u[i].start.apply(n.left,t=>l(t,r.left)),u[e].end.apply(f[e].right-n.right,t=>l(t,r.right)))}),d.foreach(({r0:t,c0:i,r1:s,c1:e},o)=>{const{size_hint:n,outer:h}=o;function l({left:t,right:i,top:s,bottom:e}){const o=h.width-t-i,n=h.height-s-e;return new r.BBox({left:t,top:s,width:o,height:n})}if(null!=n.inner){let r=l(n.inner);if(!1!==n.align){const o=w[t].start.get(h.top),n=w[s].end.get(_[s].bottom-h.bottom),c=u[i].start.get(h.left),a=u[e].end.get(f[e].right-h.right);try{r=l({top:o,bottom:n,left:c,right:a})}catch(t){}}o.inner=r}else o.inner=h}),d.foreach((t,{layout:i,outer:s,inner:e})=>{i.set_geometry(s,e)})}}s.Grid=p,p.__name__="Grid";class _ extends p{constructor(t){super(),this.items=t.map((t,i)=>({layout:t,row:0,col:i})),this.rows="fit"}}s.Row=_,_.__name__="Row";class f extends p{constructor(t){super(),this.items=t.map((t,i)=>({layout:t,row:i,col:0})),this.cols="fit"}}s.Column=f,f.__name__="Column"},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(190),i=e(189),a=e(68);class c extends n.ContentLayoutable{constructor(e){super(),this.content_size=a.unsized(e,()=>new i.Sizeable(a.size(e)))}_content_size(){return this.content_size}}s.ContentBox=c,c.__name__="ContentBox";class o extends n.Layoutable{constructor(e){super(),this.el=e}_measure(e){const t=new i.Sizeable(e).bounded_to(this.sizing.size);return a.sized(this.el,t,()=>{const e=new i.Sizeable(a.content_size(this.el)),{border:t,padding:s}=a.extents(this.el);return e.grow_by(t).grow_by(s).map(Math.ceil)})}}s.VariadicBox=o,o.__name__="VariadicBox";class r extends o{constructor(e){super(e),this._cache=new Map}_measure(e){const{width:t,height:s}=e,n=`${t},${s}`;let i=this._cache.get(n);return null==i&&(i=super._measure(e),this._cache.set(n,i)),i}invalidate_cache(){this._cache.clear()}}s.CachedVariadicBox=r,r.__name__="CachedVariadicBox"},
function _(e,r,u){Object.defineProperty(u,"__esModule",{value:!0});var a=e(195);u.Expression=a.Expression;var n=e(196);u.Stack=n.Stack;var o=e(197);u.CumSum=o.CumSum},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(71);class i extends n.Model{constructor(e){super(e)}initialize(){super.initialize(),this._connected=new Set,this._result=new Map}v_compute(e){this._connected.has(e)||(this.connect(e.change,()=>this._result.delete(e)),this.connect(e.patching,()=>this._result.delete(e)),this.connect(e.streaming,()=>this._result.delete(e)),this._connected.add(e));let t=this._result.get(e);return null==t&&(t=this._v_compute(e),this._result.set(e,t)),t}}s.Expression=i,i.__name__="Expression"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const i=t(1),o=t(195),r=i.__importStar(t(18));class s extends o.Expression{constructor(t){super(t)}static init_Stack(){this.define({fields:[r.Array,[]]})}_v_compute(t){var e;const n=null!==(e=t.get_length())&&void 0!==e?e:0,i=new Float64Array(n);for(const e of this.fields){const o=t.data[e];if(null!=o)for(let t=0,e=Math.min(n,o.length);t<e;t++)i[t]+=o[t]}return i}}n.Stack=s,s.__name__="Stack",s.init_Stack()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const i=e(1),u=e(195),o=i.__importStar(e(18));class r extends u.Expression{constructor(e){super(e)}static init_CumSum(){this.define({field:[o.String],include_zero:[o.Boolean,!1]})}_v_compute(e){const t=new Float64Array(e.get_length()||0),n=e.data[this.field],i=this.include_zero?1:0;t[0]=this.include_zero?0:n[0];for(let e=1;e<t.length;e++)t[e]=t[e-1]+n[e-i];return t}}n.CumSum=r,r.__name__="CumSum",r.init_CumSum()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var l=e(199);t.BooleanFilter=l.BooleanFilter;var i=e(201);t.CustomJSFilter=i.CustomJSFilter;var o=e(200);t.Filter=o.Filter;var F=e(202);t.GroupFilter=F.GroupFilter;var a=e(203);t.IndexFilter=a.IndexFilter},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(1),l=e(200),i=o.__importStar(e(18)),r=e(72),a=e(9),s=e(8);class g extends l.Filter{constructor(e){super(e)}static init_BooleanFilter(){this.define({booleans:[i.Array,null]})}compute_indices(e){const n=this.booleans;return null!=n&&n.length>0?a.every(n,s.isBoolean)?(n.length!==e.get_length()&&r.logger.warn(this+": length of booleans doesn't match data source"),a.range(0,n.length).filter(e=>!0===n[e])):(r.logger.warn(this+": booleans should be array of booleans, defaulting to no filtering"),null):(null!=n&&0==n.length?r.logger.warn(this+": booleans is empty, defaulting to no filtering"):r.logger.warn(this+": booleans was not set, defaulting to no filtering"),null)}}t.BooleanFilter=g,g.__name__="BooleanFilter",g.init_BooleanFilter()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const i=e(1),n=e(71),l=i.__importStar(e(18)),o=e(8),s=e(9),a=e(72);class f extends n.Model{constructor(e){super(e)}static init_Filter(){this.define({filter:[l.Array,null]})}compute_indices(e){const t=this.filter;return null!=t?o.isArrayOf(t,o.isBoolean)?s.range(0,t.length).filter(e=>!0===t[e]):o.isArrayOf(t,o.isInteger)?t:(a.logger.warn(this+": filter should either be array of only booleans or only integers, defaulting to no filtering"),null):(a.logger.warn(this+": filter was not set to be an array, defaulting to no filtering"),null)}}r.Filter=f,f.__name__="Filter",f.init_Filter()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),r=t(200),n=i.__importStar(t(18)),u=t(17),c=t(24);class o extends r.Filter{constructor(t){super(t)}static init_CustomJSFilter(){this.define({args:[n.Any,{}],code:[n.String,""]})}get names(){return u.keys(this.args)}get values(){return u.values(this.args)}get func(){const t=c.use_strict(this.code);return new Function(...this.names,"source",t)}compute_indices(t){return this.filter=this.func(...this.values,t),super.compute_indices(t)}}s.CustomJSFilter=o,o.__name__="CustomJSFilter",o.init_CustomJSFilter()},
function _(t,n,i){Object.defineProperty(i,"__esModule",{value:!0});const e=t(1),r=t(200),o=e.__importStar(t(18)),u=t(72),l=t(9);class s extends r.Filter{constructor(t){super(t),this.indices=null}static init_GroupFilter(){this.define({column_name:[o.String],group:[o.String]})}compute_indices(t){const n=t.get_column(this.column_name);return null==n?(u.logger.warn("group filter: groupby column not found in data source"),null):(this.indices=l.range(0,t.get_length()||0).filter(t=>n[t]===this.group),0===this.indices.length&&u.logger.warn(`group filter: group '${this.group}' did not match any values in column '${this.column_name}'`),this.indices)}}i.GroupFilter=s,s.__name__="GroupFilter",s.init_GroupFilter()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(1),r=e(200),s=t.__importStar(e(18)),l=e(72),d=e(8),o=e(9);class c extends r.Filter{constructor(e){super(e)}static init_IndexFilter(){this.define({indices:[s.Array,null]})}compute_indices(e){return null!=this.indices?o.every(this.indices,d.isInteger)?this.indices:(l.logger.warn(this+": indices should be array of integers, defaulting to no filtering"),null):(l.logger.warn(this+": indices was not set, defaulting to no filtering"),null)}}n.IndexFilter=c,c.__name__="IndexFilter",c.init_IndexFilter()},
function _(r,t,a){Object.defineProperty(a,"__esModule",{value:!0});var e=r(113);a.BasicTickFormatter=e.BasicTickFormatter;var c=r(154);a.CategoricalTickFormatter=c.CategoricalTickFormatter;var i=r(158);a.DatetimeTickFormatter=i.DatetimeTickFormatter;var o=r(205);a.FuncTickFormatter=o.FuncTickFormatter;var m=r(171);a.LogTickFormatter=m.LogTickFormatter;var F=r(174);a.MercatorTickFormatter=F.MercatorTickFormatter;var k=r(206);a.NumeralTickFormatter=k.NumeralTickFormatter;var T=r(207);a.PrintfTickFormatter=T.PrintfTickFormatter;var v=r(114);a.TickFormatter=v.TickFormatter},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const r=t(1),s=t(114),i=r.__importStar(t(18)),c=t(17),a=t(24);class u extends s.TickFormatter{constructor(t){super(t)}static init_FuncTickFormatter(){this.define({args:[i.Any,{}],code:[i.String,""]})}get names(){return c.keys(this.args)}get values(){return c.values(this.args)}_make_func(){const t=a.use_strict(this.code);return new Function("tick","index","ticks",...this.names,t)}doFormat(t,e){const n=this._make_func().bind({});return t.map((t,e,r)=>n(t,e,r,...this.values))}}n.FuncTickFormatter=u,u.__name__="FuncTickFormatter",u.init_FuncTickFormatter()},
function _(r,t,n){Object.defineProperty(n,"__esModule",{value:!0});const e=r(1),o=e.__importStar(r(161)),a=r(114),i=e.__importStar(r(18));class u extends a.TickFormatter{constructor(r){super(r)}static init_NumeralTickFormatter(){this.define({format:[i.String,"0,0"],language:[i.String,"en"],rounding:[i.RoundingFunction,"round"]})}get _rounding_fn(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}doFormat(r,t){const{format:n,language:e,_rounding_fn:a}=this;return r.map(r=>o.format(r,n,e,a))}}n.NumeralTickFormatter=u,u.__name__="NumeralTickFormatter",u.init_NumeralTickFormatter()},
function _(t,r,i){Object.defineProperty(i,"__esModule",{value:!0});const e=t(1),n=t(114),o=t(160),a=e.__importStar(t(18));class c extends n.TickFormatter{constructor(t){super(t)}static init_PrintfTickFormatter(){this.define({format:[a.String,"%s"]})}doFormat(t,r){return t.map(t=>o.sprintf(this.format,t))}}i.PrintfTickFormatter=c,c.__name__="PrintfTickFormatter",c.init_PrintfTickFormatter()},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var v=a(209);r.AnnularWedge=v.AnnularWedge;var l=a(210);r.Annulus=l.Annulus;var t=a(211);r.Arc=t.Arc;var i=a(212);r.Bezier=i.Bezier;var n=a(213);r.Circle=n.Circle;var u=a(214);r.CenterRotatable=u.CenterRotatable;var c=a(215);r.Ellipse=c.Ellipse;var g=a(216);r.EllipseOval=g.EllipseOval;var A=a(89);r.Glyph=A.Glyph;var p=a(95);r.HArea=p.HArea;var s=a(217);r.HBar=s.HBar;var d=a(219);r.HexTile=d.HexTile;var R=a(220);r.Image=R.Image;var o=a(222);r.ImageRGBA=o.ImageRGBA;var y=a(223);r.ImageURL=y.ImageURL;var h=a(83);r.Line=h.Line;var m=a(225);r.MultiLine=m.MultiLine;var B=a(226);r.MultiPolygons=B.MultiPolygons;var P=a(227);r.Oval=P.Oval;var G=a(94);r.Patch=G.Patch;var H=a(228);r.Patches=H.Patches;var I=a(229);r.Quad=I.Quad;var L=a(230);r.Quadratic=L.Quadratic;var M=a(231);r.Ray=M.Ray;var O=a(232);r.Rect=O.Rect;var x=a(233);r.Segment=x.Segment;var C=a(234);r.Step=C.Step;var E=a(235);r.Text=E.Text;var Q=a(97);r.VArea=Q.VArea;var S=a(236);r.VBar=S.VBar;var T=a(237);r.Wedge=T.Wedge;var V=a(84);r.XYGlyph=V.XYGlyph},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(84),n=e(92),a=e(23),_=i.__importStar(e(18)),o=e(10),h=e(79);class u extends r.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius,this._angle=new Float32Array(this._start_angle.length);for(let e=0,t=this._start_angle.length;e<t;e++)this._angle[e]=this._end_angle[e]-this._start_angle[e]}_render(e,t,{sx:s,sy:i,_start_angle:r,_angle:n,sinner_radius:a,souter_radius:_}){const o=this.model.properties.direction.value();for(const h of t)isNaN(s[h]+i[h]+a[h]+_[h]+r[h]+n[h])||(e.translate(s[h],i[h]),e.rotate(r[h]),e.moveTo(_[h],0),e.beginPath(),e.arc(0,0,_[h],0,n[h],o),e.rotate(n[h]),e.lineTo(a[h],0),e.arc(0,0,a[h],0,-n[h],!o),e.closePath(),e.rotate(-n[h]-r[h]),e.translate(-s[h],-i[h]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,h),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,h),e.stroke()))}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s);let n,a,_,u;if("data"==this.model.properties.outer_radius.units)n=i-this.max_outer_radius,_=i+this.max_outer_radius,a=r-this.max_outer_radius,u=r+this.max_outer_radius;else{const e=t-this.max_outer_radius,i=t+this.max_outer_radius;[n,_]=this.renderer.xscale.r_invert(e,i);const r=s-this.max_outer_radius,o=s+this.max_outer_radius;[a,u]=this.renderer.yscale.r_invert(r,o)}const d=[];for(const e of this.index.indices({x0:n,x1:_,y0:a,y1:u})){const t=this.souter_radius[e]**2,s=this.sinner_radius[e]**2,[n,a]=this.renderer.xscale.r_compute(i,this._x[e]),[_,o]=this.renderer.yscale.r_compute(r,this._y[e]),h=(n-a)**2+(_-o)**2;h<=t&&h>=s&&d.push([e,h])}const l=this.model.properties.direction.value(),c=[];for(const[e,i]of d){const r=Math.atan2(s-this.sy[e],t-this.sx[e]);o.angle_between(-r,-this._start_angle[e],-this._end_angle[e],l)&&c.push([e,i])}return h.Selection.from_hits(c)}draw_legend_for_index(e,t,s){n.generic_area_legend(this.visuals,e,t,s)}_scenterxy(e){const t=(this.sinner_radius[e]+this.souter_radius[e])/2,s=(this._start_angle[e]+this._end_angle[e])/2;return{x:this.sx[e]+t*Math.cos(s),y:this.sy[e]+t*Math.sin(s)}}scenterx(e){return this._scenterxy(e).x}scentery(e){return this._scenterxy(e).y}}s.AnnularWedgeView=u,u.__name__="AnnularWedgeView";class d extends r.XYGlyph{constructor(e){super(e)}static init_AnnularWedge(){this.prototype.default_view=u,this.mixins([a.LineVector,a.FillVector]),this.define({direction:[_.Direction,"anticlock"],inner_radius:[_.DistanceSpec],outer_radius:[_.DistanceSpec],start_angle:[_.AngleSpec],end_angle:[_.AngleSpec]})}}s.AnnularWedge=d,d.__name__="AnnularWedge",d.init_AnnularWedge()},
function _(s,i,e){Object.defineProperty(e,"__esModule",{value:!0});const t=s(1),r=s(84),a=s(23),n=t.__importStar(s(18)),_=s(28),u=s(79);class o extends r.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius}_render(s,i,{sx:e,sy:t,sinner_radius:r,souter_radius:a}){for(const n of i)if(!isNaN(e[n]+t[n]+r[n]+a[n])){if(this.visuals.fill.doit){if(this.visuals.fill.set_vectorize(s,n),s.beginPath(),_.is_ie)for(const i of[!1,!0])s.arc(e[n],t[n],r[n],0,Math.PI,i),s.arc(e[n],t[n],a[n],Math.PI,0,!i);else s.arc(e[n],t[n],r[n],0,2*Math.PI,!0),s.arc(e[n],t[n],a[n],2*Math.PI,0,!1);s.fill()}this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,n),s.beginPath(),s.arc(e[n],t[n],r[n],0,2*Math.PI),s.moveTo(e[n]+a[n],t[n]),s.arc(e[n],t[n],a[n],0,2*Math.PI),s.stroke())}}_hit_point(s){const{sx:i,sy:e}=s,t=this.renderer.xscale.invert(i),r=this.renderer.yscale.invert(e);let a,n,_,o;if("data"==this.model.properties.outer_radius.units)a=t-this.max_outer_radius,_=t+this.max_outer_radius,n=r-this.max_outer_radius,o=r+this.max_outer_radius;else{const s=i-this.max_outer_radius,t=i+this.max_outer_radius;[a,_]=this.renderer.xscale.r_invert(s,t);const r=e-this.max_outer_radius,u=e+this.max_outer_radius;[n,o]=this.renderer.yscale.r_invert(r,u)}const h=[];for(const s of this.index.indices({x0:a,x1:_,y0:n,y1:o})){const i=this.souter_radius[s]**2,e=this.sinner_radius[s]**2,[a,n]=this.renderer.xscale.r_compute(t,this._x[s]),[_,u]=this.renderer.yscale.r_compute(r,this._y[s]),o=(a-n)**2+(_-u)**2;o<=i&&o>=e&&h.push([s,o])}return u.Selection.from_hits(h)}draw_legend_for_index(s,{x0:i,y0:e,x1:t,y1:r},a){const n=a+1,_=new Array(n);_[a]=(i+t)/2;const u=new Array(n);u[a]=(e+r)/2;const o=.5*Math.min(Math.abs(t-i),Math.abs(r-e)),h=new Array(n);h[a]=.4*o;const d=new Array(n);d[a]=.8*o,this._render(s,[a],{sx:_,sy:u,sinner_radius:h,souter_radius:d})}}e.AnnulusView=o,o.__name__="AnnulusView";class h extends r.XYGlyph{constructor(s){super(s)}static init_Annulus(){this.prototype.default_view=o,this.mixins([a.LineVector,a.FillVector]),this.define({inner_radius:[n.DistanceSpec],outer_radius:[n.DistanceSpec]})}}e.Annulus=h,h.__name__="Annulus",h.init_Annulus()},
function _(e,i,s){Object.defineProperty(s,"__esModule",{value:!0});const t=e(1),r=e(84),n=e(92),a=e(23),_=t.__importStar(e(18));class c extends r.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius}_render(e,i,{sx:s,sy:t,sradius:r,_start_angle:n,_end_angle:a}){if(this.visuals.line.doit){const _=this.model.properties.direction.value();for(const c of i)isNaN(s[c]+t[c]+r[c]+n[c]+a[c])||(e.beginPath(),e.arc(s[c],t[c],r[c],n[c],a[c],_),this.visuals.line.set_vectorize(e,c),e.stroke())}}draw_legend_for_index(e,i,s){n.generic_line_legend(this.visuals,e,i,s)}}s.ArcView=c,c.__name__="ArcView";class d extends r.XYGlyph{constructor(e){super(e)}static init_Arc(){this.prototype.default_view=c,this.mixins(a.LineVector),this.define({direction:[_.Direction,"anticlock"],radius:[_.DistanceSpec],start_angle:[_.AngleSpec],end_angle:[_.AngleSpec]})}}s.Arc=d,d.__name__="Arc",d.init_Arc()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(23),n=t(85),c=t(89),o=t(92);function r(t,e,i,s,n,c,o,r){const h=[],_=[[],[]];for(let _=0;_<=2;_++){let a,x,l;if(0===_?(x=6*t-12*i+6*n,a=-3*t+9*i-9*n+3*o,l=3*i-3*t):(x=6*e-12*s+6*c,a=-3*e+9*s-9*c+3*r,l=3*s-3*e),Math.abs(a)<1e-12){if(Math.abs(x)<1e-12)continue;const t=-l/x;0<t&&t<1&&h.push(t);continue}const y=x*x-4*l*a,u=Math.sqrt(y);if(y<0)continue;const d=(-x+u)/(2*a);0<d&&d<1&&h.push(d);const f=(-x-u)/(2*a);0<f&&f<1&&h.push(f)}let a=h.length;const x=a;for(;a--;){const x=h[a],l=1-x,y=l*l*l*t+3*l*l*x*i+3*l*x*x*n+x*x*x*o;_[0][a]=y;const u=l*l*l*e+3*l*l*x*s+3*l*x*x*c+x*x*x*r;_[1][a]=u}return _[0][x]=t,_[1][x]=e,_[0][x+1]=o,_[1][x+1]=r,[Math.min(..._[0]),Math.max(..._[1]),Math.max(..._[0]),Math.min(..._[1])]}class h extends c.GlyphView{_index_data(){const t=[];for(let e=0,i=this._x0.length;e<i;e++){if(isNaN(this._x0[e]+this._x1[e]+this._y0[e]+this._y1[e]+this._cx0[e]+this._cy0[e]+this._cx1[e]+this._cy1[e]))continue;const[i,s,n,c]=r(this._x0[e],this._y0[e],this._x1[e],this._y1[e],this._cx0[e],this._cy0[e],this._cx1[e],this._cy1[e]);t.push({x0:i,y0:s,x1:n,y1:c,i:e})}return new n.SpatialIndex(t)}_render(t,e,{sx0:i,sy0:s,sx1:n,sy1:c,scx0:o,scy0:r,scx1:h,scy1:_}){if(this.visuals.line.doit)for(const a of e)isNaN(i[a]+s[a]+n[a]+c[a]+o[a]+r[a]+h[a]+_[a])||(t.beginPath(),t.moveTo(i[a],s[a]),t.bezierCurveTo(o[a],r[a],h[a],_[a],n[a],c[a]),this.visuals.line.set_vectorize(t,a),t.stroke())}draw_legend_for_index(t,e,i){o.generic_line_legend(this.visuals,t,e,i)}scenterx(){throw new Error("not implemented")}scentery(){throw new Error("not implemented")}}i.BezierView=h,h.__name__="BezierView";class _ extends c.Glyph{constructor(t){super(t)}static init_Bezier(){this.prototype.default_view=h,this.coords([["x0","y0"],["x1","y1"],["cx0","cy0"],["cx1","cy1"]]),this.mixins(s.LineVector)}}i.Bezier=_,_.__name__="Bezier",_.init_Bezier()},
function _(s,i,e){Object.defineProperty(e,"__esModule",{value:!0});const t=s(1),r=s(84),a=s(23),n=t.__importStar(s(93)),h=t.__importStar(s(18)),d=s(9),_=s(12),l=s(79);class c extends r.XYGlyphView{_map_data(){if(null!=this._radius)if("data"==this.model.properties.radius.units)switch(this.model.radius_dimension){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this._radius);break;case"max":{const s=this.sdist(this.renderer.xscale,this._x,this._radius),i=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=_.map(s,(s,e)=>Math.max(s,i[e]));break}case"min":{const s=this.sdist(this.renderer.xscale,this._x,this._radius),i=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=_.map(s,(s,e)=>Math.min(s,i[e]));break}}else this.sradius=this._radius,this.max_size=2*this.max_radius;else this.sradius=_.map(this._size,s=>s/2)}_mask_data(){const[s,i]=this.renderer.plot_view.frame.bbox.ranges;let e,t,r,a;if(null!=this._radius&&"data"==this.model.properties.radius.units){const n=s.start,h=s.end;[e,r]=this.renderer.xscale.r_invert(n,h),e-=this.max_radius,r+=this.max_radius;const d=i.start,_=i.end;[t,a]=this.renderer.yscale.r_invert(d,_),t-=this.max_radius,a+=this.max_radius}else{const n=s.start-this.max_size,h=s.end+this.max_size;[e,r]=this.renderer.xscale.r_invert(n,h);const d=i.start-this.max_size,_=i.end+this.max_size;[t,a]=this.renderer.yscale.r_invert(d,_)}return this.index.indices({x0:e,x1:r,y0:t,y1:a})}_render(s,i,{sx:e,sy:t,sradius:r}){for(const a of i)isNaN(e[a]+t[a]+r[a])||(s.beginPath(),s.arc(e[a],t[a],r[a],0,2*Math.PI,!1),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(s,a),s.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,a),s.stroke()))}_hit_point(s){const{sx:i,sy:e}=s,t=this.renderer.xscale.invert(i),r=this.renderer.yscale.invert(e);let a,n,h,d;if(null!=this._radius&&"data"==this.model.properties.radius.units)a=t-this.max_radius,n=t+this.max_radius,h=r-this.max_radius,d=r+this.max_radius;else{const s=i-this.max_size,t=i+this.max_size;[a,n]=this.renderer.xscale.r_invert(s,t);const r=e-this.max_size,_=e+this.max_size;[h,d]=this.renderer.yscale.r_invert(r,_)}const _=this.index.indices({x0:a,x1:n,y0:h,y1:d}),c=[];if(null!=this._radius&&"data"==this.model.properties.radius.units)for(const s of _){const i=this.sradius[s]**2,[e,a]=this.renderer.xscale.r_compute(t,this._x[s]),[n,h]=this.renderer.yscale.r_compute(r,this._y[s]),d=(e-a)**2+(n-h)**2;d<=i&&c.push([s,d])}else for(const s of _){const t=this.sradius[s]**2,r=(this.sx[s]-i)**2+(this.sy[s]-e)**2;r<=t&&c.push([s,r])}return l.Selection.from_hits(c)}_hit_span(s){const{sx:i,sy:e}=s,t=this.bounds();let r,a,n,h;if("h"==s.direction){let s,e;if(n=t.y0,h=t.y1,null!=this._radius&&"data"==this.model.properties.radius.units)s=i-this.max_radius,e=i+this.max_radius,[r,a]=this.renderer.xscale.r_invert(s,e);else{const t=this.max_size/2;s=i-t,e=i+t,[r,a]=this.renderer.xscale.r_invert(s,e)}}else{let s,i;if(r=t.x0,a=t.x1,null!=this._radius&&"data"==this.model.properties.radius.units)s=e-this.max_radius,i=e+this.max_radius,[n,h]=this.renderer.yscale.r_invert(s,i);else{const t=this.max_size/2;s=e-t,i=e+t,[n,h]=this.renderer.yscale.r_invert(s,i)}}const d=this.index.indices({x0:r,x1:a,y0:n,y1:h});return new l.Selection({indices:d})}_hit_rect(s){const{sx0:i,sx1:e,sy0:t,sy1:r}=s,[a,n]=this.renderer.xscale.r_invert(i,e),[h,d]=this.renderer.yscale.r_invert(t,r),_=this.index.indices({x0:a,x1:n,y0:h,y1:d});return new l.Selection({indices:_})}_hit_poly(s){const{sx:i,sy:e}=s,t=d.range(0,this.sx.length),r=[];for(let s=0,a=t.length;s<a;s++){const a=t[s];n.point_in_poly(this.sx[s],this.sy[s],i,e)&&r.push(a)}return new l.Selection({indices:r})}draw_legend_for_index(s,{x0:i,y0:e,x1:t,y1:r},a){const n=a+1,h=new Array(n);h[a]=(i+t)/2;const d=new Array(n);d[a]=(e+r)/2;const _=new Array(n);_[a]=.2*Math.min(Math.abs(t-i),Math.abs(r-e)),this._render(s,[a],{sx:h,sy:d,sradius:_})}}e.CircleView=c,c.__name__="CircleView";class o extends r.XYGlyph{constructor(s){super(s)}static init_Circle(){this.prototype.default_view=c,this.mixins([a.LineVector,a.FillVector]),this.define({angle:[h.AngleSpec,0],size:[h.DistanceSpec,{units:"screen",value:4}],radius:[h.DistanceSpec,void 0,{optional:!0}],radius_dimension:[h.RadiusDimension,"x"]})}}e.Circle=o,o.__name__="Circle",o.init_Circle()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const a=e(1),i=e(84),l=e(23),s=a.__importStar(e(18));class c extends i.XYGlyphView{}n.CenterRotatableView=c,c.__name__="CenterRotatableView";class o extends i.XYGlyph{constructor(e){super(e)}static init_CenterRotatable(){this.mixins([l.LineVector,l.FillVector]),this.define({angle:[s.AngleSpec,0],width:[s.DistanceSpec],height:[s.DistanceSpec]})}}n.CenterRotatable=o,o.__name__="CenterRotatable",o.init_CenterRotatable()},
function _(e,l,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(216);class t extends s.EllipseOvalView{}i.EllipseView=t,t.__name__="EllipseView";class _ extends s.EllipseOval{constructor(e){super(e)}static init_Ellipse(){this.prototype.default_view=t}}i.Ellipse=_,_.__name__="Ellipse",_.init_Ellipse()},
function _(t,s,i){Object.defineProperty(i,"__esModule",{value:!0});const e=t(1),h=t(214),r=e.__importStar(t(93)),a=t(79);class _ extends h.CenterRotatableView{_set_data(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)}_map_data(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"):this.sw=this._width,"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height}_render(t,s,{sx:i,sy:e,sw:h,sh:r,_angle:a}){for(const _ of s)isNaN(i[_]+e[_]+h[_]+r[_]+a[_])||(t.beginPath(),t.ellipse(i[_],e[_],h[_]/2,r[_]/2,a[_],0,2*Math.PI),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,_),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,_),t.stroke()))}_hit_point(t){let s,i,e,h,_,n,l,d,o,x;const{sx:m,sy:c}=t,w=this.renderer.xscale.invert(m),p=this.renderer.yscale.invert(c);"data"==this.model.properties.width.units?(s=w-this.max_width,i=w+this.max_width):(l=m-this.max_width,d=m+this.max_width,[s,i]=this.renderer.xscale.r_invert(l,d)),"data"==this.model.properties.height.units?(e=p-this.max_height,h=p+this.max_height):(o=c-this.max_height,x=c+this.max_height,[e,h]=this.renderer.yscale.r_invert(o,x));const y=this.index.indices({x0:s,x1:i,y0:e,y1:h}),u=[];for(const t of y)_=r.point_in_ellipse(m,c,this._angle[t],this.sh[t]/2,this.sw[t]/2,this.sx[t],this.sy[t]),_&&([l,d]=this.renderer.xscale.r_compute(w,this._x[t]),[o,x]=this.renderer.yscale.r_compute(p,this._y[t]),n=(l-d)**2+(o-x)**2,u.push([t,n]));return a.Selection.from_hits(u)}draw_legend_for_index(t,{x0:s,y0:i,x1:e,y1:h},r){const a=r+1,_=new Array(a);_[r]=(s+e)/2;const n=new Array(a);n[r]=(i+h)/2;const l=this.sw[r]/this.sh[r],d=.8*Math.min(Math.abs(e-s),Math.abs(h-i)),o=new Array(a),x=new Array(a);l>1?(o[r]=d,x[r]=d/l):(o[r]=d*l,x[r]=d),this._render(t,[r],{sx:_,sy:n,sw:o,sh:x,_angle:[0]})}_bounds({x0:t,x1:s,y0:i,y1:e}){return{x0:t-this.max_w2,x1:s+this.max_w2,y0:i-this.max_h2,y1:e+this.max_h2}}}i.EllipseOvalView=_,_.__name__="EllipseOvalView";class n extends h.CenterRotatable{constructor(t){super(t)}}i.EllipseOval=n,n.__name__="EllipseOval"},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1),h=t(218),r=i.__importStar(t(18));class _ extends h.BoxView{scenterx(t){return(this.sleft[t]+this.sright[t])/2}scentery(t){return this.sy[t]}_index_data(){return this._index_box(this._y.length)}_lrtb(t){return[Math.min(this._left[t],this._right[t]),Math.max(this._left[t],this._right[t]),this._y[t]+.5*this._height[t],this._y[t]-.5*this._height[t]]}_map_data(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);const t=this.sy.length;this.stop=new Float64Array(t),this.sbottom=new Float64Array(t);for(let s=0;s<t;s++)this.stop[s]=this.sy[s]-this.sh[s]/2,this.sbottom[s]=this.sy[s]+this.sh[s]/2;this._clamp_viewport()}}e.HBarView=_,_.__name__="HBarView";class a extends h.Box{constructor(t){super(t)}static init_HBar(){this.prototype.default_view=_,this.coords([["left","y"]]),this.define({height:[r.NumberSpec],right:[r.CoordinateSpec]}),this.override({left:0})}}e.HBar=a,a.__name__="HBar",a.init_HBar()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(23),r=t(85),n=t(89),h=t(92),o=t(79);class a extends n.GlyphView{get_anchor_point(t,e,i){const s=Math.min(this.sleft[e],this.sright[e]),r=Math.max(this.sright[e],this.sleft[e]),n=Math.min(this.stop[e],this.sbottom[e]),h=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:s,y:n};case"top_center":return{x:(s+r)/2,y:n};case"top_right":return{x:r,y:n};case"bottom_left":return{x:s,y:h};case"bottom_center":return{x:(s+r)/2,y:h};case"bottom_right":return{x:r,y:h};case"center_left":return{x:s,y:(n+h)/2};case"center":return{x:(s+r)/2,y:(n+h)/2};case"center_right":return{x:r,y:(n+h)/2};default:return null}}_index_box(t){const e=[];for(let i=0;i<t;i++){const[t,s,r,n]=this._lrtb(i);!isNaN(t+s+r+n)&&isFinite(t+s+r+n)&&e.push({x0:Math.min(t,s),y0:Math.min(r,n),x1:Math.max(s,t),y1:Math.max(r,n),i})}return new r.SpatialIndex(e)}_render(t,e,{sleft:i,sright:s,stop:r,sbottom:n}){for(const h of e)isNaN(i[h]+r[h]+s[h]+n[h])||(t.rect(i[h],r[h],s[h]-i[h],n[h]-r[h]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,h),t.beginPath(),t.rect(i[h],r[h],s[h]-i[h],n[h]-r[h]),t.fill()),this.visuals.hatch.doit2(t,h,()=>{t.beginPath(),t.rect(i[h],r[h],s[h]-i[h],n[h]-r[h]),t.fill()},()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,h),t.beginPath(),t.rect(i[h],r[h],s[h]-i[h],n[h]-r[h]),t.stroke()))}_clamp_viewport(){const t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,i=this.stop.length;for(let s=0;s<i;s++)this.stop[s]=Math.max(this.stop[s],e.start),this.sbottom[s]=Math.min(this.sbottom[s],e.end),this.sleft[s]=Math.max(this.sleft[s],t.start),this.sright[s]=Math.min(this.sright[s],t.end)}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){const{sx:e,sy:i}=t,s=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),n=this.index.indices({x0:s,y0:r,x1:s,y1:r});return new o.Selection({indices:n})}_hit_span(t){const{sx:e,sy:i}=t;let s;if("v"==t.direction){const t=this.renderer.yscale.invert(i),e=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(e.start,e.end);s=this.index.indices({x0:r,y0:t,x1:n,y1:t})}else{const t=this.renderer.xscale.invert(e),i=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(i.start,i.end);s=this.index.indices({x0:t,y0:r,x1:t,y1:n})}return new o.Selection({indices:s})}draw_legend_for_index(t,e,i){h.generic_area_legend(this.visuals,t,e,i)}}i.BoxView=a,a.__name__="BoxView";class c extends n.Glyph{constructor(t){super(t)}static init_Box(){this.mixins([s.LineVector,s.FillVector,s.HatchVector])}}i.Box=c,c.__name__="Box",c.init_Box()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(89),n=i.__importStar(e(93)),o=i.__importStar(e(18)),a=e(23),l=e(85),h=e(92),c=e(79);class _ extends r.GlyphView{scenterx(e){return this.sx[e]}scentery(e){return this.sy[e]}_set_data(){const e=this._q.length,t=this.model.size,s=this.model.aspect_scale;if(this._x=new Float64Array(e),this._y=new Float64Array(e),"pointytop"==this.model.orientation)for(let i=0;i<e;i++)this._x[i]=t*Math.sqrt(3)*(this._q[i]+this._r[i]/2)/s,this._y[i]=3*-t/2*this._r[i];else for(let i=0;i<e;i++)this._x[i]=3*t/2*this._q[i],this._y[i]=-t*Math.sqrt(3)*(this._r[i]+this._q[i]/2)*s}_index_data(){let e=this.model.size,t=Math.sqrt(3)*e/2;"flattop"==this.model.orientation?([t,e]=[e,t],e*=this.model.aspect_scale):t/=this.model.aspect_scale;const s=[];for(let i=0;i<this._x.length;i++){const r=this._x[i],n=this._y[i];!isNaN(r+n)&&isFinite(r+n)&&s.push({x0:r-t,y0:n-e,x1:r+t,y1:n+e,i})}return new l.SpatialIndex(s)}map_data(){[this.sx,this.sy]=this.map_to_screen(this._x,this._y),[this.svx,this.svy]=this._get_unscaled_vertices()}_get_unscaled_vertices(){const e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){const s=this.renderer.yscale,i=this.renderer.xscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t,o=r/2;return[[0,-n,-n,0,n,n],[r,o,-o,-r,-o,o]]}{const s=this.renderer.xscale,i=this.renderer.yscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t,o=r/2;return[[r,o,-o,-r,-o,o],[0,-n,-n,0,n,n]]}}_render(e,t,{sx:s,sy:i,svx:r,svy:n,_scale:o}){for(const a of t)if(!isNaN(s[a]+i[a]+o[a])){e.translate(s[a],i[a]),e.beginPath();for(let t=0;t<6;t++)e.lineTo(r[t]*o[a],n[t]*o[a]);e.closePath(),e.translate(-s[a],-i[a]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,a),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,a),e.stroke())}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s),o=this.index.indices({x0:i,y0:r,x1:i,y1:r}),a=[];for(const e of o)n.point_in_poly(t-this.sx[e],s-this.sy[e],this.svx,this.svy)&&a.push(e);return new c.Selection({indices:a})}_hit_span(e){const{sx:t,sy:s}=e;let i;if("v"==e.direction){const e=this.renderer.yscale.invert(s),t=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(t.start,t.end);i=this.index.indices({x0:r,y0:e,x1:n,y1:e})}else{const e=this.renderer.xscale.invert(t),s=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(s.start,s.end);i=this.index.indices({x0:e,y0:r,x1:e,y1:n})}return new c.Selection({indices:i})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:r}=e,[n,o]=this.renderer.xscale.r_invert(t,s),[a,l]=this.renderer.yscale.r_invert(i,r),h=this.index.indices({x0:n,x1:o,y0:a,y1:l});return new c.Selection({indices:h})}draw_legend_for_index(e,t,s){h.generic_area_legend(this.visuals,e,t,s)}}s.HexTileView=_,_.__name__="HexTileView";class d extends r.Glyph{constructor(e){super(e)}static init_HexTile(){this.prototype.default_view=_,this.coords([["r","q"]]),this.mixins([a.LineVector,a.FillVector]),this.define({size:[o.Number,1],aspect_scale:[o.Number,1],scale:[o.NumberSpec,1],orientation:[o.HexTileOrientation,"pointytop"]}),this.override({line_color:null})}}s.HexTile=d,d.__name__="HexTile",d.init_HexTile()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const _=e(1),i=e(221),n=e(115),s=_.__importStar(e(18));class r extends i.ImageBaseView{connect_signals(){super.connect_signals(),this.connect(this.model.color_mapper.change,()=>this._update_image())}_update_image(){null!=this.image_data&&(this._set_data(null),this.renderer.plot_view.request_render())}_flat_img_to_buf8(e){return this.model.color_mapper.rgba_mapper.v_compute(e)}}a.ImageView=r,r.__name__="ImageView";class o extends i.ImageBase{constructor(e){super(e)}static init_Image(){this.prototype.default_view=r,this.define({color_mapper:[s.Instance,()=>new n.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})]})}}a.Image=o,o.__name__="Image",o.init_Image()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),a=e(84),h=s.__importStar(e(18)),n=e(79),_=e(85),r=e(9),d=e(26);class l extends a.XYGlyphView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,()=>this.renderer.request_render())}_render(e,t,{image_data:i,sx:s,sy:a,sw:h,sh:n}){const _=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1),e.globalAlpha=this.model.global_alpha;for(const _ of t){if(null==i[_]||isNaN(s[_]+a[_]+h[_]+n[_]))continue;const t=a[_];e.translate(0,t),e.scale(1,-1),e.translate(0,-t),e.drawImage(i[_],0|s[_],0|a[_],h[_],n[_]),e.translate(0,t),e.scale(1,-1),e.translate(0,-t)}e.setImageSmoothingEnabled(_)}_set_data(e){this._set_width_heigh_data();for(let t=0,i=this._image.length;t<i;t++){if(null!=e&&e.indexOf(t)<0)continue;const i=this._image[t];let s;d.is_NDArray(i)?(s=i,this._height[t]=i.shape[0],this._width[t]=i.shape[1]):(s=r.concat(i),this._height[t]=i.length,this._width[t]=i[0].length);const a=this._flat_img_to_buf8(s);this._set_image_data_from_buffer(t,a)}}_index_data(){const e=[];for(let t=0,i=this._x.length;t<i;t++){const[i,s,a,h]=this._lrtb(t);!isNaN(i+s+a+h)&&isFinite(i+s+a+h)&&e.push({x0:i,y0:h,x1:s,y1:a,i:t})}return new _.SpatialIndex(e)}_lrtb(e){const t=this.renderer.xscale.source_range,i=this._x[e],s=t.is_reversed?i-this._dw[e]:i+this._dw[e],a=this.renderer.yscale.source_range,h=this._y[e],n=a.is_reversed?h-this._dh[e]:h+this._dh[e],[_,r]=i<s?[i,s]:[s,i],[d,l]=h<n?[h,n]:[n,h];return[_,r,l,d]}_set_width_heigh_data(){null!=this.image_data&&this.image_data.length==this._image.length||(this.image_data=new Array(this._image.length)),null!=this._width&&this._width.length==this._image.length||(this._width=new Array(this._image.length)),null!=this._height&&this._height.length==this._image.length||(this._height=new Array(this._image.length))}_get_or_create_canvas(e){const t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;{const t=document.createElement("canvas");return t.width=this._width[e],t.height=this._height[e],t}}_set_image_data_from_buffer(e,t){const i=this._get_or_create_canvas(e),s=i.getContext("2d"),a=s.getImageData(0,0,this._width[e],this._height[e]);a.data.set(t),s.putImageData(a,0,0),this.image_data[e]=i}_map_data(){switch(this.model.properties.dw.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,this._dw,"edge",this.model.dilate);break;case"screen":this.sw=this._dw}switch(this.model.properties.dh.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,this._dh,"edge",this.model.dilate);break;case"screen":this.sh=this._dh}}_image_index(e,t,i){const[s,a,h,n]=this._lrtb(e),_=this._width[e],r=this._height[e],d=(a-s)/_,l=(h-n)/r;let g=Math.floor((t-s)/d),o=Math.floor((i-n)/l);return this.renderer.xscale.source_range.is_reversed&&(g=_-g-1),this.renderer.yscale.source_range.is_reversed&&(o=r-o-1),{index:e,dim1:g,dim2:o,flat_index:o*_+g}}_hit_point(e){const{sx:t,sy:i}=e,s=this.renderer.xscale.invert(t),a=this.renderer.yscale.invert(i),h=this.index.indices({x0:s,x1:s,y0:a,y1:a}),_=new n.Selection;for(const e of h)t!=1/0&&i!=1/0&&_.image_indices.push(this._image_index(e,s,a));return _}}i.ImageBaseView=l,l.__name__="ImageBaseView";class g extends a.XYGlyph{constructor(e){super(e)}static init_ImageBase(){this.define({image:[h.NumberSpec],dw:[h.DistanceSpec],dh:[h.DistanceSpec],dilate:[h.Boolean,!1],global_alpha:[h.Number,1]})}}i.ImageBase=g,g.__name__="ImageBase",g.init_ImageBase()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const _=e(221),i=e(8);class n extends _.ImageBaseView{_flat_img_to_buf8(e){let t;return t=i.isArray(e)?new Uint32Array(e):e,new Uint8Array(t.buffer)}}a.ImageRGBAView=n,n.__name__="ImageRGBAView";class r extends _.ImageBase{constructor(e){super(e)}static init_ImageRGBA(){this.prototype.default_view=n}}a.ImageRGBA=r,r.__name__="ImageRGBA",r.init_ImageRGBA()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(84),a=i.__importStar(e(18)),n=e(12),h=e(85),l=e(224);class _ extends r.XYGlyphView{constructor(){super(...arguments),this._images_rendered=!1}initialize(){super.initialize(),this.connect(this.model.properties.global_alpha.change,()=>this.renderer.request_render())}_index_data(){return new h.SpatialIndex([])}_set_data(){null!=this.image&&this.image.length==this._url.length||(this.image=n.map(this._url,()=>null));const{retry_attempts:e,retry_timeout:t}=this.model;for(let s=0,i=this._url.length;s<i;s++){const i=this._url[s];null!=i&&""!=i&&new l.ImageLoader(i,{loaded:e=>{this.image[s]=e,this.renderer.request_render()},attempts:e+1,timeout:t})}const s="data"==this.model.properties.w.units,i="data"==this.model.properties.h.units,r=this._x.length,a=new Array(s?2*r:r),h=new Array(i?2*r:r);for(let e=0;e<r;e++)a[e]=this._x[e],h[e]=this._y[e];if(s)for(let e=0;e<r;e++)a[r+e]=this._x[e]+this._w[e];if(i)for(let e=0;e<r;e++)h[r+e]=this._y[e]+this._h[e];const _=n.min(a),o=n.max(a),d=n.min(h),c=n.max(h);this._bounds_rect={x0:_,x1:o,y0:d,y1:c}}has_finished(){return super.has_finished()&&1==this._images_rendered}_map_data(){const e=null!=this.model.w?this._w:n.map(this._x,()=>NaN),t=null!=this.model.h?this._h:n.map(this._x,()=>NaN);switch(this.model.properties.w.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,e,"edge",this.model.dilate);break;case"screen":this.sw=e}switch(this.model.properties.h.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,t,"edge",this.model.dilate);break;case"screen":this.sh=t}}_render(e,t,{image:s,sx:i,sy:r,sw:a,sh:n,_angle:h}){const{frame:l}=this.renderer.plot_view;e.rect(l._left.value+1,l._top.value+1,l._width.value-2,l._height.value-2),e.clip();let _=!0;for(const l of t){if(isNaN(i[l]+r[l]+h[l]))continue;const t=s[l];null!=t?this._render_image(e,l,t,i,r,a,n,h):_=!1}_&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())}_final_sx_sy(e,t,s,i,r){switch(e){case"top_left":return[t,s];case"top_center":return[t-i/2,s];case"top_right":return[t-i,s];case"center_right":return[t-i,s-r/2];case"bottom_right":return[t-i,s-r];case"bottom_center":return[t-i/2,s-r];case"bottom_left":return[t,s-r];case"center_left":return[t,s-r/2];case"center":return[t-i/2,s-r/2]}}_render_image(e,t,s,i,r,a,n,h){isNaN(a[t])&&(a[t]=s.width),isNaN(n[t])&&(n[t]=s.height);const{anchor:l}=this.model,[_,o]=this._final_sx_sy(l,i[t],r[t],a[t],n[t]);e.save(),e.globalAlpha=this.model.global_alpha;const d=a[t]/2,c=n[t]/2;h[t]?(e.translate(_,o),e.translate(d,c),e.rotate(h[t]),e.translate(-d,-c),e.drawImage(s,0,0,a[t],n[t]),e.translate(d,c),e.rotate(-h[t]),e.translate(-d,-c),e.translate(-_,-o)):e.drawImage(s,_,o,a[t],n[t]),e.restore()}bounds(){return this._bounds_rect}}s.ImageURLView=_,_.__name__="ImageURLView";class o extends r.XYGlyph{constructor(e){super(e)}static init_ImageURL(){this.prototype.default_view=_,this.define({url:[a.StringSpec],anchor:[a.Anchor,"top_left"],global_alpha:[a.Number,1],angle:[a.AngleSpec,0],w:[a.DistanceSpec],h:[a.DistanceSpec],dilate:[a.Boolean,!1],retry_attempts:[a.Number,0],retry_timeout:[a.Number,0]})}}s.ImageURL=o,o.__name__="ImageURL",o.init_ImageURL()},
function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});const s=i(72);class a{constructor(i,e={}){this._image=new Image,this._finished=!1;const{attempts:t=1,timeout:a=1}=e;this.promise=new Promise((o,n)=>{this._image.crossOrigin="anonymous";let r=0;this._image.onerror=()=>{if(++r==t){const a=`unable to load ${i} image after ${t} attempts`;if(s.logger.warn(a),null==this._image.crossOrigin)return void(null!=e.failed&&e.failed());s.logger.warn(`attempting to load ${i} without a cross origin policy`),this._image.crossOrigin=null,r=0}setTimeout(()=>this._image.src=i,a)},this._image.onload=()=>{this._finished=!0,null!=e.loaded&&e.loaded(this._image),o(this._image)},this._image.src=i})}get finished(){return this._finished}get image(){return this._image}}t.ImageLoader=a,a.__name__="ImageLoader"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),n=t(85),l=t(23),o=i.__importStar(t(93)),r=t(9),h=t(17),_=t(89),c=t(92),a=t(79);class x extends _.GlyphView{_index_data(){const t=[];for(let e=0,s=this._xs.length;e<s;e++){if(null==this._xs[e]||0===this._xs[e].length)continue;const s=this._xs[e],i=[];for(let t=0,e=s.length;t<e;t++){const e=s[t];isNaN(e)||i.push(e)}const n=this._ys[e],l=[];for(let t=0,e=n.length;t<e;t++){const e=n[t];isNaN(e)||l.push(e)}const[o,h]=[r.min(i),r.max(i)],[_,c]=[r.min(l),r.max(l)];t.push({x0:o,y0:_,x1:h,y1:c,i:e})}return new n.SpatialIndex(t)}_render(t,e,{sxs:s,sys:i}){for(const n of e){const[e,l]=[s[n],i[n]];this.visuals.line.set_vectorize(t,n);for(let s=0,i=e.length;s<i;s++)0!=s?isNaN(e[s])||isNaN(l[s])?(t.stroke(),t.beginPath()):t.lineTo(e[s],l[s]):(t.beginPath(),t.moveTo(e[s],l[s]));t.stroke()}}_hit_point(t){const e={x:t.sx,y:t.sy};let s=9999;const i=new Map;for(let t=0,n=this.sxs.length;t<n;t++){const n=Math.max(2,this.visuals.line.cache_select("line_width",t)/2);let l=null;for(let i=0,r=this.sxs[t].length-1;i<r;i++){const r={x:this.sxs[t][i],y:this.sys[t][i]},h={x:this.sxs[t][i+1],y:this.sys[t][i+1]},_=o.dist_to_segment(e,r,h);_<n&&_<s&&(s=_,l=[i])}null!=l&&i.set(t,l)}return new a.Selection({indices:[...i.keys()],multiline_indices:h.to_object(i)})}_hit_span(t){const{sx:e,sy:s}=t;let i,n;"v"===t.direction?(i=this.renderer.yscale.invert(s),n=this._ys):(i=this.renderer.xscale.invert(e),n=this._xs);const l=new Map;for(let t=0,e=n.length;t<e;t++){const e=[];for(let s=0,l=n[t].length-1;s<l;s++)n[t][s]<=i&&i<=n[t][s+1]&&e.push(s);e.length>0&&l.set(t,e)}return new a.Selection({indices:[...l.keys()],multiline_indices:h.to_object(l)})}get_interpolation_hit(t,e,s){const[i,n,l,o]=[this._xs[t][e],this._ys[t][e],this._xs[t][e+1],this._ys[t][e+1]];return c.line_interpolation(this.renderer,s,i,n,l,o)}draw_legend_for_index(t,e,s){c.generic_line_legend(this.visuals,t,e,s)}scenterx(){throw new Error("not implemented")}scentery(){throw new Error("not implemented")}}s.MultiLineView=x,x.__name__="MultiLineView";class u extends _.Glyph{constructor(t){super(t)}static init_MultiLine(){this.prototype.default_view=x,this.coords([["xs","ys"]]),this.mixins(l.LineVector)}}s.MultiLine=u,u.__name__="MultiLine",u.init_MultiLine()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),n=e(85),r=e(89),o=e(92),l=e(9),h=e(12),_=e(23),a=i.__importStar(e(93)),c=e(79),d=e(8),x=e(11);class y extends r.GlyphView{_index_data(){const e=[];for(let t=0,s=this._xs.length;t<s;t++)for(let s=0,i=this._xs[t].length;s<i;s++){const i=this._xs[t][s][0],n=this._ys[t][s][0];0!=i.length&&e.push({x0:l.min(i),y0:l.min(n),x1:l.max(i),y1:l.max(n),i:t})}return this.hole_index=this._index_hole_data(),new n.SpatialIndex(e)}_index_hole_data(){const e=[];for(let t=0,s=this._xs.length;t<s;t++)for(let s=0,i=this._xs[t].length;s<i;s++)if(this._xs[t][s].length>1)for(let i=1,n=this._xs[t][s].length;i<n;i++){const n=this._xs[t][s][i],r=this._ys[t][s][i];0!=n.length&&e.push({x0:l.min(n),y0:l.min(r),x1:l.max(n),y1:l.max(r),i:t})}return new n.SpatialIndex(e)}_mask_data(){const e=this.renderer.plot_view.frame.x_ranges.default,[t,s]=[e.min,e.max],i=this.renderer.plot_view.frame.y_ranges.default,[n,r]=[i.min,i.max];return this.index.indices({x0:t,x1:s,y0:n,y1:r}).sort((e,t)=>e-t).filter((e,t,s)=>0===t||e!==s[t-1])}_inner_loop(e,t,s){e.beginPath();for(let i=0,n=t.length;i<n;i++)for(let n=0,r=t[i].length;n<r;n++){const r=t[i][n],o=s[i][n];for(let t=0,s=r.length;t<s;t++)0!=t?e.lineTo(r[t],o[t]):e.moveTo(r[t],o[t]);e.closePath()}}_render(e,t,{sxs:s,sys:i}){if(this.visuals.fill.doit||this.visuals.line.doit)for(const n of t){const[t,r]=[s[n],i[n]];this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,n),this._inner_loop(e,t,r),e.fill("evenodd")),this.visuals.hatch.doit2(e,n,()=>{this._inner_loop(e,t,r),e.fill("evenodd")},()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,n),this._inner_loop(e,t,r),e.stroke())}}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,r=[t,s,s,t],o=[i,i,n,n],[l,h]=this.renderer.xscale.r_invert(t,s),[_,d]=this.renderer.yscale.r_invert(i,n),x=this.index.indices({x0:l,x1:h,y0:_,y1:d}),y=[];for(let e=0,t=x.length;e<t;e++){const t=x[e],s=this.sxs[t],i=this.sys[t];let n=!0;for(let e=0,t=s.length;e<t;e++){for(let t=0,l=s[e][0].length;t<l;t++){const l=s[e][0][t],h=i[e][0][t];if(!a.point_in_poly(l,h,r,o)){n=!1;break}}if(!n)break}n&&y.push(t)}return new c.Selection({indices:y})}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(s),r=this.index.indices({x0:i,y0:n,x1:i,y1:n}),o=this.hole_index.indices({x0:i,y0:n,x1:i,y1:n}),l=[];for(let e=0,i=r.length;e<i;e++){const i=r[e],n=this.sxs[i],h=this.sys[i];for(let e=0,r=n.length;e<r;e++){const r=n[e].length;if(a.point_in_poly(t,s,n[e][0],h[e][0]))if(1==r)l.push(i);else if(-1==o.indexOf(i))l.push(i);else if(r>1){let o=!1;for(let i=1;i<r;i++){const r=n[e][i],l=h[e][i];if(a.point_in_poly(t,s,r,l)){o=!0;break}}o||l.push(i)}}}return new c.Selection({indices:l})}_get_snap_coord(e){return h.sum(e)/e.length}scenterx(e,t,s){if(1==this.sxs[e].length)return this._get_snap_coord(this.sxs[e][0][0]);{const i=this.sxs[e],n=this.sys[e];for(let e=0,r=i.length;e<r;e++)if(a.point_in_poly(t,s,i[e][0],n[e][0]))return this._get_snap_coord(i[e][0])}x.unreachable()}scentery(e,t,s){if(1==this.sys[e].length)return this._get_snap_coord(this.sys[e][0][0]);{const i=this.sxs[e],n=this.sys[e];for(let e=0,r=i.length;e<r;e++)if(a.point_in_poly(t,s,i[e][0],n[e][0]))return this._get_snap_coord(n[e][0])}x.unreachable()}map_data(){const e=this;for(let[t,s]of this.model._coords){const i="s"+t,n="s"+s;if(t="_"+t,s="_"+s,null!=e[t]&&(d.isArray(e[t][0])||d.isTypedArray(e[t][0]))){const r=e[t].length;e[i]=new Array(r),e[n]=new Array(r);for(let o=0;o<r;o++){const r=e[t][o].length;e[i][o]=new Array(r),e[n][o]=new Array(r);for(let l=0;l<r;l++){const r=e[t][o][l].length;e[i][o][l]=new Array(r),e[n][o][l]=new Array(r);for(let h=0;h<r;h++){const[r,_]=this.map_to_screen(e[t][o][l][h],e[s][o][l][h]);e[i][o][l][h]=r,e[n][o][l][h]=_}}}}}}draw_legend_for_index(e,t,s){o.generic_area_legend(this.visuals,e,t,s)}}s.MultiPolygonsView=y,y.__name__="MultiPolygonsView";class f extends r.Glyph{constructor(e){super(e)}static init_MultiPolygons(){this.prototype.default_view=y,this.coords([["xs","ys"]]),this.mixins([_.LineVector,_.FillVector,_.HatchVector])}}s.MultiPolygons=f,f.__name__="MultiPolygons",f.init_MultiPolygons()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const l=e(216);class s extends l.EllipseOvalView{_map_data(){super._map_data();const{sw:e}=this,t=e.length;for(let a=0;a<t;a++)e[a]*=.75}}a.OvalView=s,s.__name__="OvalView";class _ extends l.EllipseOval{constructor(e){super(e)}static init_Oval(){this.prototype.default_view=s}}a.Oval=_,_.__name__="Oval",_.init_Oval()},
function _(s,t,e){Object.defineProperty(e,"__esModule",{value:!0});const i=s(1),n=s(85),r=s(89),o=s(92),l=s(9),_=s(12),h=s(23),c=i.__importStar(s(93)),a=s(79),d=s(11);class u extends r.GlyphView{_build_discontinuous_object(s){const t=[];for(let e=0,i=s.length;e<i;e++){t[e]=[];let i=l.copy(s[e]);for(;i.length>0;){const s=l.find_last_index(i,s=>isNaN(s));let n;s>=0?n=i.splice(s):(n=i,i=[]);const r=n.filter(s=>!isNaN(s));t[e].push(r)}}return t}_index_data(){const s=this._build_discontinuous_object(this._xs),t=this._build_discontinuous_object(this._ys),e=[];for(let i=0,n=this._xs.length;i<n;i++)for(let n=0,r=s[i].length;n<r;n++){const r=s[i][n],o=t[i][n];0!=r.length&&e.push({x0:l.min(r),y0:l.min(o),x1:l.max(r),y1:l.max(o),i})}return new n.SpatialIndex(e)}_mask_data(){const s=this.renderer.plot_view.frame.x_ranges.default,[t,e]=[s.min,s.max],i=this.renderer.plot_view.frame.y_ranges.default,[n,r]=[i.min,i.max];return this.index.indices({x0:t,x1:e,y0:n,y1:r}).sort((s,t)=>s-t)}_inner_loop(s,t,e,i){for(let n=0,r=t.length;n<r;n++)0!=n?isNaN(t[n]+e[n])?(s.closePath(),i.apply(s),s.beginPath()):s.lineTo(t[n],e[n]):(s.beginPath(),s.moveTo(t[n],e[n]));s.closePath(),i.call(s)}_render(s,t,{sxs:e,sys:i}){this.sxss=this._build_discontinuous_object(e),this.syss=this._build_discontinuous_object(i);for(const n of t){const[t,r]=[e[n],i[n]];this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(s,n),this._inner_loop(s,t,r,s.fill)),this.visuals.hatch.doit2(s,n,()=>this._inner_loop(s,t,r,s.fill),()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,n),this._inner_loop(s,t,r,s.stroke))}}_hit_rect(s){const{sx0:t,sx1:e,sy0:i,sy1:n}=s,r=[t,e,e,t],o=[i,i,n,n],[l,_]=this.renderer.xscale.r_invert(t,e),[h,d]=this.renderer.yscale.r_invert(i,n),u=this.index.indices({x0:l,x1:_,y0:h,y1:d}),x=[];for(let s=0,t=u.length;s<t;s++){const t=u[s],e=this.sxs[t],i=this.sys[t];let n=!0;for(let s=0,t=e.length;s<t;s++){const t=e[s],l=i[s];if(!c.point_in_poly(t,l,r,o)){n=!1;break}}n&&x.push(t)}return new a.Selection({indices:x})}_hit_point(s){const{sx:t,sy:e}=s,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(e),r=this.index.indices({x0:i,y0:n,x1:i,y1:n}),o=[];for(let s=0,i=r.length;s<i;s++){const i=r[s],n=this.sxss[i],l=this.syss[i];for(let s=0,r=n.length;s<r;s++)c.point_in_poly(t,e,n[s],l[s])&&o.push(i)}return new a.Selection({indices:o})}_get_snap_coord(s){return _.sum(s)/s.length}scenterx(s,t,e){if(1==this.sxss[s].length)return this._get_snap_coord(this.sxs[s]);{const i=this.sxss[s],n=this.syss[s];for(let s=0,r=i.length;s<r;s++)if(c.point_in_poly(t,e,i[s],n[s]))return this._get_snap_coord(i[s])}d.unreachable()}scentery(s,t,e){if(1==this.syss[s].length)return this._get_snap_coord(this.sys[s]);{const i=this.sxss[s],n=this.syss[s];for(let s=0,r=i.length;s<r;s++)if(c.point_in_poly(t,e,i[s],n[s]))return this._get_snap_coord(n[s])}d.unreachable()}draw_legend_for_index(s,t,e){o.generic_area_legend(this.visuals,s,t,e)}}e.PatchesView=u,u.__name__="PatchesView";class x extends r.Glyph{constructor(s){super(s)}static init_Patches(){this.prototype.default_view=u,this.coords([["xs","ys"]]),this.mixins([h.LineVector,h.FillVector,h.HatchVector])}}e.Patches=x,x.__name__="Patches",x.init_Patches()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(218);class _ extends i.BoxView{scenterx(t){return(this.sleft[t]+this.sright[t])/2}scentery(t){return(this.stop[t]+this.sbottom[t])/2}_index_data(){return this._index_box(this._right.length)}_lrtb(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]}}s.QuadView=_,_.__name__="QuadView";class o extends i.Box{constructor(t){super(t)}static init_Quad(){this.prototype.default_view=_,this.coords([["right","bottom"],["left","top"]])}}s.Quad=o,o.__name__="Quad",o.init_Quad()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});const s=t(23),n=t(85),r=t(89),_=t(92);function a(t,i,e){if(i==(t+e)/2)return[t,e];{const s=(t-i)/(t-2*i+e),n=t*(1-s)**2+2*i*(1-s)*s+e*s**2;return[Math.min(t,e,n),Math.max(t,e,n)]}}class c extends r.GlyphView{_index_data(){const t=[];for(let i=0,e=this._x0.length;i<e;i++){if(isNaN(this._x0[i]+this._x1[i]+this._y0[i]+this._y1[i]+this._cx[i]+this._cy[i]))continue;const[e,s]=a(this._x0[i],this._cx[i],this._x1[i]),[n,r]=a(this._y0[i],this._cy[i],this._y1[i]);t.push({x0:e,y0:n,x1:s,y1:r,i})}return new n.SpatialIndex(t)}_render(t,i,{sx0:e,sy0:s,sx1:n,sy1:r,scx:_,scy:a}){if(this.visuals.line.doit)for(const c of i)isNaN(e[c]+s[c]+n[c]+r[c]+_[c]+a[c])||(t.beginPath(),t.moveTo(e[c],s[c]),t.quadraticCurveTo(_[c],a[c],n[c],r[c]),this.visuals.line.set_vectorize(t,c),t.stroke())}draw_legend_for_index(t,i,e){_.generic_line_legend(this.visuals,t,i,e)}scenterx(){throw new Error("not implemented")}scentery(){throw new Error("not implemented")}}e.QuadraticView=c,c.__name__="QuadraticView";class o extends r.Glyph{constructor(t){super(t)}static init_Quadratic(){this.prototype.default_view=c,this.coords([["x0","y0"],["x1","y1"],["cx","cy"]]),this.mixins(s.LineVector)}}e.Quadratic=o,o.__name__="Quadratic",o.init_Quadratic()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),n=e(84),a=e(92),l=e(23),r=s.__importStar(e(18));class _ extends n.XYGlyphView{_map_data(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this._length):this.slength=this._length}_render(e,t,{sx:i,sy:s,slength:n,_angle:a}){if(this.visuals.line.doit){const l=2*(this.renderer.plot_view.frame._width.value+this.renderer.plot_view.frame._height.value);for(let e=0,t=n.length;e<t;e++)0==n[e]&&(n[e]=l);for(const l of t)isNaN(i[l]+s[l]+a[l]+n[l])||(e.translate(i[l],s[l]),e.rotate(a[l]),e.beginPath(),e.moveTo(0,0),e.lineTo(n[l],0),this.visuals.line.set_vectorize(e,l),e.stroke(),e.rotate(-a[l]),e.translate(-i[l],-s[l]))}}draw_legend_for_index(e,t,i){a.generic_line_legend(this.visuals,e,t,i)}}i.RayView=_,_.__name__="RayView";class h extends n.XYGlyph{constructor(e){super(e)}static init_Ray(){this.prototype.default_view=_,this.mixins(l.LineVector),this.define({length:[r.DistanceSpec],angle:[r.AngleSpec]})}}i.Ray=h,h.__name__="Ray",h.init_Ray()},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1),h=t(214),a=t(92),r=i.__importStar(t(18)),n=t(12),_=t(79);class l extends h.CenterRotatableView{_set_data(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)}_map_data(){if("data"==this.model.properties.width.units)[this.sw,this.sx0]=this._map_dist_corner_for_data_side_length(this._x,this._width,this.renderer.xscale);else{this.sw=this._width;const t=this.sx.length;this.sx0=new Float64Array(t);for(let s=0;s<t;s++)this.sx0[s]=this.sx[s]-this.sw[s]/2}if("data"==this.model.properties.height.units)[this.sh,this.sy1]=this._map_dist_corner_for_data_side_length(this._y,this._height,this.renderer.yscale);else{this.sh=this._height;const t=this.sy.length;this.sy1=new Float64Array(t);for(let s=0;s<t;s++)this.sy1[s]=this.sy[s]-this.sh[s]/2}const t=this.sw.length;this.ssemi_diag=new Float64Array(t);for(let s=0;s<t;s++)this.ssemi_diag[s]=Math.sqrt(this.sw[s]/2*this.sw[s]/2+this.sh[s]/2*this.sh[s]/2)}_render(t,s,{sx:e,sy:i,sx0:h,sy1:a,sw:r,sh:n,_angle:_}){if(this.visuals.fill.doit)for(const l of s)isNaN(e[l]+i[l]+h[l]+a[l]+r[l]+n[l]+_[l])||(this.visuals.fill.set_vectorize(t,l),_[l]?(t.translate(e[l],i[l]),t.rotate(_[l]),t.fillRect(-r[l]/2,-n[l]/2,r[l],n[l]),t.rotate(-_[l]),t.translate(-e[l],-i[l])):t.fillRect(h[l],a[l],r[l],n[l]));if(this.visuals.line.doit){t.beginPath();for(const l of s)isNaN(e[l]+i[l]+h[l]+a[l]+r[l]+n[l]+_[l])||0!=r[l]&&0!=n[l]&&(_[l]?(t.translate(e[l],i[l]),t.rotate(_[l]),t.rect(-r[l]/2,-n[l]/2,r[l],n[l]),t.rotate(-_[l]),t.translate(-e[l],-i[l])):t.rect(h[l],a[l],r[l],n[l]),this.visuals.line.set_vectorize(t,l),t.stroke(),t.beginPath());t.stroke()}}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){let{sx:s,sy:e}=t;const i=this.renderer.xscale.invert(s),h=this.renderer.yscale.invert(e),a=[];for(let t=0,s=this.sx0.length;t<s;t++)a.push(this.sx0[t]+this.sw[t]/2);const r=[];for(let t=0,s=this.sy1.length;t<s;t++)r.push(this.sy1[t]+this.sh[t]/2);const l=n.max(this._ddist(0,a,this.ssemi_diag)),o=n.max(this._ddist(1,r,this.ssemi_diag)),d=i-l,c=i+l,x=h-o,y=h+o,f=[];for(const t of this.index.indices({x0:d,x1:c,y0:x,y1:y})){let i,h;if(this._angle[t]){const a=Math.sin(-this._angle[t]),r=Math.cos(-this._angle[t]),n=r*(s-this.sx[t])-a*(e-this.sy[t])+this.sx[t],_=a*(s-this.sx[t])+r*(e-this.sy[t])+this.sy[t];s=n,e=_,h=Math.abs(this.sx[t]-s)<=this.sw[t]/2,i=Math.abs(this.sy[t]-e)<=this.sh[t]/2}else h=s-this.sx0[t]<=this.sw[t]&&s-this.sx0[t]>=0,i=e-this.sy1[t]<=this.sh[t]&&e-this.sy1[t]>=0;i&&h&&f.push(t)}return new _.Selection({indices:f})}_map_dist_corner_for_data_side_length(t,s,e){const i=t.length,h=new Float64Array(i),a=new Float64Array(i);for(let e=0;e<i;e++)h[e]=Number(t[e])-s[e]/2,a[e]=Number(t[e])+s[e]/2;const r=e.v_compute(h),n=e.v_compute(a),_=this.sdist(e,h,s,"edge",this.model.dilate);let l=r;for(let t=0,s=r.length;t<s;t++)if(r[t]!=n[t]){l=r[t]<n[t]?r:n;break}return[_,l]}_ddist(t,s,e){const i=0==t?this.renderer.xscale:this.renderer.yscale,h=s,a=h.length,r=new Float64Array(a);for(let t=0;t<a;t++)r[t]=h[t]+e[t];const n=i.v_invert(h),_=i.v_invert(r),l=n.length,o=new Float64Array(l);for(let t=0;t<l;t++)o[t]=Math.abs(_[t]-n[t]);return o}draw_legend_for_index(t,s,e){a.generic_area_legend(this.visuals,t,s,e)}_bounds({x0:t,x1:s,y0:e,y1:i}){return{x0:t-this.max_w2,x1:s+this.max_w2,y0:e-this.max_h2,y1:i+this.max_h2}}}e.RectView=l,l.__name__="RectView";class o extends h.CenterRotatable{constructor(t){super(t)}static init_Rect(){this.prototype.default_view=l,this.define({dilate:[r.Boolean,!1]})}}e.Rect=o,o.__name__="Rect",o.init_Rect()},
function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const i=e(1).__importStar(e(93)),n=e(23),r=e(85),h=e(89),_=e(92),a=e(79);class c extends h.GlyphView{_index_data(){const e=[];for(let s=0,t=this._x0.length;s<t;s++){const t=this._x0[s],i=this._x1[s],n=this._y0[s],r=this._y1[s];isNaN(t+i+n+r)||e.push({x0:Math.min(t,i),y0:Math.min(n,r),x1:Math.max(t,i),y1:Math.max(n,r),i:s})}return new r.SpatialIndex(e)}_render(e,s,{sx0:t,sy0:i,sx1:n,sy1:r}){if(this.visuals.line.doit)for(const h of s)isNaN(t[h]+i[h]+n[h]+r[h])||(e.beginPath(),e.moveTo(t[h],i[h]),e.lineTo(n[h],r[h]),this.visuals.line.set_vectorize(e,h),e.stroke())}_hit_point(e){const{sx:s,sy:t}=e,n={x:s,y:t},[r,h]=this.renderer.xscale.r_invert(s-2,s+2),[_,c]=this.renderer.yscale.r_invert(t-2,t+2),o=this.index.indices({x0:r,y0:_,x1:h,y1:c}),x=[];for(const e of o){const s=Math.max(2,this.visuals.line.cache_select("line_width",e)/2)**2,t={x:this.sx0[e],y:this.sy0[e]},r={x:this.sx1[e],y:this.sy1[e]};i.dist_to_segment_squared(n,t,r)<s&&x.push(e)}return new a.Selection({indices:x})}_hit_span(e){const[s,t]=this.renderer.plot_view.frame.bbox.ranges,{sx:i,sy:n}=e;let r,h,_;"v"==e.direction?(_=this.renderer.yscale.invert(n),[r,h]=[this._y0,this._y1]):(_=this.renderer.xscale.invert(i),[r,h]=[this._x0,this._x1]);const c=[],[o,x]=this.renderer.xscale.r_invert(s.start,s.end),[l,d]=this.renderer.yscale.r_invert(t.start,t.end),y=this.index.indices({x0:o,y0:l,x1:x,y1:d});for(const s of y){(r[s]<=_&&_<=h[s]||h[s]<=_&&_<=r[s])&&c.push(s);const t=1.5+this.visuals.line.cache_select("line_width",s)/2;r[s]==h[s]&&("h"==e.direction?Math.abs(this.sx0[s]-i)<=t&&c.push(s):Math.abs(this.sy0[s]-n)<=t&&c.push(s))}return new a.Selection({indices:c})}scenterx(e){return(this.sx0[e]+this.sx1[e])/2}scentery(e){return(this.sy0[e]+this.sy1[e])/2}draw_legend_for_index(e,s,t){_.generic_line_legend(this.visuals,e,s,t)}}t.SegmentView=c,c.__name__="SegmentView";class o extends h.Glyph{constructor(e){super(e)}static init_Segment(){this.prototype.default_view=c,this.coords([["x0","y0"],["x1","y1"]]),this.mixins(n.LineVector)}}t.Segment=o,o.__name__="Segment",o.init_Segment()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=e(84),o=e(92),r=e(23),l=n.__importStar(e(18));class a extends s.XYGlyphView{_render(e,t,{sx:i,sy:n}){let s=!1,o=null;this.visuals.line.set_value(e);const r=t.length;if(!(r<2)){e.beginPath(),e.moveTo(i[0],n[0]);for(const r of t){let t,l,a,_;switch(this.model.mode){case"before":[t,a]=[i[r-1],n[r]],[l,_]=[i[r],n[r]];break;case"after":[t,a]=[i[r],n[r-1]],[l,_]=[i[r],n[r]];break;case"center":{const e=(i[r-1]+i[r])/2;[t,a]=[e,n[r-1]],[l,_]=[e,n[r]];break}default:throw new Error("unexpected")}if(s){if(!isFinite(i[r]+n[r])){e.stroke(),e.beginPath(),s=!1,o=r;continue}null!=o&&r-o>1&&(e.stroke(),s=!1)}s?(e.lineTo(t,a),e.lineTo(l,_)):(e.beginPath(),e.moveTo(i[r],n[r]),s=!0),o=r}e.lineTo(i[r-1],n[r-1]),e.stroke()}}draw_legend_for_index(e,t,i){o.generic_line_legend(this.visuals,e,t,i)}}i.StepView=a,a.__name__="StepView";class _ extends s.XYGlyph{constructor(e){super(e)}static init_Step(){this.prototype.default_view=a,this.mixins(r.LineVector),this.define({mode:[l.StepMode,"before"]})}}i.Step=_,_.__name__="Step",_.init_Step()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),n=t(84),_=t(23),o=i.__importStar(t(93)),h=i.__importStar(t(18)),r=t(132),l=t(11),a=t(79);class c extends n.XYGlyphView{_rotate_point(t,e,s,i,n){return[(t-s)*Math.cos(n)-(e-i)*Math.sin(n)+s,(t-s)*Math.sin(n)+(e-i)*Math.cos(n)+i]}_text_bounds(t,e,s,i){return[[t,t+s,t+s,t,t],[e,e,e-i,e-i,e]]}_render(t,e,{sx:s,sy:i,_x_offset:n,_y_offset:_,_angle:o,_text:h}){this._sys=[],this._sxs=[];for(const l of e)if(this._sxs[l]=[],this._sys[l]=[],!isNaN(s[l]+i[l]+n[l]+_[l]+o[l])&&null!=h[l]&&this.visuals.text.doit){const e=""+h[l];t.save(),t.translate(s[l]+n[l],i[l]+_[l]),t.rotate(o[l]),this.visuals.text.set_vectorize(t,l);const a=this.visuals.text.cache_select("font",l),{height:c}=r.measure_font(a),x=this.visuals.text.text_line_height.value()*c;if(-1==e.indexOf("\n")){t.fillText(e,0,0);const o=s[l]+n[l],h=i[l]+_[l],r=t.measureText(e).width,[a,c]=this._text_bounds(o,h,r,x);this._sxs[l].push(a),this._sys[l].push(c)}else{const o=e.split("\n"),h=x*o.length,r=this.visuals.text.cache_select("text_baseline",l);let a;switch(r){case"top":a=0;break;case"middle":a=-h/2+x/2;break;case"bottom":a=-h+x;break;default:a=0,console.warn(`'${r}' baseline not supported with multi line text`)}for(const e of o){t.fillText(e,0,a);const o=s[l]+n[l],h=a+i[l]+_[l],r=t.measureText(e).width,[c,u]=this._text_bounds(o,h,r,x);this._sxs[l].push(c),this._sys[l].push(u),a+=x}}t.restore()}}_hit_point(t){const{sx:e,sy:s}=t,i=[];for(let t=0;t<this._sxs.length;t++){const n=this._sxs[t],_=this._sys[t],h=n.length;for(let r=0,l=h;r<l;r++){const[l,a]=this._rotate_point(e,s,n[h-1][0],_[h-1][0],-this._angle[t]);o.point_in_poly(l,a,n[r],_[r])&&i.push(t)}}return new a.Selection({indices:i})}_scenterxy(t){const e=this._sxs[t],s=this._sys[t];l.assert(0!=e.length&&0!=s.length);const i=e[0][0],n=s[0][0],_=(e[0][2]+i)/2,o=(s[0][2]+n)/2,[h,r]=this._rotate_point(_,o,i,n,this._angle[t]);return{x:h,y:r}}scenterx(t){return this._scenterxy(t).x}scentery(t){return this._scenterxy(t).y}}s.TextView=c,c.__name__="TextView";class x extends n.XYGlyph{constructor(t){super(t)}static init_Text(){this.prototype.default_view=c,this.mixins(_.TextVector),this.define({text:[h.NullStringSpec,{field:"text"}],angle:[h.AngleSpec,0],x_offset:[h.NumberSpec,0],y_offset:[h.NumberSpec,0]})}}s.Text=x,x.__name__="Text",x.init_Text()},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1),h=t(218),r=i.__importStar(t(18));class o extends h.BoxView{scenterx(t){return this.sx[t]}scentery(t){return(this.stop[t]+this.sbottom[t])/2}_index_data(){return this._index_box(this._x.length)}_lrtb(t){return[this._x[t]-this._width[t]/2,this._x[t]+this._width[t]/2,Math.max(this._top[t],this._bottom[t]),Math.min(this._top[t],this._bottom[t])]}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);const t=this.sx.length;this.sleft=new Float64Array(t),this.sright=new Float64Array(t);for(let s=0;s<t;s++)this.sleft[s]=this.sx[s]-this.sw[s]/2,this.sright[s]=this.sx[s]+this.sw[s]/2;this._clamp_viewport()}}e.VBarView=o,o.__name__="VBarView";class _ extends h.Box{constructor(t){super(t)}static init_VBar(){this.prototype.default_view=o,this.coords([["x","bottom"]]),this.define({width:[r.NumberSpec],top:[r.CoordinateSpec]}),this.override({bottom:0})}}e.VBar=_,_.__name__="VBar",_.init_VBar()},
function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const i=e(1),r=e(84),n=e(92),a=e(23),_=i.__importStar(e(18)),d=e(10),o=e(79);class l extends r.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius}_render(e,s,{sx:t,sy:i,sradius:r,_start_angle:n,_end_angle:a}){const _=this.model.properties.direction.value();for(const d of s)isNaN(t[d]+i[d]+r[d]+n[d]+a[d])||(e.beginPath(),e.arc(t[d],i[d],r[d],n[d],a[d],_),e.lineTo(t[d],i[d]),e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,d),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,d),e.stroke()))}_hit_point(e){let s,t,i,r,n,a,_,l,c;const{sx:h,sy:u}=e,p=this.renderer.xscale.invert(h),x=this.renderer.yscale.invert(u),g=2*this.max_radius;"data"===this.model.properties.radius.units?(a=p-g,_=p+g,l=x-g,c=x+g):(t=h-g,i=h+g,[a,_]=this.renderer.xscale.r_invert(t,i),r=u-g,n=u+g,[l,c]=this.renderer.yscale.r_invert(r,n));const y=[];for(const e of this.index.indices({x0:a,x1:_,y0:l,y1:c})){const a=this.sradius[e]**2;[t,i]=this.renderer.xscale.r_compute(p,this._x[e]),[r,n]=this.renderer.yscale.r_compute(x,this._y[e]),s=(t-i)**2+(r-n)**2,s<=a&&y.push([e,s])}const f=this.model.properties.direction.value(),v=[];for(const[e,s]of y){const t=Math.atan2(u-this.sy[e],h-this.sx[e]);d.angle_between(-t,-this._start_angle[e],-this._end_angle[e],f)&&v.push([e,s])}return o.Selection.from_hits(v)}draw_legend_for_index(e,s,t){n.generic_area_legend(this.visuals,e,s,t)}_scenterxy(e){const s=this.sradius[e]/2,t=(this._start_angle[e]+this._end_angle[e])/2;return{x:this.sx[e]+s*Math.cos(t),y:this.sy[e]+s*Math.sin(t)}}scenterx(e){return this._scenterxy(e).x}scentery(e){return this._scenterxy(e).y}}t.WedgeView=l,l.__name__="WedgeView";class c extends r.XYGlyph{constructor(e){super(e)}static init_Wedge(){this.prototype.default_view=l,this.mixins([a.LineVector,a.FillVector]),this.define({direction:[_.Direction,"anticlock"],radius:[_.DistanceSpec],start_angle:[_.AngleSpec],end_angle:[_.AngleSpec]})}}t.Wedge=c,c.__name__="Wedge",c.init_Wedge()},
function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0});const r=e(1);r.__exportStar(e(101),_),r.__exportStar(e(239),_),r.__exportStar(e(240),_)},
function _(e,o,r){Object.defineProperty(r,"__esModule",{value:!0});const t=e(71);class n extends t.Model{constructor(e){super(e)}}r.LayoutProvider=n,n.__name__="LayoutProvider"},
function _(t,a,e){Object.defineProperty(e,"__esModule",{value:!0});const o=t(1),r=t(239),s=o.__importStar(t(18));class n extends r.LayoutProvider{constructor(t){super(t)}static init_StaticLayoutProvider(){this.define({graph_layout:[s.Any,{}]})}get_node_coordinates(t){const a=[],e=[],o=t.data.index;for(let t=0,r=o.length;t<r;t++){const r=this.graph_layout[o[t]],[s,n]=null!=r?r:[NaN,NaN];a.push(s),e.push(n)}return[a,e]}get_edge_coordinates(t){const a=[],e=[],o=t.data.start,r=t.data.end,s=null!=t.data.xs&&null!=t.data.ys;for(let n=0,u=o.length;n<u;n++){const u=null!=this.graph_layout[o[n]]&&null!=this.graph_layout[r[n]];if(s&&u)a.push(t.data.xs[n]),e.push(t.data.ys[n]);else{let t,s;[s,t]=u?[this.graph_layout[o[n]],this.graph_layout[r[n]]]:[[NaN,NaN],[NaN,NaN]],a.push([s[0],t[0]]),e.push([s[1],t[1]])}}return[a,e]}}e.StaticLayoutProvider=n,n.__name__="StaticLayoutProvider",n.init_StaticLayoutProvider()},
function _(e,r,d){Object.defineProperty(d,"__esModule",{value:!0});var i=e(242);d.Grid=i.Grid},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1),s=e(151),r=n.__importStar(e(23)),_=n.__importStar(e(18)),o=e(8);class a extends s.GuideRendererView{render(){if(!this.model.visible)return;const e=this.layer.ctx;e.save(),this._draw_regions(e),this._draw_minor_grids(e),this._draw_grids(e),e.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render())}_draw_regions(e){if(!this.visuals.band_fill.doit&&!this.visuals.band_hatch.doit)return;this.visuals.band_fill.set_value(e);const[i,t]=this.grid_coords("major",!1);for(let n=0;n<i.length-1;n++){if(n%2!=1)continue;const[s,r]=this.plot_view.map_to_screen(i[n],t[n],this.model.x_range_name,this.model.y_range_name),[_,o]=this.plot_view.map_to_screen(i[n+1],t[n+1],this.model.x_range_name,this.model.y_range_name);this.visuals.band_fill.doit&&e.fillRect(s[0],r[0],_[1]-s[0],o[1]-r[0]),this.visuals.band_hatch.doit2(e,n,()=>{e.fillRect(s[0],r[0],_[1]-s[0],o[1]-r[0])},()=>this.request_render())}}_draw_grids(e){if(!this.visuals.grid_line.doit)return;const[i,t]=this.grid_coords("major");this._draw_grid_helper(e,this.visuals.grid_line,i,t)}_draw_minor_grids(e){if(!this.visuals.minor_grid_line.doit)return;const[i,t]=this.grid_coords("minor");this._draw_grid_helper(e,this.visuals.minor_grid_line,i,t)}_draw_grid_helper(e,i,t,n){i.set_value(e);for(let i=0;i<t.length;i++){const[s,r]=this.plot_view.map_to_screen(t[i],n[i],this.model.x_range_name,this.model.y_range_name);e.beginPath(),e.moveTo(Math.round(s[0]),Math.round(r[0]));for(let i=1;i<s.length;i++)e.lineTo(Math.round(s[i]),Math.round(r[i]));e.stroke()}}ranges(){const e=this.model.dimension,i=(e+1)%2,t=this.plot_view.frame,n=[t.x_ranges[this.model.x_range_name],t.y_ranges[this.model.y_range_name]];return[n[e],n[i]]}computed_bounds(){const[e]=this.ranges(),i=this.model.bounds,t=[e.min,e.max];let n,s;if(o.isArray(i))n=Math.min(i[0],i[1]),s=Math.max(i[0],i[1]),n<t[0]&&(n=t[0]),s>t[1]&&(s=t[1]);else{[n,s]=t;for(const e of this.plot_view.axis_views)e.dimension==this.model.dimension&&e.model.x_range_name==this.model.x_range_name&&e.model.y_range_name==this.model.y_range_name&&([n,s]=e.computed_bounds)}return[n,s]}grid_coords(e,i=!0){const t=this.model.dimension,n=(t+1)%2,[s,r]=this.ranges();let[_,o]=this.computed_bounds();[_,o]=[Math.min(_,o),Math.max(_,o)];const a=[[],[]],d=this.model.get_ticker();if(null==d)return a;const l=d.get_ticks(_,o,s,r.min,{})[e],h=s.min,m=s.max,c=r.min,u=r.max;i||(l[0]!=h&&l.splice(0,0,h),l[l.length-1]!=m&&l.push(m));for(let e=0;e<l.length;e++){if((l[e]==h||l[e]==m)&&i)continue;const s=[],r=[],_=2;for(let i=0;i<_;i++){const t=c+(u-c)/(_-1)*i;s.push(l[e]),r.push(t)}a[t].push(s),a[n].push(r)}return a}}t.GridView=a,a.__name__="GridView";class d extends s.GuideRenderer{constructor(e){super(e)}static init_Grid(){this.prototype.default_view=a,this.mixins([["grid_",r.Line],["minor_grid_",r.Line],["band_",r.Fill],["band_",r.Hatch]]),this.define({bounds:[_.Any,"auto"],dimension:[_.Any,0],axis:[_.Instance],ticker:[_.Instance],x_range_name:[_.String,"default"],y_range_name:[_.String,"default"]}),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})}get_ticker(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null}}t.Grid=d,d.__name__="Grid",d.init_Grid()},
function _(a,o,r){Object.defineProperty(r,"__esModule",{value:!0});var e=a(244);r.Box=e.Box;var v=a(247);r.Column=v.Column;var x=a(248);r.GridBox=x.GridBox;var B=a(249);r.HTMLBox=B.HTMLBox;var n=a(245);r.LayoutDOM=n.LayoutDOM;var t=a(250);r.Row=t.Row;var u=a(251);r.Spacer=u.Spacer;var d=a(252);r.Panel=d.Panel,r.Tabs=d.Tabs;var i=a(259);r.WidgetBox=i.WidgetBox},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=e(245),o=n.__importStar(e(18));class c extends s.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.children.change,()=>this.rebuild())}get child_models(){return this.model.children}}i.BoxView=c,c.__name__="BoxView";class r extends s.LayoutDOM{constructor(e){super(e)}static init_Box(){this.define({children:[o.Array,[]],spacing:[o.Number,0]})}}i.Box=r,r.__name__="Box",r.init_Box()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});const s=t(1),o=t(71),l=t(68),n=t(72),h=t(8),a=s.__importStar(t(18)),_=t(99),r=t(66),d=t(246);class u extends r.DOMView{constructor(){super(...arguments),this._idle_notified=!1,this._offset_parent=null,this._viewport={}}initialize(){super.initialize(),this.el.style.position=this.is_root?"relative":"absolute",this._child_views=new Map}async lazy_initialize(){await this.build_child_views()}remove(){for(const t of this.child_views)t.remove();this._child_views.clear(),super.remove()}connect_signals(){super.connect_signals(),this.is_root&&(this._on_resize=()=>this.resize_layout(),window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval(()=>{const t=this.el.offsetParent;this._offset_parent!=t&&(this._offset_parent=t,null!=t&&(this.compute_viewport(),this.invalidate_layout()))},250));const t=this.model.properties;this.on_change([t.width,t.height,t.min_width,t.min_height,t.max_width,t.max_height,t.margin,t.width_policy,t.height_policy,t.sizing_mode,t.aspect_ratio,t.visible],()=>this.invalidate_layout()),this.on_change([t.background,t.css_classes],()=>this.invalidate_render())}disconnect_signals(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),super.disconnect_signals()}css_classes(){return super.css_classes().concat(this.model.css_classes)}get child_views(){return this.child_models.map(t=>this._child_views.get(t))}async build_child_views(){await _.build_views(this._child_views,this.child_models,{parent:this})}render(){super.render(),l.empty(this.el);const{background:t}=this.model;this.el.style.backgroundColor=null!=t?t:"",l.classes(this.el).clear().add(...this.css_classes());for(const t of this.child_views)this.el.appendChild(t.el),t.render()}update_layout(){for(const t of this.child_views)t.update_layout();this._update_layout()}update_position(){this.el.style.display=this.model.visible?"block":"none";const t=this.is_root?this.layout.sizing.margin:void 0;l.position(this.el,this.layout.bbox,t);for(const t of this.child_views)t.update_position()}after_layout(){for(const t of this.child_views)t.after_layout();this._has_finished=!0}compute_viewport(){this._viewport=this._viewport_size()}renderTo(t){t.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build()}build(){return this.assert_root(),this.render(),this.update_layout(),this.compute_layout(),this}async rebuild(){await this.build_child_views(),this.invalidate_render()}compute_layout(){const t=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),n.logger.debug(`layout computed in ${Date.now()-t} ms`),this.notify_finished()}resize_layout(){this.root.compute_viewport(),this.root.compute_layout()}invalidate_layout(){this.root.update_layout(),this.root.compute_layout()}invalidate_render(){this.render(),this.invalidate_layout()}has_finished(){if(!super.has_finished())return!1;for(const t of this.child_views)if(!t.has_finished())return!1;return!0}notify_finished(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()}_width_policy(){return null!=this.model.width?"fixed":"fit"}_height_policy(){return null!=this.model.height?"fixed":"fit"}box_sizing(){let{width_policy:t,height_policy:i,aspect_ratio:e}=this.model;"auto"==t&&(t=this._width_policy()),"auto"==i&&(i=this._height_policy());const{sizing_mode:s}=this.model;if(null!=s)if("fixed"==s)t=i="fixed";else if("stretch_both"==s)t=i="max";else if("stretch_width"==s)t="max";else if("stretch_height"==s)i="max";else switch(null==e&&(e="auto"),s){case"scale_width":t="max",i="min";break;case"scale_height":t="min",i="max";break;case"scale_both":t="max",i="max"}const o={width_policy:t,height_policy:i},{min_width:l,min_height:n}=this.model;null!=l&&(o.min_width=l),null!=n&&(o.min_height=n);const{width:a,height:_}=this.model;null!=a&&(o.width=a),null!=_&&(o.height=_);const{max_width:r,max_height:d}=this.model;null!=r&&(o.max_width=r),null!=d&&(o.max_height=d),"auto"==e&&null!=a&&null!=_?o.aspect=a/_:h.isNumber(e)&&(o.aspect=e);const{margin:u}=this.model;if(null!=u)if(h.isNumber(u))o.margin={top:u,right:u,bottom:u,left:u};else if(2==u.length){const[t,i]=u;o.margin={top:t,right:i,bottom:t,left:i}}else{const[t,i,e,s]=u;o.margin={top:t,right:i,bottom:e,left:s}}o.visible=this.model.visible;const{align:c}=this.model;return h.isArray(c)?[o.halign,o.valign]=c:o.halign=o.valign=c,o}_viewport_size(){return l.undisplayed(this.el,()=>{let t=this.el;for(;t=t.parentElement;){if(t.classList.contains(d.bk_root))continue;if(t==document.body){const{margin:{left:t,right:i,top:e,bottom:s}}=l.extents(document.body);return{width:Math.ceil(document.documentElement.clientWidth-t-i),height:Math.ceil(document.documentElement.clientHeight-e-s)}}const{padding:{left:i,right:e,top:s,bottom:o}}=l.extents(t),{width:n,height:h}=t.getBoundingClientRect(),a=Math.ceil(n-i-e),_=Math.ceil(h-s-o);if(a>0||_>0)return{width:a>0?a:void 0,height:_>0?_:void 0}}return{}})}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box,children:this.child_views.map(t=>t.serializable_state())})}}e.LayoutDOMView=u,u.__name__="LayoutDOMView";class c extends o.Model{constructor(t){super(t)}static init_LayoutDOM(){this.define({width:[a.Number,null],height:[a.Number,null],min_width:[a.Number,null],min_height:[a.Number,null],max_width:[a.Number,null],max_height:[a.Number,null],margin:[a.Any,[0,0,0,0]],width_policy:[a.Any,"auto"],height_policy:[a.Any,"auto"],aspect_ratio:[a.Any,null],sizing_mode:[a.SizingMode,null],visible:[a.Boolean,!0],disabled:[a.Boolean,!1],align:[a.Any,"start"],background:[a.Color,null],css_classes:[a.Array,[]]})}}e.LayoutDOM=c,c.__name__="LayoutDOM",c.init_LayoutDOM()},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0}),t.bk_root="bk-root"},
function _(t,o,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),e=t(244),n=t(192),l=s.__importStar(t(18));class u extends e.BoxView{_update_layout(){const t=this.child_views.map(t=>t.layout);this.layout=new n.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())}}i.ColumnView=u,u.__name__="ColumnView";class _ extends e.Box{constructor(t){super(t)}static init_Column(){this.prototype.default_view=u,this.define({rows:[l.Any,"auto"]})}}i.Column=_,_.__name__="Column",_.init_Column()},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});const o=t(1),e=t(245),n=t(192),l=o.__importStar(t(18));class r extends e.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.children.change,()=>this.rebuild())}get child_models(){return this.model.children.map(([t])=>t)}_update_layout(){this.layout=new n.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;for(const[t,i,s,o,e]of this.model.children){const n=this._child_views.get(t);this.layout.items.push({layout:n.layout,row:i,col:s,row_span:o,col_span:e})}this.layout.set_sizing(this.box_sizing())}}s.GridBoxView=r,r.__name__="GridBoxView";class a extends e.LayoutDOM{constructor(t){super(t)}static init_GridBox(){this.prototype.default_view=r,this.define({children:[l.Array,[]],rows:[l.Any,"auto"],cols:[l.Any,"auto"],spacing:[l.Any,0]})}}s.GridBox=a,a.__name__="GridBox",a.init_GridBox()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const s=e(245),_=e(188);class n extends s.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new _.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())}}o.HTMLBoxView=n,n.__name__="HTMLBoxView";class i extends s.LayoutDOM{constructor(e){super(e)}}o.HTMLBox=i,i.__name__="HTMLBox"},
function _(t,o,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),e=t(244),_=t(192),a=s.__importStar(t(18));class n extends e.BoxView{_update_layout(){const t=this.child_views.map(t=>t.layout);this.layout=new _.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())}}i.RowView=n,n.__name__="RowView";class l extends e.Box{constructor(t){super(t)}static init_Row(){this.prototype.default_view=n,this.define({cols:[a.Any,"auto"]})}}i.Row=l,l.__name__="Row",l.init_Row()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const i=e(245),s=e(188);class _ extends i.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new s.LayoutItem,this.layout.set_sizing(this.box_sizing())}}a.SpacerView=_,_.__name__="SpacerView";class o extends i.LayoutDOM{constructor(e){super(e)}static init_Spacer(){this.prototype.default_view=_}}a.Spacer=o,o.__name__="Spacer",o.init_Spacer()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),a=e(188),l=e(68),h=e(9),o=i.__importStar(e(18)),c=e(245),d=e(71),r=e(146),n=e(253),_=e(254),b=e(255),p=i.__importDefault(e(256)),u=i.__importDefault(e(257)),m=i.__importDefault(e(258));class v extends c.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.tabs.change,()=>this.rebuild()),this.connect(this.model.properties.active.change,()=>this.on_active_change())}styles(){return[...super.styles(),p.default,u.default,m.default]}get child_models(){return this.model.tabs.map(e=>e.child)}_update_layout(){const e=this.model.tabs_location,t="above"==e||"below"==e,{scroll_el:s,headers_el:i}=this;this.header=new class extends a.ContentBox{_measure(e){const a=l.size(s),o=l.children(i).slice(0,3).map(e=>l.size(e)),{width:c,height:d}=super._measure(e);if(t){const t=a.width+h.sum(o.map(e=>e.width));return{width:e.width!=1/0?e.width:t,height:d}}{const t=a.height+h.sum(o.map(e=>e.height));return{width:c,height:e.height!=1/0?e.height:t}}}}(this.header_el),t?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});let o=1,c=1;switch(e){case"above":o-=1;break;case"below":o+=1;break;case"left":c-=1;break;case"right":c+=1}const d={layout:this.header,row:o,col:c},r=this.child_views.map(e=>({layout:e.layout,row:1,col:1}));this.layout=new a.Grid([d,...r]),this.layout.set_sizing(this.box_sizing())}update_position(){super.update_position(),this.header_el.style.position="absolute",l.position(this.header_el,this.header.bbox);const e=this.model.tabs_location,t="above"==e||"below"==e,s=l.size(this.scroll_el),i=l.scroll_size(this.headers_el);if(t){const{width:e}=this.header.bbox;i.width>e?(this.wrapper_el.style.maxWidth=e-s.width+"px",l.display(this.scroll_el)):(this.wrapper_el.style.maxWidth="",l.undisplay(this.scroll_el))}else{const{height:e}=this.header.bbox;i.height>e?(this.wrapper_el.style.maxHeight=e-s.height+"px",l.display(this.scroll_el)):(this.wrapper_el.style.maxHeight="",l.undisplay(this.scroll_el))}const{child_views:a}=this;for(const e of a)l.hide(e.el);const h=a[this.model.active];null!=h&&l.show(h.el)}render(){super.render();const{active:e}=this.model,t=this.model.tabs_location,s="above"==t||"below"==t,i=this.model.tabs.map((t,s)=>{const i=l.div({class:[n.bk_tab,s==e?r.bk_active:null]},t.title);if(i.addEventListener("click",e=>{e.target==e.currentTarget&&this.change_active(s)}),t.closable){const e=l.div({class:n.bk_close});e.addEventListener("click",e=>{if(e.target==e.currentTarget){this.model.tabs=h.remove_at(this.model.tabs,s);const e=this.model.tabs.length;this.model.active>e-1&&(this.model.active=e-1)}}),i.appendChild(e)}return i});this.headers_el=l.div({class:[n.bk_headers]},i),this.wrapper_el=l.div({class:n.bk_headers_wrapper},this.headers_el);const a=l.div({class:[_.bk_btn,_.bk_btn_default],disabled:""},l.div({class:[b.bk_caret,r.bk_left]})),o=l.div({class:[_.bk_btn,_.bk_btn_default]},l.div({class:[b.bk_caret,r.bk_right]}));let c=0;const d=e=>()=>{const t=this.model.tabs.length;c="left"==e?Math.max(c-1,0):Math.min(c+1,t-1),0==c?a.setAttribute("disabled",""):a.removeAttribute("disabled"),c==t-1?o.setAttribute("disabled",""):o.removeAttribute("disabled");const i=l.children(this.headers_el).slice(0,c).map(e=>e.getBoundingClientRect());if(s){const e=-h.sum(i.map(e=>e.width));this.headers_el.style.left=e+"px"}else{const e=-h.sum(i.map(e=>e.height));this.headers_el.style.top=e+"px"}};a.addEventListener("click",d("left")),o.addEventListener("click",d("right")),this.scroll_el=l.div({class:_.bk_btn_group},a,o),this.header_el=l.div({class:[n.bk_tabs_header,r.bk_side(t)]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)}change_active(e){e!=this.model.active&&(this.model.active=e)}on_active_change(){const e=this.model.active,t=l.children(this.headers_el);for(const e of t)e.classList.remove(r.bk_active);t[e].classList.add(r.bk_active);const{child_views:s}=this;for(const e of s)l.hide(e.el);l.show(s[e].el)}}s.TabsView=v,v.__name__="TabsView";class g extends c.LayoutDOM{constructor(e){super(e)}static init_Tabs(){this.prototype.default_view=v,this.define({tabs:[o.Array,[]],tabs_location:[o.Location,"above"],active:[o.Number,0]})}}s.Tabs=g,g.__name__="Tabs",g.init_Tabs();class w extends d.Model{constructor(e){super(e)}static init_Panel(){this.define({title:[o.String,""],child:[o.Instance],closable:[o.Boolean,!1]})}}s.Panel=w,w.__name__="Panel",w.init_Panel()},
function _(e,b,a){Object.defineProperty(a,"__esModule",{value:!0}),a.bk_tabs_header="bk-tabs-header",a.bk_headers_wrapper="bk-headers-wrapper",a.bk_headers="bk-headers",a.bk_tab="bk-tab",a.bk_close="bk-close"},
function _(n,b,t){Object.defineProperty(t,"__esModule",{value:!0}),t.bk_btn="bk-btn",t.bk_btn_group="bk-btn-group",t.bk_btn_default="bk-btn-default",t.bk_btn_primary="bk-btn-primary",t.bk_btn_success="bk-btn-success",t.bk_btn_warning="bk-btn-warning",t.bk_btn_danger="bk-btn-danger",t.bk_btn_type=function(n){switch(n){case"default":return t.bk_btn_default;case"primary":return t.bk_btn_primary;case"success":return t.bk_btn_success;case"warning":return t.bk_btn_warning;case"danger":return t.bk_btn_danger}},t.bk_dropdown_toggle="bk-dropdown-toggle"},
function _(e,b,d){Object.defineProperty(d,"__esModule",{value:!0}),d.bk_menu="bk-menu",d.bk_caret="bk-caret",d.bk_divider="bk-divider"},
function _(n,o,b){Object.defineProperty(b,"__esModule",{value:!0});b.default="\n.bk-root .bk-btn {\n  height: 100%;\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  white-space: nowrap;\n  cursor: pointer;\n  padding: 6px 12px;\n  font-size: 12px;\n  border: 1px solid transparent;\n  border-radius: 4px;\n  outline: 0;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-btn:hover,\n.bk-root .bk-btn:focus {\n  text-decoration: none;\n}\n.bk-root .bk-btn:active,\n.bk-root .bk-btn.bk-active {\n  background-image: none;\n  box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n}\n.bk-root .bk-btn[disabled] {\n  cursor: not-allowed;\n  pointer-events: none;\n  opacity: 0.65;\n  box-shadow: none;\n}\n.bk-root .bk-btn-default {\n  color: #333;\n  background-color: #fff;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-default:hover {\n  background-color: #f5f5f5;\n  border-color: #b8b8b8;\n}\n.bk-root .bk-btn-default.bk-active {\n  background-color: #ebebeb;\n  border-color: #adadad;\n}\n.bk-root .bk-btn-default[disabled],\n.bk-root .bk-btn-default[disabled]:hover,\n.bk-root .bk-btn-default[disabled]:focus,\n.bk-root .bk-btn-default[disabled]:active,\n.bk-root .bk-btn-default[disabled].bk-active {\n  background-color: #e6e6e6;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-primary {\n  color: #fff;\n  background-color: #428bca;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-primary:hover {\n  background-color: #3681c1;\n  border-color: #2c699e;\n}\n.bk-root .bk-btn-primary.bk-active {\n  background-color: #3276b1;\n  border-color: #285e8e;\n}\n.bk-root .bk-btn-primary[disabled],\n.bk-root .bk-btn-primary[disabled]:hover,\n.bk-root .bk-btn-primary[disabled]:focus,\n.bk-root .bk-btn-primary[disabled]:active,\n.bk-root .bk-btn-primary[disabled].bk-active {\n  background-color: #506f89;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-success {\n  color: #fff;\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-success:hover {\n  background-color: #4eb24e;\n  border-color: #409240;\n}\n.bk-root .bk-btn-success.bk-active {\n  background-color: #47a447;\n  border-color: #398439;\n}\n.bk-root .bk-btn-success[disabled],\n.bk-root .bk-btn-success[disabled]:hover,\n.bk-root .bk-btn-success[disabled]:focus,\n.bk-root .bk-btn-success[disabled]:active,\n.bk-root .bk-btn-success[disabled].bk-active {\n  background-color: #667b66;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-warning {\n  color: #fff;\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-warning:hover {\n  background-color: #eea43b;\n  border-color: #e89014;\n}\n.bk-root .bk-btn-warning.bk-active {\n  background-color: #ed9c28;\n  border-color: #d58512;\n}\n.bk-root .bk-btn-warning[disabled],\n.bk-root .bk-btn-warning[disabled]:hover,\n.bk-root .bk-btn-warning[disabled]:focus,\n.bk-root .bk-btn-warning[disabled]:active,\n.bk-root .bk-btn-warning[disabled].bk-active {\n  background-color: #c89143;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-danger {\n  color: #fff;\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-danger:hover {\n  background-color: #d5433e;\n  border-color: #bd2d29;\n}\n.bk-root .bk-btn-danger.bk-active {\n  background-color: #d2322d;\n  border-color: #ac2925;\n}\n.bk-root .bk-btn-danger[disabled],\n.bk-root .bk-btn-danger[disabled]:hover,\n.bk-root .bk-btn-danger[disabled]:focus,\n.bk-root .bk-btn-danger[disabled]:active,\n.bk-root .bk-btn-danger[disabled].bk-active {\n  background-color: #a55350;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-group {\n  height: 100%;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-btn-group > .bk-btn {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n}\n.bk-root .bk-btn-group > .bk-btn + .bk-btn {\n  margin-left: -1px;\n}\n.bk-root .bk-btn-group > .bk-btn:first-child:not(:last-child) {\n  border-bottom-right-radius: 0;\n  border-top-right-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):last-child {\n  border-bottom-left-radius: 0;\n  border-top-left-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child) {\n  border-radius: 0;\n}\n.bk-root .bk-btn-group .bk-dropdown-toggle {\n  flex: 0 0 0;\n  -webkit-flex: 0 0 0;\n  padding: 6px 6px;\n}\n"},
function _(n,o,r){Object.defineProperty(r,"__esModule",{value:!0});r.default="\n.bk-root .bk-menu-icon {\n  width: 28px;\n  height: 28px;\n  background-size: 60%;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-context-menu {\n  position: absolute;\n  display: inline-flex;\n  display: -webkit-inline-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  width: auto;\n  height: auto;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-context-menu.bk-horizontal {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-context-menu.bk-vertical {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-context-menu > .bk-divider {\n  cursor: default;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-context-menu.bk-horizontal > .bk-divider {\n  width: 1px;\n  margin: 5px 0;\n}\n.bk-root .bk-context-menu.bk-vertical > .bk-divider {\n  height: 1px;\n  margin: 0 5px;\n}\n.bk-root .bk-context-menu > :not(.bk-divider) {\n  border: 1px solid transparent;\n}\n.bk-root .bk-context-menu > :not(.bk-divider).bk-active {\n  border-color: #26aae1;\n}\n.bk-root .bk-context-menu > :not(.bk-divider):hover {\n  background-color: #f9f9f9;\n}\n.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child {\n  border-top-left-radius: 4px;\n  border-bottom-left-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child {\n  border-top-right-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child {\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child {\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n.bk-root .bk-menu {\n  position: absolute;\n  left: 0;\n  width: 100%;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-menu.bk-above {\n  bottom: 100%;\n}\n.bk-root .bk-menu.bk-below {\n  top: 100%;\n}\n.bk-root .bk-menu > .bk-divider {\n  height: 1px;\n  margin: 7.5px 0;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-menu > :not(.bk-divider) {\n  padding: 6px 12px;\n}\n.bk-root .bk-menu > :not(.bk-divider):hover,\n.bk-root .bk-menu > :not(.bk-divider).bk-active {\n  background-color: #e6e6e6;\n}\n.bk-root .bk-caret {\n  display: inline-block;\n  vertical-align: middle;\n  width: 0;\n  height: 0;\n  margin: 0 5px;\n}\n.bk-root .bk-caret.bk-down {\n  border-top: 4px solid;\n}\n.bk-root .bk-caret.bk-up {\n  border-bottom: 4px solid;\n}\n.bk-root .bk-caret.bk-down,\n.bk-root .bk-caret.bk-up {\n  border-right: 4px solid transparent;\n  border-left: 4px solid transparent;\n}\n.bk-root .bk-caret.bk-left {\n  border-right: 4px solid;\n}\n.bk-root .bk-caret.bk-right {\n  border-left: 4px solid;\n}\n.bk-root .bk-caret.bk-left,\n.bk-root .bk-caret.bk-right {\n  border-top: 4px solid transparent;\n  border-bottom: 4px solid transparent;\n}\n"},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});n.default='\n.bk-root .bk-tabs-header {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  overflow: hidden;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-tabs-header .bk-btn-group {\n  height: auto;\n  margin-right: 5px;\n}\n.bk-root .bk-tabs-header .bk-btn-group > .bk-btn {\n  flex-grow: 0;\n  -webkit-flex-grow: 0;\n  height: auto;\n  padding: 4px 4px;\n}\n.bk-root .bk-tabs-header .bk-headers-wrapper {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  overflow: hidden;\n  color: #666666;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper {\n  border-bottom: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper {\n  border-left: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper {\n  border-top: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper {\n  border-right: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-above,\n.bk-root .bk-tabs-header.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers,\n.bk-root .bk-tabs-header.bk-below .bk-headers {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-left,\n.bk-root .bk-tabs-header.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers,\n.bk-root .bk-tabs-header.bk-right .bk-headers {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header .bk-headers {\n  position: relative;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n}\n.bk-root .bk-tabs-header .bk-tab {\n  padding: 4px 8px;\n  border: solid transparent;\n  white-space: nowrap;\n  cursor: pointer;\n}\n.bk-root .bk-tabs-header .bk-tab:hover {\n  background-color: #f2f2f2;\n}\n.bk-root .bk-tabs-header .bk-tab.bk-active {\n  color: #4d4d4d;\n  background-color: white;\n  border-color: #e6e6e6;\n}\n.bk-root .bk-tabs-header .bk-tab .bk-close {\n  margin-left: 10px;\n}\n.bk-root .bk-tabs-header.bk-above .bk-tab {\n  border-width: 3px 1px 0px 1px;\n  border-radius: 4px 4px 0 0;\n}\n.bk-root .bk-tabs-header.bk-right .bk-tab {\n  border-width: 1px 3px 1px 0px;\n  border-radius: 0 4px 4px 0;\n}\n.bk-root .bk-tabs-header.bk-below .bk-tab {\n  border-width: 0px 1px 3px 1px;\n  border-radius: 0 0 4px 4px;\n}\n.bk-root .bk-tabs-header.bk-left .bk-tab {\n  border-width: 1px 0px 1px 3px;\n  border-radius: 4px 0 0 4px;\n}\n.bk-root .bk-close {\n  display: inline-block;\n  width: 10px;\n  height: 10px;\n  vertical-align: middle;\n  background-image: url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>      </svg>\');\n}\n.bk-root .bk-close:hover {\n  background-image: url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>      </svg>\');\n}\n'},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const o=e(247);class _ extends o.ColumnView{}i.WidgetBoxView=_,_.__name__="WidgetBoxView";class n extends o.Column{constructor(e){super(e)}static init_WidgetBox(){this.prototype.default_view=_}}i.WidgetBox=n,n.__name__="WidgetBox",n.init_WidgetBox()},
function _(r,a,o){Object.defineProperty(o,"__esModule",{value:!0});var e=r(261);o.CategoricalColorMapper=e.CategoricalColorMapper;var p=r(263);o.CategoricalMarkerMapper=p.CategoricalMarkerMapper;var l=r(264);o.CategoricalPatternMapper=l.CategoricalPatternMapper;var C=r(116);o.ContinuousColorMapper=C.ContinuousColorMapper;var M=r(117);o.ColorMapper=M.ColorMapper;var t=r(115);o.LinearColorMapper=t.LinearColorMapper;var i=r(265);o.LogColorMapper=i.LogColorMapper},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});const o=r(1),a=r(262),c=r(117),i=o.__importStar(r(18));class s extends c.ColorMapper{constructor(r){super(r)}static init_CategoricalColorMapper(){this.define({factors:[i.Array],start:[i.Number,0],end:[i.Number]})}_v_compute(r,t,e,{nan_color:o}){a.cat_v_compute(r,this.factors,e,t,this.start,this.end,o)}}e.CategoricalColorMapper=s,s.__name__="CategoricalColorMapper",s.init_CategoricalColorMapper()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const l=e(12),i=e(8);function u(e,n){if(e.length!=n.length)return!1;for(let t=0,l=e.length;t<l;t++)if(e[t]!==n[t])return!1;return!0}t._cat_equals=u,t.cat_v_compute=function(e,n,t,c,f,o,r){for(let _=0,g=e.length;_<g;_++){let g,s,d=e[_];i.isString(d)?g=l.index_of(n,d):(null!=f?d=null!=o?d.slice(f,o):d.slice(f):null!=o&&(d=d.slice(0,o)),g=1==d.length?l.index_of(n,d[0]):l.find_index(n,e=>u(e,d))),s=g<0||g>=t.length?r:t[g],c[_]=s}}},
function _(r,e,a){Object.defineProperty(a,"__esModule",{value:!0});const t=r(1),s=r(262),i=r(118),c=t.__importStar(r(18));class n extends i.Mapper{constructor(r){super(r)}static init_CategoricalMarkerMapper(){this.define({factors:[c.Array],markers:[c.Array],start:[c.Number,0],end:[c.Number],default_value:[c.MarkerType,"circle"]})}v_compute(r){const e=new Array(r.length);return s.cat_v_compute(r,this.factors,this.markers,e,this.start,this.end,this.default_value),e}}a.CategoricalMarkerMapper=n,n.__name__="CategoricalMarkerMapper",n.init_CategoricalMarkerMapper()},
function _(t,e,a){Object.defineProperty(a,"__esModule",{value:!0});const r=t(1),n=t(262),s=t(118),i=r.__importStar(t(18));class c extends s.Mapper{constructor(t){super(t)}static init_CategoricalPatternMapper(){this.define({factors:[i.Array],patterns:[i.Array],start:[i.Number,0],end:[i.Number],default_value:[i.HatchPatternType," "]})}v_compute(t){const e=new Array(t.length);return n.cat_v_compute(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e}}a.CategoricalPatternMapper=c,c.__name__="CategoricalPatternMapper",c.init_CategoricalPatternMapper()},
function _(o,l,n){Object.defineProperty(n,"__esModule",{value:!0});const t=o(116),e=o(12);class i extends t.ContinuousColorMapper{constructor(o){super(o)}_v_compute(o,l,n,t){const{nan_color:i,low_color:h,high_color:c}=t,r=n.length,s=null!=this.low?this.low:e.min(o),u=null!=this.high?this.high:e.max(o),a=r/(Math.log(u)-Math.log(s)),g=n.length-1;for(let t=0,e=o.length;t<e;t++){const e=o[t];if(isNaN(e)){l[t]=i;continue}if(e>u){l[t]=null!=c?c:n[g];continue}if(e==u){l[t]=n[g];continue}if(e<s){l[t]=null!=h?h:n[0];continue}const r=Math.log(e)-Math.log(s);let _=Math.floor(r*a);_>g&&(_=g),l[t]=n[_]}}}n.LogColorMapper=i,i.__name__="LogColorMapper"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0}),e(1).__exportStar(e(267),t);var a=e(268);t.Marker=a.Marker;var _=e(269);t.Scatter=_.Scatter},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const i=e(268),r=Math.sqrt(3);function n(e,t){e.rotate(Math.PI/4),c(e,t),e.rotate(-Math.PI/4)}function s(e,t){const o=t*r,i=o/3;e.moveTo(-o/2,-i),e.lineTo(0,0),e.lineTo(o/2,-i),e.lineTo(0,0),e.lineTo(0,t)}function c(e,t){e.moveTo(0,t),e.lineTo(0,-t),e.moveTo(-t,0),e.lineTo(t,0)}function l(e,t){e.moveTo(0,t),e.lineTo(t/1.5,0),e.lineTo(0,-t),e.lineTo(-t/1.5,0),e.closePath()}function a(e,t){const o=t*r,i=o/3;e.moveTo(-t,i),e.lineTo(t,i),e.lineTo(0,i-o),e.closePath()}function u(e,t,o,i,r){c(e,o),n(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function d(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function v(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),c(e,o),e.stroke())}function _(e,t,o,i,r){d(e,t,o,i,r),m(e,t,o,i,r)}function f(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),s(e,o),e.stroke())}function T(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),n(e,o),e.stroke())}function z(e,t,o,i,r){c(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function k(e,t,o,i,r){l(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function C(e,t,o,i,r){l(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.moveTo(0,o),e.lineTo(0,-o),e.moveTo(-o/1.5,0),e.lineTo(o/1.5,0),e.stroke())}function h(e,t,o,i,r){k(e,t,o,i,r),m(e,t,o,i,r)}function m(e,t,o,i,r){!function(e,t){e.beginPath(),e.arc(0,0,t/4,0,2*Math.PI,!1),e.closePath()}(e,o),i.set_vectorize(e,t),e.fillStyle=e.strokeStyle,e.fill()}function P(e,t,o,i,n){!function(e,t){const o=t/2,i=r*o;e.moveTo(t,0),e.lineTo(o,-i),e.lineTo(-o,-i),e.lineTo(-t,0),e.lineTo(-o,i),e.lineTo(o,i),e.closePath()}(e,o),n.doit&&(n.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function q(e,t,o,i,r){P(e,t,o,i,r),m(e,t,o,i)}function D(e,t,o,i,r){e.rotate(Math.PI),a(e,o),e.rotate(-Math.PI),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function g(e,t,o,i,r){const n=3*o/8,s=[n,n,o,o,n,n,-n,-n,-o,-o,-n,-n],c=[o,n,n,-n,-n,-o,-o,-n,-n,n,n,o];for(e.moveTo(s[0],c[0]),t=1;t<12;t++)e.lineTo(s[t],c[t]);e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function M(e,t,o,i,r){const n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function S(e,t,o,i,r){const n=3*o/8;e.moveTo(-o,-o),e.quadraticCurveTo(0,-n,o,-o),e.quadraticCurveTo(n,0,o,o),e.quadraticCurveTo(0,n,-o,o),e.quadraticCurveTo(-n,0,-o,-o),e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function x(e,t,o,i,r){const n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),c(e,o),e.stroke())}function I(e,t,o,i,r){M(e,t,o,i,r),m(e,t,o,i)}function p(e,t,o,i,r){const n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.moveTo(-o,o),e.lineTo(o,-o),e.moveTo(-o,-o),e.lineTo(o,o),e.stroke())}function y(e,t,o,i,r){a(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function X(e,t,o,i,r){y(e,t,o,i,r),m(e,t,o,i)}function H(e,t,o,i,n){const s=o*r,c=s/3,l=3*c/8;e.moveTo(-o,c),e.quadraticCurveTo(0,l,o,c),e.quadraticCurveTo(r*l/2,l/2,0,c-s),e.quadraticCurveTo(-r*l/2,l/2,-o,c),e.closePath(),n.doit&&(n.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function Y(e,t,o,i,r){!function(e,t){e.moveTo(-t,0),e.lineTo(t,0)}(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function b(e,t,o,i,r){n(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function w(e,t,o,i,r){s(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function A(e,t){var o;const r=class extends i.MarkerView{static initClass(){this.prototype._render_one=t}};r.initClass();const n=((o=class extends i.Marker{static initClass(){this.prototype.default_view=r}}).__name__=e,o);return n.initClass(),n}o.Asterisk=A("Asterisk",u),o.CircleCross=A("CircleCross",v),o.CircleDot=A("CircleDot",_),o.CircleY=A("CircleY",f),o.CircleX=A("CircleX",T),o.Cross=A("Cross",z),o.Dash=A("Dash",Y),o.Diamond=A("Diamond",k),o.DiamondCross=A("DiamondCross",C),o.DiamondDot=A("DiamondDot",h),o.Dot=A("Dot",m),o.Hex=A("Hex",P),o.HexDot=A("HexDot",q),o.InvertedTriangle=A("InvertedTriangle",D),o.Plus=A("Plus",g),o.Square=A("Square",M),o.SquareCross=A("SquareCross",x),o.SquareDot=A("SquareDot",I),o.SquarePin=A("SquarePin",S),o.SquareX=A("SquareX",p),o.Triangle=A("Triangle",y),o.TriangleDot=A("TriangleDot",X),o.TrianglePin=A("TrianglePin",H),o.X=A("X",b),o.Y=A("Y",w),o.marker_funcs={asterisk:u,circle:d,circle_cross:v,circle_dot:_,circle_y:f,circle_x:T,cross:z,diamond:k,diamond_dot:h,diamond_cross:C,dot:m,hex:P,hex_dot:q,inverted_triangle:D,plus:g,square:M,square_cross:x,square_dot:I,square_pin:S,square_x:p,triangle:y,triangle_dot:X,triangle_pin:H,dash:Y,x:b,y:w}},
function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const i=e(1),r=e(84),n=e(23),a=i.__importStar(e(93)),_=i.__importStar(e(18)),h=e(9),c=e(79);class o extends r.XYGlyphView{_render(e,s,{sx:t,sy:i,_size:r,_angle:n}){for(const a of s){if(isNaN(t[a]+i[a]+r[a]+n[a]))continue;const s=r[a]/2;e.beginPath(),e.translate(t[a],i[a]),n[a]&&e.rotate(n[a]),this._render_one(e,a,s,this.visuals.line,this.visuals.fill),n[a]&&e.rotate(-n[a]),e.translate(-t[a],-i[a])}}_mask_data(){const e=this.renderer.plot_view.frame.bbox.h_range,s=e.start-this.max_size,t=e.end+this.max_size,[i,r]=this.renderer.xscale.r_invert(s,t),n=this.renderer.plot_view.frame.bbox.v_range,a=n.start-this.max_size,_=n.end+this.max_size,[h,c]=this.renderer.yscale.r_invert(a,_);return this.index.indices({x0:i,x1:r,y0:h,y1:c})}_hit_point(e){const{sx:s,sy:t}=e,i=s-this.max_size,r=s+this.max_size,[n,a]=this.renderer.xscale.r_invert(i,r),_=t-this.max_size,h=t+this.max_size,[o,x]=this.renderer.yscale.r_invert(_,h),l=this.index.indices({x0:n,x1:a,y0:o,y1:x}),d=[];for(const e of l){const i=this._size[e]/2,r=Math.abs(this.sx[e]-s)+Math.abs(this.sy[e]-t);Math.abs(this.sx[e]-s)<=i&&Math.abs(this.sy[e]-t)<=i&&d.push([e,r])}return c.Selection.from_hits(d)}_hit_span(e){const{sx:s,sy:t}=e,i=this.bounds(),r=this.max_size/2;let n,a,_,h;if("h"==e.direction){_=i.y0,h=i.y1;const e=s-r,t=s+r;[n,a]=this.renderer.xscale.r_invert(e,t)}else{n=i.x0,a=i.x1;const e=t-r,s=t+r;[_,h]=this.renderer.yscale.r_invert(e,s)}const o=this.index.indices({x0:n,x1:a,y0:_,y1:h});return new c.Selection({indices:o})}_hit_rect(e){const{sx0:s,sx1:t,sy0:i,sy1:r}=e,[n,a]=this.renderer.xscale.r_invert(s,t),[_,h]=this.renderer.yscale.r_invert(i,r),o=this.index.indices({x0:n,x1:a,y0:_,y1:h});return new c.Selection({indices:o})}_hit_poly(e){const{sx:s,sy:t}=e,i=h.range(0,this.sx.length),r=[];for(let e=0,n=i.length;e<n;e++){const n=i[e];a.point_in_poly(this.sx[e],this.sy[e],s,t)&&r.push(n)}return new c.Selection({indices:r})}draw_legend_for_index(e,{x0:s,x1:t,y0:i,y1:r},n){const a=n+1,_=new Array(a);_[n]=(s+t)/2;const h=new Array(a);h[n]=(i+r)/2;const c=new Array(a);c[n]=.4*Math.min(Math.abs(t-s),Math.abs(r-i));const o=new Array(a);o[n]=0,this._render(e,[n],{sx:_,sy:h,_size:c,_angle:o})}}t.MarkerView=o,o.__name__="MarkerView";class x extends r.XYGlyph{constructor(e){super(e)}static init_Marker(){this.mixins([n.LineVector,n.FillVector]),this.define({size:[_.DistanceSpec,{units:"screen",value:4}],angle:[_.AngleSpec,0]})}}t.Marker=x,x.__name__="Marker",x.init_Marker()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const a=e(1),s=e(268),n=e(267),i=a.__importStar(e(18));class _ extends s.MarkerView{_render(e,t,{sx:r,sy:a,_size:s,_angle:i,_marker:_}){for(const c of t){if(isNaN(r[c]+a[c]+s[c]+i[c])||null==_[c])continue;const t=s[c]/2;e.beginPath(),e.translate(r[c],a[c]),i[c]&&e.rotate(i[c]),n.marker_funcs[_[c]](e,c,t,this.visuals.line,this.visuals.fill),i[c]&&e.rotate(-i[c]),e.translate(-r[c],-a[c])}}draw_legend_for_index(e,{x0:t,x1:r,y0:a,y1:s},n){const i=n+1,_=new Array(i);_[n]=(t+r)/2;const c=new Array(i);c[n]=(a+s)/2;const o=new Array(i);o[n]=.4*Math.min(Math.abs(r-t),Math.abs(s-a));const l=new Array(i);l[n]=0;const u=new Array(i);u[n]=this._marker[n],this._render(e,[n],{sx:_,sy:c,_size:o,_angle:l,_marker:u})}}r.ScatterView=_,_.__name__="ScatterView";class c extends s.Marker{constructor(e){super(e)}static init_Scatter(){this.prototype.default_view=_,this.define({marker:[i.MarkerSpec,{value:"circle"}]})}}r.Scatter=c,c.__name__="Scatter",c.init_Scatter()},
function _(a,o,p){Object.defineProperty(p,"__esModule",{value:!0});var t=a(271);p.MapOptions=t.MapOptions;var e=a(271);p.GMapOptions=e.GMapOptions;var n=a(271);p.GMapPlot=n.GMapPlot;var M=a(272);p.Plot=M.Plot},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const o=t(1),n=t(72),a=t(272),s=o.__importStar(t(18)),p=t(71),r=t(131),_=t(296);i.GMapPlotView=_.GMapPlotView;class l extends p.Model{constructor(t){super(t)}static init_MapOptions(){this.define({lat:[s.Number],lng:[s.Number],zoom:[s.Number,12]})}}i.MapOptions=l,l.__name__="MapOptions",l.init_MapOptions();class c extends l{constructor(t){super(t)}static init_GMapOptions(){this.define({map_type:[s.String,"roadmap"],scale_control:[s.Boolean,!1],styles:[s.String],tilt:[s.Int,45]})}}i.GMapOptions=c,c.__name__="GMapOptions",c.init_GMapOptions();class u extends a.Plot{constructor(t){super(t)}static init_GMapPlot(){this.prototype.default_view=_.GMapPlotView,this.define({map_options:[s.Instance],api_key:[s.String]}),this.override({x_range:()=>new r.Range1d,y_range:()=>new r.Range1d})}initialize(){super.initialize(),this.use_map=!0,this.api_key||n.logger.error("api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.")}}i.GMapPlot=u,u.__name__="GMapPlot",u.init_GMapPlot()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const i=e(1),o=i.__importStar(e(23)),n=i.__importStar(e(18)),s=e(14),a=e(9),l=e(17),_=e(8),h=e(245),c=e(142),u=e(120),d=e(273),b=e(76),g=e(81),p=e(186),m=e(290);r.PlotView=m.PlotView;class f extends h.LayoutDOM{constructor(e){super(e)}static init_Plot(){this.prototype.default_view=m.PlotView,this.mixins([["outline_",o.Line],["background_",o.Fill],["border_",o.Fill]]),this.define({toolbar:[n.Instance,()=>new d.Toolbar],toolbar_location:[n.Location,"right"],toolbar_sticky:[n.Boolean,!0],plot_width:[n.Number,600],plot_height:[n.Number,600],frame_width:[n.Number,null],frame_height:[n.Number,null],title:[n.Any,()=>new c.Title({text:""})],title_location:[n.Location,"above"],above:[n.Array,[]],below:[n.Array,[]],left:[n.Array,[]],right:[n.Array,[]],center:[n.Array,[]],renderers:[n.Array,[]],x_range:[n.Instance,()=>new p.DataRange1d],extra_x_ranges:[n.Any,{}],y_range:[n.Instance,()=>new p.DataRange1d],extra_y_ranges:[n.Any,{}],x_scale:[n.Instance,()=>new u.LinearScale],y_scale:[n.Instance,()=>new u.LinearScale],lod_factor:[n.Number,10],lod_interval:[n.Number,300],lod_threshold:[n.Number,2e3],lod_timeout:[n.Number,500],hidpi:[n.Boolean,!0],output_backend:[n.OutputBackend,"canvas"],min_border:[n.Number,5],min_border_top:[n.Number,null],min_border_left:[n.Number,null],min_border_bottom:[n.Number,null],min_border_right:[n.Number,null],inner_width:[n.Number],inner_height:[n.Number],outer_width:[n.Number],outer_height:[n.Number],match_aspect:[n.Boolean,!1],aspect_scale:[n.Number,1],reset_policy:[n.ResetPolicy,"standard"]}),this.override({outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})}get width(){const e=this.properties.width.get_value();return null!=e?e:this.plot_width}set width(e){this.setv({width:e,plot_width:e})}get height(){const e=this.properties.height.get_value();return null!=e?e:this.plot_height}set height(e){this.setv({height:e,plot_height:e})}_doc_attached(){super._doc_attached(),this._push_changes([[this.properties.inner_height,null,this.inner_height],[this.properties.inner_width,null,this.inner_width]])}initialize(){super.initialize(),this.reset=new s.Signal0(this,"reset");for(const e of l.values(this.extra_x_ranges).concat(this.x_range)){let t=e.plots;_.isArray(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}for(const e of l.values(this.extra_y_ranges).concat(this.y_range)){let t=e.plots;_.isArray(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}}add_layout(e,t="center"){const r=this.properties[t].get_value();this.setv({[t]:[...r,e]})}remove_layout(e){const t=t=>{a.remove_by(t,t=>t==e)};t(this.left),t(this.right),t(this.above),t(this.below),t(this.center)}add_renderers(...e){this.renderers=this.renderers.concat(e)}add_glyph(e,t=new b.ColumnDataSource,r={}){const i=Object.assign(Object.assign({},r),{data_source:t,glyph:e}),o=new g.GlyphRenderer(i);return this.add_renderers(o),o}add_tools(...e){this.toolbar.tools=this.toolbar.tools.concat(e)}get panels(){return[...this.side_panels,...this.center]}get side_panels(){const{above:e,below:t,left:r,right:i}=this;return a.concat([e,t,r,i])}}r.Plot=f,f.__name__="Plot",f.init_Plot()},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1).__importStar(t(18)),c=t(8),o=t(9),n=t(274),a=t(283),l=t=>{switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null},r=t=>"tap"==t||"pan"==t;class _ extends a.ToolbarBase{constructor(t){super(t)}static init_Toolbar(){this.prototype.default_view=a.ToolbarBaseView,this.define({active_drag:[i.Any,"auto"],active_inspect:[i.Any,"auto"],active_scroll:[i.Any,"auto"],active_tap:[i.Any,"auto"],active_multi:[i.Any,null]})}connect_signals(){super.connect_signals();const{tools:t,active_drag:s,active_inspect:e,active_scroll:i,active_tap:c,active_multi:o}=this.properties;this.on_change([t,s,e,i,c,o],()=>this._init_tools())}_init_tools(){if(super._init_tools(),"auto"==this.active_inspect);else if(this.active_inspect instanceof n.InspectTool){let t=!1;for(const s of this.inspectors)s!=this.active_inspect?s.active=!1:t=!0;t||(this.active_inspect=null)}else if(c.isArray(this.active_inspect)){const t=o.intersection(this.active_inspect,this.inspectors);t.length!=this.active_inspect.length&&(this.active_inspect=t);for(const t of this.inspectors)o.includes(this.active_inspect,t)||(t.active=!1)}else if(null==this.active_inspect)for(const t of this.inspectors)t.active=!1;const t=t=>{t.active?this._active_change(t):t.active=!0};for(const t in this.gestures){const s=this.gestures[t];s.tools=o.sort_by(s.tools,t=>t.default_order);for(const t of s.tools)this.connect(t.properties.active.change,()=>this._active_change(t))}for(const s in this.gestures){const e=l(s);if(e){const i=this[e];if("auto"==i){const e=this.gestures[s];0!=e.tools.length&&r(s)&&t(e.tools[0])}else null!=i&&(o.includes(this.tools,i)?t(i):this[e]=null)}}}}e.Toolbar=_,_.__name__="Toolbar",_.init_Toolbar()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const n=e(1),s=e(275),i=e(282),_=n.__importStar(e(18));class c extends s.ButtonToolView{}o.InspectToolView=c,c.__name__="InspectToolView";class l extends s.ButtonTool{constructor(e){super(e),this.event_type="move"}static init_InspectTool(){this.prototype.button_view=i.OnOffButtonView,this.define({toggleable:[_.Boolean,!0]}),this.override({active:!0})}}o.InspectTool=l,l.__name__="InspectTool",l.init_InspectTool()},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});const i=t(1),s=i.__importDefault(t(276)),n=t(66),l=t(277),r=t(68),a=i.__importStar(t(18)),u=t(24),_=t(8),h=t(9),c=t(278),m=i.__importDefault(t(279)),d=i.__importDefault(t(280)),p=i.__importDefault(t(257)),f=t(281);class g extends n.DOMView{initialize(){super.initialize();const t=this.model.menu;if(null!=t){const e=this.parent.model.toolbar_location,o="left"==e||"above"==e,i=this.parent.model.horizontal?"vertical":"horizontal";this._menu=new f.ContextMenu(o?h.reversed(t):t,{orientation:i,prevent_hide:t=>t.target==this.el})}this._hammer=new s.default(this.el,{touchAction:"auto",inputClass:s.default.TouchMouseInput}),this.connect(this.model.change,()=>this.render()),this._hammer.on("tap",t=>{var e;(null===(e=this._menu)||void 0===e?void 0:e.is_open)?this._menu.hide():t.target==this.el&&this._clicked()}),this._hammer.on("press",()=>this._pressed())}remove(){var t;this._hammer.destroy(),null===(t=this._menu)||void 0===t||t.remove(),super.remove()}styles(){return[...super.styles(),m.default,d.default,p.default]}css_classes(){return super.css_classes().concat(c.bk_toolbar_button)}render(){r.empty(this.el);const t=this.model.computed_icon;_.isString(t)&&(u.startsWith(t,"data:image")?this.el.style.backgroundImage="url('"+t+"')":this.el.classList.add(t)),this.el.title=this.model.tooltip,null!=this._menu&&this.root.el.appendChild(this._menu.el)}_pressed(){var t;const{left:e,top:o,right:i,bottom:s}=this.el.getBoundingClientRect(),n=(()=>{switch(this.parent.model.toolbar_location){case"right":return{right:e,top:o};case"left":return{left:i,top:o};case"above":return{left:e,top:s};case"below":return{left:e,bottom:o}}})();null===(t=this._menu)||void 0===t||t.toggle(n)}}o.ButtonToolButtonView=g,g.__name__="ButtonToolButtonView";class v extends l.ToolView{}o.ButtonToolView=v,v.__name__="ButtonToolView";class b extends l.Tool{constructor(t){super(t)}static init_ButtonTool(){this.internal({disabled:[a.Boolean,!1]})}get tooltip(){return this.tool_name}get computed_icon(){return this.icon}get menu(){return null}}o.ButtonTool=b,b.__name__="ButtonTool",b.init_ButtonTool()},
function _(t,e,n){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,n,i,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=n.createElement("div"),h=Math.round,u=Math.abs,c=Date.now;function l(t,e,n){return setTimeout(y(t,n),e)}function p(t,e,n){return!!Array.isArray(t)&&(f(t,n[e],n),!0)}function f(t,e,n){var i;if(t)if(t.forEach)t.forEach(e,n);else if(void 0!==t.length)for(i=0;i<t.length;)e.call(n,t[i],i,t),i++;else for(i in t)t.hasOwnProperty(i)&&e.call(n,t[i],i,t)}function v(e,n,i){var r="DEPRECATED METHOD: "+n+"\n"+i+" AT \n";return function(){var n=new Error("get-stack-trace"),i=n&&n.stack?n.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,i),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(null==t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),n=1;n<arguments.length;n++){var i=arguments[n];if(null!=i)for(var r in i)i.hasOwnProperty(r)&&(e[r]=i[r])}return e}:Object.assign;var d=v((function(t,e,n){for(var i=Object.keys(e),r=0;r<i.length;)(!n||n&&void 0===t[i[r]])&&(t[i[r]]=e[i[r]]),r++;return t}),"extend","Use `assign`."),m=v((function(t,e){return d(t,e,!0)}),"merge","Use `assign`.");function g(t,e,n){var i,r=e.prototype;(i=t.prototype=Object.create(r)).constructor=t,i._super=r,n&&s(i,n)}function y(t,e){return function(){return t.apply(e,arguments)}}function T(t,e){return"function"==typeof t?t.apply(e&&e[0]||void 0,e):t}function E(t,e){return void 0===t?e:t}function I(t,e,n){f(S(e),(function(e){t.addEventListener(e,n,!1)}))}function A(t,e,n){f(S(e),(function(e){t.removeEventListener(e,n,!1)}))}function _(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function b(t,e,n){if(t.indexOf&&!n)return t.indexOf(e);for(var i=0;i<t.length;){if(n&&t[i][n]==e||!n&&t[i]===e)return i;i++}return-1}function x(t){return Array.prototype.slice.call(t,0)}function P(t,e,n){for(var i=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];b(r,o)<0&&i.push(t[s]),r[s]=o,s++}return n&&(i=e?i.sort((function(t,n){return t[e]>n[e]})):i.sort()),i}function D(t,e){for(var n,i,r=e[0].toUpperCase()+e.slice(1),s=0;s<o.length;){if((i=(n=o[s])?n+r:e)in t)return i;s++}}var w=1;function O(e){var n=e.ownerDocument||e;return n.defaultView||n.parentWindow||t}var R="ontouchstart"in t,M=void 0!==D(t,"PointerEvent"),z=R&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),N=["x","y"],X=["clientX","clientY"];function Y(t,e){var n=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){T(t.options.enable,[t])&&n.handler(e)},this.init()}function F(t,e,n){var i=n.pointers.length,r=n.changedPointers.length,s=1&e&&i-r==0,o=12&e&&i-r==0;n.isFirst=!!s,n.isFinal=!!o,s&&(t.session={}),n.eventType=e,function(t,e){var n=t.session,i=e.pointers,r=i.length;n.firstInput||(n.firstInput=W(e));r>1&&!n.firstMultiple?n.firstMultiple=W(e):1===r&&(n.firstMultiple=!1);var s=n.firstInput,o=n.firstMultiple,a=o?o.center:s.center,h=e.center=q(i);e.timeStamp=c(),e.deltaTime=e.timeStamp-s.timeStamp,e.angle=U(a,h),e.distance=L(a,h),function(t,e){var n=e.center,i=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},i=t.offsetDelta={x:n.x,y:n.y});e.deltaX=r.x+(n.x-i.x),e.deltaY=r.y+(n.y-i.y)}(n,e),e.offsetDirection=H(e.deltaX,e.deltaY);var l=k(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=l.x,e.overallVelocityY=l.y,e.overallVelocity=u(l.x)>u(l.y)?l.x:l.y,e.scale=o?(p=o.pointers,f=i,L(f[0],f[1],X)/L(p[0],p[1],X)):1,e.rotation=o?function(t,e){return U(e[1],e[0],X)+U(t[1],t[0],X)}(o.pointers,i):0,e.maxPointers=n.prevInput?e.pointers.length>n.prevInput.maxPointers?e.pointers.length:n.prevInput.maxPointers:e.pointers.length,function(t,e){var n,i,r,s,o=t.lastInterval||e,a=e.timeStamp-o.timeStamp;if(8!=e.eventType&&(a>25||void 0===o.velocity)){var h=e.deltaX-o.deltaX,c=e.deltaY-o.deltaY,l=k(a,h,c);i=l.x,r=l.y,n=u(l.x)>u(l.y)?l.x:l.y,s=H(h,c),t.lastInterval=e}else n=o.velocity,i=o.velocityX,r=o.velocityY,s=o.direction;e.velocity=n,e.velocityX=i,e.velocityY=r,e.direction=s}(n,e);var p,f;var v=t.element;_(e.srcEvent.target,v)&&(v=e.srcEvent.target);e.target=v}(t,n),t.emit("hammer.input",n),t.recognize(n),t.session.prevInput=n}function W(t){for(var e=[],n=0;n<t.pointers.length;)e[n]={clientX:h(t.pointers[n].clientX),clientY:h(t.pointers[n].clientY)},n++;return{timeStamp:c(),pointers:e,center:q(e),deltaX:t.deltaX,deltaY:t.deltaY}}function q(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var n=0,i=0,r=0;r<e;)n+=t[r].clientX,i+=t[r].clientY,r++;return{x:h(n/e),y:h(i/e)}}function k(t,e,n){return{x:e/t||0,y:n/t||0}}function H(t,e){return t===e?1:u(t)>=u(e)?t<0?2:4:e<0?8:16}function L(t,e,n){n||(n=N);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return Math.sqrt(i*i+r*r)}function U(t,e,n){n||(n=N);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return 180*Math.atan2(r,i)/Math.PI}Y.prototype={handler:function(){},init:function(){this.evEl&&I(this.element,this.evEl,this.domHandler),this.evTarget&&I(this.target,this.evTarget,this.domHandler),this.evWin&&I(O(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(O(this.element),this.evWin,this.domHandler)}};var V={mousedown:1,mousemove:2,mouseup:4};function j(){this.evEl="mousedown",this.evWin="mousemove mouseup",this.pressed=!1,Y.apply(this,arguments)}g(j,Y,{handler:function(t){var e=V[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:"mouse",srcEvent:t}))}});var G={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},Z={2:"touch",3:"pen",4:"mouse",5:"kinect"},B="pointerdown",$="pointermove pointerup pointercancel";function J(){this.evEl=B,this.evWin=$,Y.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(B="MSPointerDown",$="MSPointerMove MSPointerUp MSPointerCancel"),g(J,Y,{handler:function(t){var e=this.store,n=!1,i=t.type.toLowerCase().replace("ms",""),r=G[i],s=Z[t.pointerType]||t.pointerType,o="touch"==s,a=b(e,t.pointerId,"pointerId");1&r&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):12&r&&(n=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),n&&e.splice(a,1))}});var K={touchstart:1,touchmove:2,touchend:4,touchcancel:8};function Q(){this.evTarget="touchstart",this.evWin="touchstart touchmove touchend touchcancel",this.started=!1,Y.apply(this,arguments)}function tt(t,e){var n=x(t.touches),i=x(t.changedTouches);return 12&e&&(n=P(n.concat(i),"identifier",!0)),[n,i]}g(Q,Y,{handler:function(t){var e=K[t.type];if(1===e&&(this.started=!0),this.started){var n=tt.call(this,t,e);12&e&&n[0].length-n[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}}});var et={touchstart:1,touchmove:2,touchend:4,touchcancel:8};function nt(){this.evTarget="touchstart touchmove touchend touchcancel",this.targetIds={},Y.apply(this,arguments)}function it(t,e){var n=x(t.touches),i=this.targetIds;if(3&e&&1===n.length)return i[n[0].identifier]=!0,[n,n];var r,s,o=x(t.changedTouches),a=[],h=this.target;if(s=n.filter((function(t){return _(t.target,h)})),1===e)for(r=0;r<s.length;)i[s[r].identifier]=!0,r++;for(r=0;r<o.length;)i[o[r].identifier]&&a.push(o[r]),12&e&&delete i[o[r].identifier],r++;return a.length?[P(s.concat(a),"identifier",!0),a]:void 0}g(nt,Y,{handler:function(t){var e=et[t.type],n=it.call(this,t,e);n&&this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}});function rt(){Y.apply(this,arguments);var t=y(this.handler,this);this.touch=new nt(this.manager,t),this.mouse=new j(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function st(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,ot.call(this,e)):12&t&&ot.call(this,e)}function ot(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var n={x:e.clientX,y:e.clientY};this.lastTouches.push(n);var i=this.lastTouches;setTimeout((function(){var t=i.indexOf(n);t>-1&&i.splice(t,1)}),2500)}}function at(t){for(var e=t.srcEvent.clientX,n=t.srcEvent.clientY,i=0;i<this.lastTouches.length;i++){var r=this.lastTouches[i],s=Math.abs(e-r.x),o=Math.abs(n-r.y);if(s<=25&&o<=25)return!0}return!1}g(rt,Y,{handler:function(t,e,n){var i="touch"==n.pointerType,r="mouse"==n.pointerType;if(!(r&&n.sourceCapabilities&&n.sourceCapabilities.firesTouchEvents)){if(i)st.call(this,e,n);else if(r&&at.call(this,n))return;this.callback(t,e,n)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var ht=D(a.style,"touchAction"),ut=void 0!==ht,ct=function(){if(!ut)return!1;var e={},n=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(i){e[i]=!n||t.CSS.supports("touch-action",i)})),e}();function lt(t,e){this.manager=t,this.set(e)}lt.prototype={set:function(t){"compute"==t&&(t=this.compute()),ut&&this.manager.element.style&&ct[t]&&(this.manager.element.style[ht]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return f(this.manager.recognizers,(function(e){T(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(C(t,"none"))return"none";var e=C(t,"pan-x"),n=C(t,"pan-y");if(e&&n)return"none";if(e||n)return e?"pan-x":"pan-y";if(C(t,"manipulation"))return"manipulation";return"auto"}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,n=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var i=this.actions,r=C(i,"none")&&!ct.none,s=C(i,"pan-y")&&!ct["pan-y"],o=C(i,"pan-x")&&!ct["pan-x"];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&6&n||o&&24&n?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};function pt(t){this.options=s({},this.defaults,t||{}),this.id=w++,this.manager=null,this.options.enable=E(this.options.enable,!0),this.state=1,this.simultaneous={},this.requireFail=[]}function ft(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function vt(t){return 16==t?"down":8==t?"up":2==t?"left":4==t?"right":""}function dt(t,e){var n=e.manager;return n?n.get(t):t}function mt(){pt.apply(this,arguments)}function gt(){mt.apply(this,arguments),this.pX=null,this.pY=null}function yt(){mt.apply(this,arguments)}function Tt(){pt.apply(this,arguments),this._timer=null,this._input=null}function Et(){mt.apply(this,arguments)}function It(){mt.apply(this,arguments)}function At(){pt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function _t(t,e){return(e=e||{}).recognizers=E(e.recognizers,_t.defaults.preset),new Ct(t,e)}pt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=dt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)||(t=dt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return-1===b(e,t=dt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=dt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,n=this.state;function i(n){e.manager.emit(n,t)}n<8&&i(e.options.event+ft(n)),i(e.options.event),t.additionalEvent&&i(t.additionalEvent),n>=8&&i(e.options.event+ft(n))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=32},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!T(this.options.enable,[this,e]))return this.reset(),void(this.state=32);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(mt,pt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,n=t.eventType,i=6&e,r=this.attrTest(t);return i&&(8&n||!r)?16|e:i||r?4&n?8|e:2&e?4|e:2:32}}),g(gt,mt,{defaults:{event:"pan",threshold:10,pointers:1,direction:30},getTouchAction:function(){var t=this.options.direction,e=[];return 6&t&&e.push("pan-y"),24&t&&e.push("pan-x"),e},directionTest:function(t){var e=this.options,n=!0,i=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(6&e.direction?(r=0===s?1:s<0?2:4,n=s!=this.pX,i=Math.abs(t.deltaX)):(r=0===o?1:o<0?8:16,n=o!=this.pY,i=Math.abs(t.deltaY))),t.direction=r,n&&i>e.threshold&&r&e.direction},attrTest:function(t){return mt.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=vt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(yt,mt,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return["none"]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(Tt,pt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return["auto"]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!i||!n||12&t.eventType&&!r)this.reset();else if(1&t.eventType)this.reset(),this._timer=l((function(){this.state=8,this.tryEmit()}),e.time,this);else if(4&t.eventType)return 8;return 32},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Et,mt,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return["none"]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),g(It,mt,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},getTouchAction:function(){return gt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,n=this.options.direction;return 30&n?e=t.overallVelocity:6&n?e=t.overallVelocityX:24&n&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&n&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&4&t.eventType},emit:function(t){var e=vt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(At,pt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return["manipulation"]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(i&&r&&n){if(4!=t.eventType)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||L(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=l((function(){this.state=8,this.tryEmit()}),e.interval,this),2):8}return 32},failTimeout:function(){return this._timer=l((function(){this.state=32}),this.options.interval,this),32},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),_t.VERSION="2.0.7",_t.defaults={domEvents:!1,touchAction:"compute",enable:!0,inputTarget:null,inputClass:null,preset:[[Et,{enable:!1}],[yt,{enable:!1},["rotate"]],[It,{direction:6}],[gt,{direction:6},["swipe"]],[At],[At,{event:"doubletap",taps:2},["tap"]],[Tt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Ct(t,e){var n;this.options=s({},_t.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((n=this).options.inputClass||(M?J:z?nt:R?rt:j))(n,F),this.touchAction=new lt(this,this.options.touchAction),St(this,!0),f(this.options.recognizers,(function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}function St(t,e){var n,i=t.element;i.style&&(f(t.options.cssProps,(function(r,s){n=D(i.style,s),e?(t.oldCssProps[n]=i.style[n],i.style[n]=r):i.style[n]=t.oldCssProps[n]||""})),e||(t.oldCssProps={}))}Ct.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var n;this.touchAction.preventDefaults(t);var i=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var s=0;s<i.length;)n=i[s],2===e.stopped||r&&n!=r&&!n.canRecognizeWith(r)?n.reset():n.recognize(t),!r&&14&n.state&&(r=e.curRecognizer=n),s++}},get:function(t){if(t instanceof pt)return t;for(var e=this.recognizers,n=0;n<e.length;n++)if(e[n].options.event==t)return e[n];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,n=b(e,t);-1!==n&&(e.splice(n,1),this.touchAction.update())}return this},on:function(t,e){if(void 0!==t&&void 0!==e){var n=this.handlers;return f(S(t),(function(t){n[t]=n[t]||[],n[t].push(e)})),this}},off:function(t,e){if(void 0!==t){var n=this.handlers;return f(S(t),(function(t){e?n[t]&&n[t].splice(b(n[t],e),1):delete n[t]})),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var i=n.createEvent("Event");i.initEvent(t,!0,!0),i.gesture=e,e.target.dispatchEvent(i)}(t,e);var i=this.handlers[t]&&this.handlers[t].slice();if(i&&i.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<i.length;)i[r](e),r++}},destroy:function(){this.element&&St(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(_t,{INPUT_START:1,INPUT_MOVE:2,INPUT_END:4,INPUT_CANCEL:8,STATE_POSSIBLE:1,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:32,DIRECTION_NONE:1,DIRECTION_LEFT:2,DIRECTION_RIGHT:4,DIRECTION_UP:8,DIRECTION_DOWN:16,DIRECTION_HORIZONTAL:6,DIRECTION_VERTICAL:24,DIRECTION_ALL:30,Manager:Ct,Input:Y,TouchAction:lt,TouchInput:nt,MouseInput:j,PointerEventInput:J,TouchMouseInput:rt,SingleTouchInput:Q,Recognizer:pt,AttrRecognizer:mt,Tap:At,Pan:gt,Swipe:It,Pinch:yt,Rotate:Et,Press:Tt,on:I,off:A,each:f,merge:m,extend:d,assign:s,inherit:g,bindFn:y,prefixed:D}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=_t,"function"==typeof define&&define.amd?define((function(){return _t})):void 0!==e&&e.exports?e.exports=_t:t.Hammer=_t}(window,document)},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const n=t(1).__importStar(t(18)),o=t(67),s=t(9),a=t(71);class r extends o.View{get plot_view(){return this.parent}get plot_model(){return this.parent.model}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>{this.model.active?this.activate():this.deactivate()})}activate(){}deactivate(){}}i.ToolView=r,r.__name__="ToolView";class _ extends a.Model{constructor(t){super(t)}static init_Tool(){this.prototype._known_aliases=new Map,this.internal({active:[n.Boolean,!1]})}get synthetic_renderers(){return[]}_get_dim_tooltip(t,e){switch(e){case"width":return t+" (x-axis)";case"height":return t+" (y-axis)";case"both":return t}}_get_dim_limits([t,e],[i,n],o,a){const r=o.bbox.h_range;let _;"width"==a||"both"==a?(_=[s.min([t,i]),s.max([t,i])],_=[s.max([_[0],r.start]),s.min([_[1],r.end])]):_=[r.start,r.end];const l=o.bbox.v_range;let c;return"height"==a||"both"==a?(c=[s.min([e,n]),s.max([e,n])],c=[s.max([c[0],l.start]),s.min([c[1],l.end])]):c=[l.start,l.end],[_,c]}static register_alias(t,e){this.prototype._known_aliases.set(t,e)}static from_string(t){const e=this.prototype._known_aliases.get(t);if(null!=e)return e();{const e=[...this.prototype._known_aliases.keys()];throw new Error(`unexpected tool name '${t}', possible tools are ${e.join(", ")}`)}}}i.Tool=_,_.__name__="Tool",_.init_Tool()},
function _(o,b,t){Object.defineProperty(t,"__esModule",{value:!0}),t.bk_toolbar="bk-toolbar",t.bk_toolbar_hidden="bk-toolbar-hidden",t.bk_toolbar_button="bk-toolbar-button",t.bk_button_bar="bk-button-bar",t.bk_toolbar_button_custom_action="bk-toolbar-button-custom-action"},
function _(o,b,t){Object.defineProperty(t,"__esModule",{value:!0});t.default='\n.bk-root .bk-toolbar-hidden {\n  visibility: hidden;\n  opacity: 0;\n  transition: visibility 0.3s linear, opacity 0.3s linear;\n}\n.bk-root .bk-toolbar,\n.bk-root .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-toolbar .bk-logo {\n  flex-shrink: 0;\n  -webkit-flex-shrink: 0;\n}\n.bk-root .bk-toolbar.bk-above,\n.bk-root .bk-toolbar.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n  justify-content: flex-end;\n  -webkit-justify-content: flex-end;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar,\n.bk-root .bk-toolbar.bk-below .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-toolbar.bk-above .bk-logo,\n.bk-root .bk-toolbar.bk-below .bk-logo {\n  order: 1;\n  -webkit-order: 1;\n  margin-left: 5px;\n  margin-right: 0px;\n}\n.bk-root .bk-toolbar.bk-left,\n.bk-root .bk-toolbar.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  justify-content: flex-start;\n  -webkit-justify-content: flex-start;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar,\n.bk-root .bk-toolbar.bk-right .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-toolbar.bk-left .bk-logo,\n.bk-root .bk-toolbar.bk-right .bk-logo {\n  order: 0;\n  -webkit-order: 0;\n  margin-bottom: 5px;\n  margin-top: 0px;\n}\n.bk-root .bk-toolbar-button {\n  width: 30px;\n  height: 30px;\n  cursor: pointer;\n  background-size: 60%;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-toolbar-button:hover {\n  background-color: rgba(192, 192, 192, 0.15);\n}\n.bk-root .bk-toolbar-button:focus {\n  outline: none;\n}\n.bk-root .bk-toolbar-button::-moz-focus-inner {\n  border: 0;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button {\n  border-bottom: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button.bk-active {\n  border-bottom-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button {\n  border-top: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button.bk-active {\n  border-top-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button {\n  border-left: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button.bk-active {\n  border-left-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button {\n  border-right: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button.bk-active {\n  border-right-color: #26aae1;\n}\n.bk-root .bk-button-bar + .bk-button-bar:before {\n  content: " ";\n  display: inline-block;\n  background-color: lightgray;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-below .bk-button-bar + .bk-button-bar:before {\n  height: 10px;\n  width: 1px;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-right .bk-button-bar + .bk-button-bar:before {\n  height: 1px;\n  width: 10px;\n}\n'},
function _(A,g,C){Object.defineProperty(C,"__esModule",{value:!0});C.default='\n.bk-root .bk-tool-icon-replace-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-append-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-intersect-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-subtract-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-clear-selection {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-box-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-box-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-zoom-in {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-zoom-out {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-help {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-hover {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-crosshair {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-lasso-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-pan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-xpan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-ypan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-range {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-polygon-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-redo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-reset {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-save {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-tap-select {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-undo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-wheel-pan {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-wheel-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-box-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-freehand-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-point-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-line-edit {\n  background-image: url("data:image/png;base64,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");\n}\n'},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const n=t(1),s=t(68),o=n.__importStar(t(255));class l{constructor(t,e={}){this.items=t,this.options=e,this.el=s.div(),this._open=!1,this._item_click=t=>{var e;null===(e=this.items[t])||void 0===e||e.handler(),this.hide()},this._on_mousedown=t=>{var e,i;const{target:n}=t;n instanceof Node&&this.el.contains(n)||(null===(i=(e=this.options).prevent_hide)||void 0===i?void 0:i.call(e,t))||this.hide()},this._on_keydown=t=>{t.keyCode==s.Keys.Esc&&this.hide()},this._on_blur=()=>{this.hide()},s.undisplay(this.el)}get is_open(){return this._open}get can_open(){return 0!=this.items.length}remove(){s.remove(this.el),this._unlisten()}_listen(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)}_unlisten(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)}_position(t){const e=this.el.parentElement;if(null!=e){const i=e.getBoundingClientRect();this.el.style.left=null!=t.left?t.left-i.left+"px":"",this.el.style.top=null!=t.top?t.top-i.top+"px":"",this.el.style.right=null!=t.right?i.right-t.right+"px":"",this.el.style.bottom=null!=t.bottom?i.bottom-t.bottom+"px":""}}render(){var t;s.empty(this.el,!0);const e=null!==(t=this.options.orientation)&&void 0!==t?t:"vertical";s.classes(this.el).add("bk-context-menu","bk-"+e),s.append(this.el,...this.items.map((t,e)=>{var i;let n;if(null!=t){const e=null!=t.icon?s.div({class:["bk-menu-icon",t.icon]}):null;n=s.div({class:(null===(i=t.active)||void 0===i?void 0:i.call(t))?"bk-active":null,title:t.tooltip},e,t.label)}else n=s.div({class:o.bk_divider});return n.addEventListener("click",()=>this._item_click(e)),n}))}show(t){0!=this.items.length&&(this._open||(this.render(),this._position(null!=t?t:{left:0,top:0}),s.display(this.el),this._listen(),this._open=!0))}hide(){this._open&&(this._open=!1,this._unlisten(),s.undisplay(this.el))}toggle(t){this._open?this.hide():this.show(t)}}i.ContextMenu=l,l.__name__="ContextMenu"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(275),i=e(146),s=e(68);class c extends o.ButtonToolButtonView{render(){super.render(),s.classes(this.el).toggle(i.bk_active,this.model.active)}_clicked(){const{active:e}=this.model;this.model.active=!e}}n.OnOffButtonView=c,c.__name__="OnOffButtonView"},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1),s=t(72),l=t(68),n=t(99),a=i.__importStar(t(18)),r=t(66),_=t(9),c=t(8),h=t(71),u=t(284),v=t(285),d=t(286),b=t(274),p=t(278),g=t(288),f=t(146),m=i.__importDefault(t(279)),w=i.__importDefault(t(289));class y extends h.Model{constructor(t){super(t)}static init_ToolbarViewModel(){this.define({_visible:[a.Any,null],autohide:[a.Boolean,!1]})}get visible(){return!this.autohide||null!=this._visible&&this._visible}}e.ToolbarViewModel=y,y.__name__="ToolbarViewModel",y.init_ToolbarViewModel();class T extends r.DOMView{initialize(){super.initialize(),this._tool_button_views=new Map,this._toolbar_view_model=new y({autohide:this.model.autohide})}async lazy_initialize(){await this._build_tool_button_views()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.tools.change,async()=>{await this._build_tool_button_views(),this.render()}),this.connect(this.model.properties.autohide.change,()=>{this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change()}),this.connect(this._toolbar_view_model.properties._visible.change,()=>this._on_visible_change())}styles(){return[...super.styles(),m.default,w.default]}remove(){n.remove_views(this._tool_button_views),super.remove()}async _build_tool_button_views(){const t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools;await n.build_views(this._tool_button_views,t,{parent:this},t=>t.button_view)}set_visibility(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)}_on_visible_change(){const t=this._toolbar_view_model.visible,o=p.bk_toolbar_hidden;this.el.classList.contains(o)&&t?this.el.classList.remove(o):t||this.el.classList.add(o)}render(){if(l.empty(this.el),this.el.classList.add(p.bk_toolbar),this.el.classList.add(f.bk_side(this.model.toolbar_location)),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change(),null!=this.model.logo){const t="grey"===this.model.logo?g.bk_grey:null,o=l.a({href:"https://bokeh.org/",target:"_blank",class:[g.bk_logo,g.bk_logo_small,t]});this.el.appendChild(o)}for(const[,t]of this._tool_button_views)t.render();const t=[],o=t=>this._tool_button_views.get(t).el,{gestures:e}=this.model;for(const i in e)t.push(e[i].tools.map(o));t.push(this.model.actions.map(o)),t.push(this.model.inspectors.filter(t=>t.toggleable).map(o));for(const o of t)if(0!==o.length){const t=l.div({class:p.bk_button_bar},o);this.el.appendChild(t)}}update_layout(){}update_position(){}after_layout(){this._has_finished=!0}}function k(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}e.ToolbarBaseView=T,T.__name__="ToolbarBaseView";class M extends h.Model{constructor(t){super(t)}static init_ToolbarBase(){this.prototype.default_view=T,this.define({tools:[a.Array,[]],logo:[a.Logo,"normal"],autohide:[a.Boolean,!1]}),this.internal({gestures:[a.Any,k],actions:[a.Array,[]],inspectors:[a.Array,[]],help:[a.Array,[]],toolbar_location:[a.Location,"right"]})}initialize(){super.initialize(),this._init_tools()}_init_tools(){const t=function(t,o){if(t.length!=o.length)return!0;const e=new Set(o.map(t=>t.id));return _.some(t,t=>!e.has(t.id))},o=this.tools.filter(t=>t instanceof b.InspectTool);t(this.inspectors,o)&&(this.inspectors=o);const e=this.tools.filter(t=>t instanceof d.HelpTool);t(this.help,e)&&(this.help=e);const i=this.tools.filter(t=>t instanceof v.ActionTool);t(this.actions,i)&&(this.actions=i);const l=(t,o)=>{t in this.gestures||s.logger.warn(`Toolbar: unknown event type '${t}' for tool: ${o}`)},n={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}};for(const t of this.tools)if(t instanceof u.GestureTool&&t.event_type)if(c.isString(t.event_type))n[t.event_type].tools.push(t),l(t.event_type,t);else{n.multi.tools.push(t);for(const o of t.event_type)l(o,t)}for(const o of Object.keys(n)){const e=this.gestures[o];t(e.tools,n[o].tools)&&(e.tools=n[o].tools),e.active&&_.every(e.tools,t=>t.id!=e.active.id)&&(e.active=null)}}get horizontal(){return"above"===this.toolbar_location||"below"===this.toolbar_location}get vertical(){return"left"===this.toolbar_location||"right"===this.toolbar_location}_active_change(t){const{event_type:o}=t;if(null==o)return;const e=c.isString(o)?[o]:o;for(const o of e)if(t.active){const e=this.gestures[o].active;null!=e&&t!=e&&(s.logger.debug(`Toolbar: deactivating tool: ${e} for event type '${o}'`),e.active=!1),this.gestures[o].active=t,s.logger.debug(`Toolbar: activating tool: ${t} for event type '${o}'`)}else this.gestures[o].active=null}}e.ToolbarBase=M,M.__name__="ToolbarBase",M.init_ToolbarBase()},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});const s=e(275),n=e(282);class u extends s.ButtonToolView{}t.GestureToolView=u,u.__name__="GestureToolView";class _ extends s.ButtonTool{constructor(e){super(e),this.button_view=n.OnOffButtonView}}t.GestureTool=_,_.__name__="GestureTool"},
function _(o,t,n){Object.defineProperty(n,"__esModule",{value:!0});const e=o(275),i=o(14);class s extends e.ButtonToolButtonView{_clicked(){this.model.do.emit()}}n.ActionToolButtonView=s,s.__name__="ActionToolButtonView";class c extends e.ButtonToolView{connect_signals(){super.connect_signals(),this.connect(this.model.do,()=>this.doit())}}n.ActionToolView=c,c.__name__="ActionToolView";class l extends e.ButtonTool{constructor(o){super(o),this.button_view=s,this.do=new i.Signal0(this,"do")}}n.ActionTool=l,l.__name__="ActionTool"},
function _(o,e,t){Object.defineProperty(t,"__esModule",{value:!0});const i=o(1),l=o(285),s=i.__importStar(o(18)),n=o(287);class _ extends l.ActionToolView{doit(){window.open(this.model.redirect)}}t.HelpToolView=_,_.__name__="HelpToolView";class r extends l.ActionTool{constructor(o){super(o),this.tool_name="Help",this.icon=n.bk_tool_icon_help}static init_HelpTool(){this.prototype.default_view=_,this.define({help_tooltip:[s.String,"Click the question mark to learn more about Bokeh plot tools."],redirect:[s.String,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]}),this.register_alias("help",()=>new r)}get tooltip(){return this.help_tooltip}}t.HelpTool=r,r.__name__="HelpTool",r.init_HelpTool()},
function _(o,_,l){Object.defineProperty(l,"__esModule",{value:!0}),l.bk_tool_icon_box_select="bk-tool-icon-box-select",l.bk_tool_icon_box_zoom="bk-tool-icon-box-zoom",l.bk_tool_icon_zoom_in="bk-tool-icon-zoom-in",l.bk_tool_icon_zoom_out="bk-tool-icon-zoom-out",l.bk_tool_icon_help="bk-tool-icon-help",l.bk_tool_icon_hover="bk-tool-icon-hover",l.bk_tool_icon_crosshair="bk-tool-icon-crosshair",l.bk_tool_icon_lasso_select="bk-tool-icon-lasso-select",l.bk_tool_icon_pan="bk-tool-icon-pan",l.bk_tool_icon_xpan="bk-tool-icon-xpan",l.bk_tool_icon_ypan="bk-tool-icon-ypan",l.bk_tool_icon_range="bk-tool-icon-range",l.bk_tool_icon_polygon_select="bk-tool-icon-polygon-select",l.bk_tool_icon_redo="bk-tool-icon-redo",l.bk_tool_icon_reset="bk-tool-icon-reset",l.bk_tool_icon_save="bk-tool-icon-save",l.bk_tool_icon_tap_select="bk-tool-icon-tap-select",l.bk_tool_icon_undo="bk-tool-icon-undo",l.bk_tool_icon_wheel_pan="bk-tool-icon-wheel-pan",l.bk_tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",l.bk_tool_icon_box_edit="bk-tool-icon-box-edit",l.bk_tool_icon_freehand_draw="bk-tool-icon-freehand-draw",l.bk_tool_icon_poly_draw="bk-tool-icon-poly-draw",l.bk_tool_icon_point_draw="bk-tool-icon-point-draw",l.bk_tool_icon_poly_edit="bk-tool-icon-poly-edit",l.bk_tool_icon_line_edit="bk-tool-icon-line-edit"},
function _(o,l,b){Object.defineProperty(b,"__esModule",{value:!0}),b.bk_logo="bk-logo",b.bk_logo_notebook="bk-logo-notebook",b.bk_logo_small="bk-logo-small",b.bk_grey="bk-grey"},
function _(l,n,o){Object.defineProperty(o,"__esModule",{value:!0});o.default="\n.bk-root .bk-logo {\n  margin: 5px;\n  position: relative;\n  display: block;\n  background-repeat: no-repeat;\n}\n.bk-root .bk-logo.bk-grey {\n  filter: url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale\");\n  /* Firefox 10+, Firefox on Android */\n  filter: gray;\n  /* IE6-9 */\n  -webkit-filter: grayscale(100%);\n  /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n.bk-root .bk-logo-small {\n  width: 20px;\n  height: 20px;\n  background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);\n}\n.bk-root .bk-logo-notebook {\n  display: inline-block;\n  vertical-align: middle;\n  margin-right: 5px;\n}\n"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=this&&this.__rest||function(t,e){var i={};for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&e.indexOf(s)<0&&(i[s]=t[s]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(s=Object.getOwnPropertySymbols(t);n<s.length;n++)e.indexOf(s[n])<0&&Object.prototype.propertyIsEnumerable.call(t,s[n])&&(i[s[n]]=t[s[n]])}return i};const n=t(184),a=t(181),o=t(186),l=t(81),r=t(245),h=t(142),_=t(150),d=t(143),u=t(291),c=t(14),p=t(99),g=t(292),m=t(70),f=t(72),b=t(294),w=t(8),v=t(9),y=t(17),x=t(188),z=t(191),M=t(295),k=t(192),O=t(88);class j extends x.Layoutable{constructor(){super(...arguments),this.min_border={left:0,top:0,right:0,bottom:0}}_measure(t){t=new x.Sizeable(t).bounded_to(this.sizing.size);const e=this.left_panel.measure({width:0,height:t.height}),i=Math.max(e.width,this.min_border.left),s=this.right_panel.measure({width:0,height:t.height}),n=Math.max(s.width,this.min_border.right),a=this.top_panel.measure({width:t.width,height:0}),o=Math.max(a.height,this.min_border.top),l=this.bottom_panel.measure({width:t.width,height:0}),r=Math.max(l.height,this.min_border.bottom),h=new x.Sizeable(t).shrink_by({left:i,right:n,top:o,bottom:r}),_=this.center_panel.measure(h);return{width:i+_.width+n,height:o+_.height+r,inner:{left:i,right:n,top:o,bottom:r},align:(()=>{const{width_policy:t,height_policy:e}=this.center_panel.sizing;return"fixed"!=t&&"fixed"!=e})()}}_set_geometry(t,e){super._set_geometry(t,e),this.center_panel.set_geometry(e);const i=this.left_panel.measure({width:0,height:t.height}),s=this.right_panel.measure({width:0,height:t.height}),n=this.top_panel.measure({width:t.width,height:0}),a=this.bottom_panel.measure({width:t.width,height:0}),{left:o,top:l,right:r,bottom:h}=e;this.top_panel.set_geometry(new O.BBox({left:o,right:r,bottom:l,height:n.height})),this.bottom_panel.set_geometry(new O.BBox({left:o,right:r,top:h,height:a.height})),this.left_panel.set_geometry(new O.BBox({top:l,bottom:h,right:o,width:i.width})),this.right_panel.set_geometry(new O.BBox({top:l,bottom:h,left:r,width:s.width}))}}i.PlotLayout=j,j.__name__="PlotLayout";class P extends r.LayoutDOMView{constructor(){super(...arguments),this._outer_bbox=new O.BBox,this._inner_bbox=new O.BBox,this._needs_paint=!0,this._needs_layout=!1,this._invalidated_painters=new Set,this._invalidate_all=!0}get is_paused(){return null!=this._is_paused&&0!==this._is_paused}get child_models(){return[]}pause(){null==this._is_paused?this._is_paused=1:this._is_paused+=1}unpause(t=!1){if(null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||t||this.request_paint()}request_render(){this.request_paint()}request_paint(t){if(null!=t?this._invalidated_painters.add(t):this._invalidate_all=!0,!this.is_paused){const t=this.throttled_paint();this._ready=this._ready.then(()=>t)}}request_layout(){this._needs_layout=!0,this.request_paint()}reset(){"standard"==this.model.reset_policy&&(this.clear_state(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new u.Reset)}remove(){this.ui_event_bus.destroy(),p.remove_views(this.renderer_views),p.remove_views(this.tool_views),this.canvas_view.remove(),super.remove()}render(){super.render(),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()}initialize(){this.pause(),super.initialize(),this.state_changed=new c.Signal0(this,"state_changed"),this.lod_started=!1,this.visuals=new m.Visuals(this.model),this._initial_state_info={selection:new Map,dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.state={history:[],index:-1};const{hidpi:t,output_backend:e}=this.model;this.canvas=new a.Canvas({hidpi:t,output_backend:e}),this.frame=new n.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges),this.throttled_paint=b.throttle(()=>this.repaint(),1e3/60);const{title_location:i,title:s}=this.model;null!=i&&null!=s&&(this._title=s instanceof h.Title?s:new h.Title({text:s}));const{toolbar_location:o,toolbar:l}=this.model;null!=o&&null!=l&&(this._toolbar=new d.ToolbarPanel({toolbar:l}),l.toolbar_location=o),this.renderer_views=new Map,this.tool_views=new Map}async lazy_initialize(){this.canvas_view=await p.build_view(this.canvas,{parent:this}),this.ui_event_bus=new g.UIEvents(this,this.model.toolbar,this.canvas_view.events_el),await this.build_renderer_views(),await this.build_tool_views(),this.update_dataranges(),this.unpause(!0),f.logger.debug("PlotView initialized")}_width_policy(){return null==this.model.frame_width?super._width_policy():"min"}_height_policy(){return null==this.model.frame_height?super._height_policy():"min"}_update_layout(){this.layout=new j,this.layout.set_sizing(this.box_sizing());const{frame_width:t,frame_height:e}=this.model;this.layout.center_panel=this.frame,this.layout.center_panel.set_sizing(Object.assign(Object.assign({},null!=t?{width_policy:"fixed",width:t}:{width_policy:"fit"}),null!=e?{height_policy:"fixed",height:e}:{height_policy:"fit"}));const i=v.copy(this.model.above),s=v.copy(this.model.below),n=v.copy(this.model.left),a=v.copy(this.model.right),o=t=>{switch(t){case"above":return i;case"below":return s;case"left":return n;case"right":return a}},{title_location:l,title:r}=this.model;null!=l&&null!=r&&o(l).push(this._title);const{toolbar_location:_,toolbar:u}=this.model;if(null!=_&&null!=u){const t=o(_);let e=!0;if(this.model.toolbar_sticky)for(let i=0;i<t.length;i++){const s=t[i];if(s instanceof h.Title){t[i]="above"==_||"below"==_?[s,this._toolbar]:[this._toolbar,s],e=!1;break}}e&&t.push(this._toolbar)}const c=(t,e)=>{const i=this.renderer_views.get(e);return i.layout=new M.SidePanel(t,i)},p=(t,e)=>{const i="above"==t||"below"==t,s=[];for(const n of e)if(w.isArray(n)){const e=n.map(e=>{const s=c(t,e);if(e instanceof d.ToolbarPanel){const t=i?"width_policy":"height_policy";s.set_sizing(Object.assign(Object.assign({},s.sizing),{[t]:"min"}))}return s});let a;i?(a=new k.Row(e),a.set_sizing({width_policy:"max",height_policy:"min"})):(a=new k.Column(e),a.set_sizing({width_policy:"min",height_policy:"max"})),a.absolute=!0,s.push(a)}else s.push(c(t,n));return s},g=null!=this.model.min_border?this.model.min_border:0;this.layout.min_border={left:null!=this.model.min_border_left?this.model.min_border_left:g,top:null!=this.model.min_border_top?this.model.min_border_top:g,right:null!=this.model.min_border_right?this.model.min_border_right:g,bottom:null!=this.model.min_border_bottom?this.model.min_border_bottom:g};const m=new z.VStack,f=new z.VStack,b=new z.HStack,y=new z.HStack;m.children=v.reversed(p("above",i)),f.children=p("below",s),b.children=v.reversed(p("left",n)),y.children=p("right",a),m.set_sizing({width_policy:"fit",height_policy:"min"}),f.set_sizing({width_policy:"fit",height_policy:"min"}),b.set_sizing({width_policy:"min",height_policy:"fit"}),y.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.top_panel=m,this.layout.bottom_panel=f,this.layout.left_panel=b,this.layout.right_panel=y}get axis_views(){const t=[];for(const[,e]of this.renderer_views)e instanceof _.AxisView&&t.push(e);return t}set_cursor(t="default"){this.canvas_view.el.style.cursor=t}set_toolbar_visibility(t){for(const e of this.visibility_callbacks)e(t)}update_dataranges(){const t=new Map,e=new Map;let i=!1;for(const t of y.values(this.frame.x_ranges).concat(y.values(this.frame.y_ranges)))t instanceof o.DataRange1d&&"log"==t.scale_hint&&(i=!0);for(const[s,n]of this.renderer_views)if(n instanceof l.GlyphRendererView){const a=n.glyph.bounds();if(null!=a&&t.set(s,a),i){const t=n.glyph.log_bounds();null!=t&&e.set(s,t)}}let s=!1,n=!1;const{width:a,height:r}=this.frame.bbox;let h;!1!==this.model.match_aspect&&0!=a&&0!=r&&(h=1/this.model.aspect_scale*(a/r));for(const i of y.values(this.frame.x_ranges)){if(i instanceof o.DataRange1d){const n="log"==i.scale_hint?e:t;i.update(n,0,this.model,h),i.follow&&(s=!0)}null!=i.bounds&&(n=!0)}for(const i of y.values(this.frame.y_ranges)){if(i instanceof o.DataRange1d){const n="log"==i.scale_hint?e:t;i.update(n,1,this.model,h),i.follow&&(s=!0)}null!=i.bounds&&(n=!0)}if(s&&n){f.logger.warn("Follow enabled so bounds are unset.");for(const t of y.values(this.frame.x_ranges))t.bounds=null;for(const t of y.values(this.frame.y_ranges))t.bounds=null}this.range_update_timestamp=Date.now()}map_to_screen(t,e,i="default",s="default"){return this.frame.map_to_screen(t,e,i,s)}push_state(t,e){const{history:i,index:s}=this.state,n=null!=i[s]?i[s].info:{},a=Object.assign(Object.assign(Object.assign({},this._initial_state_info),n),e);this.state.history=this.state.history.slice(0,this.state.index+1),this.state.history.push({type:t,info:a}),this.state.index=this.state.history.length-1,this.state_changed.emit()}clear_state(){this.state={history:[],index:-1},this.state_changed.emit()}can_undo(){return this.state.index>=0}can_redo(){return this.state.index<this.state.history.length-1}undo(){this.can_undo()&&(this.state.index-=1,this._do_state_change(this.state.index),this.state_changed.emit())}redo(){this.can_redo()&&(this.state.index+=1,this._do_state_change(this.state.index),this.state_changed.emit())}_do_state_change(t){const e=null!=this.state.history[t]?this.state.history[t].info:this._initial_state_info;null!=e.range&&this.update_range(e.range),null!=e.selection&&this.update_selection(e.selection)}get_selection(){const t=new Map;for(const e of this.model.renderers)if(e instanceof l.GlyphRenderer){const{selected:i}=e.data_source;t.set(e,i)}return t}update_selection(t){for(const e of this.model.renderers){if(!(e instanceof l.GlyphRenderer))continue;const i=e.data_source;if(null!=t){const s=t.get(e);null!=s&&i.selected.update(s,!0)}else i.selection_manager.clear()}}reset_selection(){this.update_selection(null)}_update_ranges_together(t){let e=1;for(const[i,s]of t)e=Math.min(e,this._get_weight_to_constrain_interval(i,s));if(e<1)for(const[i,s]of t)s.start=e*s.start+(1-e)*i.start,s.end=e*s.end+(1-e)*i.end}_update_ranges_individually(t,e,i,s){let n=!1;for(const[s,a]of t){if(!i){const t=this._get_weight_to_constrain_interval(s,a);t<1&&(a.start=t*a.start+(1-t)*s.start,a.end=t*a.end+(1-t)*s.end)}if(null!=s.bounds&&"auto"!=s.bounds){const[t,o]=s.bounds,l=Math.abs(a.end-a.start);s.is_reversed?(null!=t&&t>=a.end&&(n=!0,a.end=t,(e||i)&&(a.start=t+l)),null!=o&&o<=a.start&&(n=!0,a.start=o,(e||i)&&(a.end=o-l))):(null!=t&&t>=a.start&&(n=!0,a.start=t,(e||i)&&(a.end=t+l)),null!=o&&o<=a.end&&(n=!0,a.end=o,(e||i)&&(a.start=o-l)))}}if(!(i&&n&&s))for(const[e,i]of t)e.have_updated_interactively=!0,e.start==i.start&&e.end==i.end||e.setv(i)}_get_weight_to_constrain_interval(t,e){const{min_interval:i}=t;let{max_interval:s}=t;if(null!=t.bounds&&"auto"!=t.bounds){const[e,i]=t.bounds;if(null!=e&&null!=i){const t=Math.abs(i-e);s=null!=s?Math.min(s,t):t}}let n=1;if(null!=i||null!=s){const a=Math.abs(t.end-t.start),o=Math.abs(e.end-e.start);i>0&&o<i&&(n=(a-i)/(a-o)),s>0&&o>s&&(n=(s-a)/(o-a)),n=Math.max(0,Math.min(1,n))}return n}update_range(t,e=!1,i=!1,s=!0){this.pause();const{x_ranges:n,y_ranges:a}=this.frame;if(null==t){for(const t in n){n[t].reset()}for(const t in a){a[t].reset()}this.update_dataranges()}else{const o=[];for(const e in n){const i=n[e];o.push([i,t.xrs[e]])}for(const e in a){const i=a[e];o.push([i,t.yrs[e]])}i&&this._update_ranges_together(o),this._update_ranges_individually(o,e,i,s)}this.unpause()}reset_range(){this.update_range(null)}_invalidate_layout(){(()=>{for(const t of this.model.side_panels){if(this.renderer_views.get(t).layout.has_size_changed())return!0}return!1})()&&this.root.compute_layout()}get_renderer_views(){return this.computed_renderers.map(t=>this.renderer_views.get(t))}async build_renderer_views(){this.computed_renderers=[];const{above:t,below:e,left:i,right:s,center:n,renderers:a}=this.model;this.computed_renderers.push(...t,...e,...i,...s,...n,...a),null!=this._title&&this.computed_renderers.push(this._title),null!=this._toolbar&&this.computed_renderers.push(this._toolbar);for(const t of this.model.toolbar.tools)null!=t.overlay&&this.computed_renderers.push(t.overlay),this.computed_renderers.push(...t.synthetic_renderers);await p.build_views(this.renderer_views,this.computed_renderers,{parent:this})}async build_tool_views(){const t=this.model.toolbar.tools;(await p.build_views(this.tool_views,t,{parent:this})).map(t=>this.ui_event_bus.register_tool(t))}connect_signals(){super.connect_signals();const{x_ranges:t,y_ranges:e}=this.frame;for(const e in t){const i=t[e];this.connect(i.change,()=>{this._needs_layout=!0,this.request_paint()})}for(const t in e){const i=e[t];this.connect(i.change,()=>{this._needs_layout=!0,this.request_paint()})}const{plot_width:i,plot_height:s}=this.model.properties;this.on_change([i,s],()=>this.invalidate_layout());const{above:n,below:a,left:o,right:l,center:r,renderers:h}=this.model.properties;this.on_change([n,a,o,l,r,h],async()=>await this.build_renderer_views()),this.connect(this.model.toolbar.properties.tools.change,async()=>{await this.build_renderer_views(),await this.build_tool_views()}),this.connect(this.model.change,()=>this.request_paint()),this.connect(this.model.reset,()=>this.reset())}set_initial_range(){let t=!0;const{x_ranges:e,y_ranges:i}=this.frame,s={},n={};for(const i in e){const{start:n,end:a}=e[i];if(null==n||null==a||isNaN(n+a)){t=!1;break}s[i]={start:n,end:a}}if(t)for(const e in i){const{start:s,end:a}=i[e];if(null==s||null==a||isNaN(s+a)){t=!1;break}n[e]={start:s,end:a}}t?(this._initial_state_info.range={xrs:s,yrs:n},f.logger.debug("initial ranges set")):f.logger.warn("could not set initial ranges")}has_finished(){if(!super.has_finished())return!1;for(const[,t]of this.renderer_views)if(!t.has_finished())return!1;return!0}after_layout(){if(super.after_layout(),this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame._width.value),inner_height:Math.round(this.frame._height.value),outer_width:Math.round(this.layout._width.value),outer_height:Math.round(this.layout._height.value)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){const{width:t,height:e}=this.layout.bbox;this.canvas_view.resize(t,e),this._outer_bbox=this.layout.bbox,this._invalidate_all=!0,this._needs_paint=!0}this._inner_bbox.equals(this.frame.inner_bbox)||(this._inner_bbox=this.layout.inner_bbox,this._needs_paint=!0),this._needs_paint&&(this._needs_paint=!1,this.paint())}repaint(){this._needs_layout&&this._invalidate_layout(),this.paint()}paint(){if(this.is_paused)return;f.logger.trace("PlotView.paint() for "+this.model.id);const{document:t}=this.model;if(null!=t){const e=t.interactive_duration();e>=0&&e<this.model.lod_interval?setTimeout(()=>{t.interactive_duration()>this.model.lod_timeout&&t.interactive_stop(this.model),this.request_paint()},this.model.lod_timeout):t.interactive_stop(this.model)}for(const[,t]of this.renderer_views)if(null==this.range_update_timestamp||t instanceof l.GlyphRendererView&&t.set_data_timestamp>this.range_update_timestamp){this.update_dataranges();break}let e=!1,i=!1;if(this._invalidate_all)e=!0,i=!0;else for(const t of this._invalidated_painters){const{level:s}=t.model;if("overlay"!=s?e=!0:i=!0,e&&i)break}this._invalidated_painters.clear(),this._invalidate_all=!1;const s=[this.frame._left.value,this.frame._top.value,this.frame._width.value,this.frame._height.value],{primary:n,overlays:a}=this.canvas_view;e&&(n.prepare(),this.canvas_view.prepare_webgl(s),this.canvas_view.clear_webgl(),this._map_hook(n.ctx,s),this._paint_empty(n.ctx,s),this._paint_outline(n.ctx,s),this._paint_levels(n.ctx,"image",s,!0),this._paint_levels(n.ctx,"underlay",s,!0),this._paint_levels(n.ctx,"glyph",s,!0),this._paint_levels(n.ctx,"guide",s,!1),this._paint_levels(n.ctx,"annotation",s,!1),n.finish()),i&&(a.prepare(),this._paint_levels(a.ctx,"overlay",s,!1),a.finish()),null==this._initial_state_info.range&&this.set_initial_range()}_paint_levels(t,e,i,s){for(const n of this.computed_renderers){if(n.level!=e)continue;const a=this.renderer_views.get(n);t.save(),(s||a.needs_clip)&&(t.beginPath(),t.rect(...i),t.clip()),a.render(),t.restore(),a.has_webgl&&(this.canvas_view.blit_webgl(t),this.canvas_view.clear_webgl())}}_map_hook(t,e){}_paint_empty(t,e){const[i,s,n,a]=[0,0,this.layout._width.value,this.layout._height.value],[o,l,r,h]=e;this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(t),t.fillRect(i,s,n,a),t.clearRect(o,l,r,h)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(o,l,r,h))}_paint_outline(t,e){if(this.visuals.outline_line.doit){t.save(),this.visuals.outline_line.set_value(t);let[i,s,n,a]=e;i+n==this.layout._width.value&&(n-=1),s+a==this.layout._height.value&&(a-=1),t.strokeRect(i,s,n,a),t.restore()}}save(t){this.canvas_view.save(t)}serializable_state(){const t=super.serializable_state(),{children:e}=t,i=s(t,["children"]),n=this.get_renderer_views().map(t=>t.serializable_state()).filter(t=>"bbox"in t);return Object.assign(Object.assign({},i),{children:[...e,...n]})}}i.PlotView=P,P.__name__="PlotView"},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});var n=this&&this.__decorate||function(e,t,s,n){var _,a=arguments.length,o=a<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,s):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)o=Reflect.decorate(e,t,s,n);else for(var r=e.length-1;r>=0;r--)(_=e[r])&&(o=(a<3?_(o):a>3?_(t,s,o):_(t,s))||o);return a>3&&o&&Object.defineProperty(t,s,o),o};function _(e){return function(t){t.prototype.event_name=e}}class a{constructor(){this.origin=null}to_json(){const{event_name:e}=this;return{event_name:e,event_values:this._to_json()}}_to_json(){return{model:this.origin}}}s.BokehEvent=a,a.__name__="BokehEvent";let o=class extends a{};s.ButtonClick=o,o.__name__="ButtonClick",s.ButtonClick=o=n([_("button_click")],o);let r=class extends a{constructor(e){super(),this.item=e}_to_json(){const{item:e}=this;return Object.assign(Object.assign({},super._to_json()),{item:e})}};s.MenuItemClick=r,r.__name__="MenuItemClick",s.MenuItemClick=r=n([_("menu_item_click")],r);class c extends a{}s.UIEvent=c,c.__name__="UIEvent";let i=class extends c{};s.LODStart=i,i.__name__="LODStart",s.LODStart=i=n([_("lodstart")],i);let l=class extends c{};s.LODEnd=l,l.__name__="LODEnd",s.LODEnd=l=n([_("lodend")],l);let u=class extends c{constructor(e,t){super(),this.geometry=e,this.final=t}_to_json(){const{geometry:e,final:t}=this;return Object.assign(Object.assign({},super._to_json()),{geometry:e,final:t})}};s.SelectionGeometry=u,u.__name__="SelectionGeometry",s.SelectionGeometry=u=n([_("selectiongeometry")],u);let h=class extends c{};s.Reset=h,h.__name__="Reset",s.Reset=h=n([_("reset")],h);class d extends c{constructor(e,t,s,n){super(),this.sx=e,this.sy=t,this.x=s,this.y=n}_to_json(){const{sx:e,sy:t,x:s,y:n}=this;return Object.assign(Object.assign({},super._to_json()),{sx:e,sy:t,x:s,y:n})}}s.PointEvent=d,d.__name__="PointEvent";let m=class extends d{constructor(e,t,s,n,_,a){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.delta_x=_,this.delta_y=a}_to_json(){const{delta_x:e,delta_y:t}=this;return Object.assign(Object.assign({},super._to_json()),{delta_x:e,delta_y:t})}};s.Pan=m,m.__name__="Pan",s.Pan=m=n([_("pan")],m);let p=class extends d{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.scale=_}_to_json(){const{scale:e}=this;return Object.assign(Object.assign({},super._to_json()),{scale:e})}};s.Pinch=p,p.__name__="Pinch",s.Pinch=p=n([_("pinch")],p);let x=class extends d{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.rotation=_}_to_json(){const{rotation:e}=this;return Object.assign(Object.assign({},super._to_json()),{rotation:e})}};s.Rotate=x,x.__name__="Rotate",s.Rotate=x=n([_("rotate")],x);let j=class extends d{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.delta=_}_to_json(){const{delta:e}=this;return Object.assign(Object.assign({},super._to_json()),{delta:e})}};s.MouseWheel=j,j.__name__="MouseWheel",s.MouseWheel=j=n([_("wheel")],j);let y=class extends d{};s.MouseMove=y,y.__name__="MouseMove",s.MouseMove=y=n([_("mousemove")],y);let P=class extends d{};s.MouseEnter=P,P.__name__="MouseEnter",s.MouseEnter=P=n([_("mouseenter")],P);let O=class extends d{};s.MouseLeave=O,O.__name__="MouseLeave",s.MouseLeave=O=n([_("mouseleave")],O);let b=class extends d{};s.Tap=b,b.__name__="Tap",s.Tap=b=n([_("tap")],b);let g=class extends d{};s.DoubleTap=g,g.__name__="DoubleTap",s.DoubleTap=g=n([_("doubletap")],g);let v=class extends d{};s.Press=v,v.__name__="Press",s.Press=v=n([_("press")],v);let E=class extends d{};s.PressUp=E,E.__name__="PressUp",s.PressUp=E=n([_("pressup")],E);let M=class extends d{};s.PanStart=M,M.__name__="PanStart",s.PanStart=M=n([_("panstart")],M);let f=class extends d{};s.PanEnd=f,f.__name__="PanEnd",s.PanEnd=f=n([_("panend")],f);let R=class extends d{};s.PinchStart=R,R.__name__="PinchStart",s.PinchStart=R=n([_("pinchstart")],R);let S=class extends d{};s.PinchEnd=S,S.__name__="PinchEnd",s.PinchEnd=S=n([_("pinchend")],S);let k=class extends d{};s.RotateStart=k,k.__name__="RotateStart",s.RotateStart=k=n([_("rotatestart")],k);let D=class extends d{};s.RotateEnd=D,D.__name__="RotateEnd",s.RotateEnd=D=n([_("rotateend")],D)},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const n=t(1),i=n.__importDefault(t(276)),r=t(14),a=t(72),h=t(68),_=t(293),o=t(9),c=t(8),l=t(28),p=n.__importStar(t(291)),u=t(281);class d{constructor(t,e,s){this.plot_view=t,this.toolbar=e,this.hit_area=s,this.pan_start=new r.Signal(this,"pan:start"),this.pan=new r.Signal(this,"pan"),this.pan_end=new r.Signal(this,"pan:end"),this.pinch_start=new r.Signal(this,"pinch:start"),this.pinch=new r.Signal(this,"pinch"),this.pinch_end=new r.Signal(this,"pinch:end"),this.rotate_start=new r.Signal(this,"rotate:start"),this.rotate=new r.Signal(this,"rotate"),this.rotate_end=new r.Signal(this,"rotate:end"),this.tap=new r.Signal(this,"tap"),this.doubletap=new r.Signal(this,"doubletap"),this.press=new r.Signal(this,"press"),this.pressup=new r.Signal(this,"pressup"),this.move_enter=new r.Signal(this,"move:enter"),this.move=new r.Signal(this,"move"),this.move_exit=new r.Signal(this,"move:exit"),this.scroll=new r.Signal(this,"scroll"),this.keydown=new r.Signal(this,"keydown"),this.keyup=new r.Signal(this,"keyup"),this.hammer=new i.default(this.hit_area,{touchAction:"auto",inputClass:i.default.TouchMouseInput}),this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",t=>this._mouse_move(t)),this.hit_area.addEventListener("mouseenter",t=>this._mouse_enter(t)),this.hit_area.addEventListener("mouseleave",t=>this._mouse_exit(t)),this.hit_area.addEventListener("contextmenu",t=>this._context_menu(t)),this.hit_area.addEventListener("wheel",t=>this._mouse_wheel(t)),document.addEventListener("keydown",this),document.addEventListener("keyup",this),this.menu=new u.ContextMenu([],{prevent_hide:t=>2==t.button&&t.target==this.hit_area}),this.hit_area.appendChild(this.menu.el)}destroy(){this.menu.remove(),this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)}handleEvent(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)}_configure_hammerjs(){this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",t=>this._doubletap(t)),this.hammer.on("tap",t=>this._tap(t)),this.hammer.on("press",t=>this._press(t)),this.hammer.on("pressup",t=>this._pressup(t)),this.hammer.get("pan").set({direction:i.default.DIRECTION_ALL}),this.hammer.on("panstart",t=>this._pan_start(t)),this.hammer.on("pan",t=>this._pan(t)),this.hammer.on("panend",t=>this._pan_end(t)),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",t=>this._pinch_start(t)),this.hammer.on("pinch",t=>this._pinch(t)),this.hammer.on("pinchend",t=>this._pinch_end(t)),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",t=>this._rotate_start(t)),this.hammer.on("rotate",t=>this._rotate(t)),this.hammer.on("rotateend",t=>this._rotate_end(t))}register_tool(t){const e=t.model.event_type;null!=e&&(c.isString(e)?this._register_tool(t,e):e.forEach((e,s)=>this._register_tool(t,e,s<1)))}_register_tool(t,e,s=!0){const n=t,{id:i}=n.model,r=t=>e=>{e.id==i&&t(e.e)},h=t=>e=>{t(e.e)};switch(e){case"pan":null!=n._pan_start&&n.connect(this.pan_start,r(n._pan_start.bind(n))),null!=n._pan&&n.connect(this.pan,r(n._pan.bind(n))),null!=n._pan_end&&n.connect(this.pan_end,r(n._pan_end.bind(n)));break;case"pinch":null!=n._pinch_start&&n.connect(this.pinch_start,r(n._pinch_start.bind(n))),null!=n._pinch&&n.connect(this.pinch,r(n._pinch.bind(n))),null!=n._pinch_end&&n.connect(this.pinch_end,r(n._pinch_end.bind(n)));break;case"rotate":null!=n._rotate_start&&n.connect(this.rotate_start,r(n._rotate_start.bind(n))),null!=n._rotate&&n.connect(this.rotate,r(n._rotate.bind(n))),null!=n._rotate_end&&n.connect(this.rotate_end,r(n._rotate_end.bind(n)));break;case"move":null!=n._move_enter&&n.connect(this.move_enter,r(n._move_enter.bind(n))),null!=n._move&&n.connect(this.move,r(n._move.bind(n))),null!=n._move_exit&&n.connect(this.move_exit,r(n._move_exit.bind(n)));break;case"tap":null!=n._tap&&n.connect(this.tap,r(n._tap.bind(n)));break;case"press":null!=n._press&&n.connect(this.press,r(n._press.bind(n))),null!=n._pressup&&n.connect(this.pressup,r(n._pressup.bind(n)));break;case"scroll":null!=n._scroll&&n.connect(this.scroll,r(n._scroll.bind(n)));break;default:throw new Error("unsupported event_type: "+e)}s&&(null!=n._doubletap&&n.connect(this.doubletap,h(n._doubletap.bind(n))),null!=n._keydown&&n.connect(this.keydown,h(n._keydown.bind(n))),null!=n._keyup&&n.connect(this.keyup,h(n._keyup.bind(n))),l.is_mobile&&null!=n._scroll&&"pinch"==e&&(a.logger.debug("Registering scroll on touch screen"),n.connect(this.scroll,r(n._scroll.bind(n)))))}_hit_test_renderers(t,e){const s=this.plot_view.get_renderer_views();for(const n of o.reversed(s)){const{level:s}=n.model;if(("annotation"==s||"overlay"==s)&&null!=n.interactive_hit&&n.interactive_hit(t,e))return n}return null}_hit_test_frame(t,e){return this.plot_view.frame.bbox.contains(t,e)}_hit_test_canvas(t,e){return this.plot_view.layout.bbox.contains(t,e)}_trigger(t,e,s){const n=this.toolbar.gestures,i=t.name.split(":")[0],r=this._hit_test_renderers(e.sx,e.sy),a=this._hit_test_canvas(e.sx,e.sy);switch(i){case"move":{const s=n[i].active;null!=s&&this.trigger(t,e,s.id);const h=this.toolbar.inspectors.filter(t=>t.active);let _="default";null!=r?(_=r.cursor(e.sx,e.sy)||_,o.is_empty(h)||(t=this.move_exit)):this._hit_test_frame(e.sx,e.sy)&&(o.is_empty(h)||(_="crosshair")),this.plot_view.set_cursor(_),this.plot_view.set_toolbar_visibility(a),h.map(s=>this.trigger(t,e,s.id));break}case"tap":{const{target:a}=s;if(null!=a&&a!=this.hit_area)return;null!=r&&null!=r.on_hit&&r.on_hit(e.sx,e.sy);const h=n[i].active;null!=h&&this.trigger(t,e,h.id);break}case"scroll":{const i=n[l.is_mobile?"pinch":"scroll"].active;null!=i&&(s.preventDefault(),s.stopPropagation(),this.trigger(t,e,i.id));break}case"pan":{const r=n[i].active;null!=r&&(s.preventDefault(),this.trigger(t,e,r.id));break}default:{const s=n[i].active;null!=s&&this.trigger(t,e,s.id)}}this._trigger_bokeh_event(e)}trigger(t,e,s=null){t.emit({id:s,e})}_trigger_bokeh_event(t){const e=(()=>{const e=this.plot_view.frame.xscales.default,s=this.plot_view.frame.yscales.default,{sx:n,sy:i}=t,r=e.invert(n),a=s.invert(i);switch(t.type){case"wheel":return new p.MouseWheel(n,i,r,a,t.delta);case"mousemove":return new p.MouseMove(n,i,r,a);case"mouseenter":return new p.MouseEnter(n,i,r,a);case"mouseleave":return new p.MouseLeave(n,i,r,a);case"tap":return new p.Tap(n,i,r,a);case"doubletap":return new p.DoubleTap(n,i,r,a);case"press":return new p.Press(n,i,r,a);case"pressup":return new p.PressUp(n,i,r,a);case"pan":return new p.Pan(n,i,r,a,t.deltaX,t.deltaY);case"panstart":return new p.PanStart(n,i,r,a);case"panend":return new p.PanEnd(n,i,r,a);case"pinch":return new p.Pinch(n,i,r,a,t.scale);case"pinchstart":return new p.PinchStart(n,i,r,a);case"pinchend":return new p.PinchEnd(n,i,r,a);case"rotate":return new p.Rotate(n,i,r,a,t.rotation);case"rotatestart":return new p.RotateStart(n,i,r,a);case"rotateend":return new p.RotateEnd(n,i,r,a);default:return}})();null!=e&&this.plot_view.model.trigger_event(e)}_get_sxy(t){const{pageX:e,pageY:s}=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,{left:n,top:i}=h.offset(this.hit_area);return{sx:e-n,sy:s-i}}_pan_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_pinch_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_rotate_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_tap_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_move_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_scroll_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{delta:_.getDeltaY(t),shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_key_event(t){return{type:t.type,keyCode:t.keyCode}}_pan_start(t){const e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)}_pan(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)}_pan_end(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)}_pinch_start(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)}_pinch(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)}_pinch_end(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)}_rotate_start(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)}_rotate(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)}_rotate_end(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)}_tap(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)}_doubletap(t){const e=this._tap_event(t);this._trigger_bokeh_event(e),this.trigger(this.doubletap,e)}_press(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)}_pressup(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)}_mouse_enter(t){this._trigger(this.move_enter,this._move_event(t),t)}_mouse_move(t){this._trigger(this.move,this._move_event(t),t)}_mouse_exit(t){this._trigger(this.move_exit,this._move_event(t),t)}_mouse_wheel(t){this._trigger(this.scroll,this._scroll_event(t),t)}_context_menu(t){!this.menu.is_open&&this.menu.can_open&&t.preventDefault();const{sx:e,sy:s}=this._get_sxy(t);this.menu.toggle({left:e,top:s})}_key_down(t){this.trigger(this.keydown,this._key_event(t))}_key_up(t){this.trigger(this.keyup,this._key_event(t))}}s.UIEvents=d,d.__name__="UIEvents"},
function _(e,t,n){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function r(e){const t=getComputedStyle(e).fontSize;return null!=t?parseInt(t,10):null}Object.defineProperty(n,"__esModule",{value:!0}),n.getDeltaY=function(e){let t=-e.deltaY;if(e.target instanceof HTMLElement)switch(e.deltaMode){case e.DOM_DELTA_LINE:t*=r((n=e.target).offsetParent||document.body)||r(n)||16;break;case e.DOM_DELTA_PAGE:t*=function(e){return e.clientHeight}(e.target)}var n;return t}},
function _(n,e,o){Object.defineProperty(o,"__esModule",{value:!0});const t=("undefined"!=typeof window?window.requestAnimationFrame:void 0)||("undefined"!=typeof window?window.webkitRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.mozRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.msRequestAnimationFrame:void 0)||function(n){return n(Date.now()),-1};o.throttle=function(n,e){let o=null,i=0,u=!1;return function(){return new Promise((d,w)=>{const r=function(){i=Date.now(),o=null,u=!1;try{n(),d()}catch(n){w(n)}},a=Date.now(),f=e-(a-i);f<=0&&!u?(null!=o&&clearTimeout(o),u=!0,t(r)):o||u?d():o=setTimeout(()=>t(r),f)})}}},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});const l=i(189),a=i(190),r=i(8),o=Math.PI/2,h="left",s="center",n={above:{parallel:0,normal:-o,horizontal:0,vertical:-o},below:{parallel:0,normal:o,horizontal:0,vertical:o},left:{parallel:-o,normal:0,horizontal:0,vertical:-o},right:{parallel:o,normal:0,horizontal:0,vertical:o}},d={above:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"alphabetic",vertical:"middle"},below:{justified:"bottom",parallel:"hanging",normal:"middle",horizontal:"hanging",vertical:"middle"},left:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"},right:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"}},_={above:{justified:s,parallel:s,normal:h,horizontal:s,vertical:h},below:{justified:s,parallel:s,normal:h,horizontal:s,vertical:h},left:{justified:s,parallel:s,normal:"right",horizontal:"right",vertical:s},right:{justified:s,parallel:s,normal:h,horizontal:h,vertical:s}},c={above:"right",below:h,left:"right",right:h},m={above:h,below:"right",left:"right",right:h};class g extends a.ContentLayoutable{constructor(i,t){switch(super(),this.side=i,this.obj=t,this.side){case"above":this._dim=0,this._normals=[0,-1];break;case"below":this._dim=0,this._normals=[0,1];break;case"left":this._dim=1,this._normals=[-1,0];break;case"right":this._dim=1,this._normals=[1,0]}this.is_horizontal?this.set_sizing({width_policy:"max",height_policy:"fixed"}):this.set_sizing({width_policy:"fixed",height_policy:"max"})}_content_size(){return new l.Sizeable(this.get_oriented_size())}get_oriented_size(){const{width:i,height:t}=this.obj.get_size();return!this.obj.rotate||this.is_horizontal?{width:i,height:t}:{width:t,height:i}}has_size_changed(){const{width:i,height:t}=this.get_oriented_size();return this.is_horizontal?this.bbox.height!=t:this.bbox.width!=i}get dimension(){return this._dim}get normals(){return this._normals}get is_horizontal(){return 0==this._dim}get is_vertical(){return 1==this._dim}apply_label_text_heuristics(i,t){const e=this.side;let l,a;r.isString(t)?(l=d[e][t],a=_[e][t]):t<0?(l="middle",a=c[e]):(l="middle",a=m[e]),i.textBaseline=l,i.textAlign=a}get_label_angle_heuristic(i){return n[this.side][i]}}e.SidePanel=g,g.__name__="SidePanel"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(14),o=t(68),a=t(32),n=t(290),p=new i.Signal0({},"gmaps_ready");class l extends n.PlotView{initialize(){this.pause(),super.initialize(),this._tiles_loaded=!1,this.zoom_count=0;const{zoom:t,lat:e,lng:s}=this.model.map_options;if(this.initial_zoom=t,this.initial_lat=e,this.initial_lng=s,"undefined"==typeof google||null==google.maps){if(void 0===window._bokeh_gmaps_callback){!function(t){window._bokeh_gmaps_callback=()=>p.emit();const e=document.createElement("script");e.type="text/javascript",e.src=`https://maps.googleapis.com/maps/api/js?v=3.36&key=${t}&callback=_bokeh_gmaps_callback`,document.body.appendChild(e)}(atob(this.model.api_key))}p.connect(()=>this.request_render())}this.unpause()}remove(){o.remove(this.map_el),super.remove()}update_range(t){if(null==t)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),super.update_range(null);else if(null!=t.sdx||null!=t.sdy)this.map.panBy(t.sdx||0,t.sdy||0),super.update_range(t);else if(null!=t.factor){if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),super.update_range(t);const e=t.factor<0?-1:1,s=this.map.getZoom(),i=s+e;if(i>=2){this.map.setZoom(i);const[t,e,,]=this._get_projected_bounds();e-t<0&&this.map.setZoom(s)}this.unpause()}this._set_bokeh_ranges()}_build_map(){const{maps:t}=google;this.map_types={satellite:t.MapTypeId.SATELLITE,terrain:t.MapTypeId.TERRAIN,roadmap:t.MapTypeId.ROADMAP,hybrid:t.MapTypeId.HYBRID};const e=this.model.map_options,s={center:new t.LatLng(e.lat,e.lng),zoom:e.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[e.map_type],scaleControl:e.scale_control,tilt:e.tilt};null!=e.styles&&(s.styles=JSON.parse(e.styles)),this.map_el=o.div({style:{position:"absolute"}}),this.canvas_view.add_underlay(this.map_el),this.map=new t.Map(this.map_el,s),t.event.addListener(this.map,"idle",()=>this._set_bokeh_ranges()),t.event.addListener(this.map,"bounds_changed",()=>this._set_bokeh_ranges()),t.event.addListenerOnce(this.map,"tilesloaded",()=>this._render_finished()),this.connect(this.model.properties.map_options.change,()=>this._update_options()),this.connect(this.model.map_options.properties.styles.change,()=>this._update_styles()),this.connect(this.model.map_options.properties.lat.change,()=>this._update_center("lat")),this.connect(this.model.map_options.properties.lng.change,()=>this._update_center("lng")),this.connect(this.model.map_options.properties.zoom.change,()=>this._update_zoom()),this.connect(this.model.map_options.properties.map_type.change,()=>this._update_map_type()),this.connect(this.model.map_options.properties.scale_control.change,()=>this._update_scale_control()),this.connect(this.model.map_options.properties.tilt.change,()=>this._update_tilt())}_render_finished(){this._tiles_loaded=!0,this.notify_finished()}has_finished(){return super.has_finished()&&!0===this._tiles_loaded}_get_latlon_bounds(){const t=this.map.getBounds(),e=t.getNorthEast(),s=t.getSouthWest();return[s.lng(),e.lng(),s.lat(),e.lat()]}_get_projected_bounds(){const[t,e,s,i]=this._get_latlon_bounds(),[o,n]=a.wgs84_mercator.forward([t,s]),[p,l]=a.wgs84_mercator.forward([e,i]);return[o,p,n,l]}_set_bokeh_ranges(){const[t,e,s,i]=this._get_projected_bounds();this.frame.x_range.setv({start:t,end:e}),this.frame.y_range.setv({start:s,end:i})}_update_center(t){const e=this.map.getCenter().toJSON();e[t]=this.model.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges()}_update_map_type(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})}_update_scale_control(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})}_update_tilt(){this.map.setOptions({tilt:this.model.map_options.tilt})}_update_options(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()}_update_styles(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})}_update_zoom(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()}_map_hook(t,e){if(null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map(),null!=this.map_el){const[t,s,i,o]=e;this.map_el.style.top=s+"px",this.map_el.style.left=t+"px",this.map_el.style.width=i+"px",this.map_el.style.height=o+"px"}}_paint_empty(t,e){const s=this.layout._width.value,i=this.layout._height.value,[o,a,n,p]=e;t.clearRect(0,0,s,i),t.beginPath(),t.moveTo(0,0),t.lineTo(0,i),t.lineTo(s,i),t.lineTo(s,0),t.lineTo(0,0),t.moveTo(o,a),t.lineTo(o+n,a),t.lineTo(o+n,a+p),t.lineTo(o,a+p),t.lineTo(o,a),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=this.model.border_fill_color,t.fill())}}s.GMapPlotView=l,l.__name__="GMapPlotView"},
function _(a,e,n){Object.defineProperty(n,"__esModule",{value:!0});var g=a(187);n.DataRange=g.DataRange;var R=a(186);n.DataRange1d=R.DataRange1d;var r=a(90);n.FactorRange=r.FactorRange;var t=a(91);n.Range=t.Range;var d=a(131);n.Range1d=d.Range1d},
function _(e,r,d){Object.defineProperty(d,"__esModule",{value:!0});var n=e(81);d.GlyphRenderer=n.GlyphRenderer;var R=e(100);d.GraphRenderer=R.GraphRenderer;var a=e(151);d.GuideRenderer=a.GuideRenderer;var G=e(65);d.Renderer=G.Renderer},
function _(a,e,c){Object.defineProperty(c,"__esModule",{value:!0});var l=a(185);c.CategoricalScale=l.CategoricalScale;var o=a(121);c.ContinuousScale=o.ContinuousScale;var r=a(120);c.LinearScale=r.LinearScale;var S=a(130);c.LogScale=S.LogScale;var n=a(122);c.Scale=n.Scale},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0}),e(1).__exportStar(e(102),o);var n=e(79);o.Selection=n.Selection},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var o=a(302);r.ServerSentDataSource=o.ServerSentDataSource;var S=a(304);r.AjaxDataSource=S.AjaxDataSource;var u=a(76);r.ColumnDataSource=u.ColumnDataSource;var t=a(77);r.ColumnarDataSource=t.ColumnarDataSource;var c=a(98);r.CDSView=c.CDSView;var D=a(78);r.DataSource=D.DataSource;var v=a(305);r.GeoJSONDataSource=v.GeoJSONDataSource;var n=a(303);r.WebDataSource=n.WebDataSource},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const a=e(303);class s extends a.WebDataSource{constructor(e){super(e),this.initialized=!1}destroy(){super.destroy()}setup(){if(!this.initialized){this.initialized=!0,new EventSource(this.data_url).onmessage=e=>{this.load_data(JSON.parse(e.data),this.mode,this.max_size)}}}}i.ServerSentDataSource=s,s.__name__="ServerSentDataSource"},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const r=e(1),s=e(76),i=r.__importStar(e(18));class n extends s.ColumnDataSource{constructor(e){super(e)}get_column(e){const t=this.data[e];return null!=t?t:[]}initialize(){super.initialize(),this.setup()}load_data(e,t,a){const{adapter:r}=this;let s;switch(s=null!=r?r.execute(this,{response:e}):e,t){case"replace":this.data=s;break;case"append":{const e=this.data;for(const t of this.columns()){const r=Array.from(e[t]),i=Array.from(s[t]);s[t]=r.concat(i).slice(-a)}this.data=s;break}}}static init_WebDataSource(){this.define({mode:[i.UpdateMode,"replace"],max_size:[i.Number],adapter:[i.Any,null],data_url:[i.String]})}}a.WebDataSource=n,n.__name__="WebDataSource",n.init_WebDataSource()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),a=t(303),r=t(72),o=s.__importStar(t(18));class n extends a.WebDataSource{constructor(t){super(t),this.initialized=!1}static init_AjaxDataSource(){this.define({polling_interval:[o.Number],content_type:[o.String,"application/json"],http_headers:[o.Any,{}],method:[o.HTTPMethod,"POST"],if_modified:[o.Boolean,!1]})}destroy(){null!=this.interval&&clearInterval(this.interval),super.destroy()}setup(){if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),this.polling_interval)){const t=()=>this.get_data(this.mode,this.max_size,this.if_modified);this.interval=setInterval(t,this.polling_interval)}}get_data(t,e=0,i=!1){const s=this.prepare_request();s.addEventListener("load",()=>this.do_load(s,t,e)),s.addEventListener("error",()=>this.do_error(s)),s.send()}prepare_request(){const t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);const e=this.http_headers;for(const i in e){const s=e[i];t.setRequestHeader(i,s)}return t}do_load(t,e,i){if(200===t.status){const s=JSON.parse(t.responseText);this.load_data(s,e,i)}}do_error(t){r.logger.error(`Failed to fetch JSON from ${this.data_url} with code ${t.status}`)}}i.AjaxDataSource=n,n.__name__="AjaxDataSource",n.init_AjaxDataSource()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const r=e(1),n=e(77),s=e(72),a=r.__importStar(e(18)),i=e(9);function l(e){return null!=e?e:NaN}class c extends n.ColumnarDataSource{constructor(e){super(e)}static init_GeoJSONDataSource(){this.define({geojson:[a.Any]}),this.internal({data:[a.Any,{}]})}initialize(){super.initialize(),this._update_data()}connect_signals(){super.connect_signals(),this.connect(this.properties.geojson.change,()=>this._update_data())}_update_data(){this.data=this.geojson_to_column_data()}_get_new_list_array(e){return i.range(0,e).map(e=>[])}_get_new_nan_array(e){return i.range(0,e).map(e=>NaN)}_add_properties(e,t,o,r){const n=e.properties||{};for(const e in n)t.hasOwnProperty(e)||(t[e]=this._get_new_nan_array(r)),t[e][o]=l(n[e])}_add_geometry(e,t,o){function r(e,t){return e.concat([[NaN,NaN,NaN]]).concat(t)}switch(e.type){case"Point":{const[r,n,s]=e.coordinates;t.x[o]=r,t.y[o]=n,t.z[o]=l(s);break}case"LineString":{const{coordinates:r}=e;for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=l(a)}break}case"Polygon":{e.coordinates.length>1&&s.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");const r=e.coordinates[0];for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=l(a)}break}case"MultiPoint":s.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":{const n=e.coordinates.reduce(r);for(let e=0;e<n.length;e++){const[r,s,a]=n[e];t.xs[o][e]=r,t.ys[o][e]=s,t.zs[o][e]=l(a)}break}case"MultiPolygon":{const n=[];for(const t of e.coordinates)t.length>1&&s.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),n.push(t[0]);const a=n.reduce(r);for(let e=0;e<a.length;e++){const[r,n,s]=a[e];t.xs[o][e]=r,t.ys[o][e]=n,t.zs[o][e]=l(s)}break}default:throw new Error("Invalid GeoJSON geometry type: "+e.type)}}geojson_to_column_data(){const e=JSON.parse(this.geojson);let t;switch(e.type){case"GeometryCollection":if(null==e.geometries)throw new Error("No geometries found in GeometryCollection");if(0===e.geometries.length)throw new Error("geojson.geometries must have one or more items");t=e.geometries;break;case"FeatureCollection":if(null==e.features)throw new Error("No features found in FeaturesCollection");if(0==e.features.length)throw new Error("geojson.features must have one or more items");t=e.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}let o=0;for(const e of t){const t="Feature"===e.type?e.geometry:e;"GeometryCollection"==t.type?o+=t.geometries.length:o+=1}const r={x:this._get_new_nan_array(o),y:this._get_new_nan_array(o),z:this._get_new_nan_array(o),xs:this._get_new_list_array(o),ys:this._get_new_list_array(o),zs:this._get_new_list_array(o)};let n=0;for(const e of t){const t="Feature"==e.type?e.geometry:e;if("GeometryCollection"==t.type)for(const s of t.geometries)this._add_geometry(s,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1;else this._add_geometry(t,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1}return r}}o.GeoJSONDataSource=c,c.__name__="GeoJSONDataSource",c.init_GeoJSONDataSource()},
function _(e,r,i){Object.defineProperty(i,"__esModule",{value:!0});var c=e(110);i.AdaptiveTicker=c.AdaptiveTicker;var a=e(109);i.BasicTicker=a.BasicTicker;var k=e(153);i.CategoricalTicker=k.CategoricalTicker;var T=e(164);i.CompositeTicker=T.CompositeTicker;var t=e(111);i.ContinuousTicker=t.ContinuousTicker;var o=e(163);i.DatetimeTicker=o.DatetimeTicker;var v=e(165);i.DaysTicker=v.DaysTicker;var n=e(307);i.FixedTicker=n.FixedTicker;var s=e(172);i.LogTicker=s.LogTicker;var l=e(175);i.MercatorTicker=l.MercatorTicker;var u=e(168);i.MonthsTicker=u.MonthsTicker;var d=e(166);i.SingleIntervalTicker=d.SingleIntervalTicker;var g=e(112);i.Ticker=g.Ticker;var C=e(169);i.YearsTicker=C.YearsTicker},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});const r=i(1),n=i(111),s=r.__importStar(i(18));class _ extends n.ContinuousTicker{constructor(i){super(i),this.min_interval=0,this.max_interval=0}static init_FixedTicker(){this.define({ticks:[s.Array,[]],minor_ticks:[s.Array,[]]})}get_ticks_no_defaults(i,t,e,r){return{major:this.ticks,minor:this.minor_ticks}}get_interval(i,t,e){return 0}}e.FixedTicker=_,_.__name__="FixedTicker",_.init_FixedTicker()},
function _(e,r,o){Object.defineProperty(o,"__esModule",{value:!0});var T=e(309);o.BBoxTileSource=T.BBoxTileSource;var c=e(310);o.MercatorTileSource=c.MercatorTileSource;var i=e(313);o.QUADKEYTileSource=i.QUADKEYTileSource;var l=e(314);o.TileRenderer=l.TileRenderer;var S=e(311);o.TileSource=S.TileSource;var u=e(318);o.TMSTileSource=u.TMSTileSource;var a=e(315);o.WMTSTileSource=a.WMTSTileSource},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const o=e(1),i=e(310),l=o.__importStar(e(18));class _ extends i.MercatorTileSource{constructor(e){super(e)}static init_BBoxTileSource(){this.define({use_latlon:[l.Boolean,!1]})}get_image_url(e,t,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars);let i,l,_,n;return this.use_latlon?[l,n,i,_]=this.get_tile_geographic_bounds(e,t,r):[l,n,i,_]=this.get_tile_meter_bounds(e,t,r),o.replace("{XMIN}",l.toString()).replace("{YMIN}",n.toString()).replace("{XMAX}",i.toString()).replace("{YMAX}",_.toString())}}r.BBoxTileSource=_,_.__name__="BBoxTileSource",_.init_BBoxTileSource()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const _=t(1),s=t(311),r=_.__importStar(t(18)),o=t(9),n=t(312);class l extends s.TileSource{constructor(t){super(t)}static init_MercatorTileSource(){this.define({snap_to_zoom:[r.Boolean,!1],wrap_around:[r.Boolean,!0]}),this.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})}initialize(){super.initialize(),this._resolutions=o.range(this.min_zoom,this.max_zoom+1).map(t=>this.get_resolution(t))}_computed_initial_resolution(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size}is_valid_tile(t,e,i){return!(!this.wrap_around&&(t<0||t>=2**i))&&!(e<0||e>=2**i)}parent_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=_.substring(0,_.length-1);return this.quadkey_to_tile_xyz(s)}get_resolution(t){return this._computed_initial_resolution()/2**t}get_resolution_by_extent(t,e,i){return[(t[2]-t[0])/i,(t[3]-t[1])/e]}get_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s);let o=0;for(const t of this._resolutions){if(r>t){if(0==o)return 0;if(o>0)return o-1}o+=1}return o-1}get_closest_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s),o=this._resolutions.reduce((function(t,e){return Math.abs(e-r)<Math.abs(t-r)?e:t}));return this._resolutions.indexOf(o)}snap_to_zoom_level(t,e,i,_){const[s,r,o,n]=t,l=this._resolutions[_];let u=i*l,a=e*l;if(!this.snap_to_zoom){const t=(o-s)/u,e=(n-r)/a;t>e?(u=o-s,a*=t):(u*=e,a=n-r)}const h=(u-(o-s))/2,c=(a-(n-r))/2;return[s-h,r-c,o+h,n+c]}tms_to_wmts(t,e,i){return[t,2**i-1-e,i]}wmts_to_tms(t,e,i){return[t,2**i-1-e,i]}pixels_to_meters(t,e,i){const _=this.get_resolution(i);return[t*_-this.x_origin_offset,e*_-this.y_origin_offset]}meters_to_pixels(t,e,i){const _=this.get_resolution(i);return[(t+this.x_origin_offset)/_,(e+this.y_origin_offset)/_]}pixels_to_tile(t,e){let i=Math.ceil(t/this.tile_size);return i=0===i?i:i-1,[i,Math.max(Math.ceil(e/this.tile_size)-1,0)]}pixels_to_raster(t,e,i){return[t,(this.tile_size<<i)-e]}meters_to_tile(t,e,i){const[_,s]=this.meters_to_pixels(t,e,i);return this.pixels_to_tile(_,s)}get_tile_meter_bounds(t,e,i){const[_,s]=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,i),[r,o]=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,i);return[_,s,r,o]}get_tile_geographic_bounds(t,e,i){const _=this.get_tile_meter_bounds(t,e,i),[s,r,o,l]=n.meters_extent_to_geographic(_);return[s,r,o,l]}get_tiles_by_extent(t,e,i=1){const[_,s,r,o]=t;let[n,l]=this.meters_to_tile(_,s,e),[u,a]=this.meters_to_tile(r,o,e);n-=i,l-=i,u+=i,a+=i;const h=[];for(let t=a;t>=l;t--)for(let i=n;i<=u;i++)this.is_valid_tile(i,t,e)&&h.push([i,t,e,this.get_tile_meter_bounds(i,t,e)]);return this.sort_tiles_from_center(h,[n,l,u,a]),h}quadkey_to_tile_xyz(t){let e=0,i=0;const _=t.length;for(let s=_;s>0;s--){const r=1<<s-1;switch(t.charAt(_-s)){case"0":continue;case"1":e|=r;break;case"2":i|=r;break;case"3":e|=r,i|=r;break;default:throw new TypeError("Invalid Quadkey: "+t)}}return[e,i,_]}tile_xyz_to_quadkey(t,e,i){let _="";for(let s=i;s>0;s--){const i=1<<s-1;let r=0;0!=(t&i)&&(r+=1),0!=(e&i)&&(r+=2),_+=r.toString()}return _}children_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=[];for(let t=0;t<=3;t++){const[e,i,r]=this.quadkey_to_tile_xyz(_+t.toString()),o=this.get_tile_meter_bounds(e,i,r);s.push([e,i,r,o])}return s}get_closest_parent_by_tile_xyz(t,e,i){const _=this.calculate_world_x_by_tile_xyz(t,e,i);[t,e,i]=this.normalize_xyz(t,e,i);let s=this.tile_xyz_to_quadkey(t,e,i);for(;s.length>0;)if(s=s.substring(0,s.length-1),[t,e,i]=this.quadkey_to_tile_xyz(s),[t,e,i]=this.denormalize_xyz(t,e,i,_),this.tiles.has(this.tile_xyz_to_key(t,e,i)))return[t,e,i];return[0,0,0]}normalize_xyz(t,e,i){if(this.wrap_around){const _=2**i;return[(t%_+_)%_,e,i]}return[t,e,i]}denormalize_xyz(t,e,i,_){return[t+_*2**i,e,i]}denormalize_meters(t,e,i,_){return[t+2*_*Math.PI*6378137,e]}calculate_world_x_by_tile_xyz(t,e,i){return Math.floor(t/2**i)}}i.MercatorTileSource=l,l.__name__="MercatorTileSource",l.init_MercatorTileSource()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const i=e(1),n=e(71),s=e(17),l=i.__importStar(e(18));class a extends n.Model{constructor(e){super(e)}static init_TileSource(){this.define({url:[l.String,""],tile_size:[l.Number,256],max_zoom:[l.Number,30],min_zoom:[l.Number,0],extra_url_vars:[l.Any,{}],attribution:[l.String,""],x_origin_offset:[l.Number],y_origin_offset:[l.Number],initial_resolution:[l.Number]})}initialize(){super.initialize(),this.tiles=new Map,this._normalize_case()}connect_signals(){super.connect_signals(),this.connect(this.change,()=>this._clear_cache())}string_lookup_replace(e,t){let r=e;for(const[e,i]of s.entries(t))r=r.replace(`{${e}}`,i);return r}_normalize_case(){const e=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=e}_clear_cache(){this.tiles=new Map}tile_xyz_to_key(e,t,r){return`${e}:${t}:${r}`}key_to_tile_xyz(e){const[t,r,i]=e.split(":").map(e=>parseInt(e));return[t,r,i]}sort_tiles_from_center(e,t){const[r,i,n,s]=t,l=(n-r)/2+r,a=(s-i)/2+i;e.sort((function(e,t){return Math.sqrt((l-e[0])**2+(a-e[1])**2)-Math.sqrt((l-t[0])**2+(a-t[1])**2)}))}get_image_url(e,t,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",t.toString()).replace("{Z}",r.toString())}}r.TileSource=a,a.__name__="TileSource",a.init_TileSource()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const n=e(32);function o(e,t){return n.wgs84_mercator.forward([e,t])}function c(e,t){return n.wgs84_mercator.inverse([e,t])}r.geographic_to_meters=o,r.meters_to_geographic=c,r.geographic_extent_to_meters=function(e){const[t,r,n,c]=e,[_,i]=o(t,r),[s,u]=o(n,c);return[_,i,s,u]},r.meters_extent_to_geographic=function(e){const[t,r,n,o]=e,[_,i]=c(t,r),[s,u]=c(n,o);return[_,i,s,u]}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const _=e(310);class s extends _.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const _=this.string_lookup_replace(this.url,this.extra_url_vars),[s,o,u]=this.tms_to_wmts(e,t,r),c=this.tile_xyz_to_quadkey(s,o,u);return _.replace("{Q}",c)}}r.QUADKEYTileSource=s,s.__name__="QUADKEYTileSource"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),_=e(315),a=e(82),n=e(131),r=e(68),h=s.__importStar(e(18)),l=e(224),o=e(9),d=e(8),m=e(80),c=e(76),u=e(316),p=s.__importDefault(e(317));class g extends a.DataRendererView{initialize(){this._tiles=[],super.initialize()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render()),this.connect(this.model.tile_source.change,()=>this.request_render())}styles(){return[...super.styles(),p.default]}get_extent(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]}get map_plot(){return this.plot_model}get map_canvas(){return this.layer.ctx}get map_frame(){return this.plot_view.frame}get x_range(){return this.map_plot.x_range}get y_range(){return this.map_plot.y_range}_set_data(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0}_update_attribution(){null!=this.attribution_el&&r.removeElement(this.attribution_el);const{attribution:e}=this.model.tile_source;if(d.isString(e)&&e.length>0){const{layout:t,frame:i}=this.plot_view,s=t._width.value-i._right.value,_=t._height.value-i._bottom.value,a=i._width.value;this.attribution_el=r.div({class:u.bk_tile_attribution,style:{position:"absolute",right:s+"px",bottom:_+"px","max-width":a-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"9px","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}}),this.plot_view.canvas_view.add_event(this.attribution_el),this.attribution_el.innerHTML=e,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}}_map_data(){this.initial_extent=this.get_extent();const e=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value),t=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value,e);this.x_range.start=t[0],this.y_range.start=t[1],this.x_range.end=t[2],this.y_range.end=t[3],this.x_range instanceof n.Range1d&&(this.x_range.reset_start=t[0],this.x_range.reset_end=t[2]),this.y_range instanceof n.Range1d&&(this.y_range.reset_start=t[1],this.y_range.reset_end=t[3]),this._update_attribution()}_create_tile(e,t,i,s,_=!1){const[a,n,r]=this.model.tile_source.normalize_xyz(e,t,i),h={img:void 0,tile_coords:[e,t,i],normalized_coords:[a,n,r],quadkey:this.model.tile_source.tile_xyz_to_quadkey(e,t,i),cache_key:this.model.tile_source.tile_xyz_to_key(e,t,i),bounds:s,loaded:!1,finished:!1,x_coord:s[0],y_coord:s[3]},o=this.model.tile_source.get_image_url(a,n,r);new l.ImageLoader(o,{loaded:e=>{Object.assign(h,{img:e,loaded:!0}),_?(h.finished=!0,this.notify_finished()):this.request_render()},failed(){h.finished=!0}}),this.model.tile_source.tiles.set(h.cache_key,h),this._tiles.push(h)}_enforce_aspect_ratio(){if(this._last_height!==this.map_frame._height.value||this._last_width!==this.map_frame._width.value){const e=this.get_extent(),t=this.model.tile_source.get_level_by_extent(e,this.map_frame._height.value,this.map_frame._width.value),i=this.model.tile_source.snap_to_zoom_level(e,this.map_frame._height.value,this.map_frame._width.value,t);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame._height.value,this._last_width=this.map_frame._width.value}}has_finished(){if(!super.has_finished())return!1;if(0===this._tiles.length)return!1;for(const e of this._tiles)if(!e.finished)return!1;return!0}render(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()}_draw_tile(e){const t=this.model.tile_source.tiles.get(e);if(null!=t&&t.loaded){const[[e],[i]]=this.plot_view.map_to_screen([t.bounds[0]],[t.bounds[3]]),[[s],[_]]=this.plot_view.map_to_screen([t.bounds[2]],[t.bounds[1]]),a=s-e,n=_-i,r=e,h=i,l=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(t.img,r,h,a,n),this.map_canvas.setImageSmoothingEnabled(l),t.finished=!0}}_set_rect(){const e=this.plot_model.properties.outline_line_width.value(),t=this.map_frame._left.value+e/2,i=this.map_frame._top.value+e/2,s=this.map_frame._width.value-e,_=this.map_frame._height.value-e;this.map_canvas.rect(t,i,s,_),this.map_canvas.clip()}_render_tiles(e){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(const t of e)this._draw_tile(t);this.map_canvas.restore()}_prefetch_tiles(){const{tile_source:e}=this.model,t=this.get_extent(),i=this.map_frame._height.value,s=this.map_frame._width.value,_=this.model.tile_source.get_level_by_extent(t,i,s),a=this.model.tile_source.get_tiles_by_extent(t,_);for(let t=0,i=Math.min(10,a.length);t<i;t++){const[i,s,_]=a[t],n=this.model.tile_source.children_by_tile_xyz(i,s,_);for(const t of n){const[i,s,_,a]=t;e.tiles.has(e.tile_xyz_to_key(i,s,_))||this._create_tile(i,s,_,a,!0)}}}_fetch_tiles(e){for(const t of e){const[e,i,s,_]=t;this._create_tile(e,i,s,_)}}_update(){const{tile_source:e}=this.model,{min_zoom:t}=e,{max_zoom:i}=e;let s=this.get_extent();const _=this.extent[2]-this.extent[0]<s[2]-s[0],a=this.map_frame._height.value,n=this.map_frame._width.value;let r=e.get_level_by_extent(s,a,n),h=!1;r<t?(s=this.extent,r=t,h=!0):r>i&&(s=this.extent,r=i,h=!0),h&&(this.x_range.setv({x_range:{start:s[0],end:s[2]}}),this.y_range.setv({start:s[1],end:s[3]})),this.extent=s;const l=e.get_tiles_by_extent(s,r),d=[],m=[],c=[],u=[];for(const t of l){const[i,s,a]=t,n=e.tile_xyz_to_key(i,s,a),r=e.tiles.get(n);if(null!=r&&r.loaded)m.push(n);else if(this.model.render_parents){const[t,n,r]=e.get_closest_parent_by_tile_xyz(i,s,a),h=e.tile_xyz_to_key(t,n,r),l=e.tiles.get(h);if(null!=l&&l.loaded&&!o.includes(c,h)&&c.push(h),_){const t=e.children_by_tile_xyz(i,s,a);for(const[i,s,_]of t){const t=e.tile_xyz_to_key(i,s,_);e.tiles.has(t)&&u.push(t)}}}null==r&&d.push(t)}this._render_tiles(c),this._render_tiles(u),this._render_tiles(m),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout(()=>this._fetch_tiles(d),65)}}i.TileRendererView=g,g.__name__="TileRendererView";class f extends a.DataRenderer{constructor(e){super(e),this._selection_manager=new m.SelectionManager({source:new c.ColumnDataSource})}static init_TileRenderer(){this.prototype.default_view=g,this.define({alpha:[h.Number,1],smoothing:[h.Boolean,!0],tile_source:[h.Instance,()=>new _.WMTSTileSource],render_parents:[h.Boolean,!0]})}get_selection_manager(){return this._selection_manager}}i.TileRenderer=f,f.__name__="TileRenderer",f.init_TileRenderer()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const o=e(310);class s extends o.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars),[s,c,_]=this.tms_to_wmts(e,t,r);return o.replace("{X}",s.toString()).replace("{Y}",c.toString()).replace("{Z}",_.toString())}}r.WMTSTileSource=s,s.__name__="WMTSTileSource"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0}),i.bk_tile_attribution="bk-tile-attribution"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});n.default="\n.bk-root .bk-tile-attribution a {\n  color: black;\n}\n"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(310);class c extends o.MercatorTileSource{constructor(e){super(e)}get_image_url(e,r,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",r.toString()).replace("{Z}",t.toString())}}t.TMSTileSource=c,c.__name__="TMSTileSource"},
function _(e,r,a){Object.defineProperty(a,"__esModule",{value:!0});var t=e(320);a.CanvasTexture=t.CanvasTexture;var u=e(322);a.ImageURLTexture=u.ImageURLTexture;var v=e(321);a.Texture=v.Texture},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const r=t(1),c=t(321),s=r.__importStar(t(18)),i=t(24);class a extends c.Texture{constructor(t){super(t)}static init_CanvasTexture(){this.define({code:[s.String]})}get func(){const t=i.use_strict(this.code);return new Function("ctx","color","scale","weight",t)}get_pattern(t,e,n){return r=>{const c=document.createElement("canvas");c.width=e,c.height=e;const s=c.getContext("2d");return this.func.call(this,s,t,e,n),r.createPattern(c,this.repetition)}}}n.CanvasTexture=a,a.__name__="CanvasTexture",a.init_CanvasTexture()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const r=e(1),n=e(71),o=r.__importStar(e(18));class _ extends n.Model{constructor(e){super(e)}static init_Texture(){this.define({repetition:[o.TextureRepetition,"repeat"]})}onload(e){e()}}i.Texture=_,_.__name__="Texture",_.init_Texture()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const r=e(1),a=e(321),n=r.__importStar(e(18)),s=e(224);class o extends a.Texture{constructor(e){super(e)}static init_ImageURLTexture(){this.define({url:[n.String]})}initialize(){super.initialize(),this._loader=new s.ImageLoader(this.url)}get_pattern(e,t,i){return e=>this._loader.finished?e.createPattern(this._loader.image,this.repetition):null}onload(e){this._loader.promise.then(()=>e())}}i.ImageURLTexture=o,o.__name__="ImageURLTexture",o.init_ImageURLTexture()},
function _(o,l,T){Object.defineProperty(T,"__esModule",{value:!0});var a=o(285);T.ActionTool=a.ActionTool;var r=o(324);T.CustomAction=r.CustomAction;var e=o(286);T.HelpTool=e.HelpTool;var v=o(325);T.RedoTool=v.RedoTool;var t=o(326);T.ResetTool=t.ResetTool;var n=o(327);T.SaveTool=n.SaveTool;var s=o(328);T.UndoTool=s.UndoTool;var i=o(329);T.ZoomInTool=i.ZoomInTool;var P=o(331);T.ZoomOutTool=P.ZoomOutTool;var c=o(275);T.ButtonTool=c.ButtonTool;var d=o(332);T.EditTool=d.EditTool;var u=o(333);T.BoxEditTool=u.BoxEditTool;var y=o(334);T.FreehandDrawTool=y.FreehandDrawTool;var m=o(335);T.PointDrawTool=m.PointDrawTool;var x=o(336);T.PolyDrawTool=x.PolyDrawTool;var B=o(337);T.PolyTool=B.PolyTool;var S=o(338);T.PolyEditTool=S.PolyEditTool;var b=o(339);T.BoxSelectTool=b.BoxSelectTool;var h=o(342);T.BoxZoomTool=h.BoxZoomTool;var E=o(284);T.GestureTool=E.GestureTool;var Z=o(343);T.LassoSelectTool=Z.LassoSelectTool;var p=o(344);T.LineEditTool=p.LineEditTool;var w=o(346);T.PanTool=w.PanTool;var C=o(347);T.PolySelectTool=C.PolySelectTool;var D=o(348);T.RangeTool=D.RangeTool;var H=o(340);T.SelectTool=H.SelectTool;var R=o(349);T.TapTool=R.TapTool;var A=o(350);T.WheelPanTool=A.WheelPanTool;var I=o(351);T.WheelZoomTool=I.WheelZoomTool;var L=o(352);T.CrosshairTool=L.CrosshairTool;var W=o(353);T.CustomJSHover=W.CustomJSHover;var O=o(354);T.HoverTool=O.HoverTool;var _=o(274);T.InspectTool=_.InspectTool;var f=o(277);T.Tool=f.Tool;var g=o(355);T.ToolProxy=g.ToolProxy;var F=o(273);T.Toolbar=F.Toolbar;var G=o(283);T.ToolbarBase=G.ToolbarBase;var J=o(357);T.ProxyToolbar=J.ProxyToolbar;var U=o(357);T.ToolbarBox=U.ToolbarBox},
function _(t,o,i){Object.defineProperty(i,"__esModule",{value:!0});const n=t(1),s=t(285),e=n.__importStar(t(18)),c=t(278);class _ extends s.ActionToolButtonView{css_classes(){return super.css_classes().concat(c.bk_toolbar_button_custom_action)}}i.CustomActionButtonView=_,_.__name__="CustomActionButtonView";class l extends s.ActionToolView{doit(){null!=this.model.callback&&this.model.callback.execute(this.model)}}i.CustomActionView=l,l.__name__="CustomActionView";class u extends s.ActionTool{constructor(t){super(t),this.tool_name="Custom Action",this.button_view=_}static init_CustomAction(){this.prototype.default_view=l,this.define({action_tooltip:[e.String,"Perform a Custom Action"],callback:[e.Any],icon:[e.String]})}get tooltip(){return this.action_tooltip}}i.CustomAction=u,u.__name__="CustomAction",u.init_CustomAction()},
function _(o,e,t){Object.defineProperty(t,"__esModule",{value:!0});const i=o(285),s=o(287);class n extends i.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state_changed,()=>this.model.disabled=!this.plot_view.can_redo())}doit(){this.plot_view.redo()}}t.RedoToolView=n,n.__name__="RedoToolView";class _ extends i.ActionTool{constructor(o){super(o),this.tool_name="Redo",this.icon=s.bk_tool_icon_redo}static init_RedoTool(){this.prototype.default_view=n,this.override({disabled:!0}),this.register_alias("redo",()=>new _)}}t.RedoTool=_,_.__name__="RedoTool",_.init_RedoTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const s=e(285),i=e(287);class _ extends s.ActionToolView{doit(){this.plot_view.reset()}}o.ResetToolView=_,_.__name__="ResetToolView";class l extends s.ActionTool{constructor(e){super(e),this.tool_name="Reset",this.icon=i.bk_tool_icon_reset}static init_ResetTool(){this.prototype.default_view=_,this.register_alias("reset",()=>new l)}}o.ResetTool=l,l.__name__="ResetTool",l.init_ResetTool()},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});const i=e(285),s=e(287);class _ extends i.ActionToolView{doit(){this.plot_view.save("bokeh_plot")}}t.SaveToolView=_,_.__name__="SaveToolView";class a extends i.ActionTool{constructor(e){super(e),this.tool_name="Save",this.icon=s.bk_tool_icon_save}static init_SaveTool(){this.prototype.default_view=_,this.register_alias("save",()=>new a)}}t.SaveTool=a,a.__name__="SaveTool",a.init_SaveTool()},
function _(o,t,e){Object.defineProperty(e,"__esModule",{value:!0});const n=o(285),i=o(287);class s extends n.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state_changed,()=>this.model.disabled=!this.plot_view.can_undo())}doit(){this.plot_view.undo()}}e.UndoToolView=s,s.__name__="UndoToolView";class _ extends n.ActionTool{constructor(o){super(o),this.tool_name="Undo",this.icon=i.bk_tool_icon_undo}static init_UndoTool(){this.prototype.default_view=s,this.override({disabled:!0}),this.register_alias("undo",()=>new _)}}e.UndoTool=_,_.__name__="UndoTool",_.init_UndoTool()},
function _(o,t,i){Object.defineProperty(i,"__esModule",{value:!0});const e=o(1),n=o(285),s=o(330),_=e.__importStar(o(18)),m=o(287);class l extends n.ActionToolView{doit(){const o=this.plot_view.frame,t=this.model.dimensions,i="width"==t||"both"==t,e="height"==t||"both"==t,n=s.scale_range(o,this.model.factor,i,e);this.plot_view.push_state("zoom_out",{range:n}),this.plot_view.update_range(n,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)}}i.ZoomInToolView=l,l.__name__="ZoomInToolView";class h extends n.ActionTool{constructor(o){super(o),this.tool_name="Zoom In",this.icon=m.bk_tool_icon_zoom_in}static init_ZoomInTool(){this.prototype.default_view=l,this.define({factor:[_.Percent,.1],dimensions:[_.Dimensions,"both"]}),this.register_alias("zoom_in",()=>new h({dimensions:"both"})),this.register_alias("xzoom_in",()=>new h({dimensions:"width"})),this.register_alias("yzoom_in",()=>new h({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}i.ZoomInTool=h,h.__name__="ZoomInTool",h.init_ZoomInTool()},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});const o=n(10);function r(n,t,e){const[o,r]=[n.start,n.end],c=null!=e?e:(r+o)/2;return[o-(o-c)*t,r-(r-c)*t]}function c(n,[t,e]){const o={};for(const r in n){const c=n[r],[s,l]=c.r_invert(t,e);o[r]={start:s,end:l}}return o}e.scale_highlow=r,e.get_info=c,e.scale_range=function(n,t,e=!0,s=!0,l){t=o.clamp(t,-.9,.9);const a=e?t:0,[u,i]=r(n.bbox.h_range,a,null!=l?l.x:void 0),_=c(n.xscales,[u,i]),f=s?t:0,[d,b]=r(n.bbox.v_range,f,null!=l?l.y:void 0);return{xrs:_,yrs:c(n.yscales,[d,b]),factor:t}}},
function _(o,t,i){Object.defineProperty(i,"__esModule",{value:!0});const e=o(1),s=o(285),n=o(330),_=e.__importStar(o(18)),m=o(287);class l extends s.ActionToolView{doit(){const o=this.plot_view.frame,t=this.model.dimensions,i="width"==t||"both"==t,e="height"==t||"both"==t,s=n.scale_range(o,-this.model.factor,i,e);this.plot_view.push_state("zoom_out",{range:s}),this.plot_view.update_range(s,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)}}i.ZoomOutToolView=l,l.__name__="ZoomOutToolView";class h extends s.ActionTool{constructor(o){super(o),this.tool_name="Zoom Out",this.icon=m.bk_tool_icon_zoom_out}static init_ZoomOutTool(){this.prototype.default_view=l,this.define({factor:[_.Percent,.1],dimensions:[_.Dimensions,"both"]}),this.register_alias("zoom_out",()=>new h({dimensions:"both"})),this.register_alias("xzoom_out",()=>new h({dimensions:"width"})),this.register_alias("yzoom_out",()=>new h({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}i.ZoomOutTool=h,h.__name__="ZoomOutTool",h.init_ZoomOutTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const o=e(1).__importStar(e(18)),n=e(9),i=e(8),r=e(11),_=e(284);class c extends _.GestureToolView{constructor(){super(...arguments),this._mouse_in_frame=!0}_select_mode(e){const{shiftKey:t,ctrlKey:s}=e;return t||s?t&&!s?"append":!t&&s?"intersect":t&&s?"subtract":void r.unreachable():"replace"}_move_enter(e){this._mouse_in_frame=!0}_move_exit(e){this._mouse_in_frame=!1}_map_drag(e,t,s){const o=this.plot_view.frame;return o.bbox.contains(e,t)?[o.xscales[s.x_range_name].invert(e),o.yscales[s.y_range_name].invert(t)]:null}_delete_selected(e){const t=e.data_source,s=t.selected.indices;s.sort();for(const e of t.columns()){const o=t.get_array(e);for(let e=0;e<s.length;e++){const t=s[e];o.splice(t-e,1)}}this._emit_cds_changes(t)}_pop_glyphs(e,t){const s=e.columns();if(t&&s.length)for(const o of s){let s=e.get_array(o);const n=s.length-t+1;n<1||(i.isArray(s)||(s=Array.from(s),e.data[o]=s),s.splice(0,n))}}_emit_cds_changes(e,t=!0,s=!0,o=!0){s&&e.selection_manager.clear(),t&&e.change.emit(),o&&(e.data=e.data,e.properties.data.change.emit())}_drag_points(e,t,s="both"){if(null==this._basepoint)return;const[o,n]=this._basepoint;for(const i of t){const t=this._map_drag(o,n,i),r=this._map_drag(e.sx,e.sy,i);if(null==r||null==t)continue;const[_,c]=r,[a,l]=t,[d,u]=[_-a,c-l],m=i.glyph,h=i.data_source,[p,f]=[m.x.field,m.y.field];for(const e of h.selected.indices)!p||"width"!=s&&"both"!=s||(h.data[p][e]+=d),!f||"height"!=s&&"both"!=s||(h.data[f][e]+=u);h.change.emit()}this._basepoint=[e.sx,e.sy]}_pad_empty_columns(e,t){for(const s of e.columns())n.includes(t,s)||e.get_array(s).push(this.model.empty_value)}_select_event(e,t,s){const o=this.plot_view.frame,{sx:n,sy:i}=e;if(!o.bbox.contains(n,i))return[];const r={type:"point",sx:n,sy:i},_=[];for(const e of s){const s=e.get_selection_manager(),o=e.data_source,n=[this.plot_view.renderer_views.get(e)];s.select(n,r,!0,t)&&_.push(e),o.properties.selected.change.emit()}return _}}s.EditToolView=c,c.__name__="EditToolView";class a extends _.GestureTool{constructor(e){super(e)}static init_EditTool(){this.define({custom_icon:[o.String],custom_tooltip:[o.String],empty_value:[o.Any],renderers:[o.Array,[]]})}get tooltip(){return this.custom_tooltip||this.tool_name}get computed_icon(){return this.custom_icon||this.icon}}s.EditTool=a,a.__name__="EditTool",a.init_EditTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),_=e(68),o=i.__importStar(e(18)),n=e(332),a=e(287);class d extends n.EditToolView{_tap(e){null==this._draw_basepoint&&null==this._basepoint&&this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)if(e.keyCode===_.Keys.Backspace)this._delete_selected(t);else if(e.keyCode==_.Keys.Esc){t.data_source.selection_manager.clear()}}_set_extent([e,t],[s,i],_,o=!1){const n=this.model.renderers[0],a=this.plot_view.frame,d=n.glyph,l=n.data_source,r=a.xscales[n.x_range_name],h=a.yscales[n.y_range_name],[p,u]=r.r_invert(e,t),[c,m]=h.r_invert(s,i),[f,b]=[(p+u)/2,(c+m)/2],[x,y]=[u-p,m-c],[w,g]=[d.x.field,d.y.field],[v,E]=[d.width.field,d.height.field];if(_)this._pop_glyphs(l,this.model.num_objects),w&&l.get_array(w).push(f),g&&l.get_array(g).push(b),v&&l.get_array(v).push(x),E&&l.get_array(E).push(y),this._pad_empty_columns(l,[w,g,v,E]);else{const e=l.data[w].length-1;w&&(l.data[w][e]=f),g&&(l.data[g][e]=b),v&&(l.data[v][e]=x),E&&(l.data[E][e]=y)}this._emit_cds_changes(l,!0,!1,o)}_update_box(e,t=!1,s=!1){if(null==this._draw_basepoint)return;const i=[e.sx,e.sy],_=this.plot_view.frame,o=this.model.dimensions,n=this.model._get_dim_limits(this._draw_basepoint,i,_,o);if(null!=n){const[e,i]=n;this._set_extent(e,i,t,s)}}_doubletap(e){this.model.active&&(null!=this._draw_basepoint?(this._update_box(e,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[e.sx,e.sy],this._select_event(e,"append",this.model.renderers),this._update_box(e,!0,!1)))}_move(e){this._update_box(e,!1,!1)}_pan_start(e){if(e.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[e.sx,e.sy],this._update_box(e,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy]}}_pan(e,t=!1,s=!1){if(e.shiftKey){if(null==this._draw_basepoint)return;this._update_box(e,t,s)}else{if(null==this._basepoint)return;this._drag_points(e,this.model.renderers)}}_pan_end(e){if(this._pan(e,!1,!0),e.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0)}}}s.BoxEditToolView=d,d.__name__="BoxEditToolView";class l extends n.EditTool{constructor(e){super(e),this.tool_name="Box Edit Tool",this.icon=a.bk_tool_icon_box_edit,this.event_type=["tap","pan","move"],this.default_order=1}static init_BoxEditTool(){this.prototype.default_view=d,this.define({dimensions:[o.Dimensions,"both"],num_objects:[o.Int,0]})}}s.BoxEditTool=l,l.__name__="BoxEditTool",l.init_BoxEditTool()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const s=e(1),r=e(68),_=s.__importStar(e(18)),o=e(8),i=e(332),d=e(287);class n extends i.EditToolView{_draw(e,t,a=!1){if(!this.model.active)return;const s=this.model.renderers[0],r=this._map_drag(e.sx,e.sy,s);if(null==r)return;const[_,i]=r,d=s.data_source,n=s.glyph,[l,h]=[n.xs.field,n.ys.field];if("new"==t)this._pop_glyphs(d,this.model.num_objects),l&&d.get_array(l).push([_]),h&&d.get_array(h).push([i]),this._pad_empty_columns(d,[l,h]);else if("add"==t){if(l){const e=d.data[l].length-1;let t=d.get_array(l)[e];o.isArray(t)||(t=Array.from(t),d.data[l][e]=t),t.push(_)}if(h){const e=d.data[h].length-1;let t=d.get_array(h)[e];o.isArray(t)||(t=Array.from(t),d.data[h][e]=t),t.push(i)}}this._emit_cds_changes(d,!0,!0,a)}_pan_start(e){this._draw(e,"new")}_pan(e){this._draw(e,"add")}_pan_end(e){this._draw(e,"add",!0)}_tap(e){this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===r.Keys.Esc?t.data_source.selection_manager.clear():e.keyCode===r.Keys.Backspace&&this._delete_selected(t)}}a.FreehandDrawToolView=n,n.__name__="FreehandDrawToolView";class l extends i.EditTool{constructor(e){super(e),this.tool_name="Freehand Draw Tool",this.icon=d.bk_tool_icon_freehand_draw,this.event_type=["pan","tap"],this.default_order=3}static init_FreehandDrawTool(){this.prototype.default_view=n,this.define({num_objects:[_.Int,0]})}}a.FreehandDrawTool=l,l.__name__="FreehandDrawTool",l.init_FreehandDrawTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const s=e(1),i=e(68),a=s.__importStar(e(18)),n=e(332),_=e(287);class r extends n.EditToolView{_tap(e){if(this._select_event(e,this._select_mode(e),this.model.renderers).length||!this.model.add)return;const t=this.model.renderers[0],o=this._map_drag(e.sx,e.sy,t);if(null==o)return;const s=t.glyph,i=t.data_source,[a,n]=[s.x.field,s.y.field],[_,r]=o;this._pop_glyphs(i,this.model.num_objects),a&&i.get_array(a).push(_),n&&i.get_array(n).push(r),this._pad_empty_columns(i,[a,n]),i.change.emit(),i.data=i.data,i.properties.data.change.emit()}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===i.Keys.Backspace?this._delete_selected(t):e.keyCode==i.Keys.Esc&&t.data_source.selection_manager.clear()}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0);this._basepoint=null}}}o.PointDrawToolView=r,r.__name__="PointDrawToolView";class d extends n.EditTool{constructor(e){super(e),this.tool_name="Point Draw Tool",this.icon=_.bk_tool_icon_point_draw,this.event_type=["tap","pan","move"],this.default_order=2}static init_PointDrawTool(){this.prototype.default_view=r,this.define({add:[a.Boolean,!0],drag:[a.Boolean,!0],num_objects:[a.Int,0]})}}o.PointDrawTool=d,d.__name__="PointDrawTool",d.init_PointDrawTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(68),a=i.__importStar(e(18)),o=e(8),n=e(337),_=e(287);class d extends n.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._initialized=!1}_tap(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,this._select_mode(e),this.model.renderers)}_draw(e,t,s=!1){const i=this.model.renderers[0],r=this._map_drag(e.sx,e.sy,i);if(this._initialized||this.activate(),null==r)return;const[a,n]=this._snap_to_vertex(e,...r),_=i.data_source,d=i.glyph,[l,h]=[d.xs.field,d.ys.field];if("new"==t)this._pop_glyphs(_,this.model.num_objects),l&&_.get_array(l).push([a,a]),h&&_.get_array(h).push([n,n]),this._pad_empty_columns(_,[l,h]);else if("edit"==t){if(l){const e=_.data[l][_.data[l].length-1];e[e.length-1]=a}if(h){const e=_.data[h][_.data[h].length-1];e[e.length-1]=n}}else if("add"==t){if(l){const e=_.data[l].length-1;let t=_.get_array(l)[e];const s=t[t.length-1];t[t.length-1]=a,o.isArray(t)||(t=Array.from(t),_.data[l][e]=t),t.push(s)}if(h){const e=_.data[h].length-1;let t=_.get_array(h)[e];const s=t[t.length-1];t[t.length-1]=n,o.isArray(t)||(t=Array.from(t),_.data[h][e]=t),t.push(s)}}this._emit_cds_changes(_,!0,!1,s)}_show_vertices(){if(!this.model.active)return;const e=[],t=[];for(let s=0;s<this.model.renderers.length;s++){const i=this.model.renderers[s],r=i.data_source,a=i.glyph,[o,n]=[a.xs.field,a.ys.field];if(o)for(const t of r.get_array(o))Array.prototype.push.apply(e,t);if(n)for(const e of r.get_array(n))Array.prototype.push.apply(t,e);this._drawing&&s==this.model.renderers.length-1&&(e.splice(e.length-1,1),t.splice(t.length-1,1))}this._set_vertices(e,t)}_doubletap(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))}_move(e){this._drawing&&this._draw(e,"edit")}_remove(){const e=this.model.renderers[0],t=e.data_source,s=e.glyph,[i,r]=[s.xs.field,s.ys.field];if(i){const e=t.data[i].length-1,s=t.get_array(i)[e];s.splice(s.length-1,1)}if(r){const e=t.data[r].length-1,s=t.get_array(r)[e];s.splice(s.length-1,1)}this._emit_cds_changes(t)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===r.Keys.Backspace?this._delete_selected(t):e.keyCode==r.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),t.data_source.selection_manager.clear())}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){if(null==this._basepoint||!this.model.drag)return;const[t,s]=this._basepoint;for(const i of this.model.renderers){const r=this._map_drag(t,s,i),a=this._map_drag(e.sx,e.sy,i);if(null==a||null==r)continue;const o=i.data_source,n=i.glyph,[_,d]=[n.xs.field,n.ys.field];if(!_&&!d)continue;const[l,h]=a,[c,g]=r,[p,f]=[l-c,h-g];for(const e of o.selected.indices){let t,s,i;_&&(s=o.data[_][e]),d?(i=o.data[d][e],t=i.length):t=s.length;for(let e=0;e<t;e++)s&&(s[e]+=p),i&&(i[e]+=f)}o.change.emit()}this._basepoint=[e.sx,e.sy]}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source);this._basepoint=null}}activate(){if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(const e of this.model.renderers){const t=e.data_source;t.connect(t.properties.data.change,()=>this._show_vertices())}this._initialized=!0}}deactivate(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()}}s.PolyDrawToolView=d,d.__name__="PolyDrawToolView";class l extends n.PolyTool{constructor(e){super(e),this.tool_name="Polygon Draw Tool",this.icon=_.bk_tool_icon_poly_draw,this.event_type=["pan","tap","move"],this.default_order=3}static init_PolyDrawTool(){this.prototype.default_view=d,this.define({drag:[a.Boolean,!0],num_objects:[a.Int,0]})}}s.PolyDrawTool=l,l.__name__="PolyDrawTool",l.init_PolyDrawTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const o=e(1).__importStar(e(18)),i=e(8),s=e(332);class _ extends s.EditToolView{_set_vertices(e,t){const r=this.model.vertex_renderer.glyph,o=this.model.vertex_renderer.data_source,[s,_]=[r.x.field,r.y.field];s&&(i.isArray(e)?o.data[s]=e:r.x={value:e}),_&&(i.isArray(t)?o.data[_]=t:r.y={value:t}),this._emit_cds_changes(o,!0,!0,!1)}_hide_vertices(){this._set_vertices([],[])}_snap_to_vertex(e,t,r){if(this.model.vertex_renderer){const o=this._select_event(e,"replace",[this.model.vertex_renderer]),i=this.model.vertex_renderer.data_source,s=this.model.vertex_renderer.glyph,[_,l]=[s.x.field,s.y.field];if(o.length){const e=i.selected.indices[0];_&&(t=i.data[_][e]),l&&(r=i.data[l][e]),i.selection_manager.clear()}}return[t,r]}}r.PolyToolView=_,_.__name__="PolyToolView";class l extends s.EditTool{constructor(e){super(e)}static init_PolyTool(){this.prototype.default_view=_,this.define({vertex_renderer:[o.Instance]})}}r.PolyTool=l,l.__name__="PolyTool",l.init_PolyTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const r=e(68),i=e(8),_=e(337),d=e(287);class n extends _.PolyToolView{constructor(){super(...arguments),this._drawing=!1}_doubletap(e){if(!this.model.active)return;const t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null==t)return;const[s,r]=t,i=this._select_event(e,"replace",[this.model.vertex_renderer]),_=this.model.vertex_renderer.data_source,d=this.model.vertex_renderer.glyph,[n,l]=[d.x.field,d.y.field];if(i.length&&null!=this._selected_renderer){const e=_.selected.indices[0];this._drawing?(this._drawing=!1,_.selection_manager.clear()):(_.selected.indices=[e+1],n&&_.get_array(n).splice(e+1,0,s),l&&_.get_array(l).splice(e+1,0,r),this._drawing=!0),_.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}_show_vertices(e){if(!this.model.active)return;const t=this._select_event(e,"replace",this.model.renderers);if(!t.length)return this._set_vertices([],[]),this._selected_renderer=null,void(this._drawing=!1);const s=t[0],r=s.glyph,_=s.data_source,d=_.selected.indices[0],[n,l]=[r.xs.field,r.ys.field];let a,c;n?(a=_.data[n][d],i.isArray(a)||(_.data[n][d]=a=Array.from(a))):a=r.xs.value,l?(c=_.data[l][d],i.isArray(c)||(_.data[l][d]=c=Array.from(c))):c=r.ys.value,this._selected_renderer=s,this._set_vertices(a,c)}_move(e){if(this._drawing&&null!=this._selected_renderer){const t=this.model.vertex_renderer,s=t.data_source,r=t.glyph,i=this._map_drag(e.sx,e.sy,t);if(null==i)return;let[_,d]=i;const n=s.selected.indices;[_,d]=this._snap_to_vertex(e,_,d),s.selected.indices=n;const[l,a]=[r.x.field,r.y.field],c=n[0];l&&(s.data[l][c]=_),a&&(s.data[a][c]=d),s.change.emit(),this._selected_renderer.data_source.change.emit()}}_tap(e){const t=this.model.vertex_renderer,s=this._map_drag(e.sx,e.sy,t);if(null==s)return;if(this._drawing&&this._selected_renderer){let[r,i]=s;const _=t.data_source,d=t.glyph,[n,l]=[d.x.field,d.y.field],a=_.selected.indices;[r,i]=this._snap_to_vertex(e,r,i);const c=a[0];if(_.selected.indices=[c+1],n){const e=_.get_array(n),t=e[c];e[c]=r,e.splice(c+1,0,t)}if(l){const e=_.get_array(l),t=e[c];e[c]=i,e.splice(c+1,0,t)}return _.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}const r=this._select_mode(e);this._select_event(e,r,[t]),this._select_event(e,r,this.model.renderers)}_remove_vertex(){if(!this._drawing||!this._selected_renderer)return;const e=this.model.vertex_renderer,t=e.data_source,s=e.glyph,r=t.selected.indices[0],[i,_]=[s.x.field,s.y.field];i&&t.get_array(i).splice(r,1),_&&t.get_array(_).splice(r,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}_pan_start(e){this._select_event(e,"append",[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}_keyup(e){if(!this.model.active||!this._mouse_in_frame)return;let t;t=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;for(const s of t)e.keyCode===r.Keys.Backspace?(this._delete_selected(s),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):e.keyCode==r.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),s.data_source.selection_manager.clear())}deactivate(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())}}s.PolyEditToolView=n,n.__name__="PolyEditToolView";class l extends _.PolyTool{constructor(e){super(e),this.tool_name="Poly Edit Tool",this.icon=d.bk_tool_icon_poly_edit,this.event_type=["tap","pan","move"],this.default_order=4}static init_PolyEditTool(){this.prototype.default_view=n}}s.PolyEditTool=l,l.__name__="PolyEditTool",l.init_PolyEditTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const s=e(1),i=e(340),l=e(107),_=s.__importStar(e(18)),n=e(287);class c extends i.SelectToolView{_compute_limits(e){const t=this.plot_view.frame,o=this.model.dimensions;let s=this._base_point;if("center"==this.model.origin){const[t,o]=s,[i,l]=e;s=[t-(i-t),o-(l-o)]}return this.model._get_dim_limits(s,e,t,o)}_pan_start(e){const{sx:t,sy:o}=e;this._base_point=[t,o]}_pan(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s);this.model.overlay.update({left:i[0],right:i[1],top:l[0],bottom:l[1]}),this.model.select_every_mousemove&&this._do_select(i,l,!1,this._select_mode(e))}_pan_end(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s);this._do_select(i,l,!0,this._select_mode(e)),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.push_state("box_select",{selection:this.plot_view.get_selection()})}_do_select([e,t],[o,s],i,l="replace"){const _={type:"rect",sx0:e,sx1:t,sy0:o,sy1:s};this._select(_,i,l)}}o.BoxSelectToolView=c,c.__name__="BoxSelectToolView";const r=()=>new l.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class h extends i.SelectTool{constructor(e){super(e),this.tool_name="Box Select",this.icon=n.bk_tool_icon_box_select,this.event_type="pan",this.default_order=30}static init_BoxSelectTool(){this.prototype.default_view=c,this.define({dimensions:[_.Dimensions,"both"],select_every_mousemove:[_.Boolean,!1],overlay:[_.Instance,r],origin:[_.BoxOrigin,"corner"]}),this.register_alias("box_select",()=>new h),this.register_alias("xbox_select",()=>new h({dimensions:"width"})),this.register_alias("ybox_select",()=>new h({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}o.BoxSelectTool=h,h.__name__="BoxSelectTool",h.init_BoxSelectTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(1),o=e(284),r=e(81),c=e(100),i=e(341),l=n.__importStar(e(18)),a=e(68),d=e(291),_=e(14),h=e(11);class u extends o.GestureToolView{connect_signals(){super.connect_signals(),this.model.clear.connect(()=>this._clear())}get computed_renderers(){const e=this.model.renderers,t=this.plot_model.renderers,s=this.model.names;return i.compute_renderers(e,t,s)}_computed_renderers_by_data_source(){var e;const t=new Map;for(const s of this.computed_renderers){let n;if(s instanceof r.GlyphRenderer)n=s.data_source;else{if(!(s instanceof c.GraphRenderer))continue;n=s.node_renderer.data_source}const o=null!==(e=t.get(n))&&void 0!==e?e:[];t.set(n,[...o,s])}return t}_select_mode(e){const{shiftKey:t,ctrlKey:s}=e;return t||s?t&&!s?"append":!t&&s?"intersect":t&&s?"subtract":void h.unreachable():this.model.mode}_keyup(e){e.keyCode==a.Keys.Esc&&this._clear()}_clear(){for(const e of this.computed_renderers)e.get_selection_manager().clear();this.plot_view.request_render()}_select(e,t,s){const n=this._computed_renderers_by_data_source();for(const[,o]of n){const n=o[0].get_selection_manager(),r=[];for(const e of o){const t=this.plot_view.renderer_views.get(e);null!=t&&r.push(t)}n.select(r,e,t,s)}null!=this.model.callback&&this._emit_callback(e),this._emit_selection_event(e,t)}_emit_selection_event(e,t=!0){const{frame:s}=this.plot_view,n=s.xscales.default,o=s.yscales.default;let r;switch(e.type){case"point":{const{sx:t,sy:s}=e,c=n.invert(t),i=o.invert(s);r=Object.assign(Object.assign({},e),{x:c,y:i});break}case"span":{const{sx:t,sy:s}=e,c=n.invert(t),i=o.invert(s);r=Object.assign(Object.assign({},e),{x:c,y:i});break}case"rect":{const{sx0:t,sx1:s,sy0:c,sy1:i}=e,[l,a]=n.r_invert(t,s),[d,_]=o.r_invert(c,i);r=Object.assign(Object.assign({},e),{x0:l,y0:d,x1:a,y1:_});break}case"poly":{const{sx:t,sy:s}=e,c=n.v_invert(t),i=o.v_invert(s);r=Object.assign(Object.assign({},e),{x:c,y:i});break}}this.plot_model.trigger_event(new d.SelectionGeometry(r,t))}}s.SelectToolView=u,u.__name__="SelectToolView";class p extends o.GestureTool{constructor(e){super(e)}initialize(){super.initialize(),this.clear=new _.Signal0(this,"clear")}static init_SelectTool(){this.define({renderers:[l.Any,"auto"],names:[l.Array,[]],mode:[l.Any,"replace"]})}get menu(){return[{icon:"bk-tool-icon-replace-mode",tooltip:"Replace the current selection",active:()=>"replace"==this.mode,handler:()=>{this.mode="replace",this.active=!0}},{icon:"bk-tool-icon-append-mode",tooltip:"Append to the current selection (Shift)",active:()=>"append"==this.mode,handler:()=>{this.mode="append",this.active=!0}},{icon:"bk-tool-icon-intersect-mode",tooltip:"Intersect with the current selection (Ctrl)",active:()=>"intersect"==this.mode,handler:()=>{this.mode="intersect",this.active=!0}},{icon:"bk-tool-icon-subtract-mode",tooltip:"Subtract from the current selection (Shift+Ctrl)",active:()=>"subtract"==this.mode,handler:()=>{this.mode="subtract",this.active=!0}},null,{icon:"bk-tool-icon-clear-selection",tooltip:"Clear the current selection (Esc)",handler:()=>{this.clear.emit()}}]}}s.SelectTool=p,p.__name__="SelectTool",p.init_SelectTool()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const r=e(9);t.compute_renderers=function(e,n,t){if(null==e)return[];let u="auto"==e?n:e;return t.length>0&&(u=u.filter(e=>r.includes(t,e.name))),u}},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});const s=t(1),i=t(284),n=t(107),_=s.__importStar(t(18)),a=t(287);class l extends i.GestureToolView{_match_aspect(t,o,e){const s=e.bbox.aspect,i=e.bbox.h_range.end,n=e.bbox.h_range.start,_=e.bbox.v_range.end,a=e.bbox.v_range.start;let l=Math.abs(t[0]-o[0]),r=Math.abs(t[1]-o[1]);const h=0==r?0:l/r,[c]=h>=s?[1,h/s]:[s/h,1];let m,p,d,b;return t[0]<=o[0]?(m=t[0],p=t[0]+l*c,p>i&&(p=i)):(p=t[0],m=t[0]-l*c,m<n&&(m=n)),l=Math.abs(p-m),t[1]<=o[1]?(b=t[1],d=t[1]+l/s,d>_&&(d=_)):(d=t[1],b=t[1]-l/s,b<a&&(b=a)),r=Math.abs(d-b),t[0]<=o[0]?p=t[0]+s*r:m=t[0]-s*r,[[m,p],[b,d]]}_compute_limits(t){const o=this.plot_view.frame,e=this.model.dimensions;let s,i,n=this._base_point;if("center"==this.model.origin){const[o,e]=n,[s,i]=t;n=[o-(s-o),e-(i-e)]}return this.model.match_aspect&&"both"==e?[s,i]=this._match_aspect(n,t,o):[s,i]=this.model._get_dim_limits(n,t,o,e),[s,i]}_pan_start(t){this._base_point=[t.sx,t.sy]}_pan(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this.model.overlay.update({left:e[0],right:e[1],top:s[0],bottom:s[1]})}_pan_end(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this._update(e,s),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null}_update([t,o],[e,s]){if(Math.abs(o-t)<=5||Math.abs(s-e)<=5)return;const{xscales:i,yscales:n}=this.plot_view.frame,_={};for(const e in i){const s=i[e],[n,a]=s.r_invert(t,o);_[e]={start:n,end:a}}const a={};for(const t in n){const o=n[t],[i,_]=o.r_invert(e,s);a[t]={start:i,end:_}}const l={xrs:_,yrs:a};this.plot_view.push_state("box_zoom",{range:l}),this.plot_view.update_range(l)}}e.BoxZoomToolView=l,l.__name__="BoxZoomToolView";const r=()=>new n.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class h extends i.GestureTool{constructor(t){super(t),this.tool_name="Box Zoom",this.icon=a.bk_tool_icon_box_zoom,this.event_type="pan",this.default_order=20}static init_BoxZoomTool(){this.prototype.default_view=l,this.define({dimensions:[_.Dimensions,"both"],overlay:[_.Instance,r],match_aspect:[_.Boolean,!1],origin:[_.BoxOrigin,"corner"]}),this.register_alias("box_zoom",()=>new h({dimensions:"both"})),this.register_alias("xbox_zoom",()=>new h({dimensions:"width"})),this.register_alias("ybox_zoom",()=>new h({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}e.BoxZoomTool=h,h.__name__="BoxZoomTool",h.init_BoxZoomTool()},
function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(1),l=e(340),i=e(139),a=e(68),_=o.__importStar(e(18)),c=e(287);class n extends l.SelectToolView{initialize(){super.initialize(),this.data=null}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>this._active_change())}_active_change(){this.model.active||this._clear_overlay()}_keyup(e){e.keyCode==a.Keys.Enter&&this._clear_overlay()}_pan_start(e){const{sx:s,sy:t}=e;this.data={sx:[s],sy:[t]}}_pan(e){const{sx:s,sy:t}=e,[o,l]=this.plot_view.frame.bbox.clip(s,t);this.data.sx.push(o),this.data.sy.push(l),this.model.overlay.update({xs:this.data.sx,ys:this.data.sy}),this.model.select_every_mousemove&&this._do_select(this.data.sx,this.data.sy,!1,this._select_mode(e))}_pan_end(e){this._clear_overlay(),this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(e)),this.plot_view.push_state("lasso_select",{selection:this.plot_view.get_selection()})}_clear_overlay(){this.model.overlay.update({xs:[],ys:[]})}_do_select(e,s,t,o){const l={type:"poly",sx:e,sy:s};this._select(l,t,o)}}t.LassoSelectToolView=n,n.__name__="LassoSelectToolView";const h=()=>new i.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class r extends l.SelectTool{constructor(e){super(e),this.tool_name="Lasso Select",this.icon=c.bk_tool_icon_lasso_select,this.event_type="pan",this.default_order=12}static init_LassoSelectTool(){this.prototype.default_view=n,this.define({select_every_mousemove:[_.Boolean,!0],overlay:[_.Instance,h]}),this.register_alias("lasso_select",()=>new r)}}t.LassoSelectTool=r,r.__name__="LassoSelectTool",r.init_LassoSelectTool()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),n=e(345),r=s.__importStar(e(18)),_=e(287);class d extends n.LineToolView{constructor(){super(...arguments),this._drawing=!1}_doubletap(e){if(!this.model.active)return;const t=this.model.renderers;for(const i of t){1==this._select_event(e,"replace",[i]).length&&(this._selected_renderer=i)}this._show_intersections(),this._update_line_cds()}_show_intersections(){if(!this.model.active)return;if(null==this._selected_renderer)return;if(!this.model.renderers.length)return this._set_intersection([],[]),this._selected_renderer=null,void(this._drawing=!1);const e=this._selected_renderer.data_source,t=this._selected_renderer.glyph,[i,s]=[t.x.field,t.y.field],n=e.get_array(i),r=e.get_array(s);this._set_intersection(n,r)}_tap(e){const t=this.model.intersection_renderer;if(null==this._map_drag(e.sx,e.sy,t))return;if(this._drawing&&this._selected_renderer){const i=this._select_mode(e);if(0==this._select_event(e,i,[t]).length)return}const i=this._select_mode(e);this._select_event(e,i,[t]),this._select_event(e,i,this.model.renderers)}_update_line_cds(){if(null==this._selected_renderer)return;const e=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,[i,s]=[e.x.field,e.y.field];if(i&&s){const e=t.data[i],n=t.data[s];this._selected_renderer.data_source.data[i]=e,this._selected_renderer.data_source.data[s]=n}this._emit_cds_changes(this._selected_renderer.data_source,!0,!0,!1)}_pan_start(e){this._select_event(e,"append",[this.model.intersection_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer],this.model.dimensions),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer]),this._emit_cds_changes(this.model.intersection_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}activate(){this._drawing=!0}deactivate(){this._selected_renderer&&(this._drawing&&(this._drawing=!1),this._hide_intersections())}}i.LineEditToolView=d,d.__name__="LineEditToolView";class o extends n.LineTool{constructor(e){super(e),this.tool_name="Line Edit Tool",this.icon=_.bk_tool_icon_line_edit,this.event_type=["tap","pan","move"],this.default_order=4}static init_LineEditTool(){this.prototype.default_view=d,this.define({dimensions:[r.Dimensions,"both"]})}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}i.LineEditTool=o,o.__name__="LineEditTool",o.init_LineEditTool()},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1).__importStar(e(18)),o=e(8),s=e(332);class _ extends s.EditToolView{_set_intersection(e,i){const t=this.model.intersection_renderer.glyph,n=this.model.intersection_renderer.data_source,[s,_]=[t.x.field,t.y.field];s&&(o.isArray(e)?n.data[s]=e:t.x={value:e}),_&&(o.isArray(i)?n.data[_]=i:t.y={value:i}),this._emit_cds_changes(n,!0,!0,!1)}_hide_intersections(){this._set_intersection([],[])}}t.LineToolView=_,_.__name__="LineToolView";class r extends s.EditTool{constructor(e){super(e)}static init_LineTool(){this.prototype.default_view=_,this.define({intersection_renderer:[n.Instance]})}}t.LineTool=r,r.__name__="LineTool",r.init_LineTool()},
function _(t,s,n){Object.defineProperty(n,"__esModule",{value:!0});const i=t(1),e=t(284),o=i.__importStar(t(18)),a=t(287);class _ extends e.GestureToolView{_pan_start(t){this.last_dx=0,this.last_dy=0;const{sx:s,sy:n}=t,i=this.plot_view.frame.bbox;if(!i.contains(s,n)){const t=i.h_range,e=i.v_range;(s<t.start||s>t.end)&&(this.v_axis_only=!0),(n<e.start||n>e.end)&&(this.h_axis_only=!0)}null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}_pan(t){this._update(t.deltaX,t.deltaY),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}_pan_end(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.push_state("pan",{range:this.pan_info})}_update(t,s){const n=this.plot_view.frame,i=t-this.last_dx,e=s-this.last_dy,o=n.bbox.h_range,a=o.start-i,_=o.end-i,h=n.bbox.v_range,l=h.start-e,r=h.end-e,d=this.model.dimensions;let c,p,m,u,x,y;"width"!=d&&"both"!=d||this.v_axis_only?(c=o.start,p=o.end,m=0):(c=a,p=_,m=-i),"height"!=d&&"both"!=d||this.h_axis_only?(u=h.start,x=h.end,y=0):(u=l,x=r,y=-e),this.last_dx=t,this.last_dy=s;const{xscales:v,yscales:b}=n,g={};for(const t in v){const s=v[t],[n,i]=s.r_invert(c,p);g[t]={start:n,end:i}}const w={};for(const t in b){const s=b[t],[n,i]=s.r_invert(u,x);w[t]={start:n,end:i}}this.pan_info={xrs:g,yrs:w,sdx:m,sdy:y},this.plot_view.update_range(this.pan_info,!0)}}n.PanToolView=_,_.__name__="PanToolView";class h extends e.GestureTool{constructor(t){super(t),this.tool_name="Pan",this.event_type="pan",this.default_order=10}static init_PanTool(){this.prototype.default_view=_,this.define({dimensions:[o.Dimensions,"both"]}),this.register_alias("pan",()=>new h({dimensions:"both"})),this.register_alias("xpan",()=>new h({dimensions:"width"})),this.register_alias("ypan",()=>new h({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip("Pan",this.dimensions)}get icon(){switch(this.dimensions){case"both":return a.bk_tool_icon_pan;case"width":return a.bk_tool_icon_xpan;case"height":return a.bk_tool_icon_ypan}}}n.PanTool=h,h.__name__="PanTool",h.init_PanTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const l=e(1),o=e(340),i=e(139),a=e(68),_=l.__importStar(e(18)),c=e(9),n=e(287);class h extends o.SelectToolView{initialize(){super.initialize(),this.data={sx:[],sy:[]}}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>this._active_change())}_active_change(){this.model.active||this._clear_data()}_keyup(e){e.keyCode==a.Keys.Enter&&this._clear_data()}_doubletap(e){this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(e)),this.plot_view.push_state("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()}_clear_data(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})}_tap(e){const{sx:t,sy:s}=e;this.plot_view.frame.bbox.contains(t,s)&&(this.data.sx.push(t),this.data.sy.push(s),this.model.overlay.update({xs:c.copy(this.data.sx),ys:c.copy(this.data.sy)}))}_do_select(e,t,s,l){const o={type:"poly",sx:e,sy:t};this._select(o,s,l)}}s.PolySelectToolView=h,h.__name__="PolySelectToolView";const y=()=>new i.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class d extends o.SelectTool{constructor(e){super(e),this.tool_name="Poly Select",this.icon=n.bk_tool_icon_polygon_select,this.event_type="tap",this.default_order=11}static init_PolySelectTool(){this.prototype.default_view=h,this.define({overlay:[_.Instance,y]}),this.register_alias("poly_select",()=>new d)}}s.PolySelectTool=d,d.__name__="PolySelectTool",d.init_PolySelectTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),n=e(107),l=e(72),a=i.__importStar(e(18)),r=e(284),o=e(287);function _(e){switch(e){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return e}}function h(e,t,s,i){if(null==t)return!1;const n=s.compute(t);return Math.abs(e-n)<i}function d(e,t,s,i,n){let l=!0;if(null!=n.left&&null!=n.right){const t=s.invert(e);(t<n.left||t>n.right)&&(l=!1)}if(null!=n.bottom&&null!=n.top){const e=i.invert(t);(e<n.bottom||e>n.top)&&(l=!1)}return l}function u(e,t,s){let i=0;return e>=s.start&&e<=s.end&&(i+=1),t>=s.start&&t<=s.end&&(i+=1),i}function c(e,t,s,i){const n=t.compute(e),l=t.invert(n+s);return l>=i.start&&l<=i.end?l:e}function g(e,t,s){return e>t.start?(t.end=e,s):(t.end=t.start,t.start=e,_(s))}function y(e,t,s){return e<t.end?(t.start=e,s):(t.start=t.end,t.end=e,_(s))}function f(e,t,s,i){const[n,l]=t.r_compute(e.start,e.end),[a,r]=t.r_invert(n+s,l+s),o=u(e.start,e.end,i);u(a,r,i)>=o&&(e.start=a,e.end=r)}s.flip_side=_,s.is_near=h,s.is_inside=d,s.sides_inside=u,s.compute_value=c,s.update_range_end_side=g,s.update_range_start_side=y,s.update_range=f;class p extends r.GestureToolView{initialize(){super.initialize(),this.side=0,this.model.update_overlay_from_ranges()}connect_signals(){super.connect_signals(),null!=this.model.x_range&&this.connect(this.model.x_range.change,()=>this.model.update_overlay_from_ranges()),null!=this.model.y_range&&this.connect(this.model.y_range.change,()=>this.model.update_overlay_from_ranges())}_pan_start(e){this.last_dx=0,this.last_dy=0;const t=this.model.x_range,s=this.model.y_range,i=this.plot_view.frame,l=i.xscales.default,a=i.yscales.default,r=this.model.overlay,{left:o,right:_,top:u,bottom:c}=r,g=this.model.overlay.properties.line_width.value()+n.EDGE_TOLERANCE;null!=t&&this.model.x_interaction&&(h(e.sx,o,l,g)?this.side=1:h(e.sx,_,l,g)?this.side=2:d(e.sx,e.sy,l,a,r)&&(this.side=3)),null!=s&&this.model.y_interaction&&(0==this.side&&h(e.sy,c,a,g)&&(this.side=4),0==this.side&&h(e.sy,u,a,g)?this.side=5:d(e.sx,e.sy,l,a,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))}_pan(e){const t=this.plot_view.frame,s=e.deltaX-this.last_dx,i=e.deltaY-this.last_dy,n=this.model.x_range,l=this.model.y_range,a=t.xscales.default,r=t.yscales.default;if(null!=n)if(3==this.side||7==this.side)f(n,a,s,t.x_range);else if(1==this.side){const e=c(n.start,a,s,t.x_range);this.side=y(e,n,this.side)}else if(2==this.side){const e=c(n.end,a,s,t.x_range);this.side=g(e,n,this.side)}if(null!=l)if(6==this.side||7==this.side)f(l,r,i,t.y_range);else if(4==this.side){const e=c(l.start,r,i,t.y_range);this.side=y(e,l,this.side)}else if(5==this.side){const e=c(l.end,r,i,t.y_range);this.side=g(e,l,this.side)}this.last_dx=e.deltaX,this.last_dy=e.deltaY}_pan_end(e){this.side=0}}s.RangeToolView=p,p.__name__="RangeToolView";const m=()=>new n.BoxAnnotation({level:"overlay",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:.5,line_dash:[2,2]});class v extends r.GestureTool{constructor(e){super(e),this.tool_name="Range Tool",this.icon=o.bk_tool_icon_range,this.event_type="pan",this.default_order=1}static init_RangeTool(){this.prototype.default_view=p,this.define({x_range:[a.Instance,null],x_interaction:[a.Boolean,!0],y_range:[a.Instance,null],y_interaction:[a.Boolean,!0],overlay:[a.Instance,m]})}initialize(){super.initialize(),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null}update_overlay_from_ranges(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,l.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)}}s.RangeTool=v,v.__name__="RangeTool",v.init_RangeTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),o=e(340),a=i.__importStar(e(18)),n=e(287);class _ extends o.SelectToolView{_tap(e){const{sx:t,sy:s}=e,i={type:"point",sx:t,sy:s};this._select(i,!0,this._select_mode(e))}_select(e,t,s){const i=this.model.callback;if("select"==this.model.behavior){const o=this._computed_renderers_by_data_source();for(const[,a]of o){const o=a[0].get_selection_manager(),n=a.map(e=>this.plot_view.renderer_views.get(e));if(o.select(n,e,t,s)&&null!=i){const{frame:t}=this.plot_view,s=t.xscales[a[0].x_range_name],n=t.yscales[a[0].y_range_name],_=s.invert(e.sx),c=n.invert(e.sy),l={geometries:Object.assign(Object.assign({},e),{x:_,y:c}),source:o.source};i.execute(this.model,l)}}this._emit_selection_event(e),this.plot_view.push_state("tap",{selection:this.plot_view.get_selection()})}else for(const t of this.computed_renderers){const s=t.get_selection_manager();if(s.inspect(this.plot_view.renderer_views.get(t),e)&&null!=i){const{frame:o}=this.plot_view,a=o.xscales[t.x_range_name],n=o.yscales[t.y_range_name],_=a.invert(e.sx),c=n.invert(e.sy),l={geometries:Object.assign(Object.assign({},e),{x:_,y:c}),source:s.source};i.execute(this.model,l)}}}}s.TapToolView=_,_.__name__="TapToolView";class c extends o.SelectTool{constructor(e){super(e),this.tool_name="Tap",this.icon=n.bk_tool_icon_tap_select,this.event_type="tap",this.default_order=10}static init_TapTool(){this.prototype.default_view=_,this.define({behavior:[a.TapBehavior,"select"],callback:[a.Any]}),this.register_alias("click",()=>new c({behavior:"inspect"})),this.register_alias("tap",()=>new c)}}s.TapTool=c,c.__name__="TapTool",c.init_TapTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(1),o=e(284),i=n.__importStar(e(18)),a=e(287);class l extends o.GestureToolView{_scroll(e){let t=this.model.speed*e.delta;t>.9?t=.9:t<-.9&&(t=-.9),this._update_ranges(t)}_update_ranges(e){const{frame:t}=this.plot_view,s=t.bbox.h_range,n=t.bbox.v_range,[o,i]=[s.start,s.end],[a,l]=[n.start,n.end];let r,h,_,d;switch(this.model.dimension){case"height":{const t=Math.abs(l-a);r=o,h=i,_=a-t*e,d=l-t*e;break}case"width":{const t=Math.abs(i-o);r=o-t*e,h=i-t*e,_=a,d=l;break}default:throw new Error("this shouldn't have happened")}const{xscales:c,yscales:p}=t,m={};for(const e in c){const t=c[e],[s,n]=t.r_invert(r,h);m[e]={start:s,end:n}}const u={};for(const e in p){const t=p[e],[s,n]=t.r_invert(_,d);u[e]={start:s,end:n}}const w={xrs:m,yrs:u,factor:e};this.plot_view.push_state("wheel_pan",{range:w}),this.plot_view.update_range(w,!1,!0),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}}s.WheelPanToolView=l,l.__name__="WheelPanToolView";class r extends o.GestureTool{constructor(e){super(e),this.tool_name="Wheel Pan",this.icon=a.bk_tool_icon_wheel_pan,this.event_type="scroll",this.default_order=12}static init_WheelPanTool(){this.prototype.default_view=l,this.define({dimension:[i.Dimension,"width"]}),this.internal({speed:[i.Number,.001]}),this.register_alias("xwheel_pan",()=>new r({dimension:"width"})),this.register_alias("ywheel_pan",()=>new r({dimension:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimension)}}s.WheelPanTool=r,r.__name__="WheelPanTool",r.init_WheelPanTool()},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});const s=e(1),i=e(284),l=e(330),n=s.__importStar(e(18)),_=e(28),h=e(287);class a extends i.GestureToolView{_pinch(e){const{sx:o,sy:t,scale:s,ctrlKey:i,shiftKey:l}=e;let n;n=s>=1?20*(s-1):-20/s,this._scroll({type:"wheel",sx:o,sy:t,delta:n,ctrlKey:i,shiftKey:l})}_scroll(e){const{frame:o}=this.plot_view,t=o.bbox.h_range,s=o.bbox.v_range,{sx:i,sy:n}=e,_=this.model.dimensions,h=("width"==_||"both"==_)&&t.start<i&&i<t.end,a=("height"==_||"both"==_)&&s.start<n&&n<s.end;if(!(h&&a||this.model.zoom_on_axis))return;const m=this.model.speed*e.delta,r=l.scale_range(o,m,h,a,{x:i,y:n});this.plot_view.push_state("wheel_zoom",{range:r}),this.plot_view.update_range(r,!1,!0,this.model.maintain_focus),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}}t.WheelZoomToolView=a,a.__name__="WheelZoomToolView";class m extends i.GestureTool{constructor(e){super(e),this.tool_name="Wheel Zoom",this.icon=h.bk_tool_icon_wheel_zoom,this.event_type=_.is_mobile?"pinch":"scroll",this.default_order=10}static init_WheelZoomTool(){this.prototype.default_view=a,this.define({dimensions:[n.Dimensions,"both"],maintain_focus:[n.Boolean,!0],zoom_on_axis:[n.Boolean,!0],speed:[n.Number,1/600]}),this.register_alias("wheel_zoom",()=>new m({dimensions:"both"})),this.register_alias("xwheel_zoom",()=>new m({dimensions:"width"})),this.register_alias("ywheel_zoom",()=>new m({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}t.WheelZoomTool=m,m.__name__="WheelZoomTool",m.init_WheelZoomTool()},
function _(i,s,e){Object.defineProperty(e,"__esModule",{value:!0});const t=i(1),o=i(274),n=i(141),l=t.__importStar(i(18)),h=i(17),a=i(287);class r extends o.InspectToolView{_move(i){if(!this.model.active)return;const{sx:s,sy:e}=i;this.plot_view.frame.bbox.contains(s,e)?this._update_spans(s,e):this._update_spans(null,null)}_move_exit(i){this._update_spans(null,null)}_update_spans(i,s){const e=this.model.dimensions;"width"!=e&&"both"!=e||(this.model.spans.width.location=s),"height"!=e&&"both"!=e||(this.model.spans.height.location=i)}}e.CrosshairToolView=r,r.__name__="CrosshairToolView";class _ extends o.InspectTool{constructor(i){super(i),this.tool_name="Crosshair",this.icon=a.bk_tool_icon_crosshair}static init_CrosshairTool(){this.prototype.default_view=r,this.define({dimensions:[l.Dimensions,"both"],line_color:[l.Color,"black"],line_width:[l.Number,1],line_alpha:[l.Number,1]}),this.internal({spans:[l.Any]}),this.register_alias("crosshair",()=>new _)}get tooltip(){return this._get_dim_tooltip("Crosshair",this.dimensions)}get synthetic_renderers(){return h.values(this.spans)}initialize(){super.initialize(),this.spans={width:new n.Span({for_hover:!0,dimension:"width",location_units:"screen",level:"overlay",line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha}),height:new n.Span({for_hover:!0,dimension:"height",location_units:"screen",level:"overlay",line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha})}}}e.CrosshairTool=_,_.__name__="CrosshairTool",_.init_CrosshairTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const r=e(1),o=e(71),i=r.__importStar(e(18)),a=e(17),n=e(24);class u extends o.Model{constructor(e){super(e)}static init_CustomJSHover(){this.define({args:[i.Any,{}],code:[i.String,""]})}get values(){return a.values(this.args)}_make_code(e,t,s,r){return new Function(...a.keys(this.args),e,t,s,n.use_strict(r))}format(e,t,s){return this._make_code("value","format","special_vars",this.code)(...this.values,e,t,s)}}s.CustomJSHover=u,u.__name__="CustomJSHover",u.init_CustomJSHover()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(1),o=e(274),i=e(144),r=e(81),l=e(100),a=e(341),c=n.__importStar(e(93)),d=e(160),_=e(68),p=n.__importStar(e(18)),h=e(20),m=e(17),u=e(8),y=e(99),x=e(287),f=e(145);function v(e,t,s,n,o,i){const r={x:o[e],y:i[e]},l={x:o[e+1],y:i[e+1]};let a,d;if("span"==t.type)"h"==t.direction?(a=Math.abs(r.x-s),d=Math.abs(l.x-s)):(a=Math.abs(r.y-n),d=Math.abs(l.y-n));else{const e={x:s,y:n};a=c.dist_2_pts(r,e),d=c.dist_2_pts(l,e)}return a<d?[[r.x,r.y],e]:[[l.x,l.y],e+1]}function w(e,t,s){return[[e[s],t[s]],s]}s._nearest_line_hit=v,s._line_hit=w;class g extends o.InspectToolView{initialize(){super.initialize(),this._ttmodels=null,this._ttviews=new Map}remove(){y.remove_views(this._ttviews),super.remove()}connect_signals(){super.connect_signals();for(const e of this.computed_renderers)e instanceof r.GlyphRenderer?this.connect(e.data_source.inspect,this._update):e instanceof l.GraphRenderer&&(this.connect(e.node_renderer.data_source.inspect,this._update),this.connect(e.edge_renderer.data_source.inspect,this._update));this.connect(this.model.properties.renderers.change,()=>this._computed_renderers=this._ttmodels=null),this.connect(this.model.properties.names.change,()=>this._computed_renderers=this._ttmodels=null),this.connect(this.model.properties.tooltips.change,()=>this._ttmodels=null)}_compute_ttmodels(){const e=new Map,t=this.model.tooltips;if(null!=t)for(const s of this.computed_renderers){const n=new i.Tooltip({custom:u.isString(t)||u.isFunction(t),attachment:this.model.attachment,show_arrow:this.model.show_arrow});s instanceof r.GlyphRenderer?e.set(s,n):s instanceof l.GraphRenderer&&(e.set(s.node_renderer,n),e.set(s.edge_renderer,n))}return y.build_views(this._ttviews,[...e.values()],{parent:this.plot_view}),e}get computed_renderers(){if(null==this._computed_renderers){const e=this.model.renderers,t=this.plot_model.renderers,s=this.model.names;this._computed_renderers=a.compute_renderers(e,t,s)}return this._computed_renderers}get ttmodels(){return null==this._ttmodels&&(this._ttmodels=this._compute_ttmodels()),this._ttmodels}_clear(){this._inspect(1/0,1/0);for(const[,e]of this.ttmodels)e.clear()}_move(e){if(!this.model.active)return;const{sx:t,sy:s}=e;this.plot_view.frame.bbox.contains(t,s)?this._inspect(t,s):this._clear()}_move_exit(){this._clear()}_inspect(e,t){let s;if("mouse"==this.model.mode)s={type:"point",sx:e,sy:t};else{s={type:"span",direction:"vline"==this.model.mode?"h":"v",sx:e,sy:t}}for(const e of this.computed_renderers){e.get_selection_manager().inspect(this.plot_view.renderer_views.get(e),s)}null!=this.model.callback&&this._emit_callback(s)}_update([e,{geometry:t}]){if(!this.model.active)return;if(!(e instanceof r.GlyphRendererView))return;const{model:s}=e;if("ignore"==this.model.muted_policy&&s instanceof r.GlyphRenderer&&s.muted)return;const n=this.ttmodels.get(s);if(null==n)return;n.clear();const o=s.get_selection_manager();let i=o.inspectors.get(s);if(s instanceof r.GlyphRenderer&&(i=s.view.convert_selection_to_subset(i)),i.is_empty())return;const l=o.source,{frame:a}=this.plot_view,{sx:c,sy:d}=t,_=a.xscales[s.x_range_name],p=a.yscales[s.y_range_name],h=_.invert(c),u=p.invert(d),y=e.glyph;for(const s of i.line_indices){let o,r,a=y._x[s+1],m=y._y[s+1],x=s;switch(this.model.line_policy){case"interp":[a,m]=y.get_interpolation_hit(s,t),o=_.compute(a),r=p.compute(m);break;case"prev":[[o,r],x]=w(y.sx,y.sy,s);break;case"next":[[o,r],x]=w(y.sx,y.sy,s+1);break;case"nearest":[[o,r],x]=v(s,t,c,d,y.sx,y.sy),a=y._x[x],m=y._y[x];break;default:[o,r]=[c,d]}const f={index:x,x:h,y:u,sx:c,sy:d,data_x:a,data_y:m,rx:o,ry:r,indices:i.line_indices,name:e.model.name};n.add(o,r,this._render_tooltips(l,x,f))}for(const e of i.image_indices){const t={index:e.index,x:h,y:u,sx:c,sy:d},s=this._render_tooltips(l,e,t);n.add(c,d,s)}for(const o of i.indices)if(m.isEmpty(i.multiline_indices)){const t=null!=y._x?y._x[o]:void 0,a=null!=y._y?y._y[o]:void 0;let _,p,m;if("snap_to_data"==this.model.point_policy){let e=y.get_anchor_point(this.model.anchor,o,[c,d]);null==e&&(e=y.get_anchor_point("center",o,[c,d])),_=e.x,p=e.y}else[_,p]=[c,d];m=s instanceof r.GlyphRenderer?s.view.convert_indices_from_subset([o])[0]:o;const x={index:m,x:h,y:u,sx:c,sy:d,data_x:t,data_y:a,indices:i.indices,name:e.model.name};n.add(_,p,this._render_tooltips(l,m,x))}else for(const a of i.multiline_indices[o.toString()]){let m,x,f,g=y._xs[o][a],b=y._ys[o][a],k=a;switch(this.model.line_policy){case"interp":[g,b]=y.get_interpolation_hit(o,a,t),m=_.compute(g),x=p.compute(b);break;case"prev":[[m,x],k]=w(y.sxs[o],y.sys[o],a);break;case"next":[[m,x],k]=w(y.sxs[o],y.sys[o],a+1);break;case"nearest":[[m,x],k]=v(a,t,c,d,y.sxs[o],y.sys[o]),g=y._xs[o][k],b=y._ys[o][k];break;default:throw new Error("should't have happened")}f=s instanceof r.GlyphRenderer?s.view.convert_indices_from_subset([o])[0]:o;const T={index:f,x:h,y:u,sx:c,sy:d,data_x:g,data_y:b,segment_index:k,indices:i.multiline_indices,name:e.model.name};n.add(m,x,this._render_tooltips(l,f,T))}}_emit_callback(e){for(const t of this.computed_renderers){const s=t.data_source.inspected,{frame:n}=this.plot_view,o=n.xscales[t.x_range_name],i=n.yscales[t.y_range_name],r=o.invert(e.sx),l=i.invert(e.sy),a=Object.assign({x:r,y:l},e);this.model.callback.execute(this.model,{index:s,geometry:a,renderer:t})}}_render_tooltips(e,t,s){const n=this.model.tooltips;if(u.isString(n)){const o=_.div();return o.innerHTML=d.replace_placeholders(n,e,t,this.model.formatters,s),o}if(u.isFunction(n))return n(e,s);{const o=_.div({style:{display:"table",borderSpacing:"2px"}});for(const[i,r]of n){const n=_.div({style:{display:"table-row"}});let l;if(o.appendChild(n),l=_.div({style:{display:"table-cell"},class:f.bk_tooltip_row_label},0!=i.length?i+": ":""),n.appendChild(l),l=_.div({style:{display:"table-cell"},class:f.bk_tooltip_row_value}),n.appendChild(l),r.indexOf("$color")>=0){const[,s="",n]=r.match(/\$color(\[.*\])?:(\w*)/),o=e.get_column(n);if(null==o){const e=_.span({},n+" unknown");l.appendChild(e);continue}const i=s.indexOf("hex")>=0,a=s.indexOf("swatch")>=0;let c=u.isNumber(t)?o[t]:null;if(null==c){const e=_.span({},"(null)");l.appendChild(e);continue}i&&(c=h.color2hex(c));let d=_.span({},c);l.appendChild(d),a&&(d=_.span({class:f.bk_tooltip_color_block,style:{backgroundColor:c}}," "),l.appendChild(d))}else{const n=_.span();n.innerHTML=d.replace_placeholders(r.replace("$~","$data_"),e,t,this.model.formatters,s),l.appendChild(n)}}return o}}}s.HoverToolView=g,g.__name__="HoverToolView";class b extends o.InspectTool{constructor(e){super(e),this.tool_name="Hover",this.icon=x.bk_tool_icon_hover}static init_HoverTool(){this.prototype.default_view=g,this.define({tooltips:[p.Any,[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[p.Any,{}],renderers:[p.Any,"auto"],names:[p.Array,[]],mode:[p.HoverMode,"mouse"],muted_policy:[p.MutedPolicy,"show"],point_policy:[p.PointPolicy,"snap_to_data"],line_policy:[p.LinePolicy,"nearest"],show_arrow:[p.Boolean,!0],anchor:[p.Anchor,"center"],attachment:[p.TooltipAttachment,"horizontal"],callback:[p.Any]}),this.register_alias("hover",()=>new b)}}s.HoverTool=b,b.__name__="HoverTool",b.init_HoverTool()},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1).__importStar(t(18)),n=t(14),s=t(71),l=t(274),c=t(356);class r extends s.Model{constructor(t){super(t)}static init_ToolProxy(){this.define({tools:[i.Array,[]],active:[i.Boolean,!1],disabled:[i.Boolean,!1]})}get button_view(){return this.tools[0].button_view}get event_type(){return this.tools[0].event_type}get tooltip(){return this.tools[0].tooltip}get tool_name(){return this.tools[0].tool_name}get icon(){return this.tools[0].computed_icon}get computed_icon(){return this.icon}get toggleable(){const t=this.tools[0];return t instanceof l.InspectTool&&t.toggleable}initialize(){super.initialize(),this.do=new n.Signal0(this,"do")}connect_signals(){super.connect_signals(),this.connect(this.do,()=>this.doit()),this.connect(this.properties.active.change,()=>this.set_active());for(const t of this.tools)this.connect(t.properties.active.change,()=>{this.active=t.active})}doit(){for(const t of this.tools)t.do.emit()}set_active(){for(const t of this.tools)t.active=this.active}get menu(){const{menu:t}=this.tools[0];if(null==t)return null;const o=[];for(const[e,i]of c.enumerate(t))if(null==e)o.push(null);else{const t=()=>{var t,o;for(const e of this.tools)null===(o=null===(t=e.menu)||void 0===t?void 0:t[i])||void 0===o||o.handler()};o.push(Object.assign(Object.assign({},e),{handler:t}))}return o}}e.ToolProxy=r,r.__name__="ToolProxy",r.init_ToolProxy()},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});const t=e(9);function*r(e,n){const o=e.length;if(n>o)return;const r=t.range(n);for(yield r.map(n=>e[n]);;){let f;for(const e of t.reversed(t.range(n)))if(r[e]!=e+o-n){f=e;break}if(null==f)return;r[f]+=1;for(const e of t.range(f+1,n))r[e]=r[e-1]+1;yield r.map(n=>e[n])}}o.enumerate=function*(e){let n=0;for(const o of e)yield[o,n++]},o.combinations=r,o.subsets=function*(e){for(const n of t.range(e.length+1))yield*r(e,n)}},
function _(t,o,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1).__importStar(t(18)),e=t(9),n=t(283),r=t(355),l=t(245),c=t(188);class h extends n.ToolbarBase{constructor(t){super(t)}static init_ProxyToolbar(){this.define({toolbars:[i.Array,[]]})}initialize(){super.initialize(),this._merge_tools()}_merge_tools(){this._proxied_tools=[];const t={},o={},s={},i=[],n=[];for(const t of this.help)e.includes(n,t.redirect)||(i.push(t),n.push(t.redirect));this._proxied_tools.push(...i),this.help=i;for(const t in this.gestures){const o=this.gestures[t];t in s||(s[t]={});for(const i of o.tools)i.type in s[t]||(s[t][i.type]=[]),s[t][i.type].push(i)}for(const o of this.inspectors)o.type in t||(t[o.type]=[]),t[o.type].push(o);for(const t of this.actions)t.type in o||(o[t.type]=[]),o[t.type].push(t);const l=(t,o=!1)=>{const s=new r.ToolProxy({tools:t,active:o});return this._proxied_tools.push(s),s};for(const t in s){const o=this.gestures[t];o.tools=[];for(const i in s[t]){const e=s[t][i];if(e.length>0)if("multi"==t)for(const t of e){const s=l([t]);o.tools.push(s),this.connect(s.properties.active.change,()=>this._active_change(s))}else{const t=l(e);o.tools.push(t),this.connect(t.properties.active.change,()=>this._active_change(t))}}}this.actions=[];for(const t in o){const s=o[t];if("CustomAction"==t)for(const t of s)this.actions.push(l([t]));else s.length>0&&this.actions.push(l(s))}this.inspectors=[];for(const o in t){const s=t[o];s.length>0&&this.inspectors.push(l(s,!0))}for(const t in this.gestures){const o=this.gestures[t];0!=o.tools.length&&(o.tools=e.sort_by(o.tools,t=>t.default_order),"pinch"!=t&&"scroll"!=t&&"multi"!=t&&(o.tools[0].active=!0))}}}s.ProxyToolbar=h,h.__name__="ProxyToolbar",h.init_ProxyToolbar();class a extends l.LayoutDOMView{initialize(){this.model.toolbar.toolbar_location=this.model.toolbar_location,super.initialize()}get child_models(){return[this.model.toolbar]}_update_layout(){this.layout=new c.ContentBox(this.child_views[0].el);const{toolbar:t}=this.model;t.horizontal?this.layout.set_sizing({width_policy:"fit",min_width:100,height_policy:"fixed"}):this.layout.set_sizing({width_policy:"fixed",height_policy:"fit",min_height:100})}}s.ToolbarBoxView=a,a.__name__="ToolbarBoxView";class _ extends l.LayoutDOM{constructor(t){super(t)}static init_ToolbarBox(){this.prototype.default_view=a,this.define({toolbar:[i.Instance],toolbar_location:[i.Location,"right"]})}}s.ToolbarBox=_,_.__name__="ToolbarBox",_.init_ToolbarBox()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(5),i=e(66),d=e(99),c=e(68),l=e(359);t.index={},t.add_document_standalone=async function(e,n,s=[],a=!1){const u=new Map;async function r(o){let a;const r=e.roots().indexOf(o),f=s[r];null!=f?a=f:n.classList.contains(l.BOKEH_ROOT)?a=n:(a=c.div({class:l.BOKEH_ROOT}),n.appendChild(a));const v=await d.build_view(o,{parent:null});return v instanceof i.DOMView&&v.renderTo(a),u.set(o,v),t.index[o.id]=v,v}for(const n of e.roots())await r(n);return a&&(window.document.title=e.title()),e.on_change(e=>{e instanceof o.RootAddedEvent?r(e.model):e instanceof o.RootRemovedEvent?function(e){const n=u.get(e);null!=n&&(n.remove(),u.delete(e),delete t.index[e.id])}(e.model):a&&e instanceof o.TitleChangedEvent&&(window.document.title=e.title)}),[...u.values()]}},
function _(e,o,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(68),r=e(246);function l(e){let o=document.getElementById(e);if(null==o)throw new Error(`Error rendering Bokeh model: could not find #${e} HTML tag`);if(!document.body.contains(o))throw new Error(`Error rendering Bokeh model: element #${e} must be under <body>`);if("SCRIPT"==o.tagName){const e=t.div({class:n.BOKEH_ROOT});t.replaceWith(o,e),o=e}return o}n.BOKEH_ROOT=r.bk_root,n._resolve_element=function(e){const{elementid:o}=e;return null!=o?l(o):document.body},n._resolve_root_elements=function(e){const o=[];if(null!=e.root_ids&&null!=e.roots)for(const n of e.root_ids)o.push(l(e.roots[n]));return o}},
function _(n,o,t){Object.defineProperty(t,"__esModule",{value:!0});const e=n(361),s=n(72),c=n(358);t._get_ws_url=function(n,o){let t,e="ws:";return"https:"==window.location.protocol&&(e="wss:"),null!=o?(t=document.createElement("a"),t.href=o):t=window.location,null!=n?"/"==n&&(n=""):n=t.pathname.replace(/\/+$/,""),e+"//"+t.host+n+"/ws"};const r={};t.add_document_from_session=async function(n,o,t,a=[],i=!1){const l=window.location.search.substr(1);let d;try{d=await function(n,o,t){const s=e.parse_token(o).session_id;n in r||(r[n]={});const c=r[n];return s in c||(c[s]=e.pull_session(n,o,t)),c[s]}(n,o,l)}catch(n){const t=e.parse_token(o).session_id;throw s.logger.error(`Failed to load Bokeh session ${t}: ${n}`),n}return c.add_document_standalone(d.document,t,a,i)}},
function _(e,s,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(72),o=e(5),r=e(362),i=e(363),c=e(364);n.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",n.DEFAULT_TOKEN="eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";let l=0;function _(e){let s=e.split(".")[0];const n=s.length%4;return 0!=n&&(s+="=".repeat(4-n)),JSON.parse(atob(s.replace(/_/g,"/").replace(/-/g,"+")))}n.parse_token=_;class h{constructor(e=n.DEFAULT_SERVER_WEBSOCKET_URL,s=n.DEFAULT_TOKEN,o=null){this.url=e,this.token=s,this.args_string=o,this._number=l++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_replies=new Map,this._pending_messages=[],this._receiver=new i.Receiver,this.id=_(s).session_id.split(".")[0],t.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`)}async connect(){if(this.closed_permanently)throw new Error("Cannot connect() a closed ClientConnection");if(null!=this.socket)throw new Error("Already connected");this._current_handler=null,this._pending_replies.clear(),this._pending_messages=[];try{let e=""+this.url;return null!=this.args_string&&this.args_string.length>0&&(e+="?"+this.args_string),this.socket=new WebSocket(e,["bokeh",this.token]),new Promise((e,s)=>{this.socket.binaryType="arraybuffer",this.socket.onopen=()=>this._on_open(e,s),this.socket.onmessage=e=>this._on_message(e),this.socket.onclose=e=>this._on_close(e,s),this.socket.onerror=()=>this._on_error(s)})}catch(e){throw t.logger.error("websocket creation failed to url: "+this.url),t.logger.error(" - "+e),e}}close(){this.closed_permanently||(t.logger.debug("Permanently closing websocket connection "+this._number),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,"close method called on ClientConnection "+this._number),this.session._connection_closed())}_schedule_reconnect(e){setTimeout(()=>{this.closed_permanently||t.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to reconnect`)},e)}send(e){if(null==this.socket)throw new Error("not connected so cannot send "+e);e.send(this.socket)}async send_with_reply(e){const s=await new Promise((s,n)=>{this._pending_replies.set(e.msgid(),{resolve:s,reject:n}),this.send(e)});if("ERROR"===s.msgtype())throw new Error("Error reply "+s.content.text);return s}async _pull_doc_json(){const e=r.Message.create("PULL-DOC-REQ",{}),s=await this.send_with_reply(e);if(!("doc"in s.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return s.content.doc}async _repull_session_doc(e,s){var n;t.logger.debug(this.session?"Repulling session":"Pulling session for first time");try{const n=await this._pull_doc_json();if(null==this.session)if(this.closed_permanently)t.logger.debug("Got new document after connection was already closed"),s(new Error("The connection has been closed"));else{const s=o.Document.from_json(n),i=o.Document._compute_patch_since_json(n,s);if(i.events.length>0){t.logger.debug(`Sending ${i.events.length} changes from model construction back to server`);const e=r.Message.create("PATCH-DOC",{},i);this.send(e)}this.session=new c.ClientSession(this,s,this.id);for(const e of this._pending_messages)this.session.handle(e);this._pending_messages=[],t.logger.debug("Created a new session from new pulled doc"),e(this.session)}else this.session.document.replace_with_json(n),t.logger.debug("Updated existing session with new pulled doc")}catch(e){null===(n=console.trace)||void 0===n||n.call(console,e),t.logger.error("Failed to repull session "+e),s(e)}}_on_open(e,s){t.logger.info(`Websocket connection ${this._number} is now open`),this._current_handler=n=>{this._awaiting_ack_handler(n,e,s)}}_on_message(e){null==this._current_handler&&t.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(e.toString())}const s=this._receiver.message;if(null!=s){const e=s.problem();null!=e&&this._close_bad_protocol(e),this._current_handler(s)}}_on_close(e,s){t.logger.info(`Lost websocket ${this._number} connection, ${e.code} (${e.reason})`),this.socket=null,this._pending_replies.forEach(e=>e.reject("Disconnected")),this._pending_replies.clear(),this.closed_permanently||this._schedule_reconnect(2e3),s(new Error(`Lost websocket connection, ${e.code} (${e.reason})`))}_on_error(e){t.logger.debug("Websocket error on socket "+this._number);const s="Could not open websocket";t.logger.error("Failed to connect to Bokeh server: "+s),e(new Error(s))}_close_bad_protocol(e){t.logger.error("Closing connection: "+e),null!=this.socket&&this.socket.close(1002,e)}_awaiting_ack_handler(e,s,n){"ACK"===e.msgtype()?(this._current_handler=e=>this._steady_state_handler(e),this._repull_session_doc(s,n)):this._close_bad_protocol("First message was not an ACK")}_steady_state_handler(e){const s=e.reqid(),n=this._pending_replies.get(s);n?(this._pending_replies.delete(s),n.resolve(e)):this.session?this.session.handle(e):"PATCH-DOC"!=e.msgtype()&&this._pending_messages.push(e)}}n.ClientConnection=h,h.__name__="ClientConnection",n.pull_session=function(e,s,n){return new h(e,s,n).connect()}},
function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const r=e(24);class n{constructor(e,s,t){this.header=e,this.metadata=s,this.content=t,this.buffers=new Map}static assemble(e,s,t){const r=JSON.parse(e),i=JSON.parse(s),a=JSON.parse(t);return new n(r,i,a)}assemble_buffer(e,s){const t=null!=this.header.num_buffers?this.header.num_buffers:0;if(t<=this.buffers.size)throw new Error("too many buffers received, expecting "+t);const{id:r}=JSON.parse(e);this.buffers.set(r,s)}static create(e,s,t={}){const r=n.create_header(e);return new n(r,s,t)}static create_header(e){return{msgid:r.uniqueId(),msgtype:e}}complete(){return null!=this.header&&null!=this.metadata&&null!=this.content&&(null==this.header.num_buffers||this.buffers.size==this.header.num_buffers)}send(e){if((null!=this.header.num_buffers?this.header.num_buffers:0)>0)throw new Error("BokehJS only supports receiving buffers, not sending");const s=JSON.stringify(this.header),t=JSON.stringify(this.metadata),r=JSON.stringify(this.content);e.send(s),e.send(t),e.send(r)}msgid(){return this.header.msgid}msgtype(){return this.header.msgtype}reqid(){return this.header.reqid}problem(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"}}t.Message=n,n.__name__="Message"},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const _=e(362),r=e(8);class i{constructor(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}consume(e){this._current_consumer(e)}_HEADER(e){this._assume_text(e),this.message=null,this._partial=null,this._fragments=[e],this._buf_header=null,this._current_consumer=this._METADATA}_METADATA(e){this._assume_text(e),this._fragments.push(e),this._current_consumer=this._CONTENT}_CONTENT(e){this._assume_text(e),this._fragments.push(e);const[t,s,r]=this._fragments.slice(0,3);this._partial=_.Message.assemble(t,s,r),this._check_complete()}_BUFFER_HEADER(e){this._assume_text(e),this._buf_header=e,this._current_consumer=this._BUFFER_PAYLOAD}_BUFFER_PAYLOAD(e){this._assume_binary(e),this._partial.assemble_buffer(this._buf_header,e),this._check_complete()}_assume_text(e){if(!r.isString(e))throw new Error("Expected text fragment but received binary fragment")}_assume_binary(e){if(!(e instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")}_check_complete(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER}}s.Receiver=i,i.__name__="Receiver"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(5),s=e(362),c=e(72);class i{constructor(e,t,n){this._connection=e,this.document=t,this.id=n,this._document_listener=e=>{this._document_changed(e)},this.document.on_change(this._document_listener,!0)}handle(e){const t=e.msgtype();"PATCH-DOC"===t?this._handle_patch(e):"OK"===t?this._handle_ok(e):"ERROR"===t?this._handle_error(e):c.logger.debug("Doing nothing with message "+e.msgtype())}close(){this._connection.close()}_connection_closed(){this.document.remove_on_change(this._document_listener)}async request_server_info(){const e=s.Message.create("SERVER-INFO-REQ",{});return(await this._connection.send_with_reply(e)).content}async force_roundtrip(){await this.request_server_info()}_document_changed(e){if(e.setter_id===this.id)return;const t=e instanceof o.DocumentEventBatch?e.events:[e],n=this.document.create_json_patch(t),c=s.Message.create("PATCH-DOC",{},n);this._connection.send(c)}_handle_patch(e){this.document.apply_json_patch(e.content,e.buffers,this.id)}_handle_ok(e){c.logger.trace("Unhandled OK reply to "+e.reqid())}_handle_error(e){c.logger.error(`Unhandled ERROR reply to ${e.reqid()}: ${e.content.text}`)}}n.ClientSession=i,i.__name__="ClientSession"},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1);var r=this&&this.__asyncValues||function(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var o,t=e[Symbol.asyncIterator];return t?t.call(e):(e="function"==typeof __values?__values(e):e[Symbol.iterator](),o={},n("next"),n("throw"),n("return"),o[Symbol.asyncIterator]=function(){return this},o);function n(t){o[t]=e[t]&&function(o){return new Promise((function(n,r){(function(e,o,t,n){Promise.resolve(n).then((function(o){e({value:o,done:t})}),o)})(n,r,(o=e[t](o)).done,o.value)}))}}};const s=e(5),i=e(363),l=e(72),a=e(68),c=e(17),u=e(358),f=e(359),g=n.__importDefault(e(69)),m=n.__importDefault(e(289)),d=n.__importDefault(e(366));function p(e,o){o.buffers.length>0?e.consume(o.buffers[0].buffer):e.consume(o.content.data);const t=e.message;null!=t&&this.apply_json_patch(t.content,t.buffers)}function _(e,o){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){l.logger.info("Registering Jupyter comms for target "+e);const t=Jupyter.notebook.kernel.comm_manager;try{t.register_target(e,t=>{l.logger.info("Registering Jupyter comms for target "+e);const n=new i.Receiver;t.on_msg(p.bind(o,n))})}catch(e){l.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if(o.roots()[0].id in t.kernels){l.logger.info("Registering JupyterLab comms for target "+e);const n=t.kernels[o.roots()[0].id];try{n.registerCommTarget(e,t=>{l.logger.info("Registering JupyterLab comms for target "+e);const n=new i.Receiver;t.onMsg=p.bind(o,n)})}catch(e){l.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if("undefined"!=typeof google&&null!=google.colab.kernel){l.logger.info("Registering Google Colab comms for target "+e);const t=google.colab.kernel.comms;try{t.registerTarget(e,async t=>{var n,s,a;l.logger.info("Registering Google Colab comms for target "+e);const c=new i.Receiver;try{for(var u,f=r(t.messages);!(u=await f.next()).done;){const e=u.value,t={data:e.data},n=[];for(const o of null!==(a=e.buffers)&&void 0!==a?a:[])n.push(new DataView(o));const r={content:t,buffers:n};p.bind(o)(c,r)}}catch(e){n={error:e}}finally{try{u&&!u.done&&(s=f.return)&&await s.call(f)}finally{if(n)throw n.error}}})}catch(e){l.logger.warn(`Google Colab comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}a.stylesheet.append(g.default),a.stylesheet.append(m.default),a.stylesheet.append(d.default),t.kernels={},t.embed_items_notebook=function(e,o){if(1!=c.size(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");const t=s.Document.from_json(c.values(e)[0]);for(const e of o){null!=e.notebook_comms_target&&_(e.notebook_comms_target,t);const o=f._resolve_element(e),n=f._resolve_root_elements(e);u.add_document_standalone(t,o,n)}}},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});o.default="\n/* notebook specific tweaks so no black outline and matching padding\n/* can't be wrapped inside bk-root. here are the offending jupyter lines:\n/* https://github.com/jupyter/notebook/blob/master/notebook/static/notebook/less/renderedhtml.less#L59-L76 */\n.rendered_html .bk-root .bk-tooltip table,\n.rendered_html .bk-root .bk-tooltip tr,\n.rendered_html .bk-root .bk-tooltip th,\n.rendered_html .bk-root .bk-tooltip td {\n  border: none;\n  padding: 1px;\n}\n"},
function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0});const o=e(1);o.__exportStar(e(362),_),o.__exportStar(e(363),_)},
function _(e,t,n){function s(){const e=document.getElementsByTagName("body")[0],t=document.getElementsByClassName("bokeh-test-div");1==t.length&&(e.removeChild(t[0]),delete t[0]);const n=document.createElement("div");n.classList.add("bokeh-test-div"),n.style.display="none",e.insertBefore(n,e.firstChild)}Object.defineProperty(n,"__esModule",{value:!0}),n.results={},n.init=function(){s()},n.record0=function(e,t){n.results[e]=t},n.record=function(e,t){n.results[e]=t,s()},n.count=function(e){null==n.results[e]&&(n.results[e]=0),n.results[e]+=1,s()}},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0}),o.safely=function(e,t=!1){try{return e()}catch(e){if(function(e){const t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");const o=document.createElement("span");o.style.backgroundColor="#a94442",o.style.borderRadius="0px 4px 0px 0px",o.style.color="white",o.style.cursor="pointer",o.style.cssFloat="right",o.style.fontSize="0.8em",o.style.margin="-6px -6px 0px 0px",o.style.padding="2px 5px 4px 5px",o.title="close",o.setAttribute("aria-label","close"),o.appendChild(document.createTextNode("x")),o.addEventListener("click",()=>r.removeChild(t));const n=document.createElement("h3");n.style.color="#a94442",n.style.margin="8px 0px 0px 0px",n.style.padding="0px",n.appendChild(document.createTextNode("Bokeh Error"));const l=document.createElement("pre");l.style.whiteSpace="unset",l.style.overflowX="auto";const s=e instanceof Error?e.message:e;l.appendChild(document.createTextNode(s)),t.appendChild(o),t.appendChild(n),t.appendChild(l);const r=document.getElementsByTagName("body")[0];r.insertBefore(t,r.firstChild)}(e),t)return;throw e}}},
], 0, {"main":0,"tslib":1,"index":2,"version":3,"embed/index":4,"document/index":5,"document/document":6,"base":7,"core/util/types":8,"core/util/array":9,"core/util/math":10,"core/util/assert":11,"core/util/arrayable":12,"core/has_props":13,"core/signaling":14,"core/util/callback":15,"core/util/refs":16,"core/util/object":17,"core/properties":18,"core/enums":19,"core/util/color":20,"core/util/svg_colors":21,"core/settings":22,"core/property_mixins":23,"core/util/string":24,"core/util/eq":25,"core/util/ndarray":26,"core/util/serialization":27,"core/util/compat":28,"models/index":29,"models/annotations/index":30,"models/annotations/annotation":31,"core/util/projections":32,"models/renderers/renderer":65,"core/dom_view":66,"core/view":67,"core/dom":68,"styles/root.css":69,"core/visuals":70,"model":71,"core/logging":72,"styles/annotations.css":73,"models/annotations/arrow":74,"models/annotations/arrow_head":75,"models/sources/column_data_source":76,"models/sources/columnar_data_source":77,"models/sources/data_source":78,"models/selections/selection":79,"core/selection_manager":80,"models/renderers/glyph_renderer":81,"models/renderers/data_renderer":82,"models/glyphs/line":83,"models/glyphs/xy_glyph":84,"core/util/spatial":85,"core/util/bbox":88,"models/glyphs/glyph":89,"models/ranges/factor_range":90,"models/ranges/range":91,"models/glyphs/utils":92,"core/hittest":93,"models/glyphs/patch":94,"models/glyphs/harea":95,"models/glyphs/area":96,"models/glyphs/varea":97,"models/sources/cds_view":98,"core/build_views":99,"models/renderers/graph_renderer":100,"models/graphs/graph_hit_test_policy":101,"models/selections/interaction_policy":102,"core/util/typed_array":103,"core/util/set":104,"document/events":105,"models/annotations/band":106,"models/annotations/box_annotation":107,"models/annotations/color_bar":108,"models/tickers/basic_ticker":109,"models/tickers/adaptive_ticker":110,"models/tickers/continuous_ticker":111,"models/tickers/ticker":112,"models/formatters/basic_tick_formatter":113,"models/formatters/tick_formatter":114,"models/mappers/linear_color_mapper":115,"models/mappers/continuous_color_mapper":116,"models/mappers/color_mapper":117,"models/mappers/mapper":118,"models/transforms/transform":119,"models/scales/linear_scale":120,"models/scales/continuous_scale":121,"models/scales/scale":122,"models/transforms/index":123,"models/transforms/customjs_transform":124,"models/transforms/dodge":125,"models/transforms/interpolator":126,"models/transforms/jitter":127,"models/transforms/linear_interpolator":128,"models/transforms/step_interpolator":129,"models/scales/log_scale":130,"models/ranges/range1d":131,"core/util/text":132,"models/annotations/label":133,"models/annotations/text_annotation":134,"models/annotations/label_set":135,"models/annotations/legend":136,"models/annotations/legend_item":137,"core/vectorization":138,"models/annotations/poly_annotation":139,"models/annotations/slope":140,"models/annotations/span":141,"models/annotations/title":142,"models/annotations/toolbar_panel":143,"models/annotations/tooltip":144,"styles/tooltips":145,"styles/mixins":146,"styles/tooltips.css":147,"models/annotations/whisker":148,"models/axes/index":149,"models/axes/axis":150,"models/renderers/guide_renderer":151,"models/axes/categorical_axis":152,"models/tickers/categorical_ticker":153,"models/formatters/categorical_tick_formatter":154,"models/axes/continuous_axis":155,"models/axes/datetime_axis":156,"models/axes/linear_axis":157,"models/formatters/datetime_tick_formatter":158,"core/util/templating":160,"models/tickers/datetime_ticker":163,"models/tickers/composite_ticker":164,"models/tickers/days_ticker":165,"models/tickers/single_interval_ticker":166,"models/tickers/util":167,"models/tickers/months_ticker":168,"models/tickers/years_ticker":169,"models/axes/log_axis":170,"models/formatters/log_tick_formatter":171,"models/tickers/log_ticker":172,"models/axes/mercator_axis":173,"models/formatters/mercator_tick_formatter":174,"models/tickers/mercator_ticker":175,"models/callbacks/index":176,"models/callbacks/customjs":177,"models/callbacks/callback":178,"models/callbacks/open_url":179,"models/canvas/index":180,"models/canvas/canvas":181,"core/util/canvas":182,"core/util/svg":183,"models/canvas/cartesian_frame":184,"models/scales/categorical_scale":185,"models/ranges/data_range1d":186,"models/ranges/data_range":187,"core/layout/index":188,"core/layout/types":189,"core/layout/layoutable":190,"core/layout/alignments":191,"core/layout/grid":192,"core/layout/html":193,"models/expressions/index":194,"models/expressions/expression":195,"models/expressions/stack":196,"models/expressions/cumsum":197,"models/filters/index":198,"models/filters/boolean_filter":199,"models/filters/filter":200,"models/filters/customjs_filter":201,"models/filters/group_filter":202,"models/filters/index_filter":203,"models/formatters/index":204,"models/formatters/func_tick_formatter":205,"models/formatters/numeral_tick_formatter":206,"models/formatters/printf_tick_formatter":207,"models/glyphs/index":208,"models/glyphs/annular_wedge":209,"models/glyphs/annulus":210,"models/glyphs/arc":211,"models/glyphs/bezier":212,"models/glyphs/circle":213,"models/glyphs/center_rotatable":214,"models/glyphs/ellipse":215,"models/glyphs/ellipse_oval":216,"models/glyphs/hbar":217,"models/glyphs/box":218,"models/glyphs/hex_tile":219,"models/glyphs/image":220,"models/glyphs/image_base":221,"models/glyphs/image_rgba":222,"models/glyphs/image_url":223,"core/util/image":224,"models/glyphs/multi_line":225,"models/glyphs/multi_polygons":226,"models/glyphs/oval":227,"models/glyphs/patches":228,"models/glyphs/quad":229,"models/glyphs/quadratic":230,"models/glyphs/ray":231,"models/glyphs/rect":232,"models/glyphs/segment":233,"models/glyphs/step":234,"models/glyphs/text":235,"models/glyphs/vbar":236,"models/glyphs/wedge":237,"models/graphs/index":238,"models/graphs/layout_provider":239,"models/graphs/static_layout_provider":240,"models/grids/index":241,"models/grids/grid":242,"models/layouts/index":243,"models/layouts/box":244,"models/layouts/layout_dom":245,"styles/root":246,"models/layouts/column":247,"models/layouts/grid_box":248,"models/layouts/html_box":249,"models/layouts/row":250,"models/layouts/spacer":251,"models/layouts/tabs":252,"styles/tabs":253,"styles/buttons":254,"styles/menus":255,"styles/buttons.css":256,"styles/menus.css":257,"styles/tabs.css":258,"models/layouts/widget_box":259,"models/mappers/index":260,"models/mappers/categorical_color_mapper":261,"models/mappers/categorical_mapper":262,"models/mappers/categorical_marker_mapper":263,"models/mappers/categorical_pattern_mapper":264,"models/mappers/log_color_mapper":265,"models/markers/index":266,"models/markers/defs":267,"models/markers/marker":268,"models/markers/scatter":269,"models/plots/index":270,"models/plots/gmap_plot":271,"models/plots/plot":272,"models/tools/toolbar":273,"models/tools/inspectors/inspect_tool":274,"models/tools/button_tool":275,"models/tools/tool":277,"styles/toolbar":278,"styles/toolbar.css":279,"styles/icons.css":280,"core/util/menus":281,"models/tools/on_off_button":282,"models/tools/toolbar_base":283,"models/tools/gestures/gesture_tool":284,"models/tools/actions/action_tool":285,"models/tools/actions/help_tool":286,"styles/icons":287,"styles/logo":288,"styles/logo.css":289,"models/plots/plot_canvas":290,"core/bokeh_events":291,"core/ui_events":292,"core/util/wheel":293,"core/util/throttle":294,"core/layout/side_panel":295,"models/plots/gmap_plot_canvas":296,"models/ranges/index":297,"models/renderers/index":298,"models/scales/index":299,"models/selections/index":300,"models/sources/index":301,"models/sources/server_sent_data_source":302,"models/sources/web_data_source":303,"models/sources/ajax_data_source":304,"models/sources/geojson_data_source":305,"models/tickers/index":306,"models/tickers/fixed_ticker":307,"models/tiles/index":308,"models/tiles/bbox_tile_source":309,"models/tiles/mercator_tile_source":310,"models/tiles/tile_source":311,"models/tiles/tile_utils":312,"models/tiles/quadkey_tile_source":313,"models/tiles/tile_renderer":314,"models/tiles/wmts_tile_source":315,"styles/tiles":316,"styles/tiles.css":317,"models/tiles/tms_tile_source":318,"models/textures/index":319,"models/textures/canvas_texture":320,"models/textures/texture":321,"models/textures/image_url_texture":322,"models/tools/index":323,"models/tools/actions/custom_action":324,"models/tools/actions/redo_tool":325,"models/tools/actions/reset_tool":326,"models/tools/actions/save_tool":327,"models/tools/actions/undo_tool":328,"models/tools/actions/zoom_in_tool":329,"core/util/zoom":330,"models/tools/actions/zoom_out_tool":331,"models/tools/edit/edit_tool":332,"models/tools/edit/box_edit_tool":333,"models/tools/edit/freehand_draw_tool":334,"models/tools/edit/point_draw_tool":335,"models/tools/edit/poly_draw_tool":336,"models/tools/edit/poly_tool":337,"models/tools/edit/poly_edit_tool":338,"models/tools/gestures/box_select_tool":339,"models/tools/gestures/select_tool":340,"models/tools/util":341,"models/tools/gestures/box_zoom_tool":342,"models/tools/gestures/lasso_select_tool":343,"models/tools/edit/line_edit_tool":344,"models/tools/edit/line_tool":345,"models/tools/gestures/pan_tool":346,"models/tools/gestures/poly_select_tool":347,"models/tools/gestures/range_tool":348,"models/tools/gestures/tap_tool":349,"models/tools/gestures/wheel_pan_tool":350,"models/tools/gestures/wheel_zoom_tool":351,"models/tools/inspectors/crosshair_tool":352,"models/tools/inspectors/customjs_hover":353,"models/tools/inspectors/hover_tool":354,"models/tools/tool_proxy":355,"core/util/iterator":356,"models/tools/toolbar_box":357,"embed/standalone":358,"embed/dom":359,"embed/server":360,"client/connection":361,"protocol/message":362,"protocol/receiver":363,"client/session":364,"embed/notebook":365,"styles/notebook.css":366,"protocol/index":367,"testing":368,"safely":369}, {});
})

