# batteryclient
A standard API for accessing battery experiment datasets and metadata

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import batteryclient
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import batteryclient
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import batteryclient
from pprint import pprint
from batteryclient.api import users_api
from batteryclient.model.cell import Cell
from batteryclient.model.dataset import Dataset
from batteryclient.model.equipment import Equipment
from batteryclient.model.user import User
# Defining the host is optional and defaults to https://virtserver.swaggerhub.com/martinjrobins/battery-api/1.0.0
# See configuration.py for a list of all supported configuration parameters.
configuration = batteryclient.Configuration(
    host = "https://virtserver.swaggerhub.com/martinjrobins/battery-api/1.0.0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearerAuth
configuration = batteryclient.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with batteryclient.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = users_api.UsersApi(api_client)
    id = 1 # int | Numeric ID of the resource to get

    try:
        # get information on a single cell
        api_response = api_instance.get_cell(id)
        pprint(api_response)
    except batteryclient.ApiException as e:
        print("Exception when calling UsersApi->get_cell: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://virtserver.swaggerhub.com/martinjrobins/battery-api/1.0.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*UsersApi* | [**get_cell**](docs/UsersApi.md#get_cell) | **GET** /cell/{id} | get information on a single cell
*UsersApi* | [**get_cells**](docs/UsersApi.md#get_cells) | **GET** /cell | gets information on all cells
*UsersApi* | [**get_column**](docs/UsersApi.md#get_column) | **GET** /dataset/{id}/{column_id} | gets a single column of data from a dataset
*UsersApi* | [**get_dataset**](docs/UsersApi.md#get_dataset) | **GET** /dataset/{id} | get information on a single dataset
*UsersApi* | [**get_datasets**](docs/UsersApi.md#get_datasets) | **GET** /dataset | gets information on all datasets
*UsersApi* | [**get_equipment**](docs/UsersApi.md#get_equipment) | **GET** /equipment/{id} | get information on a single item of test equipment
*UsersApi* | [**get_equipments**](docs/UsersApi.md#get_equipments) | **GET** /equipment | gets information on all recorded test equipment
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /user/{id} | get information on a single user
*UsersApi* | [**get_users**](docs/UsersApi.md#get_users) | **GET** /user | gets information on all users


## Documentation For Models

 - [Cell](docs/Cell.md)
 - [Column](docs/Column.md)
 - [Dataset](docs/Dataset.md)
 - [Equipment](docs/Equipment.md)
 - [Error](docs/Error.md)
 - [Range](docs/Range.md)
 - [User](docs/User.md)


## Documentation For Authorization


## bearerAuth

- **Type**: Bearer authentication (JWT)


## Author

martin.robinson@cs.ox.ac.uk


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in batteryclient.apis and batteryclient.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from batteryclient.api.default_api import DefaultApi`
- `from batteryclient.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import batteryclient
from batteryclient.apis import *
from batteryclient.models import *
```

