# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sherlockpipe',
 'sherlockpipe.LATTEsub',
 'sherlockpipe.LATTEsub.LATTE',
 'sherlockpipe.LATTEsub.LATTE.tests',
 'sherlockpipe.curve_preparer',
 'sherlockpipe.eleanorSub',
 'sherlockpipe.eleanorSub.docs',
 'sherlockpipe.eleanorSub.docs.sphinx_rtd_theme',
 'sherlockpipe.eleanorSub.eleanor',
 'sherlockpipe.eleanorSub.eleanor.tests',
 'sherlockpipe.objectinfo',
 'sherlockpipe.objectinfo.preparer',
 'sherlockpipe.ois',
 'sherlockpipe.scoring',
 'sherlockpipe.search_zones',
 'sherlockpipe.star',
 'sherlockpipe.tests',
 'sherlockpipe.tlsSub',
 'sherlockpipe.tlsSub.docs.source',
 'sherlockpipe.tlsSub.transitleastsquares',
 'sherlockpipe.tlsSub.transitleastsquares.template_generator',
 'sherlockpipe.tlsSub.transitleastsquares.tests',
 'sherlockpipe.tpfplotter',
 'sherlockpipe.tpfplotter.docs.source']

package_data = \
{'': ['*'],
 'sherlockpipe': ['resources/allesfitter/*'],
 'sherlockpipe.LATTEsub': ['.LATTE_new/tesspoint/*',
                           '.ipynb_checkpoints/*',
                           'example/*',
                           'example/example_output/*',
                           'paper/*',
                           'tessLATTE.egg-info/*'],
 'sherlockpipe.LATTEsub.LATTE': ['LATTE_imgs/*',
                                 'test_output/*',
                                 'test_output/55525572/*',
                                 'test_output/55525572/model_out/*',
                                 'test_output/data/*'],
 'sherlockpipe.LATTEsub.LATTE.tests': ['LATTE_imgs/*'],
 'sherlockpipe.eleanorSub': ['.ci/*', 'figures/*', 'notebooks/*'],
 'sherlockpipe.eleanorSub.docs': ['getting_started/*'],
 'sherlockpipe.eleanorSub.docs.sphinx_rtd_theme': ['static/css/*',
                                                   'static/fonts/*',
                                                   'static/js/*'],
 'sherlockpipe.eleanorSub.eleanor': ['metadata/*'],
 'sherlockpipe.tlsSub': ['.github/ISSUE_TEMPLATE/*', 'tutorials/*'],
 'sherlockpipe.tpfplotter': ['docs/*',
                             'docs/build/doctrees/*',
                             'docs/build/html/*',
                             'docs/build/html/_images/*',
                             'docs/build/html/_sources/*',
                             'docs/build/html/_static/*',
                             'docs/build/html/_static/css/*',
                             'docs/build/html/_static/css/fonts/*',
                             'docs/build/html/_static/fonts/*',
                             'docs/build/html/_static/fonts/Lato/*',
                             'docs/build/html/_static/fonts/RobotoSlab/*',
                             'docs/build/html/_static/js/*',
                             'logo.png/*'],
 'sherlockpipe.tpfplotter.docs.source': ['_static/*']}

install_requires = \
['Cython>=0.29.21,<0.30.0',
 'PyYAML>=5.4.1,<6.0.0',
 'allesfitter>=1.1.6,<2.0.0',
 'argparse>=1.4.0,<2.0.0',
 'astroplan>=0.7,<0.8',
 'astropy>=4.1,<5.0',
 'astroquery>=0.4.1,<0.5.0',
 'batman-package>=2.4.7,<3.0.0',
 'bokeh>=2.2.3,<3.0.0',
 'celerite>=0.4.0,<0.5.0',
 'configparser>=5.0.1,<6.0.0',
 'corner>=2.1.0,<3.0.0',
 'dynesty>=1.0.1,<2.0.0',
 'ellc>=1.8.5,<2.0.0',
 'emcee>=3.0.2,<4.0.0',
 'lightkurve>=2.0b5,<3.0',
 'matplotlib>=3.3.4,<4.0.0',
 'mock>=4.0.3,<5.0.0',
 'numba>=0.52.0,<0.53.0',
 'pandas>=1.1.5,<2.0.0',
 'photutils>=1.0.2,<2.0.0',
 'reportlab>=3.5.59,<4.0.0',
 'reproject==0.4',
 'requests>=2.25.1,<3.0.0',
 'scipy>=1.5.4,<2.0.0',
 'seaborn>=0.11.1,<0.12.0',
 'setuptools>=52.0.0,<53.0.0',
 'sklearn>=0.0,<0.1',
 'tess-point>=0.6.1,<0.7.0',
 'torch>=1.7.1,<2.0.0',
 'tqdm>=4.56.0,<5.0.0',
 'transitleastsquares>=1.0.25,<2.0.0',
 'triceratops>=1.0.2,<2.0.0',
 'wotan>=1.9,<2.0']

extras_require = \
{':python_version >= "3.6.2" and python_version < "3.8"': ['numpy==1.19.5'],
 ':python_version >= "3.8"': ['numpy>=1.20,<2.0']}

setup_kwargs = {
    'name': 'sherlockpipe',
    'version': '0.17.3rc4',
    'description': 'SHERLOCKPipe: Search for Hints of Exoplanets fRom Light-curves Of spaCe-based seeKers PIPEline',
    'long_description': '<p align="center">\n  <img width="350" src="https://github.com/franpoz/SHERLOCK/blob/master/images/sherlock3.png?raw=true">\n</p>\n\nThe <b>SHERLOCK</b> (<b>S</b>earching for <b>H</b>ints of <b>E</b>xoplanets f<b>R</b>om <b>L</b>ightcurves \n<b>O</b>f spa<b>C</b>e-based see<b>K</b>ers) <b>PIPE</b>line is a user-friendly pipeline, which\nminimizes the interaction of the user to the minimum when using data coming from Kepler or TESS missions. SHERLOCK makes use of previous well-known and well-tested codes which allow the exoplanets community to explore the public data from space-based missions without need of a deep knowledge of how the data are built and stored. \nIn most of cases the user only needs to provide with a KOI-ID, EPIC-ID, TIC-ID or coordinates of the host star where wants to search for exoplanets.\n\n## Main Developers\nActive: <i>[F.J. Pozuelos](https://github.com/franpoz), \n[M. Dévora](https://github.com/martindevora) </i> \n\n## Additional contributors \n<i>A. Thuillier</i> & <i>[L. García](https://github.com/LionelGarcia) </i>\n\n## Installation\nThe package can be installed from the PyPi repositories:\n\n```python3 -m pip install sherlockpipe```\n\nYou can also use our Docker image from [DockerHub](https://hub.docker.com/repository/docker/sherlockpipe/sherlockpipe) \nor build it from our [Dockerfile](https://github.com/franpoz/SHERLOCK/blob/master/docker/Dockerfile). Therefore, you\ncan also use as a Singularity container meanwhile they support Docker.\n\n## Launch\nYou can run SHERLOCK PIPEline as a standalone package by using:\n\n```python3 -m sherlockpipe --properties my_properties.yaml```\n\nYou only need to provide a YAML file with any of the properties contained in the internal \n[properties.yaml](https://github.com/franpoz/SHERLOCK/blob/master/sherlockpipe/properties.yaml)\nprovided by the pipeline. The most important keys to be defined in your YAML file are those under\nthe `GLOBAL OBJECTS RUN SETUP` and `SECTOR OBJECTS RUN SETUP` sections because they contain the object ids\nor files to be analysed in the execution. You\'d need to fill at least one of those keys for the\npipeline to do anything. If you still have any doubts please refer to the \n[examples/properties](https://github.com/franpoz/SHERLOCK/tree/master/examples/properties) directory \n\nAdditionally, you could only want to inspect the preparation stage of SHERLOCK and therefore, you can execute it without\nrunning the analyse phase so you can watch the light curve, the periodogram and the initial report to take better\ndecisions to tune the execution parameters. Just launch SHERLOCK with:\n\n ```python3 -m sherlockpipe --properties my_properties.yaml --explore```\n \n and it will end as soon as it has processed the preparation stages for each object.\n\n## Updates\nSHERLOCK uses third party data to know TOIs, KOIs, EPICs and to handle FFIs and the vetting process.\nThis data gets frequently updated from the active missions and therefore SHERLOCK will perform better\nif the metadata gets refreshed. You can simply run:\n\n```python3 -m sherlockpipe.update```\n\nand SHERLOCK will download the dependencies. It will store a timestamp to remember the last time it was\nrefreshed to prevent several unneeded calls. However, if you find that there are more updates and you need\nthem now, you can call:\n\n```python3 -m sherlockpipe.update --force``` \n\nand SHERLOCK will ignore the timestamps and perform the update process. In addition, you could be interested\nin wiping all the metadata and build it again. That\'s why you could execute:\n\n```python3 -m sherlockpipe.update --clean```\n\nThis last command implies a `force` statement and the last executed time will be ignored too.\n\nYou can additionally let SHERLOCK refresh the OIs list before running your current execution by adding to the\nYAML file the next line:\n\n```UPDATE_OIS=True``` \n\n### Vetting\nSHERLOCK PIPEline comes with a submodule to examine the most promising transit candidates\nfound by any of its executions. This is done via [LATTE](https://github.com/noraeisner/LATTE), \n[TPFPlotter](https://github.com/jlillo/tpfplotter) and \n[Triceratops](https://github.com/stevengiacalone/triceratops).\nPlease note that this feature is only enabled for TESS candidates.\nYou should be able to execute the vetting by calling:\n\n```python3 -m sherlockpipe.vet --properties my_properties.yaml```\n\nThrough that command you will run the vetting process for the given parameters within your provided YAML file. \nYou could watch the generated results under `$your_sherlock_object_results_dir/vetting` directory.\nPlease go to \n[examples/vetting/](https://github.com/franpoz/SHERLOCK/tree/master/examples/vetting.)\nto learn how to inject the proper properties for the vetting process.\n\nThere is an additional simplified option which can be used to run the vetting. In case you are sure\nthere is a candidate from the Sherlock results which matches your desired parameters, you can run\n\n```python3 -m sherlockpipe.vet --candidate ${theCandidateNumber}``` \n\nfrom the sherlock results directory. This execution will automatically read the transit\nparameters from the Sherlock generated files.\n\n### Fitting\nSHERLOCK PIPEline comes with another submodule to fit the most promising transit candidates\nfound by any of its executions. This fit is done via \n[ALLESFITTER](https://github.com/MNGuenther/allesfitter) code. By calling:\n\n```python3 -m sherlockpipe.fit --properties my_properties.yaml```\n\nyou will run the fitting process for the given parameters within your provided YAML file. \nYou could watch the generated results under `$your_sherlock_object_results_dir/fit` directory.\nPlease go to \n[examples/fitting/](https://github.com/franpoz/SHERLOCK/tree/master/examples/fitting)\nto learn how to inject the proper properties for the fitting process.\n\nThere is an additional simplified option which can be used to run the fit. In case you are sure\nthere is a candidate from the Sherlock results which matches your desired parameters, you can run\n\n```python3 -m sherlockpipe.fit --candidate ${theCandidateNumber}``` \n\nfrom the sherlock results directory. This execution will automatically read the transit and star\nparameters from the Sherlock generated files.\n\n## SHERLOCK PIPEline Workflow\nIt is important to note that SHERLOCK PIPEline uses some csv files with TOIs, KOIs and EPIC IDs\nfrom the TESS, Kepler and K2 missions. Therefore your first execution of the pipeline might\ntake longer because it will download the information.\n\n### Provisioning of light curve\nThe light curve for every input object needs to be obtained from its mission database. For this we \nuse the high level API of [Lightkurve](https://github.com/KeplerGO/lightkurve), which enables the\ndownload of the desired light curves for TESS, Kepler and K2 missions. We also include Full Frame\nImages from the TESS mission by the usage of [ELEANOR](https://adina.feinste.in/eleanor/). We \nalways use the PDCSAP signal from the ones provided by any of those two packages.\n\n### Pre-processing of light curve\nIn many cases we will find light curves which contain several systematics like noise, high dispersion\nbeside the borders, intense periodicities caused by pulsators, fast rotators, etc. SHERLOCK PIPEline\nprovides some methods to reduce these most important systematics.\n\n#### Local noise reduction\nFor local noise, where very close measurements show high deviation from the local trend, we apply a\nSavitzky-Golay filter. This has proved a highly increment of the SNR of found transits. This feature \ncan be disabled with a flag.\n\n#### High RMS areas masking\nSometimes the spacecrafts have to perform reaction wheels momentum dumps by firing thrusters,\nsometimes there is high light scattering and sometimes the spacecraft can infer some jitter into\nthe signal. For all of those systematics we found that in many cases the data from those regions\nshould be discarded. Thus, SHERLOCK PIPEline includes a binned RMS computation where bins whose\nRMS value is higher than a configurable factor multiplied by the median get automatically masked.\nThis feature can be disabled with a flag. \n\n#### Input time ranges masking\nIf enabled, this feature automatically disables \n[High RMS areas masking](https://github.com/franpoz/SHERLOCK#high-rms-areas-masking) \nfor the assigned object. The user can input an array of time ranges to be masked into the \noriginal signal.\n\n#### Detrend of intense periodicities\nOur most common foes with high periodicities are fast-rotators, which infer a high sinusoidal-like\ntrend in the PDCSAP signal. This is why SHERLOCK PIPEline includes an automatic intense periodicities\ndetection and detrending during its preparation stage. This feature can be disabled with a flag.\n\n#### Input period detrend\nIf enabled, this feature automatically disables \n[Detrend of intense periodicities](https://github.com/franpoz/SHERLOCK#detrend-of-intense-periodicities) \nfor the assigned object. The user can input a period to be used for an initial detrend of the \noriginal signal. \n\n#### Custom user code\nYou can even inject your own python code to perform:\n* A custom signal preparation task by implementing the\n[CurvePreparer](https://github.com/franpoz/SHERLOCK/tree/master/sherlockpipe/sherlockpipe/curve_preparer/CurvePreparer.py)\nclass that we provide. Then, inject your python file into the `CUSTOM_PREPARER` property and let SHERLOCK\nuse your code.\n* A custom best signal selection algorithm by implementing the \n[SignalSelector](https://github.com/franpoz/SHERLOCK/tree/master/sherlockpipe/sherlockpipe/scoring/SignalSelector.py). \nclass that we provide. Then, inject your python file into the `CUSTOM_ALGORITHM` property and let SHERLOCK use your code.\n* A custom search zone definition by implementing the\n[SearchZone](https://github.com/franpoz/SHERLOCK/tree/master/sherlockpipe/sherlockpipe/search_zones/SearchZone.py).\nclass that we provide. Then, inject your python file into the `CUSTOM_SEARCH_ZONE` property and let SHERLOCK use your code. \n* Custom search modes: \'tls\', \'bls\', \'grazing\', \'comet\' or \'custom\'. You can search for transits by using TLS, BLS,\nTLS for a grazing template, TLS for a comet template or even inject your custom transit template (this is currently\nincluded as an experimental feature).\n\nFor better understanding of usage please see the\n[examples](https://github.com/franpoz/SHERLOCK/tree/master/examples/properties/custom_algorithms.yaml),\nwhich references custom implementations that you can inspect in our \n[custom algorithms directory](https://github.com/franpoz/SHERLOCK/tree/master/examples/custom_algorithms)\n\n### Main execution (run)\nAfter the preparation stage, the SHERLOCK PIPEline will execute what we call `runs` iteratively:\n* Several detrended fluxes with increasing window sizes will be extracted from the original \nPDCSAP light curve by using [wotan](https://github.com/hippke/wotan)\n* For each detrended flux, the [TransitLeastSquares](https://github.com/hippke/tls) utility will \nbe executed to find the most prominent transit.\n* The best transit is chosen from all the ones found in the detrended fluxes. Here we have three \ndifferent algorithms for the selection:\n    * Basic: Selects the best transit signal only based in the highest SNR value.\n    * Border-correct: Selects the best transit signal based in a corrected SNR value. This \n    correction is applied with a border-score factor, which is calculated from the found transits \n    which overlap or are very close to empty-measurements areas in the signal.\n    * Quorum: Including the same correction from the border-correct algorithm, quorum will also\n    increase the SNR values when several detrended fluxes \'agree\' about their transit selection \n    (same ephemerids). The more detrended fluxes agree, the more SNR they get. This algorithm \n    can be slightly tuned by changing the stregth or weight of every detrend vote. It is currently \n    in testing stage and hasn\'t been used intensively.\n    * Custom: You can also inject your own signal selection algorithm by implementing the \n    [SignalSelector](https://github.com/franpoz/SHERLOCK/tree/master/sherlockpipe/scoring/SignalSelector.py)\n    class. See the [example](https://github.com/franpoz/SHERLOCK/tree/master/examples/properties/custom_algorithms.yaml).\n* Measurements matching the chosen transit are masked in the original PDCSAP signal so they will\nnot be found by subsequent runs.\n\n### Reporting\nSHERLOCK PIPEline produces several information items under a new directory for every analysed\nobject:\n* Object report log: The entire log of the object run is written here.\n* Most Promising Candidates log: A summary of the parameters of the best transits found for each\nrun is written at the end of the object execution. Example content:\n```\nListing most promising candidates for ID MIS_TIC 470381900_all:\nDetrend no. Period  Duration  T0      SNR     SDE     FAP       Border_score  Matching OI   Semi-major axis   Habitability Zone   \n1           2.5013  50.34     1816.69 13.30   14.95   0.000080  1.00          TOI 1696.01   0.02365           I                   \n4           0.5245  29.65     1816.56 8.34    6.26    0.036255  1.00          nan           0.00835           I                   \n5           0.6193  29.19     1816.43 8.76    6.57    0.019688  1.00          nan           0.00933           I                   \n1           0.8111  29.04     1816.10 9.08    5.88    0.068667  0.88          nan           0.01116           I                   \n2           1.0093  32.41     1817.05 8.80    5.59    nan       0.90          nan           0.01291           I                   \n6           3.4035  45.05     1819.35 6.68    5.97    0.059784  1.00          nan           0.02904           I      \n```\n* Runs directories: Containing png images of the detrended fluxes and their suggested transits.\nExample of one detrended flux transit selection image:\n<p align="center">\n  <img width="80%" src="https://github.com/franpoz/SHERLOCK/blob/master/images/example_run.png">\n</p>\n\n* Light curve csv file: The original (before pre-processing) PDCSAP signal stored in three columns: \n`#time`, `flux` and `flux_err`. Example content:\n```\n#time,flux,flux_err\n1816.0895073542242,0.9916135,0.024114653\n1816.0908962630185,1.0232307,0.024185425\n1816.0922851713472,1.0293404,0.024151148\n1816.0936740796774,1.000998,0.024186047\n1816.0950629880074,1.0168158,0.02415397\n1816.0964518968017,1.0344968,0.024141008\n1816.0978408051305,1.0061758,0.024101004\n...\n```\n* Candidates csv file: Containing the same information than the Most Promising Candidates log but\nin a csv format so it can be read by future additions to the pipeline like vetting or fitting\nendpoints.\n* Lomb-Scargle periodogram plot: Showing the period strengths. Example:\n<p align="center">\n  <img width="80%" src="https://github.com/franpoz/SHERLOCK/blob/master/images/periodogram.png">\n</p>\n\n* RMS masking plot: In case the High RMS masking pre-processing is enabled. Example:\n<p align="center">\n  <img width="80%" src="https://github.com/franpoz/SHERLOCK/blob/master/images/rms.png">\n</p>\n\n* Phase-folded period plot: In case auto-detrend or manual period detrend is enabled.\n<p align="center">\n  <img width="80%" src="https://github.com/franpoz/SHERLOCK/blob/master/images/autodetrend.png">\n</p>\n\n### Dependencies\nAll the needed dependencies should be included by your `pip` installation of SHERLOCK. If you are\ninterested you can inspect the requirements list under \n[setup.py](https://github.com/franpoz/SHERLOCK/blob/master/setup.py).\n\n## Testing\nSHERLOCK Pipeline comes with a light automated tests suite which can be executed with:\n```python3 -m unittest sherlock_tests.py```.\nThis suite tests several points from the pipeline:\n* The construction of the Sherlock object.\n* The parameters setup of the Sherlock object.\n* The provisioning of objects of interest files.\n* Load and filtering of objects of interest.\n* Different kind of short Sherlock executions.\n\nIn case you want to test the entire SHERLOCK PIPEline functionality we encourage you to\nrun some (or all) the [manual examples](https://github.com/franpoz/SHERLOCK/tree/master/examples).\nIf so, please read the instructions provided there to execute them.\n\n## Integration\nSHERLOCK integrates with several third party services. Some of them are listed below:\n* TESS, Kepler and K2 databases through [Lightkurve](https://github.com/KeplerGO/lightkurve), \n[ELEANOR](https://adina.feinste.in/eleanor/) and [LATTE](https://github.com/noraeisner/LATTE).\n* MAST and Vizier catalogs through [Lightkurve](https://github.com/KeplerGO/lightkurve), \n[transitleastsquares](https://github.com/hippke/tls) and \n[Triceratops](https://github.com/stevengiacalone/triceratops)\n* [NASA Exoplanet Archive API](https://exoplanetarchive.ipac.caltech.edu/docs/program_interfaces.html)\n* [TESS ExoFOP](https://exofop.ipac.caltech.edu/tess/view_toi.php).\n',
    'author': 'Franciso J. Pozuelos',
    'author_email': 'fpozuelos@uliege.be',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/franpoz/SHERLOCK',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6.2,<3.9',
}


setup(**setup_kwargs)
