"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInsightsVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const architecture_1 = require("./architecture");
// To add new versions, update fact-tables.ts `CLOUDWATCH_LAMBDA_INSIGHTS_ARNS` and create a new `public static readonly VERSION_A_B_C_D`
/**
 * Version of CloudWatch Lambda Insights.
 *
 * @stability stable
 */
class LambdaInsightsVersion {
    constructor() {
        /**
         * The arn of the Lambda Insights extension.
         *
         * @stability stable
         */
        this.layerVersionArn = '';
    }
    /**
     * Use the insights extension associated with the provided ARN.
     *
     * Make sure the ARN is associated
     * with same region as your function
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-extension-versions.html
     * @stability stable
     */
    static fromInsightVersionArn(arn) {
        class InsightsArn extends LambdaInsightsVersion {
            constructor() {
                super(...arguments);
                this.layerVersionArn = arn;
            }
            _bind(_scope, _function) {
                return { arn };
            }
        }
        return new InsightsArn();
    }
    // Use the verison to build the object. Not meant to be called by the user -- user should use e.g. VERSION_1_0_54_0
    static fromInsightsVersion(insightsVersion) {
        class InsightsVersion extends LambdaInsightsVersion {
            constructor() {
                super(...arguments);
                this.layerVersionArn = core_1.Lazy.uncachedString({
                    produce: (context) => getVersionArn(context.scope, insightsVersion),
                });
            }
            _bind(_scope, _function) {
                var _b, _c;
                const arch = (_c = (_b = _function.architecture) === null || _b === void 0 ? void 0 : _b.name) !== null && _c !== void 0 ? _c : architecture_1.Architecture.X86_64.name;
                // Check if insights version is valid. This should only happen if one of the public static readonly versions are set incorrectly
                // or if the version is not available for the Lambda Architecture
                const versionExists = region_info_1.RegionInfo.regions.some(regionInfo => regionInfo.cloudwatchLambdaInsightsArn(insightsVersion, arch));
                if (!versionExists) {
                    throw new Error(`Insights version ${insightsVersion} does not exist.`);
                }
                return {
                    arn: getVersionArn(_scope, insightsVersion, arch),
                };
            }
        }
        return new InsightsVersion();
    }
}
exports.LambdaInsightsVersion = LambdaInsightsVersion;
_a = JSII_RTTI_SYMBOL_1;
LambdaInsightsVersion[_a] = { fqn: "@aws-cdk/aws-lambda.LambdaInsightsVersion", version: "1.137.0" };
/**
 * Version 1.0.54.0.
 *
 * @stability stable
 */
LambdaInsightsVersion.VERSION_1_0_54_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.54.0');
/**
 * Version 1.0.86.0.
 *
 * @stability stable
 */
LambdaInsightsVersion.VERSION_1_0_86_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.86.0');
/**
 * Version 1.0.89.0.
 *
 * @stability stable
 */
LambdaInsightsVersion.VERSION_1_0_89_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.89.0');
/**
 * Version 1.0.98.0.
 *
 * @stability stable
 */
LambdaInsightsVersion.VERSION_1_0_98_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.98.0');
/**
 * Version 1.0.119.0.
 *
 * @stability stable
 */
LambdaInsightsVersion.VERSION_1_0_119_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.119.0');
/**
 * Function to retrieve the correct Lambda Insights ARN from RegionInfo,
 * or create a mapping to look it up at stack deployment time.
 *
 * This function is run on CDK synthesis.
 */
function getVersionArn(scope, insightsVersion, architecture) {
    const scopeStack = core_1.Stack.of(scope);
    const region = scopeStack.region;
    const arch = architecture !== null && architecture !== void 0 ? architecture : architecture_1.Architecture.X86_64.name;
    // Region is defined, look up the arn, or throw an error if the version isn't supported by a region
    if (region !== undefined && !core_1.Token.isUnresolved(region)) {
        const arn = region_info_1.RegionInfo.get(region).cloudwatchLambdaInsightsArn(insightsVersion, arch);
        if (arn === undefined) {
            throw new Error(`Insights version ${insightsVersion} is not supported in region ${region}`);
        }
        return arn;
    }
    // Otherwise, need to add a mapping to be looked up at deployment time
    return scopeStack.regionalFact(region_info_1.FactName.cloudwatchLambdaInsightsVersion(insightsVersion, arch));
}
//# sourceMappingURL=data:application/json;base64,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