# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['apiclient_pydantic_generator']

package_data = \
{'': ['*'], 'apiclient_pydantic_generator': ['templates/*']}

install_requires = \
['Jinja2>=2.11.2,<4.0.0',
 'api-client-pydantic>=1.1,<2.0',
 'api-client>=1.3,<2.0',
 'datamodel-code-generator>=0.11,<0.12',
 'isort>=5.9,<6.0',
 'pydantic>=1.5,<2.0',
 'stringcase>=1.2,<2.0',
 'typer[all]>=0.2.1,<0.5.0',
 'yapf>=0.31,<0.32']

entry_points = \
{'console_scripts': ['apiclient-codegen = '
                     'apiclient_pydantic_generator.__main__:app']}

setup_kwargs = {
    'name': 'apiclient-pydantic-generator',
    'version': '0.1.0',
    'description': 'This code generator creates a ApiClient app from an openapi file.',
    'long_description': '![GitHub issues](https://img.shields.io/github/issues/mom1/apiclient-pydantic-generator.svg)\n![GitHub stars](https://img.shields.io/github/stars/mom1/apiclient-pydantic-generator.svg)\n![GitHub Release Date](https://img.shields.io/github/release-date/mom1/apiclient-pydantic-generator.svg)\n![GitHub commits since latest release](https://img.shields.io/github/commits-since/mom1/apiclient-pydantic-generator/latest.svg)\n![GitHub last commit](https://img.shields.io/github/last-commit/mom1/apiclient-pydantic-generator.svg)\n[![GitHub license](https://img.shields.io/github/license/mom1/apiclient-pydantic-generator)](https://github.com/mom1/apiclient-pydantic-generator/blob/master/LICENSE)\n\n[![PyPI](https://img.shields.io/pypi/v/apiclient-pydantic-generator.svg)](https://pypi.python.org/pypi/apiclient-pydantic-generator)\n[![PyPI](https://img.shields.io/pypi/pyversions/apiclient-pydantic-generator.svg)]()\n![PyPI - Downloads](https://img.shields.io/pypi/dm/apiclient-pydantic-generator.svg?label=pip%20installs&logo=python)\n\n\n# apiclient-pydantic-generator\n\nThis code generator creates a ApiClient app from an openapi file.\n\nThis project uses:\n  - [datamodel-code-generator](https://github.com/koxudaxi/datamodel-code-generator) to generate pydantic models\n  - [api-client](https://github.com/MikeWooster/api-client) to create class ApiClient\n  - [api-client-pydantic](https://github.com/mom1/api-client-pydantic) extension for validate request data and converting json straight to pydantic class.\n\n\nThis project highly inspired [fastapi-code-generator](https://github.com/koxudaxi/fastapi-code-generator)\n\n## Installation\n\nTo install `apiclient-pydantic-generator`:\n```sh\n$ pip install apiclient-pydantic-generator\n```\n\n## Usage\n\nThe `apiclient-pydantic-generator` command:\n```\nUsage: apiclient-codegen [OPTIONS]\n\nOptions:\n  -i, --input FILENAME     [required]\n  -o, --output PATH        [required]\n  -t, --template-dir PATH\n  -b, --base_url TEXT      [default: ]\n  -p, --prefix TEXT        If "My" then will be MyApiClient  [default: My]\n  -a, --base_api_cls TEXT  Base class for client class  [default:\n                           apiclient.APIClient]\n\n  --install-completion     Install completion for the current shell.\n  --show-completion        Show completion for the current shell, to copy it\n                           or customize the installation.\n\n  --help                   Show this message and exit.\n```\n\n\n## Example\n\n### OpenAPI\n\n<details>\n  <summary>petstore.yaml</summary>\n  <pre>\n    <code>\n      openapi: \'3.0.0\'\n      info:\n        version: 1.0.0\n        title: Swagger Petstore\n        license:\n          name: MIT\n      servers:\n        - url: http://petstore.swagger.io/v1\n      paths:\n        /pets:\n          get:\n            summary: List all pets\n            operationId: listPets\n            tags:\n              - pets\n            parameters:\n              - name: limit\n                in: query\n                description: How many items to return at one time (max 100)\n                required: false\n                schema:\n                  type: integer\n                  format: int32\n            responses:\n              \'200\':\n                description: A paged array of pets\n                headers:\n                  x-next:\n                    description: A link to the next page of responses\n                    schema:\n                      type: string\n                content:\n                  application/json:\n                    schema:\n                      $ref: \'#/components/schemas/Pets\'\n              default:\n                description: unexpected error\n                content:\n                  application/json:\n                    schema:\n                      $ref: \'#/components/schemas/Error\'\n                      x-amazon-apigateway-integration:\n                        uri:\n                          Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n                        passthroughBehavior: when_no_templates\n                        httpMethod: POST\n                        type: aws_proxy\n          post:\n            summary: Create a pet\n            operationId: createPets\n            tags:\n              - pets\n            responses:\n              \'201\':\n                description: Null response\n              default:\n                description: unexpected error\n                content:\n                  application/json:\n                    schema:\n                      $ref: \'#/components/schemas/Error\'\n                      x-amazon-apigateway-integration:\n                        uri:\n                          Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n                        passthroughBehavior: when_no_templates\n                        httpMethod: POST\n                        type: aws_proxy\n        /pets/{petId}:\n          get:\n            summary: Info for a specific pet\n            operationId: showPetById\n            tags:\n              - pets\n            parameters:\n              - name: petId\n                in: path\n                required: true\n                description: The id of the pet to retrieve\n                schema:\n                  type: string\n            responses:\n              \'200\':\n                description: Expected response to a valid request\n                content:\n                  application/json:\n                    schema:\n                      $ref: \'#/components/schemas/Pets\'\n              default:\n                description: unexpected error\n                content:\n                  application/json:\n                    schema:\n                      $ref: \'#/components/schemas/Error\'\n          x-amazon-apigateway-integration:\n            uri:\n              Fn::Sub: arn:aws:apigateway:${AWS::Region}:lambda:path/2015-03-31/functions/${PythonVersionFunction.Arn}/invocations\n            passthroughBehavior: when_no_templates\n            httpMethod: POST\n            type: aws_proxy\n      components:\n        schemas:\n          Pet:\n            required:\n              - id\n              - name\n            properties:\n              id:\n                type: integer\n                format: int64\n              name:\n                type: string\n              tag:\n                type: string\n          Pets:\n            type: array\n            description: list of pet\n            items:\n              $ref: \'#/components/schemas/Pet\'\n          Error:\n            required:\n              - code\n              - message\n            properties:\n              code:\n                type: integer\n                format: int32\n              message:\n                type: string\n    </code>\n  </pre>\n</details>\n\n```sh\n$ apiclient-codegen --input petstore.yaml --output app_petstore --prefix PetStore\n```\n\n`app_petstore/__init__.py`:\n```python\nfrom .client import PetStoreAPIClient\n\n\n__all__ = (\'PetStoreAPIClient\', )\n```\n\n`app_petstore/client.py`:\n```python\nfrom __future__ import annotations\n\nfrom apiclient import APIClient\nfrom apiclient_pydantic import serialize_all_methods\n\nfrom .endpoints import Endpoints\nfrom .models import LimitQueryParams, PetIdPathParams, Pets\n\n\n@serialize_all_methods()\nclass PetStoreAPIClient(APIClient):\n    def list_pets(self, query_params: LimitQueryParams) -> Pets:\n        """List all pets"""\n        return self.get(Endpoints.list_pets, query_params)\n\n    def create_pets(self) -> None:\n        """Create a pet"""\n        self.post(Endpoints.create_pets)\n\n    def show_pet_by_id(self, path_params: PetIdPathParams) -> Pets:\n        """Info for a specific pet"""\n        return self.get(Endpoints.show_pet_by_id.format(**path_params))\n```\n\n`app_petstore/endpoints.py`:\n```python\nfrom apiclient import endpoint\n\n\n@endpoint(base_url=\'http://petstore.swagger.io/v1\')\nclass Endpoints:\n    list_pets: str = \'/pets\'\n    create_pets: str = \'/pets\'\n    show_pet_by_id: str = \'/pets/{pet_id}\'\n```\n\n`app_petstore/models.py`:\n```python\nfrom __future__ import annotations\n\nfrom typing import List, Optional\n\nfrom pydantic import BaseModel, Field\n\n\nclass Pet(BaseModel):\n    id: int\n    name: str\n    tag: Optional[str] = None\n\n\nclass Pets(BaseModel):\n    __root__: List[Pet] = Field(..., description=\'list of pet\')\n\n\nclass Error(BaseModel):\n    code: int\n    message: str\n\n\nclass LimitQueryParams(BaseModel):\n    limit: Optional[int] = None\n\n\nclass PetIdPathParams(BaseModel):\n    petId: str\n```\n\nUsing a class:\n```python\nfrom apiclient.request_formatters import JsonRequestFormatter\nfrom apiclient.response_handlers import JsonResponseHandler\n\nfrom app_petstore import PetStoreAPIClient\n\n\npet_client = PetStoreAPIClient(response_handler=JsonResponseHandler, request_formatter=JsonRequestFormatter)\npets = pet_client.list_pets()\nfor pet in pets:\n    print(pet.name)\n```\n\n## License\n\napiclient-pydantic-generator is released under the MIT License. http://www.opensource.org/licenses/mit-license\n',
    'author': 'MaxST',
    'author_email': 'mstolpasov@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mom1/apiclient-pydantic-generator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
