"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Scheme:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SchemeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Scheme.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN: _Scheme.ValueType  # 0
    HTTP: _Scheme.ValueType  # 1
    HTTPS: _Scheme.ValueType  # 2
    WS: _Scheme.ValueType  # 3
    WSS: _Scheme.ValueType  # 4

class Scheme(_Scheme, metaclass=_SchemeEnumTypeWrapper):
    """Scheme describes the schemes supported by the OpenAPI Swagger
    and Operation objects.
    """

UNKNOWN: Scheme.ValueType  # 0
HTTP: Scheme.ValueType  # 1
HTTPS: Scheme.ValueType  # 2
WS: Scheme.ValueType  # 3
WSS: Scheme.ValueType  # 4
global___Scheme = Scheme

class Swagger(google.protobuf.message.Message):
    """`Swagger` is a representation of OpenAPI v2 specification's Swagger object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#swaggerObject

    Example:

     option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_swagger) = {
       info: {
         title: "Echo API";
         version: "1.0";
         description: "";
         contact: {
           name: "gRPC-Gateway project";
           url: "https://github.com/grpc-ecosystem/grpc-gateway";
           email: "none@example.com";
         };
         license: {
           name: "BSD 3-Clause License";
           url: "https://github.com/grpc-ecosystem/grpc-gateway/blob/master/LICENSE.txt";
         };
       };
       schemes: HTTPS;
       consumes: "application/json";
       produces: "application/json";
     };
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ResponsesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Response: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Response | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    class ExtensionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.struct_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.struct_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SWAGGER_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    HOST_FIELD_NUMBER: builtins.int
    BASE_PATH_FIELD_NUMBER: builtins.int
    SCHEMES_FIELD_NUMBER: builtins.int
    CONSUMES_FIELD_NUMBER: builtins.int
    PRODUCES_FIELD_NUMBER: builtins.int
    RESPONSES_FIELD_NUMBER: builtins.int
    SECURITY_DEFINITIONS_FIELD_NUMBER: builtins.int
    SECURITY_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    EXTERNAL_DOCS_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    swagger: builtins.str
    """Specifies the OpenAPI Specification version being used. It can be
    used by the OpenAPI UI and other clients to interpret the API listing. The
    value MUST be "2.0".
    """
    @property
    def info(self) -> global___Info:
        """Provides metadata about the API. The metadata can be used by the
        clients if needed.
        """
    host: builtins.str
    """The host (name or ip) serving the API. This MUST be the host only and does
    not include the scheme nor sub-paths. It MAY include a port. If the host is
    not included, the host serving the documentation is to be used (including
    the port). The host does not support path templating.
    """
    base_path: builtins.str
    """The base path on which the API is served, which is relative to the host. If
    it is not included, the API is served directly under the host. The value
    MUST start with a leading slash (/). The basePath does not support path
    templating.
    Note that using `base_path` does not change the endpoint paths that are
    generated in the resulting OpenAPI file. If you wish to use `base_path`
    with relatively generated OpenAPI paths, the `base_path` prefix must be
    manually removed from your `google.api.http` paths and your code changed to
    serve the API from the `base_path`.
    """
    @property
    def schemes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Scheme.ValueType]:
        """The transfer protocol of the API. Values MUST be from the list: "http",
        "https", "ws", "wss". If the schemes is not included, the default scheme to
        be used is the one used to access the OpenAPI definition itself.
        """
    @property
    def consumes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of MIME types the APIs can consume. This is global to all APIs but
        can be overridden on specific API calls. Value MUST be as described under
        Mime Types.
        """
    @property
    def produces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of MIME types the APIs can produce. This is global to all APIs but
        can be overridden on specific API calls. Value MUST be as described under
        Mime Types.
        """
    @property
    def responses(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Response]:
        """An object to hold responses that can be used across operations. This
        property does not define global responses for all operations.
        """
    @property
    def security_definitions(self) -> global___SecurityDefinitions:
        """Security scheme definitions that can be used across the specification."""
    @property
    def security(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SecurityRequirement]:
        """A declaration of which security schemes are applied for the API as a whole.
        The list of values describes alternative security schemes that can be used
        (that is, there is a logical OR between the security requirements).
        Individual operations can override this definition.
        """
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Tag]:
        """A list of tags for API documentation control. Tags can be used for logical
        grouping of operations by resources or any other qualifier.
        """
    @property
    def external_docs(self) -> global___ExternalDocumentation:
        """Additional external documentation."""
    @property
    def extensions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.struct_pb2.Value]:
        """Custom properties that start with "x-" such as "x-foo" used to describe
        extra functionality that is not covered by the standard OpenAPI Specification.
        See: https://swagger.io/docs/specification/2-0/swagger-extensions/
        """
    def __init__(
        self,
        *,
        swagger: builtins.str = ...,
        info: global___Info | None = ...,
        host: builtins.str = ...,
        base_path: builtins.str = ...,
        schemes: collections.abc.Iterable[global___Scheme.ValueType] | None = ...,
        consumes: collections.abc.Iterable[builtins.str] | None = ...,
        produces: collections.abc.Iterable[builtins.str] | None = ...,
        responses: collections.abc.Mapping[builtins.str, global___Response] | None = ...,
        security_definitions: global___SecurityDefinitions | None = ...,
        security: collections.abc.Iterable[global___SecurityRequirement] | None = ...,
        tags: collections.abc.Iterable[global___Tag] | None = ...,
        external_docs: global___ExternalDocumentation | None = ...,
        extensions: collections.abc.Mapping[builtins.str, google.protobuf.struct_pb2.Value] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["external_docs", b"external_docs", "info", b"info", "security_definitions", b"security_definitions"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["base_path", b"base_path", "consumes", b"consumes", "extensions", b"extensions", "external_docs", b"external_docs", "host", b"host", "info", b"info", "produces", b"produces", "responses", b"responses", "schemes", b"schemes", "security", b"security", "security_definitions", b"security_definitions", "swagger", b"swagger", "tags", b"tags"]) -> None: ...

global___Swagger = Swagger

class Operation(google.protobuf.message.Message):
    """`Operation` is a representation of OpenAPI v2 specification's Operation object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#operationObject

    Example:

     service EchoService {
       rpc Echo(SimpleMessage) returns (SimpleMessage) {
         option (google.api.http) = {
           get: "/v1/example/echo/{id}"
         };

         option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_operation) = {
           summary: "Get a message.";
           operation_id: "getMessage";
           tags: "echo";
           responses: {
             key: "200"
               value: {
               description: "OK";
             }
           }
         };
       }
     }
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ResponsesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Response: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Response | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    class ExtensionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.struct_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.struct_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TAGS_FIELD_NUMBER: builtins.int
    SUMMARY_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    EXTERNAL_DOCS_FIELD_NUMBER: builtins.int
    OPERATION_ID_FIELD_NUMBER: builtins.int
    CONSUMES_FIELD_NUMBER: builtins.int
    PRODUCES_FIELD_NUMBER: builtins.int
    RESPONSES_FIELD_NUMBER: builtins.int
    SCHEMES_FIELD_NUMBER: builtins.int
    DEPRECATED_FIELD_NUMBER: builtins.int
    SECURITY_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of tags for API documentation control. Tags can be used for logical
        grouping of operations by resources or any other qualifier.
        """
    summary: builtins.str
    """A short summary of what the operation does. For maximum readability in the
    swagger-ui, this field SHOULD be less than 120 characters.
    """
    description: builtins.str
    """A verbose explanation of the operation behavior. GFM syntax can be used for
    rich text representation.
    """
    @property
    def external_docs(self) -> global___ExternalDocumentation:
        """Additional external documentation for this operation."""
    operation_id: builtins.str
    """Unique string used to identify the operation. The id MUST be unique among
    all operations described in the API. Tools and libraries MAY use the
    operationId to uniquely identify an operation, therefore, it is recommended
    to follow common programming naming conventions.
    """
    @property
    def consumes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of MIME types the operation can consume. This overrides the consumes
        definition at the OpenAPI Object. An empty value MAY be used to clear the
        global definition. Value MUST be as described under Mime Types.
        """
    @property
    def produces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of MIME types the operation can produce. This overrides the produces
        definition at the OpenAPI Object. An empty value MAY be used to clear the
        global definition. Value MUST be as described under Mime Types.
        """
    @property
    def responses(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Response]:
        """The list of possible responses as they are returned from executing this
        operation.
        """
    @property
    def schemes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Scheme.ValueType]:
        """The transfer protocol for the operation. Values MUST be from the list:
        "http", "https", "ws", "wss". The value overrides the OpenAPI Object
        schemes definition.
        """
    deprecated: builtins.bool
    """Declares this operation to be deprecated. Usage of the declared operation
    should be refrained. Default value is false.
    """
    @property
    def security(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SecurityRequirement]:
        """A declaration of which security schemes are applied for this operation. The
        list of values describes alternative security schemes that can be used
        (that is, there is a logical OR between the security requirements). This
        definition overrides any declared top-level security. To remove a top-level
        security declaration, an empty array can be used.
        """
    @property
    def extensions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.struct_pb2.Value]:
        """Custom properties that start with "x-" such as "x-foo" used to describe
        extra functionality that is not covered by the standard OpenAPI Specification.
        See: https://swagger.io/docs/specification/2-0/swagger-extensions/
        """
    def __init__(
        self,
        *,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        summary: builtins.str = ...,
        description: builtins.str = ...,
        external_docs: global___ExternalDocumentation | None = ...,
        operation_id: builtins.str = ...,
        consumes: collections.abc.Iterable[builtins.str] | None = ...,
        produces: collections.abc.Iterable[builtins.str] | None = ...,
        responses: collections.abc.Mapping[builtins.str, global___Response] | None = ...,
        schemes: collections.abc.Iterable[global___Scheme.ValueType] | None = ...,
        deprecated: builtins.bool = ...,
        security: collections.abc.Iterable[global___SecurityRequirement] | None = ...,
        extensions: collections.abc.Mapping[builtins.str, google.protobuf.struct_pb2.Value] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["external_docs", b"external_docs"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["consumes", b"consumes", "deprecated", b"deprecated", "description", b"description", "extensions", b"extensions", "external_docs", b"external_docs", "operation_id", b"operation_id", "produces", b"produces", "responses", b"responses", "schemes", b"schemes", "security", b"security", "summary", b"summary", "tags", b"tags"]) -> None: ...

global___Operation = Operation

class Header(google.protobuf.message.Message):
    """`Header` is a representation of OpenAPI v2 specification's Header object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#headerObject
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESCRIPTION_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    DEFAULT_FIELD_NUMBER: builtins.int
    PATTERN_FIELD_NUMBER: builtins.int
    description: builtins.str
    """`Description` is a short description of the header."""
    type: builtins.str
    """The type of the object. The value MUST be one of "string", "number", "integer", or "boolean". The "array" type is not supported."""
    format: builtins.str
    """`Format` The extending format for the previously mentioned type."""
    default: builtins.str
    """`Default` Declares the value of the header that the server will use if none is provided.
    See: https://tools.ietf.org/html/draft-fge-json-schema-validation-00#section-6.2.
    Unlike JSON Schema this value MUST conform to the defined type for the header.
    """
    pattern: builtins.str
    """'Pattern' See https://tools.ietf.org/html/draft-fge-json-schema-validation-00#section-5.2.3."""
    def __init__(
        self,
        *,
        description: builtins.str = ...,
        type: builtins.str = ...,
        format: builtins.str = ...,
        default: builtins.str = ...,
        pattern: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["default", b"default", "description", b"description", "format", b"format", "pattern", b"pattern", "type", b"type"]) -> None: ...

global___Header = Header

class Response(google.protobuf.message.Message):
    """`Response` is a representation of OpenAPI v2 specification's Response object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#responseObject
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Header: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Header | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    class ExamplesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    class ExtensionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.struct_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.struct_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    DESCRIPTION_FIELD_NUMBER: builtins.int
    SCHEMA_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    EXAMPLES_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    description: builtins.str
    """`Description` is a short description of the response.
    GFM syntax can be used for rich text representation.
    """
    @property
    def schema(self) -> global___Schema:
        """`Schema` optionally defines the structure of the response.
        If `Schema` is not provided, it means there is no content to the response.
        """
    @property
    def headers(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Header]:
        """`Headers` A list of headers that are sent with the response.
        `Header` name is expected to be a string in the canonical format of the MIME header key
        See: https://golang.org/pkg/net/textproto/#CanonicalMIMEHeaderKey
        """
    @property
    def examples(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """`Examples` gives per-mimetype response examples.
        See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#example-object
        """
    @property
    def extensions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.struct_pb2.Value]:
        """Custom properties that start with "x-" such as "x-foo" used to describe
        extra functionality that is not covered by the standard OpenAPI Specification.
        See: https://swagger.io/docs/specification/2-0/swagger-extensions/
        """
    def __init__(
        self,
        *,
        description: builtins.str = ...,
        schema: global___Schema | None = ...,
        headers: collections.abc.Mapping[builtins.str, global___Header] | None = ...,
        examples: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        extensions: collections.abc.Mapping[builtins.str, google.protobuf.struct_pb2.Value] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["schema", b"schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "examples", b"examples", "extensions", b"extensions", "headers", b"headers", "schema", b"schema"]) -> None: ...

global___Response = Response

class Info(google.protobuf.message.Message):
    """`Info` is a representation of OpenAPI v2 specification's Info object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#infoObject

    Example:

     option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_swagger) = {
       info: {
         title: "Echo API";
         version: "1.0";
         description: "";
         contact: {
           name: "gRPC-Gateway project";
           url: "https://github.com/grpc-ecosystem/grpc-gateway";
           email: "none@example.com";
         };
         license: {
           name: "BSD 3-Clause License";
           url: "https://github.com/grpc-ecosystem/grpc-gateway/blob/master/LICENSE.txt";
         };
       };
       ...
     };
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ExtensionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.struct_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.struct_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TERMS_OF_SERVICE_FIELD_NUMBER: builtins.int
    CONTACT_FIELD_NUMBER: builtins.int
    LICENSE_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    title: builtins.str
    """The title of the application."""
    description: builtins.str
    """A short description of the application. GFM syntax can be used for rich
    text representation.
    """
    terms_of_service: builtins.str
    """The Terms of Service for the API."""
    @property
    def contact(self) -> global___Contact:
        """The contact information for the exposed API."""
    @property
    def license(self) -> global___License:
        """The license information for the exposed API."""
    version: builtins.str
    """Provides the version of the application API (not to be confused
    with the specification version).
    """
    @property
    def extensions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.struct_pb2.Value]:
        """Custom properties that start with "x-" such as "x-foo" used to describe
        extra functionality that is not covered by the standard OpenAPI Specification.
        See: https://swagger.io/docs/specification/2-0/swagger-extensions/
        """
    def __init__(
        self,
        *,
        title: builtins.str = ...,
        description: builtins.str = ...,
        terms_of_service: builtins.str = ...,
        contact: global___Contact | None = ...,
        license: global___License | None = ...,
        version: builtins.str = ...,
        extensions: collections.abc.Mapping[builtins.str, google.protobuf.struct_pb2.Value] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["contact", b"contact", "license", b"license"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["contact", b"contact", "description", b"description", "extensions", b"extensions", "license", b"license", "terms_of_service", b"terms_of_service", "title", b"title", "version", b"version"]) -> None: ...

global___Info = Info

class Contact(google.protobuf.message.Message):
    """`Contact` is a representation of OpenAPI v2 specification's Contact object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#contactObject

    Example:

     option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_swagger) = {
       info: {
         ...
         contact: {
           name: "gRPC-Gateway project";
           url: "https://github.com/grpc-ecosystem/grpc-gateway";
           email: "none@example.com";
         };
         ...
       };
       ...
     };
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The identifying name of the contact person/organization."""
    url: builtins.str
    """The URL pointing to the contact information. MUST be in the format of a
    URL.
    """
    email: builtins.str
    """The email address of the contact person/organization. MUST be in the format
    of an email address.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        url: builtins.str = ...,
        email: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["email", b"email", "name", b"name", "url", b"url"]) -> None: ...

global___Contact = Contact

class License(google.protobuf.message.Message):
    """`License` is a representation of OpenAPI v2 specification's License object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#licenseObject

    Example:

     option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_swagger) = {
       info: {
         ...
         license: {
           name: "BSD 3-Clause License";
           url: "https://github.com/grpc-ecosystem/grpc-gateway/blob/master/LICENSE.txt";
         };
         ...
       };
       ...
     };
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The license name used for the API."""
    url: builtins.str
    """A URL to the license used for the API. MUST be in the format of a URL."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "url", b"url"]) -> None: ...

global___License = License

class ExternalDocumentation(google.protobuf.message.Message):
    """`ExternalDocumentation` is a representation of OpenAPI v2 specification's
    ExternalDocumentation object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#externalDocumentationObject

    Example:

     option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_swagger) = {
       ...
       external_docs: {
         description: "More about gRPC-Gateway";
         url: "https://github.com/grpc-ecosystem/grpc-gateway";
       }
       ...
     };
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESCRIPTION_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    description: builtins.str
    """A short description of the target documentation. GFM syntax can be used for
    rich text representation.
    """
    url: builtins.str
    """The URL for the target documentation. Value MUST be in the format
    of a URL.
    """
    def __init__(
        self,
        *,
        description: builtins.str = ...,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "url", b"url"]) -> None: ...

global___ExternalDocumentation = ExternalDocumentation

class Schema(google.protobuf.message.Message):
    """`Schema` is a representation of OpenAPI v2 specification's Schema object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JSON_SCHEMA_FIELD_NUMBER: builtins.int
    DISCRIMINATOR_FIELD_NUMBER: builtins.int
    READ_ONLY_FIELD_NUMBER: builtins.int
    EXTERNAL_DOCS_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    @property
    def json_schema(self) -> global___JSONSchema: ...
    discriminator: builtins.str
    """Adds support for polymorphism. The discriminator is the schema property
    name that is used to differentiate between other schema that inherit this
    schema. The property name used MUST be defined at this schema and it MUST
    be in the required property list. When used, the value MUST be the name of
    this schema or any schema that inherits it.
    """
    read_only: builtins.bool
    """Relevant only for Schema "properties" definitions. Declares the property as
    "read only". This means that it MAY be sent as part of a response but MUST
    NOT be sent as part of the request. Properties marked as readOnly being
    true SHOULD NOT be in the required list of the defined schema. Default
    value is false.
    """
    @property
    def external_docs(self) -> global___ExternalDocumentation:
        """Additional external documentation for this schema."""
    example: builtins.str
    """A free-form property to include an example of an instance for this schema in JSON.
    This is copied verbatim to the output.
    """
    def __init__(
        self,
        *,
        json_schema: global___JSONSchema | None = ...,
        discriminator: builtins.str = ...,
        read_only: builtins.bool = ...,
        external_docs: global___ExternalDocumentation | None = ...,
        example: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["external_docs", b"external_docs", "json_schema", b"json_schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["discriminator", b"discriminator", "example", b"example", "external_docs", b"external_docs", "json_schema", b"json_schema", "read_only", b"read_only"]) -> None: ...

global___Schema = Schema

class JSONSchema(google.protobuf.message.Message):
    """`JSONSchema` represents properties from JSON Schema taken, and as used, in
    the OpenAPI v2 spec.

    This includes changes made by OpenAPI v2.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject

    See also: https://cswr.github.io/JsonSchema/spec/basic_types/,
    https://github.com/json-schema-org/json-schema-spec/blob/master/schema.json

    Example:

     message SimpleMessage {
       option (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_schema) = {
         json_schema: {
           title: "SimpleMessage"
           description: "A simple message."
           required: ["id"]
         }
       };

       // Id represents the message identifier.
       string id = 1; [
           (grpc.gateway.protoc_gen_openapiv2.options.openapiv2_field) = {
             description: "The unique identifier of the simple message."
           }];
     }
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _JSONSchemaSimpleTypes:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _JSONSchemaSimpleTypesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[JSONSchema._JSONSchemaSimpleTypes.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: JSONSchema._JSONSchemaSimpleTypes.ValueType  # 0
        ARRAY: JSONSchema._JSONSchemaSimpleTypes.ValueType  # 1
        BOOLEAN: JSONSchema._JSONSchemaSimpleTypes.ValueType  # 2
        INTEGER: JSONSchema._JSONSchemaSimpleTypes.ValueType  # 3
        NULL: JSONSchema._JSONSchemaSimpleTypes.ValueType  # 4
        NUMBER: JSONSchema._JSONSchemaSimpleTypes.ValueType  # 5
        OBJECT: JSONSchema._JSONSchemaSimpleTypes.ValueType  # 6
        STRING: JSONSchema._JSONSchemaSimpleTypes.ValueType  # 7

    class JSONSchemaSimpleTypes(_JSONSchemaSimpleTypes, metaclass=_JSONSchemaSimpleTypesEnumTypeWrapper): ...
    UNKNOWN: JSONSchema.JSONSchemaSimpleTypes.ValueType  # 0
    ARRAY: JSONSchema.JSONSchemaSimpleTypes.ValueType  # 1
    BOOLEAN: JSONSchema.JSONSchemaSimpleTypes.ValueType  # 2
    INTEGER: JSONSchema.JSONSchemaSimpleTypes.ValueType  # 3
    NULL: JSONSchema.JSONSchemaSimpleTypes.ValueType  # 4
    NUMBER: JSONSchema.JSONSchemaSimpleTypes.ValueType  # 5
    OBJECT: JSONSchema.JSONSchemaSimpleTypes.ValueType  # 6
    STRING: JSONSchema.JSONSchemaSimpleTypes.ValueType  # 7

    class FieldConfiguration(google.protobuf.message.Message):
        """'FieldConfiguration' provides additional field level properties used when generating the OpenAPI v2 file.
        These properties are not defined by OpenAPIv2, but they are used to control the generation.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PATH_PARAM_NAME_FIELD_NUMBER: builtins.int
        path_param_name: builtins.str
        """Alternative parameter name when used as path parameter. If set, this will
        be used as the complete parameter name when this field is used as a path
        parameter. Use this to avoid having auto generated path parameter names
        for overlapping paths.
        """
        def __init__(
            self,
            *,
            path_param_name: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["path_param_name", b"path_param_name"]) -> None: ...

    class ExtensionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.struct_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.struct_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    REF_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    DEFAULT_FIELD_NUMBER: builtins.int
    READ_ONLY_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    MULTIPLE_OF_FIELD_NUMBER: builtins.int
    MAXIMUM_FIELD_NUMBER: builtins.int
    EXCLUSIVE_MAXIMUM_FIELD_NUMBER: builtins.int
    MINIMUM_FIELD_NUMBER: builtins.int
    EXCLUSIVE_MINIMUM_FIELD_NUMBER: builtins.int
    MAX_LENGTH_FIELD_NUMBER: builtins.int
    MIN_LENGTH_FIELD_NUMBER: builtins.int
    PATTERN_FIELD_NUMBER: builtins.int
    MAX_ITEMS_FIELD_NUMBER: builtins.int
    MIN_ITEMS_FIELD_NUMBER: builtins.int
    UNIQUE_ITEMS_FIELD_NUMBER: builtins.int
    MAX_PROPERTIES_FIELD_NUMBER: builtins.int
    MIN_PROPERTIES_FIELD_NUMBER: builtins.int
    REQUIRED_FIELD_NUMBER: builtins.int
    ARRAY_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    ENUM_FIELD_NUMBER: builtins.int
    FIELD_CONFIGURATION_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    ref: builtins.str
    """Ref is used to define an external reference to include in the message.
    This could be a fully qualified proto message reference, and that type must
    be imported into the protofile. If no message is identified, the Ref will
    be used verbatim in the output.
    For example:
     `ref: ".google.protobuf.Timestamp"`.
    """
    title: builtins.str
    """The title of the schema."""
    description: builtins.str
    """A short description of the schema."""
    default: builtins.str
    read_only: builtins.bool
    example: builtins.str
    """A free-form property to include a JSON example of this field. This is copied
    verbatim to the output swagger.json. Quotes must be escaped.
    This property is the same for 2.0 and 3.0.0 https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/3.0.0.md#schemaObject  https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
    """
    multiple_of: builtins.float
    maximum: builtins.float
    """Maximum represents an inclusive upper limit for a numeric instance. The
    value of MUST be a number,
    """
    exclusive_maximum: builtins.bool
    minimum: builtins.float
    """minimum represents an inclusive lower limit for a numeric instance. The
    value of MUST be a number,
    """
    exclusive_minimum: builtins.bool
    max_length: builtins.int
    min_length: builtins.int
    pattern: builtins.str
    max_items: builtins.int
    min_items: builtins.int
    unique_items: builtins.bool
    max_properties: builtins.int
    min_properties: builtins.int
    @property
    def required(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def array(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Items in 'array' must be unique."""
    @property
    def type(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___JSONSchema.JSONSchemaSimpleTypes.ValueType]: ...
    format: builtins.str
    """`Format`"""
    @property
    def enum(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Items in `enum` must be unique https://tools.ietf.org/html/draft-fge-json-schema-validation-00#section-5.5.1"""
    @property
    def field_configuration(self) -> global___JSONSchema.FieldConfiguration:
        """Additional field level properties used when generating the OpenAPI v2 file."""
    @property
    def extensions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.struct_pb2.Value]:
        """Custom properties that start with "x-" such as "x-foo" used to describe
        extra functionality that is not covered by the standard OpenAPI Specification.
        See: https://swagger.io/docs/specification/2-0/swagger-extensions/
        """
    def __init__(
        self,
        *,
        ref: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        default: builtins.str = ...,
        read_only: builtins.bool = ...,
        example: builtins.str = ...,
        multiple_of: builtins.float = ...,
        maximum: builtins.float = ...,
        exclusive_maximum: builtins.bool = ...,
        minimum: builtins.float = ...,
        exclusive_minimum: builtins.bool = ...,
        max_length: builtins.int = ...,
        min_length: builtins.int = ...,
        pattern: builtins.str = ...,
        max_items: builtins.int = ...,
        min_items: builtins.int = ...,
        unique_items: builtins.bool = ...,
        max_properties: builtins.int = ...,
        min_properties: builtins.int = ...,
        required: collections.abc.Iterable[builtins.str] | None = ...,
        array: collections.abc.Iterable[builtins.str] | None = ...,
        type: collections.abc.Iterable[global___JSONSchema.JSONSchemaSimpleTypes.ValueType] | None = ...,
        format: builtins.str = ...,
        enum: collections.abc.Iterable[builtins.str] | None = ...,
        field_configuration: global___JSONSchema.FieldConfiguration | None = ...,
        extensions: collections.abc.Mapping[builtins.str, google.protobuf.struct_pb2.Value] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["field_configuration", b"field_configuration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["array", b"array", "default", b"default", "description", b"description", "enum", b"enum", "example", b"example", "exclusive_maximum", b"exclusive_maximum", "exclusive_minimum", b"exclusive_minimum", "extensions", b"extensions", "field_configuration", b"field_configuration", "format", b"format", "max_items", b"max_items", "max_length", b"max_length", "max_properties", b"max_properties", "maximum", b"maximum", "min_items", b"min_items", "min_length", b"min_length", "min_properties", b"min_properties", "minimum", b"minimum", "multiple_of", b"multiple_of", "pattern", b"pattern", "read_only", b"read_only", "ref", b"ref", "required", b"required", "title", b"title", "type", b"type", "unique_items", b"unique_items"]) -> None: ...

global___JSONSchema = JSONSchema

class Tag(google.protobuf.message.Message):
    """`Tag` is a representation of OpenAPI v2 specification's Tag object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#tagObject
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ExtensionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.struct_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.struct_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    EXTERNAL_DOCS_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the tag. Use it to allow override of the name of a
    global Tag object, then use that name to reference the tag throughout the
    OpenAPI file.
    """
    description: builtins.str
    """A short description for the tag. GFM syntax can be used for rich text
    representation.
    """
    @property
    def external_docs(self) -> global___ExternalDocumentation:
        """Additional external documentation for this tag."""
    @property
    def extensions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.struct_pb2.Value]:
        """Custom properties that start with "x-" such as "x-foo" used to describe
        extra functionality that is not covered by the standard OpenAPI Specification.
        See: https://swagger.io/docs/specification/2-0/swagger-extensions/
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        external_docs: global___ExternalDocumentation | None = ...,
        extensions: collections.abc.Mapping[builtins.str, google.protobuf.struct_pb2.Value] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["external_docs", b"external_docs"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "extensions", b"extensions", "external_docs", b"external_docs", "name", b"name"]) -> None: ...

global___Tag = Tag

class SecurityDefinitions(google.protobuf.message.Message):
    """`SecurityDefinitions` is a representation of OpenAPI v2 specification's
    Security Definitions object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securityDefinitionsObject

    A declaration of the security schemes available to be used in the
    specification. This does not enforce the security schemes on the operations
    and only serves to provide the relevant details for each scheme.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class SecurityEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___SecurityScheme: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___SecurityScheme | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SECURITY_FIELD_NUMBER: builtins.int
    @property
    def security(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___SecurityScheme]:
        """A single security scheme definition, mapping a "name" to the scheme it
        defines.
        """
    def __init__(
        self,
        *,
        security: collections.abc.Mapping[builtins.str, global___SecurityScheme] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["security", b"security"]) -> None: ...

global___SecurityDefinitions = SecurityDefinitions

class SecurityScheme(google.protobuf.message.Message):
    """`SecurityScheme` is a representation of OpenAPI v2 specification's
    Security Scheme object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securitySchemeObject

    Allows the definition of a security scheme that can be used by the
    operations. Supported schemes are basic authentication, an API key (either as
    a header or as a query parameter) and OAuth2's common flows (implicit,
    password, application and access code).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecurityScheme._Type.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_INVALID: SecurityScheme._Type.ValueType  # 0
        TYPE_BASIC: SecurityScheme._Type.ValueType  # 1
        TYPE_API_KEY: SecurityScheme._Type.ValueType  # 2
        TYPE_OAUTH2: SecurityScheme._Type.ValueType  # 3

    class Type(_Type, metaclass=_TypeEnumTypeWrapper):
        """The type of the security scheme. Valid values are "basic",
        "apiKey" or "oauth2".
        """

    TYPE_INVALID: SecurityScheme.Type.ValueType  # 0
    TYPE_BASIC: SecurityScheme.Type.ValueType  # 1
    TYPE_API_KEY: SecurityScheme.Type.ValueType  # 2
    TYPE_OAUTH2: SecurityScheme.Type.ValueType  # 3

    class _In:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _InEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecurityScheme._In.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        IN_INVALID: SecurityScheme._In.ValueType  # 0
        IN_QUERY: SecurityScheme._In.ValueType  # 1
        IN_HEADER: SecurityScheme._In.ValueType  # 2

    class In(_In, metaclass=_InEnumTypeWrapper):
        """The location of the API key. Valid values are "query" or "header"."""

    IN_INVALID: SecurityScheme.In.ValueType  # 0
    IN_QUERY: SecurityScheme.In.ValueType  # 1
    IN_HEADER: SecurityScheme.In.ValueType  # 2

    class _Flow:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _FlowEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecurityScheme._Flow.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        FLOW_INVALID: SecurityScheme._Flow.ValueType  # 0
        FLOW_IMPLICIT: SecurityScheme._Flow.ValueType  # 1
        FLOW_PASSWORD: SecurityScheme._Flow.ValueType  # 2
        FLOW_APPLICATION: SecurityScheme._Flow.ValueType  # 3
        FLOW_ACCESS_CODE: SecurityScheme._Flow.ValueType  # 4

    class Flow(_Flow, metaclass=_FlowEnumTypeWrapper):
        """The flow used by the OAuth2 security scheme. Valid values are
        "implicit", "password", "application" or "accessCode".
        """

    FLOW_INVALID: SecurityScheme.Flow.ValueType  # 0
    FLOW_IMPLICIT: SecurityScheme.Flow.ValueType  # 1
    FLOW_PASSWORD: SecurityScheme.Flow.ValueType  # 2
    FLOW_APPLICATION: SecurityScheme.Flow.ValueType  # 3
    FLOW_ACCESS_CODE: SecurityScheme.Flow.ValueType  # 4

    class ExtensionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.struct_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.struct_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TYPE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    FLOW_FIELD_NUMBER: builtins.int
    AUTHORIZATION_URL_FIELD_NUMBER: builtins.int
    TOKEN_URL_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    type: global___SecurityScheme.Type.ValueType
    """The type of the security scheme. Valid values are "basic",
    "apiKey" or "oauth2".
    """
    description: builtins.str
    """A short description for security scheme."""
    name: builtins.str
    """The name of the header or query parameter to be used.
    Valid for apiKey.
    """
    flow: global___SecurityScheme.Flow.ValueType
    """The flow used by the OAuth2 security scheme. Valid values are
    "implicit", "password", "application" or "accessCode".
    Valid for oauth2.
    """
    authorization_url: builtins.str
    """The authorization URL to be used for this flow. This SHOULD be in
    the form of a URL.
    Valid for oauth2/implicit and oauth2/accessCode.
    """
    token_url: builtins.str
    """The token URL to be used for this flow. This SHOULD be in the
    form of a URL.
    Valid for oauth2/password, oauth2/application and oauth2/accessCode.
    """
    @property
    def scopes(self) -> global___Scopes:
        """The available scopes for the OAuth2 security scheme.
        Valid for oauth2.
        """
    @property
    def extensions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.struct_pb2.Value]:
        """Custom properties that start with "x-" such as "x-foo" used to describe
        extra functionality that is not covered by the standard OpenAPI Specification.
        See: https://swagger.io/docs/specification/2-0/swagger-extensions/
        """
    def __init__(
        self,
        *,
        type: global___SecurityScheme.Type.ValueType = ...,
        description: builtins.str = ...,
        name: builtins.str = ...,
        flow: global___SecurityScheme.Flow.ValueType = ...,
        authorization_url: builtins.str = ...,
        token_url: builtins.str = ...,
        scopes: global___Scopes | None = ...,
        extensions: collections.abc.Mapping[builtins.str, google.protobuf.struct_pb2.Value] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["scopes", b"scopes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["authorization_url", b"authorization_url", "description", b"description", "extensions", b"extensions", "flow", b"flow", "in", b"in", "name", b"name", "scopes", b"scopes", "token_url", b"token_url", "type", b"type"]) -> None: ...

global___SecurityScheme = SecurityScheme

class SecurityRequirement(google.protobuf.message.Message):
    """`SecurityRequirement` is a representation of OpenAPI v2 specification's
    Security Requirement object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securityRequirementObject

    Lists the required security schemes to execute this operation. The object can
    have multiple security schemes declared in it which are all required (that
    is, there is a logical AND between the schemes).

    The name used for each property MUST correspond to a security scheme
    declared in the Security Definitions.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class SecurityRequirementValue(google.protobuf.message.Message):
        """If the security scheme is of type "oauth2", then the value is a list of
        scope names required for the execution. For other security scheme types,
        the array MUST be empty.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SCOPE_FIELD_NUMBER: builtins.int
        @property
        def scope(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            scope: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["scope", b"scope"]) -> None: ...

    class SecurityRequirementEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___SecurityRequirement.SecurityRequirementValue: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___SecurityRequirement.SecurityRequirementValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SECURITY_REQUIREMENT_FIELD_NUMBER: builtins.int
    @property
    def security_requirement(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___SecurityRequirement.SecurityRequirementValue]:
        """Each name must correspond to a security scheme which is declared in
        the Security Definitions. If the security scheme is of type "oauth2",
        then the value is a list of scope names required for the execution.
        For other security scheme types, the array MUST be empty.
        """
    def __init__(
        self,
        *,
        security_requirement: collections.abc.Mapping[builtins.str, global___SecurityRequirement.SecurityRequirementValue] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["security_requirement", b"security_requirement"]) -> None: ...

global___SecurityRequirement = SecurityRequirement

class Scopes(google.protobuf.message.Message):
    """`Scopes` is a representation of OpenAPI v2 specification's Scopes object.

    See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#scopesObject

    Lists the available scopes for an OAuth2 security scheme.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ScopeEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SCOPE_FIELD_NUMBER: builtins.int
    @property
    def scope(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Maps between a name of a scope to a short description of it (as the value
        of the property).
        """
    def __init__(
        self,
        *,
        scope: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["scope", b"scope"]) -> None: ...

global___Scopes = Scopes
