"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalTable = void 0;
const dynamodb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
const global_table_coordinator_1 = require("./global-table-coordinator");
/**
 * This class works by deploying an AWS DynamoDB table into each region specified in  GlobalTableProps.regions[],
 * then triggering a CloudFormation Custom Resource Lambda to link them all together to create linked AWS Global DynamoDB tables.
 *
 * @deprecated use `@aws-cdk/aws-dynamodb.Table.replicationRegions` instead
 */
class GlobalTable extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Creates dynamoDB tables across regions that will be able to be globbed together into a global table
         */
        this._regionalTables = new Array();
        this.node.addWarning('The @aws-cdk/aws-dynamodb-global module has been deprecated in favor of @aws-cdk/aws-dynamodb.Table.replicationRegions');
        this._regionalTables = [];
        if (props.stream != null && props.stream !== dynamodb.StreamViewType.NEW_AND_OLD_IMAGES) {
            throw new Error('dynamoProps.stream MUST be set to dynamodb.StreamViewType.NEW_AND_OLD_IMAGES');
        }
        // need to set this stream specification, otherwise global tables don't work
        // And no way to set a default value in an interface
        const regionalTableProps = {
            ...props,
            removalPolicy: props.removalPolicy,
            stream: dynamodb.StreamViewType.NEW_AND_OLD_IMAGES,
        };
        this.lambdaGlobalTableCoordinator = new global_table_coordinator_1.GlobalTableCoordinator(scope, id + '-CustomResource', props);
        const scopeStack = cdk.Stack.of(scope);
        // here we loop through the configured regions.
        // in each region we'll deploy a separate stack with a DynamoDB Table with identical properties in the individual stacks
        for (const region of props.regions) {
            const regionalStack = new cdk.Stack(this, id + '-' + region, { env: { region, account: scopeStack.account } });
            const regionalTable = new dynamodb.Table(regionalStack, `${id}-GlobalTable-${region}`, regionalTableProps);
            this._regionalTables.push(regionalTable);
            // deploy the regional stack before the Lambda coordinator stack
            this.lambdaGlobalTableCoordinator.addDependency(regionalStack);
        }
    }
    /**
     * Obtain tables deployed in other each region
     */
    get regionalTables() {
        return this._regionalTables.map(x => x);
    }
}
exports.GlobalTable = GlobalTable;
//# sourceMappingURL=data:application/json;base64,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