setup_py_template = """
import os
import sys
from pathlib import Path
from setuptools import setup, find_packages

{% if require_py3 %}
if sys.version_info.major != 3:
    raise RuntimeError("This package requires Python 3+")
{% endif %}

version = '{{ pkg_version }}'
pkg_name = '{{ pkg_name }}'
gitrepo = '{{ git_repo }}/{{ pkg_name }}'
root = Path(__file__).parent

requirements = [
    {%- for item in requirements %}
    '{{ item }}',
    {%- endfor %}
]

args = {
    'packages': find_packages(include = ['{{ lib_name }}', '{{ lib_name }}.*']),
    'install_requires': requirements,
    'long_description': root.joinpath('README.md').read_text(encoding='utf-8'),
    {%- if require_py3_version %}
    'python_requires': '>={{ require_py3_version }}',
    {%- endif %}
    {%- if kwargs %}
    {%- for key, value in kwargs|dictsort %}
    '{{ key }}': {{ value }},
    {%- endfor %}
    {%- endif %}
    {%- if include_pkg_files %}
    'include_package_data': True,
    {%- endif %}
    {%- if data_files %}
    {%- for key, value in data_files|dictsort %}
    '{{ key }}': {{ value }},
    {%- endfor %}
    {%- endif %}
    'entry_points': {
        {%- if cli_cmds %}
        'console_scripts': [
        {%- for item in cli_cmds %}
            '{{ item }}',
        {%- endfor %}
        ],
        {%- endif %}
        {%- if entry_points %}
        {%- for key, value in entry_points|dictsort %}
        '{{ key }}': {{ value }},
        {%- endfor %}
        {%- endif %}
    }
}

setup(
    name=pkg_name,
    version=version,
    url='https://github.com/{{ git_repo }}/{{ pkg_name }}',
    license='MIT Style',
    description='{{ description }}',
    author='{{ author }}',
    author_email='{{ email }}',
    long_description_content_type="text/markdown",
    classifiers=[
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: {% if require_py3_version %}{{ require_py3_version }}{% endif %}',
        'Topic :: Software Development :: Libraries',
    ],
    **args
)
"""

install_requirements_template = """
{%- for item in requirements %}
{{ item }}
{%- endfor %}
"""

gitignores_template = """
{%- for item in gitignore %}
{{ item }}
{%- endfor %}
"""

pyinit_template = """
{%- for item in modules %}
from . import {{ item }}
{%- endfor %}
"""

readme_template = """
# {{ pkg_name }}
 {{ description }}

{%- if readme_text %}
---
{{ readme_text }}
{%- endif %}

---
## Quickstart

```bash
# From pypi
pip install --upgrade {{ pkg_name }}

# From source
pip install --upgrade git+https://github.com/{{ git_repo }}/{{ pkg_name }}
```

## Usage

```python
import {{ lib_name }}

## Do something here

```

---

## Libraries & Dependencies

{%- if require_py3_version %}
- `Python {{ require_py3_version }}`
{%- endif %}
{%- for item in requirements %}
- `{{ item }}'`
{% endfor %}

---

This Python Library has been autogenerated with [pylibup](https://github.com/trisongz/pylibup).

"""

build_sh_template = """
#!/bin/bash

## Autogenerated from Pylibup

MODE=$1

if [[ "$MODE" == "prod" || "$MODE" == "dist" ]]; then
    UPLOAD="dist"
else
    UPLOAD="test"
fi

rm -r dist/*
rm -r build/*

python setup.py sdist bdist_wheel

if [[ "$UPLOAD" == "dist "]]; then
    echo "Uploading to Dist Pypi"
    python -m twine upload --repository pypi dist/*
else
    echo "Uploading to Test Pypi"
    python -m twine upload --repository testpypi dist/*
fi
"""


github_action_template = """
## Autogenerated from Pylibup

name: Upload Python Package
on:
  push:
    paths:
      - 'setup.py'
  release:
    types: [created]
jobs:
  deploy:
    runs-on: ubuntu-latest
    steps:
    - uses: actions/checkout@v2
    - name: Set up Python
      uses: actions/setup-python@v2
      with:
        python-version: '3.x'
    - name: Install dependencies
      run: |
        python -m pip install --upgrade pip
        pip install build
    - name: Build package
      run: python -m build
    - name: Publish package
      uses: pypa/gh-action-pypi-publish@release/v1
      with:
        user: __token__
        password: ${{ secrets.PYPI_API_TOKEN }}
"""



github_action_template_pypi_publish = """
## Autogenerated from Pylibup

name: Upload Python Package
on:
  push:
    paths:
      - 'setup.py'
  release:
    types: [created]
jobs:
  deploy:
    runs-on: ubuntu-latest
    steps:
    - uses: actions/checkout@v2
    - name: Set up Python
      uses: actions/setup-python@v2
      with:
        python-version: '3.x'
    - name: Install dependencies
      run: |
        python -m pip install --upgrade pip
        pip install build
    - name: Build package
      run: python -m build
    - name: Publish package
      uses: pypa/gh-action-pypi-publish@release/v1
      with:
        user: __token__
        password: ${{ secrets.PYPI_API_TOKEN }}
"""

github_action_template_docker_build = """
## Autogenerated from Pylibup

name: Build {{ app_name }} Docker Image
on:
  push:
    paths:
      - 'app/**/**'
      - '{{ lib_name }}/**'
      - 'Dockerfile'
      - 'requirements.txt'
      - '.github/workflows/docker-build.yaml'

env:
  {%- if require_ecr %}
  IMG_REPO: {{ ecr_options.repo }}
  {% else %}
  IMG_REPO: {{ docker_options.repo }}
  {%- endif %}

jobs:
  build-latest-docker-image:
    runs-on: ubuntu-latest
    permissions:
      contents: read
      packages: write
    steps:
      - name: Checkout repository
        uses: actions/checkout@v2

      - name: Set up Docker Buildx
        id: buildx
        uses: docker/setup-buildx-action@v1
      {%- if require_ecr %}
      - name: Configure AWS credentials
        uses: aws-actions/configure-aws-credentials@v1
        with:
          aws-access-key-id: ${{ secrets.AWS_ACCESS_KEY_ID }}
          aws-secret-access-key: ${{ secrets.AWS_SECRET_ACCESS_KEY }}
          aws-region: ${{ secrets.AWS_REGION }}

      - name: Login to Amazon ECR
        id: login-ecr
        uses: aws-actions/amazon-ecr-login@v1
      
      - name: Create ECR Repo if not Exists
        uses: int128/create-ecr-repository-action@v1
        id: ecr
        with:
          repository: ${{ env.IMG_REPO }}
      - name: Build and Push Docker Image: {{ app_name }}
        uses: docker/build-push-action@v2
        with:
          file: Dockerfile
          platforms: linux/amd64
          push: true
          tags: |
            ${{ steps.ecr.outputs.repository-uri }}:latest
          cache-from: type=gha
          cache-to: type=gha,mode=max
      {% else %}
      - name: Build and Push Docker Image: {{ app_name }}
        uses: docker/build-push-action@v2
        with:
          file: Dockerfile
          platforms: linux/amd64
          push: true
          tags: |
            ${{ env.IMG_REPO }}:latest
          cache-from: type=gha
          cache-to: type=gha,mode=max
      {%- endif %}
"""

dockerfile_fastapi_template = """
## Autogenerated from Pylibup

FROM tiangolo/uvicorn-gunicorn-fastapi:python3.9

COPY ./requirements.txt /app/requirements.txt

RUN pip install --no-cache-dir --upgrade -r /app/requirements.txt

COPY ./app /app

WORKDIR /app

ENV PYTHONPATH=/app:$PYTHONPATH
"""


pylib_metadata_template = """
# Autogenerated by Pylib

{%- if setup %}
setup:
  {%- for key, value in setup %}
  {{ key }}: {{ value }}
  {%- endfor %}
{%- endif %}

{%- if repo %}
repo: {{ repo }}
{%- endif %}

{%- if readme_text %}
readme_text: {{ readme_text }}
{%- endif %}

{%- if project_description %}
project_description: {{ project_description }}
{%- endif %}

{%- if gitignores %}
gitignores: 
  {%- for item in gitignores %}
  - '{{ item }}'
  {%- endfor %}
{%- endif %}

{%- if structure %}
structure:
  {%- if structure.modules %}
  modules:
  {%- for item in structure.modules %}
  - {{ item }}
  {%- endfor %}
  {%- endif %}

{%- endif %}
{%- if secrets %}
secrets:
  {%- for key, value in secrets %}
  {{ key }}: {{ value }}
  {%- endfor %}
{%- endif %}
{%- if options %}
options:
  {%- for key, value in options|dictsort %}
  {{ key }}: {{ value }}
  {%- endfor %}
{%- endif %}
{%- if workflows %}
workflows:
  {%- for key, value in workflows %}
  {{ key }}: {{ value }}
  {%- endfor %}
{%- endif %}

"""

default_metadata_setup = {
  'author': 'Tri Songz',
  'email': '',
  'git_repo': '',
  'pkg_version': '0.0.0a',
  'pkg_name': 'pylibup',
  'lib_name': 'pylibup',
  'require_py3': True,
  'require_py3_version': 3.7,
  'requirements': ['lazycls', 'pylogz'],
  'kwargs': {},
  'cli_cmds': [],
}

default_metadata_gitignores = [
  'cache*',
  '*.DS_Store',
  'tests*',
  '__pycache__*',
  '*logs',
  '*dist',
  '*build',
  '**build.sh',
  '*test.py',
  '*.egg-info*',
  '*.vscode',
  '**.ipynb',
  '**meta.yaml',
  '**metadata.yaml',
  '**state.yaml'
]

default_metadata_modules = [
  'classes',
  'client',
  'config',
  'utils',
]

default_metadata_secrets = {
  'AWS_ACCESS_KEY_ID': {'from': 'AWS_ACCESS_KEY_ID_SVC_ACCOUNT'},
  'AWS_SECRET_ACCESS_KEY': {'from': 'AWS_SECRET_ACCESS_KEY_SVC_ACCOUNT'},
  'AWS_REGION': 'us-east-1',
}
default_metadata_options = {
  'default_branch': 'main',
  'include_init': True,
  'include_app': True,
  'include_dockerfile': True,
  'include_buildscript': True,
  'include_reqtext': True,
  'private': True,
}

default_metadata_dockerbuild_options = {
  'app_name':'',
  'require_ecr': True,
  'ecr_options': {
    'img_repo': ''
  },
  'docker_options':{
    'img_repo': ''
  }
}

default_metadata_workflows = {
  'pypi_publish': True,
  'docker_build': False,
  'docker_build_options': default_metadata_dockerbuild_options
}

default_pylib_metadata = {
  'setup': default_metadata_setup,
  'repo': '',
  'readme_text': '',
  'project_description': '',
  'gitignores': default_metadata_gitignores,
  'structure': {'modules': default_metadata_modules},
  'secrets': default_metadata_secrets,
  'options': default_metadata_options,
  'workflows': default_metadata_workflows
}

