# coding: utf-8

"""
    Blog Post endpoints

    \"Use these endpoints for interacting with Blog Posts, Blog Authors, and Blog Tags\"  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.cms.blogs.authors.configuration import Configuration


class BlogAuthor(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "id": "str",
        "email": "str",
        "display_name": "str",
        "bio": "str",
        "website": "str",
        "twitter": "str",
        "facebook": "str",
        "linkedin": "str",
        "avatar": "str",
        "deleted_at": "datetime",
        "created_at": "datetime",
        "updated_at": "datetime",
    }

    attribute_map = {
        "id": "id",
        "email": "email",
        "display_name": "displayName",
        "bio": "bio",
        "website": "website",
        "twitter": "twitter",
        "facebook": "facebook",
        "linkedin": "linkedin",
        "avatar": "avatar",
        "deleted_at": "deletedAt",
        "created_at": "createdAt",
        "updated_at": "updatedAt",
    }

    def __init__(
        self,
        id=None,
        email=None,
        display_name=None,
        bio=None,
        website=None,
        twitter=None,
        facebook=None,
        linkedin=None,
        avatar=None,
        deleted_at=None,
        created_at=None,
        updated_at=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """BlogAuthor - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._email = None
        self._display_name = None
        self._bio = None
        self._website = None
        self._twitter = None
        self._facebook = None
        self._linkedin = None
        self._avatar = None
        self._deleted_at = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        self.id = id
        self.email = email
        self.display_name = display_name
        self.bio = bio
        self.website = website
        self.twitter = twitter
        self.facebook = facebook
        self.linkedin = linkedin
        self.avatar = avatar
        self.deleted_at = deleted_at
        self.created_at = created_at
        self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this BlogAuthor.  # noqa: E501

        The unique ID of the Blog Author.  # noqa: E501

        :return: The id of this BlogAuthor.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BlogAuthor.

        The unique ID of the Blog Author.  # noqa: E501

        :param id: The id of this BlogAuthor.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and id is None
        ):  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def email(self):
        """Gets the email of this BlogAuthor.  # noqa: E501

        Email address of the Blog Author.  # noqa: E501

        :return: The email of this BlogAuthor.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this BlogAuthor.

        Email address of the Blog Author.  # noqa: E501

        :param email: The email of this BlogAuthor.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and email is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `email`, must not be `None`"
            )  # noqa: E501

        self._email = email

    @property
    def display_name(self):
        """Gets the display_name of this BlogAuthor.  # noqa: E501

        The full name of the Blog Author to be displayed.  # noqa: E501

        :return: The display_name of this BlogAuthor.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this BlogAuthor.

        The full name of the Blog Author to be displayed.  # noqa: E501

        :param display_name: The display_name of this BlogAuthor.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and display_name is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `display_name`, must not be `None`"
            )  # noqa: E501

        self._display_name = display_name

    @property
    def bio(self):
        """Gets the bio of this BlogAuthor.  # noqa: E501

        A short biography of the blog author.  # noqa: E501

        :return: The bio of this BlogAuthor.  # noqa: E501
        :rtype: str
        """
        return self._bio

    @bio.setter
    def bio(self, bio):
        """Sets the bio of this BlogAuthor.

        A short biography of the blog author.  # noqa: E501

        :param bio: The bio of this BlogAuthor.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and bio is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `bio`, must not be `None`"
            )  # noqa: E501

        self._bio = bio

    @property
    def website(self):
        """Gets the website of this BlogAuthor.  # noqa: E501

        URL to the website of the Blog Author.  # noqa: E501

        :return: The website of this BlogAuthor.  # noqa: E501
        :rtype: str
        """
        return self._website

    @website.setter
    def website(self, website):
        """Sets the website of this BlogAuthor.

        URL to the website of the Blog Author.  # noqa: E501

        :param website: The website of this BlogAuthor.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and website is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `website`, must not be `None`"
            )  # noqa: E501

        self._website = website

    @property
    def twitter(self):
        """Gets the twitter of this BlogAuthor.  # noqa: E501

        URL or username of the Twitter account associated with the Blog Author. This will be normalized into the Twitter url for said user.  # noqa: E501

        :return: The twitter of this BlogAuthor.  # noqa: E501
        :rtype: str
        """
        return self._twitter

    @twitter.setter
    def twitter(self, twitter):
        """Sets the twitter of this BlogAuthor.

        URL or username of the Twitter account associated with the Blog Author. This will be normalized into the Twitter url for said user.  # noqa: E501

        :param twitter: The twitter of this BlogAuthor.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and twitter is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `twitter`, must not be `None`"
            )  # noqa: E501

        self._twitter = twitter

    @property
    def facebook(self):
        """Gets the facebook of this BlogAuthor.  # noqa: E501

        URL to the Blog Author's Facebook page.  # noqa: E501

        :return: The facebook of this BlogAuthor.  # noqa: E501
        :rtype: str
        """
        return self._facebook

    @facebook.setter
    def facebook(self, facebook):
        """Sets the facebook of this BlogAuthor.

        URL to the Blog Author's Facebook page.  # noqa: E501

        :param facebook: The facebook of this BlogAuthor.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and facebook is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `facebook`, must not be `None`"
            )  # noqa: E501

        self._facebook = facebook

    @property
    def linkedin(self):
        """Gets the linkedin of this BlogAuthor.  # noqa: E501

        URL to the blog author's LinkedIn page.  # noqa: E501

        :return: The linkedin of this BlogAuthor.  # noqa: E501
        :rtype: str
        """
        return self._linkedin

    @linkedin.setter
    def linkedin(self, linkedin):
        """Sets the linkedin of this BlogAuthor.

        URL to the blog author's LinkedIn page.  # noqa: E501

        :param linkedin: The linkedin of this BlogAuthor.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and linkedin is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `linkedin`, must not be `None`"
            )  # noqa: E501

        self._linkedin = linkedin

    @property
    def avatar(self):
        """Gets the avatar of this BlogAuthor.  # noqa: E501

        URL to the blog author's avatar, if supplying a custom one.  # noqa: E501

        :return: The avatar of this BlogAuthor.  # noqa: E501
        :rtype: str
        """
        return self._avatar

    @avatar.setter
    def avatar(self, avatar):
        """Sets the avatar of this BlogAuthor.

        URL to the blog author's avatar, if supplying a custom one.  # noqa: E501

        :param avatar: The avatar of this BlogAuthor.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and avatar is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `avatar`, must not be `None`"
            )  # noqa: E501

        self._avatar = avatar

    @property
    def deleted_at(self):
        """Gets the deleted_at of this BlogAuthor.  # noqa: E501

        The timestamp (ISO8601 format) when this Blog Author was deleted.  # noqa: E501

        :return: The deleted_at of this BlogAuthor.  # noqa: E501
        :rtype: datetime
        """
        return self._deleted_at

    @deleted_at.setter
    def deleted_at(self, deleted_at):
        """Sets the deleted_at of this BlogAuthor.

        The timestamp (ISO8601 format) when this Blog Author was deleted.  # noqa: E501

        :param deleted_at: The deleted_at of this BlogAuthor.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and deleted_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `deleted_at`, must not be `None`"
            )  # noqa: E501

        self._deleted_at = deleted_at

    @property
    def created_at(self):
        """Gets the created_at of this BlogAuthor.  # noqa: E501

        The timestamp (ISO8601 format) when this Blog Author was created.  # noqa: E501

        :return: The created_at of this BlogAuthor.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this BlogAuthor.

        The timestamp (ISO8601 format) when this Blog Author was created.  # noqa: E501

        :param created_at: The created_at of this BlogAuthor.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and created_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `created_at`, must not be `None`"
            )  # noqa: E501

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this BlogAuthor.  # noqa: E501

        The timestamp (ISO8601 format) when this Blog Author was last updated.  # noqa: E501

        :return: The updated_at of this BlogAuthor.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this BlogAuthor.

        The timestamp (ISO8601 format) when this Blog Author was last updated.  # noqa: E501

        :param updated_at: The updated_at of this BlogAuthor.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and updated_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `updated_at`, must not be `None`"
            )  # noqa: E501

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BlogAuthor):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BlogAuthor):
            return True

        return self.to_dict() != other.to_dict()
