# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['codeformer',
 'codeformer.facelib.detection',
 'codeformer.facelib.detection.retinaface',
 'codeformer.facelib.detection.yolov5face',
 'codeformer.facelib.detection.yolov5face.models',
 'codeformer.facelib.detection.yolov5face.utils',
 'codeformer.facelib.parsing',
 'codeformer.facelib.utils']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=9.2.0,<10.0.0',
 'PyYAML>=6.0,<7.0',
 'addict>=2.4.0,<3.0.0',
 'basicsr>=1.4.2,<2.0.0',
 'future>=0.18.2,<0.19.0',
 'gdown>=4.5.1,<5.0.0',
 'lmdb>=1.3.0,<2.0.0',
 'lpips>=0.1.4,<0.2.0',
 'numpy>=1.23.4,<2.0.0',
 'opencv-python>=4.6.0.66,<5.0.0.0',
 'requests>=2.28.1,<3.0.0',
 'scikit-image>=0.19.3,<0.20.0',
 'scipy>=1.9.2,<2.0.0',
 'tb-nightly>=2.11.0a20221016,<3.0.0',
 'torch>=1.11.0,<2.0.0',
 'torchvision<1.0.0',
 'tqdm>=4.64.1,<5.0.0',
 'wget>=3.2,<4.0',
 'yapf>=0.32.0,<0.33.0']

setup_kwargs = {
    'name': 'codeformer-perceptor',
    'version': '0.1.0',
    'description': 'Towards Robust Blind Face Restoration with Codebook Lookup Transformer (NeurIPS 2022)',
    'long_description': '<p align="center">\n  <img src="assets/CodeFormer_logo.png" height=110>\n</p>\n\n## Towards Robust Blind Face Restoration with Codebook Lookup Transformer (NeurIPS 2022)\n\n[Paper](https://arxiv.org/abs/2206.11253) | [Project Page](https://shangchenzhou.com/projects/CodeFormer/) | [Video](https://youtu.be/d3VDpkXlueI)\n\n<a href="https://colab.research.google.com/drive/1m52PNveE4PBhYrecj34cnpEeiHcC5LTb?usp=sharing"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="google colab logo"></a> [![Hugging Face](https://img.shields.io/badge/Demo-%F0%9F%A4%97%20Hugging%20Face-blue)](https://huggingface.co/spaces/sczhou/CodeFormer) [![Replicate](https://img.shields.io/badge/Demo-%F0%9F%9A%80%20Replicate-blue)](https://replicate.com/sczhou/codeformer) ![visitors](https://visitor-badge.laobi.icu/badge?page_id=sczhou/CodeFormer)\n\n<!-- ![visitors](https://visitor-badge.glitch.me/badge?page_id=sczhou/CodeFormer) -->\n\n[Shangchen Zhou](https://shangchenzhou.com/), [Kelvin C.K. Chan](https://ckkelvinchan.github.io/), [Chongyi Li](https://li-chongyi.github.io/), [Chen Change Loy](https://www.mmlab-ntu.com/person/ccloy/)\n\nS-Lab, Nanyang Technological University\n\n<img src="assets/network.jpg" width="800px"/>\n\n:star: If CodeFormer is helpful to your images or projects, please help star this repo. Thanks! :hugs:\n\n## Install\n\n```bash\npoetry add codeformer-perceptor\n```\n\nor\n\n```bash\npip install codeformer-perceptor\n```\n\n## Usage\n\n```python\nfrom PIL import Image\nfrom codeformer import CodeFormer\n\nmodel = CodeFormer().cuda()\n\nimage = Image.open("test.jpg")\nrestored_image = model(image)\n```\n\n**[<font color=#d1585d>News</font>]**: :whale: _Due to copyright issues, we have to delay the release of the training code (expected by the end of this year). Please star and stay tuned for our future updates!_\n\n### Update\n\n- **2022.10.05**: Support video input `--input_path [YOUR_VIDOE.mp4]`. Try it to enhance your videos! :clapper:\n- **2022.09.14**: Integrated to :hugs: [Hugging Face](https://huggingface.co/spaces). Try out online demo! [![Hugging Face](https://img.shields.io/badge/Demo-%F0%9F%A4%97%20Hugging%20Face-blue)](https://huggingface.co/spaces/sczhou/CodeFormer)\n- **2022.09.09**: Integrated to :rocket: [Replicate](https://replicate.com/explore). Try out online demo! [![Replicate](https://img.shields.io/badge/Demo-%F0%9F%9A%80%20Replicate-blue)](https://replicate.com/sczhou/codeformer)\n- **2022.09.04**: Add face upsampling `--face_upsample` for high-resolution AI-created face enhancement.\n- **2022.08.23**: Some modifications on face detection and fusion for better AI-created face enhancement.\n- **2022.08.07**: Integrate [Real-ESRGAN](https://github.com/xinntao/Real-ESRGAN) to support background image enhancement.\n- **2022.07.29**: Integrate new face detectors of `[\'RetinaFace\'(default), \'YOLOv5\']`.\n- **2022.07.17**: Add Colab demo of CodeFormer. <a href="https://colab.research.google.com/drive/1m52PNveE4PBhYrecj34cnpEeiHcC5LTb?usp=sharing"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="google colab logo"></a>\n- **2022.07.16**: Release inference code for face restoration. :blush:\n- **2022.06.21**: This repo is created.\n\n### TODO\n\n- [ ] Add checkpoint for face inpainting\n- [ ] Add checkpoint for face colorization\n- [ ] Add training code and config files\n- [x] ~~Add background image enhancement~~\n\n#### :panda_face: Try Enhancing Old Photos / Fixing AI-arts\n\n[<img src="assets/imgsli_1.jpg" height="226px"/>](https://imgsli.com/MTI3NTE2) [<img src="assets/imgsli_2.jpg" height="226px"/>](https://imgsli.com/MTI3NTE1) [<img src="assets/imgsli_3.jpg" height="226px"/>](https://imgsli.com/MTI3NTIw)\n\n#### Face Restoration\n\n<img src="assets/restoration_result1.png" width="400px"/> <img src="assets/restoration_result2.png" width="400px"/>\n<img src="assets/restoration_result3.png" width="400px"/> <img src="assets/restoration_result4.png" width="400px"/>\n\n#### Face Color Enhancement and Restoration\n\n<img src="assets/color_enhancement_result1.png" width="400px"/> <img src="assets/color_enhancement_result2.png" width="400px"/>\n\n#### Face Inpainting\n\n<img src="assets/inpainting_result1.png" width="400px"/> <img src="assets/inpainting_result2.png" width="400px"/>\n\n### Dependencies and Installation\n\n- Pytorch >= 1.7.1\n- CUDA >= 10.1\n- Other required packages in `requirements.txt`\n\n```\n# git clone this repository\ngit clone https://github.com/sczhou/CodeFormer\ncd CodeFormer\n\n# create new anaconda env\nconda create -n codeformer python=3.8 -y\nconda activate codeformer\n\n# install python dependencies\npip3 install -r requirements.txt\npython basicsr/setup.py develop\n```\n\n<!-- conda install -c conda-forge dlib -->\n\n### Quick Inference\n\n#### Download Pre-trained Models:\n\nDownload the facelib pretrained models from [[Google Drive](https://drive.google.com/drive/folders/1b_3qwrzY_kTQh0-SnBoGBgOrJ_PLZSKm?usp=sharing) | [OneDrive](https://entuedu-my.sharepoint.com/:f:/g/personal/s200094_e_ntu_edu_sg/EvDxR7FcAbZMp_MA9ouq7aQB8XTppMb3-T0uGZ_2anI2mg?e=DXsJFo)] to the `weights/facelib` folder. You can manually download the pretrained models OR download by runing the following command.\n\n```\npython scripts/download_pretrained_models.py facelib\n```\n\nDownload the CodeFormer pretrained models from [[Google Drive](https://drive.google.com/drive/folders/1CNNByjHDFt0b95q54yMVp6Ifo5iuU6QS?usp=sharing) | [OneDrive](https://entuedu-my.sharepoint.com/:f:/g/personal/s200094_e_ntu_edu_sg/EoKFj4wo8cdIn2-TY2IV6CYBhZ0pIG4kUOeHdPR_A5nlbg?e=AO8UN9)] to the `weights/CodeFormer` folder. You can manually download the pretrained models OR download by runing the following command.\n\n```\npython scripts/download_pretrained_models.py CodeFormer\n```\n\n#### Prepare Testing Data:\n\nYou can put the testing images in the `inputs/TestWhole` folder. If you would like to test on cropped and aligned faces, you can put them in the `inputs/cropped_faces` folder.\n\n#### Testing on Face Restoration:\n\n[Note] If you want to compare CodeFormer in your paper, please run the following command indicating `--has_aligned` (for cropped and aligned face), as the command for the whole image will involve a process of face-background fusion that may damage hair texture on the boundary, which leads to unfair comparison.\n\n🧑🏻 Face Restoration (cropped and aligned face)\n\n```\n# For cropped and aligned faces\npython inference_codeformer.py -w 0.5 --has_aligned --input_path [input folder]\n```\n\n:framed_picture: Whole Image Enhancement\n\n```\n# For whole image\n# Add \'--bg_upsampler realesrgan\' to enhance the background regions with Real-ESRGAN\n# Add \'--face_upsample\' to further upsample restorated face with Real-ESRGAN\npython inference_codeformer.py -w 0.7 --input_path [image folder/image path]\n```\n\n:clapper: Video Enhancement\n\n```\n# For video clips\n# Set frame rate of saved video via \'--save_video_fps 24\'\npython inference_codeformer.py --bg_upsampler realesrgan --face_upsample -w 1.0 --input_path [video path] --save_video_fps 24\n```\n\nFidelity weight _w_ lays in [0, 1]. Generally, smaller _w_ tends to produce a higher-quality result, while larger _w_ yields a higher-fidelity result.\n\nThe results will be saved in the `results` folder.\n\n### Citation\n\nIf our work is useful for your research, please consider citing:\n\n    @inproceedings{zhou2022codeformer,\n        author = {Zhou, Shangchen and Chan, Kelvin C.K. and Li, Chongyi and Loy, Chen Change},\n        title = {Towards Robust Blind Face Restoration with Codebook Lookup TransFormer},\n        booktitle = {NeurIPS},\n        year = {2022}\n    }\n\n### License\n\nThis project is licensed under <a rel="license" href="https://github.com/sczhou/CodeFormer/blob/master/LICENSE">S-Lab License 1.0</a>. Redistribution and use for non-commercial purposes should follow this license.\n\n### Acknowledgement\n\nThis project is based on [BasicSR](https://github.com/XPixelGroup/BasicSR). Some codes are brought from [Unleashing Transformers](https://github.com/samb-t/unleashing-transformers), [YOLOv5-face](https://github.com/deepcam-cn/yolov5-face), and [FaceXLib](https://github.com/xinntao/facexlib). We also adopt [Real-ESRGAN](https://github.com/xinntao/Real-ESRGAN) to support background image enhancement. Thanks for their awesome works.\n\n### Contact\n\nIf you have any question, please feel free to reach me out at `shangchenzhou@gmail.com`.\n',
    'author': 'Shangchen Zhou, Kelvin C.K. Chan, Chongyi Li, Chen Change Loy',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
