# -*- coding: utf-8 -*-

from sklearn_export.estimator.regressor.Regressor import Regressor


class SVR(Regressor):
    """
    See also
    --------
    sklearn.svm.SVR

    """

    # @formatter:on

    def __init__(self, estimator, **kwargs):
        """
        Port a trained estimator to a dict.

        Parameters
        ----------
        :param estimator : SVR
            An instance of a trained SVC estimator.
        """
        super(SVR, self).__init__(estimator, **kwargs)

        self.estimator = estimator

        est = self.estimator

        self.n_features = len(est.support_vectors_[0])
        self.svs_rows = est.n_support_
        self.n_svs_rows = len(est.n_support_)
        self.params = est.get_params()

        # Kernel:
        self.kernel = str(self.params['kernel'])

        # Gamma:
        #self.gamma = self.params['gamma']
        #if self.gamma == 'auto':
            #self.gamma = 1. / self.n_features
        #self.gamma = self.repr(self.gamma)
        self.gamma = self.repr(est._gamma)

        # Coefficient and degree:
        self.coef0 = self.repr(self.params['coef0'])
        self.degree = self.repr(self.params['degree'])

    def load_model_data(self, model_data=None):

        if model_data is None:
            model_data = {}

        vectors = self.estimator.support_vectors_.flatten('F')
        coefficients = self.estimator.dual_coef_.flatten('F')

        model_data['vectors'] = vectors.tolist()
        model_data['coefficients'] = coefficients.tolist()
        model_data['intercepts'] = self.estimator.intercept_.tolist()
        model_data['type'] = 'SVR'
        model_data['kernel'] = self.kernel
        model_data['gamma'] = float(self.gamma)
        model_data['coef0'] = float(self.coef0)
        model_data['degree'] = float(self.degree)
        model_data['numRowsV'] = self.estimator.support_vectors_.shape[0]
        model_data['numColumnsV'] = self.estimator.support_vectors_.shape[1]
        model_data['numRowsC'] = self.estimator.dual_coef_.shape[0]
        model_data['numColumnsC'] = self.estimator.dual_coef_.shape[1]

        return model_data