"""
File in charge of containing the rest of the Window Tools class that could not be placed by action type
"""

import os
import string
import random
import tkinter as tk
from PIL import ImageTk, Image


class Unsorted:
    """ Class in the charge of containing the functions that could not be placed by action """
    def gen_random_name(self, length: int = 10) -> str:
        """ Generate a random name """
        result = ""
        while length > 0:
            result += random.choice(string.ascii_letters)
            length -= 1
        return result

    def init_plain_window(self, root_window: tk.Tk = "") -> tk.Tk:
        """ Returns the basics of a window """
        my_window = root_window
        if isinstance(root_window, (tk.Tk, tk.Toplevel)):
            my_window = tk.Toplevel(
                root_window,
            )
        elif root_window == None:
            my_window = tk.Toplevel()
        else:
            my_window = tk.Tk()
        return my_window

    def init_window(self, window: tk.Tk, title: str, bkg: str, width: int, height: int, position_x: int, position_y: int, fullscreen: bool, resizable: bool) -> None:
        """ initialise the window for the main_menu """
        maximum = 200
        window.geometry(f"{width}x{height}+{position_x}+{position_y}")
        window.minsize(width=width, height=height)
        if (fullscreen == False):
            window.maxsize(width=width+maximum, height=height + maximum)
        window.title(title)
        window['bg'] = bkg
        window.attributes('-fullscreen', fullscreen)
        if resizable == False:
            window.resizable(False, False)
        else:
            window.resizable(True, True)

    def load_image(self, image_path: str, width: int = 10, height: int = 10) -> dict[str, any]:
        """ Add an image to a window """
        result = {}
        if (os.path.exists(image_path) is False) or (os.path.isfile(image_path) is False):
            err_msg = "Image path is not valid or not provided"
            result["err_message"] = err_msg
            return result
        if height <= 0 and width <= 0:
            err_msg = "Image width and heigh must be greater than 0"
            result["err_message"] = err_msg
            return result
        try:
            result["img"] = Image.open(image_path)
            if not hasattr(Image, 'Resampling'):  # Pillow<9.0
                Image.Resampling = Image
            result["img"] = result["img"].resize(
                (width, height),
                Image.Resampling.LANCZOS
            )
            result["img"] = ImageTk.PhotoImage(result["img"])
        except Exception as error:
            result["err_message"] = error
            return result
        return result

    def create_text_variable(self, default_text: str) -> tk.StringVar:
        """ create a text variable in order to store inputed and outputed text """
        value = tk.StringVar()
        value.set(default_text)

        return value

    def clear_entry_content(self, entry: tk.Entry) -> None:
        """ Clear all text currently present in the entry field """
        entry.delete(0, tk.END)

    def update_entry_content(self, entry: tk.Entry, position: int, new_text: str) -> None:
        """ update the content of an entry field """
        entry.insert(position, new_text)

    def enter_fullscreen(self, window: tk.Tk, fullscreen: bool) -> None:
        """ enter or exit the fullscreen """
        window.attributes('-fullscreen', fullscreen)

    def allow_resizing(self, window: tk.Tk, allow: bool = True) -> None:
        """ Allow the window to be resized """
        if allow == False:
            window.resizable(False, False)
        else:
            window.resizable(True, True)

    def maintain_on_top(self, window: tk.Tk, always_on_top: bool) -> None:
        """ Maintain the window always on top """
        if always_on_top == True:
            window.attributes('-topmost', True)
        else:
            window.attributes('-topmost', False)

    def free_loaded_image(self, image_pointer: ImageTk.PhotoImage) -> None:
        """ Free an image that was loaded and stored in memory """
        try:
            image_pointer.__del__()
        except Exception as error:
            del image_pointer


# usefull ressource:
# icon: https://www.pythontutorial.net/tkinter/tkinter-window/
