from PyQt5.QtWidgets import QApplication
from PyQt5.QtWidgets import QWidget
from PyQt5.QtWidgets import QHBoxLayout

import sys

from medlib.handle_property import config_ini 

from medlib.input_output import collectCards

from medlib.constants import PANEL_HEIGHT

class App(QWidget):
 
    def __init__(self):
        super().__init__()
        self.title = 'Card test'
        self.left = 10
        self.top = 10
        self.width = 1200
        self.height = PANEL_HEIGHT
        self.initUI()

    def initUI(self):
        self.layout = QHBoxLayout()
        
        self.layout.setContentsMargins(0, 0, 0, 0)
        
        self.setWindowTitle(self.title)
        self.setGeometry(self.left, self.top, self.width, self.height) 
        self.setStyleSheet('background: white')
                
        self.setLayout(self.layout)        
 
        # --- Generated by the filesystem --- #
        
        mainCollector = collectCards()
        
        mediaToShow = mainCollector
        
#        media_list = mainCollector.getMediaCollectorList()    #Video
#        media_list = media_list[0].getMediaCollectorList()    #Video
#        media_list = media_list[0].getMediaCollectorList()    #Movie
#        media_list = media_list[0].getMediaStorageList()
#        mediaToShow = media_list[0]
        self.scale = float(config_ini['scale'])
        self.setGeometry(self.left, self.top, self.width, self.height * self.scale)
        
        mediaToShow.setNextLevelListener(self.goesDeeper)
        self.widget = mediaToShow.getWidget(self.scale)
                
        self.layout.addWidget(self.widget)
        self.show()
      

    def goesDeeper(self, mediaCollector):        
        mcl = mediaCollector.getMediaCollectorList()
        msl = mediaCollector.getMediaStorageList()
        
        if mcl:
            self.layout.removeWidget(self.widget);
            mts = mcl[0]
            mts.setNextLevelListener(self.goesDeeper)
            self.widget = mts.getWidget(self.scale)
            self.layout.addWidget(self.widget)
        elif msl:
            self.layout.removeWidget(self.widget);
            msl = msl[0]
            self.widget = msl.getWidget(self.scale)
            self.layout.addWidget(self.widget)
            
        
        
        
    class MainWidget(QWidget):
        def __init__(self, parent, media):
            QWidget.__init__(self, parent)
            


  
        
#    collector_A.setLanguage("hu")

#Collector_A
#├── Collector_D
#├── Collector_C
#└── Collector_B
#            ├── Collector_BA
#            ├── Collector_BB
#            ├── Storage_BC
#            └── Storage_BD

#for mc in collector_A.getMediaContainerList():
#    print(mc.getTitle())
#    print(collector_A.getHierarchyTitle(""))

    #print(BB_content.getHtml())
#    print(storage_BC.getHtml())


if __name__ == "__main__":
    app = QApplication(sys.argv)
    ex = App()
    #ex.start_card_holder()
    sys.exit(app.exec_())

