from .title import Title
from .regionaldata import Region

__all__ = [
	"o3ds_sys_titles",
	"n3ds_sys_titles",
	"all_sys_tids"
]

# NUS gives full list for o3ds JPN
_o3ds_jpn = (
	Title(0x0004001000020000, 11266, Region.JPN),
	Title(0x0004001000020100, 3072, Region.JPN),
	Title(0x0004001000020200, 2080, Region.JPN),
	Title(0x0004001000020300, 2050, Region.JPN),
	Title(0x0004001000020400, 5120, Region.JPN),
	Title(0x0004001000020500, 4096, Region.JPN),
	Title(0x0004001000020700, 2064, Region.JPN),
	Title(0x0004001000020800, 5121, Region.JPN),
	Title(0x0004001000020900, 28673, Region.JPN),
	Title(0x0004001000020a00, 6154, Region.JPN),
	Title(0x0004001000020b00, 1034, Region.JPN),
	Title(0x0004001000020d00, 1028, Region.JPN),
	Title(0x0004001000020e00, 1026, Region.JPN),
	Title(0x0004001000020f00, 2049, Region.JPN),
	Title(0x0004001000023000, 2048, Region.JPN),
	Title(0x000400100002bf00, 3072, Region.JPN),
	Title(0x0004001b00010002, 0),
	Title(0x0004001b00010702, 4096),
	Title(0x0004001b00010802, 8192),
	Title(0x0004001b00018002, 8192),
	Title(0x0004001b00018102, 1025),
	Title(0x0004001b00018202, 2050),
	Title(0x0004001b00019002, 1026),
	Title(0x0004003000008202, 31745),
	Title(0x0004003000008302, 6),
	Title(0x0004003000008402, 2049),
	Title(0x0004003000008602, 5121),
	Title(0x0004003000008702, 4097),
	Title(0x0004003000008802, 13313),
	Title(0x0004003000008a02, 7168),
	Title(0x0004003000008a03, 0),
	Title(0x0004003000008d02, 6144),
	Title(0x0004003000008e02, 5121),
	Title(0x0004003000009502, 1031),
	Title(0x000400300000bc02, 4096),
	Title(0x000400300000c002, 4096),
	Title(0x000400300000c003, 0),
	Title(0x000400300000c102, 3077),
	Title(0x000400300000c302, 4096),
	Title(0x000400300000c402, 3072),
	Title(0x000400300000c502, 7184),
	Title(0x000400300000c503, 0),
	Title(0x000400300000c602, 22530),
	Title(0x000400300000cd02, 4097),
	Title(0x000400300000f602, 3072),
	Title(0x0004009b00010202, 0),
	Title(0x0004009b00010402, 5122),
	Title(0x0004009b00010602, 2052),
	Title(0x0004009b00011902, 0),
	Title(0x0004009b00012202, 16384),
	Title(0x0004009b00013202, 1024),
	Title(0x0004009b00014002, 0),
	Title(0x0004009b00014102, 1024),
	Title(0x0004009b00014202, 1024),
	Title(0x0004009b00014302, 1024),
	Title(0x0004009b00015202, 0),
	Title(0x000400db00010302, 9217),
	Title(0x000400db00010502, 23552),
	Title(0x000400db00016202, 784),
	Title(0x000400db00017202, 11520),
	Title(0x0004013000001502, 10245),
	Title(0x0004013000001503, 0),
	Title(0x0004013000001602, 11265),
	Title(0x0004013000001702, 15360),
	Title(0x0004013000001703, 0),
	Title(0x0004013000001802, 7168),
	Title(0x0004013000001803, 0),
	Title(0x0004013000001a02, 7169),
	Title(0x0004013000001a03, 0),
	Title(0x0004013000001b02, 3073),
	Title(0x0004013000001b03, 0),
	Title(0x0004013000001c02, 14336),
	Title(0x0004013000001c03, 0),
	Title(0x0004013000001d02, 10240),
	Title(0x0004013000001d03, 0),
	Title(0x0004013000001e02, 5120),
	Title(0x0004013000001e03, 0),
	Title(0x0004013000001f02, 8192),
	Title(0x0004013000001f03, 0),
	Title(0x0004013000002002, 2048),
	Title(0x0004013000002102, 2048),
	Title(0x0004013000002103, 0),
	Title(0x0004013000002202, 11264),
	Title(0x0004013000002203, 0),
	Title(0x0004013000002302, 3072),
	Title(0x0004013000002303, 0),
	Title(0x0004013000002402, 9216),
	Title(0x0004013000002403, 0),
	Title(0x0004013000002602, 12288),
	Title(0x0004013000002702, 5120),
	Title(0x0004013000002703, 0),
	Title(0x0004013000002802, 8192),
	Title(0x0004013000002902, 14336),
	Title(0x0004013000002903, 0),
	Title(0x0004013000002a02, 2048),
	Title(0x0004013000002a03, 0),
	Title(0x0004013000002b02, 7169),
	Title(0x0004013000002c02, 14341),
	Title(0x0004013000002c03, 0),
	Title(0x0004013000002d02, 11264),
	Title(0x0004013000002d03, 5120),
	Title(0x0004013000002e02, 8192),
	Title(0x0004013000002e03, 0),
	Title(0x0004013000002f02, 9217),
	Title(0x0004013000002f03, 1024),
	Title(0x0004013000003102, 5120),
	Title(0x0004013000003103, 0),
	Title(0x0004013000003202, 21504),
	Title(0x0004013000003203, 0),
	Title(0x0004013000003302, 13313),
	Title(0x0004013000003303, 0),
	Title(0x0004013000003402, 14337),
	Title(0x0004013000003502, 7168),
	Title(0x0004013000003702, 6148),
	Title(0x0004013000003802, 9216),
	Title(0x0004013000004002, 8192),
	Title(0x0004013000008002, 23553),
	Title(0x0004013000008003, 0),
	Title(0x0004013800000002, 32673),
	Title(0x0004013800000003, 5632),
	Title(0x0004013800000102, 10864),
	Title(0x0004013800000202, 3665),
	Title(0x0004800542383841, 2048),
	Title(0x00048005484e4441, 1024),
	Title(0x0004800f484e4841, 11264),
	Title(0x0004800f484e4c41, 0)
)

# NUS gives full list for o3ds USA
_o3ds_usa = (
	Title(0x0004001000021000, 10241, Region.USA),
	Title(0x0004001000021100, 3073, Region.USA),
	Title(0x0004001000021200, 2064, Region.USA),
	Title(0x0004001000021300, 3073, Region.USA),
	Title(0x0004001000021400, 5120, Region.USA),
	Title(0x0004001000021500, 4096, Region.USA),
	Title(0x0004001000021700, 2055, Region.USA),
	Title(0x0004001000021800, 5136, Region.USA),
	Title(0x0004001000021900, 28673, Region.USA),
	Title(0x0004001000021a00, 6156, Region.USA),
	Title(0x0004001000021b00, 1034, Region.USA),
	Title(0x0004001000021d00, 1040, Region.USA),
	Title(0x0004001000021e00, 1040, Region.USA),
	Title(0x0004001000021f00, 2049, Region.USA),
	Title(0x0004001000024000, 2048, Region.USA),
	Title(0x000400100002c000, 3072, Region.USA),
	Title(0x0004001b00010002, 0),
	Title(0x0004001b00010702, 4096),
	Title(0x0004001b00010802, 8192),
	Title(0x0004001b00018002, 8192),
	Title(0x0004001b00018102, 1025),
	Title(0x0004001b00018202, 2050),
	Title(0x0004001b00019002, 1026),
	Title(0x0004003000008a02, 7168),
	Title(0x0004003000008a03, 0),
	Title(0x0004003000008b02, 6),
	Title(0x0004003000008f02, 29697),
	Title(0x0004003000009002, 2049),
	Title(0x0004003000009202, 5120),
	Title(0x0004003000009302, 4096),
	Title(0x0004003000009402, 13313),
	Title(0x0004003000009602, 6144),
	Title(0x0004003000009702, 4097),
	Title(0x0004003000009e02, 1031),
	Title(0x000400300000bd02, 4096),
	Title(0x000400300000c502, 7184),
	Title(0x000400300000c503, 0),
	Title(0x000400300000c802, 4096),
	Title(0x000400300000c803, 0),
	Title(0x000400300000c902, 3077),
	Title(0x000400300000cb02, 4096),
	Title(0x000400300000cc02, 3072),
	Title(0x000400300000cd02, 4097),
	Title(0x000400300000ce02, 22530),
	Title(0x000400300000f602, 3072),
	Title(0x0004009b00010202, 0),
	Title(0x0004009b00010402, 5122),
	Title(0x0004009b00010602, 2052),
	Title(0x0004009b00011402, 0),
	Title(0x0004009b00011602, 0),
	Title(0x0004009b00011d02, 0),
	Title(0x0004009b00011e02, 0),
	Title(0x0004009b00012302, 15360),
	Title(0x0004009b00013302, 5123),
	Title(0x0004009b00014002, 0),
	Title(0x0004009b00014102, 1024),
	Title(0x0004009b00014202, 1024),
	Title(0x0004009b00014302, 1024),
	Title(0x0004009b00015302, 0),
	Title(0x000400db00010302, 9217),
	Title(0x000400db00010502, 23552),
	Title(0x000400db00016302, 784),
	Title(0x000400db00017302, 11520),
	Title(0x0004013000001502, 10245),
	Title(0x0004013000001503, 0),
	Title(0x0004013000001602, 11265),
	Title(0x0004013000001702, 15360),
	Title(0x0004013000001703, 0),
	Title(0x0004013000001802, 7168),
	Title(0x0004013000001803, 0),
	Title(0x0004013000001a02, 7169),
	Title(0x0004013000001a03, 0),
	Title(0x0004013000001b02, 3073),
	Title(0x0004013000001b03, 0),
	Title(0x0004013000001c02, 14336),
	Title(0x0004013000001c03, 0),
	Title(0x0004013000001d02, 10240),
	Title(0x0004013000001d03, 0),
	Title(0x0004013000001e02, 5120),
	Title(0x0004013000001e03, 0),
	Title(0x0004013000001f02, 8192),
	Title(0x0004013000001f03, 0),
	Title(0x0004013000002002, 2048),
	Title(0x0004013000002102, 2048),
	Title(0x0004013000002103, 0),
	Title(0x0004013000002202, 11264),
	Title(0x0004013000002203, 0),
	Title(0x0004013000002302, 3072),
	Title(0x0004013000002303, 0),
	Title(0x0004013000002402, 9216),
	Title(0x0004013000002403, 0),
	Title(0x0004013000002602, 12288),
	Title(0x0004013000002702, 5120),
	Title(0x0004013000002703, 0),
	Title(0x0004013000002802, 8192),
	Title(0x0004013000002902, 14336),
	Title(0x0004013000002903, 0),
	Title(0x0004013000002a02, 2048),
	Title(0x0004013000002a03, 0),
	Title(0x0004013000002b02, 7169),
	Title(0x0004013000002c02, 14341),
	Title(0x0004013000002c03, 0),
	Title(0x0004013000002d02, 11264),
	Title(0x0004013000002d03, 5120),
	Title(0x0004013000002e02, 8192),
	Title(0x0004013000002e03, 0),
	Title(0x0004013000002f02, 9217),
	Title(0x0004013000002f03, 1024),
	Title(0x0004013000003102, 5120),
	Title(0x0004013000003103, 0),
	Title(0x0004013000003202, 21504),
	Title(0x0004013000003203, 0),
	Title(0x0004013000003302, 13313),
	Title(0x0004013000003303, 0),
	Title(0x0004013000003402, 14337),
	Title(0x0004013000003502, 7168),
	Title(0x0004013000003702, 6148),
	Title(0x0004013000003802, 9216),
	Title(0x0004013000004002, 8192),
	Title(0x0004013000008002, 23553),
	Title(0x0004013000008003, 0),
	Title(0x0004013800000002, 32673),
	Title(0x0004013800000003, 5632),
	Title(0x0004013800000102, 10864),
	Title(0x0004013800000202, 3665),
	Title(0x0004800542383841, 2048),
	Title(0x00048005484e4441, 1024),
	Title(0x0004800f484e4841, 11264),
	Title(0x0004800f484e4c41, 0)
)

# NUS gives full list for o3ds EUR
_o3ds_eur = (
	Title(0x0004001000022000, 11281, Region.EUR),
	Title(0x0004001000022100, 3073, Region.EUR),
	Title(0x0004001000022200, 2064, Region.EUR),
	Title(0x0004001000022300, 3077, Region.EUR),
	Title(0x0004001000022400, 5120, Region.EUR),
	Title(0x0004001000022500, 4096, Region.EUR),
	Title(0x0004001000022700, 2055, Region.EUR),
	Title(0x0004001000022800, 5122, Region.EUR),
	Title(0x0004001000022900, 28673, Region.EUR),
	Title(0x0004001000022a00, 6155, Region.EUR),
	Title(0x0004001000022b00, 1034, Region.EUR),
	Title(0x0004001000022d00, 1040, Region.EUR),
	Title(0x0004001000022e00, 1040, Region.EUR),
	Title(0x0004001000022f00, 2050, Region.EUR),
	Title(0x0004001000025000, 2048, Region.EUR),
	Title(0x000400100002c100, 3072, Region.EUR),
	Title(0x0004001b00010002, 0),
	Title(0x0004001b00010702, 4096),
	Title(0x0004001b00010802, 8192),
	Title(0x0004001b00018002, 8192),
	Title(0x0004001b00018102, 1025),
	Title(0x0004001b00018202, 2050),
	Title(0x0004001b00019002, 1026),
	Title(0x0004003000008a02, 7168),
	Title(0x0004003000008a03, 0),
	Title(0x0004003000009802, 29696),
	Title(0x0004003000009902, 2049),
	Title(0x0004003000009b02, 5120),
	Title(0x0004003000009c02, 4096),
	Title(0x0004003000009d02, 13313),
	Title(0x0004003000009f02, 6144),
	Title(0x000400300000a002, 4097),
	Title(0x000400300000b902, 1031),
	Title(0x000400300000ba02, 6),
	Title(0x000400300000be02, 4096),
	Title(0x000400300000c502, 7184),
	Title(0x000400300000c503, 0),
	Title(0x000400300000cd02, 4097),
	Title(0x000400300000d002, 4096),
	Title(0x000400300000d003, 0),
	Title(0x000400300000d102, 3077),
	Title(0x000400300000d302, 4096),
	Title(0x000400300000d402, 3072),
	Title(0x000400300000d602, 22530),
	Title(0x000400300000f602, 3072),
	Title(0x0004009b00010202, 0),
	Title(0x0004009b00010402, 5122),
	Title(0x0004009b00010602, 2052),
	Title(0x0004009b00011202, 0),
	Title(0x0004009b00011302, 0),
	Title(0x0004009b00011502, 0),
	Title(0x0004009b00011702, 0),
	Title(0x0004009b00011802, 0),
	Title(0x0004009b00011b02, 0),
	Title(0x0004009b00011c02, 0),
	Title(0x0004009b00011d02, 0),
	Title(0x0004009b00012102, 15360),
	Title(0x0004009b00013102, 8194),
	Title(0x0004009b00014002, 0),
	Title(0x0004009b00014102, 1024),
	Title(0x0004009b00014202, 1024),
	Title(0x0004009b00014302, 1024),
	Title(0x0004009b00015102, 2048),
	Title(0x000400db00010302, 9217),
	Title(0x000400db00010502, 23552),
	Title(0x000400db00016102, 784),
	Title(0x000400db00017102, 11520),
	Title(0x0004013000001502, 10245),
	Title(0x0004013000001503, 0),
	Title(0x0004013000001602, 11265),
	Title(0x0004013000001702, 15360),
	Title(0x0004013000001703, 0),
	Title(0x0004013000001802, 7168),
	Title(0x0004013000001803, 0),
	Title(0x0004013000001a02, 7169),
	Title(0x0004013000001a03, 0),
	Title(0x0004013000001b02, 3073),
	Title(0x0004013000001b03, 0),
	Title(0x0004013000001c02, 14336),
	Title(0x0004013000001c03, 0),
	Title(0x0004013000001d02, 10240),
	Title(0x0004013000001d03, 0),
	Title(0x0004013000001e02, 5120),
	Title(0x0004013000001e03, 0),
	Title(0x0004013000001f02, 8192),
	Title(0x0004013000001f03, 0),
	Title(0x0004013000002002, 2048),
	Title(0x0004013000002102, 2048),
	Title(0x0004013000002103, 0),
	Title(0x0004013000002202, 11264),
	Title(0x0004013000002203, 0),
	Title(0x0004013000002302, 3072),
	Title(0x0004013000002303, 0),
	Title(0x0004013000002402, 9216),
	Title(0x0004013000002403, 0),
	Title(0x0004013000002602, 12288),
	Title(0x0004013000002702, 5120),
	Title(0x0004013000002703, 0),
	Title(0x0004013000002802, 8192),
	Title(0x0004013000002902, 14336),
	Title(0x0004013000002903, 0),
	Title(0x0004013000002a02, 2048),
	Title(0x0004013000002a03, 0),
	Title(0x0004013000002b02, 7169),
	Title(0x0004013000002c02, 14341),
	Title(0x0004013000002c03, 0),
	Title(0x0004013000002d02, 11264),
	Title(0x0004013000002d03, 5120),
	Title(0x0004013000002e02, 8192),
	Title(0x0004013000002e03, 0),
	Title(0x0004013000002f02, 9217),
	Title(0x0004013000002f03, 1024),
	Title(0x0004013000003102, 5120),
	Title(0x0004013000003103, 0),
	Title(0x0004013000003202, 21504),
	Title(0x0004013000003203, 0),
	Title(0x0004013000003302, 13313),
	Title(0x0004013000003303, 0),
	Title(0x0004013000003402, 14337),
	Title(0x0004013000003502, 7168),
	Title(0x0004013000003702, 6148),
	Title(0x0004013000003802, 9216),
	Title(0x0004013000004002, 8192),
	Title(0x0004013000008002, 23553),
	Title(0x0004013000008003, 0),
	Title(0x0004013800000002, 32673),
	Title(0x0004013800000003, 5632),
	Title(0x0004013800000102, 10864),
	Title(0x0004013800000202, 3665),
	Title(0x0004800542383841, 2048),
	Title(0x00048005484e4441, 1024),
	Title(0x0004800f484e4841, 11264),
	Title(0x0004800f484e4c41, 0)
)

# validated with testdisk ctrtransfer image + NUS partial list
# ctrtransfer was missing 0004003000008a03
# indications of TWN titles have a possible source of reason
# TWN seems to have CHN title dummies
# CHN can have the same other way
# need clean iQue 3DS to check
_o3ds_chn = (
	Title(0x0004001000026000, 3075, Region.CHN),
	Title(0x0004001000026100, 4, Region.CHN),
	Title(0x0004001000026200, 3, Region.CHN),
	Title(0x0004001000026300, 5, Region.CHN),
	Title(0x0004001000026400, 3, Region.CHN),
	Title(0x0004001000026500, 1024, Region.CHN),
	Title(0x0004001000026700, 1, Region.CHN),
	Title(0x0004001000026800, 4096, Region.CHN),
	Title(0x0004001000026d00, 0, Region.CHN),
	Title(0x0004001000026e00, 0, Region.CHN),
	Title(0x0004001000026f00, 1026, Region.CHN),
	#Title(0x0004001000028000, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028100, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028200, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028300, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028400, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028500, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028700, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028800, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028900, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028a00, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028d00, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028e00, 32768, Region.TWN, downloadable = False),
	#Title(0x0004001000028f00, 32768, Region.TWN, downloadable = False),
	Title(0x0004001b00010002, 0),
	Title(0x0004001b00010702, 4096),
	Title(0x0004001b00010802, 8192),
	Title(0x0004001b00019002, 1026),
	Title(0x0004003000008a02, 7168),
	Title(0x0004003000008a03, 4096),
	Title(0x000400300000a102, 3074),
	Title(0x000400300000a202, 3),
	Title(0x000400300000a402, 4097),
	Title(0x000400300000a502, 3073),
	Title(0x000400300000a602, 13313),
	Title(0x000400300000a702, 1024),
	Title(0x000400300000a802, 6),
	#Title(0x000400300000b102, 32768, downloadable = False),
	#Title(0x000400300000b202, 32768, downloadable = False),
	#Title(0x000400300000b402, 32768, downloadable = False),
	#Title(0x000400300000b502, 32768, downloadable = False),
	#Title(0x000400300000b602, 32768, downloadable = False),
	#Title(0x000400300000b702, 32768, downloadable = False),
	#Title(0x000400300000b802, 32768, downloadable = False),
	Title(0x000400300000bf02, 1024),
	Title(0x000400300000cf02, 1027),
	Title(0x000400300000cf03, 1),
	Title(0x000400300000d502, 3072),
	Title(0x000400300000d802, 0),
	Title(0x000400300000d803, 0),
	Title(0x000400300000d902, 0),
	Title(0x000400300000db02, 2),
	Title(0x000400300000dc02, 2048),
	#Title(0x000400300000e402, 32768, downloadable = False),
	#Title(0x000400300000e403, 32768, downloadable = False),
	#Title(0x000400300000e502, 32768, downloadable = False),
	#Title(0x000400300000e702, 32768, downloadable = False),
	#Title(0x000400300000e802, 32768, downloadable = False),
	#Title(0x000400300000e902, 32768, downloadable = False),
	Title(0x0004009b00010202, 0),
	Title(0x0004009b00010402, 5122),
	Title(0x0004009b00010602, 2052),
	Title(0x0004009b00011002, 1),
	#Title(0x0004009b00011102, 32768, downloadable = False),
	Title(0x0004009b00012402, 7168),
	#Title(0x0004009b00012602, 32768, downloadable = False),
	Title(0x0004009b00013402, 2048),
	#Title(0x0004009b00013602, 32768, downloadable = False),
	Title(0x0004009b00014002, 0),
	Title(0x0004009b00014102, 1024),
	Title(0x0004009b00014202, 1024),
	Title(0x0004009b00014302, 1024),
	#Title(0x0004009b00015602, 32768, downloadable = False),
	Title(0x000400db00010302, 9217),
	Title(0x000400db00010502, 23552),
	Title(0x000400db00016402, 132),
	#Title(0x000400db00016602, 32768, downloadable = False),
	Title(0x000400db00017402, 11520),
	#Title(0x000400db00017602, 32768, downloadable = False),
	Title(0x0004013000001502, 10245),
	Title(0x0004013000001503, 0),
	Title(0x0004013000001602, 11265),
	Title(0x0004013000001702, 15360),
	Title(0x0004013000001703, 0),
	Title(0x0004013000001802, 7168),
	Title(0x0004013000001803, 0),
	Title(0x0004013000001a02, 7169),
	Title(0x0004013000001a03, 0),
	Title(0x0004013000001b02, 3073),
	Title(0x0004013000001b03, 0),
	Title(0x0004013000001c02, 14336),
	Title(0x0004013000001c03, 0),
	Title(0x0004013000001d02, 10240),
	Title(0x0004013000001d03, 0),
	Title(0x0004013000001e02, 5120),
	Title(0x0004013000001e03, 0),
	Title(0x0004013000001f02, 8192),
	Title(0x0004013000001f03, 0),
	Title(0x0004013000002002, 2048),
	Title(0x0004013000002102, 2048),
	Title(0x0004013000002103, 0),
	Title(0x0004013000002202, 11264),
	Title(0x0004013000002203, 0),
	Title(0x0004013000002302, 3072),
	Title(0x0004013000002303, 0),
	Title(0x0004013000002402, 9216),
	Title(0x0004013000002403, 0),
	Title(0x0004013000002602, 12288),
	Title(0x0004013000002702, 5120),
	Title(0x0004013000002703, 0),
	Title(0x0004013000002802, 8192),
	Title(0x0004013000002902, 14336),
	Title(0x0004013000002903, 0),
	Title(0x0004013000002a02, 2048),
	Title(0x0004013000002a03, 0),
	Title(0x0004013000002b02, 7169),
	Title(0x0004013000002c02, 14341),
	Title(0x0004013000002c03, 3072),
	Title(0x0004013000002d02, 11264),
	Title(0x0004013000002d03, 5120),
	Title(0x0004013000002e02, 8192),
	Title(0x0004013000002e03, 0),
	Title(0x0004013000002f02, 9217),
	Title(0x0004013000002f03, 1024),
	Title(0x0004013000003102, 5120),
	Title(0x0004013000003103, 0),
	Title(0x0004013000003202, 21504),
	Title(0x0004013000003203, 0),
	Title(0x0004013000003302, 13313),
	Title(0x0004013000003303, 0),
	Title(0x0004013000003402, 14337),
	Title(0x0004013000003502, 7168),
	Title(0x0004013000003702, 6148),
	Title(0x0004013000003802, 9216),
	Title(0x0004013000004002, 8192),
	Title(0x0004013000008002, 23553),
	Title(0x0004013000008003, 4096),
	Title(0x0004013800000002, 32673),
	Title(0x0004013800000003, 5632),
	Title(0x0004013800000102, 10864),
	Title(0x0004013800000202, 2576),
	Title(0x0004800542383841, 2048),
	Title(0x00048005484e4443, 1024),
	Title(0x0004800f484e4841, 11264),
	Title(0x0004800f484e4c41, 0)
)

# validated with ctrtransfer image + NUS partial list
_o3ds_kor = (
	Title(0x0004001000027000, 7168, Region.KOR),
	Title(0x0004001000027100, 2048, Region.KOR),
	Title(0x0004001000027200, 16, Region.KOR),
	Title(0x0004001000027300, 1027, Region.KOR),
	Title(0x0004001000027400, 3072, Region.KOR),
	Title(0x0004001000027500, 1024, Region.KOR),
	Title(0x0004001000027700, 16, Region.KOR),
	Title(0x0004001000027800, 5120, Region.KOR),
	Title(0x0004001000027900, 28673, Region.KOR),
	Title(0x0004001000027a00, 4106, Region.KOR),
	Title(0x0004001000027d00, 0, Region.KOR),
	Title(0x0004001000027e00, 16, Region.KOR),
	Title(0x0004001000027f00, 1025, Region.KOR),
	Title(0x0004001b00010002, 0),
	Title(0x0004001b00010702, 4096),
	Title(0x0004001b00010802, 8192),
	Title(0x0004001b00019002, 1026),
	Title(0x0004003000008a02, 7168),
	Title(0x0004003000008a03, 4096),
	Title(0x0004003000008c02, 1031),
	Title(0x000400300000a902, 15361),
	Title(0x000400300000aa02, 1024),
	Title(0x000400300000ac02, 6144),
	Title(0x000400300000ad02, 4096),
	Title(0x000400300000ae02, 13313),
	Title(0x000400300000af02, 3072),
	Title(0x000400300000b002, 2048),
	Title(0x000400300000cf02, 1027),
	Title(0x000400300000cf03, 1),
	Title(0x000400300000d502, 3072),
	Title(0x000400300000de02, 1025),
	Title(0x000400300000de03, 0),
	Title(0x000400300000df02, 1026),
	Title(0x000400300000e102, 1025),
	Title(0x000400300000e202, 3072),
	Title(0x000400300000e302, 22530),
	Title(0x0004009b00010202, 0),
	Title(0x0004009b00010402, 5122),
	Title(0x0004009b00010602, 2052),
	Title(0x0004009b00011a02, 1),
	Title(0x0004009b00012502, 12288),
	Title(0x0004009b00013502, 1025),
	Title(0x0004009b00014002, 0),
	Title(0x0004009b00014102, 1024),
	Title(0x0004009b00014202, 1024),
	Title(0x0004009b00014302, 1024),
	Title(0x0004009b00015502, 1024),
	Title(0x000400db00010302, 9217),
	Title(0x000400db00010502, 23552),
	Title(0x000400db00016502, 672),
	Title(0x000400db00017502, 11520),
	Title(0x0004013000001502, 10245),
	Title(0x0004013000001503, 0),
	Title(0x0004013000001602, 11265),
	Title(0x0004013000001702, 15360),
	Title(0x0004013000001703, 0),
	Title(0x0004013000001802, 7168),
	Title(0x0004013000001803, 0),
	Title(0x0004013000001a02, 7169),
	Title(0x0004013000001a03, 0),
	Title(0x0004013000001b02, 3073),
	Title(0x0004013000001b03, 0),
	Title(0x0004013000001c02, 14336),
	Title(0x0004013000001c03, 0),
	Title(0x0004013000001d02, 10240),
	Title(0x0004013000001d03, 0),
	Title(0x0004013000001e02, 5120),
	Title(0x0004013000001e03, 0),
	Title(0x0004013000001f02, 8192),
	Title(0x0004013000001f03, 0),
	Title(0x0004013000002002, 2048),
	Title(0x0004013000002102, 2048),
	Title(0x0004013000002103, 0),
	Title(0x0004013000002202, 11264),
	Title(0x0004013000002203, 0),
	Title(0x0004013000002302, 3072),
	Title(0x0004013000002303, 0),
	Title(0x0004013000002402, 9216),
	Title(0x0004013000002403, 0),
	Title(0x0004013000002602, 12288),
	Title(0x0004013000002702, 5120),
	Title(0x0004013000002703, 0),
	Title(0x0004013000002802, 8192),
	Title(0x0004013000002902, 14336),
	Title(0x0004013000002903, 0),
	Title(0x0004013000002a02, 2048),
	Title(0x0004013000002a03, 0),
	Title(0x0004013000002b02, 7169),
	Title(0x0004013000002c02, 14341),
	Title(0x0004013000002c03, 3072),
	Title(0x0004013000002d02, 11264),
	Title(0x0004013000002d03, 5120),
	Title(0x0004013000002e02, 8192),
	Title(0x0004013000002e03, 0),
	Title(0x0004013000002f02, 9217),
	Title(0x0004013000002f03, 1024),
	Title(0x0004013000003102, 5120),
	Title(0x0004013000003103, 0),
	Title(0x0004013000003202, 21504),
	Title(0x0004013000003203, 0),
	Title(0x0004013000003302, 13313),
	Title(0x0004013000003303, 0),
	Title(0x0004013000003402, 14337),
	Title(0x0004013000003502, 7168),
	Title(0x0004013000003702, 6148),
	Title(0x0004013000003802, 9216),
	Title(0x0004013000004002, 8192),
	Title(0x0004013000008002, 23553),
	Title(0x0004013000008003, 4096),
	Title(0x0004013800000002, 32673),
	Title(0x0004013800000003, 5632),
	Title(0x0004013800000102, 10864),
	Title(0x0004013800000202, 3665),
	Title(0x0004800542383841, 2048),
	Title(0x00048005484e444b, 1024),
	Title(0x0004800f484e4841, 11264),
	Title(0x0004800f484e4c41, 0)
)

# tid and version list validated against freshly hacked console
_o3ds_twn = (
	Title(0x0004001000026000, 32768, Region.CHN, downloadable = False),
	Title(0x0004001000026100, 32768, Region.CHN, downloadable = False),
	Title(0x0004001000026200, 32768, Region.CHN, downloadable = False),
	Title(0x0004001000026300, 32768, Region.CHN, downloadable = False),
	Title(0x0004001000026400, 32768, Region.CHN, downloadable = False),
	Title(0x0004001000026500, 32768, Region.CHN, downloadable = False),
	Title(0x0004001000026700, 32768, Region.CHN, downloadable = False),
	Title(0x0004001000026800, 32768, Region.CHN, downloadable = False),
	Title(0x0004001000026d00, 32768, Region.CHN, downloadable = False),
	Title(0x0004001000026e00, 32768, Region.CHN, downloadable = False),
	Title(0x0004001000026f00, 32768, Region.CHN, downloadable = False),
	Title(0x0004001000028000, 3074, Region.TWN),
	Title(0x0004001000028100, 4, Region.TWN),
	Title(0x0004001000028200, 2, Region.TWN),
	Title(0x0004001000028300, 5, Region.TWN),
	Title(0x0004001000028400, 3, Region.TWN),
	Title(0x0004001000028500, 1024, Region.TWN),
	Title(0x0004001000028700, 2, Region.TWN),
	Title(0x0004001000028800, 4096, Region.TWN),
	Title(0x0004001000028900, 28673, Region.TWN),
	Title(0x0004001000028a00, 4105, Region.TWN),
	Title(0x0004001000028d00, 2, Region.TWN),
	Title(0x0004001000028e00, 1, Region.TWN),
	Title(0x0004001000028f00, 1025, Region.TWN),
	Title(0x0004001b00010002, 0),
	Title(0x0004001b00010702, 4096),
	Title(0x0004001b00010802, 8192),
	Title(0x0004001b00019002, 1026),
	Title(0x0004003000008a02, 7168),
	Title(0x0004003000008a03, 4096),
	Title(0x000400300000a102, 32768, downloadable = False),
	Title(0x000400300000a202, 32768, downloadable = False),
	Title(0x000400300000a402, 32768, downloadable = False),
	Title(0x000400300000a502, 32768, downloadable = False),
	Title(0x000400300000a602, 32768, downloadable = False),
	Title(0x000400300000a702, 32768, downloadable = False),
	Title(0x000400300000a802, 32768, downloadable = False),
	Title(0x000400300000b102, 6146),
	Title(0x000400300000b202, 3),
	Title(0x000400300000b402, 5121),
	Title(0x000400300000b502, 3073),
	Title(0x000400300000b602, 13313),
	Title(0x000400300000b702, 1024),
	Title(0x000400300000b802, 6),
	Title(0x000400300000bf02, 1024),
	Title(0x000400300000cf02, 1027),
	Title(0x000400300000cf03, 1),
	Title(0x000400300000d502, 3072),
	Title(0x000400300000d802, 32768, downloadable = False),
	Title(0x000400300000d803, 32768, downloadable = False),
	Title(0x000400300000d902, 32768, downloadable = False),
	Title(0x000400300000db02, 32768, downloadable = False),
	Title(0x000400300000dc02, 32768, downloadable = False),
	Title(0x000400300000e402, 0),
	Title(0x000400300000e403, 0),
	Title(0x000400300000e502, 1024),
	Title(0x000400300000e702, 2),
	Title(0x000400300000e802, 2048),
	Title(0x000400300000e902, 22530),
	Title(0x0004009b00010202, 0),
	Title(0x0004009b00010402, 5122),
	Title(0x0004009b00010602, 2052),
	Title(0x0004009b00011002, 32768, downloadable = False),
	Title(0x0004009b00011102, 1),
	Title(0x0004009b00012402, 32768, downloadable = False),
	Title(0x0004009b00012602, 10240),
	Title(0x0004009b00013402, 32768, downloadable = False),
	Title(0x0004009b00013602, 2050),
	Title(0x0004009b00014002, 0),
	Title(0x0004009b00014102, 1024),
	Title(0x0004009b00014202, 1024),
	Title(0x0004009b00014302, 1024),
	Title(0x0004009b00015402, 32768, downloadable = False),
	Title(0x0004009b00015602, 1024),
	Title(0x000400db00010302, 9217),
	Title(0x000400db00010502, 23552),
	Title(0x000400db00016402, 32768, downloadable = False),
	Title(0x000400db00016602, 640),
	Title(0x000400db00017402, 32768, downloadable = False),
	Title(0x000400db00017602, 11520),
	Title(0x0004013000001502, 10245),
	Title(0x0004013000001503, 0),
	Title(0x0004013000001602, 11265),
	Title(0x0004013000001702, 15360),
	Title(0x0004013000001703, 0),
	Title(0x0004013000001802, 7168),
	Title(0x0004013000001803, 0),
	Title(0x0004013000001a02, 7169),
	Title(0x0004013000001a03, 0),
	Title(0x0004013000001b02, 3073),
	Title(0x0004013000001b03, 0),
	Title(0x0004013000001c02, 14336),
	Title(0x0004013000001c03, 0),
	Title(0x0004013000001d02, 10240),
	Title(0x0004013000001d03, 0),
	Title(0x0004013000001e02, 5120),
	Title(0x0004013000001e03, 0),
	Title(0x0004013000001f02, 8192),
	Title(0x0004013000001f03, 0),
	Title(0x0004013000002002, 2048),
	Title(0x0004013000002102, 2048),
	Title(0x0004013000002103, 0),
	Title(0x0004013000002202, 11264),
	Title(0x0004013000002203, 0),
	Title(0x0004013000002302, 3072),
	Title(0x0004013000002303, 0),
	Title(0x0004013000002402, 9216),
	Title(0x0004013000002403, 0),
	Title(0x0004013000002602, 12288),
	Title(0x0004013000002702, 5120),
	Title(0x0004013000002703, 0),
	Title(0x0004013000002802, 8192),
	Title(0x0004013000002902, 14336),
	Title(0x0004013000002903, 0),
	Title(0x0004013000002a02, 2048),
	Title(0x0004013000002a03, 0),
	Title(0x0004013000002b02, 7169),
	Title(0x0004013000002c02, 14341),
	Title(0x0004013000002c03, 3072),
	Title(0x0004013000002d02, 11264),
	Title(0x0004013000002d03, 5120),
	Title(0x0004013000002e02, 8192),
	Title(0x0004013000002e03, 0),
	Title(0x0004013000002f02, 9217),
	Title(0x0004013000002f03, 1024),
	Title(0x0004013000003102, 5120),
	Title(0x0004013000003103, 0),
	Title(0x0004013000003202, 21504),
	Title(0x0004013000003203, 0),
	Title(0x0004013000003302, 13313),
	Title(0x0004013000003303, 0),
	Title(0x0004013000003402, 14337),
	Title(0x0004013000003502, 7168),
	Title(0x0004013000003702, 6148),
	Title(0x0004013000003802, 9216),
	Title(0x0004013000004002, 8192),
	Title(0x0004013000008002, 23553),
	Title(0x0004013000008003, 4096),
	Title(0x0004013800000002, 32673),
	Title(0x0004013800000003, 5632),
	Title(0x0004013800000102, 10864),
	Title(0x0004013800000202, 2576),
	Title(0x0004800542383841, 2048),
	Title(0x00048005484e4441, 1024),
	Title(0x00048005484e4443, 32768, downloadable = False),
	Title(0x0004800f484e4841, 11264),
	Title(0x0004800f484e4c41, 0)
)

# tid list validated against real console
_n3ds_jpn = (
	Title(0x0004001000020000, 11266, Region.JPN),
	Title(0x0004001000020100, 3072, Region.JPN),
	Title(0x0004001000020200, 2080, Region.JPN),
	Title(0x0004001020020300, 32, Region.JPN),
	Title(0x0004001000020400, 5120, Region.JPN),
	Title(0x0004001000020500, 4096, Region.JPN),
	Title(0x0004001000020700, 2064, Region.JPN),
	Title(0x0004001000020800, 5121, Region.JPN),
	Title(0x0004001000020900, 28673, Region.JPN),
	Title(0x0004001000020a00, 6154, Region.JPN),
	Title(0x0004001000020b00, 1034, Region.JPN),
	Title(0x0004001020020d00, 2050, Region.JPN),
	Title(0x0004001000020e00, 1026, Region.JPN),
	Title(0x0004001000020f00, 2049, Region.JPN),
	Title(0x0004001020023100, 2049, Region.JPN),
	Title(0x000400100002bf00, 3072, Region.JPN),
	Title(0x000400102002c800, 65, Region.JPN),
	Title(0x000400102002c900, 1, Region.JPN),
	Title(0x000400102002ca00, 0, Region.JPN),
	Title(0x000400102002cb00, 1, Region.JPN),
	Title(0x0004001b00010002, 0),
	Title(0x0004001b00010702, 4096),
	Title(0x0004001b00010802, 8192),
	Title(0x0004001b00018002, 8192),
	Title(0x0004001b00018102, 1025),
	Title(0x0004001b00018202, 2050),
	Title(0x0004003000008202, 31745),
	Title(0x0004003000008302, 6),
	Title(0x0004003000008402, 2049),
	Title(0x0004003000008602, 5121),
	Title(0x0004003000008702, 4097),
	Title(0x0004003020008802, 12289),
	Title(0x0004003000008a02, 7168),
	Title(0x0004003020008a03, 7169),
	Title(0x0004003000008d02, 6144),
	Title(0x0004003000008e02, 5121),
	Title(0x0004003000009502, 1031),
	Title(0x000400300000bc02, 4096),
	Title(0x000400300000c002, 4096),
	Title(0x000400302000c003, 1024),
	Title(0x000400300000c102, 3077),
	Title(0x000400300000c302, 4096),
	Title(0x000400300000c402, 3072),
	Title(0x000400300000c502, 7184),
	Title(0x000400302000c503, 1024),
	Title(0x000400300000c602, 22530),
	Title(0x000400300000cd02, 4097),
	Title(0x000400300000f602, 3072),
	Title(0x0004009b00010202, 0),
	Title(0x0004009b00010402, 5122),
	Title(0x0004009b00010602, 2052),
	Title(0x0004009b00011902, 0),
	Title(0x0004009b00012202, 16384),
	Title(0x0004009b00013202, 1024),
	Title(0x0004009b00014002, 0),
	Title(0x0004009b00014102, 1024),
	Title(0x0004009b00014202, 1024),
	Title(0x0004009b00014302, 1024),
	Title(0x0004009b00015202, 0),
	Title(0x000400db00010302, 9217),
	Title(0x000400db00010502, 23552),
	Title(0x000400db20016202, 784),
	Title(0x000400db00017202, 11520),
	Title(0x0004013000001502, 10245),
	Title(0x0004013020001503, 7169),
	Title(0x0004013020001602, 13313),
	Title(0x0004013000001702, 15360),
	Title(0x0004013020001703, 11265),
	Title(0x0004013000001802, 7168),
	Title(0x0004013020001803, 7169),
	Title(0x0004013000001a02, 7169),
	Title(0x0004013020001a03, 6145),
	Title(0x0004013000001b02, 3073),
	Title(0x0004013020001b03, 3073),
	Title(0x0004013020001c02, 14336),
	Title(0x0004013020001c03, 9217),
	Title(0x0004013000001d02, 10240),
	Title(0x0004013020001d03, 8193),
	Title(0x0004013020001e02, 5121),
	Title(0x0004013020001e03, 4097),
	Title(0x0004013020001f02, 9216),
	Title(0x0004013020001f03, 9217),
	Title(0x0004013000002002, 2048),
	Title(0x0004013000002102, 2048),
	Title(0x0004013020002103, 3073),
	Title(0x0004013020002202, 11264),
	Title(0x0004013020002203, 10241),
	Title(0x0004013020002302, 4096),
	Title(0x0004013020002303, 4097),
	Title(0x0004013000002402, 9216),
	Title(0x0004013020002403, 8193),
	Title(0x0004013000002602, 12288),
	Title(0x0004013000002702, 5120),
	Title(0x0004013020002703, 5121),
	Title(0x0004013000002802, 8192),
	Title(0x0004013000002902, 14336),
	Title(0x0004013020002903, 10241),
	Title(0x0004013000002a02, 2048),
	Title(0x0004013000002b02, 7169),
	Title(0x0004013000002c02, 14341),
	Title(0x0004013020002c03, 9217),
	Title(0x0004013000002d02, 11264),
	Title(0x0004013020002d03, 10241),
	Title(0x0004013000002e02, 8192),
	Title(0x0004013020002e03, 7169),
	Title(0x0004013000002f02, 9217),
	Title(0x0004013020002f03, 8194),
	Title(0x0004013000003102, 5120),
	Title(0x0004013020003103, 5121),
	Title(0x0004013000003202, 21504),
	Title(0x0004013020003203, 8193),
	Title(0x0004013000003302, 13313),
	Title(0x0004013020003303, 7169),
	Title(0x0004013000003402, 14337),
	Title(0x0004013000003502, 7168),
	Title(0x0004013000003702, 6148),
	Title(0x0004013000003802, 9216),
	Title(0x0004013020004002, 7168),
	Title(0x0004013020004102, 1024),
	Title(0x0004013020004202, 3072),
	Title(0x0004013000008002, 23553),
	Title(0x0004013020008003, 13313),
	Title(0x0004013820000002, 32673),
	Title(0x0004013820000003, 16081),
	Title(0x0004013820000102, 10962),
	Title(0x0004013820000202, 4816),
	Title(0x0004800542383841, 2048),
	Title(0x00048005484e4441, 1024),
	Title(0x0004800f484e4841, 11264),
	Title(0x0004800f484e4c41, 0)
)

# tid list validated against real console
_n3ds_usa = (
	Title(0x0004001000021000, 10241, Region.USA),
	Title(0x0004001000021100, 3073, Region.USA),
	Title(0x0004001000021200, 2064, Region.USA),
	Title(0x0004001020021300, 33, Region.USA),
	Title(0x0004001000021400, 5120, Region.USA),
	Title(0x0004001000021500, 4096, Region.USA),
	Title(0x0004001000021700, 2055, Region.USA),
	Title(0x0004001000021800, 5136, Region.USA),
	Title(0x0004001000021900, 28673, Region.USA),
	Title(0x0004001000021a00, 6156, Region.USA),
	Title(0x0004001000021b00, 1034, Region.USA),
	Title(0x0004001020021d00, 2049, Region.USA),
	Title(0x0004001000021e00, 1040, Region.USA),
	Title(0x0004001000021f00, 2049, Region.USA),
	Title(0x0004001020024100, 1025, Region.USA),
	Title(0x000400100002c000, 3072, Region.USA),
	Title(0x000400102002cf00, 48, Region.USA),
	Title(0x000400102002d100, 16, Region.USA),
	Title(0x000400102002d300, 0, Region.USA),
	Title(0x000400102002d500, 2, Region.USA),
	Title(0x0004001b00010002, 0),
	Title(0x0004001b00010702, 4096),
	Title(0x0004001b00010802, 8192),
	Title(0x0004001b00018002, 8192),
	Title(0x0004001b00018102, 1025),
	Title(0x0004001b00018202, 2050),
	Title(0x0004003000008a02, 7168),
	Title(0x0004003020008a03, 7169),
	Title(0x0004003000008b02, 6),
	Title(0x0004003000008f02, 29697),
	Title(0x0004003000009002, 2049),
	Title(0x0004003000009202, 5120),
	Title(0x0004003000009302, 4096),
	Title(0x0004003020009402, 12289),
	Title(0x0004003000009602, 6144),
	Title(0x0004003000009702, 4097),
	Title(0x0004003000009e02, 1031),
	Title(0x000400300000bd02, 4096),
	Title(0x000400300000c502, 7184),
	Title(0x000400302000c503, 1024),
	Title(0x000400300000c802, 4096),
	Title(0x000400302000c803, 0),
	Title(0x000400300000c902, 3077),
	Title(0x000400300000cb02, 4096),
	Title(0x000400300000cc02, 3072),
	Title(0x000400300000cd02, 4097),
	Title(0x000400300000ce02, 22530),
	Title(0x000400300000f602, 3072),
	Title(0x0004009b00010202, 0),
	Title(0x0004009b00010402, 5122),
	Title(0x0004009b00010602, 2052),
	Title(0x0004009b00011402, 0),
	Title(0x0004009b00011602, 0),
	Title(0x0004009b00011d02, 0),
	Title(0x0004009b00011e02, 0),
	Title(0x0004009b00012302, 15360),
	Title(0x0004009b00013302, 5123),
	Title(0x0004009b00014002, 0),
	Title(0x0004009b00014102, 1024),
	Title(0x0004009b00014202, 1024),
	Title(0x0004009b00014302, 1024),
	Title(0x0004009b00015302, 0),
	Title(0x000400db00010302, 9217),
	Title(0x000400db00010502, 23552),
	Title(0x000400db20016302, 784),
	Title(0x000400db00017302, 11520),
	Title(0x0004013000001502, 10245),
	Title(0x0004013020001503, 7169),
	Title(0x0004013020001602, 13313),
	Title(0x0004013000001702, 15360),
	Title(0x0004013020001703, 11265),
	Title(0x0004013000001802, 7168),
	Title(0x0004013020001803, 7169),
	Title(0x0004013000001a02, 7169),
	Title(0x0004013020001a03, 6145),
	Title(0x0004013000001b02, 3073),
	Title(0x0004013020001b03, 3073),
	Title(0x0004013020001c02, 14336),
	Title(0x0004013020001c03, 9217),
	Title(0x0004013000001d02, 10240),
	Title(0x0004013020001d03, 8193),
	Title(0x0004013020001e02, 5121),
	Title(0x0004013020001e03, 4097),
	Title(0x0004013020001f02, 9216),
	Title(0x0004013020001f03, 9217),
	Title(0x0004013000002002, 2048),
	Title(0x0004013000002102, 2048),
	Title(0x0004013020002103, 3073),
	Title(0x0004013020002202, 11264),
	Title(0x0004013020002203, 10241),
	Title(0x0004013020002302, 4096),
	Title(0x0004013020002303, 4097),
	Title(0x0004013000002402, 9216),
	Title(0x0004013020002403, 8193),
	Title(0x0004013000002602, 12288),
	Title(0x0004013000002702, 5120),
	Title(0x0004013020002703, 5121),
	Title(0x0004013000002802, 8192),
	Title(0x0004013000002902, 14336),
	Title(0x0004013020002903, 10241),
	Title(0x0004013000002a02, 2048),
	Title(0x0004013000002b02, 7169),
	Title(0x0004013000002c02, 14341),
	Title(0x0004013020002c03, 9217),
	Title(0x0004013000002d02, 11264),
	Title(0x0004013020002d03, 10241),
	Title(0x0004013000002e02, 8192),
	Title(0x0004013020002e03, 7169),
	Title(0x0004013000002f02, 9217),
	Title(0x0004013020002f03, 8194),
	Title(0x0004013000003102, 5120),
	Title(0x0004013020003103, 5121),
	Title(0x0004013000003202, 21504),
	Title(0x0004013020003203, 8193),
	Title(0x0004013000003302, 13313),
	Title(0x0004013020003303, 7169),
	Title(0x0004013000003402, 14337),
	Title(0x0004013000003502, 7168),
	Title(0x0004013000003702, 6148),
	Title(0x0004013000003802, 9216),
	Title(0x0004013020004002, 7168),
	Title(0x0004013020004102, 1024),
	Title(0x0004013020004202, 3072),
	Title(0x0004013000008002, 23553),
	Title(0x0004013020008003, 13313),
	Title(0x0004013820000002, 32673),
	Title(0x0004013820000003, 16081),
	Title(0x0004013820000102, 10962),
	Title(0x0004013820000202, 4816),
	Title(0x0004800542383841, 2048),
	Title(0x00048005484e4441, 1024),
	Title(0x0004800f484e4841, 11264),
	Title(0x0004800f484e4c41, 0)
)

# tid list validated against real console
_n3ds_eur = (
	Title(0x0004001000022000, 11281, Region.EUR),
	Title(0x0004001000022100, 3073, Region.EUR),
	Title(0x0004001000022200, 2064, Region.EUR),
	Title(0x0004001020022300, 1, Region.EUR),
	Title(0x0004001000022400, 5120, Region.EUR),
	Title(0x0004001000022500, 4096, Region.EUR),
	Title(0x0004001000022700, 2055, Region.EUR),
	Title(0x0004001000022800, 5122, Region.EUR),
	Title(0x0004001000022900, 28673, Region.EUR),
	Title(0x0004001000022a00, 6155, Region.EUR),
	Title(0x0004001000022b00, 1034, Region.EUR),
	Title(0x0004001020022d00, 2049, Region.EUR),
	Title(0x0004001000022e00, 1040, Region.EUR),
	Title(0x0004001000022f00, 2050, Region.EUR),
	Title(0x0004001020025100, 1025, Region.EUR),
	Title(0x000400100002c100, 3072, Region.EUR),
	Title(0x000400102002d000, 48, Region.EUR),
	Title(0x000400102002d200, 1, Region.EUR),
	Title(0x000400102002d400, 2, Region.EUR),
	Title(0x000400102002d600, 2, Region.EUR),
	Title(0x0004001b00010002, 0),
	Title(0x0004001b00010702, 4096),
	Title(0x0004001b00010802, 8192),
	Title(0x0004001b00018002, 8192),
	Title(0x0004001b00018102, 1025),
	Title(0x0004001b00018202, 2050),
	Title(0x0004003000008a02, 7168),
	Title(0x0004003020008a03, 7169),
	Title(0x0004003000009802, 29696),
	Title(0x0004003000009902, 2049),
	Title(0x0004003000009b02, 5120),
	Title(0x0004003000009c02, 4096),
	Title(0x0004003020009d02, 12289),
	Title(0x0004003000009f02, 6144),
	Title(0x000400300000a002, 4097),
	Title(0x000400300000b902, 1031),
	Title(0x000400300000ba02, 6),
	Title(0x000400300000be02, 4096),
	Title(0x000400300000c502, 7184),
	Title(0x000400302000c503, 1024),
	Title(0x000400300000cd02, 4097),
	Title(0x000400300000d002, 4096),
	Title(0x000400302000d003, 0),
	Title(0x000400300000d102, 3077),
	Title(0x000400300000d302, 4096),
	Title(0x000400300000d402, 3072),
	Title(0x000400300000d602, 22530),
	Title(0x000400300000f602, 3072),
	Title(0x0004009b00010202, 0),
	Title(0x0004009b00010402, 5122),
	Title(0x0004009b00010602, 2052),
	Title(0x0004009b00011202, 0),
	Title(0x0004009b00011302, 0),
	Title(0x0004009b00011502, 0),
	Title(0x0004009b00011702, 0),
	Title(0x0004009b00011802, 0),
	Title(0x0004009b00011b02, 0),
	Title(0x0004009b00011c02, 0),
	Title(0x0004009b00011d02, 0),
	Title(0x0004009b00012102, 15360),
	Title(0x0004009b00013102, 8194),
	Title(0x0004009b00014002, 0),
	Title(0x0004009b00014102, 1024),
	Title(0x0004009b00014202, 1024),
	Title(0x0004009b00014302, 1024),
	Title(0x0004009b00015102, 2048),
	Title(0x000400db00010302, 9217),
	Title(0x000400db00010502, 23552),
	Title(0x000400db20016102, 784),
	Title(0x000400db00017102, 11520),
	Title(0x0004013000001502, 10245),
	Title(0x0004013020001503, 7169),
	Title(0x0004013020001602, 13313),
	Title(0x0004013000001702, 15360),
	Title(0x0004013020001703, 11265),
	Title(0x0004013000001802, 7168),
	Title(0x0004013020001803, 7169),
	Title(0x0004013000001a02, 7169),
	Title(0x0004013020001a03, 6145),
	Title(0x0004013000001b02, 3073),
	Title(0x0004013020001b03, 3073),
	Title(0x0004013020001c02, 14336),
	Title(0x0004013020001c03, 9217),
	Title(0x0004013000001d02, 10240),
	Title(0x0004013020001d03, 8193),
	Title(0x0004013020001e02, 5121),
	Title(0x0004013020001e03, 4097),
	Title(0x0004013020001f02, 9216),
	Title(0x0004013020001f03, 9217),
	Title(0x0004013000002002, 2048),
	Title(0x0004013000002102, 2048),
	Title(0x0004013020002103, 3073),
	Title(0x0004013020002202, 11264),
	Title(0x0004013020002203, 10241),
	Title(0x0004013020002302, 4096),
	Title(0x0004013020002303, 4097),
	Title(0x0004013000002402, 9216),
	Title(0x0004013020002403, 8193),
	Title(0x0004013000002602, 12288),
	Title(0x0004013000002702, 5120),
	Title(0x0004013020002703, 5121),
	Title(0x0004013000002802, 8192),
	Title(0x0004013000002902, 14336),
	Title(0x0004013020002903, 10241),
	Title(0x0004013000002a02, 2048),
	Title(0x0004013000002b02, 7169),
	Title(0x0004013000002c02, 14341),
	Title(0x0004013020002c03, 9217),
	Title(0x0004013000002d02, 11264),
	Title(0x0004013020002d03, 10241),
	Title(0x0004013000002e02, 8192),
	Title(0x0004013020002e03, 7169),
	Title(0x0004013000002f02, 9217),
	Title(0x0004013020002f03, 8194),
	Title(0x0004013000003102, 5120),
	Title(0x0004013020003103, 5121),
	Title(0x0004013000003202, 21504),
	Title(0x0004013020003203, 8193),
	Title(0x0004013000003302, 13313),
	Title(0x0004013020003303, 7169),
	Title(0x0004013000003402, 14337),
	Title(0x0004013000003502, 7168),
	Title(0x0004013000003702, 6148),
	Title(0x0004013000003802, 9216),
	Title(0x0004013020004002, 7168),
	Title(0x0004013020004102, 1024),
	Title(0x0004013020004202, 3072),
	Title(0x0004013000008002, 23553),
	Title(0x0004013020008003, 13313),
	Title(0x0004013820000002, 32673),
	Title(0x0004013820000003, 16081),
	Title(0x0004013820000102, 10962),
	Title(0x0004013820000202, 4816),
	Title(0x0004800542383841, 2048),
	Title(0x00048005484e4441, 1024),
	Title(0x0004800f484e4841, 11264),
	Title(0x0004800f484e4c41, 0)
)

# validated against ctrtransfer image + NUS + o3ds kor for twl titles
_n3ds_kor = (
	Title(0x0004001000027000, 7168, Region.KOR),
	Title(0x0004001000027100, 2048, Region.KOR),
	Title(0x0004001000027200, 16, Region.KOR),
	Title(0x0004001020027300, 16, Region.KOR),
	Title(0x0004001000027400, 3072, Region.KOR),
	Title(0x0004001000027500, 1024, Region.KOR),
	Title(0x0004001000027700, 16, Region.KOR),
	Title(0x0004001000027800, 5120, Region.KOR),
	Title(0x0004001000027900, 28673, Region.KOR),
	Title(0x0004001000027a00, 4106, Region.KOR),
	Title(0x0004001020027d00, 2049, Region.KOR),
	Title(0x0004001000027e00, 16, Region.KOR),
	Title(0x0004001000027f00, 1025, Region.KOR),
	Title(0x000400102002d700, 32, Region.KOR),
	Title(0x000400102002d800, 2, Region.KOR),
	Title(0x000400102002d900, 2, Region.KOR),
	Title(0x000400102002da00, 1, Region.KOR),
	Title(0x0004001b00010002, 0),
	Title(0x0004001b00010702, 4096),
	Title(0x0004001b00010802, 8192),
	Title(0x0004003000008a02, 7168),
	Title(0x0004003020008a03, 7169),
	Title(0x0004003000008c02, 1031),
	Title(0x000400300000a902, 15361),
	Title(0x000400300000aa02, 1024),
	Title(0x000400300000ac02, 6144),
	Title(0x000400300000ad02, 4096),
	Title(0x000400302000ae02, 12289),
	Title(0x000400300000af02, 3072),
	Title(0x000400300000b002, 2048),
	Title(0x000400300000cf02, 1027),
	Title(0x000400302000cf03, 1),
	Title(0x000400300000d502, 3072),
	Title(0x000400300000de02, 1025),
	Title(0x000400302000de03, 1),
	Title(0x000400300000df02, 1026),
	Title(0x000400300000e102, 1025),
	Title(0x000400300000e202, 3072),
	Title(0x000400300000e302, 22530),
	Title(0x0004009b00010202, 0),
	Title(0x0004009b00010402, 5122),
	Title(0x0004009b00010602, 2052),
	Title(0x0004009b00011a02, 1),
	Title(0x0004009b00012502, 12288),
	Title(0x0004009b00013502, 1025),
	Title(0x0004009b00014002, 0),
	Title(0x0004009b00014102, 1024),
	Title(0x0004009b00014202, 1024),
	Title(0x0004009b00014302, 1024),
	Title(0x0004009b00015502, 1024),
	Title(0x000400db00010302, 9217),
	Title(0x000400db00010502, 23552),
	Title(0x000400db20016502, 672),
	Title(0x000400db00017502, 11520),
	Title(0x0004013000001502, 10245),
	Title(0x0004013020001503, 7169),
	Title(0x0004013020001602, 13313),
	Title(0x0004013000001702, 15360),
	Title(0x0004013020001703, 11265),
	Title(0x0004013000001802, 7168),
	Title(0x0004013020001803, 7169),
	Title(0x0004013000001a02, 7169),
	Title(0x0004013020001a03, 6145),
	Title(0x0004013000001b02, 3073),
	Title(0x0004013020001b03, 3073),
	Title(0x0004013020001c02, 14336),
	Title(0x0004013020001c03, 9217),
	Title(0x0004013000001d02, 10240),
	Title(0x0004013020001d03, 8193),
	Title(0x0004013020001e02, 5121),
	Title(0x0004013020001e03, 4097),
	Title(0x0004013020001f02, 9216),
	Title(0x0004013020001f03, 9217),
	Title(0x0004013000002002, 2048),
	Title(0x0004013000002102, 2048),
	Title(0x0004013020002103, 3073),
	Title(0x0004013020002202, 11264),
	Title(0x0004013020002203, 10241),
	Title(0x0004013020002302, 4096),
	Title(0x0004013020002303, 4097),
	Title(0x0004013000002402, 9216),
	Title(0x0004013020002403, 8193),
	Title(0x0004013000002602, 12288),
	Title(0x0004013000002702, 5120),
	Title(0x0004013020002703, 5121),
	Title(0x0004013000002802, 8192),
	Title(0x0004013000002902, 14336),
	Title(0x0004013020002903, 10241),
	Title(0x0004013000002a02, 2048),
	Title(0x0004013000002b02, 7169),
	Title(0x0004013000002c02, 14341),
	Title(0x0004013020002c03, 9217),
	Title(0x0004013000002d02, 11264),
	Title(0x0004013020002d03, 10241),
	Title(0x0004013000002e02, 8192),
	Title(0x0004013020002e03, 7169),
	Title(0x0004013000002f02, 9217),
	Title(0x0004013020002f03, 8194),
	Title(0x0004013000003102, 5120),
	Title(0x0004013020003103, 5121),
	Title(0x0004013000003202, 21504),
	Title(0x0004013020003203, 8193),
	Title(0x0004013000003302, 13313),
	Title(0x0004013020003303, 7169),
	Title(0x0004013000003402, 14337),
	Title(0x0004013000003502, 7168),
	Title(0x0004013000003702, 6148),
	Title(0x0004013000003802, 9216),
	Title(0x0004013020004002, 7168),
	Title(0x0004013020004102, 1024),
	Title(0x0004013020004202, 3072),
	Title(0x0004013000008002, 23553),
	Title(0x0004013020008003, 13313),
	Title(0x0004013820000002, 32673),
	Title(0x0004013820000003, 16081),
	Title(0x0004013820000102, 10962),
	Title(0x0004013820000202, 4816),
	Title(0x0004800542383841, 2048),
	Title(0x00048005484e444b, 1024),
	Title(0x0004800f484e4841, 11264),
	Title(0x0004800f484e4c41, 0)
)

o3ds_sys_titles = (
	_o3ds_jpn,
	_o3ds_usa,
	_o3ds_eur,
	None,
	_o3ds_chn,
	_o3ds_kor,
	_o3ds_twn
)

n3ds_sys_titles = (
	_n3ds_jpn,
	_n3ds_usa,
	_n3ds_eur,
	None,
	None,
	_n3ds_kor,
	None
)

all_sys_tids = tuple(sorted(list(set(
	[int(j) for i in (i for i in (n3ds_sys_titles + o3ds_sys_titles) if i is not None) for j in i if i]
))))