import torch
import torch.nn as nn
import torch.nn.functional as F
import neural_dream.neural_dream_core.helper_layers as helper_layers


class ResNet_50_1by2_nsfw(nn.Module):

    def __init__(self):
        super(ResNet_50_1by2_nsfw, self).__init__()
        self.conv_1 = nn.Conv2d(in_channels=3, out_channels=64, kernel_size=(7, 7), stride=(2, 2), groups=1, bias=True)
        self.bn_1 = nn.BatchNorm2d(num_features=64, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage0_block0_branch2a = nn.Conv2d(in_channels=64, out_channels=32, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.conv_stage0_block0_proj_shortcut = nn.Conv2d(in_channels=64, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage0_block0_branch2a = nn.BatchNorm2d(num_features=32, eps=9.999999747378752e-06, momentum=0.0)
        self.bn_stage0_block0_proj_shortcut = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage0_block0_branch2b = nn.Conv2d(in_channels=32, out_channels=32, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage0_block0_branch2b = nn.BatchNorm2d(num_features=32, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage0_block0_branch2c = nn.Conv2d(in_channels=32, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage0_block0_branch2c = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage0_block1_branch2a = nn.Conv2d(in_channels=128, out_channels=32, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage0_block1_branch2a = nn.BatchNorm2d(num_features=32, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage0_block1_branch2b = nn.Conv2d(in_channels=32, out_channels=32, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage0_block1_branch2b = nn.BatchNorm2d(num_features=32, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage0_block1_branch2c = nn.Conv2d(in_channels=32, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage0_block1_branch2c = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage0_block2_branch2a = nn.Conv2d(in_channels=128, out_channels=32, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage0_block2_branch2a = nn.BatchNorm2d(num_features=32, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage0_block2_branch2b = nn.Conv2d(in_channels=32, out_channels=32, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage0_block2_branch2b = nn.BatchNorm2d(num_features=32, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage0_block2_branch2c = nn.Conv2d(in_channels=32, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage0_block2_branch2c = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block0_proj_shortcut = nn.Conv2d(in_channels=128, out_channels=256, kernel_size=(1, 1), stride=(2, 2), groups=1, bias=True)
        self.conv_stage1_block0_branch2a = nn.Conv2d(in_channels=128, out_channels=64, kernel_size=(1, 1), stride=(2, 2), groups=1, bias=True)
        self.bn_stage1_block0_proj_shortcut = nn.BatchNorm2d(num_features=256, eps=9.999999747378752e-06, momentum=0.0)
        self.bn_stage1_block0_branch2a = nn.BatchNorm2d(num_features=64, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block0_branch2b = nn.Conv2d(in_channels=64, out_channels=64, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage1_block0_branch2b = nn.BatchNorm2d(num_features=64, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block0_branch2c = nn.Conv2d(in_channels=64, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage1_block0_branch2c = nn.BatchNorm2d(num_features=256, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block1_branch2a = nn.Conv2d(in_channels=256, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage1_block1_branch2a = nn.BatchNorm2d(num_features=64, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block1_branch2b = nn.Conv2d(in_channels=64, out_channels=64, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage1_block1_branch2b = nn.BatchNorm2d(num_features=64, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block1_branch2c = nn.Conv2d(in_channels=64, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage1_block1_branch2c = nn.BatchNorm2d(num_features=256, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block2_branch2a = nn.Conv2d(in_channels=256, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage1_block2_branch2a = nn.BatchNorm2d(num_features=64, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block2_branch2b = nn.Conv2d(in_channels=64, out_channels=64, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage1_block2_branch2b = nn.BatchNorm2d(num_features=64, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block2_branch2c = nn.Conv2d(in_channels=64, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage1_block2_branch2c = nn.BatchNorm2d(num_features=256, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block3_branch2a = nn.Conv2d(in_channels=256, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage1_block3_branch2a = nn.BatchNorm2d(num_features=64, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block3_branch2b = nn.Conv2d(in_channels=64, out_channels=64, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage1_block3_branch2b = nn.BatchNorm2d(num_features=64, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage1_block3_branch2c = nn.Conv2d(in_channels=64, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage1_block3_branch2c = nn.BatchNorm2d(num_features=256, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block0_proj_shortcut = nn.Conv2d(in_channels=256, out_channels=512, kernel_size=(1, 1), stride=(2, 2), groups=1, bias=True)
        self.conv_stage2_block0_branch2a = nn.Conv2d(in_channels=256, out_channels=128, kernel_size=(1, 1), stride=(2, 2), groups=1, bias=True)
        self.bn_stage2_block0_proj_shortcut = nn.BatchNorm2d(num_features=512, eps=9.999999747378752e-06, momentum=0.0)
        self.bn_stage2_block0_branch2a = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block0_branch2b = nn.Conv2d(in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block0_branch2b = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block0_branch2c = nn.Conv2d(in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block0_branch2c = nn.BatchNorm2d(num_features=512, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block1_branch2a = nn.Conv2d(in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block1_branch2a = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block1_branch2b = nn.Conv2d(in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block1_branch2b = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block1_branch2c = nn.Conv2d(in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block1_branch2c = nn.BatchNorm2d(num_features=512, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block2_branch2a = nn.Conv2d(in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block2_branch2a = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block2_branch2b = nn.Conv2d(in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block2_branch2b = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block2_branch2c = nn.Conv2d(in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block2_branch2c = nn.BatchNorm2d(num_features=512, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block3_branch2a = nn.Conv2d(in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block3_branch2a = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block3_branch2b = nn.Conv2d(in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block3_branch2b = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block3_branch2c = nn.Conv2d(in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block3_branch2c = nn.BatchNorm2d(num_features=512, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block4_branch2a = nn.Conv2d(in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block4_branch2a = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block4_branch2b = nn.Conv2d(in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block4_branch2b = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block4_branch2c = nn.Conv2d(in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block4_branch2c = nn.BatchNorm2d(num_features=512, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block5_branch2a = nn.Conv2d(in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block5_branch2a = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block5_branch2b = nn.Conv2d(in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block5_branch2b = nn.BatchNorm2d(num_features=128, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage2_block5_branch2c = nn.Conv2d(in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage2_block5_branch2c = nn.BatchNorm2d(num_features=512, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage3_block0_proj_shortcut = nn.Conv2d(in_channels=512, out_channels=1024, kernel_size=(1, 1), stride=(2, 2), groups=1, bias=True)
        self.conv_stage3_block0_branch2a = nn.Conv2d(in_channels=512, out_channels=256, kernel_size=(1, 1), stride=(2, 2), groups=1, bias=True)
        self.bn_stage3_block0_proj_shortcut = nn.BatchNorm2d(num_features=1024, eps=9.999999747378752e-06, momentum=0.0)
        self.bn_stage3_block0_branch2a = nn.BatchNorm2d(num_features=256, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage3_block0_branch2b = nn.Conv2d(in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage3_block0_branch2b = nn.BatchNorm2d(num_features=256, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage3_block0_branch2c = nn.Conv2d(in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage3_block0_branch2c = nn.BatchNorm2d(num_features=1024, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage3_block1_branch2a = nn.Conv2d(in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage3_block1_branch2a = nn.BatchNorm2d(num_features=256, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage3_block1_branch2b = nn.Conv2d(in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage3_block1_branch2b = nn.BatchNorm2d(num_features=256, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage3_block1_branch2c = nn.Conv2d(in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage3_block1_branch2c = nn.BatchNorm2d(num_features=1024, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage3_block2_branch2a = nn.Conv2d(in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage3_block2_branch2a = nn.BatchNorm2d(num_features=256, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage3_block2_branch2b = nn.Conv2d(in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=True)
        self.bn_stage3_block2_branch2b = nn.BatchNorm2d(num_features=256, eps=9.999999747378752e-06, momentum=0.0)
        self.conv_stage3_block2_branch2c = nn.Conv2d(in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=True)
        self.bn_stage3_block2_branch2c = nn.BatchNorm2d(num_features=1024, eps=9.999999747378752e-06, momentum=0.0)
        self.fc_nsfw_1 = nn.Linear(in_features = 1024, out_features = 2, bias = True)


    def add_layers(self):
        self.eltwise_stage0_block0 = helper_layers.AdditionLayer()
        self.eltwise_stage0_block1 = helper_layers.AdditionLayer()
        self.eltwise_stage0_block2 = helper_layers.AdditionLayer()
        self.eltwise_stage1_block0 = helper_layers.AdditionLayer()
        self.eltwise_stage1_block1 = helper_layers.AdditionLayer()
        self.eltwise_stage1_block2 = helper_layers.AdditionLayer()
        self.eltwise_stage1_block3 = helper_layers.AdditionLayer()
        self.eltwise_stage2_block0 = helper_layers.AdditionLayer()
        self.eltwise_stage2_block1 = helper_layers.AdditionLayer()
        self.eltwise_stage2_block2 = helper_layers.AdditionLayer()
        self.eltwise_stage2_block3 = helper_layers.AdditionLayer()
        self.eltwise_stage2_block4 = helper_layers.AdditionLayer()
        self.eltwise_stage2_block5 = helper_layers.AdditionLayer()
        self.eltwise_stage3_block0 = helper_layers.AdditionLayer()
        self.eltwise_stage3_block1 = helper_layers.AdditionLayer()
        self.eltwise_stage3_block2 = helper_layers.AdditionLayer()

        self.relu_1 = helper_layers.ReluLayer()
        self.relu_stage0_block0_branch2a = helper_layers.ReluLayer()
        self.relu_stage0_block0_branch2b = helper_layers.ReluLayer()
        self.relu_stage0_block0 = helper_layers.ReluLayer()
        self.relu_stage0_block1_branch2a = helper_layers.ReluLayer()
        self.relu_stage0_block1_branch2b = helper_layers.ReluLayer()
        self.relu_stage0_block1 = helper_layers.ReluLayer()
        self.relu_stage0_block2_branch2a = helper_layers.ReluLayer()
        self.relu_stage0_block2_branch2b = helper_layers.ReluLayer()
        self.relu_stage0_block2 = helper_layers.ReluLayer()
        self.relu_stage1_block0_branch2a = helper_layers.ReluLayer()
        self.relu_stage1_block0_branch2b = helper_layers.ReluLayer()
        self.relu_stage1_block0 = helper_layers.ReluLayer()
        self.relu_stage1_block1_branch2a = helper_layers.ReluLayer()
        self.relu_stage1_block1_branch2b = helper_layers.ReluLayer()
        self.relu_stage1_block1 = helper_layers.ReluLayer()
        self.relu_stage1_block2_branch2a = helper_layers.ReluLayer()
        self.relu_stage1_block2_branch2b = helper_layers.ReluLayer()
        self.relu_stage1_block2 = helper_layers.ReluLayer()
        self.relu_stage1_block3_branch2a = helper_layers.ReluLayer()
        self.relu_stage1_block3_branch2b = helper_layers.ReluLayer()
        self.relu_stage1_block3 = helper_layers.ReluLayer()
        self.relu_stage2_block0_branch2a = helper_layers.ReluLayer()
        self.relu_stage2_block0_branch2b = helper_layers.ReluLayer()
        self.relu_stage2_block0 = helper_layers.ReluLayer()
        self.relu_stage2_block1_branch2a = helper_layers.ReluLayer()
        self.relu_stage2_block1_branch2b = helper_layers.ReluLayer()
        self.relu_stage2_block1 = helper_layers.ReluLayer()
        self.relu_stage2_block2_branch2a = helper_layers.ReluLayer()
        self.relu_stage2_block2_branch2b = helper_layers.ReluLayer()
        self.relu_stage2_block2 = helper_layers.ReluLayer()
        self.relu_stage2_block3_branch2a = helper_layers.ReluLayer()
        self.relu_stage2_block3_branch2b = helper_layers.ReluLayer()
        self.relu_stage2_block3 = helper_layers.ReluLayer()
        self.relu_stage2_block4_branch2a = helper_layers.ReluLayer()
        self.relu_stage2_block4_branch2b = helper_layers.ReluLayer()
        self.relu_stage2_block4 = helper_layers.ReluLayer()
        self.relu_stage2_block5_branch2a = helper_layers.ReluLayer()
        self.relu_stage2_block5_branch2b = helper_layers.ReluLayer()
        self.relu_stage2_block5 = helper_layers.ReluLayer()
        self.relu_stage3_block0_branch2a = helper_layers.ReluLayer()
        self.relu_stage3_block0_branch2b = helper_layers.ReluLayer()
        self.relu_stage3_block0 = helper_layers.ReluLayer()
        self.relu_stage3_block1_branch2a = helper_layers.ReluLayer()
        self.relu_stage3_block1_branch2b = helper_layers.ReluLayer()
        self.relu_stage3_block1 = helper_layers.ReluLayer()
        self.relu_stage3_block2_branch2a = helper_layers.ReluLayer()
        self.relu_stage3_block2_branch2b = helper_layers.ReluLayer()
        self.relu_stage3_block2 = helper_layers.ReluLayer()

        self.conv_1_pad = helper_layers.PadLayer()
        self.pool1_pad = helper_layers.PadLayer()
        self.conv_stage0_block0_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage0_block1_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage0_block2_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage1_block0_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage1_block1_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage1_block2_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage1_block3_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage2_block0_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage2_block1_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage2_block2_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage2_block3_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage2_block4_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage2_block5_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage3_block0_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage3_block1_branch2b_pad = helper_layers.PadLayer()
        self.conv_stage3_block2_branch2b_pad = helper_layers.PadLayer()

        self.pool1 = helper_layers.MaxPool2dLayer()

        self.prob = helper_layers.SoftMaxLayer()


    def forward(self, input):
        conv_1_pad      = self.conv_1_pad(input, (3, 3, 3, 3))
        conv_1          = self.conv_1(conv_1_pad)
        bn_1            = self.bn_1(conv_1)
        relu_1          = self.relu_1(bn_1)
        pool1_pad       = self.pool1_pad(relu_1, (0, 1, 0, 1), value=float('-inf'))
        pool1           = self.pool1(pool1_pad, kernel_size=(3, 3), stride=(2, 2), padding=0, ceil_mode=False)
        conv_stage0_block0_branch2a = self.conv_stage0_block0_branch2a(pool1)
        conv_stage0_block0_proj_shortcut = self.conv_stage0_block0_proj_shortcut(pool1)
        bn_stage0_block0_branch2a = self.bn_stage0_block0_branch2a(conv_stage0_block0_branch2a)
        bn_stage0_block0_proj_shortcut = self.bn_stage0_block0_proj_shortcut(conv_stage0_block0_proj_shortcut)
        relu_stage0_block0_branch2a = self.relu_stage0_block0_branch2a(bn_stage0_block0_branch2a)
        conv_stage0_block0_branch2b_pad = self.conv_stage0_block0_branch2b_pad(relu_stage0_block0_branch2a, (1, 1, 1, 1))
        conv_stage0_block0_branch2b = self.conv_stage0_block0_branch2b(conv_stage0_block0_branch2b_pad)
        bn_stage0_block0_branch2b = self.bn_stage0_block0_branch2b(conv_stage0_block0_branch2b)
        relu_stage0_block0_branch2b = self.relu_stage0_block0_branch2b(bn_stage0_block0_branch2b)
        conv_stage0_block0_branch2c = self.conv_stage0_block0_branch2c(relu_stage0_block0_branch2b)
        bn_stage0_block0_branch2c = self.bn_stage0_block0_branch2c(conv_stage0_block0_branch2c)
        eltwise_stage0_block0 = self.eltwise_stage0_block0(bn_stage0_block0_proj_shortcut, bn_stage0_block0_branch2c)
        relu_stage0_block0 = self.relu_stage0_block0(eltwise_stage0_block0)
        conv_stage0_block1_branch2a = self.conv_stage0_block1_branch2a(relu_stage0_block0)
        bn_stage0_block1_branch2a = self.bn_stage0_block1_branch2a(conv_stage0_block1_branch2a)
        relu_stage0_block1_branch2a = self.relu_stage0_block1_branch2a(bn_stage0_block1_branch2a)
        conv_stage0_block1_branch2b_pad = self.conv_stage0_block1_branch2b_pad(relu_stage0_block1_branch2a, (1, 1, 1, 1))
        conv_stage0_block1_branch2b = self.conv_stage0_block1_branch2b(conv_stage0_block1_branch2b_pad)
        bn_stage0_block1_branch2b = self.bn_stage0_block1_branch2b(conv_stage0_block1_branch2b)
        relu_stage0_block1_branch2b = self.relu_stage0_block1_branch2b(bn_stage0_block1_branch2b)
        conv_stage0_block1_branch2c = self.conv_stage0_block1_branch2c(relu_stage0_block1_branch2b)
        conv_stage0_block1_branch2c = self.conv_stage0_block1_branch2c(relu_stage0_block1_branch2b)
        bn_stage0_block1_branch2c = self.bn_stage0_block1_branch2c(conv_stage0_block1_branch2c)
        eltwise_stage0_block1 = self.eltwise_stage0_block1(relu_stage0_block0, bn_stage0_block1_branch2c)
        relu_stage0_block1 = self.relu_stage0_block1(eltwise_stage0_block1)
        conv_stage0_block2_branch2a = self.conv_stage0_block2_branch2a(relu_stage0_block1)
        bn_stage0_block2_branch2a = self.bn_stage0_block2_branch2a(conv_stage0_block2_branch2a)
        relu_stage0_block2_branch2a = self.relu_stage0_block2_branch2a(bn_stage0_block2_branch2a)
        conv_stage0_block2_branch2b_pad = self.conv_stage0_block2_branch2b_pad(relu_stage0_block2_branch2a, (1, 1, 1, 1))
        conv_stage0_block2_branch2b = self.conv_stage0_block2_branch2b(conv_stage0_block2_branch2b_pad)
        bn_stage0_block2_branch2b = self.bn_stage0_block2_branch2b(conv_stage0_block2_branch2b)
        relu_stage0_block2_branch2b = self.relu_stage0_block2_branch2b(bn_stage0_block2_branch2b)
        conv_stage0_block2_branch2c = self.conv_stage0_block2_branch2c(relu_stage0_block2_branch2b)
        bn_stage0_block2_branch2c = self.bn_stage0_block2_branch2c(conv_stage0_block2_branch2c)
        eltwise_stage0_block2 = self.eltwise_stage0_block2(relu_stage0_block1, bn_stage0_block2_branch2c)
        relu_stage0_block2 = self.relu_stage0_block2(eltwise_stage0_block2)
        conv_stage1_block0_proj_shortcut = self.conv_stage1_block0_proj_shortcut(relu_stage0_block2)
        conv_stage1_block0_branch2a = self.conv_stage1_block0_branch2a(relu_stage0_block2)
        bn_stage1_block0_proj_shortcut = self.bn_stage1_block0_proj_shortcut(conv_stage1_block0_proj_shortcut)
        bn_stage1_block0_branch2a = self.bn_stage1_block0_branch2a(conv_stage1_block0_branch2a)
        relu_stage1_block0_branch2a = self.relu_stage1_block0_branch2a(bn_stage1_block0_branch2a)
        conv_stage1_block0_branch2b_pad = self.conv_stage1_block0_branch2b_pad(relu_stage1_block0_branch2a, (1, 1, 1, 1))
        conv_stage1_block0_branch2b = self.conv_stage1_block0_branch2b(conv_stage1_block0_branch2b_pad)
        bn_stage1_block0_branch2b = self.bn_stage1_block0_branch2b(conv_stage1_block0_branch2b)
        relu_stage1_block0_branch2b = self.relu_stage1_block0_branch2b(bn_stage1_block0_branch2b)
        conv_stage1_block0_branch2c = self.conv_stage1_block0_branch2c(relu_stage1_block0_branch2b)
        bn_stage1_block0_branch2c = self.bn_stage1_block0_branch2c(conv_stage1_block0_branch2c)
        eltwise_stage1_block0 = self.eltwise_stage1_block0(bn_stage1_block0_proj_shortcut, bn_stage1_block0_branch2c)
        relu_stage1_block0 = self.relu_stage1_block0(eltwise_stage1_block0)
        conv_stage1_block1_branch2a = self.conv_stage1_block1_branch2a(relu_stage1_block0)
        bn_stage1_block1_branch2a = self.bn_stage1_block1_branch2a(conv_stage1_block1_branch2a)
        relu_stage1_block1_branch2a = self.relu_stage1_block1_branch2a(bn_stage1_block1_branch2a)
        conv_stage1_block1_branch2b_pad = self.conv_stage1_block1_branch2b_pad(relu_stage1_block1_branch2a, (1, 1, 1, 1))
        conv_stage1_block1_branch2b = self.conv_stage1_block1_branch2b(conv_stage1_block1_branch2b_pad)
        bn_stage1_block1_branch2b = self.bn_stage1_block1_branch2b(conv_stage1_block1_branch2b)
        relu_stage1_block1_branch2b = self.relu_stage1_block1_branch2b(bn_stage1_block1_branch2b)
        conv_stage1_block1_branch2c = self.conv_stage1_block1_branch2c(relu_stage1_block1_branch2b)
        bn_stage1_block1_branch2c = self.bn_stage1_block1_branch2c(conv_stage1_block1_branch2c)
        eltwise_stage1_block1 = relu_stage1_block0 + bn_stage1_block1_branch2c
        relu_stage1_block1 = self.relu_stage1_block1(eltwise_stage1_block1)
        conv_stage1_block2_branch2a = self.conv_stage1_block2_branch2a(relu_stage1_block1)
        bn_stage1_block2_branch2a = self.bn_stage1_block2_branch2a(conv_stage1_block2_branch2a)
        relu_stage1_block2_branch2a = self.relu_stage1_block2_branch2a(bn_stage1_block2_branch2a)
        conv_stage1_block2_branch2b_pad = self.conv_stage1_block2_branch2b_pad(relu_stage1_block2_branch2a, (1, 1, 1, 1))
        conv_stage1_block2_branch2b = self.conv_stage1_block2_branch2b(conv_stage1_block2_branch2b_pad)
        bn_stage1_block2_branch2b = self.bn_stage1_block2_branch2b(conv_stage1_block2_branch2b)
        relu_stage1_block2_branch2b = self.relu_stage1_block2_branch2b(bn_stage1_block2_branch2b)
        conv_stage1_block2_branch2c = self.conv_stage1_block2_branch2c(relu_stage1_block2_branch2b)
        bn_stage1_block2_branch2c = self.bn_stage1_block2_branch2c(conv_stage1_block2_branch2c)
        eltwise_stage1_block2 = self.eltwise_stage1_block2(relu_stage1_block1, bn_stage1_block2_branch2c)
        relu_stage1_block2 = self.relu_stage1_block2(eltwise_stage1_block2)
        conv_stage1_block3_branch2a = self.conv_stage1_block3_branch2a(relu_stage1_block2)
        bn_stage1_block3_branch2a = self.bn_stage1_block3_branch2a(conv_stage1_block3_branch2a)
        relu_stage1_block3_branch2a = self.relu_stage1_block3_branch2a(bn_stage1_block3_branch2a)
        conv_stage1_block3_branch2b_pad = self.conv_stage1_block3_branch2b_pad(relu_stage1_block3_branch2a, (1, 1, 1, 1))
        conv_stage1_block3_branch2b = self.conv_stage1_block3_branch2b(conv_stage1_block3_branch2b_pad)
        bn_stage1_block3_branch2b = self.bn_stage1_block3_branch2b(conv_stage1_block3_branch2b)
        relu_stage1_block3_branch2b = self.relu_stage1_block3_branch2b(bn_stage1_block3_branch2b)
        conv_stage1_block3_branch2c = self.conv_stage1_block3_branch2c(relu_stage1_block3_branch2b)
        bn_stage1_block3_branch2c = self.bn_stage1_block3_branch2c(conv_stage1_block3_branch2c)
        eltwise_stage1_block3 = self.eltwise_stage1_block3(relu_stage1_block2, bn_stage1_block3_branch2c)
        relu_stage1_block3 = self.relu_stage1_block3(eltwise_stage1_block3)
        conv_stage2_block0_proj_shortcut = self.conv_stage2_block0_proj_shortcut(relu_stage1_block3)
        conv_stage2_block0_branch2a = self.conv_stage2_block0_branch2a(relu_stage1_block3)
        bn_stage2_block0_proj_shortcut = self.bn_stage2_block0_proj_shortcut(conv_stage2_block0_proj_shortcut)
        bn_stage2_block0_branch2a = self.bn_stage2_block0_branch2a(conv_stage2_block0_branch2a)
        relu_stage2_block0_branch2a = self.relu_stage2_block0_branch2a(bn_stage2_block0_branch2a)
        conv_stage2_block0_branch2b_pad = self.conv_stage2_block0_branch2b_pad(relu_stage2_block0_branch2a, (1, 1, 1, 1))
        conv_stage2_block0_branch2b = self.conv_stage2_block0_branch2b(conv_stage2_block0_branch2b_pad)
        bn_stage2_block0_branch2b = self.bn_stage2_block0_branch2b(conv_stage2_block0_branch2b)
        relu_stage2_block0_branch2b = self.relu_stage2_block0_branch2b(bn_stage2_block0_branch2b)
        conv_stage2_block0_branch2c = self.conv_stage2_block0_branch2c(relu_stage2_block0_branch2b)
        bn_stage2_block0_branch2c = self.bn_stage2_block0_branch2c(conv_stage2_block0_branch2c)
        eltwise_stage2_block0 = self.eltwise_stage2_block0(bn_stage2_block0_proj_shortcut, bn_stage2_block0_branch2c)
        relu_stage2_block0 = self.relu_stage2_block0(eltwise_stage2_block0)
        conv_stage2_block1_branch2a = self.conv_stage2_block1_branch2a(relu_stage2_block0)
        bn_stage2_block1_branch2a = self.bn_stage2_block1_branch2a(conv_stage2_block1_branch2a)
        relu_stage2_block1_branch2a = self.relu_stage2_block1_branch2a(bn_stage2_block1_branch2a)
        conv_stage2_block1_branch2b_pad = self.conv_stage2_block1_branch2b_pad(relu_stage2_block1_branch2a, (1, 1, 1, 1))
        conv_stage2_block1_branch2b = self.conv_stage2_block1_branch2b(conv_stage2_block1_branch2b_pad)
        bn_stage2_block1_branch2b = self.bn_stage2_block1_branch2b(conv_stage2_block1_branch2b)
        relu_stage2_block1_branch2b = self.relu_stage2_block1_branch2b(bn_stage2_block1_branch2b)
        conv_stage2_block1_branch2c = self.conv_stage2_block1_branch2c(relu_stage2_block1_branch2b)
        bn_stage2_block1_branch2c = self.bn_stage2_block1_branch2c(conv_stage2_block1_branch2c)
        eltwise_stage2_block1 = self.eltwise_stage2_block1(relu_stage2_block0, bn_stage2_block1_branch2c)
        relu_stage2_block1 = self.relu_stage2_block1(eltwise_stage2_block1)
        conv_stage2_block2_branch2a = self.conv_stage2_block2_branch2a(relu_stage2_block1)
        bn_stage2_block2_branch2a = self.bn_stage2_block2_branch2a(conv_stage2_block2_branch2a)
        relu_stage2_block2_branch2a = self.relu_stage2_block2_branch2a(bn_stage2_block2_branch2a)
        conv_stage2_block2_branch2b_pad = self.conv_stage2_block2_branch2b_pad(relu_stage2_block2_branch2a, (1, 1, 1, 1))
        conv_stage2_block2_branch2b = self.conv_stage2_block2_branch2b(conv_stage2_block2_branch2b_pad)
        bn_stage2_block2_branch2b = self.bn_stage2_block2_branch2b(conv_stage2_block2_branch2b)
        relu_stage2_block2_branch2b = self.relu_stage2_block2_branch2b(bn_stage2_block2_branch2b)
        conv_stage2_block2_branch2c = self.conv_stage2_block2_branch2c(relu_stage2_block2_branch2b)
        bn_stage2_block2_branch2c = self.bn_stage2_block2_branch2c(conv_stage2_block2_branch2c)
        eltwise_stage2_block2 = self.eltwise_stage2_block2(relu_stage2_block1, bn_stage2_block2_branch2c)
        relu_stage2_block2 = self.relu_stage2_block2(eltwise_stage2_block2)
        conv_stage2_block3_branch2a = self.conv_stage2_block3_branch2a(relu_stage2_block2)
        bn_stage2_block3_branch2a = self.bn_stage2_block3_branch2a(conv_stage2_block3_branch2a)
        relu_stage2_block3_branch2a = self.relu_stage2_block3_branch2a(bn_stage2_block3_branch2a)
        conv_stage2_block3_branch2b_pad = self.conv_stage2_block3_branch2b_pad(relu_stage2_block3_branch2a, (1, 1, 1, 1))
        conv_stage2_block3_branch2b = self.conv_stage2_block3_branch2b(conv_stage2_block3_branch2b_pad)
        bn_stage2_block3_branch2b = self.bn_stage2_block3_branch2b(conv_stage2_block3_branch2b)
        relu_stage2_block3_branch2b = self.relu_stage2_block3_branch2b(bn_stage2_block3_branch2b)
        conv_stage2_block3_branch2c = self.conv_stage2_block3_branch2c(relu_stage2_block3_branch2b)
        bn_stage2_block3_branch2c = self.bn_stage2_block3_branch2c(conv_stage2_block3_branch2c)
        eltwise_stage2_block3 = self.eltwise_stage2_block3(relu_stage2_block2, bn_stage2_block3_branch2c)
        relu_stage2_block3 = self.relu_stage2_block3(eltwise_stage2_block3)
        conv_stage2_block4_branch2a = self.conv_stage2_block4_branch2a(relu_stage2_block3)
        bn_stage2_block4_branch2a = self.bn_stage2_block4_branch2a(conv_stage2_block4_branch2a)
        relu_stage2_block4_branch2a = self.relu_stage2_block4_branch2a(bn_stage2_block4_branch2a)
        conv_stage2_block4_branch2b_pad = self.conv_stage2_block4_branch2b_pad(relu_stage2_block4_branch2a, (1, 1, 1, 1))
        conv_stage2_block4_branch2b = self.conv_stage2_block4_branch2b(conv_stage2_block4_branch2b_pad)
        bn_stage2_block4_branch2b = self.bn_stage2_block4_branch2b(conv_stage2_block4_branch2b)
        relu_stage2_block4_branch2b = self.relu_stage2_block4_branch2b(bn_stage2_block4_branch2b)
        conv_stage2_block4_branch2c = self.conv_stage2_block4_branch2c(relu_stage2_block4_branch2b)
        bn_stage2_block4_branch2c = self.bn_stage2_block4_branch2c(conv_stage2_block4_branch2c)
        eltwise_stage2_block4 = self.eltwise_stage2_block4(relu_stage2_block3, bn_stage2_block4_branch2c)
        relu_stage2_block4 = self.relu_stage2_block4(eltwise_stage2_block4)
        conv_stage2_block5_branch2a = self.conv_stage2_block5_branch2a(relu_stage2_block4)
        bn_stage2_block5_branch2a = self.bn_stage2_block5_branch2a(conv_stage2_block5_branch2a)
        relu_stage2_block5_branch2a = self.relu_stage2_block5_branch2a(bn_stage2_block5_branch2a)
        conv_stage2_block5_branch2b_pad = self.conv_stage2_block5_branch2b_pad(relu_stage2_block5_branch2a, (1, 1, 1, 1))
        conv_stage2_block5_branch2b = self.conv_stage2_block5_branch2b(conv_stage2_block5_branch2b_pad)
        bn_stage2_block5_branch2b = self.bn_stage2_block5_branch2b(conv_stage2_block5_branch2b)
        relu_stage2_block5_branch2b = self.relu_stage2_block5_branch2b(bn_stage2_block5_branch2b)
        conv_stage2_block5_branch2c = self.conv_stage2_block5_branch2c(relu_stage2_block5_branch2b)
        bn_stage2_block5_branch2c = self.bn_stage2_block5_branch2c(conv_stage2_block5_branch2c)
        eltwise_stage2_block5 = self.eltwise_stage2_block5(relu_stage2_block4, bn_stage2_block5_branch2c) # Test
        relu_stage2_block5 = self.relu_stage2_block5(eltwise_stage2_block5)
        conv_stage3_block0_proj_shortcut = self.conv_stage3_block0_proj_shortcut(relu_stage2_block5)
        conv_stage3_block0_branch2a = self.conv_stage3_block0_branch2a(relu_stage2_block5)
        bn_stage3_block0_proj_shortcut = self.bn_stage3_block0_proj_shortcut(conv_stage3_block0_proj_shortcut)
        bn_stage3_block0_branch2a = self.bn_stage3_block0_branch2a(conv_stage3_block0_branch2a)
        relu_stage3_block0_branch2a = self.relu_stage3_block0_branch2a(bn_stage3_block0_branch2a)
        conv_stage3_block0_branch2b_pad = self.conv_stage3_block0_branch2b_pad(relu_stage3_block0_branch2a, (1, 1, 1, 1))
        conv_stage3_block0_branch2b = self.conv_stage3_block0_branch2b(conv_stage3_block0_branch2b_pad)
        bn_stage3_block0_branch2b = self.bn_stage3_block0_branch2b(conv_stage3_block0_branch2b)
        relu_stage3_block0_branch2b = self.relu_stage3_block0_branch2b(bn_stage3_block0_branch2b)
        conv_stage3_block0_branch2c = self.conv_stage3_block0_branch2c(relu_stage3_block0_branch2b)
        bn_stage3_block0_branch2c = self.bn_stage3_block0_branch2c(conv_stage3_block0_branch2c)
        eltwise_stage3_block0 = self.eltwise_stage3_block0(bn_stage3_block0_proj_shortcut, bn_stage3_block0_branch2c)
        relu_stage3_block0 = self.relu_stage3_block0(eltwise_stage3_block0)
        conv_stage3_block1_branch2a = self.conv_stage3_block1_branch2a(relu_stage3_block0)
        bn_stage3_block1_branch2a = self.bn_stage3_block1_branch2a(conv_stage3_block1_branch2a)
        relu_stage3_block1_branch2a = self.relu_stage3_block1_branch2a(bn_stage3_block1_branch2a)
        conv_stage3_block1_branch2b_pad = self.conv_stage3_block1_branch2b_pad(relu_stage3_block1_branch2a, (1, 1, 1, 1))
        conv_stage3_block1_branch2b = self.conv_stage3_block1_branch2b(conv_stage3_block1_branch2b_pad)
        bn_stage3_block1_branch2b = self.bn_stage3_block1_branch2b(conv_stage3_block1_branch2b)
        relu_stage3_block1_branch2b = self.relu_stage3_block1_branch2b(bn_stage3_block1_branch2b)
        conv_stage3_block1_branch2c = self.conv_stage3_block1_branch2c(relu_stage3_block1_branch2b)
        bn_stage3_block1_branch2c = self.bn_stage3_block1_branch2c(conv_stage3_block1_branch2c)
        eltwise_stage3_block1 = self.eltwise_stage3_block1(relu_stage3_block0, bn_stage3_block1_branch2c)
        relu_stage3_block1 = self.relu_stage3_block1(eltwise_stage3_block1)
        conv_stage3_block2_branch2a = self.conv_stage3_block2_branch2a(relu_stage3_block1)
        bn_stage3_block2_branch2a = self.bn_stage3_block2_branch2a(conv_stage3_block2_branch2a)
        relu_stage3_block2_branch2a = self.relu_stage3_block2_branch2a(bn_stage3_block2_branch2a)
        conv_stage3_block2_branch2b_pad = self.conv_stage3_block2_branch2b_pad(relu_stage3_block2_branch2a, (1, 1, 1, 1))
        conv_stage3_block2_branch2b = self.conv_stage3_block2_branch2b(conv_stage3_block2_branch2b_pad)
        bn_stage3_block2_branch2b = self.bn_stage3_block2_branch2b(conv_stage3_block2_branch2b)
        relu_stage3_block2_branch2b = self.relu_stage3_block2_branch2b(bn_stage3_block2_branch2b)
        conv_stage3_block2_branch2c = self.conv_stage3_block2_branch2c(relu_stage3_block2_branch2b)
        bn_stage3_block2_branch2c = self.bn_stage3_block2_branch2c(conv_stage3_block2_branch2c)
        eltwise_stage3_block2 = self.eltwise_stage3_block2(relu_stage3_block1, bn_stage3_block2_branch2c)
        relu_stage3_block2 = self.relu_stage3_block2(eltwise_stage3_block2)
        avgpool_2d = nn.AdaptiveAvgPool2d((7, 7))
        relu_stage3_block2 = avgpool_2d(relu_stage3_block2)
        pool            = F.avg_pool2d(relu_stage3_block2, kernel_size=(7, 7), stride=(1, 1), padding=(0,), ceil_mode=False, count_include_pad=False)
        fc_nsfw_0       = pool.view(pool.size(0), -1)
        fc_nsfw_1       = self.fc_nsfw_1(fc_nsfw_0)
        prob            = self.prob(fc_nsfw_1, dim=1)
        return prob
