import torch
import torch.nn as nn
import torch.nn.functional as F
import neural_dream.neural_dream_core.helper_layers as helper_layers


class InceptionV3Keras(nn.Module):

    def __init__(self):
        super(InceptionV3Keras, self).__init__()
        self.conv2d_1 = nn.Conv2d(in_channels=3, out_channels=32, kernel_size=(3, 3), stride=(2, 2), groups=1, bias=False)
        self.batch_normalization_1 = nn.BatchNorm2d(num_features=32, eps=0.0010000000475, momentum=0.0)
        self.conv2d_2 = nn.Conv2d(in_channels=32, out_channels=32, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_2 = nn.BatchNorm2d(num_features=32, eps=0.0010000000475, momentum=0.0)
        self.conv2d_3 = nn.Conv2d(in_channels=32, out_channels=64, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_3 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.conv2d_4 = nn.Conv2d(in_channels=64, out_channels=80, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_4 = nn.BatchNorm2d(num_features=80, eps=0.0010000000475, momentum=0.0)
        self.conv2d_5 = nn.Conv2d(in_channels=80, out_channels=192, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_5 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_9 = nn.Conv2d(in_channels=192, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_7 = nn.Conv2d(in_channels=192, out_channels=48, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_6 = nn.Conv2d(in_channels=192, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_9 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_7 = nn.BatchNorm2d(num_features=48, eps=0.0010000000475, momentum=0.0)
        self.conv2d_12 = nn.Conv2d(in_channels=192, out_channels=32, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_6 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_12 = nn.BatchNorm2d(num_features=32, eps=0.0010000000475, momentum=0.0)
        self.conv2d_10 = nn.Conv2d(in_channels=64, out_channels=96, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.conv2d_8 = nn.Conv2d(in_channels=48, out_channels=64, kernel_size=(5, 5), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_10 = nn.BatchNorm2d(num_features=96, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_8 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.conv2d_11 = nn.Conv2d(in_channels=96, out_channels=96, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_11 = nn.BatchNorm2d(num_features=96, eps=0.0010000000475, momentum=0.0)
        self.conv2d_16 = nn.Conv2d(in_channels=256, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_14 = nn.Conv2d(in_channels=256, out_channels=48, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_13 = nn.Conv2d(in_channels=256, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_16 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_14 = nn.BatchNorm2d(num_features=48, eps=0.0010000000475, momentum=0.0)
        self.conv2d_19 = nn.Conv2d(in_channels=256, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_13 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_19 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.conv2d_17 = nn.Conv2d(in_channels=64, out_channels=96, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.conv2d_15 = nn.Conv2d(in_channels=48, out_channels=64, kernel_size=(5, 5), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_17 = nn.BatchNorm2d(num_features=96, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_15 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.conv2d_18 = nn.Conv2d(in_channels=96, out_channels=96, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_18 = nn.BatchNorm2d(num_features=96, eps=0.0010000000475, momentum=0.0)
        self.conv2d_23 = nn.Conv2d(in_channels=288, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_21 = nn.Conv2d(in_channels=288, out_channels=48, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_20 = nn.Conv2d(in_channels=288, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_23 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_21 = nn.BatchNorm2d(num_features=48, eps=0.0010000000475, momentum=0.0)
        self.conv2d_26 = nn.Conv2d(in_channels=288, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_20 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_26 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.conv2d_24 = nn.Conv2d(in_channels=64, out_channels=96, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.conv2d_22 = nn.Conv2d(in_channels=48, out_channels=64, kernel_size=(5, 5), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_24 = nn.BatchNorm2d(num_features=96, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_22 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.conv2d_25 = nn.Conv2d(in_channels=96, out_channels=96, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_25 = nn.BatchNorm2d(num_features=96, eps=0.0010000000475, momentum=0.0)
        self.conv2d_28 = nn.Conv2d(in_channels=288, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_27 = nn.Conv2d(in_channels=288, out_channels=384, kernel_size=(3, 3), stride=(2, 2), groups=1, bias=False)
        self.batch_normalization_28 = nn.BatchNorm2d(num_features=64, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_27 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.conv2d_29 = nn.Conv2d(in_channels=64, out_channels=96, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_29 = nn.BatchNorm2d(num_features=96, eps=0.0010000000475, momentum=0.0)
        self.conv2d_30 = nn.Conv2d(in_channels=96, out_channels=96, kernel_size=(3, 3), stride=(2, 2), groups=1, bias=False)
        self.batch_normalization_30 = nn.BatchNorm2d(num_features=96, eps=0.0010000000475, momentum=0.0)
        self.conv2d_35 = nn.Conv2d(in_channels=768, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_32 = nn.Conv2d(in_channels=768, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_31 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_35 = nn.BatchNorm2d(num_features=128, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_32 = nn.BatchNorm2d(num_features=128, eps=0.0010000000475, momentum=0.0)
        self.conv2d_40 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_31 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_40 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_36 = nn.Conv2d(in_channels=128, out_channels=128, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_33 = nn.Conv2d(in_channels=128, out_channels=128, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_36 = nn.BatchNorm2d(num_features=128, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_33 = nn.BatchNorm2d(num_features=128, eps=0.0010000000475, momentum=0.0)
        self.conv2d_37 = nn.Conv2d(in_channels=128, out_channels=128, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.conv2d_34 = nn.Conv2d(in_channels=128, out_channels=192, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_37 = nn.BatchNorm2d(num_features=128, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_34 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_38 = nn.Conv2d(in_channels=128, out_channels=128, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_38 = nn.BatchNorm2d(num_features=128, eps=0.0010000000475, momentum=0.0)
        self.conv2d_39 = nn.Conv2d(in_channels=128, out_channels=192, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_39 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_45 = nn.Conv2d(in_channels=768, out_channels=160, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_42 = nn.Conv2d(in_channels=768, out_channels=160, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_41 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_45 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_42 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.conv2d_50 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_41 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_50 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_46 = nn.Conv2d(in_channels=160, out_channels=160, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_43 = nn.Conv2d(in_channels=160, out_channels=160, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_46 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_43 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.conv2d_47 = nn.Conv2d(in_channels=160, out_channels=160, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.conv2d_44 = nn.Conv2d(in_channels=160, out_channels=192, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_47 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_44 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_48 = nn.Conv2d(in_channels=160, out_channels=160, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_48 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.conv2d_49 = nn.Conv2d(in_channels=160, out_channels=192, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_49 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_55 = nn.Conv2d(in_channels=768, out_channels=160, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_52 = nn.Conv2d(in_channels=768, out_channels=160, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_51 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_55 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_52 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.conv2d_60 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_51 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_60 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_56 = nn.Conv2d(in_channels=160, out_channels=160, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_53 = nn.Conv2d(in_channels=160, out_channels=160, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_56 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_53 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.conv2d_57 = nn.Conv2d(in_channels=160, out_channels=160, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.conv2d_54 = nn.Conv2d(in_channels=160, out_channels=192, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_57 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_54 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_58 = nn.Conv2d(in_channels=160, out_channels=160, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_58 = nn.BatchNorm2d(num_features=160, eps=0.0010000000475, momentum=0.0)
        self.conv2d_59 = nn.Conv2d(in_channels=160, out_channels=192, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_59 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_65 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_62 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_61 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_65 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_62 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_70 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_61 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_70 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_66 = nn.Conv2d(in_channels=192, out_channels=192, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_63 = nn.Conv2d(in_channels=192, out_channels=192, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_66 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_63 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_67 = nn.Conv2d(in_channels=192, out_channels=192, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.conv2d_64 = nn.Conv2d(in_channels=192, out_channels=192, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_67 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_64 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_68 = nn.Conv2d(in_channels=192, out_channels=192, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_68 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_69 = nn.Conv2d(in_channels=192, out_channels=192, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_69 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_73 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_71 = nn.Conv2d(in_channels=768, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_73 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_71 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_74 = nn.Conv2d(in_channels=192, out_channels=192, kernel_size=(1, 7), stride=(1, 1), groups=1, bias=False)
        self.conv2d_72 = nn.Conv2d(in_channels=192, out_channels=320, kernel_size=(3, 3), stride=(2, 2), groups=1, bias=False)
        self.batch_normalization_74 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_72 = nn.BatchNorm2d(num_features=320, eps=0.0010000000475, momentum=0.0)
        self.conv2d_75 = nn.Conv2d(in_channels=192, out_channels=192, kernel_size=(7, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_75 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_76 = nn.Conv2d(in_channels=192, out_channels=192, kernel_size=(3, 3), stride=(2, 2), groups=1, bias=False)
        self.batch_normalization_76 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_81 = nn.Conv2d(in_channels=1280, out_channels=448, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_78 = nn.Conv2d(in_channels=1280, out_channels=384, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_77 = nn.Conv2d(in_channels=1280, out_channels=320, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_81 = nn.BatchNorm2d(num_features=448, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_78 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.conv2d_85 = nn.Conv2d(in_channels=1280, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_77 = nn.BatchNorm2d(num_features=320, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_85 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_82 = nn.Conv2d(in_channels=448, out_channels=384, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.conv2d_79 = nn.Conv2d(in_channels=384, out_channels=384, kernel_size=(1, 3), stride=(1, 1), groups=1, bias=False)
        self.conv2d_80 = nn.Conv2d(in_channels=384, out_channels=384, kernel_size=(3, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_82 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_79 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_80 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.conv2d_83 = nn.Conv2d(in_channels=384, out_channels=384, kernel_size=(1, 3), stride=(1, 1), groups=1, bias=False)
        self.conv2d_84 = nn.Conv2d(in_channels=384, out_channels=384, kernel_size=(3, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_83 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_84 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.conv2d_90 = nn.Conv2d(in_channels=2048, out_channels=448, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_87 = nn.Conv2d(in_channels=2048, out_channels=384, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.conv2d_86 = nn.Conv2d(in_channels=2048, out_channels=320, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_90 = nn.BatchNorm2d(num_features=448, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_87 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.conv2d_94 = nn.Conv2d(in_channels=2048, out_channels=192, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_86 = nn.BatchNorm2d(num_features=320, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_94 = nn.BatchNorm2d(num_features=192, eps=0.0010000000475, momentum=0.0)
        self.conv2d_91 = nn.Conv2d(in_channels=448, out_channels=384, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.conv2d_88 = nn.Conv2d(in_channels=384, out_channels=384, kernel_size=(1, 3), stride=(1, 1), groups=1, bias=False)
        self.conv2d_89 = nn.Conv2d(in_channels=384, out_channels=384, kernel_size=(3, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_91 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_88 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_89 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.conv2d_92 = nn.Conv2d(in_channels=384, out_channels=384, kernel_size=(1, 3), stride=(1, 1), groups=1, bias=False)
        self.conv2d_93 = nn.Conv2d(in_channels=384, out_channels=384, kernel_size=(3, 1), stride=(1, 1), groups=1, bias=False)
        self.batch_normalization_92 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.batch_normalization_93 = nn.BatchNorm2d(num_features=384, eps=0.0010000000475, momentum=0.0)
        self.predictions = nn.Linear(in_features = 2048, out_features = 1000, bias = True)


    def add_layers(self):
        self.activation_1 = helper_layers.ReluLayer()
        self.activation_2 = helper_layers.ReluLayer()
        self.activation_3 = helper_layers.ReluLayer()
        self.max_pooling2d_1 = helper_layers.MaxPool2dLayer()
        self.activation_4 = helper_layers.ReluLayer()
        self.activation_5 = helper_layers.ReluLayer()
        self.max_pooling2d_2 = helper_layers.MaxPool2dLayer()
        self.average_pooling2d_1 = helper_layers.AVGPoolLayer()
        self.activation_9 = helper_layers.ReluLayer()
        self.activation_7 = helper_layers.ReluLayer()
        self.activation_6 = helper_layers.ReluLayer()
        self.activation_12 = helper_layers.ReluLayer()
        self.activation_10 = helper_layers.ReluLayer()
        self.activation_8 = helper_layers.ReluLayer()
        self.activation_11 = helper_layers.ReluLayer()
        self.mixed0 = helper_layers.CatLayer()
        self.average_pooling2d_2 = helper_layers.AVGPoolLayer()
        self.activation_16 = helper_layers.ReluLayer()
        self.activation_14 = helper_layers.ReluLayer()
        self.activation_13 = helper_layers.ReluLayer()
        self.activation_19 = helper_layers.ReluLayer()
        self.activation_17 = helper_layers.ReluLayer()
        self.activation_15 = helper_layers.ReluLayer()
        self.activation_18 = helper_layers.ReluLayer()
        self.mixed1 = helper_layers.CatLayer()
        self.average_pooling2d_3 = helper_layers.AVGPoolLayer()
        self.activation_23 = helper_layers.ReluLayer()
        self.activation_21 = helper_layers.ReluLayer()
        self.activation_20 = helper_layers.ReluLayer()
        self.activation_26 = helper_layers.ReluLayer()
        self.activation_24 = helper_layers.ReluLayer()
        self.activation_22 = helper_layers.ReluLayer()
        self.activation_25 = helper_layers.ReluLayer()
        self.mixed2 = helper_layers.CatLayer()
        self.max_pooling2d_3 = helper_layers.MaxPool2dLayer()
        self.activation_28 = helper_layers.ReluLayer()
        self.activation_27 = helper_layers.ReluLayer()
        self.activation_29 = helper_layers.ReluLayer()
        self.activation_30 = helper_layers.ReluLayer()
        self.mixed3 = helper_layers.CatLayer()
        self.average_pooling2d_4 = helper_layers.AVGPoolLayer()
        self.activation_35 = helper_layers.ReluLayer()
        self.activation_32 = helper_layers.ReluLayer()
        self.activation_31 = helper_layers.ReluLayer()
        self.activation_40 = helper_layers.ReluLayer()
        self.activation_36 = helper_layers.ReluLayer()
        self.activation_33 = helper_layers.ReluLayer()
        self.activation_37 = helper_layers.ReluLayer()
        self.activation_34 = helper_layers.ReluLayer()
        self.activation_38 = helper_layers.ReluLayer()
        self.activation_39 = helper_layers.ReluLayer()
        self.mixed4 = helper_layers.CatLayer()
        self.average_pooling2d_5 = helper_layers.AVGPoolLayer()
        self.activation_45 = helper_layers.ReluLayer()
        self.activation_42 = helper_layers.ReluLayer()
        self.activation_41 = helper_layers.ReluLayer()
        self.activation_50 = helper_layers.ReluLayer()
        self.activation_46 = helper_layers.ReluLayer()
        self.activation_43 = helper_layers.ReluLayer()
        self.activation_47 = helper_layers.ReluLayer()
        self.activation_44 = helper_layers.ReluLayer()
        self.activation_48 = helper_layers.ReluLayer()
        self.activation_49 = helper_layers.ReluLayer()
        self.mixed5 = helper_layers.CatLayer()
        self.average_pooling2d_6 = helper_layers.AVGPoolLayer()
        self.activation_55 = helper_layers.ReluLayer()
        self.activation_52 = helper_layers.ReluLayer()
        self.activation_51 = helper_layers.ReluLayer()
        self.activation_60 = helper_layers.ReluLayer()
        self.activation_56 = helper_layers.ReluLayer()
        self.activation_53 = helper_layers.ReluLayer()
        self.activation_57 = helper_layers.ReluLayer()
        self.activation_54 = helper_layers.ReluLayer()
        self.activation_58 = helper_layers.ReluLayer()
        self.activation_59 = helper_layers.ReluLayer()
        self.mixed6 = helper_layers.CatLayer()
        self.average_pooling2d_7 = helper_layers.AVGPoolLayer()
        self.activation_65 = helper_layers.ReluLayer()
        self.activation_62 = helper_layers.ReluLayer()
        self.activation_61 = helper_layers.ReluLayer()
        self.activation_70 = helper_layers.ReluLayer()
        self.activation_66 = helper_layers.ReluLayer()
        self.activation_63 = helper_layers.ReluLayer()
        self.activation_67 = helper_layers.ReluLayer()
        self.activation_64 = helper_layers.ReluLayer()
        self.activation_68 = helper_layers.ReluLayer()
        self.activation_69 = helper_layers.ReluLayer()
        self.mixed7 = helper_layers.CatLayer()
        self.max_pooling2d_4 = helper_layers.MaxPool2dLayer()
        self.activation_73 = helper_layers.ReluLayer()
        self.activation_71 = helper_layers.ReluLayer()
        self.activation_74 = helper_layers.ReluLayer()
        self.activation_72 = helper_layers.ReluLayer()
        self.activation_75 = helper_layers.ReluLayer()
        self.activation_76 = helper_layers.ReluLayer()
        self.mixed8 = helper_layers.CatLayer()
        self.average_pooling2d_8 = helper_layers.AVGPoolLayer()
        self.activation_81 = helper_layers.ReluLayer()
        self.activation_78 = helper_layers.ReluLayer()
        self.activation_77 = helper_layers.ReluLayer()
        self.activation_85 = helper_layers.ReluLayer()
        self.activation_82 = helper_layers.ReluLayer()
        self.activation_79 = helper_layers.ReluLayer()
        self.activation_80 = helper_layers.ReluLayer()
        self.mixed9_0 = helper_layers.CatLayer()
        self.activation_83 = helper_layers.ReluLayer()
        self.activation_84 = helper_layers.ReluLayer()
        self.concatenate_1 = helper_layers.CatLayer()
        self.mixed9 = helper_layers.CatLayer()
        self.average_pooling2d_9 = helper_layers.AVGPoolLayer()
        self.activation_90 = helper_layers.ReluLayer()
        self.activation_87 = helper_layers.ReluLayer()
        self.activation_86 = helper_layers.ReluLayer()
        self.activation_94 = helper_layers.ReluLayer()
        self.activation_91 = helper_layers.ReluLayer()
        self.activation_88 = helper_layers.ReluLayer()
        self.activation_89 = helper_layers.ReluLayer()
        self.mixed9_1 = helper_layers.CatLayer()
        self.activation_92 = helper_layers.ReluLayer()
        self.activation_93 = helper_layers.ReluLayer()
        self.concatenate_2 = helper_layers.CatLayer()
        self.mixed10 = helper_layers.CatLayer()
        self.avg_pool = helper_layers.AVGPoolLayer()
        self.predictions_activation = helper_layers.SoftMaxLayer()


    def forward(self, x):
        conv2d_1        = self.conv2d_1(x)
        batch_normalization_1 = self.batch_normalization_1(conv2d_1)
        activation_1    = self.activation_1(batch_normalization_1)
        conv2d_2        = self.conv2d_2(activation_1)
        batch_normalization_2 = self.batch_normalization_2(conv2d_2)
        activation_2    = self.activation_2(batch_normalization_2)
        conv2d_3_pad    = F.pad(activation_2, (1, 1, 1, 1))
        conv2d_3        = self.conv2d_3(conv2d_3_pad)
        batch_normalization_3 = self.batch_normalization_3(conv2d_3)
        activation_3    = self.activation_3(batch_normalization_3)
        max_pooling2d_1 = self.max_pooling2d_1(activation_3, kernel_size=(3, 3), stride=(2, 2), padding=0, ceil_mode=False)
        conv2d_4        = self.conv2d_4(max_pooling2d_1)
        batch_normalization_4 = self.batch_normalization_4(conv2d_4)
        activation_4    = self.activation_4(batch_normalization_4)
        conv2d_5        = self.conv2d_5(activation_4)
        batch_normalization_5 = self.batch_normalization_5(conv2d_5)
        activation_5    = self.activation_5(batch_normalization_5)
        max_pooling2d_2 = self.max_pooling2d_2(activation_5, kernel_size=(3, 3), stride=(2, 2), padding=0, ceil_mode=False)
        conv2d_9        = self.conv2d_9(max_pooling2d_2)
        conv2d_7        = self.conv2d_7(max_pooling2d_2)
        average_pooling2d_1 = self.average_pooling2d_1(max_pooling2d_2, kernel_size=(3, 3), stride=(1, 1), padding=(1,), ceil_mode=False, count_include_pad=False)
        conv2d_6        = self.conv2d_6(max_pooling2d_2)
        batch_normalization_9 = self.batch_normalization_9(conv2d_9)
        batch_normalization_7 = self.batch_normalization_7(conv2d_7)
        conv2d_12       = self.conv2d_12(average_pooling2d_1)
        batch_normalization_6 = self.batch_normalization_6(conv2d_6)
        activation_9    = self.activation_9(batch_normalization_9)
        activation_7    = self.activation_7(batch_normalization_7)
        batch_normalization_12 = self.batch_normalization_12(conv2d_12)
        activation_6    = self.activation_6(batch_normalization_6)
        conv2d_10_pad   = F.pad(activation_9, (1, 1, 1, 1))
        conv2d_10       = self.conv2d_10(conv2d_10_pad)
        conv2d_8_pad    = F.pad(activation_7, (2, 2, 2, 2))
        conv2d_8        = self.conv2d_8(conv2d_8_pad)
        activation_12   = self.activation_12(batch_normalization_12)
        batch_normalization_10 = self.batch_normalization_10(conv2d_10)
        batch_normalization_8 = self.batch_normalization_8(conv2d_8)
        activation_10   = self.activation_10(batch_normalization_10)
        activation_8    = self.activation_8(batch_normalization_8)
        conv2d_11_pad   = F.pad(activation_10, (1, 1, 1, 1))
        conv2d_11       = self.conv2d_11(conv2d_11_pad)
        batch_normalization_11 = self.batch_normalization_11(conv2d_11)
        activation_11   = self.activation_11(batch_normalization_11)
        mixed0          = self.mixed0((activation_6, activation_8, activation_11, activation_12), 1)
        conv2d_16       = self.conv2d_16(mixed0)
        conv2d_14       = self.conv2d_14(mixed0)
        average_pooling2d_2 = self.average_pooling2d_2(mixed0, kernel_size=(3, 3), stride=(1, 1), padding=(1,), ceil_mode=False, count_include_pad=False)
        conv2d_13       = self.conv2d_13(mixed0)
        batch_normalization_16 = self.batch_normalization_16(conv2d_16)
        batch_normalization_14 = self.batch_normalization_14(conv2d_14)
        conv2d_19       = self.conv2d_19(average_pooling2d_2)
        batch_normalization_13 = self.batch_normalization_13(conv2d_13)
        activation_16   = self.activation_16(batch_normalization_16)
        activation_14   = self.activation_14(batch_normalization_14)
        batch_normalization_19 = self.batch_normalization_19(conv2d_19)
        activation_13   = self.activation_13(batch_normalization_13)
        conv2d_17_pad   = F.pad(activation_16, (1, 1, 1, 1))
        conv2d_17       = self.conv2d_17(conv2d_17_pad)
        conv2d_15_pad   = F.pad(activation_14, (2, 2, 2, 2))
        conv2d_15       = self.conv2d_15(conv2d_15_pad)
        activation_19   = self.activation_19(batch_normalization_19)
        batch_normalization_17 = self.batch_normalization_17(conv2d_17)
        batch_normalization_15 = self.batch_normalization_15(conv2d_15)
        activation_17   = self.activation_17(batch_normalization_17)
        activation_15   = self.activation_15(batch_normalization_15)
        conv2d_18_pad   = F.pad(activation_17, (1, 1, 1, 1))
        conv2d_18       = self.conv2d_18(conv2d_18_pad)
        batch_normalization_18 = self.batch_normalization_18(conv2d_18)
        activation_18   = self.activation_18(batch_normalization_18)
        mixed1          = self.mixed1((activation_13, activation_15, activation_18, activation_19), 1)
        conv2d_23       = self.conv2d_23(mixed1)
        conv2d_21       = self.conv2d_21(mixed1)
        average_pooling2d_3 = self.average_pooling2d_3(mixed1, kernel_size=(3, 3), stride=(1, 1), padding=(1,), ceil_mode=False, count_include_pad=False)
        conv2d_20       = self.conv2d_20(mixed1)
        batch_normalization_23 = self.batch_normalization_23(conv2d_23)
        batch_normalization_21 = self.batch_normalization_21(conv2d_21)
        conv2d_26       = self.conv2d_26(average_pooling2d_3)
        batch_normalization_20 = self.batch_normalization_20(conv2d_20)
        activation_23   = self.activation_23(batch_normalization_23)
        activation_21   = self.activation_21(batch_normalization_21)
        batch_normalization_26 = self.batch_normalization_26(conv2d_26)
        activation_20   = self.activation_20(batch_normalization_20)
        conv2d_24_pad   = F.pad(activation_23, (1, 1, 1, 1))
        conv2d_24       = self.conv2d_24(conv2d_24_pad)
        conv2d_22_pad   = F.pad(activation_21, (2, 2, 2, 2))
        conv2d_22       = self.conv2d_22(conv2d_22_pad)
        activation_26   = self.activation_26(batch_normalization_26)
        batch_normalization_24 = self.batch_normalization_24(conv2d_24)
        batch_normalization_22 = self.batch_normalization_22(conv2d_22)
        activation_24   = self.activation_24(batch_normalization_24)
        activation_22   = self.activation_22(batch_normalization_22)
        conv2d_25_pad   = F.pad(activation_24, (1, 1, 1, 1))
        conv2d_25       = self.conv2d_25(conv2d_25_pad)
        batch_normalization_25 = self.batch_normalization_25(conv2d_25)
        activation_25   = self.activation_25(batch_normalization_25)
        mixed2          = self.mixed2((activation_20, activation_22, activation_25, activation_26), 1)
        conv2d_28       = self.conv2d_28(mixed2)
        conv2d_27       = self.conv2d_27(mixed2)
        max_pooling2d_3 = self.max_pooling2d_3(mixed2, kernel_size=(3, 3), stride=(2, 2), padding=0, ceil_mode=False)
        batch_normalization_28 = self.batch_normalization_28(conv2d_28)
        batch_normalization_27 = self.batch_normalization_27(conv2d_27)
        activation_28   = self.activation_28(batch_normalization_28)
        activation_27   = self.activation_27(batch_normalization_27)
        conv2d_29_pad   = F.pad(activation_28, (1, 1, 1, 1))
        conv2d_29       = self.conv2d_29(conv2d_29_pad)
        batch_normalization_29 = self.batch_normalization_29(conv2d_29)
        activation_29   = self.activation_29(batch_normalization_29)
        conv2d_30       = self.conv2d_30(activation_29)
        batch_normalization_30 = self.batch_normalization_30(conv2d_30)
        activation_30   = self.activation_30(batch_normalization_30)
        mixed3          = self.mixed3((activation_27, activation_30, max_pooling2d_3), 1)
        conv2d_35       = self.conv2d_35(mixed3)
        conv2d_32       = self.conv2d_32(mixed3)
        average_pooling2d_4 = self.average_pooling2d_4(mixed3, kernel_size=(3, 3), stride=(1, 1), padding=(1,), ceil_mode=False, count_include_pad=False)
        conv2d_31       = self.conv2d_31(mixed3)
        batch_normalization_35 = self.batch_normalization_35(conv2d_35)
        batch_normalization_32 = self.batch_normalization_32(conv2d_32)
        conv2d_40       = self.conv2d_40(average_pooling2d_4)
        batch_normalization_31 = self.batch_normalization_31(conv2d_31)
        activation_35   = self.activation_35(batch_normalization_35)
        activation_32   = self.activation_32(batch_normalization_32)
        batch_normalization_40 = self.batch_normalization_40(conv2d_40)
        activation_31   = self.activation_31(batch_normalization_31)
        conv2d_36_pad   = F.pad(activation_35, (0, 0, 3, 3))
        conv2d_36       = self.conv2d_36(conv2d_36_pad)
        conv2d_33_pad   = F.pad(activation_32, (3, 3, 0, 0))
        conv2d_33       = self.conv2d_33(conv2d_33_pad)
        activation_40   = self.activation_40(batch_normalization_40)
        batch_normalization_36 = self.batch_normalization_36(conv2d_36)
        batch_normalization_33 = self.batch_normalization_33(conv2d_33)
        activation_36   = self.activation_36(batch_normalization_36)
        activation_33   = self.activation_33(batch_normalization_33)
        conv2d_37_pad   = F.pad(activation_36, (3, 3, 0, 0))
        conv2d_37       = self.conv2d_37(conv2d_37_pad)
        conv2d_34_pad   = F.pad(activation_33, (0, 0, 3, 3))
        conv2d_34       = self.conv2d_34(conv2d_34_pad)
        batch_normalization_37 = self.batch_normalization_37(conv2d_37)
        batch_normalization_34 = self.batch_normalization_34(conv2d_34)
        activation_37   = self.activation_37(batch_normalization_37)
        activation_34   = self.activation_34(batch_normalization_34)
        conv2d_38_pad   = F.pad(activation_37, (0, 0, 3, 3))
        conv2d_38       = self.conv2d_38(conv2d_38_pad)
        batch_normalization_38 = self.batch_normalization_38(conv2d_38)
        activation_38   = self.activation_38(batch_normalization_38)
        conv2d_39_pad   = F.pad(activation_38, (3, 3, 0, 0))
        conv2d_39       = self.conv2d_39(conv2d_39_pad)
        batch_normalization_39 = self.batch_normalization_39(conv2d_39)
        activation_39   = self.activation_39(batch_normalization_39)
        mixed4          = self.mixed4((activation_31, activation_34, activation_39, activation_40), 1)
        conv2d_45       = self.conv2d_45(mixed4)
        conv2d_42       = self.conv2d_42(mixed4)
        average_pooling2d_5 = self.average_pooling2d_5(mixed4, kernel_size=(3, 3), stride=(1, 1), padding=(1,), ceil_mode=False, count_include_pad=False)
        conv2d_41       = self.conv2d_41(mixed4)
        batch_normalization_45 = self.batch_normalization_45(conv2d_45)
        batch_normalization_42 = self.batch_normalization_42(conv2d_42)
        conv2d_50       = self.conv2d_50(average_pooling2d_5)
        batch_normalization_41 = self.batch_normalization_41(conv2d_41)
        activation_45   = self.activation_45(batch_normalization_45)
        activation_42   = self.activation_42(batch_normalization_42)
        batch_normalization_50 = self.batch_normalization_50(conv2d_50)
        activation_41   = self.activation_41(batch_normalization_41)
        conv2d_46_pad   = F.pad(activation_45, (0, 0, 3, 3))
        conv2d_46       = self.conv2d_46(conv2d_46_pad)
        conv2d_43_pad   = F.pad(activation_42, (3, 3, 0, 0))
        conv2d_43       = self.conv2d_43(conv2d_43_pad)
        activation_50   = self.activation_50(batch_normalization_50)
        batch_normalization_46 = self.batch_normalization_46(conv2d_46)
        batch_normalization_43 = self.batch_normalization_43(conv2d_43)
        activation_46   = self.activation_46(batch_normalization_46)
        activation_43   = self.activation_43(batch_normalization_43)
        conv2d_47_pad   = F.pad(activation_46, (3, 3, 0, 0))
        conv2d_47       = self.conv2d_47(conv2d_47_pad)
        conv2d_44_pad   = F.pad(activation_43, (0, 0, 3, 3))
        conv2d_44       = self.conv2d_44(conv2d_44_pad)
        batch_normalization_47 = self.batch_normalization_47(conv2d_47)
        batch_normalization_44 = self.batch_normalization_44(conv2d_44)
        activation_47   = self.activation_47(batch_normalization_47)
        activation_44   = self.activation_44(batch_normalization_44)
        conv2d_48_pad   = F.pad(activation_47, (0, 0, 3, 3))
        conv2d_48       = self.conv2d_48(conv2d_48_pad)
        batch_normalization_48 = self.batch_normalization_48(conv2d_48)
        activation_48   = self.activation_48(batch_normalization_48)
        conv2d_49_pad   = F.pad(activation_48, (3, 3, 0, 0))
        conv2d_49       = self.conv2d_49(conv2d_49_pad)
        batch_normalization_49 = self.batch_normalization_49(conv2d_49)
        activation_49   = self.activation_49(batch_normalization_49)
        mixed5          = self.mixed5((activation_41, activation_44, activation_49, activation_50), 1)
        conv2d_55       = self.conv2d_55(mixed5)
        conv2d_52       = self.conv2d_52(mixed5)
        average_pooling2d_6 = self.average_pooling2d_6(mixed5, kernel_size=(3, 3), stride=(1, 1), padding=(1,), ceil_mode=False, count_include_pad=False)
        conv2d_51       = self.conv2d_51(mixed5)
        batch_normalization_55 = self.batch_normalization_55(conv2d_55)
        batch_normalization_52 = self.batch_normalization_52(conv2d_52)
        conv2d_60       = self.conv2d_60(average_pooling2d_6)
        batch_normalization_51 = self.batch_normalization_51(conv2d_51)
        activation_55   = self.activation_55(batch_normalization_55)
        activation_52   = self.activation_52(batch_normalization_52)
        batch_normalization_60 = self.batch_normalization_60(conv2d_60)
        activation_51   = self.activation_51(batch_normalization_51)
        conv2d_56_pad   = F.pad(activation_55, (0, 0, 3, 3))
        conv2d_56       = self.conv2d_56(conv2d_56_pad)
        conv2d_53_pad   = F.pad(activation_52, (3, 3, 0, 0))
        conv2d_53       = self.conv2d_53(conv2d_53_pad)
        activation_60   = self.activation_60(batch_normalization_60)
        batch_normalization_56 = self.batch_normalization_56(conv2d_56)
        batch_normalization_53 = self.batch_normalization_53(conv2d_53)
        activation_56   = self.activation_56(batch_normalization_56)
        activation_53   = self.activation_53(batch_normalization_53)
        conv2d_57_pad   = F.pad(activation_56, (3, 3, 0, 0))
        conv2d_57       = self.conv2d_57(conv2d_57_pad)
        conv2d_54_pad   = F.pad(activation_53, (0, 0, 3, 3))
        conv2d_54       = self.conv2d_54(conv2d_54_pad)
        batch_normalization_57 = self.batch_normalization_57(conv2d_57)
        batch_normalization_54 = self.batch_normalization_54(conv2d_54)
        activation_57   = self.activation_57(batch_normalization_57)
        activation_54   = self.activation_54(batch_normalization_54)
        conv2d_58_pad   = F.pad(activation_57, (0, 0, 3, 3))
        conv2d_58       = self.conv2d_58(conv2d_58_pad)
        batch_normalization_58 = self.batch_normalization_58(conv2d_58)
        activation_58   = self.activation_58(batch_normalization_58)
        conv2d_59_pad   = F.pad(activation_58, (3, 3, 0, 0))
        conv2d_59       = self.conv2d_59(conv2d_59_pad)
        batch_normalization_59 = self.batch_normalization_59(conv2d_59)
        activation_59   = self.activation_59(batch_normalization_59)
        mixed6          = self.mixed6((activation_51, activation_54, activation_59, activation_60), 1)
        conv2d_65       = self.conv2d_65(mixed6)
        conv2d_62       = self.conv2d_62(mixed6)
        average_pooling2d_7 = self.average_pooling2d_7(mixed6, kernel_size=(3, 3), stride=(1, 1), padding=(1,), ceil_mode=False, count_include_pad=False)
        conv2d_61       = self.conv2d_61(mixed6)
        batch_normalization_65 = self.batch_normalization_65(conv2d_65)
        batch_normalization_62 = self.batch_normalization_62(conv2d_62)
        conv2d_70       = self.conv2d_70(average_pooling2d_7)
        batch_normalization_61 = self.batch_normalization_61(conv2d_61)
        activation_65   = self.activation_65(batch_normalization_65)
        activation_62   = self.activation_62(batch_normalization_62)
        batch_normalization_70 = self.batch_normalization_70(conv2d_70)
        activation_61   = self.activation_61(batch_normalization_61)
        conv2d_66_pad   = F.pad(activation_65, (0, 0, 3, 3))
        conv2d_66       = self.conv2d_66(conv2d_66_pad)
        conv2d_63_pad   = F.pad(activation_62, (3, 3, 0, 0))
        conv2d_63       = self.conv2d_63(conv2d_63_pad)
        activation_70   = self.activation_70(batch_normalization_70)
        batch_normalization_66 = self.batch_normalization_66(conv2d_66)
        batch_normalization_63 = self.batch_normalization_63(conv2d_63)
        activation_66   = self.activation_66(batch_normalization_66)
        activation_63   = self.activation_63(batch_normalization_63)
        conv2d_67_pad   = F.pad(activation_66, (3, 3, 0, 0))
        conv2d_67       = self.conv2d_67(conv2d_67_pad)
        conv2d_64_pad   = F.pad(activation_63, (0, 0, 3, 3))
        conv2d_64       = self.conv2d_64(conv2d_64_pad)
        batch_normalization_67 = self.batch_normalization_67(conv2d_67)
        batch_normalization_64 = self.batch_normalization_64(conv2d_64)
        activation_67   = self.activation_67(batch_normalization_67)
        activation_64   = self.activation_64(batch_normalization_64)
        conv2d_68_pad   = F.pad(activation_67, (0, 0, 3, 3))
        conv2d_68       = self.conv2d_68(conv2d_68_pad)
        batch_normalization_68 = self.batch_normalization_68(conv2d_68)
        activation_68   = self.activation_68(batch_normalization_68)
        conv2d_69_pad   = F.pad(activation_68, (3, 3, 0, 0))
        conv2d_69       = self.conv2d_69(conv2d_69_pad)
        batch_normalization_69 = self.batch_normalization_69(conv2d_69)
        activation_69   = self.activation_69(batch_normalization_69)
        mixed7          = self.mixed7((activation_61, activation_64, activation_69, activation_70), 1)
        conv2d_73       = self.conv2d_73(mixed7)
        conv2d_71       = self.conv2d_71(mixed7)
        max_pooling2d_4 = self.max_pooling2d_4(mixed7, kernel_size=(3, 3), stride=(2, 2), padding=0, ceil_mode=False)
        batch_normalization_73 = self.batch_normalization_73(conv2d_73)
        batch_normalization_71 = self.batch_normalization_71(conv2d_71)
        activation_73   = self.activation_73(batch_normalization_73)
        activation_71   = self.activation_71(batch_normalization_71)
        conv2d_74_pad   = F.pad(activation_73, (3, 3, 0, 0))
        conv2d_74       = self.conv2d_74(conv2d_74_pad)
        conv2d_72       = self.conv2d_72(activation_71)
        batch_normalization_74 = self.batch_normalization_74(conv2d_74)
        batch_normalization_72 = self.batch_normalization_72(conv2d_72)
        activation_74   = self.activation_74(batch_normalization_74)
        activation_72   = self.activation_72(batch_normalization_72)
        conv2d_75_pad   = F.pad(activation_74, (0, 0, 3, 3))
        conv2d_75       = self.conv2d_75(conv2d_75_pad)
        batch_normalization_75 = self.batch_normalization_75(conv2d_75)
        activation_75   = self.activation_75(batch_normalization_75)
        conv2d_76       = self.conv2d_76(activation_75)
        batch_normalization_76 = self.batch_normalization_76(conv2d_76)
        activation_76   = self.activation_76(batch_normalization_76)
        mixed8          = self.mixed8((activation_72, activation_76, max_pooling2d_4), 1)
        conv2d_81       = self.conv2d_81(mixed8)
        conv2d_78       = self.conv2d_78(mixed8)
        average_pooling2d_8 = self.average_pooling2d_8(mixed8, kernel_size=(3, 3), stride=(1, 1), padding=(1,), ceil_mode=False, count_include_pad=False)
        conv2d_77       = self.conv2d_77(mixed8)
        batch_normalization_81 = self.batch_normalization_81(conv2d_81)
        batch_normalization_78 = self.batch_normalization_78(conv2d_78)
        conv2d_85       = self.conv2d_85(average_pooling2d_8)
        batch_normalization_77 = self.batch_normalization_77(conv2d_77)
        activation_81   = self.activation_81(batch_normalization_81)
        activation_78   = self.activation_78(batch_normalization_78)
        batch_normalization_85 = self.batch_normalization_85(conv2d_85)
        activation_77   = self.activation_77(batch_normalization_77)
        conv2d_82_pad   = F.pad(activation_81, (1, 1, 1, 1))
        conv2d_82       = self.conv2d_82(conv2d_82_pad)
        conv2d_79_pad   = F.pad(activation_78, (1, 1, 0, 0))
        conv2d_79       = self.conv2d_79(conv2d_79_pad)
        conv2d_80_pad   = F.pad(activation_78, (0, 0, 1, 1))
        conv2d_80       = self.conv2d_80(conv2d_80_pad)
        activation_85   = self.activation_85(batch_normalization_85)
        batch_normalization_82 = self.batch_normalization_82(conv2d_82)
        batch_normalization_79 = self.batch_normalization_79(conv2d_79)
        batch_normalization_80 = self.batch_normalization_80(conv2d_80)
        activation_82   = self.activation_82(batch_normalization_82)
        activation_79   = self.activation_79(batch_normalization_79)
        activation_80   = self.activation_80(batch_normalization_80)
        conv2d_83_pad   = F.pad(activation_82, (1, 1, 0, 0))
        conv2d_83       = self.conv2d_83(conv2d_83_pad)
        conv2d_84_pad   = F.pad(activation_82, (0, 0, 1, 1))
        conv2d_84       = self.conv2d_84(conv2d_84_pad)
        mixed9_0        = self.mixed9_0((activation_79, activation_80), 1)
        batch_normalization_83 = self.batch_normalization_83(conv2d_83)
        batch_normalization_84 = self.batch_normalization_84(conv2d_84)
        activation_83   = self.activation_83(batch_normalization_83)
        activation_84   = self.activation_84(batch_normalization_84)
        concatenate_1   = self.concatenate_1((activation_83, activation_84), 1)
        mixed9          = self.mixed9((activation_77, mixed9_0, concatenate_1, activation_85), 1)
        conv2d_90       = self.conv2d_90(mixed9)
        conv2d_87       = self.conv2d_87(mixed9)
        average_pooling2d_9 = self.average_pooling2d_9(mixed9, kernel_size=(3, 3), stride=(1, 1), padding=(1,), ceil_mode=False, count_include_pad=False)
        conv2d_86       = self.conv2d_86(mixed9)
        batch_normalization_90 = self.batch_normalization_90(conv2d_90)
        batch_normalization_87 = self.batch_normalization_87(conv2d_87)
        conv2d_94       = self.conv2d_94(average_pooling2d_9)
        batch_normalization_86 = self.batch_normalization_86(conv2d_86)
        activation_90   = self.activation_90(batch_normalization_90)
        activation_87   = self.activation_87(batch_normalization_87)
        batch_normalization_94 = self.batch_normalization_94(conv2d_94)
        activation_86   = self.activation_86(batch_normalization_86)
        conv2d_91_pad   = F.pad(activation_90, (1, 1, 1, 1))
        conv2d_91       = self.conv2d_91(conv2d_91_pad)
        conv2d_88_pad   = F.pad(activation_87, (1, 1, 0, 0))
        conv2d_88       = self.conv2d_88(conv2d_88_pad)
        conv2d_89_pad   = F.pad(activation_87, (0, 0, 1, 1))
        conv2d_89       = self.conv2d_89(conv2d_89_pad)
        activation_94   = self.activation_94(batch_normalization_94)
        batch_normalization_91 = self.batch_normalization_91(conv2d_91)
        batch_normalization_88 = self.batch_normalization_88(conv2d_88)
        batch_normalization_89 = self.batch_normalization_89(conv2d_89)
        activation_91   = self.activation_91(batch_normalization_91)
        activation_88   = self.activation_88(batch_normalization_88)
        activation_89   = self.activation_89(batch_normalization_89)
        conv2d_92_pad   = F.pad(activation_91, (1, 1, 0, 0))
        conv2d_92       = self.conv2d_92(conv2d_92_pad)
        conv2d_93_pad   = F.pad(activation_91, (0, 0, 1, 1))
        conv2d_93       = self.conv2d_93(conv2d_93_pad)
        mixed9_1        = self.mixed9_1((activation_88, activation_89), 1)
        batch_normalization_92 = self.batch_normalization_92(conv2d_92)
        batch_normalization_93 = self.batch_normalization_93(conv2d_93)
        activation_92   = self.activation_92(batch_normalization_92)
        activation_93   = self.activation_93(batch_normalization_93)
        concatenate_2   = self.concatenate_2((activation_92, activation_93), 1)
        mixed10         = self.mixed10((activation_86, mixed9_1, concatenate_2, activation_94), 1)
        avg_pool        = self.avg_pool(input = mixed10, kernel_size = mixed10.size()[2:])
        avg_pool_flatten = avg_pool.view(avg_pool.size(0), -1)
        predictions     = self.predictions(avg_pool_flatten)
        predictions_activation = self.predictions_activation(predictions)
        return predictions_activation