# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[str],
                 role_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 tenant_id: pulumi.Input[str],
                 automatically_verify: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 skip_invite_email: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] email: The user's email address.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: List of the role IDs that the user has in the tenant
        :param pulumi.Input[str] tenant_id: The tenant ID for this user.
        :param pulumi.Input[bool] automatically_verify: Whether the user gets verified upon creation.
        :param pulumi.Input[str] password: The user's login password.
        :param pulumi.Input[bool] skip_invite_email: Skip sending the invite email. If true, user is automatically verified on creation.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "role_ids", role_ids)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if automatically_verify is not None:
            pulumi.set(__self__, "automatically_verify", automatically_verify)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if skip_invite_email is not None:
            pulumi.set(__self__, "skip_invite_email", skip_invite_email)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        The user's email address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of the role IDs that the user has in the tenant
        """
        return pulumi.get(self, "role_ids")

    @role_ids.setter
    def role_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "role_ids", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The tenant ID for this user.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="automaticallyVerify")
    def automatically_verify(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the user gets verified upon creation.
        """
        return pulumi.get(self, "automatically_verify")

    @automatically_verify.setter
    def automatically_verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatically_verify", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The user's login password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="skipInviteEmail")
    def skip_invite_email(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip sending the invite email. If true, user is automatically verified on creation.
        """
        return pulumi.get(self, "skip_invite_email")

    @skip_invite_email.setter
    def skip_invite_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_invite_email", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 automatically_verify: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_invite_email: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[bool] automatically_verify: Whether the user gets verified upon creation.
        :param pulumi.Input[str] email: The user's email address.
        :param pulumi.Input[str] password: The user's login password.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: List of the role IDs that the user has in the tenant
        :param pulumi.Input[bool] skip_invite_email: Skip sending the invite email. If true, user is automatically verified on creation.
        :param pulumi.Input[str] tenant_id: The tenant ID for this user.
        """
        if automatically_verify is not None:
            pulumi.set(__self__, "automatically_verify", automatically_verify)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if role_ids is not None:
            pulumi.set(__self__, "role_ids", role_ids)
        if skip_invite_email is not None:
            pulumi.set(__self__, "skip_invite_email", skip_invite_email)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="automaticallyVerify")
    def automatically_verify(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the user gets verified upon creation.
        """
        return pulumi.get(self, "automatically_verify")

    @automatically_verify.setter
    def automatically_verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatically_verify", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The user's email address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The user's login password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the role IDs that the user has in the tenant
        """
        return pulumi.get(self, "role_ids")

    @role_ids.setter
    def role_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_ids", value)

    @property
    @pulumi.getter(name="skipInviteEmail")
    def skip_invite_email(self) -> Optional[pulumi.Input[bool]]:
        """
        Skip sending the invite email. If true, user is automatically verified on creation.
        """
        return pulumi.get(self, "skip_invite_email")

    @skip_invite_email.setter
    def skip_invite_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_invite_email", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant ID for this user.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatically_verify: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_invite_email: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a User resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] automatically_verify: Whether the user gets verified upon creation.
        :param pulumi.Input[str] email: The user's email address.
        :param pulumi.Input[str] password: The user's login password.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: List of the role IDs that the user has in the tenant
        :param pulumi.Input[bool] skip_invite_email: Skip sending the invite email. If true, user is automatically verified on creation.
        :param pulumi.Input[str] tenant_id: The tenant ID for this user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a User resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatically_verify: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_invite_email: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["automatically_verify"] = automatically_verify
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["password"] = password
            if role_ids is None and not opts.urn:
                raise TypeError("Missing required property 'role_ids'")
            __props__.__dict__["role_ids"] = role_ids
            __props__.__dict__["skip_invite_email"] = skip_invite_email
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(User, __self__).__init__(
            'frontegg:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automatically_verify: Optional[pulumi.Input[bool]] = None,
            email: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            skip_invite_email: Optional[pulumi.Input[bool]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] automatically_verify: Whether the user gets verified upon creation.
        :param pulumi.Input[str] email: The user's email address.
        :param pulumi.Input[str] password: The user's login password.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: List of the role IDs that the user has in the tenant
        :param pulumi.Input[bool] skip_invite_email: Skip sending the invite email. If true, user is automatically verified on creation.
        :param pulumi.Input[str] tenant_id: The tenant ID for this user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["automatically_verify"] = automatically_verify
        __props__.__dict__["email"] = email
        __props__.__dict__["password"] = password
        __props__.__dict__["role_ids"] = role_ids
        __props__.__dict__["skip_invite_email"] = skip_invite_email
        __props__.__dict__["tenant_id"] = tenant_id
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="automaticallyVerify")
    def automatically_verify(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the user gets verified upon creation.
        """
        return pulumi.get(self, "automatically_verify")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        The user's email address.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The user's login password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of the role IDs that the user has in the tenant
        """
        return pulumi.get(self, "role_ids")

    @property
    @pulumi.getter(name="skipInviteEmail")
    def skip_invite_email(self) -> pulumi.Output[Optional[bool]]:
        """
        Skip sending the invite email. If true, user is automatically verified on creation.
        """
        return pulumi.get(self, "skip_invite_email")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The tenant ID for this user.
        """
        return pulumi.get(self, "tenant_id")

