# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['RoleArgs', 'Role']

@pulumi.input_type
class RoleArgs:
    def __init__(__self__, *,
                 default: pulumi.Input[bool],
                 description: pulumi.Input[str],
                 key: pulumi.Input[str],
                 level: pulumi.Input[int],
                 permission_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Role resource.
        :param pulumi.Input[bool] default: Whether the role should be applied to new users by default.
        :param pulumi.Input[str] description: A human-readable description of the role.
        :param pulumi.Input[str] key: A human-readable identifier for the role.
        :param pulumi.Input[int] level: The level of the role in the role hierarchy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permission_ids: The IDs of the permissions that the role confers to its members.
        :param pulumi.Input[str] name: A human-readable name for the role.
        """
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "permission_ids", permission_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def default(self) -> pulumi.Input[bool]:
        """
        Whether the role should be applied to new users by default.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: pulumi.Input[bool]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        A human-readable description of the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        A human-readable identifier for the role.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def level(self) -> pulumi.Input[int]:
        """
        The level of the role in the role hierarchy.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: pulumi.Input[int]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="permissionIds")
    def permission_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The IDs of the permissions that the role confers to its members.
        """
        return pulumi.get(self, "permission_ids")

    @permission_ids.setter
    def permission_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "permission_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable name for the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RoleState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permission_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vendor_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Role resources.
        :param pulumi.Input[str] created_at: The timestamp at which the role was created.
        :param pulumi.Input[bool] default: Whether the role should be applied to new users by default.
        :param pulumi.Input[str] description: A human-readable description of the role.
        :param pulumi.Input[str] key: A human-readable identifier for the role.
        :param pulumi.Input[int] level: The level of the role in the role hierarchy.
        :param pulumi.Input[str] name: A human-readable name for the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permission_ids: The IDs of the permissions that the role confers to its members.
        :param pulumi.Input[str] tenant_id: The ID of the tenant that owns the role.
        :param pulumi.Input[str] vendor_id: The ID of the vendor that owns the role.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permission_ids is not None:
            pulumi.set(__self__, "permission_ids", permission_ids)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vendor_id is not None:
            pulumi.set(__self__, "vendor_id", vendor_id)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp at which the role was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the role should be applied to new users by default.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable identifier for the role.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[int]]:
        """
        The level of the role in the role hierarchy.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable name for the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="permissionIds")
    def permission_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of the permissions that the role confers to its members.
        """
        return pulumi.get(self, "permission_ids")

    @permission_ids.setter
    def permission_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permission_ids", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the tenant that owns the role.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="vendorId")
    def vendor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the vendor that owns the role.
        """
        return pulumi.get(self, "vendor_id")

    @vendor_id.setter
    def vendor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor_id", value)


class Role(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permission_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a Role resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] default: Whether the role should be applied to new users by default.
        :param pulumi.Input[str] description: A human-readable description of the role.
        :param pulumi.Input[str] key: A human-readable identifier for the role.
        :param pulumi.Input[int] level: The level of the role in the role hierarchy.
        :param pulumi.Input[str] name: A human-readable name for the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permission_ids: The IDs of the permissions that the role confers to its members.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Role resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param RoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permission_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleArgs.__new__(RoleArgs)

            if default is None and not opts.urn:
                raise TypeError("Missing required property 'default'")
            __props__.__dict__["default"] = default
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if level is None and not opts.urn:
                raise TypeError("Missing required property 'level'")
            __props__.__dict__["level"] = level
            __props__.__dict__["name"] = name
            if permission_ids is None and not opts.urn:
                raise TypeError("Missing required property 'permission_ids'")
            __props__.__dict__["permission_ids"] = permission_ids
            __props__.__dict__["created_at"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["vendor_id"] = None
        super(Role, __self__).__init__(
            'frontegg:index/role:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            default: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            level: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            permission_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            vendor_id: Optional[pulumi.Input[str]] = None) -> 'Role':
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: The timestamp at which the role was created.
        :param pulumi.Input[bool] default: Whether the role should be applied to new users by default.
        :param pulumi.Input[str] description: A human-readable description of the role.
        :param pulumi.Input[str] key: A human-readable identifier for the role.
        :param pulumi.Input[int] level: The level of the role in the role hierarchy.
        :param pulumi.Input[str] name: A human-readable name for the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permission_ids: The IDs of the permissions that the role confers to its members.
        :param pulumi.Input[str] tenant_id: The ID of the tenant that owns the role.
        :param pulumi.Input[str] vendor_id: The ID of the vendor that owns the role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleState.__new__(_RoleState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["default"] = default
        __props__.__dict__["description"] = description
        __props__.__dict__["key"] = key
        __props__.__dict__["level"] = level
        __props__.__dict__["name"] = name
        __props__.__dict__["permission_ids"] = permission_ids
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["vendor_id"] = vendor_id
        return Role(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The timestamp at which the role was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def default(self) -> pulumi.Output[bool]:
        """
        Whether the role should be applied to new users by default.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A human-readable description of the role.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        A human-readable identifier for the role.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def level(self) -> pulumi.Output[int]:
        """
        The level of the role in the role hierarchy.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A human-readable name for the role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="permissionIds")
    def permission_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The IDs of the permissions that the role confers to its members.
        """
        return pulumi.get(self, "permission_ids")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The ID of the tenant that owns the role.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="vendorId")
    def vendor_id(self) -> pulumi.Output[str]:
        """
        The ID of the vendor that owns the role.
        """
        return pulumi.get(self, "vendor_id")

