# pyre-unsafe

from typing import Any, Dict, Iterable, Iterator, Optional, Union, overload

class HttpResponseBase(Iterator[bytes]):
    status_code: int
    reason_phrase: str
    def __init__(self, content_type=..., status=..., reason=..., charset=...): ...
    _headers: Dict[str, str]
    charset: str = ...
    cookies: Any = ...
    def set_cookie(
        self,
        key: str,
        value: str = ...,
        max_age: Any = ...,
        expires: Any = ...,
        path: str = ...,
        domain: Any = ...,
        secure: bool = ...,
        httponly: bool = ...,
    ) -> None: ...
    def set_signed_cookie(
        self, key: str, value: Any, salt: str = ..., **kwargs
    ) -> None: ...
    def delete_cookie(self, key: str, path: Optional[str] = ..., domain: Any = ...): ...
    streaming: bool = ...
    # We explicitly override __next__ here to avoid abstract class instantiation errors.
    def __next__(self) -> bytes: ...
    @overload
    def get(self, header: str) -> Optional[str]: ...
    @overload
    def get(self, header: str, alternate: str = ...) -> str: ...
    @overload
    def get(self, header: str, alternate: Optional[str] = ...) -> Optional[str]: ...
    def __getitem__(self, header: str) -> str: ...
    def __setitem__(self, header: str, value: Union[str, int]) -> None: ...
    def setdefault(self, header: str, value: Union[int, str]) -> None: ...
    def has_header(self, header: str) -> bool: ...

class HttpResponse(HttpResponseBase):
    def __init__(self, content=..., *args, **kwargs): ...
    _slipstream_error_name: Any = ...
    content: bytes = ...

class HttpResponseRedirect(HttpResponse):
    def __init__(self, redirect_to, *args, **kwargs): ...
    url: Any = ...

class HttpResponsePermanentRedirect(HttpResponseRedirect): ...
class Http404(Exception): ...
class HttpResponseForbidden(HttpResponse): ...
class HttpResponseBadRequest(HttpResponse): ...
class HttpResponseNotAllowed(HttpResponse): ...
class HttpResponseNotFound(HttpResponse): ...
class HttpResponseServerError(HttpResponse): ...

class StreamingHttpResponse(HttpResponseBase):
    def __init__(
        self,
        streaming_content=Iterable[bytes],
        content_type=...,
        status=...,
        reason=...,
        charset=...,
    ): ...
    streaming_content: Iterable[bytes]
