# AUTOGENERATED! DO NOT EDIT! File to edit: io.ipynb (unless otherwise specified).

__all__ = ['DOWNLOAD_DIR', 'download_file', 'untar_to', 'clone_gitrepo_and_return_path']

# Cell
import wget
import random
import sys
from pathlib import Path
import os
import tarfile
import zipfile
import hashlib

DOWNLOAD_DIR = os.path.join(str(Path.home()), '.wbs-tutorial')

# Cell
def download_file(url:str, fname:str=None, md5sum:str=None, with_progress:bool=False):
    if fname is None:
        fname = url.split('/')[-1]
    def show_progress(current, total, width=80):
        if random.randint(0,10) == 5:
            sys.stdout.flush()
        progress_message = "Downloading: %d%% [%d / %d] bytes\r" % (current / total * 100, current, total)
        return progress_message
    os.makedirs(DOWNLOAD_DIR, exist_ok=True)
    out_fname = os.path.join(DOWNLOAD_DIR, fname)
    downloaded = os.path.isfile(out_fname)
    if downloaded and md5sum is not None:
        with open(out_fname, 'rb') as f:
            md5 = hashlib.md5(f.read()).hexdigest()
            if md5 == md5sum:
                downloaded = True
                print (f'{out_fname} already downloaded')
            else:
                print (f'{out_fname} already downloaded, but hashsum is wrong')
                downloaded = False
    if not downloaded:
        print (f"Downloading {url}")
        if with_progress:
            wget.download(url, out_fname, show_progress)
        else:
            wget.download(url, out_fname)
        print ('Done')
    return out_fname

# Cell
def untar_to(fname, our_dir):
    tar = tarfile.open(fname, "r:gz")
    tar.extractall(our_dir)
    tar.close()
    return

# Cell
import subprocess
def clone_gitrepo_and_return_path(url: str, reponame:str):
    '''To simplify downloading the 3rd party repo'''
    BASE_DOWNLOAD_DIR = os.path.join(str(Path.home()), '.wbs-tutorial')
    os.makedirs(BASE_DOWNLOAD_DIR, exist_ok=True)
    subprocess.run(f'cd {BASE_DOWNLOAD_DIR} && git clone {url} --recursive {reponame}', shell=True,check=True, text=True)
    return  os.path.join(BASE_DOWNLOAD_DIR, reponame)