"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbTarget = exports.AlbArnTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * A single Application Load Balancer as the target for load balancing.
 *
 * @stability stable
 */
class AlbArnTarget {
    /**
     * Create a new alb target.
     *
     * @param albArn The ARN of the application load balancer to load balance to.
     * @param port The port on which the target is listening.
     * @stability stable
     */
    constructor(albArn, port) {
        this.albArn = albArn;
        this.port = port;
    }
    /**
     * Register this alb target with a load balancer.
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     *
     * @stability stable
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.ALB,
            targetJson: { id: this.albArn, port: this.port },
        };
    }
}
exports.AlbArnTarget = AlbArnTarget;
_a = JSII_RTTI_SYMBOL_1;
AlbArnTarget[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-targets.AlbArnTarget", version: "1.132.0" };
/**
 * A single Application Load Balancer as the target for load balancing.
 *
 * @stability stable
 */
class AlbTarget extends AlbArnTarget {
    /**
     * @param alb The application load balancer to load balance to.
     * @param port The port on which the target is listening.
     * @stability stable
     */
    constructor(alb, port) {
        super(alb.loadBalancerArn, port);
    }
}
exports.AlbTarget = AlbTarget;
_b = JSII_RTTI_SYMBOL_1;
AlbTarget[_b] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-targets.AlbTarget", version: "1.132.0" };
//# sourceMappingURL=data:application/json;base64,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