// STRAPS - Statistical Testing of RAndom Probing Security
// Copyright (C) 2021 UCLouvain
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

use super::es_graph::CompGraphWork;
use super::sl_sc::SlSharedCircuit;

/// Set of input shares required to simulate a set of probes.
pub fn sim_set<T: IntoIterator<Item = u32>>(circ: &SlSharedCircuit, probes: T) -> Vec<u32> {
    let probes = probes
        .into_iter()
        .map(|x| x as usize)
        .collect::<Vec<usize>>();
    let (mut c, _) = CompGraphWork::from_circ_probes(circ, probes.iter().copied());
    c.simplify();
    let inputs = c.inputs();
    return inputs;
}
