#line 1 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
// Copyright (c) Meta Platforms, Inc. and affiliates.
// SPDX-License-Identifier: LGPL-2.1-or-later

struct drgn_error *linux_kernel_object_find(const char *name, size_t name_len,
					    const char *filename,
					    enum drgn_find_object_flags flags,
					    void *arg, struct drgn_object *ret)
{
	struct drgn_program *prog = arg;
	if (!filename && (flags & DRGN_FIND_OBJECT_CONSTANT)) {
#line 13 "linux_kernel_object_find.inc"
		/* Generated by libdrgn/build-aux/gen_strswitch.py. */
		switch (1) {
		default: {
			#define memswitch0_args(ptr, len) \
				const void *memswitch0_ptr = (ptr); \
				const char *memswitch0_str = memswitch0_ptr; \
				size_t memswitch0_len = (len);
			memswitch0_args(
#line 11 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
		            name, name_len
#line 24 "linux_kernel_object_find.inc"
			)
			#undef memswitch0_args
			if (memswitch0_len == 7) {
				if (memcmp(&memswitch0_str[0], "vmemmap", sizeof("vmemmap") - 1) == 0) {
					memswitch0_case4:
#line 21 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			return linux_kernel_get_vmemmap(prog, ret);
#line 32 "linux_kernel_object_find.inc"
				}
			} else if (memswitch0_len == 9) {
				if (memcmp(&memswitch0_str[0], "PAGE_", sizeof("PAGE_") - 1) == 0) {
					if (memswitch0_str[5] == 'M') {
						if (memcmp(&memswitch0_str[6], "ASK", sizeof("ASK") - 1) == 0) {
							memswitch0_case2:
#line 17 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			return linux_kernel_get_page_mask(prog, ret);
#line 41 "linux_kernel_object_find.inc"
							goto memswitch0_case3;
						}
					} else if (memswitch0_str[5] == 'S') {
						if (memcmp(&memswitch0_str[6], "IZE", sizeof("IZE") - 1) == 0) {
							memswitch0_case1:
#line 15 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			return linux_kernel_get_page_size(prog, ret);
#line 49 "linux_kernel_object_find.inc"
							goto memswitch0_case2;
						}
					}
				}
			} else if (memswitch0_len == 10) {
				if (memcmp(&memswitch0_str[0], "PAGE_SHIFT", sizeof("PAGE_SHIFT") - 1) == 0) {
#line 13 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			return linux_kernel_get_page_shift(prog, ret);
#line 58 "linux_kernel_object_find.inc"
					goto memswitch0_case1;
				}
			} else if (memswitch0_len == 11) {
				if (memcmp(&memswitch0_str[0], "UTS_RELEASE", sizeof("UTS_RELEASE") - 1) == 0) {
					memswitch0_case3:
#line 19 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			return linux_kernel_get_uts_release(prog, ret);
#line 66 "linux_kernel_object_find.inc"
					goto memswitch0_case4;
				}
			}
		}
		}
#line 23 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
	}
	return &drgn_not_found;
}
