# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/bounding_boxes.ipynb (unless otherwise specified).

__all__ = ['iou', 'to_relative', 'to_absolute']

# Cell
import numpy as np
from .loader import *

def iou(bboxes1, bboxes2):
    bboxes1 = np.array(bboxes1)
    bboxes2 = np.array(bboxes2)
    x11, y11, x12, y12 = np.split(bboxes1, 4, axis=1)
    x21, y21, x22, y22 = np.split(bboxes2, 4, axis=1)
    xA = np.maximum(x11, np.transpose(x21))
    yA = np.maximum(y11, np.transpose(y21))
    xB = np.minimum(x12, np.transpose(x22))
    yB = np.minimum(y12, np.transpose(y22))
    interArea = np.maximum((xB - xA + 1), 0) * np.maximum((yB - yA + 1), 0)
    boxAArea = (x12 - x11 + 1) * (y12 - y11 + 1)
    boxBArea = (x22 - x21 + 1) * (y22 - y21 + 1)
    iou = interArea / (boxAArea + np.transpose(boxBArea) - interArea)
    return iou

# Cell

def to_relative(df, height, width):
    df = df.copy()
    df["x"] = df["x"] / width
    df["y"] = df["y"] / height
    df["X"] = df["X"] / width
    df["Y"] = df["Y"] / height
    return df

def to_absolute(df, height, width):
    df = df.copy()
    df["x"] = (df["x"] * width).astype(np.uint16)
    df["y"] = (df["y"] * height).astype(np.uint16)
    df["X"] = (df["X"] * width).astype(np.uint16)
    df["Y"] = (df["Y"] * height).astype(np.uint16)
    return df