# coding: utf-8
import abc
import collections.abc
import os
import sys
import types
import typing

class Alphabet(object):
    @classmethod
    def dna(self) -> Alphabet: ...
    @classmethod
    def rna(self) -> Alphabet: ...
    @classmethod
    def amino(self) -> Alphabet: ...
    def __repr__(self) -> str: ...
    def __eq__(self, other: object) -> bool: ...
    @property
    def K(self) -> int: ...
    @property
    def Kp(self) -> int: ...
    @property
    def symbols(self) -> str: ...

class Bitfield(typing.Sequence[bool]):
    def __init__(self, length: int) -> None: ...
    def __len__(self) -> int: ...
    @typing.overload
    def __getitem__(self, index: int) -> bool: ...
    @typing.overload
    def __getitem__(self, index: slice) -> typing.Sequence[bool]: ...
    def __setitem__(self, index: int, value: bool) -> None: ...
    def count(self, value: bool = True) -> int: ...
    def toggle(self, index: int) -> None: ...

class KeyHash(typing.Mapping[bytes, int]):
    def __init__(self) -> None: ...
    def __copy__(self) -> KeyHash: ...
    def __len__(self) -> int: ...
    def __contains__(self, value: object) -> bool: ...
    def __getitem__(self, item: bytes) -> int: ...
    def __iter__(self) -> typing.Iterator[bytes]: ...
    def clear(self) -> None: ...
    def copy(self) -> KeyHash: ...

class _MSASequences(typing.Sequence[Sequence], abc.ABC):
    def __len__(self) -> int: ...
    @abc.abstractmethod
    def __getitem__(self, idx: int) -> Sequence: ...  # type: ignore

class MSA(abc.ABC, typing.Sized):
    @abc.abstractmethod
    def __init__(
        self, nsequences: int, length: typing.Optional[int] = None
    ) -> None: ...
    def __copy__(self) -> MSA: ...
    def __eq__(self, other: object) -> bool: ...
    def __len__(self) -> int: ...
    @property
    def accession(self) -> typing.Optional[bytes]: ...
    @accession.setter
    def accession(self, accession: typing.Optional[bytes]) -> None: ...
    @property
    def author(self) -> typing.Optional[bytes]: ...
    @author.setter
    def author(self, author: typing.Optional[bytes]) -> None: ...
    @property
    def name(self) -> typing.Optional[bytes]: ...
    @name.setter
    def name(self, name: typing.Optional[bytes]) -> None: ...
    @property
    def description(self) -> typing.Optional[bytes]: ...
    @description.setter
    def description(self, description: typing.Optional[bytes]) -> None: ...
    @abc.abstractmethod
    def copy(self) -> MSA: ...
    def checksum(self) -> int: ...
    def write(self, fh: typing.BinaryIO, format: str) -> None: ...

class _TextMSASequences(_MSASequences, typing.Sequence[TextSequence]):
    def __init__(self, msa: TextMSA) -> None: ...
    def __getitem__(self, idx: int) -> TextSequence: ...  # type: ignore
    def __setitem__(self, idx: int, item: TextSequence) -> None: ...

class TextMSA(MSA):
    def __init__(
        self,
        name: typing.Optional[bytes] = None,
        description: typing.Optional[bytes] = None,
        accession: typing.Optional[bytes] = None,
        sequences: typing.Optional[typing.Iterable[TextSequence]] = None,
        author: typing.Optional[bytes] = None,
    ) -> None: ...
    def __copy__(self) -> TextMSA: ...
    def copy(self) -> TextMSA: ...
    def digitize(self, alphabet: Alphabet) -> DigitalMSA: ...
    @property
    def sequences(self) -> _TextMSASequences: ...

class _DigitalMSASequences(_MSASequences, typing.Sequence[DigitalSequence]):
    alphabet: Alphabet
    def __init__(self, msa: DigitalMSA) -> None: ...
    def __getitem__(self, idx: int) -> DigitalSequence: ...  # type: ignore
    def __setitem__(self, idx: int, item: DigitalSequence) -> None: ...

class DigitalMSA(MSA):
    alphabet: Alphabet
    def __init__(
        self,
        alphabet: Alphabet,
        name: typing.Optional[bytes] = None,
        description: typing.Optional[bytes] = None,
        accession: typing.Optional[bytes] = None,
        sequences: typing.Optional[typing.Iterable[DigitalSequence]] = None,
        author: typing.Optional[bytes] = None,
    ) -> None: ...
    def __copy__(self) -> DigitalMSA: ...
    def copy(self) -> DigitalMSA: ...
    def textize(self) -> TextMSA: ...
    @property
    def sequences(self) -> _DigitalMSASequences: ...

class MSAFile(typing.ContextManager[MSAFile], typing.Iterator[MSA]):
    alphabet: typing.Optional[Alphabet]
    def __init__(self, file: str, format: typing.Optional[str] = None) -> None: ...
    def __enter__(self) -> MSAFile: ...
    def __exit__(
        self,
        exc_type: typing.Optional[typing.Type[BaseException]],
        exc_value: typing.Optional[BaseException],
        traceback: typing.Optional[types.TracebackType],
    ) -> bool: ...
    def __iter__(self) -> MSAFile: ...
    def __next__(self) -> MSA: ...
    def read(self) -> typing.Optional[MSA]: ...
    def close(self) -> None: ...
    def guess_alphabet(self) -> typing.Optional[Alphabet]: ...
    def set_digital(self, alphabet: Alphabet) -> None: ...

class Sequence(typing.Sized, abc.ABC):
    @abc.abstractmethod
    def __init__(self) -> None: ...
    def __copy__(self) -> Sequence: ...
    def __len__(self) -> int: ...
    def __eq__(self, other: object) -> bool: ...
    @property
    def accession(self) -> bytes: ...
    @accession.setter
    def accession(self, accession: bytes) -> None: ...
    @property
    def description(self) -> bytes: ...
    @description.setter
    def description(self, description: bytes) -> None: ...
    @property
    def name(self) -> bytes: ...
    @name.setter
    def name(self, name: bytes) -> None: ...
    @property
    def source(self) -> bytes: ...
    @source.setter
    def source(self, src: bytes) -> None: ...
    def checksum(self) -> int: ...
    def clear(self) -> None: ...
    @abc.abstractmethod
    def copy(self) -> Sequence: ...
    def write(self, fh: typing.BinaryIO) -> None: ...
    if sys.version_info >= (3, 8):
        @typing.overload
        def reverse_complement(self, inplace: typing.Literal[True]) -> None: ...
        @typing.overload
        def reverse_complement(self, inplace: typing.Literal[False] = False) -> Sequence: ...
    else:
        @typing.overload
        def reverse_complement(self, inplace: bool = False) -> typing.Optional[Sequence]: ...

class TextSequence(Sequence):
    def __init__(
        self,
        name: bytes = None,
        description: bytes = None,
        accession: bytes = None,
        sequence: str = None,
        source: bytes = None,
    ) -> None: ...
    def copy(self) -> TextSequence: ...
    def digitize(self, alphabet: Alphabet) -> DigitalSequence: ...
    @property
    def sequence(self) -> str: ...
    if sys.version_info >= (3, 8):
        @typing.overload
        def reverse_complement(self, inplace: typing.Literal[True]) -> None: ...
        @typing.overload
        def reverse_complement(self, inplace: typing.Literal[False] = False) -> TextSequence: ...
    else:
        def reverse_complement(self, inplace: bool = False) -> typing.Optional[TextSequence]: ...

class DigitalSequence(Sequence):
    alphabet: Alphabet
    def __init__(
        self,
        alphabet: Alphabet,
        name: bytes = None,
        description: bytes = None,
        accession: bytes = None,
        sequence: str = None,
        source: bytes = None,
    ) -> None: ...
    def copy(self) -> DigitalSequence: ...
    def textize(self) -> TextSequence: ...
    @property
    def sequence(self) -> memoryview: ...
    if sys.version_info >= (3, 8):
        @typing.overload
        def reverse_complement(self, inplace: typing.Literal[True]) -> None: ...
        @typing.overload
        def reverse_complement(self, inplace: typing.Literal[False] = False) -> DigitalSequence: ...
    else:
        def reverse_complement(self, inplace: bool = False) -> typing.Optional[DigitalSequence]: ...

class SequenceFile(typing.ContextManager[SequenceFile], typing.Iterator[Sequence]):
    @classmethod
    def parse(cls, buffer: bytes, format: str) -> Sequence: ...
    @classmethod
    def parseinto(cls, seq: Sequence, buffer: bytes, format: str) -> Sequence: ...
    def __init__(self, file: str, format: typing.Optional[str] = None) -> None: ...
    def __enter__(self) -> SequenceFile: ...
    def __exit__(
        self,
        exc_type: typing.Optional[typing.Type[BaseException]],
        exc_value: typing.Optional[BaseException],
        traceback: typing.Optional[types.TracebackType],
    ) -> bool: ...
    def __iter__(self) -> SequenceFile: ...
    def __next__(self) -> Sequence: ...
    def read(self) -> typing.Optional[Sequence]: ...
    def read_info(self) -> typing.Optional[Sequence]: ...
    def read_seq(self) -> typing.Optional[Sequence]: ...
    def readinto(self, seq: Sequence) -> typing.Optional[Sequence]: ...
    def readinto_seq(self, seq: Sequence) -> typing.Optional[Sequence]: ...
    def readinto_info(self, seq: Sequence) -> typing.Optional[Sequence]: ...
    def close(self) -> None: ...
    def guess_alphabet(self) -> typing.Optional[Alphabet]: ...
    def set_digital(self, alphabet: Alphabet) -> None: ...

class SSIReader(object):
    def __init__(self, file: typing.Union[typing.AnyStr, os.PathLike[typing.AnyStr]]) -> None: ...
    def __enter__(self) -> SSIReader: ...
    def __exit__(
        self,
        exc_type: typing.Optional[typing.Type[BaseException]],
        exc_value: typing.Optional[BaseException],
        traceback: typing.Optional[types.TracebackType],
    ) -> bool: ...
    def close(self) -> None: ...

class SSIWriter(object):
    def __init__(self, file: typing.Union[typing.AnyStr, os.PathLike[typing.AnyStr]]) -> None: ...
    def __enter__(self) -> SSIWriter: ...
    def __exit__(
        self,
        exc_type: typing.Optional[typing.Type[BaseException]],
        exc_value: typing.Optional[BaseException],
        traceback: typing.Optional[types.TracebackType],
    ) -> bool: ...
    def add_alias(self, alias: bytes, key: bytes) -> None: ...
    def add_file(self, filename: str, format: int = 0) -> int: ...
    def add_key(
        self,
        key: bytes,
        fd: int,
        record_offset: int,
        data_offset: int = 0,
        record_length: int = 0
    ) -> None: ...
    def close(self) -> None: ...
