# This file is automatically generated for code intellisense only.
# It does not reflect the actual implementation.

from __future__ import annotations

from . import core

class BooleanTypes():
    """
    Defines the different type of boolean operations that are supported.
    """
    def __init__(self):
        pass
    DifferenceBooleanType = 0
    IntersectionBooleanType = 1
    UnionBooleanType = 2

class BRepConvertOptions():
    """
    Defines the various options when converting the geometry of a B-Rep body or face
    to NURBS. This is used by the convert method of the BRepBody and BRepFace objects.
    """
    def __init__(self):
        pass
    ProceduralToNURBSConversion = 0
    AnalyticsToNURBSConversion = 1
    PlanesToNURBSConversion = 2
    SplitPeriodicFacesConversion = 4

class BRepEntityTypes():
    """
    Used by the findBRepUsingRay and findBRepUsingPoint methods to specify the desired return type.
    """
    def __init__(self):
        pass
    BRepBodyEntityType = 0
    BRepFaceEntityType = 1
    BRepEdgeEntityType = 2
    BRepVertexEntityType = 3

class CalculationAccuracy():
    """
    The different accuracy settings for calculating area and physical property related values.
    The higher the accuracy setting, the longer it will take to perform the calculations.
    """
    def __init__(self):
        pass
    LowCalculationAccuracy = 0
    MediumCalculationAccuracy = 1
    HighCalculationAccuracy = 2
    VeryHighCalculationAccuracy = 3

class ChainedCurveOptions():
    """
    Controls options used when creating a Path and determining the rules for how curves are
    considered to be chained or connected.
    """
    def __init__(self):
        pass
    noChainedCurves = 0
    connectedChainedCurves = 1
    tangentChainedCurves = 2
    openEdgesChainedCurves = 3
    tangentAndOpenEdgesChainedCurves = 4

class ChamferCornerTypes():
    """
    Specifies the type of corner to model when multiple edges come together at a vertex.
    """
    def __init__(self):
        pass
    ChamferCornerType = 0
    MiterCornerType = 1
    BlendCornertype = 2

class ChamferTypes():
    """
    List of the different ways a chamfer can be defined.
    """
    def __init__(self):
        pass
    EqualDistanceChamferType = 0
    TwoDistancesChamferType = 1
    DistanceAndAngleChamferType = 2

class CoilFeatureSectionPositions():
    """
    List of the section positions of coil feature.
    """
    def __init__(self):
        pass
    InsideCoilFeatureSectionPosition = 0
    OnCenterCoilFeatureSectionPosition = 1
    OutsideCoilFeatureSectionPosition = 2

class CoilFeatureSectionTypes():
    """
    List of the section types of coil primitive feature.
    """
    def __init__(self):
        pass
    CircularCoilFeatureSectionType = 0
    SquareCoilFeatureSectionType = 1
    TriangularExternalCoilFeatureSectionType = 2
    TriangularInternalCoilFeatureSectionType = 3

class CoilFeatureTypes():
    """
    List of the coil types.
    """
    def __init__(self):
        pass
    RevolutionsAndHeightCoilFeatureType = 0
    RevolutionsAndPitchCoilFeatureType = 1
    HeightAndPitchCoilFeatureType = 2
    SpiralCoilFeatureType = 3

class CustomGraphicsBillBoardStyles():
    """
    Specifies the different styles that can be used to control billboarding.
    """
    def __init__(self):
        pass
    ScreenBillBoardStyle = 1
    AxialBillBoardStyle = 2
    RightReadingBillBoardStyle = 3

class CustomGraphicsCullModes():
    """
    The various culling modes supported by custom graphics.
    """
    def __init__(self):
        pass
    CustomGraphicsCullFront = 0
    CustomGraphicsCullBack = 1
    CustomGraphicsCullNone = 2

class CustomGraphicsPointTypes():
    """
    A list of predefined point images that you can use for a CustomGraphicsPointSet.
    """
    def __init__(self):
        pass
    UserDefinedCustomGraphicsPointType = 0
    PointCloudCustomGraphicsPointType = 1

class DefaultDesignTypeOptions():
    """
    The valid options for the Design History (default design type) setting.
    """
    def __init__(self):
        pass
    PromptForDesignTypeOption = 0
    DirectDesignTypeOption = 1
    ParametricDesignTypeOption = 2

class DefaultWorkspaces():
    """
    The valid options for the Default workspaces setting.
    """
    def __init__(self):
        pass
    ModelWorkspace = 0
    SculptWorkspace = 1
    PatchWorkspace = 2

class DeleteMeError():
    """
    Specific error types for DeleteMe methods.
    """
    def __init__(self):
        pass
    ParameterReferencedByOtherParameterError = 200

class DesignTypes():
    """
    Fusion 360 design types
    """
    def __init__(self):
        pass
    DirectDesignType = 0
    ParametricDesignType = 1

class DimensionOrientations():
    """
    The different dimension orientations.
    """
    def __init__(self):
        pass
    AlignedDimensionOrientation = 0
    HorizontalDimensionOrientation = 1
    VerticalDimensionOrientation = 2

class DistanceUnits():
    """
    Valid unit types for distance
    """
    def __init__(self):
        pass
    MillimeterDistanceUnits = 0
    CentimeterDistanceUnits = 1
    MeterDistanceUnits = 2
    InchDistanceUnits = 3
    FootDistanceUnits = 4

class ExpressionError():
    """
    The expression of the parameter. Setting this can fail because of an invalid expression or
    because a cyclic reference is created between parameters.
    """
    def __init__(self):
        pass
    CyclicParameterReferenceError = 200

class ExtentDirections():
    """
    List of the valid extent directions.
    """
    def __init__(self):
        pass
    PositiveExtentDirection = 0
    NegativeExtentDirection = 1
    SymmetricExtentDirection = 2

class FeatureExtentTypes():
    """
    Used to indicate which type of extent is used for a feature.
    """
    def __init__(self):
        pass
    OneSideFeatureExtentType = 0
    TwoSidesFeatureExtentType = 1
    SymmetricFeatureExtentType = 2

class FeatureHealthStates():
    """
    The various states that a feature can be in. This is used for the
    states of modeling features, construction geometry, and sketches.
    """
    def __init__(self):
        pass
    HealthyFeatureHealthState = 0
    WarningFeatureHealthState = 1
    ErrorFeatureHealthState = 2
    SuppressedFeatureHealthState = 3
    RolledBackFeatureHealthState = 4
    UnknownFeatureHealthState = 5

class FeatureOperations():
    """
    List of the different operations a feature can perform.
    """
    def __init__(self):
        pass
    JoinFeatureOperation = 0
    CutFeatureOperation = 1
    IntersectFeatureOperation = 2
    NewBodyFeatureOperation = 3
    NewComponentFeatureOperation = 4

class HoleEdgePositions():
    """
    List of the valid edge positions for holes.
    """
    def __init__(self):
        pass
    EdgeStartPointPosition = 0
    EdgeMidPointPosition = 1
    EdgeEndPointPosition = 2

class HoleTypes():
    """
    List of the different types of holes.
    """
    def __init__(self):
        pass
    SimpleHoleType = 0
    CounterboreHoleType = 1
    CountersinkHoleType = 2

class JointDirections():
    """
    Specifies the different types of directions that can be used to define directions of a joint.
    """
    def __init__(self):
        pass
    XAxisJointDirection = 0
    YAxisJointDirection = 1
    ZAxisJointDirection = 2
    CustomJointDirection = 3

class JointGeometryTypes():
    """
    List of the different types of ways that geometry for a joint can be defined.
    """
    def __init__(self):
        pass
    JointConstructionPointGeometry = 0
    JointSketchPointGeometry = 1
    JointBRepVertexGeometry = 2
    JointBRepEdgeGeometry = 3
    JointSketchCurveGeometry = 4
    JointProfileGeometry = 5
    JointPlanarBRepFaceGeometry = 6
    JointNonPlanarBRepFaceGeometry = 7
    JointBetweenTwoPlanesGeometry = 8

class JointKeyPointTypes():
    """
    List of the various keypoints of geometry that can be used when defining joint geometry.
    """
    def __init__(self):
        pass
    StartKeyPoint = 0
    MiddleKeyPoint = 1
    EndKeyPoint = 2
    CenterKeyPoint = 3

class JointTypes():
    """
    List of the various types of joints.
    """
    def __init__(self):
        pass
    RigidJointType = 0
    RevoluteJointType = 1
    SliderJointType = 2
    CylindricalJointType = 3
    PinSlotJointType = 4
    PlanarJointType = 5
    BallJointType = 6

class LineStylePatterns():
    """
    Specifies the line styles that can be applied to custom graphics lines and curves.
    """
    def __init__(self):
        pass
    continuousLineStylePattern = 0
    centerLineStylePattern = 1
    dashedLineStylePattern = 2
    dotLineStylePattern = 3
    hiddenLineStylePattern = 4
    phantomLineStylePattern = 5
    tracksLineStylePattern = 6
    zigzagLineStylePattern = 7

class MeshRefinementSettings():
    """
    The different refinement settings supported when exporting the design as an STL or 3MF file.
    """
    def __init__(self):
        pass
    MeshRefinementHigh = 0
    MeshRefinementMedium = 1
    MeshRefinementLow = 2
    MeshRefinementCustom = 3

class MeshUnits():
    """
    The unit types that can be specified when importing a .stl or .obj file as a mesh.
    """
    def __init__(self):
        pass
    CentimeterMeshUnit = 0
    MillimeterMeshUnit = 1
    MeterMeshUnit = 2
    InchMeshUnit = 3
    FootMeshUnit = 4

class OffsetCornerTypes():
    """
    Specifies the different types of corners that can be created when offsetting a wire body.
    """
    def __init__(self):
        pass
    CircularOffsetCornerType = 0
    LinearOffsetCornerType = 1
    ExtendedOffsetCornerType = 2

class PatternComputeOptions():
    """
    List of the compute options for mirroring and patterning features in the parametric modeling environment.
    """
    def __init__(self):
        pass
    OptimizedPatternCompute = 0
    IdenticalPatternCompute = 1
    AdjustPatternCompute = 2

class PatternDistanceType():
    """
    Defines the different ways to specify the spacing between elements in a pattern.
    """
    def __init__(self):
        pass
    ExtentPatternDistanceType = 0
    SpacingPatternDistanceType = 1

class PatternEntityTypes():
    """
    Specifies the different types of entities that can be patterned.
    """
    def __init__(self):
        pass
    FacesPatternType = 0
    FeaturesPatternType = 1
    BodiesPatternType = 2
    OccurrencesPatternType = 3

class PointContainment():
    """
    Types that define the nature of the relationship between a point and a containing entity.
    """
    def __init__(self):
        pass
    PointInsidePointContainment = 0
    PointOnPointContainment = 1
    PointOutsidePointContainment = 2
    UnknownPointContainment = 3

class RuledSurfaceCornerTypes():
    """
    List of Ruled Surface corner types.
    """
    def __init__(self):
        pass
    RoundedRuledSurfaceCornerType = 0
    MiteredRuledSurfaceCornerType = 1

class RuledSurfaceTypes():
    """
    List of Ruled Surface Types.
    """
    def __init__(self):
        pass
    TangentRuledSurfaceType = 0
    NormalRuledSurfaceType = 1
    DirectionRuledSurfaceType = 2

class SilhouetteSplitOperations():
    """
    List of Silhouette Split feature operations.
    """
    def __init__(self):
        pass
    SilhouetteSplitFacesOnlyOperation = 0
    SilhouetteSplitShelledBodyOperation = 1
    SilhouetteSplitSolidBodyOperation = 2

class SplitFaceSplitTypes():
    """
    List of the ways to split a face using the split face feature.
    """
    def __init__(self):
        pass
    surfaceIntersectionSplitType = 0
    alongVectorSplitType = 1
    closestPointSplitType = 2

class SurfaceContinuityTypes():
    """
    List of Surface Continuity Types.
    """
    def __init__(self):
        pass
    ConnectedSurfaceContinuityType = 0
    TangentSurfaceContinuityType = 1
    CurvatureSurfaceContinuityType = 2

class SurfaceExtendAlignment():
    """
    List of Surface Extend Alignments
    """
    def __init__(self):
        pass
    FreeEdges = 0
    AlignEdges = 1

class SurfaceExtendTypes():
    """
    List of Surface Extend Types.
    """
    def __init__(self):
        pass
    NaturalSurfaceExtendType = 0
    TangentSurfaceExtendType = 1
    PerpendicularSurfaceExtendType = 2

class SurfaceProjectTypes():
    """
    Used by the Sketch.projectToSurface method when defined how to project a curve onto a surface.
    """
    def __init__(self):
        pass
    ClosestPointSurfaceProjectType = 0
    AlongVectorSurfaceProjectType = 1

class SweepExtentTypes():
    """
    List of the types of sweep extent.
    """
    def __init__(self):
        pass
    PerpendicularToPathExtentType = 0
    FullExtentsExtentType = 1

class SweepOrientationTypes():
    """
    List of the types of sweep orientation.
    """
    def __init__(self):
        pass
    ParallelOrientationType = 0
    PerpendicularOrientationType = 1

class SweepProfileScalingOptions():
    """
    List of the sweep profile scaling options.
    """
    def __init__(self):
        pass
    SweepProfileScaleOption = 0
    SweepProfileStretchOption = 1
    SweepProfileNoScalingOption = 2

class TextBoxKeyPoints():
    """
    Defines the nine key points that exist for a sketch text box and
    can be used as the origin when rotating the text. The named positions
    are with respect to the text box. For example when the text box has
    not been rotated the top-left key point will be the point in the upper-left
    corner of the text box. If the text box has been rotated 180 degrees,
    the top-left key point will be the point in the lower-right corner of
    the text box.
    """
    def __init__(self):
        pass
    TopLeftTextBoxKeyPoint = 0
    TopMiddleTextBoxKeyPoint = 1
    TopRightTextBoxKeyPoint = 2
    MiddleLeftTextBoxKeyPoint = 3
    MiddleTextBoxKeyPoint = 4
    MiddleRightTextBoxKeyPoint = 5
    BottomLeftTextBoxKeyPoint = 6
    BottomMiddleTextBoxKeyPoint = 7
    BottomRightTextBoxKeyPoint = 8

class TextStyles():
    """
    Defines the various text style formatting options that can be applied to text. These are
    bitwise values to they can be combined.
    """
    def __init__(self):
        pass
    TextStyleBold = 1
    TextStyleItalic = 2
    TextStyleUnderline = 4

class ThinExtrudeWallLocation():
    """
    List of Thin Extrude Wall Locations
    """
    def __init__(self):
        pass
    Side1 = 0
    Center = 1
    Side2 = 2

class ThreadLocations():
    """
    List of the types of thread location.
    """
    def __init__(self):
        pass
    HighEndThreadLocation = 0
    LowEndThreadLocation = 1

class TriangleMeshQualityOptions():
    """
    Types that indicate the level of quality of a triangle mesh.
    """
    def __init__(self):
        pass
    LowQualityTriangleMesh = 8
    NormalQualityTriangleMesh = 11
    HighQualityTriangleMesh = 13
    VeryHighQualityTriangleMesh = 15

class UntrimLoopTypes():
    """
    List of Untrim Loop Types.
    """
    def __init__(self):
        pass
    AllLoopsUntrimType = 0
    ExternalLoopsUntrimType = 1
    InternalLoopsUntrimType = 2
    ManualLoopsUntrimType = 3

class ViewCorners():
    """
    Specifies which of the four view corners custom graphics will be drawn in relation to. The
    notUsedViewCorner setting indicates the graphics are not positioned with respect to the view.
    """
    def __init__(self):
        pass
    upperLeftViewCorner = 0
    upperRightViewCorner = 1
    lowerLeftViewCorner = 2
    lowerRightViewCorner = 3

class AreaProperties(core.Base):
    """
    The Area properties of a sketch profile or planar surface.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AreaProperties:
        return AreaProperties()
    def getPrincipalAxes(self) -> tuple[bool, core.Vector3D, core.Vector3D]:
        """
        Method that returns the principal axes.
        xAxis : The output Vector3D object that indicates the direction of the x axis.
        yAxis : The output Vector3D object that indicates the direction of the y axis.
        Returns true if successful
        """
        return (bool(), core.Vector3D(), core.Vector3D())
    def getMomentsOfInertia(self) -> tuple[bool, float, float, float, float, float, float]:
        """
        Method that, for a sketch, returns the moments of inertia about the sketch origin.
        For a planar face, this method returns the moments about the world coordinate system origin.
        Unit for returned values is kg/cm^2.
        ixx : Output Double that returns the XX partial moment.
        iyy : Output Double that returns the YY partial moment.
        izz : Output Double that returns the ZZ partial moment.
        ixy : Output Double that returns the XY partial moment.
        iyz : Output Double that returns the YZ partial moment.
        ixz : Output Double that returns the XZ partial moment.
        Returns true if successful
        """
        return (bool(), float(), float(), float(), float(), float(), float())
    def getCentroidMomentsOfInertia(self) -> tuple[bool, float, float, float, float, float, float]:
        """
        Method that returns the moments of inertia about the centroid. Unit for returned values is kg/cm^2.
        ixx : Output Double that returns the XX partial moment.
        iyy : Output Double that returns the YY partial moment.
        izz : Output Double that returns the ZZ partial moment.
        ixy : Output Double that returns the XY partial moment.
        iyz : Output Double that returns the YZ partial moment.
        ixz : Output Double that returns the XZ partial moment.
        Returns true if successful
        """
        return (bool(), float(), float(), float(), float(), float(), float())
    def getPrincipalMomentsOfInertia(self) -> tuple[bool, float, float, float]:
        """
        Method that returns the moments of inertia about the principal axes. Unit for returned values is kg/cm^2.
        i1 : Output Double that specifies the first moment of inertia.
        i2 : Output Double that specifies the second moment of inertia.
        i3 : Output Double that specifies the third moment of inertia.
        Returns true if successful
        """
        return (bool(), float(), float(), float())
    def getRadiusOfGyration(self) -> tuple[bool, float, float, float]:
        """
        Method that returns the radius of gyration about the principal axes. Unit for returned values is cm.
        kxx : Output Double that returns the X partial radius of gyration.
        kyy : Output Double that returns the Y partial radius of gyration.
        kzz : Output Double that returns the Z partial radius of gyration.
        Returns true if successful
        """
        return (bool(), float(), float(), float())
    @property
    def area(self) -> float:
        """
        Gets the area in the square centimeters.
        """
        return float()
    @property
    def centroid(self) -> core.Point3D:
        """
        Gets the centroid where the units are centimeters.
        The Location is relative to the sketch origin for a profile or relative to the world coordinate system for a planar face.
        """
        return core.Point3D()
    @property
    def perimeter(self) -> float:
        """
        Gets the perimeter in centimeters.
        The perimeter is the sum of the length of all the curves or edges of the profile or planar surface
        """
        return float()
    @property
    def rotationToPrincipal(self) -> float:
        """
        Gets the angle of rotation of the principal axes.
        """
        return float()
    @property
    def accuracy(self) -> CalculationAccuracy:
        """
        Returns the accuracy that was used for the calculation.
        """
        return CalculationAccuracy()

class AsBuiltJoint(core.Base):
    """
    Represent an as-built joint.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AsBuiltJoint:
        return AsBuiltJoint()
    def deleteMe(self) -> bool:
        """
        Deletes this as-built joint.
        Returns true if the delete was successful.
        """
        return bool()
    def setAsRigidJointMotion(self) -> bool:
        """
        Redefines the relationship between the two joint geometries as a rigid joint.
        
        To use this method, you need to position the timeline marker to immediately before this as-built joint.
        This can be accomplished using the following code: thisAsBuiltJoint.timelineObject.rollTo(True)
        Returns true if successful.
        """
        return bool()
    def setAsRevoluteJointMotion(self, rotationAxis: JointDirections, geometry: JointGeometry, customRotationAxisEntity: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a revolute joint.
        
        To use this method, you need to position the timeline marker to immediately before this as-built joint.
        This can be accomplished using the following code: thisAsBuiltJoint.timelineObject.rollTo(True)
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        geometry : Redefines the joint geometry. If not provided, the existing geometry is used. This argument is
        required if the current joint motion is rigid.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        from.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsSliderJointMotion(self, sliderDirection: JointDirections, geometry: JointGeometry, customSliderDirectionEntity: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a slider joint.
        
        To use this method, you need to position the timeline marker to immediately before this as-built joint.
        This can be accomplished using the following code: thisAsBuiltJoint.timelineObject.rollTo(True)
        sliderDirection : Specifies which axis the slide direction is along. If this is set to CustomJointDirection then the
        customSliderDirectionEntity argument must also be provided.
        geometry : Redefines the joint geometry. If not provided, the existing geometry is used. This argument is
        required if the current joint motion is rigid.
        customSliderDirectionEntity : If the sliderDirection is CustomJointDirection this argument is used to specify the entity that defines
        the custom slider direction. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsCylindricalJointMotion(self, rotationAxis: JointDirections, geometry: JointGeometry, customRotationAxisEntity: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a cylindrical joint.
        
        To use this method, you need to position the timeline marker to immediately before this as-built joint.
        This can be accomplished using the following code: thisAsBuiltJoint.timelineObject.rollTo(True)
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        geometry : Redefines the joint geometry. If not provided, the existing geometry is used. This argument is
        required if the current joint motion is rigid.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        from.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsPinSlotJointMotion(self, rotationAxis: JointDirections, slideDirection: JointDirections, geometry: JointGeometry, customRotationAxisEntity: core.Base, customSlideDirectionEntity: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a pin-slot joint.
        
        To use this method, you need to position the timeline marker to immediately before this as-built joint.
        This can be accomplished using the following code: thisAsBuiltJoint.timelineObject.rollTo(True)
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        slideDirection : Specifies which axis the slide direction is along. If this is set to CustomJointDirection then the
        customSlideDirectionEntity argument must also be provided.
        geometry : Redefines the joint geometry. If not provided, the existing geometry is used. This argument is
        required if the current joint motion is rigid.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        customSlideDirectionEntity : If the slideDirection is CustomJointDirection this argument is used to specify the entity that defines
        the custom slide direction. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsPlanarJointMotion(self, normalDirection: JointDirections, geometry: JointGeometry, customNormalDirectionEntity: core.Base, customPrimarySlideDirection: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a planar joint.
        
        To use this method, you need to position the timeline marker to immediately before this as-built joint.
        This can be accomplished using the following code: thisAsBuiltJoint.timelineObject.rollTo(True)
        normalDirection : Defines the direction of the normal of the single degree of rotation.
        This can be set to XAxisJointDirection, YAxisJointDirection, ZAxisJointDirection,
        or CustomJointDirection. If set to CustomJointDirection then the customNormalDirectionEntity
        argument must also be provided.
        geometry : Redefines the joint geometry. If not provided, the existing geometry is used. This argument is
        required if the current joint motion is rigid.
        customNormalDirectionEntity : If the normalDirection is CustomJointDirection this argument is used to specify the entity that defines
        the direction of the normal. This can be several types of entities that can define a direction.
        customPrimarySlideDirection : This arguments defines the direction of the primary slide direction. A default primary slide direction
        is automatically chosen and will be used if this argument is not provided or is null. The secondary slide
        direction is automatically inferred from the normal and primary slide directions.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsBallJointMotion(self, pitchDirection: JointDirections, yawDirection: JointDirections, geometry: JointGeometry, customPitchDirection: core.Base, customYawDirection: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a ball joint.
        
        To use this method, you need to position the timeline marker to immediately before this as-built joint.
        This can be accomplished using the following code: thisAsBuiltJoint.timelineObject.rollTo(True)
        pitchDirection : Defines the direction the pitch angle is measured from. This can be ZAxisJointDirection or CustomJointDirection. If
        CustomJointDirection is specified then you must also provide a value for the customPitchDirection argument.
        yawDirection : Defines the direction the yaw is measured from. This can be XAxisJointDirection or CustomJointDirection. If
        CustomJointDirection is specified then you must also provide a value for the customYawDirection argument.
        geometry : Redefines the joint geometry. If not provided, the existing geometry is used. This argument is
        required if the current joint motion is rigid.
        customPitchDirection : If the pitchDirection argument is customPitchDirection this argument is used to define the direction the pitch
        angel is measured from. This can be several types of entities that can define a direction.
        customYawDirection : If the yawDirection argument is customPitchDirection this argument is used to define the direction the yaw
        angel is measured from. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> AsBuiltJoint:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return AsBuiltJoint()
    @property
    def parentComponent(self) -> Component:
        """
        Returns the parent component that owns this AsBuiltJoint.
        """
        return Component()
    @property
    def name(self) -> str:
        """
        The name of the as-built joint as it is displayed in the timeline and the browser. The
        name can be changed.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        The name of the as-built joint as it is displayed in the timeline and the browser. The
        name can be changed.
        """
        pass
    @property
    def occurrenceOne(self) -> Occurrence:
        """
        Specifies the first of two occurrences the joint is between.
        """
        return Occurrence()
    @property
    def occurrenceTwo(self) -> Occurrence:
        """
        Specifies the second of two occurrences the joint is between.
        """
        return Occurrence()
    @property
    def geometry(self) -> JointGeometry:
        """
        Specifies the position of the joint. Getting this property will return null and
        setting it will be ignored in the case where the joint motion is rigid.
        
        To set this property, you need to position the timeline marker to immediately before this as-built joint.
        This can be accomplished using the following code: thisAsBuiltJoint.timelineObject.rollTo(True)
        """
        return JointGeometry()
    @geometry.setter
    def geometry(self, value: JointGeometry):
        """
        Specifies the position of the joint. Getting this property will return null and
        setting it will be ignored in the case where the joint motion is rigid.
        
        To set this property, you need to position the timeline marker to immediately before this as-built joint.
        This can be accomplished using the following code: thisAsBuiltJoint.timelineObject.rollTo(True)
        """
        pass
    @property
    def timelineObject(self) -> TimelineObject:
        """
        Returns the timeline object associated with this as-built joint.
        """
        return TimelineObject()
    @property
    def jointMotion(self) -> JointMotion:
        """
        Returns a JointMotion object that defines the motion relationship between the two geometries.
        """
        return JointMotion()
    @property
    def nativeObject(self) -> AsBuiltJoint:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return AsBuiltJoint()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def isSuppressed(self) -> bool:
        """
        Gets and sets if this as-built joint is suppressed.
        """
        return bool()
    @isSuppressed.setter
    def isSuppressed(self, value: bool):
        """
        Gets and sets if this as-built joint is suppressed.
        """
        pass
    @property
    def isLightBulbOn(self) -> bool:
        """
        Gets and sets if the light bulb of this as-built joint as displayed in the browser is on or off.
        A joint will only be visible if the light bulb is switched on. However,
        the light bulb can be on and the joint still invisible if a higher level occurrence
        in the assembly context is not visible because its light bulb is off or the joints folder
        is light bulb is off.
        """
        return bool()
    @isLightBulbOn.setter
    def isLightBulbOn(self, value: bool):
        """
        Gets and sets if the light bulb of this as-built joint as displayed in the browser is on or off.
        A joint will only be visible if the light bulb is switched on. However,
        the light bulb can be on and the joint still invisible if a higher level occurrence
        in the assembly context is not visible because its light bulb is off or the joints folder
        is light bulb is off.
        """
        pass
    @property
    def isVisible(self) -> bool:
        """
        Gets whether the as-built joint is visible. To change the visibility see the isLightBulbOn property.
        This property is affected by the assembly context.
        """
        return bool()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this as-built joint.
        """
        return core.Attributes()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the AsBuiltJoint object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same as-built joint.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class AsBuiltJointInput(core.Base):
    """
    Defines all of the information needed to create an as-built joint.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AsBuiltJointInput:
        return AsBuiltJointInput()
    def setAsRigidJointMotion(self) -> bool:
        """
        Defines the relationship between the two joint geometries as a rigid joint.
        Returns true if successful.
        """
        return bool()
    def setAsRevoluteJointMotion(self, rotationAxis: JointDirections, customRotationAxisEntity: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a revolute joint.
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        from.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsSliderJointMotion(self, sliderDirection: JointDirections, customSliderDirectionEntity: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a slider joint.
        sliderDirection : Specifies which axis the slide direction is along. If this is set to CustomJointDirection then the
        customSliderDirectionEntity argument must also be provided.
        customSliderDirectionEntity : If the sliderDirection is CustomJointDirection this argument is used to specify the entity that defines
        the custom slider direction. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsCylindricalJointMotion(self, rotationAxis: JointDirections, customRotationAxisEntity: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a cylindrical joint.
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        from.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsPinSlotJointMotion(self, rotationAxis: JointDirections, slideDirection: JointDirections, customRotationAxisEntity: core.Base, customSlideDirectionEntity: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a pin-slot joint.
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        slideDirection : Specifies which axis the slide direction is along. If this is set to CustomJointDirection then the
        customSlideDirectionEntity argument must also be provided.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        customSlideDirectionEntity : If the slideDirection is CustomJointDirection this argument is used to specify the entity that defines
        the custom slide direction. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsPlanarJointMotion(self, normalDirection: JointDirections, customNormalDirectionEntity: core.Base, customPrimarySlideDirection: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a planar joint.
        normalDirection : Defines the direction of the normal of the single degree of rotation.
        This can be set to XAxisJointDirection, YAxisJointDirection, ZAxisJointDirection,
        or CustomJointDirection. If set to CustomJointDirection then the customNormalDirectionEntity
        argument must also be provided.
        customNormalDirectionEntity : If the normalDirection is CustomJointDirection this argument is used to specify the entity that defines
        the direction of the normal. This can be several types of entities that can define a direction.
        customPrimarySlideDirection : This arguments defines the direction of the primary slide direction. A default primary slide direction
        is automatically chosen and will be used if this argument is not provided or is null. The secondary slide
        direction is automatically inferred from the normal and primary slide directions.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsBallJointMotion(self, pitchDirection: JointDirections, yawDirection: JointDirections, customPitchDirection: core.Base, customYawDirection: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a ball joint.
        pitchDirection : Defines the direction the pitch angle is measured from. This can be ZAxisJointDirection or CustomJointDirection. If
        CustomJointDirection is specified then you must also provide a value for the customPitchDirection argument.
        yawDirection : Defines the direction the yaw is measured from. This can be XAxisJointDirection or CustomJointDirection. If
        CustomJointDirection is specified then you must also provide a value for the customYawDirection argument.
        customPitchDirection : If the pitchDirection argument is customPitchDirection this argument is used to define the direction the pitch
        angel is measured from. This can be several types of entities that can define a direction.
        customYawDirection : If the yawDirection argument is customPitchDirection this argument is used to define the direction the yaw
        angel is measured from. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    @property
    def occurrenceOne(self) -> Occurrence:
        """
        Specifies the first of two occurrences the joint is between.
        """
        return Occurrence()
    @occurrenceOne.setter
    def occurrenceOne(self, value: Occurrence):
        """
        Specifies the first of two occurrences the joint is between.
        """
        pass
    @property
    def occurrenceTwo(self) -> Occurrence:
        """
        Specifies the second of two occurrences the joint is between.
        """
        return Occurrence()
    @occurrenceTwo.setter
    def occurrenceTwo(self, value: Occurrence):
        """
        Specifies the second of two occurrences the joint is between.
        """
        pass
    @property
    def geometry(self) -> JointGeometry:
        """
        Specifies the position of the joint.
        """
        return JointGeometry()
    @geometry.setter
    def geometry(self, value: JointGeometry):
        """
        Specifies the position of the joint.
        """
        pass
    @property
    def jointMotion(self) -> JointMotion:
        """
        Returns one of the objects derived from JointMotion that defines how the motion between
        the two joint geometries is defined. Can be null if the motion hasn't yet been defined.
        """
        return JointMotion()

class AsBuiltJointList(core.Base):
    """
    A list of as-built joints.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AsBuiltJointList:
        return AsBuiltJointList()
    def item(self, index: int) -> AsBuiltJoint:
        """
        Function that returns the specified as-built joint using an index into the list.
        index : The index of the item within the list to return. The first item in the list has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return AsBuiltJoint()
    def itemByName(self, name: str) -> AsBuiltJoint:
        """
        Function that returns the specified as-built joint using a name.
        name : The name of the item within the list to return.
        Returns the specified item or null if an invalid name was specified.
        """
        return AsBuiltJoint()
    @property
    def count(self) -> int:
        """
        Returns number of as-built joints in the list.
        """
        return int()

class AsBuiltJoints(core.Base):
    """
    The collection of as-built joints in this component. This provides access to all existing
    as-built joints and supports the ability to create new as-built joints.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AsBuiltJoints:
        return AsBuiltJoints()
    def item(self, index: int) -> AsBuiltJoint:
        """
        Function that returns the specified as-built joint using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return AsBuiltJoint()
    def itemByName(self, name: str) -> AsBuiltJoint:
        """
        Function that returns the specified as-built joint using a name.
        name : The name of the item within the collection to return.
        Returns the specified item or null if an invalid name was specified.
        """
        return AsBuiltJoint()
    def createInput(self, occurrenceOne: Occurrence, occurrenceTwo: Occurrence, geometry: JointGeometry) -> AsBuiltJointInput:
        """
        Creates an AsBuiltJointInput object which is used to collect all of the information needed
        to create an as-built joint. This object is equivalent to the as-built joint dialog in the
        user-interface in that it doesn't represent an actual joint but just the information needed
        to create an as-built joint. Once this is fully defined the add method can be called, passing
        this object in to create the actual joint.
        occurrenceOne : Specifies the first of two occurrences the joint is between.
        occurrenceTwo : Specifies the second of two occurrences the joint is between.
        geometry : Specifies the geometry of where the joint will be positioned. If the as-built joint is
        a rigid joint, this argument should be null because no geometry is needed.
        Returns the new AsBuiltJointInput object or null in the case of failure.
        """
        return AsBuiltJointInput()
    def add(self, input: AsBuiltJointInput) -> AsBuiltJoint:
        """
        Creates a new as-built joint.
        input : An AsBuiltJointInput object that was created using the AsBuiltJoints.createInput method and then fully defined
        using the properties and methods on the AsBuiltJointInput object.
        Returns the new AsBuiltJoint object or null in the case of failure.
        """
        return AsBuiltJoint()
    @property
    def count(self) -> int:
        """
        Returns number of joint origins in the collection.
        """
        return int()

class BaseComponent(core.Base):
    """
    The BaseComponent object that defines all of the common design data
    and is the base class for the product specific components.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BaseComponent:
        return BaseComponent()
    def occurrencesByComponent(self, component: Component) -> OccurrenceList:
        """
        Returns all occurrences at the top-level of this component that reference the specified component.
        The returned list is read-only.
        component : The component that is being referenced by the occurrences that will be returned.
        The occurrences referenced by the specified component.
        """
        return OccurrenceList()
    def allOccurrencesByComponent(self, component: Component) -> OccurrenceList:
        """
        Returns all occurrences, at any level of the assembly, that reference the specified component.
        The returned list is read-only.
        component : The component that is being referenced by the occurrences that will be returned.
        The occurrences referenced by the specified component.
        """
        return OccurrenceList()
    def findBRepUsingRay(self, originPoint: core.Point3D, rayDirection: core.Vector3D, entityType: BRepEntityTypes, proximityTolerance: float, visibleEntitiesOnly: bool, hitPoints: core.ObjectCollection) -> core.ObjectCollection:
        """
        Finds all the B-Rep entities that are intersected by the specified ray. This can return BRepFace, BrepEdge,
        and BRepVertex objects.
        originPoint : Input point that defines the origin of the ray. The search for entities begins at this point.
        rayDirection : Input vector that defines the direction of the ray. The ray is infinite so the length of the vector is ignored.
        entityType : The type of B-Rep entity wanted. You can also take advantage of B-Rep topology to infer other intersections. For example,
        If you get a BRepEdge it implies that the faces the edge connects were also intersected. If a BRepVertex is returned it
        implies the edges that the vertex connects were intersected and the faces that the edges connect were intersected.
        proximityTolerance : Optional argument that specifies the tolerance for the search. All entities within this distance from the ray and of the specified type will be returned. If not specified a default small tolerance is used.
        visibleEntitiesOnly : Optional argument that indicates whether or not invisible entities should be included in the search. Defaults to True indicating that invisible entities will be ignored.
        hitPoints : An ObjectCollection of Point3D objects that represent the coordinates where the ray hit the found entity. There will be the same number of hit points as returned entities
        and they will be in the collections in the same order. In other words, hit point 1 corresponds with found entity 1, hit point 2 corresponds with found entity 2, and so on.
        Because of the proximity tolerance the hitPoint may not actually lie on the entity but will be within the proximity tolerance to it.
        It's an optional out argument, returns the hit points if an existing ObjectCollection is input. You can create a new ObjectCollection by using
        the static create method on the ObjectCollection class.
        Returns an ObjectCollection containing the entities found. The returned collection can be empty indicating nothing was found. The points are returned
        in an order where they are arranged based on their distance from the origin point where the closest point is first. If an entity is hit more than
        once, the entity is returned once for the first intersection.
        """
        return core.ObjectCollection()
    def findBRepUsingPoint(self, point: core.Point3D, entityType: BRepEntityTypes, proximityTolerance: float, visibleEntitiesOnly: bool) -> core.ObjectCollection:
        """
        Finds all the entities of the specified type at the specified location.
        point : Input coordinate that specifies the component space point at which to find the entities.
        entityType : The type of B-Rep entity wanted. You can also take advantage of B-Rep topology to infer other that other entities were found. For example,
        If you get a BRepEdge it implies that the faces the edge connects were also found. If a BRepVertex is returned it
        implies the edges that the vertex connects were found and the faces that the edges connect were found.
        proximityTolerance : Specifies the tolerance for the search. All entities within this distance from the search point that match the filter will be returned. If not specified a default tolerance is used.
        visibleEntitiesOnly : indicates whether or not invisible objects should be included in the search. Defaults to True indicating that invisible objects will be ignored.
        Returns an ObjectCollection containing the entities found. The returned collection can be empty indicating nothing was found.
        """
        return core.ObjectCollection()
    @property
    def name(self) -> str:
        """
        Property that gets and sets the name of this component. This is the name
        shown in the browser for each occurrence referencing this component.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Property that gets and sets the name of this component. This is the name
        shown in the browser for each occurrence referencing this component.
        """
        pass
    @property
    def occurrences(self) -> Occurrences:
        """
        Property that returns the Occurrences collection associated with this component.
        This provides access to the occurrences at the top-level of this component and provides
        the functionality to add new occurrences.
        """
        return Occurrences()
    @property
    def allOccurrences(self) -> OccurrenceList:
        """
        Returns all of the occurrences in the assembly regardless of their level within the assembly structure.
        The returned list is read-only.
        """
        return OccurrenceList()
    @property
    def constructionPlanes(self) -> ConstructionPlanes:
        """
        Returns the construction planes collection associated with this component.
        This provides access to the existing construction planes and supports
        the creation of new construction planes.
        """
        return ConstructionPlanes()
    @property
    def constructionAxes(self) -> ConstructionAxes:
        """
        Returns the construction axes collection associated with this component.
        This provides access to the existing construction axes and supports
        the creation of new construction axes.
        """
        return ConstructionAxes()
    @property
    def constructionPoints(self) -> ConstructionPoints:
        """
        Returns the construction points collection associated with this component.
        This provides access to the existing construction points and supports
        the creation of new construction points.
        """
        return ConstructionPoints()
    @property
    def bRepBodies(self) -> BRepBodies:
        """
        Returns the B-Rep bodies collection associated with this component.
        """
        return BRepBodies()
    @property
    def parentDesign(self) -> Design:
        """
        Returns the parent product this component is owned by.
        """
        return Design()

class BaseFeatures(core.Base):
    """
    The BaseFeature class represents a direct edit feature within a parametric design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BaseFeatures:
        return BaseFeatures()
    def item(self, index: int) -> BaseFeature:
        """
        Function that returns the specified base feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BaseFeature()
    def itemByName(self, name: str) -> BaseFeature:
        """
        Function that returns the specified base feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return BaseFeature()
    def add(self) -> BaseFeature:
        """
        Creates a new empty base feature in the parent component.
        Returns the new BaseFeature or null in the case of an error.
        """
        return BaseFeature()
    @property
    def count(self) -> int:
        """
        The number of base features in the collection.
        """
        return int()

class BoundaryFillFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a BoundaryFillFeatureInput.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BoundaryFillFeatureInput:
        return BoundaryFillFeatureInput()
    def cancel(self) -> bool:
        """
        To determine the possible boundaries and allow you to choose which cells to keep, the boundary
        fill feature does a partial compute when the input object is created. To do this it starts a boundary
        fill feature transaction and completes the transaction when you call the add method. If you don't
        call the add method to finish the transaction it leaves Fusion 360 in a bad state and there will be undo
        problems and possibly a crash. If you have created a BoundFillFeatureInput object and don't want to finish
        the feature creation, you need to call the cancel method on the BoundaryFillFeatureInput object to
        safely abort the current boundary fill transaction.
        """
        return bool()
    @property
    def bRepCells(self) -> BRepCells:
        """
        Returns the collection of the valid cells that have been calculated based on the set of input tools.
        You use this collection to specify which cells you want included in the output.
        """
        return BRepCells()
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the type of operation performed by the boundary fill feature.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the type of operation performed by the boundary fill feature.
        """
        pass
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Boundary Fill is created based on geometry (e.g. a profile and/or face(s))
        in another component AND (the Boundary Fill) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Boundary Fill is created based on geometry (e.g. a profile and/or face(s))
        in another component AND (the Boundary Fill) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        pass
    @property
    def tools(self) -> core.ObjectCollection:
        """
        Gets and sets the collection of one or more construction planes and open or closed
        BRepBody objects that are used in calculating the possible closed boundaries.
        """
        return core.ObjectCollection()
    @tools.setter
    def tools(self, value: core.ObjectCollection):
        """
        Gets and sets the collection of one or more construction planes and open or closed
        BRepBody objects that are used in calculating the possible closed boundaries.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class BoundaryFillFeatures(core.Base):
    """
    Collection that provides access to all of the existing boundary fill features in a component
    and supports the ability to create new boundary fill features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BoundaryFillFeatures:
        return BoundaryFillFeatures()
    def item(self, index: int) -> BoundaryFillFeature:
        """
        Function that returns the specified boundary fill feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BoundaryFillFeature()
    def createInput(self, tools: core.ObjectCollection, operation: FeatureOperations) -> BoundaryFillFeatureInput:
        """
        Creates a BoundaryFillFeatureInput object. Use properties and methods on this object
        to define the boundary fill you want to create and then use the Add method, passing in
        the BoundaryFillFeatureInput object.
        
        To determine the possible boundaries and allow you to choose which cells to keep, the boundary
        fill feature does a partial compute when the input object is created. To do this it starts a boundary
        fill feature transaction and completes the transaction when you call the add method. If you don't
        call the add method to finish the transaction it leaves Fusion 360 in a bad state and there will be undo
        problems and possibly a crash. If you have created a BoundFillFeatureInput object and don't want to finish
        the feature creation, you need to call the cancel method on the BoundaryFillFeatureInput object to
        safely abort the current boundary fill transaction.
        tools : A collection of one or more construction planes and open or closed BRepBody objects that will be
        used in calculating the possible closed boundaries.
        operation : The operation type to perform.
        Returns the newly created BoundaryFillFeatureInput object or null if the creation failed.
        """
        return BoundaryFillFeatureInput()
    def add(self, input: BoundaryFillFeatureInput) -> BoundaryFillFeature:
        """
        Creates a new boundary fill feature.
        input : A BoundaryFillFeatureInput object that defines the desired boundary fill feature. Use the createInput
        method to create a new BoundaryFillFeatureInput object and then use methods on it
        (the BoundaryFillFeatureInput object) to define the boundary fill feature.
        Returns the newly created BoundaryFillFeature object or null if the creation failed.
        """
        return BoundaryFillFeature()
    def itemByName(self, name: str) -> BoundaryFillFeature:
        """
        Function that returns the specified boundary fill feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return BoundaryFillFeature()
    @property
    def count(self) -> int:
        """
        The number of boundary fill features in the collection.
        """
        return int()

class BoxFeatures(core.Base):
    """
    Collection that provides access to all of the existing box features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BoxFeatures:
        return BoxFeatures()
    def item(self, index: int) -> BoxFeature:
        """
        Function that returns the specified box feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BoxFeature()
    def itemByName(self, name: str) -> BoxFeature:
        """
        Function that returns the specified box feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return BoxFeature()
    @property
    def count(self) -> int:
        """
        The number of box features in the collection.
        """
        return int()

class BRepBodies(core.Base):
    """
    The BRepBodies collection provides access to all of the B-Rep
    bodies within a component.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepBodies:
        return BRepBodies()
    def item(self, index: int) -> BRepBody:
        """
        Function that returns the specified body using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepBody()
    def itemByName(self, name: str) -> BRepBody:
        """
        Returns a specific body using the name of the body within the collection.
        name : The name of the body, as seen in the browser, to return.
        The BRepBody or null if a body with the defined name is not found.
        """
        return BRepBody()
    def add(self, body: BRepBody, targetBaseFeature: BaseFeature) -> BRepBody:
        """
        Creates a new BRepBody object. The input can be a persisted or transient BRepBody and the
        result is a persisted BRepBody. In a model where the design history is ignored (direct edit model)
        the BRepBody is created within the component the BRepBodies collection was obtained from. In
        a model where the design history is captured (parametric model), the new BRepBody is created
        within the specified Base Feature.
        
        Because of a current limitation, if you want to create a BRepBody in a parametric model,
        you must first call the edit method of the base feature, then use the add method to create
        the body, and finally call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        body : The input BRepBody. Typically this is a transient BRepBody but that's not a requirement. In
        any case, there is not any association back to the original BRepBody.
        targetBaseFeature : The BaseFeature object that this B-Rep body will be associated with. This is an optional
        requirement but is required when the model design history is being captured (parametric model) but is
        ignored otherwise (direct edit model).
        Returns the newly created BRepBody or null if the creation failed.
        """
        return BRepBody()
    @property
    def count(self) -> int:
        """
        Returns the number of bodies in the collection.
        """
        return int()

class BRepBody(core.Base):
    """
    Represents a B-Rep (Boundary Representation) body.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepBody:
        return BRepBody()
    def pointContainment(self, point: core.Point3D) -> PointContainment:
        """
        Determines the relationship of the input point with respect to this body.
        point : The point to do the containment check for.
        Returns a value from the PointContainment enum indicating the relationship of
        the input point to the body.
        """
        return PointContainment()
    def deleteMe(self) -> bool:
        """
        Deletes the body.
        
        This property is only valid if the IsTransient property is false.
        Returns true if the delete was successful.
        """
        return bool()
    def copy(self) -> bool:
        """
        Copies the body to the clipboard.
        
        This property is only valid if the IsTransient property is false.
        Returns true if the copy was successful.
        """
        return bool()
    def cut(self) -> bool:
        """
        Cuts the body to the clipboard.
        
        This property is only valid if the IsTransient property is false.
        Returns true if the cut was successful.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> BRepBody:
        """
        Returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        
        This method is only valid if the IsTransient property is false.
        occurrence : The occurrence that defines the context for the created proxy.
        Returns the new BRepBoy proxy or null if this isn't the NativeObject.
        """
        return BRepBody()
    def createComponent(self) -> BRepBody:
        """
        Creates a new component and occurrence within the component that currently owns this body.
        This body is moved into the new component and returned. The newly created component can be
        obtained by using the parentComponent property of the BRepBody object.
        
        This method is only valid if the IsTransient property is false.
        Returns the BRrepBody in the new component or null in the case the creation failed.
        """
        return BRepBody()
    def moveToComponent(self, target: core.Base) -> BRepBody:
        """
        Moves this body from it's current component into the root component or the component owned by the
        specified occurrence.
        target : The target can be either the root component or an occurrence.
        
        In the case where an occurrence is specified, the body will be moved into the parent component of the target
        occurrence and the target occurrence defines the transform of how the body will be copied so that the body
        maintains it's same position with respect to the assembly.
        Returns the moved BRepBody or null in the case the move failed.
        """
        return BRepBody()
    def copyToComponent(self, target: core.Base) -> BRepBody:
        """
        Creates a copy of this body into the specified target.
        target : The target can be either the root component or an occurrence.
        
        In the case where an occurrence is specified, the body will be copied into the parent component of the target
        occurrence and the target occurrence defines the transform of how the body will be copied so that the body
        maintains it's same position with respect to the assembly.
        
        If target is null, then a copy of the body is created in the owning component of the original body.
        Returns the moved BRepBody or null in the case the move failed.
        """
        return BRepBody()
    def convert(self, options: BRepConvertOptions) -> BRepBody:
        """
        Creates a new body where the faces and edges are converted to different
        types of geometry based on the input options. This is particularly useful
        when you need a body made up entirely of NURBS surfaces.
        
        The tempId on the faces, edges, and vertices on the new body will match
        with the corresponding tempId on the original body. In cases where faces are
        split as a result of the conversion there can be more than one face or edge in
        the new body that matches to a single face or edge in the original body. The
        findByTempId method will find the entity with the matching id.
        options : Input options that define how the conversion should be done. These are
        bitwise options so they can be combined.
        Returns the new converted body or null in the case of failure.
        """
        return BRepBody()
    def findByTempId(self, tempId: int) -> list[core.Base]:
        """
        Returns all of the faces, edges, or vertices that match the input ID.
        tempId : The ID of the B-Rep entity to find.
        Returns an array of entities that have the specified ID. This
        returns an array because it's possible that a body created by converting a
        body can have multiple entities with the same ID in the case where a curve
        or face was split. Returns an empty array in the case where no match is found.
        """
        return [core.Base()]
    def getPhysicalProperties(self, accuracy: CalculationAccuracy) -> PhysicalProperties:
        """
        Returns the PhysicalProperties object that has properties for getting the area, density, mass, volume, moments, etc
        of this body.
        accuracy : Specifies the desired level of computational accuracy of the property calculations.
        The default value of 'LowCalculationAccuracy' returns results within a +/- 1% error margin.
        Returns a PhysicalProperties object that can be used to get the various physical property related values.
        """
        return PhysicalProperties()
    @property
    def parentComponent(self) -> Component:
        """
        Returns the component this body is owned by.
        """
        return Component()
    @property
    def lumps(self) -> BRepLumps:
        """
        Returns a collection of all of the lumps in the body.
        """
        return BRepLumps()
    @property
    def shells(self) -> BRepShells:
        """
        Returns a collection of all of the shells in the body.
        """
        return BRepShells()
    @property
    def faces(self) -> BRepFaces:
        """
        Returns a collection of all of the faces in the body.
        """
        return BRepFaces()
    @property
    def edges(self) -> BRepEdges:
        """
        Returns a collection of all of the edges in the body.
        """
        return BRepEdges()
    @property
    def vertices(self) -> BRepVertices:
        """
        Returns a collection of all of the vertices in the body.
        """
        return BRepVertices()
    @property
    def isSolid(self) -> bool:
        """
        Returns whether this body is closed (solid) or not.
        """
        return bool()
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns the bounding box of this body.
        """
        return core.BoundingBox3D()
    @property
    def concaveEdges(self) -> BRepEdges:
        """
        Returns all of the edges that connect concave faces.
        """
        return BRepEdges()
    @property
    def convexEdges(self) -> BRepEdges:
        """
        Returns all of the edges that connect convex faces.
        """
        return BRepEdges()
    @property
    def area(self) -> float:
        """
        Returns the area in cm ^ 2.
        """
        return float()
    @property
    def volume(self) -> float:
        """
        Returns the volume in cm ^ 3. Returns 0 in the case the body is not solid.
        """
        return float()
    @property
    def isTransient(self) -> bool:
        """
        Indicates if this body is represented in the model or is transient.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of the body.
        
        This property is only valid if the IsTransient property is false.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of the body.
        
        This property is only valid if the IsTransient property is false.
        """
        pass
    @property
    def isVisible(self) -> bool:
        """
        Gets if this body is currently visible in the graphics window. Use the
        isLightBulbOn to change if the light bulb beside the body node in the
        browser is on or not. Parent nodes in the browser can have their light
        bulb off which affects all of their children. This property indicates
        the final result and whether this body is actually visible or not.
        
        This property is only valid if the IsTransient property is false.
        """
        return bool()
    @isVisible.setter
    def isVisible(self, value: bool):
        """
        Gets if this body is currently visible in the graphics window. Use the
        isLightBulbOn to change if the light bulb beside the body node in the
        browser is on or not. Parent nodes in the browser can have their light
        bulb off which affects all of their children. This property indicates
        the final result and whether this body is actually visible or not.
        
        This property is only valid if the IsTransient property is false.
        """
        pass
    @property
    def isSelectable(self) -> bool:
        """
        Gets and sets if this body is selectable.
        
        This property is only valid if the IsTransient property is false.
        """
        return bool()
    @isSelectable.setter
    def isSelectable(self, value: bool):
        """
        Gets and sets if this body is selectable.
        
        This property is only valid if the IsTransient property is false.
        """
        pass
    @property
    def appearance(self) -> core.Appearance:
        """
        Read-write property that gets and sets the current appearance of the body. Setting this property will result in applying
        an override appearance to the body and the AppearanceSourceType property will return OverrideAppearanceSource. Setting
        this property to null will remove any override.
        
        This property is only valid if the IsTransient property is false.
        """
        return core.Appearance()
    @appearance.setter
    def appearance(self, value: core.Appearance):
        """
        Read-write property that gets and sets the current appearance of the body. Setting this property will result in applying
        an override appearance to the body and the AppearanceSourceType property will return OverrideAppearanceSource. Setting
        this property to null will remove any override.
        
        This property is only valid if the IsTransient property is false.
        """
        pass
    @property
    def appearanceSourceType(self) -> core.AppearanceSourceTypes:
        """
        Read-write property that gets the source of the appearance for the body. If this returns OverrideAppearanceSource, an override exists
        on this body. The override can be removed by setting the Appearance property to null.
        
        This property is only valid if the IsTransient property is false.
        """
        return core.AppearanceSourceTypes()
    @property
    def material(self) -> core.Material:
        """
        Gets and sets the material assigned to this body.
        
        This property is only valid if the IsTransient property is false.
        """
        return core.Material()
    @material.setter
    def material(self, value: core.Material):
        """
        Gets and sets the material assigned to this body.
        
        This property is only valid if the IsTransient property is false.
        """
        pass
    @property
    def meshManager(self) -> MeshManager:
        """
        Returns the mesh manager object for this body.
        """
        return MeshManager()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this
        object in an assembly. This is only valid in the case where this
        BRepBody object is acting as a proxy in an assembly. Returns null
        in the case where the object is not in the context of an assembly.
        but is already the native object. Also returns null in the case
        where this body is transient.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> BRepBody:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return BRepBody()
    @property
    def physicalProperties(self) -> PhysicalProperties:
        """
        Returns the PhysicalProperties object that has properties for getting the area, density, mass, volume, moments, etc
        of this body. Property values will be calculated using the 'LowCalculationAccuracy' setting when using this property
        to get the PhysicalProperties object. To specify a higher calculation tolerance, use the getPhysicalProperties method
        on the Design class instead.
        Returns a PhysicalProperties object that can be used to get the various physical property related values.
        """
        return PhysicalProperties()
    @property
    def isLightBulbOn(self) -> bool:
        """
        Gets and set if the light bulb beside the body node in the
        browser is on or not. Parent nodes in the browser can have their light
        bulb off which affects all of their children so this property does not
        indicate if the body is actually visible, just that it should be visible
        if all of it's parent nodes are also visible. Use the isVisible property
        to determine if it's actually visible.
        
        This property is only valid if the IsTransient property is false.
        """
        return bool()
    @isLightBulbOn.setter
    def isLightBulbOn(self, value: bool):
        """
        Gets and set if the light bulb beside the body node in the
        browser is on or not. Parent nodes in the browser can have their light
        bulb off which affects all of their children so this property does not
        indicate if the body is actually visible, just that it should be visible
        if all of it's parent nodes are also visible. Use the isVisible property
        to determine if it's actually visible.
        
        This property is only valid if the IsTransient property is false.
        """
        pass
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this face.
        """
        return core.Attributes()
    @property
    def baseFeature(self) -> BaseFeature:
        """
        If this body is associated with a base feature, this property will return that base feature.
        If it's not associated with a base feature, this property will return null.
        """
        return BaseFeature()
    @property
    def opacity(self) -> float:
        """
        Gets and sets the opacity override assigned to this body. A value of 1.0 specifies
        that is it completely opaque and a value of 0.0 specifies that is it completely transparent.
        
        This value is not necessarily related to what the user sees because the opacity is inherited.
        For example, if you this body is in a component and that component's opacity is set to something
        other than 1.0, the body will also be shown as slightly transparent even though the opacity
        property for the body will return 1.0. Because the component that contains the body can be
        referenced as an occurrence in other components and they can have different opacity settings,
        it's possible that different instances of the same body can display using different opacity levels.
        To get the opacity that it is being displayed with use the BrepBody.visibleOpacity property.
        
        This is the API equivalent of the "Opacity Control" command available for the body in the browser.
        """
        return float()
    @opacity.setter
    def opacity(self, value: float):
        """
        Gets and sets the opacity override assigned to this body. A value of 1.0 specifies
        that is it completely opaque and a value of 0.0 specifies that is it completely transparent.
        
        This value is not necessarily related to what the user sees because the opacity is inherited.
        For example, if you this body is in a component and that component's opacity is set to something
        other than 1.0, the body will also be shown as slightly transparent even though the opacity
        property for the body will return 1.0. Because the component that contains the body can be
        referenced as an occurrence in other components and they can have different opacity settings,
        it's possible that different instances of the same body can display using different opacity levels.
        To get the opacity that it is being displayed with use the BrepBody.visibleOpacity property.
        
        This is the API equivalent of the "Opacity Control" command available for the body in the browser.
        """
        pass
    @property
    def visibleOpacity(self) -> float:
        """
        The user can set an override opacity for components and bodies these opacity overrides combine if
        children and parent components have overrides. This property returns the actual opacity that is
        being used to render the body. To set the opacity use the opacity property of the BRepBody object.
        """
        return float()
    @property
    def revisionId(self) -> str:
        """
        Returns the current revision ID of the body. This ID changes any time the body is modified in any way. By getting
        and saving the ID when you create any data that is dependent on the body, you can then compare the saved
        ID with the current ID to determine if the body has changed to know if you should update your data.
        """
        return str()
    @property
    def wires(self) -> BRepWires:
        """
        Returns any wire bodies that exist within this body.
        """
        return BRepWires()
    @property
    def isTemporary(self) -> bool:
        """
        Indicates if this body is represented in the model or is temporary.
        """
        return bool()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the BRepBody object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same body.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        
        This is only valid for bodies that exist in the design, (the isTemporary
        property is false).
        """
        return str()

class BRepBodyDefinition(core.Base):
    """
    This object is used to define a temporary B-Rep body. This includes solid, surface, and wire
    bodies. The class supports the ability to define the geometry and topology of the B-Rep and
    once the definition is complete, it supports the creation of a temporary BRepBody object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepBodyDefinition:
        return BRepBodyDefinition()
    @staticmethod
    def create() -> BRepBodyDefinition:
        """
        Static function that creates a new BRepBodyDefinition object. It's initially empty but you can use
        the functionality it provides to define the geometry and topology of the B-Rep
        object you want to create.
        Returns the newly created BRepBodyDefinition object.
        """
        return BRepBodyDefinition()
    def createBody(self) -> BRepBody:
        """
        Attempts to create a temporary BRepBody object using the definition
        provided by this BRepBodyDefinition object. Properties on this BRepBodyDefinition
        are used to define some of the criteria that control how the body is created.
        Returns the newly created BRepBody object if successful, otherwise null is returned.
        Information about the body creation can be obtained by using the outcomeInfo property.
        The outcome info is especially useful when initially writing and debugging your code to understand
        why the creation of the body is failing.
        """
        return BRepBody()
    def createEdgeDefinitionByCurve(self, startVertex: BRepVertexDefinition, endVertex: BRepVertexDefinition, modelSpaceCurve: core.Curve3D) -> BRepEdgeDefinition:
        """
        Using a curve in model space it creates a new BRepEdgeDefinition object that's associated with the body.
        startVertex : Vertex definition that defines the start of the edge. For a closed curve, like a circle, you still
        need to provide a vertex on the curve but you should use the same BRepVertexDefinition for both the start and end vertices.
        endVertex : Vertex definition that defines the end of the edge. For a closed curve, like a circle, this should be the
        same vertex as used for the start vertex.
        modelSpaceCurve : A Curve3D object that defines the shape of the edge using 3D geometry in model space.
        Valid input is an Arc3D, NurbsCurve3D, Circle3D, Ellipse3D, EllipticalArc3D, or Line3D.
        Returns the created BRepEdgeDefinition object or null in the case of failure.
        """
        return BRepEdgeDefinition()
    def createVertexDefinition(self, position: core.Point3D) -> BRepVertexDefinition:
        """
        Creates a new BRepVertexDefinition object that's associated with the body.
        position : Specifies the position of the vertex in model space.
        Returns the created BRepVertexDefinition object or null in the case of failure.
        """
        return BRepVertexDefinition()
    @property
    def doFullHealing(self) -> bool:
        """
        Specifies if full healing is done when creating the body. This defaults to true and it's highly recommended
        that you do full healing because it can find and correct problems with the input. If you're sure that the
        B-Rep definition that you've constructed is correct then you can set this to false to skip the full
        healing process.
        """
        return bool()
    @doFullHealing.setter
    def doFullHealing(self, value: bool):
        """
        Specifies if full healing is done when creating the body. This defaults to true and it's highly recommended
        that you do full healing because it can find and correct problems with the input. If you're sure that the
        B-Rep definition that you've constructed is correct then you can set this to false to skip the full
        healing process.
        """
        pass
    @property
    def outcomeInfo(self) -> list[str]:
        """
        Returns an array of strings that contain information about the outcome of the previous
        call of the createBody method. This is especially useful when the createBody method fails,
        (returns null), because it provides information about why the failure occurred. It can
        also sometimes provide some information even when createBody succeeds.
        
        Each string that's returned represents a single set of information and is packaged as JSON
        such as '{"description":"vertex data is null or inconsistent with edge geometry","associativeID":"unknown","code":37}'
        
        The description is an English description of the error or warning. The associativeID maps back to the
        entity provided that is the cause of the problem. The ID is the associative ID you can optionally
        assign to the entity definition. The code is an internal code for the error or warning.
        
        An empty array is returned if createBody succeeded and there's no additional information.
        """
        return [str()]
    @property
    def lumpDefinitions(self) -> BRepLumpDefinitions:
        """
        Provides access to the BRepLumpDefinitions object associated with this BRepBodyDefinition.
        It's through the returned collection that you can create new BRepLumpDefinition objects.
        """
        return BRepLumpDefinitions()

class BRepCell(core.Base):
    """
    Object that represents an existing BRepCell.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepCell:
        return BRepCell()
    @property
    def isSelected(self) -> bool:
        """
        Gets and sets whether the cell is selected. For a Trim feature a selected cell is removed,
        whereas for a boundary fill feature, a selected cell is kept and used in the feature operation.
        """
        return bool()
    @isSelected.setter
    def isSelected(self, value: bool):
        """
        Gets and sets whether the cell is selected. For a Trim feature a selected cell is removed,
        whereas for a boundary fill feature, a selected cell is kept and used in the feature operation.
        """
        pass
    @property
    def sourceTools(self) -> core.ObjectCollection:
        """
        Returns the tools that we're using in the definition of this cell.
        """
        return core.ObjectCollection()
    @property
    def cellBody(self) -> BRepBody:
        """
        Returns a BRepBody that represents this cell. This is a transient B-Rep body.
        """
        return BRepBody()

class BRepCells(core.Base):
    """
    Collection that provides access to all of the existing BRepCells defined by a BoundaryFillFeatureInput
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepCells:
        return BRepCells()
    def item(self, index: int) -> BRepCell:
        """
        Function that returns the specified BRepCell using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepCell()
    @property
    def count(self) -> int:
        """
        The number of BRepCells in the collection.
        """
        return int()

class BRepCoEdge(core.Base):
    """
    Represents the use of a BRepEdge by a BRepFace.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepCoEdge:
        return BRepCoEdge()
    def createForAssemblyContext(self, occurrence: Occurrence) -> BRepCoEdge:
        """
        Returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context for the created proxy.
        Returns the new BrepCoEdge proxy or null if this isn't the NativeObject.
        """
        return BRepCoEdge()
    @property
    def edge(self) -> BRepEdge:
        """
        Returns the edge this co-edge is associated with.
        """
        return BRepEdge()
    @property
    def loop(self) -> BRepLoop:
        """
        Returns the loop this co-edge is part of.
        """
        return BRepLoop()
    @property
    def evaluator(self) -> core.CurveEvaluator2D:
        """
        Returns a curve evaluator that can be used to perform geometric evaluations on the co-edge.
        """
        return core.CurveEvaluator2D()
    @property
    def geometry(self) -> core.Curve2D:
        """
        Returns a geometry object that represents the shape of this co-edge in parameter space of the parent face's surface.
        """
        return core.Curve2D()
    @property
    def isOpposedToEdge(self) -> bool:
        """
        Indicates if the orientation of this co-edge is in the same direction or opposed to its associated edge.
        """
        return bool()
    @property
    def isParamReversed(self) -> bool:
        """
        Returns if the parametric direction of this co-edge is reversed
        from the parametric direction of the underlying curve obtained from the geometry property.
        A co-edge's parametric direction is from the start vertex to the end vertex.
        But the underlying curve geometry may have the opposite parameterization.
        This property indicates if the parameterization order of the evaluator obtained from
        this co-edge is reversed from the order of the geometry curve's evaluator.
        """
        return bool()
    @property
    def next(self) -> BRepCoEdge:
        """
        Returns the next co-edge in the loop.
        """
        return BRepCoEdge()
    @property
    def body(self) -> BRepBody:
        """
        Returns the body this co-edge is part of.
        """
        return BRepBody()
    @property
    def partner(self) -> BRepCoEdge:
        """
        Returns the co-edge on the adjacent face
        """
        return BRepCoEdge()
    @property
    def previous(self) -> BRepCoEdge:
        """
        Returns the previous co-edge in the loop.
        """
        return BRepCoEdge()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this
        object in an assembly. This is only valid in the case where this
        BRepCoEdge object is acting as a proxy in an assembly. Returns null
        in the case where the object is not in the context of an assembly.
        but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> BRepCoEdge:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return BRepCoEdge()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the BRepCoEdge object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same co-edge.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        
        This is only valid for co-edges that exist in the design, (the isTemporary
        property is false).
        """
        return str()

class BRepCoEdgeDefinition(core.Base):
    """
    Represents the definition of a B-Rep co-edge that can be used as input to create a BRepBody that includes this co-edge.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepCoEdgeDefinition:
        return BRepCoEdgeDefinition()
    @property
    def edgeDefinition(self) -> BRepEdgeDefinition:
        """
        Gets and sets the BRepEdgeDefinition object associated with this BrepCoEdgeDefinition object.
        """
        return BRepEdgeDefinition()
    @edgeDefinition.setter
    def edgeDefinition(self, value: BRepEdgeDefinition):
        """
        Gets and sets the BRepEdgeDefinition object associated with this BrepCoEdgeDefinition object.
        """
        pass
    @property
    def isOpposedToEdge(self) -> bool:
        """
        Gets and sets if the orientation of this BRepCoEdgeDefinition object is reversed with
        respect to the associated BRepEdgeDefinition object.
        """
        return bool()
    @isOpposedToEdge.setter
    def isOpposedToEdge(self, value: bool):
        """
        Gets and sets if the orientation of this BRepCoEdgeDefinition object is reversed with
        respect to the associated BRepEdgeDefinition object.
        """
        pass

class BRepCoEdgeDefinitions(core.Base):
    """
    Provides access to the BRepCoEdgeDefinition objects associated with the parent BRepLoopDefinition object.
    It's through this object that you create new BRepCoEdgeDefinition objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepCoEdgeDefinitions:
        return BRepCoEdgeDefinitions()
    def item(self, index: int) -> BRepCoEdgeDefinition:
        """
        Function that returns the specified BRepCoEdgeDefinition object using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepCoEdgeDefinition()
    def add(self, edgeDefinition: BRepEdgeDefinition, isOpposedToEdge: bool) -> BRepCoEdgeDefinition:
        """
        Creates a new BrepCoEdgeDefinition object associated with the parent BrepLoopDefinition object.
        edgeDefinition : The BRepEdgeDefinition object this co-edge is related to.
        isOpposedToEdge : Boolean that indicates if the orientation of this BRepCoEdgeDefinition is reversed with respect
        to the associated BRepEdgeDefinition object.
        Returns the newly created BrepCoEdgeDefinition object or null in the case of failure.
        """
        return BRepCoEdgeDefinition()
    @property
    def count(self) -> int:
        """
        The number of B-Rep co-edge definition objects in the collection.
        """
        return int()

class BRepCoEdges(core.Base):
    """
    BRepCoEdge Collection.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepCoEdges:
        return BRepCoEdges()
    def item(self, index: int) -> BRepCoEdge:
        """
        Function that returns the specified co-edge using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepCoEdge()
    @property
    def count(self) -> int:
        """
        The number of co-edges in the collection.
        """
        return int()

class BRepEdge(core.Base):
    """
    Represents a one-dimensional topological element that can be used to bound a BRepFace A BRepEdge uses a single, connected and bounded subset of a curve for it geometry.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepEdge:
        return BRepEdge()
    def createForAssemblyContext(self, occurrence: Occurrence) -> BRepEdge:
        """
        Returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context for the created proxy.
        Returns the new BrepEdge proxy or null if this isn't the NativeObject.
        """
        return BRepEdge()
    @property
    def startVertex(self) -> BRepVertex:
        """
        Returns the BRepVertex that bounds its low parameter end.
        """
        return BRepVertex()
    @property
    def endVertex(self) -> BRepVertex:
        """
        Returns the BRepVertex that bounds its high parameter end.
        """
        return BRepVertex()
    @property
    def faces(self) -> BRepFaces:
        """
        Returns the BRepFaces that are associated with this edge through its BRepCoEdges.
        """
        return BRepFaces()
    @property
    def shell(self) -> BRepShell:
        """
        Returns the parent shell of the edge.
        """
        return BRepShell()
    @property
    def body(self) -> BRepBody:
        """
        Returns the parent body of the edge.
        """
        return BRepBody()
    @property
    def isDegenerate(self) -> bool:
        """
        Returns if the edge's geometry is degenerate.
        For example, the apex of a cone is a degenerate edge.
        """
        return bool()
    @property
    def evaluator(self) -> core.CurveEvaluator3D:
        """
        Returns CurveEvaluator3D for evaluation.
        """
        return core.CurveEvaluator3D()
    @property
    def geometry(self) -> core.Curve3D:
        """
        Returns the underlying curve geometry of the edge.
        """
        return core.Curve3D()
    @property
    def isTolerant(self) -> bool:
        """
        Returns if the edge is tolerant.
        The tolerance used is available from the tolerance property.
        """
        return bool()
    @property
    def tolerance(self) -> float:
        """
        Returns the tolerance used by a tolerant edge.
        This value is only useful when isTolerant is true.
        """
        return float()
    @property
    def pointOnEdge(self) -> core.Point3D:
        """
        Returns a sample point guaranteed to lie on the edge's curve, within its boundaries,
        and not on a vertex (unless this is a degenerate edge).
        """
        return core.Point3D()
    @property
    def coEdges(self) -> BRepCoEdges:
        """
        Returns the BRepCoEdges on the edge.
        """
        return BRepCoEdges()
    @property
    def isParamReversed(self) -> bool:
        """
        Returns if the parametric direction of this edge is reversed
        from the parametric direction of the underlying curve obtained from the geometry property.
        An edge's parametric direction is from the start vertex to the end vertex.
        But the underlying curve geometry may have the opposite parameterization.
        This property indicates if the parameterization order of the evaluator obtained from
        this edge is reversed from the order of the geometry curve's evaluator.
        """
        return bool()
    @property
    def tangentiallyConnectedEdges(self) -> core.ObjectCollection:
        """
        Returns a collection of edges that includes all of the edges tangentially connected
        to this edge. The result includes this edge. The edges are in the collection
        in their connected order.
        """
        return core.ObjectCollection()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this
        object in an assembly. This is only valid in the case where this
        BRepEdge object is acting as a proxy in an assembly. Returns null
        in the case where the object is not in the context of an assembly.
        but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> BRepEdge:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return BRepEdge()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this face.
        """
        return core.Attributes()
    @property
    def length(self) -> float:
        """
        Returns the length of the edge in centimeters.
        """
        return float()
    @property
    def tempId(self) -> int:
        """
        Returns the temporary ID of this edge. This ID is only good while the document
        remains open and as long as the owning BRepBody is not modified in any way.
        The findByTempId method of the BRepBody will return the entity in the body with the given ID.
        """
        return int()
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns the bounding box of this edge.
        """
        return core.BoundingBox3D()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the BRepEdge object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same edge.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        
        This is only valid for edges that exist in the design, (the isTemporary
        property is false).
        """
        return str()

class BRepEdgeDefinition(core.Base):
    """
    Represents the definition of a B-Rep edge that can be used as input to create a BRepBody.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepEdgeDefinition:
        return BRepEdgeDefinition()
    @property
    def associativeID(self) -> int:
        """
        Gets and sets the associate ID of this edge definition. This ID will be copied to the corresponding
        edge when the BRepBodyDefinition is used to create a BrepBody. It is used internally by Fusion360 as
        the identifier for the edge and is used for tracking this geometry for parametric recomputes.
        """
        return int()
    @associativeID.setter
    def associativeID(self, value: int):
        """
        Gets and sets the associate ID of this edge definition. This ID will be copied to the corresponding
        edge when the BRepBodyDefinition is used to create a BrepBody. It is used internally by Fusion360 as
        the identifier for the edge and is used for tracking this geometry for parametric recomputes.
        """
        pass
    @property
    def startVertex(self) -> BRepVertexDefinition:
        """
        Gets and sets the start vertex of the edge definition.
        """
        return BRepVertexDefinition()
    @startVertex.setter
    def startVertex(self, value: BRepVertexDefinition):
        """
        Gets and sets the start vertex of the edge definition.
        """
        pass
    @property
    def endVertex(self) -> BRepVertexDefinition:
        """
        Gets and sets the end vertex of the edge definition.
        """
        return BRepVertexDefinition()
    @endVertex.setter
    def endVertex(self, value: BRepVertexDefinition):
        """
        Gets and sets the end vertex of the edge definition.
        """
        pass
    @property
    def modelSpaceCurve(self) -> core.Curve3D:
        """
        Gets and sets the curve that defines the shape of the edge.
        """
        return core.Curve3D()
    @modelSpaceCurve.setter
    def modelSpaceCurve(self, value: core.Curve3D):
        """
        Gets and sets the curve that defines the shape of the edge.
        """
        pass
    @property
    def isMergeable(self) -> bool:
        """
        Gets and sets if the two faces that share this edge can be merged along this
        edge. This property defaults to true so that merging is always done but this
        can be set to false in cases where you want to preserve the edge.
        
        An example where merging is typically done is when you have multiple planar
        faces that all lie on the same plane and are connected. When merging is allowed
        these faces can be replaced by a single face and the edges connecting the
        faces (the merged edges) are no longer part of the body.
        """
        return bool()
    @isMergeable.setter
    def isMergeable(self, value: bool):
        """
        Gets and sets if the two faces that share this edge can be merged along this
        edge. This property defaults to true so that merging is always done but this
        can be set to false in cases where you want to preserve the edge.
        
        An example where merging is typically done is when you have multiple planar
        faces that all lie on the same plane and are connected. When merging is allowed
        these faces can be replaced by a single face and the edges connecting the
        faces (the merged edges) are no longer part of the body.
        """
        pass

class BRepEdges(core.Base):
    """
    BRepEdge collection.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepEdges:
        return BRepEdges()
    def item(self, index: int) -> BRepEdge:
        """
        Function that returns the specified edge using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepEdge()
    @property
    def count(self) -> int:
        """
        The number of edges in the collection.
        """
        return int()

class BRepFace(core.Base):
    """
    Represent a connected region on a single geometric surface.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepFace:
        return BRepFace()
    def createForAssemblyContext(self, occurrence: Occurrence) -> BRepFace:
        """
        Returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context for the created proxy.
        Returns the new BRepFace proxy or null if this isn't the NativeObject.
        """
        return BRepFace()
    def convert(self, options: BRepConvertOptions) -> BRepBody:
        """
        Creates a new body where this face and its edges are converted to different
        types of geometry based on the input options.
        
        The tempId on the faces, edges, and vertices on the new body will match
        with the corresponding tempId on the original body. In cases where the face is
        split as a result of the conversion there can be more than one face or edge in
        the new body that matches to a single face or edge in the original body.
        options : Input options that define how the conversion should be done. These are
        bitwise options so they can be combined.
        Returns the new converted body or null in the case of failure.
        """
        return BRepBody()
    @property
    def edges(self) -> BRepEdges:
        """
        Returns the BRepEdges used by this face
        """
        return BRepEdges()
    @property
    def vertices(self) -> BRepVertices:
        """
        Returns the BRepVertices used by this face
        """
        return BRepVertices()
    @property
    def shell(self) -> BRepShell:
        """
        Returns the parent shell of the face.
        """
        return BRepShell()
    @property
    def loops(self) -> BRepLoops:
        """
        Returns the BRepLoops owned by this face
        """
        return BRepLoops()
    @property
    def body(self) -> BRepBody:
        """
        Returns the parent body of the face.
        """
        return BRepBody()
    @property
    def geometry(self) -> core.Surface:
        """
        Returns the underlying surface geometry of this face
        """
        return core.Surface()
    @property
    def evaluator(self) -> core.SurfaceEvaluator:
        """
        Returns a SurfaceEvaluator to allow geometric evaluations across the face's surface.
        This evaluator differs from the evaluator available from the Surface obtained from the geometry
        property by being bounded by the topological boundaries of this face.
        """
        return core.SurfaceEvaluator()
    @property
    def pointOnFace(self) -> core.Point3D:
        """
        Returns a sample point guaranteed to lie on the face's surface, within the face's boundaries, and not on a boundary edge.
        """
        return core.Point3D()
    @property
    def tangentiallyConnectedFaces(self) -> BRepFaces:
        """
        Returns the set of faces that are tangentially adjacent to this face.
        In other words, it is the set of faces that are adjacent to this face's edges
        and have a smooth transition across those edges.
        """
        return BRepFaces()
    @property
    def meshManager(self) -> MeshManager:
        """
        Returns a MeshManager object that allows access to existing and new meshes of this face.
        """
        return MeshManager()
    @property
    def appearance(self) -> core.Appearance:
        """
        Read-write property that gets and sets the current appearance of the face. Setting this property will result in applying
        an override appearance to the face and the AppearanceSourceType property will return OverrideAppearanceSource. Setting
        this property to null will remove any override.
        """
        return core.Appearance()
    @appearance.setter
    def appearance(self, value: core.Appearance):
        """
        Read-write property that gets and sets the current appearance of the face. Setting this property will result in applying
        an override appearance to the face and the AppearanceSourceType property will return OverrideAppearanceSource. Setting
        this property to null will remove any override.
        """
        pass
    @property
    def appearanceSourceType(self) -> core.AppearanceSourceTypes:
        """
        Read-write property that gets the source of the appearance for the face. If this returns OverrideAppearanceSource, an override exists
        on this face. The override can be removed by setting the Appearance property to null.
        """
        return core.AppearanceSourceTypes()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this
        object in an assembly. This is only valid in the case where this
        BRepFace object is acting as a proxy in an assembly. Returns null
        in the case where the object is not in the context of an assembly.
        but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> BRepFace:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return BRepFace()
    @property
    def area(self) -> float:
        """
        Returns the area in cm ^ 2.
        """
        return float()
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns the bounding box of this face
        """
        return core.BoundingBox3D()
    @property
    def centroid(self) -> core.Point3D:
        """
        Returns a point at the centroid (aka, geometric center) of the face.
        """
        return core.Point3D()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this face.
        """
        return core.Attributes()
    @property
    def tempId(self) -> int:
        """
        Returns the temporary ID of this face. This ID is only good while the document
        remains open and as long as the owning BRepBody is not modified in any way.
        The findByTempId method of the BRepBody will return the entity in the body with the given ID.
        """
        return int()
    @property
    def isParamReversed(self) -> bool:
        """
        Gets if the normal of this face is reversed with respect to the surface geometry associated
        with this face.
        """
        return bool()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the BRepFace object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same face.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        
        This is only valid for faces that exist in the design, (the isTemporary
        property is false).
        """
        return str()

class BRepFaceDefinition(core.Base):
    """
    Represents the definition of a B-Rep face that can be used as input to create a BRepBody that includes this face.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepFaceDefinition:
        return BRepFaceDefinition()
    @property
    def associativeID(self) -> int:
        """
        Gets and sets the associate ID of this face definition. This ID will be copied to the corresponding
        face when the BRepBodyDefinition is used to create a BrepBody. It is used by Fusion360 as
        the identifier for the face and is used for tracking this geometry for parametric recomputes.
        """
        return int()
    @associativeID.setter
    def associativeID(self, value: int):
        """
        Gets and sets the associate ID of this face definition. This ID will be copied to the corresponding
        face when the BRepBodyDefinition is used to create a BrepBody. It is used by Fusion360 as
        the identifier for the face and is used for tracking this geometry for parametric recomputes.
        """
        pass
    @property
    def loopDefinitions(self) -> BRepLoopDefinitions:
        """
        Provides access to the BRepLoopDefinitions object associated with this BRepFaceDefinition.
        It's through the returned collection that you can create new BRepLoopDefinition objects.
        """
        return BRepLoopDefinitions()
    @property
    def surfaceGeometry(self) -> core.Surface:
        """
        Gets and sets the surface geometry associated with this face definition.
        """
        return core.Surface()
    @surfaceGeometry.setter
    def surfaceGeometry(self, value: core.Surface):
        """
        Gets and sets the surface geometry associated with this face definition.
        """
        pass
    @property
    def isParamReversed(self) -> bool:
        """
        Gets and sets if the normal of this face is reversed with respect to the surface geometry associated
        with this face definition.
        """
        return bool()
    @isParamReversed.setter
    def isParamReversed(self, value: bool):
        """
        Gets and sets if the normal of this face is reversed with respect to the surface geometry associated
        with this face definition.
        """
        pass

class BRepFaceDefinitions(core.Base):
    """
    Provides access to the BRepFaceDefinition objects associated with the object the collection was obtained from.
    It's through this object that you create new BRepFaceDefinition objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepFaceDefinitions:
        return BRepFaceDefinitions()
    def item(self, index: int) -> BRepFaceDefinition:
        """
        Function that returns the specified BRepFaceDefinition object using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepFaceDefinition()
    def add(self, surfaceGeometry: core.Surface, isParamReversed: bool) -> BRepFaceDefinition:
        """
        Creates a new BrepFaceDefinition within the parent BRepShellDefinition object.
        surfaceGeometry : Input surface object that defines the geometry of the face. Valid objects for input are
        NurbsSurface, Cone, Cylinder, EllipticalCone, EllipticalCylinder, Plane, Sphere, and Torus.
        isParamReversed : Input Boolean that indicates if the normal of this face is reversed with respect to the
        surface geometry associated with this face definition.
        Returns the newly created BRepFaceDefinition object or null in the case of failure.
        """
        return BRepFaceDefinition()
    @property
    def count(self) -> int:
        """
        The number of B-Rep face definition objects in the collection.
        """
        return int()

class BRepFaces(core.Base):
    """
    BRepFace collection.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepFaces:
        return BRepFaces()
    def item(self, index: int) -> BRepFace:
        """
        Function that returns the specified face using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepFace()
    @property
    def count(self) -> int:
        """
        The number of faces in the collection.
        """
        return int()

class BRepLoop(core.Base):
    """
    Represents a connected portion of a BRepFace boundary. It consists of a chain of BRepCoEdges.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepLoop:
        return BRepLoop()
    def createForAssemblyContext(self, occurrence: Occurrence) -> BRepLoop:
        """
        Returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context for the created proxy.
        Returns the new BrepLoop proxy or null if this isn't the NativeObject.
        """
        return BRepLoop()
    @property
    def edges(self) -> BRepEdges:
        """
        Returns the BRepEdges used by this loop
        """
        return BRepEdges()
    @property
    def coEdges(self) -> BRepCoEdges:
        """
        Returns the BRepCoEdges consisting this loop
        """
        return BRepCoEdges()
    @property
    def isOuter(self) -> bool:
        """
        Returns true of this loop is an outer loop of a face
        """
        return bool()
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns the bounding box of this loop
        """
        return core.BoundingBox3D()
    @property
    def face(self) -> BRepFace:
        """
        Returns the parent face of the loop.
        """
        return BRepFace()
    @property
    def body(self) -> BRepBody:
        """
        Returns the parent body of the loop.
        """
        return BRepBody()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this
        object in an assembly. This is only valid in the case where this
        BRepLoop object is acting as a proxy in an assembly. Returns null
        in the case where the object is not in the context of an assembly.
        but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> BRepLoop:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return BRepLoop()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the BRepLoop object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same loop.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        
        This is only valid for loops that exist in the design, (the isTemporary
        property is false).
        """
        return str()

class BRepLoopDefinition(core.Base):
    """
    Represents the definition of a B-Rep loop that can be used as input to create a BRepBody that includes this loop.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepLoopDefinition:
        return BRepLoopDefinition()
    @property
    def bRepCoEdgeDefinitions(self) -> BRepCoEdgeDefinitions:
        """
        Provides access to the BRepCoEdgeDefinitions object associated with the parent BRepFaceDefinition object.
        It's through the returned collection that you can create new BRepCoEdgeDefinition objects.
        """
        return BRepCoEdgeDefinitions()

class BRepLoopDefinitions(core.Base):
    """
    Provides access to the BRepLoopDefinition objects associated with the parent BRepFaceDefinition object.
    It's through this object that you create new BRepLoopDefinition objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepLoopDefinitions:
        return BRepLoopDefinitions()
    def item(self, index: int) -> BRepLoopDefinition:
        """
        Function that returns the specified BRepLoopDefinition object using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepLoopDefinition()
    def add(self) -> BRepLoopDefinition:
        """
        Creates a new empty loop associated with the parent face definition.
        Returns the newly created BRepLoopDefinition object.
        """
        return BRepLoopDefinition()
    @property
    def count(self) -> int:
        """
        The number of B-Rep loop definition objects in the collection.
        """
        return int()

class BRepLoops(core.Base):
    """
    BRepLoop collection.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepLoops:
        return BRepLoops()
    def item(self, index: int) -> BRepLoop:
        """
        Function that returns the specified loop using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepLoop()
    @property
    def count(self) -> int:
        """
        The number of loops in the collection.
        """
        return int()

class BRepLump(core.Base):
    """
    Represents an entirely connected set of entities. A BRepBody consists of BRepLumps.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepLump:
        return BRepLump()
    def pointContainment(self, point: core.Point3D) -> PointContainment:
        """
        Determines the relationship of the input point with respect to this lump.
        point : The point to do the containment check for.
        Returns a value from the PointContainment enum indicating the relationship of
        the input point to the lump.
        """
        return PointContainment()
    def createForAssemblyContext(self, occurrence: Occurrence) -> BRepLump:
        """
        Returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context for the created proxy.
        Returns the new BrepLump proxy or null if this isn't the NativeObject.
        """
        return BRepLump()
    @property
    def shells(self) -> BRepShells:
        """
        Returns the BRepShells owned by the lump
        """
        return BRepShells()
    @property
    def faces(self) -> BRepFaces:
        """
        Returns the BRepFaces owned by the lump
        """
        return BRepFaces()
    @property
    def edges(self) -> BRepEdges:
        """
        Returns the BRepEdges owned by the lump
        """
        return BRepEdges()
    @property
    def vertices(self) -> BRepVertices:
        """
        Returns the BRepVertices owned by the lump
        """
        return BRepVertices()
    @property
    def body(self) -> BRepBody:
        """
        Returns the immediate owner BRepBody of the lump
        """
        return BRepBody()
    @property
    def isClosed(self) -> bool:
        """
        Returns true of the lump is closed
        """
        return bool()
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns the bounding box of the lump
        """
        return core.BoundingBox3D()
    @property
    def area(self) -> float:
        """
        Returns the area in cm ^ 2.
        """
        return float()
    @property
    def volume(self) -> float:
        """
        Returns the volume in cm ^ 3. Returns 0 in the case the lump is not solid.
        """
        return float()
    @property
    def meshManager(self) -> MeshManager:
        """
        Returns the mesh manager object for this lump.
        """
        return MeshManager()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly context that is directly referencing this
        object in an assembly. This is only valid in the case where this
        BRepLump object is acting as a proxy in an assembly. Returns null
        in the case where the object is not in the context of an assembly.
        but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> BRepLump:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return BRepLump()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the BRepLump object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same lump.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        
        This is only valid for lump that exist in the design, (the isTemporary
        property is false).
        """
        return str()

class BRepLumpDefinition(core.Base):
    """
    Represents the definition of a B-Rep lump which is used in defining the topology of a B-Rep body.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepLumpDefinition:
        return BRepLumpDefinition()
    @property
    def shellDefinitions(self) -> BRepShellDefinitions:
        """
        Provides access to the BRepShellDefinitions object associated with this BRepLumpDefinition.
        It's through the returned collection that you can create new BRepShellDefinition objects.
        """
        return BRepShellDefinitions()

class BRepLumpDefinitions(core.Base):
    """
    Provides access to the BRepLumpDefinition objects associated with the BRepBodyDefinition
    and it's through this object that you create new BRepLumpDefinition objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepLumpDefinitions:
        return BRepLumpDefinitions()
    def item(self, index: int) -> BRepLumpDefinition:
        """
        Function that returns the specified BRepLumpDefinition object using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepLumpDefinition()
    def add(self) -> BRepLumpDefinition:
        """
        Creates a new empty BRepLumpDefinition associated with the parent BRepBodyDefinition object.
        Returns the newly created BRepLumpDefinition object.
        """
        return BRepLumpDefinition()
    @property
    def count(self) -> int:
        """
        The number of B-Rep lump definition objects in the collection.
        """
        return int()

class BRepLumps(core.Base):
    """
    BRepLump collection.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepLumps:
        return BRepLumps()
    def item(self, index: int) -> BRepLump:
        """
        Function that returns the specified lump using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepLump()
    @property
    def count(self) -> int:
        """
        Returns the number of lumps in the collection.
        """
        return int()

class BRepShell(core.Base):
    """
    Represents an entirely connected set of BRepFaces. A BRepLump may contain multiple BRepShells.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepShell:
        return BRepShell()
    def pointContainment(self, point: core.Point3D) -> PointContainment:
        """
        Determines the relationship of the input point with respect to this shell.
        point : The point to do the containment check for.
        Returns a value from the PointContainment enum indicating the relationship of
        the input point to the shell.
        """
        return PointContainment()
    def createForAssemblyContext(self, occurrence: Occurrence) -> BRepShell:
        """
        Returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context for the created proxy.
        Returns the new BrepShell proxy or null if this isn't the NativeObject.
        """
        return BRepShell()
    @property
    def faces(self) -> BRepFaces:
        """
        Returns the BRepFaces directly owned by this shell
        """
        return BRepFaces()
    @property
    def edges(self) -> BRepEdges:
        """
        returns the BRepEdges owned by this shell
        """
        return BRepEdges()
    @property
    def vertices(self) -> BRepVertices:
        """
        Returns the BRepVertices owned by this shell
        """
        return BRepVertices()
    @property
    def lump(self) -> BRepLump:
        """
        Returns the parent lump of this shell.
        """
        return BRepLump()
    @property
    def body(self) -> BRepBody:
        """
        Returns the parent body of the shell.
        """
        return BRepBody()
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns the bounding box of this shell
        """
        return core.BoundingBox3D()
    @property
    def isClosed(self) -> bool:
        """
        Returns true if this shell is closed
        """
        return bool()
    @property
    def isVoid(self) -> bool:
        """
        Returns true if the faces of this shell bound a void or an empty space within an outer shell.
        """
        return bool()
    @property
    def area(self) -> float:
        """
        Returns the area in cm ^ 2.
        """
        return float()
    @property
    def volume(self) -> float:
        """
        Returns the volume in cm ^ 3. Returns 0 in the case the shell is not solid.
        """
        return float()
    @property
    def meshManager(self) -> MeshManager:
        """
        Returns the mesh manager object for this shell.
        """
        return MeshManager()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this
        object in an assembly. This is only valid in the case where this
        BRepShell object is acting as a proxy in an assembly. Returns null
        in the case where the object is not in the context of an assembly.
        but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> BRepShell:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return BRepShell()
    @property
    def wire(self) -> BRepWire:
        """
        Returns the wire body, if any, that exists in this shell. Returns null if the
        shell doesn't have a wire body.
        """
        return BRepWire()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the BRepShell object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same shell.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        
        This is only valid for shells that exist in the design, (the isTemporary
        property is false).
        """
        return str()

class BRepShellDefinition(core.Base):
    """
    Represents the definition of a B-Rep shell that can be used as input to create a BRepBody that includes this shell.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepShellDefinition:
        return BRepShellDefinition()
    @property
    def faceDefinitions(self) -> BRepFaceDefinitions:
        """
        Provides access to the BRepFaceDefinitions object associated with this BRepShellDefinition.
        It's through the returned collection that you can create new BRepFaceDefinition objects.
        """
        return BRepFaceDefinitions()
    @property
    def wireDefinition(self) -> BRepWireDefinition:
        """
        Returns the single BRepWireDefinition associated with this shell definition.
        """
        return BRepWireDefinition()

class BRepShellDefinitions(core.Base):
    """
    Provides access to the BRepShellDefinition objects associated with the object the collection was obtained from.
    It's through this object that you create new BRepShellDefinition objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepShellDefinitions:
        return BRepShellDefinitions()
    def item(self, index: int) -> BRepShellDefinition:
        """
        Function that returns the specified BRepShellDefinition object using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepShellDefinition()
    def add(self) -> BRepShellDefinition:
        """
        Creates a new empty BRepShellDefinition object associated with the parent BRepLumpDefinition.
        Returns the newly created BRepShellDefinition object.
        """
        return BRepShellDefinition()
    @property
    def count(self) -> int:
        """
        The number of B-Rep shell definition objects in the collection.
        """
        return int()

class BRepShells(core.Base):
    """
    BRepShell collection.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepShells:
        return BRepShells()
    def item(self, index: int) -> BRepShell:
        """
        Function that returns the specified shell using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepShell()
    @property
    def count(self) -> int:
        """
        The number of shells in the collection.
        """
        return int()

class BRepVertex(core.Base):
    """
    A 0-dimensional topological entity that bounds a BRepEdge.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepVertex:
        return BRepVertex()
    def createForAssemblyContext(self, occurrence: Occurrence) -> BRepVertex:
        """
        Returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context for the created proxy.
        Returns the new BrepVertex proxy or null if this isn't the NativeObject.
        """
        return BRepVertex()
    @property
    def faces(self) -> BRepFaces:
        """
        Returns the BRepFaces that uses this vertex through BRepEdge
        """
        return BRepFaces()
    @property
    def edges(self) -> BRepEdges:
        """
        Returns the BRepEdges bounded by this vertex
        """
        return BRepEdges()
    @property
    def isTolerant(self) -> bool:
        """
        Returns if the vertex is tolerant.
        The tolerance used is available from the tolerance property.
        """
        return bool()
    @property
    def tolerance(self) -> float:
        """
        Returns the tolerance used by a tolerant vertex.
        This value is only useful when isTolerant is true.
        """
        return float()
    @property
    def geometry(self) -> core.Point3D:
        """
        Returns the underlying geometry point
        """
        return core.Point3D()
    @property
    def shell(self) -> BRepShell:
        """
        Returns the parent shell.
        """
        return BRepShell()
    @property
    def body(self) -> BRepBody:
        """
        Returns the parent body.
        """
        return BRepBody()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this
        object in an assembly. This is only valid in the case where this
        BRepVertex object is acting as a proxy in an assembly. Returns null
        in the case where the object is not in the context of an assembly.
        but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> BRepVertex:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return BRepVertex()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this face.
        """
        return core.Attributes()
    @property
    def tempId(self) -> int:
        """
        Returns the temporary ID of this vertex. This ID is only good while the document
        remains open and as long as the owning BRepBody is not modified in any way.
        The findByTempId method of the BRepBody will return the entity in the body with the given ID.
        """
        return int()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the BRepVertex object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same vertex.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        
        This is only valid for vertices that exist in the design, (the isTemporary
        property is false).
        """
        return str()

class BRepVertexDefinition(core.Base):
    """
    Represents the definition of a B-Rep vertex that can be used as input to create a BRepBody that includes this vertex.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepVertexDefinition:
        return BRepVertexDefinition()
    @property
    def position(self) -> core.Point3D:
        """
        Gets and sets the position of the vertex in model space.
        """
        return core.Point3D()
    @position.setter
    def position(self, value: core.Point3D):
        """
        Gets and sets the position of the vertex in model space.
        """
        pass

class BRepVertices(core.Base):
    """
    BRepVertex collection.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepVertices:
        return BRepVertices()
    def item(self, index: int) -> BRepVertex:
        """
        Function that returns the specified vertex using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepVertex()
    @property
    def count(self) -> int:
        """
        The number of vertices in the collection.
        """
        return int()

class BRepWire(core.Base):
    """
    Represents a single B-Rep wire body. A wire body consists of one or
    more edges and their vertices.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepWire:
        return BRepWire()
    def offsetPlanarWire(self, planeNormal: core.Vector3D, distance: float, cornerType: OffsetCornerTypes) -> BRepBody:
        """
        Method that computes the offset for a planar wire. A BRepBody containing the resulting
        BRepWire object(s) is returned. It's possible that the offset result of a single wire
        can result in multiple wires.
        planeNormal : Input Vector3D object that defines the positive direction of the
        plane the plane the wire lies on. This vector must be normal to the plane and is used to
        determine the side to offset the curves to. A positive offset distance is in the direction
        of the cross product (wire_tangent x wire_plane_normal). A negative offset is in the
        opposite direction.
        distance : The offset distance in centimeters. See the description for the Normal argument to see how
        a positive or negative value for the distance specifies the direction of the offset.
        cornerType : Specifies how the corners are connected when offsetting the curves results in gaps in the corners.
        See the documentation of the enum for a detailed description of each option.
        Returns a new temporary BRepBody that contains one or more wires that represent the offset.
        """
        return BRepBody()
    def createForAssemblyContext(self, occurrence: Occurrence) -> BRepWire:
        """
        Returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context for the created proxy.
        Returns the new BRepWire proxy or null if this isn't the NativeObject.
        """
        return BRepWire()
    @property
    def edges(self) -> BRepEdges:
        """
        Returns the B-Rep edges associated with this wire body.
        """
        return BRepEdges()
    @property
    def vertices(self) -> BRepVertices:
        """
        Returns the B-Rep vertices associated with this wire body.
        """
        return BRepVertices()
    @property
    def coEdges(self) -> BRepCoEdges:
        """
        Returns the co-edges associated with this wire body. The co-edges record
        the connections between the edges in the wire body.
        """
        return BRepCoEdges()
    @property
    def isPlanar(self) -> bool:
        """
        Indicates if this entities making up this wire body are planar and all lie on the same plane.
        """
        return bool()
    @property
    def parent(self) -> BRepBody:
        """
        Returns the parent BRepBody object that contains this wire.
        """
        return BRepBody()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this
        object in an assembly. This is only valid in the case where this
        BRepFace object is acting as a proxy in an assembly. Returns null
        in the case where the object is not in the context of an assembly.
        but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> BRepWire:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return BRepWire()

class BRepWireDefinition(core.Base):
    """
    Represents the definition of a B-Rep wire that can be used as input to create a BRepBody that includes this wire.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepWireDefinition:
        return BRepWireDefinition()
    @property
    def wireEdgeDefinitions(self) -> BRepWireEdgeDefinitions:
        """
        Provides access to the BRepWireEdgeDefinitions object associated with the parent BRepWireDefinition object.
        It's through the returned collection that you can create new BRepWireEdgeDefinitions objects.
        """
        return BRepWireEdgeDefinitions()

class BRepWireEdgeDefinition(core.Base):
    """
    Represents the definition of an edge in B-Rep wire that can be used as input to create a BRepBody that includes this wire edge.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepWireEdgeDefinition:
        return BRepWireEdgeDefinition()
    @property
    def associativeID(self) -> int:
        """
        Gets and sets the associate ID of this B-Rep wire definition. This ID will be copied to the corresponding
        edge when the BRepBodyDefinition is used to create a BrepBody. It is used by Fusion360 as
        the identifier for the edge and is used for tracking this geometry for parametric recomputes.
        """
        return int()
    @associativeID.setter
    def associativeID(self, value: int):
        """
        Gets and sets the associate ID of this B-Rep wire definition. This ID will be copied to the corresponding
        edge when the BRepBodyDefinition is used to create a BrepBody. It is used by Fusion360 as
        the identifier for the edge and is used for tracking this geometry for parametric recomputes.
        """
        pass
    @property
    def startVertex(self) -> BRepVertexDefinition:
        """
        Gets and sets the start vertex of the wire edge definition.
        """
        return BRepVertexDefinition()
    @startVertex.setter
    def startVertex(self, value: BRepVertexDefinition):
        """
        Gets and sets the start vertex of the wire edge definition.
        """
        pass
    @property
    def endVertex(self) -> BRepVertexDefinition:
        """
        Gets and sets the end vertex of the wire edge definition.
        """
        return BRepVertexDefinition()
    @endVertex.setter
    def endVertex(self, value: BRepVertexDefinition):
        """
        Gets and sets the end vertex of the wire edge definition.
        """
        pass
    @property
    def modelSpaceCurve(self) -> core.Curve3D:
        """
        Gets and sets the Curve3D object that defines the shape of the edge using 3D geometry in model space.
        Valid objects are an Arc3D, NurbsCurve3D, Circle3D, Ellipse3D, EllipticalArc3D, or Line3D.
        """
        return core.Curve3D()
    @modelSpaceCurve.setter
    def modelSpaceCurve(self, value: core.Curve3D):
        """
        Gets and sets the Curve3D object that defines the shape of the edge using 3D geometry in model space.
        Valid objects are an Arc3D, NurbsCurve3D, Circle3D, Ellipse3D, EllipticalArc3D, or Line3D.
        """
        pass

class BRepWireEdgeDefinitions(core.Base):
    """
    
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepWireEdgeDefinitions:
        return BRepWireEdgeDefinitions()
    def item(self, index: int) -> BRepWireEdgeDefinition:
        """
        Function that returns the specified BRepWireEdgeDefinition object using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepWireEdgeDefinition()
    def add(self, startVertex: BRepVertexDefinition, endVertex: BRepVertexDefinition, modelSpaceCurve: core.Curve3D) -> BRepWireEdgeDefinition:
        """
        Creates a new BRepWireEdgeDefinition object associated with the parent BRepWireDefinition object.
        startVertex : Vertex definition that defines the start of the edge. For a closed curve, like a circle, you still
        need to provide a vertex on the curve but should use the same BRepVertexDefinition for both the start and end vertices.
        endVertex : Vertex definition that defines the end of the edge. For a closed curve, like a circle, this should be the
        same vertex as used for the start vertex.
        modelSpaceCurve : A Curve3D object that defines the shape of the edge using 3D geometry in model space.
        Valid input is an Arc3D, NurbsCurve3D, Circle3D, Ellipse3D, EllipticalArc3D, or Line3D.
        Returns the newly created BRepWireEdgeDefinition object or null in the case of failure.
        """
        return BRepWireEdgeDefinition()
    @property
    def count(self) -> int:
        """
        The number of B-Rep wire edge definition objects in the collection.
        """
        return int()

class BRepWires(core.Base):
    """
    Provides access to B-Rep wire bodies.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BRepWires:
        return BRepWires()
    def item(self, index: int) -> BRepWire:
        """
        Function that returns the specified wire using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return BRepWire()
    @property
    def count(self) -> int:
        """
        The number of B-Rep wire bodies in the collection.
        """
        return int()

class ChamferEdgeSet(core.Base):
    """
    The base class for the classes that define the different types of chamfer edge sets.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ChamferEdgeSet:
        return ChamferEdgeSet()
    def deleteMe(self) -> bool:
        """
        Deletes the chamfer edge set from the chamfer.
        
        To use this method, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        Returns true if the operation was successful.
        """
        return bool()
    @property
    def isTangentChain(self) -> bool:
        """
        Gets and sets the Tangent chain for chamfer. This enables tangent chain option for chamfer.
        """
        return bool()
    @isTangentChain.setter
    def isTangentChain(self, value: bool):
        """
        Gets and sets the Tangent chain for chamfer. This enables tangent chain option for chamfer.
        """
        pass

class ChamferEdgeSets(core.Base):
    """
    Collection that provides access to all of the existing chamfer edge sets associated with a chamfer feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ChamferEdgeSets:
        return ChamferEdgeSets()
    def item(self, index: int) -> ChamferEdgeSet:
        """
        Function that returns the specified chamfer edge set using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ChamferEdgeSet()
    def addEqualDistanceChamferEdgeSet(self, edges: core.ObjectCollection, distance: core.ValueInput, isTangentChain: bool) -> bool:
        """
        Adds a set of edges an equal distance offset to this chamfer feature.
        
        To use this method, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        edges : An ObjectCollection containing the edges to be chamfered. Edges can be defined by passing in BrepEdge,
        BRepFace, or Feature objects. If BRepFace or Feature objects are passed in all of the edges associated
        with those objects will be chamfered. If BRepEdge objects are provided and the isTangentChain argument is true
        additional edges may also get chamfered if they are tangentially connected to any of the input edges.
        distance : A ValueInput object that defines the distance offset of the chamfer. If the ValueInput uses
        a real then it is interpreted as centimeters. If it is a string then the units
        can be defined as part of the string (i.e. "2 in") or if no units are specified
        it is interpreted using the current default units for length.
        isTangentChain : A boolean value for setting whether or not edges that are tangentially connected to
        the input edges (if any) will also be chamfered.
        Returns true if the set of edges was successfully added to the ChamferFeatureInput.
        """
        return bool()
    def addTwoDistancesChamferEdgeSet(self, edges: core.ObjectCollection, distanceOne: core.ValueInput, distanceTwo: core.ValueInput, isFlipped: bool, isTangentChain: bool) -> bool:
        """
        Adds a set of edges an equal distance offset to this chamfer feature.
        
        To use this method, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        edges : An ObjectCollection containing the edges to be chamfered. Edges can be defined by passing in BrepEdge,
        BRepFace, or Feature objects. If BRepFace or Feature objects are passed in all of the edges associated
        with those objects will be chamfered. If BRepEdge objects are provided and the isTangentChain argument is true
        additional edges may also get chamfered if they are tangentially connected to any of the input edges.
        distanceOne : A ValueInput object that defines the first distance offset of the chamfer. If the ValueInput uses
        a real then it is interpreted as centimeters. If it is a string then the units
        can be defined as part of the string (i.e. "2 in") or if no units are specified
        it is interpreted using the current default units for length.
        distanceTwo : A ValueInput object that defines the second distance offset of the chamfer. If the ValueInput uses
        a real then it is interpreted as centimeters. If it is a string then the units
        can be defined as part of the string (i.e. "2 in") or if no units are specified
        it is interpreted using the current default units for length.
        isFlipped : Swaps the directions for distance one and two.
        isTangentChain : A boolean value for setting whether or not edges that are tangentially connected to
        the input edges (if any) will also be chamfered.
        Returns true if the set of edges was successfully added to the ChamferFeatureInput.
        """
        return bool()
    def addDistanceAndAngleChamferEdgeSet(self, edges: core.ObjectCollection, distance: core.ValueInput, angle: core.ValueInput, isFlipped: bool, isTangentChain: bool) -> bool:
        """
        Adds a set of edges an equal distance offset to this chamfer feature.
        
        To use this method, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        edges : An ObjectCollection containing the edges to be chamfered. Edges can be defined by passing in BrepEdge,
        BRepFace, or Feature objects. If BRepFace or Feature objects are passed in all of the edges associated
        with those objects will be chamfered. If BRepEdge objects are provided and the isTangentChain argument is true
        additional edges may also get chamfered if they are tangentially connected to any of the input edges.
        distance : A ValueInput object that defines the distance offset of the chamfer. If the ValueInput uses
        a real then it is interpreted as centimeters. If it is a string then the units
        can be defined as part of the string (i.e. "2 in") or if no units are specified
        it is interpreted using the current default units for length.
        angle : A ValueInput object that defines the angle of the chamfer. If the ValueInput uses
        a real then it is interpreted as radians. If it is a string then the units
        can be defined as part of the string (i.e. "2 rad") or if no units are specified
        it is interpreted as degrees.
        isFlipped : Swaps the directions for distance one and two.
        isTangentChain : A boolean value for setting whether or not edges that are tangentially connected to
        the input edges (if any) will also be chamfered.
        Returns true if the set of edges was successfully added to the ChamferFeatureInput.
        """
        return bool()
    @property
    def count(self) -> int:
        """
        The number of chamfer edge sets in the collection.
        """
        return int()

class ChamferFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a chamfer
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ChamferFeatureInput:
        return ChamferFeatureInput()
    def setToEqualDistance(self, distance: core.ValueInput) -> bool:
        """
        Adds a set of edges to this input.
        distance : A ValueInput object that defines the size of the chamfer. If the ValueInput uses
        a real then it is interpreted as centimeters. If it is a string then the units
        can be defined as part of the string (i.e. "2 in"). If no units are specified
        it is interpreted using the current default units for length.
        Returns true if the set of edges was successfully added to the ChamferFeatureInput.
        """
        return bool()
    def setToTwoDistances(self, distanceOne: core.ValueInput, distanceTwo: core.ValueInput) -> bool:
        """
        Adds a set of edges to this input.
        distanceOne : A ValueInput object that defines the distanceOne of the chamfer. This distance
        is along the face which is on the left of the selected edge.
        If the ValueInput uses a real then it is interpreted as centimeters.
        If it is a string then the units can be defined as part of the string (i.e. "2 in").
        If no units are specified it is interpreted using the current default units for length.
        distanceTwo : A ValueInput object that defines the distanceTwo of the chamfer. This distance
        is along the face which is on the right of the selected edge.
        If the ValueInput uses a real then it is interpreted as centimeters.
        If it is a string then the units can be defined as part of the string (i.e. "2 in").
        If no units are specified it is interpreted using the current default units for length.
        Returns true if successful.
        """
        return bool()
    def setToDistanceAndAngle(self, distance: core.ValueInput, angle: core.ValueInput) -> bool:
        """
        Adds a set of edges to this input.
        distance : A ValueInput object that defines the distance of the chamfer. This distance
        is along the face which is on the right of the selected edge.
        If the ValueInput uses a real then it is interpreted as centimeters.
        If it is a string then the units can be defined as part of the string (i.e. "2 in").
        If no units are specified it is interpreted using the current default units for length.
        angle : A valueInput object that defines the angle. The direction will be towards to the face
        which is on the left of the selected edge. This can be a string or a value.
        If it's a string it is interpreted using the current document units and can include
        equations. For example all of the following are valid as long as they result in
        angle units; "45", "45 deg", "a1 / 2". If a value is input it is interpreted
        as radians. It cannot be negative.
        Returns true if successful.
        """
        return bool()
    @property
    def edges(self) -> core.ObjectCollection:
        """
        Gets and sets the collection of edges that will be chamfered.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return core.ObjectCollection()
    @edges.setter
    def edges(self, value: core.ObjectCollection):
        """
        Gets and sets the collection of edges that will be chamfered.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def isTangentChain(self) -> bool:
        """
        Gets and sets if any edges that are tangentially connected to any of chamfered
        edges will also be included in the chamfer.
        """
        return bool()
    @isTangentChain.setter
    def isTangentChain(self, value: bool):
        """
        Gets and sets if any edges that are tangentially connected to any of chamfered
        edges will also be included in the chamfer.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass
    @property
    def cornerType(self) -> ChamferCornerTypes:
        """
        Gets and sets the type of corner to be modeled when multiple edges connect at a vertex.
        """
        return ChamferCornerTypes()
    @cornerType.setter
    def cornerType(self, value: ChamferCornerTypes):
        """
        Gets and sets the type of corner to be modeled when multiple edges connect at a vertex.
        """
        pass
    @property
    def chamferEdgeSets(self) -> ChamferEdgeSets:
        """
        Returns the collection of edge sets for this chamfer feature input.
        """
        return ChamferEdgeSets()

class ChamferFeatures(core.Base):
    """
    Collection that provides access to all of the existing chamfer features in a component
    and supports the ability to create new chamfer features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ChamferFeatures:
        return ChamferFeatures()
    def item(self, index: int) -> ChamferFeature:
        """
        Function that returns the specified chamfer feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ChamferFeature()
    def createInput(self, edges: core.ObjectCollection, isTangentChain: bool) -> ChamferFeatureInput:
        """
        Creates a ChamferFeatureInput object. Use properties and methods on this object
        to define the chamfer you want to create and then use the Add method, passing in
        the ChamferFeatureInput object.
        edges : The collection of edges that will be chamfered.
        isTangentChain : Boolean indicating if all edges that are tangentially connected to any of the input edges should be included in the chamfer or not.
        Returns the newly created ChamferFeatureInput object or null if the creation failed.
        """
        return ChamferFeatureInput()
    def add(self, input: ChamferFeatureInput) -> ChamferFeature:
        """
        Creates a new chamfer feature.
        input : A ChamferFeatureInput object that defines the desired chamfer. Use the createInput
        method to create a new ChamferFeatureInput object and then use methods on it
        (the ChamferFeatureInput object) to define the chamfer.
        Returns the newly created ChamferFeature object or null if the creation failed.
        """
        return ChamferFeature()
    def itemByName(self, name: str) -> ChamferFeature:
        """
        Function that returns the specified chamfer feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return ChamferFeature()
    def createInput2(self) -> ChamferFeatureInput:
        """
        Creates a ChamferFeatureInput object. Use properties and methods on this object
        to define the chamfer you want to create and then use the Add method, passing in
        the ChamferFeatureInput object.
        Returns the newly created ChamferFeatureInput object or null if the creation failed.
        """
        return ChamferFeatureInput()
    @property
    def count(self) -> int:
        """
        The number of chamfer features in the collection.
        """
        return int()

class ChamferTypeDefinition(core.Base):
    """
    The base class for the classes that define how a chamfer can be defined.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ChamferTypeDefinition:
        return ChamferTypeDefinition()
    @property
    def parentFeature(self) -> ChamferFeature:
        """
        Returns the feature that owns this chamfer type definition
        """
        return ChamferFeature()

class CircularPatternFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a circular pattern
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CircularPatternFeatureInput:
        return CircularPatternFeatureInput()
    @property
    def inputEntities(self) -> core.ObjectCollection:
        """
        Gets and sets the input entities. The collection can contain faces, features, bodies or occurrences.
        All of the entities must be of a single type. For example, it can't contain features and occurrences
        but only features or occurrences.
        """
        return core.ObjectCollection()
    @inputEntities.setter
    def inputEntities(self, value: core.ObjectCollection):
        """
        Gets and sets the input entities. The collection can contain faces, features, bodies or occurrences.
        All of the entities must be of a single type. For example, it can't contain features and occurrences
        but only features or occurrences.
        """
        pass
    @property
    def axis(self) -> core.Base:
        """
        Gets and sets the axis of circular pattern. This can be a sketch line, linear edge,
        construction axis, an edge/sketch curve that defines an axis (circle, etc.) or a face that defines an axis (cylinder, cone, torus, etc.).
        """
        return core.Base()
    @axis.setter
    def axis(self, value: core.Base):
        """
        Gets and sets the axis of circular pattern. This can be a sketch line, linear edge,
        construction axis, an edge/sketch curve that defines an axis (circle, etc.) or a face that defines an axis (cylinder, cone, torus, etc.).
        """
        pass
    @property
    def quantity(self) -> core.ValueInput:
        """
        Gets and sets quantity of the elements.
        """
        return core.ValueInput()
    @quantity.setter
    def quantity(self, value: core.ValueInput):
        """
        Gets and sets quantity of the elements.
        """
        pass
    @property
    def totalAngle(self) -> core.ValueInput:
        """
        Gets and sets total angle. A negative angle can be used to reverse the direction.
        An angle of 360 degrees or 2 pi radians will create a full circular pattern.
        """
        return core.ValueInput()
    @totalAngle.setter
    def totalAngle(self, value: core.ValueInput):
        """
        Gets and sets total angle. A negative angle can be used to reverse the direction.
        An angle of 360 degrees or 2 pi radians will create a full circular pattern.
        """
        pass
    @property
    def isSymmetric(self) -> bool:
        """
        Gets and sets if the angle extent is in one direction or symmetric.
        """
        return bool()
    @isSymmetric.setter
    def isSymmetric(self, value: bool):
        """
        Gets and sets if the angle extent is in one direction or symmetric.
        """
        pass
    @property
    def patternComputeOption(self) -> PatternComputeOptions:
        """
        Gets and sets the compute option when patterning features. The default value for this is AdjustPatternCompute.
        This property only applies when patterning features and is ignored in the direct modeling environment.
        """
        return PatternComputeOptions()
    @patternComputeOption.setter
    def patternComputeOption(self, value: PatternComputeOptions):
        """
        Gets and sets the compute option when patterning features. The default value for this is AdjustPatternCompute.
        This property only applies when patterning features and is ignored in the direct modeling environment.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class CircularPatternFeatures(core.Base):
    """
    Collection that provides access to all of the existing circular pattern features in a component
    and supports the ability to create new circular pattern features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CircularPatternFeatures:
        return CircularPatternFeatures()
    def item(self, index: int) -> CircularPatternFeature:
        """
        Function that returns the specified circular pattern feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CircularPatternFeature()
    def createInput(self, inputEntities: core.ObjectCollection, axis: core.Base) -> CircularPatternFeatureInput:
        """
        Creates a CircularPatternFeatureInput object. Use properties and methods on this object
        to define the circular pattern you want to create and then use the Add method, passing in
        the CircularPatternFeatureInput object.
        inputEntities : The collection can contain faces, features, bodies or occurrences.
        All of the entities must be of a single type. For example, it can't contain features and occurrences
        but only features or occurrences.
        axis : Input linear entity or the entity has axis that defines axis of circular pattern. This can be a sketch line, linear edge,
        construction axis, an edge/sketch curve that defines an axis (circle, etc.) or a face that defines an axis (cylinder, cone, torus, etc.).
        Returns the newly created CircularPatternFeatureInput object or null if the creation failed.
        """
        return CircularPatternFeatureInput()
    def add(self, input: CircularPatternFeatureInput) -> CircularPatternFeature:
        """
        Creates a new circular pattern feature.
        input : A CircularPatternFeatureInput object that defines the desired circular pattern. Use the createInput
        method to create a new CircularPatternFeatureInput object and then use methods on it
        (the CircularPatternFeatureInput object) to define the circular pattern.
        Returns the newly created CircularPatternFeature object or null if the creation failed.
        """
        return CircularPatternFeature()
    def itemByName(self, name: str) -> CircularPatternFeature:
        """
        Function that returns the specified circular pattern feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return CircularPatternFeature()
    @property
    def count(self) -> int:
        """
        The number of circular pattern features in the collection.
        """
        return int()

class CoilFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a coil feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CoilFeatureInput:
        return CoilFeatureInput()
    def setToRevolutionAndHeight(self, revolutions: core.ValueInput, height: core.ValueInput, angle: core.ValueInput) -> bool:
        """
        Sets the coil type to RevolutionsAndHeightCoilType.
        revolutions : A ValueInput object that defines the number of revolutions.
        height : A ValueInput object that defines the height.
        angle : A ValueInput object that defines angle.
        Returns true if successful.
        """
        return bool()
    def setToRevolutionsAndPitch(self, revolutions: core.ValueInput, pitch: core.ValueInput, angle: core.ValueInput) -> bool:
        """
        Sets the coil type to RevolutionsAndPitchCoilType.
        revolutions : A ValueInput object that defines the number of revolutions.
        pitch : A ValueInput object that defines the pitch.
        angle : A ValueInput object that defines angle.
        Returns true if successful.
        """
        return bool()
    def setToHeightAndPitchCoil(self, height: core.ValueInput, pitch: core.ValueInput, angle: core.ValueInput) -> bool:
        """
        Sets the coil type to HeightAndPitchCoilType.
        height : A ValueInput object that defines the height.
        pitch : A ValueInput object that defines the pitch.
        angle : A ValueInput object that defines angle.
        Returns true if successful.
        """
        return bool()
    def setToSpiral(self, revolutions: core.ValueInput, pitch: core.ValueInput) -> bool:
        """
        Sets the coil type to SpiralCoilType.
        revolutions : A ValueInput object that defines the number of revolutions.
        pitch : A ValueInput object that defines the pitch.
        Returns true if successful.
        """
        return bool()
    @property
    def isSolid(self) -> bool:
        """
        Specifies if the coil should be created as a solid or surface. This is
        initialized to true so a solid will be created if it's not changed.
        It only can be set to false in non-parametric modeling.
        """
        return bool()
    @isSolid.setter
    def isSolid(self, value: bool):
        """
        Specifies if the coil should be created as a solid or surface. This is
        initialized to true so a solid will be created if it's not changed.
        It only can be set to false in non-parametric modeling.
        """
        pass
    @property
    def revolutions(self) -> core.ValueInput:
        """
        Gets the revolutions number. Returns null in the case where the coilType property returns HeightAndPitchCoilType.
        """
        return core.ValueInput()
    @property
    def height(self) -> core.ValueInput:
        """
        Gets the height. Returns null in the case where the coilType property returns RevolutionsAndPitchCoilType.
        """
        return core.ValueInput()
    @property
    def pitch(self) -> core.ValueInput:
        """
        Gets the pitch. Returns null in the case where the coilType property returns RevolutionsAndHeightCoilType or SpiralCoilType.
        """
        return core.ValueInput()
    @property
    def angle(self) -> core.ValueInput:
        """
        Gets the angle. Returns null in the case where the coilType property returns SpiralCoilType.
        """
        return core.ValueInput()
    @property
    def coilType(self) -> CoilFeatureTypes:
        """
        Gets the type of the coil.
        """
        return CoilFeatureTypes()
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the type of operation performed by the coil.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the type of operation performed by the coil.
        """
        pass
    @property
    def basePlane(self) -> core.Base:
        """
        Gets and sets the base plane.
        """
        return core.Base()
    @basePlane.setter
    def basePlane(self, value: core.Base):
        """
        Gets and sets the base plane.
        """
        pass
    @property
    def isClockwiseRotation(self) -> bool:
        """
        Gets and sets whether the rotation is clockwise or counter-clockwise. A value of true indicates clockwise rotation.
        It defaults to true.
        """
        return bool()
    @isClockwiseRotation.setter
    def isClockwiseRotation(self, value: bool):
        """
        Gets and sets whether the rotation is clockwise or counter-clockwise. A value of true indicates clockwise rotation.
        It defaults to true.
        """
        pass
    @property
    def diameter(self) -> core.ValueInput:
        """
        Gets and sets the diameter.
        """
        return core.ValueInput()
    @diameter.setter
    def diameter(self, value: core.ValueInput):
        """
        Gets and sets the diameter.
        """
        pass
    @property
    def coilSectionType(self) -> CoilFeatureSectionTypes:
        """
        Gets the section type of the coil.
        It defaults to CircularCoilSectionType.
        """
        return CoilFeatureSectionTypes()
    @coilSectionType.setter
    def coilSectionType(self, value: CoilFeatureSectionTypes):
        """
        Gets the section type of the coil.
        It defaults to CircularCoilSectionType.
        """
        pass
    @property
    def coilSectionPosition(self) -> CoilFeatureSectionPositions:
        """
        Gets the section position of the coil.
        It defaults to InsideCoilSectionPosition.
        """
        return CoilFeatureSectionPositions()
    @coilSectionPosition.setter
    def coilSectionPosition(self, value: CoilFeatureSectionPositions):
        """
        Gets the section position of the coil.
        It defaults to InsideCoilSectionPosition.
        """
        pass
    @property
    def sectionSize(self) -> core.ValueInput:
        """
        Gets and sets the section size.
        """
        return core.ValueInput()
    @sectionSize.setter
    def sectionSize(self, value: core.ValueInput):
        """
        Gets and sets the section size.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class CoilFeatures(core.Base):
    """
    Collection that provides access to all of the existing coil features in a design
    and supports the ability to create new coil features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CoilFeatures:
        return CoilFeatures()
    def item(self, index: int) -> CoilFeature:
        """
        Function that returns the specified coil feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CoilFeature()
    def itemByName(self, name: str) -> CoilFeature:
        """
        Function that returns the specified coil feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return CoilFeature()
    @property
    def count(self) -> int:
        """
        The number of coil features in the collection.
        """
        return int()

class CombineFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a combine
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CombineFeatureInput:
        return CombineFeatureInput()
    @property
    def targetBody(self) -> BRepBody:
        """
        Gets and sets the BRep Body object that represents the blank body.
        """
        return BRepBody()
    @targetBody.setter
    def targetBody(self, value: BRepBody):
        """
        Gets and sets the BRep Body object that represents the blank body.
        """
        pass
    @property
    def toolBodies(self) -> core.ObjectCollection:
        """
        Gets and sets the BRep Body objects that represent the tool bodies.
        """
        return core.ObjectCollection()
    @toolBodies.setter
    def toolBodies(self, value: core.ObjectCollection):
        """
        Gets and sets the BRep Body objects that represent the tool bodies.
        """
        pass
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the type of operation performed by the combine.
        The valid values are JoinFeatureOperation, CutFeatureOperation and IntersectFeatureOperation.
        The default value is JoinFeatureOperation.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the type of operation performed by the combine.
        The valid values are JoinFeatureOperation, CutFeatureOperation and IntersectFeatureOperation.
        The default value is JoinFeatureOperation.
        """
        pass
    @property
    def isNewComponent(self) -> bool:
        """
        Gets and sets a boolean value for whether or not a new component will be created with the results. The default value is false.
        In Base feature environment NewComponent does not work.
        """
        return bool()
    @isNewComponent.setter
    def isNewComponent(self, value: bool):
        """
        Gets and sets a boolean value for whether or not a new component will be created with the results. The default value is false.
        In Base feature environment NewComponent does not work.
        """
        pass
    @property
    def isKeepToolBodies(self) -> bool:
        """
        Gets and sets a boolean value for whether or not the tool bodies are retrained after the combine results. The default value is false.
        """
        return bool()
    @isKeepToolBodies.setter
    def isKeepToolBodies(self, value: bool):
        """
        Gets and sets a boolean value for whether or not the tool bodies are retrained after the combine results. The default value is false.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class CombineFeatures(core.Base):
    """
    Collection that provides access to all of the existing Combine features in a component
    and supports the ability to create new Combine features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CombineFeatures:
        return CombineFeatures()
    def item(self, index: int) -> CombineFeature:
        """
        Function that returns the specified combine feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        This property returns nothing in the case where the feature is non-parametric.
        """
        return CombineFeature()
    def createInput(self, targetBody: BRepBody, toolBodies: core.ObjectCollection) -> CombineFeatureInput:
        """
        Creates a CombineFeatureInput object. Use properties and methods on this object
        to define the combine you want to create and then use the Add method, passing in
        the CombineFeatureInput object.
        targetBody : A BRep body that represents the blank body.
        toolBodies : An ObjectCollection containing one or more BRep bodies that represent tool bodies.
        Returns the newly created CombineFeatureInput object or null if the creation failed.
        """
        return CombineFeatureInput()
    def add(self, input: CombineFeatureInput) -> CombineFeature:
        """
        Creates a new combine feature.
        input : A CombineFeatureInput object that defines the desired combine. Use the createInput
        method to create a new CombineFeatureInput object and then use methods on it
        (the CombineFeatureInput object) to define the combine.
        Returns the newly created CombineFeature object or null if the creation failed.
        This function returns nothing in the case where the feature is non-parametric.
        """
        return CombineFeature()
    def itemByName(self, name: str) -> CombineFeature:
        """
        Function that returns the specified combine feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return CombineFeature()
    @property
    def count(self) -> int:
        """
        The number of combine features in the collection.
        This property returns nothing in the case where the feature is non-parametric.
        """
        return int()

class ComponentList(core.Base):
    """
    Provides a list of components.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ComponentList:
        return ComponentList()
    def item(self, index: int) -> Component:
        """
        Function that returns the specified component using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Component()
    @property
    def count(self) -> int:
        """
        Returns the number of components in the collection.
        """
        return int()

class Components(core.Base):
    """
    The Components collection object provides access to existing components in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Components:
        return Components()
    def item(self, index: int) -> Component:
        """
        Function that returns the specified component using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Component()
    def itemByName(self, name: str) -> Component:
        """
        Function that returns the specified component by name.
        name : The name of the component within the collection to return.
        Returns the specified component or null if the name is not found.
        """
        return Component()
    def itemById(self, id: str) -> Component:
        """
        Returns the Component that has the specified ID.
        id : The ID of the Component to get. This is the same id used by PIM (Product Information Model).
        Returns the specified Component or null in the case where there isn't a Component with the specified ID in this Design.
        """
        return Component()
    @property
    def count(self) -> int:
        """
        The number of components in the collection.
        """
        return int()

class ConstructionAxes(core.Base):
    """
    Provides access to the construction axes within a component and provides
    methods to create new construction axes.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionAxes:
        return ConstructionAxes()
    def item(self, index: int) -> ConstructionAxis:
        """
        Function that returns the specified construction axis using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ConstructionAxis()
    def itemByName(self, name: str) -> ConstructionAxis:
        """
        Returns the specified construction axis using the name of the construction
        axis as it is displayed in the browser.
        name : The name of the axis as it is displayed in the browser
        Returns the specified item or null if an invalid name was specified.
        """
        return ConstructionAxis()
    def createInput(self, occurrenceForCreation: Occurrence) -> ConstructionAxisInput:
        """
        Create a ConstructionAxisInput object that is in turn used to create a ConstructionAxis.
        occurrenceForCreation : A creation occurrence is needed if the input is in another component AND the
        construction axis is not in the root component. The occurrenceForCreation is analogous
        to the active occurrence in the UI.
        Returns a ConstructionAxisInput object
        """
        return ConstructionAxisInput()
    def add(self, input: ConstructionAxisInput) -> ConstructionAxis:
        """
        Creates and adds a new ConstructionAxis using the creation parameters in the ConstructionAxisInput.
        
        If the ConstructionAxisInput was defined using the setByLine method then
        the add will only work in a direct edit model (do not capture design history) and will fail in a parametric model.
        input : A ConstructionAxisInput object
        Returns the newly created construction axis or null if the creation failed.
        """
        return ConstructionAxis()
    @property
    def count(self) -> int:
        """
        The number of construction axes in the collection.
        """
        return int()
    @property
    def component(self) -> Component:
        """
        The component that owns this collection.
        """
        return Component()

class ConstructionAxis(core.Base):
    """
    ConstructionAxis Object
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionAxis:
        return ConstructionAxis()
    def deleteMe(self) -> bool:
        """
        Deletes the construction axis.
        Returns a bool indicating if the delete was successful or not.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> ConstructionAxis:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return ConstructionAxis()
    @property
    def geometry(self) -> core.InfiniteLine3D:
        """
        Returns an infinite line that represents the position and orientation of the
        construction axis. This geometry is defined in the AssemblyContext of this
        ConstructionAxis.
        """
        return core.InfiniteLine3D()
    @property
    def name(self) -> str:
        """
        The name of the construction axis as it is shown in the browser.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        The name of the construction axis as it is shown in the browser.
        """
        pass
    @property
    def definition(self) -> ConstructionAxisDefinition:
        """
        Returns the construction axis definition object which provides access to the information
        defining the construction axis.
        """
        return ConstructionAxisDefinition()
    @property
    def isParametric(self) -> bool:
        """
        Indicates if this construction axis is parametric or not.
        """
        return bool()
    @property
    def isDeletable(self) -> bool:
        """
        Indicates if this construction axis can be deleted. Base
        construction axes can not be deleted.
        """
        return bool()
    @property
    def isLightBulbOn(self) -> bool:
        """
        Indicates if the light bulb (as displayed in the browser) is on.
        A construction axis will only be visible if it's light bulb, and that of it's
        containing folder and parent component/s are also on.
        """
        return bool()
    @isLightBulbOn.setter
    def isLightBulbOn(self, value: bool):
        """
        Indicates if the light bulb (as displayed in the browser) is on.
        A construction axis will only be visible if it's light bulb, and that of it's
        containing folder and parent component/s are also on.
        """
        pass
    @property
    def isVisible(self) -> bool:
        """
        Gets if the construction plane is visible.
        This property is affected by the AssemblyContext of the construction axis.
        """
        return bool()
    @property
    def parent(self) -> core.Base:
        """
        Returns the parent component or base feature. If both the design and the construction
        axis are parametric, the parent will be a component. If the design is parametric and
        the construction axis is not, the parent will be a base feature. If
        the design is not parametric the parent will be a component.
        """
        return core.Base()
    @property
    def component(self) -> Component:
        """
        Returns the component this construction plane belongs to.
        """
        return Component()
    @property
    def timelineObject(self) -> TimelineObject:
        """
        Returns the timeline object associated with this construction axis.
        """
        return TimelineObject()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> ConstructionAxis:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return ConstructionAxis()
    @property
    def baseFeature(self) -> BaseFeature:
        """
        If this construction axis is associated with a base feature, this property will return that base feature.
        If it's not associated with a base feature, this property will return null.
        """
        return BaseFeature()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this construction axis.
        """
        return core.Attributes()
    @property
    def healthState(self) -> FeatureHealthStates:
        """
        Returns the current health state of this construction axis.
        """
        return FeatureHealthStates()
    @property
    def errorOrWarningMessage(self) -> str:
        """
        Returns the error or warning message in the case where the healthState property returns either
        WarningFeatureHealthState or ErrorFeatureHealthState. Otherwise this property returns an empty string.
        """
        return str()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the ConstructionAxis object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same construction axis.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class ConstructionAxisDefinition(core.Base):
    """
    A Base class to return the information (possibly parametric) used to
    define a ConstructionAxis.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionAxisDefinition:
        return ConstructionAxisDefinition()
    @property
    def parentConstructionAxis(self) -> ConstructionAxis:
        """
        Returns the ConstructionAxis object
        """
        return ConstructionAxis()

class ConstructionAxisInput(core.Base):
    """
    A ConstructionAxisInput is a throwaway object used to create a ConstructionAxis
    The usage pattern is:
    a. create a ConstructionAxisInput (ConstructionAxes.CreateInput)
    b. call one of the member functions to specify how the ConstructionAxis is created
    c. create the ConstructionAxis (call ConstructionAxes.Add)
    d. stop referencing the ConstructionAxisInput (so it gets deleted).
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionAxisInput:
        return ConstructionAxisInput()
    def setByLine(self, line: core.InfiniteLine3D) -> bool:
        """
        This input method is for creating a non-parametric construction axis whose position
        in space is defined by an InfiniteLine3D object.
        
        This method of defining a construction axis is only valid when working in a direct edit model (do not capture design history).
        This is not valid when working in a parametric model and will fail.
        line : An InFiniteLine3D object
        Returns true if the creation of the ConstructionAxisInput is successful.
        """
        return bool()
    def setByCircularFace(self, circularFace: BRepFace) -> bool:
        """
        This input method is for creating an axis coincident with the axis of a
        cylindrical, conical or torus face.
        
        This can result in a parametric or non-parametric construction axis depending
        on whether the parent component is parametric or is a direct edit component.
        circularFace : The face from a cylinder, cone, or torus.
        Returns true if the creation of the ConstructionAxisInput is successful.
        """
        return bool()
    def setByPerpendicularAtPoint(self, face: BRepFace, pointEntity: core.Base) -> bool:
        """
        This input method is for creating an axis that is normal to a face
        at a specified point.
        face : A face (BRepFace object) to create the axis normal to.
        pointEntity : A construction point, sketch point or vertex the axis is to pass through.
        Returns true if the creation of the ConstructionAxisInput is successful.
        """
        return bool()
    def setByTwoPlanes(self, planarEntityOne: core.Base, planarEntityTwo: core.Base) -> bool:
        """
        This input method is for creating a construction axis coincident with the
        intersection of two planes or planar faces.
        This will fail if the two planes are parallel.
        This can result in a parametric or non-parametric construction axis depending
        on whether the parent component is parametric or is a direct edit component.
        planarEntityOne : The first planar face or construction plane to intersect
        planarEntityTwo : The second planar face or construction plane to intersect
        Returns true if the creation of the ConstructionAxisInput is successful.
        """
        return bool()
    def setByTwoPoints(self, pointEntityOne: core.Base, pointEntityTwo: core.Base) -> bool:
        """
        This input method is for creating a construction axis that passes through the two points
        (work points, sketch points or vertices).
        This will fail if the two points are coincident.
        This can result in a parametric or non-parametric construction axis depending
        on whether the parent component is parametric or is a direct edit component.
        pointEntityOne : The first construction point, sketch point or vertex the axis passes through
        pointEntityTwo : The second construction point, sketch point or vertex the axis passes through
        Returns true if the creation of the ConstructionAxisInput is successful.
        """
        return bool()
    def setByEdge(self, edgeEntity: core.Base) -> bool:
        """
        This input method is for creating a construction axis from a specified linear/circular edge
        or sketch curve.
        This can result in a parametric or non-parametric construction axis depending
        on whether the parent component is parametric or is a direct edit component.
        edgeEntity : A linear/circular edge, construction line, or sketch line
        Returns true if the creation of the ConstructionAxisInput is successful.
        """
        return bool()
    def setByNormalToFaceAtPoint(self, face: BRepFace, pointEntity: core.Base) -> bool:
        """
        This input method if for creating a construction axis normal to a specified face
        or sketch profile and that passes through a specified point.
        This can result in a parametric or non-parametric construction axis depending
        on whether the parent component is parametric or is a direct edit component.
        face : The face (BRepFace object) to create the axis normal to.
        pointEntity : A construction point, sketch point or vertex the axis passes through.
        This point does not have to lie on the face.
        Returns true if the creation of the ConstructionAxisInput is successful.
        """
        return bool()
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs
        to be specified when the ConstructionAxis is created based on geometry
        (e.g. a straight edge) in another component AND (the ConstructionAxis) is not in the
        root component. The CreationOccurrence is analogous to the active occurrence in the UI
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs
        to be specified when the ConstructionAxis is created based on geometry
        (e.g. a straight edge) in another component AND (the ConstructionAxis) is not in the
        root component. The CreationOccurrence is analogous to the active occurrence in the UI
        """
        pass
    @property
    def targetBaseOrFormFeature(self) -> core.Base:
        """
        When creating a construction axis that is owned by a base or form feature, set this property to the
        base or form feature you want to associate the new construction plane with. By default, this is null,
        meaning it will not be associated with a base or form feature.
        
        Because of a current limitation, if you want to create a construction axis associated with a base
        or form feature, you must set this property AND call the startEdit method of the base or form feature,
        create the feature, and then call the finishEdit method of the base or form feature. The base or form
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return core.Base()
    @targetBaseOrFormFeature.setter
    def targetBaseOrFormFeature(self, value: core.Base):
        """
        When creating a construction axis that is owned by a base or form feature, set this property to the
        base or form feature you want to associate the new construction plane with. By default, this is null,
        meaning it will not be associated with a base or form feature.
        
        Because of a current limitation, if you want to create a construction axis associated with a base
        or form feature, you must set this property AND call the startEdit method of the base or form feature,
        create the feature, and then call the finishEdit method of the base or form feature. The base or form
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class ConstructionPlane(core.Base):
    """
    ConstructionPlane Object
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionPlane:
        return ConstructionPlane()
    def deleteMe(self) -> bool:
        """
        Deletes the construction plane.
        Returns a bool indicating if the delete was successful or not.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> ConstructionPlane:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return ConstructionPlane()
    @property
    def geometry(self) -> core.Plane:
        """
        Returns a plane that represents the position and orientation of the construction plane.
        This geometry is defined in the AssemblyContext of this ConstructionPlane.
        """
        return core.Plane()
    @property
    def name(self) -> str:
        """
        Returns the name of the construction plane as it is shown in the browser.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Returns the name of the construction plane as it is shown in the browser.
        """
        pass
    @property
    def definition(self) -> ConstructionPlaneDefinition:
        """
        Returns the ConstructionPlaneDefinition object which provides access to the information
        defining this ConstructionPlane.
        """
        return ConstructionPlaneDefinition()
    @property
    def isDeletable(self) -> bool:
        """
        Indicates if this construction plane can be deleted. Base
        construction planes can not be deleted.
        """
        return bool()
    @property
    def isParametric(self) -> bool:
        """
        Indicates if this construction plane is parametric or not.
        """
        return bool()
    @property
    def isLightBulbOn(self) -> bool:
        """
        Indicates if the light bulb (as displayed in the browser) is on.
        A construction plane will only be visible if it's light bulb, and that of it's
        containing folder and parent component/s are also on.
        """
        return bool()
    @isLightBulbOn.setter
    def isLightBulbOn(self, value: bool):
        """
        Indicates if the light bulb (as displayed in the browser) is on.
        A construction plane will only be visible if it's light bulb, and that of it's
        containing folder and parent component/s are also on.
        """
        pass
    @property
    def isVisible(self) -> bool:
        """
        Indicates if the construction plane is visible.
        This property is affected by the AssemblyContext of the construction plane.
        """
        return bool()
    @property
    def displayBounds(self) -> core.BoundingBox2D:
        """
        Gets and sets the display size of the construction plane. The bounding
        box defines the min and max corners of the plane as defined in the
        2D space of the construction plane.
        """
        return core.BoundingBox2D()
    @displayBounds.setter
    def displayBounds(self, value: core.BoundingBox2D):
        """
        Gets and sets the display size of the construction plane. The bounding
        box defines the min and max corners of the plane as defined in the
        2D space of the construction plane.
        """
        pass
    @property
    def parent(self) -> core.Base:
        """
        Returns the parent component or base feature. If both the design and the construction
        plane are parametric, the parent will be a component. If the design is parametric and
        the construction plane is not, the parent will be a base feature. If
        the design is not parametric the parent will be a component.
        """
        return core.Base()
    @property
    def component(self) -> Component:
        """
        Returns the component this construction plane belongs to.
        """
        return Component()
    @property
    def timelineObject(self) -> TimelineObject:
        """
        Returns the timeline object associated with this construction plane.
        """
        return TimelineObject()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> ConstructionPlane:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return ConstructionPlane()
    @property
    def baseFeature(self) -> BaseFeature:
        """
        If this construction plane is associated with a base feature, this property will return that base feature.
        If it's not associated with a base feature, this property will return null.
        """
        return BaseFeature()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this construction plane.
        """
        return core.Attributes()
    @property
    def healthState(self) -> FeatureHealthStates:
        """
        Returns the current health state of this construction plane.
        """
        return FeatureHealthStates()
    @property
    def errorOrWarningMessage(self) -> str:
        """
        Returns the error or warning message in the case where the healthState property returns either
        WarningFeatureHealthState or ErrorFeatureHealthState. Otherwise this property returns an empty string.
        """
        return str()
    @property
    def transform(self) -> core.Matrix3D:
        """
        Returns the current position and orientation of the construction plane as a matrix.
        For a parametric construction plane, this property is read-only. For a construction
        plane in a direct modeling model or in a base feature, this is read-write and can be
        used to reposition the constructions plane.
        """
        return core.Matrix3D()
    @transform.setter
    def transform(self, value: core.Matrix3D):
        """
        Returns the current position and orientation of the construction plane as a matrix.
        For a parametric construction plane, this property is read-only. For a construction
        plane in a direct modeling model or in a base feature, this is read-write and can be
        used to reposition the constructions plane.
        """
        pass
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the ConstructionPlane object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same construction plane.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class ConstructionPlaneDefinition(core.Base):
    """
    A Base class to return the information, possibly parametric, used to define the ConstructionPlane.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionPlaneDefinition:
        return ConstructionPlaneDefinition()
    @property
    def parentConstructionPlane(self) -> ConstructionPlane:
        """
        Returns the ConstructionPlane object
        """
        return ConstructionPlane()

class ConstructionPlaneInput(core.Base):
    """
    A ConstructionPlaneInput is a throwaway object used to create a ConstructionPlane
    The usage pattern is:
    a. create a ConstructionPlaneInput (ConstructionPlanes.CreateInput)
    b. call one of the member functions to specify how the ConstructionPlane is created
    c. create the ConstructionPlane (call ConstructionPlanes.Add)
    d. stop referencing the ConstructionPlaneInput (so it gets deleted).
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionPlaneInput:
        return ConstructionPlaneInput()
    def setByPlane(self, plane: core.Plane) -> bool:
        """
        This input method is for creating a non-parametric construction plane positioned in
        space as defined by the input Plane object.
        
        This method of defining a construction plane is only valid when working in a direct edit model (do not capture design history).
        This is not valid when working in a parametric model and will fail.
        plane : A transient plane object
        Returns true if the construction plane definition is successful.
        """
        return bool()
    def setByOffset(self, planarEntity: core.Base, offset: core.ValueInput) -> bool:
        """
        This input method is for creating a construction plane that is offset from a planar
        face or construction plane at a specified distance. This can result in
        a parametric or non-parametric construction plane depending on whether the parent
        component is parametric or is a direct edit component.
        planarEntity : A plane, planar face or construction plane from which to create the offset plane
        offset : ValueInput object that specifies the offset distance for the plane
        Returns true if the construction plane definition is successful.
        """
        return bool()
    def setByAngle(self, linearEntity: core.Base, angle: core.ValueInput, planarEntity: core.Base) -> bool:
        """
        This input method is for creating a construction plane through an edge, axis or line
        at a specified angle. This can result in a parametric or non-parametric construction
        plane depending on whether the parent component is parametric or is a direct edit
        component.
        linearEntity : The axis about which to rotate the plane
        angle : The angle at which to create the plane
        planarEntity : The planar face or construction plane the angle is measured from.
        Returns true if the construction plane definition is successful.
        """
        return bool()
    def setByTangent(self, tangentFace: BRepFace, angle: core.ValueInput, planarEntity: core.Base) -> bool:
        """
        This input method is for creating a construction plane tangent to a cylindrical or
        conical face at a specified point. This can result in a parametric or non-parametric construction
        plane depending on whether the parent component is parametric or is a direct edit
        component.
        tangentFace : A cylindrical or conical face to create the plane tangent to
        angle : The angle relative to the planarEntity input at which to create the tangent plane
        planarEntity : The planar face or construction plane the tangent is measured from.
        Returns true if the construction plane definition is successful.
        """
        return bool()
    def setByTwoPlanes(self, planarEntityOne: core.Base, planarEntityTwo: core.Base) -> bool:
        """
        This input method is for creating a construction plane at the midpoint between
        two planar faces or construction planes. This can result in a parametric or
        non-parametric construction plane depending on whether the parent component is
        parametric or is a direct edit component.
        planarEntityOne : The first planar face or construction plane to create a bisecting plane between
        planarEntityTwo : The second planar face or construction plane to create a bisecting plane between
        Returns true if the construction plane definition is successful.
        This will fail if the two planes are co-planar.
        """
        return bool()
    def setByTwoEdges(self, linearEntityOne: core.Base, linearEntityTwo: core.Base) -> bool:
        """
        This input method is for creating a construction plane that passes through two
        coplanar linear entities or axes.
        Defines a plane by specifying two coplanar linear entities. This can result in a
        parametric or non-parametric construction plane depending on whether the parent
        component is parametric or is a direct edit component.
        linearEntityOne : The first of two coplanar linear entities to define the plane
        linearEntityTwo : The second of two coplanar linear entities to define the plane
        Returns true if the construction plane definition is successful.
        This will fail if the two linear entities are not coplanar.
        """
        return bool()
    def setByThreePoints(self, pointEntityOne: core.Base, pointEntityTwo: core.Base, pointEntityThree: core.Base) -> bool:
        """
        This input method is for creating a construction plane through three points that
        define a triangle. This can result in a parametric or non-parametric construction
        plane depending on whether the parent component is parametric or is a direct edit
        component.
        pointEntityOne : The first construction point, sketch point or vertex in the triangle
        pointEntityTwo : The second construction point, sketch point or vertex in the triangle
        pointEntityThree : The third construction point, sketch point or vertex in the triangle
        Returns true if the construction plane definition is successful.
        This will fail if the points do not form a triangle (no two
        points can be coincident and all three cannot be collinear).
        """
        return bool()
    def setByTangentAtPoint(self, tangentFace: BRepFace, pointEntity: core.Base) -> bool:
        """
        This input method is for creating a construction plane tangent to a face
        and aligned to a point. This can result in a parametric or non-parametric
        construction plane depending on whether the parent component is parametric or is a
        direct edit component.
        tangentFace : A face to create the plane tangent to
        pointEntity : A construction point, sketch point or vertex the tangent plane aligns to.
        This point need not lie on the tangent face.
        Returns true if the construction plane definition is successful.
        """
        return bool()
    def setByDistanceOnPath(self, pathEntity: core.Base, distance: core.ValueInput) -> bool:
        """
        This input method is for creating a construction plane normal to, and at
        specified distance along, a path defined by an edge or sketch profile.
        This can result in a parametric or non-parametric
        construction plane depending on whether the parent component is parametric or is a
        direct edit component.
        pathEntity : The path can be an edge, sketch curve, or a path of multiple entities.
        distance : The distance is a value from 0 to 1 indicating the position along the path where 0
        is at the start and 1 is at the end.
        Returns true if the construction plane definition is successful.
        """
        return bool()
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the ConstructionPlane is created based on geometry (e.g. a planarEntity)
        in another component AND (the ConstructionPlane) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the ConstructionPlane is created based on geometry (e.g. a planarEntity)
        in another component AND (the ConstructionPlane) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        pass
    @property
    def targetBaseOrFormFeature(self) -> core.Base:
        """
        When creating a construction plane that is owned by a base or form feature, set this property to the
        base or form feature you want to associate the new construction plane with. By default, this is null,
        meaning it will not be associated with a base or form feature.
        
        Because of a current limitation, if you want to create a construction plane associated with a base
        or form feature, you must set this property AND call the startEdit method of the base or form feature,
        create the feature, and then call the finishEdit method of the base or form feature. The base or form
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return core.Base()
    @targetBaseOrFormFeature.setter
    def targetBaseOrFormFeature(self, value: core.Base):
        """
        When creating a construction plane that is owned by a base or form feature, set this property to the
        base or form feature you want to associate the new construction plane with. By default, this is null,
        meaning it will not be associated with a base or form feature.
        
        Because of a current limitation, if you want to create a construction plane associated with a base
        or form feature, you must set this property AND call the startEdit method of the base or form feature,
        create the feature, and then call the finishEdit method of the base or form feature. The base or form
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class ConstructionPlanes(core.Base):
    """
    Provides access to the construction planes within a component and provides
    methods to create new construction planes.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionPlanes:
        return ConstructionPlanes()
    def item(self, index: int) -> ConstructionPlane:
        """
        Function that returns the specified construction plane using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ConstructionPlane()
    def itemByName(self, name: str) -> ConstructionPlane:
        """
        Returns the specified construction plane using the name of the construction
        plane as it is displayed in the browser.
        name : The name of the construction plane as it is displayed in the browser
        Returns the specified item or null if an invalid name was specified.
        """
        return ConstructionPlane()
    def createInput(self, occurrenceForCreation: Occurrence) -> ConstructionPlaneInput:
        """
        Create a ConstructionPlaneInput object that is in turn used to create a ConstructionPlane.
        occurrenceForCreation : A creation occurrence is needed if the input is in another component AND the
        construction plane is not in the root component. The occurrenceForCreation is analogous
        to the active occurrence in the UI.
        Returns a ConstructionPlaneInput object
        """
        return ConstructionPlaneInput()
    def add(self, input: ConstructionPlaneInput) -> ConstructionPlane:
        """
        Creates and adds a new ConstructionPlane using the creation parameters in
        the ConstructionPlaneInput.
        
        If the ConstructionPlaneInput was defined using the setByPlane method then
        the add will only work in a direct edit model (do not capture design history) and will fail in a parametric model.
        input : A ConstructionPlaneInput object
        Returns the newly created construction plane or null if the creation failed.
        """
        return ConstructionPlane()
    @property
    def count(self) -> int:
        """
        Returns the number of construction planes in the collection.
        """
        return int()
    @property
    def component(self) -> Component:
        """
        Returns the component that owns this collection.
        """
        return Component()

class ConstructionPoint(core.Base):
    """
    ConstructionPoint Object
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionPoint:
        return ConstructionPoint()
    def deleteMe(self) -> bool:
        """
        Deletes the construction point.
        Returns a bool indicating if the delete was successful or not.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> ConstructionPoint:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return ConstructionPoint()
    @property
    def geometry(self) -> core.Point3D:
        """
        Returns a Point3D object that represents the position of the construction point.
        The returned geometry is in the AssemblyContext of this ConstructionPoint.
        """
        return core.Point3D()
    @property
    def name(self) -> str:
        """
        The name of the construction point as it is displayed in the browser.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        The name of the construction point as it is displayed in the browser.
        """
        pass
    @property
    def definition(self) -> ConstructionPointDefinition:
        """
        Returns the construction point definition object which provides access to the
        information defining the construction point.
        """
        return ConstructionPointDefinition()
    @property
    def isDeletable(self) -> bool:
        """
        Indicates if this construction point can be deleted. The base
        construction point cannot be deleted.
        """
        return bool()
    @property
    def isLightBulbOn(self) -> bool:
        """
        Indicates if the light bulb (as displayed in the browser) is on.
        A construction point will only be visible if it's light bulb, and that of it's
        containing folder and parent component/s are also on.
        """
        return bool()
    @isLightBulbOn.setter
    def isLightBulbOn(self, value: bool):
        """
        Indicates if the light bulb (as displayed in the browser) is on.
        A construction point will only be visible if it's light bulb, and that of it's
        containing folder and parent component/s are also on.
        """
        pass
    @property
    def isVisible(self) -> bool:
        """
        Gets if the construction point is visible.
        This property is affected by the AssemblyContext of the construction point.
        """
        return bool()
    @property
    def parent(self) -> core.Base:
        """
        Returns the parent component or base feature. If both the design and the construction
        point are parametric, the parent will be a component. If the design is parametric and
        the construction point is not, the parent will be a base feature. If
        the design is not parametric the parent will be a component.
        """
        return core.Base()
    @property
    def component(self) -> Component:
        """
        Returns the component this construction point belongs to.
        """
        return Component()
    @property
    def isParametric(self) -> bool:
        """
        Indicates if the construction point is parametric.
        """
        return bool()
    @property
    def timelineObject(self) -> TimelineObject:
        """
        Returns the timeline object associated with this construction point.
        """
        return TimelineObject()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> ConstructionPoint:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return ConstructionPoint()
    @property
    def baseFeature(self) -> BaseFeature:
        """
        If this construction point is associated with a base feature, this property will return that base feature.
        If it's not associated with a base feature, this property will return null.
        """
        return BaseFeature()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this construction point.
        """
        return core.Attributes()
    @property
    def healthState(self) -> FeatureHealthStates:
        """
        Returns the current health state of this construction point.
        """
        return FeatureHealthStates()
    @property
    def errorOrWarningMessage(self) -> str:
        """
        Returns the error or warning message in the case where the healthState property returns either
        WarningFeatureHealthState or ErrorFeatureHealthState. Otherwise this property returns an empty string.
        """
        return str()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the ConstructionPoint object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same construction point.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class ConstructionPointDefinition(core.Base):
    """
    A Base class to return the information (possibly parametric) used to
    define a ConstructionPoint.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionPointDefinition:
        return ConstructionPointDefinition()
    @property
    def parentConstructionPoint(self) -> ConstructionPoint:
        """
        Returns the ConstructionPoint object
        """
        return ConstructionPoint()

class ConstructionPointInput(core.Base):
    """
    A ConstructionPointInput is a throwaway object used to create a ConstructionPoint
    The usage pattern is
    a. create a ConstructionPointInput (ConstructionPoints.CreateInput)
    b. call one of the member functions to specify how the ConstructionPoint is created
    c. create the ConstructionPoint (call ConstructionPoints.Add)
    d. stop referencing the ConstructionPointInput (so it gets deleted).
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionPointInput:
        return ConstructionPointInput()
    def setByTwoEdges(self, edgeOne: core.Base, edgeTwo: core.Base) -> bool:
        """
        This input method is for creating a construction point at the intersection of
        the two linear edges or sketch lines.
        The edges can be B-Rep edges or sketch lines.
        This can result in a parametric or non-parametric construction point depending
        on whether the parent component is parametric or is a direct edit component.
        edgeOne : The first B-Rep edge or sketch line
        edgeTwo : The second B-Rep edge or sketch line
        Returns true if the creation of the ConstructionPointInput is successful.
        """
        return bool()
    def setByThreePlanes(self, planeOne: core.Base, planeTwo: core.Base, planeThree: core.Base) -> bool:
        """
        This input method is for creating a construction point at the intersection of the
        three planes or planar faces.
        This can result in a parametric or non-parametric construction point depending
        on whether the parent component is parametric or is a direct edit component.
        planeOne : The first plane or planar face to intersect
        planeTwo : The second plane or planar face to intersect
        planeThree : The third plane or planar face to intersect
        Returns true if the creation of the ConstructionPointInput is successful.
        """
        return bool()
    def setByEdgePlane(self, edge: core.Base, plane: core.Base) -> bool:
        """
        This input method is for creating a construction point at the intersection of a
        construction plane, planar face or sketch profile and a linear edge, construction axis
        or sketch line.
        This can result in a parametric or non-parametric construction point depending
        on whether the parent component is parametric or is a direct edit component.
        edge : A linear B-Rep edge, construction axis or sketch line.
        plane : A plane, planar B-Rep face or construction plane.
        Returns true if the creation of the ConstructionPointInput is successful.
        """
        return bool()
    def setByCenter(self, circularEntity: core.Base) -> bool:
        """
        This input method is for creating a construction point at the center of a spherical
        face (sphere or torus), circular edge or sketch arc/circle
        This can result in a parametric or non-parametric construction point depending
        on whether the parent component is parametric or is a direct edit component.
        circularEntity : A spherical face (sphere or torus), circular edge or sketch arc/circle
        Returns true if the creation of the ConstructionPointInput is successful.
        """
        return bool()
    def setByPoint(self, point: core.Base) -> bool:
        """
        This input method is for creating a construction point on the specified point
        or vertex. The point can be either a B-Rep vertex, SketchPoint, or a Point3D object.
        
        Providing a Point3D object is only valid when working in a direct edit model (do not capture design history).
        This is not valid when working in a parametric model and will fail.
        
        Even when providing a B-Rep vertex, or SketchPoint the result will be non-parametric
        if the parent component is a direct edit component.
        point : A B-Rep vertex, SketchPoint, or Point object
        Returns true if the creation of the ConstructionPointInput is successful.
        """
        return bool()
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an occurrence for creation needs
        to be specified when the ConstructionPoint is created based on geometry
        (e.g. a sketch point) in another component AND (the ConstructionPoint) is not in the
        root component. The CreationOccurrence is analogous to the active occurrence in the UI
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an occurrence for creation needs
        to be specified when the ConstructionPoint is created based on geometry
        (e.g. a sketch point) in another component AND (the ConstructionPoint) is not in the
        root component. The CreationOccurrence is analogous to the active occurrence in the UI
        """
        pass
    @property
    def targetBaseOrFormFeature(self) -> core.Base:
        """
        When creating a construction point that is owned by a base or form feature, set this property to the
        base or form feature you want to associate the new construction point with. By default, this is null,
        meaning it will not be associated with a base or form feature.
        
        Because of a current limitation, if you want to create a construction point associated with a base
        or form feature, you must set this property AND call the startEdit method of the base or form feature,
        create the feature, and then call the finishEdit method of the base or form feature. The base or form
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return core.Base()
    @targetBaseOrFormFeature.setter
    def targetBaseOrFormFeature(self, value: core.Base):
        """
        When creating a construction point that is owned by a base or form feature, set this property to the
        base or form feature you want to associate the new construction point with. By default, this is null,
        meaning it will not be associated with a base or form feature.
        
        Because of a current limitation, if you want to create a construction point associated with a base
        or form feature, you must set this property AND call the startEdit method of the base or form feature,
        create the feature, and then call the finishEdit method of the base or form feature. The base or form
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class ConstructionPoints(core.Base):
    """
    Provides access to the construction points within a component and provides
    methods to create new construction points.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ConstructionPoints:
        return ConstructionPoints()
    def item(self, index: int) -> ConstructionPoint:
        """
        Function that returns the specified construction point using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ConstructionPoint()
    def itemByName(self, name: str) -> ConstructionPoint:
        """
        Returns the specified construction point using the name of the construction
        point as it is displayed in the browser.
        name : The name of the construction point as it is displayed in the browser.
        Returns the specified item or null if an invalid name was specified.
        """
        return ConstructionPoint()
    def createInput(self, occurrenceForCreation: Occurrence) -> ConstructionPointInput:
        """
        Create a ConstructionPointInput object that is in turn used
        to create a ConstructionPoint.
        occurrenceForCreation : A creation occurrence is needed if the input is in another component AND the
        construction point is not in the root component. The occurrenceForCreation is analogous
        to the active occurrence in the UI.
        Returns a ConstructionPointInput object
        """
        return ConstructionPointInput()
    def add(self, input: ConstructionPointInput) -> ConstructionPoint:
        """
        Creates a new construction point.
        
        If the ConstructionPointInput was defined using the setByPoint method using a Point3D object then
        the add will only work in a direct edit model (do not capture design history) and will fail in a parametric model.
        input : A ConstructionPointInput object
        Returns the newly created construction point or null if the creation failed.
        """
        return ConstructionPoint()
    @property
    def count(self) -> int:
        """
        The number of construction points in the collection.
        """
        return int()
    @property
    def component(self) -> Component:
        """
        The component that owns this collection.
        """
        return Component()

class ContactSet(core.Base):
    """
    Represents a contact set in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ContactSet:
        return ContactSet()
    def deleteMe(self) -> bool:
        """
        Deletes this contact set from the design.
        Returns true if the delete was successful.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of the contact set.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of the contact set.
        """
        pass
    @property
    def occurencesAndBodies(self) -> list[core.Base]:
        """
        Gets and sets the group of Occurrence and/or BRepBody objects that are part of this contact set.
        """
        return [core.Base()]
    @occurencesAndBodies.setter
    def occurencesAndBodies(self, value: list[core.Base]):
        """
        Gets and sets the group of Occurrence and/or BRepBody objects that are part of this contact set.
        """
        pass
    @property
    def isSuppressed(self) -> bool:
        """
        Gets and sets if this contact set is currently suppressed.
        """
        return bool()
    @isSuppressed.setter
    def isSuppressed(self, value: bool):
        """
        Gets and sets if this contact set is currently suppressed.
        """
        pass

class ContactSets(core.Base):
    """
    Provides access to the existing contact sets in a design and supports creating new contact sets.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ContactSets:
        return ContactSets()
    def item(self, index: int) -> ContactSet:
        """
        Returns the specified contact set using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ContactSet()
    def itemByName(self, name: str) -> ContactSet:
        """
        Returns the specified contact set.
        name : The name of the contact set to  return.
        Returns the specified contact set or null there isn't a contact set with that name.
        """
        return ContactSet()
    def add(self, occurrencesAndBodies: list[core.Base]) -> ContactSet:
        """
        Creates a new contact set for the provided occurrences and/or bodies.
        occurrencesAndBodies : An array of Occurrence or BRepBody objects that will be included in the contact set.
        All occurrences and bodies must be in the context of the root component.
        Returns the newly created ContactSet or null in the case of failure.
        """
        return ContactSet()
    @property
    def count(self) -> int:
        """
        Returns the number of contacts sets in the design.
        """
        return int()

class CopyPasteBodies(core.Base):
    """
    Collection that provides access to all of the existing copy-paste features in a design.
    These are created in the UI by copying and then pasting a B-Rep body.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CopyPasteBodies:
        return CopyPasteBodies()
    def item(self, index: int) -> CopyPasteBody:
        """
        Function that returns the specified Copy/Paste Body feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CopyPasteBody()
    def itemByName(self, name: str) -> CopyPasteBody:
        """
        Function that returns the specified Copy/Paste Body feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return CopyPasteBody()
    def add(self, sourceBody: core.Base) -> CopyPasteBody:
        """
        Copies the specified body into the component that owns this CopyPasteBodies collection.
        sourceBody : Either an ObjectCollection of BRepBodies or a single BRepBody object to copy.
        Returns the newly created BRepBody object or null in the case of failure.
        """
        return CopyPasteBody()
    @property
    def count(self) -> int:
        """
        The number of Copy/Paste Body features in the collection.
        """
        return int()

class CustomFeatureDefinition(core.Base):
    """
    The CustomFeatureDefinition object defines a specific type of custom feature. It contains
    the settings that apply to all custom features of that type and is used when creating new
    custom features of that type. It also supports the events used to handle changes to custom
    features of that type.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomFeatureDefinition:
        return CustomFeatureDefinition()
    @staticmethod
    def create(id: str, defaultName: str, iconFolder: str) -> CustomFeatureDefinition:
        """
        A static function that creates a new CustomFeatureDefinition object. The creation of a
        CustomFeatureDefinition object is required to be able to create new custom features and
        for existing custom features to behave correctly. The CustomFeatureDefinition object defines
        all of the information that is common for all custom features of a particular type. For example,
        it defines the icon and the default name. The CustomFeatureDefinition object also supports the
        events that used to react to an existing feature being edited or re-computed.
        
        The custom feature definition should be created when your add-in is initially loaded to notify
        Fusion that the add-in that supports that custom feature type is available.
        id : The unique ID for custom features of a particular type. Care must be taken to ensure that this
        is unique and you must be consistent in its use once you've chosen an ID. A good practice to
        help ensure unique naming is to use the name of your company in combination with the name of
        the feature, such as "CompanyName.FeatureName". For example, "WoodTools4U.Dovetail".
        defaultName : The default name of the feature. Fusion will use this name and append a number to each feature
        instance as it's created. For example, if this is "Dovetail" the first custom feature created
        will be named "Dovetail1" and the second will be "Dovetail2".
        
        If you want to localize this name you can use the Application.Preferences.generalPreferences.userLanguage
        property to determine what language the user has chosen and use the corresponding name for that language.
        iconFolder : The folder that contains the image files that will be used for the icon for this feature in
        the timeline. This can be a full path or a relative path where it will be relative to the add-in
        file. The folder should contain the image files named 16x16.png and 32x32.png which should be
        images that are 16 and 32 pixels square.
        Returns the newly created CustomFeatureDefinition or null in the case of failure.
        """
        return CustomFeatureDefinition()
    @property
    def id(self) -> str:
        """
        Gets the unique ID used for this type of custom feature.
        """
        return str()
    @property
    def iconFolder(self) -> str:
        """
        Gets and sets the folder that contains the images that are used for the icon in the timeline for
        this custom feature. The folder should contain the image files named 16x16.png and 32x32.png
        which should be images that are 16 and 32 pixels square.
        """
        return str()
    @iconFolder.setter
    def iconFolder(self, value: str):
        """
        Gets and sets the folder that contains the images that are used for the icon in the timeline for
        this custom feature. The folder should contain the image files named 16x16.png and 32x32.png
        which should be images that are 16 and 32 pixels square.
        """
        pass
    @property
    def defaultName(self) -> str:
        """
        Gets and sets the default name of the feature. Fusion will use this name and append a number
        to each feature instance as it's created. For example, if this is "Dovetail" the first
        custom feature created will be named "Dovetail1" and the second will be "Dovetail2".
        
        If you want to localize this name you can use the Application.Preferences.generalPreferences.userLanguage
        property to determine what language the user has chosen and use the corresponding name for that language.
        """
        return str()
    @defaultName.setter
    def defaultName(self, value: str):
        """
        Gets and sets the default name of the feature. Fusion will use this name and append a number
        to each feature instance as it's created. For example, if this is "Dovetail" the first
        custom feature created will be named "Dovetail1" and the second will be "Dovetail2".
        
        If you want to localize this name you can use the Application.Preferences.generalPreferences.userLanguage
        property to determine what language the user has chosen and use the corresponding name for that language.
        """
        pass
    @property
    def editCommandId(self) -> str:
        """
        Gets and sets which command will be invoked when the feature is edited. This is the id of the
        CommandDefinition object that you have created to do the edit of the feature.
        """
        return str()
    @editCommandId.setter
    def editCommandId(self, value: str):
        """
        Gets and sets which command will be invoked when the feature is edited. This is the id of the
        CommandDefinition object that you have created to do the edit of the feature.
        """
        pass
    @property
    def customFeatureCompute(self) -> CustomFeatureEvent:
        """
        The customFeatureCompute event fires when Fusion is computing the timeline and reaches
        the custom feature. The event is fired if any of the dependencies of the custom feature
        have changed. You can modify the results of your custom feature based on the dependencies.
        """
        return CustomFeatureEvent()

class CustomFeatureDependencies(core.Base):
    """
    A collection of dependencies associated with a particular custom feature. These
    are the entities that the custom feature is dependent on. If these entities are
    modified, it will cause the custom feature to recompute so it can be up to date.
    These dependencies are saved with the custom feature and can be accessed at a
    later time, typically during the compute, to access and use the entities.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomFeatureDependencies:
        return CustomFeatureDependencies()
    def item(self, index: int) -> CustomFeatureDependency:
        """
        Function that returns the specified custom dependency using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CustomFeatureDependency()
    def itemById(self, id: str) -> CustomFeatureDependency:
        """
        Function that returns the specified custom dependency given its ID.
        id : The ID of the dependency, which was assigned when the dependency was defined.
        Returns the specified item or null if the specified ID was not found.
        """
        return CustomFeatureDependency()
    def add(self, id: str, entity: core.Base) -> CustomFeatureDependency:
        """
        Adds an entity or parameter that this feature is dependent on. This is used by Fusion to know
        when to recompute this feature and to control the behavior of the feature's node in the timeline.
        id : An ID for this dependency. This is used to allow you to identify which dependency is which in the future.
        The ID must be unique with respect to the other dependencies of this custom feature.
        entity : The entity or parameter you want to add as a dependency. This can be a BRepBody, BRepFace, BrepEdge,
        BRepVertex, a sketch, any sketch entities, a profile, any construction geometry, or any parameter.
        Returns the created CustomFeatureDependency object and asserts if it failed.
        """
        return CustomFeatureDependency()
    def deleteAll(self) -> bool:
        """
        Deletes all of the current dependencies. This method is for convenience and
        is equivalent to iterating through the collection and deleting them one at a time.
        Returns true if the operation was successful.
        """
        return bool()
    @property
    def count(self) -> int:
        """
        The number of CustomFeatureParameter objects in the collection.
        """
        return int()

class CustomFeatureDependency(core.Base):
    """
    A custom feature dependency defines a dependency the custom feature has on an entity
    outside the custom feature. For example, a feature might be dependent on a face or a
    point and if those entities are modified the custom feature needs to recompute to be
    up to date.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomFeatureDependency:
        return CustomFeatureDependency()
    def deleteMe(self) -> bool:
        """
        Deletes this dependency from the custom feature.
        Returns true if the delete was successful.
        """
        return bool()
    @property
    def id(self) -> str:
        """
        Returns the ID of this custom feature dependency.
        """
        return str()
    @property
    def entity(self) -> core.Base:
        """
        Gets and sets the entity associated with this dependency.
        """
        return core.Base()
    @entity.setter
    def entity(self, value: core.Base):
        """
        Gets and sets the entity associated with this dependency.
        """
        pass
    @property
    def parentCustomFeature(self) -> CustomFeature:
        """
        Returns the custom feature this dependency is associated with.
        """
        return CustomFeature()

class CustomFeatureEventHandler(core.EventHandler):
    """
    The CustomFeatureEventHandler is a client implemented class that can be added as
    a handler to a CustomFeatureEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomFeatureEventHandler:
        return CustomFeatureEventHandler()
    def notify(self, eventArgs: CustomFeatureEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class CustomFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a Ruled Surface feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomFeatureInput:
        return CustomFeatureInput()
    def addDependency(self, id: str, entity: core.Base) -> bool:
        """
        Adds an entity or parameter this feature is dependent on. This is used by Fusion to know
        when to recompute this feature and to control the behavior of the feature's node in the timeline.
        id : An ID for this dependency. This is used to allow you to identify which dependency is which in the future.
        The ID must be unique with respect to the other dependencies of this custom feature.
        entity : The entity or parameter you want to add as a dependency. This can be a BRepBody, BRepFace, BrepEdge,
        BRepVertex, a sketch, any sketch entities, a profile, any construction geometry, or any parameter.
        Returns true if the dependency was successfully added.
        """
        return bool()
    def addCustomParameter(self, id: str, label: str, value: core.ValueInput, units: str, isVisible: bool) -> bool:
        """
        Defines the information needed to create a new custom parameter that will be associated with
        this feature. A custom parameter appears as a model parameter and will be listed as a child of the
        custom feature in the parameter dialog. The custom feature will automatically have a dependency
        on this parameter.
        id : An id for this parameter. This is used to allow you to identify the parameter in the future. This
        must be unique with respect to all other parameters associated with this custom feature. It's needed
        because the label does not need to be unique and the Fusion auto-generated name can be edited by
        the user.
        label : The label for this parameter as seen in the parameters dialog. This identifies to the user the purpose
        of this parameter. For example, when you create an extrusion with a specific distance, there are two
        parameters displayed in the parameters dialog with the labels "AlongDistance" and "TaperAngle". This does
        not have to be unique because in the case of a fillet feature there can be multiple parameters all labeled "Radius".
        value : ValueInput object that specifies the value of the parameter. If the ValueInput was created using a real,
        the value will be interpreted using the internal unit for the unit type specified by the "units" argument.
        For example, if the ValueInput was created using the real value 5 and the input to the "units" argument is
        any valid length unit, the value will be interpreted as 5 centimeters since centimeters is the internal unit
        for lengths. If the "units" argument is a valid angle unit the value will be interpreted as 5 radians.
        
        If the ValueInput was created using a string, the string is used as-is for the expression of the parameter.
        This means if there are units as part of the string it must evaluate to the same unit type as that specified
        by the "units" argument and if no units are specified it will use the current default units specified for
        the current document. For example, if the ValueInput was created with the string "5 in", then the "units"
        argument must define any valid length so it is compatible. If the ValueInput was created with the string "5",
        any unit type can be used and the result will be 5 of that unit.
        
        When using a ValueInput created using a string, it's the same as creating a parameter in the user-interface.
        You can specify any valid expression, i.e. "5", "5 in", "5 in / 2", "5 + Length", etc. and you can choose
        from many different types of units. The only requirement is that the units must match in type. For example,
        they must both be lengths, or they must both be angles.
        units : The units to use for the value of the parameter. Units specified must match the units specified (if any)
        in the ValueInput object.
        
        To create a parameter with no units (unitless) you can specify either an empty string.
        isVisible : Optional argument that specifies if the parameter will be visible in the parameters dialog or not. By
        default the parameter will be visible.
        
        This can be useful in cases where the feature can be edited to be in different states where a parameter
        is only valid in a certain state. You can change the visibility based on the current state of the feature
        and if that parameter should be available for edit. This implies that you create all the parameters that
        might be needed and then change their visibility based on the current state of the feature. The parameters
        that are not visible will not be returned by the ModelParameters collection and are only available through
        the custom feature they're associated with.
        Returns true if the definition of the model parameter was successfully added.
        """
        return bool()
    def setStartAndEndFeatures(self, startFeature: core.Base, endFeature: core.Base) -> bool:
        """
        Sets the start and end features that the custom feature will group. A "feature" in this
        case is an object that is visible in the timeline, such as modeling features, sketches,
        and construction geometry. The custom feature will group the input start and end features
        and all features between them in the timeline.
        
        You can determine the current start and end features using the features property and use
        the first and last features returned. If the custom feature contains a single feature,
        you can use the same feature for both the start and end feature arguments. You can also
        use null for both arguments to remove all features from a custom feature. The custom feature
        still exists but will be empty, and the features will be displayed individually within the timeline.
        startFeature : The first feature in the timeline that the custom feature will group.
        endFeature : The last feature in the timeline that the custom feature will group. When creating a custom feature
        that contains a single feature, this can be the same feature as the startFeature argument.
        Returns true if setting the start and end features was successful.
        """
        return bool()
    @property
    def features(self) -> list[core.Base]:
        """
        Returns the features that are grouped by this custom feature. The start and end features and all of
        the features between them in the timeline are returned. This includes all entities represented in
        the timeline including modeling features, construction geometry, sketches, etc.
        """
        return [core.Base()]

class CustomFeatureParameters(core.Base):
    """
    A collection of custom parameters associated with a particular custom feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomFeatureParameters:
        return CustomFeatureParameters()
    def item(self, index: int) -> CustomFeatureParameter:
        """
        Function that returns the specified custom parameter feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CustomFeatureParameter()
    def itemById(self, id: str) -> CustomFeatureParameter:
        """
        Function that returns the specified CustomParameter object given its ID.
        id : The ID of the custom parameter, which was assigned when the parameter was defined and the custom feature was created.
        Returns the specified item or null if the specified ID was not found.
        """
        return CustomFeatureParameter()
    @property
    def count(self) -> int:
        """
        The number of CustomFeatureParameter objects in the collection.
        """
        return int()

class CustomFeatures(core.Base):
    """
    Collection that provides access to all of the existing custom features in a component
    and supports the ability to create new custom features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomFeatures:
        return CustomFeatures()
    def item(self, index: int) -> CustomFeature:
        """
        Function that returns the specified ruled surface feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CustomFeature()
    def itemByName(self, name: str) -> CustomFeature:
        """
        Function that returns the specified CustomFeature feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return CustomFeature()
    def createInput(self, definition: CustomFeatureDefinition) -> CustomFeatureInput:
        """
        Creates a new input object that you use to define a custom feature. Creating an input object doesn't
        create the feature but provides a way to gather all of the input needed to create a custom feature.
        To create the custom feature, the fully defined input object is passed to the add method.
        definition : The CustomFeatureDefinition for the type of custom feature being created.
        Returns the newly created CustomFeatureInput object or null in the case of invalid input.
        """
        return CustomFeatureInput()
    def add(self, input: CustomFeatureInput) -> CustomFeature:
        """
        Creates a new custom feature.
        input : The CustomFeatureInput object that defines the information needed to create a custom feature.
        Returns the newly created CustomFeature.
        """
        return CustomFeature()
    @property
    def count(self) -> int:
        """
        The number of CustomFeature objects in the collection.
        """
        return int()

class CustomGraphicsBillBoard(core.Base):
    """
    Used to specify if the orientation of custom graphics are defined relative to the screen instead of model space.
    This is commonly used for legends and symbols that you want to always face the user, even as the
    camera is rotated.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomGraphicsBillBoard:
        return CustomGraphicsBillBoard()
    @staticmethod
    def create(anchorPoint: core.Point3D) -> CustomGraphicsBillBoard:
        """
        Creates a new CustomGraphicsBillBoard object that can be used when calling the billBoarding property
        of the CustomGraphicsEntity object to specify the billboarding behavior of some custom graphics. Once
        created you can assign it to a custom graphics entity using its billBoarding property.
        anchorPoint : Specifies the coordinate that the graphics will anchor to. The anchor point is the point where the
        custom graphics are anchored in world space. As the user manipulates the camera and rotates around
        the model, making it appear that world space is rotating, the graphics remain facing the camera and
        the anchor point defines the common location between world space and the graphics.
        
        For graphics where the If the isViewDependent property of the graphics entity is true, then the
        anchor point is defined in pixels relative to the upper-left corner of the view and the z component
        of the input point is ignored.
        Returns the newly created CustomGraphicsBillBoard object or null in the case of failure. This can be assigned
        to a custom graphics entity using its billBoarding property.
        """
        return CustomGraphicsBillBoard()
    @property
    def anchorPoint(self) -> core.Point3D:
        """
        Specifies the coordinate in model or view space that the graphics will anchor to. For graphics that
        represent a label, this will typically be the point where the label attaches to the model. A
        CustomGraphicsAnchorPoint can be created using the static create method on the CustomGraphicsAnchorPoint
        object.
        """
        return core.Point3D()
    @anchorPoint.setter
    def anchorPoint(self, value: core.Point3D):
        """
        Specifies the coordinate in model or view space that the graphics will anchor to. For graphics that
        represent a label, this will typically be the point where the label attaches to the model. A
        CustomGraphicsAnchorPoint can be created using the static create method on the CustomGraphicsAnchorPoint
        object.
        """
        pass
    @property
    def billBoardStyle(self) -> CustomGraphicsBillBoardStyles:
        """
        Specifies the type of billboarding to use. When a new CustomGraphicsBillBoard object is created
        this defaults to ScreenBillBoardStyle so the graphics will all be facing the view plane. It can also
        be set to an arbitrary plane by setting this to AxialBillBoardStyle and can be defined so that it never
        appear backwards by setting it to RightReadingBillBoardStyle.
        """
        return CustomGraphicsBillBoardStyles()
    @billBoardStyle.setter
    def billBoardStyle(self, value: CustomGraphicsBillBoardStyles):
        """
        Specifies the type of billboarding to use. When a new CustomGraphicsBillBoard object is created
        this defaults to ScreenBillBoardStyle so the graphics will all be facing the view plane. It can also
        be set to an arbitrary plane by setting this to AxialBillBoardStyle and can be defined so that it never
        appear backwards by setting it to RightReadingBillBoardStyle.
        """
        pass
    @property
    def axis(self) -> core.Vector3D:
        """
        When the billBoardStyle property is set to AxialBillBoardStyle, this is used to control the direction
        of the graphics. Otherwise it uses the x axis of the view.
        """
        return core.Vector3D()
    @axis.setter
    def axis(self, value: core.Vector3D):
        """
        When the billBoardStyle property is set to AxialBillBoardStyle, this is used to control the direction
        of the graphics. Otherwise it uses the x axis of the view.
        """
        pass

class CustomGraphicsBRepEdges(core.Base):
    """
    A collection of CustomGraphicsBRepEdge objects associated with a specific CustomGraphics body object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomGraphicsBRepEdges:
        return CustomGraphicsBRepEdges()

class CustomGraphicsBRepFaces(core.Base):
    """
    A collection of CustomGraphicsBRepFace objects associated with a specific CustomGraphicsBRepBody object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomGraphicsBRepFaces:
        return CustomGraphicsBRepFaces()

class CustomGraphicsBRepVertices(core.Base):
    """
    A collection of CustomGraphicsBRepVertex objects associated with a specific CustomGraphics body object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomGraphicsBRepVertices:
        return CustomGraphicsBRepVertices()

class CustomGraphicsColorEffect(core.Base):
    """
    The base class for all custom graphics color effects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomGraphicsColorEffect:
        return CustomGraphicsColorEffect()

class CustomGraphicsCoordinates(core.Base):
    """
    Represents coordinates that are used to define vertices in custom graphics.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomGraphicsCoordinates:
        return CustomGraphicsCoordinates()
    @staticmethod
    def create(coordinates: list[float]) -> CustomGraphicsCoordinates:
        """
        Static method that creates a CustomGraphicsCoordinates object which can be used as input to
        various custom graphics methods.
        coordinates : An array of doubles where the values are the x, y, z components of each coordinate where
        the unit of measure is centimeters.
        Returns the created CustomGraphicsCoordinates object or null in the case of failure.
        """
        return CustomGraphicsCoordinates()
    def getCoordinate(self, index: int) -> core.Point3D:
        """
        Gets the coordinate at the specified index.
        index : The index of the coordinate to return. The first coordinate has an index of 0.
        Returns the coordinate as a Point3D object.
        """
        return core.Point3D()
    def setCoordinate(self, index: int, coordinate: core.Point3D) -> bool:
        """
        Sets the coordinate at the specified index.
        index : The index of the coordinate to set. The first coordinate has an index of 0.
        coordinate : The coordinate value as a Point3D object.
        Returns true if setting the coordinate was successful.
        """
        return bool()
    def getColor(self, index: int) -> core.Color:
        """
        Gets the color assigned to the coordinate at the specified index.
        index : The index of the color to return. The first color has an index of 0.
        Returns the color associated with the index. Can also return null in the case
        where there is no color assigned.
        """
        return core.Color()
    def setColor(self, index: int, color: core.Color) -> bool:
        """
        Sets the color of the coordinate at the specified index.
        index : The index of the coordinate to set. The first coordinate has an index of 0.
        color : The color value as a Color object.
        Returns true if setting the color was successful.
        """
        return bool()
    @property
    def coordinates(self) -> list[float]:
        """
        Gets and sets the coordinate data associated with this CustomGraphicsCoordinates object.
        This data represents the x, y, z components of the coordinates where the unit of measure is centimeters.
        """
        return [float()]
    @coordinates.setter
    def coordinates(self, value: list[float]):
        """
        Gets and sets the coordinate data associated with this CustomGraphicsCoordinates object.
        This data represents the x, y, z components of the coordinates where the unit of measure is centimeters.
        """
        pass
    @property
    def coordinateCount(self) -> int:
        """
        Returns the number of coordinates defined in the CustomGraphicsCoordinates object.
        """
        return int()
    @property
    def colors(self) -> list[int]:
        """
        Gets and sets the colors assoicated with the coordinate data. This is used when a mesh is
        displayed using per-vertex coloring.
        The color at each vertex is represented by four values where they are the red, green, blue,
        and alpha values. This should contain the same number of colors as vertices.
        """
        return [int()]
    @colors.setter
    def colors(self, value: list[int]):
        """
        Gets and sets the colors assoicated with the coordinate data. This is used when a mesh is
        displayed using per-vertex coloring.
        The color at each vertex is represented by four values where they are the red, green, blue,
        and alpha values. This should contain the same number of colors as vertices.
        """
        pass

class CustomGraphicsEntity(core.Base):
    """
    The base class for all visible and selectable custom graphics objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomGraphicsEntity:
        return CustomGraphicsEntity()
    def deleteMe(self) -> bool:
        """
        Deletes the entity from the custom graphics group.
        Returns true if the deletion was successful.
        """
        return bool()
    def setOpacity(self, opacity: float, isOverride: bool) -> bool:
        """
        Sets the opacity of the graphics entity. By default, when a new entity is it is
        completely opaque and does not override the opacity defined by the material.
        opacity : The opacity value where 1.0 is completely opaque and 0.0 is completely transparent.
        isOverride : Indicates if this entities opacity will override the opacity defined by the material.
        If true, it will override the material opacity and if false the opacity values will
        accumulate.
        Returns true if setting the opacity information was successful.
        """
        return bool()
    def getOpacity(self) -> tuple[bool, float, bool]:
        """
        Gets the opacity of the graphics entity.
        opacity : The opacity value where 1.0 is completely opaque and 0.0 is completely transparent.
        isOverride : Indicates if this entities opacity will override the opacity defined by the material.
        If true, it will override the material opacity and if false the opacity values will
        accumulate.
        Returns true if getting the opacity information was successful.
        """
        return (bool(), float(), bool())
    @property
    def isVisible(self) -> bool:
        """
        Gets and sets if the graphics entity is visible in the graphics window. By
        default, when a new entity is created it is visible.
        """
        return bool()
    @isVisible.setter
    def isVisible(self, value: bool):
        """
        Gets and sets if the graphics entity is visible in the graphics window. By
        default, when a new entity is created it is visible.
        """
        pass
    @property
    def isSelectable(self) -> bool:
        """
        Gets and sets if the graphics entity is selectable within the graphics window. By
        default, when a new entity is created it is selectable.
        """
        return bool()
    @isSelectable.setter
    def isSelectable(self, value: bool):
        """
        Gets and sets if the graphics entity is selectable within the graphics window. By
        default, when a new entity is created it is selectable.
        """
        pass
    @property
    def transform(self) -> core.Matrix3D:
        """
        Gets and sets the transform associated with the graphics entity. When a new graphics
        entity is created its default transform is an identity matrix which results in the graphics entity
        being displayed in model space using the original coordinate data used to define the entity.
        """
        return core.Matrix3D()
    @transform.setter
    def transform(self, value: core.Matrix3D):
        """
        Gets and sets the transform associated with the graphics entity. When a new graphics
        entity is created its default transform is an identity matrix which results in the graphics entity
        being displayed in model space using the original coordinate data used to define the entity.
        """
        pass
    @property
    def depthPriority(self) -> int:
        """
        Gets and sets the depth priority associated with the graphics entity. The depth priority defines
        how one graphics entity will be drawn with respect to another entity. This is useful when there
        are entities that lie in the same space so it's ambiguous which should be drawn on the other. For
        example, if you draw a curve on a planar mesh and want the curve to be completely visible. You can
        set the depth priority of the curve to be greater than the mesh so it will be drawn after the mesh
        and will remain visible.
        
        When a new graphics entity is created it's default depth priority is 0.
        """
        return int()
    @depthPriority.setter
    def depthPriority(self, value: int):
        """
        Gets and sets the depth priority associated with the graphics entity. The depth priority defines
        how one graphics entity will be drawn with respect to another entity. This is useful when there
        are entities that lie in the same space so it's ambiguous which should be drawn on the other. For
        example, if you draw a curve on a planar mesh and want the curve to be completely visible. You can
        set the depth priority of the curve to be greater than the mesh so it will be drawn after the mesh
        and will remain visible.
        
        When a new graphics entity is created it's default depth priority is 0.
        """
        pass
    @property
    def cullMode(self) -> CustomGraphicsCullModes:
        """
        Gets and sets the culling model to use when rendering the entity. Culling is used when the entity contains
        a mesh or B-Rep faces and defines which sides of the mesh or face are rendered. This is primarily used
        for a watertight mesh or solid B-Rep so that the "inside" of the faces is not rendered since it's never
        visible to the user.
        
        When a new graphics entity is created its default cull mode is CustomGraphicsCullBack which will optimize
        the rendering of "solid" meshes so the inside is not rendered.
        """
        return CustomGraphicsCullModes()
    @cullMode.setter
    def cullMode(self, value: CustomGraphicsCullModes):
        """
        Gets and sets the culling model to use when rendering the entity. Culling is used when the entity contains
        a mesh or B-Rep faces and defines which sides of the mesh or face are rendered. This is primarily used
        for a watertight mesh or solid B-Rep so that the "inside" of the faces is not rendered since it's never
        visible to the user.
        
        When a new graphics entity is created its default cull mode is CustomGraphicsCullBack which will optimize
        the rendering of "solid" meshes so the inside is not rendered.
        """
        pass
    @property
    def color(self) -> CustomGraphicsColorEffect:
        """
        Gets and sets the current color definition for this entity. The color of custom graphics can
        be defined in many ways; solid color, simple material, and appearance.
        """
        return CustomGraphicsColorEffect()
    @color.setter
    def color(self, value: CustomGraphicsColorEffect):
        """
        Gets and sets the current color definition for this entity. The color of custom graphics can
        be defined in many ways; solid color, simple material, and appearance.
        """
        pass
    @property
    def parent(self) -> core.Base:
        """
        Returns the parent Component for a top-level group or the CustomGraphicsGroup object for
        graphics entities and child groups.
        """
        return core.Base()
    @property
    def id(self) -> str:
        """
        An id you can specify for the entity. By default, all new graphics entities do not have an id and
        this property will return an empty string. But in cases where entities will be selected, assigning
        an id can make understanding what was selected much easier.
        """
        return str()
    @id.setter
    def id(self, value: str):
        """
        An id you can specify for the entity. By default, all new graphics entities do not have an id and
        this property will return an empty string. But in cases where entities will be selected, assigning
        an id can make understanding what was selected much easier.
        """
        pass
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns a box oriented parallel to the world x-y-x axes that contains the graphics entity.
        Depending on whether the graphics are drawn in model space or screen space this will return
        the bounding box in either centimeters (model) or pixels (screen). In the case where it
        returns the bounding box in pixel space, the Z coordinates of the box will be 0 and can be ignored.
        """
        return core.BoundingBox3D()
    @property
    def billBoarding(self) -> CustomGraphicsBillBoard:
        """
        Gets and sets the billboarding behavior of this custom graphics entity. To define billboarding
        you can set this property using a CustomGraphicsBillBoard objects that you statically create using
        the create method of the CustomGraphicsBillBoard class. To remove billboarding from this entity
        you can set this property to null.
        
        Billboarding is used to specify that the orientation of custom graphics is defined relative to the
        screen instead of model space. This is commonly used for legends and symbols that you want to
        always face the user, even as the camera is rotated.
        """
        return CustomGraphicsBillBoard()
    @billBoarding.setter
    def billBoarding(self, value: CustomGraphicsBillBoard):
        """
        Gets and sets the billboarding behavior of this custom graphics entity. To define billboarding
        you can set this property using a CustomGraphicsBillBoard objects that you statically create using
        the create method of the CustomGraphicsBillBoard class. To remove billboarding from this entity
        you can set this property to null.
        
        Billboarding is used to specify that the orientation of custom graphics is defined relative to the
        screen instead of model space. This is commonly used for legends and symbols that you want to
        always face the user, even as the camera is rotated.
        """
        pass
    @property
    def viewPlacement(self) -> CustomGraphicsViewPlacement:
        """
        Gets and sets the graphics view placement being applied to this graphics entity. A
        CustomGraphicsViewPlacement object can be created using the static create method of the
        class. When assigned to a graphics entity the position of the graphics is defined
        relative to the view in 2D view space (pixels) rather than in 3D model space (centimeters).
        """
        return CustomGraphicsViewPlacement()
    @viewPlacement.setter
    def viewPlacement(self, value: CustomGraphicsViewPlacement):
        """
        Gets and sets the graphics view placement being applied to this graphics entity. A
        CustomGraphicsViewPlacement object can be created using the static create method of the
        class. When assigned to a graphics entity the position of the graphics is defined
        relative to the view in 2D view space (pixels) rather than in 3D model space (centimeters).
        """
        pass
    @property
    def viewScale(self) -> CustomGraphicsViewScale:
        """
        Gets and sets the graphics view scale being applied to this graphics entity. A
        CustomGraphicsViewScale object can be created using the static create method of the
        class. When assigned to a graphics entity the size of the graphics entity is defined
        in view space (pixels) instead of model space (centimeters).
        """
        return CustomGraphicsViewScale()
    @viewScale.setter
    def viewScale(self, value: CustomGraphicsViewScale):
        """
        Gets and sets the graphics view scale being applied to this graphics entity. A
        CustomGraphicsViewScale object can be created using the static create method of the
        class. When assigned to a graphics entity the size of the graphics entity is defined
        in view space (pixels) instead of model space (centimeters).
        """
        pass

class CustomGraphicsGroups(core.Base):
    """
    Provides access to a set of graphics groups that are either associated with a component or owned by another
    CustomGraphicsGroup object. This object also supports the creation of new custom graphics groups.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomGraphicsGroups:
        return CustomGraphicsGroups()
    def item(self, index: int) -> CustomGraphicsGroup:
        """
        Function that returns the specified graphics group using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CustomGraphicsGroup()
    def add(self) -> CustomGraphicsGroup:
        """
        Creates a new, empty CustomGraphicsGroup.
        Returns the new CustomGraphicsGroup object or null in the case of a failure.
        """
        return CustomGraphicsGroup()
    @property
    def count(self) -> int:
        """
        Returns the number of graphics groups in the collection.
        """
        return int()

class CustomGraphicsViewPlacement(core.Base):
    """
    Positions custom graphics relative to one of the four corners of the view. Graphics positioned
    this way will always appear on top of the model graphics. This is typically used to display
    legends are small interactive tools.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomGraphicsViewPlacement:
        return CustomGraphicsViewPlacement()
    @staticmethod
    def create(anchorPoint: core.Point3D, viewCorner: ViewCorners, viewPoint: core.Point2D) -> CustomGraphicsViewPlacement:
        """
        Creates a new CustomGraphicsViewPlacement object that can be used when setting the viewPlacement property
        of a custom graphics entity to specify the billboarding behavior.
        anchorPoint : The position within the defined graphics that will serve as the anchor. This is the location
        on the graphics that will be positioned at the specified view point.
        viewCorner : Defines which of the four corners of the view the graphics are drawn relative to.
        viewPoint : A 2D point in the view that defines the position of the graphics. This is relative to the corner
        and is in pixels. The x and y directions vary for each of the corners. These directions are only
        used to position the 2D point and do not affect the standard coordinate system the graphics were
        drawn in.
        
        upperLeftViewCorner - The x direction is to the right and y is down.
        
        upperRightViewCorner - The x direction is to the left and y is down.
        
        lowerLeftViewCorner - The x direction is to the right and y is up.
        
        lowerRightViewCorner - The x direction is to the left and y is up.
        Returns the newly created CustomGraphicsViewPlacement object or null in the case of failure. This can then
        be assigned to any custom graphics entity using its viewPlacement property.
        """
        return CustomGraphicsViewPlacement()
    @property
    def anchorPoint(self) -> core.Point3D:
        """
        Gets and sets the position within the defined graphics that serves as the anchor. This is the location
        on the graphics that is positioned at the specified view point.
        """
        return core.Point3D()
    @anchorPoint.setter
    def anchorPoint(self, value: core.Point3D):
        """
        Gets and sets the position within the defined graphics that serves as the anchor. This is the location
        on the graphics that is positioned at the specified view point.
        """
        pass
    @property
    def viewPoint(self) -> core.Point2D:
        """
        A 2D point in the view that defines the position of the graphics. This is relative to the corner
        and is in pixels. The x and y directions vary for each of the corners. These directions are only
        used to position the 2D point and do not affect the standard coordinate system the graphics were
        drawn in.
        
        upperLeftViewCorner - The x direction is to the right and y is down.
        
        upperRightViewCorner - The x direction is to the left and y is down.
        
        lowerLeftViewCorner - The x direction is to the right and y is up.
        
        lowerRightViewCorner - The x direction is to the left and y is up.
        """
        return core.Point2D()
    @viewPoint.setter
    def viewPoint(self, value: core.Point2D):
        """
        A 2D point in the view that defines the position of the graphics. This is relative to the corner
        and is in pixels. The x and y directions vary for each of the corners. These directions are only
        used to position the 2D point and do not affect the standard coordinate system the graphics were
        drawn in.
        
        upperLeftViewCorner - The x direction is to the right and y is down.
        
        upperRightViewCorner - The x direction is to the left and y is down.
        
        lowerLeftViewCorner - The x direction is to the right and y is up.
        
        lowerRightViewCorner - The x direction is to the left and y is up.
        """
        pass
    @property
    def viewCorner(self) -> ViewCorners:
        """
        Gets and sets which corner the graphics are positioned relative to.
        """
        return ViewCorners()
    @viewCorner.setter
    def viewCorner(self, value: ViewCorners):
        """
        Gets and sets which corner the graphics are positioned relative to.
        """
        pass

class CustomGraphicsViewScale(core.Base):
    """
    Specifies that custom graphics are to be scaled relative to the view (pixels) and not model space.
    If this is applied to some custom graphics then they will stat the same size on the screen regardless
    of the user zooming in or out. This is commonly used for glyphs and other interactive widgets so they don't
    don't get too large or too small.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomGraphicsViewScale:
        return CustomGraphicsViewScale()
    @staticmethod
    def create(pixelScale: float, anchorPoint: core.Point3D) -> CustomGraphicsViewScale:
        """
        Creates a new CustomGraphicsViewScale object that can be used when setting the viewScale property
        of a custom graphics entity to specify the scaling behavior.
        pixelScale : Defines the scale of the custom graphics relative to the view. If a custom graphics line is defined
        to be 100 units long it would usually display as 100 cm long. When it is view scaled with a pixel scale of
        1 it will display as 100 pixels long.
        anchorPoint : Defines the point in the graphics that defines the origin of the scaling. The graphics will be scaled
        up or down relative to that point.
        Returns the newly created CustomGraphicsViewScale object or null in the case of failure. This can then
        be assigned to any custom graphics entity using its viewScale property.
        """
        return CustomGraphicsViewScale()
    @property
    def pixelScale(self) -> float:
        """
        Gets and sets the scale of the custom graphics relative to the view. If a custom graphics line is defined
        to be 100 units long it would usually display as 100 cm long. When it is view scaled with a pixel scale of
        1 it will display as 100 pixels long.
        """
        return float()
    @pixelScale.setter
    def pixelScale(self, value: float):
        """
        Gets and sets the scale of the custom graphics relative to the view. If a custom graphics line is defined
        to be 100 units long it would usually display as 100 cm long. When it is view scaled with a pixel scale of
        1 it will display as 100 pixels long.
        """
        pass
    @property
    def anchorPoint(self) -> core.Point3D:
        """
        Gets and sets the point in the graphics that defines the origin of the scaling. The graphics will be scaled
        up or down relative to that point.
        """
        return core.Point3D()
    @anchorPoint.setter
    def anchorPoint(self, value: core.Point3D):
        """
        Gets and sets the point in the graphics that defines the origin of the scaling. The graphics will be scaled
        up or down relative to that point.
        """
        pass

class CustomNamedValues(core.Base):
    """
    A collection of named values. The values are strings that Fusion stores but can be
    anything you choose. If you have several things you need to save you can choose to
    combine the data into a JSON or XML representation and save it as a single custom value
    or create a new custom value or each unique value you want to store. Fusion doesn't care
    what the value is or what it represents but only saves and provides access to it.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomNamedValues:
        return CustomNamedValues()
    def addOrSetValue(self, id: str, value: str) -> bool:
        """
        Adds or updates a value. If the specified ID does not exist, a new named value is
        added. If the ID does exist, the named value is updated with the specified value.
        id : The ID of the value to create or change.
        value : The string to assign to the value.
        Returns true is successful and false if it failed.
        """
        return bool()
    def isExistingValue(self, id: str) -> bool:
        """
        Function that returns if a value with the specified ID exists or not.
        id : The ID of the value to check if it exists.
        Returns true if a value with the ID exists.
        """
        return bool()
    def value(self, id: str) -> str:
        """
        Function that returns the specified value given its ID.
        id : The ID of the value, which was assigned when the value was created.
        Returns the value or an empty string if the specified ID was not found.
        """
        return str()
    def idByIndex(self, index: int) -> str:
        """
        Function that returns the name of a value specified by its index.
        index : The index of the item within the collection to return the name of. The first item in the collection has an index of 0
        and the last item is the count of this collection minus 1.
        Returns the ID of the specified item or asserts if an out of bounds index is used.
        """
        return str()
    def remove(self, id: str) -> bool:
        """
        Removes the specified value from the collection.
        id : The ID of the value to remove.
        Returns true if the value was successfully removed and false if it failed.
        Failure is typically because the specified ID does not exist within the collection.
        """
        return bool()
    @property
    def count(self) -> int:
        """
        The number of values in the collection.
        """
        return int()

class CutPasteBodies(core.Base):
    """
    Collection that provides access to all of the existing cut-paste features in a design.
    These are created in the UI by cutting and then pasting a B-Rep body.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CutPasteBodies:
        return CutPasteBodies()
    def item(self, index: int) -> CutPasteBody:
        """
        Function that returns the specified Cut/Paste Body feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CutPasteBody()
    def itemByName(self, name: str) -> CutPasteBody:
        """
        Function that returns the specified Cut/Paste Body feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return CutPasteBody()
    def add(self, sourceBody: core.Base) -> CutPasteBody:
        """
        Cuts and copies the specified body into the component that owns this CutPasteBodies collection.
        This is effectively the equivalent of moving a body.
        sourceBody : Either an ObjectCollection of BRepBodies or a single BRepBody object to cut.
        Returns the newly created BRepBody object or null in the case of failure.
        """
        return CutPasteBody()
    @property
    def count(self) -> int:
        """
        The number of Cut/Paste Body features in the collection.
        """
        return int()

class CylinderFeatures(core.Base):
    """
    Collection that provides access to all of the existing cylinder features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CylinderFeatures:
        return CylinderFeatures()
    def item(self, index: int) -> CylinderFeature:
        """
        Function that returns the specified cylinder feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CylinderFeature()
    def itemByName(self, name: str) -> CylinderFeature:
        """
        Function that returns the specified cylinder feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return CylinderFeature()
    @property
    def count(self) -> int:
        """
        The number of cylinder features in the collection.
        """
        return int()

class DeleteFaceFeatures(core.Base):
    """
    Collection that provides access to all of the existing DeleteFaceFeature features in a component
    and supports the ability to create new DeleteFaceFeature features.
    
    The SurfaceDeleteFaceFeature and DeleteFaceFeature differ in that the SurfaceDeleteFaceFeature
    can delete any face without any restrictions. If the body is a solid, it will become a surface
    when the first face is deleted. The specified face is deleted without any other changes being
    made to the body. The DeleteFaceFeature deletes the specified face and also modifies the other faces
    in the body to heal or fill in the area of the deleted face. This means that a solid body will
    remain solid.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DeleteFaceFeatures:
        return DeleteFaceFeatures()
    def item(self, index: int) -> DeleteFaceFeature:
        """
        Function that returns the specified DeleteFaceFeature object using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return DeleteFaceFeature()
    def itemByName(self, name: str) -> DeleteFaceFeature:
        """
        Function that returns the specified DeleteFaceFeature object using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return DeleteFaceFeature()
    def add(self, facesToDelete: core.Base) -> DeleteFaceFeature:
        """
        Creates a new SurfaceDeleteFace feature. This deletes the specified faces
        from their bodies and attempts to heal the body. The method will fail if
        the body cannot be healed. This is equivalent to selecting and deleting
        faces when in the Patch workspace.
        facesToDelete : A single BRepFace or an ObjectCollection containing multiple BRepFace objects.
        Returns the newly created DeleteFaceFeature object or null if the creation failed.
        """
        return DeleteFaceFeature()
    @property
    def count(self) -> int:
        """
        The number of DeleteFaceFeature objects in the collection.
        """
        return int()

class DraftFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a draft
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DraftFeatureInput:
        return DraftFeatureInput()
    def setSingleAngle(self, isSymmetric: bool, angle: core.ValueInput) -> bool:
        """
        Defines the draft to be defined so that a single angle is used for all drafts.
        If the isSymmetric is true then the faces are split along the parting plane and drafted
        independently using the same angle.
        isSymmetric : Set to 'true' if the faces are to be split along the plane and drafted symmetrically. This
        will have the side effect of setting the isSymmetric property to the same value.
        angle : The ValueInput object that defines the angle of the draft. This can be a positive or negative
        value which will affect the direction of the draft along with the isDirectionFlipped property.
        Returns true if successful
        """
        return bool()
    def setTwoAngles(self, angleOne: core.ValueInput, angleTwo: core.ValueInput) -> bool:
        """
        Defines both angles to use when the surfaces are split along the draft plane and
        the faces on each side of the plane are drafted independently from the other side.
        angleOne : The ValueInput object that defines the angle for the faces on the first side of the draft plane.
        angleTwo : The ValueInput object that defines the angle for the faces on the second side of the draft plane.
        Returns true if successful
        """
        return bool()
    @property
    def inputFaces(self) -> list[BRepFace]:
        """
        Gets and sets the input faces.
        If IsTangentChain is true, all the faces that are tangentially connected to the input faces (if any) will also be included.
        """
        return [BRepFace()]
    @inputFaces.setter
    def inputFaces(self, value: list[BRepFace]):
        """
        Gets and sets the input faces.
        If IsTangentChain is true, all the faces that are tangentially connected to the input faces (if any) will also be included.
        """
        pass
    @property
    def plane(self) -> core.Base:
        """
        Gets and sets the plane that defines the direction in which the draft is applied. This can be a planar BrepFace, or a ConstructionPlane.
        """
        return core.Base()
    @plane.setter
    def plane(self, value: core.Base):
        """
        Gets and sets the plane that defines the direction in which the draft is applied. This can be a planar BrepFace, or a ConstructionPlane.
        """
        pass
    @property
    def isTangentChain(self) -> bool:
        """
        Gets and sets if any faces that are tangentially connected to any of
        the input faces will also be included in setting InputEntities. It defaults to true.
        """
        return bool()
    @isTangentChain.setter
    def isTangentChain(self, value: bool):
        """
        Gets and sets if any faces that are tangentially connected to any of
        the input faces will also be included in setting InputEntities. It defaults to true.
        """
        pass
    @property
    def isDirectionFlipped(self) -> bool:
        """
        Gets and sets if the direction of the draft is flipped.
        """
        return bool()
    @isDirectionFlipped.setter
    def isDirectionFlipped(self, value: bool):
        """
        Gets and sets if the direction of the draft is flipped.
        """
        pass
    @property
    def angleOne(self) -> core.ValueInput:
        """
        Gets the first, or the only angle in the case of a single angle definition.
        """
        return core.ValueInput()
    @property
    def angleTwo(self) -> core.ValueInput:
        """
        Gets the second angle. This can be null in the case where a single angle definition is used.
        """
        return core.ValueInput()
    @property
    def isSymmetric(self) -> bool:
        """
        Gets if the draft is symmetric from the draft plane. This only applies in the case where two
        angles have been specified and should be ignored otherwise.
        """
        return bool()
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class DraftFeatures(core.Base):
    """
    Collection that provides access to all of the existing draft features in a component
    and supports the ability to create new draft features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DraftFeatures:
        return DraftFeatures()
    def item(self, index: int) -> DraftFeature:
        """
        Function that returns the specified draft feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return DraftFeature()
    def createInput(self, inputFaces: list[BRepFace], plane: core.Base, isTangentChain: bool) -> DraftFeatureInput:
        """
        Creates a DraftFeatureInput object. Use properties and methods on this object
        to define the draft you want to create and then use the Add method, passing in
        the DraftFeatureInput object.
        inputFaces : BRepFace array that contains the faces to which draft will be applied.
        The picked point on face is always the point returned from pointOnFace property of the first BRepFace in this collection.
        plane : Input object that defines the direction in which the draft is applied. This can be a planar BrepFace, or a ConstructionPlane.
        isTangentChain : A boolean value for setting whether or not faces that are tangentially connected to
        any of the input faces (if any) will also be included. It defaults to true.
        Returns the newly created DraftFeatureInput object or null if the creation failed.
        """
        return DraftFeatureInput()
    def add(self, input: DraftFeatureInput) -> DraftFeature:
        """
        Creates a new draft feature.
        input : A DraftFeatureInput object that defines the desired draft. Use the createInput
        method to create a new DraftFeatureInput object and then use methods on it
        (the DraftFeatureInput object) to define the draft.
        Returns the newly created DraftFeature object or null if the creation failed.
        """
        return DraftFeature()
    def itemByName(self, name: str) -> DraftFeature:
        """
        Function that returns the specified draft feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return DraftFeature()
    @property
    def count(self) -> int:
        """
        The number of draft features in the collection.
        """
        return int()

class ExportManager(core.Base):
    """
    Provides support for exporting model data to various formats.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ExportManager:
        return ExportManager()
    def createIGESExportOptions(self, filename: str, geometry: core.Base) -> IGESExportOptions:
        """
        Creates an IGESExportOptions object that's used to export a design in IGES format. Creation
        of the IGESExportOptions object does not perform the export. You must pass this object to the
        ExportManager.execute method to perform the export. The IGESExportOptions supports any available
        options when exporting to IGES format.
        filename : The filename of the IGES file to be created.
        geometry : The geometry to export. Valid geometry for this is currently a Component object. This argument is optional
        and if not specified, it results in the root component and it entire contents being exported.
        The created IGESExportOptions object or null if the creation failed.
        """
        return IGESExportOptions()
    def createSTEPExportOptions(self, filename: str, geometry: core.Base) -> STEPExportOptions:
        """
        Creates an STEPExportOptions object that's used to export a design in STEP format. Creation
        of the STEPExportOptions object does not perform the export. You must pass this object to the
        ExportManager.execute method to perform the export. The STEPExportOptions supports any available
        options when exporting to STEP format.
        filename : The filename of the STEP file to be created.
        geometry : The geometry to export. Valid geometry for this is currently a Component object. This argument is optional
        and if not specified, it results in the root component and it entire contents being exported.
        The created STEPExportOptions object or null if the creation failed.
        """
        return STEPExportOptions()
    def createSATExportOptions(self, filename: str, geometry: core.Base) -> SATExportOptions:
        """
        Creates an SATExportOptions object that's used to export a design in SAT format. Creation
        of the SATExportOptions object does not perform the export. You must pass this object to the
        ExportManager.execute method to perform the export. The SATExportOptions supports any available
        options when exporting to SAT format.
        filename : The filename of the SAT file to be created.
        geometry : The geometry to export. Valid geometry for this is currently a Component object. This argument is optional
        and if not specified, it results in the root component and it entire contents being exported.
        The created SATExportOptions object or null if the creation failed.
        """
        return SATExportOptions()
    def createSMTExportOptions(self, filename: str, geometry: core.Base) -> SMTExportOptions:
        """
        Creates an SMTExportOptions object that's used to export a design in SMT format. Creation
        of the SMTExportOptions object does not perform the export. You must pass this object to the
        ExportManager.execute method to perform the export. The SMTExportOptions supports any available
        options when exporting to SMT format.
        filename : The filename of the SMT file to be created.
        geometry : The geometry to export. Valid geometry for this is currently a Component object. This argument is optional
        and if not specified, it results in the root component and it entire contents being exported.
        The created SMTExportOptions object or null if the creation failed.
        """
        return SMTExportOptions()
    def createFusionArchiveExportOptions(self, filename: str, geometry: core.Base) -> FusionArchiveExportOptions:
        """
        Creates an FusionArchiveExportOptions object that's used to export a design in Fusion 360 archive format. Creation
        of the FusionArchiveExportOptions object does not perform the export. You must pass this object to the
        ExportManager.execute method to perform the export. The FusionArchiveExportOptions supports any available
        options when exporting to Fusion 360 archive format.
        filename : The filename of the Fusion 360 archive file to be created.
        geometry : The geometry to export. Valid geometry for this is currently a Component object. This argument is optional
        and if not specified, it results in the root component and it entire contents being exported.
        The created FusionArchiveExportOptions object or null if the creation failed.
        """
        return FusionArchiveExportOptions()
    def createSTLExportOptions(self, geometry: core.Base, filename: str) -> STLExportOptions:
        """
        Creates an STLExportOptions object that's used to export a design in STL format. Creation
        of the STLExportOptions object does not perform the export. You must pass this object to the
        ExportManager.execute method to perform the export.
        geometry : The geometry to export. This can be a BRepBody, Occurrence, or Component object.
        filename : The filename of the STL file to be created. This is optional and can be left out if the mesh will be opened in a mesh editor.
        The created createSTLExportOptions object or null if the creation failed.
        """
        return STLExportOptions()
    def execute(self, exportOptions: ExportOptions) -> bool:
        """
        Executes the export operation to create the file in the format specified by the input ExportOptions object.
        exportOptions : An ExportOptions object that is created using one of the create methods on the ExportManager object. This
        defines the type of file and any available options supported for that file type.
        Returns true if the export was successful.
        """
        return bool()
    def createC3MFExportOptions(self, geometry: core.Base, filename: str) -> C3MFExportOptions:
        """
        Creates a C3MFExportOptions object that's used to export a design in 3MF format.  Creation
        of the C3MFExportOptions object does not perform the export.  You must pass this object to the
        ExportManager.execute method to perform the export.
        geometry : The geometry to export.  This can be a BRepBody, Occurrence, or Component object.
        filename : The filename of the 3MF file to be created.  This is optional and can be left out if the mesh will be opened in a mesh editor.
        The created createC3MFExportOptions object or null if the creation failed.
        """
        return C3MFExportOptions()

class ExportOptions(core.Base):
    """
    The base class for the different export types. This class is never directly used
    in an export because you need the specific export type to specify the type of
    export to be performed.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ExportOptions:
        return ExportOptions()
    @property
    def filename(self) -> str:
        """
        Gets and sets the filename that the exported file will be written to. This can
        be empty in the case of STL export and sending the result to the mesh editor.
        """
        return str()
    @filename.setter
    def filename(self, value: str):
        """
        Gets and sets the filename that the exported file will be written to. This can
        be empty in the case of STL export and sending the result to the mesh editor.
        """
        pass
    @property
    def geometry(self) -> core.Base:
        """
        Specifies the geometry to export. This can be an Occurrence, or the root Component.
        For STL export, it can also be a BRepBody. For DXF export, it can be a sketch of flat pattern.
        """
        return core.Base()
    @geometry.setter
    def geometry(self, value: core.Base):
        """
        Specifies the geometry to export. This can be an Occurrence, or the root Component.
        For STL export, it can also be a BRepBody. For DXF export, it can be a sketch of flat pattern.
        """
        pass

class ExtendFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a extend feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ExtendFeatureInput:
        return ExtendFeatureInput()
    @property
    def edges(self) -> core.ObjectCollection:
        """
        Gets and sets the edges to extend
        """
        return core.ObjectCollection()
    @edges.setter
    def edges(self, value: core.ObjectCollection):
        """
        Gets and sets the edges to extend
        """
        pass
    @property
    def distance(self) -> core.ValueInput:
        """
        Gets and sets the ValueInput object that defines the extend distance
        """
        return core.ValueInput()
    @distance.setter
    def distance(self, value: core.ValueInput):
        """
        Gets and sets the ValueInput object that defines the extend distance
        """
        pass
    @property
    def extendType(self) -> SurfaceExtendTypes:
        """
        Gets and sets surface extend type to use
        """
        return SurfaceExtendTypes()
    @extendType.setter
    def extendType(self, value: SurfaceExtendTypes):
        """
        Gets and sets surface extend type to use
        """
        pass
    @property
    def isChainingEnabled(self) -> bool:
        """
        Gets and sets if all edges that are tangent or curvature continuous, and end point connected, will be found
        automatically and extended.
        """
        return bool()
    @isChainingEnabled.setter
    def isChainingEnabled(self, value: bool):
        """
        Gets and sets if all edges that are tangent or curvature continuous, and end point connected, will be found
        automatically and extended.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass
    @property
    def extendAlignment(self) -> SurfaceExtendAlignment:
        """
        Gets and sets surface extend alignment to use.
        """
        return SurfaceExtendAlignment()
    @extendAlignment.setter
    def extendAlignment(self, value: SurfaceExtendAlignment):
        """
        Gets and sets surface extend alignment to use.
        """
        pass

class ExtendFeatures(core.Base):
    """
    Collection that provides access to all of the existing Extend features in a component
    and supports the ability to create new Extend features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ExtendFeatures:
        return ExtendFeatures()
    def item(self, index: int) -> ExtendFeature:
        """
        Function that returns the specified extend feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ExtendFeature()
    def createInput(self, edges: core.ObjectCollection, distance: core.ValueInput, extendType: SurfaceExtendTypes, isChainingEnabled: bool) -> ExtendFeatureInput:
        """
        Creates a ExtendFeatureInput object. Use properties and methods on this object
        to define the extend feature you want to create and then use the Add method, passing in
        the ExtendFeatureInput object.
        edges : The surface edges to extend.
        Only the outer edges from an open body can be extended. The edges must all be from the same body.
        Depending on the extend type there can also be some limitations on the edges being input as described below
        for the extendType argument.
        distance : ValueInput object that defines the distance to extend the face/s.
        Natural and Tangent Extend types require a positive distance value.
        Perpendicular Extend Type supports either a positive or negative value to
        control the direction of the extend. A positive number results in the
        perpendicular extension being in the same direction as the positive normal
        of the connected faces.
        extendType : The extension type to use when extending the face(s).
        Input edges must be connected at endpoints when Tangent or Perpendicular Extend Types are used.
        Input edges need not be connected when Natural Extend type is used.
        isChainingEnabled : An optional boolean argument whose default is true. If this argument is true, all edges that are
        tangent or curvature continuous, and end point connected, will be found automatically and include
        in the set of edges to extend.
        Returns the newly created ExtendFeatureInput object or null if the creation failed.
        """
        return ExtendFeatureInput()
    def add(self, input: ExtendFeatureInput) -> ExtendFeature:
        """
        Creates a new extend feature.
        input : An ExtendFeatureInput object that defines the desired extend feature. Use the createInput
        method to create a new ExtendFeatureInput object and then use methods on it
        (the ExtendFeatureInput object) to define the desired options for the extent feature.
        Returns the newly created ExtendFeature object or null if the creation failed.
        """
        return ExtendFeature()
    def itemByName(self, name: str) -> ExtendFeature:
        """
        Function that returns the specified extend feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return ExtendFeature()
    @property
    def count(self) -> int:
        """
        The number of Extend features in the collection.
        """
        return int()

class ExtentDefinition(core.Base):
    """
    The base class for the various definition objects used to define the extent of a feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ExtentDefinition:
        return ExtentDefinition()
    @property
    def parentFeature(self) -> Feature:
        """
        Returns the parent feature that this definition is associated with. If this definition has been created
        statically and is not associated with a feature this property will return null.
        """
        return Feature()

class ExtrudeFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of an extrude
    feature. This class also provides properties for setting/getting the Profile and Operation
    of the extrude. The Profile and Operation are defined when the ExtrudeFeatures.createInput
    method is called so they do not exist as properties on this class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ExtrudeFeatureInput:
        return ExtrudeFeatureInput()
    def setDistanceExtent(self, isSymmetric: bool, distance: core.ValueInput) -> bool:
        """
        Sets the extrusion extents option to 'Distance'.
        isSymmetric : Set to 'true' for an extrusion symmetrical about the profile plane
        distance : ValueInput object that defines the extrude distance.
        If the isSymmetric argument is 'false', a positive or negative distance can be used to control the direction.
        Returns true if successful
        """
        return bool()
    def setTwoSidesDistanceExtent(self, distanceOne: core.ValueInput, distanceTwo: core.ValueInput) -> bool:
        """
        Sets the extrusion extents option to 'Two Side'.
        This method will fail in the case of a non-parametric extrusion.
        distanceOne : ValueInput object that defines the extrude distance for the first side.
        distanceTwo : ValueInput object that defines the extrude distance for the second side.
        Returns true if successful
        """
        return bool()
    def setAllExtent(self, direction: ExtentDirections) -> bool:
        """
        Sets the extrusion extents option to 'All' (i.e. the extrusion is through-all, in both directions.)
        This method will fail in the case of a non-parametric extrusion.
        direction : The direction can be either positive, negative, or symmetric.
        Returns true if successful
        """
        return bool()
    def setOneSideToExtent(self, toEntity: core.Base, matchShape: bool, directionHint: core.Vector3D) -> bool:
        """
        Sets the extrusion Direction option to 'One Side' and the Extents option to 'To' (a specified face)
        toEntity : The entity that defines the "to" extent. The valid types of entities can vary depending on
        the type of feature this is being used with. For an extrude it can be a BRepBody, BRepFace,
        BRepVertex, ConstructionPlane, or ConstructionPoint.
        matchShape : If the matchShape argument is 'true', the toEntity is extended to fully intersect the extrusion.
        directionHint : Specifies the direction of the extrusion. This is only used in the case where there are two possible solutions and the extrusion can
        hit the toEntity in either direction. An example is if the profile of the extrusion is within a hole.
        The extrusion will intersect the cylinder of the hole in either direction.
        
        Typically there is only a single solution and the direction is determined automatically.
        Returns true if successful.
        """
        return bool()
    def setTwoSidesToExtent(self, toEntityOne: core.Base, toEntityTwo: core.Base, matchShape: bool) -> bool:
        """
        Set the extrusion Direction option to 'Two Side'
        This method will fail in the case of a non-parametric extrusion.
        toEntityOne : The first entity that defines the "to" extent. The valid types of entities can vary depending on
        the type of feature this is being used with. For an extrude it can be a BRepBody, BRepFace,
        BRepVertex, ConstructionPlane, or ConstructionPoint.
        toEntityTwo : The second entity that defines the "to" extent. The valid types of entities can vary depending on
        the type of feature this is being used with. For an extrude it can be a BRepBody, BRepFace,
        BRepVertex, ConstructionPlane, or ConstructionPoint.
        matchShape : If the matchShape argument is 'true', the toEntity is extended to fully intersect the extrusion.
        Returns true if successful.
        """
        return bool()
    def setOneSideExtent(self, extent: ExtentDefinition, direction: ExtentDirections, taperAngle: core.ValueInput) -> bool:
        """
        Defines the extrusion to go in one direction from the profile. The extent of the extrusion is
        defined by the extent argument.
        extent : An ExtentDefinition object that defines how the extent of the extrusion is defined. This can be
        a specified distance (DistanceExtentDefinition), to an entity (ToEntityExtent), or through-all (AllExtentDefinition).
        These objects can be obtained by using the static create method on the appropriate class.
        direction : Specifies the direction of the extrusion. PositiveExtentDirection and NegativeExtentDirection
        are valid values. PositiveExtentDirection is in the same direction as the normal of the profile's
        parent sketch plane.
        taperAngle : Optional argument that specifies the taper angle. If omitted a taper angle of 0 is used.
        Returns true is setting the input to a one sided extent was successful.
        """
        return bool()
    def setTwoSidesExtent(self, sideOneExtent: ExtentDefinition, sideTwoExtent: ExtentDefinition, sideOneTaperAngle: core.ValueInput, sideTwoTaperAngle: core.ValueInput) -> bool:
        """
        Defines the extrusion to go in both directions from the profile. The extent is defined independently
        for each direction using the input arguments.
        sideOneExtent : An ExtentDefinition object that defines how the extent of the extrusion towards side one is defined. This can be
        a specified distance (DistanceExtentDefinition), to an entity (ToEntityExtent), or through-all (AllExtentDefinition).
        These objects can be obtained by using the static create method on the appropriate class.
        sideTwoExtent : An ExtentDefinition object that defines how the extent of the extrusion towards side two is defined. This can be
        a specified distance (DistanceExtentDefinition), to an entity (ToEntityExtent), or through-all (AllExtentDefinition).
        These objects can be obtained by using the static create method on the appropriate class.
        sideOneTaperAngle : Optional argument that specifies the taper angle for side one. If omitted a taper angle of 0 is used.
        sideTwoTaperAngle : Optional argument that specifies the taper angle for side two. If omitted a taper angle of 0 is used.
        Returns true is setting the extent was successful.
        """
        return bool()
    def setSymmetricExtent(self, distance: core.ValueInput, isFullLength: bool, taperAngle: core.ValueInput) -> bool:
        """
        Defines the extrusion to go symmetrically in both directions from the profile.
        distance : The distance of the extrusions. This is either the full length of half of the length of the final extrusion
        depending on the value of the isFullLength property.
        isFullLength : Defines if the value defines the full length of the extrusion or half of the length. A value of true indicates
        it defines the full length.
        taperAngle : Optional argument that specifies the taper angle. The same taper angle is used for both sides for a symmetric
        extrusion. If omitted a taper angle of 0 is used.
        Returns true is setting the extent was successful.
        """
        return bool()
    def setThinExtrude(self, thinExtrudeWallLocationOne: ThinExtrudeWallLocation, thinExtrudeWallThicknessOne: core.ValueInput, thinExtrudeWallLocationTwo: ThinExtrudeWallLocation, thinExtrudeWallThicknessTwo: core.ValueInput) -> bool:
        """
        Changes the extrude feature to be a thin extrude. This is only valid if the isThinExtrude property
        is False. If the extrusion is already a thin extrude, you can use the properties on the ExtrudeFeature
        to modify the thin extrude specific values.
        thinExtrudeWallLocationOne : Specifies the position of the thin wall extrude with respect to the profile being extruded. This defines
        the direction for a single sided thin extrude or side one of a two-sided extrusion.
        thinExtrudeWallThicknessOne : A ValueInput object that defines the thickness for a single sided thin extrude or side one of a two-sided
        extrusion .
        thinExtrudeWallLocationTwo : Optional argument that specifies the position of side two of a two-sided extrusion. This argument is ignored
        for a single sided thin extrude.
        thinExtrudeWallThicknessTwo : Optional argument that is a ValueInput object that defines the thickness for side two of a
        two-sided extrusion. This argument is ignored for a single sided thin extrude.
        Returns true if successful.
        """
        return bool()
    @property
    def profile(self) -> core.Base:
        """
        Gets and sets the profiles or planar faces used to define the shape of the extrude.
        This property can return or be set with a single profile, a single planar face, or
        an ObjectCollection consisting of multiple profiles and planar faces. When an
        ObjectCollection is used all of the profiles and faces must be co-planar.
        
        To create a surface (non-solid) extrusion, you can use the createOpenProfile and createBRepEdgeProfile
        methods of the Component object to create an open profile. The isSolid property of the
        ExtrudeFeatureInput property must also be False.
        """
        return core.Base()
    @profile.setter
    def profile(self, value: core.Base):
        """
        Gets and sets the profiles or planar faces used to define the shape of the extrude.
        This property can return or be set with a single profile, a single planar face, or
        an ObjectCollection consisting of multiple profiles and planar faces. When an
        ObjectCollection is used all of the profiles and faces must be co-planar.
        
        To create a surface (non-solid) extrusion, you can use the createOpenProfile and createBRepEdgeProfile
        methods of the Component object to create an open profile. The isSolid property of the
        ExtrudeFeatureInput property must also be False.
        """
        pass
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the type of operation performed by the extrusion.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the type of operation performed by the extrusion.
        """
        pass
    @property
    def taperAngle(self) -> core.ValueInput:
        """
        Gets and sets the taper angle of the extrusion. This is used to define the
        taper angle for a single sided and symmetric and defines the angle for side one
        of a two sided extrusion. This property is initialized with a taper angle of zero.
        A negative angle will taper the extrusion inward while a positive value will taper
        the extrusion outward. This property is valid for both parametric and non-parametric extrusions.
        """
        return core.ValueInput()
    @taperAngle.setter
    def taperAngle(self, value: core.ValueInput):
        """
        Gets and sets the taper angle of the extrusion. This is used to define the
        taper angle for a single sided and symmetric and defines the angle for side one
        of a two sided extrusion. This property is initialized with a taper angle of zero.
        A negative angle will taper the extrusion inward while a positive value will taper
        the extrusion outward. This property is valid for both parametric and non-parametric extrusions.
        """
        pass
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Extrusion is created based on geometry (e.g. a profile and/or face(s))
        in another component AND (the Extrusion) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Extrusion is created based on geometry (e.g. a profile and/or face(s))
        in another component AND (the Extrusion) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        pass
    @property
    def isSolid(self) -> bool:
        """
        Specifies if the extrusion should be created as a solid or surface. If
        it's a surface then there aren't any end caps and it's open. When a ExtrudeFeature
        input is created, this is initialized to true so a solid will be created if it's not changed.
        """
        return bool()
    @isSolid.setter
    def isSolid(self, value: bool):
        """
        Specifies if the extrusion should be created as a solid or surface. If
        it's a surface then there aren't any end caps and it's open. When a ExtrudeFeature
        input is created, this is initialized to true so a solid will be created if it's not changed.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass
    @property
    def startExtent(self) -> ExtentDefinition:
        """
        Gets and sets the extent used to define the start of the extrusion. When a new ExtrudeFeatureInput
        object is created the start extent is initialized to be the profile plane but you can change it
        to a profile plane with offset or from an object by setting this property with either a
        ProfilePlaneWithOffsetStartDefinition or a EntityStartDefinition object. You can get either one
        of those objects by using the static create method on the class.
        """
        return ExtentDefinition()
    @startExtent.setter
    def startExtent(self, value: ExtentDefinition):
        """
        Gets and sets the extent used to define the start of the extrusion. When a new ExtrudeFeatureInput
        object is created the start extent is initialized to be the profile plane but you can change it
        to a profile plane with offset or from an object by setting this property with either a
        ProfilePlaneWithOffsetStartDefinition or a EntityStartDefinition object. You can get either one
        of those objects by using the static create method on the class.
        """
        pass
    @property
    def extentOne(self) -> ExtentDefinition:
        """
        Gets the extent assigned for a single sided extrude or side one of a two-sided extrusion. To set the extent, use
        one of the set methods on the ExtrudeFeatureInput object.
        """
        return ExtentDefinition()
    @property
    def extentTwo(self) -> ExtentDefinition:
        """
        Gets the extent assigned for side two of the extrusion. If the extrude is single sided extrude this
        property will return null. The hasTwoExtents property can be used to determine if there
        are two sides or not. To set the extent, use one of the set methods on the ExtrudeFeatureInput object.
        """
        return ExtentDefinition()
    @property
    def taperAngleOne(self) -> core.ValueInput:
        """
        Gets the value that will be used as the taper angle for a single sided extrusion or side one of a two-sided
        extrusion. To set the taper angle, use one of the set methods on the ExtrudeFeatureInput object.
        """
        return core.ValueInput()
    @property
    def taperAngleTwo(self) -> core.ValueInput:
        """
        Gets the value that will be used as the taper angle for side two of a two-sided extrusion. If the extrusion is
        single-sided, this property will return null. The hasTwoExtents property can be used to determine if there
        are two sides or not. To set the taper angle, use one of the set methods on the ExtrudeFeatureInput object.
        """
        return core.ValueInput()
    @property
    def hasTwoExtents(self) -> bool:
        """
        Property that indicates if the extrusion is a single or two-sided extrusion. If false, the extentTwo
        and taperAngleTwo properties should not be used.
        """
        return bool()
    @property
    def participantBodies(self) -> list[BRepBody]:
        """
        Gets and sets the list of bodies that will participate in the feature when the operation is a cut or intersection.
        
        If this property has not been set, the default behavior is that all bodies that are intersected by the
        feature will participate.
        
        This property can return null in the case where the feature has not been fully defined so that
        possible intersecting bodies can be computed.
        """
        return [BRepBody()]
    @participantBodies.setter
    def participantBodies(self, value: list[BRepBody]):
        """
        Gets and sets the list of bodies that will participate in the feature when the operation is a cut or intersection.
        
        If this property has not been set, the default behavior is that all bodies that are intersected by the
        feature will participate.
        
        This property can return null in the case where the feature has not been fully defined so that
        possible intersecting bodies can be computed.
        """
        pass
    @property
    def isThinExtrude(self) -> bool:
        """
        Sets or returns whether the extrude is a thin extrude.
        Setting it as false will make it a regular extrude.
        """
        return bool()
    @isThinExtrude.setter
    def isThinExtrude(self, value: bool):
        """
        Sets or returns whether the extrude is a thin extrude.
        Setting it as false will make it a regular extrude.
        """
        pass
    @property
    def thinExtrudeWallLocationOne(self) -> ThinExtrudeWallLocation:
        """
        Gets and sets the wall location for a one sided thin extrude or side one of a two sided thin extrude
        """
        return ThinExtrudeWallLocation()
    @thinExtrudeWallLocationOne.setter
    def thinExtrudeWallLocationOne(self, value: ThinExtrudeWallLocation):
        """
        Gets and sets the wall location for a one sided thin extrude or side one of a two sided thin extrude
        """
        pass
    @property
    def thinExtrudeWallLocationTwo(self) -> ThinExtrudeWallLocation:
        """
        Gets and sets the wall location for side two of a two sided thin extrude
        """
        return ThinExtrudeWallLocation()
    @thinExtrudeWallLocationTwo.setter
    def thinExtrudeWallLocationTwo(self, value: ThinExtrudeWallLocation):
        """
        Gets and sets the wall location for side two of a two sided thin extrude
        """
        pass
    @property
    def thinExtrudeWallThicknessOne(self) -> core.ValueInput:
        """
        Gets and sets the wall thickness for a one sided thin extrude or side one of a two sided thin extrude
        """
        return core.ValueInput()
    @thinExtrudeWallThicknessOne.setter
    def thinExtrudeWallThicknessOne(self, value: core.ValueInput):
        """
        Gets and sets the wall thickness for a one sided thin extrude or side one of a two sided thin extrude
        """
        pass
    @property
    def thinExtrudeWallThicknessTwo(self) -> core.ValueInput:
        """
        Gets and sets the wall thickness for side two of a two sided thin extrude
        """
        return core.ValueInput()
    @thinExtrudeWallThicknessTwo.setter
    def thinExtrudeWallThicknessTwo(self, value: core.ValueInput):
        """
        Gets and sets the wall thickness for side two of a two sided thin extrude
        """
        pass

class ExtrudeFeatures(core.Base):
    """
    Collection that provides access to all of the existing extrude features in a design
    and supports the ability to create new extrude features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ExtrudeFeatures:
        return ExtrudeFeatures()
    def item(self, index: int) -> ExtrudeFeature:
        """
        Function that returns the specified extrude feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ExtrudeFeature()
    def createInput(self, profile: core.Base, operation: FeatureOperations) -> ExtrudeFeatureInput:
        """
        Creates a new ExtrudeFeatureInput object that is used to specify the input needed
        to create a new extrude feature.
        profile : The profile argument can be a single Profile, a single planar face, a single SketchText object,
        or an ObjectCollection consisting of multiple profiles, planar faces, and sketch texts.
        When an ObjectCollection is used all of the profiles, faces, and sketch texts must be co-planar.
        
        To create a surface (non-solid) extrusion, you can use the createOpenProfile and createBRepEdgeProfile
        methods of the Component object to create an open profile. You also need to set the isSolid property
        of the returned ExtrudeFeatureInput property to False.
        operation : The feature operation to perform.
        Returns the newly created ExtrudeFeatureInput object or null if the creation failed.
        """
        return ExtrudeFeatureInput()
    def add(self, input: ExtrudeFeatureInput) -> ExtrudeFeature:
        """
        Creates a new extrude feature based on the information defined by the provided ExtrudeFeatureInput object.
        To create a new extrusion use the createInput function to create a new input object and use the methods and
        properties on that object to define the required input for an extrusion. Once the information is defined on the
        input object you can pass it to the Add method to create the extrusion.
        input : The ExtrudeFeatureInput object that specifies the input needed to create a new extrude
        feature.
        Returns the newly created ExtrudeFeature or null if the creation failed.
        """
        return ExtrudeFeature()
    def itemByName(self, name: str) -> ExtrudeFeature:
        """
        Function that returns the specified extrude feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return ExtrudeFeature()
    def addSimple(self, profile: core.Base, distance: core.ValueInput, operation: FeatureOperations) -> ExtrudeFeature:
        """
        Creates a basic extrusion that goes from the profile plane the specified distance.
        profile : The profile argument can be a single Profile, a single planar face, a single SketchText object,
        or an ObjectCollection consisting of multiple profiles, planar faces, and sketch texts.
        When an ObjectCollection is used all of the profiles, faces, and sketch texts must be co-planar.
        
        To create a surface (non-solid) extrusion, you can use the createOpenProfile and createBRepEdgeProfile
        methods of the Component object to create an open profile. You also need to set the isSolid property
        of the returned ExtrudeFeatureInput property to False.
        distance : ValueInput object that defines the extrude distance. A positive value extrudes in the positive direction
        of the sketch plane and negative value is in the opposite direction.
        operation : The feature operation to perform.
        Returns the newly created ExtrudeFeature or null if the creation failed.
        """
        return ExtrudeFeature()
    @property
    def count(self) -> int:
        """
        The number of extrude features in the collection.
        """
        return int()

class Feature(core.Base):
    """
    Base class object representing all features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Feature:
        return Feature()
    def deleteMe(self) -> bool:
        """
        Deletes the feature.
        This works for both parametric and non-parametric features.
        Returns a bool indicating if the delete was successful or not.
        """
        return bool()
    def dissolve(self) -> bool:
        """
        Dissolves the feature so that the feature information is lost
        and only the B-Rep geometry defined by the feature remains.
        This is only valid for non-parametric features.
        Returns a bool indicating if the dissolve was successful or not.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Returns the name of the feature as seen in the browser (non-parametric) or in the timeline (parametric).
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Returns the name of the feature as seen in the browser (non-parametric) or in the timeline (parametric).
        """
        pass
    @property
    def isSuppressed(self) -> bool:
        """
        Gets and sets if this feature is suppressed. This is only valid
        for parametric features.
        """
        return bool()
    @isSuppressed.setter
    def isSuppressed(self, value: bool):
        """
        Gets and sets if this feature is suppressed. This is only valid
        for parametric features.
        """
        pass
    @property
    def isParametric(self) -> bool:
        """
        Indicates if this feature is parametric or not.
        """
        return bool()
    @property
    def faces(self) -> BRepFaces:
        """
        Returns the faces that were created by this feature.
        This works for both parametric and non-parametric features.
        """
        return BRepFaces()
    @property
    def parentComponent(self) -> Component:
        """
        Returns the parent component that owns this feature.
        """
        return Component()
    @property
    def linkedFeatures(self) -> FeatureList:
        """
        Returns the set of features that are linked to this feature. The set of linked features
        are all of the features that were created in various components as the result of a
        single feature being created in the user interface.
        """
        return FeatureList()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def timelineObject(self) -> TimelineObject:
        """
        Returns the timeline object associated with this feature.
        """
        return TimelineObject()
    @property
    def bodies(self) -> BRepBodies:
        """
        Returns the bodies that were modified or created by this feature.
        This property works for both parametric and non-parametric features.
        
        For a BaseFeature, this property has two different behaviors depending
        on if the BaseFeature is active for edit or not. When the base feature is
        active, this property returns the bodies owned by the base feature or the
        source bodies. When the base feature is not active, this property returns
        the result bodies.
        
        When a body is added to a base feature, that body is owned by the base feature
        and is only seen in the UI when the base feature is active. This body is referred
        to as a "source body". Fusion creates a parametric copy of the body when you
        exit the base feature. This copy is referred to as the "result body," and it
        is used for subsequent modeling operations.
        
        You can map between the source and result bodies by using their position
        within the bodies returned. To get a valid list of result bodies, you should
        roll the timeline to immediately after the base feature node in the timeline.
        Otherwise, subsequent operations could have done something to cause one or
        more bodies to no longer be available.
        """
        return BRepBodies()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this face.
        """
        return core.Attributes()
    @property
    def baseFeature(self) -> BaseFeature:
        """
        If this feature is associated with a base feature, this property will return that base feature.
        If it's not associated with a base feature, this property will return null.
        """
        return BaseFeature()
    @property
    def healthState(self) -> FeatureHealthStates:
        """
        Returns the current health state of the feature.
        """
        return FeatureHealthStates()
    @property
    def errorOrWarningMessage(self) -> str:
        """
        Returns the error or warning message in the case where the healthState property returns either
        WarningFeatureHealthState or ErrorFeatureHealthState. Otherwise this property returns an empty string.
        """
        return str()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the Feature object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same feature.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class FeatureList(core.Base):
    """
    Provides access to a list of features. This is used in the API to return
    a list of features from an API call.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FeatureList:
        return FeatureList()
    def item(self, index: int) -> Feature:
        """
        Returns the specified folder.
        index : The index of the feature to return. The first feature in the list has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Feature()
    @property
    def count(self) -> int:
        """
        The number of features in this collection.
        """
        return int()

class Features(core.Base):
    """
    The features collection which provides access to all existing features. This collection
    provides direct access to all features regardless of type. It also provides access
    to type specific collections where you can get features of a specific type and also create
    new features of that type.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Features:
        return Features()
    def item(self, index: int) -> Feature:
        """
        Function that returns the specified feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Feature()
    def createPath(self, curve: core.Base, isChain: bool) -> Path:
        """
        Method that creates a Path used to define the shape of a Sweep feature. A Path is a contiguous
        set of curves that can be a combination of sketch curves and model edges.
        curve : A SketchCurve or an ObjectCollection containing multiple sketch entities and/or BRepEdge objects. If a single sketch curve
        or edge is input the isChain argument is checked to determine if connected curves (they do not need to be tangent)
        should be automatically found. If multiple curves are provided the isChain argument is always
        treated as false so you must provide all of the curves in the object collection that you want included in the path.
        The provided curves must all connect together in a single path.
        
        The input curves can be from multiple sketches and bodies and they need to geometrically connect for
        a valid path to be created.
        isChain : Optional argument, that defaults to true. If this argument is set to true, all curves and edges that are end point
        connected to the single input curve will be found and used to create the path.
        This argument is only used when the first argument is a single SketchCurve/BRepEdge object.
        Returns the newly created Path.
        """
        return Path()
    def itemByName(self, name: str) -> Feature:
        """
        Function that returns the specified feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the same name seen in the timeline.
        Returns the specified item or null if a feature matching the name was not found.
        """
        return Feature()
    @property
    def count(self) -> int:
        """
        Returns the number of bodies in the collection.
        """
        return int()
    @property
    def extrudeFeatures(self) -> ExtrudeFeatures:
        """
        Returns the collection that provides access to the extrude features within the component
        and supports the creation of new extrude features.
        """
        return ExtrudeFeatures()
    @property
    def revolveFeatures(self) -> RevolveFeatures:
        """
        Returns the collection that provides access to the revolve features within the component
        and supports the creation of new revolved features.
        """
        return RevolveFeatures()
    @property
    def holeFeatures(self) -> HoleFeatures:
        """
        Returns the collection that provides access to the hole features within the component
        and supports the creation of new hole features.
        """
        return HoleFeatures()
    @property
    def filletFeatures(self) -> FilletFeatures:
        """
        Returns the collection that provides access to the fillet features within the component
        and supports the creation of new fillet features.
        """
        return FilletFeatures()
    @property
    def sweepFeatures(self) -> SweepFeatures:
        """
        Returns the collection that provides access to the sweep features within the component
        and supports the creation of new sweep features.
        """
        return SweepFeatures()
    @property
    def chamferFeatures(self) -> ChamferFeatures:
        """
        Returns the collection that provides access to the chamfer features within the component
        and supports the creation of new chamfer features.
        """
        return ChamferFeatures()
    @property
    def shellFeatures(self) -> ShellFeatures:
        """
        Returns the collection that provides access to the shell features within the component
        and supports the creation of new shell features.
        """
        return ShellFeatures()
    @property
    def mirrorFeatures(self) -> MirrorFeatures:
        """
        Returns the collection that provides access to the mirror features within the component
        and supports the creation of new mirror features.
        """
        return MirrorFeatures()
    @property
    def circularPatternFeatures(self) -> CircularPatternFeatures:
        """
        Returns the collection that provides access to the circular pattern features within the component
        and supports the creation of new circular pattern features.
        """
        return CircularPatternFeatures()
    @property
    def rectangularPatternFeatures(self) -> RectangularPatternFeatures:
        """
        Returns the collection that provides access to the rectangular pattern features within the component
        and supports the creation of new rectangular pattern features.
        """
        return RectangularPatternFeatures()
    @property
    def pathPatternFeatures(self) -> PathPatternFeatures:
        """
        Returns the collection that provides access to the path pattern features within the component
        and supports the creation of new path pattern features.
        """
        return PathPatternFeatures()
    @property
    def combineFeatures(self) -> CombineFeatures:
        """
        Returns the collection that provides access to the combine features within the component
        and supports the creation of new combine features.
        """
        return CombineFeatures()
    @property
    def threadFeatures(self) -> ThreadFeatures:
        """
        Returns the collection that provides access to the thread features within the component
        and supports the creation of new thread features.
        """
        return ThreadFeatures()
    @property
    def draftFeatures(self) -> DraftFeatures:
        """
        Returns the collection that provides access to the draft features within the component
        and supports the creation of new draft features.
        """
        return DraftFeatures()
    @property
    def scaleFeatures(self) -> ScaleFeatures:
        """
        Returns the collection that provides access to the scale features within the component
        and supports the creation of new scale features.
        """
        return ScaleFeatures()
    @property
    def replaceFaceFeatures(self) -> ReplaceFaceFeatures:
        """
        Returns the collection that provides access to the replaceFace features within the component
        and supports the creation of new replaceFace features.
        """
        return ReplaceFaceFeatures()
    @property
    def moveFeatures(self) -> MoveFeatures:
        """
        Returns the collection that provides access to the Move features within the component
        and supports the creation of new Move features.
        """
        return MoveFeatures()
    @property
    def splitFaceFeatures(self) -> SplitFaceFeatures:
        """
        Returns the collection that provides access to the SplitFace features within the component and supports the creation
        of new SplitFace features
        """
        return SplitFaceFeatures()
    @property
    def splitBodyFeatures(self) -> SplitBodyFeatures:
        """
        Returns the collection that provides access to the SplitBody features within the component and supports the creation
        of new SplitBody features
        """
        return SplitBodyFeatures()
    @property
    def silhouetteSplitFeatures(self) -> SilhouetteSplitFeatures:
        """
        Returns the collection that provides access to the Parting Line Split features within the component and supports
        the creation of new Parting Line Split features
        """
        return SilhouetteSplitFeatures()
    @property
    def offsetFeatures(self) -> OffsetFeatures:
        """
        Returns the collection that provides access to the Offset features within the component
        and supports the creation of new Offset features.
        """
        return OffsetFeatures()
    @property
    def extendFeatures(self) -> ExtendFeatures:
        """
        Returns the collection that provides access to the Extend features within the component
        and supports the creation of new Extend features.
        """
        return ExtendFeatures()
    @property
    def stitchFeatures(self) -> StitchFeatures:
        """
        Returns the collection that provides access to the Stitch features within the component
        and supports the creation of new Stitch features.
        """
        return StitchFeatures()
    @property
    def boundaryFillFeatures(self) -> BoundaryFillFeatures:
        """
        Returns the collection that provides access to the Boundary Fill features within the component
        and supports the creation of new Boundary Fill features.
        """
        return BoundaryFillFeatures()
    @property
    def trimFeatures(self) -> TrimFeatures:
        """
        Returns the collection that provides access to the Trim features within the component
        and supports the creation of new Trim features.
        """
        return TrimFeatures()
    @property
    def thickenFeatures(self) -> ThickenFeatures:
        """
        Returns the collection that provides access to the Thicken features within the component
        and supports the creation of new Thicken features.
        """
        return ThickenFeatures()
    @property
    def unstitchFeatures(self) -> UnstitchFeatures:
        """
        Returns the collection that provides access to the Unstitch features within the component
        and supports the creation of new Unstitch features.
        """
        return UnstitchFeatures()
    @property
    def removeFeatures(self) -> RemoveFeatures:
        """
        Returns the collection that provides access to the Remove features within the component
        and supports the creation of new Remove features.
        """
        return RemoveFeatures()
    @property
    def baseFeatures(self) -> BaseFeatures:
        """
        Returns the collection that provides access to the existing base features
        and supports the creation of new base features. A base feature represents
        a body that is non-parametric.
        """
        return BaseFeatures()
    @property
    def coilFeatures(self) -> CoilFeatures:
        """
        Returns the collection that provides access to the Coil Primitive features within the component.
        """
        return CoilFeatures()
    @property
    def boxFeatures(self) -> BoxFeatures:
        """
        Returns the collection that provides access to the existing box features.
        """
        return BoxFeatures()
    @property
    def cylinderFeatures(self) -> CylinderFeatures:
        """
        Returns the collection that provides access to the existing cylinder features.
        """
        return CylinderFeatures()
    @property
    def sphereFeatures(self) -> SphereFeatures:
        """
        Returns the collection that provides access to the existing sphere features.
        """
        return SphereFeatures()
    @property
    def torusFeatures(self) -> TorusFeatures:
        """
        Returns the collection that provides access to the existing torus features.
        """
        return TorusFeatures()
    @property
    def pipeFeatures(self) -> PipeFeatures:
        """
        Returns the collection that provides access to the existing pipe features.
        """
        return PipeFeatures()
    @property
    def ribFeatures(self) -> RibFeatures:
        """
        Returns the collection that provides access to the existing rib features.
        """
        return RibFeatures()
    @property
    def webFeatures(self) -> WebFeatures:
        """
        Returns the collection that provides access to the existing web features.
        """
        return WebFeatures()
    @property
    def formFeatures(self) -> FormFeatures:
        """
        Returns the collection that provides access to the existing form features.
        """
        return FormFeatures()
    @property
    def reverseNormalFeatures(self) -> ReverseNormalFeatures:
        """
        Returns the collection that provides access to the Reverse Normal features within the component
        and supports the creation of new Reverse Normal features.
        """
        return ReverseNormalFeatures()
    @property
    def patchFeatures(self) -> PatchFeatures:
        """
        Returns the collection that provides access to the Patch features within the component
        and supports the creation of new Patch features.
        """
        return PatchFeatures()
    @property
    def loftFeatures(self) -> LoftFeatures:
        """
        Returns the collection that provides access to the existing loft features and
        supports the creation of new loft features.
        """
        return LoftFeatures()
    @property
    def ruleFilletFeatures(self) -> RuleFilletFeatures:
        """
        Returns the collection that provides access to the existing form features.
        """
        return RuleFilletFeatures()
    @property
    def surfaceDeleteFaceFeatures(self) -> SurfaceDeleteFaceFeatures:
        """
        Returns the collection that provides access to the existing Surface Delete Face features.
        """
        return SurfaceDeleteFaceFeatures()
    @property
    def deleteFaceFeatures(self) -> DeleteFaceFeatures:
        """
        Returns the collection that provides access to the existing Delete Face features.
        """
        return DeleteFaceFeatures()
    @property
    def offsetFacesFeatures(self) -> OffsetFacesFeatures:
        """
        Returns the collection that provides access to the existing Offset Face features.
        """
        return OffsetFacesFeatures()
    @property
    def copyPasteBodies(self) -> CopyPasteBodies:
        """
        Returns the collection that provides access to the existing copy-paste features
        and supports the creation of new copy-paste features.
        """
        return CopyPasteBodies()
    @property
    def cutPasteBodies(self) -> CutPasteBodies:
        """
        Returns the collection that provides access to the existing cut-paste features
        and supports the creation of new cut-paste features.
        """
        return CutPasteBodies()
    @property
    def flangeFeatures(self) -> FlangeFeatures:
        """
        Returns the collection that provides access to the existing flange features.
        """
        return FlangeFeatures()
    @property
    def unfoldFeatures(self) -> UnfoldFeatures:
        """
        Returns the collection that provides access to the existing unfold features.
        """
        return UnfoldFeatures()
    @property
    def refoldFeatures(self) -> RefoldFeatures:
        """
        Returns the collection that provides access to the existing refold features.
        """
        return RefoldFeatures()
    @property
    def ruledSurfaceFeatures(self) -> RuledSurfaceFeatures:
        """
        Returns the collection that provides access to the Ruled Surface features within the component
        and supports the creation of new Ruled Surface features.
        """
        return RuledSurfaceFeatures()
    @property
    def customFeatures(self) -> CustomFeatures:
        """
        Returns the collection that provides access to the custom features within the component
        and supports the creation of new custom features.
        """
        return CustomFeatures()
    @property
    def untrimFeatures(self) -> UntrimFeatures:
        """
        Returns the collection that provides access to the Untrim features within the component
        and supports the creation of new Untrim features.
        """
        return UntrimFeatures()

class FilletEdgeSet(core.Base):
    """
    The base class for the classes that define the different types of fillet edge sets.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FilletEdgeSet:
        return FilletEdgeSet()
    @property
    def isTangentChain(self) -> bool:
        """
        Gets and sets the Tangent chain for fillet. This enables tangent chain option for fillet.
        """
        return bool()
    @isTangentChain.setter
    def isTangentChain(self, value: bool):
        """
        Gets and sets the Tangent chain for fillet. This enables tangent chain option for fillet.
        """
        pass

class FilletEdgeSets(core.Base):
    """
    Collection that provides access to all of the existing fillet edge sets associated with a fillet feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FilletEdgeSets:
        return FilletEdgeSets()
    def item(self, index: int) -> FilletEdgeSet:
        """
        Function that returns the specified fillet edge set using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return FilletEdgeSet()
    @property
    def count(self) -> int:
        """
        The number of fillet edge sets in the collection.
        """
        return int()

class FilletFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a fillet
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FilletFeatureInput:
        return FilletFeatureInput()
    def addConstantRadiusEdgeSet(self, edges: core.ObjectCollection, radius: core.ValueInput, isTangentChain: bool) -> bool:
        """
        Adds a set of edges with a constant radius to this input.
        edges : An ObjectCollection containing the edges to be filleted. If the isTangentChain argument is true
        additional edges may also get filleted if they are tangentially connected to any of the
        input edges.
        radius : A ValueInput object that defines the radius of the fillet. If the ValueInput uses
        a real then it is interpreted as centimeters. If it is a string then the units
        can be defined as part of the string (i.e. "2 in") or if no units are specified
        it is interpreted using the current default units for length.
        isTangentChain : A boolean value for setting whether or not edges that are tangentially connected to
        the input edges (if any) will also be filleted.
        Returns true if the set of edges was successfully added to the FilletFeatureInput.
        """
        return bool()
    def addVariableRadiusEdgeSet(self, tangentEdges: core.ObjectCollection, startRadius: core.ValueInput, endRadius: core.ValueInput, positions: list[core.ValueInput], radii: list[core.ValueInput]) -> bool:
        """
        Adds a single edge or set of tangent edges along with variable radius information to this input.
        tangentEdges : An object collection containing a single edge or multiple edges. Multiple edges
        must be tangentially connected and added to the collection in order.
        startRadius : A ValueInput object that defines the starting radius of the fillet. If a single edge is
        being filleted, the start radius is at the start end of the edge. If multiple tangent
        edges are being filleted the start radius is the open end of the first edge in the
        collection.
        
        If the ValueInput uses a real then it is interpreted as centimeters. If it is a string then
        the units can be defined as part of the string (i.e. "2 in") or if no units are specified
        it is interpreted using the current default units for length.
        endRadius : A ValueInput object that defines the ending radius of the fillet. If a single edge is
        being filleted, the end radius is at the end of the edge. If multiple tangent
        edges are being filleted the end radius is the open end of the last edge in the
        collection.
        If the ValueInput uses a real then it is interpreted as centimeters. If it is a string then
        the units can be defined as part of the string (i.e. "2 in") or if no units are specified
        it is interpreted using the current default units for length.
        positions : An array of ValueInput objects that defines the positions of any additional radii
        along the edge(s). The value must be between 0 and 1 and defines the percentage along the
        curve where a radius is defined. The value is unitless. This array must have the same
        number of values as the array passed in for the radii argument.
        radii : An array of ValueInput objects that define the radii at positions along the edge(s).
        This array must have the same number of values as the array passed in for
        the positions argument. If the ValueInput uses a real then it is interpreted as centimeters.
        If it is a string then the units can be defined as part of the string (i.e. "2 in").
        If no units are specified it will be interpreted using the current default units for length.
        Returns true if the edge set was successfully added to the FilletFeatureInput.
        """
        return bool()
    def addChordLengthEdgeSet(self, edges: core.ObjectCollection, chordLength: core.ValueInput, isTangentChain: bool) -> bool:
        """
        Adds a set of edges with a chord length to this input.
        edges : An ObjectCollection containing the edges to be filleted. If the isTangentChain argument is true
        additional edges may also get filleted if they are tangentially connected to any of the
        input edges.
        chordLength : A ValueInput object that defines the chord length of the fillet. If the ValueInput uses
        a real then it is interpreted as centimeters. If it is a string then the units
        can be defined as part of the string (i.e. "2 in") or if no units are specified
        it is interpreted using the current default units for length.
        isTangentChain : A boolean value for setting whether or not edges that are tangentially connected to
        the input edges (if any) will also be filleted.
        Returns true if the set of edges was successfully added to the FilletFeatureInput.
        """
        return bool()
    @property
    def isG2(self) -> bool:
        """
        Gets and sets if the fillet uses the G2 (curvature-continuity) surface quality option .
        """
        return bool()
    @isG2.setter
    def isG2(self, value: bool):
        """
        Gets and sets if the fillet uses the G2 (curvature-continuity) surface quality option .
        """
        pass
    @property
    def isRollingBallCorner(self) -> bool:
        """
        Gets and sets if a rolling ball or setback solution is to be used in any corners.
        """
        return bool()
    @isRollingBallCorner.setter
    def isRollingBallCorner(self, value: bool):
        """
        Gets and sets if a rolling ball or setback solution is to be used in any corners.
        """
        pass
    @property
    def isTangentChain(self) -> bool:
        """
        Gets and sets if any edges that are tangentially connected to any of filleted
        edges will also be included in the fillet.
        """
        return bool()
    @isTangentChain.setter
    def isTangentChain(self, value: bool):
        """
        Gets and sets if any edges that are tangentially connected to any of filleted
        edges will also be included in the fillet.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class FilletFeatures(core.Base):
    """
    Collection that provides access to all of the existing fillet features in a component
    and supports the ability to create new fillet features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FilletFeatures:
        return FilletFeatures()
    def item(self, index: int) -> FilletFeature:
        """
        Function that returns the specified fillet feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return FilletFeature()
    def createInput(self) -> FilletFeatureInput:
        """
        Creates a FilletFeatureInput object. Use properties and methods on this object
        to define the fillet you want to create and then use the Add method, passing in
        the FilletFeatureInput object.
        Returns the newly created FilletFeatureInput object or null if the creation failed.
        """
        return FilletFeatureInput()
    def add(self, input: FilletFeatureInput) -> FilletFeature:
        """
        Creates a new fillet feature.
        input : A FilletFeatureInput object that defines the desired fillet. Use the createInput
        method to create a new FilletFeatureInput object and then use methods on it
        (the FilletFeatureInput object) to define the fillet.
        Returns the newly created FilletFeature object or null if the creation failed.
        """
        return FilletFeature()
    def itemByName(self, name: str) -> FilletFeature:
        """
        Function that returns the specified fillet feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return FilletFeature()
    @property
    def count(self) -> int:
        """
        The number of fillet features in the collection.
        """
        return int()

class FlangeFeatures(core.Base):
    """
    Collection that provides access to all of the existing flange features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FlangeFeatures:
        return FlangeFeatures()
    def item(self, index: int) -> FlangeFeature:
        """
        Function that returns the specified flange feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return FlangeFeature()
    def itemByName(self, name: str) -> FlangeFeature:
        """
        Function that returns the specified flange feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return FlangeFeature()
    @property
    def count(self) -> int:
        """
        The number of flange features in the collection.
        """
        return int()

class FormFeatures(core.Base):
    """
    Collection that provides access to all of the existing Form features in a component.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FormFeatures:
        return FormFeatures()
    def item(self, index: int) -> FormFeature:
        """
        Function that returns the specified Form feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return FormFeature()
    def itemByName(self, name: str) -> FormFeature:
        """
        Function that returns the specified form feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return FormFeature()
    def add(self) -> FormFeature:
        """
        Creates a new empty form feature in the parent component.
        Returns the new FormFeature or null in the case of an error.
        """
        return FormFeature()
    @property
    def count(self) -> int:
        """
        The number of Form features in the collection.
        """
        return int()

class GeometricConstraint(core.Base):
    """
    The base class for all geometric constraints.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> GeometricConstraint:
        return GeometricConstraint()
    def deleteMe(self) -> bool:
        """
        Deletes this constraint. The IsDeletable property can be used to determine if this
        constraint can be deleted.
        Returns true if the delete was successful.
        """
        return bool()
    @property
    def isDeletable(self) -> bool:
        """
        Indicates if this constraint is deletable.
        """
        return bool()
    @property
    def parentSketch(self) -> Sketch:
        """
        Returns the parent sketch object.
        """
        return Sketch()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this geometric constraint.
        """
        return core.Attributes()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the GeometricConstraint object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same geometric constraint.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class GeometricConstraintList(core.Base):
    """
    A list of geometric constraints.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> GeometricConstraintList:
        return GeometricConstraintList()
    def item(self, index: int) -> GeometricConstraint:
        """
        Function that returns the specified geometry constraint using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return GeometricConstraint()
    @property
    def count(self) -> int:
        """
        Returns the number of constraints in the sketch.
        """
        return int()

class GeometricConstraints(core.Base):
    """
    A collection of all of the geometric constraints in a sketch. This object
    also supports the methods to create new geometric constraints.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> GeometricConstraints:
        return GeometricConstraints()
    def item(self, index: int) -> GeometricConstraint:
        """
        Function that returns the specified sketch constraint using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return GeometricConstraint()
    def addCoincident(self, point: SketchPoint, entity: SketchEntity) -> CoincidentConstraint:
        """
        Creates a new coincident constraint between two entities. The first argument
        is a sketch point. The second argument is a sketch curve or point.
        point : The SketchPoint that will be made coincident.
        entity : The SketchPoint or sketch curve that the point will be made coincident to.
        Returns the newly created CoincidentConstraint object or null if the creation failed.
        """
        return CoincidentConstraint()
    def addCollinear(self, lineOne: SketchLine, lineTwo: SketchLine) -> CollinearConstraint:
        """
        Creates a new collinear constraint between two lines.
        lineOne : The first line to create the constraint on.
        lineTwo : The second line to create the constraint on.
        Returns the newly created CollinearConstraint object or null if the creation failed.
        """
        return CollinearConstraint()
    def addConcentric(self, entityOne: SketchCurve, entityTwo: SketchCurve) -> ConcentricConstraint:
        """
        Creates a new concentric constraint between two circles, arcs, ellipses, or elliptical arcs.
        entityOne : The first circle, arc, ellipse or elliptical arc.
        entityTwo : The second circle, arc, ellipse or elliptical arc.
        Returns the newly created ConcentricConstraint object or null if the creation failed.
        """
        return ConcentricConstraint()
    def addMidPoint(self, point: SketchPoint, midPointCurve: SketchCurve) -> MidPointConstraint:
        """
        Creates a new midpoint constraint between a point and a curve.
        point : The point to constrain to the midpoint of a curve.
        midPointCurve : The curve that defines the midpoint to constraint to.
        Returns the newly created MidPointConstraint object or null if the creation failed.
        """
        return MidPointConstraint()
    def addParallel(self, lineOne: SketchLine, lineTwo: SketchLine) -> ParallelConstraint:
        """
        Creates a new parallel constraint between two lines.
        lineOne : The first SketchLine.
        lineTwo : The second SketchLine.
        Returns the newly created ParallelConstraint object or null if the creation failed.
        """
        return ParallelConstraint()
    def addPerpendicular(self, lineOne: SketchLine, lineTwo: SketchLine) -> PerpendicularConstraint:
        """
        Creates a new perpendicular constraint between two lines.
        lineOne : The first SketchLine.
        lineTwo : The second SketchLine.
        Returns the newly created PerpendicularConstraint object or null if the creation failed.
        """
        return PerpendicularConstraint()
    def addHorizontal(self, line: SketchLine) -> HorizontalConstraint:
        """
        Creates a new horizontal constraint on a line.
        line : The line to constrain horizontally.
        Returns the newly created HorizontalConstraint object or null if the creation failed.
        """
        return HorizontalConstraint()
    def addHorizontalPoints(self, pointOne: SketchPoint, pointTwo: SketchPoint) -> HorizontalPointsConstraint:
        """
        Creates a new horizontal constraint between two points.
        pointOne : The first SketchPoint to constrain horizontally.
        pointTwo : The second SketchPoint to constrain horizontally.
        Returns the newly created HorizontalPointsConstraint object or null if the creation failed.
        """
        return HorizontalPointsConstraint()
    def addVertical(self, line: SketchLine) -> VerticalConstraint:
        """
        Creates a new vertical constraint on a line.
        line : The line to constrain vertically.
        Returns the newly created VerticalConstraint object or null if the creation failed.
        """
        return VerticalConstraint()
    def addVerticalPoints(self, pointOne: SketchPoint, pointTwo: SketchPoint) -> VerticalPointsConstraint:
        """
        Creates a new vertical constraint between two points.
        pointOne : The first SketchPoint to constrain vertically.
        pointTwo : The second SketchPoint to constrain vertically.
        Returns the newly created VerticalPointsConstraint object or null if the creation failed.
        """
        return VerticalPointsConstraint()
    def addTangent(self, curveOne: SketchCurve, curveTwo: SketchCurve) -> TangentConstraint:
        """
        Creates a new tangent constraint between two curves.
        curveOne : The first curve to be tangent.
        curveTwo : The second curve to be tangent.
        Returns the newly created TangentConstraint object or null if the creation failed.
        """
        return TangentConstraint()
    def addSmooth(self, curveOne: SketchCurve, curveTwo: SketchCurve) -> SmoothConstraint:
        """
        Creates a new smooth constraint between two curves. One of the curves
        must be a spline. The other curve can be a spline or an arc.
        curveOne : The first curve to be constrained to be smooth to the second curve.
        curveTwo : The second curve to be constrained to be smooth to the first curve.
        Returns the newly created SmoothConstraint object or null if the creation failed.
        """
        return SmoothConstraint()
    def addEqual(self, curveOne: SketchCurve, curveTwo: SketchCurve) -> EqualConstraint:
        """
        Creates a new equal constraint between two lines, or between arcs and circles.
        curveOne : The first line, arc, or circle.
        curveTwo : The second line, arc, or circle.
        Returns the newly created EqualConstraint object or null if the creation failed.
        """
        return EqualConstraint()
    def addSymmetry(self, entityOne: SketchEntity, entityTwo: SketchEntity, symmetryLine: SketchLine) -> SymmetryConstraint:
        """
        Creates a new symmetry constraint.
        entityOne : The first sketch entity to be symmetric.
        entityTwo : The second sketch entity to be symmetric. It must be the same type as the first entity.
        symmetryLine : The SketchLine that defines the axis of symmetry.
        Returns the newly created SymmetryConstraint object or null if the creation failed.
        """
        return SymmetryConstraint()
    @property
    def count(self) -> int:
        """
        Returns the number of constraints in the sketch.
        """
        return int()

class HoleFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a hole
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> HoleFeatureInput:
        return HoleFeatureInput()
    def setPositionByPoint(self, planarEntity: core.Base, point: core.Base) -> bool:
        """
        Defines the position of a the hole using a point. The point can be a vertex on the face
        or it can be a Point3D object to define any location on the face. If a Point3D object is
        provided it will be projected onto the plane along the planes normal. The orientation of the
        hole is defined by the planar face or construction plane. If a vertex is used, the position of
        the hole is associative to that vertex. If a Point3D object is used the position of the hole
        is not associative.
        planarEntity : The planar BRepFace or ConstructionPlane object that defines the orientation of the hole.
        The natural direction of the hole will be opposite the normal of the face or construction plane.
        point : A Point3D object or vertex that defines the position of the hole. The point will be projected
        onto the plane along the normal of the plane.
        Returns true if successful.
        """
        return bool()
    def setPositionAtCenter(self, planarEntity: core.Base, centerEdge: BRepEdge) -> bool:
        """
        Defines the position of the hole at the center of a circular or elliptical edge of the face.
        planarEntity : The planar BRepFace or ConstructionPlane object that defines the orientation of the hole.
        The natural direction of the hole will be opposite the normal of the face or construction plane.
        centerEdge : A circular or elliptical edge whose center point will be the position of the hole.
        Returns true if successful.
        """
        return bool()
    def setPositionBySketchPoint(self, sketchPoint: SketchPoint) -> bool:
        """
        Defines the position and orientation of the hole using a sketch point.
        sketchPoint : The sketch point that defines the position of the hole. The orientation is
        inferred from the normal of the point's parent sketch. The natural direction will be
        opposite the normal of the sketch.
        Returns true if successful.
        """
        return bool()
    def setPositionByPlaneAndOffsets(self, planarEntity: core.Base, point: core.Point3D, edgeOne: BRepEdge, offsetOne: core.ValueInput, edgeTwo: BRepEdge, offsetTwo: core.ValueInput) -> bool:
        """
        Defines the orientation of the hole using a planar face or construction plane.
        The position of the hole is defined by the distance from one or two edges.
        planarEntity : The planar BRepFace or ConstructionPlane object that defines the orientation of the hole.
        The natural direction of the hole will be opposite the normal of the face or construction plane.
        point : A Point3D object that defines the approximate initial position of the hole. The point will be
        projected onto the plane. This point should be close to the final position of the hole and
        is used to determine which solution out of several possible solutions should be chosen
        for the hole location.
        edgeOne : A linear BRepEdge object that the position of the hole will be measured from. The position
        of the hole will be measured along a perpendicular from this edge.
        offsetOne : A ValueInput object that defines the offset distance from edgeOne. If the ValueInput uses
        a real then it is interpreted as centimeters. If it is a string then the units
        can be defined as part of the string (i.e. "3 in"). If no units are specified
        it is interpreted using the current default units for length.
        edgeTwo : You can optionally define a second edge and offset to specify the position of the hole. If you use a
        second edge it has the same requirements as the edgeOne argument. If you provide a second edge you
        must also provide the offsetTwo argument.
        offsetTwo : If edgeTwo is defined, you must provide this argument which is a ValueInput object that
        defines the offset from the edgeTwo. If the ValueInput uses a real then it is interpreted
        as centimeters. If it is a string then the units can be defined as part of the string
        (i.e. "3 in"). If no units are specified it is interpreted using the current default units
        for length.
        Returns true if successful.
        """
        return bool()
    def setPositionOnEdge(self, planarEntity: core.Base, edge: BRepEdge, position: HoleEdgePositions) -> bool:
        """
        Defines the position and orientation of the hole to be on the start, end or center of an edge.
        planarEntity : The planar BRepFace or ConstructionPlane object that defines the orientation of the hole
        and start of the hole. The natural direction of the hole will be opposite the normal of
        the face or construction plane.
        edge : The edge to position the hole on.
        position : The position along the edge to place the hole.
        Returns true if successful.
        """
        return bool()
    def setDistanceExtent(self, distance: core.ValueInput) -> bool:
        """
        Defines the depth of the hole using a specified distance.
        distance : The depth of the hole. If a real is specified the value is in centimeters.
        If a string is specified the units are derived from the string. If no units are specified,
        the default units of the document are used.
        Returns true if setting the extent was successful.
        """
        return bool()
    def setAllExtent(self, direction: ExtentDirections) -> bool:
        """
        Defines the extent of the hole to be through-all. The direction can be
        either positive, negative.
        direction : The direction of the hole relative to the normal of the sketch plane.
        Returns true if successful.
        """
        return bool()
    def setOneSideToExtent(self, toEntity: core.Base, matchShape: bool, directionHint: core.Vector3D) -> bool:
        """
        Sets the extent of the hole to be from the sketch plane to the specified "to" face.
        toEntity : The entity that defines the "to" extent. The valid types of entities can vary depending on
        the type of feature this is being used with. For a hole it can be a BRepBody, BRepFace,
        BRepVertex, ConstructionPlane, or ConstructionPoint.
        matchShape : Indicates if the hole is not contained on the face that the hole should match
        the shape of the entity as if it extended beyond it's current boundaries.
        directionHint : Specifies the direction of the hole. This is only used in the case where there are two possible solutions and the hole can
        hit the toEntity in either direction.
        
        Typically there is only a single solution and the direction is determined automatically.
        Returns true if successful.
        """
        return bool()
    def setPositionBySketchPoints(self, sketchPoints: core.ObjectCollection) -> bool:
        """
        Defines the position and orientation of the hole using a set of sketch points.
        sketchPoints : A collection of sketch points that defines the positions of the holes. The orientation is
        inferred from the normal of the point's parent sketch. The natural direction will be
        opposite the normal of the sketch. The points can be from multiple sketches but they
        must all be co-planar.
        Returns true if successful.
        """
        return bool()
    @property
    def tipAngle(self) -> core.ValueInput:
        """
        Gets the ValueInput object that defines the angle of the tip of the hole. The default
        is "118.0 deg" but can be modified by setting it using another Value object.
        """
        return core.ValueInput()
    @tipAngle.setter
    def tipAngle(self, value: core.ValueInput):
        """
        Gets the ValueInput object that defines the angle of the tip of the hole. The default
        is "118.0 deg" but can be modified by setting it using another Value object.
        """
        pass
    @property
    def isDefaultDirection(self) -> bool:
        """
        Gets or sets if the hole goes in the default direction or is reversed.
        """
        return bool()
    @isDefaultDirection.setter
    def isDefaultDirection(self, value: bool):
        """
        Gets or sets if the hole goes in the default direction or is reversed.
        """
        pass
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Hole is created based on geometry (e.g. a face or point)
        in another component AND (the Hole) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        A value of null indicates that everything is in the context of a single component.
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Hole is created based on geometry (e.g. a face or point)
        in another component AND (the Hole) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        A value of null indicates that everything is in the context of a single component.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass
    @property
    def participantBodies(self) -> list[BRepBody]:
        """
        Gets and sets the list of bodies that will participate in the hole.
        
        If this property has not been set, the default behavior is that all bodies that are intersected by the
        hole will participate.
        
        This property can return null in the case where the feature has not been fully defined so that
        possible intersecting bodies can be computed.
        """
        return [BRepBody()]
    @participantBodies.setter
    def participantBodies(self, value: list[BRepBody]):
        """
        Gets and sets the list of bodies that will participate in the hole.
        
        If this property has not been set, the default behavior is that all bodies that are intersected by the
        hole will participate.
        
        This property can return null in the case where the feature has not been fully defined so that
        possible intersecting bodies can be computed.
        """
        pass

class HoleFeatures(core.Base):
    """
    Collection that provides access to all of the existing hole features in a component
    and supports the ability to create new hole features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> HoleFeatures:
        return HoleFeatures()
    def item(self, index: int) -> HoleFeature:
        """
        Function that returns the specified hole feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return HoleFeature()
    def createSimpleInput(self, holeDiameter: core.ValueInput) -> HoleFeatureInput:
        """
        Creates a HoleFeatureInput object that defines a simple hole (a single diameter).
        This is not a hole feature, but an object used to create a hole feature. Functionality
        on the returned HoleFeatureInput object is used to define the position and extent
        of the hole.
        holeDiameter : A ValueInput object that defines the diameter of the hole. If the ValueInput uses
        a real, it is interpreted as centimeters. If it is a string, the units
        can be defined as part of the string (i.e. "3 in") If no units are specified,
        it is interpreted using the current default units for length.
        Returns the newly created HoleFeatureInput object or null if the creation failed.
        """
        return HoleFeatureInput()
    def createCounterboreInput(self, holeDiameter: core.ValueInput, counterboreDiameter: core.ValueInput, counterboreDepth: core.ValueInput) -> HoleFeatureInput:
        """
        Creates a HoleFeatureInput object that defines a counterbore hole. This is not
        a hole feature but an object used to create a hole feature. Functionality
        on the returned HoleFeatureInput object is used to define the position and extent
        of the hole.
        holeDiameter : A ValueInput object that defines the diameter of the hole. If the ValueInput uses
        a real, it is interpreted as centimeters. If it is a string, the units
        can be defined as part of the string (i.e. "3 in") If no units are specified,
        it is interpreted using the current default units for length.
        counterboreDiameter : A ValueInput object that defines the counterbore diameter of the hole. If the ValueInput uses
        a real, it is interpreted as centimeters. If it is a string, the units
        can be defined as part of the string (i.e. "3 in") If no units are specified,
        it is interpreted using the current default units for length.
        counterboreDepth : A ValueInput object that defines the counterbore depth of the hole. If the ValueInput uses
        a real, it is interpreted as centimeters. If it is a string, the units
        can be defined as part of the string (i.e. "3 in") If no units are specified,
        it is interpreted using the current default units for length.
        Returns the newly created HoleFeatureInput object or null if the creation failed.
        """
        return HoleFeatureInput()
    def createCountersinkInput(self, holeDiameter: core.ValueInput, countersinkDiameter: core.ValueInput, countersinkAngle: core.ValueInput) -> HoleFeatureInput:
        """
        Creates a HoleFeatureInput object that defines a countersink hole. This is not
        a hole feature but an object used to create a hole feature. Functionality
        on the returned HoleFeatureInput object is used to define the position and extent of the hole.
        holeDiameter : A ValueInput object that defines the diameter of the hole. If the ValueInput uses
        a real, it is interpreted as centimeters. If it is a string, the units
        can be defined as part of the string (i.e. "3 in") If no units are specified,
        it is interpreted using the current default units for length.
        countersinkDiameter : A ValueInput object that defines the diameter of the countersink. If the ValueInput uses
        a real, it is interpreted as centimeters. If it is a string, the units
        can be defined as part of the string (i.e. "3 in") If no units are specified,
        it is interpreted using the current default units for length.
        countersinkAngle : A ValueInput object that defines the angle of the countersink. If the ValueInput uses
        a real then it is interpreted as radians. If it is a string then the units
        can be defined as part of the string (i.e. "120 deg"). If no units are specified
        it is interpreted using the current default units for angles.
        Returns the newly created HoleFeatureInput object or null if the creation failed.
        """
        return HoleFeatureInput()
    def add(self, input: HoleFeatureInput) -> HoleFeature:
        """
        Creates a new hole feature based on the information provided by a HoleFeatureInput object.
        To create a new hole, use one of the createInput functions to define a new input object for
        the type of hole you want to create. Use the methods and properties on the input object
        to define any additional input. Once the information is defined on the input object, you
        can pass it to the Add method to create the hole.
        input : The HoleFeatureInput object that defines the hole you want to create.
        Returns the newly created HoleFeature or null if the creation failed.
        """
        return HoleFeature()
    def itemByName(self, name: str) -> HoleFeature:
        """
        Function that returns the specified hole feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return HoleFeature()
    @property
    def count(self) -> int:
        """
        The number of hole features in the collection.
        """
        return int()

class HolePositionDefinition(core.Base):
    """
    The base class for the classes that define how a hole can be positioned.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> HolePositionDefinition:
        return HolePositionDefinition()

class InterferenceInput(core.Base):
    """
    Used to gather and define the various inputs and settings needed to calculate interference. This
    object is created using the Design.createInterferenceInput method.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> InterferenceInput:
        return InterferenceInput()
    @property
    def entities(self) -> core.ObjectCollection:
        """
        Gets and set an ObjectCollection containing BRepBody and/or Occurrence entities that
        will be used when checking for interference. All entities must be in the context of
        the root component of the top-level design.
        """
        return core.ObjectCollection()
    @entities.setter
    def entities(self, value: core.ObjectCollection):
        """
        Gets and set an ObjectCollection containing BRepBody and/or Occurrence entities that
        will be used when checking for interference. All entities must be in the context of
        the root component of the top-level design.
        """
        pass
    @property
    def areCoincidentFacesIncluded(self) -> bool:
        """
        Gets and sets whether any coincident faces in the input bodies are considered as interference
        or not. This property defaults to False for a newly created InterferenceInput object.
        """
        return bool()
    @areCoincidentFacesIncluded.setter
    def areCoincidentFacesIncluded(self, value: bool):
        """
        Gets and sets whether any coincident faces in the input bodies are considered as interference
        or not. This property defaults to False for a newly created InterferenceInput object.
        """
        pass

class InterferenceResult(core.Base):
    """
    Represents the interference between bodies and/or occurrences in an interference analysis.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> InterferenceResult:
        return InterferenceResult()
    @property
    def entityOne(self) -> core.Base:
        """
        Returns the first entity involved in the interference
        """
        return core.Base()
    @property
    def entityTwo(self) -> core.Base:
        """
        Returns the second entity involved in the interference
        """
        return core.Base()
    @property
    def interferenceBody(self) -> BRepBody:
        """
        Returns a transient BRepBody that represents the volume of interference.
        """
        return BRepBody()
    @property
    def isCreateBody(self) -> bool:
        """
        Gets and sets if this interference volume should be created as a model body. Setting
        this to true doesn't create the body just indicates that a body is desired. Calling
        the createBodies method on the interferenceResults object will result in the creation
        of the model body if this property is true.
        """
        return bool()
    @isCreateBody.setter
    def isCreateBody(self, value: bool):
        """
        Gets and sets if this interference volume should be created as a model body. Setting
        this to true doesn't create the body just indicates that a body is desired. Calling
        the createBodies method on the interferenceResults object will result in the creation
        of the model body if this property is true.
        """
        pass

class InterferenceResults(core.Base):
    """
    Transient object used to return the result of an interference analysis.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> InterferenceResults:
        return InterferenceResults()
    def item(self, index: int) -> InterferenceResult:
        """
        Function that returns the specified interference result using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return InterferenceResult()
    def createBodies(self, allInterferenceBodies: bool) -> core.ObjectCollection:
        """
        Creates bodies in the model that represent the interference volumes.
        This is not supported in parametric modeling.
        allInterferenceBodies : Sets if all bodies or only individual bodies will be created as bodies in the model.
        If False, then only interferenceResult objects whose isCreateBody property is true
        will be created as a model body. If true, all interface volumes will be created as
        a body regardless of the value of the isCreateBody property on each InterferenceResult object.
        Returns an ObjectCollection containing the bodies that were created.
        """
        return core.ObjectCollection()
    @property
    def count(self) -> int:
        """
        Returns the number of interference results in the collection.
        """
        return int()

class Joint(core.Base):
    """
    A joint in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Joint:
        return Joint()
    def deleteMe(self) -> bool:
        """
        Deletes this joint.
        Returns true if the delete is successful.
        """
        return bool()
    def setAsRigidJointMotion(self) -> bool:
        """
        Redefines the relationship between the two joint geometries as a rigid joint.
        
        To use this method, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        Returns true if successful.
        """
        return bool()
    def setAsRevoluteJointMotion(self, rotationAxis: JointDirections, customRotationAxisEntity: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a revolute joint.
        
        To use this method, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        from.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsSliderJointMotion(self, sliderDirection: JointDirections, customSliderDirectionEntity: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a slider joint.
        
        To use this method, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        sliderDirection : Specifies which axis the slide direction is along. If this is set to CustomJointDirection then the
        customSliderDirectionEntity argument must also be provided.
        customSliderDirectionEntity : If the sliderDirection is CustomJointDirection this argument is used to specify the entity that defines
        the custom slider direction. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsCylindricalJointMotion(self, rotationAxis: JointDirections, customRotationAxisEntity: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a cylindrical joint.
        
        To use this method, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        from.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsPinSlotJointMotion(self, rotationAxis: JointDirections, slideDirection: JointDirections, customRotationAxisEntity: core.Base, customSlideDirectionEntity: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a pin-slot joint.
        
        To use this method, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        slideDirection : Specifies which axis the slide direction is along. If this is set to CustomJointDirection then the
        customSlideDirectionEntity argument must also be provided.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        customSlideDirectionEntity : If the slideDirection is CustomJointDirection this argument is used to specify the entity that defines
        the custom slide direction. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsPlanarJointMotion(self, normalDirection: JointDirections, customNormalDirectionEntity: core.Base, customPrimarySlideDirection: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a planar joint.
        
        To use this method, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        normalDirection : Defines the direction of the normal of the single degree of rotation.
        This can be set to XAxisJointDirection, YAxisJointDirection, ZAxisJointDirection,
        or CustomJointDirection. If set to CustomJointDirection then the customNormalDirectionEntity
        argument must also be provided.
        customNormalDirectionEntity : If the normalDirection is CustomJointDirection this argument is used to specify the entity that defines
        the direction of the normal. This can be several types of entities that can define a direction.
        customPrimarySlideDirection : This arguments defines the direction of the primary slide direction. A default primary slide direction
        is automatically chosen and will be used if this argument is not provided or is null. The secondary slide
        direction is automatically inferred from the normal and primary slide directions.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsBallJointMotion(self, pitchDirection: JointDirections, yawDirection: JointDirections, customPitchDirection: core.Base, customYawDirection: core.Base) -> bool:
        """
        Redefines the relationship between the two joint geometries as a ball joint.
        
        To use this method, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        pitchDirection : Defines the direction the pitch angle is measured from. This can be ZAxisJointDirection or CustomJointDirection. If
        CustomJointDirection is specified then you must also provide a value for the customPitchDirection argument.
        yawDirection : Defines the direction the yaw is measured from. This can be XAxisJointDirection or CustomJointDirection. If
        CustomJointDirection is specified then you must also provide a value for the customYawDirection argument.
        customPitchDirection : If the pitchDirection argument is customPitchDirection this argument is used to define the direction the pitch
        angel is measured from. This can be several types of entities that can define a direction.
        customYawDirection : If the yawDirection argument is customPitchDirection this argument is used to define the direction the yaw
        angel is measured from. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> Joint:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return Joint()
    @property
    def parentComponent(self) -> Component:
        """
        Returns the parent component that owns this joint.
        """
        return Component()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of the joint.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of the joint.
        """
        pass
    @property
    def geometryOrOriginOne(self) -> core.Base:
        """
        Gets and sets the first JointGeometry or JointOrigin for this joint.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        """
        return core.Base()
    @geometryOrOriginOne.setter
    def geometryOrOriginOne(self, value: core.Base):
        """
        Gets and sets the first JointGeometry or JointOrigin for this joint.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        """
        pass
    @property
    def geometryOrOriginTwo(self) -> core.Base:
        """
        Gets and sets the second JointGeometry or JointOrigin for this joint.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        """
        return core.Base()
    @geometryOrOriginTwo.setter
    def geometryOrOriginTwo(self, value: core.Base):
        """
        Gets and sets the second JointGeometry or JointOrigin for this joint.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        """
        pass
    @property
    def angle(self) -> ModelParameter:
        """
        Returns the parameter controlling the angle between the two input geometries. This is effectively the
        angle between the two primary axes of the two joint geometries.
        """
        return ModelParameter()
    @property
    def offset(self) -> ModelParameter:
        """
        Returns the parameter controlling the offset between the two input geometries. This is effectively the
        offset distance between the two planes defined by the primary and secondary axes
        of the input geometries or the offset along the tertiary axis (z axis) of the joint.
        """
        return ModelParameter()
    @property
    def isFlipped(self) -> bool:
        """
        Gets and sets if the joint direction is flipped or not. This is effectively
        specifying if the third axis of the two input geometries is facing (false) or
        opposed (true).
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        """
        return bool()
    @isFlipped.setter
    def isFlipped(self, value: bool):
        """
        Gets and sets if the joint direction is flipped or not. This is effectively
        specifying if the third axis of the two input geometries is facing (false) or
        opposed (true).
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        """
        pass
    @property
    def jointMotion(self) -> JointMotion:
        """
        Returns a JointMotion object that defines the motion relationship between the two geometries.
        """
        return JointMotion()
    @property
    def timelineObject(self) -> TimelineObject:
        """
        Returns the timeline object associated with this joint.
        """
        return TimelineObject()
    @property
    def nativeObject(self) -> Joint:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return Joint()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def isSuppressed(self) -> bool:
        """
        Gets and sets if this joint is suppressed.
        """
        return bool()
    @isSuppressed.setter
    def isSuppressed(self, value: bool):
        """
        Gets and sets if this joint is suppressed.
        """
        pass
    @property
    def isLightBulbOn(self) -> bool:
        """
        Gets and sets if the light bulb of this joint as displayed in the browser is on or off.
        A joint will only be visible if the light bulb is switched on. However,
        the light bulb can be on and the joint still invisible if a higher level occurrence
        in the assembly context is not visible because its light bulb is off or the joints folder
        is light bulb is off.
        """
        return bool()
    @isLightBulbOn.setter
    def isLightBulbOn(self, value: bool):
        """
        Gets and sets if the light bulb of this joint as displayed in the browser is on or off.
        A joint will only be visible if the light bulb is switched on. However,
        the light bulb can be on and the joint still invisible if a higher level occurrence
        in the assembly context is not visible because its light bulb is off or the joints folder
        is light bulb is off.
        """
        pass
    @property
    def isVisible(self) -> bool:
        """
        Gets whether the joint is visible. To change the visibility see the isLightBulbOn property.
        This property is affected by the assembly context.
        """
        return bool()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this joint.
        """
        return core.Attributes()
    @property
    def healthState(self) -> FeatureHealthStates:
        """
        Returns the current health state of the joint.
        """
        return FeatureHealthStates()
    @property
    def errorOrWarningMessage(self) -> str:
        """
        Returns the error or warning message in the case where the healthState property returns either
        WarningFeatureHealthState or ErrorFeatureHealthState. Otherwise this property returns an empty string.
        """
        return str()
    @property
    def occurrenceOne(self) -> Occurrence:
        """
        Returns the first of two occurrences that this joint defines a relationship between. This is the occurrence
        that can also be found through the geometryOrOriginOne property.
        """
        return Occurrence()
    @property
    def occurrenceTwo(self) -> Occurrence:
        """
        Returns the first of two occurrences that this joint defines a relationship between. This is the occurrence
        that can also be found through the geometryOrOriginTwo property.
        """
        return Occurrence()
    @property
    def isLocked(self) -> bool:
        """
        Gets and sets if the joint is locked.
        """
        return bool()
    @isLocked.setter
    def isLocked(self, value: bool):
        """
        Gets and sets if the joint is locked.
        """
        pass
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the Joint object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same joint.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class JointGeometry(core.Base):
    """
    A transient object used to define and query the geometric input of a joint and the resulting coordinate
    system it defines. New JointGeometry objects are created using its various static create methods and
    are then used as input to the Joints.createInput method.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> JointGeometry:
        return JointGeometry()
    @staticmethod
    def createByPlanarFace(face: BRepFace, edge: BRepEdge, keyPointType: JointKeyPointTypes) -> JointGeometry:
        """
        Creates a new transient JointGeometry object based on a planar BRepFace object. A JointGeometry
        object can be used to create a joint or joint origin.
        face : The planar BRepFace object
        edge : A BRepEdge edge object that is one of the edges of the specified face. This argument can be
        null in the case where the keyPointType is CenterKeypoint indicating the center of the face
        is to be used. When an edge is used, the keyPointType specifies the position along the edge
        for the keypoint.
        keyPointType : Specifies the position along the edge where the joint keypoint will be located. For open edges
        this can be StartKeyPoint, MiddleKeyPoint, or EndKeyPoint. For closed edges (i.e. circles), it
        must be CenterKeyPoint. When no edge is specified, it must be CenterKeyPoint indicating the center
        of area of the face is to be used.
        Returns the transient JointGeometry object that can be used to create a joint or joint origin or null in case of a failure.
        """
        return JointGeometry()
    @staticmethod
    def createByNonPlanarFace(face: BRepFace, keyPointType: JointKeyPointTypes) -> JointGeometry:
        """
        Creates a new transient JointGeometry object based on a non-planar analytical BRepFace object. This is limited
        to cylinders, cones, spheres, and tori. A JointGeometry object can be used to create a joint or joint origin.
        face : The cylindrical, conical, spherical, or toroidal BRepFace object.
        keyPointType : Specifies the position relative to the input face where joint keypoint will be located. For cylinders
        and cones this can be StartKeyPoint, MiddleKeyPoint, or EndKeyPoint. For spheres and tori this must be
        CenterKeyPoint.
        Returns the transient JointGeometry object that can be used to create a joint or joint origin or null in case of a failure.
        """
        return JointGeometry()
    @staticmethod
    def createByProfile(profile: Profile, sketchCurve: SketchCurve, keyPointType: JointKeyPointTypes) -> JointGeometry:
        """
        Creates a new transient JointGeometry object based on a planar BRepFace object. A JointGeometry
        object can be used to create a joint or joint origin.
        profile : The Profile object.
        sketchCurve : A sketch curve that is part of the input profile. This argument can be
        null in the case where the keyPointType is CenterKeypoint indicating the center of the profile
        is to be used. When a curve is used, the keyPointType specifies the position along the curve
        for the keypoint.
        keyPointType : Specifies the position along the curve where the joint keypoint will be located. For open curves (lines, arcs, elliptical arcs, and open splines)
        this can be StartKeyPoint, MiddleKeyPoint, or EndKeyPoint. For closed analytic (circles and ellipses), it
        must be CenterKeyPoint. When no curve is specified, it must be CenterKeyPoint indicating the center
        of area of the profile is to be used.
        Returns the transient JointGeometry object that can be used to create a joint or joint origin or null in case of a failure.
        """
        return JointGeometry()
    @staticmethod
    def createByCurve(curve: core.Base, keyPointType: JointKeyPointTypes) -> JointGeometry:
        """
        Creates a new transient JointGeometry object using a BRepEdge or SketchCurve as input. A JointGeometry
        object can be used to create a joint or joint origin.
        curve : Input BRepEdge or SketchCurve.
        keyPointType : The position on the curve where to position the joint coordinate system. For any open curves
        the valid types are StartKeyPoint, MiddleKeyPoint, CenterKeyPoint and EndKeyPoint. For circular and elliptical
        shaped curves the option is CenterKeyPoint. For closed spline curves either StartKeyPoint or
        EndKeyPoint can be used and the result is the same.
        Returns the transient JointGeometry object that can be used to create a joint or joint origin or null in case of a failure.
        """
        return JointGeometry()
    @staticmethod
    def createByPoint(point: core.Base) -> JointGeometry:
        """
        Creates a new transient JointGeometry object using a ConstructionPoint, SketchPoint or BRepVertex as input.
        A JointGeometry object can be used to create a joint or joint origin.
        point : The ConstructionPoint, SketchPoint or BRepVertex object.
        Returns the transient JointGeometry object that can be used to create a joint or joint origin or null in case of a failure.
        """
        return JointGeometry()
    @staticmethod
    def createByBetweenTwoPlanes(planeOne: core.Base, planeTwo: core.Base, entityOne: core.Base, entityTwo: core.Base, keyPointType: JointKeyPointTypes) -> JointGeometry:
        """
        Creates a new transient JointGeometry object based on a plane bisecting the two input planes.
        planeOne : The first planar entity that the joint origin will be created between. This can be a planar BRepFace
        or a ConstructionPlane object.
        planeTwo : The second planar entity that the joint origin will be created between. This can be a planar BRepFace
        or a ConstructionPlane object.
        entityOne : Specifies the entity that is used to define the keypoint. This can be many types of geometry including
        edges, planar and non-planar faces, profiles, and sketch geometry.
        entityTwo : If the entityOne argument is a planar BRepFace or a Profile, then this argument specifies either
        an edge on the face or a sketch curve on the profile. For a planar face this argument is optional in the
        case where the keyPointType argument is CenterKeyPoint indicating the center of area of the face is to be used.
        keyPointType : Specifies the position on the keyPointGeometry where the keypoint will be defined. This keypoint is then
        projected onto the plane to define the position of the joint geometry.
        
        The values that are valid for this argument depend on the type of geometry specified for the geometry and edgeOrCurve
        arguments.
        
        If the geometry argument is a planar face and the edgeOrCurve argument is an open BRepEdge object
        then this can be StartKeyPoint, MiddleKeyPoint, or EndKeyPoint. If the geometry argument is a planar face and the edgeOrCurve argument
        is a closed BRepEdge object (i.e. circles), it must be CenterKeyPoint. If the geometry argument is a planar face and
        the edgeOrCurve argument is null, then this must be CenterKeyPoint indicating the center of area of the face.
        
        If the geometry argument is a non-planar face (cylinder, cone, sphere, or torus) this can be StartKeyPoint, MiddleKeyPoint, or EndKeyPoint
        for cylinders and cones but must be CenterKeyPoint for spheres and tori. The edgeOrCurve argument is ignored in this case.
        
        If the geometry argument is a profile and the edgeOrCurve argument is null this can be CenterKeyPoint indicating the center of area
        of the profile. If the geometry argument is a profile and the edgeOrCurve argument is an open sketch curve on the profile
        then this can be StartKeyPoint, MiddleKeyPoint, or EndKeyPoint. If the geometry argument is a profile and the edgeOrCurve argument
        is a closed sketch curve (i.e. circles), it must be CenterKeyPoint.
        Returns the transient JointGeometry object that can be used to create a joint or joint origin or null in case of a failure.
        """
        return JointGeometry()
    @property
    def geometryType(self) -> JointGeometryTypes:
        """
        Returns the type of geometry this JointGeometry object represents.
        """
        return JointGeometryTypes()
    @property
    def keyPointType(self) -> JointKeyPointTypes:
        """
        Returns the keypoint type this JointGeometry is using.
        """
        return JointKeyPointTypes()
    @property
    def entityOne(self) -> core.Base:
        """
        The first entity that's defining this joint geometry. This can be various types of geometry depending
        on how this joint geometry is defined. The geometryType property indicates how this joint geometry is
        defined a provides a clue about the type of geometry to expect back from this property.
        """
        return core.Base()
    @property
    def entityTwo(self) -> core.Base:
        """
        This is the second entity that defines this joint geometry. This isn't used for all joint geometry types
        and will return null in the cases where it's not used. A second geometry is used in the case where the geometryType
        property returns JointProfileGeometry, JointPlanarBRepFaceGeometry, JointBetweenTwoFacesGeometry or JointByTwoEdgeIntersectionGeometry.
        """
        return core.Base()
    @property
    def origin(self) -> core.Point3D:
        """
        Returns the origin point that's been calculated for this joint geometry.
        """
        return core.Point3D()
    @property
    def primaryAxisVector(self) -> core.Vector3D:
        """
        Returns the direction of the primary axis that's been calculated for this joint geometry.
        Conceptually, this is the X-axis of the computed coordinate system.
        """
        return core.Vector3D()
    @property
    def secondaryAxisVector(self) -> core.Vector3D:
        """
        Returns the direction of the secondary axis that's been calculated for this joint geometry.
        Conceptually, this is the Y-axis of the computed coordinate system.
        """
        return core.Vector3D()
    @property
    def thirdAxisVector(self) -> core.Vector3D:
        """
        Returns the direction of the third axis that's been calculated for this joint geometry.
        Conceptually, this is the Z-axis of the computed coordinate system.
        """
        return core.Vector3D()
    @property
    def planeOne(self) -> core.Base:
        """
        Returns the first plane for joint geometry that is defined between two planes. Returns null in all other cases.
        """
        return core.Base()
    @property
    def planeTwo(self) -> core.Base:
        """
        Returns the second plane for joint geometry that is defined between two planes. Returns null in all other cases.
        """
        return core.Base()

class JointInput(core.Base):
    """
    Defines all of the information required to create a new joint. This object provides
    equivalent functionality to the Joint command dialog in that it gathers the required
    information to create a joint.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> JointInput:
        return JointInput()
    def setAsRigidJointMotion(self) -> bool:
        """
        Defines the relationship between the two joint geometries as a rigid joint.
        Returns true if successful.
        """
        return bool()
    def setAsRevoluteJointMotion(self, rotationAxis: JointDirections, customRotationAxisEntity: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a revolute joint.
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        from.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsSliderJointMotion(self, sliderDirection: JointDirections, customSliderDirectionEntity: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a slider joint.
        sliderDirection : Specifies which axis the slide direction is along. If this is set to CustomJointDirection then the
        customSliderDirectionEntity argument must also be provided.
        customSliderDirectionEntity : If the sliderDirection is CustomJointDirection this argument is used to specify the entity that defines
        the custom slider direction. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsCylindricalJointMotion(self, rotationAxis: JointDirections, customRotationAxisEntity: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a cylindrical joint.
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        from.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsPinSlotJointMotion(self, rotationAxis: JointDirections, slideDirection: JointDirections, customRotationAxisEntity: core.Base, customSlideDirectionEntity: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a pin-slot joint.
        rotationAxis : Specifies which axis the rotation is around. If this is set to CustomJointDirection then the
        customRotationAxisEntity argument must also be provided.
        slideDirection : Specifies which axis the slide direction is along. If this is set to CustomJointDirection then the
        customSlideDirectionEntity argument must also be provided.
        customRotationAxisEntity : If the rotationAxis is customAxisEntity this argument is used to specify the entity that defines
        the custom axis of rotation. This can be several types of entities that an axis can be derived
        customSlideDirectionEntity : If the slideDirection is CustomJointDirection this argument is used to specify the entity that defines
        the custom slide direction. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsPlanarJointMotion(self, normalDirection: JointDirections, customNormalDirectionEntity: core.Base, customPrimarySlideDirection: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a planar joint.
        normalDirection : Defines the direction of the normal of the single degree of rotation.
        This can be set to XAxisJointDirection, YAxisJointDirection, ZAxisJointDirection,
        or CustomJointDirection. If set to CustomJointDirection then the customNormalDirectionEntity
        argument must also be provided.
        customNormalDirectionEntity : If the normalDirection is CustomJointDirection this argument is used to specify the entity that defines
        the direction of the normal. This can be several types of entities that can define a direction.
        customPrimarySlideDirection : This arguments defines the direction of the primary slide direction. A default primary slide direction
        is automatically chosen and will be used if this argument is not provided or is null. The secondary slide
        direction is automatically inferred from the normal and primary slide directions.
        Returns true if the operation was successful.
        """
        return bool()
    def setAsBallJointMotion(self, pitchDirection: JointDirections, yawDirection: JointDirections, customPitchDirection: core.Base, customYawDirection: core.Base) -> bool:
        """
        Defines the relationship between the two joint geometries as a ball joint.
        pitchDirection : Defines the direction the pitch angle is measured from. This can be ZAxisJointDirection or CustomJointDirection. If
        CustomJointDirection is specified then you must also provide a value for the customPitchDirection argument.
        yawDirection : Defines the direction the yaw is measured from. This can be XAxisJointDirection or CustomJointDirection. If
        CustomJointDirection is specified then you must also provide a value for the customYawDirection argument.
        customPitchDirection : If the pitchDirection argument is customPitchDirection this argument is used to define the direction the pitch
        angel is measured from. This can be several types of entities that can define a direction.
        customYawDirection : If the yawDirection argument is customPitchDirection this argument is used to define the direction the yaw
        angel is measured from. This can be several types of entities that can define a direction.
        Returns true if the operation was successful.
        """
        return bool()
    @property
    def geometryOrOriginOne(self) -> core.Base:
        """
        Gets and sets the first JointGeometry or JointOrigin for this joint.
        """
        return core.Base()
    @geometryOrOriginOne.setter
    def geometryOrOriginOne(self, value: core.Base):
        """
        Gets and sets the first JointGeometry or JointOrigin for this joint.
        """
        pass
    @property
    def geometryOrOriginTwo(self) -> core.Base:
        """
        Gets and sets the second JointGeometry or JointOrigin for this joint.
        """
        return core.Base()
    @geometryOrOriginTwo.setter
    def geometryOrOriginTwo(self, value: core.Base):
        """
        Gets and sets the second JointGeometry or JointOrigin for this joint.
        """
        pass
    @property
    def angle(self) -> core.ValueInput:
        """
        Specifies the angle between two input geometries. This is effectively the
        angle between the two primary axes of the input geometries. When a new
        JointInput object is created, this value defaults to zero. When the joint
        is created this will become the value of the parameter that controls the joint angle.
        
        When using a real value to define the angle, the value is in radians. When
        using a string the expression is evaluated using the document default units for angles.
        """
        return core.ValueInput()
    @angle.setter
    def angle(self, value: core.ValueInput):
        """
        Specifies the angle between two input geometries. This is effectively the
        angle between the two primary axes of the input geometries. When a new
        JointInput object is created, this value defaults to zero. When the joint
        is created this will become the value of the parameter that controls the joint angle.
        
        When using a real value to define the angle, the value is in radians. When
        using a string the expression is evaluated using the document default units for angles.
        """
        pass
    @property
    def offset(self) -> core.ValueInput:
        """
        Specifies the offset between two input geometries. This is effectively the
        offset distance between the two planes defined by the primary and secondary axes
        of the input geometries. When a new JointInput object is created, this value defaults to zero.
        When the joint is created this will become the value of the parameter that controls the joint offset.
        
        When using a real value to define the offset, the value is in centimeters. When
        using a string the expression is evaluated using the document default units for distance.
        """
        return core.ValueInput()
    @offset.setter
    def offset(self, value: core.ValueInput):
        """
        Specifies the offset between two input geometries. This is effectively the
        offset distance between the two planes defined by the primary and secondary axes
        of the input geometries. When a new JointInput object is created, this value defaults to zero.
        When the joint is created this will become the value of the parameter that controls the joint offset.
        
        When using a real value to define the offset, the value is in centimeters. When
        using a string the expression is evaluated using the document default units for distance.
        """
        pass
    @property
    def isFlipped(self) -> bool:
        """
        Gets and sets if the joint direction is flipped or not. This is effectively
        specifying if the third axis of the two input geometries is facing (false) or
        opposed (true).
        """
        return bool()
    @isFlipped.setter
    def isFlipped(self, value: bool):
        """
        Gets and sets if the joint direction is flipped or not. This is effectively
        specifying if the third axis of the two input geometries is facing (false) or
        opposed (true).
        """
        pass
    @property
    def jointMotion(self) -> JointMotion:
        """
        Returns an object derived from JointMotion that defines how the motion between the two joint geometries is defined.
        """
        return JointMotion()

class JointLimits(core.Base):
    """
    Used to define limits for the range of motion of a joint.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> JointLimits:
        return JointLimits()
    @property
    def minimumValue(self) -> float:
        """
        The minimum value of the value. This is in either centimeters
        or radians depending on if the joint value this is associated with
        defines a distance or an angle.
        """
        return float()
    @minimumValue.setter
    def minimumValue(self, value: float):
        """
        The minimum value of the value. This is in either centimeters
        or radians depending on if the joint value this is associated with
        defines a distance or an angle.
        """
        pass
    @property
    def maximumValue(self) -> float:
        """
        The maximum value of the value. This is in either centimeters
        or radians depending on if the joint value this is associated with
        defines a distance or an angle.
        """
        return float()
    @maximumValue.setter
    def maximumValue(self, value: float):
        """
        The maximum value of the value. This is in either centimeters
        or radians depending on if the joint value this is associated with
        defines a distance or an angle.
        """
        pass
    @property
    def restValue(self) -> float:
        """
        The resting state value. This is in either centimeters
        or radians depending on if the joint value this is associated with
        defines a distance or an angle.
        """
        return float()
    @restValue.setter
    def restValue(self, value: float):
        """
        The resting state value. This is in either centimeters
        or radians depending on if the joint value this is associated with
        defines a distance or an angle.
        """
        pass
    @property
    def isMinimumValueEnabled(self) -> bool:
        """
        Gets and sets whether the minimum joint limit is enabled or not.
        """
        return bool()
    @isMinimumValueEnabled.setter
    def isMinimumValueEnabled(self, value: bool):
        """
        Gets and sets whether the minimum joint limit is enabled or not.
        """
        pass
    @property
    def isMaximumValueEnabled(self) -> bool:
        """
        Gets and sets whether the maximum joint limit is enabled or not.
        """
        return bool()
    @isMaximumValueEnabled.setter
    def isMaximumValueEnabled(self, value: bool):
        """
        Gets and sets whether the maximum joint limit is enabled or not.
        """
        pass
    @property
    def isRestValueEnabled(self) -> bool:
        """
        Gets and sets whether the resting joint value is enabled or not.
        """
        return bool()
    @isRestValueEnabled.setter
    def isRestValueEnabled(self, value: bool):
        """
        Gets and sets whether the resting joint value is enabled or not.
        """
        pass

class JointList(core.Base):
    """
    A list of joints.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> JointList:
        return JointList()
    def item(self, index: int) -> Joint:
        """
        Function that returns the specified joint using an index into the list.
        index : The index of the item within the list to return. The first item in the list has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Joint()
    def itemByName(self, name: str) -> Joint:
        """
        Function that returns the specified joint using a name.
        name : The name of the item within the list to return.
        Returns the specified item or null if an invalid name was specified.
        """
        return Joint()
    @property
    def count(self) -> int:
        """
        Returns number of joints in the list.
        """
        return int()

class JointMotion(core.Base):
    """
    The base class for the classes that represent all of the
    various joint types.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> JointMotion:
        return JointMotion()
    @property
    def jointType(self) -> JointTypes:
        """
        Returns an enum value indicating the type of joint this joint represents.
        """
        return JointTypes()

class JointOrigin(core.Base):
    """
    Represents an existing joint origin in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> JointOrigin:
        return JointOrigin()
    def deleteMe(self) -> bool:
        """
        Deletes this joint origin.
        Returns true if successful.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> JointOrigin:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return JointOrigin()
    @property
    def parentComponent(self) -> Component:
        """
        Returns the parent component that owns this joint origin.
        """
        return Component()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of this joint origin. This is the name seen by the user in the timeline.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of this joint origin. This is the name seen by the user in the timeline.
        """
        pass
    @property
    def geometry(self) -> JointGeometry:
        """
        Gets and sets the joint geometry for this joint origin input. This
        defines the location of the joint origin.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: joint.timelineObject.rollTo(True)
        """
        return JointGeometry()
    @geometry.setter
    def geometry(self, value: JointGeometry):
        """
        Gets and sets the joint geometry for this joint origin input. This
        defines the location of the joint origin.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: joint.timelineObject.rollTo(True)
        """
        pass
    @property
    def angle(self) -> ModelParameter:
        """
        Gets the parameter that controls the angle. The value can be changed
        using the functionality of the returned ModelParameter object.
        """
        return ModelParameter()
    @property
    def offsetX(self) -> ModelParameter:
        """
        Gets the parameter that controls the X offset direction. The value can be changed
        using the functionality of the returned ModelParameter object.
        """
        return ModelParameter()
    @property
    def offsetY(self) -> ModelParameter:
        """
        Gets the parameter that controls the Y offset direction. The value can be changed
        using the functionality of the returned ModelParameter object.
        """
        return ModelParameter()
    @property
    def offsetZ(self) -> ModelParameter:
        """
        Gets the parameter that controls the Z offset direction. The value can be changed
        using the functionality of the returned ModelParameter object.
        """
        return ModelParameter()
    @property
    def isFlipped(self) -> bool:
        """
        Gets and sets if the joint origin direction is flipped or not.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: joint.timelineObject.rollTo(True)
        """
        return bool()
    @isFlipped.setter
    def isFlipped(self, value: bool):
        """
        Gets and sets if the joint origin direction is flipped or not.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: joint.timelineObject.rollTo(True)
        """
        pass
    @property
    def xAxisEntity(self) -> core.Base:
        """
        Gets and sets the entity that defines the X axis direction. This defaults
        to null meaning the X axis is inferred from the input geometry.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: joint.timelineObject.rollTo(True)
        """
        return core.Base()
    @xAxisEntity.setter
    def xAxisEntity(self, value: core.Base):
        """
        Gets and sets the entity that defines the X axis direction. This defaults
        to null meaning the X axis is inferred from the input geometry.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: joint.timelineObject.rollTo(True)
        """
        pass
    @property
    def zAxisEntity(self) -> core.Base:
        """
        Gets and sets the entity that defines the Z axis direction. This defaults
        to null meaning the Z axis is inferred from the input geometry.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: joint.timelineObject.rollTo(True)
        """
        return core.Base()
    @zAxisEntity.setter
    def zAxisEntity(self, value: core.Base):
        """
        Gets and sets the entity that defines the Z axis direction. This defaults
        to null meaning the Z axis is inferred from the input geometry.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: joint.timelineObject.rollTo(True)
        """
        pass
    @property
    def primaryAxisVector(self) -> core.Vector3D:
        """
        Returns the direction of the primary axis that's been calculated for this joint origin.
        """
        return core.Vector3D()
    @property
    def secondaryAxisVector(self) -> core.Vector3D:
        """
        Returns the direction of the secondary axis that's been calculated for this joint origin.
        """
        return core.Vector3D()
    @property
    def thirdAxisVector(self) -> core.Vector3D:
        """
        Returns the direction of the third axis that's been calculated for this joint origin.
        """
        return core.Vector3D()
    @property
    def timelineObject(self) -> TimelineObject:
        """
        Returns the timeline object associated with this joint origin.
        """
        return TimelineObject()
    @property
    def nativeObject(self) -> JointOrigin:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return JointOrigin()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this joint origin.
        """
        return core.Attributes()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the JointOrigin object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same joint origin.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class JointOriginInput(core.Base):
    """
    Defines all of the information required to create a new joint origin. This object provides
    equivalent functionality to the Joint Origin command dialog in that it gathers the required
    information to create a joint origin.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> JointOriginInput:
        return JointOriginInput()
    @property
    def geometry(self) -> JointGeometry:
        """
        Gets and sets the joint geometry for this joint origin input. This
        defines the location of the joint origin.
        """
        return JointGeometry()
    @geometry.setter
    def geometry(self, value: JointGeometry):
        """
        Gets and sets the joint geometry for this joint origin input. This
        defines the location of the joint origin.
        """
        pass
    @property
    def angle(self) -> core.ValueInput:
        """
        Gets and sets the value that defines the angle for the joint origin. This defaults to zero
        if it's not specified. The value defines an angle and if the ValueInput is defined using
        the createByReal method the value is assumed to be radians.
        """
        return core.ValueInput()
    @angle.setter
    def angle(self, value: core.ValueInput):
        """
        Gets and sets the value that defines the angle for the joint origin. This defaults to zero
        if it's not specified. The value defines an angle and if the ValueInput is defined using
        the createByReal method the value is assumed to be radians.
        """
        pass
    @property
    def offsetX(self) -> core.ValueInput:
        """
        Gets and sets the value that defines the X offset direction. This defaults to zero
        if it's not specified. The value defines a distance and if the ValueInput is defined using
        the createByReal method the value is assumed to be centimeters.
        """
        return core.ValueInput()
    @offsetX.setter
    def offsetX(self, value: core.ValueInput):
        """
        Gets and sets the value that defines the X offset direction. This defaults to zero
        if it's not specified. The value defines a distance and if the ValueInput is defined using
        the createByReal method the value is assumed to be centimeters.
        """
        pass
    @property
    def offsetY(self) -> core.ValueInput:
        """
        Gets and sets the value that defines the Y offset direction. This defaults to zero
        if it's not specified. The value defines a distance and if the ValueInput is defined using
        the createByReal method the value is assumed to be centimeters.
        """
        return core.ValueInput()
    @offsetY.setter
    def offsetY(self, value: core.ValueInput):
        """
        Gets and sets the value that defines the Y offset direction. This defaults to zero
        if it's not specified. The value defines a distance and if the ValueInput is defined using
        the createByReal method the value is assumed to be centimeters.
        """
        pass
    @property
    def offsetZ(self) -> core.ValueInput:
        """
        Gets and sets the value that defines the Z offset direction. This defaults to zero
        if it's not specified. The value defines a distance and if the ValueInput is defined using
        the createByReal method the value is assumed to be centimeters.
        """
        return core.ValueInput()
    @offsetZ.setter
    def offsetZ(self, value: core.ValueInput):
        """
        Gets and sets the value that defines the Z offset direction. This defaults to zero
        if it's not specified. The value defines a distance and if the ValueInput is defined using
        the createByReal method the value is assumed to be centimeters.
        """
        pass
    @property
    def isFlipped(self) -> bool:
        """
        Gets and sets if the joint origin direction is flipped or not.
        """
        return bool()
    @isFlipped.setter
    def isFlipped(self, value: bool):
        """
        Gets and sets if the joint origin direction is flipped or not.
        """
        pass
    @property
    def xAxisEntity(self) -> core.Base:
        """
        Gets and sets the entity that defines the X axis direction. This defaults
        to null meaning the X axis is inferred from the input geometry.
        """
        return core.Base()
    @xAxisEntity.setter
    def xAxisEntity(self, value: core.Base):
        """
        Gets and sets the entity that defines the X axis direction. This defaults
        to null meaning the X axis is inferred from the input geometry.
        """
        pass
    @property
    def zAxisEntity(self) -> core.Base:
        """
        Gets and sets the entity that defines the Z axis direction. This defaults
        to null meaning the Z axis is inferred from the input geometry.
        """
        return core.Base()
    @zAxisEntity.setter
    def zAxisEntity(self, value: core.Base):
        """
        Gets and sets the entity that defines the Z axis direction. This defaults
        to null meaning the Z axis is inferred from the input geometry.
        """
        pass
    @property
    def primaryAxisVector(self) -> core.Vector3D:
        """
        Returns the direction of the primary axis that's been calculated for this joint origin.
        """
        return core.Vector3D()
    @property
    def secondaryAxisVector(self) -> core.Vector3D:
        """
        Returns the direction of the secondary axis that's been calculated for this joint origin.
        """
        return core.Vector3D()
    @property
    def thirdAxisVector(self) -> core.Vector3D:
        """
        Returns the direction of the third axis that's been calculated for this joint origin.
        """
        return core.Vector3D()

class JointOriginList(core.Base):
    """
    A list of joint origins.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> JointOriginList:
        return JointOriginList()
    def item(self, index: int) -> JointOrigin:
        """
        Function that returns the specified joint origin using an index into the list.
        index : The index of the item within the list to return. The first item in the list has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return JointOrigin()
    def itemByName(self, name: str) -> JointOrigin:
        """
        Function that returns the specified joint origin using a name.
        name : The name of the item within the list to return.
        Returns the specified item or null if an invalid name was specified.
        """
        return JointOrigin()
    @property
    def count(self) -> int:
        """
        Returns number of joint origins in the list.
        """
        return int()

class JointOrigins(core.Base):
    """
    The collection of joint origins in this component. This provides access to all existing
    joint origins and supports the ability to create new joint origins.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> JointOrigins:
        return JointOrigins()
    def item(self, index: int) -> JointOrigin:
        """
        Function that returns the specified joint origin using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return JointOrigin()
    def itemByName(self, name: str) -> JointOrigin:
        """
        Function that returns the specified joint origin using a name.
        name : The name of the item within the collection to return.
        Returns the specified item or null if an invalid name was specified.
        """
        return JointOrigin()
    def createInput(self, geometry: JointGeometry) -> JointOriginInput:
        """
        Creates a JointOriginInput object which is used to collect all of the information
        needed to create a simple joint origin. The creation of the input object takes the required
        input as the geometry argument and you can optionally use methods and properties on the created
        JointOriginInput to set other optional settings. The JointOrigin is created by calling the add
        method of the JointOrigins object and passing it the JointOriginInput object.
        geometry : A JointGeometry object that defines the geometry the joint origin will be created on.
        Returns a JointOriginInput object if successfully created and null if it fails.
        """
        return JointOriginInput()
    def add(self, input: JointOriginInput) -> JointOrigin:
        """
        Create a new joint origin.
        input : A JointOriginInput object that full defines all of the information needed to create a joint origin.
        You create a JointOriginInput by using the createInput method of the JointOrigins object.
        Returns a JointOrigin object if successfully created and null if it fails.
        """
        return JointOrigin()
    @property
    def count(self) -> int:
        """
        Returns number of joint origins in the collection.
        """
        return int()

class Joints(core.Base):
    """
    The collection of joints in this component. This provides access to all existing joints
    and supports the ability to create new joints.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Joints:
        return Joints()
    def item(self, index: int) -> Joint:
        """
        Function that returns the specified joint using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Joint()
    def createInput(self, geometryOrOriginOne: core.Base, geometryOrOriginTwo: core.Base) -> JointInput:
        """
        Creates a JointInput object, which is the API equivalent to the Joint command dialog. You
        you use methods and properties on the returned class to set the desired options, similar to
        providing input and setting options in the Joint command dialog. Once the settings are defined
        you call the Joints.add method passing in the JointInput object to create the actual joint.
        geometryOrOriginOne : A JointGeometry or JointOrigin object that defines the first set of geometry of the joint.
        JointGeometry objects are created by using the various static methods on the JointGeometry class
        and JointOrigin objects are created through the JointOrigins object.
        geometryOrOriginTwo : A JointGeometry or JointOrigin object that defines the second set of geometry of the joint.
        JointGeometry objects are created by using the various static methods on the JointGeometry class
        and JointOrigin objects are created through the JointOrigins object.
        Returns the JointInput object or null if the creation failed.
        """
        return JointInput()
    def add(self, input: JointInput) -> Joint:
        """
        Creates a new joint.
        input : The JointInput object that defines the geometry and various inputs that fully define a joint.
        A JointInput object is created using the Joints.createInput method.
        Returns the newly created Joint or null in the case of failure.
        """
        return Joint()
    def itemByName(self, name: str) -> Joint:
        """
        Function that returns the specified joint using a name.
        name : The name of the item within the collection to return.
        Returns the specified item or null if an invalid name was specified.
        """
        return Joint()
    @property
    def count(self) -> int:
        """
        Returns number of joints in the collection.
        """
        return int()

class LoftCenterLineOrRail(core.Base):
    """
    Represent a centerline or a single rail used by a loft feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> LoftCenterLineOrRail:
        return LoftCenterLineOrRail()
    def deleteMe(self) -> bool:
        """
        Deletes the centerline or rail.
        
        If this LoftCenterLineOrRail object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        Returns true if the operation was successful.
        """
        return bool()
    @property
    def isCenterLine(self) -> bool:
        """
        Indicates if this object is a loft centerline (true) or a rail (false).
        """
        return bool()
    @property
    def entity(self) -> core.Base:
        """
        Gets and sets the entity that defines the centerline or rail. This can be a single sketch entity,
        a single BRepEdge, a Path, or a Profile.
        
        If this LoftCenterLineOrRail object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return core.Base()
    @entity.setter
    def entity(self, value: core.Base):
        """
        Gets and sets the entity that defines the centerline or rail. This can be a single sketch entity,
        a single BRepEdge, a Path, or a Profile.
        
        If this LoftCenterLineOrRail object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass

class LoftCenterLineOrRails(core.Base):
    """
    Defines a single centerline or one or more rails for a loft feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> LoftCenterLineOrRails:
        return LoftCenterLineOrRails()
    def item(self, index: int) -> LoftCenterLineOrRail:
        """
        Function that returns the specified LoftCenterLineOrRail using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return LoftCenterLineOrRail()
    def addCenterLine(self, entity: core.Base) -> LoftCenterLineOrRail:
        """
        Adds a centerline. A single centerline can be defined for a loft. If a centerline or rails have already
        been defined, they will be removed and the input will become the new single centerline.
        
        If this LoftCenterLineOrRails object is associated with a created feature,
        entity : The entity that defines the center line. This can be a single sketch curve, a single BRepEdge, a Path consisting of
        connected B-Rep edges or sketch curves.
        Returns the new LoftCenterLineOrRail object or null in the case of a failure.
        """
        return LoftCenterLineOrRail()
    def addRail(self, entity: core.Base) -> LoftCenterLineOrRail:
        """
        Add a rail to the loft definition. Multiple rails can be defined, so each call of this
        method adds a new rail.
        
        If this LoftCenterLineOrRails object is associated with a created feature, you need to position the timeline
        marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        entity : The entity that defines the rail. This can be a single sketch curve, a single BRepEdge, or a Path consisting of
        connected B-Rep edges or sketch curves.
        Returns the new LoftCenterLineOrRail object or null in the case of a failure.
        """
        return LoftCenterLineOrRail()
    @property
    def count(self) -> int:
        """
        The number of centerlines or rails in the collection.
        """
        return int()
    @property
    def isCenterLine(self) -> bool:
        """
        Indicates if a centerline or rails are currently defined.
        """
        return bool()

class LoftEndCondition(core.Base):
    """
    The base class for all loft end conditions.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> LoftEndCondition:
        return LoftEndCondition()
    @property
    def parentLoftSection(self) -> LoftSection:
        """
        Returns the parent loft section.
        """
        return LoftSection()

class LoftFeatureInput(core.Base):
    """
    This object defines the all of the input necessary to create a loft feature. It is the
    programming equivalent to the Loft command dialog. Through this object you provide
    the input needed to fully define a loft. To create the loft feature you pass
    this object the LoftFeatures.add method.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> LoftFeatureInput:
        return LoftFeatureInput()
    @property
    def loftSections(self) -> LoftSections:
        """
        The set of sections, (or profiles as they're referred to in the user-interface), that the loft will pass through. Use the add method on the LoftSections
        object to specify new sections.
        """
        return LoftSections()
    @property
    def centerLineOrRails(self) -> LoftCenterLineOrRails:
        """
        The single centerline or set of rails that define the shape of the loft. Use methods on the
        returned LoftCenterLineOrRails object to define the centerline or rails.
        """
        return LoftCenterLineOrRails()
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the type of operation performed by the loft.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the type of operation performed by the loft.
        """
        pass
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the loft is created based on geometry (e.g. a profile and/or face(s))
        when the loft is being created in another component AND the loft is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the loft is created based on geometry (e.g. a profile and/or face(s))
        when the loft is being created in another component AND the loft is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        pass
    @property
    def isSolid(self) -> bool:
        """
        Specifies if the loft should be created as a solid or surface. This is
        initialized to true so a solid will attempt to be created if it's not changed.
        """
        return bool()
    @isSolid.setter
    def isSolid(self, value: bool):
        """
        Specifies if the loft should be created as a solid or surface. This is
        initialized to true so a solid will attempt to be created if it's not changed.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass
    @property
    def participantBodies(self) -> list[BRepBody]:
        """
        Gets and sets the list of bodies that will participate in the feature when the operation is a cut or intersection.
        
        If this property has not been set, the default behavior is that all bodies that are intersected by the
        feature will participate.
        
        This property can return null in the case where the feature has not been fully defined so that
        possible intersecting bodies can be computed.
        """
        return [BRepBody()]
    @participantBodies.setter
    def participantBodies(self, value: list[BRepBody]):
        """
        Gets and sets the list of bodies that will participate in the feature when the operation is a cut or intersection.
        
        If this property has not been set, the default behavior is that all bodies that are intersected by the
        feature will participate.
        
        This property can return null in the case where the feature has not been fully defined so that
        possible intersecting bodies can be computed.
        """
        pass
    @property
    def isClosed(self) -> bool:
        """
        Specifies if the loft closes back on itself. In other words, the first section is also
        used as the last section and the connection is smooth. This property defaults to false.
        """
        return bool()
    @isClosed.setter
    def isClosed(self, value: bool):
        """
        Specifies if the loft closes back on itself. In other words, the first section is also
        used as the last section and the connection is smooth. This property defaults to false.
        """
        pass
    @property
    def isTangentEdgesMerged(self) -> bool:
        """
        Specifies if the loft will keep or merge tangent edges. These are edges between tangent
        faces in the resulting loft surface. If true, the faces will be merged so the connecting
        edge no longer exists
        """
        return bool()
    @isTangentEdgesMerged.setter
    def isTangentEdgesMerged(self, value: bool):
        """
        Specifies if the loft will keep or merge tangent edges. These are edges between tangent
        faces in the resulting loft surface. If true, the faces will be merged so the connecting
        edge no longer exists
        """
        pass

class LoftFeatures(core.Base):
    """
    Collection that provides access to all of the existing loft features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> LoftFeatures:
        return LoftFeatures()
    def item(self, index: int) -> LoftFeature:
        """
        Function that returns the specified loft feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return LoftFeature()
    def itemByName(self, name: str) -> LoftFeature:
        """
        Function that returns the specified loft feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return LoftFeature()
    def createInput(self, operation: FeatureOperations) -> LoftFeatureInput:
        """
        Creates a LoftFeatureInput object. Use properties and methods on the returned LoftFeatureInput
        object to provide the required input to create a loft feature. The LoftFeatureInput object can then be used as input to the
        add method to create the loft feature.
        operation : The feature operation to perform.
        Returns the newly created LoftFeatureInput object or null if the creation failed.
        """
        return LoftFeatureInput()
    def add(self, input: LoftFeatureInput) -> LoftFeature:
        """
        Creates a new loft feature.
        input : A LoftFeatureInput object that defines the desired loft feature. Use the createInput
        method to create a new LoftFeatureInput object and then use methods on it
        (the LoftFeatureInput object) to define the required input.
        Returns the newly created LoftFeature object or null if the creation failed.
        """
        return LoftFeature()
    @property
    def count(self) -> int:
        """
        The number of loft features in the collection.
        """
        return int()

class LoftSection(core.Base):
    """
    A single loft section.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> LoftSection:
        return LoftSection()
    def deleteMe(self) -> bool:
        """
        Deletes this LoftSection.
        
        If this LoftSection object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        Returns true if the operation was successful.
        """
        return bool()
    def reorder(self, newIndex: int) -> bool:
        """
        Repositions this section so that it has the new index specified.
        
        If this LoftSection object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        newIndex : The new index value. For example, passing in zero as the new index will make this
        the first section in the loft and (LoftSections.count - 1) will make it the last section.
        All other sections will be maintain their existing order but be shifted to allow space
        for this section.
        Returns true if the reorder operation was successful.
        """
        return bool()
    def setFreeEndCondition(self) -> bool:
        """
        Sets the end condition to be a "Free" end condition. This is the default
        end condition when a new section is added.
        
        This is valid for sections defined with all curve types.
        
        If this LoftSection object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        Returns true if the operation was successful.
        """
        return bool()
    def setDirectionEndCondition(self, angle: core.ValueInput, weight: core.ValueInput) -> bool:
        """
        Sets the end condition to be defined by a direction and weight.
        
        This is valid for sections defined with sketch curves.
        
        If this LoftSection object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        angle : Input ValueInput object that specifies the direction by using an angle. This defaults to an angle of 0.0.
        If the ValueInput object is a string it must be an valid expression that can be evaluated as an angle.
        If the ValueInput is a value then it is in radians.
        weight : Input ValueInput object that defines the weight or the amount of influence of end condition on the loft.
        This defaults to a value of 1.0. If the ValueInput object is a string it must be an valid expression that
        can be evaluated as a unitless value. In any case, the value must be greater than 0.
        Returns true if the operation was successful.
        """
        return bool()
    def setTangentEndCondition(self, weight: core.ValueInput) -> bool:
        """
        Sets the end condition to be tangent to the adjacent face. If the section is not defined by a BRepEdge,
        then this is ignored because there is no face to be tangent to.
        
        This is only valid on the first or last profile.
        
        If this LoftSection object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        weight : Input ValueInput object that defines the weight or the amount of influence of end condition on the loft.
        This defaults to a value of 1.0. If the ValueInput object is a string it must be an valid expression that
        can be evaluated as a unitless value. In any case, the value must be greater than 0.
        Returns true if the operation was successful.
        """
        return bool()
    def setSmoothEndCondition(self, weight: core.ValueInput) -> bool:
        """
        Sets the end condition to be smooth to the adjacent face. If the end profile is not defined by a BRepEdge,
        then this is ignored because there is no face to be smooth to.
        
        This is only valid on the first or last section.
        
        If this LoftSection object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        weight : Input ValueInput object that defines the weight or the amount of influence of end condition on the loft.
        This defaults to a value of 1.0. If the ValueInput object is a string it must be an valid expression that
        can be evaluated as a unitless value. In any case, the value must be greater than 0.
        Returns true if the operation was successful.
        """
        return bool()
    def setPointSharpEndCondition(self) -> bool:
        """
        Sets the end condition to be sharp where the section is a point. This is the default condition for a point section.
        
        If this LoftSection object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        Returns true if the operation was successful.
        """
        return bool()
    def setPointTangentEndCondition(self, weight: core.ValueInput) -> bool:
        """
        Set the end condition to a tangent condition in the case where the section is a point.
        
        If this LoftSection object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        weight : Input ValueInput object that defines the weight or the amount of influence of end condition on the loft.
        This defaults to a value of 1.0. If the ValueInput object is a string it must be an valid expression that
        can be evaluated as a unitless value. In any case, the value must be greater than 0.
        Returns true if the operation was successful.
        """
        return bool()
    @property
    def entity(self) -> core.Base:
        """
        Get and sets the entity that defines the section of the loft. This can be a BRepFace, Profile, Path, SketchPoint, ConstructionPoint, or an ObjectCollection
        of contiguous profiles.
        
        If this LoftSection object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return core.Base()
    @entity.setter
    def entity(self, value: core.Base):
        """
        Get and sets the entity that defines the section of the loft. This can be a BRepFace, Profile, Path, SketchPoint, ConstructionPoint, or an ObjectCollection
        of contiguous profiles.
        
        If this LoftSection object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def index(self) -> int:
        """
        The position of this LoftSection within the collection. The first section has an index
        of 0. This is also the order of how the section will be used in the loft. The order
        can be modified by using the reorder method.
        """
        return int()
    @property
    def endCondition(self) -> LoftEndCondition:
        """
        Returns the current end condition. This is only valid for the first and last
        section and when the result is not closed. In other cases this will return null.
        This returns one of the several objects derived from LoftEndCondition and represents
        the current end condition. You can edit the existing condition using properties
        on the returned object. You can change the end condition using one of the set methods
        on the LoftSection object.
        
        If this LoftSection object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return LoftEndCondition()

class LoftSections(core.Base):
    """
    The set of two or more sections used to define the shape of the loft.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> LoftSections:
        return LoftSections()
    def item(self, index: int) -> LoftSection:
        """
        Function that returns the specified LoftSection using an index into the collection. They are returned
        in the same order that they are used in the loft. Their order can be modified using the reorder method
        of the LoftSection object.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return LoftSection()
    def add(self, entity: core.Base) -> LoftSection:
        """
        Adds a new section to the loft. The initial end condition is "Free". Additional methods on the
        returned LoftSection can be used to further define the section.
        
        If this LoftSections object is associated with a created feature, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        entity : Specifies the BRepFace, Profile, Path, SketchPoint, ConstructionPoint, or an ObjectCollection containing
        a contiguous set of Profile objects that defines the section.
        Returns the newly created LoftSection object.
        """
        return LoftSection()
    @property
    def count(self) -> int:
        """
        The number of LoftSections in the collection.
        """
        return int()

class MeshBodies(core.Base):
    """
    Provides access to the MeshBodies in the parent Component and
    supports the creation of new mesh bodies.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MeshBodies:
        return MeshBodies()
    def add(self, fullFilename: str, units: MeshUnits, baseOrFormFeature: core.Base) -> MeshBodyList:
        """
        Creates a new mesh body by importing an STL, OBJ or 3MF file.
        
        Because of a current limitation, if you want to create a mesh body in a parametric model,
        you must first call the edit method of the base or form feature, use this method to create
        the mesh body, and then call the finishEdit method of the base or form feature. The base
        or form feature must be in an "edit" state to be able to add any additional items to it.
        fullFilename : The full filename (path and file) of a STL, OBJ or 3MF file.
        units : The units to use when importing the file.
        baseOrFormFeature : The BaseFeature or FormFeature object that this mesh body will be associated with. This is an optional
        requirement and is required when the model design history is being captured (parametric model) but is
        ignored otherwise (direct edit model).
        Returns a list of the newly created mesh bodies or null if the creation failed. Multiple
        bodies can be created in the case where a .obj file that contains multiple bodies was imported.
        STL files always contain a single body.
        """
        return MeshBodyList()
    def item(self, index: int) -> MeshBody:
        """
        Provides access to a mesh body within the collection.
        index : The index of the mesh body to return, where an index of 0 is the first mesh body in the collection.
        Returns the specified mesh body or null in the case of a invalid index.
        """
        return MeshBody()
    def addByTriangleMeshData(self, coordinates: list[float], coordinateIndexList: list[int], normalVectors: list[float], normalIndexList: list[int]) -> MeshBody:
        """
        Creates a new mesh body using the mesh description provided.
        coordinates : Input array of doubles that defines the X, Y, Z coordinates of each node in the mesh. Each set of three numbers define
        the coordinates of a node.
        coordinateIndexList : An array of integers that represent indices into the coordinates to define the vertices of the triangles. If an empty
        array is provided, then it's assumed that the first three coordinates defines the first triangle, the next three define
        the second triangle, and so on.
        normalVectors : An array of doubles that represent the x, y, z components of the normals at each coordinate. There should be a normal defined
        for each coordinate. If an empty array is provided for the normal vectors, Fusion 360 will automatically calculate normal vectors
        that are 90 degrees to the face of the triangle, making it appear flat.
        normalIndexList : An array of integers that represent indices into the normal vectors to define the which vector corresponds to which vertex. This
        should be the same size as the vertex index list. If an empty array is input and normal vectors are provided, it is assumed that
        the normals match up one-to-one to each coordinate.
        Returns the newly created MeshBody object or null in the case of a failure.
        """
        return MeshBody()
    @property
    def count(self) -> int:
        """
        Returns the number of mesh bodies in the collection.
        """
        return int()

class MeshBody(core.Base):
    """
    Provides access to a mesh body.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MeshBody:
        return MeshBody()
    def deleteMe(self) -> bool:
        """
        Deletes the mesh body.
        Returns true in the case where the selection was successful.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> MeshBody:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        Fails if this object is not the NativeObject.
        occurrence : The occurrence that represents the context you want to create this proxy in.
        Returns the proxy for the occurrence in the context of the specified occurrence. Returns null if it failed.
        """
        return MeshBody()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of the mesh body as displayed in the browser.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of the mesh body as displayed in the browser.
        """
        pass
    @property
    def isSelectable(self) -> bool:
        """
        Gets and sets if the mesh body is selectable in the graphics window.
        """
        return bool()
    @isSelectable.setter
    def isSelectable(self, value: bool):
        """
        Gets and sets if the mesh body is selectable in the graphics window.
        """
        pass
    @property
    def isLightBulbOn(self) -> bool:
        """
        Is the light bulb (as displayed in the browser) on.
        A mesh body will only be visible if the light bulb is switched on. However,
        the light bulb can be on and the mesh body is still invisible if the light bulb
        for all bodies or the owning component is off.
        """
        return bool()
    @isLightBulbOn.setter
    def isLightBulbOn(self, value: bool):
        """
        Is the light bulb (as displayed in the browser) on.
        A mesh body will only be visible if the light bulb is switched on. However,
        the light bulb can be on and the mesh body is still invisible if the light bulb
        for all bodies or the owning component is off.
        """
        pass
    @property
    def isVisible(self) -> bool:
        """
        Gets if the mesh body point is visible.
        """
        return bool()
    @property
    def mesh(self) -> PolygonMesh:
        """
        Returns the original mesh data that was imported. This can include triangles, quads, and polygons.
        """
        return PolygonMesh()
    @property
    def displayMesh(self) -> TriangleMesh:
        """
        Returns the associated mesh that is used for the display. This will always be triangles and includes any textures.
        """
        return TriangleMesh()
    @property
    def parentComponent(self) -> Component:
        """
        Returns the parent Component.
        """
        return Component()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> MeshBody:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return MeshBody()
    @property
    def baseOrFormFeature(self) -> core.Base:
        """
        This property returns the base or form feature that this mesh body is associated with. It
        returns null in the case where the modeling design history is not being captured (direct edit model).
        """
        return core.Base()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this mesh body.
        """
        return core.Attributes()
    @property
    def material(self) -> core.Material:
        """
        Gets and sets the physical material assigned to this mesh body.
        """
        return core.Material()
    @material.setter
    def material(self, value: core.Material):
        """
        Gets and sets the physical material assigned to this mesh body.
        """
        pass
    @property
    def appearance(self) -> core.Appearance:
        """
        Read-write property that gets and sets the current appearance of the body. Setting this property will result in applying
        an override appearance to the body and the AppearanceSourceType property will return OverrideAppearanceSource. Setting
        this property to null will remove any override.
        """
        return core.Appearance()
    @appearance.setter
    def appearance(self, value: core.Appearance):
        """
        Read-write property that gets and sets the current appearance of the body. Setting this property will result in applying
        an override appearance to the body and the AppearanceSourceType property will return OverrideAppearanceSource. Setting
        this property to null will remove any override.
        """
        pass
    @property
    def appearanceSourceType(self) -> core.AppearanceSourceTypes:
        """
        Read-write property that gets the source of the appearance for the body. If this returns OverrideAppearanceSource, an override exists
        on this body. The override can be removed by setting the Appearance property to null.
        """
        return core.AppearanceSourceTypes()
    @property
    def opacity(self) -> float:
        """
        Gets and sets the opacity override assigned to this body. A value of 1.0 specifies
        that is it completely opaque and a value of 0.0 specifies that is it completely transparent.
        
        This value is not necessarily related to what the user sees because the opacity is inherited.
        For example, if you this body is in a component and that component's opacity is set to something
        other than 1.0, the body will also be shown as slightly transparent even though the opacity
        property for the body will return 1.0. Because the component that contains the body can be
        referenced as an occurrence in other components and they can have different opacity settings,
        it's possible that different instances of the same body can display using different opacity levels.
        To get the opacity that it is being displayed with use the MeshBody.visibleOpacity property.
        
        This is the API equivalent of the "Opacity Control" command available for the body in the browser.
        """
        return float()
    @opacity.setter
    def opacity(self, value: float):
        """
        Gets and sets the opacity override assigned to this body. A value of 1.0 specifies
        that is it completely opaque and a value of 0.0 specifies that is it completely transparent.
        
        This value is not necessarily related to what the user sees because the opacity is inherited.
        For example, if you this body is in a component and that component's opacity is set to something
        other than 1.0, the body will also be shown as slightly transparent even though the opacity
        property for the body will return 1.0. Because the component that contains the body can be
        referenced as an occurrence in other components and they can have different opacity settings,
        it's possible that different instances of the same body can display using different opacity levels.
        To get the opacity that it is being displayed with use the MeshBody.visibleOpacity property.
        
        This is the API equivalent of the "Opacity Control" command available for the body in the browser.
        """
        pass
    @property
    def visibleOpacity(self) -> float:
        """
        The user can set an override opacity for components and bodies these opacity overrides combine if
        children and parent components have overrides. This property returns the actual opacity that is
        being used to render the body. To set the opacity use the opacity property of the MeshBody object.
        """
        return float()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the MeshBody object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same mesh body.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class MeshBodyList(core.Base):
    """
    Provides access to a list of MeshBody objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MeshBodyList:
        return MeshBodyList()
    def item(self, index: int) -> MeshBody:
        """
        Provides access to a mesh body within the collection.
        index : The index of the mesh body to return, where an index of 0 is the first mesh body in the collection.
        Returns the specified mesh body or null in the case of a invalid index.
        """
        return MeshBody()
    @property
    def count(self) -> int:
        """
        Returns the number of mesh bodies in the collection.
        """
        return int()

class MeshManager(core.Base):
    """
    Provides access to meshes that approximate a B-Rep and T-Spline.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MeshManager:
        return MeshManager()
    def createMeshCalculator(self) -> TriangleMeshCalculator:
        """
        Creates a new MeshCalculator which is used to calculate
        new triangular meshes based on various parameters that control the calculation.
        Returns the new MeshCalculator object or null if the creation failed.
        """
        return TriangleMeshCalculator()
    @property
    def displayMeshes(self) -> TriangleMeshList:
        """
        Returns a collection that provides access to all of the
        existing display meshes.
        """
        return TriangleMeshList()
    @property
    def parent(self) -> core.Base:
        """
        Returns the parent BRepBody, BRepFace, BRepLump, BRepShell, SculptBody, or SculptFace object.
        """
        return core.Base()

class MirrorFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a mirror
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MirrorFeatureInput:
        return MirrorFeatureInput()
    @property
    def inputEntities(self) -> core.ObjectCollection:
        """
        Gets and sets the entities that are mirrored. It can contain faces, features, bodies, or components.
        The input must all be of a single type. For example, you can't provide a body and a component but
        the collection must be either all bodies or all components.
        """
        return core.ObjectCollection()
    @inputEntities.setter
    def inputEntities(self, value: core.ObjectCollection):
        """
        Gets and sets the entities that are mirrored. It can contain faces, features, bodies, or components.
        The input must all be of a single type. For example, you can't provide a body and a component but
        the collection must be either all bodies or all components.
        """
        pass
    @property
    def mirrorPlane(self) -> core.Base:
        """
        Gets and sets the mirror plane. This can be either a planar face or construction plane.
        """
        return core.Base()
    @mirrorPlane.setter
    def mirrorPlane(self, value: core.Base):
        """
        Gets and sets the mirror plane. This can be either a planar face or construction plane.
        """
        pass
    @property
    def patternComputeOption(self) -> PatternComputeOptions:
        """
        Gets and sets the compute option when mirroring features. The default value for this is AdjustPatternCompute.
        This property only applies when mirroring features and is ignored in the direct modeling environment.
        """
        return PatternComputeOptions()
    @patternComputeOption.setter
    def patternComputeOption(self, value: PatternComputeOptions):
        """
        Gets and sets the compute option when mirroring features. The default value for this is AdjustPatternCompute.
        This property only applies when mirroring features and is ignored in the direct modeling environment.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass
    @property
    def isCombine(self) -> bool:
        """
        Gets and sets whether the mirrored bodies should be combined with the original bodies.
        When true, the mirrored geometry will be Boolean unioned with the original solid or surface body(s)
        when they connect within the stitch tolerance defined with the stitchTolerance property. If the bodies
        cannot be unioned or stitched the result will be separate bodies.
        If any input object is not a body, then this setting is ignored.
        Default is false.
        """
        return bool()
    @isCombine.setter
    def isCombine(self, value: bool):
        """
        Gets and sets whether the mirrored bodies should be combined with the original bodies.
        When true, the mirrored geometry will be Boolean unioned with the original solid or surface body(s)
        when they connect within the stitch tolerance defined with the stitchTolerance property. If the bodies
        cannot be unioned or stitched the result will be separate bodies.
        If any input object is not a body, then this setting is ignored.
        Default is false.
        """
        pass
    @property
    def stitchTolerance(self) -> core.ValueInput:
        """
        Gets and sets the ValueInput object that defines the Stitching Tolerance (length)
        to use when doing a mirror and combine for surface bodies.
        """
        return core.ValueInput()
    @stitchTolerance.setter
    def stitchTolerance(self, value: core.ValueInput):
        """
        Gets and sets the ValueInput object that defines the Stitching Tolerance (length)
        to use when doing a mirror and combine for surface bodies.
        """
        pass

class MirrorFeatures(core.Base):
    """
    Collection that provides access to all of the existing mirror features in a component
    and supports the ability to create new mirror features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MirrorFeatures:
        return MirrorFeatures()
    def item(self, index: int) -> MirrorFeature:
        """
        Function that returns the specified mirror feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return MirrorFeature()
    def createInput(self, inputEntities: core.ObjectCollection, mirrorPlane: core.Base) -> MirrorFeatureInput:
        """
        Creates a MirrorFeatureInput object. Use properties and methods on this object
        to define the mirror you want to create and then use the Add method, passing in
        the MirrorFeatureInput object.
        inputEntities : A collection of the entities to mirror. It can contain faces, features, bodies, or components.
        The input must all be of a single type. For example, you can't provide a body and a component but
        the collection must be either all bodies or all components.
        mirrorPlane : Input planar entity that defines the mirror plane. This can be either a planar face or a construction plane.
        Returns the newly created MirrorFeatureInput object or null if the creation failed.
        """
        return MirrorFeatureInput()
    def add(self, input: MirrorFeatureInput) -> MirrorFeature:
        """
        Creates a new mirror feature.
        input : A MirrorFeatureInput object that defines the desired mirror. Use the createInput
        method to create a new MirrorFeatureInput object and then use methods on it
        (the MirrorFeatureInput object) to define the mirror.
        Returns the newly created MirrorFeature object or null if the creation failed.
        """
        return MirrorFeature()
    def itemByName(self, name: str) -> MirrorFeature:
        """
        Function that returns the specified mirror feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return MirrorFeature()
    @property
    def count(self) -> int:
        """
        The number of mirror features in the collection.
        """
        return int()

class ModelParameters(core.Base):
    """
    Provides access to the Model Parameters within a component.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ModelParameters:
        return ModelParameters()
    def item(self, index: int) -> ModelParameter:
        """
        Function that returns the specified Model Parameter using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection
        has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ModelParameter()
    def itemByName(self, name: str) -> ModelParameter:
        """
        Function that returns the specified Model Parameter using the name of the parameter as it is
        displayed in the parameters dialog.
        name : The name of the Model Parameter as it is displayed in the parameters dialog
        Returns the specified item or null if an invalid name was specified.
        """
        return ModelParameter()
    @property
    def count(self) -> int:
        """
        Returns the number of parameters in the collection.
        """
        return int()
    @property
    def component(self) -> Component:
        """
        Returns the component that owns the Model Parameters collection
        """
        return Component()

class MoveFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a move feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MoveFeatureInput:
        return MoveFeatureInput()
    @property
    def inputEntities(self) -> core.ObjectCollection:
        """
        An ObjectCollection containing the objects to move. The collection can contain
        BRepBody or BRepFace objects but not a mixture of the two types.
        """
        return core.ObjectCollection()
    @inputEntities.setter
    def inputEntities(self, value: core.ObjectCollection):
        """
        An ObjectCollection containing the objects to move. The collection can contain
        BRepBody or BRepFace objects but not a mixture of the two types.
        """
        pass
    @property
    def transform(self) -> core.Matrix3D:
        """
        Gets and sets the transform to apply to the input entities. This can describe a move (translation)
        or a rotation. The matrix must define an orthogonal transform. That is the axes remain
        perpendicular to each other and there isn't any scale or mirror defined.
        """
        return core.Matrix3D()
    @transform.setter
    def transform(self, value: core.Matrix3D):
        """
        Gets and sets the transform to apply to the input entities. This can describe a move (translation)
        or a rotation. The matrix must define an orthogonal transform. That is the axes remain
        perpendicular to each other and there isn't any scale or mirror defined.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class MoveFeatures(core.Base):
    """
    Collection that provides access to all of the existing move features in a component
    and supports the ability to create new move features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MoveFeatures:
        return MoveFeatures()
    def item(self, index: int) -> MoveFeature:
        """
        Function that returns the specified move feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return MoveFeature()
    def createInput(self, inputEntities: core.ObjectCollection, transform: core.Matrix3D) -> MoveFeatureInput:
        """
        Creates a MoveFeatureInput object. Use properties and methods on this object
        to define the move feature you want to create and then use the Add method, passing in
        the MoveFeatureInput object.
        inputEntities : An ObjectCollection containing the entities to move. This collection can only contain
        BRepBody objects in parametric modeling. It can be BRep bodies, T-Spline bodies,
        mesh bodies mixed or faces and features mixed in non-parametric modeling.
        transform : The transform to apply to the input entities. This can describe a move (translation) or a rotation. The
        matrix must define an orthogonal transform. That is the axes must be perpendicular to each other and there
        can't be any scaling or mirroring defined.
        Returns the newly created MoveFeatureInput object or null if the creation failed.
        """
        return MoveFeatureInput()
    def add(self, input: MoveFeatureInput) -> MoveFeature:
        """
        Creates a new move feature.
        input : A MoveFeatureInput object that defines the desired move feature. Use the createInput2
        method to create a new MoveFeatureInput object and then use methods on the MoveFeatureInput
        object to define the move feature.
        Returns the newly created MoveFeature object or null if the creation failed.
        Returns nothing in the case where the feature is non-parametric.
        """
        return MoveFeature()
    def itemByName(self, name: str) -> MoveFeature:
        """
        Function that returns the specified move feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return MoveFeature()
    @property
    def count(self) -> int:
        """
        The number of move features in the collection.
        """
        return int()

class Occurrence(core.Base):
    """
    Represents an occurrence of a component at any level within a subassembly.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Occurrence:
        return Occurrence()
    def deleteMe(self) -> bool:
        """
        Deletes the occurrence from the design. If this is the last occurrence
        referencing a specific Component, the component is also deleted.
        Returns true if the delete was successful.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> Occurrence:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        Fails if this object is not the NativeObject.
        occurrence : The occurrence that represents the context you want to create this proxy in.
        Returns the proxy for the occurrence in the context of the specified occurrence.
        Returns null if it failed.
        """
        return Occurrence()
    def activate(self) -> bool:
        """
        Makes the occurrence the active edit target in the user interface. This is the same
        as enabling the radio button next to the occurrence in the browser.
        Returns true if the activation was successful.
        """
        return bool()
    def moveToComponent(self, targetOccurrence: Occurrence) -> Occurrence:
        """
        Moves this occurrence from it's current component into the component owned by the specified occurrence.
        This occurrence and the target occurrence must be in the same context.
        targetOccurrence : The target occurrence defines both the component and the transform to apply when moving the occurrence. The
        occurrence will be copied into the parent component of the target occurrence and the target occurrence also defines
        the transform of how the occurrence will be copied so that the occurrence maintains it's same position in model space.
        Returns the moved Occurrence or null in the case the move failed.
        """
        return Occurrence()
    def getPhysicalProperties(self, accuracy: CalculationAccuracy) -> PhysicalProperties:
        """
        Returns the PhysicalProperties object that has properties for getting the area, density, mass, volume, moments, etc
        of this occurrence.
        accuracy : Specifies the desired level of computational accuracy of the property calculations.
        The default value of 'LowCalculationAccuracy' returns results within a +/- 1% error margin.
        Returns a PhysicalProperties object that can be used to get the various physical property related values.
        """
        return PhysicalProperties()
    def breakLink(self) -> bool:
        """
        When the component this occurrence references is an external reference (the isReferencedComponent property returns true),
        this will break the link and create a local Component that this occurrence will reference. The new local Component can
        be accessed through the Occurrence using the component property.
        
        This method will fail if the occurrence is not referencing an external component.
        Returns true if the break link was successful.
        """
        return bool()
    @property
    def sourceComponent(self) -> Component:
        """
        This is the sourceComponent for the occurrence and is affected
        by the assembly context.
        This is the top-level component where the path begins.
        """
        return Component()
    @property
    def childOccurrences(self) -> OccurrenceList:
        """
        Returns a read only list of child occurrences where only the occurrences
        in this occurrence's AssemblyContext are returned .
        """
        return OccurrenceList()
    @property
    def component(self) -> Component:
        """
        The component this occurrence references.
        """
        return Component()
    @property
    def name(self) -> str:
        """
        The name of the occurrence. This is the name as seen in the browser. It is a reflection
        of the component name with an added counter suffix (i.e. 'OccurrenceName:1').
        """
        return str()
    @property
    def fullPathName(self) -> str:
        """
        The name of the occurrence, including the full path of occurrences as seen in the browser.
        The top-level component will depend on the context but will typically be the root component
        of the design. A name for an occurrence that is at the third level of an assembly could be
        "Sub1:1+Sub2:1+PartA:1".
        """
        return str()
    @property
    def appearance(self) -> core.Appearance:
        """
        Read-write property that gets and sets the appearance override for this occurrence.
        This property can return null indicating there is no override appearance and that the
        contents of the occurrence are displayed using there defined appearance.
        Setting the property to null will remove any override appearance for this occurrence.
        """
        return core.Appearance()
    @appearance.setter
    def appearance(self, value: core.Appearance):
        """
        Read-write property that gets and sets the appearance override for this occurrence.
        This property can return null indicating there is no override appearance and that the
        contents of the occurrence are displayed using there defined appearance.
        Setting the property to null will remove any override appearance for this occurrence.
        """
        pass
    @property
    def isLightBulbOn(self) -> bool:
        """
        Gets and sets if the light bulb of this occurrence as displayed in the browser is on or off.
        An occurrence will only be visible if the light bulb is switched on. However,
        the light bulb can be on and the occurrence still invisible if a higher level occurrence
        in the assembly context is not visible because its light bulb is off.
        """
        return bool()
    @isLightBulbOn.setter
    def isLightBulbOn(self, value: bool):
        """
        Gets and sets if the light bulb of this occurrence as displayed in the browser is on or off.
        An occurrence will only be visible if the light bulb is switched on. However,
        the light bulb can be on and the occurrence still invisible if a higher level occurrence
        in the assembly context is not visible because its light bulb is off.
        """
        pass
    @property
    def isVisible(self) -> bool:
        """
        Gets whether the occurrence is visible.
        This property is affected by the assembly context.
        """
        return bool()
    @property
    def transform(self) -> core.Matrix3D:
        """
        Gets and sets the 3d matrix data that defines this occurrences orientation and
        position in its assembly context
        """
        return core.Matrix3D()
    @transform.setter
    def transform(self, value: core.Matrix3D):
        """
        Gets and sets the 3d matrix data that defines this occurrences orientation and
        position in its assembly context
        """
        pass
    @property
    def timelineObject(self) -> TimelineObject:
        """
        Returns the timeline object associated with the creation of this occurrence.
        """
        return TimelineObject()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this
        object in an assembly. This is only valid in the case where this
        references the component the object is defined within.
        Returns null in the case where the object is not in the context of an assembly
        but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> Occurrence:
        """
        The NativeObject is the object outside the context of an assembly.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        The return type is strongly typed for each object.
        """
        return Occurrence()
    @property
    def isGrounded(self) -> bool:
        """
        Gets and sets whether this occurrence is grounded or not.
        """
        return bool()
    @isGrounded.setter
    def isGrounded(self, value: bool):
        """
        Gets and sets whether this occurrence is grounded or not.
        """
        pass
    @property
    def isSelectable(self) -> bool:
        """
        Gets and sets whether this occurrence is selectable or not.
        """
        return bool()
    @isSelectable.setter
    def isSelectable(self, value: bool):
        """
        Gets and sets whether this occurrence is selectable or not.
        """
        pass
    @property
    def isIsolated(self) -> bool:
        """
        Gets and sets whether this occurrence is isolated in the UI. When an occurrence
        is isolated it is the only one visible in the user-interface. Only one occurrence
        can be isolated at a time so setting this property to true will un-isolate an occurrence
        that is currently isolated. Setting this property to false for an occurrence that is
        current isolated will un-isolate it so that no occurrence will be isolated.
        """
        return bool()
    @isIsolated.setter
    def isIsolated(self, value: bool):
        """
        Gets and sets whether this occurrence is isolated in the UI. When an occurrence
        is isolated it is the only one visible in the user-interface. Only one occurrence
        can be isolated at a time so setting this property to true will un-isolate an occurrence
        that is currently isolated. Setting this property to false for an occurrence that is
        current isolated will un-isolate it so that no occurrence will be isolated.
        """
        pass
    @property
    def isActive(self) -> bool:
        """
        Gets whether this occurrence is the active edit target in the user interface.
        This is the same as checking the state of the radio button next to the occurrence in the browser.
        To activate the occurrence use the Activate method.
        """
        return bool()
    @property
    def physicalProperties(self) -> PhysicalProperties:
        """
        Returns the PhysicalProperties object that has properties for getting the area, density, mass, volume, moments, etc
        of this occurrence. Property values will be calculated using the 'LowCalculationAccuracy' setting when using this property
        to get the PhysicalProperties object. To specify a higher calculation tolerance, use the getPhysicalProperties method instead.
        Returns a PhysicalProperties object that can be used to get the various physical property related values.
        """
        return PhysicalProperties()
    @property
    def isReferencedComponent(self) -> bool:
        """
        Gets if this occurrence is referencing an external component.
        """
        return bool()
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns the bounding box of this occurrence.
        """
        return core.BoundingBox3D()
    @property
    def joints(self) -> JointList:
        """
        Returns the joints that affect the position of this occurrence. For example, if a joint has
        been created between this occurrence and another occurrence, this property will return that
        joint. If the occurrence is a proxy, the joints returned will also be proxies in the same
        context as the occurrence.
        """
        return JointList()
    @property
    def rigidGroups(self) -> RigidGroupList:
        """
        Returns the rigid groups that this occurrence is a member of. If the occurrence is a proxy,
        the joints returned will also be proxies in the same context as the occurrence.
        """
        return RigidGroupList()
    @property
    def asBuiltJoints(self) -> AsBuiltJointList:
        """
        Returns the as-built joints that affect the position of this occurrence. If the occurrence is a proxy,
        the as-built joints returned will also be proxies in the same context as the occurrence.
        """
        return AsBuiltJointList()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this face.
        """
        return core.Attributes()
    @property
    def bRepBodies(self) -> BRepBodies:
        """
        Returns the body proxies for the B-Rep bodies in the component referenced by this occurrence.
        For example if you get the occurrences from the root component and then use this property to
        get the bodies from those occurrences, the bodies returned will return information in the context of the root
        component, not the component they actually exist in.
        """
        return BRepBodies()
    @property
    def visibleOpacity(self) -> float:
        """
        The user can set an override opacity for components and these opacity overrides combine if
        children and parent components have overrides. This property returns the actual opacity that is
        being used to render the occurrence. To set the opacity use the opacity property of the Component object.
        """
        return float()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the Occurrence object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same occurrence.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()
    @property
    def transform2(self) -> core.Matrix3D:
        """
        Gets and sets the 3d matrix data that defines this occurrences orientation and
        position in its assembly context
        """
        return core.Matrix3D()
    @transform2.setter
    def transform2(self, value: core.Matrix3D):
        """
        Gets and sets the 3d matrix data that defines this occurrences orientation and
        position in its assembly context
        """
        pass

class OccurrenceList(core.Base):
    """
    Provides a list of occurrences.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> OccurrenceList:
        return OccurrenceList()
    def item(self, index: int) -> Occurrence:
        """
        Returns the specified occurrence using an index into the collection.
        index : The index of the occurrence within the collection to return. The first item has an index of 0.
        Returns the specified occurrence or null in the case of an invalid index.
        """
        return Occurrence()
    def itemByName(self, name: str) -> Occurrence:
        """
        Returns the specified occurrence using the name of the occurrence.
        name : The name of the occurrence to return.
        Returns the occurrence or null if an invalid name was specified
        """
        return Occurrence()
    @property
    def count(self) -> int:
        """
        Returns the number of occurrences in the collection.
        """
        return int()

class Occurrences(core.Base):
    """
    Provides access to occurrences within a component and provides
    methods to create new occurrences.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Occurrences:
        return Occurrences()
    def item(self, index: int) -> Occurrence:
        """
        Function that returns the specified occurrence using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Occurrence()
    def itemByName(self, name: str) -> Occurrence:
        """
        Returns the specified occurrence using the name of the occurrence.
        name : The name of the occurrence to return.
        Returns the occurrence or null if an invalid name was specified
        """
        return Occurrence()
    def addExistingComponent(self, component: Component, transform: core.Matrix3D) -> Occurrence:
        """
        Method that creates a new occurrence using an existing component. This is the equivalent
        of copying and pasting an occurrence in the user interface.
        component : The existing component to create a new occurrence of.
        transform : A transform that defines the location for the new occurrence
        Returns the newly created occurrence or null if the creation failed.
        """
        return Occurrence()
    def addNewComponent(self, transform: core.Matrix3D) -> Occurrence:
        """
        Method that creates a new component and an occurrence that references it.
        transform : A transform that defines the location for the new occurrence.
        Returns the newly created occurrence or null if the creation failed.
        """
        return Occurrence()
    def addByInsert(self, dataFile: core.DataFile, transform: core.Matrix3D, isReferencedComponent: bool) -> Occurrence:
        """
        Method that inserts an existing file.
        dataFile : The dataFile to insert.
        transform : A transform that defines the location for the new occurrence.
        isReferencedComponent : Indicates if the insert is to be an external reference or embedded within this document.
        This method will fail if the dataFile being inserted is not from the same project as the document
        it is being inserted into while isReferencedComponent is True.
        Returns the newly created occurrence or null if the insert failed.
        Insert will fail if the dataFile being inserted is not from the same project as the document
        it is being inserted into while isReferencedComponent is True.
        """
        return Occurrence()
    def asArray(self) -> list[Occurrence]:
        """
        Get the current list of all occurrences.
        The occurrences are returned in the same order as they appear in the browser.
        Returns the current list of all occurrences.
        """
        return [Occurrence()]
    @property
    def count(self) -> int:
        """
        Returns the number of occurrences in the collection.
        """
        return int()
    @property
    def asList(self) -> OccurrenceList:
        """
        Returns the contents of this collection as an OccurrencesList object. This
        is useful when writing a function that traverses an assembly.
        """
        return OccurrenceList()

class OffsetFacesFeatures(core.Base):
    """
    Collection that provides access to all of the existing Offset Face features in a design.
    Offset Face features are created in the UI using the "Press Pull" command.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> OffsetFacesFeatures:
        return OffsetFacesFeatures()
    def item(self, index: int) -> OffsetFacesFeature:
        """
        Function that returns the specified Offset Face feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return OffsetFacesFeature()
    def itemByName(self, name: str) -> OffsetFacesFeature:
        """
        Function that returns the specified Offset Face feature using the name of the feature.
        Offset Face features are created in the UI using the "Press Pull" command.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return OffsetFacesFeature()
    @property
    def count(self) -> int:
        """
        The number of Offset Face features in the collection.
        Offset Face features are created in the UI using the "Press Pull" command.
        """
        return int()

class OffsetFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a offset feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> OffsetFeatureInput:
        return OffsetFeatureInput()
    @property
    def entities(self) -> core.ObjectCollection:
        """
        An ObjectCollection containing the BRepFace objects being offset.
        """
        return core.ObjectCollection()
    @entities.setter
    def entities(self, value: core.ObjectCollection):
        """
        An ObjectCollection containing the BRepFace objects being offset.
        """
        pass
    @property
    def isChainSelection(self) -> bool:
        """
        Get and sets whether faces that are tangentially connected to the input faces will be included in the offset.
        """
        return bool()
    @isChainSelection.setter
    def isChainSelection(self, value: bool):
        """
        Get and sets whether faces that are tangentially connected to the input faces will be included in the offset.
        """
        pass
    @property
    def distance(self) -> core.ValueInput:
        """
        Gets and sets the ValueInput object that defines the offset distance. A positive distance value results
        in an offset in the positive normal direction of the faces.
        """
        return core.ValueInput()
    @distance.setter
    def distance(self, value: core.ValueInput):
        """
        Gets and sets the ValueInput object that defines the offset distance. A positive distance value results
        in an offset in the positive normal direction of the faces.
        """
        pass
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the feature operation to perform. Can be 'NewBodyFeatureOperation' or 'NewComponentFeatureOperation'.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the feature operation to perform. Can be 'NewBodyFeatureOperation' or 'NewComponentFeatureOperation'.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class OffsetFeatures(core.Base):
    """
    Collection that provides access to all of the existing Offset features in a component
    and supports the ability to create new Offset features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> OffsetFeatures:
        return OffsetFeatures()
    def item(self, index: int) -> OffsetFeature:
        """
        Function that returns the specified offset feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return OffsetFeature()
    def createInput(self, entities: core.ObjectCollection, distance: core.ValueInput, operation: FeatureOperations, isChainSelection: bool) -> OffsetFeatureInput:
        """
        Creates a OffsetFeatureInput object. Use properties and methods on this object
        to define the offset feature you want to create and then use the Add method, passing in
        the OffsetFeatureInput object to create the feature.
        entities : An ObjectCollection containing the BRepFace objects to offset. Additional faces may be
        automatically used depending on the value of the isChainSelection argument.
        Input faces need not be from the same body.
        distance : ValueInput object that defines the offset distance. A positive value is in the positive
        normal direction of the face being offset.
        operation : The feature operation to perform. 'NewBodyFeatureOperation' and 'NewComponentFeatureOperation' are the
        options supported.
        isChainSelection : A boolean value for setting whether or not faces that are tangentially connected to
        the input faces (if any) will be included in the offset. The default value is true.
        Returns the newly created OffsetFeatureInput object or null if the creation failed.
        """
        return OffsetFeatureInput()
    def add(self, input: OffsetFeatureInput) -> OffsetFeature:
        """
        Creates a new offset feature.
        input : A FeatureInput object that defines the desired offset feature. Use the createInput
        method to create a new OffsetFeatureInput object and then use methods on it
        (the OffsetFeatureInput object) to define the offset feature.
        Returns the newly created OffsetFeature object or null if the creation failed.
        """
        return OffsetFeature()
    def itemByName(self, name: str) -> OffsetFeature:
        """
        Function that returns the specified offset feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return OffsetFeature()
    @property
    def count(self) -> int:
        """
        The number of Offset features in the collection.
        """
        return int()

class Parameter(core.Base):
    """
    The base class Parameter object that can represent model or user parameters.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Parameter:
        return Parameter()
    @property
    def value(self) -> float:
        """
        Gets and sets the real value (a double) of the parameter in database units.
        Setting this property will set/reset the expression value for this parameter
        """
        return float()
    @value.setter
    def value(self, value: float):
        """
        Gets and sets the real value (a double) of the parameter in database units.
        Setting this property will set/reset the expression value for this parameter
        """
        pass
    @property
    def expression(self) -> str:
        """
        Gets and sets the expression (i.e. "22.064 mm") used to calculate the value of the parameter
        """
        return str()
    @expression.setter
    def expression(self, value: str):
        """
        Gets and sets the expression (i.e. "22.064 mm") used to calculate the value of the parameter
        """
        pass
    @property
    def name(self) -> str:
        """
        Gets and sets the name of the parameter. Setting the name can fail if the name
        is not unique with respect to all other parameters in the design.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of the parameter. Setting the name can fail if the name
        is not unique with respect to all other parameters in the design.
        """
        pass
    @property
    def unit(self) -> str:
        """
        The unit type associated with this parameter. An empty string is returned for parameters
        that don't have a unit type.
        """
        return str()
    @property
    def comment(self) -> str:
        """
        The comment associated with this parameter
        """
        return str()
    @comment.setter
    def comment(self, value: str):
        """
        The comment associated with this parameter
        """
        pass
    @property
    def isFavorite(self) -> bool:
        """
        Gets and sets whether this parameter is included in the Favorites list in the
        parameters dialog
        """
        return bool()
    @isFavorite.setter
    def isFavorite(self, value: bool):
        """
        Gets and sets whether this parameter is included in the Favorites list in the
        parameters dialog
        """
        pass
    @property
    def dependentParameters(self) -> ParameterList:
        """
        Returns a list of parameters that are dependent on this parameter as a result
        of this parameter being referenced in their equation.
        """
        return ParameterList()
    @property
    def isDeletable(self) -> bool:
        """
        Gets if this parameter can be deleted. Parameters that cannot be deleted are: Model Parameters and
        User Parameters that have dependents.
        """
        return bool()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this face.
        """
        return core.Attributes()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the Parameter object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same parameter.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class ParameterList(core.Base):
    """
    Transient object used to pass a set of parameters.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ParameterList:
        return ParameterList()
    @staticmethod
    def create() -> ParameterList:
        """
        Creates a parameter list that the client can use for various purposes.
        Use ParameterList.Add to add parameters to the list after creating it.
        Returns a ParameterList
        """
        return ParameterList()
    def item(self, index: int) -> Parameter:
        """
        Function that returns the specified parameter using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Parameter()
    def itemByName(self, name: str) -> Parameter:
        """
        Returns the specified parameter using the name of the parameter
        as it is displayed in the parameters dialog
        name : The name of the parameter as it is displayed in the parameters dialog
        Returns the specified item or null if an invalid name was specified.
        """
        return Parameter()
    def add(self, parameter: Parameter) -> bool:
        """
        Adds a parameter to the list. This does not create a
        new parameter, it adds an existing parameter to the list.
        Note that duplicates can exist in the list.
        parameter : The existing parameter to add to the list
        Returns true if successful. This method will fail if the list is read-only
        """
        return bool()
    def removeByIndex(self, index: int) -> bool:
        """
        Method that removes a parameter from the list using the index of the item
        in the list
        Will fail if the list is read only.
        index : The index of the parameter to be removed from the list
        Returns true if successful. This method will fail if the list is read-only
        """
        return bool()
    def removeByItem(self, item: Parameter) -> bool:
        """
        Method that removes a parameter from the list by specifying the parameter (item)
        to remove
        item : The parameter item to remove from the list
        Returns true if successful. This method will fail if the list is read-only
        """
        return bool()
    def find(self, parameter: Parameter, startIndex: int) -> int:
        """
        Finds the specified parameter in the list. The search can be started at a specified
        index rather than from the beginning of the list.
        If not found, -1 is returned.
        parameter : The parameter to find
        startIndex : the index in the list to start the search from
        Returns the index of the parameter found in the list.
        """
        return int()
    def contains(self, parameter: Parameter) -> bool:
        """
        Indicates whether or not ParameterList collection contains a specified parameter
        parameter : The parameter to look for in the list
        Returns true if list contains the specified parameter
        """
        return bool()
    @property
    def count(self) -> int:
        """
        Returns the number of parameters in the collection.
        """
        return int()
    @property
    def isReadOnly(self) -> bool:
        """
        Indicates if the list is read-only
        Some lists returned by API calls (instead of lists created by the
        user) are read only. Items cannot be added or remove from such a list.
        """
        return bool()

class PatchFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a patch feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PatchFeatureInput:
        return PatchFeatureInput()
    @property
    def boundaryCurve(self) -> core.Base:
        """
        Gets and set the input geometry that will be used to define the boundary. This can be a sketch profile,
        a single sketch curve, a single B-Rep edge, or a Path object.
        
        If a single sketch curve or B-Rep edge is input, that is not closed, Fusion 360 will automatically find connected sketch curves
        or B-Rep edges in order to define a closed loop. All sketch curves are valid as input. BRepEdges are valid if they are
        an "open" edge, which means they are only used by one face.
        
        If a Path is input it must define a closed shape and the B-Rep edges must be valid "open" edges.
        """
        return core.Base()
    @boundaryCurve.setter
    def boundaryCurve(self, value: core.Base):
        """
        Gets and set the input geometry that will be used to define the boundary. This can be a sketch profile,
        a single sketch curve, a single B-Rep edge, or a Path object.
        
        If a single sketch curve or B-Rep edge is input, that is not closed, Fusion 360 will automatically find connected sketch curves
        or B-Rep edges in order to define a closed loop. All sketch curves are valid as input. BRepEdges are valid if they are
        an "open" edge, which means they are only used by one face.
        
        If a Path is input it must define a closed shape and the B-Rep edges must be valid "open" edges.
        """
        pass
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the type of operation performed by the patch feature. Only 'NewBodyFeatureOperation' and 'NewComponentFeatureOperation' are
        valid operations for patch features.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the type of operation performed by the patch feature. Only 'NewBodyFeatureOperation' and 'NewComponentFeatureOperation' are
        valid operations for patch features.
        """
        pass
    @property
    def continuity(self) -> SurfaceContinuityTypes:
        """
        Gets and sets type of surface continuity to use when matching boundary edges to face edges. When a new PatchFeatureInput is
        created, this is initialized to ConnectedSurfaceContinuityType. This value is ignored when creating a patch for sketch curves.
        """
        return SurfaceContinuityTypes()
    @continuity.setter
    def continuity(self, value: SurfaceContinuityTypes):
        """
        Gets and sets type of surface continuity to use when matching boundary edges to face edges. When a new PatchFeatureInput is
        created, this is initialized to ConnectedSurfaceContinuityType. This value is ignored when creating a patch for sketch curves.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Patch feature is created based on geometry (e.g. a profile, edges, faces)
        in another component AND (the Patch feature) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Patch feature is created based on geometry (e.g. a profile, edges, faces)
        in another component AND (the Patch feature) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        pass

class PatchFeatures(core.Base):
    """
    Collection that provides access to all of the existing Patch features in a component
    and supports the ability to create new Patch features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PatchFeatures:
        return PatchFeatures()
    def item(self, index: int) -> PatchFeature:
        """
        Function that returns the specified patch feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return PatchFeature()
    def itemByName(self, name: str) -> PatchFeature:
        """
        Function that returns the specified patch feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return PatchFeature()
    def createInput(self, boundaryCurve: core.Base, operation: FeatureOperations) -> PatchFeatureInput:
        """
        Creates a PatchFeatureInput object. Use properties and methods on the returned PatchFeatureInput
        object to set other settings. The PatchFeatureInput object can then be used as input to the
        add method to create the patch feature.
        boundaryCurve : Defines the input geometry that will be used to define the boundary. This can be a sketch profile,
        a single sketch curve, a single B-Rep edge, or a Path object.
        
        If a single sketch curve or B-Rep edge is input, that is not closed, Fusion 360 will automatically find connected sketch curves
        or B-Rep edges in order to define a closed loop. All sketch curves are valid as input. BRepEdges are valid if they are
        an "open" edge, which means they are only used by one face.
        
        If a Path is input it must define a closed shape and the B-Rep edges must be valid "open" edges.
        operation : The feature operation to perform. Only 'NewBodyFeatureOperation' and 'NewComponentFeatureOperation' are
        valid operations for patch features.
        Returns the newly created PatchFeatureInput object or null if the creation failed.
        """
        return PatchFeatureInput()
    def add(self, input: PatchFeatureInput) -> PatchFeature:
        """
        Creates a new patch feature.
        input : A PatchFeatureInput object that defines the desired patch feature. Use the createInput
        method to create a new PatchFeatureInput object and then use methods on it
        (the PatchFeatureInput object) to define the patch feature.
        Returns the newly created PatchFeature object or null if the creation failed.
        """
        return PatchFeature()
    @property
    def count(self) -> int:
        """
        The number of Patch features in the collection.
        """
        return int()

class Path(core.Base):
    """
    The Path object represents a single set of connected curves. The order of the objects within the collection is the same as the connection order of the entities.
    When using a Path to create a feature, the Path serves as a way to pass in the set of sketch entities and edges. When
    getting the Path of an existing feature it returns the actual path used to define the feature geometry. In cases like a
    sweep feature, this can result in using portions of the original input sketch curves or edges and the returned path
    will provide these "partial" curves as the PathEntity objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Path:
        return Path()
    @staticmethod
    def create(curves: core.Base, chainOptions: ChainedCurveOptions) -> Path:
        """
        Creates a new Path that can be used as input to various features. For example, it is used
        to create an open set of curves to create surfaces using extrude, revolve, and sweep.
        It is also used to create the path for a sweep and sections and profiles and rails for lofts. And
        it is used to define the boundary of a patch feature.
        
        Although the creation of a path is very flexible as far as the types of entities and whether they
        are planar or not, each of the features have specific requirements and the path must meet those
        requirements. For example, a path for an extrusion can only contain sketch curves and must be planar,
        whereas the path for a sweep can contain a mix of sketch curves and edges and can be in three dimensions.
        curves : A SketchCurve, BRepEdge, or an ObjectCollection containing multiple sketch entities and/or BRepEdges. If a single sketch curve
        or BRepEdge is input the chainCurves argument is used to determine if connected curves or edges (they do not need to be tangent)
        should be automatically found. Searching for connected curves is only performed within the same sketch or open edges on the same
        body. If multiple curves are provided the chainCurves argument is treated as false so only the specified input curves are
        used. The input curves need to geometrically connect for a path to be created.
        chainOptions : If a single SketchCurve or BRepEdge is input, this argument is used to specify the rules in how chained entities should be found. If
        an ObjectCollection is input, this argument is ignored.
        Returns the new Path object or null in the case of a failure.
        """
        return Path()
    def item(self, index: int) -> PathEntity:
        """
        Function that returns the specified PathEntity using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return PathEntity()
    def createForAssemblyContext(self, occurrence: Occurrence) -> Path:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : 
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return Path()
    def addCurves(self, curves: core.Base, chainOptions: ChainedCurveOptions) -> bool:
        """
        Adds additional curves to the existing path. This can be useful when creating a complex path for a sweep and you
        want to include sets of curves from multiple sketches and edges from multiple bodies.
        curves : A SketchCurve, BRepEdge, or an ObjectCollection containing multiple sketch entities and/or BRepEdges. If a single sketch curve
        or BRepEdge is input the chainCurves argument is used to determine if connected curves or edges (they do not need to be tangent)
        should be automatically found. Searching for connected curves is only performed within the same sketch or open edges on the same
        body. If multiple curves are provided the chainCurves argument is treated as false so only the specified input curves are
        used. The input curves need to geometrically connect for a path to be created.
        chainOptions : If a single SketchCurve or BRepEdge is input, this argument is used to specify the rules in how chained entities should be found. If
        an ObjectCollection is input, this argument is ignored.
        Returns a bool indicating if the process was successful or not.
        """
        return bool()
    @property
    def count(self) -> int:
        """
        The number of curves in the path.
        """
        return int()
    @property
    def isClosed(self) -> bool:
        """
        Indicates if the path is closed or not. Returns True in the case of a closed path.
        """
        return bool()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        This property is not supported for the Path object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> Path:
        """
        This property is not supported for the Path object.
        """
        return Path()

class PathEntity(core.Base):
    """
    The PathEntity object represents a curve within a path
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PathEntity:
        return PathEntity()
    def createForAssemblyContext(self, occurrence: Occurrence) -> PathEntity:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : 
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return PathEntity()
    @property
    def curve(self) -> core.Curve3D:
        """
        Property that returns the geometry of the entity.
        This is different from the original path curve if the true start point is not the same as the start point of the original path curve.
        """
        return core.Curve3D()
    @property
    def curveType(self) -> core.Curve3DTypes:
        """
        Property that returns the type of the curve referenced by the path entity. This property allows you to determine what type of object will be returned by the Curve property.
        """
        return core.Curve3DTypes()
    @property
    def entity(self) -> core.Base:
        """
        Property that gets the sketch curve or edge this entity was derived from.
        """
        return core.Base()
    @property
    def parentPath(self) -> Path:
        """
        Property that returns the parent Path of the entity.
        """
        return Path()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        This property is not supported for a PathEntity object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> PathEntity:
        """
        This property is not supported for a PathEntity object.
        """
        return PathEntity()
    @property
    def isOpposedToEntity(self) -> bool:
        """
        Indicates if the orientation of this PathEntity is in the same direction or opposed to the natural direction
        of the SketchCurve or BRepEdge object it is derived from.
        """
        return bool()

class PathPatternFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a path pattern
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PathPatternFeatureInput:
        return PathPatternFeatureInput()
    @property
    def inputEntities(self) -> core.ObjectCollection:
        """
        Gets and sets the input entities. The collection can contain faces, features, bodies or occurrences.
        All of the entities must be of a single type. For example, it can't contain features and occurrences
        but only features or occurrences.
        """
        return core.ObjectCollection()
    @inputEntities.setter
    def inputEntities(self, value: core.ObjectCollection):
        """
        Gets and sets the input entities. The collection can contain faces, features, bodies or occurrences.
        All of the entities must be of a single type. For example, it can't contain features and occurrences
        but only features or occurrences.
        """
        pass
    @property
    def path(self) -> Path:
        """
        Gets and sets the path to create the pattern on path.
        """
        return Path()
    @path.setter
    def path(self, value: Path):
        """
        Gets and sets the path to create the pattern on path.
        """
        pass
    @property
    def quantity(self) -> core.ValueInput:
        """
        Gets and sets quantity of the elements.
        """
        return core.ValueInput()
    @quantity.setter
    def quantity(self, value: core.ValueInput):
        """
        Gets and sets quantity of the elements.
        """
        pass
    @property
    def distance(self) -> core.ValueInput:
        """
        Gets and sets the distance.
        """
        return core.ValueInput()
    @distance.setter
    def distance(self, value: core.ValueInput):
        """
        Gets and sets the distance.
        """
        pass
    @property
    def startPoint(self) -> float:
        """
        Gets and sets the start point on the path to count the distance.
        It's between 0 and 1. 0 means start point of the path, 1 means end point of the path.
        """
        return float()
    @startPoint.setter
    def startPoint(self, value: float):
        """
        Gets and sets the start point on the path to count the distance.
        It's between 0 and 1. 0 means start point of the path, 1 means end point of the path.
        """
        pass
    @property
    def isFlipDirection(self) -> bool:
        """
        Gets and sets if flip the direction from start point.
        """
        return bool()
    @isFlipDirection.setter
    def isFlipDirection(self, value: bool):
        """
        Gets and sets if flip the direction from start point.
        """
        pass
    @property
    def patternDistanceType(self) -> PatternDistanceType:
        """
        Gets and sets how the distance between elements is computed.
        """
        return PatternDistanceType()
    @patternDistanceType.setter
    def patternDistanceType(self, value: PatternDistanceType):
        """
        Gets and sets how the distance between elements is computed.
        """
        pass
    @property
    def isSymmetric(self) -> bool:
        """
        Gets and sets if the pattern is in one direction or symmetric.
        """
        return bool()
    @isSymmetric.setter
    def isSymmetric(self, value: bool):
        """
        Gets and sets if the pattern is in one direction or symmetric.
        """
        pass
    @property
    def isOrientationAlongPath(self) -> bool:
        """
        Gets and sets if the orientation is along path.
        If false, the orientation is identical.
        """
        return bool()
    @isOrientationAlongPath.setter
    def isOrientationAlongPath(self, value: bool):
        """
        Gets and sets if the orientation is along path.
        If false, the orientation is identical.
        """
        pass
    @property
    def patternComputeOption(self) -> PatternComputeOptions:
        """
        Gets and sets the compute option when patterning features. The default value for this is AdjustPatternCompute.
        This property only applies when patterning features and is ignored in the direct modeling environment.
        """
        return PatternComputeOptions()
    @patternComputeOption.setter
    def patternComputeOption(self, value: PatternComputeOptions):
        """
        Gets and sets the compute option when patterning features. The default value for this is AdjustPatternCompute.
        This property only applies when patterning features and is ignored in the direct modeling environment.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class PathPatternFeatures(core.Base):
    """
    Collection that provides access to all of the existing path pattern features in a component
    and supports the ability to create new path pattern features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PathPatternFeatures:
        return PathPatternFeatures()
    def item(self, index: int) -> PathPatternFeature:
        """
        Function that returns the specified path pattern feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return PathPatternFeature()
    def createInput(self, inputEntities: core.ObjectCollection, path: Path, quantity: core.ValueInput, distance: core.ValueInput, patternDistanceType: PatternDistanceType) -> PathPatternFeatureInput:
        """
        Creates a PathPatternFeatureInput object. Use properties and methods on this object
        to define the path pattern you want to create and then use the Add method, passing in
        the PathPatternFeatureInput object.
        inputEntities : The collection can contain faces, features, bodies or occurrences.
        All of the entities must be of a single type. For example, it can't contain features and occurrences
        but only features or occurrences.
        path : The Path object that represents a single set of connected curves along which to drive the pattern.
        quantity : Specifies the number of instances in the first direction.
        distance : Specifies the distance. How this value is used depends on the value of the PatternDistanceType property. A
        negative value can be used to change the direction.
        If the value is ExtentPatternDistanceType then it defines the total distance of the pattern.
        If the value is SpacingPatternDistanceType then it defines the distance between each element.
        patternDistanceType : Specifies how the distance between elements is computed.
        Returns the newly created PathPatternFeatureInput object or null if the creation failed.
        """
        return PathPatternFeatureInput()
    def add(self, input: PathPatternFeatureInput) -> PathPatternFeature:
        """
        Creates a new path pattern feature.
        input : A PathPatternFeatureInput object that defines the desired path pattern. Use the createInput
        method to create a new PathPatternFeatureInput object and then use methods on it
        (the PathPatternFeatureInput object) to define the path pattern.
        Returns the newly created PathPatternFeature object or null if the creation failed.
        """
        return PathPatternFeature()
    def itemByName(self, name: str) -> PathPatternFeature:
        """
        Function that returns the specified path pattern feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return PathPatternFeature()
    @property
    def count(self) -> int:
        """
        The number of path pattern features in the collection.
        """
        return int()

class PatternElement(core.Base):
    """
    This class defines the properties that pertain to the pattern element.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PatternElement:
        return PatternElement()
    @property
    def faces(self) -> list[BRepFace]:
        """
        Gets the faces generated as a result of this particular element.
        """
        return [BRepFace()]
    @property
    def id(self) -> int:
        """
        Gets the id of this element within the pattern.
        """
        return int()
    @property
    def parentFeature(self) -> Feature:
        """
        Gets the feature pattern this element is a member of.
        """
        return Feature()
    @property
    def isSuppressed(self) -> bool:
        """
        Gets and sets whether the element is suppressed or not. A value of True indicates it is suppressed
        """
        return bool()
    @isSuppressed.setter
    def isSuppressed(self, value: bool):
        """
        Gets and sets whether the element is suppressed or not. A value of True indicates it is suppressed
        """
        pass
    @property
    def transform(self) -> core.Matrix3D:
        """
        Get the transform that describes this elements relative position to the parent object(s).
        The transform returned for the first element in a pattern will be an identity matrix.
        """
        return core.Matrix3D()
    @property
    def name(self) -> str:
        """
        Get the name of the pattern element.
        """
        return str()
    @property
    def occurrences(self) -> list[Occurrence]:
        """
        If the patternEntityType property of the parent feature returns OccurrencesPatternType
        then this property will return the occurrences associated with this particular pattern
        element.
        """
        return [Occurrence()]

class PatternElements(core.Base):
    """
    Collection that provides access to pattern elements of mirror and pattern features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PatternElements:
        return PatternElements()
    def item(self, index: int) -> PatternElement:
        """
        Function that returns the specified pattern element using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return PatternElement()
    @property
    def count(self) -> int:
        """
        The number of pattern elements in the collection.
        """
        return int()

class PhysicalProperties(core.Base):
    """
    The physical properties of a Component, Occurrence or BRepBody
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PhysicalProperties:
        return PhysicalProperties()
    def getPrincipalAxes(self) -> tuple[bool, core.Vector3D, core.Vector3D, core.Vector3D]:
        """
        Method that returns the principal axes.
        xAxis : The output Vector3D object that indicates the direction of the x axis.
        yAxis : The output Vector3D object that indicates the direction of the y axis.
        zAxis : The output Vector3D object that indicates the direction of the z axis.
        Returns true if successful
        """
        return (bool(), core.Vector3D(), core.Vector3D(), core.Vector3D())
    def getPrincipalMomentsOfInertia(self) -> tuple[bool, float, float, float]:
        """
        Method that returns the moments of inertia about the principal axes. Unit for returned values is kg/cm^2.
        i1 : Output Double that specifies the first moment of inertia.
        i2 : Output Double that specifies the second moment of inertia.
        i3 : Output Double that specifies the third moment of inertia.
        Returns true if successful
        """
        return (bool(), float(), float(), float())
    def getRadiusOfGyration(self) -> tuple[bool, float, float, float]:
        """
        Method that returns the radius of gyration about the principal axes. Unit for returned values is cm.
        kx : Output Double that returns the X partial radius of gyration.
        ky : Output Double that returns the Y partial radius of gyration.
        kz : Output Double that returns the Z partial radius of gyration.
        Returns true if successful
        """
        return (bool(), float(), float(), float())
    def getRotationToPrincipal(self) -> tuple[bool, float, float, float]:
        """
        Gets the rotation from the world coordinate system of the target to the principal coordinate system.
        rx : 
        ry : 
        rz : 
        Returns true if successful
        """
        return (bool(), float(), float(), float())
    def getXYZMomentsOfInertia(self) -> tuple[bool, float, float, float, float, float, float]:
        """
        Method that gets the moment of inertia about the world coordinate system.
        Unit for returned values is kg/cm^2.
        xx : Output Double that returns the XX partial moment.
        yy : Output Double that returns the YY partial moment.
        zz : Output Double that returns the ZZ partial moment.
        xy : Output Double that returns the XY partial moment.
        yz : Output Double that returns the YZ partial moment.
        xz : Output Double that returns the XZ partial moment.
        Returns true if successful
        """
        return (bool(), float(), float(), float(), float(), float(), float())
    @property
    def area(self) -> float:
        """
        Gets the area in square centimeters.
        """
        return float()
    @property
    def density(self) -> float:
        """
        Gets the density in kilograms per cubic centimeter.
        """
        return float()
    @property
    def mass(self) -> float:
        """
        Gets the mass in kilograms.
        """
        return float()
    @property
    def volume(self) -> float:
        """
        Gets the volume in the cubic centimeters.
        """
        return float()
    @property
    def accuracy(self) -> CalculationAccuracy:
        """
        Returns the accuracy that was used for the calculation.
        """
        return CalculationAccuracy()
    @property
    def centerOfMass(self) -> core.Point3D:
        """
        Returns the center of mass position
        """
        return core.Point3D()

class PipeFeatures(core.Base):
    """
    Collection that provides access to all of the existing pipe features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PipeFeatures:
        return PipeFeatures()
    def item(self, index: int) -> PipeFeature:
        """
        Function that returns the specified pipe feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return PipeFeature()
    def itemByName(self, name: str) -> PipeFeature:
        """
        Function that returns the specified pipe feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return PipeFeature()
    @property
    def count(self) -> int:
        """
        The number of pipe features in the collection.
        """
        return int()

class PolygonMesh(core.Base):
    """
    The PolygonMesh represents a mesh that can contain any
    combination of polygons, quads, and triangles.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PolygonMesh:
        return PolygonMesh()
    @property
    def nodeCount(self) -> int:
        """
        Returns the number of nodes in the mesh.
        """
        return int()
    @property
    def nodeCoordinatesAsDouble(self) -> list[float]:
        """
        Returns the node coordinates as an array of doubles where
        they are the x, y, z components of each coordinate.
        """
        return [float()]
    @property
    def nodeCoordinatesAsFloat(self) -> list[float]:
        """
        Returns the node coordinates as an array of floats where
        they are the x, y, z components of each coordinate.
        """
        return [float()]
    @property
    def nodeCoordinates(self) -> list[core.Point3D]:
        """
        Returns the node coordinates as an array of Point3D objects.
        """
        return [core.Point3D()]
    @property
    def triangleCount(self) -> int:
        """
        Returns the number of triangles in the mesh.
        """
        return int()
    @property
    def quadCount(self) -> int:
        """
        Returns the number of quads in the mesh.
        """
        return int()
    @property
    def polygonCount(self) -> int:
        """
        Returns the number of polygons (more than 4 sides) in the mesh.
        """
        return int()
    @property
    def normalVectorsAsDouble(self) -> list[float]:
        """
        Returns the normal vectors as an array of doubles where
        they are the x, y, z components of each vector. There is one normal vector for each index.
        """
        return [float()]
    @property
    def normalVectorsAsFloat(self) -> list[float]:
        """
        Returns the normal vectors as an array of floats. There is one normal vector for each index.
        """
        return [float()]
    @property
    def normalVectors(self) -> list[core.Vector3D]:
        """
        Returns the normal vectors as an array of Vector 3D objects. There is one normal vector for each index.
        """
        return [core.Vector3D()]
    @property
    def triangleNodeIndices(self) -> list[int]:
        """
        Returns the index values that index into the NodeCoordinates and NormalVectors arrays to
        define the three coordinates of each triangle and the corresponding normal.
        """
        return [int()]
    @property
    def quadNodeIndices(self) -> list[int]:
        """
        Returns the index values that index into the NodeCoordinates and NormalVectors arrays to
        define the four coordinates of each quad and the corresponding normal.
        """
        return [int()]
    @property
    def polygonNodeIndices(self) -> list[int]:
        """
        Returns the index values that index into the NodeCoordinates and NormalVectors arrays to
        define the coordinates of each polygon and the corresponding normal.
        """
        return [int()]
    @property
    def nodeCountPerPolygon(self) -> list[int]:
        """
        Returns the number of nodes that define each polygon. For example,
        if NodeCountPerPolygon[0] returns 6 it indicates the first polygon
        is defined using 6 nodes. The first six indices returned by the
        PolygonNodeIndices properties provide the look-up into the NodeCoordinates
        array.
        """
        return [int()]

class Profile(core.Base):
    """
    Represents a profile in a sketch. Profiles are automatically computed by Fusion 360 and
    represent closed areas within the sketch.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Profile:
        return Profile()
    def createForAssemblyContext(self, occurrence: Occurrence) -> Profile:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        Returns null if this isn't the NativeObject.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return Profile()
    def areaProperties(self, accuracy: CalculationAccuracy) -> AreaProperties:
        """
        Calculates the area properties for the profile.
        accuracy : Specifies the desired level of computational accuracy of the property calculations.
        The default value of 'LowCalculationAccuracy' returns results within a +/- 1% error margin.
        Returns the AreaProperties object that has properties for getting the area, perimeter, centroid, etc
        of this profile.
        """
        return AreaProperties()
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns the 3D bounding box of the profile in sketch space.
        """
        return core.BoundingBox3D()
    @property
    def plane(self) -> core.Plane:
        """
        Returns the plane the profile is defined in. Profiles are always planar and exist within
        a single plane.
        """
        return core.Plane()
    @property
    def profileLoops(self) -> ProfileLoops:
        """
        The loops or closed areas within this profile. There is always a single outer loop
        but there can be zero to many inner loops defining voids in the profile.
        """
        return ProfileLoops()
    @property
    def parentSketch(self) -> Sketch:
        """
        Returns the parent sketch of the profile.
        """
        return Sketch()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this
        object in an assembly. This is only valid in the case where this
        is acting as a proxy in an assembly. Returns null
        in the case where the object is not in the context of an assembly.
        but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> Profile:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return Profile()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the Profile object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same profile.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class ProfileCurve(core.Base):
    """
    A single curve in a profile.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ProfileCurve:
        return ProfileCurve()
    def createForAssemblyContext(self, occurrence: Occurrence) -> ProfileCurve:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        Returns null if this isn't the NativeObject.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return ProfileCurve()
    @property
    def geometry(self) -> core.Curve3D:
        """
        Returns the geometric entity of this portion of the profile.
        """
        return core.Curve3D()
    @property
    def geometryType(self) -> core.Curve3DTypes:
        """
        Return the geometry type that the Geometry property will return.
        """
        return core.Curve3DTypes()
    @property
    def sketchEntity(self) -> SketchEntity:
        """
        Returns the associated sketch entity that defines this curve.
        """
        return SketchEntity()
    @property
    def parentProfileLoop(self) -> ProfileLoop:
        """
        Returns the parent ProfileLoop object.
        """
        return ProfileLoop()
    @property
    def parentProfile(self) -> Profile:
        """
        Returns the parent Profile object.
        """
        return Profile()
    @property
    def parentSketch(self) -> Sketch:
        """
        Returns the parent Profile object.
        """
        return Sketch()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> ProfileCurve:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return ProfileCurve()
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns the bounding box of the profile curve in sketch space.
        """
        return core.BoundingBox3D()

class ProfileCurves(core.Base):
    """
    A collection of profile curves within a profile loop.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ProfileCurves:
        return ProfileCurves()
    def item(self, index: int) -> ProfileCurve:
        """
        Function that returns the specified profile curve using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ProfileCurve()
    @property
    def count(self) -> int:
        """
        Returns the number of curves in the collection.
        """
        return int()

class ProfileLoop(core.Base):
    """
    A loop within a profile.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ProfileLoop:
        return ProfileLoop()
    def createForAssemblyContext(self, occurrence: Occurrence) -> ProfileLoop:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        Returns null if this isn't the NativeObject.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return ProfileLoop()
    @property
    def isOuter(self) -> bool:
        """
        Indicates if this is an outer or inner loop. Profiles always have
        one outer loop and have an zero to many inner loops defining voids.
        """
        return bool()
    @property
    def profileCurves(self) -> ProfileCurves:
        """
        Returns a collection of the curves making up this loop.
        """
        return ProfileCurves()
    @property
    def parentProfile(self) -> Profile:
        """
        Returns the parent Profile object.
        """
        return Profile()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> ProfileLoop:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return ProfileLoop()

class ProfileLoops(core.Base):
    """
    A collection of loops within a Profile.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ProfileLoops:
        return ProfileLoops()
    def item(self, index: int) -> ProfileLoop:
        """
        Function that returns the specified profile loop using an index into the collection.
        index : The index of the item within the collection to return.
        The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ProfileLoop()
    @property
    def count(self) -> int:
        """
        Returns the number of loops within this profile.
        """
        return int()

class Profiles(core.Base):
    """
    A collection of all of the closed profiles currently calculated for this sketch. Closed profiles are
    automatically computed by Fusion 360 and represent closed areas within the sketch.
    
    This class also provides some additional utility functions to create open profiles and text based profiles
    that can be used as input for various features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Profiles:
        return Profiles()
    def item(self, index: int) -> Profile:
        """
        Function that returns the specified closed profile using an index into the collection.
        index : The index of the item within the collection to return. The first item in the
        collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Profile()
    @property
    def count(self) -> int:
        """
        Returns the number of closed profiles in the sketch. Open and text based profiles are not included.
        """
        return int()

class RectangularPatternFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a rectangular pattern
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RectangularPatternFeatureInput:
        return RectangularPatternFeatureInput()
    def setDirectionTwo(self, directionTwoEntity: core.Base, quantityTwo: core.ValueInput, distanceTwo: core.ValueInput) -> bool:
        """
        Sets all of the input required to define the pattern in the second direction.
        directionTwoEntity : Specifies the entity used to define the second direction entity. This can be a linear edge, construction axis, sketch line or rectangular pattern feature.
        If a rectangular pattern feature is set, the directionOneEntity and directionTwoEntity properties return the same rectangular pattern feature.
        
        This argument can be null to indicate that the default second direction is to be used, which is 90 degrees to the first direction.
        quantityTwo : Specifies the number of instances in the second direction.
        distanceTwo : Specifies the distance in the second direction. How this value is used depends on the value of the PatternDistanceType property.
        If the value is ExtentPatternDistanceType then it defines the total distance of the pattern.
        If the value is SpacingPatternDistanceType then it defines the distance between each element.
        Returns true if it was successful.
        """
        return bool()
    @property
    def inputEntities(self) -> core.ObjectCollection:
        """
        Gets and sets the input entities. The collection can contain faces, features, bodies or occurrences.
        All of the entities must be of a single type. For example, it can't contain features and occurrences
        but only features or occurrences.
        """
        return core.ObjectCollection()
    @inputEntities.setter
    def inputEntities(self, value: core.ObjectCollection):
        """
        Gets and sets the input entities. The collection can contain faces, features, bodies or occurrences.
        All of the entities must be of a single type. For example, it can't contain features and occurrences
        but only features or occurrences.
        """
        pass
    @property
    def directionOneEntity(self) -> core.Base:
        """
        Gets and sets the first direction entity.
        This can be a linear edge, construction axis, sketch line or rectangular pattern feature.
        If a rectangular pattern feature is set, the directionOneEntity and directionTwoEntity properties return the same rectangular pattern feature.
        """
        return core.Base()
    @directionOneEntity.setter
    def directionOneEntity(self, value: core.Base):
        """
        Gets and sets the first direction entity.
        This can be a linear edge, construction axis, sketch line or rectangular pattern feature.
        If a rectangular pattern feature is set, the directionOneEntity and directionTwoEntity properties return the same rectangular pattern feature.
        """
        pass
    @property
    def directionTwoEntity(self) -> core.Base:
        """
        Gets and sets the second direction entity.
        This can be a linear edge, construction axis, sketch line or rectangular pattern feature.
        If a rectangular pattern feature is set, the directionOneEntity and directionTwoEntity properties return the same rectangular pattern feature.
        """
        return core.Base()
    @directionTwoEntity.setter
    def directionTwoEntity(self, value: core.Base):
        """
        Gets and sets the second direction entity.
        This can be a linear edge, construction axis, sketch line or rectangular pattern feature.
        If a rectangular pattern feature is set, the directionOneEntity and directionTwoEntity properties return the same rectangular pattern feature.
        """
        pass
    @property
    def quantityOne(self) -> core.ValueInput:
        """
        Gets and sets the number of instances in the first direction.
        """
        return core.ValueInput()
    @quantityOne.setter
    def quantityOne(self, value: core.ValueInput):
        """
        Gets and sets the number of instances in the first direction.
        """
        pass
    @property
    def quantityTwo(self) -> core.ValueInput:
        """
        Gets and sets the number of instances in the second direction.
        """
        return core.ValueInput()
    @quantityTwo.setter
    def quantityTwo(self, value: core.ValueInput):
        """
        Gets and sets the number of instances in the second direction.
        """
        pass
    @property
    def distanceOne(self) -> core.ValueInput:
        """
        Gets and sets the distance in the first direction.
        """
        return core.ValueInput()
    @distanceOne.setter
    def distanceOne(self, value: core.ValueInput):
        """
        Gets and sets the distance in the first direction.
        """
        pass
    @property
    def distanceTwo(self) -> core.ValueInput:
        """
        Gets and sets the distance in the second direction.
        """
        return core.ValueInput()
    @distanceTwo.setter
    def distanceTwo(self, value: core.ValueInput):
        """
        Gets and sets the distance in the second direction.
        """
        pass
    @property
    def directionOne(self) -> core.Vector3D:
        """
        Returns a Vector3D indicating the positive direction of direction one.
        """
        return core.Vector3D()
    @property
    def directionTwo(self) -> core.Vector3D:
        """
        Returns a Vector3D indicating the positive direction of direction two.
        """
        return core.Vector3D()
    @property
    def isSymmetricInDirectionOne(self) -> bool:
        """
        Gets and sets if the pattern in direction one is in one direction or symmetric.
        """
        return bool()
    @isSymmetricInDirectionOne.setter
    def isSymmetricInDirectionOne(self, value: bool):
        """
        Gets and sets if the pattern in direction one is in one direction or symmetric.
        """
        pass
    @property
    def isSymmetricInDirectionTwo(self) -> bool:
        """
        Gets and sets if the pattern in direction two is in one direction or symmetric.
        """
        return bool()
    @isSymmetricInDirectionTwo.setter
    def isSymmetricInDirectionTwo(self, value: bool):
        """
        Gets and sets if the pattern in direction two is in one direction or symmetric.
        """
        pass
    @property
    def patternDistanceType(self) -> PatternDistanceType:
        """
        Gets and sets how the distance between elements is computed.
        """
        return PatternDistanceType()
    @patternDistanceType.setter
    def patternDistanceType(self, value: PatternDistanceType):
        """
        Gets and sets how the distance between elements is computed.
        """
        pass
    @property
    def patternComputeOption(self) -> PatternComputeOptions:
        """
        Gets and sets the compute option when patterning features. The default value for this is AdjustPatternCompute.
        This property only applies when patterning features and is ignored in the direct modeling environment.
        """
        return PatternComputeOptions()
    @patternComputeOption.setter
    def patternComputeOption(self, value: PatternComputeOptions):
        """
        Gets and sets the compute option when patterning features. The default value for this is AdjustPatternCompute.
        This property only applies when patterning features and is ignored in the direct modeling environment.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class RectangularPatternFeatures(core.Base):
    """
    Collection that provides access to all of the existing rectangular pattern features in a component
    and supports the ability to create new rectangular pattern features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RectangularPatternFeatures:
        return RectangularPatternFeatures()
    def item(self, index: int) -> RectangularPatternFeature:
        """
        Function that returns the specified rectangular pattern feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return RectangularPatternFeature()
    def createInput(self, inputEntities: core.ObjectCollection, directionOneEntity: core.Base, quantityOne: core.ValueInput, distanceOne: core.ValueInput, patternDistanceType: PatternDistanceType) -> RectangularPatternFeatureInput:
        """
        Creates a RectangularPatternFeatureInput object. Use properties and methods on this object
        to define the rectangular pattern you want to create and then use the Add method, passing in
        the RectangularPatternFeatureInput object.
        inputEntities : The collection can contain faces, features, bodies or occurrences.
        All of the entities must be of a single type. For example, it can't contain features and occurrences
        but only features or occurrences.
        directionOneEntity : Specifies the entity used to define the first direction entity. This can be a linear edge, construction axis, sketch line or rectangular pattern feature.
        If a rectangular pattern feature is set, the directionOneEntity and directionTwoEntity properties return the same rectangular pattern feature.
        quantityOne : Specifies the number of instances in the first direction.
        distanceOne : Specifies the distance in the first direction. How this value is used depends on the value of the PatternDistanceType property. A
        negative value can be used to change the direction.
        If the value is ExtentPatternDistanceType then it defines the total distance of the pattern.
        If the value is SpacingPatternDistanceType then it defines the distance between each element.
        patternDistanceType : Specifies how the distance between elements is computed.
        Returns the newly created RectangularPatternFeatureInput object or null if the creation failed.
        """
        return RectangularPatternFeatureInput()
    def add(self, input: RectangularPatternFeatureInput) -> RectangularPatternFeature:
        """
        Creates a new rectangular pattern feature.
        input : A RectangularPatternFeatureInput object that defines the desired rectangular pattern. Use the createInput
        method to create a new RectangularPatternFeatureInput object and then use methods on it
        (the RectangularPatternFeatureInput object) to define the rectangular pattern.
        Returns the newly created RectangularPatternFeature object or null if the creation failed.
        """
        return RectangularPatternFeature()
    def itemByName(self, name: str) -> RectangularPatternFeature:
        """
        Function that returns the specified rectangular pattern feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return RectangularPatternFeature()
    @property
    def count(self) -> int:
        """
        The number of rectangular pattern features in the collection.
        """
        return int()

class RefoldFeatures(core.Base):
    """
    Collection that provides access to all of the existing refold features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RefoldFeatures:
        return RefoldFeatures()
    def item(self, index: int) -> RefoldFeature:
        """
        Function that returns the specified refold feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return RefoldFeature()
    def itemByName(self, name: str) -> RefoldFeature:
        """
        Function that returns the specified refold feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return RefoldFeature()
    @property
    def count(self) -> int:
        """
        The number of refold features in the collection.
        """
        return int()

class RemoveFeatures(core.Base):
    """
    Collection that provides access to all of the existing Remove features in a component
    and supports the ability to create new Remove features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RemoveFeatures:
        return RemoveFeatures()
    def item(self, index: int) -> RemoveFeature:
        """
        Function that returns the specified Remove feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return RemoveFeature()
    def itemByName(self, name: str) -> RemoveFeature:
        """
        Function that returns the specified remove feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return RemoveFeature()
    def add(self, itemToRemove: core.Base) -> RemoveFeature:
        """
        Creates a new Remove feature.
        itemToRemove : A single body (solid or surface) or component occurrence to remove.
        Returns the newly created RemoveFeature object or null if the creation failed.
        """
        return RemoveFeature()
    @property
    def count(self) -> int:
        """
        The number of Remove features in the collection.
        """
        return int()

class ReplaceFaceFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a replace face feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ReplaceFaceFeatureInput:
        return ReplaceFaceFeatureInput()
    @property
    def sourceFaces(self) -> core.ObjectCollection:
        """
        Gets and sets the entities that define the source faces to perform replace.
        The collection can contain the faces from a solid and/or from features. All the faces must be on the same body.
        """
        return core.ObjectCollection()
    @sourceFaces.setter
    def sourceFaces(self, value: core.ObjectCollection):
        """
        Gets and sets the entities that define the source faces to perform replace.
        The collection can contain the faces from a solid and/or from features. All the faces must be on the same body.
        """
        pass
    @property
    def targetFaces(self) -> core.Base:
        """
        Gets and sets the entities that define the target faces. The new faces must completely intersect the part.
        The collection can contain the surface faces, surface bodies and construction planes.
        """
        return core.Base()
    @targetFaces.setter
    def targetFaces(self, value: core.Base):
        """
        Gets and sets the entities that define the target faces. The new faces must completely intersect the part.
        The collection can contain the surface faces, surface bodies and construction planes.
        """
        pass
    @property
    def isTangentChain(self) -> bool:
        """
        Gets and sets if any faces that are tangentially connected to any of
        the input faces will also be included in setting InputEntities. It defaults to true.
        """
        return bool()
    @isTangentChain.setter
    def isTangentChain(self, value: bool):
        """
        Gets and sets if any faces that are tangentially connected to any of
        the input faces will also be included in setting InputEntities. It defaults to true.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class ReplaceFaceFeatures(core.Base):
    """
    Collection that provides access to all of the existing replace face features in a component
    and supports the ability to create new replace face features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ReplaceFaceFeatures:
        return ReplaceFaceFeatures()
    def item(self, index: int) -> ReplaceFaceFeature:
        """
        Function that returns the specified replace face feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ReplaceFaceFeature()
    def createInput(self, sourceFaces: core.ObjectCollection, isTangentChain: bool, targetFaces: core.Base) -> ReplaceFaceFeatureInput:
        """
        Creates a ReplaceFaceFeatureInput object. Use properties and methods on this object
        to define the replace face you want to create and then use the Add method, passing in
        the ReplaceFaceFeatureInput object.
        sourceFaces : Input the entities that define the source faces (the faces to be replaced).
        The collection can contain the faces from a solid and/or features. All the faces must be on the same body.
        isTangentChain : A boolean value for setting whether or not faces that are tangentially connected to
        the input faces (if any) will also be included. A value of true indicates that tangent
        faces will be included.
        targetFaces : Input the entities that define the target faces. The new faces must completely intersect the part.
        The collection can contain the surface faces, surface bodies and construction planes.
        Returns the newly created ReplaceFaceFeatureInput object or null if the creation failed.
        """
        return ReplaceFaceFeatureInput()
    def add(self, input: ReplaceFaceFeatureInput) -> ReplaceFaceFeature:
        """
        Creates a new replace face feature.
        input : A ReplaceFaceFeatureInput object that defines the desired replace face. Use the createInput
        method to create a new ReplaceFaceFeatureInput object and then use methods on it
        (the ReplaceFaceFeatureInput object) to define the replace face.
        Returns the newly created ReplaceFaceFeature object or null if the creation failed.
        """
        return ReplaceFaceFeature()
    def itemByName(self, name: str) -> ReplaceFaceFeature:
        """
        Function that returns the specified replace face feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return ReplaceFaceFeature()
    @property
    def count(self) -> int:
        """
        The number of replace face features in the collection.
        """
        return int()

class ReverseNormalFeatures(core.Base):
    """
    Collection that provides access to all of the existing Reverse Normal features in a component
    and supports the ability to create new Reverse Normal features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ReverseNormalFeatures:
        return ReverseNormalFeatures()
    def item(self, index: int) -> ReverseNormalFeature:
        """
        Function that returns the specified Reverse Normal feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ReverseNormalFeature()
    def itemByName(self, name: str) -> ReverseNormalFeature:
        """
        Function that returns the specified reverse normal feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return ReverseNormalFeature()
    def add(self, surfaces: core.ObjectCollection) -> ReverseNormalFeature:
        """
        Creates a new Reverse Normal feature.
        surfaces : One or more surface bodies (open BRepBodies) containing the faces whose normals are to be reversed.
        All faces of the input surface bodies get reversed.
        Returns the newly created ReverseNormalFeature object or null if the creation failed.
        """
        return ReverseNormalFeature()
    @property
    def count(self) -> int:
        """
        The number of Reverse Normal features in the collection.
        """
        return int()

class RevolveFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a revolve
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RevolveFeatureInput:
        return RevolveFeatureInput()
    def setAngleExtent(self, isSymmetric: bool, angle: core.ValueInput) -> bool:
        """
        Defines the extent of the revolution to be at a specified angle.
        An angle and whether the extent is symmetric or only in one direction
        is specified. If it's not symmetric a positive or negative angle can be
        used to control the direction. If symmetric, the angle is the angle on one
        side so the entire angle of the revolution will be twice the specified angle.
        Use an angle of 360 deg or 2 pi radians to create a full revolve.
        isSymmetric : Set to 'true' for a revolve symmetrical about the profile plane
        angle : The ValueInput object that defines the angle of the revolution
        Returns true if successful
        """
        return bool()
    def setTwoSideAngleExtent(self, angleOne: core.ValueInput, angleTwo: core.ValueInput) -> bool:
        """
        Defines the angle of the revolve to be to applied to both sides of the profile
        at the specified angles.
        angleOne : The ValueInput object that defines the angle for the first side of the revolution
        angleTwo : The ValueInput object that defines the angle for the second side of the revolution
        Returns true if successful
        """
        return bool()
    def setOneSideToExtent(self, toEntity: core.Base, directionHint: core.Vector3D) -> bool:
        """
        Defines the extent of the revolve to be from the sketch or profile plane to the
        specified "To" face.
        toEntity : The entity that defines the "to" extent. The valid types of entities can vary depending on
        the type of feature this is being used with. For a revolve it can be a BRepBody, BRepFace,
        BRepVertex, ConstructionPlane, or ConstructionPoint.
        directionHint : Specifies the direction of the revolve.
        Returns true if successful.
        """
        return bool()
    def setTwoSideToExtent(self, toEntityOne: core.Base, toEntityTwo: core.Base) -> bool:
        """
        Defines the extents of the revolve to be from the sketch plane to specified
        faces in both directions. If the matchShape argument is true, the faces to revolve to
        are extended to fully intersect the revolve.
        toEntityOne : The first entity that defines the "to" extent. The valid types of entities can vary depending on
        the type of feature this is being used with. For a revolve it can be a BRepBody, BRepFace,
        BRepVertex, ConstructionPlane, or ConstructionPoint.
        toEntityTwo : The second entity that defines the "to" extent. The valid types of entities can vary depending on
        the type of feature this is being used with. For a revolve it can be a BRepBody, BRepFace,
        BRepVertex, ConstructionPlane, or ConstructionPoint.
        Returns true if successful.
        """
        return bool()
    @property
    def profile(self) -> core.Base:
        """
        Gets and sets the profiles or planar faces used to define the shape of the revolve.
        This property can return or be set with a single Profile, a single planar face, or
        an ObjectCollection consisting of multiple profiles and planar faces. When an
        ObjectCollection is used all of the profiles and faces must be co-planar.
        This property returns null in the case where the feature is non-parametric.
        
        To create a surface (non-solid) revolution, you can use the createOpenProfile and createBRepEdgeProfile
        methods of the Component object to create an open profile. The isSolid property of the
        RevolveFeatureInput property must also be False.
        """
        return core.Base()
    @profile.setter
    def profile(self, value: core.Base):
        """
        Gets and sets the profiles or planar faces used to define the shape of the revolve.
        This property can return or be set with a single Profile, a single planar face, or
        an ObjectCollection consisting of multiple profiles and planar faces. When an
        ObjectCollection is used all of the profiles and faces must be co-planar.
        This property returns null in the case where the feature is non-parametric.
        
        To create a surface (non-solid) revolution, you can use the createOpenProfile and createBRepEdgeProfile
        methods of the Component object to create an open profile. The isSolid property of the
        RevolveFeatureInput property must also be False.
        """
        pass
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the type of operation performed by the revolve.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the type of operation performed by the revolve.
        """
        pass
    @property
    def axis(self) -> core.Base:
        """
        Gets and sets the entity used to define the axis of revolution.
        The axis can be a sketch line, construction axis, or linear edge. If it is not in
        the same plane as the profile, it is projected onto the profile plane.
        """
        return core.Base()
    @axis.setter
    def axis(self, value: core.Base):
        """
        Gets and sets the entity used to define the axis of revolution.
        The axis can be a sketch line, construction axis, or linear edge. If it is not in
        the same plane as the profile, it is projected onto the profile plane.
        """
        pass
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Revolve is created based on geometry (e.g. a profile and/or face(s))
        in another component AND (the Revolve) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Revolve is created based on geometry (e.g. a profile and/or face(s))
        in another component AND (the Revolve) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        pass
    @property
    def isSolid(self) -> bool:
        """
        Specifies if the revolution should be created as a solid or surface. If
        it's a surface then there aren't any end caps and it's open. This is
        initialized to true so a solid will be created if it's not changed.
        """
        return bool()
    @isSolid.setter
    def isSolid(self, value: bool):
        """
        Specifies if the revolution should be created as a solid or surface. If
        it's a surface then there aren't any end caps and it's open. This is
        initialized to true so a solid will be created if it's not changed.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass
    @property
    def participantBodies(self) -> list[BRepBody]:
        """
        Gets and sets the list of bodies that will participate in the feature when the operation is a cut or intersection.
        
        If this property has not been set, the default behavior is that all bodies that are intersected by the
        feature will participate.
        
        This property can return null in the case where the feature has not been fully defined so that
        possible intersecting bodies can be computed.
        """
        return [BRepBody()]
    @participantBodies.setter
    def participantBodies(self, value: list[BRepBody]):
        """
        Gets and sets the list of bodies that will participate in the feature when the operation is a cut or intersection.
        
        If this property has not been set, the default behavior is that all bodies that are intersected by the
        feature will participate.
        
        This property can return null in the case where the feature has not been fully defined so that
        possible intersecting bodies can be computed.
        """
        pass

class RevolveFeatures(core.Base):
    """
    Collection that provides access to all of the existing revolve features in a design
    and supports the ability to create new revolve features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RevolveFeatures:
        return RevolveFeatures()
    def item(self, index: int) -> RevolveFeature:
        """
        Function that returns the specified revolve feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return RevolveFeature()
    def createInput(self, profile: core.Base, axis: core.Base, operation: FeatureOperations) -> RevolveFeatureInput:
        """
        Creates a new RevolveFeatureInput object that is used to specify the input needed
        to create a new revolve feature.
        profile : The profile argument can be a single Profile, a single
        planar face, or an ObjectCollection consisting of multiple profiles and planar faces.
        When an ObjectCollection is used all of the profiles and faces must be co-planar.
        
        To create a surface (non-solid) revolution, you can use the createOpenProfile and createBRepEdgeProfile
        methods of the Component object to create an open profile. You also need to set the isSolid property
        of the returned RevolveFeatureInput property to False.
        axis : The axis can be a sketch line, construction axis, or linear edge. If it is not in
        the same plane as the profile, it is projected onto the profile plane.
        operation : The operation type to perform.
        Returns the newly created RevolveFeatureInput object or null if the creation failed.
        """
        return RevolveFeatureInput()
    def add(self, input: RevolveFeatureInput) -> RevolveFeature:
        """
        Creates a new revolve feature based on the information provided by the provided
        RevolveFeatureInput object.
        To create a new revolve, use the createInput function to create a new input object
        and then use the methods and properties on that object to define the required input
        for a revolve. Once the information is defined on the input object you can pass it
        to the Add method to create the revolve.
        input : The RevolveFeatureInput object that specifies the input needed to create a new extrude
        Returns the newly created RevolveFeature or null if the creation failed.
        """
        return RevolveFeature()
    def itemByName(self, name: str) -> RevolveFeature:
        """
        Function that returns the specified revolve feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return RevolveFeature()
    @property
    def count(self) -> int:
        """
        The number of revolve features in the collection.
        """
        return int()

class RibFeatures(core.Base):
    """
    Collection that provides access to all of the existing rib features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RibFeatures:
        return RibFeatures()
    def item(self, index: int) -> RibFeature:
        """
        Function that returns the specified Rib feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return RibFeature()
    def itemByName(self, name: str) -> RibFeature:
        """
        Function that returns the specified Rib feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return RibFeature()
    @property
    def count(self) -> int:
        """
        The number of Rib features in the collection.
        """
        return int()

class RigidGroup(core.Base):
    """
    Represents a rigid group within an assembly.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RigidGroup:
        return RigidGroup()
    def deleteMe(self) -> bool:
        """
        Deletes this rigid group.
        Returns True if the delete was successful.
        """
        return bool()
    def setOccurrences(self, occurrences: core.ObjectCollection, includeChildren: bool) -> bool:
        """
        Sets which occurrences are to be part of this rigid group.
        
        To use this method, you need to position the timeline marker to immediately before this group.
        This can be accomplished using the following code: group.timelineObject.rollTo(True)
        occurrences : An ObjectCollection containing the occurrences to use in creating the rigid group.
        includeChildren : Boolean indicating if the children of the input occurrences should be included in the rigid group.
        Returns true if successful.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> RigidGroup:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return RigidGroup()
    @property
    def parentComponent(self) -> Component:
        """
        Returns the parent component that owns this rigid group.
        """
        return Component()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of the rigid group as seen in the timeline.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of the rigid group as seen in the timeline.
        """
        pass
    @property
    def occurrences(self) -> OccurrenceList:
        """
        Returns the list of occurrences that are part of the rigid group.
        """
        return OccurrenceList()
    @property
    def timelineObject(self) -> TimelineObject:
        """
        Returns the timeline object associated with this rigid group.
        """
        return TimelineObject()
    @property
    def isSuppressed(self) -> bool:
        """
        Gets and sets if this rigid group is suppressed.
        """
        return bool()
    @isSuppressed.setter
    def isSuppressed(self, value: bool):
        """
        Gets and sets if this rigid group is suppressed.
        """
        pass
    @property
    def nativeObject(self) -> RigidGroup:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return RigidGroup()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this rigid group.
        """
        return core.Attributes()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the RigidGroup object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same rigid group.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class RigidGroupList(core.Base):
    """
    A list of rigid groups.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RigidGroupList:
        return RigidGroupList()
    def item(self, index: int) -> RigidGroup:
        """
        Function that returns the specified rigid group using an index into the list.
        index : The index of the item within the list to return. The first item in the list has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return RigidGroup()
    def itemByName(self, name: str) -> RigidGroup:
        """
        Function that returns the specified rigid group using a name.
        name : The name of the item within the list to return.
        Returns the specified item or null if an invalid name was specified.
        """
        return RigidGroup()
    @property
    def count(self) -> int:
        """
        Returns number of rigid groups in the list.
        """
        return int()

class RigidGroups(core.Base):
    """
    The collection of rigid groups in this component. This provides access to all existing
    rigid groups and supports the ability to create new rigid groups.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RigidGroups:
        return RigidGroups()
    def item(self, index: int) -> RigidGroup:
        """
        Function that returns the specified rigid group using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return RigidGroup()
    def itemByName(self, name: str) -> RigidGroup:
        """
        Function that returns the specified rigid group using a name.
        name : The name of the item within the collection to return.
        Returns the specified item or null if an invalid name was specified.
        """
        return RigidGroup()
    def add(self, occurrences: core.ObjectCollection, includeChildren: bool) -> RigidGroup:
        """
        Creates a new rigid group.
        occurrences : An ObjectCollection containing the occurrences to use in creating the rigid group.
        includeChildren : Boolean indicating if the children of the input occurrences should be included in the rigid group.
        Returns the new RigidGroup object or null in the case of failure.
        """
        return RigidGroup()
    @property
    def count(self) -> int:
        """
        Returns number of joint origins in the collection.
        """
        return int()

class RuledSurfaceFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a Ruled Surface feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RuledSurfaceFeatureInput:
        return RuledSurfaceFeatureInput()
    @property
    def profile(self) -> core.Base:
        """
        Gets and sets the Profile object that defines the sketch geometry or edges that define the shape of
        the ruled surface. The Component.createBRepEdgeProfile method is useful to create a profile defined from edges.
        """
        return core.Base()
    @profile.setter
    def profile(self, value: core.Base):
        """
        Gets and sets the Profile object that defines the sketch geometry or edges that define the shape of
        the ruled surface. The Component.createBRepEdgeProfile method is useful to create a profile defined from edges.
        """
        pass
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Ruled Surface is created based on geometry (e.g. a profile)
        in another component AND (the Ruled Surface) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the Ruled Surface is created based on geometry (e.g. a profile)
        in another component AND (the Ruled Surface) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        pass
    @property
    def distance(self) -> core.ValueInput:
        """
        Gets and sets the ValueInput object that defines the Ruled Surface distance. If the value input is
        a real value it will define the distance in centimeters.
        """
        return core.ValueInput()
    @distance.setter
    def distance(self, value: core.ValueInput):
        """
        Gets and sets the ValueInput object that defines the Ruled Surface distance. If the value input is
        a real value it will define the distance in centimeters.
        """
        pass
    @property
    def angle(self) -> core.ValueInput:
        """
        Gets and sets the ValueInput object that defines the Ruled Surface angle.
        If the input is a real value, the units are radians.
        """
        return core.ValueInput()
    @angle.setter
    def angle(self, value: core.ValueInput):
        """
        Gets and sets the ValueInput object that defines the Ruled Surface angle.
        If the input is a real value, the units are radians.
        """
        pass
    @property
    def ruledSurfaceType(self) -> RuledSurfaceTypes:
        """
        Gets and sets the type of ruled surface to create. To set this to DirectionRuledSurfaceType,
        use the direction property to set the direction entity, which will automatically set
        this to DirectionRuledSurfaceType.
        """
        return RuledSurfaceTypes()
    @ruledSurfaceType.setter
    def ruledSurfaceType(self, value: RuledSurfaceTypes):
        """
        Gets and sets the type of ruled surface to create. To set this to DirectionRuledSurfaceType,
        use the direction property to set the direction entity, which will automatically set
        this to DirectionRuledSurfaceType.
        """
        pass
    @property
    def direction(self) -> core.Base:
        """
        Gets and sets the entity that defines the direction when the ruled surface type is DirectionRuledSurfaceType.
        The direction is specified by providing a linear or planar entity. For example, a linear edge, construction axis,
        planar face, or construction plane can be used as input.
        
        If this property is set when the ruledSurfaceType is not DirectionRuledSurfaceType, the type will automatically be
        changed to DirectionRuledSurfaceType. If you get this property when the direction is not DirectionRuledSurfaceType,
        it will return null.
        """
        return core.Base()
    @direction.setter
    def direction(self, value: core.Base):
        """
        Gets and sets the entity that defines the direction when the ruled surface type is DirectionRuledSurfaceType.
        The direction is specified by providing a linear or planar entity. For example, a linear edge, construction axis,
        planar face, or construction plane can be used as input.
        
        If this property is set when the ruledSurfaceType is not DirectionRuledSurfaceType, the type will automatically be
        changed to DirectionRuledSurfaceType. If you get this property when the direction is not DirectionRuledSurfaceType,
        it will return null.
        """
        pass
    @property
    def alternateFace(self) -> bool:
        """
        Gets and sets if the other face is used for creation of the Ruled Surface.
        When creating a ruled surface using the edges of a solid or the interior edges
        of a surface the angle of the ruled surface is measured with respect to the
        face the selected edge is bounding. For a solid, or an interior edge on a surface,
        the edge connects to two faces. This setting toggles which of the two faces will
        be used for measuring the angle.
        """
        return bool()
    @alternateFace.setter
    def alternateFace(self, value: bool):
        """
        Gets and sets if the other face is used for creation of the Ruled Surface.
        When creating a ruled surface using the edges of a solid or the interior edges
        of a surface the angle of the ruled surface is measured with respect to the
        face the selected edge is bounding. For a solid, or an interior edge on a surface,
        the edge connects to two faces. This setting toggles which of the two faces will
        be used for measuring the angle.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the type of operation performed by the ruled surface.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the type of operation performed by the ruled surface.
        """
        pass
    @property
    def cornerType(self) -> RuledSurfaceCornerTypes:
        """
        Gets and sets the corner type for the ruled surface, indicating if the corners will be rounded or mitered.
        The default value is rounded.
        """
        return RuledSurfaceCornerTypes()
    @cornerType.setter
    def cornerType(self, value: RuledSurfaceCornerTypes):
        """
        Gets and sets the corner type for the ruled surface, indicating if the corners will be rounded or mitered.
        The default value is rounded.
        """
        pass

class RuledSurfaceFeatures(core.Base):
    """
    Collection that provides access to all of the existing Ruled Surface features in a component
    and supports the ability to create new Ruled Surface features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RuledSurfaceFeatures:
        return RuledSurfaceFeatures()
    def item(self, index: int) -> RuledSurfaceFeature:
        """
        Function that returns the specified ruled surface feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return RuledSurfaceFeature()
    def createInput(self, profile: core.Base, distance: core.ValueInput, angle: core.ValueInput, ruledSurfaceType: RuledSurfaceTypes, direction: core.Base) -> RuledSurfaceFeatureInput:
        """
        Creates a RuledSurfaceFeatureInput object that defines the input needed to create a ruled surface feature. Use the input
        object to define the input to create the desired feature and then use the Add method, passing in the RuledSurfaceFeatureInput object.
        profile : A Profile object that defines the sketch geometry or edges that define the shape of the ruled surface. The Component.createBRepEdgeProfile
        method is useful to create a profile defined from edges.
        distance : ValueInput object that defines the extension distance of the Ruled Surface..
        angle : ValueInput object that defines angle to use when creating the Ruled Surface. When the input is a real value, the units are radians.
        ruledSurfaceType : The Ruled Surface type (TangentRuledSurfaceType, NormalRuledSurfaceType, or DirectionRuledSurfaceType).
        direction : If the ruled surface type is DirectionRuledSurfaceType, you must specify the direction. The direction is specified by
        providing a linear or planar entity. For example, a linear edge, construction axis, planar face, or construction plane can be used as input.
        Returns the newly created RuledSurfaceFeatureInput object or null if the creation failed.
        """
        return RuledSurfaceFeatureInput()
    def add(self, input: RuledSurfaceFeatureInput) -> RuledSurfaceFeature:
        """
        Creates a new RuledSurface feature.
        input : An RuledSurfaceFeatureInput object that defines the desired RuledSurface feature. Use the createInput
        method to create a new RuledSurfaceFeatureInput object and then use methods on it
        (the RuledSurfaceFeatureInput object) to define the desired options for the ruled surface feature.
        Returns the newly created RuledSurfaceFeature object or null if the creation failed.
        """
        return RuledSurfaceFeature()
    def itemByName(self, name: str) -> RuledSurfaceFeature:
        """
        Function that returns the specified RuledSurface feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return RuledSurfaceFeature()
    @property
    def count(self) -> int:
        """
        The number of RuledSurface features in the collection.
        """
        return int()

class RuleFilletFeatures(core.Base):
    """
    Collection that provides access to all of the existing rule fillet features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RuleFilletFeatures:
        return RuleFilletFeatures()
    def item(self, index: int) -> RuleFilletFeature:
        """
        Function that returns the specified rule fillet feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return RuleFilletFeature()
    def itemByName(self, name: str) -> RuleFilletFeature:
        """
        Function that returns the specified rule fillet feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return RuleFilletFeature()
    @property
    def count(self) -> int:
        """
        The number of rule fillet features in the collection.
        """
        return int()

class ScaleFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a scale
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ScaleFeatureInput:
        return ScaleFeatureInput()
    def setToNonUniform(self, xScale: core.ValueInput, yScale: core.ValueInput, zScale: core.ValueInput) -> bool:
        """
        Sets the scale factor for the x, y, z directions to define a non-uniform scale.
        Calling this method will cause the isUniform property to be set to false.
        This will fail if the inputEntities collection contains sketches or components.
        xScale : A ValueInput object that defines the scale in the X direction.
        yScale : A ValueInput object that defines the scale in the Y direction.
        zScale : A ValueInput object that defines the scale in the Z direction.
        Returns true if successful.
        """
        return bool()
    @property
    def inputEntities(self) -> core.ObjectCollection:
        """
        Gets and sets the input entities.
        This collection can contain sketches, BRep bodies and T-Spline bodies in parametric modeling.
        It can contain sketches, BRep bodies, T-Spline bodies, mesh bodies, root component and occurrences in non-parametric modeling.
        If the scaling is non-uniform (the isUniform property is false), this collection cannot contain sketches or components.
        """
        return core.ObjectCollection()
    @inputEntities.setter
    def inputEntities(self, value: core.ObjectCollection):
        """
        Gets and sets the input entities.
        This collection can contain sketches, BRep bodies and T-Spline bodies in parametric modeling.
        It can contain sketches, BRep bodies, T-Spline bodies, mesh bodies, root component and occurrences in non-parametric modeling.
        If the scaling is non-uniform (the isUniform property is false), this collection cannot contain sketches or components.
        """
        pass
    @property
    def point(self) -> core.Base:
        """
        Gets and sets the origin point of the scale. This can be a BRepVertex, a SketchPoint or a ConstructionPoint.
        """
        return core.Base()
    @point.setter
    def point(self, value: core.Base):
        """
        Gets and sets the origin point of the scale. This can be a BRepVertex, a SketchPoint or a ConstructionPoint.
        """
        pass
    @property
    def scaleFactor(self) -> core.ValueInput:
        """
        Gets and sets the scale factor used for a uniform scale.
        Setting this value will cause the isUniform property to be set to true.
        """
        return core.ValueInput()
    @scaleFactor.setter
    def scaleFactor(self, value: core.ValueInput):
        """
        Gets and sets the scale factor used for a uniform scale.
        Setting this value will cause the isUniform property to be set to true.
        """
        pass
    @property
    def isUniform(self) -> bool:
        """
        Gets if the scale is uniform.
        """
        return bool()
    @property
    def xScale(self) -> core.ValueInput:
        """
        Gets the scale in X direction.
        """
        return core.ValueInput()
    @property
    def yScale(self) -> core.ValueInput:
        """
        Gets the scale in Y direction.
        """
        return core.ValueInput()
    @property
    def zScale(self) -> core.ValueInput:
        """
        Gets the scale in Z direction.
        """
        return core.ValueInput()
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class ScaleFeatures(core.Base):
    """
    Collection that provides access to all of the existing scale features in a component
    and supports the ability to create new scale features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ScaleFeatures:
        return ScaleFeatures()
    def item(self, index: int) -> ScaleFeature:
        """
        Function that returns the specified scale feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ScaleFeature()
    def createInput(self, inputEntities: core.ObjectCollection, point: core.Base, scaleFactor: core.ValueInput) -> ScaleFeatureInput:
        """
        Creates a ScaleFeatureInput object. Use properties and methods on this object
        to define the scale you want to create and then use the Add method, passing in
        the ScaleFeatureInput object.
        inputEntities : This collection can contain sketches, BRep bodies and T-Spline bodies in parametric modeling.
        It can contain sketches, BRep bodies, T-Spline bodies, mesh bodies, root component and occurrences in non-parametric modeling.
        point : Input a point as reference to scale. This can be a BRepVertex, a SketchPoint or a ConstructionPoint.
        scaleFactor : The ValueInput object that defines the scale factor for uniform scale.
        Returns the newly created ScaleFeatureInput object or null if the creation failed.
        """
        return ScaleFeatureInput()
    def add(self, input: ScaleFeatureInput) -> ScaleFeature:
        """
        Creates a new scale feature.
        input : A ScaleFeatureInput object that defines the desired scale. Use the createInput
        method to create a new ScaleFeatureInput object and then use methods on it
        (the ScaleFeatureInput object) to define the scale.
        Returns the newly created ScaleFeature object or null if the creation failed.
        Returns nothing in the case where the feature is non-parametric.
        """
        return ScaleFeature()
    def itemByName(self, name: str) -> ScaleFeature:
        """
        Function that returns the specified scale feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return ScaleFeature()
    @property
    def count(self) -> int:
        """
        The number of scale features in the collection.
        """
        return int()

class ShellFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a shell
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ShellFeatureInput:
        return ShellFeatureInput()
    @property
    def inputEntities(self) -> core.ObjectCollection:
        """
        Gets and sets the input faces/bodies.
        If IsTangentChain is true, all the faces that are tangentially connected to the input faces (if any) will also be included.
        Fails if any faces are input, and the owning bodies of the faces are also input.
        """
        return core.ObjectCollection()
    @inputEntities.setter
    def inputEntities(self, value: core.ObjectCollection):
        """
        Gets and sets the input faces/bodies.
        If IsTangentChain is true, all the faces that are tangentially connected to the input faces (if any) will also be included.
        Fails if any faces are input, and the owning bodies of the faces are also input.
        """
        pass
    @property
    def isTangentChain(self) -> bool:
        """
        Gets and sets if any faces that are tangentially connected to any of
        the input faces will also be included in setting InputEntities. It defaults to true.
        """
        return bool()
    @isTangentChain.setter
    def isTangentChain(self, value: bool):
        """
        Gets and sets if any faces that are tangentially connected to any of
        the input faces will also be included in setting InputEntities. It defaults to true.
        """
        pass
    @property
    def insideThickness(self) -> core.ValueInput:
        """
        Gets and sets the inside thickness.
        """
        return core.ValueInput()
    @insideThickness.setter
    def insideThickness(self, value: core.ValueInput):
        """
        Gets and sets the inside thickness.
        """
        pass
    @property
    def outsideThickness(self) -> core.ValueInput:
        """
        Gets and sets the outside thickness.
        """
        return core.ValueInput()
    @outsideThickness.setter
    def outsideThickness(self, value: core.ValueInput):
        """
        Gets and sets the outside thickness.
        """
        pass
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the shell is created based on geometry (e.g. a profile and/or face(s))
        in another component AND (the shell) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the shell is created based on geometry (e.g. a profile and/or face(s))
        in another component AND (the shell) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class ShellFeatures(core.Base):
    """
    Collection that provides access to all of the existing shell features in a component
    and supports the ability to create new shell features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ShellFeatures:
        return ShellFeatures()
    def item(self, index: int) -> ShellFeature:
        """
        Function that returns the specified shell feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ShellFeature()
    def createInput(self, inputEntities: core.ObjectCollection, isTangentChain: bool) -> ShellFeatureInput:
        """
        Creates a ShellFeatureInput object. Use properties and methods on this object
        to define the shell you want to create and then use the Add method, passing in
        the ShellFeatureInput object.
        inputEntities : The collection contains the faces to remove and the bodies to perform shell.
        Fails if any faces are input, and the owning bodies of the faces are also input.
        isTangentChain : A boolean value for setting whether or not faces that are tangentially connected to
        the input faces (if any) will also be included. It defaults to true.
        Returns the newly created ShellFeatureInput object or null if the creation failed.
        """
        return ShellFeatureInput()
    def add(self, input: ShellFeatureInput) -> ShellFeature:
        """
        Creates a new shell feature.
        input : A ShellFeatureInput object that defines the desired shell. Use the createInput
        method to create a new ShellFeatureInput object and then use methods on it
        (the ShellFeatureInput object) to define the shell.
        Returns the newly created ShellFeature object or null if the creation failed.
        """
        return ShellFeature()
    def itemByName(self, name: str) -> ShellFeature:
        """
        Function that returns the specified shell feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return ShellFeature()
    @property
    def count(self) -> int:
        """
        The number of shell features in the collection.
        """
        return int()

class SilhouetteSplitFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a silhouette split feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SilhouetteSplitFeatureInput:
        return SilhouetteSplitFeatureInput()
    @property
    def targetBody(self) -> BRepBody:
        """
        Gets and sets the solid body to split.
        """
        return BRepBody()
    @targetBody.setter
    def targetBody(self, value: BRepBody):
        """
        Gets and sets the solid body to split.
        """
        pass
    @property
    def viewDirection(self) -> core.Base:
        """
        Gets and sets the entity that defines the silhouette view direction, which can be a
        construction axis, linear BRepEdge, planar BRepFace or a construction plane.
        """
        return core.Base()
    @viewDirection.setter
    def viewDirection(self, value: core.Base):
        """
        Gets and sets the entity that defines the silhouette view direction, which can be a
        construction axis, linear BRepEdge, planar BRepFace or a construction plane.
        """
        pass
    @property
    def operation(self) -> SilhouetteSplitOperations:
        """
        Gets and sets the type of silhouette split operation to perform.
        """
        return SilhouetteSplitOperations()
    @operation.setter
    def operation(self, value: SilhouetteSplitOperations):
        """
        Gets and sets the type of silhouette split operation to perform.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class SilhouetteSplitFeatures(core.Base):
    """
    Collection that provides access to all of the existing Silhouette Split features in a component
    and supports the ability to create new Silhouette Split features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SilhouetteSplitFeatures:
        return SilhouetteSplitFeatures()
    def item(self, index: int) -> SilhouetteSplitFeature:
        """
        Function that returns the specified silhouette split feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SilhouetteSplitFeature()
    def createInput(self, viewDirection: core.Base, targetBody: BRepBody, operation: SilhouetteSplitOperations) -> SilhouetteSplitFeatureInput:
        """
        Creates a SilhouetteSplitFeatureInput object. Use properties and methods on this object
        to define the silhouette split you want to create and then use the Add method, passing in
        the SilhouetteSplitFeatureInput object.
        viewDirection : A construction axis, linear BRepEdge, planar BRepFace or a construction plane that defines the view direction
        where the silhouette is calculated.
        targetBody : Input the single solid body to split
        operation : The type of silhouette split operation to perform.
        Returns the newly created SilhouetteSplitFeatureInput object or null if the creation failed.
        """
        return SilhouetteSplitFeatureInput()
    def add(self, input: SilhouetteSplitFeatureInput) -> SilhouetteSplitFeature:
        """
        Creates a new silhouette split feature.
        input : A SilhouetteSplitFeatureInput object that defines the desired silhouette split feature. Use the createInput
        method to create a new SilhouetteSplitFeatureInput object and then use methods on it
        (the SilhouetteSplitFeatureInput object) to define the silhouette split.
        Returns the newly created SilhouetteSplitFeature object or null if the creation failed.
        """
        return SilhouetteSplitFeature()
    def itemByName(self, name: str) -> SilhouetteSplitFeature:
        """
        Function that returns the specified silhouette split feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return SilhouetteSplitFeature()
    @property
    def count(self) -> int:
        """
        The number of Silhouette Split features in the collection.
        """
        return int()

class Sketch(core.Base):
    """
    Represents a sketch within a component.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Sketch:
        return Sketch()
    def project(self, entity: core.Base) -> core.ObjectCollection:
        """
        Projects the specified entity onto the x-y plane of the sketch
        and returns the created sketch entity(s).
        entity : The entity to project. This can be a sketch entity, an edge, a face to get all
        of its edges, a vertex, a construction axis, a construction point, or a
        construction plane that is perpendicular to the sketch to create a line.
        Returns a collection of the sketch entities that were created as a result of the
        projection.
        """
        return core.ObjectCollection()
    def projectCutEdges(self, body: BRepBody) -> core.ObjectCollection:
        """
        Intersects the specified body with the sketch plane and creates new
        curves representing the intersection.
        body : The body to be intersected by the sketch.
        Returns a collection of the sketch entities that were created a a result of the
        cut.
        """
        return core.ObjectCollection()
    def include(self, entity: core.Base) -> core.ObjectCollection:
        """
        Creates new sketch curves and points that represent the specified entity
        as sketch geometry. The sketch geometry is not projected but is created
        in the same location in space as the input geometry.
        entity : The entity to include into the sketch. This can be a sketch entity from
        another sketch, edge, face (which results in getting all of its edges, a
        vertex, construction axis, or construction point.
        Returns a collection of the sketch entities that were created as a result of the include.
        When including this curves it will be a single sketch curve, but for faces, multiple
        sketch curves will be created; one for each edge.
        """
        return core.ObjectCollection()
    def findConnectedCurves(self, curve: SketchCurve) -> core.ObjectCollection:
        """
        Finds the sketch curves that are end connected to the input curve. This can be useful
        for many cases but is especially useful in gathering the input when creating an offset.
        curve : The initial sketch curve that will be used to find the connected curves.
        A collection of the connected curves. They are returned in their connected order with
        the original input curve being one of the curves.
        """
        return core.ObjectCollection()
    def offset(self, curves: core.ObjectCollection, directionPoint: core.Point3D, offset: float) -> core.ObjectCollection:
        """
        Creates offset curves for the set of input curves. If the offset distance is not
        provided, the offset distance is defined by the direction point.
        curves : A set of end connected curves. The Sketch.FindConnectedCurves method is a convenient way to get
        this set of curves.
        directionPoint : Defines which side of the input curves to create the offset on
        offset : The distance to offset the curves in centimeters.
        A collection of the new offset sketch curves created
        """
        return core.ObjectCollection()
    def modelToSketchSpace(self, modelCoordinate: core.Point3D) -> core.Point3D:
        """
        A specified point in model space returns the equivalent point in sketch space.
        This is sensitive to the assembly context.
        modelCoordinate : A coordinate in model space.
        Returns the equivalent point in sketch space.
        """
        return core.Point3D()
    def sketchToModelSpace(self, sketchCoordinate: core.Point3D) -> core.Point3D:
        """
        A specified point in sketch space returns the equivalent point in model space.
        This is sensitive to the assembly context.
        sketchCoordinate : A coordinate in sketch space.
        Returns the equivalent point in model space.
        """
        return core.Point3D()
    def move(self, sketchEntities: core.ObjectCollection, transform: core.Matrix3D) -> bool:
        """
        Moves the specified sketch entities using the specified transform.
        Transform respects any constraints that would normally prohibit the move.
        sketchEntities : A collection of sketch entities to transform.
        transform : The transform that defines the move, rotate or scale.
        Returns true if the move was successful.
        """
        return bool()
    def copy(self, sketchEntities: core.ObjectCollection, transform: core.Matrix3D, targetSketch: Sketch) -> core.ObjectCollection:
        """
        Copies the specified sketch entities, applying the specified transform.
        Any geometric or dimension constraints associated with the entities will
        automatically be copied, if possible. For example, if there is a horizontal
        dimension and the transform defines a rotation then it will not be included in the
        result. This same behavior can be seen when performing a copy/paste operation
        in the user interface.
        sketchEntities : The collection of sketch entities to copy. They must all exist in this sketch.
        transform : The transform to apply to the copied entities.
        targetSketch : Optionally specifies the sketch to copy the entities to. If not provided the entities are copied to this sketch.
        Returns a collection of the new sketch entities that were created as a result of the copy.
        """
        return core.ObjectCollection()
    def deleteMe(self) -> bool:
        """
        Deletes the sketch.
        Returns true if the delete was successful.
        """
        return bool()
    def saveAsDXF(self, fullFilename: str) -> bool:
        """
        Saves the contents of the sketch to a specified DXF file.
        fullFilename : The full filename, including the path, of the DXF file.
        Returns true if the operation was successful.
        """
        return bool()
    def importSVG(self, fullFilename: str, xPosition: float, yPosition: float, scale: float) -> bool:
        """
        Imports the contents of an SVG file into the active sketch.
        fullFilename : The full filename, including the path, of the SVG file.
        xPosition : The X offset in centimeters in the sketch for the origin of the SVG data
        relative to the sketch origin.
        yPosition : The Y offset in centimeters in the sketch for the origin of the SVG data
        relative to the sketch origin.
        scale : The scale value to apply to the imported SVG data.
        Returns true if the import was successful.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> Sketch:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return Sketch()
    def redefine(self, planarEntity: core.Base) -> bool:
        """
        Changes which plane the sketch is based on.
        planarEntity : A construction plane or planar face that defines the sketch plane
        Returns true if the operation was successful.
        """
        return bool()
    def intersectWithSketchPlane(self, entities: list[core.Base]) -> list[SketchEntity]:
        """
        Intersects the specified entities (BRepBody, BRepFace, BRepEdge, BRepVertex, SketchCurve, ConstructionPoint,
        ConstructionAxis, and ConstructionPlane) with the sketch plane and creates sketch geometry that represents
        the intersection.
        entities : An array containing the entities to intersect with the sketch plane.
        An array returning the sketch entities that were created as a result of the
        intersections. It's possible that this can come back empty in the case where the input
        entities don't intersect the sketch plane.
        """
        return [SketchEntity()]
    def projectToSurface(self, faces: list[BRepFace], curves: list[core.Base], projectType: SurfaceProjectTypes, directionEntity: core.Base) -> list[SketchEntity]:
        """
        Projects the specified set of curves onto the specified set of faces using the specified method of projection.
        if the projection type is along a vector, then the directionEntity argument must be supplied. if the projectionType
        is the closest point method, the directionEntity argument is ignored.
        faces : An array of BRepFace objects that the curves will be projected onto.
        curves : An array of various curve objects that will be projected onto the faces. The curves can be sketch curves and points,
        BRepEdge objects, ConstructionAxis objects, and ConstructionPoint objects.
        projectType : Specifies which projection type to use which defines the direction of projection. If this is set to AlongVectorSurfaceProjectType
        the directionEntity argument must be provided.
        directionEntity : if the projectType argument is AlongVectorSurfaceProjectType, this argument must be specified and defines the
        direction of projection. It can be a linear BRepEdge, a BRepFace where the normal will be used, a SketchLine, or
        a ConstructionLine.
        Returns an array of the sketch entities that were created as a result of projection the specified curves onto
        the faces.
        """
        return [SketchEntity()]
    @property
    def name(self) -> str:
        """
        Gets and sets the name of this sketch as seen in the browser and timeline.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of this sketch as seen in the browser and timeline.
        """
        pass
    @property
    def sketchPoints(self) -> SketchPoints:
        """
        Returns the sketch points collection associated with this sketch.
        This provides access to the existing sketch points and supports
        the creation of new sketch points.
        """
        return SketchPoints()
    @property
    def sketchCurves(self) -> SketchCurves:
        """
        Returns the sketch curves collection associated with this sketch.
        This provides access to the existing sketch curves which is all
        geometry in the sketch except for sketch points. It is through this
        collection that new sketch geometry gets created.
        """
        return SketchCurves()
    @property
    def sketchDimensions(self) -> SketchDimensions:
        """
        Returns the sketch dimensions collection associated with this sketch.
        This provides access to the existing sketch dimensions and supports
        the creation of new sketch dimensions.
        """
        return SketchDimensions()
    @property
    def geometricConstraints(self) -> GeometricConstraints:
        """
        Returns the sketch constraints collection associated with this sketch.
        This provides access to the existing sketch constraints and supports
        the creation of new sketch constraints.
        """
        return GeometricConstraints()
    @property
    def transform(self) -> core.Matrix3D:
        """
        Gets and sets the transform of the sketch with respect to model space.
        This defines the transform from the parent component space
        to the sketch space. For example, if you have point coordinates in the space
        of the parent component and apply this transform it will result in the
        coordinates of the equivalent position in sketch space.
        The transform is sensitive to the assembly context.
        Setting the transform will fail in the case where the sketch is parametric
        """
        return core.Matrix3D()
    @transform.setter
    def transform(self, value: core.Matrix3D):
        """
        Gets and sets the transform of the sketch with respect to model space.
        This defines the transform from the parent component space
        to the sketch space. For example, if you have point coordinates in the space
        of the parent component and apply this transform it will result in the
        coordinates of the equivalent position in sketch space.
        The transform is sensitive to the assembly context.
        Setting the transform will fail in the case where the sketch is parametric
        """
        pass
    @property
    def isParametric(self) -> bool:
        """
        Indicates if this sketch is parametric or not. For parametric sketches, you can also
        get the construction plane or face it is associative to using the ReferencePlane property.
        """
        return bool()
    @property
    def isVisible(self) -> bool:
        """
        Gets if this sketch is currently visible in the graphics window. Use the
        isLightBulbOn to change if the light bulb beside the sketch node in the
        browser is on or not. Parent nodes in the browser can have their light
        bulb off which affects all of their children. This property indicates
        the final result and whether this body is actually visible or not.
        """
        return bool()
    @isVisible.setter
    def isVisible(self, value: bool):
        """
        Gets if this sketch is currently visible in the graphics window. Use the
        isLightBulbOn to change if the light bulb beside the sketch node in the
        browser is on or not. Parent nodes in the browser can have their light
        bulb off which affects all of their children. This property indicates
        the final result and whether this body is actually visible or not.
        """
        pass
    @property
    def areDimensionsShown(self) -> bool:
        """
        Indicates if the dimensions of the sketch are displayed when the sketch is not active
        (in sketch edit mode)
        """
        return bool()
    @areDimensionsShown.setter
    def areDimensionsShown(self, value: bool):
        """
        Indicates if the dimensions of the sketch are displayed when the sketch is not active
        (in sketch edit mode)
        """
        pass
    @property
    def areProfilesShown(self) -> bool:
        """
        Indicates if the profiles of the sketch are displayed
        """
        return bool()
    @areProfilesShown.setter
    def areProfilesShown(self, value: bool):
        """
        Indicates if the profiles of the sketch are displayed
        """
        pass
    @property
    def origin(self) -> core.Point3D:
        """
        Returns the origin point of the sketch in model space.
        """
        return core.Point3D()
    @property
    def xDirection(self) -> core.Vector3D:
        """
        Returns the X direction of the sketch as defined in model space.
        """
        return core.Vector3D()
    @property
    def yDirection(self) -> core.Vector3D:
        """
        Returns the Y direction of the sketch as defined in model space.
        """
        return core.Vector3D()
    @property
    def referencePlane(self) -> core.Base:
        """
        Gets and sets the construction plane or planar face the sketch is associated
        to. This is only valid when the IsParametric property is True otherwise this
        returns null and setting the property will fail.
        
        Setting this property is the equivalent of the Redefine command.
        """
        return core.Base()
    @referencePlane.setter
    def referencePlane(self, value: core.Base):
        """
        Gets and sets the construction plane or planar face the sketch is associated
        to. This is only valid when the IsParametric property is True otherwise this
        returns null and setting the property will fail.
        
        Setting this property is the equivalent of the Redefine command.
        """
        pass
    @property
    def isComputeDeferred(self) -> bool:
        """
        Temporarily turns off the compute of the sketch. This is used to
        increase the performance as sketch geometry is created. Once the
        sketch is drawn the this property should be set to false to allow
        the sketch to recompute. This setting is not saved by the file and is
        always false when a file is opened.
        """
        return bool()
    @isComputeDeferred.setter
    def isComputeDeferred(self, value: bool):
        """
        Temporarily turns off the compute of the sketch. This is used to
        increase the performance as sketch geometry is created. Once the
        sketch is drawn the this property should be set to false to allow
        the sketch to recompute. This setting is not saved by the file and is
        always false when a file is opened.
        """
        pass
    @property
    def profiles(self) -> Profiles:
        """
        Returns the profiles currently computed for the sketch.
        """
        return Profiles()
    @property
    def timelineObject(self) -> TimelineObject:
        """
        Returns the timeline object associated with this sketch.
        """
        return TimelineObject()
    @property
    def parentComponent(self) -> Component:
        """
        Returns the parent Component.
        """
        return Component()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this
        object in an assembly. This is only valid in the case where this
        is acting as a proxy in an assembly. Returns null
        in the case where the object is not in the context of an assembly.
        but is already the native object.
        """
        return Occurrence()
    @property
    def nativeObject(self) -> Sketch:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return Sketch()
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns the 3D bounding box of the sketch
        """
        return core.BoundingBox3D()
    @property
    def sketchTexts(self) -> SketchTexts:
        """
        Returns the sketch text collection associated with this sketch.
        This provides access to existing text and supports the creation
        of new text.
        """
        return SketchTexts()
    @property
    def originPoint(self) -> SketchPoint:
        """
        Returns the sketch point that was automatically created by projecting the
        origin construction point into the sketch.
        """
        return SketchPoint()
    @property
    def isFullyConstrained(self) -> bool:
        """
        Indicates if this sketch is fully constrained.
        """
        return bool()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this face.
        """
        return core.Attributes()
    @property
    def baseOrFormFeature(self) -> core.Base:
        """
        This property returns the base or form feature that this sketch is associated with. It returns
        null in the case where the sketch is parametrically defined and is not related to a base or form
        feature. It also returns null in the case where the modeling design history is not being captured (direct edit model).
        """
        return core.Base()
    @property
    def healthState(self) -> FeatureHealthStates:
        """
        Returns the current health state of this sketch.
        """
        return FeatureHealthStates()
    @property
    def errorOrWarningMessage(self) -> str:
        """
        Returns the error or warning message in the case where the healthState property returns either
        WarningFeatureHealthState or ErrorFeatureHealthState. Otherwise this property returns an empty string.
        """
        return str()
    @property
    def revisionId(self) -> str:
        """
        Returns the current revision ID of the sketch. This ID changes any time the sketch is modified in any way. By getting
        and saving the ID when you create any data that is dependent on the sketch, you can then compare the saved
        ID with the current ID to determine if the sketch has changed to know if you should update your data.
        """
        return str()
    @property
    def areConstraintsShown(self) -> bool:
        """
        Indicates if the constraints of the sketch are displayed when the sketch is active.
        """
        return bool()
    @areConstraintsShown.setter
    def areConstraintsShown(self, value: bool):
        """
        Indicates if the constraints of the sketch are displayed when the sketch is active.
        """
        pass
    @property
    def arePointsShown(self) -> bool:
        """
        Indicates if the sketch points in the sketch are displayed. Points that are not connected to any other
        geometry will continue to be shown.
        """
        return bool()
    @arePointsShown.setter
    def arePointsShown(self, value: bool):
        """
        Indicates if the sketch points in the sketch are displayed. Points that are not connected to any other
        geometry will continue to be shown.
        """
        pass
    @property
    def isLightBulbOn(self) -> bool:
        """
        Gets and set if the light bulb beside the sketch node in the
        browser is on or not. Parent nodes in the browser can have their light
        bulb off which affects all of their children so this property does not
        indicate if the body is actually visible, just that it should be visible
        if all of it's parent nodes are also visible. Use the isVisible property
        to determine if it's actually visible.
        """
        return bool()
    @isLightBulbOn.setter
    def isLightBulbOn(self, value: bool):
        """
        Gets and set if the light bulb beside the sketch node in the
        browser is on or not. Parent nodes in the browser can have their light
        bulb off which affects all of their children so this property does not
        indicate if the body is actually visible, just that it should be visible
        if all of it's parent nodes are also visible. Use the isVisible property
        to determine if it's actually visible.
        """
        pass
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the Sketch object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same token.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class SketchArcs(core.Base):
    """
    The collection of arcs in a sketch. This provides access to the existing
    arcs and supports the methods to create new arcs.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchArcs:
        return SketchArcs()
    def item(self, index: int) -> SketchArc:
        """
        Function that returns the specified sketch arc using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchArc()
    def addByCenterStartSweep(self, centerPoint: core.Base, startPoint: core.Base, sweepAngle: float) -> SketchArc:
        """
        Creates a sketch arc that is always parallel to the x-y plane of the sketch
        and is centered at the specified point.
        centerPoint : The center point of the arc. This can be either an existing SketchPoint or a Point3D object.
        startPoint : The start point of the arc. The distance between this point and the center defines the radius
        of the arc. This can be either an existing SketchPoint or a Point3D object.
        sweepAngle : The sweep of the arc. This is defined in radians and a positive value defines a counter-clockwise sweep.
        Returns the newly created SketchArc object or null if the creation failed.
        """
        return SketchArc()
    def addByThreePoints(self, startPoint: core.Base, point: core.Point3D, endPoint: core.Base) -> SketchArc:
        """
        Creates a sketch arc that passes through the three points.
        startPoint : The start point of the arc. This can be either an existing SketchPoint or a Point3D object.
        point : A point along the arc. This is a Point3D object.
        endPoint : The end point of the arc. This can be either an existing SketchPoint or a Point3D object.
        Returns the newly created SketchArc or null in the case of a failure.
        """
        return SketchArc()
    def addFillet(self, firstEntity: SketchCurve, firstEntityPoint: core.Point3D, secondEnitity: SketchCurve, secondEntityPoint: core.Point3D, radius: float) -> SketchArc:
        """
        Creates a fillet between two sketch entities
        The side (quadrant) the fillet is created on is determined by the points specified.
        The point for each entity can be its startSketchPoint or endSketchPoint
        firstEntity : The first curve for the fillet definition. The curve must be open.
        firstEntityPoint : A point on or closer to one end of the first curve that indicates the side to create the fillet on
        secondEnitity : The second curve for the fillet definition. The curve must be open.
        secondEntityPoint : A point on or closer to one end of the second curve that indicates the side to create the fillet on
        radius : radius of the arc in centimeters
        Returns the newly created SketchArc object (fillet) if the operation was successful or null if it failed.
        """
        return SketchArc()
    @property
    def count(self) -> int:
        """
        Returns the number of arcs in the sketch.
        """
        return int()

class SketchCircles(core.Base):
    """
    The collection of circles in a sketch. This provides access to the existing
    circles and supports the methods to create new circles.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchCircles:
        return SketchCircles()
    def item(self, index: int) -> SketchCircle:
        """
        Function that returns the specified sketch circle using an index into the collection.
        index : The index of the item within the collection to return.
        The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchCircle()
    def addByCenterRadius(self, centerPoint: core.Base, radius: float) -> SketchCircle:
        """
        Creates a sketch circle that is always parallel to the x-y plane of the sketch
        and is centered at the specified point.
        centerPoint : The center point of the circle. It can be an existing SketchPoint or a Point3D object.
        radius : The radius of the circle in centimeters.
        Returns the newly created SketchCircle object or null if the creation failed.
        """
        return SketchCircle()
    def addByTwoPoints(self, pointOne: core.Point3D, pointTwo: core.Point3D) -> SketchCircle:
        """
        Creates a sketch circle where the circle passes through the two points and the
        distance between the two points is the diameter of the circle.
        pointOne : A Point3D object that defines a point is sketch space and lies on the x-y plane of the sketch.
        pointTwo : A Point3D object that defines a point is sketch space and lies on the x-y plane of the sketch.
        Returns the newly created SketchCircle object or null if the creation failed.
        """
        return SketchCircle()
    def addByThreePoints(self, pointOne: core.Point3D, pointTwo: core.Point3D, pointThree: core.Point3D) -> SketchCircle:
        """
        Creates a sketch circle that passes through the three points. The three points must
        lie on the x-y plane of the sketch.
        pointOne : The first point that the circle will pass through. The z component must be zero.
        pointTwo : The second point that the circle will pass through. The z component must be zero.
        pointThree : The third point that the circle will pass through. The z component must be zero.
        Returns the newly created SketchCircle object or null if the creation failed.
        """
        return SketchCircle()
    def addByTwoTangents(self, tangentOne: SketchLine, tangentTwo: SketchLine, radius: float, hintPoint: core.Point3D) -> SketchCircle:
        """
        Creates a sketch circle that is tangent to the two input lines.
        The two lines must lie on the x-y plane of the sketch.
        tangentOne : The first line that the circle will be tangent to.
        The line must lie on the x-y plane of the sketch.
        tangentTwo : The second line that the circle will be tangent to.
        The line must lie on the x-y plane of the sketch and cannot
        be parallel to the first line.
        radius : The radius of the circle in centimeters.
        hintPoint : A point that specifies which of the possible four solutions to use
        when creating the circle. If you consider the two input lines to be infinite
        they create four quadrants which results in four possible solutions for the
        creation of the circle. The hint point is a point anywhere within the quadrant
        where you want the circle created.
        Returns the newly created SketchCircle object or null if the creation failed.
        """
        return SketchCircle()
    def addByThreeTangents(self, tangentOne: SketchLine, tangentTwo: SketchLine, tangentThree: SketchLine, hintPoint: core.Point3D) -> SketchCircle:
        """
        Creates a sketch circle that is tangent to the three input lines.
        The three lines must lie on the x-y plane of the sketch.
        tangentOne : The first line that the circle will be tangent to.
        The line must lie on the x-y plane of the sketch and cannot be parallel
        to the second or third line.
        tangentTwo : The second line that the circle will be tangent to.
        The line must lie on the x-y plane of the sketch and cannot be parallel
        to the first or third line.
        tangentThree : The third line that the circle will be tangent to.
        The line must lie on the x-y plane of the sketch and cannot be parallel
        to the first or second line.
        hintPoint : A point that specifies which of the possible multiple solutions to use
        when creating the circle. If you consider the three input lines to be infinite
        there are many possible solutions when creating a circle that is tangent to all
        three lines. The hint point is a point anywhere within the area defined by the
        three lines where the circle is to be created.
        Returns the newly created SketchCircle object or null if the creation failed.
        """
        return SketchCircle()
    @property
    def count(self) -> int:
        """
        Returns the number of circles in the sketch.
        """
        return int()

class SketchConicCurves(core.Base):
    """
    The collection of conic curves in a sketch. This provides access to the existing
    conic curves and supports the method to create new conic curves.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchConicCurves:
        return SketchConicCurves()
    def item(self, index: int) -> SketchConicCurve:
        """
        Function that returns the specified conic curve using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchConicCurve()
    @property
    def count(self) -> int:
        """
        Returns the number of conic curves in the sketch.
        """
        return int()

class SketchCurves(core.Base):
    """
    A collection of sketch curves in a sketch. This also provides access to collections
    for the specific types of curves where you can get the curves based on type and
    create new curves.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchCurves:
        return SketchCurves()
    def item(self, index: int) -> SketchCurve:
        """
        Function that returns the specified sketch curve using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchCurve()
    @property
    def count(self) -> int:
        """
        Returns the number of sketch curves in the sketch.
        """
        return int()
    @property
    def sketchArcs(self) -> SketchArcs:
        """
        Returns the sketch arcs collection associated with this sketch.
        This provides access to the existing sketch arcs and supports
        the creation of new sketch arcs.
        """
        return SketchArcs()
    @property
    def sketchCircles(self) -> SketchCircles:
        """
        Returns the sketch circles collection associated with this sketch.
        This provides access to the existing sketch circles and supports
        the creation of new sketch circles.
        """
        return SketchCircles()
    @property
    def sketchEllipses(self) -> SketchEllipses:
        """
        Returns the sketch ellipses collection associated with this sketch.
        This provides access to the existing sketch ellipses and supports
        the creation of new sketch ellipses.
        """
        return SketchEllipses()
    @property
    def sketchEllipticalArcs(self) -> SketchEllipticalArcs:
        """
        Returns the sketch elliptical arcs collection associated with this sketch.
        This provides access to the existing sketch elliptical arcs and supports
        the creation of new sketch elliptical arcs.
        """
        return SketchEllipticalArcs()
    @property
    def sketchLines(self) -> SketchLines:
        """
        Returns the sketch lines collection associated with this sketch.
        This provides access to the existing sketch lines and supports
        the creation of new sketch lines.
        """
        return SketchLines()
    @property
    def sketchFittedSplines(self) -> SketchFittedSplines:
        """
        Returns the sketch splines collection associated with this sketch.
        This provides access to the existing sketch splines and supports
        the creation of new sketch splines.
        """
        return SketchFittedSplines()
    @property
    def sketchFixedSplines(self) -> SketchFixedSplines:
        """
        Returns the fixed sketch splines collection associated with this sketch.
        This provides access to the existing fixed sketch splines and supports
        the creation of new fixed sketch splines.
        """
        return SketchFixedSplines()
    @property
    def sketchConicCurves(self) -> SketchConicCurves:
        """
        Returns the conic curves collection associated with this sketch.
        This provides access to the existing conic curves and support the
        creation of new conic curves.
        """
        return SketchConicCurves()

class SketchDimension(core.Base):
    """
    The base class for the all sketch dimensions.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchDimension:
        return SketchDimension()
    def deleteMe(self) -> bool:
        """
        Deletes this dimension. The IsDeletable property indicates if this dimension can be deleted.
        Returns true if the delete was successful.
        """
        return bool()
    @property
    def isDeletable(self) -> bool:
        """
        Indicates if this dimension is deletable.
        """
        return bool()
    @property
    def textPosition(self) -> core.Point3D:
        """
        Gets and sets position of the dimension text.
        """
        return core.Point3D()
    @textPosition.setter
    def textPosition(self, value: core.Point3D):
        """
        Gets and sets position of the dimension text.
        """
        pass
    @property
    def parentSketch(self) -> Sketch:
        """
        Returns the parent sketch object.
        """
        return Sketch()
    @property
    def parameter(self) -> ModelParameter:
        """
        Returns the associated parameter or null if there is no associated parameter.
        """
        return ModelParameter()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def isDriving(self) -> bool:
        """
        Gets and sets if the dimension is Driving or is Driven. Setting this property to true for a given dimension
        may fail if the result would over constrain the sketch. Fusion 360 does not allow over-constrained sketches.
        """
        return bool()
    @isDriving.setter
    def isDriving(self, value: bool):
        """
        Gets and sets if the dimension is Driving or is Driven. Setting this property to true for a given dimension
        may fail if the result would over constrain the sketch. Fusion 360 does not allow over-constrained sketches.
        """
        pass
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this sketch dimension.
        """
        return core.Attributes()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the SketchDimension object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same sketch dimension.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class SketchDimensionList(core.Base):
    """
    A list of sketch dimensions.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchDimensionList:
        return SketchDimensionList()
    def item(self, index: int) -> SketchDimension:
        """
        Function that returns the specified sketch dimension using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection
        has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchDimension()
    @property
    def count(self) -> int:
        """
        Returns the number of sketch dimensions in the sketch.
        """
        return int()

class SketchDimensions(core.Base):
    """
    A collection of the dimensions in a sketch. This object also supports the methods to add
    new sketch dimensions.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchDimensions:
        return SketchDimensions()
    def item(self, index: int) -> SketchDimension:
        """
        Function that returns the specified sketch dimension using an index into the
        collection.
        index : The index of the item within the collection to return. The first item in the
        collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchDimension()
    def addDistanceDimension(self, pointOne: SketchPoint, pointTwo: SketchPoint, orientation: DimensionOrientations, textPoint: core.Point3D, isDriving: bool) -> SketchLinearDimension:
        """
        Creates a new linear dimension constraint between the two input entities.
        pointOne : The first SketchPoint to dimension to.
        pointTwo : The second SketchPoint to dimension to..
        orientation : The orientation of the dimension.
        textPoint : A Point3D object that defines the position of the dimension text.
        isDriving : Optional argument that specifies if a driving (the dimension controls the geometry)
        or a driven (the geometry controls the dimension) dimension is created. If not provided
        a driving dimension will be created.
        Returns the newly created dimension or null if the creation failed.
        """
        return SketchLinearDimension()
    def addOffsetDimension(self, line: SketchLine, entityTwo: SketchEntity, textPoint: core.Point3D, isDriving: bool) -> SketchOffsetDimension:
        """
        Creates a new linear dimension constraint between the two input entities. The first input
        entity must be a sketch line. The second entity can be a point or a line that is parallel
        to the first. The dimension controls the distance as measured perpendicular to the first
        input line.
        line : The SketchLine to dimension to.
        entityTwo : The parallel SketchLine or SketchPoint to dimension to. If a SketchLine is used it must be
        parallel to the first line.
        textPoint : A Point3D object that defines the position of the dimension text.
        isDriving : Optional argument that specifies if a driving (the dimension controls the geometry)
        or a driven (the geometry controls the dimension) dimension is created. If not provided
        a driving dimension will be created.
        Returns the newly created dimension or null if the creation failed.
        """
        return SketchOffsetDimension()
    def addAngularDimension(self, lineOne: SketchLine, lineTwo: SketchLine, textPoint: core.Point3D, isDriving: bool) -> SketchAngularDimension:
        """
        Creates a new angular dimension constraint between the two input lines.
        The position of the text controls which of the four quadrants will be dimensioned.
        lineOne : The first SketchLine to dimension to.
        lineTwo : The second SketchLine to dimension to.
        textPoint : A Point3D object that defines the position of the dimension text. The position of this
        text defines which quadrant will be dimensioned.
        isDriving : Optional argument that specifies if a driving (the dimension controls the geometry)
        or a driven (the geometry controls the dimension) dimension is created. If not provided
        a driving dimension will be created.
        Returns the newly created dimension or null if the creation failed.
        """
        return SketchAngularDimension()
    def addDiameterDimension(self, entity: SketchCurve, textPoint: core.Point3D, isDriving: bool) -> SketchDiameterDimension:
        """
        Creates a new diameter dimension constraint on the arc or circle.
        entity : The SketchCircle or SketchArc to dimension.
        textPoint : A Point3D object that defines the position of the dimension text.
        isDriving : Optional argument that specifies if a driving (the dimension controls the geometry)
        or a driven (the geometry controls the dimension) dimension is created. If not provided
        a driving dimension will be created.
        Returns the newly created dimension or null if the creation failed.
        """
        return SketchDiameterDimension()
    def addRadialDimension(self, entity: SketchCurve, textPoint: core.Point3D, isDriving: bool) -> SketchRadialDimension:
        """
        Creates a new radial dimension constraint on the arc or circle.
        entity : The SketchCircle or SketchArc to dimension.
        textPoint : A Point3D object that defines the position of the dimension text.
        isDriving : Optional argument that specifies if a driving (the dimension controls the geometry)
        or a driven (the geometry controls the dimension) dimension is created. If not provided
        a driving dimension will be created.
        Returns the newly created dimension or null if the creation failed.
        """
        return SketchRadialDimension()
    def addEllipseMajorRadiusDimension(self, ellipse: SketchCurve, textPoint: core.Point3D, isDriving: bool) -> SketchEllipseMajorRadiusDimension:
        """
        Creates a new dimension constraint on the major radius of an ellipse.
        ellipse : The SketchEllipse to dimension.
        textPoint : A Point3D object that defines the position of the dimension text.
        isDriving : Optional argument that specifies if a driving (the dimension controls the geometry)
        or a driven (the geometry controls the dimension) dimension is created. If not provided
        a driving dimension will be created.
        Returns the newly created dimension or null if the creation failed.
        """
        return SketchEllipseMajorRadiusDimension()
    def addEllipseMinorRadiusDimension(self, ellipse: SketchCurve, textPoint: core.Point3D, isDriving: bool) -> SketchEllipseMinorRadiusDimension:
        """
        Creates a new dimension constraint on the minor radius of an ellipse.
        ellipse : The SketchEllipse to dimension.
        textPoint : A Point3D object that defines the position of the dimension text.
        isDriving : Optional argument that specifies if a driving (the dimension controls the geometry)
        or a driven (the geometry controls the dimension) dimension is created. If not provided
        a driving dimension will be created.
        Returns the newly created dimension or null if the creation failed.
        """
        return SketchEllipseMinorRadiusDimension()
    def addConcentricCircleDimension(self, circleOne: SketchCurve, circleTwo: SketchCurve, textPoint: core.Point3D, isDriving: bool) -> SketchConcentricCircleDimension:
        """
        Creates a new dimension constraint between to concentric circles or arcs.
        circleOne : The first SketchCircle or SketchArc to dimension.
        circleTwo : The second SketchCircle or SketchArc to dimension.
        textPoint : A Point3D object that defines the position of the dimension text.
        isDriving : Optional argument that specifies if a driving (the dimension controls the geometry)
        or a driven (the geometry controls the dimension) dimension is created. If not provided
        a driving dimension will be created.
        Returns the newly created dimension or null if the creation failed.
        """
        return SketchConcentricCircleDimension()
    @property
    def count(self) -> int:
        """
        Returns the number of sketch dimensions in the sketch.
        """
        return int()

class SketchEllipses(core.Base):
    """
    The collection of ellipses in a sketch. This provides access to the existing
    ellipses and supports the methods to create new ellipses.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchEllipses:
        return SketchEllipses()
    def item(self, index: int) -> SketchEllipse:
        """
        Function that returns the specified sketch ellipse using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchEllipse()
    def add(self, centerPoint: core.Base, majorAxisPoint: core.Point3D, point: core.Point3D) -> SketchEllipse:
        """
        Creates a sketch ellipse using the center point, a point defining the major axis
        and a third point anywhere along the ellipse. The created ellipse is parallel to the
        x-y plane of the sketch.
        centerPoint : The center point of the ellipse. This can be either an existing SketchPoint or a Point3D object.
        majorAxisPoint : A point3D object that defines both the major axis direction and major axis radius.
        point : A point3D object that the ellipse will pass through.
        Returns the newly created SketchEllipse object if the creation was successful or null if it failed.
        """
        return SketchEllipse()
    @property
    def count(self) -> int:
        """
        Returns the number of ellipses in the sketch.
        """
        return int()

class SketchEllipticalArcs(core.Base):
    """
    The collection of elliptical arcs in a sketch. This provides access to the existing
    elliptical arcs and supports the methods to create new elliptical arcs.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchEllipticalArcs:
        return SketchEllipticalArcs()
    def item(self, index: int) -> SketchEllipticalArc:
        """
        Function that returns the specified sketch elliptical arc using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchEllipticalArc()
    @property
    def count(self) -> int:
        """
        Returns the number of elliptical arcs in the sketch.
        """
        return int()

class SketchEntity(core.Base):
    """
    This object represents all geometry in a sketch, including
    points and lines and the various curves.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchEntity:
        return SketchEntity()
    def deleteMe(self) -> bool:
        """
        Deletes the entity from the sketch.
        Returns true is the delete was successful.
        """
        return bool()
    @property
    def parentSketch(self) -> Sketch:
        """
        Returns the parent sketch.
        """
        return Sketch()
    @property
    def sketchDimensions(self) -> SketchDimensionList:
        """
        Returns the sketch dimensions that are attached to this curve.
        """
        return SketchDimensionList()
    @property
    def geometricConstraints(self) -> GeometricConstraintList:
        """
        Returns the sketch constraints that are attached to this curve.
        """
        return GeometricConstraintList()
    @property
    def is2D(self) -> bool:
        """
        Indicates if this curve lies entirely on the sketch x-y plane.
        """
        return bool()
    @property
    def isReference(self) -> bool:
        """
        Indicates if this geometry is a reference.
        Changing this property from true to false removes the reference.
        This property can not be set to true if it is already false.
        """
        return bool()
    @isReference.setter
    def isReference(self, value: bool):
        """
        Indicates if this geometry is a reference.
        Changing this property from true to false removes the reference.
        This property can not be set to true if it is already false.
        """
        pass
    @property
    def isFixed(self) -> bool:
        """
        Indicates if this geometry is "fixed".
        """
        return bool()
    @isFixed.setter
    def isFixed(self, value: bool):
        """
        Indicates if this geometry is "fixed".
        """
        pass
    @property
    def isVisible(self) -> bool:
        """
        When a sketch is created, geometry is sometimes automatically added to the sketch.
        For example a sketch point that references the origin point is always included and
        if a face was selected to create the sketch on, geometry from the face is also included.
        This automatically created geometry behaves in a special way in that it is invisible
        but is available for selection and it also participates in profile calculations. It's
        not possible to make them visible but they can be deleted and they can be used for any
        other standard sketch operation.
        """
        return bool()
    @property
    def boundingBox(self) -> core.BoundingBox3D:
        """
        Returns the bounding box of the entity in sketch space.
        """
        return core.BoundingBox3D()
    @property
    def referencedEntity(self) -> core.Base:
        """
        Returns the referenced entity in the case where IsReference
        is true. However, this property can also return null when
        IsReference is true in the case where the reference is not
        parametric.
        """
        return core.Base()
    @property
    def assemblyContext(self) -> Occurrence:
        """
        Returns the assembly occurrence (i.e. the occurrence) of this object
        in an assembly. This is only valid in the case where this is acting
        as a proxy in an assembly. Returns null in the case where the object
        is not in the context of an assembly but is already the native object.
        """
        return Occurrence()
    @property
    def isDeletable(self) -> bool:
        """
        Indicates if this sketch entity can be deleted. There are cases, especially with sketch
        points where another entity is dependent on an entity so deleting it is not allowed.
        For example, you can't delete the center point of circle by itself but deleting the circle
        will delete the point. The same is true for the end points of a line.
        """
        return bool()
    @property
    def isFullyConstrained(self) -> bool:
        """
        Indicates if this sketch entity is fully constrained.
        """
        return bool()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this face.
        """
        return core.Attributes()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the SketchEntity object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same sketch entity.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()
    @property
    def isLinked(self) -> bool:
        """
        Indicates if this sketch entity was created by a projection, inclusion, or driven by an API script.
        If this returns true, then the entity is presented to the user as not editable and with a 'break link'
        command available.
        """
        return bool()

class SketchEntityList(core.Base):
    """
    A list of sketch entities.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchEntityList:
        return SketchEntityList()
    def item(self, index: int) -> SketchEntity:
        """
        Function that returns the specified sketch entity using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchEntity()
    @property
    def count(self) -> int:
        """
        Returns the number of sketch entities in the list.
        """
        return int()

class Sketches(core.Base):
    """
    Provides access to the sketches within a design and provides
    methods to create new sketches.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Sketches:
        return Sketches()
    def item(self, index: int) -> Sketch:
        """
        Function that returns the specified sketch using an index into the collection.
        index : The index of the item within the collection to return. The first item in the
        collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Sketch()
    def itemByName(self, name: str) -> Sketch:
        """
        Returns the sketch with the specified name.
        name : The name of the sketch as seen in the browser and the timeline.
        Returns the sketch or null if there isn't a sketch with that name.
        """
        return Sketch()
    def add(self, planarEntity: core.Base, occurrenceForCreation: Occurrence) -> Sketch:
        """
        Creates a new sketch on the specified planar entity.
        planarEntity : A construction plane or planar face that defines the sketch plane
        occurrenceForCreation : A creation occurrence is needed if the planarEntity is in another component AND the
        sketch is not in the root component. The occurrenceForCreation is analogous
        to the active occurrence in the UI.
        Returns the newly created Sketch or null if the creation failed.
        """
        return Sketch()
    def addToBaseOrFormFeature(self, planarEntity: core.Base, targetBaseOrFormFeature: core.Base, includeFaceEdges: bool) -> Sketch:
        """
        Creates a parametric sketch that is associated with a base feature.
        
        Because of a current limitation, if you want to create a sketch associated with a base
        feature, you must first call the edit method of the base feature, use this method to
        create the sketch, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        planarEntity : A construction plane or planar face that defines the sketch plane.
        targetBaseOrFormFeature : The existing base feature that you want to associate this sketch with.
        includeFaceEdges : When a BrepFace is used as the planarEntity argument, this defines if the edges of the face
        should be included in the sketch.
        Returns the newly created Sketch or null if the creation failed.
        """
        return Sketch()
    def addWithoutEdges(self, planarEntity: core.Base, occurrenceForCreation: Occurrence) -> Sketch:
        """
        Creates a new sketch on the specified planar entity. If a BRepFace is provided, the edges of the face
        are not projected into the sketch so the result of creating a new sketch with this method will
        always be a new empty sketch.
        planarEntity : A construction plane or planar face that defines the sketch plane.
        occurrenceForCreation : A creation occurrence is needed if the planarEntity is in another component AND the
        sketch is not in the root component. The occurrenceForCreation is analogous
        to the active occurrence in the UI.
        Returns the newly created Sketch or null if the creation failed.
        """
        return Sketch()
    @property
    def count(self) -> int:
        """
        Returns the number of sketches in a component
        """
        return int()

class SketchFittedSplines(core.Base):
    """
    The collection of fitted splines in a sketch. This provides access to the existing
    fitted splines and supports the methods to create new fitted splines.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchFittedSplines:
        return SketchFittedSplines()
    def item(self, index: int) -> SketchFittedSpline:
        """
        Function that returns the specified sketch fitted spline using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchFittedSpline()
    def add(self, fitPoints: core.ObjectCollection) -> SketchFittedSpline:
        """
        Creates a new fitted spline through the specified points.
        fitPoints : A collection of points that the curve will fit through. They
        can be any combination of existing SketchPoint or Point3D objects.
        Returns the newly created SketchFittedSpline object if the creation was successful or null if it failed.
        """
        return SketchFittedSpline()
    def addByNurbsCurve(self, nurbsCurve: core.NurbsCurve3D) -> SketchFittedSpline:
        """
        Creates a new fitted spline using the input NurbsCurve3D to define the shape. Fit points are created
        to create a curve that exactly matches the input curve.
        nurbsCurve : A NurbsCurve3D object that defines a valid NURBS curve.
        Returns the newly created SketchFittedSpline object if the creation was successful or null if it failed.
        """
        return SketchFittedSpline()
    @property
    def count(self) -> int:
        """
        Returns the number of fitted splines in the sketch.
        """
        return int()

class SketchFixedSplines(core.Base):
    """
    The collection of fixed splines in a sketch. Fixed splines are splines that were created
    as the result of some operation (i.e. intersection) and is not directly editable.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchFixedSplines:
        return SketchFixedSplines()
    def item(self, index: int) -> SketchFixedSpline:
        """
        Function that returns the specified sketch fixed spline using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchFixedSpline()
    def addByNurbsCurve(self, nurbsCurve: core.NurbsCurve3D) -> SketchFixedSpline:
        """
        Creates a new fixed spline using the input NurbsCurve3D to define the shape. The resulting curve
        is not editable by the user but can be updated via the API using the replaceGeometry method on the
        SketchFixedSpline object.
        nurbsCurve : A NurbsCurve3D object that defines a valid NURBS curve.
        Returns the newly created SketchFixedSpline object if the creation was successful or null if it failed.
        """
        return SketchFixedSpline()
    @property
    def count(self) -> int:
        """
        Returns the number of fitted splines in the sketch.
        """
        return int()

class SketchLineList(core.Base):
    """
    A list of sketch lines.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchLineList:
        return SketchLineList()
    def item(self, index: int) -> SketchLine:
        """
        Function that returns the specified sketch line using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchLine()
    @property
    def count(self) -> int:
        """
        Returns the number of sketch lines in the list.
        """
        return int()

class SketchLines(core.Base):
    """
    The collection of lines in a sketch. This provides access to the existing
    lines and supports the methods to create new lines.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchLines:
        return SketchLines()
    def item(self, index: int) -> SketchLine:
        """
        Function that returns the specified sketch line using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchLine()
    def addByTwoPoints(self, startPoint: core.Base, endPoint: core.Base) -> SketchLine:
        """
        Creates a sketch line between the two input points. The input points
        can be either existing SketchPoints or Point3D objects. If a SketchPoint
        is used the new line will be based on that sketch point and update if the
        sketch point is modified.
        startPoint : The start point of the line. It can be a SketchPoint or Point3D object.
        endPoint : The end point of the line. It can be a SketchPoint or Point3D object.
        Returns the newly created SketchLine object or null if the creation failed.
        """
        return SketchLine()
    def addTwoPointRectangle(self, pointOne: core.Base, pointTwo: core.Base) -> SketchLineList:
        """
        Creates four sketch lines representing a rectangle where the two points are the opposing corners
        of the rectangle. The input points can be either existing SketchPoints or Point3D objects.
        If a SketchPoint is used the new lines will be based on that sketch point and update if the
        sketch point is modified.
        pointOne : The first corner of the rectangle. It can be a SketchPoint or Point3D object.
        pointTwo : The second corner of the rectangle. It can be a SketchPoint or Point3D object.
        Returns the four new sketch lines or null if the creation failed.
        """
        return SketchLineList()
    def addThreePointRectangle(self, pointOne: core.Base, pointTwo: core.Base, pointThree: core.Point3D) -> SketchLineList:
        """
        Creates four sketch lines representing a rectangle where the first two points are the base corners
        of the rectangle and the third point defines the height.
        pointOne : The first corner of the rectangle. It can be a SketchPoint or Point3D object.
        pointTwo : The first corner of the rectangle. It can be a SketchPoint or Point3D object.
        pointThree : The first corner of the rectangle. a Point3D object defining the height of the rectangle.
        Returns the four new sketch lines or null if the creation failed.
        """
        return SketchLineList()
    def addCenterPointRectangle(self, centerPoint: core.Point3D, cornerPoint: core.Base) -> SketchLineList:
        """
        Creates four sketch lines representing a rectangle where the first point represents the center of
        the rectangle. The second point is the corner of the rectangle and can be either an existing
        SketchPoint or Point3D object. The four sketch lines are returned.
        centerPoint : The center point of the rectangle
        cornerPoint : The corner of the rectangle. It can be a SketchPoint or Point3D object.
        Returns the four new sketch lines or null if the creation failed.
        """
        return SketchLineList()
    def addDistanceChamfer(self, firstLine: SketchLine, firstLinePoint: core.Point3D, secondLine: SketchLine, secondLinePoint: core.Point3D, distanceOne: float, distanceTwo: float) -> SketchLine:
        """
        Creates a chamfer between two sketch lines. In the case where the two input lines cross each other creating
        an "X" shape, this results in four quadrants where the chamfer can be placed. The point arguments are used
        to define which of the four quadrants the chamfer should be created in. The two points define which side of
        the two lines should be kept and the other end will be trimmed by the chamfer. The easiest way to use this is
        to use the end points of the lines on the side you want to keep.
        In the case where the lines don't intersect or connect at the end points, there is only one valid quadrant
        for the chamfer so the points are ignored.
        firstLine : The first line you want to chamfer.
        firstLinePoint : A point on the first line that is on the side of the intersection with the second line that you want to keep.
        secondLine : The second line you want to chamfer.
        secondLinePoint : A point on the second line that is on the side of the intersection with the first line that you want to keep.
        distanceOne : Defines the distance of the start point of the chamfer line from the intersection point of the two lines along the first line.
        The distance is defined in centimeters.
        distanceTwo : Defines the distance of the start point of the chamfer line from the intersection point of the two lines along the second line.
        The distance is defined in centimeters.
        Returns the newly created SketchLine object that represents the chamfer or null if the creation failed.
        """
        return SketchLine()
    def addAngleChamfer(self, firstLine: SketchLine, firstLinePoint: core.Point3D, secondLine: SketchLine, secondLinePoint: core.Point3D, distance: float, angle: float) -> SketchLine:
        """
        Creates a chamfer between two sketch lines. In the case where the two input lines cross each other creating
        an "X" shape, this results in four quadrants where the chamfer can be placed. The point arguments are used
        to define which of the four quadrants the chamfer should be created in. The two points define which side of
        the two lines should be kept and the other end will be trimmed by the chamfer. The easiest way to use this is
        to use the end points of the lines on the side you want to keep.
        In the case where the lines don't intersect or connect at the end points, there is only one valid quadrant
        for the chamfer so the points are ignored.
        firstLine : The first line you want to chamfer.
        firstLinePoint : A point on the first line that is on the side of the intersection with the second line that you want to keep.
        secondLine : The second line you want to chamfer.
        secondLinePoint : A point on the second line that is on the side of the intersection with the first line that you want to keep.
        distance : Defines the distance of the start point of the chamfer from the intersection point of the two lines along the first line.
        The distance is defined in centimeters.
        angle : Defines the angle of the chamfer as measured from the first line.
        The angle is defined in radians.
        Returns the newly created SketchLine object that represents the chamfer or null if the creation failed.
        """
        return SketchLine()
    @property
    def count(self) -> int:
        """
        Returns the number of lines in the sketch.
        """
        return int()

class SketchPointList(core.Base):
    """
    A list of sketch points.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchPointList:
        return SketchPointList()
    def item(self, index: int) -> SketchPoint:
        """
        Function that returns the specified sketch point using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchPoint()
    @property
    def count(self) -> int:
        """
        Returns the number of sketch points in the list.
        """
        return int()

class SketchPoints(core.Base):
    """
    A collection of sketch points.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchPoints:
        return SketchPoints()
    def item(self, index: int) -> SketchPoint:
        """
        Function that returns the specified sketch using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchPoint()
    def add(self, point: core.Point3D) -> SketchPoint:
        """
        Creates a point at the specified location. This is the equivalent
        of creating a sketch point using the Point command in the user
        interface and will create a visible point in the graphics window.
        point : The coordinate location to create the sketch point.
        Returns the new sketch point or null if the creation fails.
        """
        return SketchPoint()
    @property
    def count(self) -> int:
        """
        Returns the number of sketch points in the sketch.
        """
        return int()

class SketchTextDefinition(core.Base):
    """
    The base class for the classes that define how text can be defined.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchTextDefinition:
        return SketchTextDefinition()

class SketchTextInput(core.Base):
    """
    The SketchTextInput object is equivalent to the Sketch Text dialog in that it collects all of the input required
    to create sketch text. Once the properties of the SketchTextInput object have been defined, use the add method
    to create the sketch text. A SketchTextInput object is created by using the createInput of the SketchTexts object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchTextInput:
        return SketchTextInput()
    def setAsFitOnPath(self, path: core.Base, isAbovePath: bool) -> bool:
        """
        Sets this SketchTextInput to define text that fits along a specified path. Fitting on a path will
        space the characters so the text fits along the entire length of the path entity.
        path : The entity that defines the path for the text. This can be a SketchCurve or BRepEdge object.
        isAbovePath : Indicates if the text should be positioned above or below the path entity.
        Returns true if the setting the definition was successful.
        """
        return bool()
    def setAsAlongPath(self, path: core.Base, isAbovePath: bool, horizontalAlignment: core.HorizontalAlignments, characterSpacing: float) -> bool:
        """
        Sets this SketchTextInput to define text that follows along a specified path.
        path : The entity that defines the path for the text. This can be a SketchCurve or BRepEdge object.
        isAbovePath : Indicates if the text should be positioned above or below the path entity.
        horizontalAlignment : Specifies the horizontal alignment of the text with respect to the path curve.
        characterSpacing : The percentage change in default spacing between characters.
        Returns true if the setting the definition was successful.
        """
        return bool()
    def setAsMultiLine(self, cornerPoint: core.Base, diagonalPoint: core.Base, horizontalAlignment: core.HorizontalAlignments, verticalAlignment: core.VerticalAlignments, characterSpacing: float) -> bool:
        """
        Defines the first corner point of the rectangle that will contain the text.
        cornerPoint : Specifies the location of one of the corner points of the rectangle that will contain the text.
        This can be a Point3D object, with a Z component of zero, to define any arbitrary location on the X-Y
        plane of the sketch or it can be an existing SketchPoint that lies on the sketch X-Y plane.
        diagonalPoint : Specifies the location of the diagonal point of the rectangle that will contain the text. This point
        cannot be aligned vertically or horizontally to the corner point but be a diagonal point to define
        a rectangle. This can be a Point3D object, with a Z component of zero, to define any arbitrary location on the X-Y
        plane of the sketch or it can be an existing SketchPoint that lies on the sketch X-Y plane and the sketch point
        will become the opposing corner point.
        horizontalAlignment : Specifies the horizontal alignment of the text with respect to the text rectangle.
        verticalAlignment : Specifies the vertical alignment of the text with respect to the text rectangle.
        characterSpacing : The spacing between the characters. This is an additional spacing to apply that is defined
        as a percentage of the default spacing. A spacing of 0 indicates no additional spacing.
        A spacing of 50 indicates to use the default plus 50% of the default.
        Returns true if the setting the definition was successful.
        """
        return bool()
    @property
    def height(self) -> float:
        """
        Gets and sets the height of the text in centimeters.
        """
        return float()
    @height.setter
    def height(self, value: float):
        """
        Gets and sets the height of the text in centimeters.
        """
        pass
    @property
    def text(self) -> str:
        """
        Gets and sets the text.
        """
        return str()
    @text.setter
    def text(self, value: str):
        """
        Gets and sets the text.
        """
        pass
    @property
    def position(self) -> core.Point3D:
        """
        Gets and sets the position of the text on the x-y plane of the sketch. The text must lie on the x-y plane so the Z component
        of the point is ignored and always treated as zero.
        """
        return core.Point3D()
    @position.setter
    def position(self, value: core.Point3D):
        """
        Gets and sets the position of the text on the x-y plane of the sketch. The text must lie on the x-y plane so the Z component
        of the point is ignored and always treated as zero.
        """
        pass
    @property
    def fontName(self) -> str:
        """
        Gets and sets the name of the font to use.
        """
        return str()
    @fontName.setter
    def fontName(self, value: str):
        """
        Gets and sets the name of the font to use.
        """
        pass
    @property
    def angle(self) -> float:
        """
        Gets and sets the angle of the text relative to the x-axis of the x-y plane of the sketch.
        """
        return float()
    @angle.setter
    def angle(self, value: float):
        """
        Gets and sets the angle of the text relative to the x-axis of the x-y plane of the sketch.
        """
        pass
    @property
    def textStyle(self) -> TextStyles:
        """
        Gets and sets the text style to apply to the entire text. This is a bitwise enum so styles
        can be combined to apply multiple styles. For example you can apply bold and italic.
        """
        return TextStyles()
    @textStyle.setter
    def textStyle(self, value: TextStyles):
        """
        Gets and sets the text style to apply to the entire text. This is a bitwise enum so styles
        can be combined to apply multiple styles. For example you can apply bold and italic.
        """
        pass
    @property
    def isHorizontalFlip(self) -> bool:
        """
        Gets and sets if the text is flipped horizontally.
        """
        return bool()
    @isHorizontalFlip.setter
    def isHorizontalFlip(self, value: bool):
        """
        Gets and sets if the text is flipped horizontally.
        """
        pass
    @property
    def isVerticalFlip(self) -> bool:
        """
        Gets and sets if the text is flipped vertically.
        """
        return bool()
    @isVerticalFlip.setter
    def isVerticalFlip(self, value: bool):
        """
        Gets and sets if the text is flipped vertically.
        """
        pass
    @property
    def definition(self) -> SketchTextDefinition:
        """
        Returns the SketchTextDefinition object associated with this input. When the SketchTextInput is first created this
        property will return null. Once one of the "set" methods have been called, this will return the SketchTextDefinition
        of the appropriate type and can be used to make any additional changes to the text.
        """
        return SketchTextDefinition()

class SketchTexts(core.Base):
    """
    The collection of text blocks in a sketch. This provides access to the existing
    text blocks and supports creating new text blocks.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SketchTexts:
        return SketchTexts()
    def item(self, index: int) -> SketchText:
        """
        Function that returns the specified sketch text using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SketchText()
    def createInput(self, formattedText: str, height: float, position: core.Point3D) -> SketchTextInput:
        """
        Creates a SketchTextInput object that can be used to define additional settings when creating sketch text. The
        SketchTextInput object is equivalent to the Sketch Text dialog in that it collects all of the input required
        to create sketch text. Once the properties of the SketchTextInput object have been defined, use the add method
        to create the sketch text.
        formattedText : The text used for the sketch text. This is a simple string as no additional formatting is currently supported.
        height : The height of the text in centimeters.
        position : The position of the text on the x-y plane of the sketch. The text must lie on the x-y plane so the Z component
        of the point is ignored and always treated as zero.
        Returns a SketchTextInput object that can be used to set additional formatting and is used as input to the add method.
        """
        return SketchTextInput()
    def add(self, input: SketchTextInput) -> SketchText:
        """
        Creates a sketch text.
        input : A SketchTextInput object created using the SketchTexts.createInput method.
        Returns the newly created SketchText object or null in the case of failure.
        """
        return SketchText()
    def createInput2(self, formattedText: str, height: float) -> SketchTextInput:
        """
        Creates a SketchTextInput object that is used to define the additional input to create text. The SketchTextInput
        object is equivalent to the Sketch Text dialog in that it collects all of the input required to create sketch text.
        You must call setAsFitOnPath, setAsAlongPath, or setAsMultiLine methods to define one of the three types of text and
        can use other and define any
        setAs Once the properties of the SketchTextInput object have been defined, use the add method
        to create the sketch text.
        formattedText : The text used for the sketch text. This is a simple string as no additional formatting is currently supported.
        height : The height of the text in centimeters.
        Returns a SketchTextInput object that can be used to set additional formatting and is used as input to the add method.
        """
        return SketchTextInput()
    @property
    def count(self) -> int:
        """
        Returns the number of texts in the sketch.
        """
        return int()

class Snapshot(core.Base):
    """
    Object that represents a Snapshot in the timeline
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Snapshot:
        return Snapshot()
    def deleteMe(self) -> bool:
        """
        Deletes this snapshot.
        Returns true if the delete was successful.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of the snapshot as seen in the timeline.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of the snapshot as seen in the timeline.
        """
        pass
    @property
    def timelineObject(self) -> TimelineObject:
        """
        Returns the timeline object associated with this snapshot.
        """
        return TimelineObject()

class Snapshots(core.Base):
    """
    Provides access to the Snapshots within a design and provides
    methods to create new Snapshots.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Snapshots:
        return Snapshots()
    def add(self) -> Snapshot:
        """
        Creates a new snapshot. Creating a snapshot is only valid when the HasPendingTransforms property returns true.
        Returns the newly created snapshot.
        """
        return Snapshot()
    def item(self, index: int) -> Snapshot:
        """
        Function that returns the specified snapshot in the collection using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Snapshot()
    def revertPendingSnapshot(self) -> bool:
        """
        Reverts and changes that have been made that can be snapshot. This effectively
        reverts the design back to the last snapshot. This is only valid when the
        HasPendingSnapshot property returns true.
        Returns true if the revert was successful.
        """
        return bool()
    @property
    def count(self) -> int:
        """
        The number of items in the collection.
        """
        return int()
    @property
    def hasPendingSnapshot(self) -> bool:
        """
        Indicates if there are any changes that have been made than can be snapshot.
        """
        return bool()

class SphereFeatures(core.Base):
    """
    Collection that provides access to all of the existing torus features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SphereFeatures:
        return SphereFeatures()
    def item(self, index: int) -> SphereFeature:
        """
        Function that returns the specified sphere feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SphereFeature()
    def itemByName(self, name: str) -> SphereFeature:
        """
        Function that returns the specified sphere feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return SphereFeature()
    @property
    def count(self) -> int:
        """
        The number of sphere features in the collection.
        """
        return int()

class SplitBodyFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a split body feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SplitBodyFeatureInput:
        return SplitBodyFeatureInput()
    @property
    def splitBodies(self) -> core.Base:
        """
        Gets and sets the input solid or open bodies to be split. This can be a
        single BRepBody or an ObjectCollection if multiple bodies are to be split.
        """
        return core.Base()
    @splitBodies.setter
    def splitBodies(self, value: core.Base):
        """
        Gets and sets the input solid or open bodies to be split. This can be a
        single BRepBody or an ObjectCollection if multiple bodies are to be split.
        """
        pass
    @property
    def splittingTool(self) -> core.Base:
        """
        Gets and sets the entity that defines the splitting tool. The splitting tool is a single
        entity that can be either a solid or open BRepBody, construction plane, profile, or a face.
        """
        return core.Base()
    @splittingTool.setter
    def splittingTool(self, value: core.Base):
        """
        Gets and sets the entity that defines the splitting tool. The splitting tool is a single
        entity that can be either a solid or open BRepBody, construction plane, profile, or a face.
        """
        pass
    @property
    def isSplittingToolExtended(self) -> bool:
        """
        Gets and sets whether or not the splitting tool is to be automatically extended (if possible) so as to
        completely intersect the bodyToSplit.
        """
        return bool()
    @isSplittingToolExtended.setter
    def isSplittingToolExtended(self, value: bool):
        """
        Gets and sets whether or not the splitting tool is to be automatically extended (if possible) so as to
        completely intersect the bodyToSplit.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class SplitBodyFeatures(core.Base):
    """
    Collection that provides access to all of the existing split body features in a component
    and supports the ability to create new split body features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SplitBodyFeatures:
        return SplitBodyFeatures()
    def item(self, index: int) -> SplitBodyFeature:
        """
        Function that returns the specified split body feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SplitBodyFeature()
    def createInput(self, splitBodies: core.Base, splittingTool: core.Base, isSplittingToolExtended: bool) -> SplitBodyFeatureInput:
        """
        Creates a SplitBodyFeatureInput object. Use properties and methods on this object
        to define the split body you want to create and then use the Add method, passing in
        the SplitBodyFeatureInput object.
        splitBodies : Input solid body or open bodies to be split. This can be a single BRepBody or an ObjectCollection if multiple
        bodies are to be split.
        splittingTool : Input entity that defines the splitting tool. The splitting tool is a single entity that can be either a solid or open BRepBody,
        construction plane, profile, or a face.
        isSplittingToolExtended : A boolean value for setting whether or not the splitting tool is to be automatically extended (if possible) so as to
        completely intersect the bodyToSplit.
        Returns the newly created SplitBodyFeatureInput object or null if the creation failed.
        """
        return SplitBodyFeatureInput()
    def add(self, input: SplitBodyFeatureInput) -> SplitBodyFeature:
        """
        Creates a new split body feature.
        input : A SplitBodyFeatureInput object that defines the desired split body feature. Use the createInput
        method to create a new SplitBodyFeatureInput object and then use methods on it
        (the SplitBodyFeatureInput object) to define the split body.
        Returns the newly created SplitBodyFeature object or null if the creation failed.
        """
        return SplitBodyFeature()
    def itemByName(self, name: str) -> SplitBodyFeature:
        """
        Function that returns the specified split body feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return SplitBodyFeature()
    @property
    def count(self) -> int:
        """
        The number of split body features in the collection.
        """
        return int()

class SplitFaceFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a split face feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SplitFaceFeatureInput:
        return SplitFaceFeatureInput()
    def setAlongVectorSplitType(self, directionEntity: core.Base) -> bool:
        """
        Sets the split type to project the splitting tool along the direction defined by the
        specified entity.
        directionEntity : An entity that defines the direction of projection of the splitting tool. This can be
        a linear BRepEdge, SketchLine, ConstructionLine, or a planar face where the face
        normal is used.
        Returns true is setting the split type was successful.
        """
        return bool()
    def setClosestPointSplitType(self) -> bool:
        """
        Sets the split type to be a curve that defined by projecting the splitting curve to the
        closest point on the surface.
        Returns true is setting the split type was successful.
        """
        return bool()
    def setSurfaceIntersectionSplitType(self, isSplittingToolExtended: bool) -> bool:
        """
        Set the split type to be a surface to surface intersection. If the split tool is a curve
        it will be extruded into a surface to use in the split. If it's a surface, the surface will
        be used and optionally extended to fully intersect the faces to be split.
        isSplittingToolExtended : Specifies if the splitting tool should be extended so that is fully intersects the faces to be split.
        Returns true is setting the split type was successful.
        """
        return bool()
    @property
    def facesToSplit(self) -> core.ObjectCollection:
        """
        Gets and sets the faces to be split.
        The collection can contain one or more faces selected from solid and/or open bodies.
        """
        return core.ObjectCollection()
    @facesToSplit.setter
    def facesToSplit(self, value: core.ObjectCollection):
        """
        Gets and sets the faces to be split.
        The collection can contain one or more faces selected from solid and/or open bodies.
        """
        pass
    @property
    def splittingTool(self) -> core.Base:
        """
        Gets and sets the entity(s) that define the splitting tool(s). The splitting tool can be a single entity or an
        ObjectCollection containing solid and/or open bodies, construction planes, faces, or sketch curves that partially
        or fully intersect the faces that are being split.
        """
        return core.Base()
    @splittingTool.setter
    def splittingTool(self, value: core.Base):
        """
        Gets and sets the entity(s) that define the splitting tool(s). The splitting tool can be a single entity or an
        ObjectCollection containing solid and/or open bodies, construction planes, faces, or sketch curves that partially
        or fully intersect the faces that are being split.
        """
        pass
    @property
    def isSplittingToolExtended(self) -> bool:
        """
        Gets and sets whether or not the splittingTool is to be automatically extended (if possible) so as to
        completely intersect the facesToSplit.
        """
        return bool()
    @isSplittingToolExtended.setter
    def isSplittingToolExtended(self, value: bool):
        """
        Gets and sets whether or not the splittingTool is to be automatically extended (if possible) so as to
        completely intersect the facesToSplit.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass
    @property
    def splitType(self) -> SplitFaceSplitTypes:
        """
        Returns the type of split type currently defined.
        """
        return SplitFaceSplitTypes()

class SplitFaceFeatures(core.Base):
    """
    Collection that provides access to all of the existing split face features in a component
    and supports the ability to create new split face features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SplitFaceFeatures:
        return SplitFaceFeatures()
    def item(self, index: int) -> SplitFaceFeature:
        """
        Function that returns the specified split face feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SplitFaceFeature()
    def createInput(self, facesToSplit: core.ObjectCollection, splittingTool: core.Base, isSplittingToolExtended: bool) -> SplitFaceFeatureInput:
        """
        Creates a SplitFaceFeatureInput object. Use properties and methods on this object
        to define the split face you want to create and then use the Add method, passing in
        the SplitFaceFeatureInput object.
        
        A newly created SplitFaceFeatureInput object defaults to creating a split face feature
        using the "Split with Surface" option. You can use functions on the SplitFaceFeatureInput
        object to define a different type of split type.
        facesToSplit : Input the faces to be split. The collection can contain one or more faces from solid and/or open bodies.
        splittingTool : Input entity(s) that defines the splitting tool. The splitting tool can be a single entity or an ObjectCollection
        containing solid and/or open bodies, construction planes, faces, or sketch curves that partially or fully intersect
        the faces that are being split.
        isSplittingToolExtended : A boolean value for setting whether or not the splittingTool is to be automatically extended (if possible) so as to
        completely intersect the faces that are to be split. This is only used when the split type is "split with surface"
        which is the default type when a new createInput is created. Use functions on the returned SplitFaceFeatureInput
        to define a different type of split type.
        Returns the newly created SplitFaceFeatureInput object or null if the creation failed.
        """
        return SplitFaceFeatureInput()
    def add(self, input: SplitFaceFeatureInput) -> SplitFaceFeature:
        """
        Creates a new split face feature.
        input : A SplitFaceFeatureInput object that defines the desired split face feature. Use the createInput
        method to create a new SplitFaceFeatureInput object and then use methods on it
        (the SplitFaceFeatureInput object) to define the split face.
        Returns the newly created SplitFaceFeature object or null if the creation failed.
        """
        return SplitFaceFeature()
    def itemByName(self, name: str) -> SplitFaceFeature:
        """
        Function that returns the specified split face feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return SplitFaceFeature()
    @property
    def count(self) -> int:
        """
        The number of split face features in the collection.
        """
        return int()

class StitchFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a stitch feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> StitchFeatureInput:
        return StitchFeatureInput()
    @property
    def stitchSurfaces(self) -> core.ObjectCollection:
        """
        Gets and sets the surfaces to stitch together.
        """
        return core.ObjectCollection()
    @stitchSurfaces.setter
    def stitchSurfaces(self, value: core.ObjectCollection):
        """
        Gets and sets the surfaces to stitch together.
        """
        pass
    @property
    def tolerance(self) -> core.ValueInput:
        """
        Gets and sets the ValueInput object that defines the stitching tolerance. It must define a length.
        """
        return core.ValueInput()
    @tolerance.setter
    def tolerance(self, value: core.ValueInput):
        """
        Gets and sets the ValueInput object that defines the stitching tolerance. It must define a length.
        """
        pass
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the feature operation to perform. This property value is only valid if the isSolid property returns
        true. Otherwise the value of this property is ignored.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the feature operation to perform. This property value is only valid if the isSolid property returns
        true. Otherwise the value of this property is ignored.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class StitchFeatures(core.Base):
    """
    Collection that provides access to all of the existing Stitch features in a component
    and supports the ability to create new Stitch features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> StitchFeatures:
        return StitchFeatures()
    def item(self, index: int) -> StitchFeature:
        """
        Function that returns the specified stitch feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return StitchFeature()
    def createInput(self, stitchSurfaces: core.ObjectCollection, tolerance: core.ValueInput, operation: FeatureOperations) -> StitchFeatureInput:
        """
        Creates a StitchFeatureInput object. Use properties and methods on this object
        to define the stitch feature you want to create and then use the Add method, passing in
        the StitchFeatureInput object.
        stitchSurfaces : The surfaces (open BRepBodies) to stitch together.
        Stitching surfaces can form multiple closed volumes resulting in multiple solids.
        Stitch Surfaces can form multiple BRepShells (entirely connected set of entities) that would result in a
        single non-solid BRepBody.
        tolerance : ValueInput object that defines the stitching tolerance. It must define a distance value.
        operation : Specifies the operation type for the result when the final result is a closed solid. Otherwise
        this argument is ignored.
        Returns the newly created StitchFeatureInput object or null if the creation failed.
        """
        return StitchFeatureInput()
    def add(self, input: StitchFeatureInput) -> StitchFeature:
        """
        Creates a new stitch feature.
        input : A StitchFeatureInput object that defines the desired stitch feature. Use the createInput
        method to create a new StitchFeatureInput object and then use methods on it
        (the StitchFeatureInput object) to define the stitch feature.
        Returns the newly created StitchFeature object or null if the creation failed.
        """
        return StitchFeature()
    def itemByName(self, name: str) -> StitchFeature:
        """
        Function that returns the specified stitch feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return StitchFeature()
    @property
    def count(self) -> int:
        """
        The number of Stitch features in the collection.
        """
        return int()

class SurfaceDeleteFaceFeatures(core.Base):
    """
    Collection that provides access to all of the existing SurfaceDeleteFaceFeature features in a component
    and supports the ability to create new SurfaceDeleteFaceFeature features.
    
    The SurfaceDeleteFaceFeature and DeleteFaceFeature differ in that the SurfaceDeleteFaceFeature
    can delete any face without any restrictions. If the body is a solid, it will become a surface
    when the first face is deleted. The specified face is deleted without any other changes being
    made to the body. The DeleteFaceFeature deletes the specified face and also modifies the other faces
    in the body to heal or fill in the area of the deleted face. This means that a solid body will
    remain solid.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SurfaceDeleteFaceFeatures:
        return SurfaceDeleteFaceFeatures()
    def item(self, index: int) -> SurfaceDeleteFaceFeature:
        """
        Function that returns the specified SurfaceDeleteFaceFeature object using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SurfaceDeleteFaceFeature()
    def itemByName(self, name: str) -> SurfaceDeleteFaceFeature:
        """
        Function that returns the specified SurfaceDeleteFaceFeature object using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return SurfaceDeleteFaceFeature()
    def add(self, facesToDelete: core.Base) -> SurfaceDeleteFaceFeature:
        """
        Creates a new SurfaceDeleteFaceFeature feature. This deletes the specified faces
        from their bodies without any attempt to heal the openings. This is equivalent
        to selecting and deleting faces when in the Patch workspace.
        facesToDelete : A single BRepFace or an ObjectCollection containing multiple BRepFace objects.
        Returns the newly created SurfaceDeleteFaceFeature object or null if the creation failed.
        """
        return SurfaceDeleteFaceFeature()
    @property
    def count(self) -> int:
        """
        The number of SurfaceDeleteFaceFeature objects in the collection.
        """
        return int()

class SweepFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a sweep
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SweepFeatureInput:
        return SweepFeatureInput()
    @property
    def profile(self) -> core.Base:
        """
        Gets and sets the profiles or planar faces used to define the shape of the sweep.
        This property can return or be set with a single Profile, a single planar face, or
        an ObjectCollection consisting of multiple profiles and planar faces. When an
        ObjectCollection is used all of the profiles and faces must be co-planar.
        """
        return core.Base()
    @profile.setter
    def profile(self, value: core.Base):
        """
        Gets and sets the profiles or planar faces used to define the shape of the sweep.
        This property can return or be set with a single Profile, a single planar face, or
        an ObjectCollection consisting of multiple profiles and planar faces. When an
        ObjectCollection is used all of the profiles and faces must be co-planar.
        """
        pass
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the type of operation performed by the sweep.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the type of operation performed by the sweep.
        """
        pass
    @property
    def path(self) -> Path:
        """
        Gets and sets the path to create the sweep.
        """
        return Path()
    @path.setter
    def path(self, value: Path):
        """
        Gets and sets the path to create the sweep.
        """
        pass
    @property
    def distanceOne(self) -> core.ValueInput:
        """
        Gets and sets the distance for the first side.
        The distance is a value from 0 to 1 indicating the position along the path where 0
        is at the start and 1 is at the end. The value is default to 1.0.
        """
        return core.ValueInput()
    @distanceOne.setter
    def distanceOne(self, value: core.ValueInput):
        """
        Gets and sets the distance for the first side.
        The distance is a value from 0 to 1 indicating the position along the path where 0
        is at the start and 1 is at the end. The value is default to 1.0.
        """
        pass
    @property
    def distanceTwo(self) -> core.ValueInput:
        """
        Gets and sets the distance for the second side.
        The distance is a value from 0 to 1 indicating the position along the path where 0
        is at the start and 1 is at the end. The value defaults to 0 in the case where the path is closed, otherwise it defaults to 1.0.
        It is ignored if the path is only on one side of the profile or if the sweep definition includes a guide rail.
        It's always the distance against the normal of the profile if available.
        """
        return core.ValueInput()
    @distanceTwo.setter
    def distanceTwo(self, value: core.ValueInput):
        """
        Gets and sets the distance for the second side.
        The distance is a value from 0 to 1 indicating the position along the path where 0
        is at the start and 1 is at the end. The value defaults to 0 in the case where the path is closed, otherwise it defaults to 1.0.
        It is ignored if the path is only on one side of the profile or if the sweep definition includes a guide rail.
        It's always the distance against the normal of the profile if available.
        """
        pass
    @property
    def orientation(self) -> SweepOrientationTypes:
        """
        Gets and sets the sweep orientation. It defaults to PerpendicularOrientationType.
        This property is ignored when a guide rail has been specified.
        """
        return SweepOrientationTypes()
    @orientation.setter
    def orientation(self, value: SweepOrientationTypes):
        """
        Gets and sets the sweep orientation. It defaults to PerpendicularOrientationType.
        This property is ignored when a guide rail has been specified.
        """
        pass
    @property
    def creationOccurrence(self) -> Occurrence:
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the sweep is created based on geometry (e.g. a profile and/or face(s))
        in another component AND (the sweep) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        return Occurrence()
    @creationOccurrence.setter
    def creationOccurrence(self, value: Occurrence):
        """
        In order for geometry to be transformed correctly, an Occurrence for creation needs to be
        specified when the sweep is created based on geometry (e.g. a profile and/or face(s))
        in another component AND (the sweep) is not in the root component.
        The CreationOccurrence is analogous to the active occurrence in the UI
        """
        pass
    @property
    def isSolid(self) -> bool:
        """
        Specifies if the sweep should be created as a solid or surface. If
        it's a surface then there aren't any end caps and it's open. This is
        initialized to true so a solid will be created if it's not changed.
        """
        return bool()
    @isSolid.setter
    def isSolid(self, value: bool):
        """
        Specifies if the sweep should be created as a solid or surface. If
        it's a surface then there aren't any end caps and it's open. This is
        initialized to true so a solid will be created if it's not changed.
        """
        pass
    @property
    def guideRail(self) -> Path:
        """
        Gets and sets the guide rail to create the sweep. This can be set to
        null to remove the guide rail definition and have a single path sweep feature.
        """
        return Path()
    @guideRail.setter
    def guideRail(self, value: Path):
        """
        Gets and sets the guide rail to create the sweep. This can be set to
        null to remove the guide rail definition and have a single path sweep feature.
        """
        pass
    @property
    def isDirectionFlipped(self) -> bool:
        """
        Gets and sets if the direction of the sweep is flipped.
        This property only applies to sweep features that include a guide rail and whose path runs on both
        sides of the profile.
        """
        return bool()
    @isDirectionFlipped.setter
    def isDirectionFlipped(self, value: bool):
        """
        Gets and sets if the direction of the sweep is flipped.
        This property only applies to sweep features that include a guide rail and whose path runs on both
        sides of the profile.
        """
        pass
    @property
    def profileScaling(self) -> SweepProfileScalingOptions:
        """
        Gets and sets the sweep profile scaling option. It defaults to SweepProfileScaleOption.
        This property is only used when a guide rail has been specified.
        """
        return SweepProfileScalingOptions()
    @profileScaling.setter
    def profileScaling(self, value: SweepProfileScalingOptions):
        """
        Gets and sets the sweep profile scaling option. It defaults to SweepProfileScaleOption.
        This property is only used when a guide rail has been specified.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass
    @property
    def participantBodies(self) -> list[BRepBody]:
        """
        Gets and sets the list of bodies that will participate in the feature when the operation is a cut or intersection.
        
        If this property has not been set, the default behavior is that all bodies that are intersected by the
        feature will participate.
        
        This property can return null in the case where the feature has not been fully defined so that
        possible intersecting bodies can be computed.
        """
        return [BRepBody()]
    @participantBodies.setter
    def participantBodies(self, value: list[BRepBody]):
        """
        Gets and sets the list of bodies that will participate in the feature when the operation is a cut or intersection.
        
        If this property has not been set, the default behavior is that all bodies that are intersected by the
        feature will participate.
        
        This property can return null in the case where the feature has not been fully defined so that
        possible intersecting bodies can be computed.
        """
        pass
    @property
    def taperAngle(self) -> core.ValueInput:
        """
        Gets and sets the taper angle of the sweep. This property is initialized with a taper angle of zero.
        A negative angle will taper the sweep inward while a positive value will taper
        the sweep outward. This property is valid for both parametric and non-parametric extrusions.
        """
        return core.ValueInput()
    @taperAngle.setter
    def taperAngle(self, value: core.ValueInput):
        """
        Gets and sets the taper angle of the sweep. This property is initialized with a taper angle of zero.
        A negative angle will taper the sweep inward while a positive value will taper
        the sweep outward. This property is valid for both parametric and non-parametric extrusions.
        """
        pass
    @property
    def twistAngle(self) -> core.ValueInput:
        """
        Gets and sets the taper angle of the sweep. This property is initialized with a taper angle of zero.
        A negative angle will taper the sweep inward while a positive value will taper
        the sweep outward. This property is valid for both parametric and non-parametric extrusions.
        """
        return core.ValueInput()
    @twistAngle.setter
    def twistAngle(self, value: core.ValueInput):
        """
        Gets and sets the taper angle of the sweep. This property is initialized with a taper angle of zero.
        A negative angle will taper the sweep inward while a positive value will taper
        the sweep outward. This property is valid for both parametric and non-parametric extrusions.
        """
        pass
    @property
    def extent(self) -> SweepExtentTypes:
        """
        Gets and sets the sweep extent type. It defaults to PerpendicularToPathExtentType.
        This property is ignored when a guide rail has not been specified.
        """
        return SweepExtentTypes()
    @extent.setter
    def extent(self, value: SweepExtentTypes):
        """
        Gets and sets the sweep extent type. It defaults to PerpendicularToPathExtentType.
        This property is ignored when a guide rail has not been specified.
        """
        pass

class SweepFeatures(core.Base):
    """
    Collection that provides access to all of the existing sweep features in a component
    and supports the ability to create new sweep features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SweepFeatures:
        return SweepFeatures()
    def item(self, index: int) -> SweepFeature:
        """
        Function that returns the specified sweep feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return SweepFeature()
    def createInput(self, profile: core.Base, path: Path, operation: FeatureOperations) -> SweepFeatureInput:
        """
        Creates a SweepFeatureInput object for defining a simple sweep feature with only a path and no guide rail.
        Use properties and methods on this object to define the sweep you want to create and then use the Add method,
        passing in the SweepFeatureInput object.
        profile : The profile argument can be a single Profile, a single
        planar face, or an ObjectCollection consisting of multiple profiles and planar faces.
        When an ObjectCollection is used all of the profiles and faces must be co-planar.
        path : The path to create the sweep.
        operation : The feature operation to perform
        Returns the newly created SweepFeatureInput object or null if the creation failed.
        """
        return SweepFeatureInput()
    def add(self, input: SweepFeatureInput) -> SweepFeature:
        """
        Creates a new sweep feature.
        input : A SweepFeatureInput object that defines the desired sweep. Use the createInput
        method to create a new SweepFeatureInput object and then use methods on it
        (the SweepFeatureInput object) to define the sweep.
        Returns the newly created SweepFeature object or null if the creation failed.
        """
        return SweepFeature()
    def itemByName(self, name: str) -> SweepFeature:
        """
        Function that returns the specified sweep feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return SweepFeature()
    @property
    def count(self) -> int:
        """
        The number of sweep features in the collection.
        """
        return int()

class TemporaryBRepManager(core.Base):
    """
    A utility object that provides functionality to create and manipulate B-Rep data outside
    the context of a document. The provides direct access to the modeling core without the
    overhead of parametrics, persistence, transactions, or graphics. It also provides a way
    of directly defining and creating B-Rep data.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TemporaryBRepManager:
        return TemporaryBRepManager()
    @staticmethod
    def get() -> TemporaryBRepManager:
        """
        Gets the TempoaryBRepManager object. This object provides access to functionality to
        create an manipulate temporary B-Rep data outside the context of a document.
        Returns the TemporaryBRepManager object.
        """
        return TemporaryBRepManager()
    def copy(self, bRepEntity: core.Base) -> BRepBody:
        """
        Creates a temporary copy of the input BRepBody, BRepFace, or BRepEdge object.
        bRepEntity : The BRepBody, BRepFace, BRepLoop, or BRepEdge to create a copy of. This can be a parametric
        B-Rep entity or a temporary B-Rep entity.
        Returns a BRepBody that contains the result. If a BRepBody is input the copy is
        of the entire body. If a BRepFace is input, then the result is a BRepBody that
        contains a single face. If a BRepLoop is input then the result is a BRepBody that
        contains a wire where each edge in the loop will have a corresponding edge in the wire.
        If a BRepEdge is input then the result is a BRepBody that contains a wire that contains
        the single edge.
        """
        return BRepBody()
    def planeIntersection(self, body: BRepBody, plane: core.Plane) -> BRepBody:
        """
        Calculates the intersection between the input body and plane and creates a
        wire body that represents the intersection curves.
        body : The BRepBody to intersection.
        plane : The geometry Plane to intersect with the body.
        Returns a BRepBody that contains a wire body that represents the intersection.
        """
        return BRepBody()
    def createRuledSurface(self, sectionOne: BRepWire, sectionTwo: BRepWire) -> BRepBody:
        """
        Creates a new body by creating a ruled surface between the two input wire bodies.
        sectionOne : BRepWire that defines the shape of the first section.
        sectionTwo : BRepWire that defines the shape of the second section.
        Returns the created ruled surface as a BRepBody object.
        """
        return BRepBody()
    def createSilhouetteCurves(self, face: BRepFace, viewDirection: core.Vector3D, returnCoincidentSilhouettes: bool) -> BRepBody:
        """
        Calculates the silhouette curve geometry for a given face as viewed from a given direction.
        face : Input BRepFace object to calculate the silhouette curve for.
        viewDirection : Input Vector3D object that defines the view direction to calculate the silhouette curve relative to.
        The silhouette curve(s) will lie along the path where the face normal is perpendicular to the view direction.
        returnCoincidentSilhouettes : Input Boolean that specifies if silhouette curves that are coincident to the edges of the face should be
        returned or not. If true, these curves will be returned.
        Returns a SurfaceBody object that will contain one or more BRepWire objects that represent the silhouette curve(s).
        This method can return null in the case where there is not a silhouette curve for the specified face.
        """
        return BRepBody()
    def deleteFaces(self, faces: list[BRepFace], deleteSpecifiedFaces: bool) -> bool:
        """
        Deletes one or more faces from a temporary BRepBody. The body that will be modified is determined
        by getting the parent body of the input faces.
        faces : An array of BRepFace objects to delete. If more than one face is provided,
        all of the faces must exist within the same body.
        deleteSpecifiedFaces : This allows you to either delete the faces that were input or to keep those faces and delete all the
        other faces in the body.
        Returns true if the operation was successful.
        """
        return bool()
    def booleanOperation(self, targetBody: BRepBody, toolBody: BRepBody, booleanType: BooleanTypes) -> bool:
        """
        Performs the specified Boolean operation between the two input bodies. The input bodies need
        not be solid but can be faces that are combined or trimmed.
        targetBody : The target body that will be modified as a result of the Boolean operation.
        toolBody : The tool body that will be used to operate on the target body.
        booleanType : The type of Boolean operation to perform.
        Returns true if the operation was successful. If successful, the target body is modified as a result of the
        Boolean operation. Because of this the targetBody must always be a temporary BRepBody. The tool body is not
        modified. This is analogous to a machining operation where you have the target that is being machined and
        the tool that removes material.
        """
        return bool()
    def transform(self, body: BRepBody, transform: core.Matrix3D) -> bool:
        """
        Transforms the input body using the specified transformation matrix.
        body : The BRepBody object to transform.
        transform : The transformation matrix that defines the transform to apply to the body.
        Returns true if the specified transform was successfully applied to the body.
        """
        return bool()
    def createFromFile(self, filename: str) -> BRepBodies:
        """
        Creates new BRepBody objects based on the contents of the specified file.
        filename : The full path and name of the file to read in. This can be a SMT, SMB, SAT, or SAB file.
        A BRepBodies collection object is returned which can contain multiple BRepBody objects.
        null is returned in the case where it was unable to read the file.
        """
        return BRepBodies()
    def exportToFile(self, bodies: list[BRepBody], filename: str) -> bool:
        """
        Exports the input bodies to the specified file.
        bodies : An array of BRepBody objects that you want to export.
        filename : The filename to write the BRepBody objects to. The type of file to create
        is inferred from the extension of the file. The valid extensions are ".sat" and ".smt".
        Returns true if the export was successful.
        """
        return bool()
    def createBox(self, box: core.OrientedBoundingBox3D) -> BRepBody:
        """
        Creates a new temporary solid box BRepBody object.
        box : The OrientedBoundingBox3D object that defines the position, orientation, and
        size of the box to crate.
        Returns the newly created temporary BRepBody object or null in the case of failure.
        """
        return BRepBody()
    def createCylinderOrCone(self, pointOne: core.Point3D, pointOneRadius: float, pointTwo: core.Point3D, pointTwoRadius: float) -> BRepBody:
        """
        Creates a temporary solid cylinder or cone BRepBody object.
        pointOne : A point at one end of the cylinder or cone.
        pointOneRadius : The radius of the cylinder or cone at the point one end, in centimeters.
        pointTwo : A point at the opposite end of the cylinder or cone.
        pointTwoRadius : The radius of the cylinder or cone at the point two end, in centimeters.
        For a cylinder the pointTwoRadius should be equal to the pointOneRadius.
        Returns the newly created temporary BRepBody object or null in the case of failure.
        """
        return BRepBody()
    def createEllipticalCylinderOrCone(self, pointOne: core.Point3D, pointOneMajorRadius: float, pointOneMinorRadius: float, pointTwo: core.Point3D, pointTwoMajorRadius: float, majorAxisDirection: core.Vector3D) -> BRepBody:
        """
        Creates a temporary elliptical solid cylinder or cone BrepBody object.
        pointOne : A point at one end of the cylinder or cone.
        pointOneMajorRadius : The major radius of the cylinder or cone at the point one end, in centimeters.
        pointOneMinorRadius : The minor radius of the cylinder or cone at the point one end, in centimeters.
        pointTwo : A point at the opposite end of the cone.
        pointTwoMajorRadius : The major radius of the cylinder or cone at the point two end, in centimeters. The
        minor radius is automatically determined using the point one ratio of the minor and major
        radii.
        majorAxisDirection : A Vector3D object that defines the direction of the major axis.
        Returns the newly created temporary BRepBody object or null in the case of failure.
        """
        return BRepBody()
    def createSphere(self, center: core.Point3D, radius: float) -> BRepBody:
        """
        Creates a temporary spherical BRepBody object.
        center : The center point of the sphere.
        radius : The radius of the sphere in centimeters.
        Returns the newly created temporary BRepBody object or null in the case of failure.
        """
        return BRepBody()
    def createTorus(self, center: core.Point3D, axis: core.Vector3D, majorRadius: float, minorRadius: float) -> BRepBody:
        """
        Creates a temporary toroidal BRepBody object.
        center : The center point of the torus.
        axis : The axis of the torus.
        majorRadius : The radius, in centimeters, of the major radius of the torus. If the torus was created
        by sweeping a circle around another circle this would be the radius of the path circle.
        minorRadius : The radius, in centimeters, of the minor radius of the torus. If the torus was created
        by sweeping a circle around another circle this would be the radius of the profile circle.
        Returns the newly created temporary BRepBody object or null in the case of failure.
        """
        return BRepBody()
    def createFaceFromPlanarWires(self, wireBodies: list[BRepBody]) -> BRepBody:
        """
        Creates a body from multiple wires that all lie within the same plane. Multiple wires are
        used when creating a plane with interior holes. One wire defines the outer shape and the
        other wires define the interior loops of the created face.
        wireBodies : An array of bodies that contain planar wires. Each wire must be closed, they should not overlap,
        and they should all lie on the same plane.
        Returns a BRepBody containing the created BRepFace object or null in the case of failure.
        """
        return BRepBody()
    def imprintOverlapBodies(self, bodyOne: BRepBody, bodyTwo: BRepBody, imprintCoincidentEdges: bool, tolerance: float) -> tuple[bool, BRepBody, BRepBody, list[BRepFace], list[BRepFace], list[BRepEdge], list[BRepEdge]]:
        """
        <p>Method that finds regions of faces on two bodies which overlap and creates new bodies where the faces
        are split at the edges of the overlaps. This does not modify the original bodies but creates new
        temporary bodies that contain the imprints.</p>
        
        <p>The picture below shows an example of imprinting. The picture on the left shows the initial two bodies
        that are positioned so there are coincident faces. The picture on the right shows the two bodies individually
        so you can see the result of the imprint and how the coincident faces were split. </p>
        <br/><br/><center><img src="../Images/ImprintBodies.png"></center><br/>
        
        <p>The ability to imprint solids can be important to applications that need to mesh models. By creating edges
        at the points where solids connect, it guarantees that there will be mesh nodes along those boundaries.</p>
        bodyOne : Input BRepBody that will participate in the imprint operation. This body can be either a parametric
        or temporary body.
        bodyTwo : Input BRepBody that will participate in the imprint operation. This body can be either a parametric
        or temporary body.
        imprintCoincidentEdges : <p>Input Boolean that indicates if overlapping edges should be included in the result. The picture below
        shows an example of when this argument will make a difference. The two bodies have overlapping faces
        and there is also an overlapping edge. If this argument is true, then the edge shown in red below
        will be included in the output as an overlapping edge. If False it will not be included and only
        the edges of the overlapping faces will be in the overlapping faces collections.</p>
        <br/><br/><center><img src="../Images/ImprintOverlappingEdges.png"></center>
        resultBodyOne : Output temporary BRepBody that contains the imprinted body that corresponds to the body provided through the bodyOne argument.
        resultBodyTwo : Output temporary BRepBody that contains the imprinted body that corresponds to the body provided through the bodyTwo argument.
        bodyOneOverlappingFaces : Output array of BRepFace objects that represent the overlapping faces that are part of resultBodyOne. Faces at the same index within the
        collection returned here and that returned by the bodyTwoOverlappingFaces are overlapping.
        bodyTwoOverlappingFaces : Output array of BRepFace objects that represent the overlapping faces that are part of resultBodyTwo. Faces at the same index within the
        collection returned here and that returned by the bodyOneOverlappingFaces are overlapping.
        bodyOneOverlappingEdges : Output array of BRepEdge objects that represent the overlapping edges that are part of resultBodyOne. Edges at the same index within the
        collection returned here and that returned by the bodyTwoOverlappingEdges are overlapping.
        bodyTwoOverlappingEdges : Output array of BRepEdge objects that represent the overlapping edges that are part of resultBodyTwo. Edges at the same index within the
        collection returned here and that returned by the bodyOneOverlappingEdges are overlapping.
        tolerance : Optional Input double that specifies the tolerance, in centimeters, to use when comparing the bodies. If not specified, or a value of zero
        is specified, the internal modeling tolerance will be used.
        Returns true if the imprint calculation was successful.
        """
        return (bool(), BRepBody(), BRepBody(), [BRepFace()], [BRepFace()], [BRepEdge()], [BRepEdge()])
    def createWireFromCurves(self, curves: list[core.Curve3D], allowSelfIntersections: bool) -> tuple[BRepBody, list[BRepEdge]]:
        """
        Give an array of curve geometry objects, this method creates a new wire body.
        curves : An array containing the input Curve3D objects. These can be Arc3D, Circle3D, Ellipse3D, EllipticalArc3D or Line3D objects.
        edgeMap : An array of edges in the returned body. The order that the edges are in this collection is the
        same order as the original corresponding Curve3D object is in the input curves array. This allows you to
        map between the original input curve and created edge.
        allowSelfIntersections : Specifies if you want to allow self-intersection in the input curves or not.
        Returns the B-Rep body containing the created wire or null in the case of failure.
        """
        return (BRepBody(), [BRepEdge()])
    def createHelixWire(self, axisPoint: core.Point3D, axisVector: core.Vector3D, startPoint: core.Point3D, pitch: float, turns: float, taperAngle: float) -> BRepBody:
        """
        Creates a B-Rep body that contains a wire with a single edge that represents a helical curve.
        axisPoint : A Point3D object that defines a point along the axis of the helix.
        axisVector : A Vector3D object that defines the direction of the axis of the helix.
        startPoint : A Point3D that defines the start point of the helix. This is a point on the helix and defines the starting
        point of the helix. The distance of this point to the axis defines the starting radius of the helix.
        pitch : The pitch of the helix, or the distance between each of the turns, in centimeters.
        turns : The number of turns of the helix.
        taperAngle : The taper angle of the helix in radians.
        Returns a temporary BRepBody object that contains a wire body that is the shape of the
        specified helix. Return null if the creation failed.
        """
        return BRepBody()

class TextureImage(core.Base):
    """
    Provides access to the image data associated with a texture map.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TextureImage:
        return TextureImage()
    @property
    def transform(self) -> core.Matrix2D:
        """
        The transform of the texture image in parametric space.
        """
        return core.Matrix2D()

class ThickenFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a Thicken feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ThickenFeatureInput:
        return ThickenFeatureInput()
    @property
    def inputFaces(self) -> core.ObjectCollection:
        """
        An ObjectCollection containing the face and/or patch bodies to thicken.
        """
        return core.ObjectCollection()
    @inputFaces.setter
    def inputFaces(self, value: core.ObjectCollection):
        """
        An ObjectCollection containing the face and/or patch bodies to thicken.
        """
        pass
    @property
    def thickness(self) -> core.ValueInput:
        """
        Gets and sets the ValueInput object that defines the thickness distance.
        """
        return core.ValueInput()
    @thickness.setter
    def thickness(self, value: core.ValueInput):
        """
        Gets and sets the ValueInput object that defines the thickness distance.
        """
        pass
    @property
    def isSymmetric(self) -> bool:
        """
        Gets and sets whether to add thickness symmetrically or only on one side of the face/s to thicken
        """
        return bool()
    @isSymmetric.setter
    def isSymmetric(self, value: bool):
        """
        Gets and sets whether to add thickness symmetrically or only on one side of the face/s to thicken
        """
        pass
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the feature operation to perform.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the feature operation to perform.
        """
        pass
    @property
    def isChainSelection(self) -> bool:
        """
        Get and sets whether faces that are tangentially connected to the input faces will be included in the thicken feature.
        """
        return bool()
    @isChainSelection.setter
    def isChainSelection(self, value: bool):
        """
        Get and sets whether faces that are tangentially connected to the input faces will be included in the thicken feature.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class ThickenFeatures(core.Base):
    """
    Collection that provides access to all of the existing Thicken features in a component
    and supports the ability to create new Thicken features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ThickenFeatures:
        return ThickenFeatures()
    def item(self, index: int) -> ThickenFeature:
        """
        Function that returns the specified Thicken feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ThickenFeature()
    def createInput(self, inputFaces: core.ObjectCollection, thickness: core.ValueInput, isSymmetric: bool, operation: FeatureOperations, isChainSelection: bool) -> ThickenFeatureInput:
        """
        Creates a ThickenFeatureInput object. Use properties and methods on this object
        to define the Thicken feature you want to create and then use the Add method, passing in
        the ThickenFeatureInput object to create the feature.
        inputFaces : The faces or patch bodies to thicken. Faces need not be from the same component or body, nor do they need to be
        connected or touching one another.
        thickness : ValueInput object that defines the thickness.
        isSymmetric : A boolean value for setting whether to add thickness symmetrically or only on one side of the face/s to thicken
        operation : The feature operation to perform.
        isChainSelection : A boolean value for setting whether or not faces that are tangentially connected to
        the input faces (if any) will be included in the thicken. The default value is true.
        Returns the newly created ThickenFeatureInput object or null if the creation failed.
        """
        return ThickenFeatureInput()
    def add(self, input: ThickenFeatureInput) -> ThickenFeature:
        """
        Creates a new Thicken feature.
        input : A FeatureInput object that defines the desired Thicken feature. Use the createInput
        method to create a new ThickenFeatureInput object and then use methods on it
        (the ThickenFeatureInput object) to define the Thicken feature.
        Returns the newly created ThickenFeature object or null if the creation failed.
        """
        return ThickenFeature()
    def itemByName(self, name: str) -> ThickenFeature:
        """
        Function that returns the specified thicken feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return ThickenFeature()
    @property
    def count(self) -> int:
        """
        The number of Thicken features in the collection.
        """
        return int()

class ThreadDataQuery(core.Base):
    """
    This object provides methods to query the thread data contained in the XML files in ThreadData folder within the
    Fusion 360 install folder. You can use the queried values to create a ThreadInfo object that is then used to
    create a thread feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ThreadDataQuery:
        return ThreadDataQuery()
    def allSizes(self, threadType: str) -> list[str]:
        """
        Returns an array/list of all the available thread sizes for a given thread type. You can
        use the allThreadTypes property to get the available thread types.
        threadType : Specify the thread type.
        Returns the specified thread sizes or an empty array/list if an invalid thread type was specified.
        """
        return [str()]
    def allDesignations(self, threadType: str, size: str) -> list[str]:
        """
        returns an array/list of all the available thread designations for a thread type of a given size. Valid
        thread types and sizes and be obtained by using the allThreadTypes and allSizes functions.
        threadType : The thread type of the designation you want.
        size : The thread size of the designation you want.
        Returns the specified thread designations or empty array/list if an invalid thread type or size was specified.
        """
        return [str()]
    def allClasses(self, isInternal: bool, threadType: str, designation: str) -> list[str]:
        """
        Returns and array/list of all the available classes for a thread type of a given thread designation.
        isInternal : Indicates if the thread is an internal or external thread.
        threadType : The thread type of the thread class you want.
        designation : The thread designation of the thread class you want.
        Returns the specified thread classes or empty array/list if an invalid thread type or designation was specified.
        """
        return [str()]
    def threadTypeCustomName(self, threadType: str) -> str:
        """
        Method that returns the custom name for a given thread type.
        threadType : The thread type you want to get the custom name for.
        Returns the specified custom name or an empty string if an invalid thread type was specified.
        """
        return str()
    def threadTypeUnit(self, threadType: str) -> str:
        """
        Method that returns the unit for a given thread type.
        threadType : The thread type you want to get the thread unit type for.
        Returns the specified unit or an empty string if an invalid thread type was specified.
        """
        return str()
    def recommendThreadData(self, modelDiameter: float, isInternal: bool, threadType: str) -> tuple[bool, str, str]:
        """
        Method that gets the recommended thread data for a given model diameter.
        modelDiameter : The diameter of the cylinder the thread will be placed on. The units are centimeters.
        isInternal : Indicates if the thread is an internal or external thread.
        threadType : Specifies the thread type to query the thread data.
        designation : The output thread designation.
        threadClass : The output thread class.
        Returns true if successful.
        """
        return (bool(), str(), str())
    @property
    def allThreadTypes(self) -> list[str]:
        """
        Returns an array/list of all the available thread types (families).
        """
        return [str()]
    @property
    def defaultInchThreadType(self) -> str:
        """
        Gets the default thread type for inch threads.
        """
        return str()
    @property
    def defaultMetricThreadType(self) -> str:
        """
        Gets the default thread type for metric threads.
        """
        return str()

class ThreadFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a thread
    feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ThreadFeatureInput:
        return ThreadFeatureInput()
    @property
    def inputCylindricalFace(self) -> BRepFace:
        """
        Gets and sets the threaded face. In the case where there are multiple faces, only the first one is returned.
        Setting this results in a thread being applied to only a single face.
        It is recommended that you use the inputCylindricalfaces property in order to have full access to the collection of faces
        to be threaded.
        """
        return BRepFace()
    @inputCylindricalFace.setter
    def inputCylindricalFace(self, value: BRepFace):
        """
        Gets and sets the threaded face. In the case where there are multiple faces, only the first one is returned.
        Setting this results in a thread being applied to only a single face.
        It is recommended that you use the inputCylindricalfaces property in order to have full access to the collection of faces
        to be threaded.
        """
        pass
    @property
    def isModeled(self) -> bool:
        """
        Gets and sets if the thread is physical or cosmetic thread. A value of true indicates a physical thread.
        It defaults to false.
        """
        return bool()
    @isModeled.setter
    def isModeled(self, value: bool):
        """
        Gets and sets if the thread is physical or cosmetic thread. A value of true indicates a physical thread.
        It defaults to false.
        """
        pass
    @property
    def isFullLength(self) -> bool:
        """
        Gets and sets if this thread is the full length of the cylinder.
        It defaults to true.
        """
        return bool()
    @isFullLength.setter
    def isFullLength(self, value: bool):
        """
        Gets and sets if this thread is the full length of the cylinder.
        It defaults to true.
        """
        pass
    @property
    def threadLength(self) -> core.ValueInput:
        """
        Gets and sets the thread length.
        It is only used in the case where the isFullLength property is false.
        """
        return core.ValueInput()
    @threadLength.setter
    def threadLength(self, value: core.ValueInput):
        """
        Gets and sets the thread length.
        It is only used in the case where the isFullLength property is false.
        """
        pass
    @property
    def threadOffset(self) -> core.ValueInput:
        """
        Gets and sets the thread offset.
        The offset is the distance along the axis of the cylinder from the edge to the start of the thread.
        It is only used in the case where the isFullLength property is false.
        Returns nothing in the case where the feature is non-parametric.
        """
        return core.ValueInput()
    @threadOffset.setter
    def threadOffset(self, value: core.ValueInput):
        """
        Gets and sets the thread offset.
        The offset is the distance along the axis of the cylinder from the edge to the start of the thread.
        It is only used in the case where the isFullLength property is false.
        Returns nothing in the case where the feature is non-parametric.
        """
        pass
    @property
    def threadLocation(self) -> ThreadLocations:
        """
        Gets and sets where the thread length is measured from.
        This property is only used in the case where the isFullLength property is false.
        """
        return ThreadLocations()
    @threadLocation.setter
    def threadLocation(self, value: ThreadLocations):
        """
        Gets and sets where the thread length is measured from.
        This property is only used in the case where the isFullLength property is false.
        """
        pass
    @property
    def threadInfo(self) -> ThreadInfo:
        """
        Gets and sets the thread data.
        """
        return ThreadInfo()
    @threadInfo.setter
    def threadInfo(self, value: ThreadInfo):
        """
        Gets and sets the thread data.
        """
        pass
    @property
    def isRightHanded(self) -> bool:
        """
        Gets and sets if the thread is right or left-handed thread. A value of true indicates a right-handed thread.
        It defaults to true.
        """
        return bool()
    @isRightHanded.setter
    def isRightHanded(self, value: bool):
        """
        Gets and sets if the thread is right or left-handed thread. A value of true indicates a right-handed thread.
        It defaults to true.
        """
        pass
    @property
    def inputCylindricalFaces(self) -> core.ObjectCollection:
        """
        Gets and sets the cylindrical input faces.
        """
        return core.ObjectCollection()
    @inputCylindricalFaces.setter
    def inputCylindricalFaces(self, value: core.ObjectCollection):
        """
        Gets and sets the cylindrical input faces.
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class ThreadFeatures(core.Base):
    """
    Collection that provides access to all of the existing thread features in a component
    and supports the ability to create new thread features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ThreadFeatures:
        return ThreadFeatures()
    def item(self, index: int) -> ThreadFeature:
        """
        Function that returns the specified thread feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ThreadFeature()
    def createInput(self, inputCylindricalFaces: core.Base, threadInfo: ThreadInfo) -> ThreadFeatureInput:
        """
        Creates a ThreadFeatureInput object. This object is the API equivalent of the Thread feature dialog. It collects
        the required input and once fully defined you can pass this object to the ThreadFeatures.add method to create
        the thread feature.
        inputCylindricalFaces : A single cylindrical BRep face or a collection of cylindrical BRep faces to thread.
        A collection of faces must all be from either holes (for internal threading) or all from cylinders (for external threading).
        Both internal and external threads cannot be created in the same feature.
        The faces in a collection can come from different bodies or components.
        threadInfo : The ThreadInfo object that defines the type and size of the thread to create. When creating a thread, the type and size
        of the thread is specified by referencing thread information defined in one of the XML files in the ThreadData folder within
        the Fusion 360 install folder. You can use the ThreadDataQuery object to query these XML files to find the specific thread you
        want to create. The ThreadDataQuery object can be obtained by using the ThreadFeatures.threadDataQuery property. You then use
        this information to create a ThreadInfo object using the ThreadFeatures.createThreadInfo method.
        Returns the newly created ThreadFeatureInput object or null/None if the creation failed.
        """
        return ThreadFeatureInput()
    def createThreadInfo(self, isInternal: bool, threadType: str, threadDesignation: str, threadClass: str) -> ThreadInfo:
        """
        Method that creates a new ThreadInfo object that can be used in creating thread features.
        The ThreadInfo object that defines the type and size of the thread to create. When creating a thread, the type and size
        of the thread is specified by referencing thread information defined in one of the XML files in the ThreadData folder within
        the Fusion 360 install folder. You can use the ThreadDataQuery object to query these XML files to find the specific thread you
        want to create. The ThreadDataQuery object can be obtained by using the ThreadFeatures.threadDataQuery property.
        isInternal : Input Boolean that indicates if the thread is an internal or external thread. A value of true indicates an internal thread.
        threadType : Input string that defines the thread type.
        threadDesignation : Input string that contains the thread designation.
        This is input as the full thread designation that will be used in a drawing for the thread call-out.
        The nominal size and pitch information are extracted from the designation.
        threadClass : Input string that defines the thread class.
        Returns the newly created ThreadInfo object or null if the creation failed.
        """
        return ThreadInfo()
    def add(self, input: ThreadFeatureInput) -> ThreadFeature:
        """
        Creates a new thread feature.
        input : A ThreadFeatureInput object that defines the desired thread. Use the createInput
        method to create a new ThreadFeatureInput object and then use methods on it
        (the ThreadFeatureInput object) to define the thread.
        Returns the newly created ThreadFeature object or null if the creation failed.
        """
        return ThreadFeature()
    def itemByName(self, name: str) -> ThreadFeature:
        """
        Function that returns the specified thread feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return ThreadFeature()
    @property
    def count(self) -> int:
        """
        The number of thread features in the collection.
        """
        return int()
    @property
    def threadDataQuery(self) -> ThreadDataQuery:
        """
        Property that returns the ThreadDataQuery object. When creating a thread, the type and size of the thread
        is specified by referencing thread information defined in one of the XML files in the ThreadData folder.
        The ThreadDataQuery is an object that supports methods to query the existing threads defined in these files.
        """
        return ThreadDataQuery()

class ThreadInfo(core.Base):
    """
    This class defines the methods and properties that define the type and size of a thread. This object is used
    to create new thread features and to query and edit existing thread features. A new ThreadInfo object is created
    by using the ThreadFeatures.createThreadInfo method. If the ThreadInfo object is obtained from an existing thread
    feature, modifying properties on the ThreadInfo object will modify the feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ThreadInfo:
        return ThreadInfo()
    @property
    def threadType(self) -> str:
        """
        Returns and sets the string that defines the thread type.
        """
        return str()
    @threadType.setter
    def threadType(self, value: str):
        """
        Returns and sets the string that defines the thread type.
        """
        pass
    @property
    def threadSize(self) -> str:
        """
        Returns the string that defines the thread size. This is
        """
        return str()
    @property
    def threadDesignation(self) -> str:
        """
        Returns and sets the string that defines the thread designation.
        """
        return str()
    @threadDesignation.setter
    def threadDesignation(self, value: str):
        """
        Returns and sets the string that defines the thread designation.
        """
        pass
    @property
    def threadClass(self) -> str:
        """
        Returns and sets the string that defines the thread class.
        """
        return str()
    @threadClass.setter
    def threadClass(self, value: str):
        """
        Returns and sets the string that defines the thread class.
        """
        pass
    @property
    def isInternal(self) -> bool:
        """
        Returns and sets if the thread is an internal or external thread. A value of true indicates an internal thread.
        It defaults to true.
        """
        return bool()
    @isInternal.setter
    def isInternal(self, value: bool):
        """
        Returns and sets if the thread is an internal or external thread. A value of true indicates an internal thread.
        It defaults to true.
        """
        pass
    @property
    def threadAngle(self) -> float:
        """
        Returns the value that defines the thread angle. The units are degrees.
        """
        return float()
    @property
    def threadPitch(self) -> float:
        """
        Returns the value that defines the thread pitch. The units are centimeters.
        """
        return float()
    @property
    def majorDiameter(self) -> float:
        """
        Returns the value that defines the major diameter. The units are centimeters.
        """
        return float()
    @property
    def minorDiameter(self) -> float:
        """
        Returns the value that defines the minor diameter. The units are centimeters.
        """
        return float()
    @property
    def pitchDiameter(self) -> float:
        """
        Returns the value that defines the pitch diameter. The units are centimeters.
        """
        return float()

class Timeline(core.Base):
    """
    A collection of TimelineObjects in a parametric design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Timeline:
        return Timeline()
    def moveToBeginning(self) -> bool:
        """
        Moves the marker to the beginning of the timeline.
        Returns true if the move is successful
        """
        return bool()
    def moveToEnd(self) -> bool:
        """
        Moves the marker to the end of the timeline.
        Returns true if the move is successful
        """
        return bool()
    def movetoNextStep(self) -> bool:
        """
        Moves the marker to the next step in the timeline.
        Returns true if the move is successful
        """
        return bool()
    def moveToPreviousStep(self) -> bool:
        """
        Moves the marker to the previous step in the timeline.
        Returns true if the move is successful
        """
        return bool()
    def play(self) -> bool:
        """
        Plays the timeline beginning at the current position of the marker.
        Returns true if playing the timeline was successful
        """
        return bool()
    def item(self, index: int) -> TimelineObject:
        """
        Function that returns the specified item in the timeline using an index into the collection.
        The items are returned in the order they appear in the timeline.
        index : The index of the item within the collection to return. The first item in the collection
        has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return TimelineObject()
    def deleteAllAfterMarker(self) -> bool:
        """
        Deletes all objects in the timeline that are after the current position of the marker.
        Returns true if successful.
        """
        return bool()
    @property
    def markerPosition(self) -> int:
        """
        Gets and sets the current position of the marker where
        0 is at the beginning of the timeline and the value of Timeline.count is the end of the
        timeline.
        """
        return int()
    @markerPosition.setter
    def markerPosition(self, value: int):
        """
        Gets and sets the current position of the marker where
        0 is at the beginning of the timeline and the value of Timeline.count is the end of the
        timeline.
        """
        pass
    @property
    def count(self) -> int:
        """
        Returns the number of items in the collection.
        """
        return int()
    @property
    def timelineGroups(self) -> TimelineGroups:
        """
        Returns the collection of groups within the timeline.
        """
        return TimelineGroups()

class TimelineGroups(core.Base):
    """
    Provides access to the time line groups within a design and provides
    methods to create new groups.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TimelineGroups:
        return TimelineGroups()
    def add(self, startIndex: int, endIndex: int) -> TimelineGroup:
        """
        Creates a new group within the timeline. The sequential set of items defined
        by the start and end indices will be included in the group. A group cannot contains
        another group so none of the items being grouped can be a group of this will fail.
        startIndex : The index of the first item in the timeline that will be added to the group.
        endIndex : The index of the last item in the timeline that will be added to the group.
        Returns the created TimelineGroup object or null in the case of failure.
        """
        return TimelineGroup()
    def item(self, index: int) -> TimelineGroup:
        """
        Function that returns the specified timeline group using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return TimelineGroup()
    @property
    def count(self) -> int:
        """
        Returns the number of items in the collection.
        """
        return int()

class TimelineObject(core.Base):
    """
    Represents an object in the timeline.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TimelineObject:
        return TimelineObject()
    def rollTo(self, rollBefore: bool) -> bool:
        """
        Rolls the timeline by repositioning the marker to either before or after this object.
        This method will fail if this is a timelineGroup object and the group is expanded.
        rollBefore : Set rollBefore to true to reposition the marker before this object or to false to
        reposition the marker after this object
        Returns true if the move was successful
        """
        return bool()
    def canReorder(self, beforeIndex: int) -> bool:
        """
        Checks to see if this object can be reordered to the specified position.
        The default value of -1 indicates the end of the timeline.
        
        This method will fail if this is a timelineGroup object and the group is expanded.
        beforeIndex : The index number of the position in the timeline to check
        Returns true if the object can be reordered to the specified position
        """
        return bool()
    def reorder(self, beforeIndex: int) -> bool:
        """
        Reorders this object to the position specified.
        The default value of -1 indicates the end of the timeline.
        beforeIndex : The index number of the position in the timeline to place this object before
        Returns true if the reorder operation was successful
        This method will fail and return false if this is a timelineGroup object and the
        group is expanded.
        """
        return bool()
    @property
    def isSuppressed(self) -> bool:
        """
        Gets and sets if this object is suppressed.
        """
        return bool()
    @isSuppressed.setter
    def isSuppressed(self, value: bool):
        """
        Gets and sets if this object is suppressed.
        """
        pass
    @property
    def parentGroup(self) -> TimelineGroup:
        """
        Returns the parent group, if this object is part of a group.
        Returns null if this object is not part of a group.
        """
        return TimelineGroup()
    @property
    def index(self) -> int:
        """
        Returns the position of this item within the timeline where
        the first item has an index of 0.
        
        This property can return -1 in the two cases where this object
        is not currently represented in the timeline. The two cases are:
        1. When this is a TimelineGroup object and the group is expanded.
        2. When this object is part of a group and the group is collapsed.
        """
        return int()
    @property
    def isRolledBack(self) -> bool:
        """
        Indicates if this item is currently not being computed
        because it has been rolled back.
        
        If this is a timelineGroup object and the group is expanded
        the value of this property should be ignored.
        """
        return bool()
    @property
    def entity(self) -> core.Base:
        """
        Returns the entity associated with this timeline object.
        Edit operations can be performed by getting the object
        representing the associated entity and using the methods
        and properties on that entity to make changes.
        
        Returns null if this is a TimelineGroup object
        """
        return core.Base()
    @property
    def isGroup(self) -> bool:
        """
        Indicates if this TimelineObject represents a group. If True you can
        operate on this object as a TimelineGroup object.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of this timeline object. This name is shared by the object
        the timeline object represents. For example, if the TimelineObject represents a Sketch
        and you change the name using the TimelineObject, the name of the sketch in the browser
        is also changed. The reverse is also true. Setting the name of an object; sketch, feature
        construction geometry, etc, will also change the name of the associated node in the timeline.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of this timeline object. This name is shared by the object
        the timeline object represents. For example, if the TimelineObject represents a Sketch
        and you change the name using the TimelineObject, the name of the sketch in the browser
        is also changed. The reverse is also true. Setting the name of an object; sketch, feature
        construction geometry, etc, will also change the name of the associated node in the timeline.
        """
        pass
    @property
    def healthState(self) -> FeatureHealthStates:
        """
        Returns the current health state of the object associated with this TimelineObject.
        """
        return FeatureHealthStates()
    @property
    def errorOrWarningMessage(self) -> str:
        """
        Returns the error or warning message in the case where the healthState property returns either
        WarningFeatureHealthState or ErrorFeatureHealthState. Otherwise this property returns an empty string.
        """
        return str()

class TorusFeatures(core.Base):
    """
    Collection that provides access to all of the existing torus features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TorusFeatures:
        return TorusFeatures()
    def item(self, index: int) -> TorusFeature:
        """
        Function that returns the specified torus feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return TorusFeature()
    def itemByName(self, name: str) -> TorusFeature:
        """
        Function that returns the specified torus feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return TorusFeature()
    @property
    def count(self) -> int:
        """
        The number of torus features in the collection.
        """
        return int()

class TriangleMesh(core.Base):
    """
    The TriangleMesh object represents all of the data defining
    a triangular mesh.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TriangleMesh:
        return TriangleMesh()
    @property
    def nodeCount(self) -> int:
        """
        Returns the total number of nodes in the mesh.
        """
        return int()
    @property
    def nodeCoordinatesAsDouble(self) -> list[float]:
        """
        Returns the node coordinates as an array of doubles where
        they are the x, y, z components of each coordinate.
        """
        return [float()]
    @property
    def nodeCoordinatesAsFloat(self) -> list[float]:
        """
        Returns the node coordinates as an array of floats where
        they are the x, y, z components of each coordinate.
        """
        return [float()]
    @property
    def nodeCoordinates(self) -> list[core.Point3D]:
        """
        Returns the node coordinates as an array of Point3D objects.
        """
        return [core.Point3D()]
    @property
    def triangleCount(self) -> int:
        """
        Returns the number of triangles in the mesh.
        """
        return int()
    @property
    def normalVectorsAsDouble(self) -> list[float]:
        """
        Returns the normal vectors of the mesh where there is a normal
        vector at each node. The normals are returned as an array
        of doubles where they are the x, y, z components of each vector.
        """
        return [float()]
    @property
    def normalVectorsAsFloat(self) -> list[float]:
        """
        Returns the normal vectors of the mesh where there is a normal
        vector at each node. The normals are returned as an array
        of floats where they are the x, y, z components of each vector.
        """
        return [float()]
    @property
    def normalVectors(self) -> list[core.Vector3D]:
        """
        Returns the normal vectors of the mesh where there is a normal
        vector at each node. The normals are returned as an array
        of Vector3D objects.
        """
        return [core.Vector3D()]
    @property
    def nodeIndices(self) -> list[int]:
        """
        Returns an array of indices that define which nodes are used
        for each triangle. This is used to look-up the coordinates in the
        NodeCoordinates array to get the three coordinates of each triangle.
        """
        return [int()]
    @property
    def textureCoordinatesAsDouble(self) -> list[float]:
        """
        Returns the texture coordinates used when mapping a texture to
        this face. The coordinates are returned as an array of
        doubles where they are the u and v components of each
        coordinate as defined in parametric space. There is a texture
        coordinate for each vertex in the face mesh.
        """
        return [float()]
    @property
    def textureCoordinatesAsFloat(self) -> list[float]:
        """
        Returns the texture coordinates used when mapping a texture to
        this face. The coordinates are returned as an array of
        floats where they are the u and v components of each
        coordinate as defined in parametric space. There is a texture
        coordinate for each vertex in the face mesh.
        """
        return [float()]
    @property
    def textureCoordinates(self) -> list[core.Point2D]:
        """
        Returns the texture coordinates used when mapping a texture to
        this face. The coordinates are returned as an array of
        Point2D objects where the x and y properties of the point are
        u and v coordinates as defined in parametric space. There is
        a texture coordinate for each vertex in the face mesh.
        """
        return [core.Point2D()]
    @property
    def surfaceTolerance(self) -> float:
        """
        Returns the surface tolerance that was used to generate this mesh.
        This is most useful when using display meshes that have already
        been calculated.
        """
        return float()

class TriangleMeshCalculator(core.Base):
    """
    Used to calculate new meshes for a B-Rep or T-Spline using defined criteria.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TriangleMeshCalculator:
        return TriangleMeshCalculator()
    def setQuality(self, triangleMeshQuality: TriangleMeshQualityOptions) -> bool:
        """
        This is a simplified way to set the various settings that control the resulting mesh. When used it automatically
        adjusts all of the property values appropriately. It does this for the given geometry by computing its bounding
        box diameter. Then the surface tolerance is calculated as shown below where the meshLOD is the "Level of Detail" and
        is described in more detail below. The diameter is the bounding box diameter.
        
        double nodeApproximateSize = std::pow(2.0, meshLOD);
        double fracTol = 1.0 / nodeApproximateSize;
        surfaceTolerance = fracTol * diameter;
        triangleMeshQuality : The mesh quality is specified by using an item from the enum list where the following items result
        in a corresponding mesh LOD that's used in the equation above.
        
        LowQualityTriangleMesh: 8
        NormalQualityTriangleMesh: 11
        HighQualityTriangleMesh: 13
        VeryHighQualityTriangleMesh: 15
        Returns true if setting the quality was successful.
        """
        return bool()
    def calculate(self) -> TriangleMesh:
        """
        Calculates a new triangle mesh based on the current settings.
        Returns the new TriangleMesh object or null in the case where the calculation failed.
        """
        return TriangleMesh()
    @property
    def surfaceTolerance(self) -> float:
        """
        Specifies the maximum distance that the mesh can deviate from the smooth surface.
        The value is in centimeters. Smaller values can result in a much greater number
        of facets being returned and will require more processing time to calculate.
        """
        return float()
    @surfaceTolerance.setter
    def surfaceTolerance(self, value: float):
        """
        Specifies the maximum distance that the mesh can deviate from the smooth surface.
        The value is in centimeters. Smaller values can result in a much greater number
        of facets being returned and will require more processing time to calculate.
        """
        pass
    @property
    def maxSideLength(self) -> float:
        """
        Specifies the maximum side of any triangle in the mesh. A value of 0 (the default)
        indicates that no maximum length is specified. The value is specified in centimeters.
        """
        return float()
    @maxSideLength.setter
    def maxSideLength(self, value: float):
        """
        Specifies the maximum side of any triangle in the mesh. A value of 0 (the default)
        indicates that no maximum length is specified. The value is specified in centimeters.
        """
        pass
    @property
    def maxAspectRatio(self) -> float:
        """
        Specifies the maximum length to height ratio that a triangle can have.
        This helps to avoid long skinny triangles. A value of 0 (the default)
        indicates that no maximum aspect ratio is specified.
        """
        return float()
    @maxAspectRatio.setter
    def maxAspectRatio(self, value: float):
        """
        Specifies the maximum length to height ratio that a triangle can have.
        This helps to avoid long skinny triangles. A value of 0 (the default)
        indicates that no maximum aspect ratio is specified.
        """
        pass
    @property
    def maxNormalDeviation(self) -> float:
        """
        Specifies the maximum deviation between adjacent vertex normals.
        This value is the maximum angle allowed between normals and is
        specified in radians. A value of 0 (the default) indicates that no normal deviation is specified.
        """
        return float()
    @maxNormalDeviation.setter
    def maxNormalDeviation(self, value: float):
        """
        Specifies the maximum deviation between adjacent vertex normals.
        This value is the maximum angle allowed between normals and is
        specified in radians. A value of 0 (the default) indicates that no normal deviation is specified.
        """
        pass
    @property
    def parentMeshManager(self) -> MeshManager:
        """
        Returns the parent MeshManager object.
        """
        return MeshManager()

class TriangleMeshList(core.Base):
    """
    Provides access to a set of triangle meshes.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TriangleMeshList:
        return TriangleMeshList()
    def item(self, index: int) -> TriangleMesh:
        """
        Returns the specified triangle meshes.
        index : The index of the mesh to return where the first item has an index of 0.
        Returns the specified mesh or null in the case of invalid index.
        """
        return TriangleMesh()
    @property
    def bestMesh(self) -> TriangleMesh:
        """
        Returns the mesh with the tightest surface tolerance. This can return null
        in the case the list is empty, ie. Count is 0.
        """
        return TriangleMesh()
    @property
    def count(self) -> int:
        """
        Returns the number of meshes in the collection.
        """
        return int()

class TrimFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a TrimFeatureInput.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TrimFeatureInput:
        return TrimFeatureInput()
    def cancel(self) -> bool:
        """
        To determine the possible boundaries and allow you to choose which cells to keep, the trim
        feature does a partial compute when the input object is created. To do this it starts a trim
        feature transaction and completes the transaction when you call the add method. If you don't
        call the add method it leaves Fusion 360 in a bad state and there will be undo problems and it
        will possibly crash. If you have created a TrimFeatureInput object and don't want to finish
        the feature creation, you need to call the cancel method on the TrimFeatureInput object to
        safely abort the current trim feature transaction.
        """
        return bool()
    @property
    def bRepCells(self) -> BRepCells:
        """
        Returns the collection of the valid cells that have been calculated based on the trim tool.
        Use this collection to specify which cells to trim away.
        """
        return BRepCells()
    @property
    def trimTool(self) -> core.Base:
        """
        Gets and sets the entity (a patch body, B-Rep face, construction plane or sketch curve) that intersects the trim tool
        """
        return core.Base()
    @trimTool.setter
    def trimTool(self, value: core.Base):
        """
        Gets and sets the entity (a patch body, B-Rep face, construction plane or sketch curve) that intersects the trim tool
        """
        pass
    @property
    def targetBaseFeature(self) -> BaseFeature:
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        return BaseFeature()
    @targetBaseFeature.setter
    def targetBaseFeature(self, value: BaseFeature):
        """
        When creating a feature that is owned by a base feature, set this property to the
        base feature you want to associate the new feature with. By default, this is null,
        meaning it will not be associated with a base feature.
        
        Because of a current limitation, if you want to create a feature associated with a base
        feature, you must set this property AND call the startEdit method of the base feature,
        create the feature, and then call the finishEdit method of the base feature. The base
        feature must be in an "edit" state to be able to add any additional items to it.
        """
        pass

class TrimFeatures(core.Base):
    """
    Collection that provides access to all of the existing trim features in a component
    and supports the ability to create new trim features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TrimFeatures:
        return TrimFeatures()
    def item(self, index: int) -> TrimFeature:
        """
        Function that returns the specified trim feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return TrimFeature()
    def createInput(self, trimTool: core.Base) -> TrimFeatureInput:
        """
        Creates a TrimFeatureInput object. Use properties and methods on this object
        to define the trim feature you want to create and then use the Add method, passing in
        the TrimFeatureInput object.
        
        To determine the possible boundaries and allow you to choose which cells to keep, the trim
        feature does a partial compute when the input object is created. To do this it starts a trim
        feature transaction and completes the transaction when you call the add method. If you don't call
        the add method to finish the transaction it leaves Fusion 360 in a bad state and there will be undo
        problems and possibly a crash. If you have created a TrimFeatureInput object and don't want to
        finish the feature creation, you need to call the cancel method on the TrimFeatureInput object to
        safely abort the current boundary fill transaction.
        trimTool : A patch body, B-Rep face, construction plane or sketch curve that intersects the surface or surfaces to be trimmed
        Returns the newly created TrimFeatureInput object or null if the creation failed.
        """
        return TrimFeatureInput()
    def add(self, input: TrimFeatureInput) -> TrimFeature:
        """
        Creates a new trim feature.
        input : A TrimFeatureInput object that defines the desired trim feature. Use the createInput
        method to create a new TrimFeatureInput object and then use methods on it
        (the TrimFeatureInput object) to define the trim feature.
        Returns the newly created TrimFeature object or null if the creation failed.
        """
        return TrimFeature()
    def itemByName(self, name: str) -> TrimFeature:
        """
        Function that returns the specified trim feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return TrimFeature()
    @property
    def count(self) -> int:
        """
        The number of trim features in the collection.
        """
        return int()

class TSplineBodies(core.Base):
    """
    A collection of TSpline bodies.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TSplineBodies:
        return TSplineBodies()
    def item(self, index: int) -> TSplineBody:
        """
        Function that returns the specified T-Spline body using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return TSplineBody()
    def itemByName(self, name: str) -> TSplineBody:
        """
        Returns a TSplineBody by specifying the name of the body as seen in the browser.
        name : The name of the body, as seen in the browser. This is case sensitive.
        Returns the specified item or null if a body with that name was not found.
        """
        return TSplineBody()
    def addByTSMFile(self, tsmFilename: str) -> TSplineBody:
        """
        Creates a new TSplineBody by reading in a TSM file from disk.
        tsmFilename : The full filename of the TSM file on disk.
        Returns the newly created TSplineBody if successful or null in the case of failure.
        """
        return TSplineBody()
    def addByTSMDescription(self, tsmDescription: str) -> TSplineBody:
        """
        Creates a new TSplineBody using the T-Spline description provided by the input
        string which contains TSM formatted text.
        tsmDescription : A string that contains a T-Spline description in TSM form.
        Returns the newly created TSplineBody if successful or null in the case of failure.
        """
        return TSplineBody()
    @property
    def count(self) -> int:
        """
        The number of bodies in the collection.
        """
        return int()

class TSplineBody(core.Base):
    """
    A TSpline body.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TSplineBody:
        return TSplineBody()
    def getTSMDescription(self) -> str:
        """
        Returns the T-Spline body as a string in the form of a TSM description.
        Returns the string formatted using the TSM format.
        """
        return str()
    def saveAsTSMFile(self, filename: str) -> bool:
        """
        Saves the body as a TSM file.
        filename : The full filename of the file to save the body to. If the file already exists,
        it will be overwritten.
        Returns true if the file was successfully created.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of the body. If setting this property, there is the side-effect
        that the B-Rep body created from this T-Spline body is also renamed.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of the body. If setting this property, there is the side-effect
        that the B-Rep body created from this T-Spline body is also renamed.
        """
        pass
    @property
    def parentFormFeature(self) -> FormFeature:
        """
        Returns the owning form feature.
        """
        return FormFeature()
    @property
    def entityToken(self) -> str:
        """
        Returns a token for the TSplineBody object. This can be saved and used at a later
        time with the Design.findEntityByToken method to get back the same T-Spline body.
        
        When using entity tokens it's important to understand that the token string returned for a
        specific entity can be different over time. However, even if you have two different token
        strings that were obtained from the same entity, when you use findEntityByToken they
        will both return the same entity. Because of that you should never compare entity tokens
        as way to determine what the token represents. Instead, you need to use the findEntityByToken
        method to get the two entities identified by the tokens and then compare them.
        """
        return str()

class UnfoldFeatures(core.Base):
    """
    Collection that provides access to all of the existing unfold features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> UnfoldFeatures:
        return UnfoldFeatures()
    def item(self, index: int) -> UnfoldFeature:
        """
        Function that returns the specified unfold feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return UnfoldFeature()
    def itemByName(self, name: str) -> UnfoldFeature:
        """
        Function that returns the specified unfold feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return UnfoldFeature()
    @property
    def count(self) -> int:
        """
        The number of unfold features in the collection.
        """
        return int()

class UnstitchFeatures(core.Base):
    """
    Collection that provides access to all of the existing Unstitch features in a component
    and supports the ability to create new Unstitch features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> UnstitchFeatures:
        return UnstitchFeatures()
    def item(self, index: int) -> UnstitchFeature:
        """
        Function that returns the specified Unstitch feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return UnstitchFeature()
    def add(self, faces: core.ObjectCollection, isChainSelection: bool) -> UnstitchFeature:
        """
        Creates a new Unstitch feature.
        faces : The faces and/or bodies to Unstitch. Individual faces can be unstitched from solid and/or patch bodies. The faces being unstitched
        need not all come from the same body.
        isChainSelection : A boolean value for setting whether or not faces that are connected and adjacent to
        the input faces will be included in the selection. The default value is true.
        Returns the newly created UnstitchFeature object or null if the creation failed.
        """
        return UnstitchFeature()
    def itemByName(self, name: str) -> UnstitchFeature:
        """
        Function that returns the specified unstitch feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return UnstitchFeature()
    @property
    def count(self) -> int:
        """
        The number of Unstitch features in the collection.
        """
        return int()

class UntrimFeatureInput(core.Base):
    """
    This class defines the methods and properties that pertain to the definition of a Untrim feature.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> UntrimFeatureInput:
        return UntrimFeatureInput()
    def setLoopsFromFaces(self, faces: list[BRepFace], untrimLoopType: UntrimLoopTypes) -> bool:
        """
        Set the loops to be removed from a set of faces.
        faces : An array of BRepFace objects that will have the loops of the specified types removed.
        Only loops that do not have a connected face can be removed (the edges in the loop have a single face).
        The array can only contain faces from surface bodies, (the isSolid property of the BRepBody returns false).
        untrimLoopType : The loop type to be untrimmed (AllLoopUntrimType, InternalLoopUntrimType, or ExternalLoopUntrimType).
        Returns whether the operation was successful
        """
        return bool()
    def setLoops(self, loops: list[BRepLoop]) -> bool:
        """
        Set the loops to be removed.
        loops : Redefines this input to remove loops from the body. If faces were previously defined, that information will be lost.
        Only loops that do not have a connected face can be removed (the edges in the loop have a single face)
        The array can only contain loops from surface bodies, (the isSolid property of the BRepBody returns false).
        Returns whether the operation was successful
        """
        return bool()
    @property
    def untrimLoopType(self) -> UntrimLoopTypes:
        """
        Gets the loop type to be untrimmed. This is only used when faces are being untrimmed and is ignored for loops.
        """
        return UntrimLoopTypes()
    @property
    def facesToUntrim(self) -> list[BRepFace]:
        """
        Gets the face objects to untrim.
        Returns null/None in the case where loops are specified instead of faces.
        """
        return [BRepFace()]
    @property
    def loopsToUntrim(self) -> list[BRepLoop]:
        """
        Gets the loop objects to untrim.
        Returns null/None in the case where faces are specified instead of loops
        """
        return [BRepLoop()]
    @property
    def extensionDistance(self) -> core.ValueInput:
        """
        Gets and sets the ValueInput object that defines the extension distance applied to faces when an
        external boundary is removed.
        """
        return core.ValueInput()
    @extensionDistance.setter
    def extensionDistance(self, value: core.ValueInput):
        """
        Gets and sets the ValueInput object that defines the extension distance applied to faces when an
        external boundary is removed.
        """
        pass

class UntrimFeatures(core.Base):
    """
    Collection that provides access to all of the existing Untrim features in a component
    and supports the ability to create new Untrim features.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> UntrimFeatures:
        return UntrimFeatures()
    def item(self, index: int) -> UntrimFeature:
        """
        Function that returns the specified Untrim feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return UntrimFeature()
    def createInputFromFaces(self, faces: list[BRepFace], untrimLoopType: UntrimLoopTypes, extensionDistance: core.ValueInput) -> UntrimFeatureInput:
        """
        Creates a UntrimFeatureInput object that defines the input needed to create a untrim feature. Use the input
        object to define the input to create the desired feature and then use the Add method, passing in the UntrimFeatureInput object.
        faces : An array of BRepFace objects that will have the loops of the specified type removed.
        Only loops that do not have a connected face can be removed (the edges in the loop have a single face).
        The array can only contain faces from surface bodies, (the isSolid property of the BRepBody returns false).
        untrimLoopType : The loop type to be untrimmed (AllLoopUntrimType, InternalLoopUntrimType, or ExternalLoopUntrimType).
        extensionDistance : If the untrim loop type is AllLoopUntrimType or ExternalLoopUntrimType the untrimmed faces can be extended by a specified distance.
        Returns the newly created UntrimFeatureInput object or null if the creation failed.
        """
        return UntrimFeatureInput()
    def createInputFromLoops(self, loops: list[BRepLoop], extensionDistance: core.ValueInput) -> UntrimFeatureInput:
        """
        Creates a UntrimFeatureInput object that defines the input needed to create a untrim feature. Use the input
        object to define the input to create the desired feature and then use the Add method, passing in the UntrimFeatureInput object.
        loops : Input the entities that define loops to remove.
        Only loops that do not have a connected face can be removed (the edges in the loop have a single face)
        The array can only contain loops from surface bodies, (the isSolid property of the BRepBody returns false).
        extensionDistance : If an external boundary is removed the untrimmed face can be extended by a specified distance.
        Returns the newly created UntrimFeatureInput object or null if the creation failed.
        """
        return UntrimFeatureInput()
    def add(self, input: UntrimFeatureInput) -> UntrimFeature:
        """
        Creates a new Untrim feature.
        input : An UntrimFeatureInput object that defines the desired Untrim feature. Use the createInput
        method to create a new UntrimFeatureInput object and then use methods on it
        (the UntrimFeatureInput object) to define the desired options for the Untrim feature.
        Returns the newly created UntrimFeature object or null if the creation failed.
        """
        return UntrimFeature()
    def itemByName(self, name: str) -> UntrimFeature:
        """
        Function that returns the specified Untrim feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return UntrimFeature()
    @property
    def count(self) -> int:
        """
        The number of Untrim features in the collection.
        """
        return int()

class UserParameters(core.Base):
    """
    Provides access to the User Parameters within a design and provides
    methods to create new user parameters.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> UserParameters:
        return UserParameters()
    def item(self, index: int) -> UserParameter:
        """
        Function that returns the specified User Parameter using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection
        has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return UserParameter()
    def itemByName(self, name: str) -> UserParameter:
        """
        Function that returns the specified User Parameter using the name of the parameter
        as it is displayed in the parameters dialog.
        name : The name of the User Parameter as it is displayed in the parameters dialog
        Returns the specified item or null if an invalid name was specified.
        """
        return UserParameter()
    def add(self, name: str, value: core.ValueInput, units: str, comment: str) -> UserParameter:
        """
        Adds a new user parameter to the collection.
        name : The name of the parameter. This is the name shown in the parameters dialog
        value : ValueInput object that specifies the value of the parameter. If the ValueInput was created using a real,
        the value will be interpreted using the internal unit for the unit type specified by the "units" argument.
        For example, if the ValueInput was created using the real value 5 and the input to the "units" argument is
        any valid length unit, the value will be interpreted as 5 centimeters since centimeters is the internal unit
        for lengths. If the "units" argument is a valid angle unit the value will be interpreted as 5 radians.
        
        If the ValueInput was created using a string, the string is used as-is for the expression of the parameter.
        This means if there are units as part of the string it must evaluate to the same unit type as that specified
        by the "units" argument and if no units are specified it will use the current default units specified for
        the current document. For example, if the ValueInput was created with the string "5 in", then the "units"
        argument must define any valid length so they are compatible. If the ValueInput was created with the string "5",
        any unit type can be used and the result will be 5 of that unit.
        
        When using a ValueInput created using a string, it's the same as creating a parameter in the user-interface.
        You can specify any valid expression, i.e. "5", "5 in", "5 in / 2", "5 + Length", etc. and you can choose
        from many different types of units. The only requirement is that the units must match in type. For example,
        they must both be lengths, or they must both be angles.
        units : The units to use for the value of the parameter.
        Units specified must match the units specified (if any) in the ValueInput object.
        
        To create a parameter with no units you can specify either an empty string.
        comment : The comment to display in the parameters dialog. Specify an empty string ("") for no comment
        Returns the newly created UserParameter or null if the creation failed.
        """
        return UserParameter()
    @property
    def count(self) -> int:
        """
        Returns the number of parameters in the collection.
        """
        return int()
    @property
    def design(self) -> Design:
        """
        Returns the design that owns the user parameters collection.
        """
        return Design()

class WebFeatures(core.Base):
    """
    Collection that provides access to all of the existing web features in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> WebFeatures:
        return WebFeatures()
    def item(self, index: int) -> WebFeature:
        """
        Function that returns the specified web feature using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return WebFeature()
    def itemByName(self, name: str) -> WebFeature:
        """
        Function that returns the specified web feature using the name of the feature.
        name : The name of the feature within the collection to return. This is the name seen in the timeline.
        Returns the specified item or null if the specified name was not found.
        """
        return WebFeature()
    @property
    def count(self) -> int:
        """
        The number of web features in the collection.
        """
        return int()

class AllExtentDefinition(ExtentDefinition):
    """
    Defines the inputs for a AllExtentDefinition object.
    This defines a feature extent where the direction can be positive, negative, or symmetric.
    Setting the direction to Symmetric specifies that the extrusion is through-all,
    and goes in both directions.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AllExtentDefinition:
        return AllExtentDefinition()
    @property
    def direction(self) -> ExtentDirections:
        """
        Gets and sets the direction of the extent.
        """
        return ExtentDirections()
    @direction.setter
    def direction(self, value: ExtentDirections):
        """
        Gets and sets the direction of the extent.
        """
        pass

class AlongPathTextDefinition(SketchTextDefinition):
    """
    Defines the information for text that follows along a path.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AlongPathTextDefinition:
        return AlongPathTextDefinition()
    @property
    def path(self) -> core.Base:
        """
        Get and sets the entity that defines the path for the text. This can be a SketchCurve or BRepEdge object.
        """
        return core.Base()
    @path.setter
    def path(self, value: core.Base):
        """
        Get and sets the entity that defines the path for the text. This can be a SketchCurve or BRepEdge object.
        """
        pass
    @property
    def isAbovePath(self) -> bool:
        """
        Gets and sets if the text should be positioned above or below the path entity.
        """
        return bool()
    @isAbovePath.setter
    def isAbovePath(self, value: bool):
        """
        Gets and sets if the text should be positioned above or below the path entity.
        """
        pass
    @property
    def horizontalAlignment(self) -> core.HorizontalAlignments:
        """
        Gets and sets the horizontal alignment of the text with respect to the path curve.
        """
        return core.HorizontalAlignments()
    @horizontalAlignment.setter
    def horizontalAlignment(self, value: core.HorizontalAlignments):
        """
        Gets and sets the horizontal alignment of the text with respect to the path curve.
        """
        pass
    @property
    def characterSpacing(self) -> float:
        """
        Gets and sets the spacing between the characters. This is an additional spacing to apply
        that is defined as a percentage of the default spacing. A spacing of 0 indicates no
        additional spacing. A spacing of 50 indicates to use the default plus 50% of the default.
        """
        return float()
    @characterSpacing.setter
    def characterSpacing(self, value: float):
        """
        Gets and sets the spacing between the characters. This is an additional spacing to apply
        that is defined as a percentage of the default spacing. A spacing of 0 indicates no
        additional spacing. A spacing of 50 indicates to use the default plus 50% of the default.
        """
        pass

class AngleExtentDefinition(ExtentDefinition):
    """
    Defines the inputs for a AngleExtentDefinition object.
    This feature extent is defined by an angle as well as whether the extent is symmetric or only in one direction.
    If the extent is not symmetric, a positive or negative angle can be used to control the direction.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AngleExtentDefinition:
        return AngleExtentDefinition()
    @property
    def isSymmetric(self) -> bool:
        """
        Gets and sets if the angle extent is in one direction or symmetric.
        For a hole this property will always return false and setting it is ignored.
        """
        return bool()
    @isSymmetric.setter
    def isSymmetric(self, value: bool):
        """
        Gets and sets if the angle extent is in one direction or symmetric.
        For a hole this property will always return false and setting it is ignored.
        """
        pass
    @property
    def angle(self) -> ModelParameter:
        """
        Gets the ModelParameter that defines the angle. The value of the angle can be edited
        by using the properties on the ModelParameter object to edit the parameter.
        """
        return ModelParameter()

class AtCenterHolePositionDefinition(HolePositionDefinition):
    """
    Provides positioning information for a hole that is positioned at the center of a
    circular or elliptical edge.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AtCenterHolePositionDefinition:
        return AtCenterHolePositionDefinition()
    @property
    def planarEntity(self) -> core.Base:
        """
        Returns the plane that defines the orientation and start of the hole.
        """
        return core.Base()
    @property
    def centerEdge(self) -> BRepEdge:
        """
        Returns the circular or elliptical edge the hole is centered at.
        """
        return BRepEdge()

class BallJointMotion(JointMotion):
    """
    Represents the set of information specific to a ball joint.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BallJointMotion:
        return BallJointMotion()
    @property
    def pitchDirection(self) -> JointDirections:
        """
        Gets and sets the direction that the pitch is measured from.
        This can only be set to ZAxisJointDirection and can return ZAxisJointDirection
        or CustomJointDirection. If this returns CustomJointDirection then the
        customNormalDirectionEntity will return an entity that defines the direction.
        If there is a custom direction defined and this property is set to ZAxisJointDirection,
        the custom direction will be removed and customNormalDirectionEntity will return null.
        """
        return JointDirections()
    @pitchDirection.setter
    def pitchDirection(self, value: JointDirections):
        """
        Gets and sets the direction that the pitch is measured from.
        This can only be set to ZAxisJointDirection and can return ZAxisJointDirection
        or CustomJointDirection. If this returns CustomJointDirection then the
        customNormalDirectionEntity will return an entity that defines the direction.
        If there is a custom direction defined and this property is set to ZAxisJointDirection,
        the custom direction will be removed and customNormalDirectionEntity will return null.
        """
        pass
    @property
    def customPitchDirectionEntity(self) -> core.Base:
        """
        This property defines a custom pitch direction and can be set using various types
        of entities that can infer a direction. For example, a linear edge, sketch line,
        planar face, and cylindrical face.This property is only valid in the case where the
        pitchDirection property returns CustomJointDirection. Setting this property will
        automatically set the pitchDirection property to CustomJointDirection.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        """
        return core.Base()
    @customPitchDirectionEntity.setter
    def customPitchDirectionEntity(self, value: core.Base):
        """
        This property defines a custom pitch direction and can be set using various types
        of entities that can infer a direction. For example, a linear edge, sketch line,
        planar face, and cylindrical face.This property is only valid in the case where the
        pitchDirection property returns CustomJointDirection. Setting this property will
        automatically set the pitchDirection property to CustomJointDirection.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        """
        pass
    @property
    def pitchDirectionVector(self) -> core.Vector3D:
        """
        Returns the direction that the pitch angle is measured from. This property will return null in the case
        where the BallJointMotion object was obtained from a JointInput object.
        """
        return core.Vector3D()
    @property
    def yawDirection(self) -> JointDirections:
        """
        Gets and sets the direction that the pitch is measured from.
        This can only be set to XAxisJointDirection and can return XAxisJointDirection
        or CustomJointDirection. If this returns CustomJointDirection then the
        customYawDirectionEntity will return an entity that defines the direction.
        If there is a custom direction defined and this property is set to XAxisJointDirection,
        the custom direction will be removed and customYawDirectionEntity will return null.
        """
        return JointDirections()
    @yawDirection.setter
    def yawDirection(self, value: JointDirections):
        """
        Gets and sets the direction that the pitch is measured from.
        This can only be set to XAxisJointDirection and can return XAxisJointDirection
        or CustomJointDirection. If this returns CustomJointDirection then the
        customYawDirectionEntity will return an entity that defines the direction.
        If there is a custom direction defined and this property is set to XAxisJointDirection,
        the custom direction will be removed and customYawDirectionEntity will return null.
        """
        pass
    @property
    def customYawDirectionEntity(self) -> core.Base:
        """
        This property defines a custom yaw direction and can be set using various types
        of entities that can infer a direction. For example, a linear edge, sketch line,
        planar face, and cylindrical face.This property is only valid in the case where the
        yawDirection property returns CustomJointDirection. Setting this property will
        automatically set the yawDirection property to CustomJointDirection.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        """
        return core.Base()
    @customYawDirectionEntity.setter
    def customYawDirectionEntity(self, value: core.Base):
        """
        This property defines a custom yaw direction and can be set using various types
        of entities that can infer a direction. For example, a linear edge, sketch line,
        planar face, and cylindrical face.This property is only valid in the case where the
        yawDirection property returns CustomJointDirection. Setting this property will
        automatically set the yawDirection property to CustomJointDirection.
        
        To set this property, you need to position the timeline marker to immediately before this joint.
        This can be accomplished using the following code: thisJoint.timelineObject.rollTo(True)
        """
        pass
    @property
    def yawDirectionVector(self) -> core.Vector3D:
        """
        Returns the direction that the yaw angle is measured from. This property will return null in the case
        where the BallJointMotion object was obtained from a JointInput object.
        """
        return core.Vector3D()
    @property
    def rollDirectionVector(self) -> core.Vector3D:
        """
        Returns the direction that the roll angle is measured from. This property will return null in the case
        where the BallJointMotion object was obtained from a JointInput object.
        """
        return core.Vector3D()
    @property
    def pitchValue(self) -> float:
        """
        Gets and sets the pitch value. This is in radians. Setting this value is
        the equivalent of using the Drive Joints command.
        """
        return float()
    @pitchValue.setter
    def pitchValue(self, value: float):
        """
        Gets and sets the pitch value. This is in radians. Setting this value is
        the equivalent of using the Drive Joints command.
        """
        pass
    @property
    def pitchLimits(self) -> JointLimits:
        """
        Returns a JointLimits object that defines the limits of rotation for the pitch.
        Use the functionality of the returned JointLimits object to get, set, and modify
        the joint limits.
        """
        return JointLimits()
    @property
    def yawValue(self) -> float:
        """
        Gets and sets the yaw value. This is in radians. Setting this value is
        the equivalent of using the Drive Joints command.
        """
        return float()
    @yawValue.setter
    def yawValue(self, value: float):
        """
        Gets and sets the yaw value. This is in radians. Setting this value is
        the equivalent of using the Drive Joints command.
        """
        pass
    @property
    def yawLimits(self) -> JointLimits:
        """
        Returns a JointLimits object that defines the limits of rotation for the yaw.
        Use the functionality of the returned JointLimits object to get, set, and modify
        the joint limits.
        """
        return JointLimits()
    @property
    def rollValue(self) -> float:
        """
        Gets and sets the roll value. This is in radians. Setting this value is
        the equivalent of using the Drive Joints command.
        """
        return float()
    @rollValue.setter
    def rollValue(self, value: float):
        """
        Gets and sets the roll value. This is in radians. Setting this value is
        the equivalent of using the Drive Joints command.
        """
        pass
    @property
    def rollLimits(self) -> JointLimits:
        """
        Returns a JointLimits object that defines the limits of rotation for the roll.
        Use the functionality of the returned JointLimits object to get, set, and modify
        the joint limits.
        """
        return JointLimits()

class BaseFeature(Feature):
    """
    The BaseFeature class represents a direct edit feature within a parametric design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BaseFeature:
        return BaseFeature()
    def startEdit(self) -> bool:
        """
        Set the user-interface so that the base body is in edit mode.
        Returns true if successful.
        """
        return bool()
    def finishEdit(self) -> bool:
        """
        Exits from edit mode in the user-interface. If this base feature in not
        in edit mode, then nothing happens.
        Returns true if successful.
        """
        return bool()
    def updateBody(self, sourceBody: BRepBody, newBody: BRepBody) -> bool:
        """
        Update an existing source BRepBody created by this BaseFeature.
        The input BRepBody definition will be copied into the existing BRepBody.
        sourceBody : The source BRepBody to update. The source bodies of a BaseFeature are only available
        from the bodies collection of the BaseFeature when the BaseFeature is in edit mode.
        newBody : The BRepBody whose definition will be used to replace the existing source body's definition.
        Returns true if the body was updated, or false if the update failed.
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> BaseFeature:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this is not the NativeObject.
        """
        return BaseFeature()
    @property
    def constructionPlanes(self) -> list[ConstructionPlane]:
        """
        Returns an array of the construction planes associated with this base feature.
        """
        return [ConstructionPlane()]
    @property
    def constructionAxes(self) -> list[ConstructionAxis]:
        """
        Returns an array of the construction axes associated with this base feature.
        """
        return [ConstructionAxis()]
    @property
    def constructionPoints(self) -> list[ConstructionPoint]:
        """
        Returns an array of the construction points associated with this base feature.
        """
        return [ConstructionPoint()]
    @property
    def sketches(self) -> list[Sketch]:
        """
        Returns an array of the sketches associated with this base feature.
        """
        return [Sketch()]
    @property
    def meshBodies(self) -> list[MeshBody]:
        """
        Returns an array of the mesh bodies associated with this base feature.
        """
        return [MeshBody()]
    @property
    def nativeObject(self) -> BaseFeature:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return BaseFeature()

class BoundaryFillFeature(Feature):
    """
    Object that represents an existing boundary fill feature in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BoundaryFillFeature:
        return BoundaryFillFeature()
    def createForAssemblyContext(self, occurrence: Occurrence) -> BoundaryFillFeature:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return BoundaryFillFeature()
    def applyCellChanges(self) -> bool:
        """
        After making any changes to the set of selected cells you must call this method to
        indicate all changes have been made and to apply those changes to the feature.
        Returns true if the apply was successful.
        """
        return bool()
    @property
    def tools(self) -> core.ObjectCollection:
        """
        A collection of construction planes and open or closed BRepBody objects that define the
        set of boundaries that have been used in the calculation of available closed boundaries.
        Setting this property will clear all currently selected tools.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return core.ObjectCollection()
    @tools.setter
    def tools(self, value: core.ObjectCollection):
        """
        A collection of construction planes and open or closed BRepBody objects that define the
        set of boundaries that have been used in the calculation of available closed boundaries.
        Setting this property will clear all currently selected tools.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def bRepCells(self) -> BRepCells:
        """
        Gets the set of closed boundaries that have been calculated based on the current set of
        tools. To get this collection the model must be in the state it was when the feature
        was initially computed, which means the timeline marker must be positioned to immediately
        before this feature.
        
        After changing any selected cells you must call the applyCellChanges method to update
        the feature with the changes.
        """
        return BRepCells()
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the type of operation performed by the boundary fill feature.
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the type of operation performed by the boundary fill feature.
        """
        pass
    @property
    def nativeObject(self) -> BoundaryFillFeature:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return BoundaryFillFeature()

class BoxFeature(Feature):
    """
    Object that represents an existing box feature in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BoxFeature:
        return BoxFeature()

class C3MFExportOptions(ExportOptions):
    """
    Defines that a 3MF export is to be done and specifies the various options.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> C3MFExportOptions:
        return C3MFExportOptions()
    @property
    def isOneFilePerBody(self) -> bool:
        """
        If the input is an Occurrence or the root Component, this specifies if a single file should be created containing
        all of the bodies within that occurrence or component or if multiple files should be created; one for each body.
        If multiple files are created, the body name is appended to the filename.  The default is false.
        """
        return bool()
    @isOneFilePerBody.setter
    def isOneFilePerBody(self, value: bool):
        """
        If the input is an Occurrence or the root Component, this specifies if a single file should be created containing
        all of the bodies within that occurrence or component or if multiple files should be created; one for each body.
        If multiple files are created, the body name is appended to the filename.  The default is false.
        """
        pass
    @property
    def meshRefinement(self) -> MeshRefinementSettings:
        """
        Gets and sets the current simple mesh refinement settings.  Setting this property
        will reset the surfaceDeviation, normalDeviation, maximumEdgeLength, and aspectRatio
        to values that correspond to the specified mesh refinement.  The default is MeshRefinementMedium
        """
        return MeshRefinementSettings()
    @meshRefinement.setter
    def meshRefinement(self, value: MeshRefinementSettings):
        """
        Gets and sets the current simple mesh refinement settings.  Setting this property
        will reset the surfaceDeviation, normalDeviation, maximumEdgeLength, and aspectRatio
        to values that correspond to the specified mesh refinement.  The default is MeshRefinementMedium
        """
        pass
    @property
    def surfaceDeviation(self) -> float:
        """
        Gets and sets the current surface deviation, or the distance the mesh can deviate
        from the actual surface.  This is defined in centimeter.  Setting this property
        will automatically set the meshRefinement to MeshRefinementCustom.  The default is the value
        associated with medium mesh refinement.
        """
        return float()
    @surfaceDeviation.setter
    def surfaceDeviation(self, value: float):
        """
        Gets and sets the current surface deviation, or the distance the mesh can deviate
        from the actual surface.  This is defined in centimeter.  Setting this property
        will automatically set the meshRefinement to MeshRefinementCustom.  The default is the value
        associated with medium mesh refinement.
        """
        pass
    @property
    def normalDeviation(self) -> float:
        """
        Gets and sets the current normal deviation, or the angle the mesh normals at the vertices can deviate
        from the actual surface normals.  This is defined in radians.  Setting this property
        will automatically set the meshRefinement to MeshRefinementCustom.  The default is the value
        associated with medium mesh refinement.
        """
        return float()
    @normalDeviation.setter
    def normalDeviation(self, value: float):
        """
        Gets and sets the current normal deviation, or the angle the mesh normals at the vertices can deviate
        from the actual surface normals.  This is defined in radians.  Setting this property
        will automatically set the meshRefinement to MeshRefinementCustom.  The default is the value
        associated with medium mesh refinement.
        """
        pass
    @property
    def maximumEdgeLength(self) -> float:
        """
        Gets and sets the maximum length of any mesh edge.  This is defined in centimeter.  Setting this property
        will automatically set the meshRefinement to MeshRefinementCustom.  The default is the value
        associated with medium mesh refinement.
        """
        return float()
    @maximumEdgeLength.setter
    def maximumEdgeLength(self, value: float):
        """
        Gets and sets the maximum length of any mesh edge.  This is defined in centimeter.  Setting this property
        will automatically set the meshRefinement to MeshRefinementCustom.  The default is the value
        associated with medium mesh refinement.
        """
        pass
    @property
    def aspectRatio(self) -> float:
        """
        Gets and sets the minimum aspect ratio for that triangles that are generated for the mesh.  Setting this property
        will automatically set the meshRefinement to MeshRefinementCustom.  The default is the value
        associated with medium mesh refinement.
        """
        return float()
    @aspectRatio.setter
    def aspectRatio(self, value: float):
        """
        Gets and sets the minimum aspect ratio for that triangles that are generated for the mesh.  Setting this property
        will automatically set the meshRefinement to MeshRefinementCustom.  The default is the value
        associated with medium mesh refinement.
        """
        pass
    @property
    def availablePrintUtilities(self) -> list[str]:
        """
        Returns a list of the known available print utilities.  These strings can be used to set the PrintUtility
        property to specify which print utility to open the 3MF file in.
        """
        return [str()]
    @property
    def printUtility(self) -> str:
        """
        Specifies which print utility to use when opening the 3MF file if the sendToPrintUtility property is true.
        The value of this property can be one of the strings returned by the availalbePrintUtilities property, which
        will specify one of the know print utilities. You can also specify a custom print utility by specifying
        the full path to the print utility executable. The default value of this property is the last setting specified
        in the user-interface.
        """
        return str()
    @printUtility.setter
    def printUtility(self, value: str):
        """
        Specifies which print utility to use when opening the 3MF file if the sendToPrintUtility property is true.
        The value of this property can be one of the strings returned by the availalbePrintUtilities property, which
        will specify one of the know print utilities. You can also specify a custom print utility by specifying
        the full path to the print utility executable. The default value of this property is the last setting specified
        in the user-interface.
        """
        pass
    @property
    def sendToPrintUtility(self) -> bool:
        """
        Gets and sets whether the created 3MF file will be sent to the print utility specified by the printUtility property.  If this
        is false a filename must be defined.
        """
        return bool()
    @sendToPrintUtility.setter
    def sendToPrintUtility(self, value: bool):
        """
        Gets and sets whether the created 3MF file will be sent to the print utility specified by the printUtility property.  If this
        is false a filename must be defined.
        """
        pass

class ChamferFeature(Feature):
    """
    Object that represents an existing chamfer feature in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ChamferFeature:
        return ChamferFeature()
    def setEqualDistance(self, distance: core.ValueInput) -> bool:
        """
        Changes the type of chamfer to be an equal distance chamfer.
        distance : A ValueInput object that defines the distance of the chamfer. If the ValueInput uses
        a real then it is interpreted as centimeters. If it is a string then the units
        can be defined as part of the string (i.e. "2 in"). If no units are specified
        it is interpreted using the current default units for length.
        Returns true if the feature is successfully changed
        """
        return bool()
    def setTwoDistances(self, distanceOne: core.ValueInput, distanceTwo: core.ValueInput) -> bool:
        """
        Changes the type of chamfer to be a two distances chamfer.
        distanceOne : A ValueInput object that defines the distanceOne of the chamfer. This distance
        is along the face which is on the left of the selected edge.
        If the ValueInput uses a real then it is interpreted as centimeters.
        If it is a string then the units can be defined as part of the string (i.e. "2 in").
        If no units are specified it is interpreted using the current default units for length.
        distanceTwo : A ValueInput object that defines the distanceTwo of the chamfer. This distance
        is along the face which is on the right of the selected edge.
        If the ValueInput uses a real then it is interpreted as centimeters.
        If it is a string then the units can be defined as part of the string (i.e. "2 in").
        If no units are specified it is interpreted using the current default units for length.
        Returns true if the feature is successfully changed
        """
        return bool()
    def setDistanceAndAngle(self, distance: core.ValueInput, angle: core.ValueInput) -> bool:
        """
        Changes the type of chamfer to be a distance and angle chamfer.
        distance : A ValueInput object that defines the distance of the chamfer. This distance
        is along the face which is on the right of the selected edge.
        If the ValueInput uses a real then it is interpreted as centimeters.
        If it is a string then the units can be defined as part of the string (i.e. "2 in").
        If no units are specified it is interpreted using the current default units for length.
        angle : A valueInput object that defines the angle. The direction will be towards to the face
        which is on the left of the selected edge. This can be a string or a value.
        If it's a string it is interpreted using the current document units and can include
        equations. For example all of the following are valid as long as they result in
        angle units; "45", "45 deg", "a1 / 2". If a value is input it is interpreted
        as radians.
        It cannot be negative.
        Returns true if the feature is successfully changed
        """
        return bool()
    def createForAssemblyContext(self, occurrence: Occurrence) -> ChamferFeature:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return ChamferFeature()
    @property
    def edges(self) -> core.ObjectCollection:
        """
        Gets and sets the edges being chamfered. Specific edges can be defined using one or more BRepEdge
        objects or BRepFace objects can be used to chamfer all edges of the face or Feature objects can
        be used to chamfer all edges associated with the input features. If BRepEdge objects are provided
        and the isTangentChain argument is true additional edges may also get chamfered if they are
        tangentially connected to any of the input edges. When getting the property, your
        code should check for the different types in the returned collection and handle it appropriately.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        
        This property returns nothing in the case where the feature is non-parametric.
        """
        return core.ObjectCollection()
    @edges.setter
    def edges(self, value: core.ObjectCollection):
        """
        Gets and sets the edges being chamfered. Specific edges can be defined using one or more BRepEdge
        objects or BRepFace objects can be used to chamfer all edges of the face or Feature objects can
        be used to chamfer all edges associated with the input features. If BRepEdge objects are provided
        and the isTangentChain argument is true additional edges may also get chamfered if they are
        tangentially connected to any of the input edges. When getting the property, your
        code should check for the different types in the returned collection and handle it appropriately.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        
        This property returns nothing in the case where the feature is non-parametric.
        """
        pass
    @property
    def isTangentChain(self) -> bool:
        """
        Gets and sets whether or not edges that are tangentially connected to
        the input edges (if any) will also be chamfered.
        """
        return bool()
    @isTangentChain.setter
    def isTangentChain(self, value: bool):
        """
        Gets and sets whether or not edges that are tangentially connected to
        the input edges (if any) will also be chamfered.
        """
        pass
    @property
    def chamferType(self) -> ChamferTypes:
        """
        Gets an enum indicating how the chamfer was defined. The valid return values are
        EqualDistanceType, TwoDistancesType and DistanceAndAngleType.
        This property returns nothing in the case where the feature is non-parametric.
        """
        return ChamferTypes()
    @property
    def chamferTypeDefinition(self) -> ChamferTypeDefinition:
        """
        Gets the definition object that is defining the type of chamfer. Modifying the
        definition object will cause the chamfer to recompute. Various types of definition objects can
        be returned depending on how the chamfer is defined. The ChamferType property can
        be used to determine which type of definition will be returned.
        This property returns nothing in the case where the feature is non-parametric.
        """
        return ChamferTypeDefinition()
    @property
    def nativeObject(self) -> ChamferFeature:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return ChamferFeature()
    @property
    def cornerType(self) -> ChamferCornerTypes:
        """
        Gets and sets the type of corner to be modeled when multiple edges connect at a vertex.
        """
        return ChamferCornerTypes()
    @cornerType.setter
    def cornerType(self, value: ChamferCornerTypes):
        """
        Gets and sets the type of corner to be modeled when multiple edges connect at a vertex.
        """
        pass
    @property
    def edgeSets(self) -> ChamferEdgeSets:
        """
        Returns the edge sets associated with this chamfer.
        """
        return ChamferEdgeSets()

class ChordLengthFilletEdgeSet(FilletEdgeSet):
    """
    Provides access to the edges and the parameter associated with a chord length fillet.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ChordLengthFilletEdgeSet:
        return ChordLengthFilletEdgeSet()
    @property
    def edges(self) -> core.ObjectCollection:
        """
        Gets and sets the edges that will be filleted.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return core.ObjectCollection()
    @edges.setter
    def edges(self, value: core.ObjectCollection):
        """
        Gets and sets the edges that will be filleted.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def chordLength(self) -> ModelParameter:
        """
        Returns the model parameter that controls the chord length of the fillet. You can edit
        the chord length by using the properties on the returned ModelParameter object.
        """
        return ModelParameter()

class CircularPatternConstraint(GeometricConstraint):
    """
    A circular pattern constraint in a sketch.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CircularPatternConstraint:
        return CircularPatternConstraint()

class CircularPatternFeature(Feature):
    """
    Object that represents an existing circular pattern feature in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CircularPatternFeature:
        return CircularPatternFeature()
    def createForAssemblyContext(self, occurrence: Occurrence) -> CircularPatternFeature:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return CircularPatternFeature()
    @property
    def inputEntities(self) -> core.ObjectCollection:
        """
        Gets and sets the input entities. The collection can contain faces, features, bodies or occurrences.
        All of the entities must be of a single type. For example, it can't contain features and occurrences
        but only features or occurrences.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return core.ObjectCollection()
    @inputEntities.setter
    def inputEntities(self, value: core.ObjectCollection):
        """
        Gets and sets the input entities. The collection can contain faces, features, bodies or occurrences.
        All of the entities must be of a single type. For example, it can't contain features and occurrences
        but only features or occurrences.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def axis(self) -> core.Base:
        """
        Gets and sets the axis of circular pattern. This can be a sketch line, linear edge,
        construction axis, an edge/sketch curve that defines an axis (circle, etc.) or a face that defines an axis (cylinder, cone, torus, etc.).
        
        To set this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return core.Base()
    @axis.setter
    def axis(self, value: core.Base):
        """
        Gets and sets the axis of circular pattern. This can be a sketch line, linear edge,
        construction axis, an edge/sketch curve that defines an axis (circle, etc.) or a face that defines an axis (cylinder, cone, torus, etc.).
        
        To set this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def totalAngle(self) -> ModelParameter:
        """
        Returns the parameter controlling the total angle.
        To edit the angle use properties on the parameter to edit its value.
        This property returns null in the case where the feature is non-parametric.
        A negative value can be used to change the direction of the pattern.
        """
        return ModelParameter()
    @property
    def isSymmetric(self) -> bool:
        """
        Gets and sets if the angle extent is in one direction or symmetric.
        
        To set this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return bool()
    @isSymmetric.setter
    def isSymmetric(self, value: bool):
        """
        Gets and sets if the angle extent is in one direction or symmetric.
        
        To set this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def quantity(self) -> ModelParameter:
        """
        Returns the parameter controlling the number of pattern elements, including any suppressed elements.
        To edit the quantity use properties on the parameter to edit its value.
        This property returns null in the case where the feature is non-parametric.
        """
        return ModelParameter()
    @property
    def suppressedElementsIds(self) -> list[int]:
        """
        Gets and sets the id's of the elements to suppress.
        
        To set this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return [int()]
    @suppressedElementsIds.setter
    def suppressedElementsIds(self, value: list[int]):
        """
        Gets and sets the id's of the elements to suppress.
        
        To set this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def patternElements(self) -> PatternElements:
        """
        Gets the PatternElements collection that contains the elements created by this pattern.
        """
        return PatternElements()
    @property
    def resultFeatures(self) -> core.ObjectCollection:
        """
        Returns the features that were created as a result of this pattern.
        This is only valid for a direct edit model and this returns null
        in the case where the feature is parametric.
        """
        return core.ObjectCollection()
    @property
    def nativeObject(self) -> CircularPatternFeature:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return CircularPatternFeature()
    @property
    def patternEntityType(self) -> PatternEntityTypes:
        """
        Returns the type of entities the pattern consists of. This can be used to help
        determine the type of results that will be found in the pattern elements.
        """
        return PatternEntityTypes()
    @property
    def patternComputeOption(self) -> PatternComputeOptions:
        """
        Gets and sets the compute option for this pattern feature.
        This property only applies when patterning features and is ignored in the direct modeling environment.
        
        To set this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return PatternComputeOptions()
    @patternComputeOption.setter
    def patternComputeOption(self, value: PatternComputeOptions):
        """
        Gets and sets the compute option for this pattern feature.
        This property only applies when patterning features and is ignored in the direct modeling environment.
        
        To set this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass

class CoilFeature(Feature):
    """
    Object that represents an existing coil primitive feature in a design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CoilFeature:
        return CoilFeature()

class CoincidentConstraint(GeometricConstraint):
    """
    A coincident constraint in a sketch.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CoincidentConstraint:
        return CoincidentConstraint()
    def createForAssemblyContext(self, occurrence: Occurrence) -> CoincidentConstraint:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return CoincidentConstraint()
    @property
    def point(self) -> SketchPoint:
        """
        Returns the sketch point that is constrained.
        """
        return SketchPoint()
    @property
    def entity(self) -> SketchEntity:
        """
        The sketch curve or point the point is constrained to.
        """
        return SketchEntity()
    @property
    def nativeObject(self) -> CoincidentConstraint:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return CoincidentConstraint()

class CollinearConstraint(GeometricConstraint):
    """
    A collinear constraint in a sketch.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CollinearConstraint:
        return CollinearConstraint()
    def createForAssemblyContext(self, occurrence: Occurrence) -> CollinearConstraint:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return CollinearConstraint()
    @property
    def lineOne(self) -> SketchLine:
        """
        Returns the first line.
        """
        return SketchLine()
    @property
    def lineTwo(self) -> SketchLine:
        """
        Returns the second line.
        """
        return SketchLine()
    @property
    def nativeObject(self) -> CollinearConstraint:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return CollinearConstraint()

class CombineFeature(Feature):
    """
    Object that represents an existing Combine feature in a design.
    In non-parametric environment this object does not exist.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CombineFeature:
        return CombineFeature()
    def createForAssemblyContext(self, occurrence: Occurrence) -> CombineFeature:
        """
        Creates or returns a proxy for the native object
        - i.e. a new object that represents this object but adds the assembly context
        defined by the input occurrence.
        occurrence : The occurrence that defines the context to create the proxy in.
        Returns the proxy object or null if this isn't the NativeObject.
        """
        return CombineFeature()
    @property
    def targetBody(self) -> BRepBody:
        """
        Gets and sets the BRep Body object that represents the blank body.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return BRepBody()
    @targetBody.setter
    def targetBody(self, value: BRepBody):
        """
        Gets and sets the BRep Body object that represents the blank body.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def toolBodies(self) -> core.ObjectCollection:
        """
        Gets and sets the BRep Body objects that represent the tool bodies.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return core.ObjectCollection()
    @toolBodies.setter
    def toolBodies(self, value: core.ObjectCollection):
        """
        Gets and sets the BRep Body objects that represent the tool bodies.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def operation(self) -> FeatureOperations:
        """
        Gets and sets the type of operation performed by the combine.
        The valid values are JoinFeatureOperation, CutFeatureOperation and IntersectFeatureOperation.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return FeatureOperations()
    @operation.setter
    def operation(self, value: FeatureOperations):
        """
        Gets and sets the type of operation performed by the combine.
        The valid values are JoinFeatureOperation, CutFeatureOperation and IntersectFeatureOperation.
        
        To use this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def isNewComponent(self) -> bool:
        """
        Gets a boolean value for whether or not a new component was created when this feature was created.
        """
        return bool()
    @property
    def isKeepToolBodies(self) -> bool:
        """
        Gets and sets a boolean value for whether or not the tool bodies are retrained after the combine results.
        
        To set this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        return bool()
    @isKeepToolBodies.setter
    def isKeepToolBodies(self, value: bool):
        """
        Gets and sets a boolean value for whether or not the tool bodies are retrained after the combine results.
        
        To set this property, you need to position the timeline marker to immediately before this feature.
        This can be accomplished using the following code: thisFeature.timelineObject.rollTo(True)
        """
        pass
    @property
    def nativeObject(self) -> CombineFeature:
        """
        The NativeObject is the object outside the context of an assembly and
        in the context of it's parent component.
        Returns null in the case where this object is not in the context of
        an assembly but is already the native object.
        """
        return CombineFeature()

class Component(BaseComponent):
    """
    Represents a component in the data model.
    A component represents a set of geometry, features, and parameters that make up an item in the design.
    A component can be referenced multiple times into a design with a Occurrence object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Component:
        return Component()
    def createOpenProfile(self, curves: core.Base, chainCurves: bool) -> Profile:
        """
        Creates an open profile based on the input curve(s).
    