# This file is automatically generated for code intellisense only.
# It does not reflect the actual implementation.

from __future__ import annotations

class AppearanceSourceTypes():
    """
    The different types of sources for an appearance.
    """
    def __init__(self):
        pass
    MaterialAppearanceSource = 0
    BodyAppearanceSource = 1
    OccurrenceAppearanceSource = 2
    FaceAppearanceSource = 3
    OverrideAppearanceSource = 4

class CameraTypes():
    """
    The different types of cameras.
    """
    def __init__(self):
        pass
    OrthographicCameraType = 0
    PerspectiveCameraType = 1
    PerspectiveWithOrthoFacesCameraType = 2

class CloseError():
    """
    List of possible errors when closing a document.
    """
    def __init__(self):
        pass
    CloseCancelledError = 200

class CommandTerminationReason():
    """
    Defines the termination reason for a command.
    Commands can be terminated for a number of different reasons, and
    based on the reason commands have to do different things during
    termination so this enum defines various reasons for termination
    """
    def __init__(self):
        pass
    UnknownTerminationReason = 0
    CompletedTerminationReason = 1
    CancelledTerminationReason = 2
    AbortedTerminationReason = 3
    PreEmptedTerminationReason = 4
    SessionEndingTerminationReason = 5

class Curve2DTypes():
    """
    The different types of 2D curves.
    """
    def __init__(self):
        pass
    Line2DCurveType = 0
    Arc2DCurveType = 1
    Circle2DCurveType = 2
    Ellipse2DCurveType = 3
    EllipticalArc2DCurveType = 4
    InfiniteLine2DCurveType = 5
    NurbsCurve2DCurveType = 6

class Curve3DTypes():
    """
    The different types of 3D curves.
    """
    def __init__(self):
        pass
    Line3DCurveType = 0
    Arc3DCurveType = 1
    Circle3DCurveType = 2
    Ellipse3DCurveType = 3
    EllipticalArc3DCurveType = 4
    InfiniteLine3DCurveType = 5
    NurbsCurve3DCurveType = 6

class DefaultModelingOrientations():
    """
    A list of the valid modeling orientations.
    """
    def __init__(self):
        pass
    YUpModelingOrientation = 0
    ZUpModelingOrientation = 1

class DefaultOrbits():
    """
    A list of the valid orbit modes.
    """
    def __init__(self):
        pass
    ConstrainedOrbit = 0
    FreeOrbit = 1

class DegradedSelectionDisplayStyles():
    """
    A list of the valid degraded display styles.
    """
    def __init__(self):
        pass
    NormalWithGlowDegradedSelectionStyle = 0
    SimpleWithoutGlowDegradedSelectionStyle = 1

class DegreeDisplayFormats():
    """
    List of the valid degree display formats.
    """
    def __init__(self):
        pass
    DecimalDegreeDisplay = 0
    MinutesAndSecondsDegreeDisplay = 1

class DialogResults():
    """
    Defines the valid return types from a dialog.
    """
    def __init__(self):
        pass
    DialogError = -1
    DialogOK = 0
    DialogCancel = 1
    DialogYes = 2
    DialogNo = 3

class DocumentTypes():
    """
    The types of documents that can be created.
    """
    def __init__(self):
        pass
    FusionDesignDocumentType = 0

class DropDownStyles():
    """
    Defines the different styles that a drop-down input can be.
    """
    def __init__(self):
        pass
    LabeledIconDropDownStyle = 0
    TextListDropDownStyle = 1
    CheckBoxDropDownStyle = 2

class FootAndInchDisplayFormats():
    """
    List of the valid foot and inch formats.
    """
    def __init__(self):
        pass
    DecimalFootAndInchDisplay = 0
    FractionalFootAndInchDisplay = 1
    ArchitecturalFootAndInchDisplay = 2

class GenericErrors():
    """
    Errors that every API call can return via Application::GetLastError.
    These can be augmented with class and function specific errors.
    """
    def __init__(self):
        pass
    Ok = 0
    UnexpectedError = 1
    InternalValidationError = 2
    BadApiCallError = 3
    UnderlyingObjectDeletedError = 4
    OperationFailed = 5
    ExpressionError = 6
    InvalidGeometryError = 7
    ClassSpecificError = 100
    FunctionSpecificError = 200

class GraphicsDrivers():
    """
    A list of the valid graphics drivers.
    """
    def __init__(self):
        pass
    DirectX9GraphicsDriver = 0
    DirectX11GraphicsDriver = 1
    AutoSelectGraphicsDriver = 2
    OpenGLCoreProfileGraphicsDriver = 3
    OpenGLGraphicsDriver = 4

class HorizontalAlignments():
    """
    Defines the different horizontal alignments that can be applied to text.
    """
    def __init__(self):
        pass
    LeftHorizontalAlignment = 0
    CenterHorizontalAlignment = 1
    RightHorizontalAlignment = 2

class HubTypes():
    """
    The different types of hubs.
    """
    def __init__(self):
        pass
    PersonalHubType = 0
    TeamHubType = 1

class KeyboardModifiers():
    """
    Keyboard modifier values.
    """
    def __init__(self):
        pass
    NoKeyboardModifier = 0
    ShiftKeyboardModifier = 33554432
    CtrlKeyboardModifier = 67108864
    AltKeyboardModifier = 134217728
    MetaKeyboardModifier = 268435456

class KeyCodes():
    """
    Key values on the keyboard.
    """
    def __init__(self):
        pass
    NoKeyCode = 0
    SpaceKeyCode = 32
    AsteriskKeyCode = 42
    PlusKeyCode = 43
    CommaKeyCode = 44
    MinusKeyCode = 45
    PeriodKeyCode = 46
    SlashKeyCode = 47
    D0KeyCode = 48
    D1KeyCode = 49
    D2KeyCode = 50
    D3KeyCode = 51
    D4KeyCode = 52
    D5KeyCode = 53
    D6KeyCode = 54
    D7KeyCode = 55
    D8KeyCode = 56
    D9KeyCode = 57
    ColonKeyCode = 58
    SemicolonKeyCode = 59
    LessKeyCode = 60
    EqualKeyCode = 61
    GreaterKeyCode = 62
    QuestionKeyCode = 63
    AKeyCode = 65
    BKeyCode = 66
    CKeyCode = 67
    DKeyCode = 68
    EKeyCode = 69
    FKeyCode = 70
    GKeyCode = 71
    HKeyCode = 72
    IKeyCode = 73
    JKeyCode = 74
    KKeyCode = 75
    LKeyCode = 76
    MKeyCode = 77
    NKeyCode = 78
    OKeyCode = 79
    PKeyCode = 80
    QKeyCode = 81
    RKeyCode = 82
    SKeyCode = 83
    TKeyCode = 84
    UKeyCode = 85
    VKeyCode = 86
    WKeyCode = 87
    XKeyCode = 88
    YKeyCode = 89
    ZKeyCode = 90
    BracketLeftKeyCode = 91
    BackslashKeyCode = 92
    BracketRightKeyCode = 93
    AsciiCircumKeyCode = 94
    UnderscoreKeyCode = 95
    QuoteLeftKeyCode = 96
    BraceLeftKeyCode = 123
    BarKeyCode = 124
    BraceRightKeyCode = 125
    AsciiTildeKeyCode = 126
    GraveAccentKeyCode = 96
    EscapeKeyCode = 16777216
    TabKeyCode = 16777217
    BacktabKeyCode = 16777218
    BackspaceKeyCode = 16777219
    ReturnKeyCode = 16777220
    EnterKeyCode = 16777221
    InsertKeyCode = 16777222
    DeleteKeyCode = 16777223
    PauseKeyCode = 16777224
    PrintKeyCode = 16777225
    SysReqKeyCode = 16777226
    ClearKeyCode = 16777227
    HomeKeyCode = 16777232
    EndKeyCode = 16777233
    LeftKeyCode = 16777234
    UpKeyCode = 16777235
    RightKeyCode = 16777236
    DownKeyCode = 16777237
    PageUpKeyCode = 16777238
    PageDownKeyCode = 16777239
    ShiftKeyCode = 16777248
    ControlKeyCode = 16777249
    MetaKeyCode = 16777250
    AltKeyCode = 16777251
    F1KeyCode = 16777264
    F2KeyCode = 16777265
    F3KeyCode = 16777266
    F4KeyCode = 16777267
    F5KeyCode = 16777268
    F6KeyCode = 16777269
    F7KeyCode = 16777270
    F8KeyCode = 16777271
    F9KeyCode = 16777272
    F10KeyCode = 16777273
    F11KeyCode = 16777274
    F12KeyCode = 16777275
    MenuKeyCode = 16777301

class ListControlDisplayTypes():
    """
    The different types of items that can be displayed in a list control.
    """
    def __init__(self):
        pass
    CheckBoxListType = 0
    RadioButtonlistType = 1
    StandardListType = 2

class LogLevels():
    """
    Log message level
    """
    def __init__(self):
        pass
    ErrorLogLevel = 0
    WarningLogLevel = 1
    InfoLogLevel = 2

class LogTypes():
    """
    Location where messages should be logged.
    """
    def __init__(self):
        pass
    FileLogType = 0
    ConsoleLogType = 1

class MaterialDisplayUnits():
    """
    List of the different types of material related units supported for displaying values.
    """
    def __init__(self):
        pass
    MetricStandardDisplayUnits = 0
    MetricMKSDisplayUnits = 1
    MetricMMNSDisplayUnits = 2
    MetricCGSDisplayUnits = 3
    MetricUMNSDisplayUnits = 4
    EnglishStandardDisplayUnits = 5
    EnglishInchDisplayUnits = 6
    EnglishFootDisplayUnits = 7

class MessageBoxButtonTypes():
    """
    Defines the valid return types from a message box.
    """
    def __init__(self):
        pass
    OKButtonType = 0
    OKCancelButtonType = 1
    RetryCancelButtonType = 2
    YesNoButtonType = 3
    YesNoCancelButtonType = 4

class MessageBoxIconTypes():
    """
    Defines the different icons that can be used in a message box.
    """
    def __init__(self):
        pass
    NoIconIconType = 0
    QuestionIconType = 1
    InformationIconType = 2
    WarningIconType = 3
    CriticalIconType = 4

class MouseButtons():
    """
    Mouse button values.
    """
    def __init__(self):
        pass
    NoMouseButton = 0
    LeftMouseButton = 1
    RightMouseButton = 2
    MiddleMouseButton = 4

class NetworkProxySettings():
    """
    A list of the valid network proxy settings.
    """
    def __init__(self):
        pass
    AutomaticProxySettings = 0
    NoProxyProxySettings = 1
    WindowsDefaultProxySettings = 2
    OverrideProxySettings = 3

class NurbsSurfaceProperties():
    """
    The different surface property types.
    """
    def __init__(self):
        pass
    OpenNurbsSurface = 1
    ClosedNurbsSurface = 2
    PeriodicNurbsSurface = 4
    RationalNurbsSurface = 8

class OpenDocumentError():
    """
    The possible errors when a document is opened.
    """
    def __init__(self):
        pass
    DocumentNotFoundError = 200

class PaletteDockingOptions():
    """
    Defines the different options available when docking a palette to the Fusion 360 main window area.
    """
    def __init__(self):
        pass
    PaletteDockOptionsNone = 0
    PaletteDockOptionsToVerticalOnly = 1
    PaletteDockOptionsToHorizontalOnly = 2
    PaletteDockOptionsToVerticalAndHorizontal = 3

class PaletteDockingStates():
    """
    Defines the various docking states that a palette can be in.
    """
    def __init__(self):
        pass
    PaletteDockStateFloating = 0
    PaletteDockStateTop = 1
    PaletteDockStateBottom = 2
    PaletteDockStateLeft = 3
    PaletteDockStateRight = 4

class PaletteSnapOptions():
    """
    Defines the various positions that a palette can be snapped to another palette.
    """
    def __init__(self):
        pass
    PaletteSnapOptionsTop = 0
    PaletteSnapOptionsLeft = 1
    PaletteSnapOptionsRight = 2
    PaletteSnapOptionsBottom = 3

class SaveLocalErrors():
    """
    List of possible errors when saving a document locally.
    """
    def __init__(self):
        pass
    SaveCancelledSaveLocalError = 200
    DiskFullSaveLocalError = 201
    FileReadOnlySaveLocalError = 202

class SelectionDisplayStyles():
    """
    A list of the valid selection display styles.
    """
    def __init__(self):
        pass
    NormalDisplayStyle = 0
    SimpleDisplayStyle = 1

class StatusMessageTypes():
    """
    The different types of status messages that can be used with the StatusCode object.
    """
    def __init__(self):
        pass
    StatusMessageNoneType = 0
    StatusMessageErrorType = 1
    StatusMessageWarningType = 2

class SurfaceTypes():
    """
    The different types of surfaces.
    """
    def __init__(self):
        pass
    PlaneSurfaceType = 0
    CylinderSurfaceType = 1
    ConeSurfaceType = 2
    SphereSurfaceType = 3
    TorusSurfaceType = 4
    EllipticalCylinderSurfaceType = 5
    EllipticalConeSurfaceType = 6
    NurbsSurfaceType = 7

class TablePresentationStyles():
    """
    The different styles that a TableCommandInput can use for its display.
    """
    def __init__(self):
        pass
    nameValueTablePresentationStyle = 0
    itemBorderTablePresentationStyle = 1
    transparentBackgroundTablePresentationStyle = 2

class TextureTypes():
    """
    The different types of textures.
    """
    def __init__(self):
        pass
    UnknownTexture = 0
    ImageTexture = 1
    CheckerTexture = 2
    GradientTexture = 3
    MarbleTexture = 4
    NoiseTexture = 5
    SpeckleTexture = 6
    TileTexture = 7
    WaveTexture = 8
    WoodTexture = 9

class TransparencyDisplayEffects():
    """
    A list of the valid transparency display effects.
    """
    def __init__(self):
        pass
    BetterPerformanceTransparencyEffect = 0
    BetterDisplayTransparencyEffect = 1

class UploadStates():
    """
    The different states of a file upload process.
    """
    def __init__(self):
        pass
    UploadProcessing = 0
    UploadFinished = 1
    UploadFailed = 2

class UserLanguages():
    """
    A list of the valid languages.
    """
    def __init__(self):
        pass
    ChinesePRCLanguage = 0
    ChineseTaiwanLanguage = 1
    CzechLanguage = 2
    EnglishLanguage = 3
    FrenchLanguage = 4
    GermanLanguage = 5
    HungarianLanguage = 6
    ItalianLanguage = 7
    JapaneseLanguage = 8
    KoreanLanguage = 9
    PolishLanguage = 10
    PortugueseBrazilianLanguage = 11
    RussianLanguage = 12
    SpanishLanguage = 13

class ValueInputError():
    """
    Errors that can occur when using the ValueInput object.
    """
    def __init__(self):
        pass
    ValueNotOfTypeError = 100

class ValueTypes():
    """
    The different types of values that a ValueInput can be.
    """
    def __init__(self):
        pass
    StringValueType = 0
    RealValueType = 1
    ObjectValueType = 2
    BooleanValueType = 3

class VectorError():
    """
    Error values for various vector operations.
    """
    def __init__(self):
        pass
    ZeroLengthVectorError = 100

class VerticalAlignments():
    """
    Defines the different vertical alignments that can be applied to text.
    """
    def __init__(self):
        pass
    TopVerticalAlignment = 0
    MiddleVerticalAlignment = 1
    BottomVerticalAlignment = 2

class ViewOrientations():
    """
    Common view orientations.
    """
    def __init__(self):
        pass
    ArbitraryViewOrientation = 0
    BackViewOrientation = 1
    BottomViewOrientation = 2
    FrontViewOrientation = 3
    IsoBottomLeftViewOrientation = 4
    IsoBottomRightViewOrientation = 5
    IsoTopLeftViewOrientation = 6
    IsoTopRightViewOrientation = 7
    LeftViewOrientation = 8
    RightViewOrientation = 9
    TopViewOrientation = 10

class VisualStyles():
    """
    A list of the support visual styles that Fusion 360 uses when rendering the model.
    """
    def __init__(self):
        pass
    ShadedVisualStyle = 0
    ShadedWithHiddenEdgesVisualStyle = 1
    ShadedWithVisibleEdgesOnlyVisualStyle = 2
    WireframeVisualStyle = 3
    WireframeWithHiddenEdgesVisualStyle = 4
    WireframeWithVisibleEdgesOnlyVisualStyle = 5

class Base():
    """
    The base class that all other classes are derived from.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Base:
        return Base()
    @staticmethod
    def classType() -> str:
        """
        Static function that all classes support that returns the type of the class as a string.
        The returned string matches the string returned by the objectType property. For example if you
        have a reference to an object and you want to check if it's a SketchLine you can use
        myObject.objectType == fusion.SketchLine.classType().
        Returns a string indicating the type of the object.
        """
        return str()
    @property
    def objectType(self) -> str:
        """
        Returns a string indicating the type of the object.
        """
        return str()
    @property
    def isValid(self) -> bool:
        """
        Indicates if this object is still valid, i.e. hasn't been deleted
        or some other action done to invalidate the reference.
        """
        return bool()

class EventHandler():
    """
    A client supplies an EventHandler and adds it to one or more Events in
    order to be notified when the 'event' occurs.
    The EventHandler can be explicitly removed from the Event or
    if it is deleted it is automatically removed.
    This is a base class - classes like DocumentEventHandler add type safety.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> EventHandler:
        return EventHandler()

class ActiveSelectionEventHandler(EventHandler):
    """
    The ActiveSelectionEventHandler is a client implemented class that can be added as a handler to a
    ActiveSelectionEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ActiveSelectionEventHandler:
        return ActiveSelectionEventHandler()
    def notify(self, eventArgs: ActiveSelectionEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class Appearance(Base):
    """
    An appearance.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Appearance:
        return Appearance()
    def deleteMe(self) -> bool:
        """
        Deletes the Appearance from the Design. This method is only valid for appearances
        that are in a Design and are unused.
        Returns true if the delete was successful.
        """
        return bool()
    def copyTo(self, target: Base) -> bool:
        """
        Copies this appearance to the specified target.
        ***Depricated Method: Use the addByCopyMethod on the Appearances object instead, where you can rename the copied Appearance
        and the return type is Appearance rather than bool.***
        target : The target can be a Design or MaterialFavorites object.
        Returns true if the copy was successful.
        """
        return bool()
    @property
    def id(self) -> str:
        """
        The unique internal ID of this Appearance.
        """
        return str()
    @property
    def isUsed(self) -> bool:
        """
        Returns true if this Appearance is used in the Design.
        """
        return bool()
    @property
    def usedBy(self) -> ObjectCollection:
        """
        Returns a collection of the entities currently using this appearance. This
        property is only valid for an appearance in a Design and where the IsUsed
        property returns true. The collection returned can contain
        """
        return ObjectCollection()
    @property
    def name(self) -> str:
        """
        Returns the name of this Appearance. This is the localized name
        shown in the UI.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Returns the name of this Appearance. This is the localized name
        shown in the UI.
        """
        pass
    @property
    def parent(self) -> Base:
        """
        Property that returns the Parent object of this Appearance (a MaterialLibrary, Design, or AppearanceFavorites collection).
        """
        return Base()
    @property
    def hasTexture(self) -> bool:
        """
        Property that indicates if this appearance has a texture associated with it.
        """
        return bool()
    @property
    def appearanceProperties(self) -> Properties:
        """
        returns the collection of Properties that define this appearance
        """
        return Properties()

class Appearances(Base):
    """
    A collection of appearances.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Appearances:
        return Appearances()
    def item(self, index: int) -> Appearance:
        """
        Returns the specified Appearance using an index into the collection.
        index : The index of the appearance to return where the first item in the collection is 0.
        Returns the specified appearance or null if an invalid index is specified.
        """
        return Appearance()
    def itemByName(self, name: str) -> Appearance:
        """
        Returns the specified Appearance using the name as seen in the user interface. This often isn't
        a reliable way of accessing a specific appearance because appearances are not required to be unique.
        name : The name of the appearance to return,.
        Returns the specified appearance or null if there isn't a matching name.
        """
        return Appearance()
    def itemById(self, id: str) -> Appearance:
        """
        Returns the Appearance by it's internal unique ID.
        id : The ID of the appearance to return.
        Returns the specified appearance or null if there isn't a matching ID.
        """
        return Appearance()
    def addByCopy(self, appearanceToCopy: Appearance, name: str) -> Appearance:
        """
        Add an Appearance to a Design by copying an existing Appearance from Favorites, a Library or from the
        appearances stored in the Design. This method currently only applies to the Appearances collection from a Design and
        cannot be used to copy an Appearance to a library.
        appearanceToCopy : The Appearance you want to copy. The Appearance to copy can be from Favorites, a Library or from the
        appearances stored in the Design.
        name : The Appearnce name to apply to the copy.
        Returns the newly created Appearance or null if the copy operation failed.
        """
        return Appearance()
    @property
    def count(self) -> int:
        """
        The number of Materials in the collection.
        """
        return int()

class AppearanceTexture(Base):
    """
    Provides access to a list of properties that define a texture.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AppearanceTexture:
        return AppearanceTexture()
    def changeTextureImage(self, imageFilename: str) -> bool:
        """
        Changes the image of this texture.
        imageFilename : Input String specifying the full filename of the texture file to use.
        Returns true if the change was successful.
        """
        return bool()
    @property
    def properties(self) -> Properties:
        """
        Returns a collection of the properties associated with this texture.
        """
        return Properties()
    @property
    def textureType(self) -> TextureTypes:
        """
        Gets the type of texture this appearance currently is.
        """
        return TextureTypes()

class Application(Base):
    """
    The top-level object that represents the Fusion 360 application (all of Fusion 360).
    This provides access to the modeler and files.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Application:
        return Application()
    @staticmethod
    def get() -> Application:
        """
        Access to the root Application object.
        Return the root Application object or null if it failed.
        """
        return Application()
    @staticmethod
    def log(message: str, level: LogLevels, type: LogTypes) -> None:
        """
        Log Message.
        message : The message to log.
        level : The log level. Default value is Info.
        type : The log type. Default value is Console.
        """
        pass
    def getLastError(self) -> tuple[int, str]:
        """
        Returns information about the last error that occurred.
        description : A description of the last error in English.
        Returns the number of the specific error.
        """
        return (int(), str())
    def registerCustomEvent(self, eventId: str) -> CustomEvent:
        """
        This registers a new CustomEvent which is intended to be primarily used
        to send an event from a worker thread you've created back to your
        add-in running in the primary thread. It's also possible that two add-ins
        could be cooperating and another add-in can fire the event to your add-in.
        eventId : This serves as the unique ID for this event and is used by the worker thread or other
        add-in to identify which custom event to fire using the fireCustomEvent method.
        Returns the registered CustomEvent or null in the case of failure, which would typically
        be because the provided eventId is not unique.
        """
        return CustomEvent()
    def fireCustomEvent(self, eventId: str, additionalInfo: str) -> bool:
        """
        Fires a previously registered custom event. This method is used by a worker thread or another
        add-in to fire an event to the add-in that registered the event and is running in the primary thread.
        
        Firing a custom event does not immediately result in the event handler being called. When a custom
        event is fired the event is put on the queue and will be handled in the main thread when Fusion 360 is idle.
        eventId : The ID of the custom event you want to fire.
        additionalInfo : Any additional information you want to pass through the event to the add-in in the primary thread.
        Returns true if the event was successfully added to the event queue. A value of true does not indicate
        that the event was fired and handled but only that it's been put on the primary thread's event queue to
        be fired when application is idle.
        """
        return bool()
    def unregisterCustomEvent(self, eventId: str) -> bool:
        """
        Unregisters an existing CustomEvent.
        eventId : Th unique ID of the custom event you want to unregister.
        Returns True if the unregister succeeded.
        """
        return bool()
    def executeTextCommand(self, command: str) -> str:
        """
        Executes the input text command.
        command : The text command to execute.
        Returns the result of the input text command.
        """
        return str()
    @property
    def documents(self) -> Documents:
        """
        Returns the Documents collection object which supports accessing
        opened documents, opening existing documents, and creating new documents.
        """
        return Documents()
    @property
    def activeDocument(self) -> Document:
        """
        Returns the current active document.
        """
        return Document()
    @property
    def activeProduct(self) -> Product:
        """
        Returns the current active product.
        """
        return Product()
    @property
    def activeViewport(self) -> Viewport:
        """
        Returns the currently active graphics view.
        """
        return Viewport()
    @property
    def activeEditObject(self) -> Base:
        """
        Returns the current edit target as seen in the user interface. This edit target
        is defined as the container object that will be added to if something is created.
        For example, a component can be an edit target so that when new bodies are created they
        are added to that component. A sketch can also be an edit target.
        """
        return Base()
    @property
    def data(self) -> Data:
        """
        Returns the Data object which provides access the files.
        """
        return Data()
    @property
    def pointTolerance(self) -> float:
        """
        The modeling tolerance used internally when comparing two points. The value is in centimeters.
        """
        return float()
    @property
    def vectorAngleTolerance(self) -> float:
        """
        The modeling tolerance used when comparing vector angles. The value is in radians.
        """
        return float()
    @property
    def preferences(self) -> Preferences:
        """
        Provides access to all of the application preferences.
        """
        return Preferences()
    @property
    def documentOpening(self) -> DocumentEvent:
        """
        The DocumentOpening event fires at the VERY start of a document being opened.
        There is no promise that the document will be opened, hence
        a documentOpened event may not follow.
        
        When a document is being opened that references other documents, only the
        top-level document will cause a documentOpening event to be fired.
        """
        return DocumentEvent()
    @property
    def documentOpened(self) -> DocumentEvent:
        """
        The DocumentOpened event fires at the VERY end of a document being opened so the
        Document object is available to be used.
        
        When a document is opened that references other documents, only the top-level
        document will cause the documentOpened event to be fired. You can access the
        referenced documents by using the documentReferences property of the Document object.
        """
        return DocumentEvent()
    @property
    def userInterface(self) -> UserInterface:
        """
        Provides access to functionality specific to the user interface.
        """
        return UserInterface()
    @property
    def materialLibraries(self) -> MaterialLibraries:
        """
        Returns the collection of material libraries currently available.
        """
        return MaterialLibraries()
    @property
    def favoriteMaterials(self) -> FavoriteMaterials:
        """
        Returns the set of favorite materials.
        """
        return FavoriteMaterials()
    @property
    def favoriteAppearances(self) -> FavoriteAppearances:
        """
        Returns the set of favorite appearances.
        """
        return FavoriteAppearances()
    @property
    def supportedProductTypes(self) -> list[str]:
        """
        Returns an array containing the names of the products types currently
        supported by Fusion 360. For example, the name returned for Fusion 360 is
        "DesignProductType". These product type names are used to identify
        specific products in some other API functions such as the productType
        property on the Workspace and ToolbarPanel objects.
        """
        return [str()]
    @property
    def importManager(self) -> ImportManager:
        """
        Returns the ImportManager. You use the ImportManager
        to import files (of various neutral formats.) into existing components or new document.
        """
        return ImportManager()
    @property
    def userName(self) -> str:
        """
        Returns the user name of the Autodesk account currently logged in.
        """
        return str()
    @property
    def userId(self) -> str:
        """
        Returns the internal name of the Autodesk account currently logged in.
        This can be used by applications sold through the Autodesk Exchange Store
        to verify that the user has in fact purchased the product.
        """
        return str()
    @property
    def isOffLine(self) -> bool:
        """
        Gets and sets if Fusion 360 is offline or not.
        """
        return bool()
    @isOffLine.setter
    def isOffLine(self, value: bool):
        """
        Gets and sets if Fusion 360 is offline or not.
        """
        pass
    @property
    def isStartupComplete(self) -> bool:
        """
        Boolean property indicating whether Fusion 360 has completed its initialization.
        This includes initialization of all the Add-ins loaded at startup.
        """
        return bool()
    @property
    def onlineStatusChanged(self) -> ApplicationEvent:
        """
        The onlineStatusChanged event fires immediately after Fusion 360 goes online or offline.
        This event fires whether or not the online status was changed deliberately by the user by using the Fusion 360
        'Work Offline' command or because of inadvertent network/Internet connectivity issues.
        You can get the isOffline property of ApplicationEventArgs to determine whether Fusion 360 has gone Offline or
        has come back Online.
        The client can add or remove ApplicationEventHandlers from the ApplicationEvent.
        """
        return ApplicationEvent()
    @property
    def startupCompleted(self) -> ApplicationEvent:
        """
        The startupCompleted event fires after Fusion 360 has completed its initialization.
        This includes initialization of all the Add-ins loaded at startup.
        The client can add or remove ApplicationEventHandlers from the ApplicationEvent.
        """
        return ApplicationEvent()
    @property
    def currentUser(self) -> User:
        """
        Returns the User that is currently logged in.
        """
        return User()
    @property
    def insertingFromURL(self) -> WebRequestEvent:
        """
        The insertingFromURL event fires when the user has clicked a link in a web
        page that uses the Fusion 360 protocol handler to insert a file as new component.
        This event is fired at the beginning of the request but before Fusion 360 has
        take any action so that it's still possible to cancel the operation.
        """
        return WebRequestEvent()
    @property
    def insertedFromURL(self) -> WebRequestEvent:
        """
        The insertedFromURL event fires after the user has clicked a link in a web
        page that uses the Fusion 360 protocol handler to insert a file as new component
        and that operation has completed.
        """
        return WebRequestEvent()
    @property
    def openingFromURL(self) -> WebRequestEvent:
        """
        The openingFromURL event fires when the user has clicked a link in a web
        page that uses the Fusion 360 protocol handler to create a new file using an
        existing file as the initial contents. This event is fired at the beginning
        of the request but before Fusion 360 has take any action so that it's still
        possible to cancel the operation.
        """
        return WebRequestEvent()
    @property
    def openedFromURL(self) -> WebRequestEvent:
        """
        The openedFromURL event fires after the user has clicked a link in a web
        page that uses the Fusion 360 protocol handler to create a new using an existing
        file as the initial contents and that operation has completed.
        """
        return WebRequestEvent()
    @property
    def version(self) -> str:
        """
        Returns the current version of the Fusion 360 application.
        """
        return str()
    @property
    def documentCreated(self) -> DocumentEvent:
        """
        The DocumentCreated event fires when a new document is created.
        """
        return DocumentEvent()
    @property
    def documentClosing(self) -> DocumentEvent:
        """
        The DocumentClosing event fires at the VERY start of a document being closed.
        User can set the isSaveCanceled property of DocumentEventArgs to true to cancel the document close.
        """
        return DocumentEvent()
    @property
    def documentClosed(self) -> DocumentEvent:
        """
        The DocumentClosed event fires at the VERY end of a document being closed. The
        Document object is not longer available because it has been closed.
        """
        return DocumentEvent()
    @property
    def documentSaving(self) -> DocumentEvent:
        """
        The DocumentSaving event fires at the VERY start of a document being saved.
        You can set the isSaveCanceled property of DocumentEventArgs to true to cancel the document save.
        """
        return DocumentEvent()
    @property
    def documentSaved(self) -> DocumentEvent:
        """
        The DocumentSaved event fires after the save operation has been completed.
        """
        return DocumentEvent()
    @property
    def documentActivating(self) -> DocumentEvent:
        """
        The DocumentActivating event fires at the VERY start of a document being activated.
        """
        return DocumentEvent()
    @property
    def documentActivated(self) -> DocumentEvent:
        """
        The DocumentActivated event fires at the VERY end of a document being activated.
        """
        return DocumentEvent()
    @property
    def documentDeactivating(self) -> DocumentEvent:
        """
        The DocumentDeactivating event fires at the VERY start of a document being deactivated.
        """
        return DocumentEvent()
    @property
    def documentDeactivated(self) -> DocumentEvent:
        """
        The DocumentDeactivated event fires at the VERY end of a document being deactivated.
        """
        return DocumentEvent()
    @property
    def cameraChanged(self) -> CameraEvent:
        """
        The cameraChanged event fires immediately after a change in the camera has been made.
        Camera changes happen when user changes the view by rotating, zooming in or out, panning,
        changing from parallel to perspective, or when the extents of the viewport changes.
        
        You can add or remove event handlers from the CameraEvent.
        """
        return CameraEvent()
    @property
    def measureManager(self) -> MeasureManager:
        """
        Get the MeasureManager object which can be used to perform measurements of geometry.
        """
        return MeasureManager()
    @property
    def dataFileComplete(self) -> DataEvent:
        """
        The dataFileComplete event fires when a data file upload has completed including any cloud side translations.
        """
        return DataEvent()

class ApplicationCommandEventHandler(EventHandler):
    """
    An application command event handler base class that a client derives from to handle events triggered by an
    ApplicationCommandEvent.
    A client implemented instance of this class can be added to an ApplicationCommandEvent to receive these event
    notifications.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ApplicationCommandEventHandler:
        return ApplicationCommandEventHandler()
    def notify(self, eventArgs: ApplicationCommandEventArgs) -> None:
        """
        This notify member is called when an event is triggered from any event that this handler has been added to.
        eventArgs : The arguments object with details about this event and the firing ApplicationCommandEvent.
        """
        pass

class ApplicationEventHandler(EventHandler):
    """
    The ApplicationEventHandler is a client implemented class that can be added as a handler to an
    ApplicationEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ApplicationEventHandler:
        return ApplicationEventHandler()
    def notify(self, eventArgs: ApplicationEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class Attribute(Base):
    """
    Represents an attribute associated with a specific entity, Product, or Document.
    An attribute is a named value.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Attribute:
        return Attribute()
    def deleteMe(self) -> bool:
        """
        Deletes this attribute.
        Returns true if the delete was successful.
        """
        return bool()
    @property
    def groupName(self) -> str:
        """
        Gets the name of the group this attribute is a part of.
        """
        return str()
    @property
    def name(self) -> str:
        """
        Gets the name of the attribute.
        """
        return str()
    @property
    def value(self) -> str:
        """
        Gets and sets the value of this attribute.
        
        The size of an attribute value is limited to 2MB (2097152 bytes). If you need to
        save data that is larger than 2MB you'll need to break the data into pieces and
        save it in multiple attributes.
        """
        return str()
    @value.setter
    def value(self, value: str):
        """
        Gets and sets the value of this attribute.
        
        The size of an attribute value is limited to 2MB (2097152 bytes). If you need to
        save data that is larger than 2MB you'll need to break the data into pieces and
        save it in multiple attributes.
        """
        pass
    @property
    def parent(self) -> Base:
        """
        Returns the parent entity this attribute is associated with. This can return null
        in some cases. For example a BRepEdge might have been consumed by a fillet
        feature but can come back if the model is rolled back or the fillet is deleted.
        
        It's possible that the original parent that an attribute was placed on has been
        split. For example, if an attribute is placed on a face and then a slot is created
        that cuts the face into two pieces and the attribute is available from each face.
        In this case the parent property will return the "primary" face, which in most cases
        is somewhat arbitrary. You can get the other entities the attribute is associated
        with by using the otherParents property.
        """
        return Base()
    @property
    def otherParents(self) -> ObjectCollection:
        """
        In the case where the entity the attribute was originally placed on has been split,
        this property will return the other entities the attribute is associated with.
        For example, if an attribute is placed on a face and then a slot is created
        that cuts the face into two pieces and the attribute is available from both faces.
        The parent property returns the "primary" entity and this property returns any other
        entities, if any. If there aren't any other associated entities the ObjectCollection
        returned will be empty.
        """
        return ObjectCollection()

class Attributes(Base):
    """
    Provides access to attributes associated with a specific entity,
    Product, or Document. Also supports the creation of new attributes.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Attributes:
        return Attributes()
    def item(self, index: int) -> Attribute:
        """
        Returns the specified attribute using an index into the collection.
        index : The index of the attribute within the collection to return. The first item in the collection has an index of 0.
        Returns the specified attribute or null if an invalid index was specified.
        """
        return Attribute()
    def itemByName(self, groupName: str, name: str) -> Attribute:
        """
        Returns the specified attribute using the name of the attribute.
        groupName : The name of the attribute group this attribute will belong to.
        name : The name of the attribute.
        Returns the specified attribute or null if no attribute exists with the specified name.
        """
        return Attribute()
    def add(self, groupName: str, name: str, value: str) -> Attribute:
        """
        Adds a new attribute to the parent entity. If an attribute already exists on the entity with the
        same groupName and name already exists, this will update the existing attribute with the new value.
        groupName : The name of the attribute group to create this attribute within.
        name : The name of the attribute. This must be unique with respect to other attributes in the group.
        value : The value of the attribute. The size of an attribute value is limited to 2MB (2097152 bytes). If
        you need to save data that is larger than 2MB you'll need to break it into pieces and save it in
        multiple attributes.
        Returns the newly created attribute or null if the creation failed. If an attribute with the
        same groupName and name already exists, it will return the existing attribute.
        """
        return Attribute()
    def itemsByGroup(self, groupName: str) -> list[Attribute]:
        """
        Returns an array of all of the attributes that belong to the specified group.
        groupName : The name of the group.
        Returns an array of attributes or will fail in the case where an invalid group name is specified.
        """
        return [Attribute()]
    @property
    def count(self) -> int:
        """
        Returns the number of attributes in the collection.
        """
        return int()
    @property
    def groupNames(self) -> list[str]:
        """
        Returns an array of strings that are all of the name of attribute groups that exist on this entity.
        An empty array can be returns if there are no attributes on the entity.
        """
        return [str()]

class BoundingBox2D(Base):
    """
    Transient object that represents a 2D bounding box. A 2D bounding box is a rectangle box that is parallel
    to the x and y axes. The box is defined by a minimum point (smallest x-y values) and maximum point (largest x-y values).
    This object is a wrapper for these points and serves as a way to pass bounding box information
    in and out of functions. It also provides some convenience function when working with the bounding box data.
    They are created statically using the create method of the BoundingBox2D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BoundingBox2D:
        return BoundingBox2D()
    @staticmethod
    def create(minPoint: Point2D, maxPoint: Point2D) -> BoundingBox2D:
        """
        Creates a transient bounding box object.
        minPoint : The minimum point of the box.
        maxPoint : The maximum point of the box.
        Returns the new bounding box.
        """
        return BoundingBox2D()
    def contains(self, point: Point2D) -> bool:
        """
        Determines if the specified point lies within the bounding box.
        point : The point to test containment with.
        Returns true if the point lies within the bounding box.
        """
        return bool()
    def expand(self, point: Point2D) -> bool:
        """
        Expand this bounding box to contain the specified point.
        point : The point to expand the box to.
        Returns true if successful.
        """
        return bool()
    def intersects(self, boundingBox: BoundingBox2D) -> bool:
        """
        Test if this bounding box intersects with the specified bounding box.
        boundingBox : The bounding box to test intersection with.
        Returns true if the bounding boxes intersect.
        """
        return bool()
    def copy(self) -> BoundingBox2D:
        """
        Create a copy of this bounding box.
        Returns the new bounding box copy.
        """
        return BoundingBox2D()
    def combine(self, boundingBox: BoundingBox2D) -> bool:
        """
        Combines this bounding box with the input bounding box. If the input
        bounding box extends outside this bounding box then this bounding box will
        be extended to encompass both of the original bounding boxes.
        boundingBox : The other bounding box. It is not edited but is used to extend the boundaries
        of the bounding box the method is being called on.
        Returns true if the combine was successful.
        """
        return bool()
    @property
    def minPoint(self) -> Point2D:
        """
        Gets and sets the minimum point of the box.
        """
        return Point2D()
    @minPoint.setter
    def minPoint(self, value: Point2D):
        """
        Gets and sets the minimum point of the box.
        """
        pass
    @property
    def maxPoint(self) -> Point2D:
        """
        Gets and sets the maximum point of the box.
        """
        return Point2D()
    @maxPoint.setter
    def maxPoint(self, value: Point2D):
        """
        Gets and sets the maximum point of the box.
        """
        pass

class BoundingBox3D(Base):
    """
    Transient object that represents a 3D bounding box.
    It defines a rectangular box whose sides are parallel to the model space x, y, and z
    planes. Because of the fixed orientation of the box it can be fully defined
    by two points at opposing corners; the min and max points. This object is usually
    used to provide a rough approximation of the volume in space that an entity occupies.
    It also provides some convenience function when working with the bounding box data.
    They are created statically using the create method of the BoundingBox3D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BoundingBox3D:
        return BoundingBox3D()
    @staticmethod
    def create(minPoint: Point3D, maxPoint: Point3D) -> BoundingBox3D:
        """
        Creates a transient bounding box object. This object is created statically using the BoundingBox3D.create method.
        minPoint : The point that defines the minimum corner of the bounding box.
        maxPoint : The point that defines the maximum corner of the bounding box.
        Returns the newly created bounding box or null if the creation failed.
        """
        return BoundingBox3D()
    def contains(self, point: Point3D) -> bool:
        """
        Determines if the specified point is within the bound box.
        point : The point you want to check to see if it's in the bounding box.
        Returns true if the point is within the bounding box.
        """
        return bool()
    def expand(self, point: Point3D) -> bool:
        """
        Expands the size of bounding box to include the specified point.
        point : The point to include within the bounding box.
        Returns true if the expansion was successful.
        """
        return bool()
    def intersects(self, boundingBox: BoundingBox3D) -> bool:
        """
        Determines if the two bounding boxes intersect.
        boundingBox : The other bounding box to check for intersection with.
        Returns true if the two boxes intersect.
        """
        return bool()
    def copy(self) -> BoundingBox3D:
        """
        Creates an independent copy of this bounding box.
        Returns the new bounding box or null if the copy failed.
        """
        return BoundingBox3D()
    def combine(self, boundingBox: BoundingBox3D) -> bool:
        """
        Combines this bounding box with the input bounding box. If the input
        bounding box extends outside this bounding box then this bounding box will
        be extended to encompass both of the original bounding boxes.
        boundingBox : The other bounding box. It is not edited but is used to extend the boundaries
        of the bounding box the method is being called on.
        Returns true if the combine was successful.
        """
        return bool()
    @property
    def minPoint(self) -> Point3D:
        """
        Gets and sets the minimum point corner of the box.
        """
        return Point3D()
    @minPoint.setter
    def minPoint(self, value: Point3D):
        """
        Gets and sets the minimum point corner of the box.
        """
        pass
    @property
    def maxPoint(self) -> Point3D:
        """
        Gets and sets the maximum point corner of the box.
        """
        return Point3D()
    @maxPoint.setter
    def maxPoint(self, value: Point3D):
        """
        Gets and sets the maximum point corner of the box.
        """
        pass

class Camera(Base):
    """
    The Camera class represents the information that specifies how a model
    is viewed and displayed. It's analogous to a real camera where it has
    a position in space, is pointed towards a specific point and is oriented
    in a particular way.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Camera:
        return Camera()
    @property
    def eye(self) -> Point3D:
        """
        Gets and sets the position of the eye in world space.
        """
        return Point3D()
    @eye.setter
    def eye(self, value: Point3D):
        """
        Gets and sets the position of the eye in world space.
        """
        pass
    @property
    def target(self) -> Point3D:
        """
        Gets and sets the camera target point in world space.
        """
        return Point3D()
    @target.setter
    def target(self, value: Point3D):
        """
        Gets and sets the camera target point in world space.
        """
        pass
    @property
    def cameraType(self) -> CameraTypes:
        """
        Gets and sets the current camera type.
        """
        return CameraTypes()
    @cameraType.setter
    def cameraType(self, value: CameraTypes):
        """
        Gets and sets the current camera type.
        """
        pass
    @property
    def perspectiveAngle(self) -> float:
        """
        Gets and sets the perspective angle of the camera. This
        property is only valid when the CameraType property is
        either Perspective or PerspectiveWithOrthoFaces.
        """
        return float()
    @perspectiveAngle.setter
    def perspectiveAngle(self, value: float):
        """
        Gets and sets the perspective angle of the camera. This
        property is only valid when the CameraType property is
        either Perspective or PerspectiveWithOrthoFaces.
        """
        pass
    @property
    def upVector(self) -> Vector3D:
        """
        Defines the "up" direction for the camera which controls the orientation of the camera around the line
        defined between the eye and target points.
        """
        return Vector3D()
    @upVector.setter
    def upVector(self, value: Vector3D):
        """
        Defines the "up" direction for the camera which controls the orientation of the camera around the line
        defined between the eye and target points.
        """
        pass
    @property
    def viewExtents(self) -> float:
        """
        Defines the area that's visible by the camera. This
        value is the radius of a sphere centered at the target point.
        The camera will display everything within that sphere and
        everything in front of and behind the sphere. Additional
        geometry outside of the sphere will also be visible depending
        on the shape of the window. Setting this
        value can cause the eye and/or perspective angle to be
        modified when the camera type is perspective.
        """
        return float()
    @viewExtents.setter
    def viewExtents(self, value: float):
        """
        Defines the area that's visible by the camera. This
        value is the radius of a sphere centered at the target point.
        The camera will display everything within that sphere and
        everything in front of and behind the sphere. Additional
        geometry outside of the sphere will also be visible depending
        on the shape of the window. Setting this
        value can cause the eye and/or perspective angle to be
        modified when the camera type is perspective.
        """
        pass
    @property
    def isFitView(self) -> bool:
        """
        If this property is true, when this camera is applied to a viewport it
        will modify the camera such that the entire model is displayed in the viewport.
        When getting a camera from a viewport this property is always initialized to false.
        """
        return bool()
    @isFitView.setter
    def isFitView(self, value: bool):
        """
        If this property is true, when this camera is applied to a viewport it
        will modify the camera such that the entire model is displayed in the viewport.
        When getting a camera from a viewport this property is always initialized to false.
        """
        pass
    @property
    def isSmoothTransition(self) -> bool:
        """
        Determines whether Fusion 360 does a smooth transition to this camera positoin when the
        camera is assigned to a ViewPort. If this is true it will do a smooth transition from
        the current camera position to the new camera position. If false, the view will jump
        to the position defined by the camera with no intermediate steps. This is useful if
        you're providing a series of cameras to control the camera animation.
        """
        return bool()
    @isSmoothTransition.setter
    def isSmoothTransition(self, value: bool):
        """
        Determines whether Fusion 360 does a smooth transition to this camera positoin when the
        camera is assigned to a ViewPort. If this is true it will do a smooth transition from
        the current camera position to the new camera position. If false, the view will jump
        to the position defined by the camera with no intermediate steps. This is useful if
        you're providing a series of cameras to control the camera animation.
        """
        pass
    @property
    def viewOrientation(self) -> ViewOrientations:
        """
        Sets the camera to a standard orientation. If this is set,
        it will result in resetting all of the camera values except
        the camera type.
        """
        return ViewOrientations()
    @viewOrientation.setter
    def viewOrientation(self, value: ViewOrientations):
        """
        Sets the camera to a standard orientation. If this is set,
        it will result in resetting all of the camera values except
        the camera type.
        """
        pass

class CameraEventHandler(EventHandler):
    """
    The CameraEventHandler is a client implemented class that can be added as a handler to an
    CameraEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CameraEventHandler:
        return CameraEventHandler()
    def notify(self, eventArgs: CameraEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class Color(Base):
    """
    The Color class wraps all of the information that defines a simple color.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Color:
        return Color()
    @staticmethod
    def create(red: int, green: int, blue: int, opacity: int) -> Color:
        """
        Creates a new color.
        red : The red component of the color. The value can be 0 to 255.
        green : The green component of the color. The value can be 0 to 255.
        blue : The blue component of the color. The value can be 0 to 255.
        opacity : The opacity of the color. The value can be 0 to 255.
        Returns the newly created color or null if the creation failed.
        """
        return Color()
    def getColor(self) -> tuple[bool, int, int, int, int]:
        """
        Gets all of the information defining this color.
        red : The red component of the color. The value can be 0 to 255.
        green : The green component of the color. The value can be 0 to 255.
        blue : The blue component of the color. The value can be 0 to 255.
        opacity : The opacity of the color. The value can be 0 to 255. A value of 255 indicates
        it is completely opaque.
        Returns true if getting the color information was successful.
        """
        return (bool(), int(), int(), int(), int())
    def setColor(self, red: int, green: int, blue: int, opacity: int) -> bool:
        """
        Sets all of the color information.
        red : The red component of the color. The value can be 0 to 255.
        green : The green component of the color. The value can be 0 to 255.
        blue : The blue component of the color. The value can be 0 to 255.
        opacity : The opacity of the color. The value can be 0 to 255. A value of 255 indicates
        it is completely opaque. Depending on where the color is used, the opacity
        value may be ignored.
        Returns true if setting the color information was successful.
        """
        return bool()
    @property
    def red(self) -> int:
        """
        Gets and sets the red component of the color. The value can be 0 to 255.
        """
        return int()
    @red.setter
    def red(self, value: int):
        """
        Gets and sets the red component of the color. The value can be 0 to 255.
        """
        pass
    @property
    def green(self) -> int:
        """
        Gets and sets the green component of the color. The value can be 0 to 255.
        """
        return int()
    @green.setter
    def green(self, value: int):
        """
        Gets and sets the green component of the color. The value can be 0 to 255.
        """
        pass
    @property
    def blue(self) -> int:
        """
        Gets and sets the blue component of the color. The value can be 0 to 255.
        """
        return int()
    @blue.setter
    def blue(self, value: int):
        """
        Gets and sets the blue component of the color. The value can be 0 to 255.
        """
        pass
    @property
    def opacity(self) -> int:
        """
        Gets and sets the opacity of the color. The value can be 0 to 255.
        """
        return int()
    @opacity.setter
    def opacity(self, value: int):
        """
        Gets and sets the opacity of the color. The value can be 0 to 255.
        """
        pass

class Command(Base):
    """
    The Command class contains all of the functionality needed by a command to gather
    various command input from a user, provide previews, and create the final result
    which is also encapsulated within a transaction so it can be undone.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Command:
        return Command()
    def setDialogInitialSize(self, width: int, height: int) -> bool:
        """
        Sets the initial size of the dialog when it is first displayed. If this is not
        set, Fusion 360 will use a default size for the dialog.
        width : The width of the dialog in pixels.
        height : The height of the dialog in pixels.
        Returns true if the default size was successfully set.
        """
        return bool()
    def setDialogMinimumSize(self, width: int, height: int) -> bool:
        """
        Sets the minimum size for the dialog when resized to by the user. If this is not
        set, a default minimum size is used.
        width : The minimum width of the dialog in pixels.
        height : The minimum height of the dialog in pixels.
        Returns true if the minimum size was successfully set.
        """
        return bool()
    def doExecute(self, terminate: bool) -> bool:
        """
        Causes the execution of this command which results in the execute event being fired. This is the
        same effect as the user clicking the "OK" button in the command dialog and is most useful when there
        is no command dialog (no command inputs where created) and the isAutoExecute property has been set
        to False. This allows you to execute the command through code.
        terminate : In the case where there isn't a command dialog you can also use the terminate argument to specify if
        the command should terminate after execution or continue running. This is similar to the sketch line
        command where each line placement results in the creation of an undo-able line but the command continues
        to run to allow additional lines to be placed.
        Returns true if the execution of the command was successful.
        """
        return bool()
    def doExecutePreview(self) -> bool:
        """
        Causes the executePreview event of this command to be fired. This is most useful when there
        is no command dialog (no command inputs where created) and the isAutoExecute property has been set
        to False. This allows you to force the preview to be generated instead of relying on changing
        command inputs.
        Returns true if the execute Preview event was successfully fired..
        """
        return bool()
    def setCursor(self, cursorImage: str, xHotSpot: int, yHotSpot: int) -> bool:
        """
        Specifies the cursor to display at the mouse.
        cursorImage : The path to the PNG image to display as the cursor. This can either be a relative path from the py, dll, or dylib file
        of the full path. Specifying an empty string will set the cursor back to the default cursor.
        xHotSpot : Specifies the position of the x pixel within the image that is the "hot" spot or the point that is used as the mouse point. A value of
        zero indicates the far left of the image. If an empty string is used as the cursorImage, this value is ignored.
        yHotSpot : Specifies the position of the y pixel within the image that is the "hot" spot or the point that is used as the mouse point. A value of
        zero indicates the top of the image. If an empty string is used as the cursorImage, this value is ignored.
        Returns true if setting the cursor was successful.
        """
        return bool()
    def getCursor(self) -> tuple[bool, str, int, int]:
        """
        Gets the custom cursor information currently being used.
        cursorImage : The full path to the png image that is being displayed as the cursor.
        xHotSpot : Gets the position of the x pixel within the image that is the "hot" spot or the point that is used as the mouse point. A value of
        zero indicates the left of the image.
        yHotSpot : Gets the position of the y pixel within the image that is the "hot" spot or the point that is used as the mouse point. A value of
        zero indicates the top of the image.
        Returns true if getting the cursor information was successful.
        """
        return (bool(), str(), int(), int())
    def beginStep(self, makeExistingStepNonUndoable: bool) -> bool:
        """
        Begin a transacted step within the command's transaction.
        If the all of the command inputs are valid, this will trigger the execute event for the current step.
        makeExistingStepNonUndoable : If true the current step will not be undo-able.
        Returns true if beginning the step was successful.
        """
        return bool()
    @property
    def parentCommandDefinition(self) -> CommandDefinition:
        """
        Gets the parent CommandDefinition object.
        """
        return CommandDefinition()
    @property
    def activate(self) -> CommandEvent:
        """
        Gets an event that is fired when the command is first activated or re-activated after being suspended.
        Returns a CommandEvent object that is used to connect and release from the event.
        """
        return CommandEvent()
    @property
    def deactivate(self) -> CommandEvent:
        """
        Gets an event that is fired when the command is deactivated. The command still exists and could still be activated again.
        Returns a CommandEvent object that is used to connect and release from the event.
        """
        return CommandEvent()
    @property
    def destroy(self) -> CommandEvent:
        """
        Gets an event that is fired when the command is destroyed. The command is destroyed and can be cleaned up.
        Returns a CommandEvent object that is used to connect and release from the event.
        """
        return CommandEvent()
    @property
    def execute(self) -> CommandEvent:
        """
        Gets an event that is fired when the command has completed gathering the required input and now
        needs to perform whatever action the command does.
        Returns a CommandEvent object that is used to connect and release from the event.
        """
        return CommandEvent()
    @property
    def executePreview(self) -> CommandEvent:
        """
        Gets an event that is fired when the command has completed gathering the required input and now
        needs to perform a preview.
        Returns a CommandEvent object that is used to connect and release from the event.
        """
        return CommandEvent()
    @property
    def commandInputs(self) -> CommandInputs:
        """
        Gets the associated CommandInputs object which provides the ability
        to create new command inputs and provides access to any existing inputs
        that have already been created for this command.
        """
        return CommandInputs()
    @property
    def inputChanged(self) -> InputChangedEvent:
        """
        Gets an event that is fired whenever an input value is changed.
        Returns an InputChangedEvent object that is used to connect and release from the event.
        """
        return InputChangedEvent()
    @property
    def validateInputs(self) -> ValidateInputsEvent:
        """
        Gets an event that is fired to allow you to check if the current state of the inputs are valid for execution.
        Returns a ValidateInputsEvent object that is used to connect and release from the event.
        """
        return ValidateInputsEvent()
    @property
    def keyDown(self) -> KeyboardEvent:
        """
        Gets an event that is fired when a key on the keyboard is pressed down.
        """
        return KeyboardEvent()
    @property
    def keyUp(self) -> KeyboardEvent:
        """
        Gets an event that is fired when a key on the keyboard goes up.
        """
        return KeyboardEvent()
    @property
    def mouseClick(self) -> MouseEvent:
        """
        Gets an event that is fired when the mouse is clicked, (a button is pressed and released).
        """
        return MouseEvent()
    @property
    def mouseDoubleClick(self) -> MouseEvent:
        """
        Gets an event that is fired when the mouse is double-clicked, (clicked twice within the time specified by a system setting.)
        """
        return MouseEvent()
    @property
    def mouseDown(self) -> MouseEvent:
        """
        Gets an event that is fired when a mouse button is pressed.
        """
        return MouseEvent()
    @property
    def mouseMove(self) -> MouseEvent:
        """
        Gets an event that is fired when the mouse is moved.
        """
        return MouseEvent()
    @property
    def mouseUp(self) -> MouseEvent:
        """
        Gets an event that is fired when a mouse button is released.
        """
        return MouseEvent()
    @property
    def mouseWheel(self) -> MouseEvent:
        """
        Gets an event that is fired when the mouse wheel is rotated.
        """
        return MouseEvent()
    @property
    def mouseDragBegin(self) -> MouseEvent:
        """
        Gets an event that is fired when a mouse drag starts,
        (the mouse is pressed and moved).
        """
        return MouseEvent()
    @property
    def mouseDrag(self) -> MouseEvent:
        """
        Gets an event that is fired when the mouse is in drag mode,
        (being moved while a button is pressed).
        """
        return MouseEvent()
    @property
    def mouseDragEnd(self) -> MouseEvent:
        """
        Gets an event that is fired when the mouse button is released after a drag.
        """
        return MouseEvent()
    @property
    def isOKButtonVisible(self) -> bool:
        """
        Specifies if the OK button is visible or not.
        If set to false then the OK button is removed and the
        "CANCEL" button text changes to "CLOSE". You can override
        the default button text using the cancelButtonText property.
        """
        return bool()
    @isOKButtonVisible.setter
    def isOKButtonVisible(self, value: bool):
        """
        Specifies if the OK button is visible or not.
        If set to false then the OK button is removed and the
        "CANCEL" button text changes to "CLOSE". You can override
        the default button text using the cancelButtonText property.
        """
        pass
    @property
    def okButtonText(self) -> str:
        """
        Gets and sets the text displayed on the OK button. When the OK and Cancel
        buttons are displayed, this text defaults to "OK". If the Cancel button
        is not displayed the text defaults to "CLOSE".
        """
        return str()
    @okButtonText.setter
    def okButtonText(self, value: str):
        """
        Gets and sets the text displayed on the OK button. When the OK and Cancel
        buttons are displayed, this text defaults to "OK". If the Cancel button
        is not displayed the text defaults to "CLOSE".
        """
        pass
    @property
    def cancelButtonText(self) -> str:
        """
        Gets and sets the text displayed on the Cancel button. The value of this
        property is ignored if the isCancelButtonVisible property is false.
        """
        return str()
    @cancelButtonText.setter
    def cancelButtonText(self, value: str):
        """
        Gets and sets the text displayed on the Cancel button. The value of this
        property is ignored if the isCancelButtonVisible property is false.
        """
        pass
    @property
    def isRepeatable(self) -> bool:
        """
        Gets and Sets if this command is repeatable using the 'Repeat Last Command' option from the Fusion 360 marking menu.
        """
        return bool()
    @isRepeatable.setter
    def isRepeatable(self, value: bool):
        """
        Gets and Sets if this command is repeatable using the 'Repeat Last Command' option from the Fusion 360 marking menu.
        """
        pass
    @property
    def selectionEvent(self) -> SelectionEvent:
        """
        This event has been retired. Equivalent functionality is supported by the preSelect event.
        """
        return SelectionEvent()
    @property
    def isExecutedWhenPreEmpted(self) -> bool:
        """
        Specifies what the behavior will be when a command is preempted by the user executing another
        command. If true (the default), and all of the current inputs are valid, the command will be
        executed just the same as if the user clicked the OK button. If false, the command is terminated.
        """
        return bool()
    @isExecutedWhenPreEmpted.setter
    def isExecutedWhenPreEmpted(self, value: bool):
        """
        Specifies what the behavior will be when a command is preempted by the user executing another
        command. If true (the default), and all of the current inputs are valid, the command will be
        executed just the same as if the user clicked the OK button. If false, the command is terminated.
        """
        pass
    @property
    def helpFile(self) -> str:
        """
        <p class='api'>Gets and sets the associated HTML help file for this command. If this is defined
        then the help button will be displayed in the lower-left corner of the command dialog
        and when clicked the help file will be displayed using the application defined by the
        operating system for that file type. For example if the helpfile property references a .htm or .html
        file, the default browser will be invoked to display the file. If a .pdf file is used then
        whatever the default application is for viewing a pdf file will be invoked.</p>
        
        <p class='api'>The file referenced must be a local file and cannot be a URL. However, you can use a local
        HTML file that redirects to a URL.</p>
        
        <pre class="api-code">&lt;html&gt;
        &lt;head&gt;
        &lt;meta http-equiv="refresh" content="0; url=http://example.com/" /&gt;
        &lt;/head&gt;
        &lt;body&gt;&lt;/body&gt;
        &lt;/html&gt;
        </pre>
        
        <p class='api'>The filename can be either a full path or a relative path with respect to the script or add-in
        .py, .js, .dll, or .dylib file. If this is an empty string, (which is the default), then the
        help button will not be displayed.</p>
        """
        return str()
    @helpFile.setter
    def helpFile(self, value: str):
        """
        <p class='api'>Gets and sets the associated HTML help file for this command. If this is defined
        then the help button will be displayed in the lower-left corner of the command dialog
        and when clicked the help file will be displayed using the application defined by the
        operating system for that file type. For example if the helpfile property references a .htm or .html
        file, the default browser will be invoked to display the file. If a .pdf file is used then
        whatever the default application is for viewing a pdf file will be invoked.</p>
        
        <p class='api'>The file referenced must be a local file and cannot be a URL. However, you can use a local
        HTML file that redirects to a URL.</p>
        
        <pre class="api-code">&lt;html&gt;
        &lt;head&gt;
        &lt;meta http-equiv="refresh" content="0; url=http://example.com/" /&gt;
        &lt;/head&gt;
        &lt;body&gt;&lt;/body&gt;
        &lt;/html&gt;
        </pre>
        
        <p class='api'>The filename can be either a full path or a relative path with respect to the script or add-in
        .py, .js, .dll, or .dylib file. If this is an empty string, (which is the default), then the
        help button will not be displayed.</p>
        """
        pass
    @property
    def isAutoExecute(self) -> bool:
        """
        Gets and sets whether this command will automatically execute if no command inputs have been
        defined. If any command inputs have been created, the value of this property is ignored and
        the command dialog will be displayed and the command will execute when the user clicks 'OK'.
        if no command inputs have been defined and this is set to False, then the command will not
        execute but will remain running.
        
        The default value for this property is true so that the command will execute if no command inputs
        have been defined.
        """
        return bool()
    @isAutoExecute.setter
    def isAutoExecute(self, value: bool):
        """
        Gets and sets whether this command will automatically execute if no command inputs have been
        defined. If any command inputs have been created, the value of this property is ignored and
        the command dialog will be displayed and the command will execute when the user clicks 'OK'.
        if no command inputs have been defined and this is set to False, then the command will not
        execute but will remain running.
        
        The default value for this property is true so that the command will execute if no command inputs
        have been defined.
        """
        pass
    @property
    def isPositionDependent(self) -> bool:
        """
        When working in a parametric design in Fusion and you move any occurrences, those move operations are
        pending and aren't captured until you use the "Capture Position" command from the POSITION panel or
        use the "Revert" command from the same panel to move them all back to their original positions. If
        the design is in a pending situation and you run a command like "Create Sketch", a dialog appears
        asking if you want to capture the current position or not before continuing. This is because
        the creation of a sketch can be dependent on the current positions of occurrences in the design. Other commands, like
        "Fillet", depend directly on model geometry and do not rely on occurrence positions so running the Fillet command
        does not display the dialog and does not affect the pending state of the occurrences.
        
        This property allows you to specify if your command is dependent on the current position of occurrences
        or not. One good way to know if your command is dependent or not is to run the commands in the UI that are
        equivalent to the API functions you're using and see if the dialog that prompts to save or abort appears.
        If it does, then you know your command is dependent on occurrence positions.
        
        If this property is true, then the dialog will appear if there are any pending moved occurrences.
        The user can choose whether to capture the current changes or abort them, and then your command will continue.
        
        If you set this property to false, (which is the default), then even if there are pending changes, the occurrences
        are left in their current positions and your command will run.
        """
        return bool()
    @isPositionDependent.setter
    def isPositionDependent(self, value: bool):
        """
        When working in a parametric design in Fusion and you move any occurrences, those move operations are
        pending and aren't captured until you use the "Capture Position" command from the POSITION panel or
        use the "Revert" command from the same panel to move them all back to their original positions. If
        the design is in a pending situation and you run a command like "Create Sketch", a dialog appears
        asking if you want to capture the current position or not before continuing. This is because
        the creation of a sketch can be dependent on the current positions of occurrences in the design. Other commands, like
        "Fillet", depend directly on model geometry and do not rely on occurrence positions so running the Fillet command
        does not display the dialog and does not affect the pending state of the occurrences.
        
        This property allows you to specify if your command is dependent on the current position of occurrences
        or not. One good way to know if your command is dependent or not is to run the commands in the UI that are
        equivalent to the API functions you're using and see if the dialog that prompts to save or abort appears.
        If it does, then you know your command is dependent on occurrence positions.
        
        If this property is true, then the dialog will appear if there are any pending moved occurrences.
        The user can choose whether to capture the current changes or abort them, and then your command will continue.
        
        If you set this property to false, (which is the default), then even if there are pending changes, the occurrences
        are left in their current positions and your command will run.
        """
        pass
    @property
    def preSelect(self) -> SelectionEvent:
        """
        This event is used to be able to participate in the selection process in a dynamic way.
        When a user is selecting geometry, they move the mouse over the model and if the
        entity the mouse is currently over is valid for selection it will highlight indicating that
        it can be selected. This process of determining what is available for selection and highlighting
        it is referred to as the "preselect" behavior.
        
        You use functions on the SelectionCommandInput object to define what types of entities are
        selectable and in many cases this coarse level of specification is all that's needed, but in other
        cases you may need more control over the selection. For example, you might want to allow the user to
        selection construction planes and planar faces, which can easily be controlled by defining those as
        valid entities for selection in the SelectionCommandInput object. But if you only want to allow the
        user to select planes that are parallel then you need some dynamic control over the selection, which
        can be done using the preSelect event.
        
        In the example of selecting parallel planes, you would still set the valid selection types for the
        SelectionCommandInput to allow selection of construction planes and planar faces. This will limit
        the selection to only planes but any plane can still be selected. You'll also need to connect to the
        preSelect event for the command. As the user moves the mouse over any construction plane
        or planar face, the preSelect event will fire for the plane the mouse is current over. If no planes
        have yet been selected, then you allow the user to select this plane. If one or more planes have
        already selected, then in the preSelect event you'll check to see if the plane the mouse is over is
        parallel to the first plane already selected. If it is then you allow it to be selected. If it isn't
        parallel then you set the isSelectable property of the provided SelectEventArgs object to False so
        that it won't pre-highlight and won't be selectable.
        
        The entity and mouse position on the entity can be obtained through the Selection object returned
        through the selection property of the SelectionEventArgs object provided through the event.
        """
        return SelectionEvent()
    @property
    def preSelectMouseMove(self) -> SelectionEvent:
        """
        This event fires continually while the mouse is moved over an entity that is valid for selected.
        
        The entity and mouse position on the entity can be obtained through the Selection object returned
        through the selection property of the SelectionEventArgs object provided through the event.
        """
        return SelectionEvent()
    @property
    def preSelectEnd(self) -> SelectionEvent:
        """
        This event fires when the moused is moved away from an entity that was in a preselect state. If
        your add-in has done something in reaction to the preSelect, like draw some custom graphics, this
        event provides the notification to clean up whatever you've done that's associated with the current
        pre-select.
        
        The entity and mouse position on the entity can be obtained through the Selection object returned
        through the selection property of the SelectionEventArgs object provided through the event.
        """
        return SelectionEvent()
    @property
    def select(self) -> SelectionEvent:
        """
        This even fires when the user selects an entity. This is different from the preselect where an
        entity is shown as being available for selection as the mouse passes over the entity. This is the actual
        selection where the user has clicked the mouse on the entity.
        
        The entity and mouse position on the entity can be obtained through the Selection object returned
        through the selection property of the SelectionEventArgs object provided through the event.
        """
        return SelectionEvent()
    @property
    def unselect(self) -> SelectionEvent:
        """
        This even fires when the user unselects an entity by clicking the mouse again on selected entity
        or canceling previous selection.
        
        The entity and mouse position on the entity can be obtained through the Selection object returned
        through the selection property of the SelectionEventArgs object provided through the event.
        """
        return SelectionEvent()
    @property
    def editingFeature(self) -> Base:
        """
        Sets the editing feature for this command. The timeline will be rolled to the editing feature
        on activate and will the current position will be restored on deactivate.
        """
        return Base()
    @editingFeature.setter
    def editingFeature(self, value: Base):
        """
        Sets the editing feature for this command. The timeline will be rolled to the editing feature
        on activate and will the current position will be restored on deactivate.
        """
        pass
    @property
    def incomingFromHTML(self) -> HTMLEvent:
        """
        This event is fired when the JavaScript associated with the HTML displayed in a
        BrowserCommandInput calls the adsk.fusionSendData function and when the JavaScript
        responds to the sendInfoToHTML call. The HTMLEventArgs provided by the event indicates
        which BrowserCommandInput triggered the event.
        """
        return HTMLEvent()
    @property
    def navigatingURL(self) -> NavigationEvent:
        """
        This event is fired when a navigation event occurs on the page displayed within a
        BrowserCommandInput. This allows the add-in to determine how this navigation should
        be handled by the browser. The NavigationEventArgs provided by the event indicates
        which BrowserCommandInput triggered the event.
        """
        return NavigationEvent()

class CommandCreatedEventHandler(EventHandler):
    """
    Class that contains the call back function that is called when the CommandCreated event is fired.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CommandCreatedEventHandler:
        return CommandCreatedEventHandler()
    def notify(self, eventArgs: CommandCreatedEventArgs) -> None:
        """
        This notify member is called when an event is triggered from any event that this handler has been added to.
        eventArgs : The arguments object with details about this event and the firing CommandEvent.
        """
        pass

class CommandDefinition(Base):
    """
    The CommandDefinition is the base class of the various types of commands. Command types are based
    on the type of control used to execute them in the user-interface. For example, most commands will
    use a ButtonDefinition since they're executed using a button in the user-interface. A command definition
    contains the information that defines the user-interface. For example, the name and icon. The command
    definition and also gets the notification when the user interacts with the associated control.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CommandDefinition:
        return CommandDefinition()
    def execute(self, input: NamedValues) -> bool:
        """
        Executes this command definition. This is the same as the user clicking
        a button that is associated with this command definition.
        input : A list of named values that will provide input to the command. The values supported are unique for each command.
        and not all commands support input values.
        Returns true or false indicating if the execution was successful.
        """
        return bool()
    def deleteMe(self) -> bool:
        """
        Deletes this command definition. This is only valid for API created command definitions
        and will fail if the isNative property is true.
        Returns true or false indicating if the deletion was successful.
        """
        return bool()
    @property
    def commandCreated(self) -> CommandCreatedEvent:
        """
        This event is fired when the associated control is manipulated by the user. A new Command object
        is created and passed back through this event which you can then use to interact with the user
        to get any input the command requires.
        """
        return CommandCreatedEvent()
    @property
    def isNative(self) -> bool:
        """
        Gets if this is a native command definition. If True then there
        are limitations to edits that can be done on the command definition.
        For example a native command definition cannot be deleted.
        """
        return bool()
    @property
    def id(self) -> str:
        """
        Gets the unique id for this command definition. This is guaranteed to be unique with
        respect to all other command definitions.
        """
        return str()
    @property
    def toolClipFilename(self) -> str:
        """
        Gets or sets the full filename of the image file (PNG) used for the tool clip.
        The tooltip is always shown but as the user hovers over the control it will progressively display the tool clip along with the tooltip text.
        """
        return str()
    @toolClipFilename.setter
    def toolClipFilename(self, value: str):
        """
        Gets or sets the full filename of the image file (PNG) used for the tool clip.
        The tooltip is always shown but as the user hovers over the control it will progressively display the tool clip along with the tooltip text.
        """
        pass
    @property
    def tooltip(self) -> str:
        """
        Gets or sets the tooltip string. This is always shown for commands. If the tooltip description and/or tool clip are also specified then
        the tooltip will progressively display more information as the user hovers the mouse over the control.
        
        The width of all tooltips is limited to 300 pixels. Word wrapping is enabled, so Fusion will automatically
        break the line and flow your text to the next line. However, if you include a long word that exceeds
        300 pixels, it doesn't wrap and the right portion will be clipped. This is common when displaying paths
        or URL's. If a single word is longer than 300 pixels there are a couple of options to avoid the clipping.
        
        The first option is to insert one or more zero width space characters within the word to define where the
        word should be broken. The UNICODE character '\u200b' defines a zero width space. This is not displayed is only used
        to designate a possible break point.
        
        The second option is to shorten the word by removing a section. For example, if the word is a full path to a
        file and a portion of the path is common you can remove that portion and replace it with the ellipsis character
        to indicate there is some missing text. There is a single UNICODE character you can use the ellipsis. It is '\u2026'.
        """
        return str()
    @tooltip.setter
    def tooltip(self, value: str):
        """
        Gets or sets the tooltip string. This is always shown for commands. If the tooltip description and/or tool clip are also specified then
        the tooltip will progressively display more information as the user hovers the mouse over the control.
        
        The width of all tooltips is limited to 300 pixels. Word wrapping is enabled, so Fusion will automatically
        break the line and flow your text to the next line. However, if you include a long word that exceeds
        300 pixels, it doesn't wrap and the right portion will be clipped. This is common when displaying paths
        or URL's. If a single word is longer than 300 pixels there are a couple of options to avoid the clipping.
        
        The first option is to insert one or more zero width space characters within the word to define where the
        word should be broken. The UNICODE character '\u200b' defines a zero width space. This is not displayed is only used
        to designate a possible break point.
        
        The second option is to shorten the word by removing a section. For example, if the word is a full path to a
        file and a portion of the path is common you can remove that portion and replace it with the ellipsis character
        to indicate there is some missing text. There is a single UNICODE character you can use the ellipsis. It is '\u2026'.
        """
        pass
    @property
    def resourceFolder(self) -> str:
        """
        Gets or sets the directory that contains any additional files associated with this command.
        These are typically the image files that will be used for a button and the
        HTML files for a tool clip or helps and tips.
        """
        return str()
    @resourceFolder.setter
    def resourceFolder(self, value: str):
        """
        Gets or sets the directory that contains any additional files associated with this command.
        These are typically the image files that will be used for a button and the
        HTML files for a tool clip or helps and tips.
        """
        pass
    @property
    def controlDefinition(self) -> ControlDefinition:
        """
        Gets the ControlDefinition associated with this command. The control definition
        defines the type of control that can exist in the user interface to execute this command.
        You can use properties on the control definition to define the look and behavior of
        the control.
        """
        return ControlDefinition()
    @property
    def name(self) -> str:
        """
        Gets or sets the visible name of the command when seen in the user interface.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets or sets the visible name of the command when seen in the user interface.
        """
        pass

class CommandDefinitions(Base):
    """
    Provides access to all of the available command definitions. This is all those created via
    the API but also includes the command definitions defined by Fusion 360 for the native commands.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CommandDefinitions:
        return CommandDefinitions()
    def addButtonDefinition(self, id: str, name: str, tooltip: str, resourceFolder: str) -> CommandDefinition:
        """
        Creates a new command definition that can be used to create a button control and handle the response when the button is clicked.
        id : The unique identifier for this command definition. It must be unique with respect to all other command definitions and is
        limited to the following set of characters, [A-Z][a-z][0-9] and _.
        name : The name displayed in the UI for the associated button control.
        tooltip : The full description of the command as seen in the extended tooltip in the user interface.
        Using the returned CommandDefinition you can also optionally set the toolClipFilename property
        to show an image the extended tooltip.
        
        The width of all tooltips is limited to 300 pixels. Word wrapping is enabled, so Fusion will automatically
        break the line and flow your text to the next line. However, if you include a long word that exceeds
        300 pixels, it doesn't wrap and the right portion will be clipped. This is common when displaying paths
        or URL's. If a single word is longer than 300 pixels there are a couple of options to avoid the clipping.
        
        The first option is to insert one or more zero width space characters within the word to define where the
        word should be broken. The UNICODE character '\u200b' defines a zero width space. This is not displayed is only used
        to designate a possible break point.
        
        The second option is to shorten the word by removing a section. For example, if the word is a full path to a
        file and a portion of the path is common you can remove that portion and replace it with the ellipsis character
        to indicate there is some missing text. There is a single UNICODE character you can use the ellipsis. It is '\u2026'.
        resourceFolder : Specifies the folder where the resources for this command are located. These are various sizes and styles of PNG
        files that are used for the button image. To fully support all potential options you should create files with
        the following names and sizes: 16x16.png , 32x32.png, 64x64.png (used for high-res displays), 16x16-dark.png, 32x32-dark.png, 64x64-dark.png
        The dark images are used when the command is highlighted and can contain lighter lines to contrast better with the blue highlighting. If
        you don't provide dark images Fusion 360 will use the regular images when highlighting the button.
        
        This is an optional argument and if not provided a default icon will be used.
        Returns the created CommandDefinition object or null if the creation failed.
        """
        return CommandDefinition()
    def addCheckBoxDefinition(self, id: str, name: str, tooltip: str, isChecked: bool) -> CommandDefinition:
        """
        Creates a new command definition that can be used to create a single check box control and handle the response when the check box is clicked.
        id : The unique identifier for this command definition. It must be unique with respect to all other command definitions and is
        limited to the following set of characters, [A-Z][a-z][0-9] and _.
        name : The name displayed in the UI for the associated check box control.
        tooltip : The full description of the command as seen in the extended tooltip in the user interface.
        Using the returned CommandDefinition you can also optionally set the toolClipFilename property
        to show an image the extended tooltip.
        
        The width of all tooltips is limited to 300 pixels. Word wrapping is enabled, so Fusion will automatically
        break the line and flow your text to the next line. However, if you include a long word that exceeds
        300 pixels, it doesn't wrap and the right portion will be clipped. This is common when displaying paths
        or URL's. If a single word is longer than 300 pixels there are a couple of options to avoid the clipping.
        
        The first option is to insert one or more zero width space characters within the word to define where the
        word should be broken. The UNICODE character '\u200b' defines a zero width space. This is not displayed is only used
        to designate a possible break point.
        
        The second option is to shorten the word by removing a section. For example, if the word is a full path to a
        file and a portion of the path is common you can remove that portion and replace it with the ellipsis character
        to indicate there is some missing text. There is a single UNICODE character you can use the ellipsis. It is '\u2026'.
        isChecked : Indicates if the initial state of the check box.
        Returns the created CommandDefinition object or null if the creation failed.
        """
        return CommandDefinition()
    def addListDefinition(self, id: str, name: str, listControlDisplayType: ListControlDisplayTypes, resourceFolder: str) -> CommandDefinition:
        """
        Creates a new command definition that can be used to create a list of check boxes, radio buttons, or text with an icon within a pop-up.
        
        When the list is of check boxes any combinations of items in the list can be checked. The drop-down also remains displayed allowing the user to
        check and uncheck multiple items however a CommandCreated event is fired for every change.
        
        When the list is of radio buttons or a list of text items, only one item in the list can be selected at a time.
        When an item is selected the drop-down is immediately dismissed.
        
        The items in the list and their initial state are defined using functionality on the associated ListControlDefinition, which is
        accessible through the returned CommandDefinition.
        id : The unique identifier for this command definition. It must be unique with respect to all other command definitions and is
        limited to the following set of characters, [A-Z][a-z][0-9] and _.
        name : The name displayed in the UI for the associated selected check box list control.
        listControlDisplayType : Specifies the type of controls to be displayed within the list.
        resourceFolder : The folder containing any resources used for items in this list.
        Returns the created CommandDefinition object or null if the creation failed.
        """
        return CommandDefinition()
    def item(self, index: int) -> CommandDefinition:
        """
        Returns the CommandDefinition at the specified index.
        index : The index of the command definition within the collection to return. The first item in the
        collection has in index of 0.
        Returns the CommandDefinition at the specified index or null if an invalid index is specified.
        """
        return CommandDefinition()
    def itemById(self, id: str) -> CommandDefinition:
        """
        Returns the CommandDefinition that has the specified ID.
        id : The ID of the command definition to return.
        Returns the CommandDefinition with the specified ID or null if there isn't a command definition with that ID.
        """
        return CommandDefinition()
    @property
    def count(self) -> int:
        """
        Gets the number of command definitions.
        """
        return int()

class CommandEventHandler(EventHandler):
    """
    An command event handler base class that a client derives from to handle events triggered by a CommandEvent.
    A client implemented instance of this class can be added to a CommandEvent to receive these event notifications.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CommandEventHandler:
        return CommandEventHandler()
    def notify(self, eventArgs: CommandEventArgs) -> None:
        """
        This notify member is called when an event is triggered from any event that this handler has been added to.
        eventArgs : The arguments object with details about this event and the firing CommandEvent.
        """
        pass

class CommandInput(Base):
    """
    The base class for all command inputs. A CommandInput is used to gather an input value from the user when a command is executed.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CommandInput:
        return CommandInput()
    def deleteMe(self) -> bool:
        """
        Deletes this Command input.
        Returns true if the delete was successful.
        """
        return bool()
    @property
    def commandInputs(self) -> CommandInputs:
        """
        Gets the CommandInputs class of the parent, which can be a Command, GroupCommandInput or TabCommandInput.
        """
        return CommandInputs()
    @property
    def id(self) -> str:
        """
        Gets the unique identifier for this input in the command's CommandInputs.
        """
        return str()
    @property
    def name(self) -> str:
        """
        Gets the user visible name of this input.
        """
        return str()
    @property
    def isEnabled(self) -> bool:
        """
        Gets or sets if this input is currently enabled or disabled for user interaction.
        """
        return bool()
    @isEnabled.setter
    def isEnabled(self, value: bool):
        """
        Gets or sets if this input is currently enabled or disabled for user interaction.
        """
        pass
    @property
    def isVisible(self) -> bool:
        """
        Gets or sets if this input will be visible to the user.
        """
        return bool()
    @isVisible.setter
    def isVisible(self, value: bool):
        """
        Gets or sets if this input will be visible to the user.
        """
        pass
    @property
    def parentCommand(self) -> Command:
        """
        Gets the parent Command.
        """
        return Command()
    @property
    def isFullWidth(self) -> bool:
        """
        Gets or sets if this input fills the entire width of the dialog. If
        true, the name is ignored and the input control will fill the entire width of the command dialog.
        The default value for this property in a new command input if false, or not to fill the width.
        This property does not apply to GroupCommandInputs or TabCommandInputs.
        """
        return bool()
    @isFullWidth.setter
    def isFullWidth(self, value: bool):
        """
        Gets or sets if this input fills the entire width of the dialog. If
        true, the name is ignored and the input control will fill the entire width of the command dialog.
        The default value for this property in a new command input if false, or not to fill the width.
        This property does not apply to GroupCommandInputs or TabCommandInputs.
        """
        pass
    @property
    def toolClipFilename(self) -> str:
        """
        Gets or sets the full filename of the image file (PNG) used for the tool clip.
        The tooltip is always shown but as the user hovers over the control it will progressively display
        the tool clip and description text.
        """
        return str()
    @toolClipFilename.setter
    def toolClipFilename(self, value: str):
        """
        Gets or sets the full filename of the image file (PNG) used for the tool clip.
        The tooltip is always shown but as the user hovers over the control it will progressively display
        the tool clip and description text.
        """
        pass
    @property
    def tooltip(self) -> str:
        """
        Gets or sets the base tooltip string. This is always shown for commands. If the tooltip description
        and/or tool clip are also specified then the tooltip will progressively display more information as the
        user hovers the mouse over the control.
        """
        return str()
    @tooltip.setter
    def tooltip(self, value: str):
        """
        Gets or sets the base tooltip string. This is always shown for commands. If the tooltip description
        and/or tool clip are also specified then the tooltip will progressively display more information as the
        user hovers the mouse over the control.
        """
        pass
    @property
    def tooltipDescription(self) -> str:
        """
        Gets or sets additional text to display progressively along with the tooltip. The text for the description
        can contain some basic HTML formatting tags to format the tags. For example the br tag can be used to
        create multiple paragraphs. The tooltip is always shown but as the user hovers over the control it will
        progressively display the tool clip and description text.
        """
        return str()
    @tooltipDescription.setter
    def tooltipDescription(self, value: str):
        """
        Gets or sets additional text to display progressively along with the tooltip. The text for the description
        can contain some basic HTML formatting tags to format the tags. For example the br tag can be used to
        create multiple paragraphs. The tooltip is always shown but as the user hovers over the control it will
        progressively display the tool clip and description text.
        """
        pass
    @property
    def parentCommandInput(self) -> CommandInput:
        """
        Gets the parent CommandInput if this commandInput is the child of a TabCommandInput or GroupCommandInput.
        Returns null if their is no parent.
        """
        return CommandInput()

class CommandInputs(Base):
    """
    Provides access to the set of inputs for a command. Command inputs are used to gather inputs from the user when a command is executed.
    The set of inputs used by a command are created and added to the command with the methods in this class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CommandInputs:
        return CommandInputs()
    def item(self, index: int) -> CommandInput:
        """
        Returns the specified command input using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CommandInput()
    def itemById(self, id: str) -> CommandInput:
        """
        Returns the command input that has the specified ID.
        id : The unique ID of the command input you want to get.
        Returns the specified command input or null if the input ID doesn't match an existing command input.
        """
        return CommandInput()
    def addValueInput(self, id: str, name: str, unitType: str, initialValue: ValueInput) -> ValueCommandInput:
        """
        Adds a new value input to the command.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        unitType : The unit type of the value. This will be used to validate the input and the returned Value object
        will be of this type.
        initialValue : The initial value of this input as shown in the dialog. This can be a string or a real. If it's a string
        it must be able to be evaluated using the specified unit type. If it's a real it is assumed to be in database
        units for the specified unit type and is displayed as a string
        Returns the created ValueCommandInput object or null if the creation failed.
        """
        return ValueCommandInput()
    def addBoolValueInput(self, id: str, name: str, isCheckBox: bool, resourceFolder: str, initialValue: bool) -> BoolValueCommandInput:
        """
        Adds a new boolean input to the command. The input can be shown as a check box or a button. If it's a button
        you need to specify the resource folder to define the icon to use. Buttons don't have an up or down state but
        can just be clicked.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        isCheckBox : Specifies if this input should be displayed as a check box or a button. If true a check box is
        displayed, if false a button is displayed that can be clicked to toggle it's state.
        resourceFolder : Specifies the folder that contains the image for the input.
        It's optional if isCheckBox is true. If it's set for check box, the check box will be present as a button and has an up or down state.
        initialValue : Specifies the initial value of the check box or button where for a check box the value of True results
        in it being checked and for a button a value of true results in the button being pressed.
        Returns the created BoolValueCommandInput object or null if the creation failed.
        """
        return BoolValueCommandInput()
    def addStringValueInput(self, id: str, name: str, initialValue: str) -> StringValueCommandInput:
        """
        Adds a new string input to the command.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        initialValue : Specifies the initial value as shown in the dialog.
        Returns the created StringValueCommandInput object or null if the creation failed.
        """
        return StringValueCommandInput()
    def addSelectionInput(self, id: str, name: str, commandPrompt: str) -> SelectionCommandInput:
        """
        Adds a new selection input to the command. This allows you to get entity selections from the user. The default
        behavior is that only one entity can be selected and it can be of any type. To change the selection behavior to
        select specific types and control the number of items selected use the methods and properties on the returned
        SelectionCommandInput object. You can also use the selectionEvent event that's associated with the command
        to have additional control over the selection process.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        commandPrompt : The text in the tooltip shown next to the cursor.
        Returns the created SelectionCommandInput object or null if the creation failed.
        """
        return SelectionCommandInput()
    def addDropDownCommandInput(self, id: str, name: str, dropDownStyle: DropDownStyles) -> DropDownCommandInput:
        """
        Adds a new empty drop-down input to the command. drop-downs of various types are supported.
        To add items to the drop down use the returned DropDownCommandInput object.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed label of this command as seen in the dialog.
        dropDownStyle : Specifies the style of the drop-down.
        Returns the created DropDownCommandInput object or null if the creation failed.
        """
        return DropDownCommandInput()
    def addButtonRowCommandInput(self, id: str, name: str, isMultiSelectEnabled: bool) -> ButtonRowCommandInput:
        """
        Adds a new row of buttons as a command input. Depending on the isMultiSelectEnabled argument it can act like an option list
        where only a single button on the row can be selected at a time or multiple buttons can be selected.
        The buttons are defined by using the returned ButtonRowCommandInput object.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed label of this command as seen in the dialog.
        isMultiSelectEnabled : Sets if this button row can have multiple items selected at once or not.
        If True, multiple buttons can be selected at once. If False only one button
        can be selected and selecting another button unselects the one currently selected.
        Returns the created ButtonRowCommandInput object or null if the creation failed.
        """
        return ButtonRowCommandInput()
    def addFloatSliderCommandInput(self, id: str, name: str, unitType: str, min: float, max: float, hasTwoSliders: bool) -> FloatSliderCommandInput:
        """
        Adds a new slider input to the command. The value type is double.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        unitType : The unit type of the value. This will be used to validate the input and the returned value will be in the base units for this
        unit type. For example if you specify the unitType to be "in" the returned value will be in centimeters because inches are
        a length unit and the base unit for length is centimeters.
        min : Provides the minimum value in database units
        max : Provides the maximum value in database units
        hasTwoSliders : Optional input. Indicates if the slider input has two sliders.
        Returns the created FloatSliderCommandInput object or null if the creation failed.
        """
        return FloatSliderCommandInput()
    def addFloatSliderListCommandInput(self, id: str, name: str, unitType: str, valueList: list[float], hasTwoSliders: bool) -> FloatSliderCommandInput:
        """
        Adds a new slider input to the command. The value type is float.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        unitType : The unit type of the value. This will be used to validate the input and the returned Value object
        will be of this type.
        valueList : Provides the value list (in database units) of the slider command input. This defines all of the values that the slider
        can return. As the user moves the slider it will jump between these values. The low and high values
        of the list are used as the minimum and maximum values of the slider.
        hasTwoSliders : Optional input. Indicates if the slider input has two sliders.
        Returns the created FloatSliderCommandInput object or null if the creation failed.
        """
        return FloatSliderCommandInput()
    def addIntegerSliderCommandInput(self, id: str, name: str, min: int, max: int, hasTwoSliders: bool) -> IntegerSliderCommandInput:
        """
        Adds a new slider input to the command. The value type is integer.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        min : Provides the minimum value.
        max : Provides the maximum value.
        hasTwoSliders : Optional input. Indicates if the slider input has two sliders.
        Returns the created IntegerSliderCommandInput object or null if the creation failed.
        """
        return IntegerSliderCommandInput()
    def addIntegerSliderListCommandInput(self, id: str, name: str, valueList: list[int], hasTwoSliders: bool) -> IntegerSliderCommandInput:
        """
        Adds a new slider input to the command. The value type is integer.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        valueList : Provides the value list of the slider command input. This defines all of the values that the slider
        can return. As the user moves the slider it will jump between these values. The low and high values
        of the list are used as the minimum and maximum values of the slider.
        hasTwoSliders : Optional input. Indicates if the slider has two sliders.
        Returns the created IntegerSliderCommandInput object or null if the creation failed.
        """
        return IntegerSliderCommandInput()
    def addTextBoxCommandInput(self, id: str, name: str, formattedText: str, numRows: int, isReadOnly: bool) -> TextBoxCommandInput:
        """
        Adds a text box input to the command.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog. If an empty string is provided then
        no name will be displayed and the text box will span the width of the command dialog.
        formattedText : Gets and sets the formatted text displayed in the dialog. Formatted text includes
        any basic html formatting that has been defined. For example, you can use basic html
        formatting such as <code>&lt;b&gt;Bold&lt;/b&gt;</code>, <code>&lt;i&gt;Italic&lt;/i&gt;</code>,
        and <code>&lt;br /&gt;</code> for a line break. It also supports hyperlinks, which when clicked
        by the user, Fusion 360 will open the specified URL in the default browser. Hyperlinks are defined
        using the <code>&lt;a&gt;</code> tag such as
        "<code>You are using Autodesk's &lt;a href="http://fusion360.autodesk.com"&gt;Fusion 360&lt;/a&gt;.</code>".
        numRows : Specifies the height of the text box as defined by the number of rows of text that can be displayed.
        If the text is larger than will fit in the box a scroll bar will automatically be displayed.
        isReadOnly : Specifies if the text box is read-only or not.
        Returns the created TextBoxCommandInput object or null if the creation failed.
        """
        return TextBoxCommandInput()
    def addFloatSpinnerCommandInput(self, id: str, name: str, unitType: str, min: float, max: float, spinStep: float, initialValue: float) -> FloatSpinnerCommandInput:
        """
        Adds a new spinner input to the command. The value type is float.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        unitType : The unit type of the value. This will be used to validate the input and the returned Value object
        will be of this type.
        min : Provides the minimum value in database units.
        max : Provides the maximum value in database units.
        spinStep : Sets the spin step value in the unit type set by the unitType argument.
        The value should be more than zero. This is the amount the slider will advance
        when the user clicks the spin button beside the value.
        initialValue : The initial value of this input as shown in the dialog. This value is assumed to be in database
        units for the specified unit type
        Returns the created FloatSpinnerCommandInput object or null if the creation failed.
        """
        return FloatSpinnerCommandInput()
    def addIntegerSpinnerCommandInput(self, id: str, name: str, min: int, max: int, spinStep: int, initialValue: int) -> IntegerSpinnerCommandInput:
        """
        Adds a new spinner input to the command. The value type is integer.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        min : Provides the minimum value.
        max : Provides the maximum value.
        spinStep : Provides the spin step. The value should be more than zero. This is the amount the slider will advance
        when the user clicks the spin button beside the value.
        initialValue : The initial value of this input as shown in the dialog.
        Returns the created IntegerSpinnerCommandInput object or null if the creation failed.
        """
        return IntegerSpinnerCommandInput()
    def addRadioButtonGroupCommandInput(self, id: str, name: str) -> RadioButtonGroupCommandInput:
        """
        Adds a new Radio Button Group input to the command.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed label of this radio button group as seen in the dialog.
        Returns the created RadioButtonGroupCommandInput object or null if the creation failed.
        """
        return RadioButtonGroupCommandInput()
    def addGroupCommandInput(self, id: str, name: str) -> GroupCommandInput:
        """
        Adds a new Group input to the command. Group Command inputs organize a set of command inputs into a collapsible
        list within a command dialog.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed label of this group as seen in the dialog.
        Returns the created GroupCommandInput object or null if the creation failed.
        """
        return GroupCommandInput()
    def addTabCommandInput(self, id: str, name: str, resourceFolder: str) -> TabCommandInput:
        """
        Adds a new Tab input to the command. Tab command inputs contain a set of command inputs and/or group command inputs
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed label of this tab as seen in the dialog.
        resourceFolder : An optional parameter that specifies the folder that contains the image for the tab.
        If no name is specified (no text on tab), a resourceFolder containing the image to appear
        on the tab needs to be provided.
        Returns the created TabCommandInput object or null if the creation failed.
        """
        return TabCommandInput()
    def addImageCommandInput(self, id: str, name: str, imageFile: str) -> ImageCommandInput:
        """
        Adds a new Image input to the command.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed label of this Image as seen in the dialog.
        If a name is not specified (an empty string), the image will be left justified within the dialog.
        If a name is specified it will appear as a left justified label aligned with the other command input labels,
        and the left side of the image will be aligned with the other command input controls.
        imageFile : The full path and file name of the image file.
        Supported image format is .png
        Images are displayed in the command dialog using their actual size.
        Returns the created ImageCommandInput object or null if the creation failed.
        """
        return ImageCommandInput()
    def addDistanceValueCommandInput(self, id: str, name: str, initialValue: ValueInput) -> DistanceValueCommandInput:
        """
        Adds a new distance value input to the command. This displays a field in the command dialog where a
        distance value can be entered. It displays the distance in the dialog using current document default unit.
        There is also a graphical manipulator associated with the input.
        You use the setManipulator method of the returned DistanceValueCommandInput
        object to define the position and orientation of the manipulator.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed label of this input as seen in the dialog.
        If a name is not specified (an empty string), the input will be centered horizontally within it's row in the dialog.
        If a name is specified it will appear as a left justified label aligned with the other command input labels,
        and the left side of the image will be aligned with the other command input controls.
        initialValue : The initial value of the input. If the value input is a number then it is interpreted as centimeters. If it is
        a string it uses the units specified in the string or if no units are specified it uses the active units of the design.
        Returns the created DistanceValueCommandInput object or null if the creation failed.
        """
        return DistanceValueCommandInput()
    def addDirectionCommandInput(self, id: str, name: str, resourceFolder: str) -> DirectionCommandInput:
        """
        Adds a new direction command input to the command. The input can be shown as a check box or a button. If it's a button
        you need to specify the resource folder to define the icon to use for the Button.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        resourceFolder : Specifies the folder that contains the image for the input.
        This is an optional argument. The input is shown as a check box if the resource folder is not set.
        Returns the created DirectionCommandInput object or null if the creation failed.
        """
        return DirectionCommandInput()
    def addTableCommandInput(self, id: str, name: str, numberOfColumns: int, columnRatio: str) -> TableCommandInput:
        """
        Adds a new table command input to the command.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed name of this command as seen in the dialog.
        numberOfColumns : This argument is no longer used. The number of columns displayed is inferred by the
        number of columns that contain command inputs. As you add command inputs to the table
        the display of the table will adjust to show all of the columns that contain a command input.
        columnRatio : Sets the width ratio of the columns. This is defined using a string
        such as "1:1:1" where this defines that the first three columns are all the same width.
        A value of "2:1" defines that the first column is twice the width of the second.
        
        If the table has more columns than are defined by this property, they will automatically
        default to a value of 1. If this property defines the width of more columns than are
        displayed, the extra definitions are ignored.
        
        You can also specify 0 as a column width and this will have the effect of hiding
        that column. Setting a column width to 0 does not delete the column or the command inputs
        but only hides them so they can be turned back on at a later time by resetting the
        column ratio.
        Returns the created TableCommandInput object or null if the creation failed.
        """
        return TableCommandInput()
    def addAngleValueCommandInput(self, id: str, name: str, initialValue: ValueInput) -> AngleValueCommandInput:
        """
        Adds a new angle value input to the command. This displays a field in the command dialog where an
        angle value can be entered. It displays the angle in the dialog using degrees. There is also a graphical
        manipulator associated with the input to allow the user to graphically set the value. You use the
        setManipulator method of the returned AngleValueCommandInput object to define the position and
        orientation of the manipulator.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed label of this input as seen in the dialog.
        If a name is not specified (an empty string), the input will be centered horizontally within it's row in the dialog.
        If a name is specified it will appear as a left justified label aligned with the other command input labels,
        and the left side of the image will be aligned with the other command input controls.
        initialValue : The initial value of the input. If the value input is a number then it is interpreted as radians. If it is
        a string it uses the units specified in the string or if no units are specified it uses degrees.
        Returns the created AngleValueCommandInput object or null if the creation failed.
        """
        return AngleValueCommandInput()
    def addBrowserCommandInput(self, id: str, name: str, htmlFileURL: str, minimumHeight: int, maximumHeight: int) -> BrowserCommandInput:
        """
        Adds a new command input to the command that behaves as a browser.
        id : The unique ID of this command input. It must be unique with respect to the other inputs associated with this command.
        name : The displayed label of this input as seen in the dialog.
        
        If a name is not specified (an empty string), the input will be centered horizontally within it's row in the dialog.
        If a name is specified, the name will appear as a left justified label aligned with the other command input labels,
        and the left side of the input will be aligned with the other command inputs.
        htmlFileURL : Specifies the URL to the HTML file that will be displayed in the tab. This can be a local file or on the web.
        minimumHeight : Defines the minimum height of the browser within the command dialog. As the user resizes the dialog, the area taken
        up by the browser will shrink and grow to fit within the defined space. It will never shrink to be less than the
        minimum height or expand to be larger than the maximum height. If the dialog can't fit the browser at the minimum size
        a scroll bar will appear for the dialog to allow the user to scroll to access all the inputs in the dialog.
        maximumHeight : An optional parameter that specifies the maximum height of the browser within the command dialog. As the user resizes
        the dialog, the area taken up by the browser will shrink and grow to fit within the defined space. It will never
        shrink to be less than the minimum height or expand to be larger than the maximum height. If the content displayed
        within the browser does not fit within the current area, a scroll bar will appear to allow the user to scroll to see
        the entire browser content. The default value of zero sets no maximum height, so the browser will expand to the maximum
        extent available.
        Returns the created BrowserCommandInput object or null if the creation failed.
        """
        return BrowserCommandInput()
    @property
    def command(self) -> Command:
        """
        Gets the parent Command object.
        """
        return Command()
    @property
    def count(self) -> int:
        """
        Gets the number of inputs.
        """
        return int()

class ControlDefinition(Base):
    """
    The ControlDefinition is the base class for the various types of control definitions.
    You can use properties on the control definition to define the look and behavior of
    the control.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ControlDefinition:
        return ControlDefinition()
    @property
    def isEnabled(self) -> bool:
        """
        Gets or sets if this definition is enabled or not. This has the effect of enabling and disabling any associated controls.
        """
        return bool()
    @isEnabled.setter
    def isEnabled(self, value: bool):
        """
        Gets or sets if this definition is enabled or not. This has the effect of enabling and disabling any associated controls.
        """
        pass
    @property
    def isVisible(self) -> bool:
        """
        Gets or sets if this definition is visible or not. This has the effect of making any associated controls visible or invisible in the user interface.
        """
        return bool()
    @isVisible.setter
    def isVisible(self, value: bool):
        """
        Gets or sets if this definition is visible or not. This has the effect of making any associated controls visible or invisible in the user interface.
        """
        pass
    @property
    def name(self) -> str:
        """
        Gets or sets the name for this control. This is the visible name displayed in the user interface.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets or sets the name for this control. This is the visible name displayed in the user interface.
        """
        pass

class Curve2D(Base):
    """
    The base class for all 2D transient geometry classes.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Curve2D:
        return Curve2D()
    def transformBy(self, matrix: Matrix2D) -> bool:
        """
        Transforms this curve in 2D space.
        matrix : A 2D matrix that defines the transform to apply to the curve.
        Return true if the transform was successful.
        """
        return bool()
    @property
    def curveType(self) -> Curve2DTypes:
        """
        Returns the type of geometry this curve represents.
        """
        return Curve2DTypes()
    @property
    def evaluator(self) -> CurveEvaluator2D:
        """
        Returns an evaluator object that lets you perform additional evaluations on the curve.
        """
        return CurveEvaluator2D()

class Curve3D(Base):
    """
    The base class for all 3D transient geometry classes.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Curve3D:
        return Curve3D()
    def transformBy(self, matrix: Matrix3D) -> bool:
        """
        Transforms this curve in 3D space.
        matrix : A 3D matrix that defines the transform to apply to the curve.
        Return true if the transform was successful.
        """
        return bool()
    @property
    def curveType(self) -> Curve3DTypes:
        """
        Returns the type of geometry this curve represents.
        """
        return Curve3DTypes()
    @property
    def evaluator(self) -> CurveEvaluator3D:
        """
        Returns an evaluator object that lets you perform additional evaluations on the curve.
        """
        return CurveEvaluator3D()

class CurveEvaluator2D(Base):
    """
    2D curve evaluator that is obtained from a transient curve and allows you to perform
    various evaluations on the curve.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CurveEvaluator2D:
        return CurveEvaluator2D()
    def getCurvatures(self, parameters: list[float]) -> tuple[bool, list[Vector2D], list[float]]:
        """
        Get the curvature values at a number of parameter positions on the curve.
        parameters : The array of parameter positions to return curvature information at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        directions : The output array of the direction of the curvature at each position on the curve.
        The length of this array will be the same as the length of the parameters array provided.
        curvatures : The output array of the magnitude of the curvature at the position on the curve.
        The length of this array will be the same as the length of the parameters array provided.
        Returns true if the curvatures were successfully returned.
        """
        return (bool(), [Vector2D()], [float()])
    def getCurvature(self, parameter: float) -> tuple[bool, Vector2D, float]:
        """
        Get the curvature value at a parameter position on the curve.
        parameter : The parameter position to return the curvature information at.
        This value must be within the range of the parameter extents as provided by getParameterExtents.
        direction : The output direction of the curvature at the position on the curve.
        curvature : The output magnitude of the curvature at the position on the curve.
        Returns true if the curvature was successfully returned.
        """
        return (bool(), Vector2D(), float())
    def getTangents(self, parameters: list[float]) -> tuple[bool, list[Vector2D]]:
        """
        Get the tangent to the curve at a number of parameter positions on the curve.
        parameters : The array of parameter positions to return the tangent at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        tangents : The output array of tangent vectors for each position on the curve.
        The length of this array will be the same as the length of the parameters array provided.
        Returns true if the tangents were successfully returned.
        """
        return (bool(), [Vector2D()])
    def getTangent(self, parameter: float) -> tuple[bool, Vector2D]:
        """
        Get the tangent to the curve at a parameter position on the curve.
        parameter : The parameter position to return the tangent at.
        This value must be within the range of the parameter extents as provided by getParameterExtents.
        tangent : The output tangent vector at the curve position.
        Returns true if the tangent was successfully returned.
        """
        return (bool(), Vector2D())
    def getEndPoints(self) -> tuple[bool, Point2D, Point2D]:
        """
        Get the end points of the curve.
        startPoint : The output start point of the curve. If the curve is unbounded at the start, this value will be null.
        endPoint : The output end point of the curve. If the curve is unbounded at the end, this value will be null.
        Returns true if the end points were successfully returned.
        """
        return (bool(), Point2D(), Point2D())
    def getLengthAtParameter(self, fromParameter: float, toParameter: float) -> tuple[bool, float]:
        """
        Get the length of the curve between two parameter positions on the curve.
        fromParameter : The parameter position to measure the curve length from.
        This value must be within the range of the parameter extents as provided by getParameterExtents.
        toParameter : The parameter position to measure the curve length to.
        This value must be within the range of the parameter extents as provided by getParameterExtents.
        length : The output curve length between the from and to parameter positions on the curve.
        Returns true if the length was successfully returned.
        """
        return (bool(), float())
    def getParameterAtLength(self, fromParameter: float, length: float) -> tuple[bool, float]:
        """
        Get the parameter position on the curve that is the specified curve length from the specified starting parameter position.
        fromParameter : The parameter position to start measuring the curve length from.
        This value must be within the range of the parameter extents as provided by getParameterExtents.
        length : The curve length to offset the from parameter by.
        A negative length value will offset in the negative parameter direction.
        parameter : The output parameter value that is the specified curve length from the starting parameter position.
        Returns true if the parameter was successfully returned.
        """
        return (bool(), float())
    def getParametersAtPoints(self, points: list[Point2D]) -> tuple[bool, list[float]]:
        """
        Get the parameter positions that correspond to a set of points on the curve.
        For reliable results, the points should lie on the curve within model tolerance.
        If the points do not lie on the curve, the parameter of the nearest point on the curve will generally be returned.
        points : An array of points to get the curve parameter values at.
        parameters : The output array of parameter positions corresponding to the set of points.
        The length of this array will be equal to the length of the points array specified.
        Returns true if the parameters were successfully returned.
        """
        return (bool(), [float()])
    def getParameterAtPoint(self, point: Point2D) -> tuple[bool, float]:
        """
        Get the parameter position that correspond to a point on the curve.
        For reliable results, the point should lie on the curve within model tolerance.
        If the point does not lie on the curve, the parameter of the nearest point on the curve will generally be returned.
        point : The point to get the curve parameter value at.
        parameter : The output parameter position corresponding to the point.
        Returns true of the parameter was successfully returned.
        """
        return (bool(), float())
    def getParameterExtents(self) -> tuple[bool, float, float]:
        """
        Get the parametric range of the curve.
        startParameter : The output lower bound of the parameter range.
        endParameter : The output upper bound of the parameter range.
        Returns true if the curve is bounded and the parameter extents were successfully returned.
        """
        return (bool(), float(), float())
    def getPointsAtParameters(self, parameters: list[float]) -> tuple[bool, list[Point2D]]:
        """
        Get the points on the curve that correspond to evaluating a set of parameter positions on the curve.
        parameters : The array of parameter positions to evaluate the curve position at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        points : The output array of curve positions corresponding to evaluating the curve at that parameter position.
        The length of this array will be equal to the length of the parameters array specified.
        Returns true if the points were successfully returned.
        """
        return (bool(), [Point2D()])
    def getPointAtParameter(self, parameter: float) -> tuple[bool, Point2D]:
        """
        Get the point on the curve that corresponds to evaluating a parameter position on the curve.
        parameter : The parameter position to evaluate the curve position at.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        point : The output curve position corresponding to evaluating the curve at that parameter position.
        Returns true if the point was successfully returned.
        """
        return (bool(), Point2D())
    def getFirstDerivatives(self, parameters: list[float]) -> tuple[bool, list[Vector2D]]:
        """
        Get the first derivatives of the curve at the specified parameter positions.
        parameters : The array of parameter positions to get the curve first derivative at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        firstDerivatives : The output array of first derivative vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        Returns true if the first derivatives were successfully returned.
        """
        return (bool(), [Vector2D()])
    def getFirstDerivative(self, parameter: float) -> tuple[bool, Vector2D]:
        """
        Get the first derivative of the curve at the specified parameter position.
        parameter : The parameter position to get the curve first derivative at.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        firstDerivative : The output first derivative vector at the parameter position specified.
        Returns true if the first derivative was successfully returned.
        """
        return (bool(), Vector2D())
    def getSecondDerivatives(self, parameters: list[float]) -> tuple[bool, list[Vector2D]]:
        """
        Get the second derivatives of the curve at the specified parameter positions.
        parameters : The array of parameter positions to get the curve second derivative at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        secondDerivatives : The output array of second derivative vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        Returns true if the second derivatives were successfully returned.
        """
        return (bool(), [Vector2D()])
    def getSecondDerivative(self, parameter: float) -> tuple[bool, Vector2D]:
        """
        Get the second derivative of the curve at the specified parameter position.
        parameter : The parameter position to get the curve second derivative at.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        secondDerivative : The output second derivative vector at the parameter position specified.
        Returns true if the second derivative was successfully returned.
        """
        return (bool(), Vector2D())
    def getThirdDerivatives(self, parameters: list[float]) -> tuple[bool, list[Vector2D]]:
        """
        Get the third derivatives of the curve at the specified parameter positions.
        parameters : The array of parameter positions to get the curve third derivative at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        thirdDerivatives : The output array of third derivative vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        Returns true if the third derivatives were successfully returned.
        """
        return (bool(), [Vector2D()])
    def getThirdDerivative(self, parameter: float) -> tuple[bool, Vector2D]:
        """
        Get the third derivative of the curve at the specified parameter position.
        parameter : The parameter position to get the curve third derivative at.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        thirdDerivative : The output third derivative vector at the parameter position specified.
        Returns true if the third derivative was successfully returned.
        """
        return (bool(), Vector2D())
    def getStrokes(self, fromParameter: float, toParameter: float, tolerance: float) -> tuple[bool, list[Point2D]]:
        """
        Get a sequence of points between two curve parameter positions.
        The points will be a linear interpolation along the curve between these two
        parameter positions where the maximum deviation between the curve and each line
        segment will not exceed the specified tolerance value.
        fromParameter : The starting parameter position to interpolate points from.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        toParameter : The ending parameter position to interpolate points to.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        tolerance : The maximum distance tolerance between the curve and the linear interpolation.
        vertexCoordinates : The output array of linear interpolation points.
        Returns true if the interpolation points were successfully returned.
        """
        return (bool(), [Point2D()])

class CurveEvaluator3D(Base):
    """
    3D curve evaluator that is obtained from a transient curve and allows you to perform
    various evaluations on the curve.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CurveEvaluator3D:
        return CurveEvaluator3D()
    def getCurvatures(self, parameters: list[float]) -> tuple[bool, list[Vector3D], list[float]]:
        """
        Get the curvature values at a number of parameter positions on the curve.
        parameters : The array of parameter positions to return curvature information at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        directions : The output array of the direction of the curvature at each position on the curve.
        The length of this array will be the same as the length of the parameters array provided.
        curvatures : The output array of the magnitude of the curvature at the position on the curve.
        The length of this array will be the same as the length of the parameters array provided.
        Returns true if the curvatures were successfully returned.
        """
        return (bool(), [Vector3D()], [float()])
    def getCurvature(self, parameter: float) -> tuple[bool, Vector3D, float]:
        """
        Get the curvature value at a parameter position on the curve.
        parameter : The parameter position to return the curvature information at.
        This value must be within the range of the parameter extents as provided by getParameterExtents.
        direction : The output direction of the curvature at the position on the curve.
        curvature : The output magnitude of the curvature at the position on the curve.
        Returns true if the curvature was successfully returned.
        """
        return (bool(), Vector3D(), float())
    def getEndPoints(self) -> tuple[bool, Point3D, Point3D]:
        """
        Get the end points of the curve.
        startPoint : The output start point of the curve. If the curve is unbounded at the start, this value will be null.
        endPoint : The output end point of the curve. If the curve is unbounded at the end, this value will be null.
        Returns true if the end points were successfully returned.
        """
        return (bool(), Point3D(), Point3D())
    def getLengthAtParameter(self, fromParameter: float, toParameter: float) -> tuple[bool, float]:
        """
        Get the length of the curve between two parameter positions on the curve.
        fromParameter : The parameter position to measure the curve length from.
        This value must be within the range of the parameter extents as provided by getParameterExtents.
        toParameter : The parameter position to measure the curve length to.
        This value must be within the range of the parameter extents as provided by getParameterExtents.
        length : The output curve length between the from and to parameter positions on the curve.
        Returns true if the length was successfully returned.
        """
        return (bool(), float())
    def getParameterAtLength(self, fromParameter: float, length: float) -> tuple[bool, float]:
        """
        Get the parameter position on the curve that is the specified curve length from the specified starting parameter position.
        fromParameter : The parameter position to start measuring the curve length from.
        This value must be within the range of the parameter extents as provided by getParameterExtents.
        length : The curve length to offset the from parameter by.
        A negative length value will offset in the negative parameter direction.
        parameter : The output parameter value that is the specified curve length from the starting parameter position.
        Returns true if the parameter was successfully returned.
        """
        return (bool(), float())
    def getParametersAtPoints(self, points: list[Point3D]) -> tuple[bool, list[float]]:
        """
        Get the parameter positions that correspond to a set of points on the curve.
        For reliable results, the points should lie on the curve within model tolerance.
        If the points do not lie on the curve, the parameter of the nearest point on the curve will generally be returned.
        points : An array of points to get the curve parameter values at.
        parameters : The output array of parameter positions corresponding to the set of points.
        The length of this array will be equal to the length of the points array specified.
        Returns true if the parameters were successfully returned.
        """
        return (bool(), [float()])
    def getParameterAtPoint(self, point: Point3D) -> tuple[bool, float]:
        """
        Get the parameter position that correspond to a point on the curve.
        For reliable results, the point should lie on the curve within model tolerance.
        If the point does not lie on the curve, the parameter of the nearest point on the curve will generally be returned.
        point : The point to get the curve parameter value at.
        parameter : The output parameter position corresponding to the point.
        Returns true of the parameter was successfully returned.
        """
        return (bool(), float())
    def getParameterExtents(self) -> tuple[bool, float, float]:
        """
        Get the parametric range of the curve.
        startParameter : The output lower bound of the parameter range.
        endParameter : The output upper bound of the parameter range.
        Returns true if the curve is bounded and the parameter extents were successfully returned.
        """
        return (bool(), float(), float())
    def getPointsAtParameters(self, parameters: list[float]) -> tuple[bool, list[Point3D]]:
        """
        Get the points on the curve that correspond to evaluating a set of parameter positions on the curve.
        parameters : The array of parameter positions to evaluate the curve position at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        points : The output array of curve positions corresponding to evaluating the curve at that parameter position.
        The length of this array will be equal to the length of the parameters array specified.
        Returns true if the points were successfully returned.
        """
        return (bool(), [Point3D()])
    def getPointAtParameter(self, parameter: float) -> tuple[bool, Point3D]:
        """
        Get the point on the curve that corresponds to evaluating a parameter position on the curve.
        parameter : The parameter position to evaluate the curve position at.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        point : The output curve position corresponding to evaluating the curve at that parameter position.
        Returns true if the point was successfully returned.
        """
        return (bool(), Point3D())
    def getFirstDerivatives(self, parameters: list[float]) -> tuple[bool, list[Vector3D]]:
        """
        Get the first derivatives of the curve at the specified parameter positions.
        parameters : The array of parameter positions to get the curve first derivative at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        firstDerivatives : The output array of first derivative vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        Returns true if the first derivatives were successfully returned.
        """
        return (bool(), [Vector3D()])
    def getFirstDerivative(self, parameter: float) -> tuple[bool, Vector3D]:
        """
        Get the first derivative of the curve at the specified parameter position.
        parameter : The parameter position to get the curve first derivative at.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        firstDerivative : The output first derivative vector at the parameter position specified.
        Returns true if the first derivative was successfully returned.
        """
        return (bool(), Vector3D())
    def getSecondDerivatives(self, parameters: list[float]) -> tuple[bool, list[Vector3D]]:
        """
        Get the second derivatives of the curve at the specified parameter positions.
        parameters : The array of parameter positions to get the curve second derivative at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        secondDerivatives : The output array of second derivative vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        Returns true if the second derivatives were successfully returned.
        """
        return (bool(), [Vector3D()])
    def getSecondDerivative(self, parameter: float) -> tuple[bool, Vector3D]:
        """
        Get the second derivative of the curve at the specified parameter position.
        parameter : The parameter position to get the curve second derivative at.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        secondDerivative : The output second derivative vector at the parameter position specified.
        Returns true if the second derivative was successfully returned.
        """
        return (bool(), Vector3D())
    def getThirdDerivatives(self, parameters: list[float]) -> tuple[bool, list[Vector3D]]:
        """
        Get the third derivatives of the curve at the specified parameter positions.
        parameters : The array of parameter positions to get the curve third derivative at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        thirdDerivatives : The output array of third derivative vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        Returns true if the third derivatives were successfully returned.
        """
        return (bool(), [Vector3D()])
    def getThirdDerivative(self, parameter: float) -> tuple[bool, Vector3D]:
        """
        Get the third derivative of the curve at the specified parameter position.
        parameter : The parameter position to get the curve third derivative at.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        thirdDerivative : The output third derivative vector at the parameter position specified.
        Returns true if the third derivative was successfully returned.
        """
        return (bool(), Vector3D())
    def getStrokes(self, fromParameter: float, toParameter: float, tolerance: float) -> tuple[bool, list[Point3D]]:
        """
        Get a sequence of points between two curve parameter positions.
        The points will be a linear interpolation along the curve between these two
        parameter positions where the maximum deviation between the curve and each line
        segment will not exceed the specified tolerance value.
        fromParameter : The starting parameter position to interpolate points from.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        toParameter : The ending parameter position to interpolate points to.
        The parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        tolerance : The maximum distance tolerance between the curve and the linear interpolation.
        vertexCoordinates : The output array of linear interpolation points.
        Returns true if the interpolation points were successfully returned.
        """
        return (bool(), [Point3D()])
    def getTangents(self, parameters: list[float]) -> tuple[bool, list[Vector3D]]:
        """
        Get the tangent to the curve at a number of parameter positions on the curve.
        parameters : The array of parameter positions to return the tangent at.
        Each parameter value must be within the range of the parameter extents as provided by getParameterExtents.
        tangents : The output array of tangent vectors for each position on the curve.
        The length of this array will be the same as the length of the parameters array provided.
        Returns true if the tangents were successfully returned.
        """
        return (bool(), [Vector3D()])
    def getTangent(self, parameter: float) -> tuple[bool, Vector3D]:
        """
        Get the tangent to the curve at a parameter position on the curve.
        parameter : The parameter position to return the tangent at.
        This value must be within the range of the parameter extents as provided by getParameterExtents.
        tangent : The output tangent vector at the curve position.
        Returns true if the tangent was successfully returned.
        """
        return (bool(), Vector3D())

class CustomEventHandler(EventHandler):
    """
    The ApplicationEventHandler is a client implemented class that can be added as a handler to an
    ApplicationEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomEventHandler:
        return CustomEventHandler()
    def notify(self, eventArgs: CustomEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class Data(Base):
    """
    The Data class provides access to data files
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Data:
        return Data()
    def refreshDataPanel(self) -> bool:
        """
        Refreshes the contents of the data panel to ensure what is displayed reflects the latest state.
        Returns true if the refresh was successful.
        """
        return bool()
    def findFileById(self, id: str) -> DataFile:
        """
        Returns the DataFile identified by the input id. This can fail is there isn't a DataFile identified
        with the specified id or if the current user doesn't have privileges to access the file.
        id : The full id of the file will be something similar to that shown below. The version argument can be
        omitted which will result in getting the latest version.
        
        urn:adsk.wipprod:fs.file:vf.NazykCYLRWKZ5tpzJtEQ1A?version=3
        
        This is also the same id that you'll obtain if you use the Forge Data Management API.
        Returns a DataFile if one was found matching the input id or null if one was not found or you don't
        have privileges to access it. You can use the Application.getLastError method to determine the reason
        for the failure.
        """
        return DataFile()
    @property
    def activeProject(self) -> DataProject:
        """
        Gets and sets the active DataProject. This is the project currently displayed in the Fusion 360 Data Panel.
        """
        return DataProject()
    @activeProject.setter
    def activeProject(self, value: DataProject):
        """
        Gets and sets the active DataProject. This is the project currently displayed in the Fusion 360 Data Panel.
        """
        pass
    @property
    def dataProjects(self) -> DataProjects:
        """
        Gets the collection of DataProjects associated with the active Hub.
        """
        return DataProjects()
    @property
    def dataHubs(self) -> DataHubs:
        """
        Returns a collection of accessible hubs for the current user. A DataHub represents an A360 Team or Personal hub.
        """
        return DataHubs()
    @property
    def activeHub(self) -> DataHub:
        """
        Gets the active DataHub.
        """
        return DataHub()
    @activeHub.setter
    def activeHub(self, value: DataHub):
        """
        Gets the active DataHub.
        """
        pass
    @property
    def isDataPanelVisible(self) -> bool:
        """
        Gets and sets if the data panel is visible within Fusion 360.
        """
        return bool()
    @isDataPanelVisible.setter
    def isDataPanelVisible(self, value: bool):
        """
        Gets and sets if the data panel is visible within Fusion 360.
        """
        pass
    @property
    def personalUseLimits(self) -> PersonalUseLimits:
        """
        If the user is running with a "Fusion 360 for Personal Use license", this property
        will return a peronalUseLimits object which provides information about
        file limits associated with the license. If the user is running with any other
        license type, this property will return null.
        """
        return PersonalUseLimits()
    @property
    def activeSpaceCollectionId(self) -> str:
        """
        Returns the Id of the currently active space collection.
        """
        return str()

class DataEventHandler(EventHandler):
    """
    The DataEventHandler is a client implemented class that can be added as a handler to a
    DataEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataEventHandler:
        return DataEventHandler()
    def notify(self, eventArgs: DataEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class DataFile(Base):
    """
    A data file in a data folder.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataFile:
        return DataFile()
    def deleteMe(self) -> bool:
        """
        Deletes this DataFile. This can fail if this file is referenced by another file or is currently open.
        Returns true if the deletion was successful.
        """
        return bool()
    def move(self, targetFolder: DataFolder) -> bool:
        """
        Moves this DataFile to the specified folder.
        targetFolder : The folder to move this DataFile to.
        Returns true if the move was successful.
        """
        return bool()
    def copy(self, targetFolder: DataFolder) -> DataFile:
        """
        Copies this DataFile to the specified folder.
        targetFolder : The folder to copy this DataFile to.
        Returns the copied DataFile if the copy was successful.
        """
        return DataFile()
    def promote(self) -> bool:
        """
        Promotes this version to be the latest version. If this is the latest version, nothing happens.
        Returns true if successful.
        """
        return bool()
    def assemblyPIMData(self, noTraverse: bool) -> str:
        """
        Retrieve the PIM data JSON for the assembly.
        noTraverse : If false, traverse across referenced documents, otherwise do not.
        
        """
        return str()
    def download(self, path: str, handler: DataEventHandler) -> bool:
        """
        Performs a synchronous or asynchronous download of this DataFile. Only DataFiles that represent
        non-Fusion data can be downloaded. For example, this will work for TXT or XLS files but will
        fail for F3D files.
        
        When using this in its synchronous mode, Fusion is frozen during the download and the call will not
        return until the download is complete or has failed. When using this in its asynchronous mode,
        calling this method will start the download process and the call return before the download is
        complete. The event on the provided handler will be called notifying you when the download is complete.
        path : The full path and optionally the filename used on the local file system for the file. If the path
        doesn't exist it will be created. If only a path is specified, the name and file extension associated
        with the DataFile is used for the filename. You can also specify the full path, including the filename.
        handler : If you want to do an asynchronous download, provide the handler object to be called when this operation
        is complete. To call the method synchronously, set this argument to null/None.
        Returns True in synchronous mode if successful. Returns True in asynchronous mode if the download was successfully started.
        """
        return bool()
    def refresh(self, handler: DataEventHandler) -> bool:
        """
        Refreshes the data associated with a DataFile object to be up to date with the associated cloud data.
        The DataFile returned by the API reflects the local representation of the DataFile as used by the Data Panel.
        This is method is only useful in very limited cases and should rarely be used. In most cases the local
        representation will match the actual data on the cloud. In rare occasions where Fusion was offline while
        the cloud processing of DataFile is completed or the DataFile is not in the folder shown in the Data Panel.
        Getting a DataFileFolder contents forces an update of the local data for all of the data files it contains
        so they will all be up to date.
        handler : If you want to do an asynchronous refresh, provide the handler object to be called when this operation
        is complete. To call the method synchronously, set this argument to null/None.
        Returns True in synchronous mode if successful. Returns True in asynchronous mode if the refresh was successfully started.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets and sets the displayed name of this item.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the displayed name of this item.
        """
        pass
    @property
    def description(self) -> str:
        """
        Gets and sets the description information associated with this item.
        """
        return str()
    @property
    def parentFolder(self) -> DataFolder:
        """
        Returns the parent folder this item is contained within.
        """
        return DataFolder()
    @property
    def parentProject(self) -> DataProject:
        """
        Returns the parent project that this item is in.
        """
        return DataProject()
    @property
    def id(self) -> str:
        """
        Returns the unique ID for this DataFile. This is the same id used in the
        Forge Data Management API for an Item and is in the unencoded form and will
        look similar to this: "urn:adsk.wipprod:dm.lineage:hC6k4hndRWaeIVhIjvHu8w"
        """
        return str()
    @property
    def versionNumber(self) -> int:
        """
        Gets the version number of this DataFile.
        """
        return int()
    @property
    def versions(self) -> DataFiles:
        """
        Gets the other version of this item.
        """
        return DataFiles()
    @property
    def latestVersionNumber(self) -> int:
        """
        Gets the latest version number for this DataFile.
        """
        return int()
    @property
    def latestVersion(self) -> DataFile:
        """
        Returns the latest version of the DataFile. It can return a reference
        to the same DataFile is this DataFile is the latest version.
        """
        return DataFile()
    @property
    def fileExtension(self) -> str:
        """
        Gets the file extension for this data file. The file type can be inferred from this.
        """
        return str()
    @property
    def isInUse(self) -> bool:
        """
        Gets if this DataFile is currently in use (opened for edit) by any other user.
        """
        return bool()
    @property
    def inUseBy(self) -> list[User]:
        """
        Returns the array of users that are currently using (have open for edit) this data file.
        """
        return [User()]
    @property
    def createdBy(self) -> User:
        """
        Returns the User that created this data file.
        """
        return User()
    @property
    def lastUpdatedBy(self) -> User:
        """
        Returns the User that last updated this data file
        """
        return User()
    @property
    def hasOutofDateChildReferences(self) -> bool:
        """
        Gets if this datafile has Children (referenced components) that are out of date (not the latest version).
        """
        return bool()
    @property
    def hasChildReferences(self) -> bool:
        """
        Gets if this datafile has children, (i.e. a Fusion 360 Design containing referenced components).
        """
        return bool()
    @property
    def hasParentReferences(self) -> bool:
        """
        Gets if this datafile has parents, (i.e. this is a child being referenced in another Fusion 360 design).
        """
        return bool()
    @property
    def childReferences(self) -> DataFiles:
        """
        Returns a collection of DataFiles that are the children (referenced designs) this datafile references.
        """
        return DataFiles()
    @property
    def parentReferences(self) -> DataFiles:
        """
        Returns a collection DataFiles collection that are the parents (designs that reference) this datafile.
        """
        return DataFiles()
    @property
    def publicLink(self) -> str:
        """
        Returns a short url of this data file which can be shared with others.
        """
        return str()
    @property
    def dateCreated(self) -> int:
        """
        Returns the date when this data file was created as UNIX epoch time. UNIX epoch time
        is the number of seconds since January 1, 1970 (midnight UTC/GMT).
        
        In Python you can import the standard time module to work with UNIX epoch time.
        
        In C++ you can use functions in time.h and std::chrono to work with UNIX epoch time.
        """
        return int()
    @property
    def versionId(self) -> str:
        """
        Returns the version ID for this DataFile. This is the same id used in the
        Forge Data Management API for an Item and is in the unencoded form and will
        look similar to this: "urn:adsk.wipqa:fs.file:vf.W3syIw1lQAW-5vWObMdYnA?version=2"
        """
        return str()
    @property
    def isReadOnly(self) -> bool:
        """
        Gets if this file is currently read-only or not. A file can be read-only for various
        reasons. For example, if you are running with a "Fusion 360 for Personal Use license" and
        have not designate the file to be editable or if someone else is editing the file.
        """
        return bool()
    @property
    def isComplete(self) -> bool:
        """
        Returns if the DataFile is fully processed. This is especially useful when a new file is being saved or uploaded.
        The initial call to save or upload the file returns when the process has started but processing continues on the cloud.
        This property will return true when all of the processing has been completed and all information related to
        the Datafile is now available.
        """
        return bool()

class DataFileFuture(Base):
    """
    Used to check the state and get back the results of a file upload.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataFileFuture:
        return DataFileFuture()
    @property
    def dataFile(self) -> DataFile:
        """
        Returns the DataFile when the upload is complete (uplodeState returns UploadFinished).
        Returns null if the upload is still running or has failed.
        """
        return DataFile()
    @property
    def uploadState(self) -> UploadStates:
        """
        Returns the current state of the upload.
        """
        return UploadStates()

class DataFiles(Base):
    """
    Returns the items within a folder. This includes everything in a folder except for other folders.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataFiles:
        return DataFiles()
    def item(self, index: int) -> DataFile:
        """
        Returns the specified data file.
        index : The index of the file to return. The first file in the list has an index of 0.
        Returns the specified file or null if an invalid index was specified.
        """
        return DataFile()
    def itemById(self, id: str) -> DataFile:
        """
        Returns the file specified using the ID or version ID of the file.
        id : The ID or version ID of the file to return. This is the same ID used by
        the Forge Data Management API.
        Returns the file or null if a file with the specified ID is not found.
        """
        return DataFile()
    def asArray(self) -> list[DataFile]:
        """
        Get the current list of all files.
        Returns the current list of all files.
        """
        return [DataFile()]
    @property
    def count(self) -> int:
        """
        The number of data items in this collection.
        """
        return int()

class DataFolder(Base):
    """
    A data folder that contains a collection of data items.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataFolder:
        return DataFolder()
    def uploadFile(self, filename: str) -> DataFileFuture:
        """
        Uploads a single file to this directory.
        filename : The full filename of the file to upload.
        The upload process is asynchronous which means that this method
        will return before the upload process had completed. The returned
        DataFileFuture object can be used to check on the current state of the
        upload to determine if it is still uploading, is complete, or has failed.
        If it is complete the final DataFinal can be retrieved through the
        DataFileFuture object.
        """
        return DataFileFuture()
    def uploadAssembly(self, filenames: list[str]) -> DataFileFuture:
        """
        Uploads a set of files that represent an assembly There should only
        be a single top-level assembly file but there can be any number of other
        files that represent subassemblies.
        filenames : An array of strings that contains the list of all of the files that
        are part of the assembly. The name of the the top-level assembly file
        must be the first file in the array.
        The upload process is asynchronous which means that this method
        will return before the upload process had completed. The returned
        DataFileFuture object can be used to check on the current state of the
        upload to determine if it is still uploading, is complete, or has failed.
        If it is complete the final DataFinal can be retrieved through the
        DataFileFuture object.
        """
        return DataFileFuture()
    def deleteMe(self) -> bool:
        """
        Deletes this folder item.
        Returns true if the deletion was successful.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets and sets the displayed name of this folder.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the displayed name of this folder.
        """
        pass
    @property
    def dataFiles(self) -> DataFiles:
        """
        Returns a collection containing all of the items within this folder, excluding folders.
        Use the dataFolders property to get the folders.
        """
        return DataFiles()
    @property
    def dataFolders(self) -> DataFolders:
        """
        Returns a collection containing all of the folders within this folder.
        """
        return DataFolders()
    @property
    def parentFolder(self) -> DataFolder:
        """
        Returns the parent folder this folder is contained within. Returns null
        if this is the project's root folder.
        """
        return DataFolder()
    @property
    def parentProject(self) -> DataProject:
        """
        Returns the parent project that owns this folder.
        """
        return DataProject()
    @property
    def isRoot(self) -> bool:
        """
        Indicates if this folder is the root folder within the parent project.
        """
        return bool()
    @property
    def id(self) -> str:
        """
        Returns the unique ID for this folder. This is the same id used in the
        Forge Data Management API.
        """
        return str()

class DataFolders(Base):
    """
    Collection object the provides a list of data folders.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataFolders:
        return DataFolders()
    def item(self, index: int) -> DataFolder:
        """
        Returns the specified folder.
        index : The index of the folder to return. The first folder in the list has an index of 0.
        Returns the item or null if an invalid index was specified.
        """
        return DataFolder()
    def itemByName(self, name: str) -> DataFolder:
        """
        Returns the folder specified using the name of the folder.
        name : The name of the folder to return.
        Returns the folder or null if a folder of the specified name is not found.
        """
        return DataFolder()
    def itemById(self, id: str) -> DataFolder:
        """
        Returns the folder specified using the ID of the folder.
        id : The ID of the folder to return. This is the same ID used by
        the Forge Data Management API.
        Returns the folder or null if a folder with the specified ID is not found.
        """
        return DataFolder()
    def add(self, name: str) -> DataFolder:
        """
        Creates a new folder within the parent folder.
        name : The name of the folder. This must be unique with respect to the other folders within the parent folder.
        Returns the created DataFolder or null if the creation failed.
        """
        return DataFolder()
    def asArray(self) -> list[DataFolder]:
        """
        Get the current list of all folders.
        Returns the current list of all folders.
        """
        return [DataFolder()]
    @property
    def count(self) -> int:
        """
        The number of folders in this collection.
        """
        return int()

class DataHub(Base):
    """
    Represents a hub within the data.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataHub:
        return DataHub()
    @property
    def name(self) -> str:
        """
        Returns the name of the hub.
        """
        return str()
    @property
    def dataProjects(self) -> DataProjects:
        """
        Returns the projects within this hub.
        """
        return DataProjects()
    @property
    def hubType(self) -> HubTypes:
        """
        Gets if this hub is a Personal (PersonalHubType) or Team (TeamHubType) type hub.
        """
        return HubTypes()
    @property
    def id(self) -> str:
        """
        Returns the unique ID for this hub. This is the same id used in the
        Forge Data Management API in an unencoded form and will look something like
        this: "a.45637".
        """
        return str()

class DataHubs(Base):
    """
    Collection object that provides a list of all available hubs.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataHubs:
        return DataHubs()
    def item(self, index: int) -> DataHub:
        """
        Returns the specified hub.
        index : The index of the hub to return. The first hub in the list has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return DataHub()
    def itemById(self, id: str) -> DataHub:
        """
        Returns the hub specified using the ID of the hub.
        id : The ID of the hub to return. This is the same ID used by
        the Forge Data Management API.
        Returns the hub or null if a hub with the specified ID is not found.
        """
        return DataHub()
    def asArray(self) -> list[DataHub]:
        """
        Get the current list of all hubs.
        Returns the current list of all hubs.
        """
        return [DataHub()]
    @property
    def count(self) -> int:
        """
        The number of hubs in this collection.
        """
        return int()

class DataProject(Base):
    """
    Represents the master branch project within a hub.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataProject:
        return DataProject()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of the project.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of the project.
        """
        pass
    @property
    def rootFolder(self) -> DataFolder:
        """
        Returns the project's root folder. This provides access to all of the
        folders and the files in the top level of the project.
        """
        return DataFolder()
    @property
    def id(self) -> str:
        """
        Returns the unique ID for this project. This is the same id used in the
        Forge Data Management API in an unencoded form and will look something like
        this: "a.45637".
        """
        return str()
    @property
    def parentHub(self) -> DataHub:
        """
        Returns the parent DataHub of this project.
        """
        return DataHub()

class DataProjects(Base):
    """
    Collection object that provides a list of all available projects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataProjects:
        return DataProjects()
    def item(self, index: int) -> DataProject:
        """
        Returns the specified project.
        index : The index of the project to return. The first project in the list has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return DataProject()
    def add(self, name: str, purpose: str, contributors: str) -> DataProject:
        """
        Creates a new project in the parent hub.
        name : The name of the project. This is the name visible to the user.
        purpose : Optional description of the purpose of the project. An empty string can be used to not specify a purpose.
        contributors : Optional list of contributors where the list consists of email addresses separated by a comma.
        An empty string can be used to not specify any contributors.
        Returns the created DataProject object or null if the creation failed.
        """
        return DataProject()
    def itemById(self, id: str) -> DataProject:
        """
        Returns the project specified using the ID of the project.
        id : The ID of the project to return. This is the same ID used by
        the Forge Data Management API.
        Returns the project or null if a project with the specified ID is not found.
        """
        return DataProject()
    def asArray(self) -> list[DataProject]:
        """
        Get the current list of all projects.
        Returns the current list of all projects.
        """
        return [DataProject()]
    @property
    def count(self) -> int:
        """
        The number of projects in this collection.
        """
        return int()

class DefaultUnitsPreferences(Base):
    """
    The base class for the default units preference. There is a derived class
    supported by each product where the specific preference values are exposed.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DefaultUnitsPreferences:
        return DefaultUnitsPreferences()
    @property
    def name(self) -> str:
        """
        Returns the name of this DefaultUnitPreferences object.
        """
        return str()

class DefaultUnitsPreferencesCollection(Base):
    """
    A collection that provides access to product specific unit preference objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DefaultUnitsPreferencesCollection:
        return DefaultUnitsPreferencesCollection()
    def item(self, index: int) -> DefaultUnitsPreferences:
        """
        Function that returns the specified DefaultUnitPreferences object using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return DefaultUnitsPreferences()
    def itemByName(self, name: str) -> DefaultUnitsPreferences:
        """
        Returns the DefaultUnitsPreference object with the specified name.
        name : The name of the DefaultUnitsPreference to return.
        Returns the DefaultUnitsPreference object or null if if an invalid name was specified.
        """
        return DefaultUnitsPreferences()
    @property
    def count(self) -> int:
        """
        Returns the number of DefaultUnitsPreference objects.
        """
        return int()

class Document(Base):
    """
    Object that represents an open document. This is the base class for all document types.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Document:
        return Document()
    def activate(self) -> bool:
        """
        Causes this document to become the active document in the user interface.
        Returns true if the activation was successful.
        """
        return bool()
    def close(self, saveChanges: bool) -> bool:
        """
        Closes this document.
        saveChanges : This argument defines what the behavior of the close is when the document
        has been modified. If the document hasn't been modified then this argument
        is ignored and the document is closed. If the document has been modified
        and this argument is false then Fusion 360 will close the document and lose
        any changes. If the document has been modified and this argument is true then
        it will prompt the user if they want to save the changes or not, just the same
        as if the user was to interactively close the document.
        Returns true if closing the document was successful.
        """
        return bool()
    def save(self, description: str) -> bool:
        """
        Saves a version of the current document. You must use the SaveAs method the first
        time a document is saved. You can determine if a document has been saved by checking
        the value of the isSaved property.
        description : The version description for this document
        Returns true if saving the document was successful.
        """
        return bool()
    def saveAs(self, name: str, dataFolder: DataFolder, description: str, tag: str) -> bool:
        """
        Performs a Save As on this document. This saves the currently open document to the specified
        location and this document becomes the saved document. If this is a new document that has
        never been saved you must use the SaveAs method in order to specify the location and name. You
        can determine if the document has been saved by checking the value of the isSaved property.
        name : The name to use for this document. If this is an empty string, Fusion 360 will use the default name
        assigned when the document was created.
        dataFolder : The data folder to save this document to.
        description : The description string of the document. This can be an empty string.
        tag : The tag string of the document. This can be an empty string.
        Returns true if the save as was successful.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of the document.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of the document.
        """
        pass
    @property
    def isModified(self) -> bool:
        """
        Property that indicates if the document has been modified since it was last saved.
        """
        return bool()
    @property
    def isSaved(self) -> bool:
        """
        Property that indicates if this document has been saved or not. The initial save of
        a document requires that the name and location be specified and requires the saveAs method
        to be used. If the document has been saved then the save method can be used to save changes made.
        """
        return bool()
    @property
    def parent(self) -> Application:
        """
        Returns the parent Application object.
        """
        return Application()
    @property
    def products(self) -> Products:
        """
        Returns the products associated with this document.
        """
        return Products()
    @property
    def isActive(self) -> bool:
        """
        Gets if this document is the active document in the user interface.
        """
        return bool()
    @property
    def isVisible(self) -> bool:
        """
        Gets if a currently open document is open as visible.
        """
        return bool()
    @property
    def attributes(self) -> Attributes:
        """
        Returns the collection of attributes associated with this document.
        """
        return Attributes()
    @property
    def dataFile(self) -> DataFile:
        """
        Gets the DataFile that represents this document in A360.
        """
        return DataFile()
    @property
    def version(self) -> str:
        """
        Returns the Fusion 360 version this document was last saved with.
        """
        return str()
    @property
    def documentReferences(self) -> DocumentReferences:
        """
        Returns a collection containing the documents directly referenced
        by this document.
        """
        return DocumentReferences()
    @property
    def isUpToDate(self) -> bool:
        """
        Indicates if any references in the assembly are out of date. This is the API
        equivalent to the "Out of Date" notification displayed in the Quick Access Toolbar.
        """
        return bool()
    @property
    def allDocumentReferences(self) -> DocumentReferences:
        """
        Returns a collection containing all of the documents referenced directly
        by this document and those referenced by all sub-assemblies.
        """
        return DocumentReferences()
    @property
    def creationId(self) -> str:
        """
        Returns the creation ID of this document. When a new document is created, Fusion assigns it a
        creation ID that will remain constant for the life of the document. The ID that is assigned is unique.
        However, it's possible that more than one document can have the same ID. This happens in the case
        where a document is copied. In this case a new document is created but an existing document is copied.
        It's only when a new document is created that a creation ID is generated and assigned.
        
        Using this ID can be useful in cases where the save of a new document is started and you can use
        this ID to match the completion of the save operation on the cloud to the original document.
        """
        return str()

class DocumentEventHandler(EventHandler):
    """
    The DocumentEventHandler is a client implemented class that can be added as a handler to a
    DocumentEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DocumentEventHandler:
        return DocumentEventHandler()
    def notify(self, eventArgs: DocumentEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class DocumentReference(Base):
    """
    Represents a reference to a document from another document.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DocumentReference:
        return DocumentReference()
    def getLatestVersion(self) -> bool:
        """
        Updates the reference to use the latest version. This is only useful
        when the isOutOfDate property is true.
        Returns true if getting the latest version was successful.
        """
        return bool()
    @property
    def dataFile(self) -> DataFile:
        """
        The dataFile on A360 that this object references.
        """
        return DataFile()
    @property
    def referencedDocument(self) -> Document:
        """
        The document currently open in Fusion 360 that this object references.
        """
        return Document()
    @property
    def version(self) -> int:
        """
        Gets and sets the version of the dataFile on A360 that this document currently represents.
        Setting this property will cause all occurrences referencing this document to update to
        that version.
        """
        return int()
    @version.setter
    def version(self, value: int):
        """
        Gets and sets the version of the dataFile on A360 that this document currently represents.
        Setting this property will cause all occurrences referencing this document to update to
        that version.
        """
        pass
    @property
    def parentDocument(self) -> Document:
        """
        The document that is doing the referencing and owns this reference.
        """
        return Document()
    @property
    def isOutOfDate(self) -> bool:
        """
        Indicates if this reference is out of date, meaning that the reference
        is not referencing the latest version.
        """
        return bool()

class DocumentReferences(Base):
    """
    Provides access to the list of documents referenced from a document.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DocumentReferences:
        return DocumentReferences()
    def item(self, index: int) -> DocumentReference:
        """
        Returns the specified DocumentReference.
        index : The index of the object to return where the first one in the collection has an index of 0.
        Returns the specified DocumentReference or null if an invalid index was specified.
        """
        return DocumentReference()
    @property
    def count(self) -> int:
        """
        The number of DocumentReference objects in this collection.
        """
        return int()

class Documents(Base):
    """
    The Documents object provides access to all of the currently open documents and
    provides methods to create and open documents.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Documents:
        return Documents()
    def add(self, documentType: DocumentTypes, visible: bool, options: NamedValues) -> Document:
        """
        Creates and opens a new document of the specified type.
        documentType : A value from the DocumentTypes enum that specifies the type of document to create.
        visible : Optional argument specifying is the document should be visible or not. Currently, documents can only
        be created visibly so this argument must always be true.
        options : Various options that are supported that are specific to the document type. See the documentation
        for the DocumentTypes enum for information about the options supported for the various types.
        Returns the created document
        """
        return Document()
    def item(self, index: int) -> Document:
        """
        Function that returns the specified document using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Document()
    def open(self, dataFile: DataFile, visible: bool) -> Document:
        """
        Opens an item that has previously been saved.
        dataFile : The item to open.
        visible : Specifies if the document should be opened visibly or not. Currently, documents can only
        be opened visibly so this argument must always be true.
        Returns the open document or null if the open failed.
        """
        return Document()
    @property
    def count(self) -> int:
        """
        Returns the number of currently open files.
        """
        return int()

class Event(Base):
    """
    Objects can have several Event properties that fire when
    some 'event' occurs. Clients can attach EventHandlers
    to one or more Events and they get notified when the 'event' occurs.
    
    This is a base class - classes like DocumentEvent add type safety
    (i.e. only allow the correct type of handler to be added to them).
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Event:
        return Event()
    @property
    def name(self) -> str:
        """
        The name of the event - e.g. "DocumentOpening"
        """
        return str()
    @property
    def sender(self) -> Base:
        """
        The object that is firing the event. For example, in the case of a command
        input event this will return the command.
        """
        return Base()

class EventArgs(Base):
    """
    When an event handler is called, it is passed
    an EventArgs object that describes the 'event'.
    This is a base class - classes like DocumentEventArgs add more information on
    the 'event'.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> EventArgs:
        return EventArgs()
    @property
    def firingEvent(self) -> Event:
        """
        The event that the firing is in response to.
        """
        return Event()

class FavoriteAppearances(Base):
    """
    Collection of the favorite appearances.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FavoriteAppearances:
        return FavoriteAppearances()
    def item(self, index: int) -> Appearance:
        """
        Returns the specified Appearance using an index into the collection.
        index : The index of the appearance to return where the first item in the collection is 0.
        Returns the specified appearance or null if an invalid index is specified.
        """
        return Appearance()
    def itemByName(self, name: str) -> Appearance:
        """
        Returns the specified appearance using the name as seen in the user interface. This often isn't
        a reliable way of accessing a specific appearance because appearances are not required to be unique.
        name : The name of the appearance to return,.
        Returns the specified appearance or null if there isn't a matching name.
        """
        return Appearance()
    def itemById(self, id: str) -> Appearance:
        """
        Returns the Appearance by it's internal unique ID.
        id : The ID of the appearance to return.
        Returns the specified appearance or null if there isn't a matching ID.
        """
        return Appearance()
    def add(self, appearance: Appearance) -> Appearance:
        """
        Adds an existing appearance to the Favorites list
        appearance : The appearance to be added to the favorites list. This can come from a Library or from a Design.
        Returns the Appearance added to the favorites list or null if the operation failed.
        """
        return Appearance()
    @property
    def count(self) -> int:
        """
        The number of Appearances in the collection.
        """
        return int()

class FavoriteMaterials(Base):
    """
    Collection of the favorite materials.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FavoriteMaterials:
        return FavoriteMaterials()
    def item(self, index: int) -> Material:
        """
        Returns the specified Material using an index into the collection.
        index : The index of the material to return where the first item in the collection is 0.
        Returns the specified material or null if an invalid index is specified.
        """
        return Material()
    def itemByName(self, name: str) -> Material:
        """
        Returns the specified Material using the name as seen in the user interface. This often isn't
        a reliable way of accessing a specific material because materials are not required to be unique.
        name : The name of the material to return,.
        Returns the specified material or null if there isn't a matching name.
        """
        return Material()
    def itemById(self, id: str) -> Material:
        """
        Returns the Material by it's internal unique ID.
        id : The ID of the material to return.
        Returns the specified material or null if there isn't a matching ID.
        """
        return Material()
    def add(self, material: Material) -> Material:
        """
        Adds an existing material to the Favorites list
        material : The material to be added to the favorites list. This can come from a Library or from a Design.
        Returns the Material added to the favorites list or null if the operation failed.
        """
        return Material()
    @property
    def count(self) -> int:
        """
        The number of Materials in the collection.
        """
        return int()

class FileDialog(Base):
    """
    Provides access to a file dialog. A file dialog can be used to prompt the user
    for file names to open or save to.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FileDialog:
        return FileDialog()
    def showOpen(self) -> DialogResults:
        """
        Displays a modal open dialog, allowing the user to select one or more files. The return value
        can be used to determine if the dialog was canceled without selecting a file. The Filename
        and Filenames properties can be used to get the selected files.
        Returns an enum value indicating which button was clicked on the dialog.
        """
        return DialogResults()
    def showSave(self) -> DialogResults:
        """
        Displays a modal save dialog, allowing the user to specify a file. The return value
        can be used to determine if the dialog was canceled without selecting a file. The Filename
        and Filenames properties can be used to get the selected files.
        Returns an enum value indicating which button was clicked on the dialog.
        """
        return DialogResults()
    @property
    def title(self) -> str:
        """
        Gets or sets the title displayed on the dialog.
        """
        return str()
    @title.setter
    def title(self, value: str):
        """
        Gets or sets the title displayed on the dialog.
        """
        pass
    @property
    def filename(self) -> str:
        """
        Gets the filename specified by the user in the dialog. This property is
        used after the ShowOpen or ShowSave methods have been called to retrieve
        the filename specified by the user. The file name includes both the
        file path and the extension.
        
        If ShowOpen was used and IsMultiSelectEnabled is true, then this property will
        only display the first filename selected and the Filenames property should be
        used instead to retrieved the full list. Is ShowSave was used, then only a
        single file name is ever returned.
        """
        return str()
    @property
    def filenames(self) -> list[str]:
        """
        Gets the filenames specified by the user in the dialog. This property is
        used after the ShowOpen or ShowSave methods have been called to retrieve
        the filenames specified by the user. Each file name includes both the
        file path and the extension.
        
        If ShowOpen is used and IsMultiSelectEnabled is true, the user is able to select
        more than one file. This property returns all of the files that were selected. If
        ShowSave is used or IsMultiSelectEnabled is false then this array will contain
        the single file name.
        """
        return [str()]
    @property
    def filter(self) -> str:
        """
        Gets or sets the current file name filter string, which determines the choices
        that appear in the "Save as file type" or "Files of type" box in the dialog box.
        
        For each filtering option, the filter string contains a description of the filter
        and the filter pattern as specified in parentheses and separated by semi-colons. Multiple
        filters are separated by a double semi-colon. These are illustrated below.
        
        The following is an example of a filter string:
        
        Text files (*.txt);;All files (*.*)
        
        You can add several filter patterns to a filter by separating the file types with semicolons, for example:
        
        Image Files (*.BMP;*.JPG;*.GIF);;All files (*.*)
        """
        return str()
    @filter.setter
    def filter(self, value: str):
        """
        Gets or sets the current file name filter string, which determines the choices
        that appear in the "Save as file type" or "Files of type" box in the dialog box.
        
        For each filtering option, the filter string contains a description of the filter
        and the filter pattern as specified in parentheses and separated by semi-colons. Multiple
        filters are separated by a double semi-colon. These are illustrated below.
        
        The following is an example of a filter string:
        
        Text files (*.txt);;All files (*.*)
        
        You can add several filter patterns to a filter by separating the file types with semicolons, for example:
        
        Image Files (*.BMP;*.JPG;*.GIF);;All files (*.*)
        """
        pass
    @property
    def filterIndex(self) -> int:
        """
        Gets or sets the index of the filter currently selected in the file dialog box. Use the FilterIndex
        property to set which filtering option is shown first to the user. You can also use the value of
        FilterIndex after showing the file dialog to perform special file operations depending upon the filter chosen.
        The first item in the filter list is index 0.
        """
        return int()
    @filterIndex.setter
    def filterIndex(self, value: int):
        """
        Gets or sets the index of the filter currently selected in the file dialog box. Use the FilterIndex
        property to set which filtering option is shown first to the user. You can also use the value of
        FilterIndex after showing the file dialog to perform special file operations depending upon the filter chosen.
        The first item in the filter list is index 0.
        """
        pass
    @property
    def initialDirectory(self) -> str:
        """
        Gets or sets the initial directory displayed by the file dialog box.
        """
        return str()
    @initialDirectory.setter
    def initialDirectory(self, value: str):
        """
        Gets or sets the initial directory displayed by the file dialog box.
        """
        pass
    @property
    def isMultiSelectEnabled(self) -> bool:
        """
        Gets or sets a value indicating whether the dialog box allows multiple files to be selected.
        """
        return bool()
    @isMultiSelectEnabled.setter
    def isMultiSelectEnabled(self, value: bool):
        """
        Gets or sets a value indicating whether the dialog box allows multiple files to be selected.
        """
        pass
    @property
    def initialFilename(self) -> str:
        """
        Gets or sets the initial filename displayed when the dialog is first displayed.
        When a new FileDialog object is created this defaults to an empty string so no
        initial filename is specified.
        
        If the showOpen option is used, the file must
        already exist in the directory specified by the initialDirectory property. If
        it doesn't exist, the initial filename will not be used.
        """
        return str()
    @initialFilename.setter
    def initialFilename(self, value: str):
        """
        Gets or sets the initial filename displayed when the dialog is first displayed.
        When a new FileDialog object is created this defaults to an empty string so no
        initial filename is specified.
        
        If the showOpen option is used, the file must
        already exist in the directory specified by the initialDirectory property. If
        it doesn't exist, the initial filename will not be used.
        """
        pass

class FolderDialog(Base):
    """
    Provides access to a folder selection dialog to allow the user to select a folder.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FolderDialog:
        return FolderDialog()
    def showDialog(self) -> DialogResults:
        """
        Displays a modal dialog allowing the user to select a folder. The return value
        can be used to determine if the dialog was canceled without selecting a folder.
        the folder property can be used to get the selected folder.
        Returns an enum value indicating which button was clicked on the dialog.
        """
        return DialogResults()
    @property
    def title(self) -> str:
        """
        Gets or sets the title displayed on the dialog.
        """
        return str()
    @title.setter
    def title(self, value: str):
        """
        Gets or sets the title displayed on the dialog.
        """
        pass
    @property
    def folder(self) -> str:
        """
        Gets the folder selected by the user in the dialog. This property is
        used after the ShowDialog method has been called to retrieve the folder
        specified by the user.
        """
        return str()
    @property
    def initialDirectory(self) -> str:
        """
        Gets or sets the initial directory displayed by the file dialog box.
        """
        return str()
    @initialDirectory.setter
    def initialDirectory(self, value: str):
        """
        Gets or sets the initial directory displayed by the file dialog box.
        """
        pass

class GeneralPreferences(Base):
    """
    Provides access to the general preferences.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> GeneralPreferences:
        return GeneralPreferences()
    @property
    def userLanguage(self) -> UserLanguages:
        """
        Gets and sets the current language. Setting the language does not
        take effect until the next time Fusion 360 is started.
        """
        return UserLanguages()
    @userLanguage.setter
    def userLanguage(self, value: UserLanguages):
        """
        Gets and sets the current language. Setting the language does not
        take effect until the next time Fusion 360 is started.
        """
        pass
    @property
    def offlineCachePeriod(self) -> float:
        """
        Gets and sets the length of time, in days, that the offline cache of a document will remain.
        """
        return float()
    @offlineCachePeriod.setter
    def offlineCachePeriod(self, value: float):
        """
        Gets and sets the length of time, in days, that the offline cache of a document will remain.
        """
        pass
    @property
    def graphicsDriver(self) -> GraphicsDrivers:
        """
        Gets and sets the graphics driver used to display the graphics.
        """
        return GraphicsDrivers()
    @graphicsDriver.setter
    def graphicsDriver(self, value: GraphicsDrivers):
        """
        Gets and sets the graphics driver used to display the graphics.
        """
        pass
    @property
    def isAutomaticSaveOnCloseEnabled(self) -> bool:
        """
        Gets and sets if the file is automatically saved on close.
        """
        return bool()
    @isAutomaticSaveOnCloseEnabled.setter
    def isAutomaticSaveOnCloseEnabled(self, value: bool):
        """
        Gets and sets if the file is automatically saved on close.
        """
        pass
    @property
    def isAutomaticVersioningEnabled(self) -> bool:
        """
        Gets and sets if a version of the file is automatically saved using a background thread.
        """
        return bool()
    @isAutomaticVersioningEnabled.setter
    def isAutomaticVersioningEnabled(self, value: bool):
        """
        Gets and sets if a version of the file is automatically saved using a background thread.
        """
        pass
    @property
    def automateVersioningTimeInterval(self) -> int:
        """
        Gets and sets the interval, in minutes, for automatic versioning.
        """
        return int()
    @automateVersioningTimeInterval.setter
    def automateVersioningTimeInterval(self, value: int):
        """
        Gets and sets the interval, in minutes, for automatic versioning.
        """
        pass
    @property
    def defaultModelingOrientation(self) -> DefaultModelingOrientations:
        """
        Gets and sets the default for which direction is considered "up".
        """
        return DefaultModelingOrientations()
    @defaultModelingOrientation.setter
    def defaultModelingOrientation(self, value: DefaultModelingOrientations):
        """
        Gets and sets the default for which direction is considered "up".
        """
        pass
    @property
    def areTooltipsShown(self) -> bool:
        """
        Gets and sets if tooltips are shown.
        """
        return bool()
    @areTooltipsShown.setter
    def areTooltipsShown(self, value: bool):
        """
        Gets and sets if tooltips are shown.
        """
        pass
    @property
    def isCommandPromptShown(self) -> bool:
        """
        Gets and sets if the command prompt is shown.
        """
        return bool()
    @isCommandPromptShown.setter
    def isCommandPromptShown(self, value: bool):
        """
        Gets and sets if the command prompt is shown.
        """
        pass
    @property
    def areTipsAndTricksShown(self) -> bool:
        """
        Gets and sets if in command tips and tricks are shown.
        """
        return bool()
    @areTipsAndTricksShown.setter
    def areTipsAndTricksShown(self, value: bool):
        """
        Gets and sets if in command tips and tricks are shown.
        """
        pass
    @property
    def areInCommandErrorsAndWarningsShown(self) -> bool:
        """
        Gets and sets if in command errors and warnings are shown.
        """
        return bool()
    @areInCommandErrorsAndWarningsShown.setter
    def areInCommandErrorsAndWarningsShown(self, value: bool):
        """
        Gets and sets if in command errors and warnings are shown.
        """
        pass
    @property
    def areAutodesk360NotificationsShown(self) -> bool:
        """
        Gets and sets if Autodesk 360 notifications are shown.
        """
        return bool()
    @areAutodesk360NotificationsShown.setter
    def areAutodesk360NotificationsShown(self, value: bool):
        """
        Gets and sets if Autodesk 360 notifications are shown.
        """
        pass
    @property
    def isGestureBasedViewNavigationUsed(self) -> bool:
        """
        Gets and sets if gesture based view navigation is used.
        """
        return bool()
    @isGestureBasedViewNavigationUsed.setter
    def isGestureBasedViewNavigationUsed(self, value: bool):
        """
        Gets and sets if gesture based view navigation is used.
        """
        pass
    @property
    def isZoomDirectionReversed(self) -> bool:
        """
        Gets and sets if the direction of the zoom is reversed.
        """
        return bool()
    @isZoomDirectionReversed.setter
    def isZoomDirectionReversed(self, value: bool):
        """
        Gets and sets if the direction of the zoom is reversed.
        """
        pass
    @property
    def isCameraPivotEnabled(self) -> bool:
        """
        Gets and sets if zoom and orbit commands use camera pivot point for transition.
        """
        return bool()
    @isCameraPivotEnabled.setter
    def isCameraPivotEnabled(self, value: bool):
        """
        Gets and sets if zoom and orbit commands use camera pivot point for transition.
        """
        pass
    @property
    def defaultOrbit(self) -> DefaultOrbits:
        """
        Get and sets the type of orbit.
        """
        return DefaultOrbits()
    @defaultOrbit.setter
    def defaultOrbit(self, value: DefaultOrbits):
        """
        Get and sets the type of orbit.
        """
        pass

class GraphicsPreferences(Base):
    """
    The GraphicsPreferences object provides access to the various graphics related preferences.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> GraphicsPreferences:
        return GraphicsPreferences()
    @property
    def minimumFramesPerSecond(self) -> float:
        """
        Gets and sets the minimum frames per second.
        """
        return float()
    @minimumFramesPerSecond.setter
    def minimumFramesPerSecond(self, value: float):
        """
        Gets and sets the minimum frames per second.
        """
        pass
    @property
    def selectionDisplayStyle(self) -> SelectionDisplayStyles:
        """
        Gets and sets the style of display to use for selections.
        """
        return SelectionDisplayStyles()
    @selectionDisplayStyle.setter
    def selectionDisplayStyle(self, value: SelectionDisplayStyles):
        """
        Gets and sets the style of display to use for selections.
        """
        pass
    @property
    def degradedSelectionDisplayStyle(self) -> DegradedSelectionDisplayStyles:
        """
        Gets and sets the style of display for degraded selections.
        """
        return DegradedSelectionDisplayStyles()
    @degradedSelectionDisplayStyle.setter
    def degradedSelectionDisplayStyle(self, value: DegradedSelectionDisplayStyles):
        """
        Gets and sets the style of display for degraded selections.
        """
        pass
    @property
    def transparencyEffects(self) -> TransparencyDisplayEffects:
        """
        Gets and sets the style of display for transparency effects.
        """
        return TransparencyDisplayEffects()
    @transparencyEffects.setter
    def transparencyEffects(self, value: TransparencyDisplayEffects):
        """
        Gets and sets the style of display for transparency effects.
        """
        pass
    @property
    def autoThrottleEffects(self) -> bool:
        """
        Gets and sets if automatically disable or degrade visual effects to keep the video memory pressure under a safe threshold.
        """
        return bool()
    @autoThrottleEffects.setter
    def autoThrottleEffects(self, value: bool):
        """
        Gets and sets if automatically disable or degrade visual effects to keep the video memory pressure under a safe threshold.
        """
        pass
    @property
    def hiddenEdgeDimming(self) -> int:
        """
        Gets and sets the dimming percentage to use for hidden edges.
        the value is a percentage expressed by a value between 0 and 100.
        """
        return int()
    @hiddenEdgeDimming.setter
    def hiddenEdgeDimming(self, value: int):
        """
        Gets and sets the dimming percentage to use for hidden edges.
        the value is a percentage expressed by a value between 0 and 100.
        """
        pass

class GridPreferences(Base):
    """
    The GridPreferences object provides access to grid related preferences.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> GridPreferences:
        return GridPreferences()
    @property
    def isLayoutGridLockEnabled(self) -> bool:
        """
        Gets and sets if the layout grid lock is enabled.
        """
        return bool()
    @isLayoutGridLockEnabled.setter
    def isLayoutGridLockEnabled(self, value: bool):
        """
        Gets and sets if the layout grid lock is enabled.
        """
        pass

class HTMLEventHandler(EventHandler):
    """
    The HTMLEventHandler is a client implemented class that can be added as a handler to a HTML
    event which is triggered by JavaScript that associated with HTML displayed within a palette
    calling the adsk.fusionSendData function to send data from the HTML back to your add-in.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> HTMLEventHandler:
        return HTMLEventHandler()
    def notify(self, eventArgs: HTMLEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class ImportManager(Base):
    """
    Provides access to functionality to support importing various modeling formats into Fusion 360.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ImportManager:
        return ImportManager()
    def createIGESImportOptions(self, filename: str) -> IGESImportOptions:
        """
        Creates an IGESImportOptions object that is used to import a design from IGES format. Creation
        of the IGESImportOptions object does not perform the import. You must pass this object to one of the
        ImportManager import methods to perform the import. The IGESImportOptions supports any available
        options when importing from IGES format.
        filename : The filename or URL of the IGES file to be imported.
        The created IGESImportOptions object or null if the creation failed.
        """
        return IGESImportOptions()
    def createSTEPImportOptions(self, filename: str) -> STEPImportOptions:
        """
        Creates an STEPImportOptions object that's used to import a design from STEP format. Creation
        of the STEPImportOptions object does not perform the import. You must pass this object to one of the
        ImportManager import methods to perform the import. The STEPImportOptions supports any available
        options when importing from STEP format.
        filename : The filename or URL of the STEP file to be imported.
        The created STEPImportOptions object or null if the creation failed.
        """
        return STEPImportOptions()
    def createSATImportOptions(self, filename: str) -> SATImportOptions:
        """
        Creates an SATImportOptions object that's used to import a design from SAT format. Creation
        of the SATImportOptions object does not perform the import. You must pass this object to one of the
        ImportManager import methods to perform the import. The SATImportOptions supports any available
        options when importing from SAT format.
        filename : The filename or URL of the SAT file to be imported.
        The created SATImportOptions object or null if the creation failed.
        """
        return SATImportOptions()
    def createSMTImportOptions(self, filename: str) -> SMTImportOptions:
        """
        Creates an SMTImportOptions object that's used to import a design from SMT format. Creation
        of the SMTImportOptions object does not perform the import. You must pass this object to one of the
        ImportManager import methods to perform the import. The SMTImportOptions supports any available
        options when importing from SMT format.
        filename : The filename or URL of the SMT file to be imported.
        The created SMTImportOptions object or null if the creation failed.
        """
        return SMTImportOptions()
    def createFusionArchiveImportOptions(self, filename: str) -> FusionArchiveImportOptions:
        """
        Creates an FusionArchiveImportOptions object that is used to import a design from a Fusion 360 archive format. Creation
        of the FusionArchiveImportOptions object does not perform the import. You must pass this object to one of the
        ImportManager import methods to perform the import. The FusionArchiveImportOptions supports any available
        options when importing from Fusion 360 archive format.
        filename : The filename or URL of the Fusion 360 archive file to be imported.
        .f3z files and .f3d files containing externally referenced designs are currently not supported.
        The created FusionArchiveImportOptions object or null if the creation failed.
        """
        return FusionArchiveImportOptions()
    def importToNewDocument(self, importOptions: ImportOptions) -> Document:
        """
        Executes the import operation to import a file (of the format specified by the input ImportOptions object)
        to a new document.
        ***This method does not currently support the DXF2DImportOptions ImportOptions object.***
        importOptions : An ImportOptions object that is created using one of the create methods on the ImportManager object. This
        defines the type of file and any available options supported for that file type.
        Returns the newly created Document object or null if the creation failed.
        A new unnamed, unsaved document will be opened in Fusion 360 as a result.
        """
        return Document()
    def importToTarget(self, importOptions: ImportOptions, target: Base) -> bool:
        """
        Executes the import operation to import a file (of the format specified by the input ImportOptions object)
        into an existing component in an existing design.
        importOptions : An ImportOptions object that is created using one of the create methods on the ImportManager object. This
        defines the type of file and any available options supported for that file type.
        Supplying a DXF2DImportOptions object will result in the creation of one or more sketches
        (depending on the layers in the DXF file) in the target component.
        target : Currently supports importing to a Fusion 360 Component.
        Returns true if the import was successful.
        """
        return bool()
    def createDXF2DImportOptions(self, filename: str, planarEntity: Base) -> DXF2DImportOptions:
        """
        Creates a DXF2DImportOptions object that is used to import 2D data to create sketches. Creation
        of the createDXF2DImportOptions object does not perform the import. You must pass this object to the
        ImportManager.importToTarget method to perform the import. The sketches created as a result of
        the import are available through the 'results' property of the DXF2DImportOptions.
        filename : The filename of the DXF file to be imported.
        planarEntity : The construction plane or planar face that defines the plane that the resulting sketches will
        be created on.
        The created DXF2DImportOptions object or null if the creation failed.
        """
        return DXF2DImportOptions()
    def importToTarget2(self, importOptions: ImportOptions, target: Base) -> ObjectCollection:
        """
        Executes the import operation to import a file (of the format specified by the input ImportOptions object)
        into an existing component in an existing design and returns the imported objects.
        importOptions : An ImportOptions object that is created using one of the create methods on the ImportManager object. This
        defines the type of file and any available options supported for that file type.
        Supplying a DXF2DImportOptions object will result in the creation of one or more sketches
        (depending on the layers in the DXF file) in the target component.
        target : Currently supports importing to a Fusion 360 Component.
        Returns an ObjectCollection containing the results of whatever was created as a result of the import.
        null is returned in the case of failure.
        """
        return ObjectCollection()

class ImportOptions(Base):
    """
    The base class for the different import types. This class is never directly used
    in an import because you need the specific import type to specify the type of
    import to be performed.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ImportOptions:
        return ImportOptions()
    @property
    def filename(self) -> str:
        """
        Gets and sets the filename or url of the file to be imported.
        """
        return str()
    @filename.setter
    def filename(self, value: str):
        """
        Gets and sets the filename or url of the file to be imported.
        """
        pass
    @property
    def isViewFit(self) -> bool:
        """
        Specifies if the camera should be adjusted to fit the geometry of the import.
        This defaults to true, which will cause a change in the current view. Setting this
        to false will leave the view as-is and just import the geometry.
        """
        return bool()
    @isViewFit.setter
    def isViewFit(self, value: bool):
        """
        Specifies if the camera should be adjusted to fit the geometry of the import.
        This defaults to true, which will cause a change in the current view. Setting this
        to false will leave the view as-is and just import the geometry.
        """
        pass

class InputChangedEventHandler(EventHandler):
    """
    An event handler base class that a client derives from to handle events triggered by a InputChangedEvent.
    A client implemented instance of this class can be added to a InputChangedEvent to receive these event notifications.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> InputChangedEventHandler:
        return InputChangedEventHandler()
    def notify(self, eventArgs: InputChangedEventArgs) -> None:
        """
        This notify member is called when an event is triggered from any event that this handler has been added to.
        eventArgs : The arguments object with details about this event and the firing InputChangedEvent.
        """
        pass

class KeyboardEventHandler(EventHandler):
    """
    An event handler base class that a client derives from to handle events triggered by a KeyboardEvent.
    A client implemented instance of this class can be added to a KeyboardEvent to receive these event notifications.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> KeyboardEventHandler:
        return KeyboardEventHandler()
    def notify(self, eventArgs: KeyboardEventArgs) -> None:
        """
        This notify member is called when an event is triggered from any event that this handler has been added to.
        eventArgs : The arguments object with details about this event and the firing KeyboardEvent.
        """
        pass

class LinearMarkingMenu(Base):
    """
    Represents the linear marking menu which is the vertical menu that's displayed when the user right-clicks
    within Fusion 360. This supports customizing the contents of the context menu.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> LinearMarkingMenu:
        return LinearMarkingMenu()
    def clear(self) -> bool:
        """
        Completely clears the contents of the context menu. If left in this state, the
        context menu will not be displayed.
        Returns true if the clear was successful.
        """
        return bool()
    @property
    def controls(self) -> ToolbarControls:
        """
        Return the collection of top-level controls in the context menu. It's possible to have
        drop-down controls (fly-outs) that provide access to additional controls. You can
        remove and add controls to customize the contents of the context menu.
        """
        return ToolbarControls()

class ListItem(Base):
    """
    Represents a single item in a check box list or a drop-down command input.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ListItem:
        return ListItem()
    def deleteMe(self) -> bool:
        """
        Deletes this item from the list. In cases where there is the concept of active item in the
        list, like with a DropDownCommandInput, this method will fail if the item you're attempting
        to delete is currently active. You need to make another item active first, and then you can
        delete the item.
        Returns true if the delete was successful.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets or sets the name of this item as displayed in the list. If
        this control is a separator (isSeparator is true) or it's a button row,
        setting this property is ignored and getting it will return an empty string.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets or sets the name of this item as displayed in the list. If
        this control is a separator (isSeparator is true) or it's a button row,
        setting this property is ignored and getting it will return an empty string.
        """
        pass
    @property
    def icon(self) -> str:
        """
        Gets or sets the location for the icon file used for this item in the list.
        This is the path to a directory that contains the image files associated
        with this item. This is only valid when this is a standard list or button row and is
        ignored for check box lists, radio control lists, and radio button groups.
        """
        return str()
    @icon.setter
    def icon(self, value: str):
        """
        Gets or sets the location for the icon file used for this item in the list.
        This is the path to a directory that contains the image files associated
        with this item. This is only valid when this is a standard list or button row and is
        ignored for check box lists, radio control lists, and radio button groups.
        """
        pass
    @property
    def isSelected(self) -> bool:
        """
        Gets or sets whether this item is selected. If the item is
        being displayed as a check box, this controls whether it is
        checked or not. If it's a drop-down list or button row it controls whether
        this is the single selected item. Setting a drop-down list, button row item, or radio button
        from a group to be selected will unselect the currently selected item.
        For a standard list, this will get or set the single item currently
        selected. For a separator, setting this property is ignored and
        it will always return false.
        """
        return bool()
    @isSelected.setter
    def isSelected(self, value: bool):
        """
        Gets or sets whether this item is selected. If the item is
        being displayed as a check box, this controls whether it is
        checked or not. If it's a drop-down list or button row it controls whether
        this is the single selected item. Setting a drop-down list, button row item, or radio button
        from a group to be selected will unselect the currently selected item.
        For a standard list, this will get or set the single item currently
        selected. For a separator, setting this property is ignored and
        it will always return false.
        """
        pass
    @property
    def index(self) -> int:
        """
        Gets the index position within the list of this item.
        """
        return int()
    @property
    def parentList(self) -> Base:
        """
        Gets the parent CheckBoxListControlDefinition or object.
        """
        return Base()
    @property
    def isSeparator(self) -> bool:
        """
        Gets if this control is a separator.
        """
        return bool()

class ListItems(Base):
    """
    Provides access to the list of items in a check box list. This object supports the ability to add
    items to the list and iterate through the existing items.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ListItems:
        return ListItems()
    def add(self, name: str, isSelected: bool, icon: str, beforeIndex: int) -> ListItem:
        """
        Adds a new item to the list.
        name : The name of this item as it is displayed in the list.
        isSelected : Sets whether this item is selected or not. If this list is associated with a control
        or input that can only have one item selected any other selected items will be unselected
        and this one will be the only selected item.
        icon : The path to the folder containing the image files to use for the icon. This is an optional
        argument but is required in the case of ButtonRowCommandInput objects. It is optional in
        the case of a DropDownCommandInput whose style is LabeledIconDropDownStyle and for
        ListControlType whose type is not RadioButtonListType. In other cases it is not used and
        is ignored.
        beforeIndex : The position of the item within the list. This value indicates the index of the current
        item to insert this new item just before. For example, a value of 0 will insert it before
        the first item in the list. An index of -1 will position the button at the bottom of the list.
        Returns the new ListControlItem or null in the case of a failure.
        """
        return ListItem()
    def addSeparator(self, beforeIndex: int) -> ListItem:
        """
        Adds a separator to the list. This is not supported for button rows.
        beforeIndex : The position of the item within the list. This value indicates the index of the current
        item to insert this new item just before. For example, a value of 0 will insert it before
        the first item in the list. An index of -1 will position the button at the bottom of the list.
        Returns the new ListControlItem or null in the case of a failure.
        """
        return ListItem()
    def item(self, index: int) -> ListItem:
        """
        Returns the specified check box list item using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ListItem()
    def clear(self) -> bool:
        """
        Clears all of the items from the list.
        Returns true if successful.
        """
        return bool()
    @property
    def count(self) -> int:
        """
        Gets the number of items in the collection.
        """
        return int()

class MarkingMenuEventHandler(EventHandler):
    """
    The MarkingMenuEventHandler is a client implemented class that can be added as a handler to a
    MarkingMenuEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MarkingMenuEventHandler:
        return MarkingMenuEventHandler()
    def notify(self, eventArgs: MarkingMenuEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class Material(Base):
    """
    A material.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Material:
        return Material()
    def deleteMe(self) -> bool:
        """
        Deletes the material from the Design. This method only applies to materials
        in a Design that are unused
        Returns true if the delete was successful.
        """
        return bool()
    def copyTo(self, target: Base) -> Material:
        """
        Copies this material to the specified target.
        ***Depricated Method: Use the addByCopyMethod on the Materials object instead, where you can rename the copied Material***
        target : The target can be a Design or MaterialFavorites object.
        Returns the new copy of the material or null if the copy failed.
        """
        return Material()
    @property
    def appearance(self) -> Appearance:
        """
        Gets the Appearance of this material.
        """
        return Appearance()
    @property
    def id(self) -> str:
        """
        Returns the unique internal ID of this material.
        """
        return str()
    @property
    def isUsed(self) -> bool:
        """
        Returns true if this material is used in the Design
        """
        return bool()
    @property
    def materialProperties(self) -> Properties:
        """
        Returns the collection of material properties associated with this material.
        """
        return Properties()
    @property
    def name(self) -> str:
        """
        Returns the name of this Material. This is the name of the material as seen in the user interface.
        The name can only be edited if the material is in a Design or the favorites list.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Returns the name of this Material. This is the name of the material as seen in the user interface.
        The name can only be edited if the material is in a Design or the favorites list.
        """
        pass
    @property
    def parent(self) -> Base:
        """
        Returns the Parent object (a Library or a Design).
        """
        return Base()

class MaterialLibraries(Base):
    """
    The MaterialLibraries collection object provides access to
    currently loaded Material and Appearance libraries
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MaterialLibraries:
        return MaterialLibraries()
    def item(self, index: int) -> MaterialLibrary:
        """
        Method that returns the specified Material Library using an index into the collection.
        index : The index of the item within the collection. The first item has an index of 0.
        Returns the specified material library or null if an invalid index was specified.
        """
        return MaterialLibrary()
    def itemByName(self, name: str) -> MaterialLibrary:
        """
        Returns the specified Material Library using the name as seen in the user interface.
        name : The name of the library to return.
        Returns the specified material library or null if there's no match on the name.
        """
        return MaterialLibrary()
    def itemById(self, id: str) -> MaterialLibrary:
        """
        Returns the Material Library at the specified ID.
        id : The ID of the library to return.
        Returns the specified material library or null if there's no match on the ID.
        """
        return MaterialLibrary()
    def load(self, filename: str) -> MaterialLibrary:
        """
        Loads the specified existing local material library. Fusion 360 remembers which libraries have
        been loaded from one session to the next so you should check to see if the local library
        is already loaded or not before loading it again.
        filename : The full filename of the .adsklib material file.
        Returns the MaterialLibrary object representing the opened library or null in the case of failure.
        """
        return MaterialLibrary()
    @property
    def count(self) -> int:
        """
        The number of Material Libraries in the collection.
        """
        return int()

class MaterialLibrary(Base):
    """
    A material library.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MaterialLibrary:
        return MaterialLibrary()
    def unload(self) -> bool:
        """
        Unloads this material from Fusion 360. Only non-native material libraries
        can be unloaded. You can determine this by checking the isNative property.
        Returns True if the library was successfully unloaded.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Property that gets the name of this Library. This is the localized name
        shown in the user interface.
        """
        return str()
    @property
    def id(self) -> str:
        """
        The unique internal ID of this Library.
        """
        return str()
    @property
    def appearances(self) -> Appearances:
        """
        Returns the appearances defined within this library.
        """
        return Appearances()
    @property
    def materials(self) -> Materials:
        """
        Returns the materials defined within this library.
        """
        return Materials()
    @property
    def isNative(self) -> bool:
        """
        Gets if this is a native material library. Native libraries are
        those that are delivered with Fusion 360 and are always available. And
        non-native libraries are user created. If This returns True then there
        are some limitations to what can be done with the library. For example,
        if this is a native material library it cannot be unloaded.
        """
        return bool()

class MaterialPreferences(Base):
    """
    Provides access to the material related preferences.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MaterialPreferences:
        return MaterialPreferences()
    @property
    def defaultMaterial(self) -> Material:
        """
        Gets and sets the default material.
        """
        return Material()
    @defaultMaterial.setter
    def defaultMaterial(self, value: Material):
        """
        Gets and sets the default material.
        """
        pass
    @property
    def appearanceOverride(self) -> Appearance:
        """
        Gets and sets an appearance override.
        This property return null indicating that there is no override, or be set to null to remove
        the current appearance override.
        """
        return Appearance()
    @appearanceOverride.setter
    def appearanceOverride(self, value: Appearance):
        """
        Gets and sets an appearance override.
        This property return null indicating that there is no override, or be set to null to remove
        the current appearance override.
        """
        pass

class Materials(Base):
    """
    Collection of materials within a Library or Design.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Materials:
        return Materials()
    def item(self, index: int) -> Material:
        """
        Returns the specified Material using an index into the collection.
        index : The index of the material to return where the first item in the collection is 0.
        Returns the specified material or null if an invalid index is specified.
        """
        return Material()
    def itemByName(self, name: str) -> Material:
        """
        Returns the specified Material using the name as seen in the user interface. This often isn't
        a reliable way of accessing a specific material because materials are not required to be unique.
        name : The name of the material to return,.
        Returns the specified material or null if there isn't a matching name.
        """
        return Material()
    def itemById(self, id: str) -> Material:
        """
        Returns the Material by it's internal unique ID.
        id : The ID of the material to return.
        Returns the specified material or null if there isn't a matching ID.
        """
        return Material()
    def addByCopy(self, materialToCopy: Material, name: str) -> Material:
        """
        Add a Material to a Design by copying an existing Material from Favorites, a Library or from the
        Materials stored in the Design. This method currently only applies to the Materials collection from a Design and
        cannot be used to copy a Material to a library.
        materialToCopy : The Material you want to copy. The Material to copy can be from Favorites, a Library or from the
        materials stored in the Design.
        name : The Material name to apply to the copy.
        Returns the newly created Material or null if the copy operation failed.
        """
        return Material()
    @property
    def count(self) -> int:
        """
        The number of Materials in the collection.
        """
        return int()

class Matrix2D(Base):
    """
    Transient 2D 3x3 matrix. This object is a wrapper over 2D matrix data and is used as way to pass matrix data
    in and out of the API and as a convenience when operating on matrix data.
    They are created statically using the create method of the Matrix2D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Matrix2D:
        return Matrix2D()
    @staticmethod
    def create() -> Matrix2D:
        """
        Creates a transient 2D matrix (3x3) object. It is initialized as an identity matrix.
        Returns the new matrix.
        """
        return Matrix2D()
    def setToIdentity(self) -> bool:
        """
        Resets this matrix to be an identity matrix.
        Returns true if successful.
        """
        return bool()
    def invert(self) -> bool:
        """
        Invert this matrix.
        Returns true if successful.
        """
        return bool()
    def copy(self) -> Matrix2D:
        """
        Creates an independent copy of this matrix.
        Returns the new matrix copy.
        """
        return Matrix2D()
    def transformBy(self, matrix: Matrix2D) -> bool:
        """
        Transforms this matrix using the input matrix.
        matrix : The transformation matrix.
        Returns true if successful.
        """
        return bool()
    def getCell(self, row: int, column: int) -> float:
        """
        Gets the value of the specified cell in the 3x3 matrix.
        row : The index of the row. The first row has in index of 0
        column : The index of the column. The first column has an index of 0
        Returns the value at [row][column].
        """
        return float()
    def setCell(self, row: int, column: int, value: float) -> bool:
        """
        Sets the specified cell in the 3x3 matrix to the specified value.
        row : The index of the row. The first row has in index of 0
        column : The index of the column. The first column has an index of 0
        value : The new value of the cell.
        Returns true if successful.
        """
        return bool()
    def getAsCoordinateSystem(self) -> tuple[Point2D, Vector2D, Vector2D]:
        """
        Gets the matrix data as the components that define a coordinate system.
        origin : The output origin point of the coordinate system.
        xAxis : The output x axis direction of the coordinate system.
        yAxis : The output y axis direction of the coordinate system.
        """
        return (Point2D(), Vector2D(), Vector2D())
    def asArray(self) -> list[float]:
        """
        Returns the contents of the matrix as a 9 element array.
        Returns the array of matrix values.
        """
        return [float()]
    def setWithCoordinateSystem(self, origin: Point2D, xAxis: Vector2D, yAxis: Vector2D) -> bool:
        """
        Reset this matrix to align with a specific coordinate system.
        origin : The origin point of the coordinate system.
        xAxis : The x axis direction of the coordinate system.
        yAxis : The y axis direction of the coordinate system.
        Returns true if successful.
        """
        return bool()
    def setWithArray(self, cells: list[float]) -> bool:
        """
        Sets the contents of the array using a 9 element array.
        cells : The array of cell values.
        Returns true if successful.
        """
        return bool()
    def isEqualTo(self, matrix: Matrix2D) -> bool:
        """
        Compares this matrix with another matrix and returns True if they're identical.
        matrix : The matrix to compare to.
        Returns true if the matrix is equal to this matrix.
        """
        return bool()
    def setToAlignCoordinateSystems(self, fromOrigin: Point2D, fromXAxis: Vector2D, fromYAxis: Vector2D, toOrigin: Point2D, toXAxis: Vector2D, toYAxis: Vector2D) -> bool:
        """
        Sets this matrix to be the matrix that maps from the 'from' coordinate system to the 'to' coordinate system.
        fromOrigin : The origin point of the from coordinate system.
        fromXAxis : The x axis direction of the from coordinate system.
        fromYAxis : The y axis direction of the from coordinate system.
        toOrigin : The origin point of the to coordinate system.
        toXAxis : The x axis direction of the to coordinate system.
        toYAxis : The y axis direction of the to coordinate system.
        Returns true if successful.
        """
        return bool()
    def setToRotateTo(self, _from: Vector2D, to: Vector2D) -> bool:
        """
        Sets to the matrix of rotation that would align the 'from' vector with the 'to' vector.
        from : The from vector.
        to : The to vector.
        Returns true if successful.
        """
        return bool()
    def setToRotation(self, angle: float, origin: Point2D) -> bool:
        """
        Sets this matrix to the matrix of rotation by the specified angle, through the specified origin.
        angle : The rotation angle in radians.
        origin : The origin point of the rotation.
        Returns true if successful.
        """
        return bool()
    @property
    def determinant(self) -> float:
        """
        Returns the determinant of the matrix.
        Returns the determinant value of this matrix.
        """
        return float()

class Matrix3D(Base):
    """
    Transient 3D 4x4 matrix. This object is a wrapper over 3D matrix data and is used as way to pass matrix data
    in and out of the API and as a convenience when operating on matrix data.
    They are created statically using the create method of the Matrix3D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Matrix3D:
        return Matrix3D()
    @staticmethod
    def create() -> Matrix3D:
        """
        Creates a transient 3d matrix object. It is initialized as an identity matrix and
        is created statically using the Matrix3D.create method.
        Returns the new matrix.
        """
        return Matrix3D()
    def setToIdentity(self) -> bool:
        """
        Resets this matrix to an identify matrix.
        Returns true if successful.
        """
        return bool()
    def invert(self) -> bool:
        """
        Inverts this matrix.
        Returns true if successful.
        """
        return bool()
    def copy(self) -> Matrix3D:
        """
        Creates an independent copy of this matrix.
        Returns the new matrix copy.
        """
        return Matrix3D()
    def transformBy(self, matrix: Matrix3D) -> bool:
        """
        Transforms this matrix using the input matrix.
        matrix : The transformation matrix.
        Returns true if successful.
        """
        return bool()
    def getAsCoordinateSystem(self) -> tuple[Point3D, Vector3D, Vector3D, Vector3D]:
        """
        Gets the matrix data as the components that define a coordinate system.
        origin : The output origin point of the coordinate system.
        xAxis : The output x axis direction of the coordinate system.
        yAxis : The output y axis direction of the coordinate system.
        zAxis : The output z axis direction of the coordinate system.
        """
        return (Point3D(), Vector3D(), Vector3D(), Vector3D())
    def setWithCoordinateSystem(self, origin: Point3D, xAxis: Vector3D, yAxis: Vector3D, zAxis: Vector3D) -> bool:
        """
        Sets the matrix based on the components of a coordinate system.
        origin : The origin point of the coordinate system.
        xAxis : The x axis direction of the coordinate system.
        yAxis : The y axis direction of the coordinate system.
        zAxis : The z axis direction of the coordinate system.
        Returns true if successful.
        """
        return bool()
    def getCell(self, row: int, column: int) -> float:
        """
        Gets the value of the specified cell in the 4x4 matrix.
        row : The index of the row. The first row has in index of 0
        column : The index of the column. The first column has an index of 0
        The cell value at [row][column].
        """
        return float()
    def setCell(self, row: int, column: int, value: float) -> bool:
        """
        Sets the specified cell in the 4x4 matrix to the specified value.
        row : The index of the row. The first row has in index of 0
        column : The index of the column. The first column has an index of 0
        value : The new cell value.
        Returns true if successful.
        """
        return bool()
    def asArray(self) -> list[float]:
        """
        Returns the contents of the matrix as a 16 element array.
        Returns the array of cell values.
        """
        return [float()]
    def setWithArray(self, cells: list[float]) -> bool:
        """
        Sets the contents of the array using a 16 element array.
        cells : The array of cell values.
        Returns true if successful.
        """
        return bool()
    def isEqualTo(self, matrix: Matrix3D) -> bool:
        """
        Compares this matrix with another matrix and returns True if they're identical.
        matrix : The matrix to compare this matrix to.
        Returns true if the matrices are equal.
        """
        return bool()
    def setToAlignCoordinateSystems(self, fromOrigin: Point3D, fromXAxis: Vector3D, fromYAxis: Vector3D, fromZAxis: Vector3D, toOrigin: Point3D, toXAxis: Vector3D, toYAxis: Vector3D, toZAxis: Vector3D) -> bool:
        """
        Sets this matrix to be the matrix that maps from the 'from' coordinate system to the 'to' coordinate system.
        fromOrigin : The origin point of the from coordinate system.
        fromXAxis : The x axis direction of the from coordinate system.
        fromYAxis : The y axis direction of the from coordinate system.
        fromZAxis : The z axis direction of the from coordinate system.
        toOrigin : The origin point of the to coordinate system.
        toXAxis : The x axis direction of the to coordinate system.
        toYAxis : The y axis direction of the to coordinate system.
        toZAxis : The z axis direction of the to coordinate system.
        Returns true if successful.
        """
        return bool()
    def setToRotateTo(self, _from: Vector3D, to: Vector3D, axis: Vector3D) -> bool:
        """
        Sets to the matrix of rotation that would align the 'from' vector with the 'to' vector. The optional
        axis argument may be used when the two vectors are perpendicular and in opposite directions to
        specify a specific solution, but is otherwise ignored
        from : The vector to rotate from.
        to : The vector to rotate to.
        axis : The optional axis vector to disambiguate the rotation axis.
        Returns true if successful.
        """
        return bool()
    def setToRotation(self, angle: float, axis: Vector3D, origin: Point3D) -> bool:
        """
        Sets this matrix to the matrix of rotation by the specified angle, through the specified origin, around the specified axis
        angle : The rotation angle in radians.
        axis : The axis of rotation.
        origin : The origin point of the axis of rotation.
        Returns true if successful.
        """
        return bool()
    @property
    def determinant(self) -> float:
        """
        Returns the determinant of the matrix.
        """
        return float()
    @property
    def translation(self) -> Vector3D:
        """
        Gets and sets the translation component of the matrix.
        """
        return Vector3D()
    @translation.setter
    def translation(self, value: Vector3D):
        """
        Gets and sets the translation component of the matrix.
        """
        pass

class MeasureManager(Base):
    """
    The MeasurementManager class provides some generic measurement utilities that
    can be used for most entity types.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MeasureManager:
        return MeasureManager()
    def getOrientedBoundingBox(self, geometry: Base, lengthVector: Vector3D, widthVector: Vector3D) -> OrientedBoundingBox3D:
        """
        Calculates an oriented bounding box for the input geometry. The bounding box is tight fitting
        to the input geometry and is particularly useful when you want to calculate a bounding box that
        is not oriented to be parallel to the model x-y-z plane.
        
        The height direction is automatically determined using the length and width directions.
        geometry : The geometry to calculate the bounding box for. This can be any of the B-Rep related entities.
        lengthVector : The direction the length of the oriented bounding box will be measured in. The magnitude of the vector
        is ignored and only the direction is used.
        widthVector : The direction the width of the oriented bounding box will be measured in. The magnitude of the vector
        is ignored and only the direction is used. This must be perpendicular to the length vector.
        Returns an OrientedBoundingBox3D object which provides the information that defines an oriented bounding box.
        """
        return OrientedBoundingBox3D()
    def measureMinimumDistance(self, geometryOne: Base, geometryTwo: Base) -> MeasureResults:
        """
        Measures the minimum distance between the two input geometries.
        geometryOne : The first geometry to measure from. This can be an Occurrence, BRepBody, BRepFace, BRepEdge, BRepVertex,
        ConstructionPlane, ConstructionAxis, ConstructionPoint, and any sketch entity. The only temporary geometry supported is the Plane object.
        geometryTwo : The first geometry to measure from. This can be an Occurrence, BRepBody, BRepFace, BRepEdge, BRepVertex,
        ConstructionPlane, ConstructionAxis, ConstructionPoint, and any sketch entity. The only temporary geometry supported is the Plane object.
        A MeasureResults object that contains the distance and the two points on the geometry that the distance that
        was measured between them in centimeters.
        """
        return MeasureResults()
    def measureAngle(self, geometryOne: Base, geometryTwo: Base, geometryThree: Base) -> MeasureResults:
        """
        Measures the angle between the input geometry.
        geometryOne : The first geometry to measure the angle to. This can be any 3D point geometry (Construction Point, Vertex, SketchPoint, or Point3D),
        any 3D linear geometry (Construction Axis, linear BRepEdge, SketchLine, Line3D, or InfiniteLine3D), or any planar geometry (Construction Plane, planar BRepFace, or Plane).
        geometryTwo : The second geometry to measure the angle to. This can be any 3D point geometry (Construction Point, Vertex, SketchPoint, or Point3D),
        any 3D linear geometry (Construction Axis, linear BRepEdge, SketchLine, Line3D, or InfiniteLine3D), or any planar geometry (Construction Plane, planar BRepFace, or Plane).
        geometryThree : The optional third geometry to measure the angle to. This is only used when the first two geometries
        are points and this defines the third point. When three points define a triangle, the apex of the
        triangle is defined by the second point. A point can be defined by a Construction Point, Vertex, SketchPoint, or Point3D object.
        A MeasureResults object that contains the angle and the two points on the geometry that the angle
        that was measured between them in radians.
        """
        return MeasureResults()

class MeasureResults(Base):
    """
    Provides measurement results from the various measurement methods available on the MeasureManager object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MeasureResults:
        return MeasureResults()
    @property
    def value(self) -> float:
        """
        The measurement value. If the measurement is a distance this value will be in centimeters.
        If it's an angle then it will be in radians.
        """
        return float()
    @property
    def positionOne(self) -> Point3D:
        """
        For a distance measurement, this is the point on the first entity where the measurement was made from.
        For an angle measurement this is one of the three points defining the angle.
        """
        return Point3D()
    @property
    def positionTwo(self) -> Point3D:
        """
        For a distance measurement, this is the point on the second entity where the measurement was made to.
        For an angle measurement this is one of the three points defining the angle.
        """
        return Point3D()
    @property
    def positionThree(self) -> Point3D:
        """
        This point is only used for angle measurements and is one of the three points defining the angle.
        """
        return Point3D()

class MouseEventHandler(EventHandler):
    """
    An event handler base class that a client derives from to handle events triggered by a MouseEvent.
    A client implemented instance of this class can be added to a MouseEvent to receive these event notifications.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MouseEventHandler:
        return MouseEventHandler()
    def notify(self, eventArgs: MouseEventArgs) -> None:
        """
        This notify member is called when an event is triggered from any event that this handler has been added to.
        eventArgs : The arguments object with details about this event and the firing MouseEvent.
        """
        pass

class NamedValues(Base):
    """
    Wraps a list of named values.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> NamedValues:
        return NamedValues()
    @staticmethod
    def create() -> NamedValues:
        """
        Creates a transient NamedValues object.
        Returns the created NamedValue object.
        """
        return NamedValues()
    def add(self, name: str, value: ValueInput) -> bool:
        """
        Adds a name value pair to the NamedValues object
        name : A name for the name value pair
        value : A ValueInput object that defines the value of the name value pair
        Returns true if the name value pair is added successfully.
        """
        return bool()
    def getByIndex(self, index: int) -> tuple[bool, str, ValueInput]:
        """
        Function that returns the name and ValueInput object of a name value pair
        by specifying an index number
        index : The index of the name value pair to return. The first pair in the collection
        has an index of 0.
        name : The name
        value : The ValueInput object
        Returns true if successful
        """
        return (bool(), str(), ValueInput())
    def getValueByName(self, name: str) -> tuple[bool, ValueInput]:
        """
        Function that returns the ValueInput object of a name value pair
        by specifying its name
        name : The name of the name value pair to return the ValueInput object from
        value : The ValueInput object
        Returns true if successful
        """
        return (bool(), ValueInput())
    @property
    def count(self) -> int:
        """
        Returns the number of name value pairs in this object.
        """
        return int()

class NavigationEventHandler(EventHandler):
    """
    The NavigationEventHandler is a client implemented class that can be added as a handler to a Navigation
    event which is triggered by the browser within a palette.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> NavigationEventHandler:
        return NavigationEventHandler()
    def notify(self, eventArgs: NavigationEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class NetworkPreferences(Base):
    """
    The NetworkPreferences object provides access to network related preferences.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> NetworkPreferences:
        return NetworkPreferences()
    @property
    def networkProxySetting(self) -> NetworkProxySettings:
        """
        Gets and sets the network proxy setting.
        """
        return NetworkProxySettings()
    @networkProxySetting.setter
    def networkProxySetting(self, value: NetworkProxySettings):
        """
        Gets and sets the network proxy setting.
        """
        pass
    @property
    def proxyHost(self) -> str:
        """
        Gets and sets the proxy host.
        """
        return str()
    @proxyHost.setter
    def proxyHost(self, value: str):
        """
        Gets and sets the proxy host.
        """
        pass
    @property
    def proxyPort(self) -> int:
        """
        Gets and sets the proxy host.
        """
        return int()
    @proxyPort.setter
    def proxyPort(self, value: int):
        """
        Gets and sets the proxy host.
        """
        pass

class ObjectCollection(Base):
    """
    Generic collection used to handle lists of any object type.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ObjectCollection:
        return ObjectCollection()
    @staticmethod
    def create() -> ObjectCollection:
        """
        Creates a new ObjectCollection object.
        Returns the newly created ObjectCollection.
        """
        return ObjectCollection()
    def item(self, index: int) -> Base:
        """
        Function that returns the specified object using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Base()
    def add(self, item: Base) -> bool:
        """
        Adds an object to the end of the collection.
        Duplicates can be added to the collection.
        item : The item to add to the list.
        Returns false if the item was not added.
        """
        return bool()
    def removeByItem(self, item: Base) -> bool:
        """
        Function that removes an item from the collection.
        item : The object to remove from the collection.
        Returns true if the removal was successful.
        """
        return bool()
    def removeByIndex(self, index: int) -> bool:
        """
        Function that removes an item from the list.
        Will fail if the list is read only.
        index : The index of the item to remove from the collection. The first item has an index of 0.
        Returns true if the removal was successful.
        """
        return bool()
    def find(self, item: Base, startIndex: int) -> int:
        """
        Finds the specified component in the collection.
        item : The item to search for within the collection.
        startIndex : The index to begin the search.
        Returns the index of the found item. If not found, -1 is returned.
        """
        return int()
    def contains(self, item: Base) -> bool:
        """
        Returns whether the specified object exists within the collection.
        item : The item to look for in the collection.
        Returns true if the specified item is found in the collection.
        """
        return bool()
    def clear(self) -> bool:
        """
        Clears the entire contents of the collection.
        Returns true if successful.
        """
        return bool()
    @property
    def count(self) -> int:
        """
        Returns the number of occurrences in the collection.
        """
        return int()

class OrientedBoundingBox3D(Base):
    """
    Transient object that represents an oriented 3D bounding box. An oriented 3D bounding box is a rectangular box that
    can be in any orientation in model space. They are created statically using the create method of the OrientedBoundingBox3D class
    and are used by some functions to return oriented box information.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> OrientedBoundingBox3D:
        return OrientedBoundingBox3D()
    @staticmethod
    def create(centerPoint: Point3D, lengthDirection: Vector3D, widthDirection: Vector3D, length: float, width: float, height: float) -> OrientedBoundingBox3D:
        """
        Creates a transient oriented bounding box object.
        centerPoint : The center point of the oriented box.
        lengthDirection : A Vector3D object that defines the direction of the length of the oriented bounding box. The magnitude of
        the vector is ignored and just the direction is used.
        widthDirection : A Vector3D object that defines the direction of the width of the oriented bounding box. The magnitude of
        the vector is ignored and just the direction is used. The width direction must be perpendicular to
        the length direction.
        length : The length of the oriented bounding box in centimeters.
        width : The width of the oriented bounding box in centimeters. The width of the box is always perpendicular to the length.
        height : The height of the oriented bounding box in centimeters. The height of the box is perpendicular to the length-width plane
        using the right-hand rule where you cross the length into the width.
        Returns the new oriented bounding box.
        """
        return OrientedBoundingBox3D()
    def setOrientation(self, lengthDirection: Vector3D, widthDirection: Vector3D) -> bool:
        """
        Sets the orientation of the oriented bounding box.
        lengthDirection : A Vector3D object that defines the direction of the length of the oriented bounding box. The magnitude of
        the vector is ignored and just the direction is used.
        widthDirection : A Vector3D object that defines the direction of the width of the oriented bounding box. The magnitude of
        the vector is ignored and just the direction is used. The width direction must be perpendicular to
        the length direction.
        
        """
        return bool()
    def contains(self, point: Point3D) -> bool:
        """
        Determines if the specified point lies within the oriented bounding box.
        point : The point to test containment with.
        Returns true if the point lies within the bounding box.
        """
        return bool()
    def copy(self) -> OrientedBoundingBox3D:
        """
        Create a copy of this oriented bounding box.
        Returns the new oriented bounding box copy.
        """
        return OrientedBoundingBox3D()
    @property
    def centerPoint(self) -> Point3D:
        """
        Gets and sets the centerPoint point of the oriented box.
        """
        return Point3D()
    @centerPoint.setter
    def centerPoint(self, value: Point3D):
        """
        Gets and sets the centerPoint point of the oriented box.
        """
        pass
    @property
    def lengthDirection(self) -> Vector3D:
        """
        Gets the direction of the length of the oriented bounding box.
        A unit vector is always returned.
        """
        return Vector3D()
    @property
    def length(self) -> float:
        """
        Gets and sets the length of the oriented bounding box in centimeters.
        """
        return float()
    @length.setter
    def length(self, value: float):
        """
        Gets and sets the length of the oriented bounding box in centimeters.
        """
        pass
    @property
    def widthDirection(self) -> Vector3D:
        """
        Gets the direction of the width of the oriented bounding box.
        A unit vector is always returned.
        """
        return Vector3D()
    @property
    def width(self) -> float:
        """
        Gets and sets the width of the oriented bounding box in centimeters.
        """
        return float()
    @width.setter
    def width(self, value: float):
        """
        Gets and sets the width of the oriented bounding box in centimeters.
        """
        pass
    @property
    def heightDirection(self) -> Vector3D:
        """
        Gets the direction of the height of the oriented bounding box.
        A unit vector is always returned.
        """
        return Vector3D()
    @property
    def height(self) -> float:
        """
        Gets and sets the height of the oriented bounding box in centimeters.
        """
        return float()
    @height.setter
    def height(self, value: float):
        """
        Gets and sets the height of the oriented bounding box in centimeters.
        """
        pass

class Palette(Base):
    """
    A Palette is a floating or docked dialog in Fusion 360. The browser is an
    example of a built-in palette. The contents of a custom palette are
    created by displaying an HTML file.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Palette:
        return Palette()
    def sendInfoToHTML(self, action: str, data: str) -> str:
        """
        <p>Sends the string to the JavaScript associated with the loaded HTML. A variation of the
        event handler below should be implemented in the JavaScript associated with the HTML to
        receive the data. The event will be triggered by Fusion 360 whenever the sendInfoToHTML method
        is called.</p>
        
        <pre class="api-code">window.fusionJavaScriptHandler = {
        handle: function(actionString, dataString){
        confirm('Action from Fusion: ' + actionString);
        confirm('Data from Fusion: ' + dataString);
        
        // Build up JSON return string.
        var result = {};
        result.status = 'OK';
        var response = JSON.stringify(result);
        return response;
        }
        };</pre>
        <p>Your JavaScript code should always return something in response because an empty string
        response is assumed to be a failure.</p>
        action : The "action" string to pass to the JavaScript associated with the HTML. This string can be
        anything but will typically be JSON formatted information.
        data : The "data" string to pass to the JavaScript associated with the HTML. This string can be
        anything but will typically be JSON formatted information.
        Returns a string that can be anything that your JavaScript code generates. The JavaScript
        should always return some content because an empty string is used to indicate a failure.
        
        If useNewWebBrowser flag is set to true while creating the palette control this API call
        will be asynchronous and an empty string is returned. Response will come in data field of HTMLEvent with action
        equal to 'response'.
        """
        return str()
    def deleteMe(self) -> bool:
        """
        Deletes this palette. Fusion 360 native palettes cannot be deleted. Use the
        isNative property to determine if this is a native or API created palette.
        Returns true if the delete was successful.
        """
        return bool()
    def setPosition(self, left: int, top: int) -> bool:
        """
        Sets the position of the palette. If the palette is docked or snapped, this will result in changing it
        to be floating.
        left : The position of the left side of the palette relative to screen space and in pixels. Because palettes can be
        positioned outside of the Fusion 360 window, a value of zero indicates the left side of the screen and not the
        Fusion 360 window.
        top : The position of the top of the palette relative to screen space and in pixels. Because palettes can be
        positioned outside of the Fusion 360 window, a value of zero indicates the top of the screen and not the
        Fusion 360 window.
        Returns true if setting the position was successful.
        """
        return bool()
    def setSize(self, width: int, height: int) -> bool:
        """
        Sets the size of the palette. This is best used for a floating palette because either the width or
        height can be locked when a palette is docked.
        width : Specifies the width of the palette. Depending on how the palette is docked or snapped, the width
        may not be editable.
        height : Specifies the height of the palette. Depending on how the palette is docked or snapped, the height
        may not be editable.
        Returns true if the sizing was successful. It is still considered a success even if the width or
        height could not be changed because of how the palette is docked or snapped.
        """
        return bool()
    def snapTo(self, palette: Palette, snapOption: PaletteSnapOptions) -> bool:
        """
        Snaps this palette to another palette.
        palette : Specifies the palette to snap to.
        snapOption : Specifies how this palette should be snapped to the other palette.
        Returns true if the palette was successfully snapped to the other palette.
        """
        return bool()
    def setMinimumSize(self, width: int, height: int) -> bool:
        """
        Sets the minimum size of the palette. The user cannot resize it to be smaller than
        this size. This does not change the current size of the palette unless the palette
        is already smaller than this size.
        
        Calling this method and setting the width and height to zero, removes the minimum
        size restriction.
        width : Specifies the minimum width of the palette.
        height : Specifies the minimum height of the palette.
        Returns true if setting the minimum size was successful.
        """
        return bool()
    def setMaximumSize(self, width: int, height: int) -> bool:
        """
        Sets the maximum size of the palette. The user cannot resize it to be larger than
        this size. This does not change the current size of the palette unless the palette
        is already larger than this size.
        
        Calling this method and setting the width and height to zero, removes the maximum
        size restriction.
        width : Specifies the maximum width of the palette.
        height : Specifies the maximum height of the palette.
        Returns true if setting the maximum size was successful.
        """
        return bool()
    @property
    def id(self) -> str:
        """
        Gets The unique, language independent, ID of this palette.
        """
        return str()
    @property
    def isVisible(self) -> bool:
        """
        Gets and sets whether this palette is currently being displayed in the user interface.
        """
        return bool()
    @isVisible.setter
    def isVisible(self, value: bool):
        """
        Gets and sets whether this palette is currently being displayed in the user interface.
        """
        pass
    @property
    def htmlFileURL(self) -> str:
        """
        Gets and sets the URL to the HTML file currently being displayed. This can be local or on the web.
        """
        return str()
    @htmlFileURL.setter
    def htmlFileURL(self, value: str):
        """
        Gets and sets the URL to the HTML file currently being displayed. This can be local or on the web.
        """
        pass
    @property
    def incomingFromHTML(self) -> HTMLEvent:
        """
        This event is fired when the JavaScript associated with the HTML calls the
        adsk.fusionSendData function. This allows the HTML to communicate with the add-in by
        passing information to the add-in.
        """
        return HTMLEvent()
    @property
    def closed(self) -> UserInterfaceGeneralEvent:
        """
        This event is fired when the user clicks the "Close" button on the palette. You can choose
        if the "Close" button is available or not when you initially create the palette. When a
        palette is closed, it still exists but is change to invisible so you can still interact with it and
        retrieve any needed information and can make it visible again. Use the deleteMe method to
        delete the palette.
        """
        return UserInterfaceGeneralEvent()
    @property
    def name(self) -> str:
        """
        Gets and set the name of the palette as seen in the user interface. The name of native palettes
        cannot be set.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and set the name of the palette as seen in the user interface. The name of native palettes
        cannot be set.
        """
        pass
    @property
    def isNative(self) -> bool:
        """
        Indicates if this is one of the standard Fusion 360 palettes or a custom palette
        created through the API. If true, it is a standard Fusion 360 palette and will
        have some restrictions on changing its properties and cannot be deleted.
        """
        return bool()
    @property
    def dockingOption(self) -> PaletteDockingOptions:
        """
        Defines the docking behavior for this palette. This controls how the user is allowed to dock the palette.
        """
        return PaletteDockingOptions()
    @dockingOption.setter
    def dockingOption(self, value: PaletteDockingOptions):
        """
        Defines the docking behavior for this palette. This controls how the user is allowed to dock the palette.
        """
        pass
    @property
    def dockingState(self) -> PaletteDockingStates:
        """
        Gets and sets how the palette is currently docked.
        """
        return PaletteDockingStates()
    @dockingState.setter
    def dockingState(self, value: PaletteDockingStates):
        """
        Gets and sets how the palette is currently docked.
        """
        pass
    @property
    def width(self) -> int:
        """
        Gets and sets the width of the palette. Setting this property may not always set the width. Depending on
        how the palette is docked or snapped, the width may not be editable.
        """
        return int()
    @width.setter
    def width(self, value: int):
        """
        Gets and sets the width of the palette. Setting this property may not always set the width. Depending on
        how the palette is docked or snapped, the width may not be editable.
        """
        pass
    @property
    def height(self) -> int:
        """
        Gets and sets the height of the palette. Setting this property may not always set the height. Depending on
        how the palette is docked or snapped, the height may not be editable.
        """
        return int()
    @height.setter
    def height(self, value: int):
        """
        Gets and sets the height of the palette. Setting this property may not always set the height. Depending on
        how the palette is docked or snapped, the height may not be editable.
        """
        pass
    @property
    def left(self) -> int:
        """
        Gets and sets the left side of the palette relative to screen space and in pixels. Because palettes can be
        positioned outside of the Fusion 360 window, a value of zero indicates the left side of the screen and not the
        Fusion 360 window.
        """
        return int()
    @left.setter
    def left(self, value: int):
        """
        Gets and sets the left side of the palette relative to screen space and in pixels. Because palettes can be
        positioned outside of the Fusion 360 window, a value of zero indicates the left side of the screen and not the
        Fusion 360 window.
        """
        pass
    @property
    def top(self) -> int:
        """
        Gets and sets the top of the palette relative to screen space and in pixels. Because palettes can be
        positioned outside of the Fusion 360 window, a value of zero indicates the top of the screen and not the
        Fusion 360 window.
        """
        return int()
    @top.setter
    def top(self, value: int):
        """
        Gets and sets the top of the palette relative to screen space and in pixels. Because palettes can be
        positioned outside of the Fusion 360 window, a value of zero indicates the top of the screen and not the
        Fusion 360 window.
        """
        pass
    @property
    def navigatingURL(self) -> NavigationEvent:
        """
        This event is fired when a navigation event occurs on the page. This allows the add-in to determine
        how this navigation should be handled by the browser.
        """
        return NavigationEvent()

class Palettes(Base):
    """
    Provides access to a set of palettes, which are docked or floating windows that display HTML.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Palettes:
        return Palettes()
    def add(self, id: str, name: str, htmlFileURL: str, isVisible: bool, showCloseButton: bool, isResizable: bool, width: int, height: int, useNewWebBrowser: bool) -> Palette:
        """
        Creates a new Palette.
        id : The unique id for this palette. The id must be unique with respect to all of the palettes.
        name : The displayed name of this palette. This is the name visible in the user interface.
        htmlFileURL : Specifies the URL to the HTML file that will be displayed in the palette. This can be a local file or on the web.
        isVisible : Specifies if the palette is initially visible or not. It's useful to create it invisibly, change other desired
        properties and then use the isVisible property to finally make it visible to the user.
        showCloseButton : Specifies if a "Close" button should be displayed on the palette to allow the user to easily close it.
        isResizable : Specifies if the palette can be resized by the user or not.
        width : Specifies the width of the palette in pixels. If no width is specified a default width will be used.
        height : Specifies the height of the palette in pixels. If no height is specified a default height will be used.
        useNewWebBrowser : Specifies if you want to use the old or new web browser. A palette is essentially a dialog that hosts
        a web browser. To support this type of functionality, Fusion has used CEF (Chromium Embedded Framework).
        Fusion is in the process of switching to the Qt Web Browser wherever an embedded browser is needed in the product.
        As this transition occurs, Fusion is supporting both web browsers. This argument is optional and defaults
        to False, which means the palette will behave as before and use the CEF browser. Setting the argument to
        True will cause the palette to use the new QT Web Browser.
        
        When Fusion completes the transition to the QT Web Browser, support for the CEF browser will be removed from Fusion,
        and you will always get a QT Web Browser regardless of how the argument is set. Because of this, it is highly
        recommended you set this argument to true to use the new browser because when support for the CEF browser is removed
        you will automatically be forced to use the QT Web Browser.
        Returns the newly created palette or null in the case the creation failed.
        """
        return Palette()
    def item(self, index: int) -> Palette:
        """
        Returns the specified palette using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Palette()
    def itemById(self, id: str) -> Palette:
        """
        Returns the palette at the specified ID.
        id : The Id of the palette within the collection to return.
        Returns the palette of the specified id or null if no palette has the specified id.
        """
        return Palette()
    @property
    def count(self) -> int:
        """
        Gets the number of Palettes.
        """
        return int()

class PersonalUseLimits(Base):
    """
    Object that provides information about file limits associated with a "Fusion 360 for Personal Use license".
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PersonalUseLimits:
        return PersonalUseLimits()
    @property
    def maxEditableFileCount(self) -> int:
        """
        Returns the maximum number of documents that can be set by the user
        to be editable.
        """
        return int()
    @property
    def editableFileCount(self) -> int:
        """
        Returns the current number of documents that are set by the user to be editable.
        """
        return int()
    @property
    def editableFiles(self) -> list[DataFile]:
        """
        Returns a list of the DataFile objects that have been set by the user to be editable.
        """
        return [DataFile()]

class Point2D(Base):
    """
    Transient 2D point. A transient point is not displayed or saved in a document.
    Transient 2D points are used as a wrapper to work with raw 2D point information.
    They are created statically using the create methods of the Point2D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Point2D:
        return Point2D()
    @staticmethod
    def create(x: float, y: float) -> Point2D:
        """
        Creates a transient 2D point object.
        x : The x coordinate of the point
        y : The y coordinate of the point
        Returns the new Point2D object or null if the creation failed.
        """
        return Point2D()
    def copy(self) -> Point2D:
        """
        Creates and returns a copy of this point object.
        Returns an independent copy of this point object.
        """
        return Point2D()
    def getData(self) -> tuple[bool, float, float]:
        """
        Gets the data defining the point.
        x : The output x coordinate of the point.
        y : The output y coordinate of the point.
        Returns true if successful.
        """
        return (bool(), float(), float())
    def distanceTo(self, point: Point2D) -> float:
        """
        Returns the distance from this point to another point.
        point : The point to measure the distance to
        Returns the distance to the point.
        """
        return float()
    def asArray(self) -> list[float]:
        """
        Get coordinate data of the point
        Returns the coordinate data of the point as an array
        """
        return [float()]
    def isEqualTo(self, point: Point2D) -> bool:
        """
        Checks to see if this point and another point are equal (have identical coordinates).
        The comparison is done within the modeling tolerance which can be found with the
        Application.pointTolerance property. If you want to compare two points with any other
        tolerance you can use the isEqualToByTolerance method.
        point : The point to compare for equality
        Returns true if the points are equal. (have identical coordinates)
        """
        return bool()
    def setWithArray(self, coordinates: list[float]) -> bool:
        """
        Sets the coordinates of the point using an array as input.
        coordinates : An array that defines the coordinates of the point
        Returns true if successful
        """
        return bool()
    def set(self, x: float, y: float) -> bool:
        """
        Sets the coordinates of the point by specifying the x, y coordinates.
        x : The x coordinate of the point.
        y : The y coordinate of the point.
        Returns true if successful
        """
        return bool()
    def transformBy(self, matrix: Matrix2D) -> bool:
        """
        Transforms the point using the provided matrix.
        matrix : The Matrix2D object that defines the transformation
        Returns true if successful
        """
        return bool()
    def asVector(self) -> Vector2D:
        """
        Defines a vector using the coordinates of the point.
        Returns a Vector2D object
        """
        return Vector2D()
    def translateBy(self, vector: Vector2D) -> bool:
        """
        Translates the point using the provided vector.
        vector : The vector to use to translate the point
        Returns true if successful
        """
        return bool()
    def vectorTo(self, point: Point2D) -> Vector2D:
        """
        Returns a vector from this point to another point.
        point : The other point to use to create the vector
        Returns a Vector2D object
        """
        return Vector2D()
    def isEqualToByTolerance(self, point: Point2D, tolerance: float) -> bool:
        """
        Checks to see if this point and another point are equal within the specified tolerance.
        point : The point to compare for equality.
        tolerance : The tolerance, in centimeters, to use when comparing the two points.
        Returns true if the points are equal (have identical coordinates).
        """
        return bool()
    @property
    def x(self) -> float:
        """
        Gets and sets the X coordinate of the point.
        """
        return float()
    @x.setter
    def x(self, value: float):
        """
        Gets and sets the X coordinate of the point.
        """
        pass
    @property
    def y(self) -> float:
        """
        Gets and sets the Y coordinate of the point.
        """
        return float()
    @y.setter
    def y(self, value: float):
        """
        Gets and sets the Y coordinate of the point.
        """
        pass

class Point3D(Base):
    """
    Transient 3D point. A transient point is not displayed or saved in a document.
    Transient 3D points are used as a wrapper to work with raw 3D point information.
    They are created statically using the create method of the Point3D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Point3D:
        return Point3D()
    @staticmethod
    def create(x: float, y: float, z: float) -> Point3D:
        """
        Creates a transient 3D point object.
        x : The x coordinate of the point
        y : The y coordinate of the point
        z : The z coordinate of the point
        Returns the new Point3D object or null if the creation failed.
        """
        return Point3D()
    def distanceTo(self, point: Point3D) -> float:
        """
        Returns the distance from this point to another point.
        point : The point to measure the distance to.
        Returns the distance to the point.
        """
        return float()
    def copy(self) -> Point3D:
        """
        Creates and returns a copy of this point object.
        Returns an independent copy of this point object.
        """
        return Point3D()
    def asArray(self) -> list[float]:
        """
        Get coordinate data of the point.
        Returns the coordinate data of the point as an array [x, y, z].
        """
        return [float()]
    def isEqualTo(self, point: Point3D) -> bool:
        """
        Checks to see if this point and another point are equal (have identical coordinates).
        The comparison is done within the modeling tolerance which can be found with the
        Application.pointTolerance property. If you want to compare two points with any other
        tolerance you can use the isEqualToByTolerance method.
        point : The point to compare for equality.
        Returns true if the points are equal (have identical coordinates).
        """
        return bool()
    def setWithArray(self, coordinates: list[float]) -> bool:
        """
        Sets the coordinates of the point using an array as input.
        coordinates : An array that defines the coordinates of the point [x, y, z].
        Returns true if successful.
        """
        return bool()
    def transformBy(self, matrix: Matrix3D) -> bool:
        """
        Transforms the point using the provided matrix.
        matrix : The Matrix3D object that defines the transformation.
        Returns true if successful.
        """
        return bool()
    def asVector(self) -> Vector3D:
        """
        Defines a vector using the coordinates of the point.
        Returns a Vector2D object.
        """
        return Vector3D()
    def translateBy(self, vector: Vector3D) -> bool:
        """
        Translates the point using the provided vector.
        vector : The vector to use to translate the point.
        Returns true if successful.
        """
        return bool()
    def getData(self) -> tuple[bool, float, float, float]:
        """
        Gets the data defining the point.
        x : The output x coordinate of the point.
        y : The output y coordinate of the point.
        z : The output z coordinate of the point.
        Returns true if successful.
        """
        return (bool(), float(), float(), float())
    def set(self, x: float, y: float, z: float) -> bool:
        """
        Sets the data defining the point.
        x : The x coordinate of the point.
        y : The y coordinate of the point.
        z : The z coordinate of the point.
        Returns true if successful.
        """
        return bool()
    def vectorTo(self, point: Point3D) -> Vector3D:
        """
        Returns a vector from this point to another point.
        point : The other point to use to create the vector.
        Returns a Vector3D object.
        """
        return Vector3D()
    def isEqualToByTolerance(self, point: Point3D, tolerance: float) -> bool:
        """
        Checks to see if this point and another point are equal within the specified tolerance.
        point : The point to compare for equality.
        tolerance : The tolerance, in centimeters, to use when comparing the two points.
        Returns true if the points are equal (have identical coordinates).
        """
        return bool()
    @property
    def x(self) -> float:
        """
        Gets and sets the X coordinate of the point.
        """
        return float()
    @x.setter
    def x(self, value: float):
        """
        Gets and sets the X coordinate of the point.
        """
        pass
    @property
    def y(self) -> float:
        """
        Gets and sets the Y coordinate of the point.
        """
        return float()
    @y.setter
    def y(self, value: float):
        """
        Gets and sets the Y coordinate of the point.
        """
        pass
    @property
    def z(self) -> float:
        """
        Gets and sets the Z coordinate of the point.
        """
        return float()
    @z.setter
    def z(self, value: float):
        """
        Gets and sets the Z coordinate of the point.
        """
        pass

class Preferences(Base):
    """
    The Preferences object provides access to the various preference related objects
    for getting and setting the various preference values.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Preferences:
        return Preferences()
    @property
    def generalPreferences(self) -> GeneralPreferences:
        """
        Gets the GeneralPreferences object.
        """
        return GeneralPreferences()
    @property
    def materialPreferences(self) -> MaterialPreferences:
        """
        Gets the MaterialPreferences object.
        """
        return MaterialPreferences()
    @property
    def graphicsPreferences(self) -> GraphicsPreferences:
        """
        Gets the GraphicsPreferences object.
        """
        return GraphicsPreferences()
    @property
    def networkPreferences(self) -> NetworkPreferences:
        """
        Gets the NetworkPreferences object.
        """
        return NetworkPreferences()
    @property
    def unitAndValuePreferences(self) -> UnitAndValuePreferences:
        """
        Gets the UnitAndValuePreferences object.
        """
        return UnitAndValuePreferences()
    @property
    def defaultUnitsPreferences(self) -> DefaultUnitsPreferencesCollection:
        """
        Gets the DefaultUnitsPreferences object.
        """
        return DefaultUnitsPreferencesCollection()
    @property
    def productPreferences(self) -> ProductPreferencesCollection:
        """
        Gets the ProductPreferences object.
        """
        return ProductPreferencesCollection()
    @property
    def gridPreferences(self) -> GridPreferences:
        """
        Gets the GridPreferences object.
        """
        return GridPreferences()
    @property
    def productUsageData(self) -> ProductUsageData:
        """
        Gets the ProductUsageData object.
        """
        return ProductUsageData()

class Product(Base):
    """
    The base class for the various product specific containers. For
    Fusion 360 this is the Design object. For manufacturing this is a CAM object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Product:
        return Product()
    def findAttributes(self, groupName: str, attributeName: str) -> list[Attribute]:
        """
        Find attributes attached to objects in this product that match the group and or attribute name.
        This does not find attributes attached directly to the Product or Document objects but finds the
        attributes attached to entities within the product.
        
        The search string for both the groupName and attributeName arguments can be either an absolute
        name value, or a regular expression. With an absolute name, the search string must match the
        entire groupName or attributeName, including case. An empty string will match everything.
        For example if you have an attribute group named "MyStuff" that contains the attribute "Length1",
        using the search string "MyStuff" as the group name and "Length1" as the attribute name will
        find the attributes with those names. Searching for "MyStuff" as the group name and "" as the
        attribute name will find all attributes that have "MyStuff" as the group name.
        
        Regular expressions provide a more flexible way of searching. To use a regular expression,
        prefix the input string for the groupName or attributeName arguments with "re:". The regular
        expression much match the entire group or attribute name. For example if you have a group that
        contains attributes named "Length1", "Length2", "Width1", and "Width2" and want to find any
        of the length attributes you can use a regular expression using the string "re:Length.*". For more
        information on attributes see the Attributes topic in the user manual.
        groupName : The search string for the group name. See above for more details.
        attributeName : The search string for the attribute name. See above for more details.
        An array of Attribute objects that were found. An empty array is returned if no attributes were found.
        """
        return [Attribute()]
    def deleteEntities(self, entities: ObjectCollection) -> bool:
        """
        Deletes the specified set of entities that are associated with this product.
        entities : An ObjectCollection containing the list of entities to delete.
        Returns True if any of the entities provided in the list were deleted. If
        entities were specified that can't be deleted or aren't owned by this product,
        they are ignored.
        """
        return bool()
    @property
    def parentDocument(self) -> Document:
        """
        Returns the parent Document object.
        """
        return Document()
    @property
    def unitsManager(self) -> UnitsManager:
        """
        Returns the UnitsManager object associated with this product.
        """
        return UnitsManager()
    @property
    def workspaces(self) -> WorkspaceList:
        """
        Returns the workspaces associated with this product.
        """
        return WorkspaceList()
    @property
    def productType(self) -> str:
        """
        Returns the product type name of this product. A list of all of
        the possible product types can be obtained by using the
        Application.supportedProductTypes property.
        """
        return str()
    @property
    def attributes(self) -> Attributes:
        """
        Returns the collection of attributes associated with this product.
        """
        return Attributes()

class ProductPreferences(Base):
    """
    The base class for the general product preferences. There is a derived class
    for each product where the specific preference values are exposed.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ProductPreferences:
        return ProductPreferences()
    @property
    def name(self) -> str:
        """
        Returns the name of this ProductPreferences object.
        """
        return str()

class ProductPreferencesCollection(Base):
    """
    A collection that provides access to product specific preference objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ProductPreferencesCollection:
        return ProductPreferencesCollection()
    def item(self, index: int) -> ProductPreferences:
        """
        Function that returns the specified ProductPreferences object using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ProductPreferences()
    def itemByName(self, name: str) -> ProductPreferences:
        """
        Returns the ProductPreference object with the specified name.
        name : The name of the ProductPreferences to return.
        Returns the ProductPreferences object or null if if an invalid name was specified.
        """
        return ProductPreferences()
    @property
    def count(self) -> int:
        """
        Returns the number of ProductPreference objects.
        """
        return int()

class Products(Base):
    """
    The Products object provides access to all of the products that exist in the document.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Products:
        return Products()
    def item(self, index: int) -> Product:
        """
        Function that returns the specified product using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Product()
    def itemByProductType(self, productType: str) -> Product:
        """
        Returns the specified product, if it exists within this document.
        productType : The product type string. For example, to get the product that represents the design data
        you use "DesignProductType" or to get the product that represent the CAM data you use "CAMProductType".
        
        A complete list of available products can be obtained by using the Application.supportedProductTypes property.
        Returns the specified item or null if the specified productType does not exist within this document.
        """
        return Product()
    @property
    def count(self) -> int:
        """
        Returns the number of products within the collection.
        """
        return int()

class ProductUsageData(Base):
    """
    Provides access to the product usage data settings.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ProductUsageData:
        return ProductUsageData()
    @property
    def isTrackingToImproveSoftwareEnabled(self) -> bool:
        """
        Gets and sets if tracking to improve the software is enabled.
        """
        return bool()
    @isTrackingToImproveSoftwareEnabled.setter
    def isTrackingToImproveSoftwareEnabled(self, value: bool):
        """
        Gets and sets if tracking to improve the software is enabled.
        """
        pass
    @property
    def isTrackingToImproveCommunicationEnabled(self) -> bool:
        """
        Gets and sets if tracking to improve communication is enabled.
        """
        return bool()
    @isTrackingToImproveCommunicationEnabled.setter
    def isTrackingToImproveCommunicationEnabled(self, value: bool):
        """
        Gets and sets if tracking to improve communication is enabled.
        """
        pass

class ProgressDialog(Base):
    """
    Provides access to the progress dialog.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ProgressDialog:
        return ProgressDialog()
    def show(self, title: str, message: str, minimumValue: int, maximumValue: int, delay: int) -> bool:
        """
        Displays the progress dialog that includes a progress bar that can be used to display a continually updated
        message indicating the progress of a process that will take more than a few seconds.
        The progress is determined by comparing the current progress value with the minimum and maximum values.
        title : Sets the title for the progress dialog
        message : The message to display along with the progress bar. The following symbols can be used
        to display values. "%p" is replaced by the percentage completed. "%v" is replaced
        by the current value. %m is replaced by the total number of steps. For example, the
        message "Processing section %v of %m." will result in the message "Processing section
        1 of 10." to be displayed if the maximum value is 10 and the current value is 1.
        minimumValue : The minimum value of the progress bar. This is used along with the maximum value and the
        progress value to compute the current percentage complete. This is also the initial
        progress value when the progress bar is first displayed.
        maximumValue : The maximum value of the progress bar. This is used along with the minimum value and the
        progress value to compute the current percentage complete.
        delay : Specifies the time interval in seconds to delay displaying the Progress Dialog. This provides a way to hide
        the progress dialog before it actually gets displayed, which is useful for cases where the progress of the
        operation being tracked completes quickly and there is no need to indicate progress to the user.
        Returns true if successful.
        """
        return bool()
    def hide(self) -> bool:
        """
        Hides the progress dialog. This should be used when the process has completed.
        Returns true if successful.
        """
        return bool()
    def reset(self) -> bool:
        """
        Method that resets the progress bar. The progress bar "rewinds" and shows no progress.
        This is the same as setting the progress value to the minimum value.
        Returns true if successful
        """
        return bool()
    @property
    def title(self) -> str:
        """
        Gets and sets the title of the progress dialog
        """
        return str()
    @title.setter
    def title(self, value: str):
        """
        Gets and sets the title of the progress dialog
        """
        pass
    @property
    def message(self) -> str:
        """
        Gets and sets the message to display along with the progress bar. The following symbols can be used
        to display values. "%p" is replaced by the percentage completed. "%v" is replaced
        by the current value. %m is replaced by the total number of steps. For example, the
        message "Processing section %v of %m." will result in the message "Processing section
        1 of 10." to be displayed if the maximum value is 10 and the current value is 1.
        Specify an empty string ("") for no message to appear along with the progress panel.
        """
        return str()
    @message.setter
    def message(self, value: str):
        """
        Gets and sets the message to display along with the progress bar. The following symbols can be used
        to display values. "%p" is replaced by the percentage completed. "%v" is replaced
        by the current value. %m is replaced by the total number of steps. For example, the
        message "Processing section %v of %m." will result in the message "Processing section
        1 of 10." to be displayed if the maximum value is 10 and the current value is 1.
        Specify an empty string ("") for no message to appear along with the progress panel.
        """
        pass
    @property
    def minimumValue(self) -> int:
        """
        The minimum value of the progress bar. This is used along with the maximum value and the
        progress value to compute the current percentage complete. This is also the initial
        progress value when the progress bar is first displayed.
        """
        return int()
    @minimumValue.setter
    def minimumValue(self, value: int):
        """
        The minimum value of the progress bar. This is used along with the maximum value and the
        progress value to compute the current percentage complete. This is also the initial
        progress value when the progress bar is first displayed.
        """
        pass
    @property
    def maximumValue(self) -> int:
        """
        The maximum value of the progress bar. This is used along with the minimum value and the
        progress value to compute the current percentage complete.
        """
        return int()
    @maximumValue.setter
    def maximumValue(self, value: int):
        """
        The maximum value of the progress bar. This is used along with the minimum value and the
        progress value to compute the current percentage complete.
        """
        pass
    @property
    def progressValue(self) -> int:
        """
        Gets and sets the current progress bar value. Progress is determined based on this value relative to
        the minimum and maximum values. This will update the values displayed
        in the message string.
        """
        return int()
    @progressValue.setter
    def progressValue(self, value: int):
        """
        Gets and sets the current progress bar value. Progress is determined based on this value relative to
        the minimum and maximum values. This will update the values displayed
        in the message string.
        """
        pass
    @property
    def isCancelButtonShown(self) -> bool:
        """
        Gets and sets if the cancel button is included in the dialog. This is false by default.
        """
        return bool()
    @isCancelButtonShown.setter
    def isCancelButtonShown(self, value: bool):
        """
        Gets and sets if the cancel button is included in the dialog. This is false by default.
        """
        pass
    @property
    def wasCancelled(self) -> bool:
        """
        Indicates if the cancel button was selected the last time the Progress Dialog was shown.
        """
        return bool()
    @property
    def cancelButtonText(self) -> str:
        """
        Sets the text label on the Cancel button. The default text label is "Cancel".
        """
        return str()
    @cancelButtonText.setter
    def cancelButtonText(self, value: str):
        """
        Sets the text label on the Cancel button. The default text label is "Cancel".
        """
        pass
    @property
    def isBackgroundTranslucent(self) -> bool:
        """
        Gets and sets if the dialog background is translucent. This is false by default
        """
        return bool()
    @isBackgroundTranslucent.setter
    def isBackgroundTranslucent(self, value: bool):
        """
        Gets and sets if the dialog background is translucent. This is false by default
        """
        pass
    @property
    def isShowing(self) -> bool:
        """
        Gets if the Progress Dialog is currently being displayed
        """
        return bool()

class Properties(Base):
    """
    A collection of properties that are associated with a material or appearance.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Properties:
        return Properties()
    def item(self, index: int) -> Property:
        """
        Returns the specified property from the collection using an index into the collection.
        index : The index of the property within the collection where the first item is 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Property()
    def itemById(self, id: str) -> Property:
        """
        Returns the specified property from the collection using the unique ID of the property.
        id : The unique ID of the property.
        Returns the specified property or null if the ID doesn't match a property within the collection.
        """
        return Property()
    def itemByName(self, name: str) -> Property:
        """
        Returns the specified Property using the name of the property.
        name : The name of the property to return. This is the name as seen in the user interface.
        Returns the specified property or null if the name doesn't match a property within the collection.
        """
        return Property()
    @property
    def count(self) -> int:
        """
        Returns the number of properties within the collection.
        """
        return int()

class Property(Base):
    """
    The base class for the specific property types used by materials and appearances.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Property:
        return Property()
    @property
    def name(self) -> str:
        """
        Returns the name of this property as seen in the user interface. This name is localized
        and can change based on the current language
        """
        return str()
    @property
    def isReadOnly(self) -> bool:
        """
        Indicates if this property is read-only. If True any attempted edits will fail.
        """
        return bool()
    @property
    def id(self) -> str:
        """
        Returns the unique ID of this property.
        """
        return str()
    @property
    def parent(self) -> Base:
        """
        Returns the parent of this property.
        """
        return Base()

class RadialMarkingMenu(Base):
    """
    Represents the marking menu which is the round menu that's displayed when the user right-clicks
    within Fusion 360. This supports customizing the contents of the marking menu.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RadialMarkingMenu:
        return RadialMarkingMenu()
    def create(self, text: str) -> RadialMarkingMenu:
        """
        This is used to create a sub-menu in a marking menu. This method creates a new,
        empty marking menu which can then be assigned to a position in the displayed
        marking menu to define the sub-menu.
        text : The text that will be displayed in the parent menu to access this menu.
        Returns the newly created marking menu or null in the case of a failure.
        """
        return RadialMarkingMenu()
    def clear(self) -> bool:
        """
        Completely clears the contents of the marking menu. If left in this state, the
        marking menu will not be displayed.
        Returns true if the clear was successful.
        """
        return bool()
    @property
    def text(self) -> str:
        """
        Gets and sets the text that is displayed in the parent marking menu to access a
        sub marking menu. This property is not used for the main marking menu and will
        return an empty string and setting it will have no effect.
        """
        return str()
    @text.setter
    def text(self, value: str):
        """
        Gets and sets the text that is displayed in the parent marking menu to access a
        sub marking menu. This property is not used for the main marking menu and will
        return an empty string and setting it will have no effect.
        """
        pass
    @property
    def eastCommand(self) -> Base:
        """
        Gets and sets the command definition that's displayed in the East position (right) of
        the marking menu. Setting this to null indicates that the East position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        return Base()
    @eastCommand.setter
    def eastCommand(self, value: Base):
        """
        Gets and sets the command definition that's displayed in the East position (right) of
        the marking menu. Setting this to null indicates that the East position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        pass
    @property
    def northCommand(self) -> Base:
        """
        Gets and sets the command definition that's displayed in the North position (top) of the
        marking menu. Setting this to null indicates that the North position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        return Base()
    @northCommand.setter
    def northCommand(self, value: Base):
        """
        Gets and sets the command definition that's displayed in the North position (top) of the
        marking menu. Setting this to null indicates that the North position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        pass
    @property
    def northeastCommand(self) -> Base:
        """
        Gets and sets the command definition that's displayed in the Northeast position (top-right) of
        the marking menu. Setting this to null indicates that the Northeast position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        return Base()
    @northeastCommand.setter
    def northeastCommand(self, value: Base):
        """
        Gets and sets the command definition that's displayed in the Northeast position (top-right) of
        the marking menu. Setting this to null indicates that the Northeast position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        pass
    @property
    def westCommand(self) -> Base:
        """
        Gets and sets the command definition that's displayed in the West position (left) of
        the marking menu. Setting this to null indicates that the West position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        return Base()
    @westCommand.setter
    def westCommand(self, value: Base):
        """
        Gets and sets the command definition that's displayed in the West position (left) of
        the marking menu. Setting this to null indicates that the West position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        pass
    @property
    def northwestCommand(self) -> Base:
        """
        Gets and sets the command definition that's displayed in the Northwest position (upper-left) of
        the marking menu. Setting this to null indicates that the Northwest position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        return Base()
    @northwestCommand.setter
    def northwestCommand(self, value: Base):
        """
        Gets and sets the command definition that's displayed in the Northwest position (upper-left) of
        the marking menu. Setting this to null indicates that the Northwest position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        pass
    @property
    def southwestCommand(self) -> Base:
        """
        Gets and sets the command definition that's displayed in the Southwest position (bottom-left) of
        the marking menu. Setting this to null indicates that the Southwest position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        return Base()
    @southwestCommand.setter
    def southwestCommand(self, value: Base):
        """
        Gets and sets the command definition that's displayed in the Southwest position (bottom-left) of
        the marking menu. Setting this to null indicates that the Southwest position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        pass
    @property
    def southCommand(self) -> Base:
        """
        Gets and sets the command definition that's displayed in the South position (bottom) of
        the marking menu. Setting this to null indicates that the South position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        return Base()
    @southCommand.setter
    def southCommand(self, value: Base):
        """
        Gets and sets the command definition that's displayed in the South position (bottom) of
        the marking menu. Setting this to null indicates that the South position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        pass
    @property
    def southeastCommand(self) -> Base:
        """
        Gets and sets the command definition that's displayed in the Southeast position (bottom-right) of
        the marking menu. Setting this to null indicates that the Southeast position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        return Base()
    @southeastCommand.setter
    def southeastCommand(self, value: Base):
        """
        Gets and sets the command definition that's displayed in the Southeast position (bottom-right) of
        the marking menu. Setting this to null indicates that the Southeast position should be empty.
        
        This can also return or be set with a MarkingMenu object which is used to have a sub-menu.
        New marking menus can be created using the create method and then assigned
        to the desired position in the marking menu.
        """
        pass

class Selection(Base):
    """
    Provides access to a selection of an entity in the user interface.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Selection:
        return Selection()
    @property
    def entity(self) -> Base:
        """
        Gets the selected entity.
        """
        return Base()
    @property
    def point(self) -> Point3D:
        """
        Gets the selection point on the object.
        """
        return Point3D()

class SelectionEventHandler(EventHandler):
    """
    An event handler base class that a client derives from to handle events triggered by a SelectionEvent.
    A client implemented instance of this class can be added to a SelectionEvent to receive these event notifications.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SelectionEventHandler:
        return SelectionEventHandler()
    def notify(self, eventArgs: SelectionEventArgs) -> None:
        """
        This notify member is called when an event is triggered from any event that this handler has been added to.
        eventArgs : The arguments object with details about this event and the firing SelectionEvent.
        """
        pass

class Selections(Base):
    """
    Provides access to and control over the set of selected entities in the user interface.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Selections:
        return Selections()
    def item(self, index: int) -> Selection:
        """
        Returns the specified selection using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Selection()
    def add(self, entity: Base) -> bool:
        """
        Adds the entity to the set of currently selected entities.
        The user will see the entity become selected in the user interface.
        entity : The entity to select and add to this selection set.
        Returns true if successful.
        """
        return bool()
    def clear(self) -> bool:
        """
        Clears the selection set so no entities are currently selected.
        Returns true if successful.
        """
        return bool()
    def removeBySelection(self, selection: Selection) -> bool:
        """
        Removes the specified selection from the set of selected entities.
        selection : The selection to remove.
        Returns true if the item was removed or not currently selected.
        """
        return bool()
    def removeByEntity(self, entity: Base) -> bool:
        """
        Removes the selections that are associated with the specified entity from the set of selected entities.
        entity : The entity to remove selections of.
        Returns true if the item was removed or not currently selected.
        """
        return bool()
    def removeByIndex(self, index: int) -> bool:
        """
        Removes an item from the set of selected entities.
        index : The index of the selection to remove.
        Returns true if the item was removed successfully.
        """
        return bool()
    def asArray(self) -> list[Selection]:
        """
        Returns an array containing all of the current selections. This is
        useful in cases where you need to iterate over the set of selected entities but need
        to create or edit data as you process each one. Selections are fragile and creation and
        edit operations will clear the selections so you won't have access to the complete list
        after processing the first one.
        Returns an array of all of the current selections. Selection objects are returned so
        you'll need to call their entity properties to get the actual selected entity.
        """
        return [Selection()]
    @property
    def count(self) -> int:
        """
        Gets the number of entities currently selected.
        """
        return int()
    @property
    def all(self) -> ObjectCollection:
        """
        Gets or sets all entities currently selected.
        """
        return ObjectCollection()
    @all.setter
    def all(self, value: ObjectCollection):
        """
        Gets or sets all entities currently selected.
        """
        pass

class Status(Base):
    """
    Used to communicate the current status of an object or operation. This provides the status
    and any error messages that might accompany an error or warning.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Status:
        return Status()
    @property
    def isError(self) -> bool:
        """
        If true, An error occurred that has prevented the operation from successfully completing.
        This takes into account all of the child status messages.
        """
        return bool()
    @property
    def isWarning(self) -> bool:
        """
        If true, the operation has succeeded but with an unusual result.
        This takes into account all of the child status messages.
        """
        return bool()
    @property
    def isOK(self) -> bool:
        """
        If true, the operation was successful without any warnings or errors.
        This takes into account all of the child status messages.
        """
        return bool()
    @property
    def statusMessages(self) -> StatusMessages:
        """
        the status messages associated with this status. These messages are displayed to
        the user in the alert dialog. Each status message can have children status
        messages that will be displayed as a tree structure in the alert dialog.
        """
        return StatusMessages()

class StatusMessage(Base):
    """
    Defines the message associated with a Status object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> StatusMessage:
        return StatusMessage()
    @property
    def messageId(self) -> str:
        """
        Gets and sets the ID of the message being used. This is a predefined ID within the Fusion message
        string table.
        """
        return str()
    @messageId.setter
    def messageId(self, value: str):
        """
        Gets and sets the ID of the message being used. This is a predefined ID within the Fusion message
        string table.
        """
        pass
    @property
    def message(self) -> str:
        """
        The user visible message being used. Setting this message for custom feature errors or warnings is
        currently ignored.
        """
        return str()
    @message.setter
    def message(self, value: str):
        """
        The user visible message being used. Setting this message for custom feature errors or warnings is
        currently ignored.
        """
        pass
    @property
    def statusMessageType(self) -> StatusMessageTypes:
        """
        Returns the type of message this StatusMessage represents.
        """
        return StatusMessageTypes()
    @property
    def childStatusMessages(self) -> StatusMessages:
        """
        Returns the collection of status codes that are children of
        this status message.
        """
        return StatusMessages()

class StatusMessages(Base):
    """
    A collection of status messages associated with a Status object. The primary purpose of the messages is to
    describe the reason for a warning or failure and display the messages in the alert dialog.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> StatusMessages:
        return StatusMessages()
    def item(self, index: int) -> StatusMessage:
        """
        Returns the specified status message using an index into the collection.
        index : The index of the status message within the collection to return. The first item in the collection has an index of 0.
        Returns the specified StatusMessage or null if an invalid index was specified.
        """
        return StatusMessage()
    def addError(self, messageId: str, message: str) -> StatusMessage:
        """
        Adds a new error status message to the list of warning and error messages.
        messageId : The ID of a predefined message or if an empty string is provided, the
        default error message will be used. The displayed message is localized based on the
        current default language in Fusion. Below is a list of some valid message ID's and
        the corresponding English message.
        <br/><br/>
        "API_COMPUTE_ERROR" - "Cannot compute this feature."<br />
        "API_COMPUTE_WARNING" - "This feature computed with warnings."<br />
        "CFLANGE_INVALID_GEOM" - "Invalid input sketch curve."<br />
        "DRAFT_MISSING_FACE_REFERENCES" - "Missing face references"<br />
        "DRAFT_MISSING_REFERENCE_PLANE" - "Missing reference plane"<br />
        "FEATURE_ENTITY_TYPE_INVALID" - "Entity type is invalid"<br />
        "FEATURE_FAILED_TO_CREATE" - "Failed to create feature"<br />
        "FEATURE_MISSING_INPUTS" - "Missing inputs"<br />
        "FEATURE_REFERENCE_LOST" - "Reference is lost"<br />
        "Feature_Compute_Error" - "Compute Failed"<br />
        "Feature_Input_Compute_Error" - "Reference Failures"<br />
        "InvalidWPntInput" - "Invalid input"<br />
        "NO_TARGET_BODY" - "No target body!"<br />
        "ORIGIN_SELECTION_MISSING" - "Origin geometry is missing."<br />
        "DRPOINT_COMPUTE_FAILED" - "Failed to evaluate the point due to the invalid input"<br />
        message : This is not currently supported for custom feature compute errors and will be ignored.
        Returns true if the error message was successfully added.
        """
        return StatusMessage()
    def addWarning(self, messageId: str, message: str) -> StatusMessage:
        """
        Adds a new warning status message to the list of warning and error messages.
        messageId : The ID of a predefined message or if an empty string is provided, the
        default error message will be used. The displayed message is localized based on the
        current default language in Fusion. Below is a list of some valid message ID's and
        the corresponding English message.
        <br/><br/>
        "API_COMPUTE_ERROR" - "Cannot compute this feature."<br />
        "API_COMPUTE_WARNING" - "This feature computed with warnings."<br />
        "CFLANGE_INVALID_GEOM" - "Invalid input sketch curve."<br />
        "DRAFT_MISSING_FACE_REFERENCES" - "Missing face references"<br />
        "DRAFT_MISSING_REFERENCE_PLANE" - "Missing reference plane"<br />
        "FEATURE_ENTITY_TYPE_INVALID" - "Entity type is invalid"<br />
        "FEATURE_FAILED_TO_CREATE" - "Failed to create feature"<br />
        "FEATURE_MISSING_INPUTS" - "Missing inputs"<br />
        "FEATURE_REFERENCE_LOST" - "Reference is lost"<br />
        "Feature_Compute_Error" - "Compute Failed"<br />
        "Feature_Input_Compute_Error" - "Reference Failures"<br />
        "InvalidWPntInput" - "Invalid input"<br />
        "NO_TARGET_BODY" - "No target body!"<br />
        "ORIGIN_SELECTION_MISSING" - "Origin geometry is missing."<br />
        "DRPOINT_COMPUTE_FAILED" - "Failed to evaluate the point due to the invalid input"<br />
        message : This is not currently supported for custom feature compute errors and will be ignored.
        Returns true if the warning message was successfully added.
        """
        return StatusMessage()
    @property
    def count(self) -> int:
        """
        Returns the number of status messages in this collection.
        """
        return int()

class Surface(Base):
    """
    Describes a two-dimensional topological, manifold in three-dimensional space.
    It is used as the underlying geometry for a BRepFace.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Surface:
        return Surface()
    def transformBy(self, matrix: Matrix3D) -> bool:
        """
        Updates this surface by transforming it with a given input matrix.
        matrix : A 3D matrix that defines the transform to apply to the surface.
        Returns true if the transform was successful.
        """
        return bool()
    @property
    def surfaceType(self) -> SurfaceTypes:
        """
        Returns the surface type.
        """
        return SurfaceTypes()
    @property
    def evaluator(self) -> SurfaceEvaluator:
        """
        Returns the surface evaluator.
        """
        return SurfaceEvaluator()

class SurfaceEvaluator(Base):
    """
    Surface evaluator that is obtained from a transient surface and allows you to perform
    various evaluations on the surface.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SurfaceEvaluator:
        return SurfaceEvaluator()
    def getModelCurveFromParametricCurve(self, parametricCurve: Curve2D) -> ObjectCollection:
        """
        Creates the 3D equivalent curve in model space, of a 2D curve defined in the
        parametric space of the surface.
        parametricCurve : The parameter space curve to map into this surface's parameter space.
        Returns an ObjectCollection containing one or more curves.
        When the SufaceEvaluatior is obtained from a face, and the curve cuts across internal
        boundaries of the face, multiple curves are returned. The returned curves are trimmed
        to the boundaries of the face.
        If the SurfaceEvaluator is obtained from a geometry object, a single curve returned
        because there are no boundaries with which to trim the curve.
        The type of curve(s) returned depends on the shape of the input curve and surface.
        """
        return ObjectCollection()
    def getIsoCurve(self, parameter: float, isUDirection: bool) -> ObjectCollection:
        """
        Gets (by extraction) a curve that follows a constant u or v parameter along the surface.
        The curve will have the same properties as the surface in the direction of the extraction.
        For example, when a curve is extracted from the periodic direction of a surface, the extracted
        curve will also be periodic.
        The type of curve returned is dependent on the shape the surface.
        parameter : The parameter at which to extract the curve
        isUDirection : A bool that indicates whether to extract the curve from the U or V direction
        Returns an ObjectCollection that contains one or more curves.
        Multiple curves are returned when the SurfaceEvaluator is obtained from a Face
        and the curve cuts across internal boundaries. The resulting curves are trimmed to the
        boundaries of the Face.
        When the SurfaceEvaluator is obtained from a geometry object, a single curve is returned
        because there are no boundaries to trim the curve.
        The type of curve(s) returned is dependent on the shape of the surface.
        """
        return ObjectCollection()
    def getCurvatures(self, parameters: list[Point2D]) -> tuple[bool, list[Vector3D], list[float], list[float]]:
        """
        Get the curvature values at a number of parameter positions on the surface.
        parameters : The array of parameter positions to return curvature information at.
        Each parameter position must be with the range of the parameter extents as verified by isParameterOnFace.
        maxTangents : The output array of directions of maximum curvature at each position on the surface.
        The length of this array will be the same as the length of the parameters array provided.
        maxCurvatures : The output array of the magnitude of the maximum curvature at each position on the surface.
        The length of this array will be the same as the length of the parameters array provided.
        minCurvatures : The output array of the magnitude of the minimum curvature at each position on the surface.
        The minimum curvature direction is perpendicular to the maximum curvature tangent directions.
        The length of this array will be the same as the length of the parameters array provided.
        Returns true if the curvatures were successfully returned.
        """
        return (bool(), [Vector3D()], [float()], [float()])
    def getCurvature(self, parameter: Point2D) -> tuple[bool, Vector3D, float, float]:
        """
        Get the curvature values at a parameter positions on the surface.
        parameter : The parameter positions to return curvature information at.
        maxTangent : The output directions of maximum curvature at the position on the surface.
        maxCurvature : The output magnitude of the maximum curvature at the position on the surface.
        minCurvature : The output magnitude of the minimum curvature at the position on the surface.
        The minimum curvature direction is perpendicular to the maximum curvature tangent directions.
        Returns true if the curvature was successfully returned.
        """
        return (bool(), Vector3D(), float(), float())
    def getNormalsAtParameters(self, parameters: list[Point2D]) -> tuple[bool, list[Vector3D]]:
        """
        Gets the surface normal at a number of parameter positions on the surface.
        parameters : The array of parameter positions to return the normal at.
        Each parameter position must be with the range of the parameter extents as verified by isParameterOnFace.
        normals : The output array of normals for each parameter position on the surface.
        The length of this array will be the same as the length of the parameters array provided.
        Returns true if the normals were successfully returned.
        """
        return (bool(), [Vector3D()])
    def getNormalAtParameter(self, parameter: Point2D) -> tuple[bool, Vector3D]:
        """
        Gets the surface normal at a parameter position on the surface.
        parameter : The parameter position to return the normal at.
        The parameter position must be with the range of the parameter extents as verified by isParameterOnFace.
        normal : The output normal for the parameter position on the surface.
        Returns true if the normal was successfully returned.
        """
        return (bool(), Vector3D())
    def getNormalsAtPoints(self, points: list[Point3D]) -> tuple[bool, list[Vector3D]]:
        """
        Gets the surface normal at a number of positions on the surface.
        points : The array of points to return the normal at.
        For reliable results each point should lie on the surface.
        normals : The output array of normals for each point on the surface.
        The length of this array will be the same as the length of the points array provided.
        Returns true if the normals were successfully returned.
        """
        return (bool(), [Vector3D()])
    def getNormalAtPoint(self, point: Point3D) -> tuple[bool, Vector3D]:
        """
        Gets the surface normal at a point on the surface.
        point : The point to return the normal at.
        For reliable results the point should lie on the surface.
        normal : The output normal for the point on the surface.
        Returns true if the normal was successfully returned.
        """
        return (bool(), Vector3D())
    def getParametersAtPoints(self, points: list[Point3D]) -> tuple[bool, list[Point2D]]:
        """
        Get the parameter positions that correspond to a set of points on the surface.
        For reliable results, the points should lie on the surface within model tolerance.
        If the points do not lie on the surface, the parameter of the nearest point on the surface will generally be returned.
        points : An array of points to get the surface parameter values at.
        parameters : The output array of parameter positions corresponding to the set of points.
        The length of this array will be equal to the length of the points array specified.
        Returns true if the parameters were successfully returned.
        """
        return (bool(), [Point2D()])
    def getParameterAtPoint(self, point: Point3D) -> tuple[bool, Point2D]:
        """
        Get the parameter position that correspond to a point on the surface.
        For reliable results, the point should lie on the surface within model tolerance.
        If the point does not lie on the surface, the parameter of the nearest point on the surface will generally be returned.
        point : The point to get the curve parameter value at.
        parameter : The output parameter position corresponding to the point.
        Returns true of the parameter was successfully returned.
        """
        return (bool(), Point2D())
    def getPointsAtParameters(self, parameters: list[Point2D]) -> tuple[bool, list[Point3D]]:
        """
        Get the points on the surface that correspond to evaluating a set of parameter positions on the surface.
        parameters : The array of parameter positions to evaluate the surface position at.
        Each parameter position must be within the range of the parameter extents as verified by isParameterOnFace.
        points : The output array of points corresponding to evaluating the curve at that parameter position.
        The length of this array will be equal to the length of the parameters array specified.
        Returns true if the points were successfully returned.
        """
        return (bool(), [Point3D()])
    def getPointAtParameter(self, parameter: Point2D) -> tuple[bool, Point3D]:
        """
        Get the point on the surface that correspond to evaluating a parameter position on the surface.
        parameter : The parameter positions to evaluate the surface position at.
        The parameter position must be within the range of the parameter extents as verified by isParameterOnFace.
        point : The output point corresponding to evaluating the curve at that parameter position.
        Returns true if the point was successfully returned.
        """
        return (bool(), Point3D())
    def getParamAnomaly(self) -> tuple[bool, list[float], list[float], list[float], list[float], list[bool]]:
        """
        Gets details about anomalies in parameter space of the surface.
        This includes information about periodic intervals, singularities, or unbounded parameter ranges.
        periodicityU : The output array with information about the period of the surface in U.
        periodicityU[0] will contain the period of the surface in U.
        If periodicityU[0] is 0, the surface is not periodic in U.
        If the surface is periodic in U, peridocityU[1] will contain the parameter value at the start of the principle period.
        periodicityV : The output array with information about the period of the surface in V.
        periodicityV[0] will contain the period of the surface in V.
        If periodicityV[0] is 0, the surface is not periodic in V.
        If the surface is periodic in V, peridocityV[1] will contain the parameter value at the start of the principle period.
        singularitiesU : The output array parameter values of singularities in U.
        If this array is empty, there are no singularities in U.
        singularitiesV : The output array parameter values of singularities in V.
        If this array is empty, there are no singularities in V.
        unboundedParameters : The output array that indicates if the parameter range is unbounded in U or V.
        unboundedParameters[0] will be true if U is unbounded.
        unboundedParameters[1] will be true if V is unbounded.
        Returns true if the parameter anomalies were successfully returned.
        """
        return (bool(), [float()], [float()], [float()], [float()], [bool()])
    def getFirstDerivatives(self, parameters: list[Point2D]) -> tuple[bool, list[Vector3D], list[Vector3D]]:
        """
        Get the first derivatives of the surface at the specified parameter positions.
        parameters : The array of parameter positions to get the surface first derivative at.
        Each parameter position must be within the range of the parameter extents as verified by isParameterOnFace.
        partialsU : The output array of first derivative U partial vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        partialsV : The output array of first derivative V partial vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        Returns true if the first derivatives were successfully returned.
        """
        return (bool(), [Vector3D()], [Vector3D()])
    def getFirstDerivative(self, parameter: Point2D) -> tuple[bool, Vector3D, Vector3D]:
        """
        Get the first derivative of the surface at the specified parameter position.
        parameter : The parameter positions to get the surface first derivative at.
        The parameter position must be within the range of the parameter extents as verified by isParameterOnFace.
        partialU : The output first derivative U partial vector at the parameter position specified.
        partialV : The output first derivative V partial vector at the parameter position specified.
        Returns true if the first derivative was successfully returned.
        """
        return (bool(), Vector3D(), Vector3D())
    def getSecondDerivatives(self, parameters: list[Point2D]) -> tuple[bool, list[Vector3D], list[Vector3D], list[Vector3D]]:
        """
        Get the second derivatives of the surface at the specified parameter positions.
        parameters : The array of parameter positions to get the surface second derivative at.
        Each parameter position must be within the range of the parameter extents as verified by isParameterOnFace.
        partialsUU : The output array of second derivative UU partial vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        partialsUV : The output array of second derivative UV mixed partial vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        partialsVV : The output array of second derivative VV partial vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        Returns true if the second derivatives were successfully returned.
        """
        return (bool(), [Vector3D()], [Vector3D()], [Vector3D()])
    def getSecondDerivative(self, parameter: Point2D) -> tuple[bool, Vector3D, Vector3D, Vector3D]:
        """
        Get the second derivative of the surface at the specified parameter position.
        parameter : The parameter position to get the surface second derivative at.
        The parameter position must be within the range of the parameter extents as verified by isParameterOnFace.
        partialUU : The output second derivative UU partial vector at each parameter position specified.
        partialUV : The output second derivative UV mixed partial vector at each parameter position specified.
        partialVV : The output second derivative VV partial vector at each parameter position specified.
        Returns true if the second derivative was successfully returned.
        """
        return (bool(), Vector3D(), Vector3D(), Vector3D())
    def getThirdDerivatives(self, parameters: list[Point2D]) -> tuple[bool, list[Vector3D], list[Vector3D]]:
        """
        Get the third derivatives of the surface at the specified parameter positions.
        parameters : The array of parameter positions to get the surface third derivative at.
        Each parameter position must be within the range of the parameter extents as verified by isParameterOnFace.
        partialsUUU : The output array of third derivative UUU partial vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        partialsVVV : The output array of third derivative VVV partial vectors at each parameter position specified.
        The length of this array is equal to the length of the parameters array specified.
        Returns true if the third derivatives were successfully returned.
        """
        return (bool(), [Vector3D()], [Vector3D()])
    def getThirdDerivative(self, parameter: Point2D) -> tuple[bool, Vector3D, Vector3D]:
        """
        Get the third derivative of the surface at the specified parameter position.
        parameter : The parameter position to get the surface third derivative at.
        The parameter position must be within the range of the parameter extents as verified by isParameterOnFace.
        partialUUU : The output third derivative UUU partial vector at each parameter position specified.
        partialVVV : The output third derivative VVV partial vector at each parameter position specified.
        Returns true if the third derivative was successfully returned.
        """
        return (bool(), Vector3D(), Vector3D())
    def isParameterOnFace(self, parameter: Point2D) -> bool:
        """
        Determines if the specified parameter position lies with the parametric range of the surface.
        parameter : The parameter position to test.
        Returns true if the parameter position lies within the valid parametric range of the surface.
        """
        return bool()
    def parametricRange(self) -> BoundingBox2D:
        """
        Returns the parametric range of the surface.
        If the surface is periodic in a direction, the range is set to the principle period's range.
        If the surface is only upper bounded in a direction, the lower bound is set to -double-max.
        If the surface is only lower bounded in a direction, the upper bound is set to double-max.
        If the surface is unbounded in a direction, the lower bound and upper bound of the range will both be zero.
        Returns the bounding box with the parameter extents, with the X value being the U range, and the Y value being the V range.
        """
        return BoundingBox2D()
    @property
    def isClosedInU(self) -> bool:
        """
        Indicates if the surface is closed (forms a loop) in the U direction
        """
        return bool()
    @property
    def isClosedInV(self) -> bool:
        """
        Indicates if the surface is closed (forms a loop) in the V direction
        """
        return bool()
    @property
    def area(self) -> float:
        """
        Returns the area of the surface. This is typically used when the SurfaceEvaluator is associated
        with a BRepFace object where it is always valid. This can fail in the case where the SurfaceEvaluator is
        associated with one of the geometry classes, (Plane, Cylinder, Cone, EllipticalCone, or EllipticalCylinder
        object), because these surfaces are unbounded. A BRepFace, even one of these shapes, is bounded by its
        edges and has a well-defined area.
        """
        return float()

class Toolbar(Base):
    """
    Provides access to a toolbar in the user interface. A toolbar is a collection of toolbar controls.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Toolbar:
        return Toolbar()
    @property
    def id(self) -> str:
        """
        Gets the unique ID of the toolbar that can be used programmatically
        to find a specific toolbar.
        """
        return str()
    @property
    def parentUserInterface(self) -> UserInterface:
        """
        Gets the owning UserInterface object.
        """
        return UserInterface()
    @property
    def controls(self) -> ToolbarControls:
        """
        Gets the controls in this toolbar.
        """
        return ToolbarControls()

class ToolbarControl(Base):
    """
    The base class for all toolbar controls.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ToolbarControl:
        return ToolbarControl()
    def deleteMe(self) -> bool:
        """
        Deletes the ToolbarControl
        Returns a boolean indicating if the deletion was successful.
        """
        return bool()
    @property
    def id(self) -> str:
        """
        Gets the unique ID of this control. The ID is unique with respect to the other
        controls within the same panel, toolbar, or drop-down control.
        """
        return str()
    @property
    def index(self) -> int:
        """
        Gets the position of this control within the list of controls within the panel, toolbar, or drop-down control.
        """
        return int()
    @property
    def isVisible(self) -> bool:
        """
        Gets or sets if this control is currently visible.
        """
        return bool()
    @isVisible.setter
    def isVisible(self, value: bool):
        """
        Gets or sets if this control is currently visible.
        """
        pass
    @property
    def parent(self) -> Base:
        """
        Gets the Parent object. When associated with a toolbar (right or left QAT or the NavBar) this
        returns the parent Toolbar object. When associated with a panel it returns the parent ToolbarPanel object.
        When associated with a control (DropDownControl) it returns the parent control.
        """
        return Base()

class ToolbarControlList(Base):
    """
    Provides access to a list of toolbar controls.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ToolbarControlList:
        return ToolbarControlList()
    def item(self, index: int) -> ToolbarControl:
        """
        Returns the ToolbarControl at the specified index.
        When iterating by index, the controls are returned
        in the same order as they are shown in the user interface.
        index : The index of the control within the collection to return. The first item in the
        collection has in index of 0.
        Returns the ToolbarControl at the specified index or null if an invalid index was specified.
        """
        return ToolbarControl()
    def itemById(self, id: str) -> ToolbarControl:
        """
        Returns the ToolbarControl at the specified ID.
        id : The ID of the control within the collection to return.
        Returns the ToolbarControl with the specified ID or null if no control has this ID.
        """
        return ToolbarControl()
    @property
    def count(self) -> int:
        """
        Gets the number of toolbar controls.
        """
        return int()

class ToolbarControls(Base):
    """
    ToolbarControls is a collection of ToolbarControl objects displayed in a toolbar or menu.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ToolbarControls:
        return ToolbarControls()
    def item(self, index: int) -> ToolbarControl:
        """
        Returns the ToolbarControl at the specified index.
        When iterating by index, the controls are returned
        in the same order as they are shown in the user interface.
        index : The index of the control within the collection to return. The first item in the
        collection has in index of 0.
        Returns the ToolbarControl at the specified index or null if an invalid index was specified.
        """
        return ToolbarControl()
    def itemById(self, id: str) -> ToolbarControl:
        """
        Returns the ToolbarControl at the specified ID.
        id : The ID of the control within the collection to return.
        Returns the ToolbarControl with the specified ID or null if no control has this ID.
        """
        return ToolbarControl()
    def addCommand(self, commandDefinition: CommandDefinition, positionID: str, isBefore: bool) -> CommandControl:
        """
        Adds a button to the controls in the toolbar, panel, or drop-down. The ID of the created
        command control is inherited from the associated command definition.
        commandDefinition : The associated CommandDefinition that defines the resources and receives events related to this control.
        positionID : Specifies the reference id of the control to position this control relative to.
        Not setting this value indicates that the control will be created at the end of all other controls in toolbar. The isBefore
        parameter specifies whether to place the control before or after the reference control.
        isBefore : Specifies whether to place the control before or after the reference control specified by the positionID parameter.
        This argument is ignored is positionID is not specified.
        Returns the newly created CommandControl object or null if the creation fails.
        """
        return CommandControl()
    def addDropDown(self, text: str, resourceFolder: str, id: str, positionID: str, isBefore: bool) -> DropDownControl:
        """
        Adds a drop-down to the controls in the toolbar, panel, or drop-down. When the drop-down is initially created it will be empty.
        you can get the associated ToolbarControls object from the DropDownControl to add additional controls to the drop-down.
        text : The text displayed for the drop-down in a menu. For a drop-down in a toolbar this argument is ignored
        because an icon is used.
        resourceFolder : The resource folder containing the image used for the icon when the drop-down is in a toolbar.
        id : Optional unique ID for the control. It must be unique with respect to other controls in this collection.
        If the default empty string is provided, Fusion 360 will create a unique ID.
        positionID : Specifies the reference id of the control to position this control relative to.
        Not setting this value indicates that the control will be created at the end of all other controls in toolbar. The isBefore
        parameter specifies whether to place the control before or after the reference control.
        isBefore : Specifies whether to place the control before or after the reference control specified by the positionID parameter.
        This argument is ignored is positionID is not specified.
        Returns the newly created DropDownControl object or null if the creation fails.
        """
        return DropDownControl()
    def addSeparator(self, id: str, positionID: str, isBefore: bool) -> SeparatorControl:
        """
        Adds a separator to the controls in the toolbar, panel, or drop-down.
        id : Optional unique ID for the control. It must be unique with respect to other controls in this collection.
        If the default empty string is provided, Fusion 360 will create a unique ID.
        positionID : Specifies the reference id of the control to position this separator control relative to.
        Not setting this value indicates that the separator control will be created at the end of all other controls in toolbar.
        The isBefore parameter specifies whether to place the control before or after the reference control.
        isBefore : Specifies whether to place the separator control before or after the reference control specified by the positionID parameter.
        This argument is ignored is positionID is not specified.
        Returns the newly created separator controls or null if the creation fails.
        """
        return SeparatorControl()
    def addSplitButton(self, defaultDefinition: CommandDefinition, additionalDefinitions: list[CommandDefinition], showLastUsed: bool, id: str, positionID: str, isBefore: bool) -> SplitButtonControl:
        """
        Adds a split button to the controls in a toolbar. A split button has two active areas that the user can click;
        the main button portion and the drop-down arrow. Clicking the main button, executes the displayed command.
        Clicking the drop-down displays the drop-down with additional commands.
        
        The split button itself does not fire any events, but the buttons within it will fire events to their associated
        command definitions.
        defaultDefinition : A command definition that will be used to create the main button. A button will also be created in the drop-down
        for this definition.
        additionalDefinitions : An array of command definitions that will be used to create the buttons on the drop-down.
        showLastUsed : Specifies if the split button should have the behavior where the command shown on the main button changes
        to the last executed command.
        id : Optional unique ID for the control. It must be unique with respect to other controls in this collection.
        If the default empty string is provided, Fusion 360 will create a unique ID.
        positionID : Specifies the reference id of the control to position this control relative to.
        Not setting this value indicates that the control will be created at the end of all other controls in toolbar. The isBefore
        parameter specifies whether to place the control before or after the reference control.
        isBefore : Specifies whether to place the control before or after the reference control specified by the positionID parameter.
        This argument is ignored is positionID is not specified
        Returns the newly created SplitButtonControl object or null if the creation fails.
        """
        return SplitButtonControl()
    @property
    def count(self) -> int:
        """
        Gets the number of controls in the collection.
        """
        return int()

class ToolbarPanel(Base):
    """
    Toolbar panels are the panels shown in the command toolbar.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ToolbarPanel:
        return ToolbarPanel()
    def deleteMe(self) -> bool:
        """
        Deletes this toolbar panel.
        Returns true if the delete was successful.
        """
        return bool()
    def indexWithinTab(self, tabId: str) -> int:
        """
        Gets the position this panel is in within the toolbar tab.
        The first panel in the tab is at position 0.
        Returns the index value of the panel within the tab.
        """
        return int()
    @property
    def id(self) -> str:
        """
        Gets The unique, language independent, ID of this panel.
        """
        return str()
    @property
    def index(self) -> int:
        """
        Gets the position this panel is in within the toolbar.
        The first panel is at position 0. This value is with respect
        to the complete list of panels so this value could be outside
        of the expected range if you have a collection of panels
        associated with a workspace, which is a subset of the entire
        list of panels.
        """
        return int()
    @property
    def isVisible(self) -> bool:
        """
        Gets whether this panel is currently being displayed in the user interface.
        Visibility of a panel is controlled by it being associated with the currently
        active workspace.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets the name of the panel as seen in the user interface.
        """
        return str()
    @property
    def controls(self) -> ToolbarControls:
        """
        Gets the controls associated with this panel. These are all in the panel's
        drop-down (assuming their visible property is true) and are selectively shown
        within the panel.
        """
        return ToolbarControls()
    @property
    def parentUserInterface(self) -> UserInterface:
        """
        Gets the parent UserInterface object.
        """
        return UserInterface()
    @property
    def promotedControls(self) -> ToolbarControlList:
        """
        Gets the controls in the panel that have been promoted. Promoted
        controls are the controls that are displayed within the panel.
        """
        return ToolbarControlList()
    @property
    def relatedWorkspaces(self) -> ObjectCollection:
        """
        Gets or sets the set of workspaces that this panel is displayed for.
        """
        return ObjectCollection()
    @relatedWorkspaces.setter
    def relatedWorkspaces(self, value: ObjectCollection):
        """
        Gets or sets the set of workspaces that this panel is displayed for.
        """
        pass
    @property
    def productType(self) -> str:
        """
        Returns the name of the product this toolbar panel is associated with.
        """
        return str()

class ToolbarPanelList(Base):
    """
    A ToolbarPanelList is a list of ToolbarPanel objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ToolbarPanelList:
        return ToolbarPanelList()
    def item(self, index: int) -> ToolbarPanel:
        """
        Returns the specified work space using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ToolbarPanel()
    def itemById(self, id: str) -> ToolbarPanel:
        """
        Returns the ToolbarPanel of the specified ID.
        id : The ID of the ToolbarPanel to get.
        Returns the specified ToolbarPanel or null in the case where there isn't a ToolbarPanel with the specified ID.
        """
        return ToolbarPanel()
    @property
    def count(self) -> int:
        """
        Gets the number of toolbar panels in the collection.
        """
        return int()

class ToolbarPanels(Base):
    """
    Provides access to a set of toolbar panels. Many toolbar panels exist and their
    visibility is determined by the active workspace. A panel can be associated with one
    or more workspaces and when the associated workspace is active, the panel is made visible.
    
    This collection is associated with a workspace and possibly a tab in the toolbar for that workspace.
    If this collection is from a toolbar tab, the collection order is the left-to-right order
    of panels in the toolbar tab.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ToolbarPanels:
        return ToolbarPanels()
    def add(self, id: str, name: str, positionID: str, isBefore: bool) -> ToolbarPanel:
        """
        Creates a new ToolbarPanel. The panel is initially empty.
        Use the associated ToolbarControls collection to add buttons.
        
        If this collection is associated with a tab, the new panel will be added to that tab.
        If this collection is not associated with a tab, the new panel will be added to the end of the "Tools" Tab.
        A "Tools" tab will be created for you if it does not currently exist for this collection's workspace.
        id : The unique id for this panel. The id must be unique with respect to all of the panels.
        name : The displayed name of this panel. This is the name visible in the user interface.
        positionID : Specifies the id of the panel to position this panel relative to.
        Not setting this value indicates that the panel will be created at the end of all other panels. The isBefore
        parameter specifies whether to place the panel before or after this panel.
        isBefore : Specifies whether to place the panel before or after the panel specified by the positionID argument.
        This argument is ignored is positionID is not specified
        Returns the newly created panel or null in the case the creation failed.
        """
        return ToolbarPanel()
    def item(self, index: int) -> ToolbarPanel:
        """
        Returns the specified toolbar panel using an index into the collection.
        When iterating by index, the panels are returned in the same order as they are shown in the user interface.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ToolbarPanel()
    def itemById(self, id: str) -> ToolbarPanel:
        """
        Returns the ToolbarPanel at the specified ID.
        id : The Id of the panel within the collection to return.
        Returns the ToolbarPanel of the specified id or null no panel has the specified id.
        """
        return ToolbarPanel()
    @property
    def count(self) -> int:
        """
        Gets the number of ToolbarPanels.
        """
        return int()

class Toolbars(Base):
    """
    Provides access to the toolbars. These are currently the right and left QAT's and the NavBar.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Toolbars:
        return Toolbars()
    def item(self, index: int) -> Toolbar:
        """
        Returns the specified toolbar using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Toolbar()
    def itemById(self, id: str) -> Toolbar:
        """
        Returns the Toolbar of the specified ID.
        id : The Id of the toolbar to return.
        Returns the toolbar with the specified ID or null if there's not a toolbar with the specified ID.
        """
        return Toolbar()
    @property
    def count(self) -> int:
        """
        Gets the number of Toolbar objects in the collection.
        """
        return int()

class ToolbarTab(Base):
    """
    Toolbar tabs are the tabs shown in the command toolbar.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ToolbarTab:
        return ToolbarTab()
    def activate(self) -> bool:
        """
        Activate this toolbar tab.
        Boolean return that indicates if the activation was successful or not.
        """
        return bool()
    def deleteMe(self) -> bool:
        """
        Deletes this tab. Fusion 360 native tabs cannot be deleted. Use the
        isNative property to determine if this is a native or API created tab.
        Returns true if the delete was successful.
        """
        return bool()
    @property
    def id(self) -> str:
        """
        Gets The unique, language independent, ID of this tab.
        """
        return str()
    @property
    def index(self) -> int:
        """
        Gets the position this tab is in within the toolbar.
        The first tab is at position 0. This value is with respect
        to the complete list of tabs so this value could be outside
        of the expected range if you have a collection of tabs
        associated with a workspace, which is a subset of the entire
        list of tabs.
        """
        return int()
    @property
    def isVisible(self) -> bool:
        """
        Gets whether this tab is currently being displayed in the user interface.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets the name of the tab as seen in the user interface.
        """
        return str()
    @property
    def toolbarPanels(self) -> ToolbarPanels:
        """
        Gets the collection containing the panels associated with this tab.
        It's through this collection that you can add new toolbar panels.
        """
        return ToolbarPanels()
    @property
    def parentUserInterface(self) -> UserInterface:
        """
        Gets the parent UserInterface object.
        """
        return UserInterface()
    @property
    def productType(self) -> str:
        """
        Returns the name of the product this toolbar tab is associated with.
        """
        return str()
    @property
    def isActive(self) -> bool:
        """
        Gets if this toolbar tab is currently active - i.e. displayed.
        """
        return bool()
    @property
    def isNative(self) -> bool:
        """
        Gets if this tab is native to Fusion 360 or was created via the API.
        """
        return bool()

class ToolbarTabList(Base):
    """
    A ToolbarTabList is a list of ToolbarTab objects.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ToolbarTabList:
        return ToolbarTabList()
    def item(self, index: int) -> ToolbarTab:
        """
        Returns the specified tab using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ToolbarTab()
    def itemById(self, id: str) -> ToolbarTab:
        """
        Returns the ToolbarTab of the specified ID.
        id : The ID of the ToolbarTab to get.
        Returns the specified ToolbarTab or null in the case where there isn't a ToolbarTab with the specified ID.
        """
        return ToolbarTab()
    @property
    def count(self) -> int:
        """
        Gets the number of toolbar tabs in the collection.
        """
        return int()

class ToolbarTabs(Base):
    """
    Provides access to a set of toolbar tabs.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ToolbarTabs:
        return ToolbarTabs()
    def item(self, index: int) -> ToolbarTab:
        """
        Returns the specified toolbar tab using an index into the collection.
        When iterating by index, the tabs are returned in the same order as they are shown in the user interface.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return ToolbarTab()
    def itemById(self, id: str) -> ToolbarTab:
        """
        Returns the ToolbarTab at the specified ID.
        id : The Id of the tab within the collection to return.
        Returns the ToolbarTab of the specified id or null if no tab has the specified id.
        """
        return ToolbarTab()
    def add(self, id: str, name: str) -> ToolbarTab:
        """
        Creates a new ToolbarTab. The tab is initially empty.
        This method appends the tab to the end of the collection.
        id : The unique id for this tab. The id must be unique with respect to all of the tabs.
        name : The displayed name of this tab. This is the name visible in the user interface.
        Returns the newly created tab or null in the case the creation failed.
        """
        return ToolbarTab()
    @property
    def count(self) -> int:
        """
        Gets the number of ToolbarTabs.
        """
        return int()

class UnitAndValuePreferences(Base):
    """
    The UnitAndValuePreferences object provides access to unit and value precision
    related preferences.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> UnitAndValuePreferences:
        return UnitAndValuePreferences()
    @property
    def generalPrecision(self) -> int:
        """
        Gets and sets the general precision for distance values. This
        value specifies the number of decimals to display.
        """
        return int()
    @generalPrecision.setter
    def generalPrecision(self, value: int):
        """
        Gets and sets the general precision for distance values. This
        value specifies the number of decimals to display.
        """
        pass
    @property
    def angularPrecision(self) -> int:
        """
        Gets and sets the angular precision. This
        value specifies the number of decimals to display.
        """
        return int()
    @angularPrecision.setter
    def angularPrecision(self, value: int):
        """
        Gets and sets the angular precision. This
        value specifies the number of decimals to display.
        """
        pass
    @property
    def scientificNotationPrecision(self) -> int:
        """
        Gets and sets the number scientific notation precision. This
        value specifies the number of decimals to display.
        """
        return int()
    @scientificNotationPrecision.setter
    def scientificNotationPrecision(self, value: int):
        """
        Gets and sets the number scientific notation precision. This
        value specifies the number of decimals to display.
        """
        pass
    @property
    def footAndInchDisplayFormat(self) -> FootAndInchDisplayFormats:
        """
        Gets and sets the foot and inch display format.
        """
        return FootAndInchDisplayFormats()
    @footAndInchDisplayFormat.setter
    def footAndInchDisplayFormat(self, value: FootAndInchDisplayFormats):
        """
        Gets and sets the foot and inch display format.
        """
        pass
    @property
    def degreeDisplayFormat(self) -> DegreeDisplayFormats:
        """
        Gets and sets the degree display format.
        """
        return DegreeDisplayFormats()
    @degreeDisplayFormat.setter
    def degreeDisplayFormat(self, value: DegreeDisplayFormats):
        """
        Gets and sets the degree display format.
        """
        pass
    @property
    def isPeriodDecimalPoint(self) -> bool:
        """
        Gets and sets if the decimal is a period or comma.
        """
        return bool()
    @isPeriodDecimalPoint.setter
    def isPeriodDecimalPoint(self, value: bool):
        """
        Gets and sets if the decimal is a period or comma.
        """
        pass
    @property
    def areAbbreviationsForUnitDisplayed(self) -> bool:
        """
        Gets and sets if abbreviations are used for units display.
        """
        return bool()
    @areAbbreviationsForUnitDisplayed.setter
    def areAbbreviationsForUnitDisplayed(self, value: bool):
        """
        Gets and sets if abbreviations are used for units display.
        """
        pass
    @property
    def areSymbolsForUnitDisplayed(self) -> bool:
        """
        Gets and sets if symbols are used for units display.
        """
        return bool()
    @areSymbolsForUnitDisplayed.setter
    def areSymbolsForUnitDisplayed(self, value: bool):
        """
        Gets and sets if symbols are used for units display.
        """
        pass
    @property
    def isScientificNotationUsed(self) -> bool:
        """
        Gets and sets if scientific notation is used when displaying numbers.
        """
        return bool()
    @isScientificNotationUsed.setter
    def isScientificNotationUsed(self, value: bool):
        """
        Gets and sets if scientific notation is used when displaying numbers.
        """
        pass
    @property
    def useScientficNotationAbove(self) -> int:
        """
        Gets and sets the number of whole digits that will be displayed before
        switching to scientific notation.
        """
        return int()
    @useScientficNotationAbove.setter
    def useScientficNotationAbove(self, value: int):
        """
        Gets and sets the number of whole digits that will be displayed before
        switching to scientific notation.
        """
        pass
    @property
    def useScientficNotationBelow(self) -> int:
        """
        Gets and sets the number of non zero decimal places that will be
        displayed before switching to scientific notation.
        """
        return int()
    @useScientficNotationBelow.setter
    def useScientficNotationBelow(self, value: int):
        """
        Gets and sets the number of non zero decimal places that will be
        displayed before switching to scientific notation.
        """
        pass
    @property
    def areTrailingZerosHidden(self) -> bool:
        """
        Gets and sets if trailing zeros are hidden when displaying numbers.
        """
        return bool()
    @areTrailingZerosHidden.setter
    def areTrailingZerosHidden(self, value: bool):
        """
        Gets and sets if trailing zeros are hidden when displaying numbers.
        """
        pass
    @property
    def minimumPrecisionWhenHidingZeros(self) -> int:
        """
        Gets and sets the minimum number of digits to the right of the decimal to display
        before hiding trailing zeros.
        """
        return int()
    @minimumPrecisionWhenHidingZeros.setter
    def minimumPrecisionWhenHidingZeros(self, value: int):
        """
        Gets and sets the minimum number of digits to the right of the decimal to display
        before hiding trailing zeros.
        """
        pass
    @property
    def materialDisplayUnit(self) -> MaterialDisplayUnits:
        """
        Gets and sets the units types to use when displaying values.
        """
        return MaterialDisplayUnits()
    @materialDisplayUnit.setter
    def materialDisplayUnit(self, value: MaterialDisplayUnits):
        """
        Gets and sets the units types to use when displaying values.
        """
        pass

class UnitsManager(Base):
    """
    Utility class used to work with Values and control default units.
    Internal values are held in SI units (e.g. seconds, radians, kg for time, angle, mass)
    with the exception that all lengths are in cm rather than meter and this affects derived
    units (e.g. velocity is cm/s, volume is cm^3).
    Units are specified flexibility via strings (e.g. "cm", "in", "inch", "cm^3", "cm*cm*cm", "mph", "mps" "m/s").
    Units like length can be defaulted based on the design settings if the user does not explicitly
    specify units - so "3" can be 3 inches, mm or cm depending on what the design
    settings are.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> UnitsManager:
        return UnitsManager()
    def isValidExpression(self, expression: str, units: str) -> bool:
        """
        Checks to see if the given expression is valid.
        expression : The expression to validate.
        units : The units to use when validating the expression.
        Returns True if it is a valid expression.
        """
        return bool()
    def evaluateExpression(self, expression: str, units: str) -> float:
        """
        Gets the value (in internal units) of the expression.
        expression : EvaluateExpression("1cm + 1in") -> 3.54
        EvaluateExpression("1") -> -> depends on the DistanceUnits, with "mm" it gives 0.1
        units : If not supplied the units will default to the default length specified in the preferences.
        Returns -1 AND GetLastError will return ExpressionError in the event of an error.
        """
        return float()
    def convert(self, valueInInputUnits: float, inputUnits: str, outputUnits: str) -> float:
        """
        Converts a value from one unit to another. The input and output unit specifiers must be compatible.
        For example, "in" (inches) and "cm" (centimeters) will work because they both define length.
        So Convert(1.5, "in", "ft") -> 0.125
        Convert(1.5, unitsManager.defaultLengthUnits, "cm") -> depends on the current default distance units, with "mm" it gives 0.15
        So Convert(1.5, "in", "kg") -> -1 and GetLastError returns ExpressionError (to denote error)
        So Convert(1, "in", "internalUnits") -> 2.54
        So Convert(1, "internalUnits", "in") -> 0.3937...
        valueInInputUnits : The value to convert
        inputUnits : The units of the value to convert
        outputUnits : The units to convert the value to
        Returns -1 AND GetLastError returns ExpressionError in the event of an error.
        """
        return float()
    def formatInternalValue(self, internalValue: float, displayUnits: str, showUnits: bool) -> str:
        """
        Formats the internal value as a string. The output string is formatted using the current
        unit settings in preferences. The preferences control the number of decimal places, whether
        units are abbreviated and several other things.
        FormatInternalValue(1.5, "in") -> "0.591 in"
        FormatInternalValue(1.5, "in", false) -> "0.591"
        FormatInternalValue(1.5, "mm", true) -> "15.00 mm"
        FormatInternalValue(1.5) -> depends on DistanceUnits, might be "15.0 mm"
        internalValue : The internal value to format.
        displayUnits : The units to display the value in. If not supplied the units will default to the default length specified in the preferences.
        showUnits : Specify false to exclude units from the format. The default is true.
        Returns an empty string if the units are incorrectly specified.
        """
        return str()
    def formatUnits(self, units: str) -> str:
        """
        Formats the unit according to the user preferences
        "centimeter" -> "cm"
        "inch" -> "in"
        "cm* cm *cm / s" -> , "cm^3 / s"
        units : The unit to use when converting the value into a string.
        Returns an empty string and GetLastError returns ExpressionError in the event of an error.
        """
        return str()
    def standardizeExpression(self, expression: str, units: str) -> str:
        """
        Standardizes the expression in terms of spacing and user preferences.
        StandardizeExpression("1.5") -> depends on distance units, but with mmight be "1.5 mm"
        StandardizeExpression("1.5", "in") -> "1.5 in"
        StandardizeExpression("1.5 cm + 1.50001 centimeter") -> "1.5 cm + 1.50001 cm"
        StandardizeExpression("1.5", "m * m * m / s") -> "1.5 m^3 /s"
        expression : The expression to standardize
        units : The units to apply to the standardized expression. If not supplied the units will default to the default length specified in the preferences.
        Returns an empty string AND GetLastError returns ExpressionError in the event of an error.
        """
        return str()
    @property
    def product(self) -> Product:
        """
        Returns the parent Product.
        """
        return Product()
    @property
    def internalUnits(self) -> str:
        """
        Returns a string that represents internal units - i.e. "internalUnits".
        This can be used when performing conversions via Convert.
        """
        return str()
    @property
    def defaultLengthUnits(self) -> str:
        """
        Returns the unit strings for the current default length unit as specified in preferences. - e.g. "cm" or "in"
        This is the string that is being used by Fusion 360 to represent the current length unit and is affected
        by the preference settings that let the user choose whether abbreviations and symbols can be used. This means
        that inch length units can be returned as inch, in, or ". If you need a consistent way of determing the current
        length unit, the distanceDisplayUnits of the FusionUnitsManager object returns an enum value.
        """
        return str()

class User(Base):
    """
    A class that represents a Fusion 360 User
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> User:
        return User()
    @property
    def userName(self) -> str:
        """
        Returns the Username associated with this user's Autodesk account
        """
        return str()
    @property
    def displayName(self) -> str:
        """
        Returns display name of the user. (i.e. the name that shows up in the Fusion 360 UI)
        """
        return str()
    @property
    def userId(self) -> str:
        """
        Returns the user's internal Autodesk account name.
        This can be used by applications sold through the Autodesk Exchange Store to verify that the user has in
        fact purchased the product.
        """
        return str()
    @property
    def email(self) -> str:
        """
        Get the email associated with this users Fusion 360 account
        """
        return str()

class UserInterface(Base):
    """
    Provides access to the user-interface related objects and functionality.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> UserInterface:
        return UserInterface()
    def messageBox(self, text: str, title: str, buttons: MessageBoxButtonTypes, icon: MessageBoxIconTypes) -> DialogResults:
        """
        Display a modal message box with the provided text.
        text : The message text to display in the dialog.
        title : If the optional title argument is provided, it sets the title for the dialog, otherwise the default product name is used.
        buttons : The optional buttons array can be used to specify which buttons to display on the dialog.
        The first button provided is the default action.
        If buttons are not specified, the dialog will default to a single OK button.
        icon : The optional icon argument can be used to specify which icon to display, otherwise the default of no icon is used.
        The button pressed to dismiss the dialog is returned.
        """
        return DialogResults()
    def inputBox(self, prompt: str, title: str, defaultValue: str) -> tuple[str, bool]:
        """
        Displays a modal dialog to get string input from the user.
        prompt : The message text to display in the dialog.
        cancelled : Indicates if the dialog was canceled.
        title : Sets the title for the dialog if specified, otherwise the default product name is used.
        defaultValue : The default string that's shown when the dialog is initially displayed, otherwise the input box is empty.
        Returns the string entered by the user but because the user can click Cancel, the canceled argument should be tested before using the string.
        """
        return (str(), bool())
    def selectEntity(self, prompt: str, filter: str) -> Selection:
        """
        Supports the selection of a single entity. This provides a simple way to prompt the user for
        for a selection in a script. If you need more control over the selection a command should be
        created and a SelectionCommandInput used.
        prompt : The prompt displayed to the user during the selection.
        filter : A string defining the types of entities valid for selection. The valid list of selection filters can be found here: <a href="SelectionFilters_UM.htm">Selection Filters</a>.
        You can combine multiple types by using a comma delimiter. For example, the string "PlanarFaces,ConstructionPlanes" will allow the selection of either a planar face or a construction plane.
        Returns a Selection object that provides access the selected entity through it's "entity" property
        along with the location in space where the entity was selected. Asserts if the selection is aborted.
        """
        return Selection()
    def createFileDialog(self) -> FileDialog:
        """
        Creates a new FileDialog object which provides the ability to show a standard file selection dialog
        to the user.
        Returns the created FileDialog object that you can use to define the contents of and display a standard file dialog.
        """
        return FileDialog()
    def workspacesByProductType(self, productType: str) -> WorkspaceList:
        """
        Returns all of the workspaces associated with the specified product.
        productType : The name of the product that you want the associated workspaces for. The full list
        of available products can be obtained by using the Application.supportedProductTypes property.
        Returns a list of the associated work spaces.
        """
        return WorkspaceList()
    def toolbarPanelsByProductType(self, productType: str) -> ToolbarPanelList:
        """
        Gets all of the toolbar panels associated with the specified product.
        productType : The name of the product that you want the associated workspaces for. The full list
        of available products can be obtained by using the Application.supportedProductTypes property.
        Returns a list of the toolbars associated with the specified product.
        """
        return ToolbarPanelList()
    def terminateActiveCommand(self) -> bool:
        """
        Method that causes the currently active (running) command to be terminated
        Returns true if terminating the active command was successful.
        """
        return bool()
    def createProgressDialog(self) -> ProgressDialog:
        """
        Creates a new ProgressDialog object that you can use to display and control a progress dialog.
        Returns the created ProgressDialog object that you can use to define the contents of and display a progress dialog.
        """
        return ProgressDialog()
    def createFolderDialog(self) -> FolderDialog:
        """
        Creates a new FolderDialog object which provides the ability to show a standard folder selection dialog
        to the user.
        Returns the created FolderDialog object that you can use to define the contents of and display a standard folder dialog.
        """
        return FolderDialog()
    def toolbarTabsByProductType(self, productType: str) -> ToolbarTabList:
        """
        Gets all of the toolbar tabs associated with the specified product.
        productType : The name of the product that you want the associated tabs for. The full list
        of available products can be obtained by using the Application.supportedProductTypes property.
        Returns a list of the tabs associated with the specified product.
        """
        return ToolbarTabList()
    def getText(self, module: str, id: str, defaultValue: str) -> str:
        """
        Get the localized text for a specific application text string. The set of text strings available
        are listed in the .xml files in the application's StringTable folders.
        module : The module name. This is the same as the StringTable .xml filename without the .xml extension.
        id : The id of the text. This is the same as the 'commandName' field in the StringTable .xml file.
        defaultValue : A default string value to return if the module or string id is not found in the current locale.
        The localized string or the defaultValue if one is not found.
        """
        return str()
    @property
    def activeSelections(self) -> Selections:
        """
        Gets the current set of selected objects.
        """
        return Selections()
    @property
    def activeWorkspace(self) -> Workspace:
        """
        Gets the active workspace. The active workspace is the one currently active in the user interface.
        This can be null if there is no active product.
        """
        return Workspace()
    @property
    def commandDefinitions(self) -> CommandDefinitions:
        """
        Gets all of the command definitions currently defined. This is all
        command definitions both internal and those defined through the API.
        """
        return CommandDefinitions()
    @property
    def toolbars(self) -> Toolbars:
        """
        Gets a collection that provides access to the toolbars. This includes
        the left and right QAT, and the Navbar.
        """
        return Toolbars()
    @property
    def workspaces(self) -> Workspaces:
        """
        Gets all of the workspaces currently available.
        """
        return Workspaces()
    @property
    def allToolbarPanels(self) -> ToolbarPanelList:
        """
        Gets all of the toolbar panels. This returns all of the panels
        available, regardless of which workspace or product they're associated with.
        """
        return ToolbarPanelList()
    @property
    def workspacePreActivate(self) -> WorkspaceEvent:
        """
        The workspacePreActivate event fires at the VERY start of a workspace being activated.
        The client can add or remove WorkspaceEventHandlers from the WorkspaceEvent.
        """
        return WorkspaceEvent()
    @property
    def workspaceActivated(self) -> WorkspaceEvent:
        """
        The workspaceActivated event fires at the VERY end of a workspace being activated.
        The client can add or remove WorkspaceEventHandlers from the WorkspaceEvent.
        """
        return WorkspaceEvent()
    @property
    def workspacePreDeactivate(self) -> WorkspaceEvent:
        """
        The workspacePreDeactivate event fires at the VERY start of a workspace being deactivated.
        The client can add or remove WorkspaceEventHandlers from the WorkspaceEvent.
        """
        return WorkspaceEvent()
    @property
    def workspaceDeactivated(self) -> WorkspaceEvent:
        """
        The workspaceDeactivated event fires at the VERY end of a workspace being deactivated.
        The client can add or remove WorkspaceEventHandlers from the WorkspaceEvent.
        """
        return WorkspaceEvent()
    @property
    def activeCommand(self) -> str:
        """
        Gets the id of the command definition from the active command (the one that is currently running)
        """
        return str()
    @property
    def commandStarting(self) -> ApplicationCommandEvent:
        """
        The commandStarting event fires when a request for a command to be executed has been
        received but before the command is executed. Through this event, it's possible to
        cancel the command from being executed.
        """
        return ApplicationCommandEvent()
    @property
    def commandCreated(self) -> ApplicationCommandEvent:
        """
        The commandCreated event fires immediately after the command is created.
        """
        return ApplicationCommandEvent()
    @property
    def commandTerminated(self) -> ApplicationCommandEvent:
        """
        Gets an event that is fired when a command is terminated.
        """
        return ApplicationCommandEvent()
    @property
    def markingMenuDisplaying(self) -> MarkingMenuEvent:
        """
        The markingMenuDisplaying event fires just before the marking menu and context menus are displayed. The
        marking menu is the round menu displayed when the user right-clicks the mouse within Fusion 360. The context
        menu is the vertical menu displayed. The event provides both the marking menu and the context menu so you
        can examine and edit the contents of either one or both of them before they are displayed. Fusion 360 will then
        display the marking and context menu that you've customized. If either one is empty it will not be displayed.
        """
        return MarkingMenuEvent()
    @property
    def palettes(self) -> Palettes:
        """
        Returns the collection object that provides access to all of the existing
        palettes and provides the functionality to create new custom palettes.
        """
        return Palettes()
    @property
    def allToolbarTabs(self) -> ToolbarTabList:
        """
        Gets all of the toolbar tabs. This returns all of the tabs
        available, regardless of which workspace or product they're associated with.
        """
        return ToolbarTabList()
    @property
    def isTabbedToolbarUI(self) -> bool:
        """
        Returns true if Tabbed Toolbars are being used.
        Returns true if using Tabbed Toolbars.
        """
        return bool()
    @property
    def activeSelectionChanged(self) -> ActiveSelectionEvent:
        """
        This event fires whenever the contents of the active selection changes. This occurs as the user
        selects or unselects entities while using the Fusion 360 Select command. The Select command
        is the default command that is always running if no other command is active. Pressing Escape
        terminates the currently active command and starts the Select command. If the Select command is
        running and you press Escape, it terminates the current Select command and starts a new one.
        
        This event is only associated with the selection associated with the Select command and does not
        fire when any other command is running. The event fires when there is any change to the active
        selection, including when the selection is cleared when the Select command is terminated. It is
        also fired when the user clicks in an open area of the canvas to clear the current selection.
        """
        return ActiveSelectionEvent()

class UserInterfaceGeneralEventHandler(EventHandler):
    """
    The UserInterfaceGeneralEventHandler is a client implemented class that can be
    added as a handler to a UserInterfaceGeneralEvent event and which is triggered when the event is fired.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> UserInterfaceGeneralEventHandler:
        return UserInterfaceGeneralEventHandler()
    def notify(self, eventArgs: UserInterfaceGeneralEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class ValidateInputsEventHandler(EventHandler):
    """
    An event handler base class that a client derives from to handle events triggered by a ValidateInputsEvent.
    A client implemented instance of this class can be added to a ValidateInputsEvent to receive these event notifications.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ValidateInputsEventHandler:
        return ValidateInputsEventHandler()
    def notify(self, eventArgs: ValidateInputsEventArgs) -> None:
        """
        This notify member is called when an event is triggered from any event that this handler has been added to.
        eventArgs : The arguments object with details about this event and the firing ValidateInputsEvent.
        """
        pass

class ValueInput(Base):
    """
    A ValueInput provides a flexible way of specifying a string, a double, a boolean, or object reference.
    No semantics are associated with a ValueInput (e.g. is the string valid, can the string
    be converted to a double) - it is merely a way of supplying information in
    either string, double, boolean or object reference form as a function parameter.
    ValueInput objects are typically used to specify things like an extrude depth, or hole dia, etc.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ValueInput:
        return ValueInput()
    @staticmethod
    def createByReal(realValue: float) -> ValueInput:
        """
        Creates a new ValueInput object using a double. For example, if you create a value using
        the double value 2 and use it as input for a length, it will be interpreted as 2 cm because
        centimeters are the internal unit for length. Values defined by a real are are always
        interpreted to be in the appropriate internal unit.
        For example, if the value 2 is used to define the depth of an extrusion (a length value),
        it will be 2 cm because cm is the internal unit for lengths. If the value 2 is used
        to define the angle of the extrude, it will be 2 radians because radians are the internal
        unit for angles.
        realValue : a double value
        Returns the newly created ValueInput object or null if the creation failed.
        """
        return ValueInput()
    @staticmethod
    def createByString(stringValue: str) -> ValueInput:
        """
        When a string is used to create a value it needs to be evaluated as an expression so
        its value can be determined using the UnitsManager class.
        The units of an expression can be explicitly defined or will default to the current default
        units.
        For example, if you create an expression with the string "6" and specify it as a length,
        it will use the current active units. If the current active units are defined as inches
        the expression will be interpreted as 6 inches.
        You can specify the units as part of the string (i.e. "6 mm").
        You can also use equations in the string (ie. "6 + 5mm")
        
        In order for an expression to be valid, its units must be compatible with the value it
        represents. For example if you specify "5 in + 3 cm" as an expresssion to supply the value
        of an angle, it will fail because the units of the expression define a length.
        stringValue : The expression string
        Returns the newly created ValueInput object or null if the creation failed.
        """
        return ValueInput()
    @staticmethod
    def createByObject(objectReference: Base) -> ValueInput:
        """
        Creates a new ValueInput object that contains a reference to any Fusion 360 object.
        objectReference : The Fusion 360 object that you want to create the ValueInput for.
        Returns the newly created ValueInput object or null if the creation failed.
        """
        return ValueInput()
    @staticmethod
    def createByBoolean(booleanValue: bool) -> ValueInput:
        """
        Creates a new ValueInput object that contains a boolean value.
        booleanValue : Boolean value.
        Returns the newly created ValueInput object or null if the creation failed.
        """
        return ValueInput()
    @property
    def realValue(self) -> float:
        """
        Gets the real value, if there is one.
        Returns -1 AND GetLastError returns ValueNotOfType if there is no real value.
        You can use the valueType property to determine which value type is currently used.
        """
        return float()
    @property
    def stringValue(self) -> str:
        """
        Gets the string value, if there is one.
        Returns an empty string AND GetLastError returns ValueNotOfType if there is no string value.
        You can use the valueType property to determine which value type is currently used.
        """
        return str()
    @property
    def objectReference(self) -> Base:
        """
        Gets the object being referenced, if there is one.
        Returns null AND GetLastError returns ValueNotOfType if there is no object reference.
        You can use the valueType property to determine which value type is currently used.
        """
        return Base()
    @property
    def valueType(self) -> ValueTypes:
        """
        Returns the type of value this ValueInput currently represents.
        """
        return ValueTypes()
    @property
    def booleanValue(self) -> bool:
        """
        Gets the boolean value, if there is one.
        Returns false AND GetLastError returns ValueNotOfType if there is no boolean value.
        You can use the valueType property to determine which value type is currently used.
        """
        return bool()

class Vector2D(Base):
    """
    Transient 2D vector. This object is a wrapper for 2D vector data and is used to
    pass vector data in and out of the API.
    They are created statically using the create method of the Vector2D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Vector2D:
        return Vector2D()
    @staticmethod
    def create(x: float, y: float) -> Vector2D:
        """
        Creates a 2D vector object.
        x : The x coordinate of the vector.
        y : The y coordinate of the vector.
        Returns the new Vector2D object or null if the creation failed.
        """
        return Vector2D()
    def add(self, vector: Vector2D) -> bool:
        """
        Add a vector to this vector.
        vector : The vector to add to this vector.
        Returns true if successful.
        """
        return bool()
    def angleTo(self, vector: Vector2D) -> float:
        """
        Gets the angle between this vector and another vector.
        vector : The vector to measure the angle to.
        Returns the angle in radians.
        """
        return float()
    def copy(self) -> Vector2D:
        """
        Creates and returns an independent copy of this Vector2D object.
        Returns a new Vector2D object that is a copy of this Vector2D object.
        """
        return Vector2D()
    def dotProduct(self, vector: Vector2D) -> float:
        """
        Calculates the Dot Product of this vector and an input vector.
        vector : The vector to use in the dot product calculation.
        Returns the dot product of the two vectors.
        """
        return float()
    def asArray(self) -> list[float]:
        """
        Returns the vector values as an array [x, y].
        Returns an array of the vector's values [x, y].
        """
        return [float()]
    def isEqualTo(self, vector: Vector2D) -> bool:
        """
        Compare this vector with another to check for equality.
        vector : The vector to compare with for equality.
        Returns true if the vectors are equal.
        """
        return bool()
    def isParallelTo(self, vector: Vector2D) -> bool:
        """
        Compare this vector with another to check for parallelism.
        vector : The vector to compare with for parallelism.
        Returns true if the vectors are parallel.
        """
        return bool()
    def isPerpendicularTo(self, vector: Vector2D) -> bool:
        """
        Compare this vector with another to check for perpendicularity.
        vector : The vector to compare with for perpendicularity.
        Returns true if the vectors are perpendicular.
        """
        return bool()
    def normalize(self) -> bool:
        """
        Normalizes the vector.
        Normalization makes the vector length equal to one.
        The vector should not be zero length.
        Returns true if successful.
        """
        return bool()
    def setWithArray(self, coordinates: list[float]) -> bool:
        """
        Sets the definition of the vector by specifying an array containing the x and y coordinates.
        coordinates : An array that specifies the values for the x and y coordinates of the vector.
        Returns true if successful
        """
        return bool()
    def scaleBy(self, scale: float) -> bool:
        """
        Scales the vector by specifying a scaling factor.
        scale : The scale factor to multiple the vector by (i.e. 1.5).
        Returns true if successful.
        """
        return bool()
    def subtract(self, vector: Vector2D) -> bool:
        """
        Subtract a vector from this vector.
        vector : The vector to subtract from this vector.
        Returns true if successful.
        """
        return bool()
    def transformBy(self, matrix: Matrix2D) -> bool:
        """
        Transforms the vector by specifying a 2D transformation matrix.
        matrix : The Matrix2D object that defines the transformation.
        Returns true if successful.
        """
        return bool()
    def asPoint(self) -> Point2D:
        """
        Return a point with the same x and y values as this vector.
        Returns the new point.
        """
        return Point2D()
    @property
    def length(self) -> float:
        """
        Gets the length of the vector.
        """
        return float()
    @property
    def x(self) -> float:
        """
        Gets and sets the X coordinate of the vector.
        """
        return float()
    @x.setter
    def x(self, value: float):
        """
        Gets and sets the X coordinate of the vector.
        """
        pass
    @property
    def y(self) -> float:
        """
        Gets and sets the Y coordinate of the vector.
        """
        return float()
    @y.setter
    def y(self, value: float):
        """
        Gets and sets the Y coordinate of the vector.
        """
        pass

class Vector3D(Base):
    """
    Transient 3D vector. This object is a wrapper over 3D vector data and is used as way to pass vector data
    in and out of the API and as a convenience when operating on vector data.
    They are created statically using the create method of the Vector3D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Vector3D:
        return Vector3D()
    @staticmethod
    def create(x: float, y: float, z: float) -> Vector3D:
        """
        Creates a 3D vector object. This object is created statically using the Vector3D.create method.
        x : The optional x value.
        y : The optional y value.
        z : The optional z value.
        Returns the new vector.
        """
        return Vector3D()
    def add(self, vector: Vector3D) -> bool:
        """
        Adds a vector to this vector.
        vector : The vector to add to this vector.
        Returns true if successful.
        """
        return bool()
    def angleTo(self, vector: Vector3D) -> float:
        """
        Determines the angle between this vector and the specified vector.
        vector : The vector to measure the angle to.
        The angle in radians between this vector and the specified vector.
        """
        return float()
    def asPoint(self) -> Point3D:
        """
        Returns a new point with the same coordinate values as this vector.
        Return the new point.
        """
        return Point3D()
    def copy(self) -> Vector3D:
        """
        Creates a copy of this vector.
        Returns the new vector copy.
        """
        return Vector3D()
    def crossProduct(self, vector: Vector3D) -> Vector3D:
        """
        Returns the cross product between this vector and the specified vector.
        vector : The vector to take the cross product to.
        Returns the vector cross product.
        """
        return Vector3D()
    def dotProduct(self, vector: Vector3D) -> float:
        """
        Returns the dot product between this vector and the specified vector.
        vector : The vector to take the dot product to.
        Returns the dot product value.
        """
        return float()
    def asArray(self) -> list[float]:
        """
        Returns the vector coordinates as an array [x, y, z].
        Returns the array of vector coordinates [x, y, z].
        """
        return [float()]
    def isEqualTo(self, vector: Vector3D) -> bool:
        """
        Determines if this vector is equal to the specified vector.
        vector : The vector to test equality to.
        Returns true if the vectors are equal.
        """
        return bool()
    def isParallelTo(self, vector: Vector3D) -> bool:
        """
        Determines if the input vector is parallel with this vector.
        vector : The vector to test parallelism to.
        Returns true if the vectors are parallel.
        """
        return bool()
    def isPerpendicularTo(self, vector: Vector3D) -> bool:
        """
        Determines if the input vector is perpendicular to this vector.
        vector : The vector to test perpendicularity to.
        Returns true if the vectors are perpendicular.
        """
        return bool()
    def normalize(self) -> bool:
        """
        Makes this vector of unit length.
        This vector should not be zero length.
        Returns true if successful.
        """
        return bool()
    def setWithArray(self, coordinates: list[float]) -> bool:
        """
        Reset this vector with the coordinate values in an array [x, y, z].
        coordinates : The array of coordinate values.
        Returns true if successful.
        """
        return bool()
    def scaleBy(self, scale: float) -> bool:
        """
        Scale this vector by the specified product.
        scale : The scale value.
        Returns true if successful.
        """
        return bool()
    def subtract(self, vector: Vector3D) -> bool:
        """
        Subtract a vector from this vector.
        vector : The vector to subtract.
        Returns true if successful.
        """
        return bool()
    def transformBy(self, matrix: Matrix3D) -> bool:
        """
        Transform this vector by the specified matrix.
        matrix : The transformation matrix.
        Returns true if successful.
        """
        return bool()
    @property
    def length(self) -> float:
        """
        Get the length of this vector.
        """
        return float()
    @property
    def x(self) -> float:
        """
        The x value.
        """
        return float()
    @x.setter
    def x(self, value: float):
        """
        The x value.
        """
        pass
    @property
    def y(self) -> float:
        """
        The y value.
        """
        return float()
    @y.setter
    def y(self, value: float):
        """
        The y value.
        """
        pass
    @property
    def z(self) -> float:
        """
        The z value.
        """
        return float()
    @z.setter
    def z(self, value: float):
        """
        The z value.
        """
        pass

class Viewport(Base):
    """
    A viewport within Fusion 360. A viewport is the window where the model is displayed.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Viewport:
        return Viewport()
    def refresh(self) -> bool:
        """
        Forces the view to refresh. It is sometimes useful to force a refresh to
        be able to see edits that have been made using the API.
        Returns true if the operation was successful.
        """
        return bool()
    def saveAsImageFile(self, filename: str, width: int, height: int) -> bool:
        """
        Saves the current view to the specified image file. The view is re-rendered to the specified size and not
        just scaled from the existing view. This allows you to generate higher resolution images than you could
        do with just a screen capture.
        filename : The full filename, including the path, of the image file. The type of image file to be created is inferred from the extension of the filename.
        width : The width in pixels of the output image. A value of zero indicates that the current width of the viewport is to be used.
        height : The height in pixels of the output image. A value of zero indicates that the current height of the viewport is to be used.
        Returns true if the operation was successful.
        """
        return bool()
    def fit(self) -> bool:
        """
        Forces a camera change so that all of the graphics are visible in the viewport.
        Returns true if the fit was successful.
        """
        return bool()
    def modelToViewSpace(self, modelCoordinate: Point3D) -> Point2D:
        """
        A specified point in model space returns the equivalent point in view space.
        modelCoordinate : A coordinate in model space.
        Returns the equivalent point in view space.
        """
        return Point2D()
    def viewToModelSpace(self, viewCoordinate: Point2D) -> Point3D:
        """
        A specified point in view space returns the equivalent point in model space.
        Because view space is 2D and model space is 3D, the depth of the point is
        returned is somewhat arbitrary along the eye to target point direction.
        viewCoordinate : A coordinate in view space.
        Returns the equivalent point in model space.
        """
        return Point3D()
    def screenToView(self, screenCoordinate: Point2D) -> Point2D:
        """
        Converts a 2D screen point into the equivalent viewport coordinate.
        screenCoordinate : A 2D coordinate in screen space.
        (0,0) indicates the upper-left corner of the entire screen.
        Returns the equivalent point in the viewport. This can return null in the case
        where the input screen point does not lie within the viewport.
        """
        return Point2D()
    def viewToScreen(self, viewCoordinate: Point2D) -> Point2D:
        """
        Converts a 2D viewPort point into the equivalent screen coordinate.
        viewCoordinate : A 2D coordinate in the viewport.
        (0,0) indicates the upper-left corner of the viewport.
        Returns the equivalent point in the screen. This can return null in the case where
        the input point is outside the bounds of the screen, which also means it's outside
        any viewport.
        """
        return Point2D()
    @property
    def camera(self) -> Camera:
        """
        Gets and sets the camera associated with the view.
        The camera returned is a copy of the current camera
        settings of the view. Editing the properties of the
        camera will have no affect on the viewport until the
        camera is assigned back to the viewport.
        """
        return Camera()
    @camera.setter
    def camera(self, value: Camera):
        """
        Gets and sets the camera associated with the view.
        The camera returned is a copy of the current camera
        settings of the view. Editing the properties of the
        camera will have no affect on the viewport until the
        camera is assigned back to the viewport.
        """
        pass
    @property
    def height(self) -> int:
        """
        Returns the height of the viewport in pixels.
        """
        return int()
    @property
    def width(self) -> int:
        """
        Returns the width of the viewport in pixels.
        """
        return int()
    @property
    def isFullScreen(self) -> bool:
        """
        Gets and sets if the view is in full screen mode.
        """
        return bool()
    @isFullScreen.setter
    def isFullScreen(self, value: bool):
        """
        Gets and sets if the view is in full screen mode.
        """
        pass
    @property
    def visualStyle(self) -> VisualStyles:
        """
        Gets and sets the current visual style being used.
        """
        return VisualStyles()
    @visualStyle.setter
    def visualStyle(self, value: VisualStyles):
        """
        Gets and sets the current visual style being used.
        """
        pass

class WebRequestEventHandler(EventHandler):
    """
    The WebRequestEventHandler is a client implemented class that can be added as a handler to an
    WebRequestEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> WebRequestEventHandler:
        return WebRequestEventHandler()
    def notify(self, eventArgs: WebRequestEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class Workspace(Base):
    """
    A Workspace provides access to a set of panels, which contain commands that
    are relevant for that particular workspace. The user can switch from one
    workspace to another in a product (e.g. switch from Model to Sculpt in Fusion 360).
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Workspace:
        return Workspace()
    def activate(self) -> bool:
        """
        Activate the workspace (assuming it is valid to do so - a SIM workspace can't
        be activated if Fusion 360 is the active product).
        Boolean return that indicates if the activation was successful or not.
        """
        return bool()
    def deleteMe(self) -> bool:
        """
        Deletes this workspace. Only a workspace added by the API can be deleted, (IsNative is false).
        Boolean return that indicates if the deletion was successful or not.
        """
        return bool()
    @property
    def id(self) -> str:
        """
        Gets the unique Id of the workspace that can be used programmatically
        to find a specific workspace. It is not affected by the current
        language.
        """
        return str()
    @property
    def isActive(self) -> bool:
        """
        Gets if the workspace is currently active - i.e. displayed
        """
        return bool()
    @property
    def isNative(self) -> bool:
        """
        Gets if this workspace is native to Fusion 360 or was created via the API.
        """
        return bool()
    @property
    def name(self) -> str:
        """
        Gets the visible name of the workspace as seen in the user interface.
        This is the localized name.
        """
        return str()
    @property
    def toolbarPanels(self) -> ToolbarPanels:
        """
        Gets the collection containing the panels associated with this workspace.
        It's through this collection that you can add new toolbar panels.
        """
        return ToolbarPanels()
    @property
    def resourceFolder(self) -> str:
        """
        Gets or sets the resource folder.
        """
        return str()
    @resourceFolder.setter
    def resourceFolder(self, value: str):
        """
        Gets or sets the resource folder.
        """
        pass
    @property
    def productType(self) -> str:
        """
        Returns the name of the product this workspace is associated with.
        """
        return str()
    @property
    def toolClipFilename(self) -> str:
        """
        Gets or sets the full filename of the image file (PNG) used for the tool clip.
        the tool clip is the image shown when the user hovers the mouse over the workspace name in the workspace drop-down.
        """
        return str()
    @toolClipFilename.setter
    def toolClipFilename(self, value: str):
        """
        Gets or sets the full filename of the image file (PNG) used for the tool clip.
        the tool clip is the image shown when the user hovers the mouse over the workspace name in the workspace drop-down.
        """
        pass
    @property
    def tooltip(self) -> str:
        """
        Gets or sets the tooltip text displayed for the workspace. This is the first line of text shown when the
        user hovers over the workspace name in the Fusion 360 toolbar drop-down. This is typically the name of the
        workspace. This is different from the name in the that the name is a short name shown in the drop-down.
        The tooltip is only shown when the user hovers over the name and box appears providing more information
        about the workspace. For example, the name of the model workspace is "Model" and the tooltip is "Model Workspace".
        """
        return str()
    @tooltip.setter
    def tooltip(self, value: str):
        """
        Gets or sets the tooltip text displayed for the workspace. This is the first line of text shown when the
        user hovers over the workspace name in the Fusion 360 toolbar drop-down. This is typically the name of the
        workspace. This is different from the name in the that the name is a short name shown in the drop-down.
        The tooltip is only shown when the user hovers over the name and box appears providing more information
        about the workspace. For example, the name of the model workspace is "Model" and the tooltip is "Model Workspace".
        """
        pass
    @property
    def tooltipDescription(self) -> str:
        """
        Gets or sets the tooltip description displayed for the workspace. The tooltip description is a longer
        description of the workspace and is only displayed when the user hovers over the workspace name in
        the Fusion 360 toolbar drop-down. The pop-up dialog that appears contains the tooltip, the tooltip
        description, and the tool clip which is a picture.
        """
        return str()
    @tooltipDescription.setter
    def tooltipDescription(self, value: str):
        """
        Gets or sets the tooltip description displayed for the workspace. The tooltip description is a longer
        description of the workspace and is only displayed when the user hovers over the workspace name in
        the Fusion 360 toolbar drop-down. The pop-up dialog that appears contains the tooltip, the tooltip
        description, and the tool clip which is a picture.
        """
        pass
    @property
    def toolbarTabs(self) -> ToolbarTabs:
        """
        Gets the collection containing the tabs associated with this workspace.
        """
        return ToolbarTabs()

class WorkspaceEventHandler(EventHandler):
    """
    The WorkspaceEventHandler is a client implemented class that can be added as a handler to a
    WorkspaceEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> WorkspaceEventHandler:
        return WorkspaceEventHandler()
    def notify(self, eventArgs: WorkspaceEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class WorkspaceList(Base):
    """
    A WorkspaceList is a list of Workspaces - e.g. the Workspaces for a given product.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> WorkspaceList:
        return WorkspaceList()
    def item(self, index: int) -> Workspace:
        """
        Returns the specified work space using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Workspace()
    def itemById(self, id: str) -> Workspace:
        """
        Returns the Workspace of the specified ID.
        id : The ID of the workspace to get.
        Returns the specified workspace or null in the case where there isn't a workspace with the specified ID.
        """
        return Workspace()
    @property
    def count(self) -> int:
        """
        Gets the number of workspaces in the collection.
        """
        return int()

class Workspaces(Base):
    """
    Provides access to all of the existing workspaces.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Workspaces:
        return Workspaces()
    def item(self, index: int) -> Workspace:
        """
        Returns the specified work space using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Workspace()
    def itemById(self, id: str) -> Workspace:
        """
        Returns the Workspace of the specified ID.
        id : The ID of the workspace to get.
        Returns the specified workspace or null in the case where there isn't a workspace with the specified ID.
        """
        return Workspace()
    def add(self, productType: str, id: str, name: str, resourceFolder: str) -> Workspace:
        """
        Creates a new workspace for a specific product.
        productType : The name of the product this workspace will be displayed with. You can obtain a list of the available
        products by using the supportedProductTypes property of the Application object.
        id : The unique ID for this workspace. It must be unique with respect to all other workspaces.
        name : The displayed name of this workspace.
        resourceFolder : The resource folder should contain two files; 49X31.png and 98x62.png. The larger is used for the Apple Retina display.
        Returns the created workspace or null if the creation failed.
        """
        return Workspace()
    @property
    def count(self) -> int:
        """
        Gets the number of workspaces in the collection.
        """
        return int()

class ActiveSelectionEvent(Event):
    """
    This event fires whenever the contents of the active selection changes. This occurs as the user
    selects or unselects entities while using the Fusion 360 Select command. The Select command
    is the default command that is always running if no other command is active. Pressing Escape
    terminates the currently active command and starts the Select command. If the Select command is
    running and you press Escape, it terminates the current Select command and starts a new one.
    
    This event is only associated with the selection associated with the Select command and does not
    fire when any other command is running. The event fires when there is any change to the active
    selection, including when the selection is cleared when the Select command is terminated. It is
    also fired when the user clicks in an open area of the canvas to clear the current selection.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ActiveSelectionEvent:
        return ActiveSelectionEvent()
    def add(self, handler: ActiveSelectionEventHandler) -> bool:
        """
        Add a handler to be notified when the event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: ActiveSelectionEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class ActiveSelectionEventArgs(EventArgs):
    """
    The ActiveSelectionEventArgs provides information associated with the active selection changing.
    The event fires whenever the contents of the active selection changes. This occurs as the user
    selects or unselects entities while using the Fusion 360 Select command. The Select command
    is the default command that is always running if no other command is active. Pressing Escape
    terminates the currently active command and starts the Select command. If the Select command is
    running and you press Escape, it terminates the current Select command and starts a new one.
    
    An array or list of all the currently selected entities is returned. This is the same set of
    entities accessed through the UserInterface.activeSelection object. An empty array can be returned
    in the case where the selection has been cleared which can occur by the user unselecting and entity,
    terminating the select command pressing Escape or running another command or clicking the mouse in
    an open area of the canvas.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ActiveSelectionEventArgs:
        return ActiveSelectionEventArgs()
    @property
    def currentSelection(self) -> list[Selection]:
        """
        The list of all of the current selections. This is the same set of selections accessed through
        the UserInterface.activeSelection object. An empty array can be returned
        in the case where the selection has been cleared which can occur by the user unselecting and entity,
        terminating the select command pressing Escape or running another command or clicking the mouse in
        an open area of the canvas.
        """
        return [Selection()]

class AngleValueCommandInput(CommandInput):
    """
    Represents a command input that gets an angle from the user. This displays
    an entry in the command dialog where the user can enter a value and also displays
    a manipulator in the graphics window to allow them to graphically set the value.
    The input box is displayed in the dialog when the isVisible property of the command
    input is true. The manipulator is displayed in the graphics when both the isVisible
    and isEnabled properties are true.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AngleValueCommandInput:
        return AngleValueCommandInput()
    def setManipulator(self, origin: Point3D, xDirection: Vector3D, yDirection: Vector3D) -> bool:
        """
        Defines the position and orientation of the manipulator. The manipulator is only visible
        when both the isVisible and isEnabled properties are true. If those properties are
        true and the setManipulator has not been called, the manipulator will be displayed in
        a default location (0,0,0) using default directions; x direction (1,0,0) and y direction (0,1,0).
        Because of that the input is typically set to be invisible and/or disabled and then enabled once
        enough input has been specified that you can display the manipulator in the desired location.
        origin : Defines the center position of the manipulator in root component space.
        xDirection : Defines the X direction of the manipulator in root component space. The X direction is the 0 angle direction. This
        direction, along with the Y direction vector define the plane that the manipulator is displayed on.
        yDirection : Defines the Y direction of the manipulator in root component space. The X and Y direction vectors define the plane
        the manipulator is displayed one. When the manipulator is rotated from the xDirection vector towards the yDirection
        vector that is the positive direction.
        Returns true if successful.
        """
        return bool()
    @property
    def value(self) -> float:
        """
        Gets and sets the current value of the command input. The value is in radians
        but will be displayed to the user in degrees. Setting this value can fail if the input value is
        not within the minimum and maximum value range.
        
        The isValidExpression property should be checked before using the value within the command
        because if the expression can't be evaluated there isn't a valid value. Fusion 360 won't allow
        the execution of a command that contains ValueCommandInput object with invalid expressions
        so you can dependably use the value in the execute event of the command.
        """
        return float()
    @value.setter
    def value(self, value: float):
        """
        Gets and sets the current value of the command input. The value is in radians
        but will be displayed to the user in degrees. Setting this value can fail if the input value is
        not within the minimum and maximum value range.
        
        The isValidExpression property should be checked before using the value within the command
        because if the expression can't be evaluated there isn't a valid value. Fusion 360 won't allow
        the execution of a command that contains ValueCommandInput object with invalid expressions
        so you can dependably use the value in the execute event of the command.
        """
        pass
    @property
    def expression(self) -> str:
        """
        Gets or sets the expression displayed in the input field. This can contain equations and
        references to parameters but must result in a valid angle expression. If units are not
        specified as part of the expression, the default user units of degrees are used.
        """
        return str()
    @expression.setter
    def expression(self, value: str):
        """
        Gets or sets the expression displayed in the input field. This can contain equations and
        references to parameters but must result in a valid angle expression. If units are not
        specified as part of the expression, the default user units of degrees are used.
        """
        pass
    @property
    def minimumValue(self) -> float:
        """
        Gets and sets minimum value, if any, that the value can be. The value is in radians. When getting this
        property you should first check the hasMinimumValue property to see if this property
        applies. Also, the isMinimumValueInclusive indicates if the minimum includes this
        value or will be up to this value.
        
        Setting this value will change the isMinimumValueInclusive to True and the hasMinimumValue
        property to True if hasMinimumValue is currently False, otherwise it will just update the value.
        """
        return float()
    @minimumValue.setter
    def minimumValue(self, value: float):
        """
        Gets and sets minimum value, if any, that the value can be. The value is in radians. When getting this
        property you should first check the hasMinimumValue property to see if this property
        applies. Also, the isMinimumValueInclusive indicates if the minimum includes this
        value or will be up to this value.
        
        Setting this value will change the isMinimumValueInclusive to True and the hasMinimumValue
        property to True if hasMinimumValue is currently False, otherwise it will just update the value.
        """
        pass
    @property
    def hasMinimumValue(self) -> bool:
        """
        Gets and sets if there is a minimum value for this command input. When setting this property, it is only valid
        to set it to False to remove the minimum value. Setting the minimumValue property will result in this property
        being set to True.
        """
        return bool()
    @hasMinimumValue.setter
    def hasMinimumValue(self, value: bool):
        """
        Gets and sets if there is a minimum value for this command input. When setting this property, it is only valid
        to set it to False to remove the minimum value. Setting the minimumValue property will result in this property
        being set to True.
        """
        pass
    @property
    def isMinimumValueInclusive(self) -> bool:
        """
        Gets and sets if the value of the input includes the minimum value or is up to the minimum value. For example,
        if the minimum value is zero and this property is True, the minimum value can be zero. If this is False, the
        minimum value must be greater than zero. When the minimum value is first defined using the minimumValue property,
        this property is set to True. The value returned by this property is only meaningful when the hasMinimumValue property
        returns True.
        """
        return bool()
    @isMinimumValueInclusive.setter
    def isMinimumValueInclusive(self, value: bool):
        """
        Gets and sets if the value of the input includes the minimum value or is up to the minimum value. For example,
        if the minimum value is zero and this property is True, the minimum value can be zero. If this is False, the
        minimum value must be greater than zero. When the minimum value is first defined using the minimumValue property,
        this property is set to True. The value returned by this property is only meaningful when the hasMinimumValue property
        returns True.
        """
        pass
    @property
    def maximumValue(self) -> float:
        """
        Gets and sets maximum value, if any, that the value can be. The value is in radians. When getting this
        property you should first check the hasMaximumValue property to see if this property applies. Also, the
        isMaximumValueInclusive indicates if the minimum includes this value or will be up to this value.
        
        Setting this value will change the isMaximumValueInclusive to True and the hasMaximumValue
        property to True if hasMaximumValue is currently False, otherwise it will just update the value.
        """
        return float()
    @maximumValue.setter
    def maximumValue(self, value: float):
        """
        Gets and sets maximum value, if any, that the value can be. The value is in radians. When getting this
        property you should first check the hasMaximumValue property to see if this property applies. Also, the
        isMaximumValueInclusive indicates if the minimum includes this value or will be up to this value.
        
        Setting this value will change the isMaximumValueInclusive to True and the hasMaximumValue
        property to True if hasMaximumValue is currently False, otherwise it will just update the value.
        """
        pass
    @property
    def hasMaximumValue(self) -> bool:
        """
        Gets and sets if there is a maximum value for this command input. When setting this property, it is only valid
        to set it to False to remove the maximum value. Setting the maximumValue property will result in this property
        being set to True.
        """
        return bool()
    @hasMaximumValue.setter
    def hasMaximumValue(self, value: bool):
        """
        Gets and sets if there is a maximum value for this command input. When setting this property, it is only valid
        to set it to False to remove the maximum value. Setting the maximumValue property will result in this property
        being set to True.
        """
        pass
    @property
    def isMaximumValueInclusive(self) -> bool:
        """
        Gets and sets if the value of the input includes the maximum value or is up to the maximum value. For example,
        if the maximum value is the value of pi (180 degrees) and this property is True, the maximum value can be pi.
        If this is False, the minimum value must be less than pi. When the maximum value is first defined using the
        maximumValue property, this property is set to True. The value returned by this property is only meaningful
        when the hasMaximumValue property returns True.
        """
        return bool()
    @isMaximumValueInclusive.setter
    def isMaximumValueInclusive(self, value: bool):
        """
        Gets and sets if the value of the input includes the maximum value or is up to the maximum value. For example,
        if the maximum value is the value of pi (180 degrees) and this property is True, the maximum value can be pi.
        If this is False, the minimum value must be less than pi. When the maximum value is first defined using the
        maximumValue property, this property is set to True. The value returned by this property is only meaningful
        when the hasMaximumValue property returns True.
        """
        pass
    @property
    def manipulatorOrigin(self) -> Point3D:
        """
        Gets the origin point of the manipulator in the model space of the root component.
        To set the origin use the setManipulator method.
        """
        return Point3D()
    @property
    def manipulatorXDirection(self) -> Vector3D:
        """
        Gets the X direction of the manipulator in the model space of the root component. The X direction is
        the 0 angle direction. This direction, along with the Y direction vector define the plane that the
        manipulator is displayed on.
        
        To set the direction use the setManipulator method.
        """
        return Vector3D()
    @property
    def manipulatorYDirection(self) -> Vector3D:
        """
        Gets the Y direction of the manipulator in the model space of the root component. The X and Y direction
        vectors define the plane that the manipulator is displayed on.
        
        To set the direction use the setManipulator method.
        """
        return Vector3D()
    @property
    def isValidExpression(self) -> bool:
        """
        Returns true if the current expression is valid and can be evaluated. If this
        is false, the value returned should be ignored because there currently is
        not a valid value.
        """
        return bool()

class AppearanceTextureProperty(Property):
    """
    A texture value property associated with a material or appearance.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> AppearanceTextureProperty:
        return AppearanceTextureProperty()
    @property
    def value(self) -> AppearanceTexture:
        """
        Gets and sets this property value.
        """
        return AppearanceTexture()
    @value.setter
    def value(self, value: AppearanceTexture):
        """
        Gets and sets this property value.
        """
        pass
    @property
    def isUsed(self) -> bool:
        """
        Specifies if this AppearanceTexture is being used. This is the equivalent of the
        check box in the Appearance dialog to enable the use of a text for an appearance or not.
        if this is False, then the value property should not be used because there isn't an associated.
        AppearanceTexture.
        """
        return bool()

class ApplicationCommandEvent(Event):
    """
    An event endpoint that supports the connection to ApplicationCommandEventHandlers.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ApplicationCommandEvent:
        return ApplicationCommandEvent()
    def add(self, handler: ApplicationCommandEventHandler) -> bool:
        """
        Adds an event handler object to this event endpoint.
        handler : The ApplicationCommandEventHandler to be called when this event is triggered.
        Returns true if the handler was successfully added to the set of event handlers.
        """
        return bool()
    def remove(self, handler: ApplicationCommandEventHandler) -> bool:
        """
        Removes a handler from this event endpoint.
        handler : An ApplicationCommandEventHandler that was previously added to this event with the add method.
        Returns true if the handler was found and removed from the set of event handlers.
        """
        return bool()

class ApplicationCommandEventArgs(EventArgs):
    """
    Provides a set of arguments from a firing ApplicationCommandEvent to an ApplicationCommandEventHandler's
    notify callback method.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ApplicationCommandEventArgs:
        return ApplicationCommandEventArgs()
    @property
    def commandDefinition(self) -> CommandDefinition:
        """
        Returns the CommandDefinition object for the command the event is being fired for.
        """
        return CommandDefinition()
    @property
    def commandId(self) -> str:
        """
        Returns the unique id of the command the event if being fired for.
        """
        return str()
    @property
    def isCanceled(self) -> bool:
        """
        Used during the commandStarting event to get or set if the command should
        be allowed to continue executing or be canceled. This defaults to false,
        which will allow the command to execute. Setting this to true will cancel
        the command and not begin the execution.
        This property should be ignored for all events besides the commandStarting event.
        """
        return bool()
    @isCanceled.setter
    def isCanceled(self, value: bool):
        """
        Used during the commandStarting event to get or set if the command should
        be allowed to continue executing or be canceled. This defaults to false,
        which will allow the command to execute. Setting this to true will cancel
        the command and not begin the execution.
        This property should be ignored for all events besides the commandStarting event.
        """
        pass
    @property
    def terminationReason(self) -> CommandTerminationReason:
        """
        Returns the reason the command is being terminated.
        This property should be ignored for all events besides the commandTerminated event.
        """
        return CommandTerminationReason()

class ApplicationEvent(Event):
    """
    An ApplicationEvent represents a Fusion 360 application related event. For example, startupCompleted or OnlineStatusChanged
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ApplicationEvent:
        return ApplicationEvent()
    def add(self, handler: ApplicationEventHandler) -> bool:
        """
        Add a handler to be notified when the event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: ApplicationEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class ApplicationEventArgs(EventArgs):
    """
    The ApplicationEventArgs provides information associated with an application event.
    Note that some properties are not available on every event
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ApplicationEventArgs:
        return ApplicationEventArgs()
    @property
    def isOffLine(self) -> bool:
        """
        Gets and sets if Fusion 360 is offline or not.
        """
        return bool()
    @isOffLine.setter
    def isOffLine(self, value: bool):
        """
        Gets and sets if Fusion 360 is offline or not.
        """
        pass
    @property
    def hasInternetAccess(self) -> bool:
        """
        Gets if the client computer has access to the Internet.
        """
        return bool()

class Arc2D(Curve2D):
    """
    Transient 2D arc. A transient arc is not displayed or saved in a document.
    Transient arcs are used as a wrapper to work with raw 2D arc information. They
    are created statically using one of the create methods supported by the Arc2D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Arc2D:
        return Arc2D()
    @staticmethod
    def createByCenter(center: Point2D, radius: float, startAngle: float, endAngle: float, isClockwise: bool) -> Arc2D:
        """
        Creates a transient 2D arc object specifying the center, radius and start and end angles.
        A transient arc is not displayed or saved in a document. Transient arcs arcs are used as
        a wrapper to work with raw 2D arc information.
        center : A Point2D object that defines the center position of the arc in 2D space.
        radius : The radius of the arc.
        startAngle : The start angle in radians, where 0 is along the X-axis.
        endAngle : The end angle in radians, where 0 is along the X-axis.
        isClockwise : Specifies if the sweep of the arc is clockwise or counterclockwise from the start to end angle.
        Returns the newly created arc or null if the creation failed.
        """
        return Arc2D()
    @staticmethod
    def createByThreePoints(startPoint: Point2D, point: Point2D, endPoint: Point2D) -> Arc2D:
        """
        Creates a transient 2D arc by specifying 3 points.
        A transient arc is not displayed or saved in a document. Transient arcs arcs are used as
        a wrapper to work with raw 2D arc information.
        startPoint : The start point of the arc.
        point : A point along the arc.
        endPoint : The end point of the arc.
        Returns the newly created arc or null if the creation failed.
        """
        return Arc2D()
    def copy(self) -> Arc2D:
        """
        Creates and returns an independent copy of this Arc2D object.
        Returns a new Arc2D object that is a copy of this Arc2D object.
        """
        return Arc2D()
    def getData(self) -> tuple[bool, Point2D, float, float, float, bool]:
        """
        Gets all of the data defining the arc.
        center : The output center point of the arc.
        radius : The output radius of the arc.
        startAngle : The output start angle of the arc in radians, where 0 is along the x axis.
        endAngle : The output end angle of the arc in radians, where 0 is along the x axis.
        isClockwise : The output value that indicates if the sweep direction is clockwise or counterclockwise.
        Returns true if successful
        """
        return (bool(), Point2D(), float(), float(), float(), bool())
    def set(self, center: Point2D, radius: float, startAngle: float, endAngle: float, isClockwise: bool) -> bool:
        """
        Sets all of the data defining the arc.
        center : A Point2D object defining the center position of the arc.
        radius : The radius of the arc.
        startAngle : The start angle of the arc in radians, where 0 is along the x axis.
        endAngle : The end angle of the arc in radians, where 0 is along the x axis.
        isClockwise : Indicates if the sweep direction is clockwise or counterclockwise.
        Returns true if redefining the arc is successful
        """
        return bool()
    @property
    def center(self) -> Point2D:
        """
        Gets and sets the center position of the arc.
        """
        return Point2D()
    @center.setter
    def center(self, value: Point2D):
        """
        Gets and sets the center position of the arc.
        """
        pass
    @property
    def radius(self) -> float:
        """
        Gets and sets the radius of the arc.
        """
        return float()
    @radius.setter
    def radius(self, value: float):
        """
        Gets and sets the radius of the arc.
        """
        pass
    @property
    def startAngle(self) -> float:
        """
        Gets and sets the start angle of the arc in radians, where 0 is along the x axis.
        """
        return float()
    @startAngle.setter
    def startAngle(self, value: float):
        """
        Gets and sets the start angle of the arc in radians, where 0 is along the x axis.
        """
        pass
    @property
    def endAngle(self) -> float:
        """
        Gets and sets the end angle of the arc in radians, where 0 is along the x axis.
        """
        return float()
    @endAngle.setter
    def endAngle(self, value: float):
        """
        Gets and sets the end angle of the arc in radians, where 0 is along the x axis.
        """
        pass
    @property
    def isClockwise(self) -> bool:
        """
        Specifies if the sweep direction of the arc is clockwise or counterclockwise.
        """
        return bool()
    @property
    def startPoint(self) -> Point2D:
        """
        Gets the position of the start point of the arc.
        """
        return Point2D()
    @property
    def endPoint(self) -> Point2D:
        """
        Gets the position of the end point of the arc.
        """
        return Point2D()
    @property
    def asNurbsCurve(self) -> NurbsCurve2D:
        """
        Returns a NURBS curve that is geometrically identical to the arc.
        """
        return NurbsCurve2D()

class Arc3D(Curve3D):
    """
    Transient 3D arc. A transient arc is not displayed or saved in a document.
    Transient 3D arcs are used as a wrapper to work with raw 3D arc information.
    They are created statically using one of the create methods of the Arc3D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Arc3D:
        return Arc3D()
    @staticmethod
    def createByCenter(center: Point3D, normal: Vector3D, referenceVector: Vector3D, radius: float, startAngle: float, endAngle: float) -> Arc3D:
        """
        Creates a transient 3D arc object by specifying a center point and radius.
        center : The center point of the arc.
        normal : The normal vector of the arc.
        The plane perpendicular to this normal at the center point is the plane of the arc.
        referenceVector : A reference vector from which the start and end angles are measured from.
        This vector must be perpendicular to the normal vector.
        radius : The radius of the arc.
        startAngle : The start angle in radians.
        This angle is measured from the reference vector using the right hand rule around the normal vector.
        endAngle : The end angle in radians.
        This angle is measured from the reference vector using the right hand rule around the normal vector.
        Returns the newly created arc or null if the creation failed.
        """
        return Arc3D()
    @staticmethod
    def createByThreePoints(pointOne: Point3D, pointTwo: Point3D, pointThree: Point3D) -> Arc3D:
        """
        Creates a transient 3D arc by specifying 3 points.
        A transient arc is not displayed or saved in a document. Transient arcs are used as
        a wrapper to work with raw 3D arc information.
        pointOne : The start point of the arc.
        pointTwo : A point along the arc.
        This point must not be coincident with the first or third points.
        This point must not lie on the line between the first and third points.
        pointThree : The end point of the arc.
        This point must not be coincident with the first or second points.
        Returns the newly created arc or null if the creation failed.
        """
        return Arc3D()
    def setAxes(self, normal: Vector3D, referenceVector: Vector3D) -> bool:
        """
        Sets the normal and reference vectors of the arc.
        normal : The new normal vector.
        referenceVector : The new reference vector from which the start and end angles are measured from.
        The reference vector must be perpendicular to the normal vector.
        Returns true if successful
        """
        return bool()
    def copy(self) -> Arc3D:
        """
        Creates and returns an independent copy of this Arc3D object.
        Returns a new Arc3D object that is a copy of this Arc3D object.
        """
        return Arc3D()
    def getData(self) -> tuple[bool, Point3D, Vector3D, Vector3D, float, float, float]:
        """
        Gets all of the data defining the arc.
        center : The output center point of the arc.
        normal : The output normal vector.
        referenceVector : The output reference vector.
        radius : The output radius of the arc.
        startAngle : The output start angle in radians.
        This angle is measured from the reference vector using the right hand rule around the normal vector.
        endAngle : The output end angle in radians.
        This angle is measured from the reference vector using the right hand rule around the normal vector.
        Returns true if successful
        """
        return (bool(), Point3D(), Vector3D(), Vector3D(), float(), float(), float())
    def set(self, center: Point3D, normal: Vector3D, referenceVector: Vector3D, radius: float, startAngle: float, endAngle: float) -> bool:
        """
        Sets all of the data defining the arc.
        center : The center point of the arc.
        normal : The normal vector of the arc.
        The plane perpendicular to this normal at the center point is the plane of the arc.
        referenceVector : A reference vector from which the start and end angles are measured from.
        This vector must be perpendicular to the normal vector.
        radius : The radius of the arc.
        startAngle : The start angle in radians.
        This angle is measured from the reference vector using the right hand rule around the normal vector.
        endAngle : The end angle in radians.
        This angle is measured from the reference vector using the right hand rule around the normal vector.
        Returns true if successful
        """
        return bool()
    @property
    def center(self) -> Point3D:
        """
        Gets and sets the center position of the arc.
        """
        return Point3D()
    @center.setter
    def center(self, value: Point3D):
        """
        Gets and sets the center position of the arc.
        """
        pass
    @property
    def normal(self) -> Vector3D:
        """
        Gets and sets the normal of the arc.
        """
        return Vector3D()
    @property
    def referenceVector(self) -> Vector3D:
        """
        Gets and sets the reference vector of the arc.
        """
        return Vector3D()
    @property
    def radius(self) -> float:
        """
        Gets and sets the radius of the arc.
        """
        return float()
    @radius.setter
    def radius(self, value: float):
        """
        Gets and sets the radius of the arc.
        """
        pass
    @property
    def startAngle(self) -> float:
        """
        Gets and sets the start angle of the arc in radians.
        This angle is measured from the reference vector using the right hand rule around the normal vector.
        """
        return float()
    @startAngle.setter
    def startAngle(self, value: float):
        """
        Gets and sets the start angle of the arc in radians.
        This angle is measured from the reference vector using the right hand rule around the normal vector.
        """
        pass
    @property
    def endAngle(self) -> float:
        """
        Gets and sets the end angle of the arc in radians.
        This angle is measured from the reference vector using the right hand rule around the normal vector.
        """
        return float()
    @endAngle.setter
    def endAngle(self, value: float):
        """
        Gets and sets the end angle of the arc in radians.
        This angle is measured from the reference vector using the right hand rule around the normal vector.
        """
        pass
    @property
    def startPoint(self) -> Point3D:
        """
        Gets the start point of the arc.
        """
        return Point3D()
    @property
    def endPoint(self) -> Point3D:
        """
        Gets the end point of the arc.
        """
        return Point3D()
    @property
    def asNurbsCurve(self) -> NurbsCurve3D:
        """
        Returns a NURBS curve that is geometrically identical to the arc.
        """
        return NurbsCurve3D()

class BooleanProperty(Property):
    """
    A material or appearance property that is a Boolean value.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BooleanProperty:
        return BooleanProperty()
    @property
    def value(self) -> bool:
        """
        Gets and sets the value of this property.
        """
        return bool()
    @value.setter
    def value(self, value: bool):
        """
        Gets and sets the value of this property.
        """
        pass

class BoolValueCommandInput(CommandInput):
    """
    Provides a command input to get a boolean value from the user. This is represented
    in the user interface as either a button or a check box.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BoolValueCommandInput:
        return BoolValueCommandInput()
    @property
    def value(self) -> bool:
        """
        Gets or sets the state of this input. If it's being displayed as a check box a value of true indicates the input is checked.
        If it's being displayed as a button, a value of true indicates the button is currently depressed.
        """
        return bool()
    @value.setter
    def value(self, value: bool):
        """
        Gets or sets the state of this input. If it's being displayed as a check box a value of true indicates the input is checked.
        If it's being displayed as a button, a value of true indicates the button is currently depressed.
        """
        pass
    @property
    def resourceFolder(self) -> str:
        """
        Gets and sets the folder that contains the image to display on the button. Text
        can also be displayed, which is specified using the text property.
        """
        return str()
    @resourceFolder.setter
    def resourceFolder(self, value: str):
        """
        Gets and sets the folder that contains the image to display on the button. Text
        can also be displayed, which is specified using the text property.
        """
        pass
    @property
    def isCheckBox(self) -> bool:
        """
        Indicates if this is being shown as a button or check box.
        """
        return bool()
    @property
    def text(self) -> str:
        """
        Gets and sets text to be displayed on the button. If the resourceFolder
        is not specified then the button will be displayed with only text. If
        text and the resource folder are specified then both the icon and text
        will be displayed.
        """
        return str()
    @text.setter
    def text(self, value: str):
        """
        Gets and sets text to be displayed on the button. If the resourceFolder
        is not specified then the button will be displayed with only text. If
        text and the resource folder are specified then both the icon and text
        will be displayed.
        """
        pass

class BrowserCommandInput(CommandInput):
    """
    Browser command inputs behave as a browser where you can define HTML to be displayed within the
    area occupied by the command input.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BrowserCommandInput:
        return BrowserCommandInput()
    def sendInfoToHTML(self, action: str, data: str) -> bool:
        """
        <p>Sends the string to the JavaScript associated with the loaded HTML. A variation of the
        event handler below should be implemented in the JavaScript associated with the HTML to
        receive the data. The event will be triggered by Fusion 360 whenever the sendInfoToHTML method
        is called.</p>
        
        <pre class="api-code">window.fusionJavaScriptHandler = {
        handle: function(actionString, dataString){
        confirm('Action from Fusion: ' + actionString);
        confirm('Data from Fusion: ' + dataString);
        
        // Build up JSON return string.
        var result = {};
        result.status = 'OK';
        var response = JSON.stringify(result);
        return response;
        }
        };</pre>
        <p>Your JavaScript code should always return something in response because an empty string
        response is assumed to be a failure.</p>
        action : The "action" string to pass to the JavaScript associated with the HTML. This string can be
        anything but will typically be JSON formatted information.
        data : The "data" string to pass to the JavaScript associated with the HTML. This string can be
        anything but will typically be JSON formatted information.
        This API call is asynchronous and true is returned if the send was successful. Any response from
        the JavaScript response will be returned through the incomingFromHTML event using the data field of
        the provided HTMLEvent object where the action property is "response".
        """
        return bool()
    @property
    def htmlFileURL(self) -> str:
        """
        Gets and sets the URL to the HTML file currently being displayed. This can be local or on the web.
        """
        return str()
    @htmlFileURL.setter
    def htmlFileURL(self, value: str):
        """
        Gets and sets the URL to the HTML file currently being displayed. This can be local or on the web.
        """
        pass
    @property
    def minimumHeight(self) -> int:
        """
        Gets and sets the minimum height of the browser within the command dialog in pixels. As the user resizes the dialog, the area taken
        up by the browser will shrink and grow to fit within the defined space. It will never shrink to be less than the
        minimum height or expand to be larger than the maximum height. If the dialog can't fit the browser at the minimum size
        a scroll bar will appear for the dialog to allow the user to scroll to access all the inputs in the dialog.
        """
        return int()
    @minimumHeight.setter
    def minimumHeight(self, value: int):
        """
        Gets and sets the minimum height of the browser within the command dialog in pixels. As the user resizes the dialog, the area taken
        up by the browser will shrink and grow to fit within the defined space. It will never shrink to be less than the
        minimum height or expand to be larger than the maximum height. If the dialog can't fit the browser at the minimum size
        a scroll bar will appear for the dialog to allow the user to scroll to access all the inputs in the dialog.
        """
        pass
    @property
    def maximumHeight(self) -> int:
        """
        Gets and sets the maximum height of the browser within the command dialog, in pixels. As the user resizes
        the dialog, the area taken up by the browser will shrink and grow to fit within the defined space. It will never
        shrink to be less than the minimum height or expand to be larger than the maximum height. If the content displayed
        within the browser does not fit within the current area, a scroll bar will appear to allow the user to scroll to see
        the entire browser content. The default value of zero sets no maximum height, so the browser will expand to the maximum
        extent available.
        """
        return int()
    @maximumHeight.setter
    def maximumHeight(self, value: int):
        """
        Gets and sets the maximum height of the browser within the command dialog, in pixels. As the user resizes
        the dialog, the area taken up by the browser will shrink and grow to fit within the defined space. It will never
        shrink to be less than the minimum height or expand to be larger than the maximum height. If the content displayed
        within the browser does not fit within the current area, a scroll bar will appear to allow the user to scroll to see
        the entire browser content. The default value of zero sets no maximum height, so the browser will expand to the maximum
        extent available.
        """
        pass

class ButtonControlDefinition(ControlDefinition):
    """
    Represents the information used to define a button. This isn't the visible button control but
    is the information needed to create a button control and fully defines a button except for
    it's position within the user interface.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ButtonControlDefinition:
        return ButtonControlDefinition()

class ButtonRowCommandInput(CommandInput):
    """
    Provides a command input to get a selection of a single button from a row of buttons.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ButtonRowCommandInput:
        return ButtonRowCommandInput()
    @property
    def isMultiSelectEnabled(self) -> bool:
        """
        Returns if this button row can have multiple items selected at once or not.
        If True, multiple buttons can be selected at once. If False only one button
        can be selected and selecting another button unselects the one currently selected.
        """
        return bool()
    @property
    def listItems(self) -> ListItems:
        """
        Returns the ListItems object associated with this button row. You use this
        object to populate and interact with the buttons in the row. When adding items
        to a ButtonRowCommandInput, icons are required.
        """
        return ListItems()
    @property
    def selectedItem(self) -> ListItem:
        """
        Gets the button in the row that is currently selected. This can return null in the
        case where no button in the row has been selected.
        """
        return ListItem()

class CameraEvent(Event):
    """
    A CameraEvent represents an event that occurs in reaction to the user manipulating the view.
    Camera changes happen when user changes the view by rotating, zooming in or out, panning,
    changing from parallel to perspective, or when the extents of the viewport changes.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CameraEvent:
        return CameraEvent()
    def add(self, handler: CameraEventHandler) -> bool:
        """
        Add a handler to be notified when the event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: CameraEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class CameraEventArgs(EventArgs):
    """
    The CameraEventArgs provides information associated with a camera change.
    Camera changes happen when user changes the view by rotating, zooming in or out, panning,
    changing from parallel to perspective, or when the extents of the viewport changes.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CameraEventArgs:
        return CameraEventArgs()
    @property
    def viewport(self) -> Viewport:
        """
        Returns the viewport that the modified camera is associated with.
        """
        return Viewport()

class CheckBoxControlDefinition(ControlDefinition):
    """
    Represents the information used to define a check box. This isn't the visible check box control but
    is the information needed to create a check box control and fully defines a check box except for
    it's position within the user interface.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CheckBoxControlDefinition:
        return CheckBoxControlDefinition()
    @property
    def isChecked(self) -> bool:
        """
        Gets or sets whether the check box is checked. Changing this will result in changing any
        associated controls and will execute the associated command.
        """
        return bool()
    @isChecked.setter
    def isChecked(self, value: bool):
        """
        Gets or sets whether the check box is checked. Changing this will result in changing any
        associated controls and will execute the associated command.
        """
        pass

class ChoiceProperty(Property):
    """
    A material or appearance property that is a pre-defined list of choices.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ChoiceProperty:
        return ChoiceProperty()
    def getChoices(self) -> tuple[bool, list[str], list[str]]:
        """
        Method that returns the list of available choices.
        names : An array of the names of the choices. These coincide with the array of choices returned by the choices argument.
        choices : An array of the choices. These coincide with the array of names returned by the names argument.
        Returns true if the call was successful.
        """
        return (bool(), [str()], [str()])
    @property
    def value(self) -> str:
        """
        Gets and sets the which choice is selected from the set of choices.
        The value is a string that matches one of the pre-defined choices.
        The names of the available choices can be obtained using GetChoices method.
        """
        return str()
    @value.setter
    def value(self, value: str):
        """
        Gets and sets the which choice is selected from the set of choices.
        The value is a string that matches one of the pre-defined choices.
        The names of the available choices can be obtained using GetChoices method.
        """
        pass

class Circle2D(Curve2D):
    """
    Transient 2D circle. A transient circle is not displayed or saved in a document.
    Transient circles are used as a wrapper to work with raw 2D arc information. They
    are created statically using one of the create methods of the Circle2D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Circle2D:
        return Circle2D()
    @staticmethod
    def createByCenter(center: Point2D, radius: float) -> Circle2D:
        """
        Creates a transient 2D circle object by specifying a center and radius.
        center : A Point2D object that defines the center of the circle.
        radius : The radius of the circle.
        Returns the new Circle2D object or null if the creation failed.
        """
        return Circle2D()
    @staticmethod
    def createByThreePoints(pointOne: Point2D, pointTwo: Point2D, pointThree: Point2D) -> Circle2D:
        """
        Creates a transient 2D circle through three points.
        pointOne : The first point on the circle.
        pointTwo : The second point on the circle.
        pointThree : The third point on the circle.
        Returns the new Circle2D object or null if the creation failed.
        """
        return Circle2D()
    def copy(self) -> Circle2D:
        """
        Creates and returns an independent copy of this Circle2D object.
        Returns an independent copy of this Circle2D object.
        """
        return Circle2D()
    def getData(self) -> tuple[bool, Point2D, float]:
        """
        Gets all of the data defining the circle.
        center : The output point defining the center position of the circle.
        radius : The output radius of the circle.
        Returns true if successful.
        """
        return (bool(), Point2D(), float())
    def set(self, center: Point2D, radius: float) -> bool:
        """
        Sets all of the data defining the circle.
        center : A point that defines the center position of the circle.
        radius : The radius of the circle.
        Returns true if redefining the circle is successful
        """
        return bool()
    @property
    def center(self) -> Point2D:
        """
        Gets and sets the center position of the circle.
        """
        return Point2D()
    @center.setter
    def center(self, value: Point2D):
        """
        Gets and sets the center position of the circle.
        """
        pass
    @property
    def radius(self) -> float:
        """
        Gets and sets the radius of the circle.
        """
        return float()
    @radius.setter
    def radius(self, value: float):
        """
        Gets and sets the radius of the circle.
        """
        pass
    @property
    def asNurbsCurve(self) -> NurbsCurve2D:
        """
        Returns a NURBS curve that is geometrically identical to the circle.
        """
        return NurbsCurve2D()

class Circle3D(Curve3D):
    """
    Transient 3D circle. A transient circle is not displayed or saved in a document.
    Transient 3D circles are used as a wrapper to work with raw 3D circle information.
    They are created statically using one of the create methods of the Circle3D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Circle3D:
        return Circle3D()
    @staticmethod
    def createByCenter(center: Point3D, normal: Vector3D, radius: float) -> Circle3D:
        """
        Creates a transient 3D circle object by specifying a center and radius.
        center : The center point of the circle.
        normal : The normal vector of the circle.
        The plane through the center point and perpendicular to the normal vector defines the plane of the circle.
        radius : The radius of the circle.
        Returns the new Circle3D object or null if the creation failed.
        """
        return Circle3D()
    @staticmethod
    def createByThreePoints(pointOne: Point3D, pointTwo: Point3D, pointThree: Point3D) -> Circle3D:
        """
        Creates a transient 3D circle through three points.
        pointOne : The first point on the circle.
        pointTwo : The second point on the circle.
        This point cannot be coincident with pointOne or pointThree.
        This point cannot lie on the line defined by pointOne and pointThree.
        pointThree : The third point on the circle.
        This point cannot be coincident with pointOne or pointThree.
        Returns the new Circle3D object or null if the creation failed.
        """
        return Circle3D()
    def copy(self) -> Circle3D:
        """
        Creates and returns an independent copy of this Circle3D object.
        Returns an independent copy of this Circle3D object.
        """
        return Circle3D()
    def getData(self) -> tuple[bool, Point3D, Vector3D, float]:
        """
        Gets all of the data defining the circle.
        center : The output center point of the circle.
        normal : The output normal vector.
        radius : The output radius of the circle.
        Returns true if successful
        """
        return (bool(), Point3D(), Vector3D(), float())
    def set(self, center: Point3D, normal: Vector3D, radius: float) -> bool:
        """
        Sets all of the data defining the circle.
        center : The center point of the circle.
        normal : The normal vector of the circle.
        The plane through the center point and perpendicular to the normal vector defines the plane of the circle.
        radius : The radius of the circle.
        Returns true if successful
        """
        return bool()
    @property
    def center(self) -> Point3D:
        """
        Gets and sets the center position of the circle.
        """
        return Point3D()
    @center.setter
    def center(self, value: Point3D):
        """
        Gets and sets the center position of the circle.
        """
        pass
    @property
    def normal(self) -> Vector3D:
        """
        Gets and sets the normal of the circle.
        """
        return Vector3D()
    @normal.setter
    def normal(self, value: Vector3D):
        """
        Gets and sets the normal of the circle.
        """
        pass
    @property
    def radius(self) -> float:
        """
        Gets and sets the radius of the circle.
        """
        return float()
    @radius.setter
    def radius(self, value: float):
        """
        Gets and sets the radius of the circle.
        """
        pass
    @property
    def asNurbsCurve(self) -> NurbsCurve3D:
        """
        Returns a NURBS curve that is geometrically identical to the circle.
        """
        return NurbsCurve3D()

class ColorProperty(Property):
    """
    A color property associated with an appearance.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ColorProperty:
        return ColorProperty()
    @property
    def connectedTexture(self) -> AppearanceTexture:
        """
        Gets the associated texture, if one exists. The HasConnectedTexture property controls
        if there is an associated texture or not. If the parent is writable you can edit the
        texture. If no texture exists, this property will return null.
        """
        return AppearanceTexture()
    @property
    def hasConnectedTexture(self) -> bool:
        """
        Specifies if this color is specified using a simple color or a texture. If this returns true
        the color is defined using a texture. If the parent is writable, this property can be set to
        true to change the definition from a simple color to a texture. You can then use the ConnectedTexture
        property to get the associated texture and modify it.
        """
        return bool()
    @hasConnectedTexture.setter
    def hasConnectedTexture(self, value: bool):
        """
        Specifies if this color is specified using a simple color or a texture. If this returns true
        the color is defined using a texture. If the parent is writable, this property can be set to
        true to change the definition from a simple color to a texture. You can then use the ConnectedTexture
        property to get the associated texture and modify it.
        """
        pass
    @property
    def hasMultipleValues(self) -> bool:
        """
        Indicates if this property has multiple values or not.
        """
        return bool()
    @property
    def value(self) -> Color:
        """
        Gets and sets this property value if there is a color and not a texture defining
        this color . If a texture is used, this property returns null. Setting this property
        when a texture is used removes the texture and changes the color definition to a simple color.
        """
        return Color()
    @value.setter
    def value(self, value: Color):
        """
        Gets and sets this property value if there is a color and not a texture defining
        this color . If a texture is used, this property returns null. Setting this property
        when a texture is used removes the texture and changes the color definition to a simple color.
        """
        pass
    @property
    def values(self) -> list[Color]:
        """
        Gets and sets the values associated with this property. The HasMultipleValues property
        indicates if this property will be returning more than one value.
        """
        return [Color()]
    @values.setter
    def values(self, value: list[Color]):
        """
        Gets and sets the values associated with this property. The HasMultipleValues property
        indicates if this property will be returning more than one value.
        """
        pass

class CommandControl(ToolbarControl):
    """
    Represents a button, check box, or radio control list in a panel, toolbar, or drop-down.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CommandControl:
        return CommandControl()
    @property
    def commandDefinition(self) -> CommandDefinition:
        """
        Gets the command definition associated with this button. The command definition defines
        all of the resource information used to display this button and receives the event when the button is clicked.
        """
        return CommandDefinition()
    @property
    def isPromoted(self) -> bool:
        """
        Gets or sets if this command has been promoted to the parent panel.
        This property is ignored in the case where this control isn't in a panel.
        """
        return bool()
    @isPromoted.setter
    def isPromoted(self, value: bool):
        """
        Gets or sets if this command has been promoted to the parent panel.
        This property is ignored in the case where this control isn't in a panel.
        """
        pass
    @property
    def isPromotedByDefault(self) -> bool:
        """
        Gets or sets if this command is a default command in the panel.
        This defines the default state of the panel if the UI is reset.
        This property is ignored in the case where this control isn't in a panel.
        """
        return bool()
    @isPromotedByDefault.setter
    def isPromotedByDefault(self, value: bool):
        """
        Gets or sets if this command is a default command in the panel.
        This defines the default state of the panel if the UI is reset.
        This property is ignored in the case where this control isn't in a panel.
        """
        pass

class CommandCreatedEvent(Event):
    """
    Class that needs to be implemented in order to respond to the CommandCreatedEvent event.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CommandCreatedEvent:
        return CommandCreatedEvent()
    def add(self, handler: CommandCreatedEventHandler) -> bool:
        """
        Adds an event handler object to this event endpoint.
        handler : The client implemented CommandCreatedEventHandler to be called when this event is triggered.
        Returns true if the handler was successfully added to the set of event handlers.
        """
        return bool()
    def remove(self, handler: CommandCreatedEventHandler) -> bool:
        """
        Removes a handler from this event endpoint.
        handler : A CommandCreatedEventHandler that was previously added to this event with the add method.
        Returns true if the handler was found and removed from the set of event handlers.
        """
        return bool()

class CommandCreatedEventArgs(EventArgs):
    """
    Provides data for the CommandCreated event.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CommandCreatedEventArgs:
        return CommandCreatedEventArgs()
    @property
    def command(self) -> Command:
        """
        Gets the newly created Command object that allows you to perform an action in response to the control being clicked.
        """
        return Command()

class CommandEvent(Event):
    """
    An event endpoint that supports the connection to client implemented CommandEventHandlers.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CommandEvent:
        return CommandEvent()
    def add(self, handler: CommandEventHandler) -> bool:
        """
        Adds an event handler object to this event endpoint.
        handler : The client implemented CommandEventHandler to be called when this event is triggered.
        Returns true if the handler was successfully added to the set of event handlers.
        """
        return bool()
    def remove(self, handler: CommandEventHandler) -> bool:
        """
        Removes a handler from this event endpoint.
        handler : A CommandEventHandler that was previously added to this event with the add method.
        Returns true if the handler was found and removed from the set of event handlers.
        """
        return bool()

class CommandEventArgs(EventArgs):
    """
    Provides a set of arguments from a firing CommandEvent to a CommandEventHandler's notify callback method.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CommandEventArgs:
        return CommandEventArgs()
    @property
    def command(self) -> Command:
        """
        Gets the Command object.
        """
        return Command()
    @property
    def executeFailed(self) -> bool:
        """
        Used during the execute event to get or set that the execute operations failed
        and the commands transaction should be aborted.
        This property should be ignored for all events besides the Execute event.
        """
        return bool()
    @executeFailed.setter
    def executeFailed(self, value: bool):
        """
        Used during the execute event to get or set that the execute operations failed
        and the commands transaction should be aborted.
        This property should be ignored for all events besides the Execute event.
        """
        pass
    @property
    def executeFailedMessage(self) -> str:
        """
        Used during the execute event to get or set a description of an execute failure.
        This property should be ignored for all events besides the Execute event.
        """
        return str()
    @executeFailedMessage.setter
    def executeFailedMessage(self, value: str):
        """
        Used during the execute event to get or set a description of an execute failure.
        This property should be ignored for all events besides the Execute event.
        """
        pass
    @property
    def isValidResult(self) -> bool:
        """
        Used during the commandStarting event to get or set that the result of preview is valid
        and the command can reuse the result when OK is hit.
        This property should be ignored for all events besides the executePreview event.
        """
        return bool()
    @isValidResult.setter
    def isValidResult(self, value: bool):
        """
        Used during the commandStarting event to get or set that the result of preview is valid
        and the command can reuse the result when OK is hit.
        This property should be ignored for all events besides the executePreview event.
        """
        pass
    @property
    def terminationReason(self) -> CommandTerminationReason:
        """
        Gets the termination reason of the command. It's only valid on the destroy event.
        """
        return CommandTerminationReason()

class Cone(Surface):
    """
    Transient cone. A transient cone is not displayed or saved in a document.
    A transient cone is used as a wrapper to work with raw cone information.
    A transient cone has no boundaries.
    The cone always goes to a point in its narrowing direction, and is infinite in its
    widening direction.
    They are created statically using the create method of the Cone class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Cone:
        return Cone()
    @staticmethod
    def create(origin: Point3D, axis: Vector3D, radius: float, halfAngle: float) -> Cone:
        """
        Creates a transient cone object.
        origin : The origin point (center) of the base of the cone.
        axis : The center axis (along the length) of the cone that defines its normal direction.
        radius : The radius of the cone.
        halfAngle : The taper half-angle of the cone.
        Returns the new Cone object or null if the creation failed.
        """
        return Cone()
    def getData(self) -> tuple[bool, Point3D, Vector3D, float, float]:
        """
        Gets the data that defines the cone.
        origin : The output origin point (center) of the base of the cone.
        axis : The output center axis (along the length) of the cone that defines its normal direction.
        radius : The output radius of the cone.
        halfAngle : The output taper half-angle of the cone.
        Returns true if successful.
        """
        return (bool(), Point3D(), Vector3D(), float(), float())
    def set(self, origin: Point3D, axis: Vector3D, radius: float, halfAngle: float) -> bool:
        """
        Sets the data that defines the cone.
        origin : The origin point (center) of the base of the cone.
        axis : The center axis (along the length) of the cone that defines its normal direction.
        radius : The radius of the cone.
        halfAngle : The taper half-angle of the cone.
        Returns true if successful.
        """
        return bool()
    def copy(self) -> Cone:
        """
        Creates and returns an independent copy of this Cone object.
        Returns a new Cone object that is a copy of this Cone object.
        """
        return Cone()
    @property
    def origin(self) -> Point3D:
        """
        Gets and sets the origin point (center) of the base of the cone.
        """
        return Point3D()
    @origin.setter
    def origin(self, value: Point3D):
        """
        Gets and sets the origin point (center) of the base of the cone.
        """
        pass
    @property
    def axis(self) -> Vector3D:
        """
        Gets and sets the center axis (along the length) of the cone that defines its
        normal direction.
        """
        return Vector3D()
    @axis.setter
    def axis(self, value: Vector3D):
        """
        Gets and sets the center axis (along the length) of the cone that defines its
        normal direction.
        """
        pass
    @property
    def radius(self) -> float:
        """
        Gets and sets the radius of the cone.
        """
        return float()
    @radius.setter
    def radius(self, value: float):
        """
        Gets and sets the radius of the cone.
        """
        pass
    @property
    def halfAngle(self) -> float:
        """
        Gets and sets the taper half-angle of the cone in radians.
        A negative value indicates that the cone is narrowing in the direction of the
        axis vector, whereas a positive value indicates that it is expanding in the direction of
        the axis vector.
        """
        return float()
    @halfAngle.setter
    def halfAngle(self, value: float):
        """
        Gets and sets the taper half-angle of the cone in radians.
        A negative value indicates that the cone is narrowing in the direction of the
        axis vector, whereas a positive value indicates that it is expanding in the direction of
        the axis vector.
        """
        pass

class CustomEvent(Event):
    """
    A CustomEvent is primarily used to send an event from a worker thread you've created back
    to your add-in, which is running in the primary thread. It's also possible for add-ins to
    cooperate and another add-in can trigger this event in your add-in by knowing the custom
    event id.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomEvent:
        return CustomEvent()
    def add(self, handler: CustomEventHandler) -> bool:
        """
        Add a handler to be notified when the event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: CustomEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()
    @property
    def eventId(self) -> str:
        """
        Returns the id that was assigned to this event when it was registered. Each
        custom event has it's own unique id.
        """
        return str()

class CustomEventArgs(EventArgs):
    """
    The ApplicationEventArgs provides information associated with an application event.
    Note that some properties are not available on every event
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CustomEventArgs:
        return CustomEventArgs()
    @property
    def additionalInfo(self) -> str:
        """
        Information being passed to the add-in in the primary thread from the worker thread
        or other add-in.
        """
        return str()

class Cylinder(Surface):
    """
    Transient cylinder. A transient cylinder is not displayed or saved in a document.
    A transient cylinder is but is used as a wrapper to work with raw cylinder information.
    A transient cylinder has no boundaries and is infinite in length.
    They are created statically using the create method of the Cylinder class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Cylinder:
        return Cylinder()
    @staticmethod
    def create(origin: Point3D, axis: Vector3D, radius: float) -> Cylinder:
        """
        Creates a transient cylinder object.
        origin : The origin point (center) of the base of the cylinder.
        axis : The center axis (along the length) of the cylinder that defines its normal direction.
        radius : The radius of the cylinder.
        Returns the new Cylinder object or null if the creation failed.
        """
        return Cylinder()
    def getData(self) -> tuple[bool, Point3D, Vector3D, float]:
        """
        Gets the data that defines the cylinder.
        origin : The output origin point (center) of the base of the cylinder.
        axis : The output center axis (along the length) of the cylinder that defines its normal direction.
        radius : The output radius of the cylinder.
        Returns true if successful.
        """
        return (bool(), Point3D(), Vector3D(), float())
    def set(self, origin: Point3D, axis: Vector3D, radius: float) -> bool:
        """
        Sets the data that defines the cylinder.
        origin : The origin point (center) of the base of the cylinder.
        axis : The center axis (along the length) of the cylinder that defines its normal direction.
        radius : The radius of the cylinder.
        Returns true if successful.
        """
        return bool()
    def copy(self) -> Cylinder:
        """
        Creates and returns an independent copy of this Cylinder object.
        Returns a new Cylinder object that is a copy of this Cylinder object.
        """
        return Cylinder()
    @property
    def origin(self) -> Point3D:
        """
        The origin point (center) of the base of the cylinder.
        """
        return Point3D()
    @origin.setter
    def origin(self, value: Point3D):
        """
        The origin point (center) of the base of the cylinder.
        """
        pass
    @property
    def axis(self) -> Vector3D:
        """
        The center axis (along the length) of the cylinder that defines its normal direction.
        """
        return Vector3D()
    @axis.setter
    def axis(self, value: Vector3D):
        """
        The center axis (along the length) of the cylinder that defines its normal direction.
        """
        pass
    @property
    def radius(self) -> float:
        """
        The radius of the cylinder.
        """
        return float()
    @radius.setter
    def radius(self, value: float):
        """
        The radius of the cylinder.
        """
        pass

class DataEvent(Event):
    """
    A Data event is an event associated with operations on Data items.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataEvent:
        return DataEvent()
    def add(self, handler: DataEventHandler) -> bool:
        """
        Add a handler to be notified when the data event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: DataEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class DataEventArgs(EventArgs):
    """
    The DataEventArgs provides information associated with a data event.
    Note that some properties are not available on every event.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DataEventArgs:
        return DataEventArgs()
    @property
    def filename(self) -> str:
        """
        Gets the filename associated with the operation. If there isn't an associated
        filename, an empty string is returned. For a download operation, this will
        be the full filename of the downloaded file.
        """
        return str()
    @property
    def file(self) -> DataFile:
        """
        Gets the DataFile object associated with this event. If there isn't
        a DataFile associated with the event, this property will return null.
        """
        return DataFile()
    @property
    def status(self) -> Status:
        """
        Returns a Status object that provides additional information about the
        success or failure of the operation.
        """
        return Status()

class DirectionCommandInput(CommandInput):
    """
    Represents a command input that gets a direction from the user. This displays
    a button or a check-box in the command dialog where the user can flip the direction if desired and also displays
    a manipulator in the graphics window to allow flipping the direction by clicking and dragging on the manipulator.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DirectionCommandInput:
        return DirectionCommandInput()
    def setManipulator(self, origin: Point3D, direction: Vector3D) -> bool:
        """
        Defines a direction manipulator arrow in the graphics viewport whose direction can be flipped by the
        toggling the check box, clicking the button or by the user clicking and dragging on the manipulator arrow.
        origin : The origin point of the direction manipulator (arrow) in the model space of the root component.
        direction : The direction of the manipulator (arrow) in the model space of the root component.
        Returns true if successful
        """
        return bool()
    @property
    def manipulatorOrigin(self) -> Point3D:
        """
        Gets the origin point of the direction manipulator (arrow) in the model space of the root component.
        To set the origin use the setManipulator method.
        """
        return Point3D()
    @property
    def manipulatorDirection(self) -> Vector3D:
        """
        Gets the direction of the manipulator (arrow) in the model space of the root component.
        To set the direction use the setManipulator method.
        """
        return Vector3D()
    @property
    def isDirectionFlipped(self) -> bool:
        """
        Gets and sets if the direction manipulator displayed is flipped (reversed 180 degrees as compared to the
        direction defined by the manipulatorDirection property). This is false for a newly created DirectionCommandInput.
        """
        return bool()
    @isDirectionFlipped.setter
    def isDirectionFlipped(self, value: bool):
        """
        Gets and sets if the direction manipulator displayed is flipped (reversed 180 degrees as compared to the
        direction defined by the manipulatorDirection property). This is false for a newly created DirectionCommandInput.
        """
        pass
    @property
    def resourceFolder(self) -> str:
        """
        Gets and sets the folder that contains the image to display on the button.
        The input is shown as a check box if set resource folder to empty.
        """
        return str()
    @resourceFolder.setter
    def resourceFolder(self, value: str):
        """
        Gets and sets the folder that contains the image to display on the button.
        The input is shown as a check box if set resource folder to empty.
        """
        pass

class DistanceValueCommandInput(CommandInput):
    """
    Represents a command input that gets a distance from the user. This displays
    an entry in the command dialog where the user can enter a value and also displays
    a manipulator in the graphics window to allow them to graphically set the value.
    The input box is displayed in the dialog when the isVisible property of the command
    input is true. The manipulator is displayed in the graphics when both the isVisible
    and isEnabled properties are true.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DistanceValueCommandInput:
        return DistanceValueCommandInput()
    def setManipulator(self, origin: Point3D, direction: Vector3D) -> bool:
        """
        Defines the position and orientation of the manipulator. The manipulator is only visible
        when both the isVisible and isEnabled properties are true. If those properties are
        true and the setManipulator has not been called, the manipulator will be displayed in
        a default location (0,0,0) and direction (1,0,0). Because of that the input is typically
        set to be invisible and/or disabled and then enabled once enough input has been specified
        that you can display the manipulator in the desired location.
        origin : Defines the position of the manipulator in root component space.
        direction : Defines the direction of the manipulator in root component space.
        Returns true if successful.
        """
        return bool()
    @property
    def value(self) -> float:
        """
        Gets and sets the current value of the command input. The value is
        in centimeters but will be displayed to the user in the current default
        document units. Setting this value can fail if the input value is
        not within the minimum and maximum value range.
        
        The isValidExpression property should be checked before using this
        value within the command because if the expression can't be evaluated
        there isn't a valid value. Fusion 360 won't allow the execution of a command
        that contains ValueCommandInput object with invalid expressions so you can
        dependably use the value in the execute event of the command.
        """
        return float()
    @value.setter
    def value(self, value: float):
        """
        Gets and sets the current value of the command input. The value is
        in centimeters but will be displayed to the user in the current default
        document units. Setting this value can fail if the input value is
        not within the minimum and maximum value range.
        
        The isValidExpression property should be checked before using this
        value within the command because if the expression can't be evaluated
        there isn't a valid value. Fusion 360 won't allow the execution of a command
        that contains ValueCommandInput object with invalid expressions so you can
        dependably use the value in the execute event of the command.
        """
        pass
    @property
    def expression(self) -> str:
        """
        Gets or sets the expression displayed in the input field. This can contain equations and
        references to parameters but must result in a valid length expression. If units are not
        specified as part of the expression, the default units for the design are used.
        """
        return str()
    @expression.setter
    def expression(self, value: str):
        """
        Gets or sets the expression displayed in the input field. This can contain equations and
        references to parameters but must result in a valid length expression. If units are not
        specified as part of the expression, the default units for the design are used.
        """
        pass
    @property
    def minimumValue(self) -> float:
        """
        Gets and sets minimum value, if any, that the value can be. When getting this
        property you should first check the hasMinimumValue property to see if this property
        applies. Also, the isMinimumValueInclusive indicates if the minimum includes this
        value or will be up to this value.
        
        Setting this value will change the isMinimumValueInclusive to True and the hasMinimumValue property to True if hasMinimumValue is currently
        False, otherwise it will just update the value.
        """
        return float()
    @minimumValue.setter
    def minimumValue(self, value: float):
        """
        Gets and sets minimum value, if any, that the value can be. When getting this
        property you should first check the hasMinimumValue property to see if this property
        applies. Also, the isMinimumValueInclusive indicates if the minimum includes this
        value or will be up to this value.
        
        Setting this value will change the isMinimumValueInclusive to True and the hasMinimumValue property to True if hasMinimumValue is currently
        False, otherwise it will just update the value.
        """
        pass
    @property
    def hasMinimumValue(self) -> bool:
        """
        Gets and sets if there is a minimum value for this command input. When setting this property, it is only valid
        to set it to False to remove the minimum value. Setting the minimumValue property will result in this property
        being set to True.
        """
        return bool()
    @hasMinimumValue.setter
    def hasMinimumValue(self, value: bool):
        """
        Gets and sets if there is a minimum value for this command input. When setting this property, it is only valid
        to set it to False to remove the minimum value. Setting the minimumValue property will result in this property
        being set to True.
        """
        pass
    @property
    def isMinimumValueInclusive(self) -> bool:
        """
        Gets and sets if the value of the input includes the minimum value or is up to the minimum value. For example,
        if the minimum value is zero and this property is True, the minimum value can be zero. If this is False, the
        minimum value must be greater than zero. When the minimum value is first defined using the minimumValue property,
        this property is set to True. The value returned by this property is only meaningful when the hasMinimumValue property
        returns True.
        """
        return bool()
    @isMinimumValueInclusive.setter
    def isMinimumValueInclusive(self, value: bool):
        """
        Gets and sets if the value of the input includes the minimum value or is up to the minimum value. For example,
        if the minimum value is zero and this property is True, the minimum value can be zero. If this is False, the
        minimum value must be greater than zero. When the minimum value is first defined using the minimumValue property,
        this property is set to True. The value returned by this property is only meaningful when the hasMinimumValue property
        returns True.
        """
        pass
    @property
    def maximumValue(self) -> float:
        """
        Gets and sets maximum value, if any, that the value can be. When getting this
        property you should first check the hasMaximumValue property to see if this property
        applies. Also, the isMaximumValueInclusive indicates if the maximum includes this
        value or will be up to this value.
        """
        return float()
    @maximumValue.setter
    def maximumValue(self, value: float):
        """
        Gets and sets maximum value, if any, that the value can be. When getting this
        property you should first check the hasMaximumValue property to see if this property
        applies. Also, the isMaximumValueInclusive indicates if the maximum includes this
        value or will be up to this value.
        """
        pass
    @property
    def hasMaximumValue(self) -> bool:
        """
        Gets and sets if there is a maximum value for this command input. When setting this property, it is only valid
        to set it to False to remove the maximum value. Setting the maximumValue property will result in this property
        being set to True.
        """
        return bool()
    @hasMaximumValue.setter
    def hasMaximumValue(self, value: bool):
        """
        Gets and sets if there is a maximum value for this command input. When setting this property, it is only valid
        to set it to False to remove the maximum value. Setting the maximumValue property will result in this property
        being set to True.
        """
        pass
    @property
    def isMaximumValueInclusive(self) -> bool:
        """
        Gets and sets if the value of the input includes the maximum value or is up to the maximum value. For example,
        if the maximum value is 100 and this property is True, the maximum value can be 100. If this is False, the
        minimum value must be less than 100. When the maximum value is first defined using the maximumValue property,
        this property is set to True. The value returned by this property is only meaningful when the hasMaximumValue property
        returns True.
        """
        return bool()
    @isMaximumValueInclusive.setter
    def isMaximumValueInclusive(self, value: bool):
        """
        Gets and sets if the value of the input includes the maximum value or is up to the maximum value. For example,
        if the maximum value is 100 and this property is True, the maximum value can be 100. If this is False, the
        minimum value must be less than 100. When the maximum value is first defined using the maximumValue property,
        this property is set to True. The value returned by this property is only meaningful when the hasMaximumValue property
        returns True.
        """
        pass
    @property
    def manipulatorOrigin(self) -> Point3D:
        """
        Gets the origin point of the manipulator in the model space of the root component.
        To set the origin use the setManipulator method.
        """
        return Point3D()
    @property
    def manipulatorDirection(self) -> Vector3D:
        """
        Gets the positive direction of the manipulator in the model space or the root component.
        To set the direction use the setManipulator method.
        """
        return Vector3D()
    @property
    def isValidExpression(self) -> bool:
        """
        Returns true if the current expression is valid and can be evaluated. If this
        is false, the value returned should be ignored because there currently is
        not a valid value.
        """
        return bool()

class DocumentEvent(Event):
    """
    A DocumentEvent represents a document related event. For example, DocumentOpening or DocumentOpened.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DocumentEvent:
        return DocumentEvent()
    def add(self, handler: DocumentEventHandler) -> bool:
        """
        Add a handler to be notified when the file event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: DocumentEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class DocumentEventArgs(EventArgs):
    """
    The DocumentEventArgs provides information associated with a document event.
    Note that some properties are not available on every event
    - for example, the Document is not available on the DocumentOpening event because
    the Document is not yet available.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DocumentEventArgs:
        return DocumentEventArgs()
    @property
    def document(self) -> Document:
        """
        Provides access to the document that is open. Can be null in the case
        where the event is fired before the document has been opened or after it has been closed.
        """
        return Document()
    @property
    def fullPath(self) -> str:
        """
        The full path to the file.
        """
        return str()

class DropDownCommandInput(CommandInput):
    """
    Provides a command input to get the choice in a drop-down list from the user.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DropDownCommandInput:
        return DropDownCommandInput()
    @property
    def dropDownStyle(self) -> DropDownStyles:
        """
        Returns the style of drop down this was created as.
        """
        return DropDownStyles()
    @property
    def listItems(self) -> ListItems:
        """
        Returns the ListItems object associated with this drop-down. You use this
        object to populate and interact with the items in the drop-down.
        """
        return ListItems()
    @property
    def selectedItem(self) -> ListItem:
        """
        Gets the item in the list that is currently selected. This can return null in the
        case where no item in the list has been selected. This should be ignored
        for CheckBoxDropDownStyle style drop-downs because multiple items can be selected
        and each LiteItem should be checked individually.
        """
        return ListItem()
    @property
    def maxVisibleItems(self) -> int:
        """
        Gets or sets the maximum allowed size on screen of the drop down list, measured in items.
        """
        return int()
    @maxVisibleItems.setter
    def maxVisibleItems(self, value: int):
        """
        Gets or sets the maximum allowed size on screen of the drop down list, measured in items.
        """
        pass

class DropDownControl(ToolbarControl):
    """
    Represents a drop-down control.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DropDownControl:
        return DropDownControl()
    @property
    def controls(self) -> ToolbarControls:
        """
        Gets the associated ToolbarControls collection. Through this you can add additional controls to the drop-down.
        """
        return ToolbarControls()
    @property
    def resourceFolder(self) -> str:
        """
        Gets or sets the resource folder containing the image used for the icon when the drop-down is in a toolbar.
        """
        return str()
    @resourceFolder.setter
    def resourceFolder(self, value: str):
        """
        Gets or sets the resource folder containing the image used for the icon when the drop-down is in a toolbar.
        """
        pass
    @property
    def name(self) -> str:
        """
        Gets or sets the Name displayed for this drop down. This isn't used when the drop-down is in a toolbar because an icon is used in that case.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets or sets the Name displayed for this drop down. This isn't used when the drop-down is in a toolbar because an icon is used in that case.
        """
        pass

class DXF2DImportOptions(ImportOptions):
    """
    Defines that a 2D DXF Import to create sketches (based on layers in the DXF file) is to be performed and
    specifies the various options.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> DXF2DImportOptions:
        return DXF2DImportOptions()
    @property
    def planarEntity(self) -> Base:
        """
        Gets and sets the construction plane or planar face that defines the plane that the resulting sketches will
        be created on.
        """
        return Base()
    @planarEntity.setter
    def planarEntity(self, value: Base):
        """
        Gets and sets the construction plane or planar face that defines the plane that the resulting sketches will
        be created on.
        """
        pass
    @property
    def position(self) -> Point2D:
        """
        Gets and sets the X,Y offset position for the origin of the imported DXF data relative to the sketch origin.
        This defaults to (0,0) in a newly created DXF2DImportOptions object.
        """
        return Point2D()
    @position.setter
    def position(self, value: Point2D):
        """
        Gets and sets the X,Y offset position for the origin of the imported DXF data relative to the sketch origin.
        This defaults to (0,0) in a newly created DXF2DImportOptions object.
        """
        pass
    @property
    def results(self) -> ObjectCollection:
        """
        Returns a collection of Sketch objects. A sketch is created for each layer in the dxf file
        that contains 2D geometry. Any 3D geometry contained in the DXF file is ignored.
        The names of the resulting sketches correspond to the layer names in the DXF file.
        Currently, the only way to get a single sketch as a result is to supply a DXF file that only has 2D geometry
        on a single layer.
        """
        return ObjectCollection()
    @property
    def isSingleSketchResult(self) -> bool:
        """
        Gets and sets if importing the DXF file should create a new sketch for each layer or
        if the entire contents of the DXF file should be merged into a single layer. If true
        a single sketch will be created. If false a new sketch for each layer will be created
        where the sketch name will be the name of the layer. The default value for this
        property is false, resulting in a sketch for each layer.
        """
        return bool()
    @isSingleSketchResult.setter
    def isSingleSketchResult(self, value: bool):
        """
        Gets and sets if importing the DXF file should create a new sketch for each layer or
        if the entire contents of the DXF file should be merged into a single layer. If true
        a single sketch will be created. If false a new sketch for each layer will be created
        where the sketch name will be the name of the layer. The default value for this
        property is false, resulting in a sketch for each layer.
        """
        pass

class Ellipse2D(Curve2D):
    """
    Transient 2D ellipse. A transient ellipse is not displayed or saved in a document.
    Transient 2D ellipses are used as a wrapper to work with raw 2D ellipse information.
    They are created statically using the create method of the Ellipse2D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Ellipse2D:
        return Ellipse2D()
    @staticmethod
    def create(center: Point2D, majorAxis: Vector2D, majorRadius: float, minorRadius: float) -> Ellipse2D:
        """
        Creates a transient 2D ellipse by specifying a center position, major and minor axes,
        and major and minor radii.
        center : A Point2D object that defines the center of the ellipse.
        majorAxis : The major axis of the ellipse
        majorRadius : The major radius of the of the ellipse.
        minorRadius : The minor radius of the of the ellipse.
        Returns the new Ellipse 2D object or null if the creation failed.
        """
        return Ellipse2D()
    def copy(self) -> Ellipse2D:
        """
        Creates and returns a copy of this Ellipse2D object.
        Returns a new Ellipse2D object that is a copy of this Ellipse2D object.
        """
        return Ellipse2D()
    def getData(self) -> tuple[bool, Point2D, Vector2D, float, float]:
        """
        Gets all of the data defining the ellipse.
        center : The output center point of the ellipse.
        majorAxis : The output major axis of the ellipse.
        majorRadius : The output major radius of the of the ellipse.
        minorRadius : The output minor radius of the of the ellipse.
        Returns true if successful.
        """
        return (bool(), Point2D(), Vector2D(), float(), float())
    def set(self, center: Point2D, majorAxis: Vector2D, majorRadius: float, minorRadius: float) -> bool:
        """
        Sets all of the data defining the ellipse.
        center : A Point2D object that defines the center of the ellipse.
        majorAxis : The major axis of the ellipse.
        majorRadius : The major radius of the of the ellipse.
        minorRadius : The minor radius of the of the ellipse.
        Returns true if redefining the ellipse is successful.
        """
        return bool()
    @property
    def center(self) -> Point2D:
        """
        Gets and sets the center position of the ellipse.
        """
        return Point2D()
    @center.setter
    def center(self, value: Point2D):
        """
        Gets and sets the center position of the ellipse.
        """
        pass
    @property
    def majorAxis(self) -> Vector2D:
        """
        Gets and sets the major axis of the ellipse.
        """
        return Vector2D()
    @majorAxis.setter
    def majorAxis(self, value: Vector2D):
        """
        Gets and sets the major axis of the ellipse.
        """
        pass
    @property
    def majorRadius(self) -> float:
        """
        Gets and sets the major radius of the ellipse.
        """
        return float()
    @majorRadius.setter
    def majorRadius(self, value: float):
        """
        Gets and sets the major radius of the ellipse.
        """
        pass
    @property
    def minorRadius(self) -> float:
        """
        Gets and sets the minor radius of the ellipse.
        """
        return float()
    @minorRadius.setter
    def minorRadius(self, value: float):
        """
        Gets and sets the minor radius of the ellipse.
        """
        pass
    @property
    def asNurbsCurve(self) -> NurbsCurve2D:
        """
        Returns a NURBS curve that is geometrically identical to the ellipse.
        """
        return NurbsCurve2D()

class Ellipse3D(Curve3D):
    """
    Transient 3D ellipse. A transient ellipse is n0t displayed or saved in a document.
    Transient 3D ellipses are used as a wrapper to work with raw 3D ellipse information.
    They are created statically using the create method of the Ellipse3D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Ellipse3D:
        return Ellipse3D()
    @staticmethod
    def create(center: Point3D, normal: Vector3D, majorAxis: Vector3D, majorRadius: float, minorRadius: float) -> Ellipse3D:
        """
        Creates a transient 3D ellipse object.
        center : The center point of the ellipse.
        normal : The normal vector of the ellipse.
        The plane through the center point and perpendicular to the normal vector defines the plane of the ellipse.
        majorAxis : The major axis of the ellipse
        majorRadius : The major radius of the of the ellipse.
        minorRadius : The minor radius of the of the ellipse.
        Returns the new Ellipse 3D object or null if the creation failed.
        """
        return Ellipse3D()
    def copy(self) -> Ellipse3D:
        """
        Creates a copy of this Ellipse3D object.
        Returns the independent copy of the ellipse.
        """
        return Ellipse3D()
    def getData(self) -> tuple[bool, Point3D, Vector3D, Vector3D, float, float]:
        """
        Gets all of the data defining the ellipse.
        center : The output center point of the ellipse.
        normal : The output normal vector of the ellipse.
        majorAxis : The output major axis of the ellipse
        majorRadius : The output major radius of the of the ellipse.
        minorRadius : The output minor radius of the of the ellipse.
        Returns true if successful.
        """
        return (bool(), Point3D(), Vector3D(), Vector3D(), float(), float())
    def set(self, center: Point3D, normal: Vector3D, majorAxis: Vector3D, majorRadius: float, minorRadius: float) -> bool:
        """
        Sets all of the data defining the ellipse.
        center : The center point of the ellipse.
        normal : The normal vector of the ellipse.
        The plane through the center point and perpendicular to the normal vector defines the plane of the ellipse.
        majorAxis : The major axis of the ellipse.
        majorRadius : The major radius of the of the ellipse.
        minorRadius : The minor radius of the of the ellipse.
        Returns true if successful.
        """
        return bool()
    @property
    def center(self) -> Point3D:
        """
        Gets and sets the center position of the ellipse.
        """
        return Point3D()
    @center.setter
    def center(self, value: Point3D):
        """
        Gets and sets the center position of the ellipse.
        """
        pass
    @property
    def normal(self) -> Vector3D:
        """
        Gets and sets the normal of the ellipse.
        """
        return Vector3D()
    @property
    def majorAxis(self) -> Vector3D:
        """
        Gets and sets the major axis of the ellipse.
        """
        return Vector3D()
    @majorAxis.setter
    def majorAxis(self, value: Vector3D):
        """
        Gets and sets the major axis of the ellipse.
        """
        pass
    @property
    def majorRadius(self) -> float:
        """
        Gets and sets the major radius of the ellipse.
        """
        return float()
    @majorRadius.setter
    def majorRadius(self, value: float):
        """
        Gets and sets the major radius of the ellipse.
        """
        pass
    @property
    def minorRadius(self) -> float:
        """
        Gets and sets the minor radius of the ellipse.
        """
        return float()
    @minorRadius.setter
    def minorRadius(self, value: float):
        """
        Gets and sets the minor radius of the ellipse.
        """
        pass
    @property
    def asNurbsCurve(self) -> NurbsCurve3D:
        """
        Returns a NURBS curve that is geometrically identical to the ellipse.
        """
        return NurbsCurve3D()

class EllipticalArc2D(Curve2D):
    """
    Transient 2D elliptical arc. A transient elliptical arc is not displayed or saved in a document.
    Transient 2D elliptical arcs are used as a wrapper to work with raw 2D elliptical arc information.
    They are created statically using the create method of the EllipticalArc2D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> EllipticalArc2D:
        return EllipticalArc2D()
    @staticmethod
    def create(center: Point2D, majorAxis: Vector2D, majorRadius: float, minorRadius: float, startAngle: float, endAngle: float) -> EllipticalArc2D:
        """
        Creates a transient 2D elliptical arc
        center : A Point2D object that defines the center of the elliptical arc.
        majorAxis : The major axis of the elliptical arc
        majorRadius : The major radius of the of the elliptical arc.
        minorRadius : The minor radius of the of the elliptical arc.
        startAngle : The start angle of the elliptical arc in radians, where 0 is along the major axis.
        endAngle : The end angle of the elliptical arc in radians, where 0 is along the major axis.
        Returns the newly created elliptical arc or null if the creation failed.
        """
        return EllipticalArc2D()
    def copy(self) -> EllipticalArc2D:
        """
        Creates and returns a copy of this EllipticalArc2D object.
        Returns a new EllipticalArc2D object that is a copy of this Arc2D object.
        """
        return EllipticalArc2D()
    def getData(self) -> tuple[bool, Point2D, Vector2D, float, float, float, float]:
        """
        Gets all of the data defining the elliptical arc.
        center : The output center point of the elliptical arc.
        majorAxis : The output major axis of the elliptical arc.
        majorRadius : The output major radius of the of the elliptical arc.
        minorRadius : The output minor radius of the of the elliptical arc.
        startAngle : The output start angle of the elliptical arc in radians, where 0 is along the major axis.
        endAngle : The output end angle of the elliptical arc in radians, where 0 is along the major axis.
        Returns true if successful
        """
        return (bool(), Point2D(), Vector2D(), float(), float(), float(), float())
    def set(self, center: Point2D, majorAxis: Vector2D, majorRadius: float, minorRadius: float, startAngle: float, endAngle: float) -> bool:
        """
        center : A Point2D object that defines the center of the elliptical arc.
        majorAxis : The major axis of the elliptical arc.
        majorRadius : The major radius of the of the elliptical arc.
        minorRadius : The minor radius of the of the elliptical arc.
        startAngle : The start angle of the elliptical arc in radians, where 0 is along the major axis.
        endAngle : The end angle of the elliptical arc in radians, where 0 is along the major axis.
        Returns true if redefining the elliptical arc is successful
        """
        return bool()
    @property
    def center(self) -> Point2D:
        """
        Gets and sets the center position of the elliptical arc.
        """
        return Point2D()
    @center.setter
    def center(self, value: Point2D):
        """
        Gets and sets the center position of the elliptical arc.
        """
        pass
    @property
    def majorAxis(self) -> Vector2D:
        """
        Gets and sets the major axis of the elliptical arc.
        """
        return Vector2D()
    @majorAxis.setter
    def majorAxis(self, value: Vector2D):
        """
        Gets and sets the major axis of the elliptical arc.
        """
        pass
    @property
    def majorRadius(self) -> float:
        """
        Gets and sets the major radius of the elliptical arc.
        """
        return float()
    @majorRadius.setter
    def majorRadius(self, value: float):
        """
        Gets and sets the major radius of the elliptical arc.
        """
        pass
    @property
    def minorRadius(self) -> float:
        """
        Gets and sets the minor radius of the elliptical arc.
        """
        return float()
    @minorRadius.setter
    def minorRadius(self, value: float):
        """
        Gets and sets the minor radius of the elliptical arc.
        """
        pass
    @property
    def startAngle(self) -> float:
        """
        Gets and sets the start angle of the elliptical arc in radians, where 0 is along the major axis.
        """
        return float()
    @startAngle.setter
    def startAngle(self, value: float):
        """
        Gets and sets the start angle of the elliptical arc in radians, where 0 is along the major axis.
        """
        pass
    @property
    def endAngle(self) -> float:
        """
        Gets and sets the end angle of the elliptical arc in radians, where 0 is along the major axis.
        """
        return float()
    @endAngle.setter
    def endAngle(self, value: float):
        """
        Gets and sets the end angle of the elliptical arc in radians, where 0 is along the major axis.
        """
        pass
    @property
    def isClockwise(self) -> bool:
        """
        Indicates if the sweep direction of the elliptical arc is clockwise or counterclockwise.
        """
        return bool()
    @property
    def isCircular(self) -> bool:
        """
        Indicates if the elliptical arc is the geometric equivalent of a circular arc
        """
        return bool()
    @property
    def startPoint(self) -> Point2D:
        """
        Gets the position of the start point of the elliptical arc.
        """
        return Point2D()
    @property
    def endPoint(self) -> Point2D:
        """
        Gets the position of the end point of the elliptical arc.
        """
        return Point2D()
    @property
    def asNurbsCurve(self) -> NurbsCurve2D:
        """
        Returns a NURBS curve that is geometrically identical to the elliptical arc.
        """
        return NurbsCurve2D()

class EllipticalArc3D(Curve3D):
    """
    Transient 3D elliptical arc. A transient elliptical arc is not displayed or saved in a document.
    Transient 3D elliptical arcs are used as a wrapper to work with raw 3D elliptical arc information.
    They are created statically using the create method of the EllipticalArc3D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> EllipticalArc3D:
        return EllipticalArc3D()
    @staticmethod
    def create(center: Point3D, normal: Vector3D, majorAxis: Vector3D, majorRadius: float, minorRadius: float, startAngle: float, endAngle: float) -> EllipticalArc3D:
        """
        Creates a transient 3D elliptical arc.
        center : The center point of the elliptical arc.
        normal : The normal vector of the elliptical arc.
        majorAxis : The major axis of the elliptical arc.
        majorRadius : The major radius of the of the elliptical arc.
        minorRadius : The minor radius of the of the elliptical arc.
        startAngle : The start angle of the elliptical arc in radians, where 0 is along the major axis.
        endAngle : The end angle of the elliptical arc in radians, where 0 is along the major axis.
        Returns the newly created elliptical arc or null if the creation failed.
        """
        return EllipticalArc3D()
    def copy(self) -> EllipticalArc3D:
        """
        Creates and returns a copy of this EllipticalArc3D object.
        Returns a new EllipticalArc3D object that is a copy of this Arc3D object.
        """
        return EllipticalArc3D()
    def getData(self) -> tuple[bool, Point3D, Vector3D, Vector3D, float, float, float, float]:
        """
        Gets all of the data defining the elliptical arc.
        center : The output center point of the elliptical arc.
        normal : The output normal vector of the elliptical arc.
        majorAxis : The output major axis of the elliptical arc.
        majorRadius : The output major radius of the of the elliptical arc.
        minorRadius : The output minor radius of the of the elliptical arc.
        startAngle : The output start angle of the elliptical arc in radians, where 0 is along the major axis.
        endAngle : The output end angle of the elliptical arc in radians, where 0 is along the major axis.
        Returns true if successful.
        """
        return (bool(), Point3D(), Vector3D(), Vector3D(), float(), float(), float(), float())
    def set(self, center: Point3D, normal: Vector3D, majorAxis: Vector3D, majorRadius: float, minorRadius: float, startAngle: float, endAngle: float) -> bool:
        """
        Sets all of the data defining the elliptical arc.
        center : The center point of the elliptical arc.
        normal : The normal vector of the elliptical arc.
        majorAxis : The major axis of the elliptical arc.
        majorRadius : The major radius of the of the elliptical arc.
        minorRadius : The minor radius of the of the elliptical arc.
        startAngle : The start angle of the elliptical arc in radians, where 0 is along the major axis.
        endAngle : The end angle of the elliptical arc in radians, where 0 is along the major axis.
        Returns true if successful.
        """
        return bool()
    @property
    def center(self) -> Point3D:
        """
        Gets and sets the center point of the elliptical arc.
        """
        return Point3D()
    @center.setter
    def center(self, value: Point3D):
        """
        Gets and sets the center point of the elliptical arc.
        """
        pass
    @property
    def normal(self) -> Vector3D:
        """
        Gets and sets the normal of the elliptical arc.
        """
        return Vector3D()
    @property
    def majorAxis(self) -> Vector3D:
        """
        Gets and sets the major axis of the elliptical arc.
        """
        return Vector3D()
    @majorAxis.setter
    def majorAxis(self, value: Vector3D):
        """
        Gets and sets the major axis of the elliptical arc.
        """
        pass
    @property
    def majorRadius(self) -> float:
        """
        Gets and sets the major radius of the elliptical arc.
        """
        return float()
    @majorRadius.setter
    def majorRadius(self, value: float):
        """
        Gets and sets the major radius of the elliptical arc.
        """
        pass
    @property
    def minorRadius(self) -> float:
        """
        Gets and sets the minor radius of the elliptical arc.
        """
        return float()
    @minorRadius.setter
    def minorRadius(self, value: float):
        """
        Gets and sets the minor radius of the elliptical arc.
        """
        pass
    @property
    def startAngle(self) -> float:
        """
        Gets and sets the start angle of the elliptical arc.
        """
        return float()
    @startAngle.setter
    def startAngle(self, value: float):
        """
        Gets and sets the start angle of the elliptical arc.
        """
        pass
    @property
    def endAngle(self) -> float:
        """
        Gets and sets the end angle of the elliptical arc.
        """
        return float()
    @endAngle.setter
    def endAngle(self, value: float):
        """
        Gets and sets the end angle of the elliptical arc.
        """
        pass
    @property
    def asNurbsCurve(self) -> NurbsCurve3D:
        """
        Returns a NURBS curve that is geometrically identical to the elliptical arc.
        """
        return NurbsCurve3D()

class EllipticalCone(Surface):
    """
    Transient elliptical cone. A transient elliptical cone is not displayed or saved in a document.
    A transient elliptical cone is used as a wrapper to work with raw elliptical cone information.
    A transient elliptical cone has no boundaries.
    The cone always goes to a point in its narrowing direction, and is infinite in its
    widening direction.
    They are created statically using the create method of the EllipticalCone class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> EllipticalCone:
        return EllipticalCone()
    @staticmethod
    def create(origin: Point3D, axis: Vector3D, majorAxisDirection: Vector3D, majorRadius: float, minorRadius: float, halfAngle: float) -> EllipticalCone:
        """
        Creates a transient elliptical cone object.
        origin : The origin point (center) of the base of the cone.
        axis : The center axis (along the length) of the cone that defines its normal direction.
        majorAxisDirection : The direction of the major axis of the ellipse that defines the cone.
        majorRadius : The major radius of the ellipse that defines the cone.
        minorRadius : The minor radius of the ellipse that defines the cone.
        halfAngle : The taper half-angle of the cone.
        Returns the new EllipticalCone object or null if the creation failed.
        """
        return EllipticalCone()
    def getAxes(self) -> tuple[Vector3D, Vector3D]:
        """
        Gets the center axis of the cone that defines its normal direction and the major axis
        direction of the ellipse that defines it.
        axis : The output center axis (along the length) of the cone that defines its normal direction.
        majorAxisDirection : The output direction of the major axis of the ellipse that defines the cone.
        """
        return (Vector3D(), Vector3D())
    def setAxes(self, axis: Vector3D, majorAxisDirection: Vector3D) -> bool:
        """
        Sets the center axis of the cone and the major axis direction of the ellipse that defines it.
        axis : The center axis (along the length) of the cone that defines its normal direction.
        majorAxisDirection : The direction of the major axis of the ellipse that defines the cone.
        Returns true if successful.
        """
        return bool()
    def getData(self) -> tuple[bool, Point3D, Vector3D, Vector3D, float, float, float]:
        """
        Gets the data that defines the Elliptical Cone.
        origin : The output origin point (center) of the base of the cone.
        axis : The output center axis (along the length) of the cone that defines its normal direction.
        majorAxisDirection : The output direction of the major axis of the ellipse that defines the cone.
        majorRadius : The output major radius of the ellipse that defines the cone.
        minorRadius : The output minor radius of the ellipse that defines the cone.
        halfAngle : The output taper half-angle of the cone.
        Returns true if successful.
        """
        return (bool(), Point3D(), Vector3D(), Vector3D(), float(), float(), float())
    def set(self, origin: Point3D, axis: Vector3D, majorAxisDirection: Vector3D, majorRadius: float, minorRadius: float, halfAngle: float) -> bool:
        """
        Sets the data that defines the Elliptical Cone.
        origin : The origin point (center) of the base of the cone.
        axis : The center axis (along the length) of the cone that defines its normal direction.
        majorAxisDirection : The direction of the major axis of the ellipse that defines the cone.
        majorRadius : The major radius of the ellipse that defines the cone.
        minorRadius : The minor radius of the ellipse that defines the cone.
        halfAngle : The taper half-angle of the cone.
        Returns true if successful.
        """
        return bool()
    def copy(self) -> EllipticalCone:
        """
        Creates and returns an independent copy of this EllipticalCone object.
        Returns a new EllipticalCone object that is a copy of this EllipticalCone object.
        """
        return EllipticalCone()
    @property
    def origin(self) -> Point3D:
        """
        Gets and sets the origin point (center) of the base of the cone.
        """
        return Point3D()
    @origin.setter
    def origin(self, value: Point3D):
        """
        Gets and sets the origin point (center) of the base of the cone.
        """
        pass
    @property
    def majorRadius(self) -> float:
        """
        Gets and sets the major radius of the ellipse that defines the cone.
        """
        return float()
    @majorRadius.setter
    def majorRadius(self, value: float):
        """
        Gets and sets the major radius of the ellipse that defines the cone.
        """
        pass
    @property
    def minorRadius(self) -> float:
        """
        Gets and sets the minor radius of the ellipse that defines the cone.
        """
        return float()
    @minorRadius.setter
    def minorRadius(self, value: float):
        """
        Gets and sets the minor radius of the ellipse that defines the cone.
        """
        pass
    @property
    def halfAngle(self) -> float:
        """
        Gets and sets the taper half-angle of the elliptical cone.
        A negative value indicates that the cone is narrowing in the direction of the axis vector,
        whereas a positive values indicates that it is expanding in the direction of the axis vector.
        """
        return float()
    @halfAngle.setter
    def halfAngle(self, value: float):
        """
        Gets and sets the taper half-angle of the elliptical cone.
        A negative value indicates that the cone is narrowing in the direction of the axis vector,
        whereas a positive values indicates that it is expanding in the direction of the axis vector.
        """
        pass

class EllipticalCylinder(Surface):
    """
    Transient elliptical cylinder. A transient elliptical cylinder is not displayed or saved
    in a document.
    A transient elliptical cylinder is used as a wrapper to work with raw elliptical cylinder
    information.
    A transient elliptical cylinder has no boundaries and is infinite in length.
    They are created statically using the create method of the EllipticalCylinder class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> EllipticalCylinder:
        return EllipticalCylinder()
    @staticmethod
    def create(origin: Point3D, axis: Vector3D, majorAxis: Vector3D, majorRadius: float, minorRadius: float) -> EllipticalCylinder:
        """
        Creates a transient 3D elliptical cylinder object.
        origin : The origin point (center) of the base of the cylinder.
        axis : The center axis (along the length) of the cylinder that defines its normal direction.
        majorAxis : The direction of the major axis of the ellipse that defines the cylinder.
        majorRadius : The major radius of the ellipse that defines the cylinder.
        minorRadius : The minor radius of the ellipse that defines the cylinder.
        Returns the new EllipticalCylinder object or null if the creation failed.
        """
        return EllipticalCylinder()
    def getData(self) -> tuple[bool, Point3D, Vector3D, Vector3D, float, float]:
        """
        Gets the data defining the elliptical cylinder.
        origin : The output origin point (center) of the base of the cylinder.
        axis : The output center axis (along the length) of the cylinder that defines its normal direction.
        majorAxis : The output direction of the major axis of the ellipse that defines the cylinder.
        majorRadius : The output major radius of the ellipse that defines the cylinder.
        minorRadius : The output minor radius of the ellipse that defines the cylinder.
        Returns true if successful.
        """
        return (bool(), Point3D(), Vector3D(), Vector3D(), float(), float())
    def set(self, origin: Point3D, axis: Vector3D, majorAxis: Vector3D, majorRadius: float, minorRadius: float) -> bool:
        """
        Sets the data defining the elliptical cylinder.
        origin : The origin point (center) of the base of the cylinder.
        axis : The center axis (along the length) of the cylinder that defines its normal direction.
        majorAxis : The direction of the major axis of the ellipse that defines the cylinder.
        majorRadius : The major radius of the ellipse that defines the cylinder.
        minorRadius : The minor radius of the ellipse that defines the cylinder.
        Returns true if successful.
        """
        return bool()
    def copy(self) -> EllipticalCylinder:
        """
        Creates and returns an independent copy of this EllipticalCylinder object.
        Returns a new EllipticalCylinder object that is a copy of this EllipticalCylinder object.
        """
        return EllipticalCylinder()
    @property
    def origin(self) -> Point3D:
        """
        Gets and sets the origin point (center) of the base of the cylinder.
        """
        return Point3D()
    @origin.setter
    def origin(self, value: Point3D):
        """
        Gets and sets the origin point (center) of the base of the cylinder.
        """
        pass
    @property
    def axis(self) -> Vector3D:
        """
        Gets and set the center axis (along the length) of the cylinder that defines
        its normal direction.
        """
        return Vector3D()
    @axis.setter
    def axis(self, value: Vector3D):
        """
        Gets and set the center axis (along the length) of the cylinder that defines
        its normal direction.
        """
        pass
    @property
    def majorAxis(self) -> Vector3D:
        """
        Gets and sets the direction of the major axis of the ellipse that defines the cylinder.
        """
        return Vector3D()
    @majorAxis.setter
    def majorAxis(self, value: Vector3D):
        """
        Gets and sets the direction of the major axis of the ellipse that defines the cylinder.
        """
        pass
    @property
    def majorRadius(self) -> float:
        """
        Gets and sets the major radius of the ellipse that defines the cylinder.
        """
        return float()
    @majorRadius.setter
    def majorRadius(self, value: float):
        """
        Gets and sets the major radius of the ellipse that defines the cylinder.
        """
        pass
    @property
    def minorRadius(self) -> float:
        """
        Gets and sets the minor radius of the ellipse that defines the cylinder.
        """
        return float()
    @minorRadius.setter
    def minorRadius(self, value: float):
        """
        Gets and sets the minor radius of the ellipse that defines the cylinder.
        """
        pass

class FilenameProperty(Property):
    """
    A file name property associated with an appearance.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FilenameProperty:
        return FilenameProperty()
    @property
    def hasMultipleValues(self) -> bool:
        """
        Gets the boolean flag that indicates if this property has multiple values or not.
        """
        return bool()
    @property
    def value(self) -> str:
        """
        Gets and sets the value of this property.
        """
        return str()
    @value.setter
    def value(self, value: str):
        """
        Gets and sets the value of this property.
        """
        pass
    @property
    def values(self) -> list[str]:
        """
        Gets and sets the values associated with this property. HasMultipleValues
        property indicates if this property will be returning more than one value.
        """
        return [str()]
    @values.setter
    def values(self, value: list[str]):
        """
        Gets and sets the values associated with this property. HasMultipleValues
        property indicates if this property will be returning more than one value.
        """
        pass

class FloatProperty(Property):
    """
    A float or real value property associated with a material or appearance.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FloatProperty:
        return FloatProperty()
    def getLimits(self) -> tuple[bool, bool, float, bool, float]:
        """
        Method that returns any limits for the value of this property. The HasLimits property can
        be used to see if there are any limits or not.
        hasLowLimit : Output Boolean that indicates if there is a low limit or not.
        lowLimit : If the hasLowLimit argument is true, this argument returns the low limit.
        hasHighLimit : Output Boolean that indicates if there is a high limit or not.
        highLimit : If the hasHighLimit argument is true, this argument returns the high limit.
        Returns true if the method call was successful.
        """
        return (bool(), bool(), float(), bool(), float())
    @property
    def hasConnectedTexture(self) -> bool:
        """
        Gets and sets the boolean flag that indicates if the float value has been overridden
        using a texture. Setting this property to False will remove the texture so that a float
        value is used. Setting this property to True will connect a texture to this float value.
        """
        return bool()
    @hasConnectedTexture.setter
    def hasConnectedTexture(self, value: bool):
        """
        Gets and sets the boolean flag that indicates if the float value has been overridden
        using a texture. Setting this property to False will remove the texture so that a float
        value is used. Setting this property to True will connect a texture to this float value.
        """
        pass
    @property
    def connectedTexture(self) -> AppearanceTexture:
        """
        Gets the associated texture, if one exists. The HasConnectedTexture property controls
        if there is an associated texture or not. If it's parent writable you can edit the
        texture. If no texture exists, this property will return Nothing.
        """
        return AppearanceTexture()
    @property
    def hasLimits(self) -> bool:
        """
        Gets the boolean flag that indicates if the value of this property has any limits it must be within to
        be valid. If True, use the GetLimits method to get the limit values.
        """
        return bool()
    @property
    def hasMultipleValues(self) -> bool:
        """
        Gets the boolean flag that indicates if this property has multiple values or not.
        """
        return bool()
    @property
    def isPercentage(self) -> bool:
        """
        Gets the boolean flag that indicates that this property represents a percentage value so
        the valid values must be in the range of 0.0 to 1.0 unless they’re further limited by
        additional limits which can be determined with the HasLimits property.
        """
        return bool()
    @property
    def units(self) -> str:
        """
        Gets the units that the value of this property is returned in. The String returned is a
        valid Fusion 360 unit string.
        """
        return str()
    @property
    def value(self) -> float:
        """
        Gets and sets this property value. The value of this property should be ignored
        if the HasConnectedTexture property is true. Setting this will remove any
        associated texture, if there is one.
        """
        return float()
    @value.setter
    def value(self, value: float):
        """
        Gets and sets this property value. The value of this property should be ignored
        if the HasConnectedTexture property is true. Setting this will remove any
        associated texture, if there is one.
        """
        pass
    @property
    def values(self) -> list[float]:
        """
        Gets and sets the values associated with this property. HasMultipleValues property
        indicates if this property will be returning more than one value.
        """
        return [float()]
    @values.setter
    def values(self, value: list[float]):
        """
        Gets and sets the values associated with this property. HasMultipleValues property
        indicates if this property will be returning more than one value.
        """
        pass

class FloatSpinnerCommandInput(CommandInput):
    """
    Provides a command input to get the value of a spinner from the user, the value type is float.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FloatSpinnerCommandInput:
        return FloatSpinnerCommandInput()
    @property
    def value(self) -> float:
        """
        Gets and sets the value associated with this input. The value is always in
        the database units of the unit type specified. For example, if the unit type is "inch"
        this value is in centimeters since centimeters are the database length unit. When setting the
        value it is converted into a string using the unit type and displayed in the input box.
        
        The isValidExpression property should be checked before using this
        value within the command because if the expression can't be evaluated
        there isn't a valid value. Fusion 360 won't allow the execution of a command
        that contains ValueCommandInput object with invalid expressions so you can
        dependably use the value in the execute event of the command.
        """
        return float()
    @value.setter
    def value(self, value: float):
        """
        Gets and sets the value associated with this input. The value is always in
        the database units of the unit type specified. For example, if the unit type is "inch"
        this value is in centimeters since centimeters are the database length unit. When setting the
        value it is converted into a string using the unit type and displayed in the input box.
        
        The isValidExpression property should be checked before using this
        value within the command because if the expression can't be evaluated
        there isn't a valid value. Fusion 360 won't allow the execution of a command
        that contains ValueCommandInput object with invalid expressions so you can
        dependably use the value in the execute event of the command.
        """
        pass
    @property
    def unitType(self) -> str:
        """
        Gets the unit type that is used when evaluating the user's input.
        """
        return str()
    @property
    def minimumValue(self) -> float:
        """
        Gets the minimum allowed value of the spinner in database units.
        """
        return float()
    @property
    def maximumValue(self) -> float:
        """
        Gets the maximum allowed value of the spinner in database units.
        """
        return float()
    @property
    def spinStep(self) -> float:
        """
        Gets the spin step value in the unit type set by the unitType argument.
        The value should be more than zero. This is the amount the spinner will advance
        when the user clicks the spin button beside the value.
        """
        return float()
    @property
    def expression(self) -> str:
        """
        Gets or sets the expression displayed in the input field. This can contain equations and
        references to parameters. It is evaluated using the specified unit type.
        """
        return str()
    @expression.setter
    def expression(self, value: str):
        """
        Gets or sets the expression displayed in the input field. This can contain equations and
        references to parameters. It is evaluated using the specified unit type.
        """
        pass
    @property
    def isValidExpression(self) -> bool:
        """
        Returns true if the current expression is valid and can be evaluated. If this
        is false, the value returned should be ignored because there currently is
        not a valid value.
        """
        return bool()

class FusionArchiveImportOptions(ImportOptions):
    """
    Defines that a Fusion 360 Archive import is to be done and specifies the various options.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FusionArchiveImportOptions:
        return FusionArchiveImportOptions()

class GroupCommandInput(CommandInput):
    """
    Group Command inputs organize a set of command inputs into a collapsible
    list within a command dialog
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> GroupCommandInput:
        return GroupCommandInput()
    @property
    def children(self) -> CommandInputs:
        """
        Gets the CommandInputs collection for this GroupCommandInput.
        Use the add methods on this collection to add child CommandInputs to this Group in the desired order.
        """
        return CommandInputs()
    @property
    def isExpanded(self) -> bool:
        """
        Gets or sets if this group is expanded.
        If this is a sub-group of another group and the isEnabledCheckBoxDisplayed property is set to false
        then the isExpanded property must be set to true.
        """
        return bool()
    @isExpanded.setter
    def isExpanded(self, value: bool):
        """
        Gets or sets if this group is expanded.
        If this is a sub-group of another group and the isEnabledCheckBoxDisplayed property is set to false
        then the isExpanded property must be set to true.
        """
        pass
    @property
    def isEnabledCheckBoxDisplayed(self) -> bool:
        """
        Gets or sets if this group has a check-box for enabling/disabling the group.
        If this is a sub-group of another group and the isEnabledCheckBoxDisplayed property is set to false
        then the isExpanded property must be set to true.
        """
        return bool()
    @isEnabledCheckBoxDisplayed.setter
    def isEnabledCheckBoxDisplayed(self, value: bool):
        """
        Gets or sets if this group has a check-box for enabling/disabling the group.
        If this is a sub-group of another group and the isEnabledCheckBoxDisplayed property is set to false
        then the isExpanded property must be set to true.
        """
        pass
    @property
    def isEnabledCheckBoxChecked(self) -> bool:
        """
        Gets or sets if the enabled check-box is checked or not. This is only
        valid when the isEnabledCheckBoxDisplayed property is true.
        """
        return bool()
    @isEnabledCheckBoxChecked.setter
    def isEnabledCheckBoxChecked(self, value: bool):
        """
        Gets or sets if the enabled check-box is checked or not. This is only
        valid when the isEnabledCheckBoxDisplayed property is true.
        """
        pass

class HTMLEvent(Event):
    """
    A HTMLEvent is fired when triggered from JavaScript code associated with HTML used
    in a palette.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> HTMLEvent:
        return HTMLEvent()
    def add(self, handler: HTMLEventHandler) -> bool:
        """
        Add a handler to be notified when the event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: HTMLEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class HTMLEventArgs(EventArgs):
    """
    The HTMLEventArgs provides access to the information sent from the JavaScript
    that's associated with HTML being displayed within a palette.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> HTMLEventArgs:
        return HTMLEventArgs()
    @property
    def action(self) -> str:
        """
        The action string sent from the JavaScript associated with HTML displayed
        in the palette. The string can represent any type of data in any format but
        JSON is commonly used to pass more complex data.
        """
        return str()
    @property
    def data(self) -> str:
        """
        The data string sent from the JavaScript associated with HTML displayed
        in the palette. The string can represent any type of data in any format but
        JSON is commonly used to pass more complex data.
        """
        return str()
    @property
    def returnData(self) -> str:
        """
        Set this property to return data back to the JavaScript that's associated with the HTML.
        """
        return str()
    @returnData.setter
    def returnData(self, value: str):
        """
        Set this property to return data back to the JavaScript that's associated with the HTML.
        """
        pass
    @property
    def browserCommandInput(self) -> BrowserCommandInput:
        """
        When the event is fired from a BrowserCommandInput object, this property returns
        the specific BrowserCommandInput that caused the event to fire. In all other cases
        this property returns null.
        """
        return BrowserCommandInput()

class IGESImportOptions(ImportOptions):
    """
    Defines that an IGES import is to be done and specifies the various options.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> IGESImportOptions:
        return IGESImportOptions()

class ImageCommandInput(CommandInput):
    """
    Provides an image command input for including an image in a command dialog.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ImageCommandInput:
        return ImageCommandInput()
    @property
    def imageFile(self) -> str:
        """
        Gets and sets the full path and file name of the image file.
        Supported image format is .png
        Images are displayed in the command dialog using their actual size.
        """
        return str()
    @imageFile.setter
    def imageFile(self, value: str):
        """
        Gets and sets the full path and file name of the image file.
        Supported image format is .png
        Images are displayed in the command dialog using their actual size.
        """
        pass

class InfiniteLine3D(Curve3D):
    """
    Transient 3D infinite line. An infinite line is defined by a position and direction in space
    and has no start or end points.
    They are created statically using the create method of the InfiniteLine3D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> InfiniteLine3D:
        return InfiniteLine3D()
    @staticmethod
    def create(origin: Point3D, direction: Vector3D) -> InfiniteLine3D:
        """
        Creates a transient 3D infinite line.
        origin : The origin point of the line.
        direction : The direction of the line.
        Returns the new InfiniteLine3D object or null if the creation failed.
        """
        return InfiniteLine3D()
    def isColinearTo(self, line: InfiniteLine3D) -> bool:
        """
        Compare this line with another to check for collinearity.
        line : The line to compare with for collinearity.
        Returns true if the two lines are collinear.
        """
        return bool()
    def copy(self) -> InfiniteLine3D:
        """
        Creates and returns a copy of this line object.
        Returns an independent copy of this line object.
        """
        return InfiniteLine3D()
    def intersectWithCurve(self, curve: Curve3D) -> ObjectCollection:
        """
        Intersect this line with a curve to get the intersection point(s).
        curve : The intersecting curve.
        The curve can be a Line3D, InfininteLine3D, Circle3D, Arc3D, EllipticalArc3D, Ellipse3D,
        or NurbsCurve3D.
        Returns a collection of the intersection points.
        """
        return ObjectCollection()
    def intersectWithSurface(self, surface: Surface) -> ObjectCollection:
        """
        Intersect this line with a surface to get the intersection point(s).
        surface : The intersecting surface.
        The surface can be a Plane, Cone, Cylinder, EllipticalCone, EllipticalCylinder, Sphere,
        Torus, or a NurbsSurface.
        Returns a collection of the intersection points.
        """
        return ObjectCollection()
    def getData(self) -> tuple[bool, Point3D, Vector3D]:
        """
        Gets all of the data defining the infinite line.
        origin : The output origin point of the line.
        direction : The output direction of the line.
        Returns true if successful.
        """
        return (bool(), Point3D(), Vector3D())
    def set(self, origin: Point3D, direction: Vector3D) -> bool:
        """
        Sets all of the data defining the infinite line.
        origin : The origin point of the line.
        direction : The direction of the line.
        Returns true if successful.
        """
        return bool()
    @property
    def origin(self) -> Point3D:
        """
        Gets and sets the origin point of the line.
        """
        return Point3D()
    @origin.setter
    def origin(self, value: Point3D):
        """
        Gets and sets the origin point of the line.
        """
        pass
    @property
    def direction(self) -> Vector3D:
        """
        Gets and sets the direction of the line.
        """
        return Vector3D()
    @direction.setter
    def direction(self, value: Vector3D):
        """
        Gets and sets the direction of the line.
        """
        pass

class InputChangedEvent(Event):
    """
    An event endpoint that supports the connection to client implemented InputChangedEventHandlers.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> InputChangedEvent:
        return InputChangedEvent()
    def add(self, handler: InputChangedEventHandler) -> bool:
        """
        Adds an event handler to this event endpoint.
        handler : The client implemented InputChangedEventHandler to be called when this event is triggered.
        Returns true if the handler was successfully added to the set of event handlers.
        """
        return bool()
    def remove(self, handler: InputChangedEventHandler) -> bool:
        """
        Removes a handler from this event endpoint.
        handler : A InputChangedEventHandler that was previously added to this event with the add method.
        Returns true if the handler was found and removed from the set of event handlers.
        """
        return bool()

class InputChangedEventArgs(EventArgs):
    """
    Provides a set of arguments from a firing InputChangedEvent to a InputEventChangedEventHandler's notify callback method.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> InputChangedEventArgs:
        return InputChangedEventArgs()
    @property
    def input(self) -> CommandInput:
        """
        Returns the command input that has just changed.
        """
        return CommandInput()
    @property
    def inputs(self) -> CommandInputs:
        """
        Returns the collection of command inputs that are associated with the command this event is being fired for.
        """
        return CommandInputs()

class IntegerProperty(Property):
    """
    An integer value property associated with a material or appearance.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> IntegerProperty:
        return IntegerProperty()
    def getLimits(self) -> tuple[bool, bool, int, bool, int]:
        """
        Method that returns any limits for the value of this property. The HasLimits property can
        be used to see if there are any limits or not.
        hasLowLimit : Output Boolean that indicates if there is a low limit or not.
        lowLimit : If the hasLowLimit argument is true, this argument returns the low limit.
        hasHighLimit : Output Boolean that indicates if there is a high limit or not.
        highLimit : If the hasHighLimit argument is true, this argument returns the high limit.
        Returns true if the method call was successful.
        """
        return (bool(), bool(), int(), bool(), int())
    @property
    def hasLimits(self) -> bool:
        """
        Gets the boolean flag that indicates if the value of this property has any limits it must
        be within to be valid. If True, use the GetLimits method to get the limit values.
        """
        return bool()
    @property
    def hasMultipleValues(self) -> bool:
        """
        Gets the boolean flag that indicates if this property has multiple values or not.
        """
        return bool()
    @property
    def value(self) -> int:
        """
        Gets and sets this property value. The value of this property should be ignored
        if the HasConnectedTexture property is true. Setting this will remove any
        associated texture, if there is one.
        """
        return int()
    @value.setter
    def value(self, value: int):
        """
        Gets and sets this property value. The value of this property should be ignored
        if the HasConnectedTexture property is true. Setting this will remove any
        associated texture, if there is one.
        """
        pass
    @property
    def values(self) -> list[int]:
        """
        Gets and sets the values associated with this property. HasMultipleValues property
        indicates if this property will be returning more than one value.
        """
        return [int()]
    @values.setter
    def values(self, value: list[int]):
        """
        Gets and sets the values associated with this property. HasMultipleValues property
        indicates if this property will be returning more than one value.
        """
        pass

class IntegerSpinnerCommandInput(CommandInput):
    """
    Provides a command input to get the value of a spinner from the user, the value type is integer.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> IntegerSpinnerCommandInput:
        return IntegerSpinnerCommandInput()
    @property
    def value(self) -> int:
        """
        Gets and sets the value associated with this input.
        """
        return int()
    @value.setter
    def value(self, value: int):
        """
        Gets and sets the value associated with this input.
        """
        pass
    @property
    def minimumValue(self) -> int:
        """
        Gets the minimum allowed value of the spinner.
        """
        return int()
    @property
    def maximumValue(self) -> int:
        """
        Gets the maximum allowed value of the spinner.
        """
        return int()
    @property
    def spinStep(self) -> int:
        """
        Gets the spin step. The value should be more than zero. This is the amount the spinner will advance
        when the user clicks the spin button beside the value.
        """
        return int()

class KeyboardEvent(Event):
    """
    An event endpoint that supports the connection to client implemented KeyboardEventHandlers.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> KeyboardEvent:
        return KeyboardEvent()
    def add(self, handler: KeyboardEventHandler) -> bool:
        """
        Adds an event handler to this event endpoint.
        handler : The client implemented KeyboardEventHandler to be called when this event is triggered.
        Returns true if the handler was successfully added to the set of event handlers.
        """
        return bool()
    def remove(self, handler: KeyboardEventHandler) -> bool:
        """
        Removes a handler from this event endpoint.
        handler : A KeyboardEventHandler that was previously added to this event with the add method.
        Returns true if the handler was found and removed from the set of event handlers.
        """
        return bool()

class KeyboardEventArgs(EventArgs):
    """
    Provides a set of arguments from a firing KeyboardEvent to a KeyboardEventHandler's notify callback method.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> KeyboardEventArgs:
        return KeyboardEventArgs()
    @property
    def modifierMask(self) -> int:
        """
        Gets the set of keyboard modifiers that were active. The value is the Boolean
        combination of KeyboardModifiers values.
        """
        return int()
    @property
    def keyCode(self) -> KeyCodes:
        """
        Gets the keyboard key.
        """
        return KeyCodes()

class Line2D(Curve2D):
    """
    Transient 2D line. A transient line is not displayed or saved in a document.
    Transient 2D lines are used as a wrapper to work with raw 2D line information.
    They are created statically using the create method of the Line2D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Line2D:
        return Line2D()
    @staticmethod
    def create(startPoint: Point2D, endPoint: Point2D) -> Line2D:
        """
        Creates a transient line.
        startPoint : The start point of the line
        endPoint : The end point of the line
        Returns the new Line2D object or null if the creation failed.
        """
        return Line2D()
    def copy(self) -> Line2D:
        """
        Creates and returns a copy of this line object.
        Returns an independent copy of this line object.
        """
        return Line2D()
    def getData(self) -> tuple[bool, Point2D, Point2D]:
        """
        Gets all of the data defining the line segment.
        startPoint : The output start point of the line.
        endPoint : The output end point of the line.
        Returns true if successful.
        """
        return (bool(), Point2D(), Point2D())
    def set(self, startPoint: Point2D, endPoint: Point2D) -> bool:
        """
        Sets all of the data defining the line segment.
        startPoint : The start point of the line
        endPoint : The end point of the line
        Returns true if redefining the line is successful
        """
        return bool()
    @property
    def startPoint(self) -> Point2D:
        """
        Gets and sets the start point of the line.
        """
        return Point2D()
    @startPoint.setter
    def startPoint(self, value: Point2D):
        """
        Gets and sets the start point of the line.
        """
        pass
    @property
    def endPoint(self) -> Point2D:
        """
        Gets and sets the end point of the line.
        """
        return Point2D()
    @endPoint.setter
    def endPoint(self, value: Point2D):
        """
        Gets and sets the end point of the line.
        """
        pass
    @property
    def asNurbsCurve(self) -> NurbsCurve2D:
        """
        Returns a NURBS curve that is geometrically identical to the line.
        """
        return NurbsCurve2D()

class Line3D(Curve3D):
    """
    Transient 3D line. A transient line is not displayed or saved in a document.
    Transient 3D lines are used as a wrapper to work with raw 3D line information.
    They are created statically using the create method of the Line3D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Line3D:
        return Line3D()
    @staticmethod
    def create(startPoint: Point3D, endPoint: Point3D) -> Line3D:
        """
        Creates a transient line.
        startPoint : The start point of the line.
        endPoint : The end point of the line.
        Returns the new Line3D object or null if the creation failed.
        """
        return Line3D()
    def copy(self) -> Line3D:
        """
        Creates and returns a copy of this line object.
        Returns an independent copy of this line object.
        """
        return Line3D()
    def asInfiniteLine(self) -> InfiniteLine3D:
        """
        Creates an equivalent InfiniteLine3D.
        Returns an equivalent InfiniteLine3D
        """
        return InfiniteLine3D()
    def isColinearTo(self, line: Line3D) -> bool:
        """
        Compare this line with another to check for collinearity
        line : The line to compare with for collinearity
        Returns true if the two lines are collinear
        """
        return bool()
    def intersectWithCurve(self, curve: Curve3D) -> ObjectCollection:
        """
        Intersect this line with a curve to get the intersection point(s).
        curve : The intersecting curve.
        The curve can be a Line3D, InfininteLine3D, Circle3D, Arc3D, EllipticalArc3D, Ellipse3D,
        or NurbsCurve3D.
        Returns a collection of the intersection points
        """
        return ObjectCollection()
    def intersectWithSurface(self, surface: Surface) -> ObjectCollection:
        """
        Intersect this line with a surface to get the intersection point(s).
        surface : The intersecting surface.
        The surface can be a Plane, Cone, Cylinder, EllipticalCone, EllipticalCylinder, Sphere,
        Torus or a NurbsSurface.
        Returns a collection of the intersection points.
        """
        return ObjectCollection()
    def getData(self) -> tuple[bool, Point3D, Point3D]:
        """
        Gets all of the data defining the line segment.
        startPoint : The output start point of the line.
        endPoint : The output end point of the line.
        Returns true if successful.
        """
        return (bool(), Point3D(), Point3D())
    def set(self, startPoint: Point3D, endPoint: Point3D) -> bool:
        """
        Sets all of the data defining the line segment.
        startPoint : The start point of the line.
        endPoint : The end point of the line.
        Returns true if successful.
        """
        return bool()
    @property
    def startPoint(self) -> Point3D:
        """
        Gets and sets the start point of the line.
        """
        return Point3D()
    @startPoint.setter
    def startPoint(self, value: Point3D):
        """
        Gets and sets the start point of the line.
        """
        pass
    @property
    def endPoint(self) -> Point3D:
        """
        Gets and sets the end point of the line.
        """
        return Point3D()
    @endPoint.setter
    def endPoint(self, value: Point3D):
        """
        Gets and sets the end point of the line.
        """
        pass
    @property
    def asNurbsCurve(self) -> NurbsCurve3D:
        """
        Returns a NURBS curve that is geometrically identical to the line.
        """
        return NurbsCurve3D()

class ListControlDefinition(ControlDefinition):
    """
    Represents the information used to define a list of check boxes, radio buttons, or text with icons. This class
    isn't the visible list control but is the information needed to create a list control and fully defines a list except for
    it's position within the user interface.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ListControlDefinition:
        return ListControlDefinition()
    @property
    def listItems(self) -> ListItems:
        """
        Gets the associated ListControlItems collection through which you can add and modify items in the list.
        """
        return ListItems()
    @property
    def listControlDisplayType(self) -> ListControlDisplayTypes:
        """
        Gets how this list control will be displayed; as a standard list, a list of check boxes, or a list of radio buttons.
        """
        return ListControlDisplayTypes()
    @property
    def lastSelected(self) -> ListItem:
        """
        Gets the item in the list that was last selected. This can return null
        in the case where this control is displayed as a list of check boxes and there hasn't
        been any interaction by the end-user. In the case of a list of check boxes, this returns
        the item that was last clicked by the user, whether it was to check or uncheck the item.
        In the case of a list of radio buttons, this always returns the item that is currently selected.
        """
        return ListItem()

class MarkingMenuEvent(Event):
    """
    A MarkingMenuEvent is fired when the marking menu and context menu are displayed. For example, in response to the
    markingMenuDisplaying event.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MarkingMenuEvent:
        return MarkingMenuEvent()
    def add(self, handler: MarkingMenuEventHandler) -> bool:
        """
        Add a handler to be notified when the event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: MarkingMenuEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class MarkingMenuEventArgs(EventArgs):
    """
    The MarkingMenuEventArgs provides information associated with the marking and context
    menu being displayed.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MarkingMenuEventArgs:
        return MarkingMenuEventArgs()
    @property
    def radialMarkingMenu(self) -> RadialMarkingMenu:
        """
        Provides access to the radial marking menu.
        """
        return RadialMarkingMenu()
    @property
    def linearMarkingMenu(self) -> LinearMarkingMenu:
        """
        Provides access to the linear marking menu.
        """
        return LinearMarkingMenu()
    @property
    def selectedEntities(self) -> list[Base]:
        """
        Returns the currently selected entities that the user left-clicked over.
        These provide the "context" of what should be displayed in the menu. This
        can be an empty array in the case where they clicked in a open area within
        the graphics window.
        """
        return [Base()]

class MouseEvent(Event):
    """
    An event endpoint that supports the connection to client implemented MouseEventHandlers.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MouseEvent:
        return MouseEvent()
    def add(self, handler: MouseEventHandler) -> bool:
        """
        Adds an event handler to this event endpoint.
        handler : The client implemented MouseEventHandler to be called when this event is triggered.
        Returns true if the handler was successfully added to the set of event handlers.
        """
        return bool()
    def remove(self, handler: MouseEventHandler) -> bool:
        """
        Removes a handler from this event endpoint.
        handler : A MouseEventhandler that was previously added to this event with the add method.
        Returns true if the handler was found and removed from the set of event handlers.
        """
        return bool()

class MouseEventArgs(EventArgs):
    """
    Provides a set of arguments from a firing MouseEvent to a MouseEventHandler's notify callback method.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MouseEventArgs:
        return MouseEventArgs()
    @property
    def button(self) -> MouseButtons:
        """
        Gets which mouse button(s) are pressed. The returned value
        is bitwise and can indicate that more than one button is pressed.
        """
        return MouseButtons()
    @property
    def clicks(self) -> int:
        """
        Gets the number of times the button was pressed and released.
        """
        return int()
    @property
    def wheelDelta(self) -> int:
        """
        Gets a signed count of the number of detents the mouse wheel has rotated.
        """
        return int()
    @property
    def keyboardModifiers(self) -> KeyboardModifiers:
        """
        Gets which modifier keys are currently pressed. The returned value
        is bitwise and can indicate that more than one button is pressed.
        """
        return KeyboardModifiers()
    @property
    def position(self) -> Point2D:
        """
        Gets the coordinate of the mouse in screen space.
        """
        return Point2D()
    @property
    def viewportPosition(self) -> Point2D:
        """
        Gets the coordinate of the mouse in viewport space, if the mouse is
        within a viewport. If the mouse is not over a viewport this property will return null.
        """
        return Point2D()
    @property
    def viewport(self) -> Viewport:
        """
        Returns the viewport where the mouse event occurred, if it was within a viewport.
        If the mouse is not over a viewport this property will return null.
        """
        return Viewport()

class NavigationEvent(Event):
    """
    A NavigationEvent is fired when a link is navigated on the page in a palette.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> NavigationEvent:
        return NavigationEvent()
    def add(self, handler: NavigationEventHandler) -> bool:
        """
        Add a handler to be notified when the event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: NavigationEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class NavigationEventArgs(EventArgs):
    """
    The NavigationEventArgs provides access to the information sent from the browser
    within a palette on a navigation event.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> NavigationEventArgs:
        return NavigationEventArgs()
    @property
    def navigationURL(self) -> str:
        """
        The URL that is being navigated to.
        """
        return str()
    @navigationURL.setter
    def navigationURL(self, value: str):
        """
        The URL that is being navigated to.
        """
        pass
    @property
    def launchExternally(self) -> bool:
        """
        If True, the URL will be navigated to in an external browser by the operating system.
        If False, the default value, the URL will be navigated to in the palette's browser.
        """
        return bool()
    @launchExternally.setter
    def launchExternally(self, value: bool):
        """
        If True, the URL will be navigated to in an external browser by the operating system.
        If False, the default value, the URL will be navigated to in the palette's browser.
        """
        pass
    @property
    def preventDefault(self) -> bool:
        """
        If True, the default handling of this navigation event will not continue.
        If False, the default value, the default handling of this navigation event will continue.
        """
        return bool()
    @preventDefault.setter
    def preventDefault(self, value: bool):
        """
        If True, the default handling of this navigation event will not continue.
        If False, the default value, the default handling of this navigation event will continue.
        """
        pass
    @property
    def browserCommandInput(self) -> BrowserCommandInput:
        """
        When the event is fired from a BrowserCommandInput object, this property returns
        the specific BrowserCommandInput that caused the event to fire. In all other cases
        this property returns null.
        """
        return BrowserCommandInput()

class NurbsCurve2D(Curve2D):
    """
    Transient 2D NURBS curve. A transient NURBS curve is not displayed or saved in a document.
    Transient 2D NURBS curves are used as a wrapper to work with raw 2D NURBS curve information.
    They are created statically using one of the create methods of the NurbsCurve2D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> NurbsCurve2D:
        return NurbsCurve2D()
    @staticmethod
    def createNonRational(controlPoints: list[Point2D], degree: int, knots: list[float], isPeriodic: bool) -> NurbsCurve2D:
        """
        Creates a transient 2D NURBS non-rational b-spline object.
        controlPoints : An array of control point that define the path of the spline
        degree : The degree of curvature of the spline
        knots : An array of numbers that define the knot vector of the spline. The knots is an array of (>=degree + N + 1) numbers, where N is the number of control points.
        isPeriodic : A bool specifying if the spline is to be Periodic. A periodic spline has a start point and
        end point that meet forming a closed loop.
        Returns the new NurbsCurve2D object or null if the creation failed.
        """
        return NurbsCurve2D()
    @staticmethod
    def createRational(controlPoints: list[Point2D], degree: int, knots: list[float], weights: list[float], isPeriodic: bool) -> NurbsCurve2D:
        """
        Creates a transient 2D NURBS rational b-spline object.
        controlPoints : An array of control point that define the path of the spline
        degree : The degree of curvature of the spline
        knots : An array of numbers that define the knot vector of the spline. The knots is an array of (>=degree + N + 1) numbers, where N is the number of control points.
        weights : An array of numbers that define the weights for the spline.
        isPeriodic : A bool specifying if the spline is to be Periodic. A periodic curve has a start point and
        end point that meet (with curvature continuity) forming a closed loop.
        Returns the new NurbsCurve2D object or null if the creation failed.
        """
        return NurbsCurve2D()
    def copy(self) -> NurbsCurve2D:
        """
        Creates and returns an independent copy of this NurbsCurve2D object.
        Returns an independent copy of this NurbsCurve2D.
        """
        return NurbsCurve2D()
    def getData(self) -> tuple[bool, list[Point2D], int, list[float], bool, list[float], bool]:
        """
        Gets the data that defines a transient 2D NURBS rational b-spline object.
        controlPoints : The output array of control point that define the path of the spline.
        degree : The output degree of curvature of the spline.
        knots : The output array of numbers that define the knots of the spline.
        isRational : The output value indicating if the spline is rational. A rational spline will have a weight value
        for each control point.
        weights : The output array of numbers that define the weights for the spline.
        isPeriodic : The output value indicating if the spline is Periodic. A periodic curve has a start point and
        end point that meet (with curvature continuity) forming a closed loop.
        Returns true if successful.
        """
        return (bool(), [Point2D()], int(), [float()], bool(), [float()], bool())
    def set(self, controlPoints: list[Point2D], degree: int, knots: list[float], isRational: bool, weights: list[float], isPeriodic: bool) -> bool:
        """
        Sets the data that defines a transient 2D NURBS rational b-spline object.
        controlPoints : The array of control point that define the path of the spline
        degree : The degree of curvature of the spline
        knots : An array of numbers that define the knots of the spline.
        isRational : A bool indicating if the spline is rational. A rational spline must have a weight value
        for each control point.
        weights : An array of numbers that define the weights for the spline.
        isPeriodic : A bool specifying if the spline is to be Periodic. A periodic curve has a start point and
        end point that meet (with curvature continuity) forming a closed loop.
        Returns true if successful
        """
        return bool()
    def extract(self, startParam: float, endParam: float) -> NurbsCurve2D:
        """
        Defines a new NURBS curve that is the subset of this NURBS curve in the parameter
        range of [startParam, endParam]
        startParam : The parameter position of the start of the subset.
        endParam : The parameter position of the end of the subset.
        Returns a new NurbsCurve2D object.
        """
        return NurbsCurve2D()
    def merge(self, nurbsCurve: NurbsCurve2D) -> NurbsCurve2D:
        """
        Define a new NURBS curve that is the result of combining this NURBS curve with
        another NURBS curve. The curves are merged with the end point of the current
        curve merging with the start point of the other curve. The curves are forced
        to join even if they are not physically touching so you will typically want
        to make sure the end and start points of the curves are where you expect them to be.
        nurbsCurve : The NURBS curve to combine with
        Returns a new NurbsCurve2D object.
        """
        return NurbsCurve2D()
    @property
    def controlPointCount(self) -> int:
        """
        Gets the number of control points that define the curve
        """
        return int()
    @property
    def degree(self) -> int:
        """
        Returns the degree of the curve
        """
        return int()
    @property
    def knotCount(self) -> int:
        """
        Returns the knot count of the curve
        """
        return int()
    @property
    def isRational(self) -> bool:
        """
        Indicates if the curve is rational or non-rational type
        """
        return bool()
    @property
    def isClosed(self) -> bool:
        """
        Indicates if the curve is closed
        """
        return bool()
    @property
    def isPeriodic(self) -> bool:
        """
        Indicates if the curve is periodic.
        """
        return bool()
    @property
    def controlPoints(self) -> list[Point2D]:
        """
        Returns an array of Point2D objects that define the control points of the curve.
        """
        return [Point2D()]
    @property
    def knots(self) -> list[float]:
        """
        Returns an array of numbers that define the Knots of the curve.
        """
        return [float()]

class NurbsCurve3D(Curve3D):
    """
    Transient 3D NURBS curve. A transient NURBS curve is not displayed or saved in a document.
    Transient 3D NURBS curves are used as a wrapper to work with raw 3D NURBS curve information.
    They are created statically using one of the create methods of the NurbsCurve3D class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> NurbsCurve3D:
        return NurbsCurve3D()
    @staticmethod
    def createNonRational(controlPoints: list[Point3D], degree: int, knots: list[float], isPeriodic: bool) -> NurbsCurve3D:
        """
        Creates a transient 3D NURBS non-rational b-spline object.
        controlPoints : An array of control point that define the path of the spline.
        degree : The degree of curvature of the spline.
        knots : An array of numbers that define the knot vector of the spline. The knots is an array of (>=degree + N + 1) numbers, where N is the number of control points.
        isPeriodic : A bool specifying if the spline is to be Periodic. A periodic spline has a start point and
        end point that meet forming a closed loop.
        Returns the new NurbsCurve3D object or null if the creation failed.
        """
        return NurbsCurve3D()
    @staticmethod
    def createRational(controlPoints: list[Point3D], degree: int, knots: list[float], weights: list[float], isPeriodic: bool) -> NurbsCurve3D:
        """
        Creates a transient 3D NURBS rational b-spline object.
        controlPoints : An array of control point that define the path of the spline.
        degree : The degree of curvature of the spline.
        knots : An array of numbers that define the knot vector of the spline. The knots is an array of (>=degree + N + 1) numbers, where N is the number of control points.
        weights : An array of numbers that define the weight at each control point.
        isPeriodic : A bool specifying if the spline is to be Periodic. A periodic curve has a start point and
        end point that meet (with curvature continuity) forming a closed loop.
        Returns the new NurbsCurve3D object or null if the creation failed.
        """
        return NurbsCurve3D()
    def getData(self) -> tuple[bool, list[Point3D], int, list[float], bool, list[float], bool]:
        """
        Gets the data that defines a transient 3D NURBS rational b-spline object.
        controlPoints : The output array of control point that define the path of the spline.
        degree : The output degree of curvature of the spline.
        knots : The output array of numbers that define the knot vector of the spline.
        isRational : The output value indicating if the spline is rational. A rational spline will have a weight value
        for each control point.
        weights : The output array of numbers that define the weights for the spline.
        isPeriodic : The output value indicating if the spline is Periodic. A periodic curve has a start point and
        end point that meet (with curvature continuity) forming a closed loop.
        Returns true if successful.
        """
        return (bool(), [Point3D()], int(), [float()], bool(), [float()], bool())
    def set(self, controlPoints: list[Point3D], degree: int, knots: list[float], isRational: bool, weights: list[float], isPeriodic: bool) -> bool:
        """
        Sets the data that defines a transient 3D NURBS rational b-spline object.
        controlPoints : The array of control point that define the path of the spline.
        degree : The degree of curvature of the spline.
        knots : An array of numbers that define the knot vector of the spline.
        isRational : A bool value indicating if the spline is rational. A rational spline must have a weight value
        for each control point.
        weights : An array of numbers that define the weights for the spline.
        isPeriodic : A bool indicating if the spline is Periodic. A periodic curve has a start point and
        end point that meet (with curvature continuity) forming a closed loop.
        Returns true if successful.
        """
        return bool()
    def extract(self, startParam: float, endParam: float) -> NurbsCurve3D:
        """
        Defines a new NURBS curve that is the subset of this NURBS curve in the parameter
        range of [startParam, endParam]
        startParam : The parameter position that defines the start of the subset.
        endParam : The parameter position that defines the end of the subset.
        Returns a new NurbsCurve3D object.
        """
        return NurbsCurve3D()
    def merge(self, nurbsCurve: NurbsCurve3D) -> NurbsCurve3D:
        """
        Define a new NURBS curve that is the result of combining this NURBS curve with
        another NURBS curve.
        nurbsCurve : The NURBS curve to combine with.
        Returns a new NurbsCurve3D object.
        """
        return NurbsCurve3D()
    def copy(self) -> NurbsCurve3D:
        """
        Creates and returns an independent copy of this NurbsCurve3D object.
        Returns an independent copy of this NurbsCurve3D.
        """
        return NurbsCurve3D()
    @property
    def controlPointCount(self) -> int:
        """
        Gets the number of control points that define the curve.
        """
        return int()
    @property
    def degree(self) -> int:
        """
        Returns the degree of the curve.
        """
        return int()
    @property
    def knotCount(self) -> int:
        """
        Returns the knot count of the curve.
        """
        return int()
    @property
    def isRational(self) -> bool:
        """
        Indicates if the curve is rational or non-rational type.
        """
        return bool()
    @property
    def isClosed(self) -> bool:
        """
        Indicates if the curve is closed.
        """
        return bool()
    @property
    def isPeriodic(self) -> bool:
        """
        Indicates if the curve is periodic.
        """
        return bool()
    @property
    def controlPoints(self) -> list[Point3D]:
        """
        Returns an array of Point3D objects that define the control points of the curve.
        """
        return [Point3D()]
    @property
    def knots(self) -> list[float]:
        """
        Returns an array of numbers that define the knot vector of the curve.
        """
        return [float()]

class NurbsSurface(Surface):
    """
    Transient NURBS surface. A transient NURBS surface is not displayed or saved in a document.
    A transient NURBS surface is used as a wrapper to work with raw NURBS surface information.
    A transient NURBS surface is bounded by it's natural boundaries and does not support the
    definition of arbitrary boundaries.
    A NURBS surface is typically obtained from a BREPFace object, which does have boundary information.
    They are created statically using the create method of the NurbsSurface class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> NurbsSurface:
        return NurbsSurface()
    @staticmethod
    def create(degreeU: int, degreeV: int, controlPointCountU: int, controlPointCountV: int, controlPoints: list[Point3D], knotsU: list[float], knotsV: list[float], weights: list[float], propertiesU: NurbsSurfaceProperties, propertiesV: NurbsSurfaceProperties) -> NurbsSurface:
        """
        Creates a transient NURBS surface object.
        degreeU : The degree in the U direction.
        degreeV : The degree in the V direction.
        controlPointCountU : The number of control points in the U direction.
        controlPointCountV : The number of control points in the V direction.
        controlPoints : An array of surface control points.
        The length of this array must be controlPointCountU * controlPointCountV.
        knotsU : The knot vector for the U direction.
        knotsV : The knot vector for the V direction.
        weights : An array of weights that corresponds to the control points of the surface.
        propertiesU : The properties (NurbsSurfaceProperties) of the surface in the U direction.
        propertiesV : The properties (NurbsSurfaceProperties) of the surface in the V direction.
        Returns the new NurbsSurface object or null if the creation failed.
        """
        return NurbsSurface()
    def getData(self) -> tuple[bool, int, int, int, int, list[Point3D], list[float], list[float], list[float], NurbsSurfaceProperties, NurbsSurfaceProperties]:
        """
        Gets the data that defines the NURBS surface.
        degreeU : The output degree in the U direction.
        degreeV : The output degree in the V direction.
        controlPointCountU : The output number of control points in the U direction.
        controlPointCountV : The output number of control points in the V direction.
        controlPoints : An output array of surface control points.
        knotsU : The output knot vector for the U direction.
        knotsV : The output knot vector for the V direction.
        weights : An output array of weights that corresponds to the control points of the surface.
        propertiesU : The output properties (NurbsSurfaceProperties) of the surface in the U direction.
        propertiesV : The output properties (NurbsSurfaceProperties) of the surface in the V direction.
        Returns true if successful.
        """
        return (bool(), int(), int(), int(), int(), [Point3D()], [float()], [float()], [float()], NurbsSurfaceProperties(), NurbsSurfaceProperties())
    def set(self, degreeU: int, degreeV: int, controlPointCountU: int, controlPointCountV: int, controlPoints: list[Point3D], knotsU: list[float], knotsV: list[float], weights: list[float], propertiesU: NurbsSurfaceProperties, propertiesV: NurbsSurfaceProperties) -> bool:
        """
        Sets the data that defines the NURBS surface.
        degreeU : The degree in the U direction.
        degreeV : The degree in the V direction.
        controlPointCountU : The number of control points in the U direction.
        controlPointCountV : The number of control points in the V direction.
        controlPoints : An array of surface control points.
        knotsU : The knot vector for the U direction.
        knotsV : The knot vector for the V direction.
        weights : An array of weights that corresponds to the control points of the surface.
        propertiesU : The properties (NurbsSurfaceProperties) of the surface in the U direction.
        propertiesV : The properties (NurbsSurfaceProperties) of the surface in the V direction.
        Returns true if successful
        """
        return bool()
    def copy(self) -> NurbsSurface:
        """
        Creates and returns an independent copy of this NurbsSurface object.
        Returns a new NurbsSurface object that is a copy of this NurbsSurface object.
        """
        return NurbsSurface()
    @property
    def controlPointCountU(self) -> int:
        """
        Gets the number of control points in the U direction.
        """
        return int()
    @property
    def controlPointCountV(self) -> int:
        """
        Gets the number of control points in the V direction.
        """
        return int()
    @property
    def degreeU(self) -> int:
        """
        Gets the degree in the U direction.
        """
        return int()
    @property
    def degreeV(self) -> int:
        """
        Gets the degree in the V direction.
        """
        return int()
    @property
    def knotCountU(self) -> int:
        """
        Gets the knot count in the U direction.
        """
        return int()
    @property
    def knotCountV(self) -> int:
        """
        Gets thekKnot count in the V direction.
        """
        return int()
    @property
    def propertiesU(self) -> NurbsSurfaceProperties:
        """
        Gets the properties (NurbsSurfaceProperties) of the surface in the U direction.
        """
        return NurbsSurfaceProperties()
    @property
    def propertiesV(self) -> NurbsSurfaceProperties:
        """
        Gets the properties (NurbsSurfaceProperties) of the surface in the V direction.
        """
        return NurbsSurfaceProperties()
    @property
    def controlPoints(self) -> list[Point3D]:
        """
        Gets an array of control points from the surface.
        """
        return [Point3D()]
    @property
    def knotsU(self) -> list[float]:
        """
        Get the knot vector from the U direction.
        """
        return [float()]
    @property
    def knotsV(self) -> list[float]:
        """
        Get the knot vector from the V direction
        """
        return [float()]

class Plane(Surface):
    """
    Transient plane. A transient plane is not displayed or saved in a document.
    Transient planes are used as a wrapper to work with raw plane information.
    A transient plane has no boundaries or size, but is infinite and is represented
    by a position, a normal, and an orientation in space.
    They are created statically using the create method of the Plane class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Plane:
        return Plane()
    @staticmethod
    def create(origin: Point3D, normal: Vector3D) -> Plane:
        """
        Creates a transient plane object by specifying an origin and a normal direction.
        origin : The origin point of the plane.
        normal : The normal direction of the plane.
        Returns the new plane object or null if the creation failed.
        """
        return Plane()
    @staticmethod
    def createUsingDirections(origin: Point3D, uDirection: Vector3D, vDirection: Vector3D) -> Plane:
        """
        Creates a transient plane object by specifying an origin along with U and V directions.
        origin : The origin point of the plane.
        uDirection : The U direction for the plane.
        vDirection : The V direction for the plane.
        Returns the new plane object or null if the creation failed.
        """
        return Plane()
    def setUVDirections(self, uDirection: Vector3D, vDirection: Vector3D) -> bool:
        """
        Sets the U and V directions of the plane.
        uDirection : The U direction for the plane.
        vDirection : The V direction for the plane.
        Returns true if successful.
        """
        return bool()
    def isParallelToPlane(self, plane: Plane) -> bool:
        """
        Checks if this plane is parallel to another plane.
        plane : The plane to compare with for parallelism.
        Returns true if the planes are parallel.
        """
        return bool()
    def isParallelToLine(self, line: Line3D) -> bool:
        """
        Checks if this plane is parallel to a line.
        line : The line to compare with for parallelism.
        Returns true if the plane and line are parallel.
        """
        return bool()
    def isPerpendicularToPlane(self, plane: Plane) -> bool:
        """
        Checks if this plane is perpendicular to another plane.
        plane : The plane to compare with for perpendicularity.
        Returns true if the planes are perpendicular.
        """
        return bool()
    def isPerpendicularToLine(self, line: Line3D) -> bool:
        """
        Checks if this plane is perpendicular to a line.
        line : The line to compare with for perpendicularity.
        Returns true if the plane and line are perpendicular.
        """
        return bool()
    def isCoPlanarTo(self, plane: Plane) -> bool:
        """
        Checks if this plane is coplanar with another plane.
        plane : The plane to compare with for co-planarity.
        Returns true if the planes are coplanar.
        """
        return bool()
    def intersectWithPlane(self, plane: Plane) -> InfiniteLine3D:
        """
        Creates an infinite line at the intersection of this plane with another plane.
        plane : The plane to intersect with.
        Returns an InfiniteLine3D object or null if the planes do not intersect (are parallel).
        """
        return InfiniteLine3D()
    def intersectWithLine(self, line: InfiniteLine3D) -> Point3D:
        """
        Creates a 3D point at the intersection of this plane and a line.
        line : The line to intersect with.
        Returns a Point3D object or null if the plane and line do not intersect (are parallel).
        """
        return Point3D()
    def intersectWithCurve(self, curve: Curve3D) -> ObjectCollection:
        """
        Intersect this plane with a curve to get the intersection point(s).
        curve : The intersecting curve.
        The curve can be a Line3D, InfininteLine3D, Circle3D, Arc3D, EllipticalArc3D, Ellipse3D,
        or NurbsCurve3D.
        Returns a collection of the intersection points.
        """
        return ObjectCollection()
    def intersectWithSurface(self, surface: Surface) -> ObjectCollection:
        """
        Intersect this plane with a surface to get the intersection point(s).
        surface : The intersecting surface.
        The surface can be a Plane, Cone, Cylinder, EllipticalCone, EllipticalCylinder, Sphere,
        Torus, or a NurbsSurface.
        Returns a collection of the intersection points.
        """
        return ObjectCollection()
    def copy(self) -> Plane:
        """
        Creates and returns an independent copy of this Plane object.
        Returns a new Plane object that is a copy of this Plane object.
        """
        return Plane()
    @property
    def origin(self) -> Point3D:
        """
        Gets and sets the origin point of the plane.
        """
        return Point3D()
    @origin.setter
    def origin(self, value: Point3D):
        """
        Gets and sets the origin point of the plane.
        """
        pass
    @property
    def normal(self) -> Vector3D:
        """
        Gets and sets the normal of the plane.
        """
        return Vector3D()
    @normal.setter
    def normal(self, value: Vector3D):
        """
        Gets and sets the normal of the plane.
        """
        pass
    @property
    def uDirection(self) -> Vector3D:
        """
        Gets the U Direction of the plane.
        """
        return Vector3D()
    @property
    def vDirection(self) -> Vector3D:
        """
        Gets the V Direction of the plane.
        """
        return Vector3D()

class RadioButtonGroupCommandInput(CommandInput):
    """
    Provides a command input to get the choice from a radio button group from the user.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RadioButtonGroupCommandInput:
        return RadioButtonGroupCommandInput()
    @property
    def listItems(self) -> ListItems:
        """
        Returns the ListItems object associated with this radio button group. You use this
        object to populate and interact with the items in the radio button group.
        """
        return ListItems()
    @property
    def selectedItem(self) -> ListItem:
        """
        Gets and sets the item in the radio button list that is currently selected.
        """
        return ListItem()

class SATImportOptions(ImportOptions):
    """
    Defines that a SAT import is to be done and specifies the various options.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SATImportOptions:
        return SATImportOptions()

class SelectionCommandInput(CommandInput):
    """
    Provides a command input to get a selection from the user.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SelectionCommandInput:
        return SelectionCommandInput()
    Bodies = "Bodies"
    SolidBodies = "SolidBodies"
    SurfaceBodies = "SurfaceBodies"
    MeshBodies = "MeshBodies"
    Faces = "Faces"
    SolidFaces = "SolidFaces"
    SurfaceFaces = "SurfaceFaces"
    PlanarFaces = "PlanarFaces"
    CylindricalFaces = "CylindricalFaces"
    ConicalFaces = "ConicalFaces"
    SphericalFaces = "SphericalFaces"
    ToroidalFaces = "ToroidalFaces"
    SplineFaces = "SplineFaces"
    Edges = "Edges"
    LinearEdges = "LinearEdges"
    CircularEdges = "CircularEdges"
    EllipticalEdges = "EllipticalEdges"
    TangentEdges = "TangentEdges"
    NonTangentEdges = "NonTangentEdges"
    Vertices = "Vertices"
    RootComponents = "RootComponents"
    Occurrences = "Occurrences"
    Sketches = "Sketches"
    SketchCurves = "SketchCurves"
    SketchLines = "SketchLines"
    SketchCircles = "SketchCircles"
    SketchPoints = "SketchPoints"
    ConstructionPoints = "ConstructionPoints"
    ConstructionLines = "ConstructionLines"
    ConstructionPlanes = "ConstructionPlanes"
    Features = "Features"
    Canvases = "Canvases"
    Decals = "Decals"
    JointOrigins = "JointOrigins"
    Joints = "Joints"
    SketchConstraints = "SketchConstraints"
    Profiles = "Profiles"
    Texts = "Texts"
    CustomGraphics = "CustomGraphics"
    def addSelectionFilter(self, filter: str) -> bool:
        """
        Adds an additional filter to the existing filter list.
        filter : The name of a selection filter to add. The valid list of selection filters can be found here: <a href="SelectionFilters_UM.htm">Selection Filters</a>.
        Returns true if the filter was added successfully.
        """
        return bool()
    def clearSelectionFilter(self) -> bool:
        """
        Clears the list of selection filters.
        Returns true if successful.
        """
        return bool()
    def selection(self, index: int) -> Selection:
        """
        Returns the selection at the specified index.
        index : The index of the selection to return.
        Returns the Selection at the specified index, or null on error.
        """
        return Selection()
    def addSelection(self, selection: Base) -> bool:
        """
        Adds the selection to the list of selections associated with this input. This method is not valid within
        the commandCreated event but must be used later in the command lifetime. If you want to pre-populate the
        selection when the command is starting, you can use this method in the activate method of the Command.
        It's also valid to use in other events once the command is running, such as the validateInputs event.
        selection : The entity to add a selection of to this input. The addition may fail if the entity
        does not match the selection filter, or adding it would exceed the limits.
        Returns true if a selection to the entity was added to this input.
        """
        return bool()
    def getSelectionLimits(self) -> tuple[bool, int, int]:
        """
        Get the limits currently defined for this input.
        minimum : The minimum number of selections required. A value of zero means that there is no minimum limit.
        maximum : The maximum number of selections required. A value of zero means that there is no maximum limit.
        Returns true if the selection limits were successfully returned.
        """
        return (bool(), int(), int())
    def setSelectionLimits(self, minimum: int, maximum: int) -> bool:
        """
        Defines the limits for the number of selections associated with this input.
        A maximum value of 0 indicates that there is no maximum.
        minimum : The minimum number of selections required. A value of zero means that there is no minimum limit.
        maximum : The maximum number of selections required. A value of zero means that there is no maximum limit.
        If maximum is equal to minimum, then exactly that number of selections is required.
        Returns true if the limits were successfully set.
        """
        return bool()
    def clearSelection(self) -> bool:
        """
        Clears the current selection so no entities are in the selection.
        Returns true if successful.
        """
        return bool()
    @property
    def commandPrompt(self) -> str:
        """
        Gets or sets the tooltip shown next to the cursor.
        """
        return str()
    @commandPrompt.setter
    def commandPrompt(self, value: str):
        """
        Gets or sets the tooltip shown next to the cursor.
        """
        pass
    @property
    def selectionFilters(self) -> list[str]:
        """
        Gets or sets the list of selection filters. The valid list of selection filters can be found here: <a href="SelectionFilters_UM.htm">Selection Filters</a>.
        """
        return [str()]
    @selectionFilters.setter
    def selectionFilters(self, value: list[str]):
        """
        Gets or sets the list of selection filters. The valid list of selection filters can be found here: <a href="SelectionFilters_UM.htm">Selection Filters</a>.
        """
        pass
    @property
    def selectionCount(self) -> int:
        """
        Gets the current number of selections the user has made for this input.
        """
        return int()
    @property
    def hasFocus(self) -> bool:
        """
        Gets and sets if this selection input has focus with respect to other selection inputs on the
        command dialog. Only one selection input on a dialog can have focus at a time so setting hasFocus to true
        will remove the focus from the selection input that previously had focus. When a selection input
        has focus, any user selections will be added to that selection input and the selection rules associated
        with that selection input will apply.
        """
        return bool()
    @hasFocus.setter
    def hasFocus(self, value: bool):
        """
        Gets and sets if this selection input has focus with respect to other selection inputs on the
        command dialog. Only one selection input on a dialog can have focus at a time so setting hasFocus to true
        will remove the focus from the selection input that previously had focus. When a selection input
        has focus, any user selections will be added to that selection input and the selection rules associated
        with that selection input will apply.
        """
        pass

class SelectionEvent(Event):
    """
    An event endpoint that supports the connection to client implemented SelectionEventHandlers.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SelectionEvent:
        return SelectionEvent()
    def add(self, handler: SelectionEventHandler) -> bool:
        """
        Adds an event handler to this event endpoint.
        handler : The client implemented SelectionEventHandler to be called when this event is triggered.
        Returns true if the handler was successfully added to the set of event handlers.
        """
        return bool()
    def remove(self, handler: SelectionEventHandler) -> bool:
        """
        Removes a handler from this event endpoint.
        handler : A SelectionEventHandler that was previously added to this event with the add method.
        Returns true if the handler was found and removed from the set of event handlers.
        """
        return bool()
    @property
    def activeInput(self) -> SelectionCommandInput:
        """
        Returns the SelectionCommandInput that is currently active in the command dialog and
        that the user is selecting entities for. This can be used to determine which set of
        rules you want to apply to determine if the current entity is selectable or not.
        """
        return SelectionCommandInput()

class SelectionEventArgs(EventArgs):
    """
    Provides a set of arguments from a firing SelectionEvent to a SelectionEventHandler's notify callback method.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SelectionEventArgs:
        return SelectionEventArgs()
    @property
    def selection(self) -> Selection:
        """
        Gets the entity that is valid for selection.
        """
        return Selection()
    @property
    def isSelectable(self) -> bool:
        """
        Gets or sets whether this entity should be made available to be selected.
        The value is initialized to true, so doing nothing will result
        in the entity being selectable.
        """
        return bool()
    @isSelectable.setter
    def isSelectable(self, value: bool):
        """
        Gets or sets whether this entity should be made available to be selected.
        The value is initialized to true, so doing nothing will result
        in the entity being selectable.
        """
        pass
    @property
    def additionalEntities(self) -> ObjectCollection:
        """
        Gets or sets any additional entities that should be pre-highlighted and selected
        if the entity the mouse is over is selected. If you add an entity that is already
        selected, it will be unselected. The result of adding additional entities is the
        same as if they were selected one at a time by the user and the user can unselect each
        entity one at a time by picking it while it's selected.
        
        An example of how this might be used is that the user can select a group of
        tangentially connected edges by picking a single edge. You can use the
        BrepEdge.tangentiallyConnectedEdges to easily find the tangent edges and add them
        to the set of additional entities to be selected. These edges are pre-highlighted
        and then selected.
        
        If you are using this property you need to make sure that the selection
        limits for the SelectionCommandInput have been set appropriately. For example, a
        newly created SeletionCommandInput is set to only allow the selection of a single
        entity. By adding additional entities you'll need more than one entity because the
        entire set of entities will be added to the selection. Use the setSelectionLimits
        method of the SelectionCommandInput to change the number of allowed selections.
        
        The additional entities should all be valid based on the current selection filter.
        """
        return ObjectCollection()
    @additionalEntities.setter
    def additionalEntities(self, value: ObjectCollection):
        """
        Gets or sets any additional entities that should be pre-highlighted and selected
        if the entity the mouse is over is selected. If you add an entity that is already
        selected, it will be unselected. The result of adding additional entities is the
        same as if they were selected one at a time by the user and the user can unselect each
        entity one at a time by picking it while it's selected.
        
        An example of how this might be used is that the user can select a group of
        tangentially connected edges by picking a single edge. You can use the
        BrepEdge.tangentiallyConnectedEdges to easily find the tangent edges and add them
        to the set of additional entities to be selected. These edges are pre-highlighted
        and then selected.
        
        If you are using this property you need to make sure that the selection
        limits for the SelectionCommandInput have been set appropriately. For example, a
        newly created SeletionCommandInput is set to only allow the selection of a single
        entity. By adding additional entities you'll need more than one entity because the
        entire set of entities will be added to the selection. Use the setSelectionLimits
        method of the SelectionCommandInput to change the number of allowed selections.
        
        The additional entities should all be valid based on the current selection filter.
        """
        pass
    @property
    def activeInput(self) -> SelectionCommandInput:
        """
        Returns the SelectionCommandInput that is currently active in the command dialog and
        that the user is selecting entities for. This can be used to determine which set of
        rules you want to apply to determine if the current entity is selectable or not.
        """
        return SelectionCommandInput()

class SeparatorControl(ToolbarControl):
    """
    Represents a separator within a panel, toolbar, or drop-down control.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SeparatorControl:
        return SeparatorControl()

class SliderCommandInput(CommandInput):
    """
    Provides a command input to get the value of a slider from the user.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SliderCommandInput:
        return SliderCommandInput()
    def setText(self, left: str, right: str) -> bool:
        """
        Sets the text of the slider. Both the left and the right text should be set.
        left : Indicates the text on the left side of the slider.
        right : Indicates the text on the right side of the slider.
        Returns true if successful.
        """
        return bool()
    def getText(self, isLeft: bool) -> str:
        """
        Gets the texts of the slider if text has been defined.
        isLeft : Indicates to get the left or right text.
        Returns the left or right text of the slider.
        """
        return str()
    @property
    def expressionOne(self) -> str:
        """
        Uses an expression to set the value in the first input field. This can contain equations and
        is evaluated using the specified unit type.
        """
        return str()
    @expressionOne.setter
    def expressionOne(self, value: str):
        """
        Uses an expression to set the value in the first input field. This can contain equations and
        is evaluated using the specified unit type.
        """
        pass
    @property
    def expressionTwo(self) -> str:
        """
        Uses an expression to set the value in the second input field. This can contain equations and
        is evaluated using the specified unit type.
        
        This property is only available when the hasTwoSliders property returns true.
        """
        return str()
    @expressionTwo.setter
    def expressionTwo(self, value: str):
        """
        Uses an expression to set the value in the second input field. This can contain equations and
        is evaluated using the specified unit type.
        
        This property is only available when the hasTwoSliders property returns true.
        """
        pass
    @property
    def unitType(self) -> str:
        """
        Gets and sets the unit type that is used when evaluating the user's input.
        """
        return str()
    @unitType.setter
    def unitType(self, value: str):
        """
        Gets and sets the unit type that is used when evaluating the user's input.
        """
        pass
    @property
    def hasTwoSliders(self) -> bool:
        """
        Gets if the command input has two sliders.
        """
        return bool()

class SMTImportOptions(ImportOptions):
    """
    Defines that an SMT import is to be done and specifies the various options.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SMTImportOptions:
        return SMTImportOptions()

class Sphere(Surface):
    """
    Transient sphere. A transient sphere is not displayed or saved in a document.
    Transient spheres are used as a wrapper to work with raw sphere information.
    A transient sphere is a full sphere defined by a point and a radius.
    They are created statically using the create method of the Sphere class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Sphere:
        return Sphere()
    @staticmethod
    def create(origin: Point3D, radius: float) -> Sphere:
        """
        Creates a transient sphere object.
        origin : The origin point (center) of the sphere.
        radius : The radius of the sphere.
        Returns the new Sphere object or null if the creation failed.
        """
        return Sphere()
    def getData(self) -> tuple[bool, Point3D, float]:
        """
        Gets all of the data defining the sphere.
        origin : The output origin point (center) of the sphere.
        radius : The output radius of the sphere.
        Returns true if successful.
        """
        return (bool(), Point3D(), float())
    def set(self, origin: Point3D, radius: float) -> bool:
        """
        Sets all of the data defining the sphere.
        origin : The origin point (center) of the sphere.
        radius : The radius of the sphere.
        Returns true if successful.
        """
        return bool()
    def copy(self) -> Sphere:
        """
        Creates and returns an independent copy of this Sphere object.
        Returns a new Sphere object that is a copy of this Sphere object.
        """
        return Sphere()
    @property
    def origin(self) -> Point3D:
        """
        Gets and sets the origin point (center) of the sphere.
        """
        return Point3D()
    @origin.setter
    def origin(self, value: Point3D):
        """
        Gets and sets the origin point (center) of the sphere.
        """
        pass
    @property
    def radius(self) -> float:
        """
        Gets and sets the radius of the sphere.
        """
        return float()
    @radius.setter
    def radius(self, value: float):
        """
        Gets and sets the radius of the sphere.
        """
        pass

class SplitButtonControl(ToolbarControl):
    """
    A split button has two active areas that the user can click;
    the main button portion and the drop-down arrow. Clicking the main button, executes the displayed command.
    Clicking the drop-down displays the drop-down with additional commands.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SplitButtonControl:
        return SplitButtonControl()
    @property
    def defaultCommandDefinition(self) -> CommandDefinition:
        """
        Gets the command definition that is used as the default command on the main portion of the split button.
        """
        return CommandDefinition()
    @property
    def isLastUsedShown(self) -> bool:
        """
        Gets if this button behaves where the last executed command becomes the command on the main portion of the split button.
        """
        return bool()
    @property
    def additionalDefinitions(self) -> list[CommandDefinition]:
        """
        Gets or sets the command definitions used to define the buttons associated with the split button.
        """
        return [CommandDefinition()]
    @additionalDefinitions.setter
    def additionalDefinitions(self, value: list[CommandDefinition]):
        """
        Gets or sets the command definitions used to define the buttons associated with the split button.
        """
        pass

class STEPImportOptions(ImportOptions):
    """
    Defines that a STEP import is to be done and specifies the various options.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> STEPImportOptions:
        return STEPImportOptions()

class StringProperty(Property):
    """
    A string value property associated with a material or appearance.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> StringProperty:
        return StringProperty()
    @property
    def value(self) -> str:
        """
        Gets and sets the property value.
        """
        return str()
    @value.setter
    def value(self, value: str):
        """
        Gets and sets the property value.
        """
        pass

class StringValueCommandInput(CommandInput):
    """
    Provides a command input to get a string value from the user.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> StringValueCommandInput:
        return StringValueCommandInput()
    @property
    def value(self) -> str:
        """
        Gets or sets the value of this input.
        """
        return str()
    @value.setter
    def value(self, value: str):
        """
        Gets or sets the value of this input.
        """
        pass
    @property
    def isPassword(self) -> bool:
        """
        Gets or sets if this string input behaves as a password field.
        This defaults to false for a newly created StringValueCommandInput.
        If true, dots are displayed instead of the actual characters but
        the value property will get and set the actual string.
        """
        return bool()
    @isPassword.setter
    def isPassword(self, value: bool):
        """
        Gets or sets if this string input behaves as a password field.
        This defaults to false for a newly created StringValueCommandInput.
        If true, dots are displayed instead of the actual characters but
        the value property will get and set the actual string.
        """
        pass
    @property
    def isReadOnly(self) -> bool:
        """
        Gets and sets if the string value is read-only or not. If it is read-only the user
        cannot edit the text. This property is initialized to False for a newly created
        StringValueCommandInput object.
        """
        return bool()
    @isReadOnly.setter
    def isReadOnly(self, value: bool):
        """
        Gets and sets if the string value is read-only or not. If it is read-only the user
        cannot edit the text. This property is initialized to False for a newly created
        StringValueCommandInput object.
        """
        pass
    @property
    def isValueError(self) -> bool:
        """
        Specifies if the current value shown is valid or not. Any string is valid for a
        StringValueCommandInput, but you many have some criteria that the string needs
        to meet for it to be valid in your application. You use the command's validateInputs
        event to verify that inputs are valid and control whether the "OK" button is enabled
        or not, and you can also set this property on specific StringValueCommandInputs objects
        to indicate to the user that a specific value is not correct. When this property is
        true, Fusion 360 will change the color of the text to red to indicate to the user there is
        a problem.
        """
        return bool()
    @isValueError.setter
    def isValueError(self, value: bool):
        """
        Specifies if the current value shown is valid or not. Any string is valid for a
        StringValueCommandInput, but you many have some criteria that the string needs
        to meet for it to be valid in your application. You use the command's validateInputs
        event to verify that inputs are valid and control whether the "OK" button is enabled
        or not, and you can also set this property on specific StringValueCommandInputs objects
        to indicate to the user that a specific value is not correct. When this property is
        true, Fusion 360 will change the color of the text to red to indicate to the user there is
        a problem.
        """
        pass

class TabCommandInput(CommandInput):
    """
    Tab command inputs contain a set of command inputs and/or group command inputs/
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TabCommandInput:
        return TabCommandInput()
    def activate(self) -> bool:
        """
        Sets this to be the currently activated (selected) tab.
        Returns true if the TabCommandInput was successfully activated.
        """
        return bool()
    @property
    def children(self) -> CommandInputs:
        """
        Gets the CommandInputs collection for this TabCommandInput.
        Use the add methods on this collection to add child CommandInputs to this Tab in the desired order.
        """
        return CommandInputs()
    @property
    def resourceFolder(self) -> str:
        """
        Gets the folder that contains the image for the tab. If no name is specified (no text on tab),
        a resourceFolder containing the image to appear on the tab needs to be provided.
        """
        return str()
    @property
    def isActive(self) -> bool:
        """
        Gets if this is the currently activated (selected) tab.
        """
        return bool()

class TableCommandInput(CommandInput):
    """
    Represents a table within a command dialog. The table consists of
    rows and columns where each cell can contain another command input. The
    selection and button row command inputs cannot be used within a table.
    In addition to the rows and columns, each table can optionally have a
    toolbar of seperate command inputs that is shown at the bottom of the table.
    
    A table command input can conceptually be compared to an Excel table where you
    have an infinite number of rows and columns available but use a small portion.
    As you add inputs to the table, the table will adjust so all used columns are
    visible. The visible number of rows is controlled by you and if you create
    more rows than can be displayed a scroll bar becomes available.
    
    For an example of this command input, see the loft command which uses it to show
    the selected profiles and rails.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TableCommandInput:
        return TableCommandInput()
    def deleteRow(self, row: int) -> bool:
        """
        Deletes the specified row. The following rows will be shifted up. The row and the
        command inputs it contains are deleted. To temporarily hide a row you can set the
        visibility of all of the command inputs it contains to be invisible. If all inputs
        are invisible the row will automatically be hidden.
        row : The row to delete where valid values are 0 to the number of rows minus 1. A value of
        0 will delete the first row. A value greater than the number of rows will delete the
        last row.
        Returns true if the delete was successful.
        """
        return bool()
    def addCommandInput(self, input: CommandInput, row: int, column: int, rowSpan: int, columnSpan: int) -> bool:
        """
        Adds a command input to a particular cell in the table. Rows are automatically added to the table to
        able to contain the command input. The command input can span multiple columns within a row and spanning
        across multiple rows is not currently supported.
        
        The command input is created in the standard way but when it's added to the table using this method it
        will be displayed in the table instead of the main area of the dialog.
        input : The command input to associate to a cell. The command input is created in the standard way but when it's added to
        the table using this method it will be displayed in the table instead of the main area of the dialog.
        row : The row index of the cell where 0 is the first row.
        column : The column index of the cell where 0 is the first column.
        rowSpan : The number of additional rows that this input uses. The default value of 0 indicates that no additional
        rows are used. Row spanning is not currently supported so this value must always be 0.
        columnSpan : The number of additional columns that this input uses. The default value of 0 indicates that no additional
        columns are used.
        Returns true if the association of the command input to the cell was successful.
        """
        return bool()
    def removeInput(self, row: int, column: int) -> bool:
        """
        Removes the command input that is at the specified row and column. This doesn't delete the command input from
        the collection of inputs associated with the command but just removes it from being displayed in the table.
        row : The row where the command input to be removed is located.
        column : The row where the command input to be removed is located.
        Returns true if the removal was successful.
        """
        return bool()
    def getPosition(self, input: CommandInput) -> tuple[bool, int, int, int, int]:
        """
        Gets the position of the specified command input within the table.
        input : The existing command input you want to find the associated cell for.
        row : The returned row index of the cell.
        column : The returned column index of the cell.
        rowSpan : The returned number of additional rows used by the input. A value of 0
        indicates that no additional rows are used.
        columnSpan : The returned number of additional columns used by the input. A value of 0
        indicates that no additional columns are used.
        Returns true if the position was successfully returned.
        """
        return (bool(), int(), int(), int(), int())
    def clear(self) -> bool:
        """
        Removes all rows in the table and the toolbar.
        Returns true if successful.
        """
        return bool()
    def addToolbarCommandInput(self, input: CommandInput) -> bool:
        """
        Adds a new command input to the toolbar at the bottom of the table.
        input : Adds a command input to the toolbar at the bottom of the table. The inputs are displayed
        in the same order that they're added.
        
        The command input is created in the standard way but when it's added to the table using this method it
        will be displayed in the table instead of the main area of the dialog.
        Returns true if the command input was successfully added.
        """
        return bool()
    def getInputAtPosition(self, row: int, column: int) -> CommandInput:
        """
        Returns the command input that is in the specified row and column. In the case
        where a command input spans multiple columns, the same input can be returned
        from multiple positions.
        row : The row index to return the command input from where the first row is 0.
        column : The row index to return the command input from where the first row is 0.
        Returns the command input that is in the specified row and column. If there
        isn't a command input in the specified location, null is returned.
        """
        return CommandInput()
    @property
    def numberOfColumns(self) -> int:
        """
        Returns the current number of visible columns displayed. Setting this property
        has no effect because the number of columns is automatically inferred by
        the command inputs that have been added to the table. The table automatically
        adjusts the number of rows displayed so all inputs can be seen.
        """
        return int()
    @numberOfColumns.setter
    def numberOfColumns(self, value: int):
        """
        Returns the current number of visible columns displayed. Setting this property
        has no effect because the number of columns is automatically inferred by
        the command inputs that have been added to the table. The table automatically
        adjusts the number of rows displayed so all inputs can be seen.
        """
        pass
    @property
    def columnRatio(self) -> str:
        """
        Gets and sets the width ratio of the columns. This is defined using a string
        such as "1:1:1" where this defines that the first three columns are all the same width.
        A value of "2:1" defines that the first column is twice the width of the second.
        
        If the table has more columns than are defined by this property, they will automatically
        default to a value of 1. If this property defines the width of more columns than are
        displayed, the extra definitions are ignored.
        
        You can also specify 0 as a column width and this will have the effect of hiding
        that column. Setting a column width to 0 does not delete the column or the command inputs
        but only hides them so they can be turned back on at a later time by resetting the
        column ratio.
        """
        return str()
    @columnRatio.setter
    def columnRatio(self, value: str):
        """
        Gets and sets the width ratio of the columns. This is defined using a string
        such as "1:1:1" where this defines that the first three columns are all the same width.
        A value of "2:1" defines that the first column is twice the width of the second.
        
        If the table has more columns than are defined by this property, they will automatically
        default to a value of 1. If this property defines the width of more columns than are
        displayed, the extra definitions are ignored.
        
        You can also specify 0 as a column width and this will have the effect of hiding
        that column. Setting a column width to 0 does not delete the column or the command inputs
        but only hides them so they can be turned back on at a later time by resetting the
        column ratio.
        """
        pass
    @property
    def hasGrid(self) -> bool:
        """
        Gets and sets whether a grid is displayed for the table. For a newly created
        table, this property defaults to false.
        """
        return bool()
    @hasGrid.setter
    def hasGrid(self, value: bool):
        """
        Gets and sets whether a grid is displayed for the table. For a newly created
        table, this property defaults to false.
        """
        pass
    @property
    def rowSpacing(self) -> int:
        """
        Gets and sets the spacing between rows. This is defined in pixels. For a newly
        created table, this property defaults to 1.
        """
        return int()
    @rowSpacing.setter
    def rowSpacing(self, value: int):
        """
        Gets and sets the spacing between rows. This is defined in pixels. For a newly
        created table, this property defaults to 1.
        """
        pass
    @property
    def columnSpacing(self) -> int:
        """
        Gets and sets the spacing between columns. This is defined in pixels. For a newly
        created table, this property defaults to 1.
        """
        return int()
    @columnSpacing.setter
    def columnSpacing(self, value: int):
        """
        Gets and sets the spacing between columns. This is defined in pixels. For a newly
        created table, this property defaults to 1.
        """
        pass
    @property
    def minimumVisibleRows(self) -> int:
        """
        Gets and sets the minimum number of rows displayed. This is the minimum amount of
        space taken up on the command dialog, even if the table doesn't yet contain any
        rows. For a newly created table, this property defaults to 2.
        """
        return int()
    @minimumVisibleRows.setter
    def minimumVisibleRows(self, value: int):
        """
        Gets and sets the minimum number of rows displayed. This is the minimum amount of
        space taken up on the command dialog, even if the table doesn't yet contain any
        rows. For a newly created table, this property defaults to 2.
        """
        pass
    @property
    def maximumVisibleRows(self) -> int:
        """
        Gets and sets the maximum number of rows that can be displayed. As rows are added
        the visible size of the table will grow to show all rows until this maximum number
        of rows is reached and then a scroll bar will be displayed to allow the user to
        access all rows. For a new created table, this property defaults to 4.
        """
        return int()
    @maximumVisibleRows.setter
    def maximumVisibleRows(self, value: int):
        """
        Gets and sets the maximum number of rows that can be displayed. As rows are added
        the visible size of the table will grow to show all rows until this maximum number
        of rows is reached and then a scroll bar will be displayed to allow the user to
        access all rows. For a new created table, this property defaults to 4.
        """
        pass
    @property
    def tablePresentationStyle(self) -> TablePresentationStyles:
        """
        Gets and sets the presentation style the table is currently using for its display.
        """
        return TablePresentationStyles()
    @tablePresentationStyle.setter
    def tablePresentationStyle(self, value: TablePresentationStyles):
        """
        Gets and sets the presentation style the table is currently using for its display.
        """
        pass
    @property
    def rowCount(self) -> int:
        """
        Returns the number of rows in the table. The actual number of rows in the table is defined
        by the number of rows that contain command inputs.
        """
        return int()
    @property
    def selectedRow(self) -> int:
        """
        Gets and sets which row is selected in the user-interface. A value of 0 indicates
        that the first row is selected. A value of -1 indicates that no row is selected.
        """
        return int()
    @selectedRow.setter
    def selectedRow(self, value: int):
        """
        Gets and sets which row is selected in the user-interface. A value of 0 indicates
        that the first row is selected. A value of -1 indicates that no row is selected.
        """
        pass

class TextBoxCommandInput(CommandInput):
    """
    Provides a command input to interact with a text box.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TextBoxCommandInput:
        return TextBoxCommandInput()
    @property
    def formattedText(self) -> str:
        """
        Gets and sets the formatted text displayed in the dialog. Formatted text includes
        any html formatting that has been defined. For example, you can use basic html formatting such as
        <b>Bold</b>, <i>Italic</i>, and <br /> for a line break.
        """
        return str()
    @formattedText.setter
    def formattedText(self, value: str):
        """
        Gets and sets the formatted text displayed in the dialog. Formatted text includes
        any html formatting that has been defined. For example, you can use basic html formatting such as
        <b>Bold</b>, <i>Italic</i>, and <br /> for a line break.
        """
        pass
    @property
    def text(self) -> str:
        """
        Gets and sets the text in the text box. This returns the string
        as seen in the text box with any formatting stripped out.
        """
        return str()
    @text.setter
    def text(self, value: str):
        """
        Gets and sets the text in the text box. This returns the string
        as seen in the text box with any formatting stripped out.
        """
        pass
    @property
    def numRows(self) -> int:
        """
        Gets and sets the height of the text box as defined by the number of rows of
        text that can be displayed. If the text is larger than will fit in the box
        a scroll bar will automatically be displayed.
        """
        return int()
    @numRows.setter
    def numRows(self, value: int):
        """
        Gets and sets the height of the text box as defined by the number of rows of
        text that can be displayed. If the text is larger than will fit in the box
        a scroll bar will automatically be displayed.
        """
        pass
    @property
    def isReadOnly(self) -> bool:
        """
        Gets and sets if the text box is read-only or not. If it is read-only the user
        cannot edit the text.
        """
        return bool()
    @isReadOnly.setter
    def isReadOnly(self, value: bool):
        """
        Gets and sets if the text box is read-only or not. If it is read-only the user
        cannot edit the text.
        """
        pass

class TextCommandPalette(Palette):
    """
    <p class="api">Represents the palette that is the Text Command window in Fusion 360. You can obtain the Text Command palette by using the itemById method of the Palettes object and using "TextCommands" as the ID. Below is some sample code that illustrates making sure the palette is visible and writing some text to it.</p>
    <pre class="api-code"><span style = "color:blue" ># Get the palette that represents the TEXT COMMANDS window.</span>
    textPalette = ui.palettes.itemById('TextCommands')
    
    <span style = "color:blue"># Make sure the palette is visible.</span>
    if not textPalette.isVisible:
    textPalette.isVisible = True
    
    <span style= "color:blue" ># Write some text.</span>
    textPalette.writeText('This is a text message.') </pre>
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> TextCommandPalette:
        return TextCommandPalette()
    def writeText(self, text: str) -> bool:
        """
        <p class="api">Write the specified text to the TEXT COMMAND window. Below is some sample code that illustrates making sure the palette is visible and writing some text to it.</p>
        <pre class="api-code"><span style = "color:blue" ># Get the palette that represents the TEXT COMMANDS window.</span>
        textPalette = ui.palettes.itemById('TextCommands')
        
        <span style = "color:blue"># Make sure the palette is visible.</span>
        if not textPalette.isVisible:
        textPalette.isVisible = True
        
        <span style= "color:blue" ># Write some text.</span>
        textPalette.writeText('This is a text message.') </pre>
        text : The text to write to the Text Command window.
        Returns true if successful.
        """
        return bool()

class Torus(Surface):
    """
    Transient torus. A transient torus is not displayed or saved in a document.
    A transient torus is used as a wrapper to work with raw torus information.
    A transient torus is a full torus with no boundaries.
    They are created statically using the create method of the Torus class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Torus:
        return Torus()
    @staticmethod
    def create(origin: Point3D, axis: Vector3D, majorRadius: float, minorRadius: float) -> Torus:
        """
        Creates a transient torus object.
        origin : The origin point (center) of the torus.
        axis : The center axis of the torus.
        majorRadius : The major radius of the torus.
        minorRadius : The minor radius of the torus.
        Returns the new Torus object or null if the creation failed.
        """
        return Torus()
    def getData(self) -> tuple[bool, Point3D, Vector3D, float, float]:
        """
        Gets all of the data defining the torus.
        origin : The output origin point (center) of the torus.
        axis : The output center axis of the torus.
        majorRadius : The output major radius of the torus.
        minorRadius : The output minor radius of the torus.
        Returns true if successful.
        """
        return (bool(), Point3D(), Vector3D(), float(), float())
    def set(self, origin: Point3D, axis: Vector3D, majorRadius: float, minorRadius: float) -> bool:
        """
        Sets all of the data defining the torus.
        origin : The origin point (center) of the torus.
        axis : The center axis of the torus.
        majorRadius : The major radius of the torus.
        minorRadius : The minor radius of the torus.
        Returns true if successful.
        """
        return bool()
    def copy(self) -> Torus:
        """
        Creates and returns an independent copy of this Torus object.
        Returns a new Torus object that is a copy of this Torus object.
        """
        return Torus()
    @property
    def origin(self) -> Point3D:
        """
        Gets and sets the origin point (center) of the torus.
        """
        return Point3D()
    @origin.setter
    def origin(self, value: Point3D):
        """
        Gets and sets the origin point (center) of the torus.
        """
        pass
    @property
    def axis(self) -> Vector3D:
        """
        Gets and sets the center axis of the torus.
        """
        return Vector3D()
    @axis.setter
    def axis(self, value: Vector3D):
        """
        Gets and sets the center axis of the torus.
        """
        pass
    @property
    def majorRadius(self) -> float:
        """
        Gets and sets the major radius of the torus.
        """
        return float()
    @majorRadius.setter
    def majorRadius(self, value: float):
        """
        Gets and sets the major radius of the torus.
        """
        pass
    @property
    def minorRadius(self) -> float:
        """
        Gets and sets the minor radius of the torus.
        """
        return float()
    @minorRadius.setter
    def minorRadius(self, value: float):
        """
        Gets and sets the minor radius of the torus.
        """
        pass

class UserInterfaceGeneralEvent(Event):
    """
    A UserInterfaceGeneralEvent is used for user-interface related events that don't
    require any additional information beyond getting the event itself.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> UserInterfaceGeneralEvent:
        return UserInterfaceGeneralEvent()
    def add(self, handler: UserInterfaceGeneralEventHandler) -> bool:
        """
        Add a handler to be notified when the event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: UserInterfaceGeneralEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class UserInterfaceGeneralEventArgs(EventArgs):
    """
    The UserInterfaceGeneralEventArgs is passed when a UserInterfaceGeneralEvent is fired.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> UserInterfaceGeneralEventArgs:
        return UserInterfaceGeneralEventArgs()

class ValidateInputsEvent(Event):
    """
    An event endpoint that supports the connection to client implemented ValidateInputsEventHandlers.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ValidateInputsEvent:
        return ValidateInputsEvent()
    def add(self, handler: ValidateInputsEventHandler) -> bool:
        """
        Adds an event handler to this event endpoint.
        handler : The client implemented ValidateInputsEventHandler to be called when this event is triggered.
        Returns true if the handler was successfully added to the set of event handlers.
        """
        return bool()
    def remove(self, handler: ValidateInputsEventHandler) -> bool:
        """
        Removes a handler from this event endpoint.
        handler : A ValidateInputsEventHandler that was previously added to this event with the add method.
        Returns true if the handler was found and removed from the set of event handlers.
        """
        return bool()

class ValidateInputsEventArgs(EventArgs):
    """
    Provides a set of arguments from a firing ValidateInputsEvent to a ValidateInputsEventHandler's notify callback method.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ValidateInputsEventArgs:
        return ValidateInputsEventArgs()
    @property
    def areInputsValid(self) -> bool:
        """
        Used during the AreInputsValid event to get or set if all inputs are valid
        and the OK button should be enabled.
        """
        return bool()
    @areInputsValid.setter
    def areInputsValid(self, value: bool):
        """
        Used during the AreInputsValid event to get or set if all inputs are valid
        and the OK button should be enabled.
        """
        pass
    @property
    def inputs(self) -> CommandInputs:
        """
        Returns the collection of command inputs that are associated with the command this event is being fired for.
        """
        return CommandInputs()

class ValueCommandInput(CommandInput):
    """
    Provides a command input to get a unit based value from the user.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ValueCommandInput:
        return ValueCommandInput()
    @property
    def value(self) -> float:
        """
        Gets or sets the value associated with this input. The value is always in
        the database units of the unit type specified. For example, if the unit type is "inch"
        this value is in centimeters since centimeters are the database length unit. When setting the
        value it is converted into a string using the unit type and displayed in the input box.
        When getting the value, the current expression string is evaluated and the database value
        for the unit type is returned.
        
        The isValidExpression property should be checked before using this
        value within the command because if the expression can't be evaluated
        there isn't a valid value. Fusion 360 won't allow the execution of a command
        that contains ValueCommandInput object with invalid expressions so you can
        dependably use the value in the execute event of the command.
        """
        return float()
    @value.setter
    def value(self, value: float):
        """
        Gets or sets the value associated with this input. The value is always in
        the database units of the unit type specified. For example, if the unit type is "inch"
        this value is in centimeters since centimeters are the database length unit. When setting the
        value it is converted into a string using the unit type and displayed in the input box.
        When getting the value, the current expression string is evaluated and the database value
        for the unit type is returned.
        
        The isValidExpression property should be checked before using this
        value within the command because if the expression can't be evaluated
        there isn't a valid value. Fusion 360 won't allow the execution of a command
        that contains ValueCommandInput object with invalid expressions so you can
        dependably use the value in the execute event of the command.
        """
        pass
    @property
    def expression(self) -> str:
        """
        Gets or sets the expression displayed in the input field. This can contain equations and
        references to parameters. It is evaluated using the specified unit type.
        """
        return str()
    @expression.setter
    def expression(self, value: str):
        """
        Gets or sets the expression displayed in the input field. This can contain equations and
        references to parameters. It is evaluated using the specified unit type.
        """
        pass
    @property
    def unitType(self) -> str:
        """
        Gets and sets the unit type that is used when evaluating the user's input.
        """
        return str()
    @unitType.setter
    def unitType(self, value: str):
        """
        Gets and sets the unit type that is used when evaluating the user's input.
        """
        pass
    @property
    def isValidExpression(self) -> bool:
        """
        Returns true if the current expression is valid and can be evaluated. If this
        is false, the value returned should be ignored because there currently is
        not a valid value.
        """
        return bool()

class WebRequestEvent(Event):
    """
    A WebRequestEvent represents an event that occurs in reaction to a Fusion 360 protocol handler
    in a web page. For example, insertedFromURL and openedFromURL
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> WebRequestEvent:
        return WebRequestEvent()
    def add(self, handler: WebRequestEventHandler) -> bool:
        """
        Add a handler to be notified when the event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: WebRequestEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class WebRequestEventArgs(EventArgs):
    """
    The WebRequestEventArgs provides information associated with a web request event. These
    are events fired as a result of a Fusion 360 protocol handler being invoked from a web page.
    Note that some properties are not available on every event.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> WebRequestEventArgs:
        return WebRequestEventArgs()
    @property
    def isCanceled(self) -> bool:
        """
        Used during the insertingFromURL and openingFromURL events to get or set
        if the insert or open should be allowed to continue. This defaults to false,
        which will allow the operation to continue as normal.
        This property should be ignored for all events besides the insertingFromURL and
        openingFromURL events.
        """
        return bool()
    @isCanceled.setter
    def isCanceled(self, value: bool):
        """
        Used during the insertingFromURL and openingFromURL events to get or set
        if the insert or open should be allowed to continue. This defaults to false,
        which will allow the operation to continue as normal.
        This property should be ignored for all events besides the insertingFromURL and
        openingFromURL events.
        """
        pass
    @property
    def file(self) -> str:
        """
        Returns the value specified as the "file" parameter in the URL.
        """
        return str()
    @property
    def properties(self) -> str:
        """
        Returns the value specified as the "properties" parameter in the URL. This
        will be decoded and should be in JSON format if it was properly provided
        by the web page. It can be an empty string if the "properties" parameter was
        not specified in the URL.
        """
        return str()
    @property
    def id(self) -> str:
        """
        Returns the value specified as the "id" parameter in the URL. This
        will be decoded. It can be an empty string if the "id" parameter was
        not specified in the URL.
        """
        return str()
    @property
    def privateInfo(self) -> str:
        """
        Returns the value specified as the "privateInfo" parameter in the URL. This
        will be decoded and can be an empty string if the "privateInfo" parameter was
        not specified in the URL.
        """
        return str()
    @property
    def occurrenceOrDocument(self) -> Base:
        """
        Used during the insertedFromURL or openedFromURL events and returns the Document (openedFromURL)
        or Occurrence (insertedFromURL) that was just created.
        """
        return Base()

class WorkspaceEvent(Event):
    """
    A WorkspaceEvent represents a workspace related event. For example, workspaceActivate or workspaceDeactivate.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> WorkspaceEvent:
        return WorkspaceEvent()
    def add(self, handler: WorkspaceEventHandler) -> bool:
        """
        Add a handler to be notified when the event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: WorkspaceEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class WorkspaceEventArgs(EventArgs):
    """
    The WorkspaceEventArgs provides information associated with a workspace event.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> WorkspaceEventArgs:
        return WorkspaceEventArgs()
    @property
    def workspace(self) -> Workspace:
        """
        Provides access to the workspace.
        """
        return Workspace()

class FloatSliderCommandInput(SliderCommandInput):
    """
    Provides a command input to get the value of a slider from the user, the value type is float.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FloatSliderCommandInput:
        return FloatSliderCommandInput()
    @property
    def valueOne(self) -> float:
        """
        Gets or sets the first value associated with this input. The value is always in
        the database units of the unit type specified. For example, if the unit type is "inch"
        this value is in centimeters since centimeters are the database length unit. When setting the
        value it is converted into a string using the unit type and displayed in the input box.
        """
        return float()
    @valueOne.setter
    def valueOne(self, value: float):
        """
        Gets or sets the first value associated with this input. The value is always in
        the database units of the unit type specified. For example, if the unit type is "inch"
        this value is in centimeters since centimeters are the database length unit. When setting the
        value it is converted into a string using the unit type and displayed in the input box.
        """
        pass
    @property
    def valueTwo(self) -> float:
        """
        Gets or sets the second value associated with this input. The value is always in
        the database units of the unit type specified. For example, if the unit type is "inch"
        this value is in centimeters since centimeters are the database length unit. When setting the
        value it is converted into a string using the unit type and displayed in the input box.
        
        This property is only available when the hasTwoSliders property returns true.
        """
        return float()
    @valueTwo.setter
    def valueTwo(self, value: float):
        """
        Gets or sets the second value associated with this input. The value is always in
        the database units of the unit type specified. For example, if the unit type is "inch"
        this value is in centimeters since centimeters are the database length unit. When setting the
        value it is converted into a string using the unit type and displayed in the input box.
        
        This property is only available when the hasTwoSliders property returns true.
        """
        pass
    @property
    def minimumValue(self) -> float:
        """
        Gets and sets minimum value of the slider in database units.
        Gets a failure when set if the value of this command input was added by value list.
        """
        return float()
    @minimumValue.setter
    def minimumValue(self, value: float):
        """
        Gets and sets minimum value of the slider in database units.
        Gets a failure when set if the value of this command input was added by value list.
        """
        pass
    @property
    def maximumValue(self) -> float:
        """
        Gets and sets maximum value of the slider in database units.
        Gets a failure when set if the value of this command input was added by value list.
        """
        return float()
    @maximumValue.setter
    def maximumValue(self, value: float):
        """
        Gets and sets maximum value of the slider in database units.
        Gets a failure when set if the value of this command input was added by value list.
        """
        pass
    @property
    def valueList(self) -> list[float]:
        """
        Gets the value list of the slider. This property is valid when this input represents a list type of slider command input.
        Otherwise an empty list will be returned.
        """
        return [float()]
    @property
    def spinStep(self) -> float:
        """
        Gets and sets the spin step value in the unit type set by the unitType argument.
        The value should be more than zero. This is the amount the slider will advance
        when the user clicks the spin button beside the value.
        """
        return float()
    @spinStep.setter
    def spinStep(self, value: float):
        """
        Gets and sets the spin step value in the unit type set by the unitType argument.
        The value should be more than zero. This is the amount the slider will advance
        when the user clicks the spin button beside the value.
        """
        pass

class IntegerSliderCommandInput(SliderCommandInput):
    """
    Provides a command input to get the value of a slider from the user, the value type is integer.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> IntegerSliderCommandInput:
        return IntegerSliderCommandInput()
    @property
    def valueOne(self) -> int:
        """
        Gets or sets the value associated with the first slider.
        """
        return int()
    @valueOne.setter
    def valueOne(self, value: int):
        """
        Gets or sets the value associated with the first slider.
        """
        pass
    @property
    def valueTwo(self) -> int:
        """
        If the hasTwoSliders property is true, this returns the value associated with
        the second slider.
        """
        return int()
    @valueTwo.setter
    def valueTwo(self, value: int):
        """
        If the hasTwoSliders property is true, this returns the value associated with
        the second slider.
        """
        pass
    @property
    def minimumValue(self) -> int:
        """
        Gets and sets minimum value of the slider. This will fail if there is a value list because the
        minimum and maximum values are defined by the value list.
        """
        return int()
    @minimumValue.setter
    def minimumValue(self, value: int):
        """
        Gets and sets minimum value of the slider. This will fail if there is a value list because the
        minimum and maximum values are defined by the value list.
        """
        pass
    @property
    def maximumValue(self) -> int:
        """
        Gets and sets maximum value of the slider. This will fail if there is a value list because the
        minimum and maximum values are defined by the value list.
        """
        return int()
    @maximumValue.setter
    def maximumValue(self, value: int):
        """
        Gets and sets maximum value of the slider. This will fail if there is a value list because the
        minimum and maximum values are defined by the value list.
        """
        pass
    @property
    def valueList(self) -> list[int]:
        """
        Gets the value list of the slider. The list is empty if this command input was not added by value list.
        """
        return [int()]
    @property
    def spinStep(self) -> int:
        """
        Gets and sets the spin step. This defines the amount the slider moves when the user clicks the spin
        button beside the value. The spin step should be more than zero.
        """
        return int()
    @spinStep.setter
    def spinStep(self, value: int):
        """
        Gets and sets the spin step. This defines the amount the slider moves when the user clicks the spin
        button beside the value. The spin step should be more than zero.
        """
        pass
