# This file is automatically generated for code intellisense only.
# It does not reflect the actual implementation.

from __future__ import annotations

from . import core
from . import fusion

class InspectionPointState():
    """
    Summarize state of measured inspection point.
    Compares the deviation from the nominal position, or the projected position
    (if using projection), to the contact position relative to the upper or lower tolerances.
    Further information can be found in the online help
    """
    def __init__(self):
        pass
    WithinTolerance = 0
    AboveTolerance = 1
    BelowTolerance = 2
    Unprojected = 3

class LibraryLocation():
    """
    List of locations representing folders in the library dialogs.
    """
    def __init__(self):
        pass
    Local = 0
    Cloud = 1
    Network = 2
    OnlineSamples = 3
    External = 4

class MachineAxisTypes():
    """
    List of machine axis types for MachineAxis
    """
    def __init__(self):
        pass
    LinearMachineAxisType = 0
    RotaryMachineAxisType = 1

class MachinePartTypes():
    """
    List of part types for MachinePart
    """
    def __init__(self):
        pass
    BasicMachinePartType = 0
    AxisMachinePartType = 1
    ToolAttachmentMachinePartType = 2
    FixtureAttachmentMachinePartType = 3

class MachineTemplate():
    """
    List of the machine templates to create a machine from.
    """
    def __init__(self):
        pass
    GenericLathe = 0
    Generic3Axis = 1
    Generic4Axis = 2
    Generic5AxisHeadHead = 3
    Generic5AxisHeadTable = 4
    Generic5AxisTableTable = 5

class OperationStates():
    """
    The possible states of an operation
    """
    def __init__(self):
        pass
    IsValidOperationState = 0
    IsInvalidOperationState = 1
    SuppressedOperationState = 2
    NoToolpathOperationState = 3

class OperationStrategyTypes():
    """
    The valid options for the Strategy Type of an operation.
    """
    def __init__(self):
        pass
    AdaptiveClearing2D = 0
    Pocket2D = 1
    Face = 2
    Contour2D = 3
    Slot = 4
    Trace = 5
    Thread = 6
    Bore = 7
    Circular = 8
    Engrave = 9
    AdaptiveClearing = 10
    PocketClearing = 11
    Parallel = 12
    Contour = 13
    Ramp = 14
    Horizontal = 15
    Pencil = 16
    Scallop = 17
    Spiral = 18
    Radial = 19
    MorphedSpiral = 20
    Projection = 21
    Drilling = 22
    Jet2D = 23
    TurningChamfer = 24
    TurningFace = 25
    TurningGroove = 26
    TurningPart = 27
    TurningProfile = 28
    TurningProfileGroove = 29
    TurningStockTransfer = 30
    TurningThread = 31
    SteepAndShallow = 32
    Flow = 33
    RotaryFinishing = 34
    Chamfer2D = 35
    Morph = 36
    MultiAxisContour = 37
    MultiAxisMorph = 38
    RestFinishing = 39
    Swarf = 40
    SurfaceInspection = 41
    ManualInspection = 42
    ProbeWCS = 43
    ProbeGeometry = 44
    PartAlignment = 45
    PathMeasure = 46
    ManualMeasure = 47

class OperationTypes():
    """
    The valid options for the Operation Type of a Setup.
    """
    def __init__(self):
        pass
    MillingOperation = 0
    TurningOperation = 1
    JetOperation = 2
    AdditiveOperation = 3

class PostOutputUnitOptions():
    """
    List of the valid options for the outputUnit property on a PostProcessInput object .
    """
    def __init__(self):
        pass
    DocumentUnitsOutput = 0
    InchesOutput = 1
    MillimetersOutput = 2

class SetupChangeEventType():
    """
    List of setup change event types.
    """
    def __init__(self):
        pass
    Arbitrary = 0
    PrintSettingSelection = 1

class SetupSheetFormats():
    """
    List of the formats to choose from when generating setup sheets
    """
    def __init__(self):
        pass
    HTMLFormat = 0
    ExcelFormat = 1

class CAMExportManager(core.Base):
    """
    Export manager used to export the setup's models in one of the formats defined the the ExportOptions objects.
    The export is currently restricted to additive setups only and the availability of the export option and its settings depends on the chosen machine.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMExportManager:
        return CAMExportManager()
    def execute(self, exportOptions: CAMExportOptions) -> bool:
        """
        Executes an export based on the export options
        """
        return bool()
    def createFormlabsOptions(self) -> CAMFormlabsExportOptions:
        """
        Creates a new Formlabs export option.
        """
        return CAMFormlabsExportOptions()
    def create3MFOptions(self) -> CAM3MFExportOptions:
        """
        Creates a new 3MF export option.
        """
        return CAM3MFExportOptions()

class CAMExportOptions(core.Base):
    """
    Parent class for all ExportOptions objects giving access to the setup and file name used for the export.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMExportOptions:
        return CAMExportOptions()
    @property
    def fullFilename(self) -> str:
        """
        The file we want to export to. Needs to contain a valid path, as no intermediate folders are created.
        """
        return str()
    @fullFilename.setter
    def fullFilename(self, value: str):
        """
        The file we want to export to. Needs to contain a valid path, as no intermediate folders are created.
        """
        pass
    @property
    def exportObject(self) -> core.Base:
        """
        The export object we want to export. Depending on the actual export option, this might be geometry, an operation or a setup.
        """
        return core.Base()
    @exportObject.setter
    def exportObject(self, value: core.Base):
        """
        The export object we want to export. Depending on the actual export option, this might be geometry, an operation or a setup.
        """
        pass

class CAMFolders(core.Base):
    """
    Collection that provides access to the folders within an existing setup, folder or pattern.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMFolders:
        return CAMFolders()
    def item(self, index: int) -> CAMFolder:
        """
        Function that returns the specified folder using an index into the collection.
        index : The index of the item within the collection to return.  The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CAMFolder()
    def itemByName(self, name: str) -> CAMFolder:
        """
        Returns the folder with the specified name (as appears in the browser).
        name : The name (as it appears in the browser) of the folder.
        Returns the specified folder or null in the case where there is no folder with the specified name.
        """
        return CAMFolder()
    def itemByOperationId(self, id: int) -> CAMFolder:
        """
        Returns the folder with the specified operation id.
        id : The id of the folder.
        Returns the specified folder or null in the case where there is no folder with the specified operation id.
        """
        return CAMFolder()
    @property
    def count(self) -> int:
        """
        The number of items in the collection.
        """
        return int()

class CAMInspectionResults(core.Base):
    """
    Collection that provides access to the Measures in a results folder.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMInspectionResults:
        return CAMInspectionResults()
    def item(self, index: int) -> CAMMeasure:
        """
        Function that returns the specified measure using an index into the collection.
        index : The index of the item within the collection to return.  The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CAMMeasure()
    def itemByName(self, name: str) -> CAMMeasure:
        """
        Returns the measure with the specified name (as appears in the browser).
        name : The name (as it appears in the browser) of the measure.
        Returns the specified measure or null in the case where there is no measure with the specified name.
        """
        return CAMMeasure()
    @property
    def count(self) -> int:
        """
        The number of measures in the collection.
        """
        return int()

class CAMLibraryManager(core.Base):
    """
    CAMLibraryManager provides access to properties related to various libraries in the
    Fusion 360 Manufacture workspace, such as the post library and machine library.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMLibraryManager:
        return CAMLibraryManager()
    @property
    def fusion360PostFolder(self) -> str:
        """
        Gets the absolute path to the folder containing Fusion 360 posts. Fusion 360 posts
        appear in the post library under the Fusion 360 tab.
        """
        return str()
    @property
    def localPostFolder(self) -> str:
        """
        Gets the absolute path to the folder containing local posts. Local posts appear
        in post library under the local tab.
        """
        return str()
    @property
    def fusion360MachineFolder(self) -> str:
        """
        Gets the absolute path to the folder containing Fusion 360 machines. Fusion 360
        machines appear in the machine library under the Fusion 360 tab.
        """
        return str()
    @property
    def localMachineFolder(self) -> str:
        """
        Gets the absolute path to the folder containing local machines. Local Machines appear
        in machine library under the local tab.
        """
        return str()
    @property
    def networkMachineFolder(self) -> str:
        """
        Gets the absolute path to the folder containing network machines. Network machines
        appear in the machine library under the network tab.
        """
        return str()

class CAMManager(core.Base):
    """
    This singleton object provides access to application-level events and properties
    that relate to the CAM (Manufacture) workspace in Fusion 360.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMManager:
        return CAMManager()
    @staticmethod
    def get() -> CAMManager:
        """
        Access to the root CAMManager object.
        Return the root CAMManager object or null if it failed.
        """
        return CAMManager()
    @property
    def libraryManager(self) -> CAMLibraryManager:
        """
        CAMLibraryManager provides access to properties related to various libraries in the
        Fusion 360 Manufacture workspace, such as the post library and machine library.
        Return a CAMLibraryManager object or null if it failed.
        """
        return CAMLibraryManager()
    @property
    def postEnginePath(self) -> str:
        """
        Gets the absolute path to the post engine (post.exe) installed with Fusion 360.
        """
        return str()
    @property
    def networkMachineIntegrationManager(self) -> NetworkMachineIntegrationManager:
        """
        NetworkMachineIntegrationManager provides access to properties and events needed to
        integrate addins into the 'Find network machines' dialog, which enables users to add
        machine configurations representing machines on the network to their machine library.
        Return a NetworkMachineIntegrationManager object or null if it failed.
        """
        return NetworkMachineIntegrationManager()

class CAMMeasure(core.Base):
    """
    Object that represents a Measure folder.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMMeasure:
        return CAMMeasure()
    @property
    def inspectionPathResults(self) -> InspectionPathResults:
        """
        Access all the surface inspection results from a measure
        return a collection of surface inspection results from a measure or null if none found
        """
        return InspectionPathResults()

class CAMParameter(core.Base):
    """
    Base class for representing parameter of an operation.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMParameter:
        return CAMParameter()
    @property
    def name(self) -> str:
        """
        Gets the name (internal name) of the parameter.
        """
        return str()
    @property
    def title(self) -> str:
        """
        Returns the title of this parameter as seen in the user interface.
        This title is localized and can change based on the current language
        """
        return str()
    @property
    def expression(self) -> str:
        """
        Gets and sets the value expression of the parameter.
        """
        return str()
    @expression.setter
    def expression(self, value: str):
        """
        Gets and sets the value expression of the parameter.
        """
        pass
    @property
    def isEnabled(self) -> bool:
        """
        Gets if this parameter is enabled.  Some parameters are enabled/disabled depending on the values
        set for other parameters.
        """
        return bool()
    @property
    def error(self) -> str:
        """
        Returns a message corresponding to any active error associated with the value of this parameter.
        """
        return str()
    @property
    def warning(self) -> str:
        """
        Returns a message corresponding to any active warning associated with the value of this parameter.
        """
        return str()
    @property
    def isEditable(self) -> bool:
        """
        Returns whether or not the parameter's expression or value can be modified.
        """
        return bool()
    @property
    def value(self) -> ParameterValue:
        """
        Returns an object that allows you to get and set the value associated with the parameter.
        Within CAM operations, floating point values (via FloatParameterValue) are returned
        and set using a standardized set of "internal" units, rather than using the document units.
        The units used depend on the type of parameter. For reference, the units used are:
        Length - centimeters (cm)
        Angle - radians (rad)
        Linear velocity - millimeters/minute (mm/min)
        Rotational velocity - revolutions per minute (rpm)
        Time - seconds (s)
        Weight - kilograms (kg)
        Power - Watts (W)
        Flow rate - liters/minute (l/min)
        Area - square centimeters (cm²)
        Volume - cubic centimeters (cm³)
        Temperature - degrees celsius (C)
        """
        return ParameterValue()

class CAMParameters(core.Base):
    """
    Collection that provides access to the parameters of an existing operation.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMParameters:
        return CAMParameters()
    def item(self, index: int) -> CAMParameter:
        """
        Function that returns the specified parameter using an index into the collection.
        index : The index of the item within the collection to return.  The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CAMParameter()
    def itemByName(self, internalName: str) -> CAMParameter:
        """
        Returns the parameter of the specified id (internal name).
        internalName : The id (internal name) of the parameter.
        Returns the specified parameter or null in the case where there is no parameter with the specified id.
        """
        return CAMParameter()
    @property
    def count(self) -> int:
        """
        The number of items in the collection.
        """
        return int()

class CAMPatterns(core.Base):
    """
    Collection that provides access to the patterns within an existing setup, folder or pattern.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMPatterns:
        return CAMPatterns()
    def item(self, index: int) -> CAMPattern:
        """
        Function that returns the specified pattern using an index into the collection.
        index : The index of the item within the collection to return.  The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return CAMPattern()
    def itemByName(self, name: str) -> CAMPattern:
        """
        Returns the pattern with the specified name (as appears in the browser).
        name : The name (as it appears in the browser) of the pattern.
        Returns the specified pattern or null in the case where there is no pattern with the specified name.
        """
        return CAMPattern()
    def itemByOperationId(self, id: int) -> CAMPattern:
        """
        Returns the pattern with the specified operation id.
        id : The id of the pattern.
        Returns the specified pattern or null in the case where there is no pattern with the specified operation id.
        """
        return CAMPattern()
    @property
    def count(self) -> int:
        """
        The number of items in the collection.
        """
        return int()

class ChildOperationList(core.Base):
    """
    Provides access to the collection of child operations, folders and patterns of an existing setup.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ChildOperationList:
        return ChildOperationList()
    def item(self, index: int) -> core.Base:
        """
        Returns the specified item using an index into the collection.
        index : The index of the item within the collection to return.  The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return core.Base()
    def itemByName(self, name: str) -> core.Base:
        """
        Returns the operation, folder or pattern with the specified name (the name seen in the browser).
        name : The name of the operation, folder or pattern as seen in the browser.
        Returns the specified item or null in the case where there is no item with the specified name.
        """
        return core.Base()
    def itemByOperationId(self, id: int) -> core.Base:
        """
        Returns the operation, folder or pattern with the specified operation id.
        id : The id of the operation, folder or pattern.
        Returns the specified item or null in the case where there is no item with the specified operation id.
        """
        return core.Base()
    @property
    def count(self) -> int:
        """
        Gets the number of objects in the collection.
        """
        return int()

class CreateMachineConfigurationsEventHandler(core.EventHandler):
    """
    Event handler for the CreateMachineConfigurationsEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CreateMachineConfigurationsEventHandler:
        return CreateMachineConfigurationsEventHandler()
    def notify(self, eventArgs: CreateMachineConfigurationsEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class GenerateToolpathFuture(core.Base):
    """
    Used to check the state and get back the results of toolpath generation.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> GenerateToolpathFuture:
        return GenerateToolpathFuture()
    @property
    def numberOfOperations(self) -> int:
        """
        Returns a number of operations need to be generated.
        """
        return int()
    @property
    def numberOfCompleted(self) -> int:
        """
        Returns a number of operations whose toolpath generation are completed.
        """
        return int()
    @property
    def operations(self) -> Operations:
        """
        Returns all operations that need to be generated.
        """
        return Operations()
    @property
    def isGenerationCompleted(self) -> bool:
        """
        Returns true if all operations are generated.
        """
        return bool()

class InspectionPathResult(core.Base):
    """
    Class to represent measured results from an surface inspection path.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> InspectionPathResult:
        return InspectionPathResult()
    @property
    def pointResults(self) -> InspectionPointResults:
        """
        return all the point results for the path.
        """
        return InspectionPointResults()

class InspectionPathResults(core.Base):
    """
    collection of inspection paths results.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> InspectionPathResults:
        return InspectionPathResults()
    def item(self, index: int) -> InspectionPathResult:
        """
        Function that returns the specified InspectionPathResult using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return InspectionPathResult()
    @property
    def count(self) -> int:
        """
        The number of InspectionPathResult in the collection.
        """
        return int()

class InspectionPointResult(core.Base):
    """
    Class to represent an inspection point's measured result.
    These are created as a result of probing a surface inspection path.
    For each point on the surface inspection path, the nominal position is
    the contact position on the CAD model. The measured 'contact point' is
    recorded when probing and a notional projected point can be calculated
    on the CAD model. The error is calculated as the deviation from the
    nominal over and above the tolerance.
    All values are in the Fusion's internal units which for positional and length values is CM.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> InspectionPointResult:
        return InspectionPointResult()
    @property
    def nominalPosition(self) -> core.Point3D:
        """
        get the nominal position of the inspection point.
        """
        return core.Point3D()
    @property
    def projectedPoint(self) -> core.Point3D:
        """
        get the projected position of the measured point.
        """
        return core.Point3D()
    @property
    def contact(self) -> core.Point3D:
        """
        get the contact position of the inspection point.
        """
        return core.Point3D()
    @property
    def offset(self) -> float:
        """
        get offset associated with the inspection point.
        """
        return float()
    @property
    def delta(self) -> core.Vector3D:
        """
        get the deviation vector of the measured point from nominal.
        """
        return core.Vector3D()
    @property
    def deviation(self) -> float:
        """
        get the deviation of the measured point.
        """
        return float()
    @property
    def error(self) -> float:
        """
        get the error of the measured point adjusting by the allowable tolerance.
        """
        return float()
    @property
    def state(self) -> InspectionPointState:
        """
        Get the state of the result.
        """
        return InspectionPointState()

class InspectionPointResults(core.Base):
    """
    collection of inspection point results
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> InspectionPointResults:
        return InspectionPointResults()
    def item(self, index: int) -> InspectionPointResult:
        """
        Function that returns the specified InspectionPointResult using an index into the collection.
        index : The index of the item within the collection to return. The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return InspectionPointResult()
    @property
    def count(self) -> int:
        """
        The number of InspectionPointResult in the collection.
        """
        return int()

class Machine(core.Base):
    """
    Object that represents a machine.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Machine:
        return Machine()
    @staticmethod
    def createFromTemplate(machineTemplate: MachineTemplate) -> Machine:
        """
        Creates a Machine from a template.
        machineTemplate : The template to act as a base for creating a machine from.
        Returns the newly created machine with a valid kinematics tree.
        """
        return Machine()
    @staticmethod
    def createFromFile(location: LibraryLocation, filePath: str) -> Machine:
        """
        Creates a Machine from a file.
        location : The location in the machine library.
        filePath : The path to a file to act as a base for creating a machine from.
        The path is relative to the library location given, unless library location is External,
        then the filePath is expected to be an absolute path.
        Returns the newly created machine with a valid kinematics tree.
        """
        return Machine()
    def save(self, location: LibraryLocation, filePath: str) -> bool:
        """
        Save the Machine to a file.
        Any subsequent edits will need to be saved again.
        location : The location in the machine library to save the machine to.
        filePath : The path of the file to save the machine as.
        The path is relative to the library location given, unless library location is External,
        then the filePath is expected to be an absolute path.
        .machine will be appended if no extension is given.
        Returns true if the machine was saved successfully, false otherwise.
        """
        return bool()
    @property
    def vendor(self) -> str:
        """
        Gets and sets the vendor name of the machine.
        """
        return str()
    @vendor.setter
    def vendor(self, value: str):
        """
        Gets and sets the vendor name of the machine.
        """
        pass
    @property
    def model(self) -> str:
        """
        Gets and sets the model name of the machine.
        """
        return str()
    @model.setter
    def model(self, value: str):
        """
        Gets and sets the model name of the machine.
        """
        pass
    @property
    def description(self) -> str:
        """
        Gets and sets the description of the machine.
        """
        return str()
    @description.setter
    def description(self, value: str):
        """
        Gets and sets the description of the machine.
        """
        pass
    @property
    def id(self) -> str:
        """
        Gets the unique identifier of the machine.
        Can be used for comparing machines within the document.
        """
        return str()
    @property
    def capabilities(self) -> MachineCapabilities:
        """
        Gets the capabilities of the machine.
        """
        return MachineCapabilities()
    @property
    def kinematics(self) -> MachineKinematics:
        """
        Gets the kinematics tree of the machine.
        """
        return MachineKinematics()

class MachineAxis(core.Base):
    """
    Abstract base class representing a single machine axis.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MachineAxis:
        return MachineAxis()
    @property
    def name(self) -> str:
        """
        The name of this axis.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        The name of this axis.
        """
        pass
    @property
    def axisType(self) -> MachineAxisTypes:
        """
        The type of axis.
        """
        return MachineAxisTypes()
    @property
    def hasLimits(self) -> bool:
        """
        Does this axis have a limited range of motion.
        """
        return bool()
    @property
    def physicalMin(self) -> float:
        """
        The minimum possible value for this axis (in mm/deg).
        Must be less than physicalMax.
        Set the value of this and physicalMax to 0 to remove
        axis limits.
        """
        return float()
    @physicalMin.setter
    def physicalMin(self, value: float):
        """
        The minimum possible value for this axis (in mm/deg).
        Must be less than physicalMax.
        Set the value of this and physicalMax to 0 to remove
        axis limits.
        """
        pass
    @property
    def physicalMax(self) -> float:
        """
        The maximum possible value for this axis (in mm/deg).
        Must be less than physicalMin.
        Set the value of this and physicalMin to 0 to remove
        axis limits.
        """
        return float()
    @physicalMax.setter
    def physicalMax(self, value: float):
        """
        The maximum possible value for this axis (in mm/deg).
        Must be less than physicalMin.
        Set the value of this and physicalMin to 0 to remove
        axis limits.
        """
        pass
    @property
    def homePosition(self) -> float:
        """
        Specifies the value (in mm/deg) that this axis returns to when the machine is homed.
        """
        return float()
    @homePosition.setter
    def homePosition(self, value: float):
        """
        Specifies the value (in mm/deg) that this axis returns to when the machine is homed.
        """
        pass

class MachineAxisInput(core.Base):
    """
    Object that defines the properties required to create a machine axis object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MachineAxisInput:
        return MachineAxisInput()
    @property
    def axisType(self) -> MachineAxisTypes:
        """
        The type of axis.
        This axis type determines which parameters of this object are valid to be accessed
        or modified.
        """
        return MachineAxisTypes()
    @property
    def name(self) -> str:
        """
        The user facing name of this axis.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        The user facing name of this axis.
        """
        pass
    @property
    def homePosition(self) -> float:
        """
        Specifies the value (in mm/deg) that this axis returns to when the machine is homed.
        """
        return float()
    @homePosition.setter
    def homePosition(self, value: float):
        """
        Specifies the value (in mm/deg) that this axis returns to when the machine is homed.
        """
        pass
    @property
    def physicalMin(self) -> float:
        """
        The minimum possible value for this axis (in mm/deg).
        Set the value of this and physicalMax to 0 to create an
        unlimited axis.
        """
        return float()
    @physicalMin.setter
    def physicalMin(self, value: float):
        """
        The minimum possible value for this axis (in mm/deg).
        Set the value of this and physicalMax to 0 to create an
        unlimited axis.
        """
        pass
    @property
    def physicalMax(self) -> float:
        """
        The maximum possible value for this axis (in mm/deg).
        Set the value of this and physicalMin to 0 to create an
        unlimited axis.
        """
        return float()
    @physicalMax.setter
    def physicalMax(self, value: float):
        """
        The maximum possible value for this axis (in mm/deg).
        Set the value of this and physicalMin to 0 to create an
        unlimited axis.
        """
        pass

class MachineCapabilities(core.Base):
    """
    Object that represents the capabilities of the machine.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MachineCapabilities:
        return MachineCapabilities()
    @property
    def isMillingSupported(self) -> bool:
        """
        Gets and sets if the machine is capable of subtractive milling.
        """
        return bool()
    @isMillingSupported.setter
    def isMillingSupported(self, value: bool):
        """
        Gets and sets if the machine is capable of subtractive milling.
        """
        pass
    @property
    def isTurningSupported(self) -> bool:
        """
        Gets and sets if the machine is capable of subtractive turning.
        """
        return bool()
    @isTurningSupported.setter
    def isTurningSupported(self, value: bool):
        """
        Gets and sets if the machine is capable of subtractive turning.
        """
        pass
    @property
    def isCuttingSupported(self) -> bool:
        """
        Gets and sets if the machine is capable of subtractive cutting.
        """
        return bool()
    @isCuttingSupported.setter
    def isCuttingSupported(self, value: bool):
        """
        Gets and sets if the machine is capable of subtractive cutting.
        """
        pass

class MachineDescription(core.Base):
    """
    A description of a machine used to preview machines in the 'Find network machines' dialog
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MachineDescription:
        return MachineDescription()
    @staticmethod
    def create(vendor: str, model: str, ipAddress: str) -> MachineDescription:
        """
        Creates a new MachineDescription.
        vendor : The machine vendor.
        model : The machine model.
        ipAddress : The machine's ipv4 ip address.
        Returns the newly created MachineDescription object, and allocates a unique id for the
        object, or null if the creation failed.
        """
        return MachineDescription()
    @property
    def id(self) -> int:
        """
        Gets this MachineDescription's unique id. This id can be used to match
        MachineDescription objects provided during the SearchNetworkMachinesEvent with those
        requested to create machine configurations for during the CreateMachineConfigurations
        event.
        """
        return int()
    @property
    def vendor(self) -> str:
        """
        Gets and sets the vendor name of the machine.
        """
        return str()
    @vendor.setter
    def vendor(self, value: str):
        """
        Gets and sets the vendor name of the machine.
        """
        pass
    @property
    def model(self) -> str:
        """
        Gets and sets the model name of the machine.
        """
        return str()
    @model.setter
    def model(self, value: str):
        """
        Gets and sets the model name of the machine.
        """
        pass
    @property
    def ipAddress(self) -> str:
        """
        Gets and sets the ip address of the machine.
        """
        return str()
    @ipAddress.setter
    def ipAddress(self, value: str):
        """
        Gets and sets the ip address of the machine.
        """
        pass
    @property
    def control(self) -> str:
        """
        Gets and sets the controller name of the machine. Controller info is not displayed if
        not set.
        """
        return str()
    @control.setter
    def control(self, value: str):
        """
        Gets and sets the controller name of the machine. Controller info is not displayed if
        not set.
        """
        pass
    @property
    def iconPath(self) -> str:
        """
        Gets and sets the absolute path to the 128x128 png image of the machine. A default
        image is used if not set.
        """
        return str()
    @iconPath.setter
    def iconPath(self, value: str):
        """
        Gets and sets the absolute path to the 128x128 png image of the machine. A default
        image is used if not set.
        """
        pass
    @property
    def serial(self) -> str:
        """
        Gets and sets the serial number of the machine. A serial number is not displayed if not
        set.
        """
        return str()
    @serial.setter
    def serial(self, value: str):
        """
        Gets and sets the serial number of the machine. A serial number is not displayed if not
        set.
        """
        pass

class MachineKinematics(core.Base):
    """
    Object that represents the kinematics tree in the machine.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MachineKinematics:
        return MachineKinematics()
    @property
    def parts(self) -> MachineParts:
        """
        Get the root parts collection.
        """
        return MachineParts()

class MachinePart(core.Base):
    """
    Object representing some part of a machine, such as the static base of the machine, an
    axis, or the attachment points for tools and fixtures.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MachinePart:
        return MachinePart()
    def deleteMe(self) -> None:
        """
        Delete this part and its children from the kinematics tree.
        """
        pass
    @property
    def children(self) -> MachineParts:
        """
        Get the collection of child parts.
        """
        return MachineParts()
    @property
    def parent(self) -> MachinePart:
        """
        Get or set the parent of this part.
        Setting the parent will add this part to the end of the parent's children
        collection. Setting the parent will throw an error if the new parent is this
        part or a child this part.
        """
        return MachinePart()
    @parent.setter
    def parent(self, value: MachinePart):
        """
        Get or set the parent of this part.
        Setting the parent will add this part to the end of the parent's children
        collection. Setting the parent will throw an error if the new parent is this
        part or a child this part.
        """
        pass
    @property
    def partType(self) -> MachinePartTypes:
        """
        Get the type of this part.
        """
        return MachinePartTypes()
    @property
    def id(self) -> str:
        """
        Get the internal ID of the part.
        This is unique with respect to other MachineParts in the Machine.
        """
        return str()
    @property
    def axis(self) -> MachineAxis:
        """
        Get the axis object for this part used to reference this part for other
        operations.
        Only valid when partType is Axis, otherwise returns null
        """
        return MachineAxis()

class MachinePartInput(core.Base):
    """
    Object representing the set of inputs required to create a new MachinePart.
    Set an MachineAxisInput object on this object's axisInput parameter to create
    a new MachineAxis with this part.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MachinePartInput:
        return MachinePartInput()
    def createAxisInput(self, axisType: MachineAxisTypes) -> MachineAxisInput:
        """
        Create a new MachineAxisInput object to be used to create a new MachineAxis.
        Set this object on to an axis type MachinePartInput to create a new MachineAxis
        with that part.
        axisType : The type of MachineAxisInput to create.
        Returns a LinearMachineAxisInput or RotaryMachineAxisInput, or null if the creation failed.
        """
        return MachineAxisInput()
    @property
    def id(self) -> str:
        """
        Get or set the internal ID of the part, used to reference this part for other
        operations. This ID can be any string.
        This must be unique with respect to other MachineParts in the Machine.
        """
        return str()
    @id.setter
    def id(self, value: str):
        """
        Get or set the internal ID of the part, used to reference this part for other
        operations. This ID can be any string.
        This must be unique with respect to other MachineParts in the Machine.
        """
        pass
    @property
    def partType(self) -> MachinePartTypes:
        """
        Get the type of part this input will create.
        """
        return MachinePartTypes()
    @property
    def axisInput(self) -> MachineAxisInput:
        """
        Get or Set an axis input object to create a new MachineAxis with this part.
        Only valid when partType is Axis.
        """
        return MachineAxisInput()
    @axisInput.setter
    def axisInput(self, value: MachineAxisInput):
        """
        Get or Set an axis input object to create a new MachineAxis with this part.
        Only valid when partType is Axis.
        """
        pass

class MachineParts(core.Base):
    """
    Object that represents a collection of machine parts.
    These parts are the children of another part or the collection of base parts from MachineKinematics
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MachineParts:
        return MachineParts()
    def add(self, partInput: MachinePartInput) -> MachinePart:
        """
        Add a new part to this collection. The part's parent will be set to the the owner of
        this collection, or null if this is the root parts collection.
        
        If the passed MachinePartInput has a MachineAxisInput a new MachineAxis will be created.
        partInput : Part input object used to create the new MachinePart.
        Returns the newly creted MachinePart or null if creation failed.
        """
        return MachinePart()
    def createPartInput(self, partType: MachinePartTypes) -> MachinePartInput:
        """
        Create a new MachinePartInput.
        partType : The type of part to create.
        When this parameter is Axis, you must set a value for axisInput.
        Returns the new MachinePartInput or null if creation failed.
        """
        return MachinePartInput()
    def item(self, index: int) -> MachinePart:
        """
        Get the part at index in this collection.
        index : The index of the part.
        The MachinePart at index.
        """
        return MachinePart()
    def itemById(self, id: str) -> MachinePart:
        """
        Get the part with the given ID.
        id : The ID for the part to get.
        Returns the MachinePart with the given ID, or null if the given ID does not
        match any part in the collection.
        """
        return MachinePart()
    @property
    def count(self) -> int:
        """
        Get the number of parts in this collection.
        """
        return int()

class MachiningTime(core.Base):
    """
    Object returned when using the getMachiningTime method from the CAM class.
    Use the properties on this object to get the machining time results.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> MachiningTime:
        return MachiningTime()
    @property
    def feedDistance(self) -> float:
        """
        Gets the feed distance in centimeters.
        """
        return float()
    @property
    def totalFeedTime(self) -> float:
        """
        Get the total feed time in seconds.
        """
        return float()
    @property
    def rapidDistance(self) -> float:
        """
        Gets the calculated rapid distance in centimeters.
        """
        return float()
    @property
    def totalRapidTime(self) -> float:
        """
        Gets the total rapid feed time in seconds.
        """
        return float()
    @property
    def toolChangeCount(self) -> int:
        """
        Gets the number of tool changes.
        """
        return int()
    @property
    def totalToolChangeTime(self) -> float:
        """
        Gets the total tool change time in seconds.
        """
        return float()
    @property
    def machiningTime(self) -> float:
        """
        Gets the machining time in seconds.
        """
        return float()

class NetworkMachineIntegrationInput(core.Base):
    """
    An input object required to register an addin for use in the 'Find network machines'
    dialog. This input object defines properties of an addin and allows an addin to
    customize its appearence in the 'Find network machines' dialog.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> NetworkMachineIntegrationInput:
        return NetworkMachineIntegrationInput()
    @staticmethod
    def create(displayName: str, description: str) -> NetworkMachineIntegrationInput:
        """
        displayName : The name that will be presented to the user in the 'Find network machines' dialog.
        description : A description of the addin which appears as a tooltip alongside the display name.
        Returns true if the addin was successfully registered.
        """
        return NetworkMachineIntegrationInput()
    @property
    def displayName(self) -> str:
        """
        Gets and sets the display name of the addin that appears in the 'vendor' dropdown in
        the 'Find network machines' dialog.
        """
        return str()
    @displayName.setter
    def displayName(self, value: str):
        """
        Gets and sets the display name of the addin that appears in the 'vendor' dropdown in
        the 'Find network machines' dialog.
        """
        pass
    @property
    def description(self) -> str:
        """
        Gets and sets the description of the addin
        """
        return str()
    @description.setter
    def description(self, value: str):
        """
        Gets and sets the description of the addin
        """
        pass

class NetworkMachineIntegrationManager(core.Base):
    """
    NetworkMachineManager provides access to properties and events needed to integrate
    addins into the 'Find network machines' dialog, which enables users to add machine
    configurations representing machines on the network to their machine library.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> NetworkMachineIntegrationManager:
        return NetworkMachineIntegrationManager()
    def registerNetworkMachineIntegration(self, networkMachineIntegrationInput: NetworkMachineIntegrationInput) -> bool:
        """
        Registers an addin for use in the 'Find network machines' dialog. This dialog will fire
        the SearchNetworkMachinesEvent and CreateMachineConfigurationsEvent, which the addin
        must handle. See SearchNetworkMachinesEvent and CreateMachineConfigurationsEvent for
        details.
        networkMachineIntegrationInput : An object defining properties of an addin, also allowing an addin to customize its
        appearence in the 'Find network machines' dialog.
        """
        return bool()
    @property
    def searchNetworkMachinesEvent(self) -> SearchNetworkMachinesEvent:
        """
        This event is fired from the 'Find network machines' dialog when the corresponding
        addin is selected from the vendor dropdown, or when 'search all vendors' is
        selected. This event will allow the addin to initiate an enumeration of machines on
        the network, and populate the 'Find network machines' dialog with descriptions of each
        machine found. See SearchNetworkMachinesEvent for details.
        """
        return SearchNetworkMachinesEvent()
    @property
    def createMachineConfigurationsEvent(self) -> CreateMachineConfigurationsEvent:
        """
        This event is fired from the 'Find network machines' dialog when MachineDescription(s)
        previously provided during the handling of the SearchNetworkMachines event are selected
        to add to the user's Machine Library. This event will allow the addins to create
        machine configurations corresponding to the selected MachineDescription objects.
        See CreateMachineConfigurationsEvent for details.
        """
        return CreateMachineConfigurationsEvent()

class OperationBase(core.Base):
    """
    Base class object representing all operations, folders, patterns and setups.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> OperationBase:
        return OperationBase()
    @property
    def name(self) -> str:
        """
        Gets and sets the name of the operation as seen in the browser.  This name is unique as compared
        to the names of all other operations in the document.
        """
        return str()
    @name.setter
    def name(self, value: str):
        """
        Gets and sets the name of the operation as seen in the browser.  This name is unique as compared
        to the names of all other operations in the document.
        """
        pass
    @property
    def isProtected(self) -> bool:
        """
        Gets and sets the "protected" property value of the operation.
        Gets/sets true if the operation is protected.
        """
        return bool()
    @isProtected.setter
    def isProtected(self, value: bool):
        """
        Gets and sets the "protected" property value of the operation.
        Gets/sets true if the operation is protected.
        """
        pass
    @property
    def isOptional(self) -> bool:
        """
        Gets and sets the "Optional" property value of the operation.
        Gets/sets true if the operation is optional.
        """
        return bool()
    @isOptional.setter
    def isOptional(self, value: bool):
        """
        Gets and sets the "Optional" property value of the operation.
        Gets/sets true if the operation is optional.
        """
        pass
    @property
    def isSuppressed(self) -> bool:
        """
        Gets and sets the "Suppressed" property value of the operation.
        Gets/sets true if the operation is suppressed.
        """
        return bool()
    @isSuppressed.setter
    def isSuppressed(self, value: bool):
        """
        Gets and sets the "Suppressed" property value of the operation.
        Gets/sets true if the operation is suppressed.
        """
        pass
    @property
    def parentSetup(self) -> Setup:
        """
        Gets the Setup this operation belongs to.
        """
        return Setup()
    @property
    def isSelected(self) -> bool:
        """
        Gets if this operation is selected in the 'Setups' browser.
        """
        return bool()
    @property
    def notes(self) -> str:
        """
        Gets and sets the notes of the operation.
        """
        return str()
    @notes.setter
    def notes(self, value: str):
        """
        Gets and sets the notes of the operation.
        """
        pass
    @property
    def operationId(self) -> int:
        """
        Returns the id of the operation.  This id is unique as compared
        to the ids of all other operations in the document.
        This id will not change when changing the order or parent of the operation.
        This id will remain valid when the document is saved and reloaded.
        """
        return int()
    @property
    def parameters(self) -> CAMParameters:
        """
        Gets the CAMParameters collection for this operation.
        """
        return CAMParameters()
    @property
    def attributes(self) -> core.Attributes:
        """
        Returns the collection of attributes associated with this object.
        """
        return core.Attributes()

class Operations(core.Base):
    """
    Collection that provides access to the individual operations within an existing setup, folder or pattern.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Operations:
        return Operations()
    def item(self, index: int) -> Operation:
        """
        Function that returns the specified operation using an index into the collection.
        index : The index of the item within the collection to return.  The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Operation()
    def itemByName(self, name: str) -> Operation:
        """
        Returns the operation with the specified name (as appears in the browser).
        name : The name (as it appears in the browser) of the operation.
        Returns the specified operation or null in the case where there is no operation with the specified name.
        """
        return Operation()
    def itemByOperationId(self, id: int) -> Operation:
        """
        Returns the operation with the specified operation id.
        id : The id of the operation.
        Returns the specified operation or null in the case where there is no operation with the specified operation id.
        """
        return Operation()
    @property
    def count(self) -> int:
        """
        The number of items in the collection.
        """
        return int()

class ParameterValue(core.Base):
    """
    Base class for representing the value of a parameter.
    Subclasses implement value handling for available parameter types.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ParameterValue:
        return ParameterValue()
    @property
    def parent(self) -> core.Base:
        """
        Get the parameter object that the value is associated with.
        """
        return core.Base()

class PostProcessInput(core.Base):
    """
    This class defines the properties that pertain to the settings and options required for posting a
    toolpath to generate a CNC file.  A PostProcessInput object is a required parameter for the
    postProcessAll() and postProcess() methods on the CAM class.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> PostProcessInput:
        return PostProcessInput()
    @staticmethod
    def create(programName: str, postConfiguration: str, outputFolder: str, outputUnits: PostOutputUnitOptions) -> PostProcessInput:
        """
        Creates a new PostProcessInput object to be used as an input argument by the postProcess() and postProcessAll()
        methods on the CAM class for posting toolpaths and generating CNC files.
        programName : The program name or number.
        If the post configuration specifies the parameter programNameIsInteger = true, then the program name must be a number.
        postConfiguration : The full filename (including the path) to the post configuration file (.cps)
        The post config file can be stored in any path but for convenience you can use the genericPostFolder or the personalPostFolder property on the CAM class to specify
        the path if your .cps file is stored in either of those locations.  You must add a forward slash (this works for Mac or Windows) to the path defined by these folder
        properties before the filename (e.g. postConfiguration = cam.genericPostFolder + '/' + 'fanuc.cps')
        outputFolder : The path for the existing output folder where the .cnc files will be located.  This method will create the specified output folder if it does not already exist.
        It is not necessary to add a slash to the end of the outputFolder path.  You should use forward slashes in your path definition if you want your script to run on both Mac and Windows.
        outputUnits : The units option for the cnc output.
        Valid options are DocumentUnitsOutput, InchesOutput or MillimetersOutput
        Returns the newly created PostProcessInput object or null if the creation failed.
        """
        return PostProcessInput()
    @property
    def programName(self) -> str:
        """
        Gets and sets the program name or number.
        If the post configuration specifies the parameter programNameIsInteger = true, then the program name must be a number.
        """
        return str()
    @programName.setter
    def programName(self, value: str):
        """
        Gets and sets the program name or number.
        If the post configuration specifies the parameter programNameIsInteger = true, then the program name must be a number.
        """
        pass
    @property
    def programComment(self) -> str:
        """
        Gets and sets the program comment.  The default value for this property is an empty string ("").
        """
        return str()
    @programComment.setter
    def programComment(self, value: str):
        """
        Gets and sets the program comment.  The default value for this property is an empty string ("").
        """
        pass
    @property
    def postConfiguration(self) -> str:
        """
        Gets and sets the full filename (including the path) for the post configuration file (.cps)
        """
        return str()
    @postConfiguration.setter
    def postConfiguration(self, value: str):
        """
        Gets and sets the full filename (including the path) for the post configuration file (.cps)
        """
        pass
    @property
    def outputFolder(self) -> str:
        """
        Gets and sets the path for the output folder where the .cnc files will be located.
        """
        return str()
    @outputFolder.setter
    def outputFolder(self, value: str):
        """
        Gets and sets the path for the output folder where the .cnc files will be located.
        """
        pass
    @property
    def outputUnits(self) -> PostOutputUnitOptions:
        """
        Gets and sets the units option for the cnc output.
        Valid options are DocumentUnitsOutput, InchesOutput or MillimetersOutput
        """
        return PostOutputUnitOptions()
    @outputUnits.setter
    def outputUnits(self, value: PostOutputUnitOptions):
        """
        Gets and sets the units option for the cnc output.
        Valid options are DocumentUnitsOutput, InchesOutput or MillimetersOutput
        """
        pass
    @property
    def isOpenInEditor(self) -> bool:
        """
        Gets and sets the option if opening the cnc file with the editor after it is created.
        The default value for this property is true.
        """
        return bool()
    @isOpenInEditor.setter
    def isOpenInEditor(self, value: bool):
        """
        Gets and sets the option if opening the cnc file with the editor after it is created.
        The default value for this property is true.
        """
        pass
    @property
    def areToolChangesMinimized(self) -> bool:
        """
        Gets and sets that operations may be reordered between setups to minimize the number of tool changes.
        Operations within each setup will still be executed in the programmed order.
        This is commonly used for tombstone machining where you have multiple setups.
        The default value for this property is false.
        """
        return bool()
    @areToolChangesMinimized.setter
    def areToolChangesMinimized(self, value: bool):
        """
        Gets and sets that operations may be reordered between setups to minimize the number of tool changes.
        Operations within each setup will still be executed in the programmed order.
        This is commonly used for tombstone machining where you have multiple setups.
        The default value for this property is false.
        """
        pass
    @property
    def postProperties(self) -> core.NamedValues:
        """
        Gets and sets the list of post properties.
        Each property has a string name and a ValueInput object.
        The default value for this is an empty NamedValues.
        """
        return core.NamedValues()
    @postProperties.setter
    def postProperties(self, value: core.NamedValues):
        """
        Gets and sets the list of post properties.
        Each property has a string name and a ValueInput object.
        The default value for this is an empty NamedValues.
        """
        pass
    @property
    def machine(self) -> Machine:
        """
        Gets and sets the machine used for post processing.
        It will override the machines associated with the operations or setup when posting.
        The default value for this property is null.
        """
        return Machine()
    @machine.setter
    def machine(self, value: Machine):
        """
        Gets and sets the machine used for post processing.
        It will override the machines associated with the operations or setup when posting.
        The default value for this property is null.
        """
        pass

class SandvikIntegration(core.Base):
    """
    This singleton object provides access to application-level events and properties
    that relate to the CAM (Manufacture) workspace in Fusion 360.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SandvikIntegration:
        return SandvikIntegration()
    @staticmethod
    def get() -> SandvikIntegration:
        """
        Access to the root CAMGlobal object.
        Return the root SandvikIntegration object or null if it failed.
        """
        return SandvikIntegration()
    def getStockMaterialId(self, setup: Setup) -> str:
        """
        Get the stock material id specified for the Setup.
        setup : The Setup object to get the stock material id for.
        The ID of the stock material set for the Setup.
        """
        return str()
    def setStockMaterialId(self, setup: Setup, id: str) -> bool:
        """
        Set the stock material id for the Setup.
        setup : The Setup object to set the stock material id for.
        Returns true if successful.
        """
        return bool()
    def getStockMaterialText(self, setup: Setup) -> str:
        """
        Get the stock material id specified for the Setup.
        setup : The Setup object to get the stock material id for.
        The ID of the stock material set for the Setup.
        """
        return str()
    def setStockMaterialText(self, setup: Setup, text: str) -> bool:
        """
        Set the stock material text for the Setup. This will be displayed in the user interface.
        setup : The Setup object to set the stock material text for.
        Returns true if successful.
        """
        return bool()
    @property
    def preIntegrationEvent(self) -> SandvikPreIntegrationEvent:
        """
        This event will be fired just before an operation/setup dialog (create/edit) is
        presented. This will allow the addin to indicate which, if any, of the integration
        actions should be shown, as well as details of the presentation. See
        SandvikPreIntegrationEventArgs for details.
        """
        return SandvikPreIntegrationEvent()
    @property
    def integrationEvent(self) -> SandvikIntegrationEvent:
        """
        An integration event will be fired when any of the buttons related to the
        integration is pressed. The event arguments will provide information about which
        button was pressed, and will provide contextual information, such as the object
        active at the time.
        """
        return SandvikIntegrationEvent()
    @property
    def settings(self) -> str:
        """
        Provides a mechanism to store and retrieve user-specific information as a hidden system preference.
        """
        return str()
    @settings.setter
    def settings(self, value: str):
        """
        Provides a mechanism to store and retrieve user-specific information as a hidden system preference.
        """
        pass

class SandvikIntegrationEventHandler(core.EventHandler):
    """
    Event handler for the SandvikIntegrationEvent event.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SandvikIntegrationEventHandler:
        return SandvikIntegrationEventHandler()
    def notify(self, eventArgs: SandvikIntegrationEventArgs) -> None:
        """
        The function called by CAM when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class SandvikPreIntegrationEventHandler(core.EventHandler):
    """
    Event handler for the SandvikPreIntegrationEvent event.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SandvikPreIntegrationEventHandler:
        return SandvikPreIntegrationEventHandler()
    def notify(self, eventArgs: SandvikPreIntegrationEventArgs) -> None:
        """
        The function called by CAM when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class SearchNetworkMachinesEventHandler(core.EventHandler):
    """
    Event handler for the SearchNetworkMachinesEvent event.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SearchNetworkMachinesEventHandler:
        return SearchNetworkMachinesEventHandler()
    def notify(self, eventArgs: SearchNetworkMachinesEventArgs) -> None:
        """
        The function called by Fusion 360 when the associated event is fired.
        eventArgs : An object that provides access to additional information associated with the event.
        """
        pass

class SetupChangeEventHandler(core.EventHandler):
    """
    The SetupChangeEventHandler is a client implemented class that can be added as a handler to a
    SetupChangeEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SetupChangeEventHandler:
        return SetupChangeEventHandler()
    def notify(self, eventArgs: SetupChangeEventArgs) -> None:
        """
        The function called by CAM when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class SetupEventHandler(core.EventHandler):
    """
    The SetupEventHandler is a client implemented class that can be added as a handler to a
    SetupEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SetupEventHandler:
        return SetupEventHandler()
    def notify(self, eventArgs: SetupEventArgs) -> None:
        """
        The function called by CAM when the associated event is fired.
        eventArgs : Returns an object that provides access to additional information associated with the event.
        """
        pass

class Setups(core.Base):
    """
    Collection that provides access to all of the existing setups in a document.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Setups:
        return Setups()
    def item(self, index: int) -> Setup:
        """
        Function that returns the specified setup using an index into the collection.
        index : The index of the item within the collection to return.  The first item in the collection has an index of 0.
        Returns the specified item or null if an invalid index was specified.
        """
        return Setup()
    def itemByName(self, name: str) -> Setup:
        """
        Returns the setup with the specified name.
        name : The name (as it appears in the browser) of the operation.
        Returns the specified setup or null in the case where there is no setup with the specified name.
        """
        return Setup()
    def itemByOperationId(self, id: int) -> Setup:
        """
        Returns the setup with the specified operation id.
        id : The id of the operation.
        Returns the specified setup or null in the case where there is no setup with the specified operation id.
        """
        return Setup()
    @property
    def count(self) -> int:
        """
        The number of setups in the collection.
        """
        return int()

class BooleanParameterValue(ParameterValue):
    """
    A parameter value that is a boolean.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> BooleanParameterValue:
        return BooleanParameterValue()
    @property
    def value(self) -> bool:
        """
        Get or set the value of the parameter.
        """
        return bool()
    @value.setter
    def value(self, value: bool):
        """
        Get or set the value of the parameter.
        """
        pass

class CadObjectParameterValue(ParameterValue):
    """
    A parameter value that is a CadObject.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CadObjectParameterValue:
        return CadObjectParameterValue()

class CAM(core.Product):
    """
    Object that represents the CAM environment of a Fusion document.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAM:
        return CAM()
    def export3MFForDefaultAdditiveSetup(self, filepath: str, addSimulationInfo: bool, simPostProcess: bool, simSplitSurrogates: bool, simKeepThickeningStructure: bool) -> bool:
        """
        Exports the default additive setup's models into a 3mf file. The 3mf also contains machine and support information.
        True on success, false on errors or wrong setup type
        """
        return bool()
    def generateToolpath(self, operations: core.Base) -> GenerateToolpathFuture:
        """
        Generates/Regenerates all of the toolpaths (including those nested in sub-folders or patterns)
        for the specified objects.
        operations : An Operation, Setup, Folder or Pattern object for which to generate the toolpath/s for.  You can also
        specify a collection of any combination of these object types.
        Return GenerateToolpathFuture that includes the status of toolpath generation.
        """
        return GenerateToolpathFuture()
    def generateAllToolpaths(self, skipValid: bool) -> GenerateToolpathFuture:
        """
        Generates/Regenerates all toolpaths (includes those nested in sub-folders or patterns) in the document.
        skipValid : Option to skip valid toolpaths and only regenerate invalid toolpaths.
        Return GenerateToolpathFuture that includes the status of toolpath generation.
        """
        return GenerateToolpathFuture()
    def clearToolpath(self, operations: core.Base) -> bool:
        """
        Clears all of the toolpaths (including those nested in sub-folders or patterns) for the specified objects.
        operations : An Operation, Setup, Folder or Pattern object for which to clear the toolpath/s for.  You can also
        specify a collection of any combination of these object types.
        Return true if successful.
        """
        return bool()
    def clearAllToolpaths(self) -> bool:
        """
        Clears all the toolpaths (includes those nested in sub-folders or patterns) in the document
        Return true if successful.
        """
        return bool()
    def checkToolpath(self, operations: core.Base) -> bool:
        """
        Checks if toolpath operations (including those nested in sub-folders or patterns) are valid for the specified objects.
        operations : An Operation, Setup, Folder or Pattern object for which to check the toolpath/s of.  You can also
        specify a collection of any combination of these object types.
        Returns true if the toolpath operations are valid
        """
        return bool()
    def checkAllToolpaths(self) -> bool:
        """
        Checks if all the toolpath operations (includes those nested in sub-folders or patterns) in the document are valid
        Returns true if the all toolpath operations are valid
        """
        return bool()
    def postProcess(self, operations: core.Base, input: PostProcessInput) -> bool:
        """
        Post all of the toolpaths (including those nested in sub-folders or patterns) for the specified objects.
        If post processing fails, an error message can be retrieved from the error log explaining the reason for the failure.
        operations : An Operation, Setup, Folder or Pattern object for which to post the toolpath/s of.  You can also
        specify a collection of any combination of these object types.
        input : The PostProcessInput object that defines the post options and parameters.
        Returns true if successful
        """
        return bool()
    def postProcessAll(self, input: PostProcessInput) -> bool:
        """
        Post all of the toolpaths (includes those nested in sub-folders or patterns) in the document.
        If post processing fails, an error message can be retrieved from the error log explaining the reason for the failure.
        input : The PostProcessInput object that defines the post options and parameters.
        Returns true if successful.
        """
        return bool()
    def generateSetupSheet(self, operations: core.Base, format: SetupSheetFormats, folder: str, openDocument: bool) -> bool:
        """
        Generate the setup sheets for the specified objects
        operations : An Operation, Setup, Folder or Pattern object for which to generate the setup sheet/s for.  You can also
        specify a collection of any combination of these object types.
        format : The document format for the setup sheet.  Valid options are HTMLFormat and ExcelFormat.
        Limitation: "ExcelFormat" can be used in windows OS only.
        folder : The destination folder to locate the setup sheet documents in.
        openDocument : An option to allow to open the document instantly after the generation. By default, the document is opened.
        Returns true if successful
        """
        return bool()
    def generateAllSetupSheets(self, format: SetupSheetFormats, folder: str, openDocument: bool) -> bool:
        """
        Generates all of the setup sheets for all of the operations in the document
        format : The document format for the setup sheet.  Valid options are HTMLFormat and ExcelFormat.
        Limitation: "ExcelFormat" can be used in windows OS only.
        folder : The destination folder to locate the setup sheet documents in.
        openDocument : An option to allow to open the document instantly after the generation. By default, the document is opened.
        Returns true if successful
        """
        return bool()
    def getMachiningTime(self, operations: core.Base, feedScale: float, rapidFeed: float, toolChangeTime: float) -> MachiningTime:
        """
        Get the machining time for the specified objects.
        operations : An Operation, Setup, Folder or Pattern object for which to get the machining time for.  You can also
        specify a collection of any combination of these object types.
        feedScale : The feed scale value (%) to use.
        rapidFeed : The rapid feed rate in centimeters per second.
        toolChangeTime : The tool change time in seconds.
        Returns a MachiningTime object that has properties holding the calculation results.
        """
        return MachiningTime()
    @property
    def setups(self) -> Setups:
        """
        Returns the Setups collection that provides access to existing setups
        """
        return Setups()
    @property
    def allOperations(self) -> core.ObjectCollection:
        """
        Gets a collection containing all of the operations in the document.
        This includes all operations nested in folders and patterns.
        """
        return core.ObjectCollection()
    @property
    def genericPostFolder(self) -> str:
        """
        Gets the installed post folder.
        """
        return str()
    @property
    def personalPostFolder(self) -> str:
        """
        Gets the personal post folder.
        """
        return str()
    @property
    def temporaryFolder(self) -> str:
        """
        Gets the folder for temporary files.
        """
        return str()
    @property
    def customGraphicsGroups(self) -> fusion.CustomGraphicsGroups:
        """
        Returns the customGraphicsGroups object associated with the CAM product.
        """
        return fusion.CustomGraphicsGroups()
    @property
    def designRootOccurrence(self) -> fusion.Occurrence:
        """
        Returns the occurrence that references the design root component in CAM product.
        """
        return fusion.Occurrence()
    @property
    def flatPatternOccurrences(self) -> fusion.OccurrenceList:
        """
        Returns a read only list of flat pattern occurrences in CAM product.
        """
        return fusion.OccurrenceList()
    @property
    def allMachines(self) -> core.ObjectCollection:
        """
        Gets a collection containing all of the machines in the document.
        """
        return core.ObjectCollection()
    @property
    def setupCreated(self) -> SetupEvent:
        """
        The SetupCreated event fires when a new setup was created.
        """
        return SetupEvent()
    @property
    def setupDestroying(self) -> SetupEvent:
        """
        The setupDestroying event fires before a setup will be destroyed.
        """
        return SetupEvent()
    @property
    def setupChanged(self) -> SetupChangeEvent:
        """
        The SetupChanged event fires when a setup was modified.
        """
        return SetupChangeEvent()
    @property
    def setupActivating(self) -> SetupEvent:
        """
        The SetupActivating event fires before a setup will be activated.
        """
        return SetupEvent()
    @property
    def setupActivated(self) -> SetupEvent:
        """
        The SetupActivated event fires when a setup was activated.
        """
        return SetupEvent()
    @property
    def setupDeactivating(self) -> SetupEvent:
        """
        The SetupDeactivating event fires before a setup will be deactivated.
        """
        return SetupEvent()
    @property
    def setupDeactivated(self) -> SetupEvent:
        """
        The SetupDeactivated event fires when a setup was deactivated.
        """
        return SetupEvent()
    @property
    def exportManager(self) -> CAMExportManager:
        """
        Returns the API-only Export Manager instance
        """
        return CAMExportManager()
    @property
    def inspectionResults(self) -> CAMInspectionResults:
        """
        Returns the results collection that provides access to existing measures then pathMeasures and manualMeasures
        """
        return CAMInspectionResults()

class CAM3MFExportOptions(CAMExportOptions):
    """
    3MF export option. Available with all additive machines except Formlabs. Expects a setup as its export object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAM3MFExportOptions:
        return CAM3MFExportOptions()
    @property
    def areSupportsIncluded(self) -> bool:
        """
        Flag toggling if support information should be included in the exported file.
        Includes both support structures marked as open or closed support as well as meta data used in Netfabb.
        This option might not be available for all machine types.
        The default value is false.
        """
        return bool()
    @areSupportsIncluded.setter
    def areSupportsIncluded(self, value: bool):
        """
        Flag toggling if support information should be included in the exported file.
        Includes both support structures marked as open or closed support as well as meta data used in Netfabb.
        This option might not be available for all machine types.
        The default value is false.
        """
        pass
    @property
    def isMachineInformationIncluded(self) -> bool:
        """
        Flag toggling if machine information should be included in the exported file.
        The machine information is only compatible with Netfabb.
        This option might not be available for all machine types.
        The default value is false.
        """
        return bool()
    @isMachineInformationIncluded.setter
    def isMachineInformationIncluded(self, value: bool):
        """
        Flag toggling if machine information should be included in the exported file.
        The machine information is only compatible with Netfabb.
        This option might not be available for all machine types.
        The default value is false.
        """
        pass
    @property
    def isProcessSimulationDataIncluded(self) -> bool:
        """
        Flag toggling if simulation information should be included in the exported file.
        This option might not be available for all machine types.
        The default value is false.
        """
        return bool()
    @isProcessSimulationDataIncluded.setter
    def isProcessSimulationDataIncluded(self, value: bool):
        """
        Flag toggling if simulation information should be included in the exported file.
        This option might not be available for all machine types.
        The default value is false.
        """
        pass
    @property
    def isSimulationPostProcessingIncluded(self) -> bool:
        """
        Flag toggling if post processing of the simulation should be included.
        This option might not be available for all machine types.
        The default value is false.
        """
        return bool()
    @isSimulationPostProcessingIncluded.setter
    def isSimulationPostProcessingIncluded(self, value: bool):
        """
        Flag toggling if post processing of the simulation should be included.
        This option might not be available for all machine types.
        The default value is false.
        """
        pass
    @property
    def areSimulationSurrogatesSplit(self) -> bool:
        """
        Flag toggling if surrogate supports used in the simulation should be split.
        This option might not be available for all machine types.
        The default value is false.
        """
        return bool()
    @areSimulationSurrogatesSplit.setter
    def areSimulationSurrogatesSplit(self, value: bool):
        """
        Flag toggling if surrogate supports used in the simulation should be split.
        This option might not be available for all machine types.
        The default value is false.
        """
        pass
    @property
    def areSimulationThickeningStructuresKept(self) -> bool:
        """
        Flag toggling if thickening structures used for simulation should be kept.
        This option might not be available for all machine types.
        The default value is false.
        """
        return bool()
    @areSimulationThickeningStructuresKept.setter
    def areSimulationThickeningStructuresKept(self, value: bool):
        """
        Flag toggling if thickening structures used for simulation should be kept.
        This option might not be available for all machine types.
        The default value is false.
        """
        pass

class CAMFolder(OperationBase):
    """
    Object that represents a folder in an existing Setup, Folder or Pattern.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMFolder:
        return CAMFolder()
    def createFromTemplate(self, templateFilePath: str) -> core.ObjectCollection:
        """
        Create and add operations, folders or patterns from the specified template file to the end of this folder.
        templateFilePath : The full path to the template file.
        Returns the collection containing all of the operations, folders and patterns created from the template file.
        """
        return core.ObjectCollection()
    @property
    def isActive(self) -> bool:
        """
        Gets if this folder is active.
        """
        return bool()
    @property
    def operations(self) -> Operations:
        """
        Returns the Operations collection that provides access to existing individual operations
        in this folder.
        """
        return Operations()
    @property
    def folders(self) -> CAMFolders:
        """
        Returns the Folders collection that provides access to existing folders
        in this folder.
        """
        return CAMFolders()
    @property
    def patterns(self) -> CAMPatterns:
        """
        Returns the Patterns collection that provides access to existing patterns
        in this folder.
        """
        return CAMPatterns()
    @property
    def children(self) -> ChildOperationList:
        """
        Returns a collection containing all of the immediate (top level) child operations, folders and patterns in this folder
        in the order they appear in the browser.
        """
        return ChildOperationList()
    @property
    def parent(self) -> core.Base:
        """
        Returns the parent Setup, Folder or Pattern for this Folder.
        """
        return core.Base()
    @property
    def allOperations(self) -> core.ObjectCollection:
        """
        Gets a collection containing all of the operations in this folder.
        This includes all operations nested in folders and patterns.
        """
        return core.ObjectCollection()

class CAMFormlabsExportOptions(CAMExportOptions):
    """
    Formlabs export option. Available only with Formlabs machines. Expects a setup as its export object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMFormlabsExportOptions:
        return CAMFormlabsExportOptions()
    @property
    def areSupportsIncluded(self) -> bool:
        """
        Flag toggling if supports should be included in the exported file. The flag is only evaluated if the user has bought the extension.
        The default value is false.
        """
        return bool()
    @areSupportsIncluded.setter
    def areSupportsIncluded(self, value: bool):
        """
        Flag toggling if supports should be included in the exported file. The flag is only evaluated if the user has bought the extension.
        The default value is false.
        """
        pass

class ChoiceParameterValue(ParameterValue):
    """
    A parameter value that is a list of choices.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> ChoiceParameterValue:
        return ChoiceParameterValue()
    def getChoices(self) -> tuple[bool, list[str], list[str]]:
        """
        Method that returns the list of available choices.
        names : An array of the names of the choices. These coincide with the array of possible values returned by the values argument.
        values : An array of the possible values. These coincide with the array of names returned by the names argument.
        Returns true if the call was successful.
        """
        return (bool(), [str()], [str()])
    @property
    def value(self) -> str:
        """
        Get or set the value of the parameter.
        This value will correspond to one of the available values of the parameter.
        """
        return str()
    @value.setter
    def value(self, value: str):
        """
        Get or set the value of the parameter.
        This value will correspond to one of the available values of the parameter.
        """
        pass

class CreateMachineConfigurationsEvent(core.Event):
    """
    This event is fired from the 'Find network machines' dialog when MachineDescription(s)
    previously provided during the handling of the SearchNetworkMachines event are selected
    to add to the user's Machine Library. This event will allow the addins to create
    machine configurations corresponding to the selected MachineDescription objects.
    Handlers of this event should create machine configurations corresponding to each
    MachineDescription present in the 'machineDescriptions' property in the
    CreateMachineConfigurationsEventArgs and set them on the 'machines' property of the
    event args. See CreateMachineConfigurationsEventArgs for details. Note that this event is
    raised on a background thread.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CreateMachineConfigurationsEvent:
        return CreateMachineConfigurationsEvent()
    def add(self, handler: CreateMachineConfigurationsEventHandler) -> bool:
        """
        Add a handler to be notified when the CreateMachineConfigurationsEvent occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: CreateMachineConfigurationsEventHandler) -> bool:
        """
        Removes a handler from the CreateMachineConfigurationsEvent.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class CreateMachineConfigurationsEventArgs(core.EventArgs):
    """
    This EventArgs object will be sent with the CreateMachineConfigurationsEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CreateMachineConfigurationsEventArgs:
        return CreateMachineConfigurationsEventArgs()
    @property
    def machineDescriptions(self) -> list[MachineDescription]:
        """
        Gets the collection of MachineDescription objects for which machine configurations
        must be created. These MachineDescription(s) will be a subset of those previously
        provided by the addin's SearchNetworkMachinesEventHandler.
        Returns a list of MachineDescription objects which is a subset of the list that was
        previously set by this addin on the 'machineDescriptions' property of the
        SearchNetworkMachinesEventArgs.
        """
        return [MachineDescription()]
    @property
    def machines(self) -> list[Machine]:
        """
        Gets and sets the list of Machine objects. Machines should be created corresponding to
        each of the MachineDescription objects provided in the machineDescriptions property.
        Machines can be created using adsk.cam.Machine.createFromTemplate or
        adsk.cam.Machine.createFromFile.
        """
        return [Machine()]
    @machines.setter
    def machines(self, value: list[Machine]):
        """
        Gets and sets the list of Machine objects. Machines should be created corresponding to
        each of the MachineDescription objects provided in the machineDescriptions property.
        Machines can be created using adsk.cam.Machine.createFromTemplate or
        adsk.cam.Machine.createFromFile.
        """
        pass

class FloatParameterValue(ParameterValue):
    """
    A parameter value that is a floating point value.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> FloatParameterValue:
        return FloatParameterValue()
    @property
    def value(self) -> float:
        """
        Get or set the value of the parameter.
        """
        return float()
    @value.setter
    def value(self, value: float):
        """
        Get or set the value of the parameter.
        """
        pass

class IntegerParameterValue(ParameterValue):
    """
    A parameter value that is an integer.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> IntegerParameterValue:
        return IntegerParameterValue()
    @property
    def value(self) -> int:
        """
        Get or set the value of the parameter.
        """
        return int()
    @value.setter
    def value(self, value: int):
        """
        Get or set the value of the parameter.
        """
        pass

class LinearMachineAxis(MachineAxis):
    """
    Object that represents an axis with linear motion (e.g. X, Y, and Z).
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> LinearMachineAxis:
        return LinearMachineAxis()
    @property
    def direction(self) -> core.Vector3D:
        """
        The unit vector that represents the direction along which the axis will move.
        """
        return core.Vector3D()
    @direction.setter
    def direction(self, value: core.Vector3D):
        """
        The unit vector that represents the direction along which the axis will move.
        """
        pass

class LinearMachineAxisInput(MachineAxisInput):
    """
    Object that defines the properties required to create a new linear machine axis object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> LinearMachineAxisInput:
        return LinearMachineAxisInput()
    @property
    def direction(self) -> core.Vector3D:
        """
        The unit vector that represents the direction along which the linear axis will move.
        This vector is in the machine's coordinate system (e.g. the X axis is always (1,0,0)).
        """
        return core.Vector3D()
    @direction.setter
    def direction(self, value: core.Vector3D):
        """
        The unit vector that represents the direction along which the linear axis will move.
        This vector is in the machine's coordinate system (e.g. the X axis is always (1,0,0)).
        """
        pass

class Operation(OperationBase):
    """
    Object that represents an operation in an existing Setup, Folder or Pattern.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Operation:
        return Operation()
    @property
    def strategyType(self) -> OperationStrategyTypes:
        """
        Gets the strategy type for this operation.
        """
        return OperationStrategyTypes()
    @property
    def isToolpathValid(self) -> bool:
        """
        Gets if the toolpath for this operation is currently valid. (has not become invalidated by model changes).
        """
        return bool()
    @property
    def isGenerating(self) -> bool:
        """
        Gets if the toolpath is in the process of generating.
        """
        return bool()
    @property
    def hasWarning(self) -> bool:
        """
        Gets if problems were encountered when generating the toolpath for this operation.
        """
        return bool()
    @property
    def parent(self) -> core.Base:
        """
        Returns the parent Setup, Folder or Pattern for this operation.
        """
        return core.Base()
    @property
    def hasToolpath(self) -> bool:
        """
        Gets if a toolpath currently exists (has been generated) for this operation.
        """
        return bool()
    @property
    def operationState(self) -> OperationStates:
        """
        Gets the current state of this operation.
        """
        return OperationStates()
    @property
    def generatingProgress(self) -> str:
        """
        Gets the toolpath generation progress value for this operation.
        """
        return str()
    @property
    def toolJson(self) -> str:
        """
        Get or set the tool in JSON format for this operation. Adds tool to the document.
        """
        return str()
    @toolJson.setter
    def toolJson(self, value: str):
        """
        Get or set the tool in JSON format for this operation. Adds tool to the document.
        """
        pass
    @property
    def toolPresetId(self) -> str:
        """
        Get or set the id of the tool preset to be used. Must be valid for the applied tool.
        """
        return str()
    @toolPresetId.setter
    def toolPresetId(self, value: str):
        """
        Get or set the id of the tool preset to be used. Must be valid for the applied tool.
        """
        pass

class RotaryMachineAxis(MachineAxis):
    """
    Object that represents an axis with rotary motion (e.g. A, B, and C).
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RotaryMachineAxis:
        return RotaryMachineAxis()
    @property
    def rotationAxis(self) -> core.InfiniteLine3D:
        """
        The infinite line that defines the direction and location of the axis of rotation.
        """
        return core.InfiniteLine3D()
    @rotationAxis.setter
    def rotationAxis(self, value: core.InfiniteLine3D):
        """
        The infinite line that defines the direction and location of the axis of rotation.
        """
        pass

class RotaryMachineAxisInput(MachineAxisInput):
    """
    Object that defines the properties required to create a new rotary machine axis object.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> RotaryMachineAxisInput:
        return RotaryMachineAxisInput()
    @property
    def rotationAxis(self) -> core.InfiniteLine3D:
        """
        The infinite line that defines the direction and location of the axis of rotation.
        This direction is in the machine's coordinate system (e.g. an A axis would
        typically use (1,0,0) for the direction), and follows the right-hand rule.
        """
        return core.InfiniteLine3D()
    @rotationAxis.setter
    def rotationAxis(self, value: core.InfiniteLine3D):
        """
        The infinite line that defines the direction and location of the axis of rotation.
        This direction is in the machine's coordinate system (e.g. an A axis would
        typically use (1,0,0) for the direction), and follows the right-hand rule.
        """
        pass

class SandvikIntegrationEvent(core.Event):
    """
    
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SandvikIntegrationEvent:
        return SandvikIntegrationEvent()
    def add(self, handler: SandvikIntegrationEventHandler) -> bool:
        """
        Add a handler to be notified when the SandvikIntegrationEvent occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: SandvikIntegrationEventHandler) -> bool:
        """
        Removes a handler from the SandvikIntegrationEvent.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class SandvikIntegrationEventArgs(core.EventArgs):
    """
    This EventArgs object will be sent with the SandvikIntegrationEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SandvikIntegrationEventArgs:
        return SandvikIntegrationEventArgs()
    @property
    def action(self) -> str:
        """
        The action to be performed -- by convention with Sandvik.
        Actions include:
        "selectAssembly"
        "getToolRecommendation"
        "getCuttingData"
        "setMaterial"
        """
        return str()
    @property
    def contextObject(self) -> OperationBase:
        """
        Provides access to the object that is being edited or created.
        """
        return OperationBase()

class SandvikPreIntegrationEvent(core.Event):
    """
    
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SandvikPreIntegrationEvent:
        return SandvikPreIntegrationEvent()
    def add(self, handler: SandvikPreIntegrationEventHandler) -> bool:
        """
        Add a handler to be notified when the SandvikPreIntegrationEvent occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: SandvikPreIntegrationEventHandler) -> bool:
        """
        Removes a handler from the SandvikPreIntegrationEvent.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class SandvikPreIntegrationEventArgs(core.EventArgs):
    """
    This EventArgs object will be sent with the SandvikPreIntegrationEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SandvikPreIntegrationEventArgs:
        return SandvikPreIntegrationEventArgs()
    @property
    def contextObject(self) -> OperationBase:
        """
        Provides access to the object that is being edited or created.
        """
        return OperationBase()
    @property
    def showSetMaterial(self) -> bool:
        """
        Initially false, this should be set to true to enable the display of the "Set Material"
        action on the Setup create/edit dialog.
        """
        return bool()
    @showSetMaterial.setter
    def showSetMaterial(self, value: bool):
        """
        Initially false, this should be set to true to enable the display of the "Set Material"
        action on the Setup create/edit dialog.
        """
        pass
    @property
    def showSelectToolAssembly(self) -> bool:
        """
        Initially false, this should be set to true to enable the display of the "Select Tool Assembly"
        action on the Operation create/edit dialog.
        """
        return bool()
    @showSelectToolAssembly.setter
    def showSelectToolAssembly(self, value: bool):
        """
        Initially false, this should be set to true to enable the display of the "Select Tool Assembly"
        action on the Operation create/edit dialog.
        """
        pass
    @property
    def showGetToolRecommendation(self) -> bool:
        """
        Initially false, this should be set to true to enable the display of the "Get Tool Recommendation"
        action on the Operation create/edit dialog.
        """
        return bool()
    @showGetToolRecommendation.setter
    def showGetToolRecommendation(self, value: bool):
        """
        Initially false, this should be set to true to enable the display of the "Get Tool Recommendation"
        action on the Operation create/edit dialog.
        """
        pass
    @property
    def showGetCuttingData(self) -> bool:
        """
        Initially false, this should be set to true to enable the display of the "Get Cutting Data"
        action on the Operation create/edit dialog.
        """
        return bool()
    @showGetCuttingData.setter
    def showGetCuttingData(self, value: bool):
        """
        Initially false, this should be set to true to enable the display of the "Get Cutting Data"
        action on the Operation create/edit dialog.
        """
        pass

class SearchNetworkMachinesEvent(core.Event):
    """
    This event is fired from the 'Find network machines' dialog when the corresponding
    addin is selected from the vendor dropdown, or when 'search all vendors' is
    selected. This event will allow the addin to initiate an enumeration of machines on
    the network. MachineDescription objects should be created for each machine found, and
    an list of those MachineDescription objects should be set on the 'machineDescriptions'
    property of the SearchNetworkMachinesEventArgs. Nothing should be set to signify no
    machines found. See SearchNetworkMachinesEventArgs and MachineDescription for details.
    Note that this event is raised on a background thread.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SearchNetworkMachinesEvent:
        return SearchNetworkMachinesEvent()
    def add(self, handler: SearchNetworkMachinesEventHandler) -> bool:
        """
        Add a handler to be notified when the SearchNetworkMachinesEvent occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: SearchNetworkMachinesEventHandler) -> bool:
        """
        Removes a handler from the SearchNetworkMachinesEvent.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class SearchNetworkMachinesEventArgs(core.EventArgs):
    """
    This EventArgs object will be sent with the SearchNetworkMachinesEvent.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SearchNetworkMachinesEventArgs:
        return SearchNetworkMachinesEventArgs()
    @property
    def machineDescriptions(self) -> list[MachineDescription]:
        """
        Gets and sets a list of MachineDescription objects representing machines found on the
        network. Do not set anything to signify no machine found.
        """
        return [MachineDescription()]
    @machineDescriptions.setter
    def machineDescriptions(self, value: list[MachineDescription]):
        """
        Gets and sets a list of MachineDescription objects representing machines found on the
        network. Do not set anything to signify no machine found.
        """
        pass

class Setup(OperationBase):
    """
    Object that represents an existing Setup.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> Setup:
        return Setup()
    def createFromTemplate(self, templateFilePath: str) -> core.ObjectCollection:
        """
        Create and add operations, folders or patterns from the specified template file to the end of this setup.
        templateFilePath : The full path to the template file.
        Returns the collection containing all of the operations, folders and patterns created from the template file.
        """
        return core.ObjectCollection()
    @property
    def operationType(self) -> OperationTypes:
        """
        Gets the Operation Type.
        It can be MillingOperation, TurningOperation, JetOperation or AdditiveOperation.
        """
        return OperationTypes()
    @property
    def isActive(self) -> bool:
        """
        Gets if this setup is active.
        """
        return bool()
    @property
    def operations(self) -> Operations:
        """
        Returns the Operations collection that provides access to existing operations
        in this setup.
        """
        return Operations()
    @property
    def folders(self) -> CAMFolders:
        """
        Returns the Folders collection that provides access to existing folders
        in this setup.
        """
        return CAMFolders()
    @property
    def patterns(self) -> CAMPatterns:
        """
        Returns the Patterns collection that provides access to existing patterns
        in this setup.
        """
        return CAMPatterns()
    @property
    def children(self) -> ChildOperationList:
        """
        Returns a collection containing all of the immediate (top level) child operations, folders and patterns in this setup
        in the order they appear in the browser.
        """
        return ChildOperationList()
    @property
    def allOperations(self) -> core.ObjectCollection:
        """
        Gets a collection containing all of the operations in this setup.
        This includes all operations nested in folders and patterns.
        """
        return core.ObjectCollection()
    @property
    def models(self) -> core.ObjectCollection:
        """
        Gets and sets the bodies associated with the setup.  Passing in an empty ObjectCollection
        will remove all current bodies.  Valid input is MeshBody and/or BRepBody objects.
        """
        return core.ObjectCollection()
    @models.setter
    def models(self, value: core.ObjectCollection):
        """
        Gets and sets the bodies associated with the setup.  Passing in an empty ObjectCollection
        will remove all current bodies.  Valid input is MeshBody and/or BRepBody objects.
        """
        pass
    @property
    def fixtures(self) -> core.ObjectCollection:
        """
        Gets the fixtures associated with the setup.
        """
        return core.ObjectCollection()
    @property
    def stockSolids(self) -> core.ObjectCollection:
        """
        Gets the stock solids associated with the setup.
        """
        return core.ObjectCollection()
    @property
    def machine(self) -> Machine:
        """
        Gets the Machine associated with the setup.
        """
        return Machine()

class SetupChangeEvent(core.Event):
    """
    A SetupChangeEvent represents a setup related change event.  It is used for SetupChanged notifications.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SetupChangeEvent:
        return SetupChangeEvent()
    def add(self, handler: SetupChangeEventHandler) -> bool:
        """
        Add a handler to be notified when the file event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: SetupChangeEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class SetupChangeEventArgs(core.EventArgs):
    """
    The SetupChangeEventArgs provides information associated with a change event of a setup.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SetupChangeEventArgs:
        return SetupChangeEventArgs()
    @property
    def setup(self) -> Setup:
        """
        Provides access to the setup. Can be null in the case
        where the event is fired before the setup has been created or after it has been deleted.
        """
        return Setup()
    @property
    def info(self) -> str:
        """
        Provides access to an information string.
        The optional string may contain additional information about the change.
        """
        return str()
    @property
    def type(self) -> SetupChangeEventType:
        """
        The type specifies the actual change.
        """
        return SetupChangeEventType()

class SetupEvent(core.Event):
    """
    A SetupEvent represents a setup related event.  For example, SetupCreated or SetupDestroying.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SetupEvent:
        return SetupEvent()
    def add(self, handler: SetupEventHandler) -> bool:
        """
        Add a handler to be notified when the file event occurs.
        handler : The handler object to be called when this event is fired.
        Returns true if the addition of the handler was successful.
        """
        return bool()
    def remove(self, handler: SetupEventHandler) -> bool:
        """
        Removes a handler from the event.
        handler : The handler object to be removed from the event.
        Returns true if removal of the handler was successful.
        """
        return bool()

class SetupEventArgs(core.EventArgs):
    """
    The SetupEventArgs provides information associated with a setup event.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> SetupEventArgs:
        return SetupEventArgs()
    @property
    def setup(self) -> Setup:
        """
        Provides access to the setup. Can be null in the case
        where the event is fired before the setup has been created or after it has been deleted.
        """
        return Setup()

class StringParameterValue(ParameterValue):
    """
    A parameter value that is a string.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> StringParameterValue:
        return StringParameterValue()
    @property
    def value(self) -> str:
        """
        Get or set the value of the parameter.
        """
        return str()
    @value.setter
    def value(self, value: str):
        """
        Get or set the value of the parameter.
        """
        pass

class CadMultiPointOnSurfaceParameterValue(CadObjectParameterValue):
    """
    A parameter value that is a CadMultiPointOnSurface.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CadMultiPointOnSurfaceParameterValue:
        return CadMultiPointOnSurfaceParameterValue()
    @property
    def values(self) -> list[core.Point3D]:
        """
        Get/Set the values of the parameter as a vector of Point3D positions.
        Points are in CM units.
        Points are in model coordinates.
        """
        return [core.Point3D()]
    @values.setter
    def values(self, value: list[core.Point3D]):
        """
        Get/Set the values of the parameter as a vector of Point3D positions.
        Points are in CM units.
        Points are in model coordinates.
        """
        pass

class CAMPattern(CAMFolder):
    """
    Object that represents a pattern in an existing Setup, Folder or Pattern.
    """
    def __init__(self):
        pass
    @staticmethod
    def cast(arg) -> CAMPattern:
        return CAMPattern()
