# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.publics = PublicService(self)
        



class PublicService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def get(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (PublicGetReqBody, str, str, int) -> PublicGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return PublicGetReqCall(self, body, request_opts=request_opts)

    def update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (PublicUpdateReqBody, str, str, int) -> PublicUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return PublicUpdateReqCall(self, body, request_opts=request_opts)



class PublicGetReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (PublicService, PublicGetReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[PublicGetResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('/open-apis/drive/permission/v2/public', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=PublicGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PublicUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (PublicService, PublicUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('/open-apis/drive/permission/v2/public/update', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

