/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.generator;

import java.io.Serializable;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import textworldexpress.games.KitchenGameGenerator;
import textworldexpress.generator.GameGenerator;
import textworldexpress.struct.TextGame;

public class GameGeneratorKitchen
extends GameGenerator {
    private final int numLocations;
    private final int numDistractorItems;
    private final int numIngredients;
    private final boolean includeDoors;
    private final boolean limitInventorySize;
    private final KitchenGameGenerator generator;

    public int numLocations() {
        return this.numLocations;
    }

    public int numDistractorItems() {
        return this.numDistractorItems;
    }

    public int numIngredients() {
        return this.numIngredients;
    }

    public boolean includeDoors() {
        return this.includeDoors;
    }

    public boolean limitInventorySize() {
        return this.limitInventorySize;
    }

    public KitchenGameGenerator generator() {
        return this.generator;
    }

    private String checkValidConfiguration() {
        scala.collection.mutable.StringBuilder os = new scala.collection.mutable.StringBuilder();
        Serializable serializable = this.numLocations() < 1 ? os.append(new StringBuilder(67).append("Number of locations must be greater than one (specified value = ").append(this.numLocations()).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable2 = this.numLocations() > 11 ? os.append(new StringBuilder(75).append("Number of locations must be less than or equal to 11 (specified value = ").append(this.numLocations()).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable3 = this.numDistractorItems() < 0 ? os.append(new StringBuilder(89).append("Number of distractor objects must be greater than or equal to zero (specified value = ").append(this.numDistractorItems()).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable4 = this.numDistractorItems() > 10 ? os.append(new StringBuilder(84).append("Number of distractor objects must be less than or equal to 10 (specified value = ").append(this.numDistractorItems()).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable5 = this.numIngredients() < 1 ? os.append(new StringBuilder(63).append("Number of ingredients must be at least 1 (specified value = ").append(this.numIngredients()).append("). ").toString()) : BoxedUnit.UNIT;
        Serializable serializable6 = this.numIngredients() > 5 ? os.append(new StringBuilder(61).append("Number of ingredients must less than 5 (specified value = ").append(this.numIngredients()).append("). ").toString()) : BoxedUnit.UNIT;
        return os.toString();
    }

    @Override
    public boolean isInvalid() {
        return this.errorStr().length() > 0;
    }

    @Override
    public TextGame mkGame(long seed, String fold) {
        return this.generator().mkGame(seed, this.numLocations(), this.numDistractorItems(), this.numIngredients(), this.includeDoors(), this.limitInventorySize(), fold);
    }

    @Override
    public Tuple2<TextGame, String[]> mkGameWithGoldPath(long seed, String fold) {
        return this.generator().mkGameWithGoldPath(seed, this.numLocations(), this.numDistractorItems(), this.numIngredients(), this.includeDoors(), this.limitInventorySize(), fold);
    }

    public GameGeneratorKitchen(int numLocations, int numDistractorItems, int numIngredients, boolean includeDoors, boolean limitInventorySize) {
        this.numLocations = numLocations;
        this.numDistractorItems = numDistractorItems;
        this.numIngredients = numIngredients;
        this.includeDoors = includeDoors;
        this.limitInventorySize = limitInventorySize;
        this.generator = new KitchenGameGenerator();
        this.errorStr_$eq(this.checkValidConfiguration());
    }
}

