/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.util.Comparator;
import scala.Function1;
import scala.Option;
import scala.math.PartialOrdering;

public interface Ordering<T>
extends Comparator<T>,
PartialOrdering<T> {
    @Override
    public int compare(T var1, T var2);

    public static /* synthetic */ boolean lteq$(Ordering $this, Object x, Object y) {
        return $this.lteq(x, y);
    }

    default public boolean lteq(T x, T y) {
        return this.compare(x, y) <= 0;
    }

    public static /* synthetic */ boolean equiv$(Ordering $this, Object x, Object y) {
        return $this.equiv(x, y);
    }

    default public boolean equiv(T x, T y) {
        return this.compare(x, y) == 0;
    }

    public static /* synthetic */ Ordering reverse$(Ordering $this) {
        return $this.reverse();
    }

    default public Ordering<T> reverse() {
        return new Reverse(this);
    }

    default public <U> Ordering<U> on(Function1<U, T> f) {
        return new Ordering<U>(this, f){
            private final /* synthetic */ Ordering $outer;
            private final Function1 f$1;

            public boolean lteq(U x, U y) {
                return Ordering.lteq$(this, x, y);
            }

            public boolean equiv(U x, U y) {
                return Ordering.equiv$(this, x, y);
            }

            public Ordering<U> reverse() {
                return Ordering.reverse$(this);
            }

            public <U> Ordering<U> on(Function1<U, U> f) {
                return Ordering.on$(this, f);
            }

            public int compare(U x, U y) {
                return this.$outer.compare(this.f$1.apply(x), this.f$1.apply(y));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        };
    }

    public static interface BooleanOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(BooleanOrdering $this, boolean x, boolean y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(boolean x, boolean y) {
            return Boolean.compare(x, y);
        }
    }

    public static interface ByteOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(ByteOrdering $this, byte x, byte y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(byte x, byte y) {
            return Byte.compare(x, y);
        }
    }

    public static interface CachedReverse<T>
    extends Ordering<T> {
        public void scala$math$Ordering$CachedReverse$_setter_$scala$math$Ordering$CachedReverse$$_reverse_$eq(Ordering<T> var1);

        public /* synthetic */ Ordering scala$math$Ordering$CachedReverse$$super$reverse();

        public Ordering<T> scala$math$Ordering$CachedReverse$$_reverse();

        public static /* synthetic */ Ordering reverse$(CachedReverse $this) {
            return $this.reverse();
        }

        @Override
        default public Ordering<T> reverse() {
            return this.scala$math$Ordering$CachedReverse$$_reverse();
        }

        public static /* synthetic */ boolean isReverseOf$(CachedReverse $this, Ordering other) {
            return $this.isReverseOf(other);
        }

        default public boolean isReverseOf(Ordering<?> other) {
            return other == this.scala$math$Ordering$CachedReverse$$_reverse();
        }

        public static void $init$(CachedReverse $this) {
            $this.scala$math$Ordering$CachedReverse$_setter_$scala$math$Ordering$CachedReverse$$_reverse_$eq($this.scala$math$Ordering$CachedReverse$$super$reverse());
        }
    }

    public static interface CharOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(CharOrdering $this, char x, char y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(char x, char y) {
            return Character.compare(x, y);
        }
    }

    public static interface IntOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(IntOrdering $this, int x, int y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(int x, int y) {
            return Integer.compare(x, y);
        }
    }

    public static interface LongOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(LongOrdering $this, long x, long y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(long x, long y) {
            return Long.compare(x, y);
        }
    }

    public static interface OptionOrdering<T>
    extends Ordering<Option<T>> {
        public Ordering<T> optionOrdering();

        @Override
        default public boolean equals(Object obj) {
            boolean bl;
            if (obj instanceof Object && this == obj) {
                bl = true;
            } else if (obj instanceof OptionOrdering) {
                OptionOrdering optionOrdering = (OptionOrdering)obj;
                Ordering<T> ordering = this.optionOrdering();
                Ordering<T> ordering2 = optionOrdering.optionOrdering();
                bl = !(ordering != null ? !ordering.equals(ordering2) : ordering2 != null);
            } else {
                bl = false;
            }
            return bl;
        }

        default public int hashCode() {
            return this.optionOrdering().hashCode() * 43;
        }
    }

    private static final class Reverse<T>
    implements Ordering<T> {
        private final Ordering<T> outer;

        @Override
        public <U> Ordering<U> on(Function1<U, T> f) {
            return ((Ordering)this).on(f);
        }

        public Ordering<T> outer() {
            return this.outer;
        }

        @Override
        public Ordering<T> reverse() {
            return this.outer();
        }

        @Override
        public int compare(T x, T y) {
            return this.outer().compare(y, x);
        }

        @Override
        public boolean lteq(T x, T y) {
            return this.outer().lteq(y, x);
        }

        @Override
        public boolean equiv(T x, T y) {
            return this.outer().equiv(y, x);
        }

        @Override
        public boolean equals(Object obj) {
            boolean bl;
            if (obj instanceof Object && this == obj) {
                bl = true;
            } else if (obj instanceof Reverse) {
                Reverse reverse = (Reverse)obj;
                Ordering<T> ordering = this.outer();
                Ordering<T> ordering2 = reverse.outer();
                bl = !(ordering != null ? !ordering.equals(ordering2) : ordering2 != null);
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.outer().hashCode() * 41;
        }

        public Reverse(Ordering<T> outer) {
            this.outer = outer;
        }
    }

    public static interface ShortOrdering
    extends Ordering<Object> {
        public static /* synthetic */ int compare$(ShortOrdering $this, short x, short y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(short x, short y) {
            return Short.compare(x, y);
        }
    }

    public static interface StringOrdering
    extends Ordering<String> {
        public static /* synthetic */ int compare$(StringOrdering $this, String x, String y) {
            return $this.compare(x, y);
        }

        @Override
        default public int compare(String x, String y) {
            return x.compareTo(y);
        }
    }
}

