/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Function1;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqOps;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range$;
import scala.collection.immutable.RangeIterator;
import scala.collection.mutable.Builder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public abstract class Range
extends AbstractSeq<Object>
implements Serializable,
scala.collection.immutable.IndexedSeq<Object>,
scala.collection.immutable.StrictOptimizedSeqOps<Object, scala.collection.immutable.IndexedSeq, scala.collection.immutable.IndexedSeq<Object>> {
    private final int start;
    private final int end;
    private final int step;
    private final boolean isEmpty;
    public final int scala$collection$immutable$Range$$numRangeElements;
    public final int scala$collection$immutable$Range$$lastElement;

    @Override
    public Object updated(int index, Object elem) {
        return scala.collection.immutable.StrictOptimizedSeqOps.updated$(this, index, elem);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
        return Seq.canEqual$(this, that);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce that) {
        return SeqOps.sameElements$(this, that);
    }

    @Override
    public boolean canEqual(Object that) {
        return scala.collection.immutable.IndexedSeq.canEqual$(this, that);
    }

    @Override
    public SeqFactory<scala.collection.immutable.IndexedSeq> iterableFactory() {
        return scala.collection.immutable.IndexedSeq.iterableFactory$(this);
    }

    @Override
    public /* synthetic */ Object scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
        return IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public String stringPrefix() {
        return IndexedSeq.stringPrefix$(this);
    }

    @Override
    public Iterator<Object> reverseIterator() {
        return IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public IndexedSeqView<Object> view() {
        return IndexedSeqOps.view$(this);
    }

    @Override
    public Iterable<Object> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    @Override
    public final int lengthCompare(int len) {
        return IndexedSeqOps.lengthCompare$(this, len);
    }

    @Override
    public int knownSize() {
        return IndexedSeqOps.knownSize$(this);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int step() {
        return this.step;
    }

    @Override
    public final Iterator<Object> iterator() {
        return new RangeIterator(this.start(), this.step(), this.scala$collection$immutable$Range$$lastElement, this.isEmpty());
    }

    private long gap() {
        return (long)this.end() - (long)this.start();
    }

    private boolean isExact() {
        return this.gap() % (long)this.step() == 0L;
    }

    private boolean hasStub() {
        return this.isInclusive() || !this.isExact();
    }

    private long longLength() {
        return this.gap() / (long)this.step() + (long)(this.hasStub() ? 1 : 0);
    }

    public abstract boolean isInclusive();

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public final int length() {
        if (this.scala$collection$immutable$Range$$numRangeElements < 0) {
            throw this.fail();
        }
        return this.scala$collection$immutable$Range$$numRangeElements;
    }

    @Override
    public final int last() {
        if (this.isEmpty()) {
            throw Range$.MODULE$.scala$collection$immutable$Range$$emptyRangeError("last");
        }
        return this.scala$collection$immutable$Range$$lastElement;
    }

    @Override
    public final int head() {
        if (this.isEmpty()) {
            throw Range$.MODULE$.scala$collection$immutable$Range$$emptyRangeError("head");
        }
        return this.start();
    }

    @Override
    public final Range tail() {
        if (this.isEmpty()) {
            throw Range$.MODULE$.scala$collection$immutable$Range$$emptyRangeError("tail");
        }
        if (this.scala$collection$immutable$Range$$numRangeElements == 1) {
            return this.newEmptyRange(this.end());
        }
        if (this.isInclusive()) {
            return new Inclusive(this.start() + this.step(), this.end(), this.step());
        }
        return new Exclusive(this.start() + this.step(), this.end(), this.step());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> scala.collection.immutable.IndexedSeq<B> map(Function1<Object, B> f) {
        this.scala$collection$immutable$Range$$validateMaxLength();
        Builder strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator strictOptimizedMap_it = this.iterator();
        while (strictOptimizedMap_it.hasNext()) {
            void strictOptimizedMap_$plus$eq_elem;
            B b = f.apply(strictOptimizedMap_it.next());
            if (strictOptimizedMap_b == null) {
                throw null;
            }
            strictOptimizedMap_b.addOne(strictOptimizedMap_$plus$eq_elem);
            b = null;
        }
        return (scala.collection.immutable.IndexedSeq)strictOptimizedMap_b.result();
    }

    public final Range copy(int start, int end, int step, boolean isInclusive) {
        if (isInclusive) {
            return new Inclusive(start, end, step);
        }
        return new Exclusive(start, end, step);
    }

    public final Range by(int step) {
        return this.copy(this.start(), this.end(), step, this.isInclusive());
    }

    public void scala$collection$immutable$Range$$validateMaxLength() {
        if (this.scala$collection$immutable$Range$$numRangeElements < 0) {
            throw this.fail();
        }
    }

    private String description() {
        return StringOps$.MODULE$.format$extension("%d %s %d by %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.start(), this.isInclusive() ? "to" : "until", this.end(), this.step()}));
    }

    private Nothing$ fail() {
        throw new IllegalArgumentException(new StringBuilder(54).append(this.description()).append(": seqs cannot contain more than Int.MaxValue elements.").toString());
    }

    @Override
    public final int apply(int idx) throws IndexOutOfBoundsException {
        return this.apply$mcII$sp(idx);
    }

    @Override
    public final <U> void foreach(Function1<Object, U> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply(i);
                if (i == this.scala$collection$immutable$Range$$lastElement) {
                    return;
                }
                i += this.step();
            }
        }
    }

    @Override
    public final <B> int indexOf(B elem, int from) {
        int n;
        int pos;
        int n2 = elem instanceof Integer ? ((pos = this.scala$collection$immutable$Range$$posOf(n = BoxesRunTime.unboxToInt(elem))) >= from ? pos : -1) : SeqOps.indexOf$(this, elem, from);
        return n2;
    }

    public int scala$collection$immutable$Range$$posOf(int i) {
        if (this.contains(i)) {
            return (i - this.start()) / this.step();
        }
        return -1;
    }

    @Override
    public <B> boolean sameElements(IterableOnce<B> that) {
        boolean bl;
        if (that instanceof Range) {
            boolean bl2;
            Range range = (Range)that;
            int n = this.length();
            switch (n) {
                case 0: {
                    bl2 = range.isEmpty();
                    break;
                }
                case 1: {
                    if (range.length() == 1 && this.start() == range.start()) {
                        bl2 = true;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                default: {
                    bl2 = range.length() == n && this.start() == range.start() && this.step() == range.step();
                }
            }
            bl = bl2;
        } else {
            bl = scala.collection.immutable.IndexedSeq.sameElements$(this, that);
        }
        return bl;
    }

    public final Range take(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this.newEmptyRange(this.start());
        }
        if (n >= this.scala$collection$immutable$Range$$numRangeElements && this.scala$collection$immutable$Range$$numRangeElements >= 0) {
            return this;
        }
        return new Inclusive(this.start(), this.locationAfterN(n - 1), this.step());
    }

    @Override
    public final Range drop(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this;
        }
        if (n >= this.scala$collection$immutable$Range$$numRangeElements && this.scala$collection$immutable$Range$$numRangeElements >= 0) {
            return this.newEmptyRange(this.end());
        }
        return this.copy(this.locationAfterN(n), this.end(), this.step(), this.isInclusive());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Range slice(int from, int until) {
        void inclusive_step;
        if (from <= 0) {
            return this.take(until);
        }
        if (until >= this.scala$collection$immutable$Range$$numRangeElements && this.scala$collection$immutable$Range$$numRangeElements >= 0) {
            return this.drop(from);
        }
        int fromValue = this.locationAfterN(from);
        if (from >= until) {
            return this.newEmptyRange(fromValue);
        }
        int n = this.step();
        int inclusive_end = this.locationAfterN(until - 1);
        return new Inclusive(fromValue, inclusive_end, (int)inclusive_step);
    }

    private int locationAfterN(int n) {
        return this.start() + this.step() * n;
    }

    private Exclusive newEmptyRange(int value) {
        return new Exclusive(value, value, this.step());
    }

    @Override
    public final boolean contains(int x) {
        if (x == this.end() && !this.isInclusive()) {
            return false;
        }
        if (this.step() > 0) {
            if (x < this.start() || x > this.end()) {
                return false;
            }
            return this.step() == 1 || (x - this.start()) % this.step() == 0;
        }
        if (x < this.end() || x > this.start()) {
            return false;
        }
        return this.step() == -1 || (x - this.start()) % this.step() == 0;
    }

    @Override
    public final <B> boolean contains(B elem) {
        boolean bl;
        if (elem instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(elem);
            bl = this.contains(n);
        } else {
            bl = SeqOps.contains$(this, elem);
        }
        return bl;
    }

    @Override
    public final int applyPreferredMaxLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean equals(Object other) {
        boolean bl;
        if (other instanceof Range) {
            int l0;
            Range range = (Range)other;
            bl = this.isEmpty() ? range.isEmpty() : range.nonEmpty() && this.start() == range.start() && (l0 = this.last()) == range.last() && (this.start() == l0 || this.step() == range.step());
        } else {
            bl = Seq.equals$(this, other);
        }
        return bl;
    }

    @Override
    public final int hashCode() {
        if (this.length() >= 2) {
            return MurmurHash3$.MODULE$.rangeHash(this.start(), this.step(), this.scala$collection$immutable$Range$$lastElement);
        }
        return MurmurHash3$.MODULE$.seqHash(this);
    }

    @Override
    public final String toString() {
        String stepped;
        String preposition = this.isInclusive() ? "to" : "until";
        String string = stepped = this.step() == 1 ? "" : new StringBuilder(4).append(" by ").append(this.step()).toString();
        String prefix = this.isEmpty() ? "empty " : (!this.isExact() ? "inexact " : "");
        return new StringBuilder(8).append(prefix).append("Range ").append(this.start()).append(" ").append(preposition).append(" ").append(this.end()).append(stepped).toString();
    }

    @Override
    public String className() {
        return "Range";
    }

    public final void foreach$mVc$sp(Function1<Object, BoxedUnit> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply$mcVI$sp(i);
                if (i == this.scala$collection$immutable$Range$$lastElement) {
                    return;
                }
                i += this.step();
            }
        }
    }

    @Override
    public int apply$mcII$sp(int idx) {
        this.scala$collection$immutable$Range$$validateMaxLength();
        if (idx < 0 || idx >= this.scala$collection$immutable$Range$$numRangeElements) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(this.scala$collection$immutable$Range$$numRangeElements - 1).append(")").toString());
        }
        return this.start() + this.step() * idx;
    }

    public Range(int start, int end, int step) {
        int n;
        long len;
        this.start = start;
        this.end = end;
        this.step = step;
        boolean bl = this.isEmpty = start > end && step > 0 || start < end && step < 0 || start == end && !this.isInclusive();
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        this.scala$collection$immutable$Range$$numRangeElements = this.isEmpty() ? 0 : ((len = this.longLength()) > Integer.MAX_VALUE ? -1 : (int)len);
        switch (step) {
            case 1: {
                if (this.isInclusive()) {
                    n = end;
                    break;
                }
                n = end - 1;
                break;
            }
            case -1: {
                if (this.isInclusive()) {
                    n = end;
                    break;
                }
                n = end + 1;
                break;
            }
            default: {
                int remainder = (int)(this.gap() % (long)step);
                n = remainder != 0 ? end - remainder : (this.isInclusive() ? end : end - step);
            }
        }
        this.scala$collection$immutable$Range$$lastElement = n;
    }

    public static final class Exclusive
    extends Range {
        @Override
        public boolean isInclusive() {
            return false;
        }

        public Exclusive(int start, int end, int step) {
            super(start, end, step);
        }
    }

    public static final class Inclusive
    extends Range {
        @Override
        public boolean isInclusive() {
            return true;
        }

        public Inclusive(int start, int end, int step) {
            super(start, end, step);
        }
    }
}

