/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.collection.Hashing$;
import scala.collection.IterableFactory;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.AbstractMap;
import scala.collection.immutable.BitmapIndexedMapNode;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.MapKeyIterator;
import scala.collection.immutable.MapKeyValueTupleHashIterator;
import scala.collection.immutable.MapKeyValueTupleIterator;
import scala.collection.immutable.MapKeyValueTupleReverseIterator;
import scala.collection.immutable.MapNode;
import scala.collection.immutable.MapNode$;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$EmptySet$;
import scala.collection.immutable.StrictOptimizedMapOps;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public final class HashMap<K, V>
extends AbstractMap<K, V>
implements DefaultSerializable,
StrictOptimizedMapOps<K, V, HashMap, HashMap<K, V>> {
    private final BitmapIndexedMapNode<K, V> rootNode;

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    public BitmapIndexedMapNode<K, V> rootNode() {
        return this.rootNode;
    }

    @Override
    public MapFactory<HashMap> mapFactory() {
        return HashMap$.MODULE$;
    }

    @Override
    public int knownSize() {
        return this.rootNode().size();
    }

    @Override
    public int size() {
        return this.rootNode().size();
    }

    @Override
    public boolean isEmpty() {
        return this.rootNode().size() == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.size() == 0) {
            return Set$EmptySet$.MODULE$;
        }
        return new HashKeySet(this);
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        if (this.isEmpty()) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new MapKeyValueTupleIterator<K, V>(this.rootNode());
    }

    @Override
    public Iterator<K> keysIterator() {
        if (this.isEmpty()) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new MapKeyIterator<K, V>(this.rootNode());
    }

    public Iterator<Tuple2<K, V>> reverseIterator() {
        if (this.isEmpty()) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new MapKeyValueTupleReverseIterator<K, V>(this.rootNode());
    }

    @Override
    public final boolean contains(K key) {
        int keyUnimprovedHash = Statics.anyHash(key);
        int keyHash = Hashing$.MODULE$.improve(keyUnimprovedHash);
        return this.rootNode().containsKey(key, keyUnimprovedHash, keyHash, 0);
    }

    @Override
    public V apply(K key) {
        int keyUnimprovedHash = Statics.anyHash(key);
        int keyHash = Hashing$.MODULE$.improve(keyUnimprovedHash);
        return this.rootNode().apply(key, keyUnimprovedHash, keyHash, 0);
    }

    @Override
    public Option<V> get(K key) {
        int keyUnimprovedHash = Statics.anyHash(key);
        int keyHash = Hashing$.MODULE$.improve(keyUnimprovedHash);
        return this.rootNode().get(key, keyUnimprovedHash, keyHash, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <V1> V1 getOrElse(K key, Function0<V1> function0) {
        void getOrElse_shift;
        int keyUnimprovedHash = Statics.anyHash(key);
        int keyHash = Hashing$.MODULE$.improve(keyUnimprovedHash);
        BitmapIndexedMapNode<K, V> bitmapIndexedMapNode = this.rootNode();
        boolean bl = false;
        if (bitmapIndexedMapNode == null) {
            throw null;
        }
        BitmapIndexedMapNode<K, V> getOrElse_this = bitmapIndexedMapNode;
        int n = keyHash >>> getOrElse_shift & 0x1F;
        int n2 = 1 << n;
        if ((getOrElse_this.dataMap() & n2) != 0) {
            Object object;
            int getOrElse_index = Node$.MODULE$.indexFrom(getOrElse_this.dataMap(), n, n2);
            Object object2 = object = getOrElse_this.content()[2 * getOrElse_index];
            object = null;
            Object getOrElse_key0 = object2;
            if (BoxesRunTime.equals(key, getOrElse_key0)) {
                return (V1)getOrElse_this.content()[2 * getOrElse_index + 1];
            }
            return function0.apply();
        }
        if ((getOrElse_this.nodeMap() & n2) != 0) {
            int getOrElse_index = Node$.MODULE$.indexFrom(getOrElse_this.nodeMap(), n, n2);
            return ((MapNode)getOrElse_this.getNode(getOrElse_index)).getOrElse(key, keyUnimprovedHash, keyHash, (int)(getOrElse_shift + 5), function0);
        }
        return function0.apply();
    }

    public <V1> HashMap<K, V1> updated(K key, V1 value) {
        int keyUnimprovedHash = Statics.anyHash(key);
        MapNode newHashMapOrThis_newRootNode = this.rootNode().updated((Object)key, (Object)value, keyUnimprovedHash, Hashing$.MODULE$.improve(keyUnimprovedHash), 0, true);
        if (newHashMapOrThis_newRootNode == this.rootNode()) {
            return this;
        }
        return new HashMap<K, V>(newHashMapOrThis_newRootNode);
    }

    public HashMap<K, V> removed(K key) {
        int keyUnimprovedHash = Statics.anyHash(key);
        MapNode newHashMapOrThis_newRootNode = this.rootNode().removed((Object)key, keyUnimprovedHash, Hashing$.MODULE$.improve(keyUnimprovedHash), 0);
        if (newHashMapOrThis_newRootNode == this.rootNode()) {
            return this;
        }
        return new HashMap<K, V>(newHashMapOrThis_newRootNode);
    }

    @Override
    public HashMap<K, V> tail() {
        Object $minus_key = ((Tuple2)this.head())._1();
        return this.removed($minus_key);
    }

    @Override
    public Tuple2<K, V> head() {
        return this.iterator().next();
    }

    @Override
    public Tuple2<K, V> last() {
        return this.reverseIterator().next();
    }

    @Override
    public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        BitmapIndexedMapNode<K, V> bitmapIndexedMapNode = this.rootNode();
        if (bitmapIndexedMapNode == null) {
            throw null;
        }
        BitmapIndexedMapNode<K, V> foreach_this = bitmapIndexedMapNode;
        int foreach_iN = foreach_this.payloadArity();
        for (int foreach_i = 0; foreach_i < foreach_iN; ++foreach_i) {
            f.apply(foreach_this.getPayload(foreach_i));
        }
        int foreach_jN = foreach_this.nodeArity();
        for (int foreach_j = 0; foreach_j < foreach_jN; ++foreach_j) {
            ((MapNode)foreach_this.getNode(foreach_j)).foreach(f);
        }
    }

    @Override
    public <U> void foreachEntry(Function2<K, V, U> f) {
        BitmapIndexedMapNode<K, V> bitmapIndexedMapNode = this.rootNode();
        if (bitmapIndexedMapNode == null) {
            throw null;
        }
        BitmapIndexedMapNode<K, V> foreachEntry_this = bitmapIndexedMapNode;
        int foreachEntry_iN = foreachEntry_this.payloadArity();
        for (int foreachEntry_i = 0; foreachEntry_i < foreachEntry_iN; ++foreachEntry_i) {
            f.apply(foreachEntry_this.content()[2 * foreachEntry_i], foreachEntry_this.content()[2 * foreachEntry_i + 1]);
        }
        int foreachEntry_jN = foreachEntry_this.nodeArity();
        for (int foreachEntry_j = 0; foreachEntry_j < foreachEntry_jN; ++foreachEntry_j) {
            ((MapNode)foreachEntry_this.getNode(foreachEntry_j)).foreachEntry(f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object that) {
        if (!(that instanceof HashMap)) return Map.equals$(this, that);
        HashMap hashMap = (HashMap)that;
        if (this == hashMap) return true;
        BitmapIndexedMapNode<K, V> bitmapIndexedMapNode = this.rootNode();
        BitmapIndexedMapNode<K, V> bitmapIndexedMapNode2 = hashMap.rootNode();
        if (bitmapIndexedMapNode != null) {
            if (!((Object)bitmapIndexedMapNode).equals(bitmapIndexedMapNode2)) return false;
            return true;
        }
        if (bitmapIndexedMapNode2 == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        if (this.isEmpty()) {
            return MurmurHash3$.MODULE$.emptyMapHash();
        }
        MapKeyValueTupleHashIterator<K, V> hashIterator = new MapKeyValueTupleHashIterator<K, V>(this.rootNode());
        return MurmurHash3$.MODULE$.unorderedHash(hashIterator, MurmurHash3$.MODULE$.mapSeed());
    }

    @Override
    public String className() {
        return "HashMap";
    }

    public HashMap<K, V> filterImpl(Function1<Tuple2<K, V>, Object> pred, boolean isFlipped) {
        BitmapIndexedMapNode bitmapIndexedMapNode;
        BitmapIndexedMapNode bitmapIndexedMapNode2 = this.rootNode();
        if (bitmapIndexedMapNode2 == null) {
            throw null;
        }
        BitmapIndexedMapNode filterImpl_this = bitmapIndexedMapNode2;
        if (filterImpl_this.size() == 0) {
            bitmapIndexedMapNode = filterImpl_this;
        } else if (filterImpl_this.size() == 1) {
            bitmapIndexedMapNode = BoxesRunTime.unboxToBoolean(pred.apply(filterImpl_this.getPayload(0))) != isFlipped ? filterImpl_this : MapNode$.MODULE$.empty();
        } else if (filterImpl_this.nodeMap() == 0) {
            int filterImpl_minimumIndex = Integer.numberOfTrailingZeros(filterImpl_this.dataMap());
            int filterImpl_maximumIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_this.dataMap());
            int filterImpl_newDataMap = 0;
            int filterImpl_newCachedHashCode = 0;
            int filterImpl_dataIndex = 0;
            for (int filterImpl_i = filterImpl_minimumIndex; filterImpl_i < filterImpl_maximumIndex; ++filterImpl_i) {
                int n = 1 << filterImpl_i;
                if ((n & filterImpl_this.dataMap()) == 0) continue;
                Tuple2<K, V> filterImpl_payload = filterImpl_this.getPayload(filterImpl_dataIndex);
                if (BoxesRunTime.unboxToBoolean(pred.apply(filterImpl_payload)) != isFlipped) {
                    filterImpl_newDataMap |= n;
                    filterImpl_newCachedHashCode += Hashing$.MODULE$.improve(filterImpl_this.originalHashes()[filterImpl_dataIndex]);
                }
                ++filterImpl_dataIndex;
            }
            if (filterImpl_newDataMap == 0) {
                bitmapIndexedMapNode = MapNode$.MODULE$.empty();
            } else if (filterImpl_newDataMap == filterImpl_this.dataMap()) {
                bitmapIndexedMapNode = filterImpl_this;
            } else {
                int filterImpl_newSize = Integer.bitCount(filterImpl_newDataMap);
                Object[] filterImpl_newContent = new Object[filterImpl_newSize * 2];
                int[] filterImpl_newOriginalHashCodes = new int[filterImpl_newSize];
                int filterImpl_newMaximumIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_newDataMap);
                int filterImpl_newDataIndex = 0;
                for (int filterImpl_j = Integer.numberOfTrailingZeros(filterImpl_newDataMap); filterImpl_j < filterImpl_newMaximumIndex; ++filterImpl_j) {
                    int n = 1 << filterImpl_j;
                    if ((n & filterImpl_newDataMap) == 0) continue;
                    int n2 = Integer.bitCount(filterImpl_this.dataMap() & n - 1);
                    filterImpl_newContent[filterImpl_newDataIndex * 2] = filterImpl_this.content()[n2 * 2];
                    filterImpl_newContent[filterImpl_newDataIndex * 2 + 1] = filterImpl_this.content()[n2 * 2 + 1];
                    filterImpl_newOriginalHashCodes[filterImpl_newDataIndex] = filterImpl_this.originalHashes()[n2];
                    ++filterImpl_newDataIndex;
                }
                bitmapIndexedMapNode = new BitmapIndexedMapNode(filterImpl_newDataMap, 0, filterImpl_newContent, filterImpl_newOriginalHashCodes, filterImpl_newSize, filterImpl_newCachedHashCode);
            }
        } else {
            int filterImpl_allMap = filterImpl_this.dataMap() | filterImpl_this.nodeMap();
            int filterImpl_minimumIndex = Integer.numberOfTrailingZeros(filterImpl_allMap);
            int filterImpl_maximumIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_allMap);
            int filterImpl_oldDataPassThrough = 0;
            int filterImpl_nodeMigrateToDataTargetMap = 0;
            AbstractBuffer filterImpl_nodesToMigrateToData = null;
            int filterImpl_nodesToPassThroughMap = 0;
            int filterImpl_mapOfNewNodes = 0;
            Object filterImpl_newNodes = null;
            int filterImpl_newDataMap = 0;
            int filterImpl_newNodeMap = 0;
            int filterImpl_newSize = 0;
            int filterImpl_newCachedHashCode = 0;
            int filterImpl_dataIndex = 0;
            int filterImpl_nodeIndex = 0;
            for (int filterImpl_i = filterImpl_minimumIndex; filterImpl_i < filterImpl_maximumIndex; ++filterImpl_i) {
                int n = 1 << filterImpl_i;
                if ((n & filterImpl_this.dataMap()) != 0) {
                    Tuple2 filterImpl_payload = filterImpl_this.getPayload(filterImpl_dataIndex);
                    if (BoxesRunTime.unboxToBoolean(pred.apply(filterImpl_payload)) != isFlipped) {
                        filterImpl_newDataMap |= n;
                        filterImpl_oldDataPassThrough |= n;
                        ++filterImpl_newSize;
                        filterImpl_newCachedHashCode += Hashing$.MODULE$.improve(filterImpl_this.originalHashes()[filterImpl_dataIndex]);
                    }
                    ++filterImpl_dataIndex;
                    continue;
                }
                if ((n & filterImpl_this.nodeMap()) == 0) continue;
                Node filterImpl_oldSubNode = filterImpl_this.getNode(filterImpl_nodeIndex);
                MapNode<K, V> filterImpl_newSubNode = ((MapNode)filterImpl_oldSubNode).filterImpl(pred, isFlipped);
                filterImpl_newSize += filterImpl_newSubNode.size();
                filterImpl_newCachedHashCode += filterImpl_newSubNode.cachedJavaKeySetHashCode();
                if (filterImpl_newSubNode.size() > 1) {
                    filterImpl_newNodeMap |= n;
                    if (filterImpl_oldSubNode == filterImpl_newSubNode) {
                        filterImpl_nodesToPassThroughMap |= n;
                    } else {
                        filterImpl_mapOfNewNodes |= n;
                        if (filterImpl_newNodes == null) {
                            filterImpl_newNodes = Queue$.MODULE$.empty();
                        }
                        ((AbstractBuffer)filterImpl_newNodes).$plus$eq(filterImpl_newSubNode);
                    }
                } else if (filterImpl_newSubNode.size() == 1) {
                    filterImpl_newDataMap |= n;
                    filterImpl_nodeMigrateToDataTargetMap |= n;
                    if (filterImpl_nodesToMigrateToData == null) {
                        filterImpl_nodesToMigrateToData = (Queue)IterableFactory.apply$(Queue$.MODULE$, Nil$.MODULE$);
                    }
                    filterImpl_nodesToMigrateToData.$plus$eq(filterImpl_newSubNode);
                }
                ++filterImpl_nodeIndex;
            }
            if (filterImpl_newSize == 0) {
                bitmapIndexedMapNode = MapNode$.MODULE$.empty();
            } else if (filterImpl_newSize == filterImpl_this.size()) {
                bitmapIndexedMapNode = filterImpl_this;
            } else {
                int filterImpl_newDataSize = Integer.bitCount(filterImpl_newDataMap);
                int filterImpl_newContentSize = 2 * filterImpl_newDataSize + Integer.bitCount(filterImpl_newNodeMap);
                Object[] filterImpl_newContent = new Object[filterImpl_newContentSize];
                int[] filterImpl_newOriginalHashes = new int[filterImpl_newDataSize];
                int filterImpl_newAllMap = filterImpl_newDataMap | filterImpl_newNodeMap;
                int filterImpl_maxIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_newAllMap);
                int filterImpl_oldDataIndex = 0;
                int filterImpl_oldNodeIndex = 0;
                int filterImpl_newDataIndex = 0;
                int filterImpl_newNodeIndex = 0;
                for (int filterImpl_i = filterImpl_minimumIndex; filterImpl_i < filterImpl_maxIndex; ++filterImpl_i) {
                    int filterImpl_bitpos = Node$.MODULE$.bitposFrom(filterImpl_i);
                    if ((filterImpl_bitpos & filterImpl_oldDataPassThrough) != 0) {
                        filterImpl_newContent[filterImpl_newDataIndex * 2] = filterImpl_this.content()[2 * filterImpl_oldDataIndex];
                        filterImpl_newContent[filterImpl_newDataIndex * 2 + 1] = filterImpl_this.content()[2 * filterImpl_oldDataIndex + 1];
                        filterImpl_newOriginalHashes[filterImpl_newDataIndex] = filterImpl_this.originalHashes()[filterImpl_oldDataIndex];
                        ++filterImpl_newDataIndex;
                        ++filterImpl_oldDataIndex;
                        continue;
                    }
                    if ((filterImpl_bitpos & filterImpl_nodesToPassThroughMap) != 0) {
                        filterImpl_newContent[filterImpl_newContentSize - filterImpl_newNodeIndex - 1] = filterImpl_this.getNode(filterImpl_oldNodeIndex);
                        ++filterImpl_newNodeIndex;
                        ++filterImpl_oldNodeIndex;
                        continue;
                    }
                    if ((filterImpl_bitpos & filterImpl_nodeMigrateToDataTargetMap) != 0) {
                        MapNode filterImpl_node = (MapNode)((Queue)filterImpl_nodesToMigrateToData).dequeue();
                        filterImpl_newContent[2 * filterImpl_newDataIndex] = filterImpl_node.getKey(0);
                        filterImpl_newContent[2 * filterImpl_newDataIndex + 1] = filterImpl_node.getValue(0);
                        filterImpl_newOriginalHashes[filterImpl_newDataIndex] = filterImpl_node.getHash(0);
                        ++filterImpl_newDataIndex;
                        ++filterImpl_oldNodeIndex;
                        continue;
                    }
                    if ((filterImpl_bitpos & filterImpl_mapOfNewNodes) != 0) {
                        filterImpl_newContent[filterImpl_newContentSize - filterImpl_newNodeIndex - 1] = ((Queue)filterImpl_newNodes).dequeue();
                        ++filterImpl_newNodeIndex;
                        ++filterImpl_oldNodeIndex;
                        continue;
                    }
                    if ((filterImpl_bitpos & filterImpl_this.dataMap()) != 0) {
                        ++filterImpl_oldDataIndex;
                        continue;
                    }
                    if ((filterImpl_bitpos & filterImpl_this.nodeMap()) == 0) continue;
                    ++filterImpl_oldNodeIndex;
                }
                bitmapIndexedMapNode = new BitmapIndexedMapNode(filterImpl_newDataMap, filterImpl_newNodeMap, filterImpl_newContent, filterImpl_newOriginalHashes, filterImpl_newSize, filterImpl_newCachedHashCode);
            }
        }
        Object var4_3 = null;
        Object var11_11 = null;
        Object var13_13 = null;
        Object var14_14 = null;
        Object var23_25 = null;
        Object var26_28 = null;
        Object var34_36 = null;
        Object var35_37 = null;
        Object var36_38 = null;
        Object var39_42 = null;
        Object var40_43 = null;
        Object var49_52 = null;
        BitmapIndexedMapNode newRootNode = bitmapIndexedMapNode;
        if (newRootNode == this.rootNode()) {
            return this;
        }
        if (newRootNode.size() == 0) {
            return HashMap$.MODULE$.empty();
        }
        return new HashMap<K, V>(newRootNode);
    }

    @Override
    public HashMap<K, V> drop(int n) {
        return (HashMap)IterableOps.drop$(this, n);
    }

    public HashMap(BitmapIndexedMapNode<K, V> rootNode) {
        this.rootNode = rootNode;
        Statics.releaseFence();
    }

    public HashMap() {
        this(MapNode$.MODULE$.empty());
    }

    private final class HashKeySet
    extends MapOps.ImmutableKeySet {
        private Set<K> newKeySetOrThis(HashMap<K, ?> newHashMap) {
            if (newHashMap == this.scala$collection$immutable$HashMap$HashKeySet$$$outer()) {
                return this;
            }
            return newHashMap.keySet();
        }

        private Set<K> newKeySetOrThis(BitmapIndexedMapNode<K, ?> newRootNode) {
            if (newRootNode == this.scala$collection$immutable$HashMap$HashKeySet$$$outer().rootNode()) {
                return this;
            }
            return new HashMap(newRootNode).keySet();
        }

        @Override
        public Set<K> incl(K elem) {
            int originalHash = Statics.anyHash(elem);
            int improvedHash = Hashing$.MODULE$.improve(originalHash);
            MapNode newNode = this.scala$collection$immutable$HashMap$HashKeySet$$$outer().rootNode().updated(elem, (Object)null, originalHash, improvedHash, 0, false);
            return this.newKeySetOrThis((BitmapIndexedMapNode)newNode);
        }

        @Override
        public Set<K> excl(K elem) {
            HashMap hashMap = this.scala$collection$immutable$HashMap$HashKeySet$$$outer();
            if (hashMap == null) {
                throw null;
            }
            return this.newKeySetOrThis((HashMap)hashMap.removed(elem));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<K> filter(Function1<K, Object> pred) {
            BitmapIndexedMapNode bitmapIndexedMapNode;
            HashMap hashMap = this.scala$collection$immutable$HashMap$HashKeySet$$$outer();
            Function1<Tuple2, Object> & Serializable intersect = (Function1<Tuple2, Object> & Serializable)kv -> BoxesRunTime.boxToBoolean(HashKeySet.$anonfun$filter$1(pred, kv));
            if (hashMap == null) {
                throw null;
            }
            HashMap filter_this = hashMap;
            boolean filterImpl_isFlipped = false;
            BitmapIndexedMapNode bitmapIndexedMapNode2 = filter_this.rootNode();
            if (bitmapIndexedMapNode2 == null) {
                throw null;
            }
            BitmapIndexedMapNode filterImpl_filterImpl_this = bitmapIndexedMapNode2;
            if (filterImpl_filterImpl_this.size() == 0) {
                bitmapIndexedMapNode = filterImpl_filterImpl_this;
            } else if (filterImpl_filterImpl_this.size() == 1) {
                Tuple2 tuple2 = filterImpl_filterImpl_this.getPayload(0);
                bitmapIndexedMapNode = BoxesRunTime.unboxToBoolean(pred.apply(tuple2._1())) != filterImpl_isFlipped ? filterImpl_filterImpl_this : MapNode$.MODULE$.empty();
            } else if (filterImpl_filterImpl_this.nodeMap() == 0) {
                int filterImpl_filterImpl_minimumIndex = Integer.numberOfTrailingZeros(filterImpl_filterImpl_this.dataMap());
                int filterImpl_filterImpl_maximumIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_filterImpl_this.dataMap());
                int filterImpl_filterImpl_newDataMap = 0;
                int filterImpl_filterImpl_newCachedHashCode = 0;
                int filterImpl_filterImpl_dataIndex = 0;
                for (int filterImpl_filterImpl_i = filterImpl_filterImpl_minimumIndex; filterImpl_filterImpl_i < filterImpl_filterImpl_maximumIndex; ++filterImpl_filterImpl_i) {
                    int n = 1 << filterImpl_filterImpl_i;
                    if ((n & filterImpl_filterImpl_this.dataMap()) == 0) continue;
                    Tuple2 tuple2 = filterImpl_filterImpl_this.getPayload(filterImpl_filterImpl_dataIndex);
                    if (BoxesRunTime.unboxToBoolean(pred.apply(tuple2._1())) != filterImpl_isFlipped) {
                        filterImpl_filterImpl_newDataMap |= n;
                        filterImpl_filterImpl_newCachedHashCode += Hashing$.MODULE$.improve(filterImpl_filterImpl_this.originalHashes()[filterImpl_filterImpl_dataIndex]);
                    }
                    ++filterImpl_filterImpl_dataIndex;
                }
                if (filterImpl_filterImpl_newDataMap == 0) {
                    bitmapIndexedMapNode = MapNode$.MODULE$.empty();
                } else if (filterImpl_filterImpl_newDataMap == filterImpl_filterImpl_this.dataMap()) {
                    bitmapIndexedMapNode = filterImpl_filterImpl_this;
                } else {
                    int filterImpl_filterImpl_newSize = Integer.bitCount(filterImpl_filterImpl_newDataMap);
                    Object[] filterImpl_filterImpl_newContent = new Object[filterImpl_filterImpl_newSize * 2];
                    int[] filterImpl_filterImpl_newOriginalHashCodes = new int[filterImpl_filterImpl_newSize];
                    int filterImpl_filterImpl_newMaximumIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_filterImpl_newDataMap);
                    int filterImpl_filterImpl_newDataIndex = 0;
                    for (int filterImpl_filterImpl_j = Integer.numberOfTrailingZeros(filterImpl_filterImpl_newDataMap); filterImpl_filterImpl_j < filterImpl_filterImpl_newMaximumIndex; ++filterImpl_filterImpl_j) {
                        int n = 1 << filterImpl_filterImpl_j;
                        if ((n & filterImpl_filterImpl_newDataMap) == 0) continue;
                        int n2 = Integer.bitCount(filterImpl_filterImpl_this.dataMap() & n - 1);
                        filterImpl_filterImpl_newContent[filterImpl_filterImpl_newDataIndex * 2] = filterImpl_filterImpl_this.content()[n2 * 2];
                        filterImpl_filterImpl_newContent[filterImpl_filterImpl_newDataIndex * 2 + 1] = filterImpl_filterImpl_this.content()[n2 * 2 + 1];
                        filterImpl_filterImpl_newOriginalHashCodes[filterImpl_filterImpl_newDataIndex] = filterImpl_filterImpl_this.originalHashes()[n2];
                        ++filterImpl_filterImpl_newDataIndex;
                    }
                    bitmapIndexedMapNode = new BitmapIndexedMapNode(filterImpl_filterImpl_newDataMap, 0, filterImpl_filterImpl_newContent, filterImpl_filterImpl_newOriginalHashCodes, filterImpl_filterImpl_newSize, filterImpl_filterImpl_newCachedHashCode);
                }
            } else {
                int filterImpl_filterImpl_allMap = filterImpl_filterImpl_this.dataMap() | filterImpl_filterImpl_this.nodeMap();
                int filterImpl_filterImpl_minimumIndex = Integer.numberOfTrailingZeros(filterImpl_filterImpl_allMap);
                int filterImpl_filterImpl_maximumIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_filterImpl_allMap);
                int filterImpl_filterImpl_oldDataPassThrough = 0;
                int filterImpl_filterImpl_nodeMigrateToDataTargetMap = 0;
                AbstractBuffer filterImpl_filterImpl_nodesToMigrateToData = null;
                int filterImpl_filterImpl_nodesToPassThroughMap = 0;
                int filterImpl_filterImpl_mapOfNewNodes = 0;
                Object filterImpl_filterImpl_newNodes = null;
                int filterImpl_filterImpl_newDataMap = 0;
                int filterImpl_filterImpl_newNodeMap = 0;
                int filterImpl_filterImpl_newSize = 0;
                int filterImpl_filterImpl_newCachedHashCode = 0;
                int filterImpl_filterImpl_dataIndex = 0;
                int filterImpl_filterImpl_nodeIndex = 0;
                for (int filterImpl_filterImpl_i = filterImpl_filterImpl_minimumIndex; filterImpl_filterImpl_i < filterImpl_filterImpl_maximumIndex; ++filterImpl_filterImpl_i) {
                    void filter_pred;
                    int n = 1 << filterImpl_filterImpl_i;
                    if ((n & filterImpl_filterImpl_this.dataMap()) != 0) {
                        Tuple2 tuple2 = filterImpl_filterImpl_this.getPayload(filterImpl_filterImpl_dataIndex);
                        if (BoxesRunTime.unboxToBoolean(pred.apply(tuple2._1())) != filterImpl_isFlipped) {
                            filterImpl_filterImpl_newDataMap |= n;
                            filterImpl_filterImpl_oldDataPassThrough |= n;
                            ++filterImpl_filterImpl_newSize;
                            filterImpl_filterImpl_newCachedHashCode += Hashing$.MODULE$.improve(filterImpl_filterImpl_this.originalHashes()[filterImpl_filterImpl_dataIndex]);
                        }
                        ++filterImpl_filterImpl_dataIndex;
                        continue;
                    }
                    if ((n & filterImpl_filterImpl_this.nodeMap()) == 0) continue;
                    Node filterImpl_filterImpl_oldSubNode = filterImpl_filterImpl_this.getNode(filterImpl_filterImpl_nodeIndex);
                    MapNode filterImpl_filterImpl_newSubNode = ((MapNode)filterImpl_filterImpl_oldSubNode).filterImpl(filter_pred, filterImpl_isFlipped);
                    filterImpl_filterImpl_newSize += filterImpl_filterImpl_newSubNode.size();
                    filterImpl_filterImpl_newCachedHashCode += filterImpl_filterImpl_newSubNode.cachedJavaKeySetHashCode();
                    if (filterImpl_filterImpl_newSubNode.size() > 1) {
                        filterImpl_filterImpl_newNodeMap |= n;
                        if (filterImpl_filterImpl_oldSubNode == filterImpl_filterImpl_newSubNode) {
                            filterImpl_filterImpl_nodesToPassThroughMap |= n;
                        } else {
                            filterImpl_filterImpl_mapOfNewNodes |= n;
                            if (filterImpl_filterImpl_newNodes == null) {
                                filterImpl_filterImpl_newNodes = Queue$.MODULE$.empty();
                            }
                            ((AbstractBuffer)filterImpl_filterImpl_newNodes).$plus$eq(filterImpl_filterImpl_newSubNode);
                        }
                    } else if (filterImpl_filterImpl_newSubNode.size() == 1) {
                        filterImpl_filterImpl_newDataMap |= n;
                        filterImpl_filterImpl_nodeMigrateToDataTargetMap |= n;
                        if (filterImpl_filterImpl_nodesToMigrateToData == null) {
                            filterImpl_filterImpl_nodesToMigrateToData = (Queue)IterableFactory.apply$(Queue$.MODULE$, Nil$.MODULE$);
                        }
                        filterImpl_filterImpl_nodesToMigrateToData.$plus$eq(filterImpl_filterImpl_newSubNode);
                    }
                    ++filterImpl_filterImpl_nodeIndex;
                }
                if (filterImpl_filterImpl_newSize == 0) {
                    bitmapIndexedMapNode = MapNode$.MODULE$.empty();
                } else if (filterImpl_filterImpl_newSize == filterImpl_filterImpl_this.size()) {
                    bitmapIndexedMapNode = filterImpl_filterImpl_this;
                } else {
                    int filterImpl_filterImpl_newDataSize = Integer.bitCount(filterImpl_filterImpl_newDataMap);
                    int filterImpl_filterImpl_newContentSize = 2 * filterImpl_filterImpl_newDataSize + Integer.bitCount(filterImpl_filterImpl_newNodeMap);
                    Object[] filterImpl_filterImpl_newContent = new Object[filterImpl_filterImpl_newContentSize];
                    int[] filterImpl_filterImpl_newOriginalHashes = new int[filterImpl_filterImpl_newDataSize];
                    int filterImpl_filterImpl_newAllMap = filterImpl_filterImpl_newDataMap | filterImpl_filterImpl_newNodeMap;
                    int filterImpl_filterImpl_maxIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_filterImpl_newAllMap);
                    int filterImpl_filterImpl_oldDataIndex = 0;
                    int filterImpl_filterImpl_oldNodeIndex = 0;
                    int filterImpl_filterImpl_newDataIndex = 0;
                    int filterImpl_filterImpl_newNodeIndex = 0;
                    for (int filterImpl_filterImpl_i = filterImpl_filterImpl_minimumIndex; filterImpl_filterImpl_i < filterImpl_filterImpl_maxIndex; ++filterImpl_filterImpl_i) {
                        int filterImpl_filterImpl_bitpos = Node$.MODULE$.bitposFrom(filterImpl_filterImpl_i);
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_oldDataPassThrough) != 0) {
                            filterImpl_filterImpl_newContent[filterImpl_filterImpl_newDataIndex * 2] = filterImpl_filterImpl_this.content()[2 * filterImpl_filterImpl_oldDataIndex];
                            filterImpl_filterImpl_newContent[filterImpl_filterImpl_newDataIndex * 2 + 1] = filterImpl_filterImpl_this.content()[2 * filterImpl_filterImpl_oldDataIndex + 1];
                            filterImpl_filterImpl_newOriginalHashes[filterImpl_filterImpl_newDataIndex] = filterImpl_filterImpl_this.originalHashes()[filterImpl_filterImpl_oldDataIndex];
                            ++filterImpl_filterImpl_newDataIndex;
                            ++filterImpl_filterImpl_oldDataIndex;
                            continue;
                        }
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_nodesToPassThroughMap) != 0) {
                            filterImpl_filterImpl_newContent[filterImpl_filterImpl_newContentSize - filterImpl_filterImpl_newNodeIndex - 1] = filterImpl_filterImpl_this.getNode(filterImpl_filterImpl_oldNodeIndex);
                            ++filterImpl_filterImpl_newNodeIndex;
                            ++filterImpl_filterImpl_oldNodeIndex;
                            continue;
                        }
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_nodeMigrateToDataTargetMap) != 0) {
                            MapNode filterImpl_filterImpl_node = (MapNode)((Queue)filterImpl_filterImpl_nodesToMigrateToData).dequeue();
                            filterImpl_filterImpl_newContent[2 * filterImpl_filterImpl_newDataIndex] = filterImpl_filterImpl_node.getKey(0);
                            filterImpl_filterImpl_newContent[2 * filterImpl_filterImpl_newDataIndex + 1] = filterImpl_filterImpl_node.getValue(0);
                            filterImpl_filterImpl_newOriginalHashes[filterImpl_filterImpl_newDataIndex] = filterImpl_filterImpl_node.getHash(0);
                            ++filterImpl_filterImpl_newDataIndex;
                            ++filterImpl_filterImpl_oldNodeIndex;
                            continue;
                        }
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_mapOfNewNodes) != 0) {
                            filterImpl_filterImpl_newContent[filterImpl_filterImpl_newContentSize - filterImpl_filterImpl_newNodeIndex - 1] = ((Queue)filterImpl_filterImpl_newNodes).dequeue();
                            ++filterImpl_filterImpl_newNodeIndex;
                            ++filterImpl_filterImpl_oldNodeIndex;
                            continue;
                        }
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_this.dataMap()) != 0) {
                            ++filterImpl_filterImpl_oldDataIndex;
                            continue;
                        }
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_this.nodeMap()) == 0) continue;
                        ++filterImpl_filterImpl_oldNodeIndex;
                    }
                    bitmapIndexedMapNode = new BitmapIndexedMapNode(filterImpl_filterImpl_newDataMap, filterImpl_filterImpl_newNodeMap, filterImpl_filterImpl_newContent, filterImpl_filterImpl_newOriginalHashes, filterImpl_filterImpl_newSize, filterImpl_filterImpl_newCachedHashCode);
                }
            }
            Object var6_5 = null;
            Object var14_17 = null;
            Object var15_18 = null;
            Object var24_29 = null;
            Object var27_32 = null;
            Object var35_40 = null;
            Object var36_41 = null;
            Object var39_45 = null;
            Object var40_46 = null;
            Object var49_55 = null;
            BitmapIndexedMapNode filterImpl_newRootNode = bitmapIndexedMapNode;
            Object var5_56 = null;
            Object var2_3 = null;
            intersect = null;
            return this.newKeySetOrThis((HashMap)(filterImpl_newRootNode == filter_this.rootNode() ? filter_this : (filterImpl_newRootNode.size() == 0 ? HashMap$.MODULE$.empty() : new HashMap(filterImpl_newRootNode))));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<K> filterNot(Function1<K, Object> pred) {
            BitmapIndexedMapNode bitmapIndexedMapNode;
            HashMap hashMap = this.scala$collection$immutable$HashMap$HashKeySet$$$outer();
            Function1<Tuple2, Object> & Serializable intersect = (Function1<Tuple2, Object> & Serializable)kv -> BoxesRunTime.boxToBoolean(HashKeySet.$anonfun$filterNot$1(pred, kv));
            if (hashMap == null) {
                throw null;
            }
            HashMap filterNot_this = hashMap;
            boolean filterImpl_isFlipped = true;
            BitmapIndexedMapNode bitmapIndexedMapNode2 = filterNot_this.rootNode();
            if (bitmapIndexedMapNode2 == null) {
                throw null;
            }
            BitmapIndexedMapNode filterImpl_filterImpl_this = bitmapIndexedMapNode2;
            if (filterImpl_filterImpl_this.size() == 0) {
                bitmapIndexedMapNode = filterImpl_filterImpl_this;
            } else if (filterImpl_filterImpl_this.size() == 1) {
                Tuple2 tuple2 = filterImpl_filterImpl_this.getPayload(0);
                bitmapIndexedMapNode = BoxesRunTime.unboxToBoolean(pred.apply(tuple2._1())) != filterImpl_isFlipped ? filterImpl_filterImpl_this : MapNode$.MODULE$.empty();
            } else if (filterImpl_filterImpl_this.nodeMap() == 0) {
                int filterImpl_filterImpl_minimumIndex = Integer.numberOfTrailingZeros(filterImpl_filterImpl_this.dataMap());
                int filterImpl_filterImpl_maximumIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_filterImpl_this.dataMap());
                int filterImpl_filterImpl_newDataMap = 0;
                int filterImpl_filterImpl_newCachedHashCode = 0;
                int filterImpl_filterImpl_dataIndex = 0;
                for (int filterImpl_filterImpl_i = filterImpl_filterImpl_minimumIndex; filterImpl_filterImpl_i < filterImpl_filterImpl_maximumIndex; ++filterImpl_filterImpl_i) {
                    int n = 1 << filterImpl_filterImpl_i;
                    if ((n & filterImpl_filterImpl_this.dataMap()) == 0) continue;
                    Tuple2 tuple2 = filterImpl_filterImpl_this.getPayload(filterImpl_filterImpl_dataIndex);
                    if (BoxesRunTime.unboxToBoolean(pred.apply(tuple2._1())) != filterImpl_isFlipped) {
                        filterImpl_filterImpl_newDataMap |= n;
                        filterImpl_filterImpl_newCachedHashCode += Hashing$.MODULE$.improve(filterImpl_filterImpl_this.originalHashes()[filterImpl_filterImpl_dataIndex]);
                    }
                    ++filterImpl_filterImpl_dataIndex;
                }
                if (filterImpl_filterImpl_newDataMap == 0) {
                    bitmapIndexedMapNode = MapNode$.MODULE$.empty();
                } else if (filterImpl_filterImpl_newDataMap == filterImpl_filterImpl_this.dataMap()) {
                    bitmapIndexedMapNode = filterImpl_filterImpl_this;
                } else {
                    int filterImpl_filterImpl_newSize = Integer.bitCount(filterImpl_filterImpl_newDataMap);
                    Object[] filterImpl_filterImpl_newContent = new Object[filterImpl_filterImpl_newSize * 2];
                    int[] filterImpl_filterImpl_newOriginalHashCodes = new int[filterImpl_filterImpl_newSize];
                    int filterImpl_filterImpl_newMaximumIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_filterImpl_newDataMap);
                    int filterImpl_filterImpl_newDataIndex = 0;
                    for (int filterImpl_filterImpl_j = Integer.numberOfTrailingZeros(filterImpl_filterImpl_newDataMap); filterImpl_filterImpl_j < filterImpl_filterImpl_newMaximumIndex; ++filterImpl_filterImpl_j) {
                        int n = 1 << filterImpl_filterImpl_j;
                        if ((n & filterImpl_filterImpl_newDataMap) == 0) continue;
                        int n2 = Integer.bitCount(filterImpl_filterImpl_this.dataMap() & n - 1);
                        filterImpl_filterImpl_newContent[filterImpl_filterImpl_newDataIndex * 2] = filterImpl_filterImpl_this.content()[n2 * 2];
                        filterImpl_filterImpl_newContent[filterImpl_filterImpl_newDataIndex * 2 + 1] = filterImpl_filterImpl_this.content()[n2 * 2 + 1];
                        filterImpl_filterImpl_newOriginalHashCodes[filterImpl_filterImpl_newDataIndex] = filterImpl_filterImpl_this.originalHashes()[n2];
                        ++filterImpl_filterImpl_newDataIndex;
                    }
                    bitmapIndexedMapNode = new BitmapIndexedMapNode(filterImpl_filterImpl_newDataMap, 0, filterImpl_filterImpl_newContent, filterImpl_filterImpl_newOriginalHashCodes, filterImpl_filterImpl_newSize, filterImpl_filterImpl_newCachedHashCode);
                }
            } else {
                int filterImpl_filterImpl_allMap = filterImpl_filterImpl_this.dataMap() | filterImpl_filterImpl_this.nodeMap();
                int filterImpl_filterImpl_minimumIndex = Integer.numberOfTrailingZeros(filterImpl_filterImpl_allMap);
                int filterImpl_filterImpl_maximumIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_filterImpl_allMap);
                int filterImpl_filterImpl_oldDataPassThrough = 0;
                int filterImpl_filterImpl_nodeMigrateToDataTargetMap = 0;
                AbstractBuffer filterImpl_filterImpl_nodesToMigrateToData = null;
                int filterImpl_filterImpl_nodesToPassThroughMap = 0;
                int filterImpl_filterImpl_mapOfNewNodes = 0;
                Object filterImpl_filterImpl_newNodes = null;
                int filterImpl_filterImpl_newDataMap = 0;
                int filterImpl_filterImpl_newNodeMap = 0;
                int filterImpl_filterImpl_newSize = 0;
                int filterImpl_filterImpl_newCachedHashCode = 0;
                int filterImpl_filterImpl_dataIndex = 0;
                int filterImpl_filterImpl_nodeIndex = 0;
                for (int filterImpl_filterImpl_i = filterImpl_filterImpl_minimumIndex; filterImpl_filterImpl_i < filterImpl_filterImpl_maximumIndex; ++filterImpl_filterImpl_i) {
                    void filterNot_pred;
                    int n = 1 << filterImpl_filterImpl_i;
                    if ((n & filterImpl_filterImpl_this.dataMap()) != 0) {
                        Tuple2 tuple2 = filterImpl_filterImpl_this.getPayload(filterImpl_filterImpl_dataIndex);
                        if (BoxesRunTime.unboxToBoolean(pred.apply(tuple2._1())) != filterImpl_isFlipped) {
                            filterImpl_filterImpl_newDataMap |= n;
                            filterImpl_filterImpl_oldDataPassThrough |= n;
                            ++filterImpl_filterImpl_newSize;
                            filterImpl_filterImpl_newCachedHashCode += Hashing$.MODULE$.improve(filterImpl_filterImpl_this.originalHashes()[filterImpl_filterImpl_dataIndex]);
                        }
                        ++filterImpl_filterImpl_dataIndex;
                        continue;
                    }
                    if ((n & filterImpl_filterImpl_this.nodeMap()) == 0) continue;
                    Node filterImpl_filterImpl_oldSubNode = filterImpl_filterImpl_this.getNode(filterImpl_filterImpl_nodeIndex);
                    MapNode filterImpl_filterImpl_newSubNode = ((MapNode)filterImpl_filterImpl_oldSubNode).filterImpl(filterNot_pred, filterImpl_isFlipped);
                    filterImpl_filterImpl_newSize += filterImpl_filterImpl_newSubNode.size();
                    filterImpl_filterImpl_newCachedHashCode += filterImpl_filterImpl_newSubNode.cachedJavaKeySetHashCode();
                    if (filterImpl_filterImpl_newSubNode.size() > 1) {
                        filterImpl_filterImpl_newNodeMap |= n;
                        if (filterImpl_filterImpl_oldSubNode == filterImpl_filterImpl_newSubNode) {
                            filterImpl_filterImpl_nodesToPassThroughMap |= n;
                        } else {
                            filterImpl_filterImpl_mapOfNewNodes |= n;
                            if (filterImpl_filterImpl_newNodes == null) {
                                filterImpl_filterImpl_newNodes = Queue$.MODULE$.empty();
                            }
                            ((AbstractBuffer)filterImpl_filterImpl_newNodes).$plus$eq(filterImpl_filterImpl_newSubNode);
                        }
                    } else if (filterImpl_filterImpl_newSubNode.size() == 1) {
                        filterImpl_filterImpl_newDataMap |= n;
                        filterImpl_filterImpl_nodeMigrateToDataTargetMap |= n;
                        if (filterImpl_filterImpl_nodesToMigrateToData == null) {
                            filterImpl_filterImpl_nodesToMigrateToData = (Queue)IterableFactory.apply$(Queue$.MODULE$, Nil$.MODULE$);
                        }
                        filterImpl_filterImpl_nodesToMigrateToData.$plus$eq(filterImpl_filterImpl_newSubNode);
                    }
                    ++filterImpl_filterImpl_nodeIndex;
                }
                if (filterImpl_filterImpl_newSize == 0) {
                    bitmapIndexedMapNode = MapNode$.MODULE$.empty();
                } else if (filterImpl_filterImpl_newSize == filterImpl_filterImpl_this.size()) {
                    bitmapIndexedMapNode = filterImpl_filterImpl_this;
                } else {
                    int filterImpl_filterImpl_newDataSize = Integer.bitCount(filterImpl_filterImpl_newDataMap);
                    int filterImpl_filterImpl_newContentSize = 2 * filterImpl_filterImpl_newDataSize + Integer.bitCount(filterImpl_filterImpl_newNodeMap);
                    Object[] filterImpl_filterImpl_newContent = new Object[filterImpl_filterImpl_newContentSize];
                    int[] filterImpl_filterImpl_newOriginalHashes = new int[filterImpl_filterImpl_newDataSize];
                    int filterImpl_filterImpl_newAllMap = filterImpl_filterImpl_newDataMap | filterImpl_filterImpl_newNodeMap;
                    int filterImpl_filterImpl_maxIndex = 32 - Integer.numberOfLeadingZeros(filterImpl_filterImpl_newAllMap);
                    int filterImpl_filterImpl_oldDataIndex = 0;
                    int filterImpl_filterImpl_oldNodeIndex = 0;
                    int filterImpl_filterImpl_newDataIndex = 0;
                    int filterImpl_filterImpl_newNodeIndex = 0;
                    for (int filterImpl_filterImpl_i = filterImpl_filterImpl_minimumIndex; filterImpl_filterImpl_i < filterImpl_filterImpl_maxIndex; ++filterImpl_filterImpl_i) {
                        int filterImpl_filterImpl_bitpos = Node$.MODULE$.bitposFrom(filterImpl_filterImpl_i);
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_oldDataPassThrough) != 0) {
                            filterImpl_filterImpl_newContent[filterImpl_filterImpl_newDataIndex * 2] = filterImpl_filterImpl_this.content()[2 * filterImpl_filterImpl_oldDataIndex];
                            filterImpl_filterImpl_newContent[filterImpl_filterImpl_newDataIndex * 2 + 1] = filterImpl_filterImpl_this.content()[2 * filterImpl_filterImpl_oldDataIndex + 1];
                            filterImpl_filterImpl_newOriginalHashes[filterImpl_filterImpl_newDataIndex] = filterImpl_filterImpl_this.originalHashes()[filterImpl_filterImpl_oldDataIndex];
                            ++filterImpl_filterImpl_newDataIndex;
                            ++filterImpl_filterImpl_oldDataIndex;
                            continue;
                        }
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_nodesToPassThroughMap) != 0) {
                            filterImpl_filterImpl_newContent[filterImpl_filterImpl_newContentSize - filterImpl_filterImpl_newNodeIndex - 1] = filterImpl_filterImpl_this.getNode(filterImpl_filterImpl_oldNodeIndex);
                            ++filterImpl_filterImpl_newNodeIndex;
                            ++filterImpl_filterImpl_oldNodeIndex;
                            continue;
                        }
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_nodeMigrateToDataTargetMap) != 0) {
                            MapNode filterImpl_filterImpl_node = (MapNode)((Queue)filterImpl_filterImpl_nodesToMigrateToData).dequeue();
                            filterImpl_filterImpl_newContent[2 * filterImpl_filterImpl_newDataIndex] = filterImpl_filterImpl_node.getKey(0);
                            filterImpl_filterImpl_newContent[2 * filterImpl_filterImpl_newDataIndex + 1] = filterImpl_filterImpl_node.getValue(0);
                            filterImpl_filterImpl_newOriginalHashes[filterImpl_filterImpl_newDataIndex] = filterImpl_filterImpl_node.getHash(0);
                            ++filterImpl_filterImpl_newDataIndex;
                            ++filterImpl_filterImpl_oldNodeIndex;
                            continue;
                        }
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_mapOfNewNodes) != 0) {
                            filterImpl_filterImpl_newContent[filterImpl_filterImpl_newContentSize - filterImpl_filterImpl_newNodeIndex - 1] = ((Queue)filterImpl_filterImpl_newNodes).dequeue();
                            ++filterImpl_filterImpl_newNodeIndex;
                            ++filterImpl_filterImpl_oldNodeIndex;
                            continue;
                        }
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_this.dataMap()) != 0) {
                            ++filterImpl_filterImpl_oldDataIndex;
                            continue;
                        }
                        if ((filterImpl_filterImpl_bitpos & filterImpl_filterImpl_this.nodeMap()) == 0) continue;
                        ++filterImpl_filterImpl_oldNodeIndex;
                    }
                    bitmapIndexedMapNode = new BitmapIndexedMapNode(filterImpl_filterImpl_newDataMap, filterImpl_filterImpl_newNodeMap, filterImpl_filterImpl_newContent, filterImpl_filterImpl_newOriginalHashes, filterImpl_filterImpl_newSize, filterImpl_filterImpl_newCachedHashCode);
                }
            }
            Object var6_5 = null;
            Object var14_17 = null;
            Object var15_18 = null;
            Object var24_29 = null;
            Object var27_32 = null;
            Object var35_40 = null;
            Object var36_41 = null;
            Object var39_45 = null;
            Object var40_46 = null;
            Object var49_55 = null;
            BitmapIndexedMapNode filterImpl_newRootNode = bitmapIndexedMapNode;
            Object var5_56 = null;
            Object var2_3 = null;
            intersect = null;
            return this.newKeySetOrThis((HashMap)(filterImpl_newRootNode == filterNot_this.rootNode() ? filterNot_this : (filterImpl_newRootNode.size() == 0 ? HashMap$.MODULE$.empty() : new HashMap(filterImpl_newRootNode))));
        }

        public /* synthetic */ HashMap scala$collection$immutable$HashMap$HashKeySet$$$outer() {
            return (HashMap)this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$filter$1(Function1 pred$1, Tuple2 kv) {
            return BoxesRunTime.unboxToBoolean(pred$1.apply(kv._1()));
        }

        public static final /* synthetic */ boolean $anonfun$filterNot$1(Function1 pred$2, Tuple2 kv) {
            return BoxesRunTime.unboxToBoolean(pred$2.apply(kv._1()));
        }

        public HashKeySet(HashMap $outer) {
            super($outer);
        }
    }
}

