/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.collection.AbstractIterator;
import scala.collection.BufferedIterator;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator$;
import scala.runtime.BoxesRunTime;

public interface Iterator<A>
extends IterableOnce<A>,
IterableOnceOps<A, Iterator, Iterator<A>> {
    public boolean hasNext();

    public A next() throws NoSuchElementException;

    public static /* synthetic */ Iterator iterator$(Iterator $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<A> iterator() {
        return this;
    }

    public static /* synthetic */ BufferedIterator buffered$(Iterator $this) {
        return $this.buffered();
    }

    default public BufferedIterator<A> buffered() {
        return new BufferedIterator<A>(this){
            private A hd;
            private boolean hdDefined;
            private final /* synthetic */ Iterator $outer;

            public BufferedIterator<A> buffered() {
                return BufferedIterator.buffered$(this);
            }

            public A head() {
                if (!this.hdDefined) {
                    this.hd = this.next();
                    this.hdDefined = true;
                }
                return this.hd;
            }

            /*
             * WARNING - void declaration
             */
            public int knownSize() {
                void var1_1;
                int thisSize = this.$outer.knownSize();
                if (thisSize >= 0 && this.hdDefined) {
                    return thisSize + 1;
                }
                return (int)var1_1;
            }

            public boolean hasNext() {
                return this.hdDefined || this.$outer.hasNext();
            }

            public A next() {
                if (this.hdDefined) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return this.$outer.next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hdDefined = false;
            }
        };
    }

    public static /* synthetic */ int indexWhere$(Iterator $this, Function1 p, int from) {
        return $this.indexWhere(p, from);
    }

    default public int indexWhere(Function1<A, Object> p, int from) {
        int max_y = 0;
        int i = Math.max(from, max_y);
        Iterator<A> dropped = this.drop(from);
        while (dropped.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(dropped.next()))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static /* synthetic */ boolean isEmpty$(Iterator $this) {
        return $this.isEmpty();
    }

    @Override
    default public boolean isEmpty() {
        return !this.hasNext();
    }

    public static /* synthetic */ Iterator filterImpl$(Iterator $this, Function1 p, boolean isFlipped) {
        return $this.filterImpl(p, isFlipped);
    }

    default public Iterator<A> filterImpl(Function1<A, Object> p, boolean isFlipped) {
        return new AbstractIterator<A>(this, p, isFlipped){
            private A hd;
            private boolean hdDefined;
            private final /* synthetic */ Iterator $outer;
            private final Function1 p$1;
            private final boolean isFlipped$1;

            public boolean hasNext() {
                if (!this.hdDefined) {
                    if (!this.$outer.hasNext()) {
                        return false;
                    }
                    this.hd = this.$outer.next();
                    while (BoxesRunTime.unboxToBoolean(this.p$1.apply(this.hd)) == this.isFlipped$1) {
                        if (!this.$outer.hasNext()) {
                            return false;
                        }
                        this.hd = this.$outer.next();
                    }
                    this.hdDefined = true;
                }
                return true;
            }

            public A next() {
                if (this.hasNext()) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$1 = p$1;
                this.isFlipped$1 = isFlipped$1;
                this.hdDefined = false;
            }
        };
    }

    public static /* synthetic */ Iterator map$(Iterator $this, Function1 f) {
        return $this.map(f);
    }

    default public <B> Iterator<B> map(Function1<A, B> f) {
        return new AbstractIterator<B>(this, f){
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$2;

            public int knownSize() {
                return this.$outer.knownSize();
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            public B next() {
                return (B)this.f$2.apply(this.$outer.next());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$2 = f$2;
            }
        };
    }

    public static /* synthetic */ Iterator flatMap$(Iterator $this, Function1 f) {
        return $this.flatMap(f);
    }

    default public <B> Iterator<B> flatMap(Function1<A, IterableOnce<B>> f) {
        return new AbstractIterator<B>(this, f){
            private Iterator<B> cur;
            private int _hasNext;
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$3;

            private void nextCur() {
                this.cur = null;
                this.cur = ((IterableOnce)this.f$3.apply(this.$outer.next())).iterator();
                this._hasNext = -1;
            }

            public boolean hasNext() {
                if (this._hasNext == -1) {
                    while (!this.cur.hasNext()) {
                        if (!this.$outer.hasNext()) {
                            this._hasNext = 0;
                            this.cur = Iterator$.scala$collection$Iterator$$_empty;
                            return false;
                        }
                        this.nextCur();
                    }
                    this._hasNext = 1;
                    return true;
                }
                return this._hasNext == 1;
            }

            public B next() {
                if (this.hasNext()) {
                    this._hasNext = -1;
                }
                return this.cur.next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$3 = f$3;
                this.cur = Iterator$.scala$collection$Iterator$$_empty;
                this._hasNext = -1;
            }
        };
    }

    public static /* synthetic */ Iterator concat$(Iterator $this, Function0 xs) {
        return $this.concat(xs);
    }

    default public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
        return new ConcatIterator(this).concat(xs);
    }

    public static /* synthetic */ Iterator take$(Iterator $this, int n) {
        return $this.take(n);
    }

    default public Iterator<A> take(int n) {
        int max$extension_that = 0;
        return this.sliceIterator(0, Math.max(n, max$extension_that));
    }

    public static /* synthetic */ Iterator takeWhile$(Iterator $this, Function1 p) {
        return $this.takeWhile(p);
    }

    default public Iterator<A> takeWhile(Function1<A, Object> p) {
        return new AbstractIterator<A>(this, p){
            private A hd;
            private boolean hdDefined;
            private Iterator<A> tail;
            private final Function1 p$2;

            public boolean hasNext() {
                block6: {
                    block5: {
                        if (this.hdDefined) break block5;
                        if (!this.tail.hasNext()) break block6;
                        this.hd = this.tail.next();
                        if (BoxesRunTime.unboxToBoolean(this.p$2.apply(this.hd))) {
                            this.hdDefined = true;
                        } else {
                            this.tail = Iterator$.scala$collection$Iterator$$_empty;
                        }
                        if (!this.hdDefined) break block6;
                    }
                    return true;
                }
                return false;
            }

            public A next() {
                if (this.hasNext()) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                this.p$2 = p$2;
                this.hdDefined = false;
                this.tail = $outer;
            }
        };
    }

    public static /* synthetic */ Iterator drop$(Iterator $this, int n) {
        return $this.drop(n);
    }

    default public Iterator<A> drop(int n) {
        return this.sliceIterator(n, -1);
    }

    public static /* synthetic */ Iterator sliceIterator$(Iterator $this, int from, int until) {
        return $this.sliceIterator(from, until);
    }

    default public Iterator<A> sliceIterator(int from, int until) {
        int rest;
        int max$extension_that = 0;
        int n = Math.max(from, max$extension_that);
        int n2 = until < 0 ? -1 : (rest = until <= n ? 0 : until - n);
        if (rest == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new SliceIterator(this, n, rest);
    }

    public static /* synthetic */ boolean sameElements$(Iterator $this, IterableOnce that) {
        return $this.sameElements(that);
    }

    default public <B> boolean sameElements(IterableOnce<B> that) {
        Iterator<B> those = that.iterator();
        while (this.hasNext() && those.hasNext()) {
            if (BoxesRunTime.equals(this.next(), those.next())) continue;
            return false;
        }
        return this.hasNext() == those.hasNext();
    }

    public static /* synthetic */ String toString$(Iterator $this) {
        return $this.toString();
    }

    default public String toString() {
        return "<iterator>";
    }

    private static final class ConcatIterator<A>
    extends AbstractIterator<A> {
        private Iterator<A> current;
        private ConcatIteratorCell<A> tail;
        private ConcatIteratorCell<A> last;
        private boolean currentHasNextChecked;

        private Iterator<A> current() {
            return this.current;
        }

        private void current_$eq(Iterator<A> x$1) {
            this.current = x$1;
        }

        private ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        private void tail_$eq(ConcatIteratorCell<A> x$1) {
            this.tail = x$1;
        }

        private ConcatIteratorCell<A> last() {
            return this.last;
        }

        private void last_$eq(ConcatIteratorCell<A> x$1) {
            this.last = x$1;
        }

        private boolean currentHasNextChecked() {
            return this.currentHasNextChecked;
        }

        private void currentHasNextChecked_$eq(boolean x$1) {
            this.currentHasNextChecked = x$1;
        }

        @Override
        public boolean hasNext() {
            if (this.currentHasNextChecked()) {
                return true;
            }
            if (this.current() == null) {
                return false;
            }
            if (this.current().hasNext()) {
                this.currentHasNextChecked_$eq(true);
                return true;
            }
            return this.advance$1();
        }

        @Override
        public A next() {
            if (this.hasNext()) {
                this.currentHasNextChecked_$eq(false);
                return this.current().next();
            }
            return (A)Iterator$.scala$collection$Iterator$$_empty.next();
        }

        @Override
        public <B> Iterator<B> concat(Function0<IterableOnce<B>> that) {
            ConcatIteratorCell c = new ConcatIteratorCell(that, null);
            if (this.tail() == null) {
                this.tail_$eq(c);
                this.last_$eq(c);
            } else {
                this.last().tail_$eq(c);
                this.last_$eq(c);
            }
            if (this.current() == null) {
                this.current_$eq(Iterator$.scala$collection$Iterator$$_empty);
            }
            return this;
        }

        private final void merge$1() {
            while (this.current() instanceof ConcatIterator) {
                ConcatIterator c = (ConcatIterator)this.current();
                this.current_$eq(c.current());
                this.currentHasNextChecked_$eq(c.currentHasNextChecked());
                if (c.tail() == null) continue;
                if (this.last() == null) {
                    this.last_$eq(c.last());
                }
                c.last().tail_$eq(this.tail());
                this.tail_$eq(c.tail());
            }
        }

        private final boolean advance$1() {
            do {
                if (this.tail() == null) {
                    this.current_$eq(null);
                    this.last_$eq(null);
                    return false;
                }
                this.current_$eq(this.tail().headIterator());
                if (this.last() == this.tail()) {
                    this.last_$eq(this.last().tail());
                }
                this.tail_$eq(this.tail().tail());
                this.merge$1();
                if (!this.currentHasNextChecked()) continue;
                return true;
            } while (this.current() == null || !this.current().hasNext());
            this.currentHasNextChecked_$eq(true);
            return true;
        }

        public ConcatIterator(Iterator<A> current) {
            this.current = current;
            this.tail = null;
            this.last = null;
            this.currentHasNextChecked = false;
        }
    }

    private static final class ConcatIteratorCell<A> {
        private final Function0<IterableOnce<A>> head;
        private ConcatIteratorCell<A> tail;

        public ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        public void tail_$eq(ConcatIteratorCell<A> x$1) {
            this.tail = x$1;
        }

        public Iterator<A> headIterator() {
            return this.head.apply().iterator();
        }

        public ConcatIteratorCell(Function0<IterableOnce<A>> head, ConcatIteratorCell<A> tail) {
            this.head = head;
            this.tail = tail;
        }
    }

    public static final class SliceIterator<A>
    extends AbstractIterator<A> {
        private final Iterator<A> underlying;
        public int scala$collection$Iterator$SliceIterator$$remaining;
        private int dropping;

        public Iterator<A> underlying() {
            return this.underlying;
        }

        private void skip() {
            while (this.dropping > 0) {
                if (this.underlying().hasNext()) {
                    this.underlying().next();
                    --this.dropping;
                    continue;
                }
                this.dropping = 0;
            }
        }

        @Override
        public int knownSize() {
            int size = this.underlying().knownSize();
            if (size < 0) {
                return -1;
            }
            int n = 0;
            int max$extension_that = size - this.dropping;
            int n2 = Math.max(n, max$extension_that);
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                return n2;
            }
            int n3 = this.scala$collection$Iterator$SliceIterator$$remaining;
            return Math.min(n3, n2);
        }

        @Override
        public boolean hasNext() {
            this.skip();
            return this.scala$collection$Iterator$SliceIterator$$remaining != 0 && this.underlying().hasNext();
        }

        @Override
        public A next() {
            this.skip();
            if (this.scala$collection$Iterator$SliceIterator$$remaining > 0) {
                --this.scala$collection$Iterator$SliceIterator$$remaining;
                return this.underlying().next();
            }
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                return this.underlying().next();
            }
            return (A)Iterator$.scala$collection$Iterator$$_empty.next();
        }

        @Override
        public Iterator<A> sliceIterator(int from, int until) {
            int rest;
            int n;
            int max$extension_that = 0;
            int n2 = Math.max(from, max$extension_that);
            if (until < 0) {
                n = this.adjustedBound$1(n2);
            } else if (until <= n2) {
                n = 0;
            } else if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                n = until - n2;
            } else {
                int n3 = this.adjustedBound$1(n2);
                int min$extension_that = until - n2;
                n = rest = Math.min(n3, min$extension_that);
            }
            if (rest == 0) {
                return Iterator$.scala$collection$Iterator$$_empty;
            }
            this.dropping += n2;
            this.scala$collection$Iterator$SliceIterator$$remaining = rest;
            return this;
        }

        private final int adjustedBound$1(int lo$1) {
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                return -1;
            }
            int n = 0;
            int max$extension_that = this.scala$collection$Iterator$SliceIterator$$remaining - lo$1;
            return Math.max(n, max$extension_that);
        }

        public SliceIterator(Iterator<A> underlying, int start, int limit) {
            this.underlying = underlying;
            this.scala$collection$Iterator$SliceIterator$$remaining = limit;
            this.dropping = start;
        }
    }
}

