/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.collection.ArrayOps;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.IndexedSeq;
import scala.math.Ordering;
import scala.math.Ordering$Boolean$;
import scala.math.Ordering$Byte$;
import scala.math.Ordering$Char$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$Long$;
import scala.math.Ordering$Short$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Sorting$;

public final class ArrayOps$ {
    public static final ArrayOps$ MODULE$ = new ArrayOps$();

    public final <A> int size$extension(Object $this) {
        return Array.getLength($this);
    }

    public final <A> boolean isEmpty$extension(Object $this) {
        return Array.getLength($this) == 0;
    }

    public final <A> A last$extension(Object $this) {
        try {
            return (A)ScalaRunTime$.MODULE$.array_apply($this, Array.getLength($this) - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException("last of empty array");
        }
    }

    public final <A> Object slice$extension(Object $this, int from, int until) {
        int lo = Math.max(from, 0);
        int hi = Math.min(until, Array.getLength($this));
        if (hi > lo) {
            Object[] objectArray;
            if ($this instanceof Object[]) {
                objectArray = Arrays.copyOfRange((Object[])$this, lo, hi);
            } else if ($this instanceof int[]) {
                objectArray = Arrays.copyOfRange((int[])$this, lo, hi);
            } else if ($this instanceof double[]) {
                objectArray = Arrays.copyOfRange((double[])$this, lo, hi);
            } else if ($this instanceof long[]) {
                objectArray = Arrays.copyOfRange((long[])$this, lo, hi);
            } else if ($this instanceof float[]) {
                objectArray = Arrays.copyOfRange((float[])$this, lo, hi);
            } else if ($this instanceof char[]) {
                objectArray = Arrays.copyOfRange((char[])$this, lo, hi);
            } else if ($this instanceof byte[]) {
                objectArray = Arrays.copyOfRange((byte[])$this, lo, hi);
            } else if ($this instanceof short[]) {
                objectArray = Arrays.copyOfRange((short[])$this, lo, hi);
            } else if ($this instanceof boolean[]) {
                objectArray = Arrays.copyOfRange((boolean[])$this, lo, hi);
            } else {
                throw new MatchError($this);
            }
            return objectArray;
        }
        return ClassTag$.MODULE$.apply($this.getClass().getComponentType()).newArray(0);
    }

    public final <A> Object tail$extension(Object $this) {
        if (Array.getLength($this) == 0) {
            throw new UnsupportedOperationException("tail of empty array");
        }
        return this.slice$extension($this, 1, Array.getLength($this));
    }

    public final <A> Object drop$extension(Object $this, int n) {
        return this.slice$extension($this, n, Array.getLength($this));
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Object reverse$extension(Object $this) {
        void var2_3;
        int n = Array.getLength($this);
        Object res = ClassTag$.MODULE$.apply($this.getClass().getComponentType()).newArray(n);
        for (int i = 0; i < n; ++i) {
            ScalaRunTime$.MODULE$.array_update(res, n - i - 1, ScalaRunTime$.MODULE$.array_apply($this, i));
        }
        return var2_3;
    }

    public final <B, A> Object sorted$extension(Object $this, Ordering<B> ord) {
        Object object;
        int n = Array.getLength($this);
        if (n <= 1) {
            return ScalaRunTime$.MODULE$.array_clone($this);
        }
        if ($this instanceof Object[]) {
            Object[] a = Arrays.copyOf((Object[])$this, n);
            Arrays.sort(a, ord);
            object = a;
        } else if ($this instanceof int[]) {
            Object object2;
            int[] nArray = (int[])$this;
            if (ord == Ordering$Int$.MODULE$) {
                int[] a = Arrays.copyOf(nArray, n);
                Arrays.sort(a);
                object2 = a;
            } else {
                object2 = ArrayOps$.boxed$1(n, $this, ord);
            }
            object = object2;
        } else if ($this instanceof long[]) {
            Object object3;
            long[] lArray = (long[])$this;
            if (ord == Ordering$Long$.MODULE$) {
                long[] a = Arrays.copyOf(lArray, n);
                Arrays.sort(a);
                object3 = a;
            } else {
                object3 = ArrayOps$.boxed$1(n, $this, ord);
            }
            object = object3;
        } else if ($this instanceof char[]) {
            Object object4;
            char[] cArray = (char[])$this;
            if (ord == Ordering$Char$.MODULE$) {
                char[] a = Arrays.copyOf(cArray, n);
                Arrays.sort(a);
                object4 = a;
            } else {
                object4 = ArrayOps$.boxed$1(n, $this, ord);
            }
            object = object4;
        } else if ($this instanceof byte[]) {
            Object object5;
            byte[] byArray = (byte[])$this;
            if (ord == Ordering$Byte$.MODULE$) {
                byte[] a = Arrays.copyOf(byArray, n);
                Arrays.sort(a);
                object5 = a;
            } else {
                object5 = ArrayOps$.boxed$1(n, $this, ord);
            }
            object = object5;
        } else if ($this instanceof short[]) {
            Object object6;
            short[] sArray = (short[])$this;
            if (ord == Ordering$Short$.MODULE$) {
                short[] a = Arrays.copyOf(sArray, n);
                Arrays.sort(a);
                object6 = a;
            } else {
                object6 = ArrayOps$.boxed$1(n, $this, ord);
            }
            object = object6;
        } else if ($this instanceof boolean[]) {
            Object object7;
            boolean[] blArray = (boolean[])$this;
            if (ord == Ordering$Boolean$.MODULE$) {
                boolean[] a = Arrays.copyOf(blArray, n);
                Ordering$Boolean$ stableSort_evidence$3 = Ordering$Boolean$.MODULE$;
                Sorting$.MODULE$.stableSort(a, 0, a.length, stableSort_evidence$3);
                Object var18_18 = null;
                object7 = a;
            } else {
                object7 = ArrayOps$.boxed$1(n, $this, ord);
            }
            object = object7;
        } else {
            object = ArrayOps$.boxed$1(n, $this, ord);
        }
        return object;
    }

    public final <B, A> Object sortBy$extension(Object $this, Function1<A, B> f, Ordering<B> ord) {
        return this.sorted$extension($this, ord.on(f));
    }

    public final <B, A> Object map$extension(Object $this, Function1<A, B> f, ClassTag<B> ct) {
        int n = Array.getLength($this);
        Object ys = ct.newArray(n);
        if (n > 0) {
            int i;
            if ($this instanceof Object[]) {
                Object[] objectArray = (Object[])$this;
                for (i = 0; i < n; ++i) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply(objectArray[i]));
                }
            } else if ($this instanceof int[]) {
                int[] nArray = (int[])$this;
                while (i < n) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply(nArray[i]));
                    ++i;
                }
            } else if ($this instanceof double[]) {
                double[] dArray = (double[])$this;
                while (i < n) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply(dArray[i]));
                    ++i;
                }
            } else if ($this instanceof long[]) {
                long[] lArray = (long[])$this;
                while (i < n) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply(lArray[i]));
                    ++i;
                }
            } else if ($this instanceof float[]) {
                float[] fArray = (float[])$this;
                while (i < n) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply(Float.valueOf(fArray[i])));
                    ++i;
                }
            } else if ($this instanceof char[]) {
                char[] cArray = (char[])$this;
                while (i < n) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply(Character.valueOf(cArray[i])));
                    ++i;
                }
            } else if ($this instanceof byte[]) {
                byte[] byArray = (byte[])$this;
                while (i < n) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply(byArray[i]));
                    ++i;
                }
            } else if ($this instanceof short[]) {
                short[] sArray = (short[])$this;
                while (i < n) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply(sArray[i]));
                    ++i;
                }
            } else if ($this instanceof boolean[]) {
                boolean[] blArray = (boolean[])$this;
                while (i < n) {
                    ScalaRunTime$.MODULE$.array_update(ys, i, f.apply(blArray[i]));
                    ++i;
                }
            } else {
                throw new MatchError($this);
            }
        }
        return ys;
    }

    public final <B, A> Object appended$extension(Object $this, B x, ClassTag<B> evidence$10) {
        Object dest = Array$.MODULE$.copyAs($this, Array.getLength($this) + 1, evidence$10);
        ScalaRunTime$.MODULE$.array_update(dest, Array.getLength($this), x);
        return dest;
    }

    public final <B, A> Object appendedAll$extension(Object $this, Object suffix, ClassTag<B> evidence$19) {
        Object dest = Array$.MODULE$.copyAs($this, Array.getLength($this) + Array.getLength(suffix), evidence$19);
        Array$.MODULE$.copy(suffix, 0, dest, Array.getLength($this), Array.getLength(suffix));
        return dest;
    }

    public final <B, A> Object $plus$plus$extension(Object $this, Object xs, ClassTag<B> evidence$25) {
        return this.appendedAll$extension($this, xs, evidence$25);
    }

    public final <A> boolean contains$extension(Object $this, A elem) {
        int n;
        block1: {
            for (int exists$extension_indexWhere$extension_i = 0; exists$extension_indexWhere$extension_i < Array.getLength($this); ++exists$extension_indexWhere$extension_i) {
                Object object = ScalaRunTime$.MODULE$.array_apply($this, exists$extension_indexWhere$extension_i);
                if (!ArrayOps$.$anonfun$contains$1(elem, object)) continue;
                n = exists$extension_indexWhere$extension_i;
                break block1;
            }
            n = -1;
        }
        return n >= 0;
    }

    public final <U, A> void foreach$extension(Object $this, Function1<A, U> f) {
        int i;
        int n = Array.getLength($this);
        if ($this instanceof Object[]) {
            Object[] objectArray = (Object[])$this;
            for (i = 0; i < n; ++i) {
                f.apply(objectArray[i]);
            }
        } else if ($this instanceof int[]) {
            int[] nArray = (int[])$this;
            while (i < n) {
                f.apply(nArray[i]);
                ++i;
            }
        } else if ($this instanceof double[]) {
            double[] dArray = (double[])$this;
            while (i < n) {
                f.apply(dArray[i]);
                ++i;
            }
        } else if ($this instanceof long[]) {
            long[] lArray = (long[])$this;
            while (i < n) {
                f.apply(lArray[i]);
                ++i;
            }
        } else if ($this instanceof float[]) {
            float[] fArray = (float[])$this;
            while (i < n) {
                f.apply(Float.valueOf(fArray[i]));
                ++i;
            }
        } else if ($this instanceof char[]) {
            char[] cArray = (char[])$this;
            while (i < n) {
                f.apply(Character.valueOf(cArray[i]));
                ++i;
            }
        } else if ($this instanceof byte[]) {
            byte[] byArray = (byte[])$this;
            while (i < n) {
                f.apply(byArray[i]);
                ++i;
            }
        } else if ($this instanceof short[]) {
            short[] sArray = (short[])$this;
            while (i < n) {
                f.apply(sArray[i]);
                ++i;
            }
        } else if ($this instanceof boolean[]) {
            boolean[] blArray = (boolean[])$this;
            while (i < n) {
                f.apply(blArray[i]);
                ++i;
            }
        } else {
            throw new MatchError($this);
        }
    }

    public final <A> IndexedSeq<A> toIndexedSeq$extension(Object $this) {
        return ArraySeq$.MODULE$.unsafeWrapArray(Array$.MODULE$.copyOf($this, Array.getLength($this)));
    }

    public final <B, A> int copyToArray$extension(Object $this, Object xs, int start, int len) {
        int elemsToCopyToArray_max_y;
        int elemsToCopyToArray_min_y;
        int n = Array.getLength($this);
        int n2 = Array.getLength(xs);
        int n3 = Math.min(len, n);
        int n4 = Math.min(n3, elemsToCopyToArray_min_y = n2 - start);
        int n5 = Math.max(n4, elemsToCopyToArray_max_y = 0);
        if (n5 > 0) {
            Array$.MODULE$.copy($this, 0, xs, start, n5);
        }
        return n5;
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Object toArray$extension(Object $this, ClassTag<B> evidence$29) {
        void var3_3;
        Object destination = evidence$29.newArray(Array.getLength($this));
        int copyToArray$extension_start = 0;
        this.copyToArray$extension($this, destination, copyToArray$extension_start, Integer.MAX_VALUE);
        return var3_3;
    }

    public final <B, A> Object updated$extension(Object $this, int index, B elem, ClassTag<B> evidence$30) {
        if (index < 0 || index >= Array.getLength($this)) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(index).append(" is out of bounds (min 0, max ").append(Array.getLength($this) - 1).append(")").toString());
        }
        Object dest = this.toArray$extension($this, evidence$30);
        ScalaRunTime$.MODULE$.array_update(dest, index, elem);
        return dest;
    }

    public final <A> boolean equals$extension(Object $this, Object x$1) {
        Object object;
        boolean bl = x$1 instanceof ArrayOps;
        return bl && BoxesRunTime.equals($this, object = x$1 == null ? null : ((ArrayOps)x$1).scala$collection$ArrayOps$$xs());
    }

    /*
     * WARNING - void declaration
     */
    private static final Object boxed$1(int len$1, Object $this$2, Ordering ord$1) {
        if (len$1 < 300) {
            void var3_3;
            Object a = ScalaRunTime$.MODULE$.array_clone($this$2);
            Sorting$.MODULE$.stableSort(a, 0, Array.getLength(a), ord$1);
            return var3_3;
        }
        Object[] a = (Object[])Array$.MODULE$.copyAs($this$2, len$1, ClassTag$.MODULE$.AnyRef());
        Arrays.sort(a, ord$1);
        return Array$.MODULE$.copyAs(a, len$1, ClassTag$.MODULE$.apply($this$2.getClass().getComponentType()));
    }

    public static final /* synthetic */ boolean $anonfun$contains$1(Object elem$1, Object x$1) {
        return BoxesRunTime.equals(x$1, elem$1);
    }

    private ArrayOps$() {
    }
}

