/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import py4j.Base64;
import py4j.Gateway;
import py4j.Py4JException;
import py4j.Py4JNetworkException;
import py4j.ReturnObject;
import py4j.StringUtil;
import py4j.reflection.PythonProxyHandler;
import py4j.reflection.ReflectionUtil;

public class Protocol {
    public static String encodeBytes(byte[] bytes) {
        return Base64.encodeToString(bytes, false);
    }

    public static final boolean getBoolean(String commandPart) {
        return Boolean.parseBoolean(commandPart.substring(1, commandPart.length()));
    }

    public static final byte[] getBytes(String commandPart) {
        return Base64.decode(commandPart.substring(1));
    }

    public static final BigDecimal getDecimal(String commandPart) {
        return new BigDecimal(commandPart.substring(1, commandPart.length()));
    }

    public static final double getDouble(String commandPart) {
        String doubleValue = commandPart.substring(1, commandPart.length());
        try {
            return Double.parseDouble(doubleValue);
        }
        catch (NumberFormatException e) {
            if (doubleValue.equals("inf")) {
                return Double.POSITIVE_INFINITY;
            }
            if (doubleValue.equals("-inf")) {
                return Double.NEGATIVE_INFINITY;
            }
            if (doubleValue.equals("nan")) {
                return Double.NaN;
            }
            throw e;
        }
    }

    public static final int getInteger(String commandPart) {
        return Integer.parseInt(commandPart.substring(1, commandPart.length()));
    }

    public static final long getLong(String commandPart) {
        return Long.parseLong(commandPart.substring(1, commandPart.length()));
    }

    public static final String getMemberOutputCommand(char memberType) {
        StringBuilder builder = new StringBuilder();
        builder.append('!');
        builder.append('y');
        builder.append(memberType);
        builder.append('\n');
        return builder.toString();
    }

    public static final String getMemberOutputCommand(char memberType, String fqn) {
        StringBuilder builder = new StringBuilder();
        builder.append('!');
        builder.append('y');
        builder.append(memberType);
        builder.append(fqn);
        builder.append('\n');
        return builder.toString();
    }

    public static String getNoSuchFieldOutputCommand() {
        return "!yo\n";
    }

    public static final Object getNull(String commandPart) {
        return null;
    }

    public static final Object getObject(String commandPart, Gateway gateway) {
        if (Protocol.isEmpty(commandPart) || Protocol.isEnd(commandPart)) {
            throw new Py4JException("Command Part is Empty or is the End of Command Part");
        }
        switch (commandPart.charAt(0)) {
            case 'b': {
                return Protocol.getBoolean(commandPart);
            }
            case 'd': {
                return Protocol.getDouble(commandPart);
            }
            case 'L': {
                return Protocol.getLong(commandPart);
            }
            case 'i': {
                try {
                    return Protocol.getInteger(commandPart);
                }
                catch (NumberFormatException e) {
                    return Protocol.getLong(commandPart);
                }
            }
            case 'j': {
                return Protocol.getBytes(commandPart);
            }
            case 'n': {
                return Protocol.getNull(commandPart);
            }
            case 'v': {
                return Protocol.getNull(commandPart);
            }
            case 'r': {
                return Protocol.getReference(commandPart, gateway);
            }
            case 's': {
                return Protocol.getString(commandPart);
            }
            case 'D': {
                return Protocol.getDecimal(commandPart);
            }
            case 'f': {
                return Protocol.getPythonProxy(commandPart, gateway);
            }
        }
        throw new Py4JException("Command Part is unknown: " + commandPart);
    }

    public static final String getOutputCommand(ReturnObject rObject) {
        StringBuilder builder = new StringBuilder();
        builder.append('!');
        if (rObject.isError()) {
            builder.append(rObject.getCommandPart());
        } else {
            builder.append('y');
            builder.append(rObject.getCommandPart());
        }
        builder.append('\n');
        return builder.toString();
    }

    public static final String getOutputErrorCommand() {
        return "!x\n";
    }

    public static final String getOutputErrorCommand(String errorMessage) {
        StringBuilder builder = new StringBuilder();
        builder.append('!');
        builder.append('x');
        builder.append('s');
        builder.append(StringUtil.escape(errorMessage));
        builder.append('\n');
        return builder.toString();
    }

    public static final String getOutputErrorCommand(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        builder.append('!');
        builder.append('x');
        builder.append('s');
        builder.append(StringUtil.escape(Protocol.getThrowableAsString(throwable)));
        builder.append('\n');
        return builder.toString();
    }

    public static final String getOutputVoidCommand() {
        return "!yv\n";
    }

    public static char getPrimitiveType(Object primitiveObject) {
        int c = 105;
        if (primitiveObject instanceof String || primitiveObject instanceof Character) {
            c = 115;
        } else if (primitiveObject instanceof Long) {
            c = 76;
        } else if (primitiveObject instanceof Double || primitiveObject instanceof Float) {
            c = 100;
        } else if (primitiveObject instanceof Boolean) {
            c = 98;
        } else if (primitiveObject instanceof byte[]) {
            c = 106;
        }
        return (char)c;
    }

    public static Object getPythonProxy(String commandPart, Gateway gateway) {
        String proxyString = commandPart.substring(1, commandPart.length());
        String[] parts = proxyString.split(";");
        int length = parts.length;
        Class[] interfaces = new Class[length - 1];
        if (length < 2) {
            throw new Py4JException("Invalid Python Proxy.");
        }
        for (int i = 1; i < length; ++i) {
            try {
                interfaces[i - 1] = ReflectionUtil.classForName(parts[i]);
                if (interfaces[i - 1].isInterface()) continue;
                throw new Py4JException("This class " + parts[i] + " is not an interface and cannot be used as a Python Proxy.");
            }
            catch (ClassNotFoundException e) {
                throw new Py4JException("Invalid interface name: " + parts[i]);
            }
        }
        Object proxy = Protocol.getPythonProxyHandler(ReflectionUtil.getClassLoader(), interfaces, parts[0], gateway);
        return proxy;
    }

    public static Object getPythonProxyHandler(ClassLoader classLoader, Class[] interfacesToImplement, String objectId, Gateway gateway) {
        return Proxy.newProxyInstance(classLoader, interfacesToImplement, (InvocationHandler)new PythonProxyHandler(objectId, gateway));
    }

    public static final Object getReference(String commandPart, Gateway gateway) {
        String reference = commandPart.substring(1, commandPart.length());
        if (reference.trim().length() == 0) {
            throw new Py4JException("Reference is empty.");
        }
        return gateway.getObject(reference);
    }

    public static final Object getReturnValue(String returnMessage, Gateway gateway) {
        Object returnValue = null;
        if (Protocol.isError(returnMessage)) {
            throw new Py4JException("An exception was raised by the Python Proxy. Return Message: " + returnMessage);
        }
        returnValue = Protocol.getObject(returnMessage.substring(1), gateway);
        return returnValue;
    }

    public static final Throwable getRootThrowable(Throwable throwable, boolean skipInvocation) {
        Throwable child = throwable;
        if (!skipInvocation && child instanceof InvocationTargetException) {
            child = throwable.getCause();
            skipInvocation = true;
        } else if (child instanceof Py4JException || child instanceof Py4JNetworkException) {
            child = throwable.getCause();
        } else {
            return child;
        }
        if (child == null) {
            return throwable;
        }
        return Protocol.getRootThrowable(child, skipInvocation);
    }

    public static final String getString(String commandPart) {
        String toReturn = "";
        if (commandPart.length() >= 2) {
            toReturn = StringUtil.unescape(commandPart.substring(1, commandPart.length()));
        }
        return toReturn;
    }

    public static final String getThrowableAsString(Throwable throwable) {
        Throwable root = Protocol.getRootThrowable(throwable, false);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        root.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static final boolean isReturnMessage(String commandPart) {
        return commandPart != null && commandPart.length() > 1 && commandPart.charAt(0) == '!';
    }

    public static final boolean isEmpty(String commandPart) {
        return commandPart == null || commandPart.trim().length() == 0;
    }

    public static final boolean isEnd(String commandPart) {
        return commandPart.length() == 1 && commandPart.charAt(0) == 'e';
    }

    public static final boolean isError(String returnMessage) {
        return returnMessage == null || returnMessage.length() == 0 || returnMessage.charAt(0) == 'x';
    }
}

