from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="osonweb",
    version="0.1.0",
    author="OsonWeb Jamoasi",
    author_email="info@osonweb.uz",
    description="O'zbekcha dokumentatsiyali, asinxron, to'liq funksional web freymvork",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/osonweb/osonweb",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Application Frameworks",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    python_requires=">=3.8",
    install_requires=[
        "fastapi>=0.104.0",
        "uvicorn[standard]>=0.24.0",
        "tortoise-orm>=0.20.0",
        "aerich>=0.7.2",
        "typer>=0.9.0",
        "jinja2>=3.1.2",
        "python-multipart>=0.0.6",
        "passlib>=1.7.4",
        "bcrypt>=4.0.1",
        "python-jose[cryptography]>=3.3.0",
        "aiosqlite>=0.19.0",
    ],
    entry_points={
        "console_scripts": [
            "osonweb=osonweb.cli:app",
        ],
    },
    include_package_data=True,
    package_data={
        "osonweb": [
            "templates/**/*",
            "static/**/*",
        ],
    },
)
