"""
OsonWeb Routing - Flask uslubidagi marshrutlash
"""
from functools import wraps
from typing import Callable


def route(path: str, methods: list = None):
    """
    Flask uslubida marshrutni belgilash
    
    Misol:
        @route("/users", methods=["GET", "POST"])
        async def users():
            return {"users": []}
    """
    if methods is None:
        methods = ["GET"]
    
    def decorator(func: Callable):
        func._route_path = path
        func._route_methods = methods
        return func
    
    return decorator


def get(path: str):
    """GET so'rovi uchun marshrutni belgilash"""
    return route(path, methods=["GET"])


def post(path: str):
    """POST so'rovi uchun marshrutni belgilash"""
    return route(path, methods=["POST"])


def put(path: str):
    """PUT so'rovi uchun marshrutni belgilash"""
    return route(path, methods=["PUT"])


def delete(path: str):
    """DELETE so'rovi uchun marshrutni belgilash"""
    return route(path, methods=["DELETE"])


def patch(path: str):
    """PATCH so'rovi uchun marshrutni belgilash"""
    return route(path, methods=["PATCH"])
