"""
OsonWeb Models - Django uslubida modellar
Tortoise-ORM asosida qurilgan
"""
from tortoise.models import Model as TortoiseModel
from tortoise import fields as tortoise_fields


class Model(TortoiseModel):
    """
    Asosiy model klassi
    Django ORM uslubida ishlatish uchun
    
    Misol:
        class User(Model):
            id = fields.IntField(pk=True)
            username = fields.CharField(max_length=50, unique=True)
            email = fields.CharField(max_length=100)
            created_at = fields.DatetimeField(auto_now_add=True)
            
            class Meta:
                table = "users"
    """
    
    class Meta:
        abstract = True


# Tortoise-ORM fields ni eksport qilish
class fields:
    """Model maydonlari"""
    
    # Asosiy maydonlar
    IntField = tortoise_fields.IntField
    BigIntField = tortoise_fields.BigIntField
    SmallIntField = tortoise_fields.SmallIntField
    
    CharField = tortoise_fields.CharField
    TextField = tortoise_fields.TextField
    
    BooleanField = tortoise_fields.BooleanField
    
    FloatField = tortoise_fields.FloatField
    DecimalField = tortoise_fields.DecimalField
    
    DateField = tortoise_fields.DateField
    DatetimeField = tortoise_fields.DatetimeField
    TimeField = tortoise_fields.TimeField
    TimeDeltaField = tortoise_fields.TimeDeltaField
    
    JSONField = tortoise_fields.JSONField
    UUIDField = tortoise_fields.UUIDField
    BinaryField = tortoise_fields.BinaryField
    
    # Munosabatlar
    ForeignKeyField = tortoise_fields.ForeignKeyField
    OneToOneField = tortoise_fields.OneToOneField
    ManyToManyField = tortoise_fields.ManyToManyField
    
    # Maxsus maydonlar
    ReverseRelation = tortoise_fields.ReverseRelation
    BackwardFKRelation = tortoise_fields.BackwardFKRelation
    BackwardOneToOneRelation = tortoise_fields.BackwardOneToOneRelation
    ManyToManyRelation = tortoise_fields.ManyToManyRelation


# Tortoise-ORM funksiyalarini eksport qilish
from tortoise import Tortoise
from tortoise.transactions import in_transaction, atomic
from tortoise.queryset import QuerySet
from tortoise.expressions import Q, F

__all__ = [
    "Model",
    "fields",
    "Tortoise",
    "in_transaction",
    "atomic",
    "QuerySet",
    "Q",
    "F",
]
