# foxtail-trainer-api
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import foxtail_trainer_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import foxtail_trainer_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import foxtail_trainer_api
from foxtail_trainer_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = foxtail_trainer_api.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with foxtail_trainer_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = foxtail_trainer_api.JobApi(api_client)
    id = 'id_example' # str | Id of job

    try:
        # Get job
        api_response = api_instance.api_job_id_get(id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling JobApi->api_job_id_get: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*JobApi* | [**api_job_id_get**](docs/JobApi.md#api_job_id_get) | **GET** /api/Job/{id} | Get job
*JobApi* | [**api_job_id_models_delete**](docs/JobApi.md#api_job_id_models_delete) | **DELETE** /api/Job/{id}/Models | Delete ML models from job
*JobApi* | [**api_job_id_models_get**](docs/JobApi.md#api_job_id_models_get) | **GET** /api/Job/{id}/Models | Get list of model guids for job
*JobApi* | [**api_job_id_models_post**](docs/JobApi.md#api_job_id_models_post) | **POST** /api/Job/{id}/Models | Add ML models to the job
*JobApi* | [**api_job_id_run_post**](docs/JobApi.md#api_job_id_run_post) | **POST** /api/Job/{id}/Run | Run job, start models training.
*JobApi* | [**api_job_post**](docs/JobApi.md#api_job_post) | **POST** /api/Job | Create and store job entity.   Post an empty Job or Job with models
*JobReportApi* | [**api_job_job_id_job_report_job_metric_report_get**](docs/JobReportApi.md#api_job_job_id_job_report_job_metric_report_get) | **GET** /api/Job/{jobId}/JobReport/JobMetricReport | 
*JobReportApi* | [**api_job_job_id_job_report_model_metric_report_get**](docs/JobReportApi.md#api_job_job_id_job_report_model_metric_report_get) | **GET** /api/Job/{jobId}/JobReport/ModelMetricReport | 
*JobReportApi* | [**api_job_job_id_job_report_model_status_report_get**](docs/JobReportApi.md#api_job_job_id_job_report_model_status_report_get) | **GET** /api/Job/{jobId}/JobReport/ModelStatusReport | Get status for every model. Report contains model id and current status.
*JobReportApi* | [**api_job_job_id_job_report_model_url_report_get**](docs/JobReportApi.md#api_job_job_id_job_report_model_url_report_get) | **GET** /api/Job/{jobId}/JobReport/ModelUrlReport | 
*JobReportApi* | [**api_job_job_id_job_report_status_count_report_get**](docs/JobReportApi.md#api_job_job_id_job_report_status_count_report_get) | **GET** /api/Job/{jobId}/JobReport/StatusCountReport | 
*JobReportApi* | [**api_job_job_id_job_report_training_time_report_get**](docs/JobReportApi.md#api_job_job_id_job_report_training_time_report_get) | **GET** /api/Job/{jobId}/JobReport/TrainingTimeReport | 
*MLModelApi* | [**api_ml_model_id_get**](docs/MLModelApi.md#api_ml_model_id_get) | **GET** /api/MLModel/{id} | 
*MLModelApi* | [**api_ml_model_id_status_post**](docs/MLModelApi.md#api_ml_model_id_status_post) | **POST** /api/MLModel/{id}/Status | 
*MLModelApi* | [**api_ml_model_id_training_config_get**](docs/MLModelApi.md#api_ml_model_id_training_config_get) | **GET** /api/MLModel/{id}/TrainingConfig | 
*MLModelApi* | [**api_ml_model_id_training_result_get**](docs/MLModelApi.md#api_ml_model_id_training_result_get) | **GET** /api/MLModel/{id}/TrainingResult | 
*MLModelApi* | [**api_ml_model_id_training_result_post**](docs/MLModelApi.md#api_ml_model_id_training_result_post) | **POST** /api/MLModel/{id}/TrainingResult | 
*WorkerApi* | [**api_worker_job_id_workers_information_get**](docs/WorkerApi.md#api_worker_job_id_workers_information_get) | **GET** /api/Worker/{jobId}/WorkersInformation | 


## Documentation For Models

 - [AggregatedMetricReport](docs/AggregatedMetricReport.md)
 - [Job](docs/Job.md)
 - [JobMetricByProblemTypeReport](docs/JobMetricByProblemTypeReport.md)
 - [JobMetricReport](docs/JobMetricReport.md)
 - [Log](docs/Log.md)
 - [MLModel](docs/MLModel.md)
 - [Metric](docs/Metric.md)
 - [MetricReport](docs/MetricReport.md)
 - [MetricType](docs/MetricType.md)
 - [ModelMetricReport](docs/ModelMetricReport.md)
 - [ModelStatus](docs/ModelStatus.md)
 - [ModelStatusReport](docs/ModelStatusReport.md)
 - [ModelType](docs/ModelType.md)
 - [ModelUrlReport](docs/ModelUrlReport.md)
 - [ProblemType](docs/ProblemType.md)
 - [StatusCountReport](docs/StatusCountReport.md)
 - [TimeSpan](docs/TimeSpan.md)
 - [TrainingConfig](docs/TrainingConfig.md)
 - [TrainingHistory](docs/TrainingHistory.md)
 - [TrainingResult](docs/TrainingResult.md)
 - [TrainingTimeReport](docs/TrainingTimeReport.md)
 - [Worker](docs/Worker.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




