# elastix_napari

[![License](https://img.shields.io/pypi/l/elastix_napari.svg?color=green)](https://github.com/SuperElastix/elastix_napari/raw/main/LICENSE)
[![PyPI](https://img.shields.io/pypi/v/elastix_napari.svg?color=green)](https://pypi.org/project/elastix_napari)
[![Python Version](https://img.shields.io/pypi/pyversions/elastix_napari.svg?color=green)](https://python.org)
[![tests](https://github.com/SuperElastix/elastix_napari/workflows/tests/badge.svg)](https://github.com/SuperElastix/elastix_napari/actions)
[![codecov](https://codecov.io/gh/SuperElastix/elastix_napari/branch/main/graph/badge.svg)](https://codecov.io/gh/SuperElastix/elastix_napari)
[![Youtube](https://img.shields.io/badge/YouTube-Demo-red)](https://www.youtube.com/watch?v=GzbP-qUR034)

The [napari] plugin for [elastix], a toolbox for rigid and nonrigid registration of images, based on [itk-elastix].

For a demo video see [youtube] channel.
For tutorials on how to use elastix, see our [Jupyter notebooks].

To find parameters that work well with specific datasets, see the [elastix Model Zoo].

<img width="1438" alt="Screenshot 2021-05-12 at 15 07 24" src="https://user-images.githubusercontent.com/33719474/117980045-d6009b00-b333-11eb-9976-f64d34f4f7cc.png">

## Installation

You can install `elastix_napari` via [pip]:

    pip install elastix_napari

## Contributing

Contributions are very welcome. Tests can be run with [tox], please ensure
the coverage at least stays the same before you submit a pull request.

## License

Distributed under the terms of the [Apache Software License 2.0] license,
"elastix_napari" is free and open source software

## Issues

If you encounter any problems, please [file an issue] along with a detailed description.

[napari]: https://github.com/napari/napari
[Cookiecutter]: https://github.com/audreyr/cookiecutter
[@napari]: https://github.com/napari
[Apache Software License 2.0]: http://www.apache.org/licenses/LICENSE-2.0
[cookiecutter-napari-plugin]: https://github.com/napari/cookiecutter-napari-plugin
[file an issue]: https://github.com/SuperElastix/elastix_napari/issues
[tox]: https://tox.readthedocs.io/en/latest/
[pip]: https://pypi.org/project/pip/
[PyPI]: https://pypi.org/
[elastix]: https://elastix.lumc.nl/
[itk-elastix]: https://github.com/InsightSoftwareConsortium/ITKElastix
[elastix Model Zoo]: https://elastix.lumc.nl/modelzoo/
[Jupyter notebooks]: https://mybinder.org/v2/gh/InsightSoftwareConsortium/ITKElastix/master?urlpath=lab/tree/examples%2FITK_Example01_SimpleRegistration.ipynb
[youtube]: https://www.youtube.com/watch?v=GzbP-qUR034
