import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setuptools.setup(
    name='EDA-assistant',
    version='0.0.3',
    author='Madalyn Li',
    author_email='mli2324@uw.edu',
    description='This package allows users to perform exploratory data analysis '
                'tasks and techniques such as creating an EDA PDF report from '
                'any dataset',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://github.com/madalynli/EDA-assistant',
    install_requires=['cycler',
                      'fonttools',
                      'kiwisolver',
                      'matplotlib',
                      'numpy',
                      'packaging',
                      'pandas',
                      'Pillow',
                      'pyparsing',
                      'python-dateutil',
                      'pytz',
                      'scipy',
                      'seaborn',
                      'six'
                      ],
    classifiers=[
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent'
    ]
)
