"""Import all the functions from construct_splines to top level.

:author: Shay Hill
:created: 2023-02-08
"""

from .bezier_curve import BezierCurve
from .bezier_spline import BezierSpline
from .construct_splines import (
    get_closed_b_points,
    get_open_b_points,
    new_closed_approximating_spline,
    new_closed_interpolating_spline,
    new_open_approximating_spline,
    new_open_interpolating_spline,
)

__all__ = [
    "BezierCurve",
    "BezierSpline",
    "get_closed_b_points",
    "get_open_b_points",
    "new_closed_approximating_spline",
    "new_closed_interpolating_spline",
    "new_open_approximating_spline",
    "new_open_interpolating_spline",
]
