#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pyformatters_consolidate']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['pymultirole-plugins>=0.4.0,<0.5.0', 'pandas==1.2.3', 'collections-extended']

extras_require = \
{'dev': ['flit', 'pre-commit', 'bump2version'],
 'docs': ['sphinx',
          'sphinx-rtd-theme',
          'm2r2',
          'sphinxcontrib.apidoc',
          'jupyter_sphinx'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-flake8',
          'pytest-mypy',
          'pytest-black',
          'hypothesis',
          'tox']}

entry_points = \
{'pyformatters.plugins': ['consolidate = '
                          'pyformatters_consolidate.consolidate:ConsolidateFormatter']}

setup(name='pyformatters-consolidate',
      version='0.4.60',
      description='Sherpa Consolidation formatter',
      author='Olivier Terrier',
      author_email='olivier.terrier@kairntech.com',
      url='https://github.com/oterrier/pyformatters_consolidate/',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
