from necroassembler import Assembler
from necroassembler.utils import pack_le16u, pack_byte, pack_8s, match


OPCODES_TABLE = (
    ([0x00], 'NOP'),
    ([0x01], 'LD', 'BC', 'nn'),
    ([0x02], 'LD', '(', 'BC', ')', 'A'),
    ([0x03], 'INC', 'BC'),
    ([0x04], 'INC', 'B'),
    ([0x05], 'DEC', 'B'),
    ([0x06], 'LD', 'B', 'n'),
    ([0x07], 'RLCA'),
    ([0x08], 'EX', 'AF', 'AF\''),
    ([0x09], 'ADD', 'HL', 'BC'),
    ([0x0A], 'LD', 'A', '(', 'BC', ')'),
    ([0x0B], 'DEC', 'BC'),
    ([0x0C], 'INC', 'C'),
    ([0x0D], 'DEC', 'C'),
    ([0x0E], 'LD', 'C', 'n'),
    ([0x0F], 'RRCA'),
    ([0x10], 'DJNZ', 'e'),
    ([0x11], 'LD', 'DE', 'nn'),
    ([0x12], 'LD', '(', 'DE', ')', 'A'),
    ([0x13], 'INC', 'DE'),
    ([0x14], 'INC', 'D'),
    ([0x15], 'DEC', 'D'),
    ([0x16], 'LD', 'D', 'n'),
    ([0x17], 'RLA'),
    ([0x18], 'JR', 'e'),
    ([0x19], 'ADD', 'HL', 'DE'),
    ([0x1A], 'LD', 'A', '(', 'DE', ')'),
    ([0x1B], 'DEC', 'DE'),
    ([0x1C], 'INC', 'E'),
    ([0x1D], 'DEC', 'E'),
    ([0x1E], 'LD', 'E', 'n'),
    ([0x1F], 'RRA'),
    ([0x20], 'JR', 'NZ', 'e'),
    ([0x21], 'LD', 'HL', 'nn'),
    ([0x22], 'LD', '(', 'nn', ')', 'HL'),
    ([0x23], 'INC', 'HL'),
    ([0x24], 'INC', 'H'),
    ([0x25], 'DEC', 'H'),
    ([0x26], 'LD', 'H', 'n'),
    ([0x27], 'DAA'),
    ([0x28], 'JR', 'Z', 'e'),
    ([0x29], 'ADD', 'HL', 'HL'),
    ([0x2A], 'LD', 'HL', '(', 'nn', ')'),
    ([0x2B], 'DEC', 'HL'),
    ([0x2C], 'INC', 'L'),
    ([0x2D], 'DEC', 'L'),
    ([0x2E], 'LD', 'L', 'n'),
    ([0x2F], 'CPL'),
    ([0x30], 'JR', 'NC', 'e'),
    ([0x31], 'LD', 'SP', 'nn'),
    ([0x32], 'LD', '(', 'nn', ')', 'A'),
    ([0x33], 'INC', 'SP'),
    ([0x34], 'INC', '(', 'HL', ')'),
    ([0x35], 'DEC', '(', 'HL', ')'),
    ([0x36], 'LD', '(', 'HL', ')', 'n'),
    ([0x37], 'SCF'),
    ([0x38], 'JR', 'C', 'e'),
    ([0x39], 'ADD', 'HL', 'SP'),
    ([0x3A], 'LD', 'A', '(', 'nn', ')'),
    ([0x3B], 'DEC', 'SP'),
    ([0x3C], 'INC', 'A'),
    ([0x3D], 'DEC', 'A'),
    ([0x3E], 'LD', 'A', 'n'),
    ([0x3F], 'CCF'),
    ([0x40], 'LD', 'B', 'B'),
    ([0x41], 'LD', 'B', 'C'),
    ([0x42], 'LD', 'B', 'D'),
    ([0x43], 'LD', 'B', 'E'),
    ([0x44], 'LD', 'B', 'H'),
    ([0x45], 'LD', 'B', 'L'),
    ([0x46], 'LD', 'B', '(', 'HL', ')'),
    ([0x47], 'LD', 'B', 'A'),
    ([0x48], 'LD', 'C', 'B'),
    ([0x49], 'LD', 'C', 'C'),
    ([0x4A], 'LD', 'C', 'D'),
    ([0x4B], 'LD', 'C', 'E'),
    ([0x4C], 'LD', 'C', 'H'),
    ([0x4D], 'LD', 'C', 'L'),
    ([0x4E], 'LD', 'C', '(', 'HL', ')'),
    ([0x4F], 'LD', 'C', 'A'),
    ([0x50], 'LD', 'D', 'B'),
    ([0x51], 'LD', 'D', 'C'),
    ([0x52], 'LD', 'D', 'D'),
    ([0x53], 'LD', 'D', 'E'),
    ([0x54], 'LD', 'D', 'H'),
    ([0x55], 'LD', 'D', 'L'),
    ([0x56], 'LD', 'D', '(', 'HL', ')'),
    ([0x57], 'LD', 'D', 'A'),
    ([0x58], 'LD', 'E', 'B'),
    ([0x59], 'LD', 'E', 'C'),
    ([0x5A], 'LD', 'E', 'D'),
    ([0x5B], 'LD', 'E', 'E'),
    ([0x5C], 'LD', 'E', 'H'),
    ([0x5D], 'LD', 'E', 'L'),
    ([0x5E], 'LD', 'E', '(', 'HL', ')'),
    ([0x5F], 'LD', 'E', 'A'),
    ([0x60], 'LD', 'H', 'B'),
    ([0x61], 'LD', 'H', 'C'),
    ([0x62], 'LD', 'H', 'D'),
    ([0x63], 'LD', 'H', 'E'),
    ([0x64], 'LD', 'H', 'H'),
    ([0x65], 'LD', 'H', 'L'),
    ([0x66], 'LD', 'H', '(', 'HL', ')'),
    ([0x67], 'LD', 'H', 'A'),
    ([0x68], 'LD', 'L', 'B'),
    ([0x69], 'LD', 'L', 'C'),
    ([0x6A], 'LD', 'L', 'D'),
    ([0x6B], 'LD', 'L', 'E'),
    ([0x6C], 'LD', 'L', 'H'),
    ([0x6D], 'LD', 'L', 'L'),
    ([0x6E], 'LD', 'L', '(', 'HL', ')'),
    ([0x6F], 'LD', 'L', 'A'),
    ([0x70], 'LD', '(', 'HL', ')', 'B'),
    ([0x71], 'LD', '(', 'HL', ')', 'C'),
    ([0x72], 'LD', '(', 'HL', ')', 'D'),
    ([0x73], 'LD', '(', 'HL', ')', 'E'),
    ([0x74], 'LD', '(', 'HL', ')', 'H'),
    ([0x75], 'LD', '(', 'HL', ')', 'L'),
    ([0x76], 'HALT'),
    ([0x77], 'LD', '(', 'HL', ')', 'A'),
    ([0x78], 'LD', 'A', 'B'),
    ([0x79], 'LD', 'A', 'C'),
    ([0x7A], 'LD', 'A', 'D'),
    ([0x7B], 'LD', 'A', 'E'),
    ([0x7C], 'LD', 'A', 'H'),
    ([0x7D], 'LD', 'A', 'L'),
    ([0x7E], 'LD', 'A', '(', 'HL', ')'),
    ([0x7F], 'LD', 'A', 'A'),
    ([0x80], 'ADD', 'A', 'B'),
    ([0x81], 'ADD', 'A', 'C'),
    ([0x82], 'ADD', 'A', 'D'),
    ([0x83], 'ADD', 'A', 'E'),
    ([0x84], 'ADD', 'A', 'H'),
    ([0x85], 'ADD', 'A', 'L'),
    ([0x86], 'ADD', 'A', '(', 'HL', ')'),
    ([0x87], 'ADD', 'A', 'A'),
    ([0x88], 'ADC', 'A', 'B'),
    ([0x89], 'ADC', 'A', 'C'),
    ([0x8A], 'ADC', 'A', 'D'),
    ([0x8B], 'ADC', 'A', 'E'),
    ([0x8C], 'ADC', 'A', 'H'),
    ([0x8D], 'ADC', 'A', 'L'),
    ([0x8E], 'ADC', 'A', '(', 'HL', ')'),
    ([0x8F], 'ADC', 'A', 'A'),
    ([0x90], 'SUB', 'B'),
    ([0x91], 'SUB', 'C'),
    ([0x92], 'SUB', 'D'),
    ([0x93], 'SUB', 'E'),
    ([0x94], 'SUB', 'H'),
    ([0x95], 'SUB', 'L'),
    ([0x96], 'SUB', '(', 'HL', ')'),
    ([0x97], 'SUB', 'A'),
    ([0x98], 'SBC', 'A', 'B'),
    ([0x99], 'SBC', 'A', 'C'),
    ([0x9A], 'SBC', 'A', 'D'),
    ([0x9B], 'SBC', 'A', 'E'),
    ([0x9C], 'SBC', 'A', 'H'),
    ([0x9D], 'SBC', 'A', 'L'),
    ([0x9E], 'SBC', 'A', '(', 'HL', ')'),
    ([0x9F], 'SBC', 'A', 'A'),
    ([0xA0], 'AND', 'B'),
    ([0xA1], 'AND', 'C'),
    ([0xA2], 'AND', 'D'),
    ([0xA3], 'AND', 'E'),
    ([0xA4], 'AND', 'H'),
    ([0xA5], 'AND', 'L'),
    ([0xA6], 'AND', '(', 'HL', ')'),
    ([0xA7], 'AND', 'A'),
    ([0xA8], 'XOR', 'B'),
    ([0xA9], 'XOR', 'C'),
    ([0xAA], 'XOR', 'D'),
    ([0xAB], 'XOR', 'E'),
    ([0xAC], 'XOR', 'H'),
    ([0xAD], 'XOR', 'L'),
    ([0xAE], 'XOR', '(', 'HL', ')'),
    ([0xAF], 'XOR', 'A'),
    ([0xB0], 'OR', 'B'),
    ([0xB1], 'OR', 'C'),
    ([0xB2], 'OR', 'D'),
    ([0xB3], 'OR', 'E'),
    ([0xB4], 'OR', 'H'),
    ([0xB5], 'OR', 'L'),
    ([0xB6], 'OR', '(', 'HL', ')'),
    ([0xB7], 'OR', 'A'),
    ([0xB8], 'CP', 'B'),
    ([0xB9], 'CP', 'C'),
    ([0xBA], 'CP', 'D'),
    ([0xBB], 'CP', 'E'),
    ([0xBC], 'CP', 'H'),
    ([0xBD], 'CP', 'L'),
    ([0xBE], 'CP', '(', 'HL', ')'),
    ([0xBF], 'CP', 'A'),
    ([0xC0], 'RET', 'NZ'),
    ([0xC1], 'POP', 'BC'),
    ([0xC2], 'JP', 'NZ', 'nn'),
    ([0xC3], 'JP', 'nn'),
    ([0xC4], 'CALL', 'NZ', 'nn'),
    ([0xC5], 'PUSH', 'BC'),
    ([0xC6], 'ADD', 'A', 'n'),
    ([0xC7], 'RST', '0H'),
    ([0xC8], 'RET', 'Z'),
    ([0xC9], 'RET'),
    ([0xCA], 'JP', 'Z', 'nn'),
    ([0xCB00], 'RLC', 'B'),
    ([0xCB01], 'RLC', 'C'),
    ([0xCB02], 'RLC', 'D'),
    ([0xCB03], 'RLC', 'E'),
    ([0xCB04], 'RLC', 'H'),
    ([0xCB05], 'RLC', 'L'),
    ([0xCB06], 'RLC', '(', 'HL', ')'),
    ([0xCB07], 'RLC', 'A'),
    ([0xCB08], 'RRC', 'B'),
    ([0xCB09], 'RRC', 'C'),
    ([0xCB0A], 'RRC', 'D'),
    ([0xCB0B], 'RRC', 'E'),
    ([0xCB0C], 'RRC', 'H'),
    ([0xCB0D], 'RRC', 'L'),
    ([0xCB0E], 'RRC', '(', 'HL', ')'),
    ([0xCB0F], 'RRC', 'A'),
    ([0xCB10], 'RL', 'B'),
    ([0xCB11], 'RL', 'C'),
    ([0xCB12], 'RL', 'D'),
    ([0xCB13], 'RL', 'E'),
    ([0xCB14], 'RL', 'H'),
    ([0xCB15], 'RL', 'L'),
    ([0xCB16], 'RL', '(', 'HL', ')'),
    ([0xCB17], 'RL', 'A'),
    ([0xCB18], 'RR', 'B'),
    ([0xCB19], 'RR', 'C'),
    ([0xCB1A], 'RR', 'D'),
    ([0xCB1B], 'RR', 'E'),
    ([0xCB1C], 'RR', 'H'),
    ([0xCB1D], 'RR', 'L'),
    ([0xCB1E], 'RR', '(', 'HL', ')'),
    ([0xCB1F], 'RR', 'A'),
    ([0xCB20], 'SLA', 'B'),
    ([0xCB21], 'SLA', 'C'),
    ([0xCB22], 'SLA', 'D'),
    ([0xCB23], 'SLA', 'E'),
    ([0xCB24], 'SLA', 'H'),
    ([0xCB25], 'SLA', 'L'),
    ([0xCB26], 'SLA', '(', 'HL', ')'),
    ([0xCB27], 'SLA', 'A'),
    ([0xCB28], 'SRA', 'B'),
    ([0xCB29], 'SRA', 'C'),
    ([0xCB2A], 'SRA', 'D'),
    ([0xCB2B], 'SRA', 'E'),
    ([0xCB2C], 'SRA', 'H'),
    ([0xCB2D], 'SRA', 'L'),
    ([0xCB2E], 'SRA', '(', 'HL', ')'),
    ([0xCB2F], 'SRA', 'A'),
    ([0xCB30], 'SLL', 'B'),
    ([0xCB31], 'SLL', 'C'),
    ([0xCB32], 'SLL', 'D'),
    ([0xCB33], 'SLL', 'E'),
    ([0xCB34], 'SLL', 'H'),
    ([0xCB35], 'SLL', 'L'),
    ([0xCB36], 'SLL', '(', 'HL', ')'),
    ([0xCB37], 'SLL', 'A'),
    ([0xCB38], 'SRL', 'B'),
    ([0xCB39], 'SRL', 'C'),
    ([0xCB3A], 'SRL', 'D'),
    ([0xCB3B], 'SRL', 'E'),
    ([0xCB3C], 'SRL', 'H'),
    ([0xCB3D], 'SRL', 'L'),
    ([0xCB3E], 'SRL', '(', 'HL', ')'),
    ([0xCB3F], 'SRL', 'A'),
    ([0xCB40], 'BIT', '0', 'B'),
    ([0xCB41], 'BIT', '0', 'C'),
    ([0xCB42], 'BIT', '0', 'D'),
    ([0xCB43], 'BIT', '0', 'E'),
    ([0xCB44], 'BIT', '0', 'H'),
    ([0xCB45], 'BIT', '0', 'L'),
    ([0xCB46], 'BIT', '0', '(', 'HL', ')'),
    ([0xCB47], 'BIT', '0', 'A'),
    ([0xCB48], 'BIT', '1', 'B'),
    ([0xCB49], 'BIT', '1', 'C'),
    ([0xCB4A], 'BIT', '1', 'D'),
    ([0xCB4B], 'BIT', '1', 'E'),
    ([0xCB4C], 'BIT', '1', 'H'),
    ([0xCB4D], 'BIT', '1', 'L'),
    ([0xCB4E], 'BIT', '1', '(', 'HL', ')'),
    ([0xCB4F], 'BIT', '1', 'A'),
    ([0xCB50], 'BIT', '2', 'B'),
    ([0xCB51], 'BIT', '2', 'C'),
    ([0xCB52], 'BIT', '2', 'D'),
    ([0xCB53], 'BIT', '2', 'E'),
    ([0xCB54], 'BIT', '2', 'H'),
    ([0xCB55], 'BIT', '2', 'L'),
    ([0xCB56], 'BIT', '2', '(', 'HL', ')'),
    ([0xCB57], 'BIT', '2', 'A'),
    ([0xCB58], 'BIT', '3', 'B'),
    ([0xCB59], 'BIT', '3', 'C'),
    ([0xCB5A], 'BIT', '3', 'D'),
    ([0xCB5B], 'BIT', '3', 'E'),
    ([0xCB5C], 'BIT', '3', 'H'),
    ([0xCB5D], 'BIT', '3', 'L'),
    ([0xCB5E], 'BIT', '3', '(', 'HL', ')'),
    ([0xCB5F], 'BIT', '3', 'A'),
    ([0xCB60], 'BIT', '4', 'B'),
    ([0xCB61], 'BIT', '4', 'C'),
    ([0xCB62], 'BIT', '4', 'D'),
    ([0xCB63], 'BIT', '4', 'E'),
    ([0xCB64], 'BIT', '4', 'H'),
    ([0xCB65], 'BIT', '4', 'L'),
    ([0xCB66], 'BIT', '4', '(', 'HL', ')'),
    ([0xCB67], 'BIT', '4', 'A'),
    ([0xCB68], 'BIT', '5', 'B'),
    ([0xCB69], 'BIT', '5', 'C'),
    ([0xCB6A], 'BIT', '5', 'D'),
    ([0xCB6B], 'BIT', '5', 'E'),
    ([0xCB6C], 'BIT', '5', 'H'),
    ([0xCB6D], 'BIT', '5', 'L'),
    ([0xCB6E], 'BIT', '5', '(', 'HL', ')'),
    ([0xCB6F], 'BIT', '5', 'A'),
    ([0xCB70], 'BIT', '6', 'B'),
    ([0xCB71], 'BIT', '6', 'C'),
    ([0xCB72], 'BIT', '6', 'D'),
    ([0xCB73], 'BIT', '6', 'E'),
    ([0xCB74], 'BIT', '6', 'H'),
    ([0xCB75], 'BIT', '6', 'L'),
    ([0xCB76], 'BIT', '6', '(', 'HL', ')'),
    ([0xCB77], 'BIT', '6', 'A'),
    ([0xCB78], 'BIT', '7', 'B'),
    ([0xCB79], 'BIT', '7', 'C'),
    ([0xCB7A], 'BIT', '7', 'D'),
    ([0xCB7B], 'BIT', '7', 'E'),
    ([0xCB7C], 'BIT', '7', 'H'),
    ([0xCB7D], 'BIT', '7', 'L'),
    ([0xCB7E], 'BIT', '7', '(', 'HL', ')'),
    ([0xCB7F], 'BIT', '7', 'A'),
    ([0xCB80], 'RES', '0', 'B'),
    ([0xCB81], 'RES', '0', 'C'),
    ([0xCB82], 'RES', '0', 'D'),
    ([0xCB83], 'RES', '0', 'E'),
    ([0xCB84], 'RES', '0', 'H'),
    ([0xCB85], 'RES', '0', 'L'),
    ([0xCB86], 'RES', '0', '(', 'HL', ')'),
    ([0xCB87], 'RES', '0', 'A'),
    ([0xCB88], 'RES', '1', 'B'),
    ([0xCB89], 'RES', '1', 'C'),
    ([0xCB8A], 'RES', '1', 'D'),
    ([0xCB8B], 'RES', '1', 'E'),
    ([0xCB8C], 'RES', '1', 'H'),
    ([0xCB8D], 'RES', '1', 'L'),
    ([0xCB8E], 'RES', '1', '(', 'HL', ')'),
    ([0xCB8F], 'RES', '1', 'A'),
    ([0xCB90], 'RES', '2', 'B'),
    ([0xCB91], 'RES', '2', 'C'),
    ([0xCB92], 'RES', '2', 'D'),
    ([0xCB93], 'RES', '2', 'E'),
    ([0xCB94], 'RES', '2', 'H'),
    ([0xCB95], 'RES', '2', 'L'),
    ([0xCB96], 'RES', '2', '(', 'HL', ')'),
    ([0xCB97], 'RES', '2', 'A'),
    ([0xCB98], 'RES', '3', 'B'),
    ([0xCB99], 'RES', '3', 'C'),
    ([0xCB9A], 'RES', '3', 'D'),
    ([0xCB9B], 'RES', '3', 'E'),
    ([0xCB9C], 'RES', '3', 'H'),
    ([0xCB9D], 'RES', '3', 'L'),
    ([0xCB9E], 'RES', '3', '(', 'HL', ')'),
    ([0xCB9F], 'RES', '3', 'A'),
    ([0xCBA0], 'RES', '4', 'B'),
    ([0xCBA1], 'RES', '4', 'C'),
    ([0xCBA2], 'RES', '4', 'D'),
    ([0xCBA3], 'RES', '4', 'E'),
    ([0xCBA4], 'RES', '4', 'H'),
    ([0xCBA5], 'RES', '4', 'L'),
    ([0xCBA6], 'RES', '4', '(', 'HL', ')'),
    ([0xCBA7], 'RES', '4', 'A'),
    ([0xCBA8], 'RES', '5', 'B'),
    ([0xCBA9], 'RES', '5', 'C'),
    ([0xCBAA], 'RES', '5', 'D'),
    ([0xCBAB], 'RES', '5', 'E'),
    ([0xCBAC], 'RES', '5', 'H'),
    ([0xCBAD], 'RES', '5', 'L'),
    ([0xCBAE], 'RES', '5', '(', 'HL', ')'),
    ([0xCBAF], 'RES', '5', 'A'),
    ([0xCBB0], 'RES', '6', 'B'),
    ([0xCBB1], 'RES', '6', 'C'),
    ([0xCBB2], 'RES', '6', 'D'),
    ([0xCBB3], 'RES', '6', 'E'),
    ([0xCBB4], 'RES', '6', 'H'),
    ([0xCBB5], 'RES', '6', 'L'),
    ([0xCBB6], 'RES', '6', '(', 'HL', ')'),
    ([0xCBB7], 'RES', '6', 'A'),
    ([0xCBB8], 'RES', '7', 'B'),
    ([0xCBB9], 'RES', '7', 'C'),
    ([0xCBBA], 'RES', '7', 'D'),
    ([0xCBBB], 'RES', '7', 'E'),
    ([0xCBBC], 'RES', '7', 'H'),
    ([0xCBBD], 'RES', '7', 'L'),
    ([0xCBBE], 'RES', '7', '(', 'HL', ')'),
    ([0xCBBF], 'RES', '7', 'A'),
    ([0xCBC0], 'SET', '0', 'B'),
    ([0xCBC1], 'SET', '0', 'C'),
    ([0xCBC2], 'SET', '0', 'D'),
    ([0xCBC3], 'SET', '0', 'E'),
    ([0xCBC4], 'SET', '0', 'H'),
    ([0xCBC5], 'SET', '0', 'L'),
    ([0xCBC6], 'SET', '0', '(', 'HL', ')'),
    ([0xCBC7], 'SET', '0', 'A'),
    ([0xCBC8], 'SET', '1', 'B'),
    ([0xCBC9], 'SET', '1', 'C'),
    ([0xCBCA], 'SET', '1', 'D'),
    ([0xCBCB], 'SET', '1', 'E'),
    ([0xCBCC], 'SET', '1', 'H'),
    ([0xCBCD], 'SET', '1', 'L'),
    ([0xCBCE], 'SET', '1', '(', 'HL', ')'),
    ([0xCBCF], 'SET', '1', 'A'),
    ([0xCBD0], 'SET', '2', 'B'),
    ([0xCBD1], 'SET', '2', 'C'),
    ([0xCBD2], 'SET', '2', 'D'),
    ([0xCBD3], 'SET', '2', 'E'),
    ([0xCBD4], 'SET', '2', 'H'),
    ([0xCBD5], 'SET', '2', 'L'),
    ([0xCBD6], 'SET', '2', '(', 'HL', ')'),
    ([0xCBD7], 'SET', '2', 'A'),
    ([0xCBD8], 'SET', '3', 'B'),
    ([0xCBD9], 'SET', '3', 'C'),
    ([0xCBDA], 'SET', '3', 'D'),
    ([0xCBDB], 'SET', '3', 'E'),
    ([0xCBDC], 'SET', '3', 'H'),
    ([0xCBDD], 'SET', '3', 'L'),
    ([0xCBDE], 'SET', '3', '(', 'HL', ')'),
    ([0xCBDF], 'SET', '3', 'A'),
    ([0xCBE0], 'SET', '4', 'B'),
    ([0xCBE1], 'SET', '4', 'C'),
    ([0xCBE2], 'SET', '4', 'D'),
    ([0xCBE3], 'SET', '4', 'E'),
    ([0xCBE4], 'SET', '4', 'H'),
    ([0xCBE5], 'SET', '4', 'L'),
    ([0xCBE6], 'SET', '4', '(', 'HL', ')'),
    ([0xCBE7], 'SET', '4', 'A'),
    ([0xCBE8], 'SET', '5', 'B'),
    ([0xCBE9], 'SET', '5', 'C'),
    ([0xCBEA], 'SET', '5', 'D'),
    ([0xCBEB], 'SET', '5', 'E'),
    ([0xCBEC], 'SET', '5', 'H'),
    ([0xCBED], 'SET', '5', 'L'),
    ([0xCBEE], 'SET', '5', '(', 'HL', ')'),
    ([0xCBEF], 'SET', '5', 'A'),
    ([0xCBF0], 'SET', '6', 'B'),
    ([0xCBF1], 'SET', '6', 'C'),
    ([0xCBF2], 'SET', '6', 'D'),
    ([0xCBF3], 'SET', '6', 'E'),
    ([0xCBF4], 'SET', '6', 'H'),
    ([0xCBF5], 'SET', '6', 'L'),
    ([0xCBF6], 'SET', '6', '(', 'HL', ')'),
    ([0xCBF7], 'SET', '6', 'A'),
    ([0xCBF8], 'SET', '7', 'B'),
    ([0xCBF9], 'SET', '7', 'C'),
    ([0xCBFA], 'SET', '7', 'D'),
    ([0xCBFB], 'SET', '7', 'E'),
    ([0xCBFC], 'SET', '7', 'H'),
    ([0xCBFD], 'SET', '7', 'L'),
    ([0xCBFE], 'SET', '7', '(', 'HL', ')'),
    ([0xCBFF], 'SET', '7', 'A'),
    ([0xCC], 'CALL', 'Z',  'nn'),
    ([0xCD], 'CALL', 'nn'),
    ([0xCE], 'ADC', 'A', 'n'),
    ([0xCF], 'RST', '8H'),
    ([0xD0], 'RET', 'NC'),
    ([0xD1], 'POP', 'DE'),
    ([0xD2], 'JP', 'NC',  'nn'),
    ([0xD3], 'OUT', '(', 'n', ')', 'A'),
    ([0xD4], 'CALL', 'NC', 'nn'),
    ([0xD5], 'PUSH', 'DE'),
    ([0xD6], 'SUB', 'n'),
    ([0xD7], 'RST', '10H'),
    ([0xD8], 'RET', 'C'),
    ([0xD9], 'EXX'),
    ([0xDA], 'JP', 'C', 'nn'),
    ([0xDB], 'IN', 'A', '(', 'n', ')'),
    ([0xDC], 'CALL', 'C',  'nn'),
    ([0xDD09], 'ADD', 'IX', 'BC'),
    ([0xDD19], 'ADD', 'IX', 'DE'),
    ([0xDD21], 'LD', 'IX', 'nn'),
    ([0xDD22], 'LD', '(', 'nn', ')', 'IX'),
    ([0xDD23], 'INC', 'IX'),
    ([0xDD24], 'INC', 'IXH'),
    ([0xDD25], 'DEC', 'IXH'),
    ([0xDD26], 'LD', 'IXH', 'n'),
    ([0xDD29], 'ADD', 'IX', 'IX'),
    ([0xDD2A], 'LD', 'IX', '(', 'nn', ')'),
    ([0xDD2B], 'DEC', 'IX'),
    ([0xDD2C], 'INC', 'IXL'),
    ([0xDD2D], 'DEC', 'IXL'),
    ([0xDD2E], 'LD', 'IXL', 'n'),
    ([0xDD34], 'INC', '(', 'IX+d', ')'),
    ([0xDD35], 'DEC', '(', 'IX+d', ')'),
    ([0xDD36], 'LD', '(', 'IX+d', ')', 'n'),
    ([0xDD39], 'ADD', 'IX', 'SP'),
    ([0xDD44], 'LD', 'B', 'IXH'),
    ([0xDD45], 'LD', 'B', 'IXL'),
    ([0xDD46], 'LD', 'B', '(', 'IX+d', ')'),
    ([0xDD4C], 'LD', 'C', 'IXH'),
    ([0xDD4D], 'LD', 'C', 'IXL'),
    ([0xDD4E], 'LD', 'C', '(', 'IX+d', ')'),
    ([0xDD54], 'LD', 'D', 'IXH'),
    ([0xDD55], 'LD', 'D', 'IXL'),
    ([0xDD56], 'LD', 'D', '(', 'IX+d', ')'),
    ([0xDD5C], 'LD', 'E', 'IXH'),
    ([0xDD5D], 'LD', 'E', 'IXL'),
    ([0xDD5E], 'LD', 'E', '(', 'IX+d', ')'),
    ([0xDD60], 'LD', 'IXH', 'B'),
    ([0xDD61], 'LD', 'IXH', 'C'),
    ([0xDD62], 'LD', 'IXH', 'D'),
    ([0xDD63], 'LD', 'IXH', 'E'),
    ([0xDD64], 'LD', 'IXH', 'IXH'),
    ([0xDD65], 'LD', 'IXH', 'IXL'),
    ([0xDD66], 'LD', 'H', '(', 'IX+d', ')'),
    ([0xDD67], 'LD', 'IXH', 'A'),
    ([0xDD68], 'LD', 'IXL', 'B'),
    ([0xDD69], 'LD', 'IXL', 'C'),
    ([0xDD6A], 'LD', 'IXL', 'D'),
    ([0xDD6B], 'LD', 'IXL', 'E'),
    ([0xDD6C], 'LD', 'IXL', 'IXH'),
    ([0xDD6D], 'LD', 'IXL', 'IXL'),
    ([0xDD6E], 'LD', 'L', '(', 'IX+d', ')'),
    ([0xDD6F], 'LD', 'IXL', 'A'),
    ([0xDD70], 'LD', '(', 'IX+d', ')', 'B'),
    ([0xDD71], 'LD', '(', 'IX+d', ')', 'C'),
    ([0xDD72], 'LD', '(', 'IX+d', ')', 'D'),
    ([0xDD73], 'LD', '(', 'IX+d', ')', 'E'),
    ([0xDD74], 'LD', '(', 'IX+d', ')', 'H'),
    ([0xDD75], 'LD', '(', 'IX+d', ')', 'L'),
    ([0xDD77], 'LD', '(', 'IX+d', ')', 'A'),
    ([0xDD7C], 'LD', 'A', 'IXH'),
    ([0xDD7D], 'LD', 'A', 'IXL'),
    ([0xDD7E], 'LD', 'A', '(', 'IX+d', ')'),
    ([0xDD84], 'ADD', 'A', 'IXH'),
    ([0xDD85], 'ADD', 'A', 'IXL'),
    ([0xDD86], 'ADD', 'A', '(', 'IX+d', ')'),
    ([0xDD8C], 'ADC', 'A', 'IXH'),
    ([0xDD8D], 'ADC', 'A', 'IXL'),
    ([0xDD8E], 'ADC', 'A', '(', 'IX+d', ')'),
    ([0xDD94], 'SUB', 'IXH'),
    ([0xDD95], 'SUB', 'IXL'),
    ([0xDD96], 'SUB', '(', 'IX+d', ')'),
    ([0xDD9C], 'SBC', 'A', 'IXH'),
    ([0xDD9D], 'SBC', 'A', 'IXL'),
    ([0xDD9E], 'SBC', 'A', '(', 'IX+d', ')'),
    ([0xDDA4], 'AND', 'IXH'),
    ([0xDDA5], 'AND', 'IXL'),
    ([0xDDA6], 'AND', '(', 'IX+d', ')'),
    ([0xDDAC], 'XOR', 'IXH'),
    ([0xDDAD], 'XOR', 'IXL'),
    ([0xDDAE], 'XOR', '(', 'IX+d', ')'),
    ([0xDDB4], 'OR', 'IXH'),
    ([0xDDB5], 'OR', 'IXL'),
    ([0xDDB6], 'OR', '(', 'IX+d', ')'),
    ([0xDDBC], 'CP', 'IXH'),
    ([0xDDBD], 'CP', 'IXL'),
    ([0xDDBE], 'CP', '(', 'IX+d', ')'),
    ([0xDDCB, 0x00], 'LD', 'B', 'RLC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x01], 'LD', 'C', 'RLC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x02], 'LD', 'D', 'RLC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x03], 'LD', 'E', 'RLC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x04], 'LD', 'H', 'RLC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x05], 'LD', 'L', 'RLC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x06], 'RLC', '(', 'IX+d', ')'),
    ([0xDDCB, 0x07], 'LD', 'A', 'RLC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x08], 'LD', 'B', 'RRC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x09], 'LD', 'C', 'RRC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x0A], 'LD', 'D', 'RRC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x0B], 'LD', 'E', 'RRC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x0C], 'LD', 'H', 'RRC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x0D], 'LD', 'L', 'RRC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x0E], 'RRC', '(', 'IX+d', ')'),
    ([0xDDCB, 0x0F], 'LD', 'A', 'RRC ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x10], 'LD', 'B', 'RL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x11], 'LD', 'C', 'RL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x12], 'LD', 'D', 'RL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x13], 'LD', 'E', 'RL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x14], 'LD', 'H', 'RL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x15], 'LD', 'L', 'RL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x16], 'RL', '(', 'IX+d', ')'),
    ([0xDDCB, 0x17], 'LD', 'A', 'RL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x18], 'LD', 'B', 'RR ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x19], 'LD', 'C', 'RR ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x1A], 'LD', 'D', 'RR ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x1B], 'LD', 'E', 'RR ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x1C], 'LD', 'H', 'RR ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x1D], 'LD', 'L', 'RR ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x1E], 'RR', '(', 'IX+d', ')'),
    ([0xDDCB, 0x1F], 'LD', 'A', 'RR ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x20], 'LD', 'B', 'SLA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x21], 'LD', 'C', 'SLA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x22], 'LD', 'D', 'SLA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x23], 'LD', 'E', 'SLA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x24], 'LD', 'H', 'SLA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x25], 'LD', 'L', 'SLA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x26], 'SLA', '(', 'IX+d', ')'),
    ([0xDDCB, 0x27], 'LD', 'A', 'SLA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x28], 'LD', 'B', 'SRA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x29], 'LD', 'C', 'SRA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x2A], 'LD', 'D', 'SRA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x2B], 'LD', 'E', 'SRA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x2C], 'LD', 'H', 'SRA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x2D], 'LD', 'L', 'SRA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x2E], 'SRA', '(', 'IX+d', ')'),
    ([0xDDCB, 0x2F], 'LD', 'A', 'SRA ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x30], 'LD', 'B', 'SLL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x31], 'LD', 'C', 'SLL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x32], 'LD', 'D', 'SLL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x33], 'LD', 'E', 'SLL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x34], 'LD', 'H', 'SLL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x35], 'LD', 'L', 'SLL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x36], 'SLL', '(', 'IX+d', ')'),
    ([0xDDCB, 0x37], 'LD', 'A', 'SLL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x38], 'LD', 'B', 'SRL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x39], 'LD', 'C', 'SRL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x3A], 'LD', 'D', 'SRL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x3B], 'LD', 'E', 'SRL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x3C], 'LD', 'H', 'SRL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x3D], 'LD', 'L', 'SRL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x3E], 'SRL', '(', 'IX+d', ')'),
    ([0xDDCB, 0x3F], 'LD', 'A', 'SRL ', '(', 'IX+d', ')'),
    ([0xDDCB, 0x40], 'BIT', '0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x41], 'BIT', '0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x42], 'BIT', '0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x43], 'BIT', '0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x44], 'BIT', '0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x45], 'BIT', '0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x46], 'BIT', '0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x47], 'BIT', '0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x48], 'BIT', '1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x49], 'BIT', '1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x4A], 'BIT', '1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x4B], 'BIT', '1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x4C], 'BIT', '1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x4D], 'BIT', '1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x4E], 'BIT', '1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x4F], 'BIT', '1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x50], 'BIT', '2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x51], 'BIT', '2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x52], 'BIT', '2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x53], 'BIT', '2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x54], 'BIT', '2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x55], 'BIT', '2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x56], 'BIT', '2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x57], 'BIT', '2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x58], 'BIT', '3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x59], 'BIT', '3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x5A], 'BIT', '3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x5B], 'BIT', '3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x5C], 'BIT', '3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x5D], 'BIT', '3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x5E], 'BIT', '3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x5F], 'BIT', '3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x60], 'BIT', '4', '(', 'IX+d', ')'),
    ([0xDDCB, 0x61], 'BIT', '4', '(', 'IX+d', ')'),
    ([0xDDCB, 0x62], 'BIT', '4', '(', 'IX+d', ')'),
    ([0xDDCB, 0x63], 'BIT', '4', '(', 'IX+d', ')'),
    ([0xDDCB, 0x64], 'BIT', '4', '(', 'IX+d', ')'),
    ([0xDDCB, 0x65], 'BIT', '4', '(', 'IX+d', ')'),
    ([0xDDCB, 0x66], 'BIT', '4', '(', 'IX+d', ')'),
    ([0xDDCB, 0x67], 'BIT', '4', '(', 'IX+d', ')'),
    ([0xDDCB, 0x68], 'BIT', '5', '(', 'IX+d', ')'),
    ([0xDDCB, 0x69], 'BIT', '5', '(', 'IX+d', ')'),
    ([0xDDCB, 0x6A], 'BIT', '5', '(', 'IX+d', ')'),
    ([0xDDCB, 0x6B], 'BIT', '5', '(', 'IX+d', ')'),
    ([0xDDCB, 0x6C], 'BIT', '5', '(', 'IX+d', ')'),
    ([0xDDCB, 0x6D], 'BIT', '5', '(', 'IX+d', ')'),
    ([0xDDCB, 0x6E], 'BIT', '5', '(', 'IX+d', ')'),
    ([0xDDCB, 0x6F], 'BIT', '5', '(', 'IX+d', ')'),
    ([0xDDCB, 0x70], 'BIT', '6', '(', 'IX+d', ')'),
    ([0xDDCB, 0x71], 'BIT', '6', '(', 'IX+d', ')'),
    ([0xDDCB, 0x72], 'BIT', '6', '(', 'IX+d', ')'),
    ([0xDDCB, 0x73], 'BIT', '6', '(', 'IX+d', ')'),
    ([0xDDCB, 0x74], 'BIT', '6', '(', 'IX+d', ')'),
    ([0xDDCB, 0x75], 'BIT', '6', '(', 'IX+d', ')'),
    ([0xDDCB, 0x76], 'BIT', '6', '(', 'IX+d', ')'),
    ([0xDDCB, 0x77], 'BIT', '6', '(', 'IX+d', ')'),
    ([0xDDCB, 0x78], 'BIT', '7', '(', 'IX+d', ')'),
    ([0xDDCB, 0x79], 'BIT', '7', '(', 'IX+d', ')'),
    ([0xDDCB, 0x7A], 'BIT', '7', '(', 'IX+d', ')'),
    ([0xDDCB, 0x7B], 'BIT', '7', '(', 'IX+d', ')'),
    ([0xDDCB, 0x7C], 'BIT', '7', '(', 'IX+d', ')'),
    ([0xDDCB, 0x7D], 'BIT', '7', '(', 'IX+d', ')'),
    ([0xDDCB, 0x7E], 'BIT', '7', '(', 'IX+d', ')'),
    ([0xDDCB, 0x7F], 'BIT', '7', '(', 'IX+d', ')'),
    ([0xDDCB, 0x80], 'LD', 'B', 'RES 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x81], 'LD', 'C', 'RES 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x82], 'LD', 'D', 'RES 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x83], 'LD', 'E', 'RES 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x84], 'LD', 'H', 'RES 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x85], 'LD', 'L', 'RES 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x86], 'RES', '0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x87], 'LD', 'A', 'RES 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0x88], 'LD', 'B', 'RES 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x89], 'LD', 'C', 'RES 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x8A], 'LD', 'D', 'RES 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x8B], 'LD', 'E', 'RES 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x8C], 'LD', 'H', 'RES 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x8D], 'LD', 'L', 'RES 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x8E], 'RES', '1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x8F], 'LD', 'A', 'RES 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0x90], 'LD', 'B', 'RES 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x91], 'LD', 'C', 'RES 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x92], 'LD', 'D', 'RES 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x93], 'LD', 'E', 'RES 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x94], 'LD', 'H', 'RES 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x95], 'LD', 'L', 'RES 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x96], 'RES', '2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x97], 'LD', 'A', 'RES 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0x98], 'LD', 'B', 'RES 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x99], 'LD', 'C', 'RES 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x9A], 'LD', 'D', 'RES 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x9B], 'LD', 'E', 'RES 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x9C], 'LD', 'H', 'RES 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x9D], 'LD', 'L', 'RES 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x9E], 'RES', '3', '(', 'IX+d', ')'),
    ([0xDDCB, 0x9F], 'LD', 'A', 'RES 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0xA0], 'LD', 'B', 'RES 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xA1], 'LD', 'C', 'RES 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xA2], 'LD', 'D', 'RES 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xA3], 'LD', 'E', 'RES 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xA4], 'LD', 'H', 'RES 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xA5], 'LD', 'L', 'RES 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xA6], 'RES', '4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xA7], 'LD', 'A', 'RES 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xA8], 'LD', 'B', 'RES 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xA9], 'LD', 'C', 'RES 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xAA], 'LD', 'D', 'RES 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xAB], 'LD', 'E', 'RES 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xAC], 'LD', 'H', 'RES 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xAD], 'LD', 'L', 'RES 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xAE], 'RES', '5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xAF], 'LD', 'A', 'RES 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xB0], 'LD', 'B', 'RES 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xB1], 'LD', 'C', 'RES 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xB2], 'LD', 'D', 'RES 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xB3], 'LD', 'E', 'RES 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xB4], 'LD', 'H', 'RES 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xB5], 'LD', 'L', 'RES 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xB6], 'RES', '6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xB7], 'LD', 'A', 'RES 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xB8], 'LD', 'B', 'RES 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xB9], 'LD', 'C', 'RES 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xBA], 'LD', 'D', 'RES 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xBB], 'LD', 'E', 'RES 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xBC], 'LD', 'H', 'RES 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xBD], 'LD', 'L', 'RES 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xBE], 'RES', '7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xBF], 'LD', 'A', 'RES 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xC0], 'LD', 'B', 'SET 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0xC1], 'LD', 'C', 'SET 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0xC2], 'LD', 'D', 'SET 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0xC3], 'LD', 'E', 'SET 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0xC4], 'LD', 'H', 'SET 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0xC5], 'LD', 'L', 'SET 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0xC6], 'SET', '0', '(', 'IX+d', ')'),
    ([0xDDCB, 0xC7], 'LD', 'A', 'SET 0', '(', 'IX+d', ')'),
    ([0xDDCB, 0xC8], 'LD', 'B', 'SET 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0xC9], 'LD', 'C', 'SET 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0xCA], 'LD', 'D', 'SET 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0xCB], 'LD', 'E', 'SET 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0xCC], 'LD', 'H', 'SET 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0xCD], 'LD', 'L', 'SET 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0xCE], 'SET', '1', '(', 'IX+d', ')'),
    ([0xDDCB, 0xCF], 'LD', 'A', 'SET 1', '(', 'IX+d', ')'),
    ([0xDDCB, 0xD0], 'LD', 'B', 'SET 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0xD1], 'LD', 'C', 'SET 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0xD2], 'LD', 'D', 'SET 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0xD3], 'LD', 'E', 'SET 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0xD4], 'LD', 'H', 'SET 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0xD5], 'LD', 'L', 'SET 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0xD6], 'SET', '2', '(', 'IX+d', ')'),
    ([0xDDCB, 0xD7], 'LD', 'A', 'SET 2', '(', 'IX+d', ')'),
    ([0xDDCB, 0xD8], 'LD', 'B', 'SET 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0xD9], 'LD', 'C', 'SET 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0xDA], 'LD', 'D', 'SET 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0xDB], 'LD', 'E', 'SET 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0xDC], 'LD', 'H', 'SET 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0xDD], 'LD', 'L', 'SET 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0xDE], 'SET', '3', '(', 'IX+d', ')'),
    ([0xDDCB, 0xDF], 'LD', 'A', 'SET 3', '(', 'IX+d', ')'),
    ([0xDDCB, 0xE0], 'LD', 'B', 'SET 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xE1], 'LD', 'C', 'SET 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xE2], 'LD', 'D', 'SET 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xE3], 'LD', 'E', 'SET 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xE4], 'LD', 'H', 'SET 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xE5], 'LD', 'L', 'SET 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xE6], 'SET', '4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xE7], 'LD', 'A', 'SET 4', '(', 'IX+d', ')'),
    ([0xDDCB, 0xE8], 'LD', 'B', 'SET 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xE9], 'LD', 'C', 'SET 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xEA], 'LD', 'D', 'SET 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xEB], 'LD', 'E', 'SET 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xEC], 'LD', 'H', 'SET 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xED], 'LD', 'L', 'SET 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xEE], 'SET', '5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xEF], 'LD', 'A', 'SET 5', '(', 'IX+d', ')'),
    ([0xDDCB, 0xF0], 'LD', 'B', 'SET 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xF1], 'LD', 'C', 'SET 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xF2], 'LD', 'D', 'SET 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xF3], 'LD', 'E', 'SET 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xF4], 'LD', 'H', 'SET 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xF5], 'LD', 'L', 'SET 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xF6], 'SET', '6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xF7], 'LD', 'A', 'SET 6', '(', 'IX+d', ')'),
    ([0xDDCB, 0xF8], 'LD', 'B', 'SET 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xF9], 'LD', 'C', 'SET 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xFA], 'LD', 'D', 'SET 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xFB], 'LD', 'E', 'SET 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xFC], 'LD', 'H', 'SET 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xFD], 'LD', 'L', 'SET 7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xFE], 'SET', '7', '(', 'IX+d', ')'),
    ([0xDDCB, 0xFF], 'LD', 'A', 'SET 7', '(', 'IX+d', ')'),
    ([0xDDE1], 'POP', 'IX'),
    ([0xDDE3], 'EX', '(', 'SP', ')', 'IX'),
    ([0xDDE5], 'PUSH', 'IX'),
    ([0xDDE9], 'JP', '(', 'IX', ')'),
    ([0xDDF9], 'LD', 'SP', 'IX'),
    ([0xDE], 'SBC', 'A', 'n'),
    ([0xDF], 'RST', '18H'),
    ([0xE0], 'RET', 'PO'),
    ([0xE1], 'POP', 'HL'),
    ([0xE2], 'JP', 'PO', 'nn'),
    ([0xE3], 'EX', '(', 'SP', ')', 'HL'),
    ([0xE4], 'CALL', 'PO', 'nn'),
    ([0xE5], 'PUSH', 'HL'),
    ([0xE6], 'AND', 'n'),
    ([0xE7], 'RST', '20H'),
    ([0xE8], 'RET', 'PE'),
    ([0xE9], 'JP', '(', 'HL', ')'),
    ([0xEA], 'JP', 'PE',  'nn'),
    ([0xEB], 'EX', 'DE', 'HL'),
    ([0xEC], 'CALL', 'PE', 'nn'),
    ([0xED40], 'IN', 'B', '(', 'C', ')'),
    ([0xED41], 'OUT', '(', 'C', ')', 'B'),
    ([0xED42], 'SBC', 'HL', 'BC'),
    ([0xED43], 'LD', '(', 'nn', ')', 'BC'),
    ([0xED44], 'NEG'),
    ([0xED45], 'RETN'),
    ([0xED46], 'IM', '0'),
    ([0xED47], 'LD', 'I', 'A'),
    ([0xED48], 'IN', 'C', '(', 'C', ')'),
    ([0xED49], 'OUT', '(', 'C', ')', 'C'),
    ([0xED4A], 'ADC', 'HL', 'BC'),
    ([0xED4B], 'LD', 'BC', '(', 'nn', ')'),
    ([0xED4C], 'NEG'),
    ([0xED4D], 'RETI'),
    ([0xED4E], 'IM', '0/1'),
    ([0xED4F], 'LD', 'R', 'A'),
    ([0xED50], 'IN', 'D', '(', 'C', ')'),
    ([0xED51], 'OUT', '(', 'C', ')', 'D'),
    ([0xED52], 'SBC', 'HL', 'DE'),
    ([0xED53], 'LD', '(', 'nn', ')', 'DE'),
    ([0xED54], 'NEG'),
    ([0xED55], 'RETN'),
    ([0xED56], 'IM', '1'),
    ([0xED57], 'LD', 'A', 'I'),
    ([0xED58], 'IN', 'E', '(', 'C', ')'),
    ([0xED59], 'OUT', '(', 'C', ')', 'E'),
    ([0xED5A], 'ADC', 'HL', 'DE'),
    ([0xED5B], 'LD', 'DE', '(', 'nn', ')'),
    ([0xED5C], 'NEG'),
    ([0xED5D], 'RETN'),
    ([0xED5E], 'IM', '2'),
    ([0xED5F], 'LD', 'A', 'R'),
    ([0xED60], 'IN', 'H', '(', 'C', ')'),
    ([0xED61], 'OUT', '(', 'C', ')', 'H'),
    ([0xED62], 'SBC', 'HL', 'HL'),
    ([0xED63], 'LD', '(', 'nn', ')', 'HL'),
    ([0xED64], 'NEG'),
    ([0xED65], 'RETN'),
    ([0xED66], 'IM', '0'),
    ([0xED67], 'RRD'),
    ([0xED68], 'IN', 'L', '(', 'C', ')'),
    ([0xED69], 'OUT', '(', 'C', ')', 'L'),
    ([0xED6A], 'ADC', 'HL', 'HL'),
    ([0xED6B], 'LD', 'HL', '(', 'nn', ')'),
    ([0xED6C], 'NEG'),
    ([0xED6D], 'RETN'),
    ([0xED6E], 'IM', '0/1'),
    ([0xED6F], 'RLD'),
    ([0xED70], 'IN', 'F', '(', 'C', ')', '* / IN ', '(', 'C', ')'),
    ([0xED71], 'OUT', '(', 'C', ')', '0'),
    ([0xED72], 'SBC', 'HL', 'SP'),
    ([0xED73], 'LD', '(', 'nn', ')', 'SP'),
    ([0xED74], 'NEG'),
    ([0xED75], 'RETN'),
    ([0xED76], 'IM', '1'),
    ([0xED78], 'IN', 'A', '(', 'C', ')'),
    ([0xED79], 'OUT', '(', 'C', ')', 'A'),
    ([0xED7A], 'ADC', 'HL', 'SP'),
    ([0xED7B], 'LD', 'SP', '(', 'nn', ')'),
    ([0xED7C], 'NEG'),
    ([0xED7D], 'RETN'),
    ([0xED7E], 'IM', '2'),
    ([0xEDA0], 'LDI'),
    ([0xEDA1], 'CPI'),
    ([0xEDA2], 'INI'),
    ([0xEDA3], 'OUTI'),
    ([0xEDA8], 'LDD'),
    ([0xEDA9], 'CPD'),
    ([0xEDAA], 'IND'),
    ([0xEDAB], 'OUTD'),
    ([0xEDB0], 'LDIR'),
    ([0xEDB1], 'CPIR'),
    ([0xEDB2], 'INIR'),
    ([0xEDB3], 'OTIR'),
    ([0xEDB8], 'LDDR'),
    ([0xEDB9], 'CPDR'),
    ([0xEDBA], 'INDR'),
    ([0xEDBB], 'OTDR'),
    ([0xEE], 'XOR', 'n'),
    ([0xEF], 'RST', '28H'),
    ([0xF0], 'RET', 'P'),
    ([0xF1], 'POP', 'AF'),
    ([0xF2], 'JP', 'P', 'nn'),
    ([0xF3], 'DI'),
    ([0xF4], 'CALL', 'P', 'nn'),
    ([0xF5], 'PUSH', 'AF'),
    ([0xF6], 'OR', 'n'),
    ([0xF7], 'RST', '30H'),
    ([0xF8], 'RET', 'M'),
    ([0xF9], 'LD', 'SP', 'HL'),
    ([0xFA], 'JP', 'M', 'nn'),
    ([0xFB], 'EI'),
    ([0xFC], 'CALL', 'M',  'nn'),
    ([0xFD09], 'ADD', 'IY', 'BC'),
    ([0xFD19], 'ADD', 'IY', 'DE'),
    ([0xFD21], 'LD', 'IY', 'nn'),
    ([0xFD22], 'LD', '(', 'nn', ')', 'IY'),
    ([0xFD23], 'INC', 'IY'),
    ([0xFD24], 'INC', 'IYH'),
    ([0xFD25], 'DEC', 'IYH'),
    ([0xFD26], 'LD', 'IYH', 'n'),
    ([0xFD29], 'ADD', 'IY', 'IY'),
    ([0xFD2A], 'LD', 'IY', '(', 'nn', ')'),
    ([0xFD2B], 'DEC', 'IY'),
    ([0xFD2C], 'INC', 'IYL'),
    ([0xFD2D], 'DEC', 'IYL'),
    ([0xFD2E], 'LD', 'IYL', 'n'),
    ([0xFD34], 'INC', '(', 'IY+d', ')'),
    ([0xFD35], 'DEC', '(', 'IY+d', ')'),
    ([0xFD36], 'LD', '(', 'IY+d', ')', 'n'),
    ([0xFD39], 'ADD', 'IY', 'SP'),
    ([0xFD44], 'LD', 'B', 'IYH'),
    ([0xFD45], 'LD', 'B', 'IYL'),
    ([0xFD46], 'LD', 'B', '(', 'IY+d', ')'),
    ([0xFD4C], 'LD', 'C', 'IYH'),
    ([0xFD4D], 'LD', 'C', 'IYL'),
    ([0xFD4E], 'LD', 'C', '(', 'IY+d', ')'),
    ([0xFD54], 'LD', 'D', 'IYH'),
    ([0xFD55], 'LD', 'D', 'IYL'),
    ([0xFD56], 'LD', 'D', '(', 'IY+d', ')'),
    ([0xFD5C], 'LD', 'E', 'IYH'),
    ([0xFD5D], 'LD', 'E', 'IYL'),
    ([0xFD5E], 'LD', 'E', '(', 'IY+d', ')'),
    ([0xFD60], 'LD', 'IYH', 'B'),
    ([0xFD61], 'LD', 'IYH', 'C'),
    ([0xFD62], 'LD', 'IYH', 'D'),
    ([0xFD63], 'LD', 'IYH', 'E'),
    ([0xFD64], 'LD', 'IYH', 'IYH'),
    ([0xFD65], 'LD', 'IYH', 'IYL'),
    ([0xFD66], 'LD', 'H', '(', 'IY+d', ')'),
    ([0xFD67], 'LD', 'IYH', 'A'),
    ([0xFD68], 'LD', 'IYL', 'B'),
    ([0xFD69], 'LD', 'IYL', 'C'),
    ([0xFD6A], 'LD', 'IYL', 'D'),
    ([0xFD6B], 'LD', 'IYL', 'E'),
    ([0xFD6C], 'LD', 'IYL', 'IYH'),
    ([0xFD6D], 'LD', 'IYL', 'IYL'),
    ([0xFD6E], 'LD', 'L', '(', 'IY+d', ')'),
    ([0xFD6F], 'LD', 'IYL', 'A'),
    ([0xFD70], 'LD', '(', 'IY+d', ')', 'B'),
    ([0xFD71], 'LD', '(', 'IY+d', ')', 'C'),
    ([0xFD72], 'LD', '(', 'IY+d', ')', 'D'),
    ([0xFD73], 'LD', '(', 'IY+d', ')', 'E'),
    ([0xFD74], 'LD', '(', 'IY+d', ')', 'H'),
    ([0xFD75], 'LD', '(', 'IY+d', ')', 'L'),
    ([0xFD77], 'LD', '(', 'IY+d', ')', 'A'),
    ([0xFD7C], 'LD', 'A', 'IYH'),
    ([0xFD7D], 'LD', 'A', 'IYL'),
    ([0xFD7E], 'LD', 'A', '(', 'IY+d', ')'),
    ([0xFD84], 'ADD', 'A', 'IYH'),
    ([0xFD85], 'ADD', 'A', 'IYL'),
    ([0xFD86], 'ADD', 'A', '(', 'IY+d', ')'),
    ([0xFD8C], 'ADC', 'A', 'IYH'),
    ([0xFD8D], 'ADC', 'A', 'IYL'),
    ([0xFD8E], 'ADC', 'A', '(', 'IY+d', ')'),
    ([0xFD94], 'SUB', 'IYH'),
    ([0xFD95], 'SUB', 'IYL'),
    ([0xFD96], 'SUB', '(', 'IY+d', ')'),
    ([0xFD9C], 'SBC', 'A', 'IYH'),
    ([0xFD9D], 'SBC', 'A', 'IYL'),
    ([0xFD9E], 'SBC', 'A', '(', 'IY+d', ')'),
    ([0xFDA4], 'AND', 'IYH'),
    ([0xFDA5], 'AND', 'IYL'),
    ([0xFDA6], 'AND', '(', 'IY+d', ')'),
    ([0xFDAC], 'XOR', 'IYH'),
    ([0xFDAD], 'XOR', 'IYL'),
    ([0xFDAE], 'XOR', '(', 'IY+d', ')'),
    ([0xFDB4], 'OR', 'IYH'),
    ([0xFDB5], 'OR', 'IYL'),
    ([0xFDB6], 'OR', '(', 'IY+d', ')'),
    ([0xFDBC], 'CP', 'IYH'),
    ([0xFDBD], 'CP', 'IYL'),
    ([0xFDBE], 'CP', '(', 'IY+d', ')'),
    ([0xFDCB, 0x00], 'LD', 'B', 'RLC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x01], 'LD', 'C', 'RLC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x02], 'LD', 'D', 'RLC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x03], 'LD', 'E', 'RLC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x04], 'LD', 'H', 'RLC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x05], 'LD', 'L', 'RLC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x06], 'RLC', '(', 'IY+d', ')'),
    ([0xFDCB, 0x07], 'LD', 'A', 'RLC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x08], 'LD', 'B', 'RRC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x09], 'LD', 'C', 'RRC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x0A], 'LD', 'D', 'RRC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x0B], 'LD', 'E', 'RRC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x0C], 'LD', 'H', 'RRC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x0D], 'LD', 'L', 'RRC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x0E], 'RRC', '(', 'IY+d', ')'),
    ([0xFDCB, 0x0F], 'LD', 'A', 'RRC ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x10], 'LD', 'B', 'RL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x11], 'LD', 'C', 'RL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x12], 'LD', 'D', 'RL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x13], 'LD', 'E', 'RL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x14], 'LD', 'H', 'RL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x15], 'LD', 'L', 'RL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x16], 'RL', '(', 'IY+d', ')'),
    ([0xFDCB, 0x17], 'LD', 'A', 'RL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x18], 'LD', 'B', 'RR ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x19], 'LD', 'C', 'RR ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x1A], 'LD', 'D', 'RR ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x1B], 'LD', 'E', 'RR ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x1C], 'LD', 'H', 'RR ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x1D], 'LD', 'L', 'RR ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x1E], 'RR', '(', 'IY+d', ')'),
    ([0xFDCB, 0x1F], 'LD', 'A', 'RR ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x20], 'LD', 'B', 'SLA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x21], 'LD', 'C', 'SLA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x22], 'LD', 'D', 'SLA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x23], 'LD', 'E', 'SLA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x24], 'LD', 'H', 'SLA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x25], 'LD', 'L', 'SLA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x26], 'SLA', '(', 'IY+d', ')'),
    ([0xFDCB, 0x27], 'LD', 'A', 'SLA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x28], 'LD', 'B', 'SRA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x29], 'LD', 'C', 'SRA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x2A], 'LD', 'D', 'SRA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x2B], 'LD', 'E', 'SRA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x2C], 'LD', 'H', 'SRA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x2D], 'LD', 'L', 'SRA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x2E], 'SRA', '(', 'IY+d', ')'),
    ([0xFDCB, 0x2F], 'LD', 'A', 'SRA ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x30], 'LD', 'B', 'SLL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x31], 'LD', 'C', 'SLL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x32], 'LD', 'D', 'SLL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x33], 'LD', 'E', 'SLL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x34], 'LD', 'H', 'SLL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x35], 'LD', 'L', 'SLL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x36], 'SLL', '(', 'IY+d', ')'),
    ([0xFDCB, 0x37], 'LD', 'A', 'SLL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x38], 'LD', 'B', 'SRL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x39], 'LD', 'C', 'SRL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x3A], 'LD', 'D', 'SRL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x3B], 'LD', 'E', 'SRL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x3C], 'LD', 'H', 'SRL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x3D], 'LD', 'L', 'SRL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x3E], 'SRL', '(', 'IY+d', ')'),
    ([0xFDCB, 0x3F], 'LD', 'A', 'SRL ', '(', 'IY+d', ')'),
    ([0xFDCB, 0x40], 'BIT', '0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x41], 'BIT', '0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x42], 'BIT', '0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x43], 'BIT', '0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x44], 'BIT', '0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x45], 'BIT', '0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x46], 'BIT', '0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x47], 'BIT', '0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x48], 'BIT', '1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x49], 'BIT', '1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x4A], 'BIT', '1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x4B], 'BIT', '1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x4C], 'BIT', '1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x4D], 'BIT', '1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x4E], 'BIT', '1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x4F], 'BIT', '1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x50], 'BIT', '2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x51], 'BIT', '2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x52], 'BIT', '2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x53], 'BIT', '2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x54], 'BIT', '2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x55], 'BIT', '2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x56], 'BIT', '2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x57], 'BIT', '2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x58], 'BIT', '3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x59], 'BIT', '3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x5A], 'BIT', '3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x5B], 'BIT', '3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x5C], 'BIT', '3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x5D], 'BIT', '3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x5E], 'BIT', '3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x5F], 'BIT', '3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x60], 'BIT', '4', '(', 'IY+d', ')'),
    ([0xFDCB, 0x61], 'BIT', '4', '(', 'IY+d', ')'),
    ([0xFDCB, 0x62], 'BIT', '4', '(', 'IY+d', ')'),
    ([0xFDCB, 0x63], 'BIT', '4', '(', 'IY+d', ')'),
    ([0xFDCB, 0x64], 'BIT', '4', '(', 'IY+d', ')'),
    ([0xFDCB, 0x65], 'BIT', '4', '(', 'IY+d', ')'),
    ([0xFDCB, 0x66], 'BIT', '4', '(', 'IY+d', ')'),
    ([0xFDCB, 0x67], 'BIT', '4', '(', 'IY+d', ')'),
    ([0xFDCB, 0x68], 'BIT', '5', '(', 'IY+d', ')'),
    ([0xFDCB, 0x69], 'BIT', '5', '(', 'IY+d', ')'),
    ([0xFDCB, 0x6A], 'BIT', '5', '(', 'IY+d', ')'),
    ([0xFDCB, 0x6B], 'BIT', '5', '(', 'IY+d', ')'),
    ([0xFDCB, 0x6C], 'BIT', '5', '(', 'IY+d', ')'),
    ([0xFDCB, 0x6D], 'BIT', '5', '(', 'IY+d', ')'),
    ([0xFDCB, 0x6E], 'BIT', '5', '(', 'IY+d', ')'),
    ([0xFDCB, 0x6F], 'BIT', '5', '(', 'IY+d', ')'),
    ([0xFDCB, 0x70], 'BIT', '6', '(', 'IY+d', ')'),
    ([0xFDCB, 0x71], 'BIT', '6', '(', 'IY+d', ')'),
    ([0xFDCB, 0x72], 'BIT', '6', '(', 'IY+d', ')'),
    ([0xFDCB, 0x73], 'BIT', '6', '(', 'IY+d', ')'),
    ([0xFDCB, 0x74], 'BIT', '6', '(', 'IY+d', ')'),
    ([0xFDCB, 0x75], 'BIT', '6', '(', 'IY+d', ')'),
    ([0xFDCB, 0x76], 'BIT', '6', '(', 'IY+d', ')'),
    ([0xFDCB, 0x77], 'BIT', '6', '(', 'IY+d', ')'),
    ([0xFDCB, 0x78], 'BIT', '7', '(', 'IY+d', ')'),
    ([0xFDCB, 0x79], 'BIT', '7', '(', 'IY+d', ')'),
    ([0xFDCB, 0x7A], 'BIT', '7', '(', 'IY+d', ')'),
    ([0xFDCB, 0x7B], 'BIT', '7', '(', 'IY+d', ')'),
    ([0xFDCB, 0x7C], 'BIT', '7', '(', 'IY+d', ')'),
    ([0xFDCB, 0x7D], 'BIT', '7', '(', 'IY+d', ')'),
    ([0xFDCB, 0x7E], 'BIT', '7', '(', 'IY+d', ')'),
    ([0xFDCB, 0x7F], 'BIT', '7', '(', 'IY+d', ')'),
    ([0xFDCB, 0x80], 'LD', 'B', 'RES 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x81], 'LD', 'C', 'RES 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x82], 'LD', 'D', 'RES 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x83], 'LD', 'E', 'RES 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x84], 'LD', 'H', 'RES 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x85], 'LD', 'L', 'RES 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x86], 'RES', '0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x87], 'LD', 'A', 'RES 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0x88], 'LD', 'B', 'RES 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x89], 'LD', 'C', 'RES 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x8A], 'LD', 'D', 'RES 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x8B], 'LD', 'E', 'RES 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x8C], 'LD', 'H', 'RES 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x8D], 'LD', 'L', 'RES 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x8E], 'RES', '1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x8F], 'LD', 'A', 'RES 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0x90], 'LD', 'B', 'RES 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x91], 'LD', 'C', 'RES 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x92], 'LD', 'D', 'RES 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x93], 'LD', 'E', 'RES 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x94], 'LD', 'H', 'RES 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x95], 'LD', 'L', 'RES 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x96], 'RES', '2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x97], 'LD', 'A', 'RES 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0x98], 'LD', 'B', 'RES 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x99], 'LD', 'C', 'RES 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x9A], 'LD', 'D', 'RES 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x9B], 'LD', 'E', 'RES 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x9C], 'LD', 'H', 'RES 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x9D], 'LD', 'L', 'RES 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x9E], 'RES', '3', '(', 'IY+d', ')'),
    ([0xFDCB, 0x9F], 'LD', 'A', 'RES 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0xA0], 'LD', 'B', 'RES 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xA1], 'LD', 'C', 'RES 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xA2], 'LD', 'D', 'RES 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xA3], 'LD', 'E', 'RES 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xA4], 'LD', 'H', 'RES 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xA5], 'LD', 'L', 'RES 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xA6], 'RES', '4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xA7], 'LD', 'A', 'RES 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xA8], 'LD', 'B', 'RES 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xA9], 'LD', 'C', 'RES 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xAA], 'LD', 'D', 'RES 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xAB], 'LD', 'E', 'RES 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xAC], 'LD', 'H', 'RES 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xAD], 'LD', 'L', 'RES 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xAE], 'RES', '5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xAF], 'LD', 'A', 'RES 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xB0], 'LD', 'B', 'RES 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xB1], 'LD', 'C', 'RES 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xB2], 'LD', 'D', 'RES 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xB3], 'LD', 'E', 'RES 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xB4], 'LD', 'H', 'RES 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xB5], 'LD', 'L', 'RES 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xB6], 'RES', '6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xB7], 'LD', 'A', 'RES 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xB8], 'LD', 'B', 'RES 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xB9], 'LD', 'C', 'RES 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xBA], 'LD', 'D', 'RES 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xBB], 'LD', 'E', 'RES 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xBC], 'LD', 'H', 'RES 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xBD], 'LD', 'L', 'RES 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xBE], 'RES', '7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xBF], 'LD', 'A', 'RES 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xC0], 'LD', 'B', 'SET 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0xC1], 'LD', 'C', 'SET 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0xC2], 'LD', 'D', 'SET 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0xC3], 'LD', 'E', 'SET 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0xC4], 'LD', 'H', 'SET 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0xC5], 'LD', 'L', 'SET 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0xC6], 'SET', '0', '(', 'IY+d', ')'),
    ([0xFDCB, 0xC7], 'LD', 'A', 'SET 0', '(', 'IY+d', ')'),
    ([0xFDCB, 0xC8], 'LD', 'B', 'SET 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0xC9], 'LD', 'C', 'SET 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0xCA], 'LD', 'D', 'SET 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0xCB], 'LD', 'E', 'SET 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0xCC], 'LD', 'H', 'SET 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0xCD], 'LD', 'L', 'SET 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0xCE], 'SET', '1', '(', 'IY+d', ')'),
    ([0xFDCB, 0xCF], 'LD', 'A', 'SET 1', '(', 'IY+d', ')'),
    ([0xFDCB, 0xD0], 'LD', 'B', 'SET 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0xD1], 'LD', 'C', 'SET 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0xD2], 'LD', 'D', 'SET 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0xD3], 'LD', 'E', 'SET 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0xD4], 'LD', 'H', 'SET 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0xD5], 'LD', 'L', 'SET 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0xD6], 'SET', '2', '(', 'IY+d', ')'),
    ([0xFDCB, 0xD7], 'LD', 'A', 'SET 2', '(', 'IY+d', ')'),
    ([0xFDCB, 0xD8], 'LD', 'B', 'SET 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0xD9], 'LD', 'C', 'SET 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0xDA], 'LD', 'D', 'SET 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0xDB], 'LD', 'E', 'SET 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0xDC], 'LD', 'H', 'SET 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0xDD], 'LD', 'L', 'SET 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0xDE], 'SET', '3', '(', 'IY+d', ')'),
    ([0xFDCB, 0xDF], 'LD', 'A', 'SET 3', '(', 'IY+d', ')'),
    ([0xFDCB, 0xE0], 'LD', 'B', 'SET 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xE1], 'LD', 'C', 'SET 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xE2], 'LD', 'D', 'SET 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xE3], 'LD', 'E', 'SET 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xE4], 'LD', 'H', 'SET 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xE5], 'LD', 'L', 'SET 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xE6], 'SET', '4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xE7], 'LD', 'A', 'SET 4', '(', 'IY+d', ')'),
    ([0xFDCB, 0xE8], 'LD', 'B', 'SET 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xE9], 'LD', 'C', 'SET 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xEA], 'LD', 'D', 'SET 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xEB], 'LD', 'E', 'SET 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xEC], 'LD', 'H', 'SET 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xED], 'LD', 'L', 'SET 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xEE], 'SET', '5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xEF], 'LD', 'A', 'SET 5', '(', 'IY+d', ')'),
    ([0xFDCB, 0xF0], 'LD', 'B', 'SET 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xF1], 'LD', 'C', 'SET 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xF2], 'LD', 'D', 'SET 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xF3], 'LD', 'E', 'SET 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xF4], 'LD', 'H', 'SET 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xF5], 'LD', 'L', 'SET 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xF6], 'SET', '6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xF7], 'LD', 'A', 'SET 6', '(', 'IY+d', ')'),
    ([0xFDCB, 0xF8], 'LD', 'B', 'SET 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xF9], 'LD', 'C', 'SET 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xFA], 'LD', 'D', 'SET 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xFB], 'LD', 'E', 'SET 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xFC], 'LD', 'H', 'SET 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xFD], 'LD', 'L', 'SET 7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xFE], 'SET', '7', '(', 'IY+d', ')'),
    ([0xFDCB, 0xFF], 'LD', 'A', 'SET 7', '(', 'IY+d', ')'),
    ([0xFDE1], 'POP', 'IY'),
    ([0xFDE3], 'EX', '(', 'SP', ')', 'IY'),
    ([0xFDE5], 'PUSH', 'IY'),
    ([0xFDE9], 'JP', '(', 'IY', ')'),
    ([0xFDF9], 'LD', 'SP', 'IY'),
    ([0xFE], 'CP', 'n'),
    ([0xFF], 'RST', '38H')
)

REGS8 = ('A', 'B', 'C', 'D', 'E', 'F', 'H', 'L',
         'I', 'R', 'IXH', 'IXL', 'IYH', 'IYL')
REGS16 = ('AF', 'BC', 'DE', 'HL', 'PC', 'SP', 'IX', 'IY')


class Z80OpCode:

    def __init__(self, assembler, name, code, args):
        self.assembler = assembler
        self.name = name
        self.code = code
        self.variants = []
        self.add_variant(code, args)

    def _is_value(self, arg):
        return arg.upper() not in REGS8+REGS16

    def _is_index_x(self, arg):
        return (
            arg.upper().startswith('IX+') or
            arg.upper().startswith('IX-'))

    def _is_index_y(self, arg):
        return (
            arg.upper().startswith('IY+') or
            arg.upper().startswith('IY-'))

    def _build_nn(self, base, value):
        return pack_le16u(self.assembler.parse_integer_or_label(
            label=value,
            size=2,
            bits_size=16,
            offset=len(base)
        ))

    def _build_n(self, base, value):
        return pack_byte(self.assembler.parse_integer_or_label(
            label=value,
            size=1,
            bits_size=8,
            offset=len(base)
        ))

    def _build_e(self, base, value):
        return pack_8s(self.assembler.parse_integer_or_label(
            label=value,
            size=1,
            bits_size=8,
            offset=len(base),
            relative=self.assembler.pc + len(base) + 1
        ))

    def _build_d(self, base, value):
        return pack_8s(self.assembler.parse_integer_or_label(
            label=value,
            size=1,
            bits_size=8,
            offset=len(base),
            signed=True
        ))

    def _build_index(self, base, value):
        if value[2] == '+':
            arg = value[3:]
        elif value[2] == '-':
            arg = value[2:]
        return pack_8s(self.assembler.parse_integer_or_label(
            label=arg,
            size=1,
            bits_size=8,
            offset=len(base),
            signed=True
        ))

    def add_variant(self, code, args):
        sanitized_args = []
        hook = None
        for index, arg in enumerate(args):
            if arg == 'nn':
                sanitized_args.append(self._is_value)
                hook = self._build_nn, index
            elif arg == 'n':
                sanitized_args.append(self._is_value)
                hook = self._build_n, index
            elif arg == 'e':
                sanitized_args.append(self._is_value)
                hook = self._build_e, index
            elif arg == 'd':
                sanitized_args.append(self._is_value)
                hook = self._build_d, index
            elif arg in ('IX+d'):
                sanitized_args.append(self._is_index_x)
                hook = self._build_index, index
            elif arg in ('IY+d'):
                sanitized_args.append(self._is_index_y)
                hook = self._build_index, index
            else:
                sanitized_args.append(arg)

        self.variants.append((code, sanitized_args, hook))

    def __call__(self, instr):
        for variant in self.variants:
            if match(instr.tokens[1:], *variant[1]):
                code = variant[0][0]
                base = b''
                if code <= 0xFF:
                    base += pack_byte(code)
                else:
                    base += pack_byte(code >> 8)
                    base += pack_byte(code & 0xFF)
                if variant[2] is not None:
                    hook, index = variant[2]
                    base += hook(base, instr.tokens[index+1])
                for suffix in variant[0][1:]:
                    base += pack_byte(suffix)
                return base


class AssemblerZ80(Assembler):

    hex_prefixes = ('$',)
    bin_prefixes = ('%',)

    def register_instructions(self):
        for line in OPCODES_TABLE:
            name = line[1]
            if name.upper() in self.instructions:
                self.instructions[name.upper()].add_variant(line[0], line[2:])
            else:
                z80_opcode = Z80OpCode(self, name, line[0], line[2:])
                self.register_instruction(name, z80_opcode)


if __name__ == '__main__':
    AssemblerZ80().main()
